/*
 * Copyright (c) 2015, 2023, Oracle and/or its affiliates.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License, version 2.0, as published by the
 * Free Software Foundation.
 *
 * This program is also distributed with certain software (including but not
 * limited to OpenSSL) that is licensed under separate terms, as designated in a
 * particular file or component or in included license documentation. The
 * authors of MySQL hereby grant you an additional permission to link the
 * program and your derivative works with the separately licensed software that
 * they have included with MySQL.
 *
 * Without limiting anything contained in the foregoing, this file, which is
 * part of MySQL Connector/J, is also subject to the Universal FOSS Exception,
 * version 1.0, a copy of which can be found at
 * http://oss.oracle.com/licenses/universal-foss-exception.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License, version 2.0,
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA
 */

package com.mysql.cj.x.protobuf;

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: mysqlx_sql.proto

// Protobuf Java Version: 3.25.1

@SuppressWarnings({ "deprecation" })
public final class MysqlxSql {
  private MysqlxSql() {}
  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistryLite registry) {
  }

  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistry registry) {
    registerAllExtensions(
        (com.google.protobuf.ExtensionRegistryLite) registry);
  }
  public interface StmtExecuteOrBuilder extends
      // @@protoc_insertion_point(interface_extends:Mysqlx.Sql.StmtExecute)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     ** namespace of the statement to be executed 
     * </pre>
     *
     * <code>optional string namespace = 3 [default = "sql"];</code>
     * @return Whether the namespace field is set.
     */
    boolean hasNamespace();
    /**
     * <pre>
     ** namespace of the statement to be executed 
     * </pre>
     *
     * <code>optional string namespace = 3 [default = "sql"];</code>
     * @return The namespace.
     */
    java.lang.String getNamespace();
    /**
     * <pre>
     ** namespace of the statement to be executed 
     * </pre>
     *
     * <code>optional string namespace = 3 [default = "sql"];</code>
     * @return The bytes for namespace.
     */
    com.google.protobuf.ByteString
        getNamespaceBytes();

    /**
     * <pre>
     ** statement that shall be executed  
     * </pre>
     *
     * <code>required bytes stmt = 1;</code>
     * @return Whether the stmt field is set.
     */
    boolean hasStmt();
    /**
     * <pre>
     ** statement that shall be executed  
     * </pre>
     *
     * <code>required bytes stmt = 1;</code>
     * @return The stmt.
     */
    com.google.protobuf.ByteString getStmt();

    /**
     * <pre>
     ** values for wildcard replacements 
     * </pre>
     *
     * <code>repeated .Mysqlx.Datatypes.Any args = 2;</code>
     */
    java.util.List<com.mysql.cj.x.protobuf.MysqlxDatatypes.Any> 
        getArgsList();
    /**
     * <pre>
     ** values for wildcard replacements 
     * </pre>
     *
     * <code>repeated .Mysqlx.Datatypes.Any args = 2;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxDatatypes.Any getArgs(int index);
    /**
     * <pre>
     ** values for wildcard replacements 
     * </pre>
     *
     * <code>repeated .Mysqlx.Datatypes.Any args = 2;</code>
     */
    int getArgsCount();
    /**
     * <pre>
     ** values for wildcard replacements 
     * </pre>
     *
     * <code>repeated .Mysqlx.Datatypes.Any args = 2;</code>
     */
    java.util.List<? extends com.mysql.cj.x.protobuf.MysqlxDatatypes.AnyOrBuilder> 
        getArgsOrBuilderList();
    /**
     * <pre>
     ** values for wildcard replacements 
     * </pre>
     *
     * <code>repeated .Mysqlx.Datatypes.Any args = 2;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxDatatypes.AnyOrBuilder getArgsOrBuilder(
        int index);

    /**
     * <pre>
     ** send only type information for &#64;ref Mysqlx::Resultset::ColumnMetaData,
     *skipping names and others 
     * </pre>
     *
     * <code>optional bool compact_metadata = 4 [default = false];</code>
     * @return Whether the compactMetadata field is set.
     */
    boolean hasCompactMetadata();
    /**
     * <pre>
     ** send only type information for &#64;ref Mysqlx::Resultset::ColumnMetaData,
     *skipping names and others 
     * </pre>
     *
     * <code>optional bool compact_metadata = 4 [default = false];</code>
     * @return The compactMetadata.
     */
    boolean getCompactMetadata();
  }
  /**
   * <pre>
   *
   *Execute a statement in the given namespace.
   *
   *&#64;startuml "Execute Statements"
   *client -&gt; server: StmtExecute
   *... zero or more Resultsets ...
   *server --&gt; client: StmtExecuteOk
   *&#64;enduml
   *
   *&#64;notice This message may generate a notice containing WARNINGs generated by
   *its execution. This message may generate a  notice containing INFO messages
   *generated by its execution.
   *
   *&#64;returns zero or more  &#64;ref Mysqlx::Resultset followed by &#64;ref Mysqlx::Sql::StmtExecuteOk
   * </pre>
   *
   * Protobuf type {@code Mysqlx.Sql.StmtExecute}
   */
  public static final class StmtExecute extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:Mysqlx.Sql.StmtExecute)
      StmtExecuteOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use StmtExecute.newBuilder() to construct.
    private StmtExecute(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private StmtExecute() {
      namespace_ = "sql";
      stmt_ = com.google.protobuf.ByteString.EMPTY;
      args_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new StmtExecute();
    }

    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.mysql.cj.x.protobuf.MysqlxSql.internal_static_Mysqlx_Sql_StmtExecute_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.mysql.cj.x.protobuf.MysqlxSql.internal_static_Mysqlx_Sql_StmtExecute_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.mysql.cj.x.protobuf.MysqlxSql.StmtExecute.class, com.mysql.cj.x.protobuf.MysqlxSql.StmtExecute.Builder.class);
    }

    private int bitField0_;
    public static final int NAMESPACE_FIELD_NUMBER = 3;
    @SuppressWarnings("serial")
    private volatile java.lang.Object namespace_ = "sql";
    /**
     * <pre>
     ** namespace of the statement to be executed 
     * </pre>
     *
     * <code>optional string namespace = 3 [default = "sql"];</code>
     * @return Whether the namespace field is set.
     */
    @java.lang.Override
    public boolean hasNamespace() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <pre>
     ** namespace of the statement to be executed 
     * </pre>
     *
     * <code>optional string namespace = 3 [default = "sql"];</code>
     * @return The namespace.
     */
    @java.lang.Override
    public java.lang.String getNamespace() {
      java.lang.Object ref = namespace_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          namespace_ = s;
        }
        return s;
      }
    }
    /**
     * <pre>
     ** namespace of the statement to be executed 
     * </pre>
     *
     * <code>optional string namespace = 3 [default = "sql"];</code>
     * @return The bytes for namespace.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getNamespaceBytes() {
      java.lang.Object ref = namespace_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        namespace_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int STMT_FIELD_NUMBER = 1;
    private com.google.protobuf.ByteString stmt_ = com.google.protobuf.ByteString.EMPTY;
    /**
     * <pre>
     ** statement that shall be executed  
     * </pre>
     *
     * <code>required bytes stmt = 1;</code>
     * @return Whether the stmt field is set.
     */
    @java.lang.Override
    public boolean hasStmt() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     * <pre>
     ** statement that shall be executed  
     * </pre>
     *
     * <code>required bytes stmt = 1;</code>
     * @return The stmt.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getStmt() {
      return stmt_;
    }

    public static final int ARGS_FIELD_NUMBER = 2;
    @SuppressWarnings("serial")
    private java.util.List<com.mysql.cj.x.protobuf.MysqlxDatatypes.Any> args_;
    /**
     * <pre>
     ** values for wildcard replacements 
     * </pre>
     *
     * <code>repeated .Mysqlx.Datatypes.Any args = 2;</code>
     */
    @java.lang.Override
    public java.util.List<com.mysql.cj.x.protobuf.MysqlxDatatypes.Any> getArgsList() {
      return args_;
    }
    /**
     * <pre>
     ** values for wildcard replacements 
     * </pre>
     *
     * <code>repeated .Mysqlx.Datatypes.Any args = 2;</code>
     */
    @java.lang.Override
    public java.util.List<? extends com.mysql.cj.x.protobuf.MysqlxDatatypes.AnyOrBuilder> 
        getArgsOrBuilderList() {
      return args_;
    }
    /**
     * <pre>
     ** values for wildcard replacements 
     * </pre>
     *
     * <code>repeated .Mysqlx.Datatypes.Any args = 2;</code>
     */
    @java.lang.Override
    public int getArgsCount() {
      return args_.size();
    }
    /**
     * <pre>
     ** values for wildcard replacements 
     * </pre>
     *
     * <code>repeated .Mysqlx.Datatypes.Any args = 2;</code>
     */
    @java.lang.Override
    public com.mysql.cj.x.protobuf.MysqlxDatatypes.Any getArgs(int index) {
      return args_.get(index);
    }
    /**
     * <pre>
     ** values for wildcard replacements 
     * </pre>
     *
     * <code>repeated .Mysqlx.Datatypes.Any args = 2;</code>
     */
    @java.lang.Override
    public com.mysql.cj.x.protobuf.MysqlxDatatypes.AnyOrBuilder getArgsOrBuilder(
        int index) {
      return args_.get(index);
    }

    public static final int COMPACT_METADATA_FIELD_NUMBER = 4;
    private boolean compactMetadata_ = false;
    /**
     * <pre>
     ** send only type information for &#64;ref Mysqlx::Resultset::ColumnMetaData,
     *skipping names and others 
     * </pre>
     *
     * <code>optional bool compact_metadata = 4 [default = false];</code>
     * @return Whether the compactMetadata field is set.
     */
    @java.lang.Override
    public boolean hasCompactMetadata() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     * <pre>
     ** send only type information for &#64;ref Mysqlx::Resultset::ColumnMetaData,
     *skipping names and others 
     * </pre>
     *
     * <code>optional bool compact_metadata = 4 [default = false];</code>
     * @return The compactMetadata.
     */
    @java.lang.Override
    public boolean getCompactMetadata() {
      return compactMetadata_;
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!hasStmt()) {
        memoizedIsInitialized = 0;
        return false;
      }
      for (int i = 0; i < getArgsCount(); i++) {
        if (!getArgs(i).isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeBytes(1, stmt_);
      }
      for (int i = 0; i < args_.size(); i++) {
        output.writeMessage(2, args_.get(i));
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, namespace_);
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        output.writeBool(4, compactMetadata_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(1, stmt_);
      }
      for (int i = 0; i < args_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(2, args_.get(i));
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, namespace_);
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(4, compactMetadata_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof com.mysql.cj.x.protobuf.MysqlxSql.StmtExecute)) {
        return super.equals(obj);
      }
      com.mysql.cj.x.protobuf.MysqlxSql.StmtExecute other = (com.mysql.cj.x.protobuf.MysqlxSql.StmtExecute) obj;

      if (hasNamespace() != other.hasNamespace()) return false;
      if (hasNamespace()) {
        if (!getNamespace()
            .equals(other.getNamespace())) return false;
      }
      if (hasStmt() != other.hasStmt()) return false;
      if (hasStmt()) {
        if (!getStmt()
            .equals(other.getStmt())) return false;
      }
      if (!getArgsList()
          .equals(other.getArgsList())) return false;
      if (hasCompactMetadata() != other.hasCompactMetadata()) return false;
      if (hasCompactMetadata()) {
        if (getCompactMetadata()
            != other.getCompactMetadata()) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasNamespace()) {
        hash = (37 * hash) + NAMESPACE_FIELD_NUMBER;
        hash = (53 * hash) + getNamespace().hashCode();
      }
      if (hasStmt()) {
        hash = (37 * hash) + STMT_FIELD_NUMBER;
        hash = (53 * hash) + getStmt().hashCode();
      }
      if (getArgsCount() > 0) {
        hash = (37 * hash) + ARGS_FIELD_NUMBER;
        hash = (53 * hash) + getArgsList().hashCode();
      }
      if (hasCompactMetadata()) {
        hash = (37 * hash) + COMPACT_METADATA_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
            getCompactMetadata());
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.mysql.cj.x.protobuf.MysqlxSql.StmtExecute parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxSql.StmtExecute parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxSql.StmtExecute parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxSql.StmtExecute parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxSql.StmtExecute parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxSql.StmtExecute parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxSql.StmtExecute parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxSql.StmtExecute parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public static com.mysql.cj.x.protobuf.MysqlxSql.StmtExecute parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }

    public static com.mysql.cj.x.protobuf.MysqlxSql.StmtExecute parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxSql.StmtExecute parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxSql.StmtExecute parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(com.mysql.cj.x.protobuf.MysqlxSql.StmtExecute prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     *
     *Execute a statement in the given namespace.
     *
     *&#64;startuml "Execute Statements"
     *client -&gt; server: StmtExecute
     *... zero or more Resultsets ...
     *server --&gt; client: StmtExecuteOk
     *&#64;enduml
     *
     *&#64;notice This message may generate a notice containing WARNINGs generated by
     *its execution. This message may generate a  notice containing INFO messages
     *generated by its execution.
     *
     *&#64;returns zero or more  &#64;ref Mysqlx::Resultset followed by &#64;ref Mysqlx::Sql::StmtExecuteOk
     * </pre>
     *
     * Protobuf type {@code Mysqlx.Sql.StmtExecute}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:Mysqlx.Sql.StmtExecute)
        com.mysql.cj.x.protobuf.MysqlxSql.StmtExecuteOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.MysqlxSql.internal_static_Mysqlx_Sql_StmtExecute_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.mysql.cj.x.protobuf.MysqlxSql.internal_static_Mysqlx_Sql_StmtExecute_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.mysql.cj.x.protobuf.MysqlxSql.StmtExecute.class, com.mysql.cj.x.protobuf.MysqlxSql.StmtExecute.Builder.class);
      }

      // Construct using com.mysql.cj.x.protobuf.MysqlxSql.StmtExecute.newBuilder()
      private Builder() {

      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);

      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        namespace_ = "sql";
        stmt_ = com.google.protobuf.ByteString.EMPTY;
        if (argsBuilder_ == null) {
          args_ = java.util.Collections.emptyList();
        } else {
          args_ = null;
          argsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000004);
        compactMetadata_ = false;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.mysql.cj.x.protobuf.MysqlxSql.internal_static_Mysqlx_Sql_StmtExecute_descriptor;
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxSql.StmtExecute getDefaultInstanceForType() {
        return com.mysql.cj.x.protobuf.MysqlxSql.StmtExecute.getDefaultInstance();
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxSql.StmtExecute build() {
        com.mysql.cj.x.protobuf.MysqlxSql.StmtExecute result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxSql.StmtExecute buildPartial() {
        com.mysql.cj.x.protobuf.MysqlxSql.StmtExecute result = new com.mysql.cj.x.protobuf.MysqlxSql.StmtExecute(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) { buildPartial0(result); }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(com.mysql.cj.x.protobuf.MysqlxSql.StmtExecute result) {
        if (argsBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)) {
            args_ = java.util.Collections.unmodifiableList(args_);
            bitField0_ = (bitField0_ & ~0x00000004);
          }
          result.args_ = args_;
        } else {
          result.args_ = argsBuilder_.build();
        }
      }

      private void buildPartial0(com.mysql.cj.x.protobuf.MysqlxSql.StmtExecute result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.namespace_ = namespace_;
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.stmt_ = stmt_;
          to_bitField0_ |= 0x00000002;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.compactMetadata_ = compactMetadata_;
          to_bitField0_ |= 0x00000004;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.mysql.cj.x.protobuf.MysqlxSql.StmtExecute) {
          return mergeFrom((com.mysql.cj.x.protobuf.MysqlxSql.StmtExecute)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.mysql.cj.x.protobuf.MysqlxSql.StmtExecute other) {
        if (other == com.mysql.cj.x.protobuf.MysqlxSql.StmtExecute.getDefaultInstance()) return this;
        if (other.hasNamespace()) {
          namespace_ = other.namespace_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.hasStmt()) {
          setStmt(other.getStmt());
        }
        if (argsBuilder_ == null) {
          if (!other.args_.isEmpty()) {
            if (args_.isEmpty()) {
              args_ = other.args_;
              bitField0_ = (bitField0_ & ~0x00000004);
            } else {
              ensureArgsIsMutable();
              args_.addAll(other.args_);
            }
            onChanged();
          }
        } else {
          if (!other.args_.isEmpty()) {
            if (argsBuilder_.isEmpty()) {
              argsBuilder_.dispose();
              argsBuilder_ = null;
              args_ = other.args_;
              bitField0_ = (bitField0_ & ~0x00000004);
              argsBuilder_ = 
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                   getArgsFieldBuilder() : null;
            } else {
              argsBuilder_.addAllMessages(other.args_);
            }
          }
        }
        if (other.hasCompactMetadata()) {
          setCompactMetadata(other.getCompactMetadata());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        if (!hasStmt()) {
          return false;
        }
        for (int i = 0; i < getArgsCount(); i++) {
          if (!getArgs(i).isInitialized()) {
            return false;
          }
        }
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                stmt_ = input.readBytes();
                bitField0_ |= 0x00000002;
                break;
              } // case 10
              case 18: {
                com.mysql.cj.x.protobuf.MysqlxDatatypes.Any m =
                    input.readMessage(
                        com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.PARSER,
                        extensionRegistry);
                if (argsBuilder_ == null) {
                  ensureArgsIsMutable();
                  args_.add(m);
                } else {
                  argsBuilder_.addMessage(m);
                }
                break;
              } // case 18
              case 26: {
                namespace_ = input.readBytes();
                bitField0_ |= 0x00000001;
                break;
              } // case 26
              case 32: {
                compactMetadata_ = input.readBool();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private java.lang.Object namespace_ = "sql";
      /**
       * <pre>
       ** namespace of the statement to be executed 
       * </pre>
       *
       * <code>optional string namespace = 3 [default = "sql"];</code>
       * @return Whether the namespace field is set.
       */
      public boolean hasNamespace() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <pre>
       ** namespace of the statement to be executed 
       * </pre>
       *
       * <code>optional string namespace = 3 [default = "sql"];</code>
       * @return The namespace.
       */
      public java.lang.String getNamespace() {
        java.lang.Object ref = namespace_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            namespace_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       ** namespace of the statement to be executed 
       * </pre>
       *
       * <code>optional string namespace = 3 [default = "sql"];</code>
       * @return The bytes for namespace.
       */
      public com.google.protobuf.ByteString
          getNamespaceBytes() {
        java.lang.Object ref = namespace_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          namespace_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       ** namespace of the statement to be executed 
       * </pre>
       *
       * <code>optional string namespace = 3 [default = "sql"];</code>
       * @param value The namespace to set.
       * @return This builder for chaining.
       */
      public Builder setNamespace(
          java.lang.String value) {
        if (value == null) { throw new NullPointerException(); }
        namespace_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       * <pre>
       ** namespace of the statement to be executed 
       * </pre>
       *
       * <code>optional string namespace = 3 [default = "sql"];</code>
       * @return This builder for chaining.
       */
      public Builder clearNamespace() {
        namespace_ = getDefaultInstance().getNamespace();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       * <pre>
       ** namespace of the statement to be executed 
       * </pre>
       *
       * <code>optional string namespace = 3 [default = "sql"];</code>
       * @param value The bytes for namespace to set.
       * @return This builder for chaining.
       */
      public Builder setNamespaceBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) { throw new NullPointerException(); }
        namespace_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private com.google.protobuf.ByteString stmt_ = com.google.protobuf.ByteString.EMPTY;
      /**
       * <pre>
       ** statement that shall be executed  
       * </pre>
       *
       * <code>required bytes stmt = 1;</code>
       * @return Whether the stmt field is set.
       */
      @java.lang.Override
      public boolean hasStmt() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       * <pre>
       ** statement that shall be executed  
       * </pre>
       *
       * <code>required bytes stmt = 1;</code>
       * @return The stmt.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getStmt() {
        return stmt_;
      }
      /**
       * <pre>
       ** statement that shall be executed  
       * </pre>
       *
       * <code>required bytes stmt = 1;</code>
       * @param value The stmt to set.
       * @return This builder for chaining.
       */
      public Builder setStmt(com.google.protobuf.ByteString value) {
        if (value == null) { throw new NullPointerException(); }
        stmt_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       * <pre>
       ** statement that shall be executed  
       * </pre>
       *
       * <code>required bytes stmt = 1;</code>
       * @return This builder for chaining.
       */
      public Builder clearStmt() {
        bitField0_ = (bitField0_ & ~0x00000002);
        stmt_ = getDefaultInstance().getStmt();
        onChanged();
        return this;
      }

      private java.util.List<com.mysql.cj.x.protobuf.MysqlxDatatypes.Any> args_ =
        java.util.Collections.emptyList();
      private void ensureArgsIsMutable() {
        if (!((bitField0_ & 0x00000004) != 0)) {
          args_ = new java.util.ArrayList<com.mysql.cj.x.protobuf.MysqlxDatatypes.Any>(args_);
          bitField0_ |= 0x00000004;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
          com.mysql.cj.x.protobuf.MysqlxDatatypes.Any, com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.Builder, com.mysql.cj.x.protobuf.MysqlxDatatypes.AnyOrBuilder> argsBuilder_;

      /**
       * <pre>
       ** values for wildcard replacements 
       * </pre>
       *
       * <code>repeated .Mysqlx.Datatypes.Any args = 2;</code>
       */
      public java.util.List<com.mysql.cj.x.protobuf.MysqlxDatatypes.Any> getArgsList() {
        if (argsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(args_);
        } else {
          return argsBuilder_.getMessageList();
        }
      }
      /**
       * <pre>
       ** values for wildcard replacements 
       * </pre>
       *
       * <code>repeated .Mysqlx.Datatypes.Any args = 2;</code>
       */
      public int getArgsCount() {
        if (argsBuilder_ == null) {
          return args_.size();
        } else {
          return argsBuilder_.getCount();
        }
      }
      /**
       * <pre>
       ** values for wildcard replacements 
       * </pre>
       *
       * <code>repeated .Mysqlx.Datatypes.Any args = 2;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Any getArgs(int index) {
        if (argsBuilder_ == null) {
          return args_.get(index);
        } else {
          return argsBuilder_.getMessage(index);
        }
      }
      /**
       * <pre>
       ** values for wildcard replacements 
       * </pre>
       *
       * <code>repeated .Mysqlx.Datatypes.Any args = 2;</code>
       */
      public Builder setArgs(
          int index, com.mysql.cj.x.protobuf.MysqlxDatatypes.Any value) {
        if (argsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureArgsIsMutable();
          args_.set(index, value);
          onChanged();
        } else {
          argsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       ** values for wildcard replacements 
       * </pre>
       *
       * <code>repeated .Mysqlx.Datatypes.Any args = 2;</code>
       */
      public Builder setArgs(
          int index, com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.Builder builderForValue) {
        if (argsBuilder_ == null) {
          ensureArgsIsMutable();
          args_.set(index, builderForValue.build());
          onChanged();
        } else {
          argsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       ** values for wildcard replacements 
       * </pre>
       *
       * <code>repeated .Mysqlx.Datatypes.Any args = 2;</code>
       */
      public Builder addArgs(com.mysql.cj.x.protobuf.MysqlxDatatypes.Any value) {
        if (argsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureArgsIsMutable();
          args_.add(value);
          onChanged();
        } else {
          argsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <pre>
       ** values for wildcard replacements 
       * </pre>
       *
       * <code>repeated .Mysqlx.Datatypes.Any args = 2;</code>
       */
      public Builder addArgs(
          int index, com.mysql.cj.x.protobuf.MysqlxDatatypes.Any value) {
        if (argsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureArgsIsMutable();
          args_.add(index, value);
          onChanged();
        } else {
          argsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       ** values for wildcard replacements 
       * </pre>
       *
       * <code>repeated .Mysqlx.Datatypes.Any args = 2;</code>
       */
      public Builder addArgs(
          com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.Builder builderForValue) {
        if (argsBuilder_ == null) {
          ensureArgsIsMutable();
          args_.add(builderForValue.build());
          onChanged();
        } else {
          argsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       ** values for wildcard replacements 
       * </pre>
       *
       * <code>repeated .Mysqlx.Datatypes.Any args = 2;</code>
       */
      public Builder addArgs(
          int index, com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.Builder builderForValue) {
        if (argsBuilder_ == null) {
          ensureArgsIsMutable();
          args_.add(index, builderForValue.build());
          onChanged();
        } else {
          argsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       ** values for wildcard replacements 
       * </pre>
       *
       * <code>repeated .Mysqlx.Datatypes.Any args = 2;</code>
       */
      public Builder addAllArgs(
          java.lang.Iterable<? extends com.mysql.cj.x.protobuf.MysqlxDatatypes.Any> values) {
        if (argsBuilder_ == null) {
          ensureArgsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, args_);
          onChanged();
        } else {
          argsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <pre>
       ** values for wildcard replacements 
       * </pre>
       *
       * <code>repeated .Mysqlx.Datatypes.Any args = 2;</code>
       */
      public Builder clearArgs() {
        if (argsBuilder_ == null) {
          args_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000004);
          onChanged();
        } else {
          argsBuilder_.clear();
        }
        return this;
      }
      /**
       * <pre>
       ** values for wildcard replacements 
       * </pre>
       *
       * <code>repeated .Mysqlx.Datatypes.Any args = 2;</code>
       */
      public Builder removeArgs(int index) {
        if (argsBuilder_ == null) {
          ensureArgsIsMutable();
          args_.remove(index);
          onChanged();
        } else {
          argsBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <pre>
       ** values for wildcard replacements 
       * </pre>
       *
       * <code>repeated .Mysqlx.Datatypes.Any args = 2;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.Builder getArgsBuilder(
          int index) {
        return getArgsFieldBuilder().getBuilder(index);
      }
      /**
       * <pre>
       ** values for wildcard replacements 
       * </pre>
       *
       * <code>repeated .Mysqlx.Datatypes.Any args = 2;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.AnyOrBuilder getArgsOrBuilder(
          int index) {
        if (argsBuilder_ == null) {
          return args_.get(index);  } else {
          return argsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <pre>
       ** values for wildcard replacements 
       * </pre>
       *
       * <code>repeated .Mysqlx.Datatypes.Any args = 2;</code>
       */
      public java.util.List<? extends com.mysql.cj.x.protobuf.MysqlxDatatypes.AnyOrBuilder> 
           getArgsOrBuilderList() {
        if (argsBuilder_ != null) {
          return argsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(args_);
        }
      }
      /**
       * <pre>
       ** values for wildcard replacements 
       * </pre>
       *
       * <code>repeated .Mysqlx.Datatypes.Any args = 2;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.Builder addArgsBuilder() {
        return getArgsFieldBuilder().addBuilder(
            com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.getDefaultInstance());
      }
      /**
       * <pre>
       ** values for wildcard replacements 
       * </pre>
       *
       * <code>repeated .Mysqlx.Datatypes.Any args = 2;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.Builder addArgsBuilder(
          int index) {
        return getArgsFieldBuilder().addBuilder(
            index, com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.getDefaultInstance());
      }
      /**
       * <pre>
       ** values for wildcard replacements 
       * </pre>
       *
       * <code>repeated .Mysqlx.Datatypes.Any args = 2;</code>
       */
      public java.util.List<com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.Builder> 
           getArgsBuilderList() {
        return getArgsFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilderV3<
          com.mysql.cj.x.protobuf.MysqlxDatatypes.Any, com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.Builder, com.mysql.cj.x.protobuf.MysqlxDatatypes.AnyOrBuilder> 
          getArgsFieldBuilder() {
        if (argsBuilder_ == null) {
          argsBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
              com.mysql.cj.x.protobuf.MysqlxDatatypes.Any, com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.Builder, com.mysql.cj.x.protobuf.MysqlxDatatypes.AnyOrBuilder>(
                  args_,
                  ((bitField0_ & 0x00000004) != 0),
                  getParentForChildren(),
                  isClean());
          args_ = null;
        }
        return argsBuilder_;
      }

      private boolean compactMetadata_ ;
      /**
       * <pre>
       ** send only type information for &#64;ref Mysqlx::Resultset::ColumnMetaData,
       *skipping names and others 
       * </pre>
       *
       * <code>optional bool compact_metadata = 4 [default = false];</code>
       * @return Whether the compactMetadata field is set.
       */
      @java.lang.Override
      public boolean hasCompactMetadata() {
        return ((bitField0_ & 0x00000008) != 0);
      }
      /**
       * <pre>
       ** send only type information for &#64;ref Mysqlx::Resultset::ColumnMetaData,
       *skipping names and others 
       * </pre>
       *
       * <code>optional bool compact_metadata = 4 [default = false];</code>
       * @return The compactMetadata.
       */
      @java.lang.Override
      public boolean getCompactMetadata() {
        return compactMetadata_;
      }
      /**
       * <pre>
       ** send only type information for &#64;ref Mysqlx::Resultset::ColumnMetaData,
       *skipping names and others 
       * </pre>
       *
       * <code>optional bool compact_metadata = 4 [default = false];</code>
       * @param value The compactMetadata to set.
       * @return This builder for chaining.
       */
      public Builder setCompactMetadata(boolean value) {

        compactMetadata_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       * <pre>
       ** send only type information for &#64;ref Mysqlx::Resultset::ColumnMetaData,
       *skipping names and others 
       * </pre>
       *
       * <code>optional bool compact_metadata = 4 [default = false];</code>
       * @return This builder for chaining.
       */
      public Builder clearCompactMetadata() {
        bitField0_ = (bitField0_ & ~0x00000008);
        compactMetadata_ = false;
        onChanged();
        return this;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:Mysqlx.Sql.StmtExecute)
    }

    // @@protoc_insertion_point(class_scope:Mysqlx.Sql.StmtExecute)
    private static final com.mysql.cj.x.protobuf.MysqlxSql.StmtExecute DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new com.mysql.cj.x.protobuf.MysqlxSql.StmtExecute();
    }

    public static com.mysql.cj.x.protobuf.MysqlxSql.StmtExecute getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated public static final com.google.protobuf.Parser<StmtExecute>
        PARSER = new com.google.protobuf.AbstractParser<StmtExecute>() {
      @java.lang.Override
      public StmtExecute parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<StmtExecute> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<StmtExecute> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.mysql.cj.x.protobuf.MysqlxSql.StmtExecute getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface StmtExecuteOkOrBuilder extends
      // @@protoc_insertion_point(interface_extends:Mysqlx.Sql.StmtExecuteOk)
      com.google.protobuf.MessageOrBuilder {
  }
  /**
   * <pre>
   **
   *Statement executed successfully
   * </pre>
   *
   * Protobuf type {@code Mysqlx.Sql.StmtExecuteOk}
   */
  public static final class StmtExecuteOk extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:Mysqlx.Sql.StmtExecuteOk)
      StmtExecuteOkOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use StmtExecuteOk.newBuilder() to construct.
    private StmtExecuteOk(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private StmtExecuteOk() {
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new StmtExecuteOk();
    }

    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.mysql.cj.x.protobuf.MysqlxSql.internal_static_Mysqlx_Sql_StmtExecuteOk_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.mysql.cj.x.protobuf.MysqlxSql.internal_static_Mysqlx_Sql_StmtExecuteOk_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.mysql.cj.x.protobuf.MysqlxSql.StmtExecuteOk.class, com.mysql.cj.x.protobuf.MysqlxSql.StmtExecuteOk.Builder.class);
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof com.mysql.cj.x.protobuf.MysqlxSql.StmtExecuteOk)) {
        return super.equals(obj);
      }
      com.mysql.cj.x.protobuf.MysqlxSql.StmtExecuteOk other = (com.mysql.cj.x.protobuf.MysqlxSql.StmtExecuteOk) obj;

      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.mysql.cj.x.protobuf.MysqlxSql.StmtExecuteOk parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxSql.StmtExecuteOk parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxSql.StmtExecuteOk parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxSql.StmtExecuteOk parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxSql.StmtExecuteOk parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxSql.StmtExecuteOk parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxSql.StmtExecuteOk parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxSql.StmtExecuteOk parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public static com.mysql.cj.x.protobuf.MysqlxSql.StmtExecuteOk parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }

    public static com.mysql.cj.x.protobuf.MysqlxSql.StmtExecuteOk parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxSql.StmtExecuteOk parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxSql.StmtExecuteOk parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(com.mysql.cj.x.protobuf.MysqlxSql.StmtExecuteOk prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     **
     *Statement executed successfully
     * </pre>
     *
     * Protobuf type {@code Mysqlx.Sql.StmtExecuteOk}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:Mysqlx.Sql.StmtExecuteOk)
        com.mysql.cj.x.protobuf.MysqlxSql.StmtExecuteOkOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.MysqlxSql.internal_static_Mysqlx_Sql_StmtExecuteOk_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.mysql.cj.x.protobuf.MysqlxSql.internal_static_Mysqlx_Sql_StmtExecuteOk_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.mysql.cj.x.protobuf.MysqlxSql.StmtExecuteOk.class, com.mysql.cj.x.protobuf.MysqlxSql.StmtExecuteOk.Builder.class);
      }

      // Construct using com.mysql.cj.x.protobuf.MysqlxSql.StmtExecuteOk.newBuilder()
      private Builder() {

      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);

      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.mysql.cj.x.protobuf.MysqlxSql.internal_static_Mysqlx_Sql_StmtExecuteOk_descriptor;
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxSql.StmtExecuteOk getDefaultInstanceForType() {
        return com.mysql.cj.x.protobuf.MysqlxSql.StmtExecuteOk.getDefaultInstance();
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxSql.StmtExecuteOk build() {
        com.mysql.cj.x.protobuf.MysqlxSql.StmtExecuteOk result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxSql.StmtExecuteOk buildPartial() {
        com.mysql.cj.x.protobuf.MysqlxSql.StmtExecuteOk result = new com.mysql.cj.x.protobuf.MysqlxSql.StmtExecuteOk(this);
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.mysql.cj.x.protobuf.MysqlxSql.StmtExecuteOk) {
          return mergeFrom((com.mysql.cj.x.protobuf.MysqlxSql.StmtExecuteOk)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.mysql.cj.x.protobuf.MysqlxSql.StmtExecuteOk other) {
        if (other == com.mysql.cj.x.protobuf.MysqlxSql.StmtExecuteOk.getDefaultInstance()) return this;
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:Mysqlx.Sql.StmtExecuteOk)
    }

    // @@protoc_insertion_point(class_scope:Mysqlx.Sql.StmtExecuteOk)
    private static final com.mysql.cj.x.protobuf.MysqlxSql.StmtExecuteOk DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new com.mysql.cj.x.protobuf.MysqlxSql.StmtExecuteOk();
    }

    public static com.mysql.cj.x.protobuf.MysqlxSql.StmtExecuteOk getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated public static final com.google.protobuf.Parser<StmtExecuteOk>
        PARSER = new com.google.protobuf.AbstractParser<StmtExecuteOk>() {
      @java.lang.Override
      public StmtExecuteOk parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<StmtExecuteOk> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<StmtExecuteOk> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.mysql.cj.x.protobuf.MysqlxSql.StmtExecuteOk getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_Mysqlx_Sql_StmtExecute_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_Mysqlx_Sql_StmtExecute_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_Mysqlx_Sql_StmtExecuteOk_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_Mysqlx_Sql_StmtExecuteOk_fieldAccessorTable;

  public static com.google.protobuf.Descriptors.FileDescriptor
      getDescriptor() {
    return descriptor;
  }
  private static  com.google.protobuf.Descriptors.FileDescriptor
      descriptor;
  static {
    java.lang.String[] descriptorData = {
      "\n\020mysqlx_sql.proto\022\nMysqlx.Sql\032\014mysqlx.p" +
      "roto\032\026mysqlx_datatypes.proto\"\177\n\013StmtExec" +
      "ute\022\026\n\tnamespace\030\003 \001(\t:\003sql\022\014\n\004stmt\030\001 \002(" +
      "\014\022#\n\004args\030\002 \003(\0132\025.Mysqlx.Datatypes.Any\022\037" +
      "\n\020compact_metadata\030\004 \001(\010:\005false:\004\210\3520\014\"\025\n" +
      "\rStmtExecuteOk:\004\220\3520\021B\031\n\027com.mysql.cj.x.p" +
      "rotobuf"
    };
    descriptor = com.google.protobuf.Descriptors.FileDescriptor
      .internalBuildGeneratedFileFrom(descriptorData,
        new com.google.protobuf.Descriptors.FileDescriptor[] {
          com.mysql.cj.x.protobuf.Mysqlx.getDescriptor(),
          com.mysql.cj.x.protobuf.MysqlxDatatypes.getDescriptor(),
        });
    internal_static_Mysqlx_Sql_StmtExecute_descriptor =
      getDescriptor().getMessageTypes().get(0);
    internal_static_Mysqlx_Sql_StmtExecute_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_Mysqlx_Sql_StmtExecute_descriptor,
        new java.lang.String[] { "Namespace", "Stmt", "Args", "CompactMetadata", });
    internal_static_Mysqlx_Sql_StmtExecuteOk_descriptor =
      getDescriptor().getMessageTypes().get(1);
    internal_static_Mysqlx_Sql_StmtExecuteOk_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_Mysqlx_Sql_StmtExecuteOk_descriptor,
        new java.lang.String[] { });
    com.google.protobuf.ExtensionRegistry registry =
        com.google.protobuf.ExtensionRegistry.newInstance();
    registry.add(com.mysql.cj.x.protobuf.Mysqlx.clientMessageId);
    registry.add(com.mysql.cj.x.protobuf.Mysqlx.serverMessageId);
    com.google.protobuf.Descriptors.FileDescriptor
        .internalUpdateFileDescriptor(descriptor, registry);
    com.mysql.cj.x.protobuf.Mysqlx.getDescriptor();
    com.mysql.cj.x.protobuf.MysqlxDatatypes.getDescriptor();
  }

  // @@protoc_insertion_point(outer_class_scope)
}
