# Ds in Js

Ds in Js is a repository that contains implementations of various basic data structures and algorithms in JavaScript. Whether you are a beginner looking to learn about data structures and algorithms or an experienced developer looking for a quick reference, this repository has you covered.

## Table of Contents

- [Introduction](#introduction)
- [Data Structures](#data-structures)
  - [Linked List](#linked-list)
  - [String](#string)
  - [Binary Search Tree](#binary-search-tree)
  - [Graph](#graph)
  - [Hash Table](#hash-table)
  - [Heap](#heap)
  - [Stack](#stack)
  - [Queue](#queue)
  - [Trie](#trie)
- [Algorithms](#algorithms)
  - [Recursion](#recursion)
  - [Selection Sort](#selection-sort)
  - [Insertion Sort](#insertion-sort)
  - [Bubble Sort](#bubble-sort)
  - [Merge Sort](#merge-sort)
  - [Quick Sort](#quick-sort)
- [Getting Started](#getting-started)
- [Contributing](#contributing)
- [License](#license)

## Introduction

Understanding data structures and algorithms is fundamental for any programmer. This repository aims to provide clear and concise implementations of various data structures and algorithms in JavaScript. Each data structure and algorithm is implemented in its own individual file, making it easy to find and use the code.

## Data Structures

### Linked List

A basic singly linked list implementation.

### String

Basic string manipulation functions.

### Binary Search Tree

A binary search tree data structure and relevant operations.

### Graph

A graph data structure and common graph algorithms.

### Hash Table

A hash table (hash map) implementation.

### Heap

A binary heap data structure and common heap operations.

### Stack

A stack data structure.

### Queue

A queue data structure (implemented using arrays and linked lists).

### Trie

A trie data structure for efficient string searching.

## Algorithms

### Recursion

Examples of recursive algorithms and functions.

### Selection Sort

An implementation of the selection sort algorithm.

### Insertion Sort

An implementation of the insertion sort algorithm.

### Bubble Sort

An implementation of the bubble sort algorithm.

### Merge Sort

An implementation of the merge sort algorithm.

### Quick Sort

An implementation of the quick sort algorithm.
