class HashTable {

  constructor(size) {

    this.table = new Array(size);

    this.size = size;

  }

  hash(key) {

    let total = 0;

    for (let i = 0; i < key.length; i++) {

      total = total + key.charCodeAt(i);

    }

    return total % this.size;
  }


  set(key, value) {

    const index = this.hash(key);

    const bucket = this.table[index];

    if (!bucket) {

      this.table[index] = [[key, value]];

    } else {

      const sameKeyItem = bucket.find((item) => item[0] === key);

      if (sameKeyItem) {

        sameKeyItem[1] = value;

      } else {

        bucket.push([key, value]);

      }

    }

  }


  get(key) {

    const index = this.hash(key);

    const bucket = this.table[index];

    if (bucket) {

      const sameKeyItem = bucket.find((item) => item[0] === key);

      if (sameKeyItem) {
        
        return sameKeyItem[1];

      }

    }

    return undefined;

  }


  remove(key) {

    let index = this.hash(key);

    const bucket = this.table[index];

    if (bucket) {

      const sameKeyItem = bucket.find((item) => item[0] === key);

      if (sameKeyItem) {

        bucket.splice(bucket.indexOf(sameKeyItem), 1);

      }

    }

  }


  display() {

    for (let i = 0; i < this.table.length; i++) {

      if (this.table[i]) {

        console.log(i, this.table[i]);

      }

    }
    
  }


}


// =================TEST CASES=================


const table = new HashTable(10);

table.set("1",24);

table.display();

console.log(table.get("1"));

table.set("KEY", "Value");

console.log(table.get("KEY"));

table.display();

table.remove("1");

table.remove("KEY");

table.display();