
(function(l, r) { if (l.getElementById('livereloadscript')) return; r = l.createElement('script'); r.async = 1; r.src = '//' + (window.location.host || 'localhost').split(':')[0] + ':35729/livereload.js?snipver=1'; r.id = 'livereloadscript'; l.getElementsByTagName('head')[0].appendChild(r) })(window.document);
var app = (function () {
    'use strict';

    function noop() { }
    const identity = x => x;
    function assign(tar, src) {
        // @ts-ignore
        for (const k in src)
            tar[k] = src[k];
        return tar;
    }
    function add_location(element, file, line, column, char) {
        element.__svelte_meta = {
            loc: { file, line, column, char }
        };
    }
    function run(fn) {
        return fn();
    }
    function blank_object() {
        return Object.create(null);
    }
    function run_all(fns) {
        fns.forEach(run);
    }
    function is_function(thing) {
        return typeof thing === 'function';
    }
    function safe_not_equal(a, b) {
        return a != a ? b == b : a !== b || ((a && typeof a === 'object') || typeof a === 'function');
    }
    function is_empty(obj) {
        return Object.keys(obj).length === 0;
    }
    function validate_store(store, name) {
        if (store != null && typeof store.subscribe !== 'function') {
            throw new Error(`'${name}' is not a store with a 'subscribe' method`);
        }
    }
    function subscribe$1(store, ...callbacks) {
        if (store == null) {
            return noop;
        }
        const unsub = store.subscribe(...callbacks);
        return unsub.unsubscribe ? () => unsub.unsubscribe() : unsub;
    }
    function component_subscribe(component, store, callback) {
        component.$$.on_destroy.push(subscribe$1(store, callback));
    }
    function create_slot(definition, ctx, $$scope, fn) {
        if (definition) {
            const slot_ctx = get_slot_context(definition, ctx, $$scope, fn);
            return definition[0](slot_ctx);
        }
    }
    function get_slot_context(definition, ctx, $$scope, fn) {
        return definition[1] && fn
            ? assign($$scope.ctx.slice(), definition[1](fn(ctx)))
            : $$scope.ctx;
    }
    function get_slot_changes(definition, $$scope, dirty, fn) {
        if (definition[2] && fn) {
            const lets = definition[2](fn(dirty));
            if ($$scope.dirty === undefined) {
                return lets;
            }
            if (typeof lets === 'object') {
                const merged = [];
                const len = Math.max($$scope.dirty.length, lets.length);
                for (let i = 0; i < len; i += 1) {
                    merged[i] = $$scope.dirty[i] | lets[i];
                }
                return merged;
            }
            return $$scope.dirty | lets;
        }
        return $$scope.dirty;
    }
    function update_slot(slot, slot_definition, ctx, $$scope, dirty, get_slot_changes_fn, get_slot_context_fn) {
        const slot_changes = get_slot_changes(slot_definition, $$scope, dirty, get_slot_changes_fn);
        if (slot_changes) {
            const slot_context = get_slot_context(slot_definition, ctx, $$scope, get_slot_context_fn);
            slot.p(slot_context, slot_changes);
        }
    }
    function exclude_internal_props(props) {
        const result = {};
        for (const k in props)
            if (k[0] !== '$')
                result[k] = props[k];
        return result;
    }
    function action_destroyer(action_result) {
        return action_result && is_function(action_result.destroy) ? action_result.destroy : noop;
    }

    const is_client = typeof window !== 'undefined';
    let now = is_client
        ? () => window.performance.now()
        : () => Date.now();
    let raf = is_client ? cb => requestAnimationFrame(cb) : noop;

    const tasks = new Set();
    function run_tasks(now) {
        tasks.forEach(task => {
            if (!task.c(now)) {
                tasks.delete(task);
                task.f();
            }
        });
        if (tasks.size !== 0)
            raf(run_tasks);
    }
    /**
     * Creates a new task that runs on each raf frame
     * until it returns a falsy value or is aborted
     */
    function loop(callback) {
        let task;
        if (tasks.size === 0)
            raf(run_tasks);
        return {
            promise: new Promise(fulfill => {
                tasks.add(task = { c: callback, f: fulfill });
            }),
            abort() {
                tasks.delete(task);
            }
        };
    }

    function append(target, node) {
        target.appendChild(node);
    }
    function insert(target, node, anchor) {
        target.insertBefore(node, anchor || null);
    }
    function detach(node) {
        node.parentNode.removeChild(node);
    }
    function destroy_each(iterations, detaching) {
        for (let i = 0; i < iterations.length; i += 1) {
            if (iterations[i])
                iterations[i].d(detaching);
        }
    }
    function element(name) {
        return document.createElement(name);
    }
    function svg_element(name) {
        return document.createElementNS('http://www.w3.org/2000/svg', name);
    }
    function text(data) {
        return document.createTextNode(data);
    }
    function space() {
        return text(' ');
    }
    function empty() {
        return text('');
    }
    function listen(node, event, handler, options) {
        node.addEventListener(event, handler, options);
        return () => node.removeEventListener(event, handler, options);
    }
    function attr(node, attribute, value) {
        if (value == null)
            node.removeAttribute(attribute);
        else if (node.getAttribute(attribute) !== value)
            node.setAttribute(attribute, value);
    }
    function set_attributes(node, attributes) {
        // @ts-ignore
        const descriptors = Object.getOwnPropertyDescriptors(node.__proto__);
        for (const key in attributes) {
            if (attributes[key] == null) {
                node.removeAttribute(key);
            }
            else if (key === 'style') {
                node.style.cssText = attributes[key];
            }
            else if (key === '__value') {
                node.value = node[key] = attributes[key];
            }
            else if (descriptors[key] && descriptors[key].set) {
                node[key] = attributes[key];
            }
            else {
                attr(node, key, attributes[key]);
            }
        }
    }
    function children(element) {
        return Array.from(element.childNodes);
    }
    function set_input_value(input, value) {
        input.value = value == null ? '' : value;
    }
    function set_style(node, key, value, important) {
        node.style.setProperty(key, value, important ? 'important' : '');
    }
    function select_option(select, value) {
        for (let i = 0; i < select.options.length; i += 1) {
            const option = select.options[i];
            if (option.__value === value) {
                option.selected = true;
                return;
            }
        }
    }
    function select_options(select, value) {
        for (let i = 0; i < select.options.length; i += 1) {
            const option = select.options[i];
            option.selected = ~value.indexOf(option.__value);
        }
    }
    function select_value(select) {
        const selected_option = select.querySelector(':checked') || select.options[0];
        return selected_option && selected_option.__value;
    }
    function select_multiple_value(select) {
        return [].map.call(select.querySelectorAll(':checked'), option => option.__value);
    }
    function toggle_class(element, name, toggle) {
        element.classList[toggle ? 'add' : 'remove'](name);
    }
    function custom_event(type, detail) {
        const e = document.createEvent('CustomEvent');
        e.initCustomEvent(type, false, false, detail);
        return e;
    }

    const active_docs = new Set();
    let active = 0;
    // https://github.com/darkskyapp/string-hash/blob/master/index.js
    function hash(str) {
        let hash = 5381;
        let i = str.length;
        while (i--)
            hash = ((hash << 5) - hash) ^ str.charCodeAt(i);
        return hash >>> 0;
    }
    function create_rule(node, a, b, duration, delay, ease, fn, uid = 0) {
        const step = 16.666 / duration;
        let keyframes = '{\n';
        for (let p = 0; p <= 1; p += step) {
            const t = a + (b - a) * ease(p);
            keyframes += p * 100 + `%{${fn(t, 1 - t)}}\n`;
        }
        const rule = keyframes + `100% {${fn(b, 1 - b)}}\n}`;
        const name = `__svelte_${hash(rule)}_${uid}`;
        const doc = node.ownerDocument;
        active_docs.add(doc);
        const stylesheet = doc.__svelte_stylesheet || (doc.__svelte_stylesheet = doc.head.appendChild(element('style')).sheet);
        const current_rules = doc.__svelte_rules || (doc.__svelte_rules = {});
        if (!current_rules[name]) {
            current_rules[name] = true;
            stylesheet.insertRule(`@keyframes ${name} ${rule}`, stylesheet.cssRules.length);
        }
        const animation = node.style.animation || '';
        node.style.animation = `${animation ? `${animation}, ` : ''}${name} ${duration}ms linear ${delay}ms 1 both`;
        active += 1;
        return name;
    }
    function delete_rule(node, name) {
        const previous = (node.style.animation || '').split(', ');
        const next = previous.filter(name
            ? anim => anim.indexOf(name) < 0 // remove specific animation
            : anim => anim.indexOf('__svelte') === -1 // remove all Svelte animations
        );
        const deleted = previous.length - next.length;
        if (deleted) {
            node.style.animation = next.join(', ');
            active -= deleted;
            if (!active)
                clear_rules();
        }
    }
    function clear_rules() {
        raf(() => {
            if (active)
                return;
            active_docs.forEach(doc => {
                const stylesheet = doc.__svelte_stylesheet;
                let i = stylesheet.cssRules.length;
                while (i--)
                    stylesheet.deleteRule(i);
                doc.__svelte_rules = {};
            });
            active_docs.clear();
        });
    }

    let current_component;
    function set_current_component(component) {
        current_component = component;
    }
    function get_current_component() {
        if (!current_component)
            throw new Error('Function called outside component initialization');
        return current_component;
    }
    function onMount(fn) {
        get_current_component().$$.on_mount.push(fn);
    }
    function afterUpdate(fn) {
        get_current_component().$$.after_update.push(fn);
    }
    function onDestroy(fn) {
        get_current_component().$$.on_destroy.push(fn);
    }
    function createEventDispatcher() {
        const component = get_current_component();
        return (type, detail) => {
            const callbacks = component.$$.callbacks[type];
            if (callbacks) {
                // TODO are there situations where events could be dispatched
                // in a server (non-DOM) environment?
                const event = custom_event(type, detail);
                callbacks.slice().forEach(fn => {
                    fn.call(component, event);
                });
            }
        };
    }
    // TODO figure out if we still want to support
    // shorthand events, or if we want to implement
    // a real bubbling mechanism
    function bubble(component, event) {
        const callbacks = component.$$.callbacks[event.type];
        if (callbacks) {
            callbacks.slice().forEach(fn => fn(event));
        }
    }

    const dirty_components = [];
    const binding_callbacks = [];
    const render_callbacks = [];
    const flush_callbacks = [];
    const resolved_promise = Promise.resolve();
    let update_scheduled = false;
    function schedule_update() {
        if (!update_scheduled) {
            update_scheduled = true;
            resolved_promise.then(flush);
        }
    }
    function add_render_callback(fn) {
        render_callbacks.push(fn);
    }
    let flushing = false;
    const seen_callbacks = new Set();
    function flush() {
        if (flushing)
            return;
        flushing = true;
        do {
            // first, call beforeUpdate functions
            // and update components
            for (let i = 0; i < dirty_components.length; i += 1) {
                const component = dirty_components[i];
                set_current_component(component);
                update(component.$$);
            }
            set_current_component(null);
            dirty_components.length = 0;
            while (binding_callbacks.length)
                binding_callbacks.pop()();
            // then, once components are updated, call
            // afterUpdate functions. This may cause
            // subsequent updates...
            for (let i = 0; i < render_callbacks.length; i += 1) {
                const callback = render_callbacks[i];
                if (!seen_callbacks.has(callback)) {
                    // ...so guard against infinite loops
                    seen_callbacks.add(callback);
                    callback();
                }
            }
            render_callbacks.length = 0;
        } while (dirty_components.length);
        while (flush_callbacks.length) {
            flush_callbacks.pop()();
        }
        update_scheduled = false;
        flushing = false;
        seen_callbacks.clear();
    }
    function update($$) {
        if ($$.fragment !== null) {
            $$.update();
            run_all($$.before_update);
            const dirty = $$.dirty;
            $$.dirty = [-1];
            $$.fragment && $$.fragment.p($$.ctx, dirty);
            $$.after_update.forEach(add_render_callback);
        }
    }

    let promise;
    function wait() {
        if (!promise) {
            promise = Promise.resolve();
            promise.then(() => {
                promise = null;
            });
        }
        return promise;
    }
    function dispatch(node, direction, kind) {
        node.dispatchEvent(custom_event(`${direction ? 'intro' : 'outro'}${kind}`));
    }
    const outroing = new Set();
    let outros;
    function group_outros() {
        outros = {
            r: 0,
            c: [],
            p: outros // parent group
        };
    }
    function check_outros() {
        if (!outros.r) {
            run_all(outros.c);
        }
        outros = outros.p;
    }
    function transition_in(block, local) {
        if (block && block.i) {
            outroing.delete(block);
            block.i(local);
        }
    }
    function transition_out(block, local, detach, callback) {
        if (block && block.o) {
            if (outroing.has(block))
                return;
            outroing.add(block);
            outros.c.push(() => {
                outroing.delete(block);
                if (callback) {
                    if (detach)
                        block.d(1);
                    callback();
                }
            });
            block.o(local);
        }
    }
    const null_transition = { duration: 0 };
    function create_bidirectional_transition(node, fn, params, intro) {
        let config = fn(node, params);
        let t = intro ? 0 : 1;
        let running_program = null;
        let pending_program = null;
        let animation_name = null;
        function clear_animation() {
            if (animation_name)
                delete_rule(node, animation_name);
        }
        function init(program, duration) {
            const d = program.b - t;
            duration *= Math.abs(d);
            return {
                a: t,
                b: program.b,
                d,
                duration,
                start: program.start,
                end: program.start + duration,
                group: program.group
            };
        }
        function go(b) {
            const { delay = 0, duration = 300, easing = identity, tick = noop, css } = config || null_transition;
            const program = {
                start: now() + delay,
                b
            };
            if (!b) {
                // @ts-ignore todo: improve typings
                program.group = outros;
                outros.r += 1;
            }
            if (running_program || pending_program) {
                pending_program = program;
            }
            else {
                // if this is an intro, and there's a delay, we need to do
                // an initial tick and/or apply CSS animation immediately
                if (css) {
                    clear_animation();
                    animation_name = create_rule(node, t, b, duration, delay, easing, css);
                }
                if (b)
                    tick(0, 1);
                running_program = init(program, duration);
                add_render_callback(() => dispatch(node, b, 'start'));
                loop(now => {
                    if (pending_program && now > pending_program.start) {
                        running_program = init(pending_program, duration);
                        pending_program = null;
                        dispatch(node, running_program.b, 'start');
                        if (css) {
                            clear_animation();
                            animation_name = create_rule(node, t, running_program.b, running_program.duration, 0, easing, config.css);
                        }
                    }
                    if (running_program) {
                        if (now >= running_program.end) {
                            tick(t = running_program.b, 1 - t);
                            dispatch(node, running_program.b, 'end');
                            if (!pending_program) {
                                // we're done
                                if (running_program.b) {
                                    // intro — we can tidy up immediately
                                    clear_animation();
                                }
                                else {
                                    // outro — needs to be coordinated
                                    if (!--running_program.group.r)
                                        run_all(running_program.group.c);
                                }
                            }
                            running_program = null;
                        }
                        else if (now >= running_program.start) {
                            const p = now - running_program.start;
                            t = running_program.a + running_program.d * easing(p / running_program.duration);
                            tick(t, 1 - t);
                        }
                    }
                    return !!(running_program || pending_program);
                });
            }
        }
        return {
            run(b) {
                if (is_function(config)) {
                    wait().then(() => {
                        // @ts-ignore
                        config = config();
                        go(b);
                    });
                }
                else {
                    go(b);
                }
            },
            end() {
                clear_animation();
                running_program = pending_program = null;
            }
        };
    }

    function get_spread_update(levels, updates) {
        const update = {};
        const to_null_out = {};
        const accounted_for = { $$scope: 1 };
        let i = levels.length;
        while (i--) {
            const o = levels[i];
            const n = updates[i];
            if (n) {
                for (const key in o) {
                    if (!(key in n))
                        to_null_out[key] = 1;
                }
                for (const key in n) {
                    if (!accounted_for[key]) {
                        update[key] = n[key];
                        accounted_for[key] = 1;
                    }
                }
                levels[i] = n;
            }
            else {
                for (const key in o) {
                    accounted_for[key] = 1;
                }
            }
        }
        for (const key in to_null_out) {
            if (!(key in update))
                update[key] = undefined;
        }
        return update;
    }
    function get_spread_object(spread_props) {
        return typeof spread_props === 'object' && spread_props !== null ? spread_props : {};
    }
    function create_component(block) {
        block && block.c();
    }
    function mount_component(component, target, anchor, customElement) {
        const { fragment, on_mount, on_destroy, after_update } = component.$$;
        fragment && fragment.m(target, anchor);
        if (!customElement) {
            // onMount happens before the initial afterUpdate
            add_render_callback(() => {
                const new_on_destroy = on_mount.map(run).filter(is_function);
                if (on_destroy) {
                    on_destroy.push(...new_on_destroy);
                }
                else {
                    // Edge case - component was destroyed immediately,
                    // most likely as a result of a binding initialising
                    run_all(new_on_destroy);
                }
                component.$$.on_mount = [];
            });
        }
        after_update.forEach(add_render_callback);
    }
    function destroy_component(component, detaching) {
        const $$ = component.$$;
        if ($$.fragment !== null) {
            run_all($$.on_destroy);
            $$.fragment && $$.fragment.d(detaching);
            // TODO null out other refs, including component.$$ (but need to
            // preserve final state?)
            $$.on_destroy = $$.fragment = null;
            $$.ctx = [];
        }
    }
    function make_dirty(component, i) {
        if (component.$$.dirty[0] === -1) {
            dirty_components.push(component);
            schedule_update();
            component.$$.dirty.fill(0);
        }
        component.$$.dirty[(i / 31) | 0] |= (1 << (i % 31));
    }
    function init(component, options, instance, create_fragment, not_equal, props, dirty = [-1]) {
        const parent_component = current_component;
        set_current_component(component);
        const $$ = component.$$ = {
            fragment: null,
            ctx: null,
            // state
            props,
            update: noop,
            not_equal,
            bound: blank_object(),
            // lifecycle
            on_mount: [],
            on_destroy: [],
            on_disconnect: [],
            before_update: [],
            after_update: [],
            context: new Map(parent_component ? parent_component.$$.context : options.context || []),
            // everything else
            callbacks: blank_object(),
            dirty,
            skip_bound: false
        };
        let ready = false;
        $$.ctx = instance
            ? instance(component, options.props || {}, (i, ret, ...rest) => {
                const value = rest.length ? rest[0] : ret;
                if ($$.ctx && not_equal($$.ctx[i], $$.ctx[i] = value)) {
                    if (!$$.skip_bound && $$.bound[i])
                        $$.bound[i](value);
                    if (ready)
                        make_dirty(component, i);
                }
                return ret;
            })
            : [];
        $$.update();
        ready = true;
        run_all($$.before_update);
        // `false` as a special case of no DOM component
        $$.fragment = create_fragment ? create_fragment($$.ctx) : false;
        if (options.target) {
            if (options.hydrate) {
                const nodes = children(options.target);
                // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
                $$.fragment && $$.fragment.l(nodes);
                nodes.forEach(detach);
            }
            else {
                // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
                $$.fragment && $$.fragment.c();
            }
            if (options.intro)
                transition_in(component.$$.fragment);
            mount_component(component, options.target, options.anchor, options.customElement);
            flush();
        }
        set_current_component(parent_component);
    }
    /**
     * Base class for Svelte components. Used when dev=false.
     */
    class SvelteComponent {
        $destroy() {
            destroy_component(this, 1);
            this.$destroy = noop;
        }
        $on(type, callback) {
            const callbacks = (this.$$.callbacks[type] || (this.$$.callbacks[type] = []));
            callbacks.push(callback);
            return () => {
                const index = callbacks.indexOf(callback);
                if (index !== -1)
                    callbacks.splice(index, 1);
            };
        }
        $set($$props) {
            if (this.$$set && !is_empty($$props)) {
                this.$$.skip_bound = true;
                this.$$set($$props);
                this.$$.skip_bound = false;
            }
        }
    }

    function dispatch_dev(type, detail) {
        document.dispatchEvent(custom_event(type, Object.assign({ version: '3.37.0' }, detail)));
    }
    function append_dev(target, node) {
        dispatch_dev('SvelteDOMInsert', { target, node });
        append(target, node);
    }
    function insert_dev(target, node, anchor) {
        dispatch_dev('SvelteDOMInsert', { target, node, anchor });
        insert(target, node, anchor);
    }
    function detach_dev(node) {
        dispatch_dev('SvelteDOMRemove', { node });
        detach(node);
    }
    function listen_dev(node, event, handler, options, has_prevent_default, has_stop_propagation) {
        const modifiers = options === true ? ['capture'] : options ? Array.from(Object.keys(options)) : [];
        if (has_prevent_default)
            modifiers.push('preventDefault');
        if (has_stop_propagation)
            modifiers.push('stopPropagation');
        dispatch_dev('SvelteDOMAddEventListener', { node, event, handler, modifiers });
        const dispose = listen(node, event, handler, options);
        return () => {
            dispatch_dev('SvelteDOMRemoveEventListener', { node, event, handler, modifiers });
            dispose();
        };
    }
    function attr_dev(node, attribute, value) {
        attr(node, attribute, value);
        if (value == null)
            dispatch_dev('SvelteDOMRemoveAttribute', { node, attribute });
        else
            dispatch_dev('SvelteDOMSetAttribute', { node, attribute, value });
    }
    function set_data_dev(text, data) {
        data = '' + data;
        if (text.wholeText === data)
            return;
        dispatch_dev('SvelteDOMSetData', { node: text, data });
        text.data = data;
    }
    function validate_each_argument(arg) {
        if (typeof arg !== 'string' && !(arg && typeof arg === 'object' && 'length' in arg)) {
            let msg = '{#each} only iterates over array-like objects.';
            if (typeof Symbol === 'function' && arg && Symbol.iterator in arg) {
                msg += ' You can use a spread to convert this iterable into an array.';
            }
            throw new Error(msg);
        }
    }
    function validate_slots(name, slot, keys) {
        for (const slot_key of Object.keys(slot)) {
            if (!~keys.indexOf(slot_key)) {
                console.warn(`<${name}> received an unexpected slot "${slot_key}".`);
            }
        }
    }
    /**
     * Base class for Svelte components with some minor dev-enhancements. Used when dev=true.
     */
    class SvelteComponentDev extends SvelteComponent {
        constructor(options) {
            if (!options || (!options.target && !options.$$inline)) {
                throw new Error("'target' is a required option");
            }
            super();
        }
        $destroy() {
            super.$destroy();
            this.$destroy = () => {
                console.warn('Component was already destroyed'); // eslint-disable-line no-console
            };
        }
        $capture_state() { }
        $inject_state() { }
    }

    const subscriber_queue = [];
    /**
     * Create a `Writable` store that allows both updating and reading by subscription.
     * @param {*=}value initial value
     * @param {StartStopNotifier=}start start and stop notifications for subscriptions
     */
    function writable(value, start = noop) {
        let stop;
        const subscribers = [];
        function set(new_value) {
            if (safe_not_equal(value, new_value)) {
                value = new_value;
                if (stop) { // store is ready
                    const run_queue = !subscriber_queue.length;
                    for (let i = 0; i < subscribers.length; i += 1) {
                        const s = subscribers[i];
                        s[1]();
                        subscriber_queue.push(s, value);
                    }
                    if (run_queue) {
                        for (let i = 0; i < subscriber_queue.length; i += 2) {
                            subscriber_queue[i][0](subscriber_queue[i + 1]);
                        }
                        subscriber_queue.length = 0;
                    }
                }
            }
        }
        function update(fn) {
            set(fn(value));
        }
        function subscribe(run, invalidate = noop) {
            const subscriber = [run, invalidate];
            subscribers.push(subscriber);
            if (subscribers.length === 1) {
                stop = start(set) || noop;
            }
            run(value);
            return () => {
                const index = subscribers.indexOf(subscriber);
                if (index !== -1) {
                    subscribers.splice(index, 1);
                }
                if (subscribers.length === 0) {
                    stop();
                    stop = null;
                }
            };
        }
        return { set, update, subscribe };
    }

    const { set, subscribe } = writable({});

    const remove = () => {
      set({});
    };

    const activeRoute = {
      subscribe,
      set,
      remove,
    };

    const UrlParser = (urlString, namedUrl = '') => {
      const urlBase = new URL(urlString);

      /**
       * Wrapper for URL.hash
       *
       **/
      function hash() {
        return urlBase.hash;
      }

      /**
       * Wrapper for URL.host
       *
       **/
      function host() {
        return urlBase.host;
      }

      /**
       * Wrapper for URL.hostname
       *
       **/
      function hostname() {
        return urlBase.hostname;
      }

      /**
       * Returns an object with all the named params and their values
       *
       **/
      function namedParams() {
        const allPathName = pathNames();
        const allNamedParamsKeys = namedParamsWithIndex();

        return allNamedParamsKeys.reduce((values, paramKey) => {
          values[paramKey.value] = allPathName[paramKey.index];
          return values;
        }, {});
      }

      /**
       * Returns an array with all the named param keys
       *
       **/
      function namedParamsKeys() {
        const allNamedParamsKeys = namedParamsWithIndex();

        return allNamedParamsKeys.reduce((values, paramKey) => {
          values.push(paramKey.value);
          return values;
        }, []);
      }

      /**
       * Returns an array with all the named param values
       *
       **/
      function namedParamsValues() {
        const allPathName = pathNames();
        const allNamedParamsKeys = namedParamsWithIndex();

        return allNamedParamsKeys.reduce((values, paramKey) => {
          values.push(allPathName[paramKey.index]);
          return values;
        }, []);
      }

      /**
       * Returns an array with all named param ids and their position in the path
       * Private
       **/
      function namedParamsWithIndex() {
        const namedUrlParams = getPathNames(namedUrl);

        return namedUrlParams.reduce((validParams, param, index) => {
          if (param[0] === ':') {
            validParams.push({ value: param.slice(1), index });
          }
          return validParams;
        }, []);
      }

      /**
       * Wrapper for URL.port
       *
       **/
      function port() {
        return urlBase.port;
      }

      /**
       * Wrapper for URL.pathname
       *
       **/
      function pathname() {
        return urlBase.pathname;
      }

      /**
       * Wrapper for URL.protocol
       *
       **/
      function protocol() {
        return urlBase.protocol;
      }

      /**
       * Wrapper for URL.search
       *
       **/
      function search() {
        return urlBase.search;
      }

      /**
       * Returns an object with all query params and their values
       *
       **/
      function queryParams() {
        const params = {};
        urlBase.searchParams.forEach((value, key) => {
          params[key] = value;
        });

        return params;
      }

      /**
       * Returns an array with all the query param keys
       *
       **/
      function queryParamsKeys() {
        const params = [];
        urlBase.searchParams.forEach((_value, key) => {
          params.push(key);
        });

        return params;
      }

      /**
       * Returns an array with all the query param values
       *
       **/
      function queryParamsValues() {
        const params = [];
        urlBase.searchParams.forEach((value) => {
          params.push(value);
        });

        return params;
      }

      /**
       * Returns an array with all the elements of a pathname
       *
       **/
      function pathNames() {
        return getPathNames(urlBase.pathname);
      }

      /**
       * Returns an array with all the parts of a pathname
       * Private method
       **/
      function getPathNames(pathName) {
        if (pathName === '/' || pathName.trim().length === 0) return [pathName];
        if (pathName.slice(-1) === '/') {
          pathName = pathName.slice(0, -1);
        }
        if (pathName[0] === '/') {
          pathName = pathName.slice(1);
        }

        return pathName.split('/');
      }

      return Object.freeze({
        hash: hash(),
        host: host(),
        hostname: hostname(),
        namedParams: namedParams(),
        namedParamsKeys: namedParamsKeys(),
        namedParamsValues: namedParamsValues(),
        pathNames: pathNames(),
        port: port(),
        pathname: pathname(),
        protocol: protocol(),
        search: search(),
        queryParams: queryParams(),
        queryParamsKeys: queryParamsKeys(),
        queryParamsValues: queryParamsValues(),
      });
    };

    /**
     * Returns true if object has any nested routes empty
     * @param routeObject
     **/
    const anyEmptyNestedRoutes = (routeObject) => {
      let result = false;
      if (Object.keys(routeObject).length === 0) {
        return true;
      }

      if (routeObject.childRoute && Object.keys(routeObject.childRoute).length === 0) {
        result = true;
      } else if (routeObject.childRoute) {
        result = anyEmptyNestedRoutes(routeObject.childRoute);
      }

      return result;
    };

    /**
     * Compare two routes ignoring named params
     * @param pathName string
     * @param routeName string
     **/

    const compareRoutes = (pathName, routeName) => {
      routeName = removeSlash(routeName);

      if (routeName.includes(':')) {
        return routeName.includes(pathName);
      } else {
        return routeName.startsWith(pathName);
      }
    };

    /**
     * Returns a boolean indicating if the name of path exists in the route based on the language parameter
     * @param pathName string
     * @param route object
     * @param language string
     **/

    const findLocalisedRoute = (pathName, route, language) => {
      let exists = false;

      if (language) {
        return { exists: route.lang && route.lang[language] && route.lang[language].includes(pathName), language };
      }

      exists = compareRoutes(pathName, route.name);

      if (!exists && route.lang && typeof route.lang === 'object') {
        for (const [key, value] of Object.entries(route.lang)) {
          if (compareRoutes(pathName, value)) {
            exists = true;
            language = key;
          }
        }
      }

      return { exists, language };
    };

    /**
     * Return all the consecutive named param (placeholders) of a pathname
     * @param pathname
     **/
    const getNamedParams = (pathName = '') => {
      if (pathName.trim().length === 0) return [];
      const namedUrlParams = getPathNames(pathName);
      return namedUrlParams.reduce((validParams, param) => {
        if (param[0] === ':') {
          validParams.push(param.slice(1));
        }

        return validParams;
      }, []);
    };

    /**
     * Split a pathname based on /
     * @param pathName
     * Private method
     **/
    const getPathNames = (pathName) => {
      if (pathName === '/' || pathName.trim().length === 0) return [pathName];

      pathName = removeSlash(pathName, 'both');

      return pathName.split('/');
    };

    /**
     * Return the first part of a pathname until the first named param is found
     * @param name
     **/
    const nameToPath = (name = '') => {
      let routeName;
      if (name === '/' || name.trim().length === 0) return name;
      name = removeSlash(name, 'lead');
      routeName = name.split(':')[0];
      routeName = removeSlash(routeName, 'trail');

      return routeName.toLowerCase();
    };

    /**
     * Return the path name excluding query params
     * @param name
     **/
    const pathWithoutQueryParams = (currentRoute) => {
      const path = currentRoute.path.split('?');
      return path[0];
    };

    /**
     * Return the path name including query params
     * @param name
     **/
    const pathWithQueryParams = (currentRoute) => {
      let queryParams = [];
      if (currentRoute.queryParams) {
        for (let [key, value] of Object.entries(currentRoute.queryParams)) {
          queryParams.push(`${key}=${value}`);
        }
      }

      const hash = currentRoute.hash ? currentRoute.hash : '';

      if (queryParams.length > 0) {
        return `${currentRoute.path}?${queryParams.join('&')}${hash}`;
      } else {
        return currentRoute.path + hash;
      }
    };

    /**
     * Returns a string with trailing or leading slash character removed
     * @param pathName string
     * @param position string - lead, trail, both
     **/
    const removeExtraPaths = (pathNames, basePathNames) => {
      const names = basePathNames.split('/');
      if (names.length > 1) {
        names.forEach(function (name, index) {
          if (name.length > 0 && index > 0) {
            pathNames.shift();
          }
        });
      }

      return pathNames;
    };

    /**
     * Returns a string with trailing or leading slash character removed
     * @param pathName string
     * @param position string - lead, trail, both
     **/

    const removeSlash = (pathName, position = 'lead') => {
      if (position === 'trail' || position === 'both') {
        pathName = pathName.replace(/\/$/, '');
      }

      if (position === 'lead' || position === 'both') {
        pathName = pathName.replace(/^\//, '');
      }

      return pathName;
    };

    /**
     * Returns the name of the route based on the language parameter
     * @param route object
     * @param language string
     **/

    const routeNameLocalised = (route, language = null) => {
      if (!language || !route.lang || !route.lang[language]) {
        return route.name;
      } else {
        return route.lang[language];
      }
    };

    /**
     * Return the path name excluding query params
     * @param name
     **/
    const startsWithNamedParam = (currentRoute) => {
      const routeName = removeSlash(currentRoute);

      return routeName.startsWith(':');
    };

    /**
     * Updates the base route path.
     * Route objects can have nested routes (childRoutes) or just a long name like "admin/employees/show/:id"
     *
     * @param basePath string
     * @param pathNames array
     * @param route object
     * @param language string
     **/

    const updateRoutePath = (basePath, pathNames, route, language, convert = false) => {
      if (basePath === '/' || basePath.trim().length === 0) return { result: basePath, language: null };

      let basePathResult = basePath;
      let routeName = route.name;
      let currentLanguage = language;

      if (convert) {
        currentLanguage = '';
      }

      routeName = removeSlash(routeName);
      basePathResult = removeSlash(basePathResult);

      if (!route.childRoute) {
        let localisedRoute = findLocalisedRoute(basePathResult, route, currentLanguage);

        if (localisedRoute.exists && convert) {
          basePathResult = routeNameLocalised(route, language);
        }

        let routeNames = routeName.split(':')[0];
        routeNames = removeSlash(routeNames, 'trail');
        routeNames = routeNames.split('/');
        routeNames.shift();
        routeNames.forEach(() => {
          const currentPathName = pathNames[0];
          localisedRoute = findLocalisedRoute(`${basePathResult}/${currentPathName}`, route, currentLanguage);

          if (currentPathName && localisedRoute.exists) {
            if (convert) {
              basePathResult = routeNameLocalised(route, language);
            } else {
              basePathResult = `${basePathResult}/${currentPathName}`;
            }
            pathNames.shift();
          } else {
            return { result: basePathResult, language: localisedRoute.language };
          }
        });
        return { result: basePathResult, language: localisedRoute.language };
      } else {
        return { result: basePath, language: currentLanguage };
      }
    };

    const RouterCurrent = (trackPage) => {
      const trackPageview = trackPage || false;
      let activeRoute = '';

      const setActive = (newRoute, updateBrowserHistory) => {
        activeRoute = newRoute.path;
        pushActiveRoute(newRoute, updateBrowserHistory);
      };

      const active = () => {
        return activeRoute;
      };

      /**
       * Returns true if pathName is current active route
       * @param pathName String The path name to check against the current route.
       * @param includePath Boolean if true checks that pathName is included in current route. If false should match it.
       **/
      const isActive = (queryPath, includePath = false) => {
        if (queryPath[0] !== '/') {
          queryPath = '/' + queryPath;
        }

        // remove query params for comparison
        let pathName = UrlParser(`http://fake.com${queryPath}`).pathname;
        let activeRoutePath = UrlParser(`http://fake.com${activeRoute}`).pathname;

        pathName = removeSlash(pathName, 'trail');

        activeRoutePath = removeSlash(activeRoutePath, 'trail');

        if (includePath) {
          return activeRoutePath.includes(pathName);
        } else {
          return activeRoutePath === pathName;
        }
      };

      const pushActiveRoute = (newRoute, updateBrowserHistory) => {
        if (typeof window !== 'undefined') {
          const pathAndSearch = pathWithQueryParams(newRoute);

          if (updateBrowserHistory) {
            window.history.pushState({ page: pathAndSearch }, '', pathAndSearch);
          }
          // Moving back in history does not update browser history but does update tracking.
          if (trackPageview) {
            gaTracking(pathAndSearch);
          }
        }
      };

      const gaTracking = (newPage) => {
        if (typeof ga !== 'undefined') {
          ga('set', 'page', newPage);
          ga('send', 'pageview');
        }
      };

      return Object.freeze({ active, isActive, setActive });
    };

    const RouterGuard = (onlyIf) => {
      const guardInfo = onlyIf;

      const valid = () => {
        return guardInfo && guardInfo.guard && typeof guardInfo.guard === 'function';
      };

      const redirect = () => {
        return !guardInfo.guard();
      };

      const redirectPath = () => {
        let destinationUrl = '/';
        if (guardInfo.redirect && guardInfo.redirect.length > 0) {
          destinationUrl = guardInfo.redirect;
        }

        return destinationUrl;
      };

      return Object.freeze({ valid, redirect, redirectPath });
    };

    const RouterRedirect = (route, currentPath) => {
      const guard = RouterGuard(route.onlyIf);

      const path = () => {
        let redirectTo = currentPath;
        if (route.redirectTo && route.redirectTo.length > 0) {
          redirectTo = route.redirectTo;
        }

        if (guard.valid() && guard.redirect()) {
          redirectTo = guard.redirectPath();
        }

        return redirectTo;
      };

      return Object.freeze({ path });
    };

    function RouterRoute({ routeInfo, path, routeNamedParams, urlParser, namedPath, language }) {
      const namedParams = () => {
        const parsedParams = UrlParser(`https://fake.com${urlParser.pathname}`, namedPath).namedParams;

        return { ...routeNamedParams, ...parsedParams };
      };

      const get = () => {
        return {
          name: path,
          component: routeInfo.component,
          hash: urlParser.hash,
          layout: routeInfo.layout,
          queryParams: urlParser.queryParams,
          namedParams: namedParams(),
          path,
          language,
        };
      };

      return Object.freeze({ get, namedParams });
    }

    function RouterPath({ basePath, basePathName, pathNames, convert, currentLanguage }) {
      let updatedPathRoute;
      let route;
      let routePathLanguage = currentLanguage;

      function updatedPath(currentRoute) {
        route = currentRoute;
        updatedPathRoute = updateRoutePath(basePathName, pathNames, route, routePathLanguage, convert);
        routePathLanguage = convert ? currentLanguage : updatedPathRoute.language;

        return updatedPathRoute;
      }

      function localisedPathName() {
        return routeNameLocalised(route, routePathLanguage);
      }

      function localisedRouteWithoutNamedParams() {
        return nameToPath(localisedPathName());
      }

      function basePathNameWithoutNamedParams() {
        return nameToPath(updatedPathRoute.result);
      }

      function namedPath() {
        const localisedPath = localisedPathName();

        return basePath ? `${basePath}/${localisedPath}` : localisedPath;
      }

      function routePath() {
        let routePathValue = `${basePath}/${basePathNameWithoutNamedParams()}`;
        if (routePathValue === '//') {
          routePathValue = '/';
        }

        if (routePathLanguage) {
          pathNames = removeExtraPaths(pathNames, localisedRouteWithoutNamedParams());
        }

        const namedParams = getNamedParams(localisedPathName());
        if (namedParams && namedParams.length > 0) {
          namedParams.forEach(function () {
            if (pathNames.length > 0) {
              routePathValue += `/${pathNames.shift()}`;
            }
          });
        }

        return routePathValue;
      }

      function routeLanguage() {
        return routePathLanguage;
      }

      function basePathSameAsLocalised() {
        return basePathNameWithoutNamedParams() === localisedRouteWithoutNamedParams();
      }

      return Object.freeze({
        basePathSameAsLocalised,
        updatedPath,
        basePathNameWithoutNamedParams,
        localisedPathName,
        localisedRouteWithoutNamedParams,
        namedPath,
        pathNames,
        routeLanguage,
        routePath,
      });
    }

    const NotFoundPage$1 = '/404.html';

    function RouterFinder({ routes, currentUrl, routerOptions, convert }) {
      const defaultLanguage = routerOptions.defaultLanguage;
      const sitePrefix = routerOptions.prefix ? routerOptions.prefix.toLowerCase() : '';
      const urlParser = parseCurrentUrl(currentUrl, sitePrefix);
      let redirectTo = '';
      let routeNamedParams = {};
      let staticParamMatch = false;

      function findActiveRoute() {
        let searchActiveRoute = searchActiveRoutes(routes, '', urlParser.pathNames, routerOptions.lang, convert);

        if (!searchActiveRoute || !Object.keys(searchActiveRoute).length || anyEmptyNestedRoutes(searchActiveRoute)) {
          if (typeof window !== 'undefined') {
            searchActiveRoute = routeNotFound(routerOptions.lang);
          }
        } else {
          searchActiveRoute.path = pathWithoutQueryParams(searchActiveRoute);
          if (sitePrefix) {
            searchActiveRoute.path = `/${sitePrefix}${searchActiveRoute.path}`;
          }
        }

        return searchActiveRoute;
      }

      /**
       * Gets an array of routes and the browser pathname and return the active route
       * @param routes
       * @param basePath
       * @param pathNames
       **/
      function searchActiveRoutes(routes, basePath, pathNames, currentLanguage, convert) {
        let currentRoute = {};
        let basePathName = pathNames.shift().toLowerCase();
        const routerPath = RouterPath({ basePath, basePathName, pathNames, convert, currentLanguage });
        staticParamMatch = false;

        routes.forEach(function (route) {
          routerPath.updatedPath(route);
          if (route.name !== '/') {
            route.name = removeSlash(route.name);
          }
          if (matchRoute(routerPath, route.name)) {
            let routePath = routerPath.routePath();
            redirectTo = RouterRedirect(route, redirectTo).path();

            if (currentRoute.name !== routePath) {
              currentRoute = setCurrentRoute({
                route,
                routePath,
                routeLanguage: routerPath.routeLanguage(),
                urlParser,
                namedPath: routerPath.namedPath(),
              });
            }

            if (route.nestedRoutes && route.nestedRoutes.length > 0 && routerPath.pathNames.length > 0) {
              currentRoute.childRoute = searchActiveRoutes(
                route.nestedRoutes,
                routePath,
                routerPath.pathNames,
                routerPath.routeLanguage(),
                convert
              );
              currentRoute.path = currentRoute.childRoute.path;
              currentRoute.language = currentRoute.childRoute.language;
            } else if (nestedRoutesAndNoPath(route, routerPath.pathNames)) {
              const indexRoute = searchActiveRoutes(
                route.nestedRoutes,
                routePath,
                ['index'],
                routerPath.routeLanguage(),
                convert
              );
              if (indexRoute && Object.keys(indexRoute).length > 0) {
                currentRoute.childRoute = indexRoute;
                currentRoute.language = currentRoute.childRoute.language;
              }
            }
          }
        });

        if (redirectTo) {
          currentRoute.redirectTo = redirectTo;
        }

        return currentRoute;
      }

      function matchRoute(routerPath, routeName) {
        const basePathSameAsLocalised = routerPath.basePathSameAsLocalised();
        if (basePathSameAsLocalised) {
          staticParamMatch = true;
        }

        return basePathSameAsLocalised || (!staticParamMatch && startsWithNamedParam(routeName));
      }

      function nestedRoutesAndNoPath(route, pathNames) {
        return route.nestedRoutes && route.nestedRoutes.length > 0 && pathNames.length === 0;
      }

      function parseCurrentUrl(currentUrl, sitePrefix) {
        if (sitePrefix && sitePrefix.trim().length > 0) {
          const noPrefixUrl = currentUrl.replace(sitePrefix + '/', '');
          return UrlParser(noPrefixUrl);
        } else {
          return UrlParser(currentUrl);
        }
      }

      function setCurrentRoute({ route, routePath, routeLanguage, urlParser, namedPath }) {
        const routerRoute = RouterRoute({
          routeInfo: route,
          urlParser,
          path: routePath,
          routeNamedParams,
          namedPath,
          language: routeLanguage || defaultLanguage,
        });
        routeNamedParams = routerRoute.namedParams();

        return routerRoute.get();
      }

      const routeNotFound = (customLanguage) => {
        const custom404Page = routes.find((route) => route.name == '404');
        const language = customLanguage || defaultLanguage || '';
        if (custom404Page) {
          return { ...custom404Page, language, path: '404' };
        } else {
          return { name: '404', component: '', path: '404', redirectTo: NotFoundPage$1 };
        }
      };

      return Object.freeze({ findActiveRoute });
    }

    const NotFoundPage = '/404.html';

    let userDefinedRoutes = [];
    let routerOptions = {};
    let routerCurrent;

    /**
     * Object exposes one single property: activeRoute
     * @param routes  Array of routes
     * @param currentUrl current url
     * @param options configuration options
     **/
    const SpaRouter = (routes, currentUrl, options = {}) => {
      routerOptions = { ...options };
      if (typeof currentUrl === 'undefined' || currentUrl === '') {
        currentUrl = document.location.href;
      }

      routerCurrent = RouterCurrent(routerOptions.gaPageviews);

      currentUrl = removeSlash(currentUrl, 'trail');
      userDefinedRoutes = routes;

      const findActiveRoute = () => {
        let convert = false;

        if (routerOptions.langConvertTo) {
          routerOptions.lang = routerOptions.langConvertTo;
          convert = true;
        }

        return RouterFinder({ routes, currentUrl, routerOptions, convert }).findActiveRoute();
      };

      /**
       * Redirect current route to another
       * @param destinationUrl
       **/
      const navigateNow = (destinationUrl, updateBrowserHistory) => {
        if (typeof window !== 'undefined') {
          if (destinationUrl === NotFoundPage) {
            routerCurrent.setActive({ path: NotFoundPage }, updateBrowserHistory);
          } else {
            navigateTo(destinationUrl);
          }
        }

        return destinationUrl;
      };

      const setActiveRoute = (updateBrowserHistory = true) => {
        const currentRoute = findActiveRoute();
        if (currentRoute.redirectTo) {
          return navigateNow(currentRoute.redirectTo, updateBrowserHistory);
        }

        routerCurrent.setActive(currentRoute, updateBrowserHistory);
        activeRoute.set(currentRoute);

        return currentRoute;
      };

      return Object.freeze({
        setActiveRoute,
        findActiveRoute,
      });
    };

    /**
     * Converts a route to its localised version
     * @param pathName
     **/
    const localisedRoute = (pathName, language) => {
      pathName = removeSlash(pathName, 'lead');
      routerOptions.langConvertTo = language;

      return SpaRouter(userDefinedRoutes, 'http://fake.com/' + pathName, routerOptions).findActiveRoute();
    };

    /**
     * Updates the current active route and updates the browser pathname
     * @param pathName String
     * @param language String
     * @param updateBrowserHistory Boolean
     **/
    const navigateTo = (pathName, language = null, updateBrowserHistory = true) => {
      pathName = removeSlash(pathName, 'lead');

      if (language) {
        routerOptions.langConvertTo = language;
      }

      return SpaRouter(userDefinedRoutes, 'http://fake.com/' + pathName, routerOptions).setActiveRoute(
        updateBrowserHistory
      );
    };

    /**
     * Returns true if pathName is current active route
     * @param pathName String The path name to check against the current route.
     * @param includePath Boolean if true checks that pathName is included in current route. If false should match it.
     **/
    const routeIsActive = (queryPath, includePath = false) => {
      return routerCurrent.isActive(queryPath, includePath);
    };

    if (typeof window !== 'undefined') {
      // Avoid full page reload on local routes
      window.addEventListener('click', (event) => {
        if (event.target.localName.toLowerCase() !== 'a') return;
        if (event.metaKey || event.ctrlKey || event.shiftKey) return;

        const sitePrefix = routerOptions.prefix ? `/${routerOptions.prefix.toLowerCase()}` : '';
        const targetHostNameInternal = event.target.pathname && event.target.host === window.location.host;
        const prefixMatchPath = sitePrefix.length > 1 ? event.target.pathname.startsWith(sitePrefix) : true;

        if (targetHostNameInternal && prefixMatchPath) {
          event.preventDefault();
          let navigatePathname = event.target.pathname + event.target.search;

          const destinationUrl = navigatePathname + event.target.search + event.target.hash;
          if (event.target.target === '_blank') {
            window.open(destinationUrl, 'newTab');
          } else {
            navigateTo(destinationUrl);
          }
        }
      });

      window.onpopstate = function (_event) {
        let navigatePathname = window.location.pathname + window.location.search + window.location.hash;

        navigateTo(navigatePathname, null, false);
      };
    }

    /* node_modules/svelte-router-spa/src/components/route.svelte generated by Svelte v3.37.0 */

    // (10:34) 
    function create_if_block_2$3(ctx) {
    	let route;
    	let current;

    	route = new Route({
    			props: {
    				currentRoute: /*currentRoute*/ ctx[0].childRoute,
    				params: /*params*/ ctx[1]
    			},
    			$$inline: true
    		});

    	const block = {
    		c: function create() {
    			create_component(route.$$.fragment);
    		},
    		m: function mount(target, anchor) {
    			mount_component(route, target, anchor);
    			current = true;
    		},
    		p: function update(ctx, dirty) {
    			const route_changes = {};
    			if (dirty & /*currentRoute*/ 1) route_changes.currentRoute = /*currentRoute*/ ctx[0].childRoute;
    			if (dirty & /*params*/ 2) route_changes.params = /*params*/ ctx[1];
    			route.$set(route_changes);
    		},
    		i: function intro(local) {
    			if (current) return;
    			transition_in(route.$$.fragment, local);
    			current = true;
    		},
    		o: function outro(local) {
    			transition_out(route.$$.fragment, local);
    			current = false;
    		},
    		d: function destroy(detaching) {
    			destroy_component(route, detaching);
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_if_block_2$3.name,
    		type: "if",
    		source: "(10:34) ",
    		ctx
    	});

    	return block;
    }

    // (8:33) 
    function create_if_block_1$6(ctx) {
    	let switch_instance;
    	let switch_instance_anchor;
    	let current;
    	var switch_value = /*currentRoute*/ ctx[0].component;

    	function switch_props(ctx) {
    		return {
    			props: {
    				currentRoute: {
    					.../*currentRoute*/ ctx[0],
    					component: ""
    				},
    				params: /*params*/ ctx[1]
    			},
    			$$inline: true
    		};
    	}

    	if (switch_value) {
    		switch_instance = new switch_value(switch_props(ctx));
    	}

    	const block = {
    		c: function create() {
    			if (switch_instance) create_component(switch_instance.$$.fragment);
    			switch_instance_anchor = empty();
    		},
    		m: function mount(target, anchor) {
    			if (switch_instance) {
    				mount_component(switch_instance, target, anchor);
    			}

    			insert_dev(target, switch_instance_anchor, anchor);
    			current = true;
    		},
    		p: function update(ctx, dirty) {
    			const switch_instance_changes = {};

    			if (dirty & /*currentRoute*/ 1) switch_instance_changes.currentRoute = {
    				.../*currentRoute*/ ctx[0],
    				component: ""
    			};

    			if (dirty & /*params*/ 2) switch_instance_changes.params = /*params*/ ctx[1];

    			if (switch_value !== (switch_value = /*currentRoute*/ ctx[0].component)) {
    				if (switch_instance) {
    					group_outros();
    					const old_component = switch_instance;

    					transition_out(old_component.$$.fragment, 1, 0, () => {
    						destroy_component(old_component, 1);
    					});

    					check_outros();
    				}

    				if (switch_value) {
    					switch_instance = new switch_value(switch_props(ctx));
    					create_component(switch_instance.$$.fragment);
    					transition_in(switch_instance.$$.fragment, 1);
    					mount_component(switch_instance, switch_instance_anchor.parentNode, switch_instance_anchor);
    				} else {
    					switch_instance = null;
    				}
    			} else if (switch_value) {
    				switch_instance.$set(switch_instance_changes);
    			}
    		},
    		i: function intro(local) {
    			if (current) return;
    			if (switch_instance) transition_in(switch_instance.$$.fragment, local);
    			current = true;
    		},
    		o: function outro(local) {
    			if (switch_instance) transition_out(switch_instance.$$.fragment, local);
    			current = false;
    		},
    		d: function destroy(detaching) {
    			if (detaching) detach_dev(switch_instance_anchor);
    			if (switch_instance) destroy_component(switch_instance, detaching);
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_if_block_1$6.name,
    		type: "if",
    		source: "(8:33) ",
    		ctx
    	});

    	return block;
    }

    // (6:0) {#if currentRoute.layout}
    function create_if_block$d(ctx) {
    	let switch_instance;
    	let switch_instance_anchor;
    	let current;
    	var switch_value = /*currentRoute*/ ctx[0].layout;

    	function switch_props(ctx) {
    		return {
    			props: {
    				currentRoute: { .../*currentRoute*/ ctx[0], layout: "" },
    				params: /*params*/ ctx[1]
    			},
    			$$inline: true
    		};
    	}

    	if (switch_value) {
    		switch_instance = new switch_value(switch_props(ctx));
    	}

    	const block = {
    		c: function create() {
    			if (switch_instance) create_component(switch_instance.$$.fragment);
    			switch_instance_anchor = empty();
    		},
    		m: function mount(target, anchor) {
    			if (switch_instance) {
    				mount_component(switch_instance, target, anchor);
    			}

    			insert_dev(target, switch_instance_anchor, anchor);
    			current = true;
    		},
    		p: function update(ctx, dirty) {
    			const switch_instance_changes = {};
    			if (dirty & /*currentRoute*/ 1) switch_instance_changes.currentRoute = { .../*currentRoute*/ ctx[0], layout: "" };
    			if (dirty & /*params*/ 2) switch_instance_changes.params = /*params*/ ctx[1];

    			if (switch_value !== (switch_value = /*currentRoute*/ ctx[0].layout)) {
    				if (switch_instance) {
    					group_outros();
    					const old_component = switch_instance;

    					transition_out(old_component.$$.fragment, 1, 0, () => {
    						destroy_component(old_component, 1);
    					});

    					check_outros();
    				}

    				if (switch_value) {
    					switch_instance = new switch_value(switch_props(ctx));
    					create_component(switch_instance.$$.fragment);
    					transition_in(switch_instance.$$.fragment, 1);
    					mount_component(switch_instance, switch_instance_anchor.parentNode, switch_instance_anchor);
    				} else {
    					switch_instance = null;
    				}
    			} else if (switch_value) {
    				switch_instance.$set(switch_instance_changes);
    			}
    		},
    		i: function intro(local) {
    			if (current) return;
    			if (switch_instance) transition_in(switch_instance.$$.fragment, local);
    			current = true;
    		},
    		o: function outro(local) {
    			if (switch_instance) transition_out(switch_instance.$$.fragment, local);
    			current = false;
    		},
    		d: function destroy(detaching) {
    			if (detaching) detach_dev(switch_instance_anchor);
    			if (switch_instance) destroy_component(switch_instance, detaching);
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_if_block$d.name,
    		type: "if",
    		source: "(6:0) {#if currentRoute.layout}",
    		ctx
    	});

    	return block;
    }

    function create_fragment$Z(ctx) {
    	let current_block_type_index;
    	let if_block;
    	let if_block_anchor;
    	let current;
    	const if_block_creators = [create_if_block$d, create_if_block_1$6, create_if_block_2$3];
    	const if_blocks = [];

    	function select_block_type(ctx, dirty) {
    		if (/*currentRoute*/ ctx[0].layout) return 0;
    		if (/*currentRoute*/ ctx[0].component) return 1;
    		if (/*currentRoute*/ ctx[0].childRoute) return 2;
    		return -1;
    	}

    	if (~(current_block_type_index = select_block_type(ctx))) {
    		if_block = if_blocks[current_block_type_index] = if_block_creators[current_block_type_index](ctx);
    	}

    	const block = {
    		c: function create() {
    			if (if_block) if_block.c();
    			if_block_anchor = empty();
    		},
    		l: function claim(nodes) {
    			throw new Error("options.hydrate only works if the component was compiled with the `hydratable: true` option");
    		},
    		m: function mount(target, anchor) {
    			if (~current_block_type_index) {
    				if_blocks[current_block_type_index].m(target, anchor);
    			}

    			insert_dev(target, if_block_anchor, anchor);
    			current = true;
    		},
    		p: function update(ctx, [dirty]) {
    			let previous_block_index = current_block_type_index;
    			current_block_type_index = select_block_type(ctx);

    			if (current_block_type_index === previous_block_index) {
    				if (~current_block_type_index) {
    					if_blocks[current_block_type_index].p(ctx, dirty);
    				}
    			} else {
    				if (if_block) {
    					group_outros();

    					transition_out(if_blocks[previous_block_index], 1, 1, () => {
    						if_blocks[previous_block_index] = null;
    					});

    					check_outros();
    				}

    				if (~current_block_type_index) {
    					if_block = if_blocks[current_block_type_index];

    					if (!if_block) {
    						if_block = if_blocks[current_block_type_index] = if_block_creators[current_block_type_index](ctx);
    						if_block.c();
    					} else {
    						if_block.p(ctx, dirty);
    					}

    					transition_in(if_block, 1);
    					if_block.m(if_block_anchor.parentNode, if_block_anchor);
    				} else {
    					if_block = null;
    				}
    			}
    		},
    		i: function intro(local) {
    			if (current) return;
    			transition_in(if_block);
    			current = true;
    		},
    		o: function outro(local) {
    			transition_out(if_block);
    			current = false;
    		},
    		d: function destroy(detaching) {
    			if (~current_block_type_index) {
    				if_blocks[current_block_type_index].d(detaching);
    			}

    			if (detaching) detach_dev(if_block_anchor);
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_fragment$Z.name,
    		type: "component",
    		source: "",
    		ctx
    	});

    	return block;
    }

    function instance$Z($$self, $$props, $$invalidate) {
    	let { $$slots: slots = {}, $$scope } = $$props;
    	validate_slots("Route", slots, []);
    	let { currentRoute = {} } = $$props;
    	let { params = {} } = $$props;
    	const writable_props = ["currentRoute", "params"];

    	Object.keys($$props).forEach(key => {
    		if (!~writable_props.indexOf(key) && key.slice(0, 2) !== "$$") console.warn(`<Route> was created with unknown prop '${key}'`);
    	});

    	$$self.$$set = $$props => {
    		if ("currentRoute" in $$props) $$invalidate(0, currentRoute = $$props.currentRoute);
    		if ("params" in $$props) $$invalidate(1, params = $$props.params);
    	};

    	$$self.$capture_state = () => ({ currentRoute, params });

    	$$self.$inject_state = $$props => {
    		if ("currentRoute" in $$props) $$invalidate(0, currentRoute = $$props.currentRoute);
    		if ("params" in $$props) $$invalidate(1, params = $$props.params);
    	};

    	if ($$props && "$$inject" in $$props) {
    		$$self.$inject_state($$props.$$inject);
    	}

    	return [currentRoute, params];
    }

    class Route extends SvelteComponentDev {
    	constructor(options) {
    		super(options);
    		init(this, options, instance$Z, create_fragment$Z, safe_not_equal, { currentRoute: 0, params: 1 });

    		dispatch_dev("SvelteRegisterComponent", {
    			component: this,
    			tagName: "Route",
    			options,
    			id: create_fragment$Z.name
    		});
    	}

    	get currentRoute() {
    		throw new Error("<Route>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	set currentRoute(value) {
    		throw new Error("<Route>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	get params() {
    		throw new Error("<Route>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	set params(value) {
    		throw new Error("<Route>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}
    }

    /* node_modules/svelte-router-spa/src/components/router.svelte generated by Svelte v3.37.0 */

    function create_fragment$Y(ctx) {
    	let route;
    	let current;

    	route = new Route({
    			props: { currentRoute: /*$activeRoute*/ ctx[0] },
    			$$inline: true
    		});

    	const block = {
    		c: function create() {
    			create_component(route.$$.fragment);
    		},
    		l: function claim(nodes) {
    			throw new Error("options.hydrate only works if the component was compiled with the `hydratable: true` option");
    		},
    		m: function mount(target, anchor) {
    			mount_component(route, target, anchor);
    			current = true;
    		},
    		p: function update(ctx, [dirty]) {
    			const route_changes = {};
    			if (dirty & /*$activeRoute*/ 1) route_changes.currentRoute = /*$activeRoute*/ ctx[0];
    			route.$set(route_changes);
    		},
    		i: function intro(local) {
    			if (current) return;
    			transition_in(route.$$.fragment, local);
    			current = true;
    		},
    		o: function outro(local) {
    			transition_out(route.$$.fragment, local);
    			current = false;
    		},
    		d: function destroy(detaching) {
    			destroy_component(route, detaching);
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_fragment$Y.name,
    		type: "component",
    		source: "",
    		ctx
    	});

    	return block;
    }

    function instance$Y($$self, $$props, $$invalidate) {
    	let $activeRoute;
    	validate_store(activeRoute, "activeRoute");
    	component_subscribe($$self, activeRoute, $$value => $$invalidate(0, $activeRoute = $$value));
    	let { $$slots: slots = {}, $$scope } = $$props;
    	validate_slots("Router", slots, []);
    	let { routes = [] } = $$props;
    	let { options = {} } = $$props;

    	onMount(() => {
    		SpaRouter(routes, document.location.href, options).setActiveRoute();
    	});

    	const writable_props = ["routes", "options"];

    	Object.keys($$props).forEach(key => {
    		if (!~writable_props.indexOf(key) && key.slice(0, 2) !== "$$") console.warn(`<Router> was created with unknown prop '${key}'`);
    	});

    	$$self.$$set = $$props => {
    		if ("routes" in $$props) $$invalidate(1, routes = $$props.routes);
    		if ("options" in $$props) $$invalidate(2, options = $$props.options);
    	};

    	$$self.$capture_state = () => ({
    		onMount,
    		SpaRouter,
    		Route,
    		activeRoute,
    		routes,
    		options,
    		$activeRoute
    	});

    	$$self.$inject_state = $$props => {
    		if ("routes" in $$props) $$invalidate(1, routes = $$props.routes);
    		if ("options" in $$props) $$invalidate(2, options = $$props.options);
    	};

    	if ($$props && "$$inject" in $$props) {
    		$$self.$inject_state($$props.$$inject);
    	}

    	return [$activeRoute, routes, options];
    }

    class Router extends SvelteComponentDev {
    	constructor(options) {
    		super(options);
    		init(this, options, instance$Y, create_fragment$Y, safe_not_equal, { routes: 1, options: 2 });

    		dispatch_dev("SvelteRegisterComponent", {
    			component: this,
    			tagName: "Router",
    			options,
    			id: create_fragment$Y.name
    		});
    	}

    	get routes() {
    		throw new Error("<Router>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	set routes(value) {
    		throw new Error("<Router>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	get options() {
    		throw new Error("<Router>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	set options(value) {
    		throw new Error("<Router>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}
    }

    /* node_modules/svelte-router-spa/src/components/navigate.svelte generated by Svelte v3.37.0 */
    const file$P = "node_modules/svelte-router-spa/src/components/navigate.svelte";

    function create_fragment$X(ctx) {
    	let a;
    	let current;
    	let mounted;
    	let dispose;
    	const default_slot_template = /*#slots*/ ctx[6].default;
    	const default_slot = create_slot(default_slot_template, ctx, /*$$scope*/ ctx[5], null);

    	const block = {
    		c: function create() {
    			a = element("a");
    			if (default_slot) default_slot.c();
    			attr_dev(a, "href", /*to*/ ctx[0]);
    			attr_dev(a, "title", /*title*/ ctx[1]);
    			attr_dev(a, "class", /*styles*/ ctx[2]);
    			toggle_class(a, "active", routeIsActive(/*to*/ ctx[0]));
    			add_location(a, file$P, 26, 0, 560);
    		},
    		l: function claim(nodes) {
    			throw new Error("options.hydrate only works if the component was compiled with the `hydratable: true` option");
    		},
    		m: function mount(target, anchor) {
    			insert_dev(target, a, anchor);

    			if (default_slot) {
    				default_slot.m(a, null);
    			}

    			current = true;

    			if (!mounted) {
    				dispose = listen_dev(a, "click", /*navigate*/ ctx[3], false, false, false);
    				mounted = true;
    			}
    		},
    		p: function update(ctx, [dirty]) {
    			if (default_slot) {
    				if (default_slot.p && dirty & /*$$scope*/ 32) {
    					update_slot(default_slot, default_slot_template, ctx, /*$$scope*/ ctx[5], dirty, null, null);
    				}
    			}

    			if (!current || dirty & /*to*/ 1) {
    				attr_dev(a, "href", /*to*/ ctx[0]);
    			}

    			if (!current || dirty & /*title*/ 2) {
    				attr_dev(a, "title", /*title*/ ctx[1]);
    			}

    			if (!current || dirty & /*styles*/ 4) {
    				attr_dev(a, "class", /*styles*/ ctx[2]);
    			}

    			if (dirty & /*styles, routeIsActive, to*/ 5) {
    				toggle_class(a, "active", routeIsActive(/*to*/ ctx[0]));
    			}
    		},
    		i: function intro(local) {
    			if (current) return;
    			transition_in(default_slot, local);
    			current = true;
    		},
    		o: function outro(local) {
    			transition_out(default_slot, local);
    			current = false;
    		},
    		d: function destroy(detaching) {
    			if (detaching) detach_dev(a);
    			if (default_slot) default_slot.d(detaching);
    			mounted = false;
    			dispose();
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_fragment$X.name,
    		type: "component",
    		source: "",
    		ctx
    	});

    	return block;
    }

    function instance$X($$self, $$props, $$invalidate) {
    	let { $$slots: slots = {}, $$scope } = $$props;
    	validate_slots("Navigate", slots, ['default']);
    	let { to = "/" } = $$props;
    	let { title = "" } = $$props;
    	let { styles = "" } = $$props;
    	let { lang = null } = $$props;

    	onMount(() => {
    		if (lang) {
    			const route = localisedRoute(to, lang);

    			if (route) {
    				$$invalidate(0, to = route.path);
    			}
    		}
    	});

    	const navigate = event => {
    		if (event.metaKey || event.ctrlKey || event.shiftKey) return;
    		event.preventDefault();
    		event.stopPropagation();
    		navigateTo(to);
    	};

    	const writable_props = ["to", "title", "styles", "lang"];

    	Object.keys($$props).forEach(key => {
    		if (!~writable_props.indexOf(key) && key.slice(0, 2) !== "$$") console.warn(`<Navigate> was created with unknown prop '${key}'`);
    	});

    	$$self.$$set = $$props => {
    		if ("to" in $$props) $$invalidate(0, to = $$props.to);
    		if ("title" in $$props) $$invalidate(1, title = $$props.title);
    		if ("styles" in $$props) $$invalidate(2, styles = $$props.styles);
    		if ("lang" in $$props) $$invalidate(4, lang = $$props.lang);
    		if ("$$scope" in $$props) $$invalidate(5, $$scope = $$props.$$scope);
    	};

    	$$self.$capture_state = () => ({
    		onMount,
    		localisedRoute,
    		navigateTo,
    		routeIsActive,
    		to,
    		title,
    		styles,
    		lang,
    		navigate
    	});

    	$$self.$inject_state = $$props => {
    		if ("to" in $$props) $$invalidate(0, to = $$props.to);
    		if ("title" in $$props) $$invalidate(1, title = $$props.title);
    		if ("styles" in $$props) $$invalidate(2, styles = $$props.styles);
    		if ("lang" in $$props) $$invalidate(4, lang = $$props.lang);
    	};

    	if ($$props && "$$inject" in $$props) {
    		$$self.$inject_state($$props.$$inject);
    	}

    	return [to, title, styles, navigate, lang, $$scope, slots];
    }

    class Navigate extends SvelteComponentDev {
    	constructor(options) {
    		super(options);
    		init(this, options, instance$X, create_fragment$X, safe_not_equal, { to: 0, title: 1, styles: 2, lang: 4 });

    		dispatch_dev("SvelteRegisterComponent", {
    			component: this,
    			tagName: "Navigate",
    			options,
    			id: create_fragment$X.name
    		});
    	}

    	get to() {
    		throw new Error("<Navigate>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	set to(value) {
    		throw new Error("<Navigate>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	get title() {
    		throw new Error("<Navigate>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	set title(value) {
    		throw new Error("<Navigate>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	get styles() {
    		throw new Error("<Navigate>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	set styles(value) {
    		throw new Error("<Navigate>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	get lang() {
    		throw new Error("<Navigate>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	set lang(value) {
    		throw new Error("<Navigate>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}
    }

    function clean$1($$props, extra_keys) {
      let keys = ["children", "$$scope", "$$slots"].concat(extra_keys);
      const rest = {};
      for (const key of Object.keys($$props)) {
        if (!(keys.includes(key))) {
          rest[key] = $$props[key];
        }
      }
      return rest;
    }

    function getOriginalBodyPadding() {
      const style = window ? window.getComputedStyle(document.body, null) : {};

      return parseInt((style && style.getPropertyValue('padding-right')) || 0, 10);
    }

    function getScrollbarWidth() {
      let scrollDiv = document.createElement('div');
      // .modal-scrollbar-measure styles // https://github.com/twbs/bootstrap/blob/v4.0.0-alpha.4/scss/_modal.scss#L106-L113
      scrollDiv.style.position = 'absolute';
      scrollDiv.style.top = '-9999px';
      scrollDiv.style.width = '50px';
      scrollDiv.style.height = '50px';
      scrollDiv.style.overflow = 'scroll';
      document.body.appendChild(scrollDiv);
      const scrollbarWidth = scrollDiv.offsetWidth - scrollDiv.clientWidth;
      document.body.removeChild(scrollDiv);
      return scrollbarWidth;
    }

    function setScrollbarWidth(padding) {
      document.body.style.paddingRight = padding > 0 ? `${padding}px` : null;
    }

    function isBodyOverflowing() {
      return window ? document.body.clientWidth < window.innerWidth : false;
    }

    function isObject(value) {
      const type = typeof value;
      return value != null && (type == 'object' || type == 'function');
    }

    function conditionallyUpdateScrollbar() {
      const scrollbarWidth = getScrollbarWidth();
      // https://github.com/twbs/bootstrap/blob/v4.0.0-alpha.6/js/src/modal.js#L433
      const fixedContent = document.querySelectorAll(
        '.fixed-top, .fixed-bottom, .is-fixed, .sticky-top'
      )[0];
      const bodyPadding = fixedContent
        ? parseInt(fixedContent.style.paddingRight || 0, 10)
        : 0;

      if (isBodyOverflowing()) {
        setScrollbarWidth(bodyPadding + scrollbarWidth);
      }
    }

    function getColumnSizeClass(isXs, colWidth, colSize) {
      if (colSize === true || colSize === '') {
        return isXs ? 'col' : `col-${colWidth}`;
      } else if (colSize === 'auto') {
        return isXs ? 'col-auto' : `col-${colWidth}-auto`;
      }

      return isXs ? `col-${colSize}` : `col-${colWidth}-${colSize}`;
    }

    function browserEvent(target, ...args) {
      target.addEventListener(...args);

      return () => target.removeEventListener(...args);
    }

    function toVal(mix) {
      var k, y, str = '';
      if (mix) {
        if (typeof mix === 'object') {
          if (Array.isArray(mix)) {
            for (k = 0; k < mix.length; k++) {
              if (mix[k] && (y = toVal(mix[k]))) {
                str && (str += ' ');
                str += y;
              }
            }
          } else {
            for (k in mix) {
              if (mix[k] && (y = toVal(k))) {
                str && (str += ' ');
                str += y;
              }
            }
          }
        } else if (typeof mix !== 'boolean' && !mix.call) {
          str && (str += ' ');
          str += mix;
        }
      }
      return str;
    }

    function clsx() {
      let i = 0, x, str = '';
      while (i < arguments.length) {
        if (x = toVal(arguments[i++])) {
          str && (str += ' ');
          str += x;
        }
      }
      return str;
    }

    function forwardEventsBuilder(component, additionalEvents = []) {
      const events = [
        'focus', 'blur', 'change', 'input', 'update','submit',
        'fullscreenchange', 'fullscreenerror', 'scroll',
        'cut', 'copy', 'paste',
        'keydown', 'keypress', 'keyup',
        'auxclick', 'click', 'contextmenu', 'dblclick', 'mousedown', 'mouseenter', 'mouseleave', 'mousemove', 'mouseover', 'mouseout', 'mouseup', 'pointerlockchange', 'pointerlockerror', 'select', 'wheel',
        'drag', 'dragend', 'dragenter', 'dragstart', 'dragleave', 'dragover', 'drop',
        'touchcancel', 'touchend', 'touchmove', 'touchstart',
        'pointerover', 'pointerenter', 'pointerdown', 'pointermove', 'pointerup', 'pointercancel', 'pointerout', 'pointerleave', 'gotpointercapture', 'lostpointercapture',
        ...additionalEvents
      ];

      function forward(e) {
        bubble(component, e);
      }

      return node => {
        const destructors = [];

        for (let i = 0; i < events.length; i++) {
          destructors.push(listen(node, events[i], forward));
        }

        return {
          destroy: () => {
            for (let i = 0; i < destructors.length; i++) {
              destructors[i]();
            }
          }
        }
      };
    }

    const getColorClass = color => {
      const colorArray = color.split(' ');
      const specialColors = [
        'danger',
        'warning',
        'success',
        'info',
        'default',
        'primary',
        'secondary',
        'elegant',
        'stylish',
        'unique',
        'special'
      ];
      let colorClasses = '';

      colorArray.forEach(color => {
        if (specialColors.includes(color)) {
          if (color.includes('dark')) {
            color.replace('-', '-color-');
            colorClasses += `${color} `;
          } else {
            colorClasses += `${color}-color`;
          }
        } else {
          colorClasses += `${color} `;
        }
      });

      return colorClasses;
    };

    /* node_modules/mdbsvelte/src/MDBListGroup.svelte generated by Svelte v3.37.0 */
    const file$O = "node_modules/mdbsvelte/src/MDBListGroup.svelte";

    function create_fragment$W(ctx) {
    	let ul;
    	let current;
    	let mounted;
    	let dispose;
    	const default_slot_template = /*#slots*/ ctx[6].default;
    	const default_slot = create_slot(default_slot_template, ctx, /*$$scope*/ ctx[5], null);
    	let ul_levels = [/*props*/ ctx[2], { class: /*classes*/ ctx[0] }];
    	let ul_data = {};

    	for (let i = 0; i < ul_levels.length; i += 1) {
    		ul_data = assign(ul_data, ul_levels[i]);
    	}

    	const block = {
    		c: function create() {
    			ul = element("ul");
    			if (default_slot) default_slot.c();
    			set_attributes(ul, ul_data);
    			add_location(ul, file$O, 18, 0, 411);
    		},
    		l: function claim(nodes) {
    			throw new Error("options.hydrate only works if the component was compiled with the `hydratable: true` option");
    		},
    		m: function mount(target, anchor) {
    			insert_dev(target, ul, anchor);

    			if (default_slot) {
    				default_slot.m(ul, null);
    			}

    			current = true;

    			if (!mounted) {
    				dispose = action_destroyer(/*forwardEvents*/ ctx[1].call(null, ul));
    				mounted = true;
    			}
    		},
    		p: function update(ctx, [dirty]) {
    			if (default_slot) {
    				if (default_slot.p && dirty & /*$$scope*/ 32) {
    					update_slot(default_slot, default_slot_template, ctx, /*$$scope*/ ctx[5], dirty, null, null);
    				}
    			}

    			set_attributes(ul, ul_data = get_spread_update(ul_levels, [
    				/*props*/ ctx[2],
    				(!current || dirty & /*classes*/ 1) && { class: /*classes*/ ctx[0] }
    			]));
    		},
    		i: function intro(local) {
    			if (current) return;
    			transition_in(default_slot, local);
    			current = true;
    		},
    		o: function outro(local) {
    			transition_out(default_slot, local);
    			current = false;
    		},
    		d: function destroy(detaching) {
    			if (detaching) detach_dev(ul);
    			if (default_slot) default_slot.d(detaching);
    			mounted = false;
    			dispose();
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_fragment$W.name,
    		type: "component",
    		source: "",
    		ctx
    	});

    	return block;
    }

    function instance$W($$self, $$props, $$invalidate) {
    	let classes;
    	let { $$slots: slots = {}, $$scope } = $$props;
    	validate_slots("MDBListGroup", slots, ['default']);
    	const forwardEvents = forwardEventsBuilder(current_component);
    	let { class: className = "" } = $$props;
    	let { flush = false } = $$props;
    	const props = clean$1($$props);

    	$$self.$$set = $$new_props => {
    		$$invalidate(7, $$props = assign(assign({}, $$props), exclude_internal_props($$new_props)));
    		if ("class" in $$new_props) $$invalidate(3, className = $$new_props.class);
    		if ("flush" in $$new_props) $$invalidate(4, flush = $$new_props.flush);
    		if ("$$scope" in $$new_props) $$invalidate(5, $$scope = $$new_props.$$scope);
    	};

    	$$self.$capture_state = () => ({
    		clean: clean$1,
    		clsx,
    		forwardEventsBuilder,
    		current_component,
    		forwardEvents,
    		className,
    		flush,
    		props,
    		classes
    	});

    	$$self.$inject_state = $$new_props => {
    		$$invalidate(7, $$props = assign(assign({}, $$props), $$new_props));
    		if ("className" in $$props) $$invalidate(3, className = $$new_props.className);
    		if ("flush" in $$props) $$invalidate(4, flush = $$new_props.flush);
    		if ("classes" in $$props) $$invalidate(0, classes = $$new_props.classes);
    	};

    	if ($$props && "$$inject" in $$props) {
    		$$self.$inject_state($$props.$$inject);
    	}

    	$$self.$$.update = () => {
    		if ($$self.$$.dirty & /*className, flush*/ 24) {
    			$$invalidate(0, classes = clsx(className, "list-group", flush ? "list-group-flush" : false));
    		}
    	};

    	$$props = exclude_internal_props($$props);
    	return [classes, forwardEvents, props, className, flush, $$scope, slots];
    }

    class MDBListGroup extends SvelteComponentDev {
    	constructor(options) {
    		super(options);
    		init(this, options, instance$W, create_fragment$W, safe_not_equal, { class: 3, flush: 4 });

    		dispatch_dev("SvelteRegisterComponent", {
    			component: this,
    			tagName: "MDBListGroup",
    			options,
    			id: create_fragment$W.name
    		});
    	}

    	get class() {
    		throw new Error("<MDBListGroup>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	set class(value) {
    		throw new Error("<MDBListGroup>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	get flush() {
    		throw new Error("<MDBListGroup>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	set flush(value) {
    		throw new Error("<MDBListGroup>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}
    }

    /* node_modules/mdbsvelte/src/MDBListGroupItem.svelte generated by Svelte v3.37.0 */
    const file$N = "node_modules/mdbsvelte/src/MDBListGroupItem.svelte";

    // (35:0) {:else}
    function create_else_block$9(ctx) {
    	let li;
    	let current;
    	let mounted;
    	let dispose;
    	const default_slot_template = /*#slots*/ ctx[11].default;
    	const default_slot = create_slot(default_slot_template, ctx, /*$$scope*/ ctx[10], null);

    	let li_levels = [
    		/*props*/ ctx[6],
    		{ class: /*classes*/ ctx[4] },
    		{ disabled: /*disabled*/ ctx[1] },
    		{ active: /*active*/ ctx[0] }
    	];

    	let li_data = {};

    	for (let i = 0; i < li_levels.length; i += 1) {
    		li_data = assign(li_data, li_levels[i]);
    	}

    	const block = {
    		c: function create() {
    			li = element("li");
    			if (default_slot) default_slot.c();
    			set_attributes(li, li_data);
    			add_location(li, file$N, 35, 2, 934);
    		},
    		m: function mount(target, anchor) {
    			insert_dev(target, li, anchor);

    			if (default_slot) {
    				default_slot.m(li, null);
    			}

    			current = true;

    			if (!mounted) {
    				dispose = action_destroyer(/*forwardEvents*/ ctx[5].call(null, li));
    				mounted = true;
    			}
    		},
    		p: function update(ctx, dirty) {
    			if (default_slot) {
    				if (default_slot.p && dirty & /*$$scope*/ 1024) {
    					update_slot(default_slot, default_slot_template, ctx, /*$$scope*/ ctx[10], dirty, null, null);
    				}
    			}

    			set_attributes(li, li_data = get_spread_update(li_levels, [
    				/*props*/ ctx[6],
    				(!current || dirty & /*classes*/ 16) && { class: /*classes*/ ctx[4] },
    				(!current || dirty & /*disabled*/ 2) && { disabled: /*disabled*/ ctx[1] },
    				(!current || dirty & /*active*/ 1) && { active: /*active*/ ctx[0] }
    			]));
    		},
    		i: function intro(local) {
    			if (current) return;
    			transition_in(default_slot, local);
    			current = true;
    		},
    		o: function outro(local) {
    			transition_out(default_slot, local);
    			current = false;
    		},
    		d: function destroy(detaching) {
    			if (detaching) detach_dev(li);
    			if (default_slot) default_slot.d(detaching);
    			mounted = false;
    			dispose();
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_else_block$9.name,
    		type: "else",
    		source: "(35:0) {:else}",
    		ctx
    	});

    	return block;
    }

    // (31:27) 
    function create_if_block_1$5(ctx) {
    	let button;
    	let current;
    	let mounted;
    	let dispose;
    	const default_slot_template = /*#slots*/ ctx[11].default;
    	const default_slot = create_slot(default_slot_template, ctx, /*$$scope*/ ctx[10], null);

    	let button_levels = [
    		/*props*/ ctx[6],
    		{ class: /*classes*/ ctx[4] },
    		{ type: "button" },
    		{ disabled: /*disabled*/ ctx[1] },
    		{ active: /*active*/ ctx[0] }
    	];

    	let button_data = {};

    	for (let i = 0; i < button_levels.length; i += 1) {
    		button_data = assign(button_data, button_levels[i]);
    	}

    	const block = {
    		c: function create() {
    			button = element("button");
    			if (default_slot) default_slot.c();
    			set_attributes(button, button_data);
    			add_location(button, file$N, 31, 2, 812);
    		},
    		m: function mount(target, anchor) {
    			insert_dev(target, button, anchor);

    			if (default_slot) {
    				default_slot.m(button, null);
    			}

    			current = true;

    			if (!mounted) {
    				dispose = action_destroyer(/*forwardEvents*/ ctx[5].call(null, button));
    				mounted = true;
    			}
    		},
    		p: function update(ctx, dirty) {
    			if (default_slot) {
    				if (default_slot.p && dirty & /*$$scope*/ 1024) {
    					update_slot(default_slot, default_slot_template, ctx, /*$$scope*/ ctx[10], dirty, null, null);
    				}
    			}

    			set_attributes(button, button_data = get_spread_update(button_levels, [
    				/*props*/ ctx[6],
    				(!current || dirty & /*classes*/ 16) && { class: /*classes*/ ctx[4] },
    				{ type: "button" },
    				(!current || dirty & /*disabled*/ 2) && { disabled: /*disabled*/ ctx[1] },
    				(!current || dirty & /*active*/ 1) && { active: /*active*/ ctx[0] }
    			]));
    		},
    		i: function intro(local) {
    			if (current) return;
    			transition_in(default_slot, local);
    			current = true;
    		},
    		o: function outro(local) {
    			transition_out(default_slot, local);
    			current = false;
    		},
    		d: function destroy(detaching) {
    			if (detaching) detach_dev(button);
    			if (default_slot) default_slot.d(detaching);
    			mounted = false;
    			dispose();
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_if_block_1$5.name,
    		type: "if",
    		source: "(31:27) ",
    		ctx
    	});

    	return block;
    }

    // (27:0) {#if href}
    function create_if_block$c(ctx) {
    	let a;
    	let current;
    	let mounted;
    	let dispose;
    	const default_slot_template = /*#slots*/ ctx[11].default;
    	const default_slot = create_slot(default_slot_template, ctx, /*$$scope*/ ctx[10], null);

    	let a_levels = [
    		/*props*/ ctx[6],
    		{ class: /*classes*/ ctx[4] },
    		{ href: /*href*/ ctx[2] },
    		{ disabled: /*disabled*/ ctx[1] },
    		{ active: /*active*/ ctx[0] }
    	];

    	let a_data = {};

    	for (let i = 0; i < a_levels.length; i += 1) {
    		a_data = assign(a_data, a_levels[i]);
    	}

    	const block = {
    		c: function create() {
    			a = element("a");
    			if (default_slot) default_slot.c();
    			set_attributes(a, a_data);
    			add_location(a, file$N, 27, 2, 687);
    		},
    		m: function mount(target, anchor) {
    			insert_dev(target, a, anchor);

    			if (default_slot) {
    				default_slot.m(a, null);
    			}

    			current = true;

    			if (!mounted) {
    				dispose = action_destroyer(/*forwardEvents*/ ctx[5].call(null, a));
    				mounted = true;
    			}
    		},
    		p: function update(ctx, dirty) {
    			if (default_slot) {
    				if (default_slot.p && dirty & /*$$scope*/ 1024) {
    					update_slot(default_slot, default_slot_template, ctx, /*$$scope*/ ctx[10], dirty, null, null);
    				}
    			}

    			set_attributes(a, a_data = get_spread_update(a_levels, [
    				/*props*/ ctx[6],
    				(!current || dirty & /*classes*/ 16) && { class: /*classes*/ ctx[4] },
    				(!current || dirty & /*href*/ 4) && { href: /*href*/ ctx[2] },
    				(!current || dirty & /*disabled*/ 2) && { disabled: /*disabled*/ ctx[1] },
    				(!current || dirty & /*active*/ 1) && { active: /*active*/ ctx[0] }
    			]));
    		},
    		i: function intro(local) {
    			if (current) return;
    			transition_in(default_slot, local);
    			current = true;
    		},
    		o: function outro(local) {
    			transition_out(default_slot, local);
    			current = false;
    		},
    		d: function destroy(detaching) {
    			if (detaching) detach_dev(a);
    			if (default_slot) default_slot.d(detaching);
    			mounted = false;
    			dispose();
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_if_block$c.name,
    		type: "if",
    		source: "(27:0) {#if href}",
    		ctx
    	});

    	return block;
    }

    function create_fragment$V(ctx) {
    	let current_block_type_index;
    	let if_block;
    	let if_block_anchor;
    	let current;
    	const if_block_creators = [create_if_block$c, create_if_block_1$5, create_else_block$9];
    	const if_blocks = [];

    	function select_block_type(ctx, dirty) {
    		if (/*href*/ ctx[2]) return 0;
    		if (/*tag*/ ctx[3] === "button") return 1;
    		return 2;
    	}

    	current_block_type_index = select_block_type(ctx);
    	if_block = if_blocks[current_block_type_index] = if_block_creators[current_block_type_index](ctx);

    	const block = {
    		c: function create() {
    			if_block.c();
    			if_block_anchor = empty();
    		},
    		l: function claim(nodes) {
    			throw new Error("options.hydrate only works if the component was compiled with the `hydratable: true` option");
    		},
    		m: function mount(target, anchor) {
    			if_blocks[current_block_type_index].m(target, anchor);
    			insert_dev(target, if_block_anchor, anchor);
    			current = true;
    		},
    		p: function update(ctx, [dirty]) {
    			let previous_block_index = current_block_type_index;
    			current_block_type_index = select_block_type(ctx);

    			if (current_block_type_index === previous_block_index) {
    				if_blocks[current_block_type_index].p(ctx, dirty);
    			} else {
    				group_outros();

    				transition_out(if_blocks[previous_block_index], 1, 1, () => {
    					if_blocks[previous_block_index] = null;
    				});

    				check_outros();
    				if_block = if_blocks[current_block_type_index];

    				if (!if_block) {
    					if_block = if_blocks[current_block_type_index] = if_block_creators[current_block_type_index](ctx);
    					if_block.c();
    				} else {
    					if_block.p(ctx, dirty);
    				}

    				transition_in(if_block, 1);
    				if_block.m(if_block_anchor.parentNode, if_block_anchor);
    			}
    		},
    		i: function intro(local) {
    			if (current) return;
    			transition_in(if_block);
    			current = true;
    		},
    		o: function outro(local) {
    			transition_out(if_block);
    			current = false;
    		},
    		d: function destroy(detaching) {
    			if_blocks[current_block_type_index].d(detaching);
    			if (detaching) detach_dev(if_block_anchor);
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_fragment$V.name,
    		type: "component",
    		source: "",
    		ctx
    	});

    	return block;
    }

    function instance$V($$self, $$props, $$invalidate) {
    	let classes;
    	let { $$slots: slots = {}, $$scope } = $$props;
    	validate_slots("MDBListGroupItem", slots, ['default']);
    	const forwardEvents = forwardEventsBuilder(current_component);
    	let { class: className = "" } = $$props;
    	let { active = false } = $$props;
    	let { disabled = false } = $$props;
    	let { color = "" } = $$props;
    	let { action = false } = $$props;
    	let { href = null } = $$props;
    	let { tag = null } = $$props;
    	const props = clean$1($$props);

    	$$self.$$set = $$new_props => {
    		$$invalidate(12, $$props = assign(assign({}, $$props), exclude_internal_props($$new_props)));
    		if ("class" in $$new_props) $$invalidate(7, className = $$new_props.class);
    		if ("active" in $$new_props) $$invalidate(0, active = $$new_props.active);
    		if ("disabled" in $$new_props) $$invalidate(1, disabled = $$new_props.disabled);
    		if ("color" in $$new_props) $$invalidate(8, color = $$new_props.color);
    		if ("action" in $$new_props) $$invalidate(9, action = $$new_props.action);
    		if ("href" in $$new_props) $$invalidate(2, href = $$new_props.href);
    		if ("tag" in $$new_props) $$invalidate(3, tag = $$new_props.tag);
    		if ("$$scope" in $$new_props) $$invalidate(10, $$scope = $$new_props.$$scope);
    	};

    	$$self.$capture_state = () => ({
    		clean: clean$1,
    		clsx,
    		forwardEventsBuilder,
    		current_component,
    		forwardEvents,
    		className,
    		active,
    		disabled,
    		color,
    		action,
    		href,
    		tag,
    		props,
    		classes
    	});

    	$$self.$inject_state = $$new_props => {
    		$$invalidate(12, $$props = assign(assign({}, $$props), $$new_props));
    		if ("className" in $$props) $$invalidate(7, className = $$new_props.className);
    		if ("active" in $$props) $$invalidate(0, active = $$new_props.active);
    		if ("disabled" in $$props) $$invalidate(1, disabled = $$new_props.disabled);
    		if ("color" in $$props) $$invalidate(8, color = $$new_props.color);
    		if ("action" in $$props) $$invalidate(9, action = $$new_props.action);
    		if ("href" in $$props) $$invalidate(2, href = $$new_props.href);
    		if ("tag" in $$props) $$invalidate(3, tag = $$new_props.tag);
    		if ("classes" in $$props) $$invalidate(4, classes = $$new_props.classes);
    	};

    	if ($$props && "$$inject" in $$props) {
    		$$self.$inject_state($$props.$$inject);
    	}

    	$$self.$$.update = () => {
    		if ($$self.$$.dirty & /*className, active, disabled, action, color*/ 899) {
    			$$invalidate(4, classes = clsx(className, active ? "active" : false, disabled ? "disabled" : false, action ? "list-group-item-action" : false, color ? `list-group-item-${color}` : false, "list-group-item"));
    		}
    	};

    	$$props = exclude_internal_props($$props);

    	return [
    		active,
    		disabled,
    		href,
    		tag,
    		classes,
    		forwardEvents,
    		props,
    		className,
    		color,
    		action,
    		$$scope,
    		slots
    	];
    }

    class MDBListGroupItem extends SvelteComponentDev {
    	constructor(options) {
    		super(options);

    		init(this, options, instance$V, create_fragment$V, safe_not_equal, {
    			class: 7,
    			active: 0,
    			disabled: 1,
    			color: 8,
    			action: 9,
    			href: 2,
    			tag: 3
    		});

    		dispatch_dev("SvelteRegisterComponent", {
    			component: this,
    			tagName: "MDBListGroupItem",
    			options,
    			id: create_fragment$V.name
    		});
    	}

    	get class() {
    		throw new Error("<MDBListGroupItem>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	set class(value) {
    		throw new Error("<MDBListGroupItem>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	get active() {
    		throw new Error("<MDBListGroupItem>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	set active(value) {
    		throw new Error("<MDBListGroupItem>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	get disabled() {
    		throw new Error("<MDBListGroupItem>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	set disabled(value) {
    		throw new Error("<MDBListGroupItem>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	get color() {
    		throw new Error("<MDBListGroupItem>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	set color(value) {
    		throw new Error("<MDBListGroupItem>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	get action() {
    		throw new Error("<MDBListGroupItem>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	set action(value) {
    		throw new Error("<MDBListGroupItem>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	get href() {
    		throw new Error("<MDBListGroupItem>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	set href(value) {
    		throw new Error("<MDBListGroupItem>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	get tag() {
    		throw new Error("<MDBListGroupItem>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	set tag(value) {
    		throw new Error("<MDBListGroupItem>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}
    }

    /* node_modules/mdbsvelte/src/MDBIcon.svelte generated by Svelte v3.37.0 */
    const file$M = "node_modules/mdbsvelte/src/MDBIcon.svelte";

    function create_fragment$U(ctx) {
    	let i;
    	let current;
    	let mounted;
    	let dispose;
    	const default_slot_template = /*#slots*/ ctx[11].default;
    	const default_slot = create_slot(default_slot_template, ctx, /*$$scope*/ ctx[10], null);
    	let i_levels = [/*props*/ ctx[2], { class: /*classes*/ ctx[0] }];
    	let i_data = {};

    	for (let i = 0; i < i_levels.length; i += 1) {
    		i_data = assign(i_data, i_levels[i]);
    	}

    	const block = {
    		c: function create() {
    			i = element("i");
    			if (default_slot) default_slot.c();
    			set_attributes(i, i_data);
    			add_location(i, file$M, 26, 0, 634);
    		},
    		l: function claim(nodes) {
    			throw new Error("options.hydrate only works if the component was compiled with the `hydratable: true` option");
    		},
    		m: function mount(target, anchor) {
    			insert_dev(target, i, anchor);

    			if (default_slot) {
    				default_slot.m(i, null);
    			}

    			current = true;

    			if (!mounted) {
    				dispose = action_destroyer(/*forwardEvents*/ ctx[1].call(null, i));
    				mounted = true;
    			}
    		},
    		p: function update(ctx, [dirty]) {
    			if (default_slot) {
    				if (default_slot.p && dirty & /*$$scope*/ 1024) {
    					update_slot(default_slot, default_slot_template, ctx, /*$$scope*/ ctx[10], dirty, null, null);
    				}
    			}

    			set_attributes(i, i_data = get_spread_update(i_levels, [
    				/*props*/ ctx[2],
    				(!current || dirty & /*classes*/ 1) && { class: /*classes*/ ctx[0] }
    			]));
    		},
    		i: function intro(local) {
    			if (current) return;
    			transition_in(default_slot, local);
    			current = true;
    		},
    		o: function outro(local) {
    			transition_out(default_slot, local);
    			current = false;
    		},
    		d: function destroy(detaching) {
    			if (detaching) detach_dev(i);
    			if (default_slot) default_slot.d(detaching);
    			mounted = false;
    			dispose();
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_fragment$U.name,
    		type: "component",
    		source: "",
    		ctx
    	});

    	return block;
    }

    function instance$U($$self, $$props, $$invalidate) {
    	let classes;
    	let { $$slots: slots = {}, $$scope } = $$props;
    	validate_slots("MDBIcon", slots, ['default']);
    	const forwardEvents = forwardEventsBuilder(current_component);
    	let { class: className = "" } = $$props;
    	let { icon } = $$props;
    	let { size } = $$props;
    	const props = clean$1($$props, ["size"]);
    	let { type } = $$props;
    	let { far } = $$props;
    	let { fas } = $$props;
    	let { fab } = $$props;

    	$$self.$$set = $$new_props => {
    		$$invalidate(12, $$props = assign(assign({}, $$props), exclude_internal_props($$new_props)));
    		if ("class" in $$new_props) $$invalidate(3, className = $$new_props.class);
    		if ("icon" in $$new_props) $$invalidate(4, icon = $$new_props.icon);
    		if ("size" in $$new_props) $$invalidate(5, size = $$new_props.size);
    		if ("type" in $$new_props) $$invalidate(6, type = $$new_props.type);
    		if ("far" in $$new_props) $$invalidate(7, far = $$new_props.far);
    		if ("fas" in $$new_props) $$invalidate(8, fas = $$new_props.fas);
    		if ("fab" in $$new_props) $$invalidate(9, fab = $$new_props.fab);
    		if ("$$scope" in $$new_props) $$invalidate(10, $$scope = $$new_props.$$scope);
    	};

    	$$self.$capture_state = () => ({
    		clean: clean$1,
    		clsx,
    		forwardEventsBuilder,
    		current_component,
    		forwardEvents,
    		className,
    		icon,
    		size,
    		props,
    		type,
    		far,
    		fas,
    		fab,
    		classes
    	});

    	$$self.$inject_state = $$new_props => {
    		$$invalidate(12, $$props = assign(assign({}, $$props), $$new_props));
    		if ("className" in $$props) $$invalidate(3, className = $$new_props.className);
    		if ("icon" in $$props) $$invalidate(4, icon = $$new_props.icon);
    		if ("size" in $$props) $$invalidate(5, size = $$new_props.size);
    		if ("type" in $$props) $$invalidate(6, type = $$new_props.type);
    		if ("far" in $$props) $$invalidate(7, far = $$new_props.far);
    		if ("fas" in $$props) $$invalidate(8, fas = $$new_props.fas);
    		if ("fab" in $$props) $$invalidate(9, fab = $$new_props.fab);
    		if ("classes" in $$props) $$invalidate(0, classes = $$new_props.classes);
    	};

    	if ($$props && "$$inject" in $$props) {
    		$$self.$inject_state($$props.$$inject);
    	}

    	$$self.$$.update = () => {
    		if ($$self.$$.dirty & /*className, fas, type, fab, far, icon, size*/ 1016) {
    			$$invalidate(0, classes = clsx(
    				className,
    				{
    					"fas": fas | !type & !fab & !far | type === "fas",
    					"fab": fab | type === "fab",
    					"far": far | type === "far"
    				},
    				icon ? `fa-${icon}` : null,
    				size ? `fa-${size}` : null
    			));
    		}
    	};

    	$$props = exclude_internal_props($$props);

    	return [
    		classes,
    		forwardEvents,
    		props,
    		className,
    		icon,
    		size,
    		type,
    		far,
    		fas,
    		fab,
    		$$scope,
    		slots
    	];
    }

    class MDBIcon extends SvelteComponentDev {
    	constructor(options) {
    		super(options);

    		init(this, options, instance$U, create_fragment$U, safe_not_equal, {
    			class: 3,
    			icon: 4,
    			size: 5,
    			type: 6,
    			far: 7,
    			fas: 8,
    			fab: 9
    		});

    		dispatch_dev("SvelteRegisterComponent", {
    			component: this,
    			tagName: "MDBIcon",
    			options,
    			id: create_fragment$U.name
    		});

    		const { ctx } = this.$$;
    		const props = options.props || {};

    		if (/*icon*/ ctx[4] === undefined && !("icon" in props)) {
    			console.warn("<MDBIcon> was created without expected prop 'icon'");
    		}

    		if (/*size*/ ctx[5] === undefined && !("size" in props)) {
    			console.warn("<MDBIcon> was created without expected prop 'size'");
    		}

    		if (/*type*/ ctx[6] === undefined && !("type" in props)) {
    			console.warn("<MDBIcon> was created without expected prop 'type'");
    		}

    		if (/*far*/ ctx[7] === undefined && !("far" in props)) {
    			console.warn("<MDBIcon> was created without expected prop 'far'");
    		}

    		if (/*fas*/ ctx[8] === undefined && !("fas" in props)) {
    			console.warn("<MDBIcon> was created without expected prop 'fas'");
    		}

    		if (/*fab*/ ctx[9] === undefined && !("fab" in props)) {
    			console.warn("<MDBIcon> was created without expected prop 'fab'");
    		}
    	}

    	get class() {
    		throw new Error("<MDBIcon>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	set class(value) {
    		throw new Error("<MDBIcon>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	get icon() {
    		throw new Error("<MDBIcon>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	set icon(value) {
    		throw new Error("<MDBIcon>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	get size() {
    		throw new Error("<MDBIcon>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	set size(value) {
    		throw new Error("<MDBIcon>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	get type() {
    		throw new Error("<MDBIcon>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	set type(value) {
    		throw new Error("<MDBIcon>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	get far() {
    		throw new Error("<MDBIcon>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	set far(value) {
    		throw new Error("<MDBIcon>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	get fas() {
    		throw new Error("<MDBIcon>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	set fas(value) {
    		throw new Error("<MDBIcon>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	get fab() {
    		throw new Error("<MDBIcon>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	set fab(value) {
    		throw new Error("<MDBIcon>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}
    }

    /* node_modules/mdbsvelte/src/MDBNavLink.svelte generated by Svelte v3.37.0 */
    const file$L = "node_modules/mdbsvelte/src/MDBNavLink.svelte";

    function create_fragment$T(ctx) {
    	let a;
    	let current;
    	let mounted;
    	let dispose;
    	const default_slot_template = /*#slots*/ ctx[10].default;
    	const default_slot = create_slot(default_slot_template, ctx, /*$$scope*/ ctx[9], null);
    	let a_levels = [/*props*/ ctx[3], { href: /*href*/ ctx[0] }, { class: /*classes*/ ctx[1] }];
    	let a_data = {};

    	for (let i = 0; i < a_levels.length; i += 1) {
    		a_data = assign(a_data, a_levels[i]);
    	}

    	const block = {
    		c: function create() {
    			a = element("a");
    			if (default_slot) default_slot.c();
    			set_attributes(a, a_data);
    			add_location(a, file$L, 29, 0, 695);
    		},
    		l: function claim(nodes) {
    			throw new Error("options.hydrate only works if the component was compiled with the `hydratable: true` option");
    		},
    		m: function mount(target, anchor) {
    			insert_dev(target, a, anchor);

    			if (default_slot) {
    				default_slot.m(a, null);
    			}

    			current = true;

    			if (!mounted) {
    				dispose = [
    					action_destroyer(/*forwardEvents*/ ctx[2].call(null, a)),
    					listen_dev(a, "click", /*handleClick*/ ctx[4], false, false, false)
    				];

    				mounted = true;
    			}
    		},
    		p: function update(ctx, [dirty]) {
    			if (default_slot) {
    				if (default_slot.p && dirty & /*$$scope*/ 512) {
    					update_slot(default_slot, default_slot_template, ctx, /*$$scope*/ ctx[9], dirty, null, null);
    				}
    			}

    			set_attributes(a, a_data = get_spread_update(a_levels, [
    				/*props*/ ctx[3],
    				(!current || dirty & /*href*/ 1) && { href: /*href*/ ctx[0] },
    				(!current || dirty & /*classes*/ 2) && { class: /*classes*/ ctx[1] }
    			]));
    		},
    		i: function intro(local) {
    			if (current) return;
    			transition_in(default_slot, local);
    			current = true;
    		},
    		o: function outro(local) {
    			transition_out(default_slot, local);
    			current = false;
    		},
    		d: function destroy(detaching) {
    			if (detaching) detach_dev(a);
    			if (default_slot) default_slot.d(detaching);
    			mounted = false;
    			run_all(dispose);
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_fragment$T.name,
    		type: "component",
    		source: "",
    		ctx
    	});

    	return block;
    }

    function instance$T($$self, $$props, $$invalidate) {
    	let classes;
    	let { $$slots: slots = {}, $$scope } = $$props;
    	validate_slots("MDBNavLink", slots, ['default']);
    	const forwardEvents = forwardEventsBuilder(current_component);
    	let { class: className = "" } = $$props;
    	let { disabled = false } = $$props;
    	let { active = false } = $$props;
    	let { href = "#" } = $$props;
    	let { activeClassName = "active" } = $$props;
    	const props = clean$1($$props);

    	function handleClick(e) {
    		if (disabled) {
    			e.preventDefault();
    			e.stopImmediatePropagation();
    			return;
    		}

    		if (href === "#") {
    			e.preventDefault();
    		}
    	}

    	$$self.$$set = $$new_props => {
    		$$invalidate(11, $$props = assign(assign({}, $$props), exclude_internal_props($$new_props)));
    		if ("class" in $$new_props) $$invalidate(5, className = $$new_props.class);
    		if ("disabled" in $$new_props) $$invalidate(6, disabled = $$new_props.disabled);
    		if ("active" in $$new_props) $$invalidate(7, active = $$new_props.active);
    		if ("href" in $$new_props) $$invalidate(0, href = $$new_props.href);
    		if ("activeClassName" in $$new_props) $$invalidate(8, activeClassName = $$new_props.activeClassName);
    		if ("$$scope" in $$new_props) $$invalidate(9, $$scope = $$new_props.$$scope);
    	};

    	$$self.$capture_state = () => ({
    		clean: clean$1,
    		clsx,
    		forwardEventsBuilder,
    		current_component,
    		forwardEvents,
    		className,
    		disabled,
    		active,
    		href,
    		activeClassName,
    		props,
    		handleClick,
    		classes
    	});

    	$$self.$inject_state = $$new_props => {
    		$$invalidate(11, $$props = assign(assign({}, $$props), $$new_props));
    		if ("className" in $$props) $$invalidate(5, className = $$new_props.className);
    		if ("disabled" in $$props) $$invalidate(6, disabled = $$new_props.disabled);
    		if ("active" in $$props) $$invalidate(7, active = $$new_props.active);
    		if ("href" in $$props) $$invalidate(0, href = $$new_props.href);
    		if ("activeClassName" in $$props) $$invalidate(8, activeClassName = $$new_props.activeClassName);
    		if ("classes" in $$props) $$invalidate(1, classes = $$new_props.classes);
    	};

    	if ($$props && "$$inject" in $$props) {
    		$$self.$inject_state($$props.$$inject);
    	}

    	$$self.$$.update = () => {
    		if ($$self.$$.dirty & /*className, disabled, active, activeClassName*/ 480) {
    			$$invalidate(1, classes = clsx(className, "nav-link", { disabled }, active ? activeClassName : false));
    		}
    	};

    	$$props = exclude_internal_props($$props);

    	return [
    		href,
    		classes,
    		forwardEvents,
    		props,
    		handleClick,
    		className,
    		disabled,
    		active,
    		activeClassName,
    		$$scope,
    		slots
    	];
    }

    class MDBNavLink extends SvelteComponentDev {
    	constructor(options) {
    		super(options);

    		init(this, options, instance$T, create_fragment$T, safe_not_equal, {
    			class: 5,
    			disabled: 6,
    			active: 7,
    			href: 0,
    			activeClassName: 8
    		});

    		dispatch_dev("SvelteRegisterComponent", {
    			component: this,
    			tagName: "MDBNavLink",
    			options,
    			id: create_fragment$T.name
    		});
    	}

    	get class() {
    		throw new Error("<MDBNavLink>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	set class(value) {
    		throw new Error("<MDBNavLink>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	get disabled() {
    		throw new Error("<MDBNavLink>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	set disabled(value) {
    		throw new Error("<MDBNavLink>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	get active() {
    		throw new Error("<MDBNavLink>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	set active(value) {
    		throw new Error("<MDBNavLink>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	get href() {
    		throw new Error("<MDBNavLink>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	set href(value) {
    		throw new Error("<MDBNavLink>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	get activeClassName() {
    		throw new Error("<MDBNavLink>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	set activeClassName(value) {
    		throw new Error("<MDBNavLink>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}
    }

    /* src/components/_shared/SideNavigation.svelte generated by Svelte v3.37.0 */
    const file$K = "src/components/_shared/SideNavigation.svelte";

    // (12:0) {#if isOpen}
    function create_if_block$b(ctx) {
    	let div;
    	let a;
    	let img;
    	let img_src_value;
    	let t;
    	let mdblistgroup;
    	let current;

    	mdblistgroup = new MDBListGroup({
    			props: {
    				class: "list-group-flush",
    				$$slots: { default: [create_default_slot$e] },
    				$$scope: { ctx }
    			},
    			$$inline: true
    		});

    	const block = {
    		c: function create() {
    			div = element("div");
    			a = element("a");
    			img = element("img");
    			t = space();
    			create_component(mdblistgroup.$$.fragment);
    			attr_dev(img, "alt", "MDB React Logo");
    			attr_dev(img, "class", "img-fluid");
    			if (img.src !== (img_src_value = "mdbsvelte.png")) attr_dev(img, "src", img_src_value);
    			add_location(img, file$K, 14, 6, 483);
    			attr_dev(a, "href", "#!");
    			attr_dev(a, "class", "logo-wrapper waves-effect");
    			add_location(a, file$K, 13, 4, 429);
    			attr_dev(div, "class", "sidebar-fixed position-fixed");
    			add_location(div, file$K, 12, 2, 382);
    		},
    		m: function mount(target, anchor) {
    			insert_dev(target, div, anchor);
    			append_dev(div, a);
    			append_dev(a, img);
    			append_dev(div, t);
    			mount_component(mdblistgroup, div, null);
    			current = true;
    		},
    		p: function update(ctx, dirty) {
    			const mdblistgroup_changes = {};

    			if (dirty & /*$$scope, segment*/ 5) {
    				mdblistgroup_changes.$$scope = { dirty, ctx };
    			}

    			mdblistgroup.$set(mdblistgroup_changes);
    		},
    		i: function intro(local) {
    			if (current) return;
    			transition_in(mdblistgroup.$$.fragment, local);
    			current = true;
    		},
    		o: function outro(local) {
    			transition_out(mdblistgroup.$$.fragment, local);
    			current = false;
    		},
    		d: function destroy(detaching) {
    			if (detaching) detach_dev(div);
    			destroy_component(mdblistgroup);
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_if_block$b.name,
    		type: "if",
    		source: "(12:0) {#if isOpen}",
    		ctx
    	});

    	return block;
    }

    // (20:10) <MDBListGroupItem>
    function create_default_slot_12$9(ctx) {
    	let mdbicon;
    	let t0;
    	let span;
    	let current;

    	mdbicon = new MDBIcon({
    			props: { icon: "chart-pie", class: "mr-3" },
    			$$inline: true
    		});

    	const block = {
    		c: function create() {
    			create_component(mdbicon.$$.fragment);
    			t0 = space();
    			span = element("span");
    			span.textContent = "Dashboard";
    			add_location(span, file$K, 21, 12, 807);
    		},
    		m: function mount(target, anchor) {
    			mount_component(mdbicon, target, anchor);
    			insert_dev(target, t0, anchor);
    			insert_dev(target, span, anchor);
    			current = true;
    		},
    		p: noop,
    		i: function intro(local) {
    			if (current) return;
    			transition_in(mdbicon.$$.fragment, local);
    			current = true;
    		},
    		o: function outro(local) {
    			transition_out(mdbicon.$$.fragment, local);
    			current = false;
    		},
    		d: function destroy(detaching) {
    			destroy_component(mdbicon, detaching);
    			if (detaching) detach_dev(t0);
    			if (detaching) detach_dev(span);
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_default_slot_12$9.name,
    		type: "slot",
    		source: "(20:10) <MDBListGroupItem>",
    		ctx
    	});

    	return block;
    }

    // (19:8) <Navigate to="home">
    function create_default_slot_11$9(ctx) {
    	let mdblistgroupitem;
    	let current;

    	mdblistgroupitem = new MDBListGroupItem({
    			props: {
    				$$slots: { default: [create_default_slot_12$9] },
    				$$scope: { ctx }
    			},
    			$$inline: true
    		});

    	const block = {
    		c: function create() {
    			create_component(mdblistgroupitem.$$.fragment);
    		},
    		m: function mount(target, anchor) {
    			mount_component(mdblistgroupitem, target, anchor);
    			current = true;
    		},
    		p: function update(ctx, dirty) {
    			const mdblistgroupitem_changes = {};

    			if (dirty & /*$$scope*/ 4) {
    				mdblistgroupitem_changes.$$scope = { dirty, ctx };
    			}

    			mdblistgroupitem.$set(mdblistgroupitem_changes);
    		},
    		i: function intro(local) {
    			if (current) return;
    			transition_in(mdblistgroupitem.$$.fragment, local);
    			current = true;
    		},
    		o: function outro(local) {
    			transition_out(mdblistgroupitem.$$.fragment, local);
    			current = false;
    		},
    		d: function destroy(detaching) {
    			destroy_component(mdblistgroupitem, detaching);
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_default_slot_11$9.name,
    		type: "slot",
    		source: "(19:8) <Navigate to=\\\"home\\\">",
    		ctx
    	});

    	return block;
    }

    // (18:6) <MDBNavLink active={segment === undefined} activeClassName="activeClass">
    function create_default_slot_10$a(ctx) {
    	let navigate;
    	let current;

    	navigate = new Navigate({
    			props: {
    				to: "home",
    				$$slots: { default: [create_default_slot_11$9] },
    				$$scope: { ctx }
    			},
    			$$inline: true
    		});

    	const block = {
    		c: function create() {
    			create_component(navigate.$$.fragment);
    		},
    		m: function mount(target, anchor) {
    			mount_component(navigate, target, anchor);
    			current = true;
    		},
    		p: function update(ctx, dirty) {
    			const navigate_changes = {};

    			if (dirty & /*$$scope*/ 4) {
    				navigate_changes.$$scope = { dirty, ctx };
    			}

    			navigate.$set(navigate_changes);
    		},
    		i: function intro(local) {
    			if (current) return;
    			transition_in(navigate.$$.fragment, local);
    			current = true;
    		},
    		o: function outro(local) {
    			transition_out(navigate.$$.fragment, local);
    			current = false;
    		},
    		d: function destroy(detaching) {
    			destroy_component(navigate, detaching);
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_default_slot_10$a.name,
    		type: "slot",
    		source: "(18:6) <MDBNavLink active={segment === undefined} activeClassName=\\\"activeClass\\\">",
    		ctx
    	});

    	return block;
    }

    // (31:10) <MDBListGroupItem>
    function create_default_slot_9$a(ctx) {
    	let mdbicon;
    	let t0;
    	let span;
    	let current;

    	mdbicon = new MDBIcon({
    			props: { icon: "table", class: "mr-3" },
    			$$inline: true
    		});

    	const block = {
    		c: function create() {
    			create_component(mdbicon.$$.fragment);
    			t0 = space();
    			span = element("span");
    			span.textContent = "Tables";
    			add_location(span, file$K, 32, 12, 1117);
    		},
    		m: function mount(target, anchor) {
    			mount_component(mdbicon, target, anchor);
    			insert_dev(target, t0, anchor);
    			insert_dev(target, span, anchor);
    			current = true;
    		},
    		p: noop,
    		i: function intro(local) {
    			if (current) return;
    			transition_in(mdbicon.$$.fragment, local);
    			current = true;
    		},
    		o: function outro(local) {
    			transition_out(mdbicon.$$.fragment, local);
    			current = false;
    		},
    		d: function destroy(detaching) {
    			destroy_component(mdbicon, detaching);
    			if (detaching) detach_dev(t0);
    			if (detaching) detach_dev(span);
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_default_slot_9$a.name,
    		type: "slot",
    		source: "(31:10) <MDBListGroupItem>",
    		ctx
    	});

    	return block;
    }

    // (30:8) <Navigate to="table">
    function create_default_slot_8$a(ctx) {
    	let mdblistgroupitem;
    	let current;

    	mdblistgroupitem = new MDBListGroupItem({
    			props: {
    				$$slots: { default: [create_default_slot_9$a] },
    				$$scope: { ctx }
    			},
    			$$inline: true
    		});

    	const block = {
    		c: function create() {
    			create_component(mdblistgroupitem.$$.fragment);
    		},
    		m: function mount(target, anchor) {
    			mount_component(mdblistgroupitem, target, anchor);
    			current = true;
    		},
    		p: function update(ctx, dirty) {
    			const mdblistgroupitem_changes = {};

    			if (dirty & /*$$scope*/ 4) {
    				mdblistgroupitem_changes.$$scope = { dirty, ctx };
    			}

    			mdblistgroupitem.$set(mdblistgroupitem_changes);
    		},
    		i: function intro(local) {
    			if (current) return;
    			transition_in(mdblistgroupitem.$$.fragment, local);
    			current = true;
    		},
    		o: function outro(local) {
    			transition_out(mdblistgroupitem.$$.fragment, local);
    			current = false;
    		},
    		d: function destroy(detaching) {
    			destroy_component(mdblistgroupitem, detaching);
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_default_slot_8$a.name,
    		type: "slot",
    		source: "(30:8) <Navigate to=\\\"table\\\">",
    		ctx
    	});

    	return block;
    }

    // (27:6) <MDBNavLink         active={segment === 'tables'}         activeClassName="activeClass">
    function create_default_slot_7$a(ctx) {
    	let navigate;
    	let current;

    	navigate = new Navigate({
    			props: {
    				to: "table",
    				$$slots: { default: [create_default_slot_8$a] },
    				$$scope: { ctx }
    			},
    			$$inline: true
    		});

    	const block = {
    		c: function create() {
    			create_component(navigate.$$.fragment);
    		},
    		m: function mount(target, anchor) {
    			mount_component(navigate, target, anchor);
    			current = true;
    		},
    		p: function update(ctx, dirty) {
    			const navigate_changes = {};

    			if (dirty & /*$$scope*/ 4) {
    				navigate_changes.$$scope = { dirty, ctx };
    			}

    			navigate.$set(navigate_changes);
    		},
    		i: function intro(local) {
    			if (current) return;
    			transition_in(navigate.$$.fragment, local);
    			current = true;
    		},
    		o: function outro(local) {
    			transition_out(navigate.$$.fragment, local);
    			current = false;
    		},
    		d: function destroy(detaching) {
    			destroy_component(navigate, detaching);
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_default_slot_7$a.name,
    		type: "slot",
    		source: "(27:6) <MDBNavLink         active={segment === 'tables'}         activeClassName=\\\"activeClass\\\">",
    		ctx
    	});

    	return block;
    }

    // (42:8) <MDBListGroupItem>
    function create_default_slot_6$b(ctx) {
    	let mdbicon;
    	let t0;
    	let span;
    	let current;

    	mdbicon = new MDBIcon({
    			props: { icon: "file", class: "mr-3" },
    			$$inline: true
    		});

    	const block = {
    		c: function create() {
    			create_component(mdbicon.$$.fragment);
    			t0 = space();
    			span = element("span");
    			span.textContent = "Forms";
    			add_location(span, file$K, 43, 10, 1410);
    		},
    		m: function mount(target, anchor) {
    			mount_component(mdbicon, target, anchor);
    			insert_dev(target, t0, anchor);
    			insert_dev(target, span, anchor);
    			current = true;
    		},
    		p: noop,
    		i: function intro(local) {
    			if (current) return;
    			transition_in(mdbicon.$$.fragment, local);
    			current = true;
    		},
    		o: function outro(local) {
    			transition_out(mdbicon.$$.fragment, local);
    			current = false;
    		},
    		d: function destroy(detaching) {
    			destroy_component(mdbicon, detaching);
    			if (detaching) detach_dev(t0);
    			if (detaching) detach_dev(span);
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_default_slot_6$b.name,
    		type: "slot",
    		source: "(42:8) <MDBListGroupItem>",
    		ctx
    	});

    	return block;
    }

    // (41:6) <Navigate to="forms">
    function create_default_slot_5$c(ctx) {
    	let mdblistgroupitem;
    	let current;

    	mdblistgroupitem = new MDBListGroupItem({
    			props: {
    				$$slots: { default: [create_default_slot_6$b] },
    				$$scope: { ctx }
    			},
    			$$inline: true
    		});

    	const block = {
    		c: function create() {
    			create_component(mdblistgroupitem.$$.fragment);
    		},
    		m: function mount(target, anchor) {
    			mount_component(mdblistgroupitem, target, anchor);
    			current = true;
    		},
    		p: function update(ctx, dirty) {
    			const mdblistgroupitem_changes = {};

    			if (dirty & /*$$scope*/ 4) {
    				mdblistgroupitem_changes.$$scope = { dirty, ctx };
    			}

    			mdblistgroupitem.$set(mdblistgroupitem_changes);
    		},
    		i: function intro(local) {
    			if (current) return;
    			transition_in(mdblistgroupitem.$$.fragment, local);
    			current = true;
    		},
    		o: function outro(local) {
    			transition_out(mdblistgroupitem.$$.fragment, local);
    			current = false;
    		},
    		d: function destroy(detaching) {
    			destroy_component(mdblistgroupitem, detaching);
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_default_slot_5$c.name,
    		type: "slot",
    		source: "(41:6) <Navigate to=\\\"forms\\\">",
    		ctx
    	});

    	return block;
    }

    // (38:6) <MDBNavLink       active={segment === 'forms'}       activeClassName="activeClass">
    function create_default_slot_4$c(ctx) {
    	let navigate;
    	let current;

    	navigate = new Navigate({
    			props: {
    				to: "forms",
    				$$slots: { default: [create_default_slot_5$c] },
    				$$scope: { ctx }
    			},
    			$$inline: true
    		});

    	const block = {
    		c: function create() {
    			create_component(navigate.$$.fragment);
    		},
    		m: function mount(target, anchor) {
    			mount_component(navigate, target, anchor);
    			current = true;
    		},
    		p: function update(ctx, dirty) {
    			const navigate_changes = {};

    			if (dirty & /*$$scope*/ 4) {
    				navigate_changes.$$scope = { dirty, ctx };
    			}

    			navigate.$set(navigate_changes);
    		},
    		i: function intro(local) {
    			if (current) return;
    			transition_in(navigate.$$.fragment, local);
    			current = true;
    		},
    		o: function outro(local) {
    			transition_out(navigate.$$.fragment, local);
    			current = false;
    		},
    		d: function destroy(detaching) {
    			destroy_component(navigate, detaching);
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_default_slot_4$c.name,
    		type: "slot",
    		source: "(38:6) <MDBNavLink       active={segment === 'forms'}       activeClassName=\\\"activeClass\\\">",
    		ctx
    	});

    	return block;
    }

    // (52:6) <MDBListGroupItem>
    function create_default_slot_3$c(ctx) {
    	let mdbicon;
    	let t0;
    	let span;
    	let current;

    	mdbicon = new MDBIcon({
    			props: { icon: "user", class: "mr-3" },
    			$$inline: true
    		});

    	const block = {
    		c: function create() {
    			create_component(mdbicon.$$.fragment);
    			t0 = space();
    			span = element("span");
    			span.textContent = "Profile";
    			add_location(span, file$K, 53, 8, 1683);
    		},
    		m: function mount(target, anchor) {
    			mount_component(mdbicon, target, anchor);
    			insert_dev(target, t0, anchor);
    			insert_dev(target, span, anchor);
    			current = true;
    		},
    		p: noop,
    		i: function intro(local) {
    			if (current) return;
    			transition_in(mdbicon.$$.fragment, local);
    			current = true;
    		},
    		o: function outro(local) {
    			transition_out(mdbicon.$$.fragment, local);
    			current = false;
    		},
    		d: function destroy(detaching) {
    			destroy_component(mdbicon, detaching);
    			if (detaching) detach_dev(t0);
    			if (detaching) detach_dev(span);
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_default_slot_3$c.name,
    		type: "slot",
    		source: "(52:6) <MDBListGroupItem>",
    		ctx
    	});

    	return block;
    }

    // (51:4) <Navigate to="profile">
    function create_default_slot_2$d(ctx) {
    	let mdblistgroupitem;
    	let current;

    	mdblistgroupitem = new MDBListGroupItem({
    			props: {
    				$$slots: { default: [create_default_slot_3$c] },
    				$$scope: { ctx }
    			},
    			$$inline: true
    		});

    	const block = {
    		c: function create() {
    			create_component(mdblistgroupitem.$$.fragment);
    		},
    		m: function mount(target, anchor) {
    			mount_component(mdblistgroupitem, target, anchor);
    			current = true;
    		},
    		p: function update(ctx, dirty) {
    			const mdblistgroupitem_changes = {};

    			if (dirty & /*$$scope*/ 4) {
    				mdblistgroupitem_changes.$$scope = { dirty, ctx };
    			}

    			mdblistgroupitem.$set(mdblistgroupitem_changes);
    		},
    		i: function intro(local) {
    			if (current) return;
    			transition_in(mdblistgroupitem.$$.fragment, local);
    			current = true;
    		},
    		o: function outro(local) {
    			transition_out(mdblistgroupitem.$$.fragment, local);
    			current = false;
    		},
    		d: function destroy(detaching) {
    			destroy_component(mdblistgroupitem, detaching);
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_default_slot_2$d.name,
    		type: "slot",
    		source: "(51:4) <Navigate to=\\\"profile\\\">",
    		ctx
    	});

    	return block;
    }

    // (48:4) <MDBNavLink     active={segment === 'forms'}     activeClassName="activeClass">
    function create_default_slot_1$d(ctx) {
    	let navigate;
    	let current;

    	navigate = new Navigate({
    			props: {
    				to: "profile",
    				$$slots: { default: [create_default_slot_2$d] },
    				$$scope: { ctx }
    			},
    			$$inline: true
    		});

    	const block = {
    		c: function create() {
    			create_component(navigate.$$.fragment);
    		},
    		m: function mount(target, anchor) {
    			mount_component(navigate, target, anchor);
    			current = true;
    		},
    		p: function update(ctx, dirty) {
    			const navigate_changes = {};

    			if (dirty & /*$$scope*/ 4) {
    				navigate_changes.$$scope = { dirty, ctx };
    			}

    			navigate.$set(navigate_changes);
    		},
    		i: function intro(local) {
    			if (current) return;
    			transition_in(navigate.$$.fragment, local);
    			current = true;
    		},
    		o: function outro(local) {
    			transition_out(navigate.$$.fragment, local);
    			current = false;
    		},
    		d: function destroy(detaching) {
    			destroy_component(navigate, detaching);
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_default_slot_1$d.name,
    		type: "slot",
    		source: "(48:4) <MDBNavLink     active={segment === 'forms'}     activeClassName=\\\"activeClass\\\">",
    		ctx
    	});

    	return block;
    }

    // (17:4) <MDBListGroup class="list-group-flush">
    function create_default_slot$e(ctx) {
    	let mdbnavlink0;
    	let t0;
    	let mdbnavlink1;
    	let t1;
    	let mdbnavlink2;
    	let t2;
    	let mdbnavlink3;
    	let current;

    	mdbnavlink0 = new MDBNavLink({
    			props: {
    				active: /*segment*/ ctx[0] === undefined,
    				activeClassName: "activeClass",
    				$$slots: { default: [create_default_slot_10$a] },
    				$$scope: { ctx }
    			},
    			$$inline: true
    		});

    	mdbnavlink1 = new MDBNavLink({
    			props: {
    				active: /*segment*/ ctx[0] === "tables",
    				activeClassName: "activeClass",
    				$$slots: { default: [create_default_slot_7$a] },
    				$$scope: { ctx }
    			},
    			$$inline: true
    		});

    	mdbnavlink2 = new MDBNavLink({
    			props: {
    				active: /*segment*/ ctx[0] === "forms",
    				activeClassName: "activeClass",
    				$$slots: { default: [create_default_slot_4$c] },
    				$$scope: { ctx }
    			},
    			$$inline: true
    		});

    	mdbnavlink3 = new MDBNavLink({
    			props: {
    				active: /*segment*/ ctx[0] === "forms",
    				activeClassName: "activeClass",
    				$$slots: { default: [create_default_slot_1$d] },
    				$$scope: { ctx }
    			},
    			$$inline: true
    		});

    	const block = {
    		c: function create() {
    			create_component(mdbnavlink0.$$.fragment);
    			t0 = space();
    			create_component(mdbnavlink1.$$.fragment);
    			t1 = space();
    			create_component(mdbnavlink2.$$.fragment);
    			t2 = space();
    			create_component(mdbnavlink3.$$.fragment);
    		},
    		m: function mount(target, anchor) {
    			mount_component(mdbnavlink0, target, anchor);
    			insert_dev(target, t0, anchor);
    			mount_component(mdbnavlink1, target, anchor);
    			insert_dev(target, t1, anchor);
    			mount_component(mdbnavlink2, target, anchor);
    			insert_dev(target, t2, anchor);
    			mount_component(mdbnavlink3, target, anchor);
    			current = true;
    		},
    		p: function update(ctx, dirty) {
    			const mdbnavlink0_changes = {};
    			if (dirty & /*segment*/ 1) mdbnavlink0_changes.active = /*segment*/ ctx[0] === undefined;

    			if (dirty & /*$$scope*/ 4) {
    				mdbnavlink0_changes.$$scope = { dirty, ctx };
    			}

    			mdbnavlink0.$set(mdbnavlink0_changes);
    			const mdbnavlink1_changes = {};
    			if (dirty & /*segment*/ 1) mdbnavlink1_changes.active = /*segment*/ ctx[0] === "tables";

    			if (dirty & /*$$scope*/ 4) {
    				mdbnavlink1_changes.$$scope = { dirty, ctx };
    			}

    			mdbnavlink1.$set(mdbnavlink1_changes);
    			const mdbnavlink2_changes = {};
    			if (dirty & /*segment*/ 1) mdbnavlink2_changes.active = /*segment*/ ctx[0] === "forms";

    			if (dirty & /*$$scope*/ 4) {
    				mdbnavlink2_changes.$$scope = { dirty, ctx };
    			}

    			mdbnavlink2.$set(mdbnavlink2_changes);
    			const mdbnavlink3_changes = {};
    			if (dirty & /*segment*/ 1) mdbnavlink3_changes.active = /*segment*/ ctx[0] === "forms";

    			if (dirty & /*$$scope*/ 4) {
    				mdbnavlink3_changes.$$scope = { dirty, ctx };
    			}

    			mdbnavlink3.$set(mdbnavlink3_changes);
    		},
    		i: function intro(local) {
    			if (current) return;
    			transition_in(mdbnavlink0.$$.fragment, local);
    			transition_in(mdbnavlink1.$$.fragment, local);
    			transition_in(mdbnavlink2.$$.fragment, local);
    			transition_in(mdbnavlink3.$$.fragment, local);
    			current = true;
    		},
    		o: function outro(local) {
    			transition_out(mdbnavlink0.$$.fragment, local);
    			transition_out(mdbnavlink1.$$.fragment, local);
    			transition_out(mdbnavlink2.$$.fragment, local);
    			transition_out(mdbnavlink3.$$.fragment, local);
    			current = false;
    		},
    		d: function destroy(detaching) {
    			destroy_component(mdbnavlink0, detaching);
    			if (detaching) detach_dev(t0);
    			destroy_component(mdbnavlink1, detaching);
    			if (detaching) detach_dev(t1);
    			destroy_component(mdbnavlink2, detaching);
    			if (detaching) detach_dev(t2);
    			destroy_component(mdbnavlink3, detaching);
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_default_slot$e.name,
    		type: "slot",
    		source: "(17:4) <MDBListGroup class=\\\"list-group-flush\\\">",
    		ctx
    	});

    	return block;
    }

    function create_fragment$S(ctx) {
    	let if_block_anchor;
    	let current;
    	let if_block = /*isOpen*/ ctx[1] && create_if_block$b(ctx);

    	const block = {
    		c: function create() {
    			if (if_block) if_block.c();
    			if_block_anchor = empty();
    		},
    		l: function claim(nodes) {
    			throw new Error("options.hydrate only works if the component was compiled with the `hydratable: true` option");
    		},
    		m: function mount(target, anchor) {
    			if (if_block) if_block.m(target, anchor);
    			insert_dev(target, if_block_anchor, anchor);
    			current = true;
    		},
    		p: function update(ctx, [dirty]) {
    			if (/*isOpen*/ ctx[1]) {
    				if (if_block) {
    					if_block.p(ctx, dirty);

    					if (dirty & /*isOpen*/ 2) {
    						transition_in(if_block, 1);
    					}
    				} else {
    					if_block = create_if_block$b(ctx);
    					if_block.c();
    					transition_in(if_block, 1);
    					if_block.m(if_block_anchor.parentNode, if_block_anchor);
    				}
    			} else if (if_block) {
    				group_outros();

    				transition_out(if_block, 1, 1, () => {
    					if_block = null;
    				});

    				check_outros();
    			}
    		},
    		i: function intro(local) {
    			if (current) return;
    			transition_in(if_block);
    			current = true;
    		},
    		o: function outro(local) {
    			transition_out(if_block);
    			current = false;
    		},
    		d: function destroy(detaching) {
    			if (if_block) if_block.d(detaching);
    			if (detaching) detach_dev(if_block_anchor);
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_fragment$S.name,
    		type: "component",
    		source: "",
    		ctx
    	});

    	return block;
    }

    function instance$S($$self, $$props, $$invalidate) {
    	let { $$slots: slots = {}, $$scope } = $$props;
    	validate_slots("SideNavigation", slots, []);
    	let { segment } = $$props;
    	let { isOpen = true } = $$props;
    	const writable_props = ["segment", "isOpen"];

    	Object.keys($$props).forEach(key => {
    		if (!~writable_props.indexOf(key) && key.slice(0, 2) !== "$$") console.warn(`<SideNavigation> was created with unknown prop '${key}'`);
    	});

    	$$self.$$set = $$props => {
    		if ("segment" in $$props) $$invalidate(0, segment = $$props.segment);
    		if ("isOpen" in $$props) $$invalidate(1, isOpen = $$props.isOpen);
    	};

    	$$self.$capture_state = () => ({
    		segment,
    		isOpen,
    		MDBListGroup,
    		MDBListGroupItem,
    		MDBIcon,
    		MDBNavLink,
    		Navigate
    	});

    	$$self.$inject_state = $$props => {
    		if ("segment" in $$props) $$invalidate(0, segment = $$props.segment);
    		if ("isOpen" in $$props) $$invalidate(1, isOpen = $$props.isOpen);
    	};

    	if ($$props && "$$inject" in $$props) {
    		$$self.$inject_state($$props.$$inject);
    	}

    	return [segment, isOpen];
    }

    class SideNavigation extends SvelteComponentDev {
    	constructor(options) {
    		super(options);
    		init(this, options, instance$S, create_fragment$S, safe_not_equal, { segment: 0, isOpen: 1 });

    		dispatch_dev("SvelteRegisterComponent", {
    			component: this,
    			tagName: "SideNavigation",
    			options,
    			id: create_fragment$S.name
    		});

    		const { ctx } = this.$$;
    		const props = options.props || {};

    		if (/*segment*/ ctx[0] === undefined && !("segment" in props)) {
    			console.warn("<SideNavigation> was created without expected prop 'segment'");
    		}
    	}

    	get segment() {
    		throw new Error("<SideNavigation>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	set segment(value) {
    		throw new Error("<SideNavigation>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	get isOpen() {
    		throw new Error("<SideNavigation>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	set isOpen(value) {
    		throw new Error("<SideNavigation>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}
    }

    /* node_modules/mdbsvelte/src/MDBNavbar.svelte generated by Svelte v3.37.0 */
    const file$J = "node_modules/mdbsvelte/src/MDBNavbar.svelte";

    function create_fragment$R(ctx) {
    	let nav;
    	let current;
    	let mounted;
    	let dispose;
    	const default_slot_template = /*#slots*/ ctx[11].default;
    	const default_slot = create_slot(default_slot_template, ctx, /*$$scope*/ ctx[10], null);
    	let nav_levels = [/*props*/ ctx[2], { class: /*classes*/ ctx[0] }];
    	let nav_data = {};

    	for (let i = 0; i < nav_levels.length; i += 1) {
    		nav_data = assign(nav_data, nav_levels[i]);
    	}

    	const block = {
    		c: function create() {
    			nav = element("nav");
    			if (default_slot) default_slot.c();
    			set_attributes(nav, nav_data);
    			add_location(nav, file$J, 36, 0, 879);
    		},
    		l: function claim(nodes) {
    			throw new Error("options.hydrate only works if the component was compiled with the `hydratable: true` option");
    		},
    		m: function mount(target, anchor) {
    			insert_dev(target, nav, anchor);

    			if (default_slot) {
    				default_slot.m(nav, null);
    			}

    			current = true;

    			if (!mounted) {
    				dispose = action_destroyer(/*forwardEvents*/ ctx[1].call(null, nav));
    				mounted = true;
    			}
    		},
    		p: function update(ctx, [dirty]) {
    			if (default_slot) {
    				if (default_slot.p && dirty & /*$$scope*/ 1024) {
    					update_slot(default_slot, default_slot_template, ctx, /*$$scope*/ ctx[10], dirty, null, null);
    				}
    			}

    			set_attributes(nav, nav_data = get_spread_update(nav_levels, [
    				/*props*/ ctx[2],
    				(!current || dirty & /*classes*/ 1) && { class: /*classes*/ ctx[0] }
    			]));
    		},
    		i: function intro(local) {
    			if (current) return;
    			transition_in(default_slot, local);
    			current = true;
    		},
    		o: function outro(local) {
    			transition_out(default_slot, local);
    			current = false;
    		},
    		d: function destroy(detaching) {
    			if (detaching) detach_dev(nav);
    			if (default_slot) default_slot.d(detaching);
    			mounted = false;
    			dispose();
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_fragment$R.name,
    		type: "component",
    		source: "",
    		ctx
    	});

    	return block;
    }

    function getExpandClass(expand) {
    	if (expand === false) {
    		return false;
    	} else if (expand === true || expand === "xs") {
    		return "navbar-expand";
    	}

    	return `navbar-expand-${expand}`;
    }

    function instance$R($$self, $$props, $$invalidate) {
    	let classes;
    	let { $$slots: slots = {}, $$scope } = $$props;
    	validate_slots("MDBNavbar", slots, ['default']);
    	const forwardEvents = forwardEventsBuilder(current_component);
    	let { class: className = "" } = $$props;
    	let { light = false } = $$props;
    	let { dark = false } = $$props;
    	let { fixed = "" } = $$props;
    	let { sticky = "" } = $$props;
    	let { color = "" } = $$props;
    	let { expand = false } = $$props;
    	const props = clean$1($$props);

    	$$self.$$set = $$new_props => {
    		$$invalidate(12, $$props = assign(assign({}, $$props), exclude_internal_props($$new_props)));
    		if ("class" in $$new_props) $$invalidate(3, className = $$new_props.class);
    		if ("light" in $$new_props) $$invalidate(4, light = $$new_props.light);
    		if ("dark" in $$new_props) $$invalidate(5, dark = $$new_props.dark);
    		if ("fixed" in $$new_props) $$invalidate(6, fixed = $$new_props.fixed);
    		if ("sticky" in $$new_props) $$invalidate(7, sticky = $$new_props.sticky);
    		if ("color" in $$new_props) $$invalidate(8, color = $$new_props.color);
    		if ("expand" in $$new_props) $$invalidate(9, expand = $$new_props.expand);
    		if ("$$scope" in $$new_props) $$invalidate(10, $$scope = $$new_props.$$scope);
    	};

    	$$self.$capture_state = () => ({
    		clean: clean$1,
    		clsx,
    		forwardEventsBuilder,
    		current_component,
    		forwardEvents,
    		className,
    		light,
    		dark,
    		fixed,
    		sticky,
    		color,
    		expand,
    		props,
    		getExpandClass,
    		classes
    	});

    	$$self.$inject_state = $$new_props => {
    		$$invalidate(12, $$props = assign(assign({}, $$props), $$new_props));
    		if ("className" in $$props) $$invalidate(3, className = $$new_props.className);
    		if ("light" in $$props) $$invalidate(4, light = $$new_props.light);
    		if ("dark" in $$props) $$invalidate(5, dark = $$new_props.dark);
    		if ("fixed" in $$props) $$invalidate(6, fixed = $$new_props.fixed);
    		if ("sticky" in $$props) $$invalidate(7, sticky = $$new_props.sticky);
    		if ("color" in $$props) $$invalidate(8, color = $$new_props.color);
    		if ("expand" in $$props) $$invalidate(9, expand = $$new_props.expand);
    		if ("classes" in $$props) $$invalidate(0, classes = $$new_props.classes);
    	};

    	if ($$props && "$$inject" in $$props) {
    		$$self.$inject_state($$props.$$inject);
    	}

    	$$self.$$.update = () => {
    		if ($$self.$$.dirty & /*className, expand, light, dark, color, fixed, sticky*/ 1016) {
    			$$invalidate(0, classes = clsx(className, "navbar", getExpandClass(expand), {
    				"navbar-light": light,
    				"navbar-dark": dark,
    				[`${color}`]: color,
    				[`fixed-${fixed}`]: fixed,
    				[`sticky-${sticky}`]: sticky
    			}));
    		}
    	};

    	$$props = exclude_internal_props($$props);

    	return [
    		classes,
    		forwardEvents,
    		props,
    		className,
    		light,
    		dark,
    		fixed,
    		sticky,
    		color,
    		expand,
    		$$scope,
    		slots
    	];
    }

    class MDBNavbar extends SvelteComponentDev {
    	constructor(options) {
    		super(options);

    		init(this, options, instance$R, create_fragment$R, safe_not_equal, {
    			class: 3,
    			light: 4,
    			dark: 5,
    			fixed: 6,
    			sticky: 7,
    			color: 8,
    			expand: 9
    		});

    		dispatch_dev("SvelteRegisterComponent", {
    			component: this,
    			tagName: "MDBNavbar",
    			options,
    			id: create_fragment$R.name
    		});
    	}

    	get class() {
    		throw new Error("<MDBNavbar>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	set class(value) {
    		throw new Error("<MDBNavbar>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	get light() {
    		throw new Error("<MDBNavbar>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	set light(value) {
    		throw new Error("<MDBNavbar>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	get dark() {
    		throw new Error("<MDBNavbar>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	set dark(value) {
    		throw new Error("<MDBNavbar>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	get fixed() {
    		throw new Error("<MDBNavbar>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	set fixed(value) {
    		throw new Error("<MDBNavbar>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	get sticky() {
    		throw new Error("<MDBNavbar>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	set sticky(value) {
    		throw new Error("<MDBNavbar>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	get color() {
    		throw new Error("<MDBNavbar>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	set color(value) {
    		throw new Error("<MDBNavbar>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	get expand() {
    		throw new Error("<MDBNavbar>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	set expand(value) {
    		throw new Error("<MDBNavbar>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}
    }

    /* node_modules/mdbsvelte/src/MDBNavbarBrand.svelte generated by Svelte v3.37.0 */
    const file$I = "node_modules/mdbsvelte/src/MDBNavbarBrand.svelte";

    function create_fragment$Q(ctx) {
    	let a;
    	let current;
    	let mounted;
    	let dispose;
    	const default_slot_template = /*#slots*/ ctx[6].default;
    	const default_slot = create_slot(default_slot_template, ctx, /*$$scope*/ ctx[5], null);
    	let a_levels = [/*props*/ ctx[3], { class: /*classes*/ ctx[1] }, { href: /*href*/ ctx[0] }];
    	let a_data = {};

    	for (let i = 0; i < a_levels.length; i += 1) {
    		a_data = assign(a_data, a_levels[i]);
    	}

    	const block = {
    		c: function create() {
    			a = element("a");
    			if (default_slot) default_slot.c();
    			set_attributes(a, a_data);
    			add_location(a, file$I, 14, 0, 358);
    		},
    		l: function claim(nodes) {
    			throw new Error("options.hydrate only works if the component was compiled with the `hydratable: true` option");
    		},
    		m: function mount(target, anchor) {
    			insert_dev(target, a, anchor);

    			if (default_slot) {
    				default_slot.m(a, null);
    			}

    			current = true;

    			if (!mounted) {
    				dispose = action_destroyer(/*forwardEvents*/ ctx[2].call(null, a));
    				mounted = true;
    			}
    		},
    		p: function update(ctx, [dirty]) {
    			if (default_slot) {
    				if (default_slot.p && dirty & /*$$scope*/ 32) {
    					update_slot(default_slot, default_slot_template, ctx, /*$$scope*/ ctx[5], dirty, null, null);
    				}
    			}

    			set_attributes(a, a_data = get_spread_update(a_levels, [
    				/*props*/ ctx[3],
    				(!current || dirty & /*classes*/ 2) && { class: /*classes*/ ctx[1] },
    				(!current || dirty & /*href*/ 1) && { href: /*href*/ ctx[0] }
    			]));
    		},
    		i: function intro(local) {
    			if (current) return;
    			transition_in(default_slot, local);
    			current = true;
    		},
    		o: function outro(local) {
    			transition_out(default_slot, local);
    			current = false;
    		},
    		d: function destroy(detaching) {
    			if (detaching) detach_dev(a);
    			if (default_slot) default_slot.d(detaching);
    			mounted = false;
    			dispose();
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_fragment$Q.name,
    		type: "component",
    		source: "",
    		ctx
    	});

    	return block;
    }

    function instance$Q($$self, $$props, $$invalidate) {
    	let classes;
    	let { $$slots: slots = {}, $$scope } = $$props;
    	validate_slots("MDBNavbarBrand", slots, ['default']);
    	const forwardEvents = forwardEventsBuilder(current_component);
    	let { class: className = "" } = $$props;
    	let { href = "/" } = $$props;
    	const props = clean$1($$props);

    	$$self.$$set = $$new_props => {
    		$$invalidate(7, $$props = assign(assign({}, $$props), exclude_internal_props($$new_props)));
    		if ("class" in $$new_props) $$invalidate(4, className = $$new_props.class);
    		if ("href" in $$new_props) $$invalidate(0, href = $$new_props.href);
    		if ("$$scope" in $$new_props) $$invalidate(5, $$scope = $$new_props.$$scope);
    	};

    	$$self.$capture_state = () => ({
    		clean: clean$1,
    		clsx,
    		forwardEventsBuilder,
    		current_component,
    		forwardEvents,
    		className,
    		href,
    		props,
    		classes
    	});

    	$$self.$inject_state = $$new_props => {
    		$$invalidate(7, $$props = assign(assign({}, $$props), $$new_props));
    		if ("className" in $$props) $$invalidate(4, className = $$new_props.className);
    		if ("href" in $$props) $$invalidate(0, href = $$new_props.href);
    		if ("classes" in $$props) $$invalidate(1, classes = $$new_props.classes);
    	};

    	if ($$props && "$$inject" in $$props) {
    		$$self.$inject_state($$props.$$inject);
    	}

    	$$self.$$.update = () => {
    		if ($$self.$$.dirty & /*className*/ 16) {
    			$$invalidate(1, classes = clsx(className, "navbar-brand"));
    		}
    	};

    	$$props = exclude_internal_props($$props);
    	return [href, classes, forwardEvents, props, className, $$scope, slots];
    }

    class MDBNavbarBrand extends SvelteComponentDev {
    	constructor(options) {
    		super(options);
    		init(this, options, instance$Q, create_fragment$Q, safe_not_equal, { class: 4, href: 0 });

    		dispatch_dev("SvelteRegisterComponent", {
    			component: this,
    			tagName: "MDBNavbarBrand",
    			options,
    			id: create_fragment$Q.name
    		});
    	}

    	get class() {
    		throw new Error("<MDBNavbarBrand>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	set class(value) {
    		throw new Error("<MDBNavbarBrand>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	get href() {
    		throw new Error("<MDBNavbarBrand>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	set href(value) {
    		throw new Error("<MDBNavbarBrand>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}
    }

    /* node_modules/mdbsvelte/src/MDBNavbarNav.svelte generated by Svelte v3.37.0 */
    const file$H = "node_modules/mdbsvelte/src/MDBNavbarNav.svelte";

    function create_fragment$P(ctx) {
    	let ul;
    	let current;
    	let mounted;
    	let dispose;
    	const default_slot_template = /*#slots*/ ctx[7].default;
    	const default_slot = create_slot(default_slot_template, ctx, /*$$scope*/ ctx[6], null);
    	let ul_levels = [/*props*/ ctx[2], { class: /*elementClasses*/ ctx[0] }];
    	let ul_data = {};

    	for (let i = 0; i < ul_levels.length; i += 1) {
    		ul_data = assign(ul_data, ul_levels[i]);
    	}

    	const block = {
    		c: function create() {
    			ul = element("ul");
    			if (default_slot) default_slot.c();
    			set_attributes(ul, ul_data);
    			add_location(ul, file$H, 15, 0, 453);
    		},
    		l: function claim(nodes) {
    			throw new Error("options.hydrate only works if the component was compiled with the `hydratable: true` option");
    		},
    		m: function mount(target, anchor) {
    			insert_dev(target, ul, anchor);

    			if (default_slot) {
    				default_slot.m(ul, null);
    			}

    			current = true;

    			if (!mounted) {
    				dispose = action_destroyer(/*forwardEvents*/ ctx[1].call(null, ul));
    				mounted = true;
    			}
    		},
    		p: function update(ctx, [dirty]) {
    			if (default_slot) {
    				if (default_slot.p && dirty & /*$$scope*/ 64) {
    					update_slot(default_slot, default_slot_template, ctx, /*$$scope*/ ctx[6], dirty, null, null);
    				}
    			}

    			set_attributes(ul, ul_data = get_spread_update(ul_levels, [
    				/*props*/ ctx[2],
    				(!current || dirty & /*elementClasses*/ 1) && { class: /*elementClasses*/ ctx[0] }
    			]));
    		},
    		i: function intro(local) {
    			if (current) return;
    			transition_in(default_slot, local);
    			current = true;
    		},
    		o: function outro(local) {
    			transition_out(default_slot, local);
    			current = false;
    		},
    		d: function destroy(detaching) {
    			if (detaching) detach_dev(ul);
    			if (default_slot) default_slot.d(detaching);
    			mounted = false;
    			dispose();
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_fragment$P.name,
    		type: "component",
    		source: "",
    		ctx
    	});

    	return block;
    }

    function instance$P($$self, $$props, $$invalidate) {
    	let { $$slots: slots = {}, $$scope } = $$props;
    	validate_slots("MDBNavbarNav", slots, ['default']);
    	const forwardEvents = forwardEventsBuilder(current_component);
    	let { class: className = "" } = $$props;
    	let { right } = $$props;
    	let { left } = $$props;
    	const props = clean$1($$props, ["right", "left"]);
    	let elementClasses;

    	$$self.$$set = $$new_props => {
    		$$invalidate(8, $$props = assign(assign({}, $$props), exclude_internal_props($$new_props)));
    		if ("class" in $$new_props) $$invalidate(3, className = $$new_props.class);
    		if ("right" in $$new_props) $$invalidate(4, right = $$new_props.right);
    		if ("left" in $$new_props) $$invalidate(5, left = $$new_props.left);
    		if ("$$scope" in $$new_props) $$invalidate(6, $$scope = $$new_props.$$scope);
    	};

    	$$self.$capture_state = () => ({
    		clean: clean$1,
    		clsx,
    		forwardEventsBuilder,
    		current_component,
    		forwardEvents,
    		className,
    		right,
    		left,
    		props,
    		elementClasses
    	});

    	$$self.$inject_state = $$new_props => {
    		$$invalidate(8, $$props = assign(assign({}, $$props), $$new_props));
    		if ("className" in $$props) $$invalidate(3, className = $$new_props.className);
    		if ("right" in $$props) $$invalidate(4, right = $$new_props.right);
    		if ("left" in $$props) $$invalidate(5, left = $$new_props.left);
    		if ("elementClasses" in $$props) $$invalidate(0, elementClasses = $$new_props.elementClasses);
    	};

    	if ($$props && "$$inject" in $$props) {
    		$$self.$inject_state($$props.$$inject);
    	}

    	$$self.$$.update = () => {
    		if ($$self.$$.dirty & /*className, right, left*/ 56) {
    			$$invalidate(0, elementClasses = clsx(className, "navbar-nav", { "ml-auto": right, "mr-auto": left }));
    		}
    	};

    	$$props = exclude_internal_props($$props);
    	return [elementClasses, forwardEvents, props, className, right, left, $$scope, slots];
    }

    class MDBNavbarNav extends SvelteComponentDev {
    	constructor(options) {
    		super(options);
    		init(this, options, instance$P, create_fragment$P, safe_not_equal, { class: 3, right: 4, left: 5 });

    		dispatch_dev("SvelteRegisterComponent", {
    			component: this,
    			tagName: "MDBNavbarNav",
    			options,
    			id: create_fragment$P.name
    		});

    		const { ctx } = this.$$;
    		const props = options.props || {};

    		if (/*right*/ ctx[4] === undefined && !("right" in props)) {
    			console.warn("<MDBNavbarNav> was created without expected prop 'right'");
    		}

    		if (/*left*/ ctx[5] === undefined && !("left" in props)) {
    			console.warn("<MDBNavbarNav> was created without expected prop 'left'");
    		}
    	}

    	get class() {
    		throw new Error("<MDBNavbarNav>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	set class(value) {
    		throw new Error("<MDBNavbarNav>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	get right() {
    		throw new Error("<MDBNavbarNav>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	set right(value) {
    		throw new Error("<MDBNavbarNav>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	get left() {
    		throw new Error("<MDBNavbarNav>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	set left(value) {
    		throw new Error("<MDBNavbarNav>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}
    }

    /* node_modules/mdbsvelte/src/MDBNavbarToggler.svelte generated by Svelte v3.37.0 */
    const file$G = "node_modules/mdbsvelte/src/MDBNavbarToggler.svelte";

    // (26:8)      
    function fallback_block$2(ctx) {
    	let span;

    	const block = {
    		c: function create() {
    			span = element("span");
    			attr_dev(span, "class", "navbar-toggler-icon");
    			add_location(span, file$G, 26, 4, 563);
    		},
    		m: function mount(target, anchor) {
    			insert_dev(target, span, anchor);
    		},
    		d: function destroy(detaching) {
    			if (detaching) detach_dev(span);
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: fallback_block$2.name,
    		type: "fallback",
    		source: "(26:8)      ",
    		ctx
    	});

    	return block;
    }

    function create_fragment$O(ctx) {
    	let button;
    	let current;
    	let mounted;
    	let dispose;
    	const default_slot_template = /*#slots*/ ctx[6].default;
    	const default_slot = create_slot(default_slot_template, ctx, /*$$scope*/ ctx[5], null);
    	const default_slot_or_fallback = default_slot || fallback_block$2(ctx);
    	let button_levels = [/*props*/ ctx[1], { class: /*classes*/ ctx[0] }];
    	let button_data = {};

    	for (let i = 0; i < button_levels.length; i += 1) {
    		button_data = assign(button_data, button_levels[i]);
    	}

    	const block = {
    		c: function create() {
    			button = element("button");
    			if (default_slot_or_fallback) default_slot_or_fallback.c();
    			set_attributes(button, button_data);
    			add_location(button, file$G, 24, 0, 505);
    		},
    		l: function claim(nodes) {
    			throw new Error("options.hydrate only works if the component was compiled with the `hydratable: true` option");
    		},
    		m: function mount(target, anchor) {
    			insert_dev(target, button, anchor);

    			if (default_slot_or_fallback) {
    				default_slot_or_fallback.m(button, null);
    			}

    			current = true;

    			if (!mounted) {
    				dispose = listen_dev(button, "click", /*click_handler*/ ctx[7], false, false, false);
    				mounted = true;
    			}
    		},
    		p: function update(ctx, [dirty]) {
    			if (default_slot) {
    				if (default_slot.p && dirty & /*$$scope*/ 32) {
    					update_slot(default_slot, default_slot_template, ctx, /*$$scope*/ ctx[5], dirty, null, null);
    				}
    			}

    			set_attributes(button, button_data = get_spread_update(button_levels, [
    				/*props*/ ctx[1],
    				(!current || dirty & /*classes*/ 1) && { class: /*classes*/ ctx[0] }
    			]));
    		},
    		i: function intro(local) {
    			if (current) return;
    			transition_in(default_slot_or_fallback, local);
    			current = true;
    		},
    		o: function outro(local) {
    			transition_out(default_slot_or_fallback, local);
    			current = false;
    		},
    		d: function destroy(detaching) {
    			if (detaching) detach_dev(button);
    			if (default_slot_or_fallback) default_slot_or_fallback.d(detaching);
    			mounted = false;
    			dispose();
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_fragment$O.name,
    		type: "component",
    		source: "",
    		ctx
    	});

    	return block;
    }

    function instance$O($$self, $$props, $$invalidate) {
    	let { $$slots: slots = {}, $$scope } = $$props;
    	validate_slots("MDBNavbarToggler", slots, ['default']);
    	const forwardEvents = forwardEventsBuilder(current_component);
    	let { class: className = "" } = $$props;
    	let { left } = $$props;
    	let { right } = $$props;
    	const props = clean$1($$props, "left");
    	let classes;

    	function click_handler(event) {
    		bubble($$self, event);
    	}

    	$$self.$$set = $$new_props => {
    		$$invalidate(9, $$props = assign(assign({}, $$props), exclude_internal_props($$new_props)));
    		if ("class" in $$new_props) $$invalidate(2, className = $$new_props.class);
    		if ("left" in $$new_props) $$invalidate(3, left = $$new_props.left);
    		if ("right" in $$new_props) $$invalidate(4, right = $$new_props.right);
    		if ("$$scope" in $$new_props) $$invalidate(5, $$scope = $$new_props.$$scope);
    	};

    	$$self.$capture_state = () => ({
    		clean: clean$1,
    		clsx,
    		forwardEventsBuilder,
    		current_component,
    		forwardEvents,
    		className,
    		left,
    		right,
    		props,
    		classes
    	});

    	$$self.$inject_state = $$new_props => {
    		$$invalidate(9, $$props = assign(assign({}, $$props), $$new_props));
    		if ("className" in $$props) $$invalidate(2, className = $$new_props.className);
    		if ("left" in $$props) $$invalidate(3, left = $$new_props.left);
    		if ("right" in $$props) $$invalidate(4, right = $$new_props.right);
    		if ("classes" in $$props) $$invalidate(0, classes = $$new_props.classes);
    	};

    	if ($$props && "$$inject" in $$props) {
    		$$self.$inject_state($$props.$$inject);
    	}

    	$$self.$$.update = () => {
    		if ($$self.$$.dirty & /*right, left, className*/ 28) {
    			$$invalidate(0, classes = clsx(
    				{
    					"navbar-toggler-right": right,
    					"navbar-toggler-left": left
    				},
    				"navbar-toggler",
    				className
    			));
    		}
    	};

    	$$props = exclude_internal_props($$props);
    	return [classes, props, className, left, right, $$scope, slots, click_handler];
    }

    class MDBNavbarToggler extends SvelteComponentDev {
    	constructor(options) {
    		super(options);
    		init(this, options, instance$O, create_fragment$O, safe_not_equal, { class: 2, left: 3, right: 4 });

    		dispatch_dev("SvelteRegisterComponent", {
    			component: this,
    			tagName: "MDBNavbarToggler",
    			options,
    			id: create_fragment$O.name
    		});

    		const { ctx } = this.$$;
    		const props = options.props || {};

    		if (/*left*/ ctx[3] === undefined && !("left" in props)) {
    			console.warn("<MDBNavbarToggler> was created without expected prop 'left'");
    		}

    		if (/*right*/ ctx[4] === undefined && !("right" in props)) {
    			console.warn("<MDBNavbarToggler> was created without expected prop 'right'");
    		}
    	}

    	get class() {
    		throw new Error("<MDBNavbarToggler>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	set class(value) {
    		throw new Error("<MDBNavbarToggler>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	get left() {
    		throw new Error("<MDBNavbarToggler>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	set left(value) {
    		throw new Error("<MDBNavbarToggler>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	get right() {
    		throw new Error("<MDBNavbarToggler>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	set right(value) {
    		throw new Error("<MDBNavbarToggler>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}
    }

    function cubicOut(t) {
        const f = t - 1.0;
        return f * f * f + 1.0;
    }

    function fade(node, { delay = 0, duration = 400, easing = identity } = {}) {
        const o = +getComputedStyle(node).opacity;
        return {
            delay,
            duration,
            easing,
            css: t => `opacity: ${t * o}`
        };
    }
    function fly(node, { delay = 0, duration = 400, easing = cubicOut, x = 0, y = 0, opacity = 0 } = {}) {
        const style = getComputedStyle(node);
        const target_opacity = +style.opacity;
        const transform = style.transform === 'none' ? '' : style.transform;
        const od = target_opacity * (1 - opacity);
        return {
            delay,
            duration,
            easing,
            css: (t, u) => `
			transform: ${transform} translate(${(1 - t) * x}px, ${(1 - t) * y}px);
			opacity: ${target_opacity - (od * u)}`
        };
    }
    function slide(node, { delay = 0, duration = 400, easing = cubicOut } = {}) {
        const style = getComputedStyle(node);
        const opacity = +style.opacity;
        const height = parseFloat(style.height);
        const padding_top = parseFloat(style.paddingTop);
        const padding_bottom = parseFloat(style.paddingBottom);
        const margin_top = parseFloat(style.marginTop);
        const margin_bottom = parseFloat(style.marginBottom);
        const border_top_width = parseFloat(style.borderTopWidth);
        const border_bottom_width = parseFloat(style.borderBottomWidth);
        return {
            delay,
            duration,
            easing,
            css: t => 'overflow: hidden;' +
                `opacity: ${Math.min(t * 20, 1) * opacity};` +
                `height: ${t * height}px;` +
                `padding-top: ${t * padding_top}px;` +
                `padding-bottom: ${t * padding_bottom}px;` +
                `margin-top: ${t * margin_top}px;` +
                `margin-bottom: ${t * margin_bottom}px;` +
                `border-top-width: ${t * border_top_width}px;` +
                `border-bottom-width: ${t * border_bottom_width}px;`
        };
    }

    /* node_modules/mdbsvelte/src/MDBCollapse.svelte generated by Svelte v3.37.0 */
    const file$F = "node_modules/mdbsvelte/src/MDBCollapse.svelte";

    // (62:0) {#if isOpen}
    function create_if_block$a(ctx) {
    	let div;
    	let div_transition;
    	let current;
    	let mounted;
    	let dispose;
    	const default_slot_template = /*#slots*/ ctx[15].default;
    	const default_slot = create_slot(default_slot_template, ctx, /*$$scope*/ ctx[14], null);
    	let div_levels = [{ class: /*classes*/ ctx[6] }, /*props*/ ctx[8]];
    	let div_data = {};

    	for (let i = 0; i < div_levels.length; i += 1) {
    		div_data = assign(div_data, div_levels[i]);
    	}

    	const block = {
    		c: function create() {
    			div = element("div");
    			if (default_slot) default_slot.c();
    			set_attributes(div, div_data);
    			add_location(div, file$F, 62, 2, 1395);
    		},
    		m: function mount(target, anchor) {
    			insert_dev(target, div, anchor);

    			if (default_slot) {
    				default_slot.m(div, null);
    			}

    			current = true;

    			if (!mounted) {
    				dispose = [
    					listen_dev(
    						div,
    						"introstart",
    						function () {
    							if (is_function(/*onEntering*/ ctx[1])) /*onEntering*/ ctx[1].apply(this, arguments);
    						},
    						false,
    						false,
    						false
    					),
    					listen_dev(
    						div,
    						"introend",
    						function () {
    							if (is_function(/*onEntered*/ ctx[2])) /*onEntered*/ ctx[2].apply(this, arguments);
    						},
    						false,
    						false,
    						false
    					),
    					listen_dev(
    						div,
    						"outrostart",
    						function () {
    							if (is_function(/*onExiting*/ ctx[3])) /*onExiting*/ ctx[3].apply(this, arguments);
    						},
    						false,
    						false,
    						false
    					),
    					listen_dev(
    						div,
    						"outroend",
    						function () {
    							if (is_function(/*onExited*/ ctx[4])) /*onExited*/ ctx[4].apply(this, arguments);
    						},
    						false,
    						false,
    						false
    					),
    					action_destroyer(/*forwardEvents*/ ctx[7].call(null, div))
    				];

    				mounted = true;
    			}
    		},
    		p: function update(new_ctx, dirty) {
    			ctx = new_ctx;

    			if (default_slot) {
    				if (default_slot.p && dirty & /*$$scope*/ 16384) {
    					update_slot(default_slot, default_slot_template, ctx, /*$$scope*/ ctx[14], dirty, null, null);
    				}
    			}

    			set_attributes(div, div_data = get_spread_update(div_levels, [
    				(!current || dirty & /*classes*/ 64) && { class: /*classes*/ ctx[6] },
    				/*props*/ ctx[8]
    			]));
    		},
    		i: function intro(local) {
    			if (current) return;
    			transition_in(default_slot, local);

    			add_render_callback(() => {
    				if (!div_transition) div_transition = create_bidirectional_transition(div, slide, {}, true);
    				div_transition.run(1);
    			});

    			current = true;
    		},
    		o: function outro(local) {
    			transition_out(default_slot, local);
    			if (!div_transition) div_transition = create_bidirectional_transition(div, slide, {}, false);
    			div_transition.run(0);
    			current = false;
    		},
    		d: function destroy(detaching) {
    			if (detaching) detach_dev(div);
    			if (default_slot) default_slot.d(detaching);
    			if (detaching && div_transition) div_transition.end();
    			mounted = false;
    			run_all(dispose);
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_if_block$a.name,
    		type: "if",
    		source: "(62:0) {#if isOpen}",
    		ctx
    	});

    	return block;
    }

    function create_fragment$N(ctx) {
    	let if_block_anchor;
    	let current;
    	let mounted;
    	let dispose;
    	add_render_callback(/*onwindowresize*/ ctx[16]);
    	let if_block = /*isOpen*/ ctx[0] && create_if_block$a(ctx);

    	const block = {
    		c: function create() {
    			if (if_block) if_block.c();
    			if_block_anchor = empty();
    		},
    		l: function claim(nodes) {
    			throw new Error("options.hydrate only works if the component was compiled with the `hydratable: true` option");
    		},
    		m: function mount(target, anchor) {
    			if (if_block) if_block.m(target, anchor);
    			insert_dev(target, if_block_anchor, anchor);
    			current = true;

    			if (!mounted) {
    				dispose = listen_dev(window, "resize", /*onwindowresize*/ ctx[16]);
    				mounted = true;
    			}
    		},
    		p: function update(ctx, [dirty]) {
    			if (/*isOpen*/ ctx[0]) {
    				if (if_block) {
    					if_block.p(ctx, dirty);

    					if (dirty & /*isOpen*/ 1) {
    						transition_in(if_block, 1);
    					}
    				} else {
    					if_block = create_if_block$a(ctx);
    					if_block.c();
    					transition_in(if_block, 1);
    					if_block.m(if_block_anchor.parentNode, if_block_anchor);
    				}
    			} else if (if_block) {
    				group_outros();

    				transition_out(if_block, 1, 1, () => {
    					if_block = null;
    				});

    				check_outros();
    			}
    		},
    		i: function intro(local) {
    			if (current) return;
    			transition_in(if_block);
    			current = true;
    		},
    		o: function outro(local) {
    			transition_out(if_block);
    			current = false;
    		},
    		d: function destroy(detaching) {
    			if (if_block) if_block.d(detaching);
    			if (detaching) detach_dev(if_block_anchor);
    			mounted = false;
    			dispose();
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_fragment$N.name,
    		type: "component",
    		source: "",
    		ctx
    	});

    	return block;
    }

    function instance$N($$self, $$props, $$invalidate) {
    	let classes;
    	let { $$slots: slots = {}, $$scope } = $$props;
    	validate_slots("MDBCollapse", slots, ['default']);
    	const forwardEvents = forwardEventsBuilder(current_component);
    	const noop = () => undefined;
    	let { isOpen = false } = $$props;
    	let { class: className = "" } = $$props;
    	let { navbar = false } = $$props;
    	let { onEntering = noop } = $$props;
    	let { onEntered = noop } = $$props;
    	let { onExiting = noop } = $$props;
    	let { onExited = noop } = $$props;
    	let { expand = false } = $$props;
    	const props = clean$1($$props);
    	let windowWidth = 0;
    	let _wasMaximazed = false;
    	const minWidth = {};
    	minWidth["xs"] = 0;
    	minWidth["sm"] = 576;
    	minWidth["md"] = 768;
    	minWidth["lg"] = 992;
    	minWidth["xl"] = 1200;
    	const dispatch = createEventDispatcher();

    	function notify() {
    		dispatch("update", { isOpen });
    	}

    	function onwindowresize() {
    		$$invalidate(5, windowWidth = window.innerWidth);
    	}

    	$$self.$$set = $$new_props => {
    		$$invalidate(20, $$props = assign(assign({}, $$props), exclude_internal_props($$new_props)));
    		if ("isOpen" in $$new_props) $$invalidate(0, isOpen = $$new_props.isOpen);
    		if ("class" in $$new_props) $$invalidate(9, className = $$new_props.class);
    		if ("navbar" in $$new_props) $$invalidate(10, navbar = $$new_props.navbar);
    		if ("onEntering" in $$new_props) $$invalidate(1, onEntering = $$new_props.onEntering);
    		if ("onEntered" in $$new_props) $$invalidate(2, onEntered = $$new_props.onEntered);
    		if ("onExiting" in $$new_props) $$invalidate(3, onExiting = $$new_props.onExiting);
    		if ("onExited" in $$new_props) $$invalidate(4, onExited = $$new_props.onExited);
    		if ("expand" in $$new_props) $$invalidate(11, expand = $$new_props.expand);
    		if ("$$scope" in $$new_props) $$invalidate(14, $$scope = $$new_props.$$scope);
    	};

    	$$self.$capture_state = () => ({
    		clean: clean$1,
    		clsx,
    		forwardEventsBuilder,
    		current_component,
    		forwardEvents,
    		createEventDispatcher,
    		slide,
    		noop,
    		isOpen,
    		className,
    		navbar,
    		onEntering,
    		onEntered,
    		onExiting,
    		onExited,
    		expand,
    		props,
    		windowWidth,
    		_wasMaximazed,
    		minWidth,
    		dispatch,
    		notify,
    		classes
    	});

    	$$self.$inject_state = $$new_props => {
    		$$invalidate(20, $$props = assign(assign({}, $$props), $$new_props));
    		if ("isOpen" in $$props) $$invalidate(0, isOpen = $$new_props.isOpen);
    		if ("className" in $$props) $$invalidate(9, className = $$new_props.className);
    		if ("navbar" in $$props) $$invalidate(10, navbar = $$new_props.navbar);
    		if ("onEntering" in $$props) $$invalidate(1, onEntering = $$new_props.onEntering);
    		if ("onEntered" in $$props) $$invalidate(2, onEntered = $$new_props.onEntered);
    		if ("onExiting" in $$props) $$invalidate(3, onExiting = $$new_props.onExiting);
    		if ("onExited" in $$props) $$invalidate(4, onExited = $$new_props.onExited);
    		if ("expand" in $$props) $$invalidate(11, expand = $$new_props.expand);
    		if ("windowWidth" in $$props) $$invalidate(5, windowWidth = $$new_props.windowWidth);
    		if ("_wasMaximazed" in $$props) $$invalidate(12, _wasMaximazed = $$new_props._wasMaximazed);
    		if ("classes" in $$props) $$invalidate(6, classes = $$new_props.classes);
    	};

    	if ($$props && "$$inject" in $$props) {
    		$$self.$inject_state($$props.$$inject);
    	}

    	$$self.$$.update = () => {
    		if ($$self.$$.dirty & /*className, navbar*/ 1536) {
    			$$invalidate(6, classes = clsx(className, // collapseClass,
    			navbar && "navbar-collapse"));
    		}

    		if ($$self.$$.dirty & /*navbar, expand, windowWidth, minWidth, isOpen, _wasMaximazed*/ 15393) {
    			if (navbar && expand) {
    				if (windowWidth >= minWidth[expand] && !isOpen) {
    					$$invalidate(0, isOpen = true);
    					$$invalidate(12, _wasMaximazed = true);
    					notify();
    				} else if (windowWidth < minWidth[expand] && _wasMaximazed) {
    					$$invalidate(0, isOpen = false);
    					$$invalidate(12, _wasMaximazed = false);
    					notify();
    				}
    			}
    		}
    	};

    	$$props = exclude_internal_props($$props);

    	return [
    		isOpen,
    		onEntering,
    		onEntered,
    		onExiting,
    		onExited,
    		windowWidth,
    		classes,
    		forwardEvents,
    		props,
    		className,
    		navbar,
    		expand,
    		_wasMaximazed,
    		minWidth,
    		$$scope,
    		slots,
    		onwindowresize
    	];
    }

    class MDBCollapse extends SvelteComponentDev {
    	constructor(options) {
    		super(options);

    		init(this, options, instance$N, create_fragment$N, safe_not_equal, {
    			isOpen: 0,
    			class: 9,
    			navbar: 10,
    			onEntering: 1,
    			onEntered: 2,
    			onExiting: 3,
    			onExited: 4,
    			expand: 11
    		});

    		dispatch_dev("SvelteRegisterComponent", {
    			component: this,
    			tagName: "MDBCollapse",
    			options,
    			id: create_fragment$N.name
    		});
    	}

    	get isOpen() {
    		throw new Error("<MDBCollapse>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	set isOpen(value) {
    		throw new Error("<MDBCollapse>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	get class() {
    		throw new Error("<MDBCollapse>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	set class(value) {
    		throw new Error("<MDBCollapse>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	get navbar() {
    		throw new Error("<MDBCollapse>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	set navbar(value) {
    		throw new Error("<MDBCollapse>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	get onEntering() {
    		throw new Error("<MDBCollapse>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	set onEntering(value) {
    		throw new Error("<MDBCollapse>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	get onEntered() {
    		throw new Error("<MDBCollapse>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	set onEntered(value) {
    		throw new Error("<MDBCollapse>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	get onExiting() {
    		throw new Error("<MDBCollapse>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	set onExiting(value) {
    		throw new Error("<MDBCollapse>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	get onExited() {
    		throw new Error("<MDBCollapse>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	set onExited(value) {
    		throw new Error("<MDBCollapse>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	get expand() {
    		throw new Error("<MDBCollapse>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	set expand(value) {
    		throw new Error("<MDBCollapse>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}
    }

    /* node_modules/mdbsvelte/src/MDBNavItem.svelte generated by Svelte v3.37.0 */
    const file$E = "node_modules/mdbsvelte/src/MDBNavItem.svelte";

    function create_fragment$M(ctx) {
    	let li;
    	let current;
    	let mounted;
    	let dispose;
    	const default_slot_template = /*#slots*/ ctx[7].default;
    	const default_slot = create_slot(default_slot_template, ctx, /*$$scope*/ ctx[6], null);
    	let li_levels = [/*props*/ ctx[2], { class: /*classes*/ ctx[0] }];
    	let li_data = {};

    	for (let i = 0; i < li_levels.length; i += 1) {
    		li_data = assign(li_data, li_levels[i]);
    	}

    	const block = {
    		c: function create() {
    			li = element("li");
    			if (default_slot) default_slot.c();
    			set_attributes(li, li_data);
    			add_location(li, file$E, 16, 0, 435);
    		},
    		l: function claim(nodes) {
    			throw new Error("options.hydrate only works if the component was compiled with the `hydratable: true` option");
    		},
    		m: function mount(target, anchor) {
    			insert_dev(target, li, anchor);

    			if (default_slot) {
    				default_slot.m(li, null);
    			}

    			current = true;

    			if (!mounted) {
    				dispose = action_destroyer(/*forwardEvents*/ ctx[1].call(null, li));
    				mounted = true;
    			}
    		},
    		p: function update(ctx, [dirty]) {
    			if (default_slot) {
    				if (default_slot.p && dirty & /*$$scope*/ 64) {
    					update_slot(default_slot, default_slot_template, ctx, /*$$scope*/ ctx[6], dirty, null, null);
    				}
    			}

    			set_attributes(li, li_data = get_spread_update(li_levels, [
    				/*props*/ ctx[2],
    				(!current || dirty & /*classes*/ 1) && { class: /*classes*/ ctx[0] }
    			]));
    		},
    		i: function intro(local) {
    			if (current) return;
    			transition_in(default_slot, local);
    			current = true;
    		},
    		o: function outro(local) {
    			transition_out(default_slot, local);
    			current = false;
    		},
    		d: function destroy(detaching) {
    			if (detaching) detach_dev(li);
    			if (default_slot) default_slot.d(detaching);
    			mounted = false;
    			dispose();
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_fragment$M.name,
    		type: "component",
    		source: "",
    		ctx
    	});

    	return block;
    }

    function instance$M($$self, $$props, $$invalidate) {
    	let classes;
    	let { $$slots: slots = {}, $$scope } = $$props;
    	validate_slots("MDBNavItem", slots, ['default']);
    	const forwardEvents = forwardEventsBuilder(current_component);
    	let { class: className = "" } = $$props;
    	let { active = false } = $$props;
    	let { activeClassName = "active" } = $$props;
    	const props = clean$1($$props);

    	$$self.$$set = $$new_props => {
    		$$invalidate(8, $$props = assign(assign({}, $$props), exclude_internal_props($$new_props)));
    		if ("class" in $$new_props) $$invalidate(3, className = $$new_props.class);
    		if ("active" in $$new_props) $$invalidate(4, active = $$new_props.active);
    		if ("activeClassName" in $$new_props) $$invalidate(5, activeClassName = $$new_props.activeClassName);
    		if ("$$scope" in $$new_props) $$invalidate(6, $$scope = $$new_props.$$scope);
    	};

    	$$self.$capture_state = () => ({
    		clean: clean$1,
    		clsx,
    		forwardEventsBuilder,
    		current_component,
    		forwardEvents,
    		className,
    		active,
    		activeClassName,
    		props,
    		classes
    	});

    	$$self.$inject_state = $$new_props => {
    		$$invalidate(8, $$props = assign(assign({}, $$props), $$new_props));
    		if ("className" in $$props) $$invalidate(3, className = $$new_props.className);
    		if ("active" in $$props) $$invalidate(4, active = $$new_props.active);
    		if ("activeClassName" in $$props) $$invalidate(5, activeClassName = $$new_props.activeClassName);
    		if ("classes" in $$props) $$invalidate(0, classes = $$new_props.classes);
    	};

    	if ($$props && "$$inject" in $$props) {
    		$$self.$inject_state($$props.$$inject);
    	}

    	$$self.$$.update = () => {
    		if ($$self.$$.dirty & /*className, active, activeClassName*/ 56) {
    			$$invalidate(0, classes = clsx(className, "nav-item", active ? activeClassName : false));
    		}
    	};

    	$$props = exclude_internal_props($$props);

    	return [
    		classes,
    		forwardEvents,
    		props,
    		className,
    		active,
    		activeClassName,
    		$$scope,
    		slots
    	];
    }

    class MDBNavItem extends SvelteComponentDev {
    	constructor(options) {
    		super(options);
    		init(this, options, instance$M, create_fragment$M, safe_not_equal, { class: 3, active: 4, activeClassName: 5 });

    		dispatch_dev("SvelteRegisterComponent", {
    			component: this,
    			tagName: "MDBNavItem",
    			options,
    			id: create_fragment$M.name
    		});
    	}

    	get class() {
    		throw new Error("<MDBNavItem>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	set class(value) {
    		throw new Error("<MDBNavItem>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	get active() {
    		throw new Error("<MDBNavItem>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	set active(value) {
    		throw new Error("<MDBNavItem>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	get activeClassName() {
    		throw new Error("<MDBNavItem>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	set activeClassName(value) {
    		throw new Error("<MDBNavItem>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}
    }

    /* src/components/_shared/TopNavigation.svelte generated by Svelte v3.37.0 */
    const file$D = "src/components/_shared/TopNavigation.svelte";

    // (23:2) <MDBNavbarBrand href="/">
    function create_default_slot_10$9(ctx) {
    	let strong;

    	const block = {
    		c: function create() {
    			strong = element("strong");
    			strong.textContent = "MDB";
    			add_location(strong, file$D, 23, 4, 755);
    		},
    		m: function mount(target, anchor) {
    			insert_dev(target, strong, anchor);
    		},
    		d: function destroy(detaching) {
    			if (detaching) detach_dev(strong);
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_default_slot_10$9.name,
    		type: "slot",
    		source: "(23:2) <MDBNavbarBrand href=\\\"/\\\">",
    		ctx
    	});

    	return block;
    }

    // (30:8) <MDBNavLink to="#">
    function create_default_slot_9$9(ctx) {
    	let t;

    	const block = {
    		c: function create() {
    			t = text("Home");
    		},
    		m: function mount(target, anchor) {
    			insert_dev(target, t, anchor);
    		},
    		d: function destroy(detaching) {
    			if (detaching) detach_dev(t);
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_default_slot_9$9.name,
    		type: "slot",
    		source: "(30:8) <MDBNavLink to=\\\"#\\\">",
    		ctx
    	});

    	return block;
    }

    // (29:6) <MDBNavItem >
    function create_default_slot_8$9(ctx) {
    	let mdbnavlink;
    	let current;

    	mdbnavlink = new MDBNavLink({
    			props: {
    				to: "#",
    				$$slots: { default: [create_default_slot_9$9] },
    				$$scope: { ctx }
    			},
    			$$inline: true
    		});

    	const block = {
    		c: function create() {
    			create_component(mdbnavlink.$$.fragment);
    		},
    		m: function mount(target, anchor) {
    			mount_component(mdbnavlink, target, anchor);
    			current = true;
    		},
    		p: function update(ctx, dirty) {
    			const mdbnavlink_changes = {};

    			if (dirty & /*$$scope*/ 8) {
    				mdbnavlink_changes.$$scope = { dirty, ctx };
    			}

    			mdbnavlink.$set(mdbnavlink_changes);
    		},
    		i: function intro(local) {
    			if (current) return;
    			transition_in(mdbnavlink.$$.fragment, local);
    			current = true;
    		},
    		o: function outro(local) {
    			transition_out(mdbnavlink.$$.fragment, local);
    			current = false;
    		},
    		d: function destroy(detaching) {
    			destroy_component(mdbnavlink, detaching);
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_default_slot_8$9.name,
    		type: "slot",
    		source: "(29:6) <MDBNavItem >",
    		ctx
    	});

    	return block;
    }

    // (28:4) <MDBNavbarNav left>
    function create_default_slot_7$9(ctx) {
    	let mdbnavitem;
    	let current;

    	mdbnavitem = new MDBNavItem({
    			props: {
    				$$slots: { default: [create_default_slot_8$9] },
    				$$scope: { ctx }
    			},
    			$$inline: true
    		});

    	const block = {
    		c: function create() {
    			create_component(mdbnavitem.$$.fragment);
    		},
    		m: function mount(target, anchor) {
    			mount_component(mdbnavitem, target, anchor);
    			current = true;
    		},
    		p: function update(ctx, dirty) {
    			const mdbnavitem_changes = {};

    			if (dirty & /*$$scope*/ 8) {
    				mdbnavitem_changes.$$scope = { dirty, ctx };
    			}

    			mdbnavitem.$set(mdbnavitem_changes);
    		},
    		i: function intro(local) {
    			if (current) return;
    			transition_in(mdbnavitem.$$.fragment, local);
    			current = true;
    		},
    		o: function outro(local) {
    			transition_out(mdbnavitem.$$.fragment, local);
    			current = false;
    		},
    		d: function destroy(detaching) {
    			destroy_component(mdbnavitem, detaching);
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_default_slot_7$9.name,
    		type: "slot",
    		source: "(28:4) <MDBNavbarNav left>",
    		ctx
    	});

    	return block;
    }

    // (34:6) <MDBNavItem>
    function create_default_slot_6$a(ctx) {
    	let a;
    	let mdbicon;
    	let current;

    	mdbicon = new MDBIcon({
    			props: { fab: true, icon: "facebook" },
    			$$inline: true
    		});

    	const block = {
    		c: function create() {
    			a = element("a");
    			create_component(mdbicon.$$.fragment);
    			attr_dev(a, "class", "nav-link navbar-link");
    			attr_dev(a, "rel", "noopener noreferrer");
    			attr_dev(a, "target", "_blank");
    			attr_dev(a, "href", "https://pl-pl.facebook.com/mdbootstrap/");
    			add_location(a, file$D, 34, 8, 1104);
    		},
    		m: function mount(target, anchor) {
    			insert_dev(target, a, anchor);
    			mount_component(mdbicon, a, null);
    			current = true;
    		},
    		p: noop,
    		i: function intro(local) {
    			if (current) return;
    			transition_in(mdbicon.$$.fragment, local);
    			current = true;
    		},
    		o: function outro(local) {
    			transition_out(mdbicon.$$.fragment, local);
    			current = false;
    		},
    		d: function destroy(detaching) {
    			if (detaching) detach_dev(a);
    			destroy_component(mdbicon);
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_default_slot_6$a.name,
    		type: "slot",
    		source: "(34:6) <MDBNavItem>",
    		ctx
    	});

    	return block;
    }

    // (37:6) <MDBNavItem>
    function create_default_slot_5$b(ctx) {
    	let a;
    	let mdbicon;
    	let current;

    	mdbicon = new MDBIcon({
    			props: { fab: true, icon: "twitter" },
    			$$inline: true
    		});

    	const block = {
    		c: function create() {
    			a = element("a");
    			create_component(mdbicon.$$.fragment);
    			attr_dev(a, "class", "nav-link navbar-link");
    			attr_dev(a, "rel", "noopener noreferrer");
    			attr_dev(a, "target", "_blank");
    			attr_dev(a, "href", "https://twitter.com/mdbootstrap");
    			add_location(a, file$D, 37, 8, 1308);
    		},
    		m: function mount(target, anchor) {
    			insert_dev(target, a, anchor);
    			mount_component(mdbicon, a, null);
    			current = true;
    		},
    		p: noop,
    		i: function intro(local) {
    			if (current) return;
    			transition_in(mdbicon.$$.fragment, local);
    			current = true;
    		},
    		o: function outro(local) {
    			transition_out(mdbicon.$$.fragment, local);
    			current = false;
    		},
    		d: function destroy(detaching) {
    			if (detaching) detach_dev(a);
    			destroy_component(mdbicon);
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_default_slot_5$b.name,
    		type: "slot",
    		source: "(37:6) <MDBNavItem>",
    		ctx
    	});

    	return block;
    }

    // (40:6) <MDBNavItem>
    function create_default_slot_4$b(ctx) {
    	let a;
    	let mdbicon;
    	let t;
    	let current;

    	mdbicon = new MDBIcon({
    			props: { fab: true, icon: "github", class: "mr-2" },
    			$$inline: true
    		});

    	const block = {
    		c: function create() {
    			a = element("a");
    			create_component(mdbicon.$$.fragment);
    			t = text("MDB GitHub");
    			attr_dev(a, "class", "border border-light rounded mr-1 nav-link Ripple-parent");
    			attr_dev(a, "rel", "noopener noreferrer");
    			attr_dev(a, "href", "https://github.com/SauravKanchan/mdbsvelte-dashboard");
    			attr_dev(a, "target", "_blank");
    			add_location(a, file$D, 40, 8, 1503);
    		},
    		m: function mount(target, anchor) {
    			insert_dev(target, a, anchor);
    			mount_component(mdbicon, a, null);
    			append_dev(a, t);
    			current = true;
    		},
    		p: noop,
    		i: function intro(local) {
    			if (current) return;
    			transition_in(mdbicon.$$.fragment, local);
    			current = true;
    		},
    		o: function outro(local) {
    			transition_out(mdbicon.$$.fragment, local);
    			current = false;
    		},
    		d: function destroy(detaching) {
    			if (detaching) detach_dev(a);
    			destroy_component(mdbicon);
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_default_slot_4$b.name,
    		type: "slot",
    		source: "(40:6) <MDBNavItem>",
    		ctx
    	});

    	return block;
    }

    // (43:6) <MDBNavItem>
    function create_default_slot_3$b(ctx) {
    	let a;
    	let mdbicon;
    	let t;
    	let current;

    	mdbicon = new MDBIcon({
    			props: { fab: true, icon: "github", class: "mr-2" },
    			$$inline: true
    		});

    	const block = {
    		c: function create() {
    			a = element("a");
    			create_component(mdbicon.$$.fragment);
    			t = text("Go Pro");
    			attr_dev(a, "class", "border border-light rounded mr-1 nav-link Ripple-parent");
    			attr_dev(a, "rel", "noopener noreferrer");
    			attr_dev(a, "href", "https://github.com/SauravKanchan/mdbsvelte");
    			attr_dev(a, "target", "_blank");
    			add_location(a, file$D, 43, 8, 1775);
    		},
    		m: function mount(target, anchor) {
    			insert_dev(target, a, anchor);
    			mount_component(mdbicon, a, null);
    			append_dev(a, t);
    			current = true;
    		},
    		p: noop,
    		i: function intro(local) {
    			if (current) return;
    			transition_in(mdbicon.$$.fragment, local);
    			current = true;
    		},
    		o: function outro(local) {
    			transition_out(mdbicon.$$.fragment, local);
    			current = false;
    		},
    		d: function destroy(detaching) {
    			if (detaching) detach_dev(a);
    			destroy_component(mdbicon);
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_default_slot_3$b.name,
    		type: "slot",
    		source: "(43:6) <MDBNavItem>",
    		ctx
    	});

    	return block;
    }

    // (33:4) <MDBNavbarNav right>
    function create_default_slot_2$c(ctx) {
    	let mdbnavitem0;
    	let t0;
    	let mdbnavitem1;
    	let t1;
    	let mdbnavitem2;
    	let t2;
    	let mdbnavitem3;
    	let current;

    	mdbnavitem0 = new MDBNavItem({
    			props: {
    				$$slots: { default: [create_default_slot_6$a] },
    				$$scope: { ctx }
    			},
    			$$inline: true
    		});

    	mdbnavitem1 = new MDBNavItem({
    			props: {
    				$$slots: { default: [create_default_slot_5$b] },
    				$$scope: { ctx }
    			},
    			$$inline: true
    		});

    	mdbnavitem2 = new MDBNavItem({
    			props: {
    				$$slots: { default: [create_default_slot_4$b] },
    				$$scope: { ctx }
    			},
    			$$inline: true
    		});

    	mdbnavitem3 = new MDBNavItem({
    			props: {
    				$$slots: { default: [create_default_slot_3$b] },
    				$$scope: { ctx }
    			},
    			$$inline: true
    		});

    	const block = {
    		c: function create() {
    			create_component(mdbnavitem0.$$.fragment);
    			t0 = space();
    			create_component(mdbnavitem1.$$.fragment);
    			t1 = space();
    			create_component(mdbnavitem2.$$.fragment);
    			t2 = space();
    			create_component(mdbnavitem3.$$.fragment);
    		},
    		m: function mount(target, anchor) {
    			mount_component(mdbnavitem0, target, anchor);
    			insert_dev(target, t0, anchor);
    			mount_component(mdbnavitem1, target, anchor);
    			insert_dev(target, t1, anchor);
    			mount_component(mdbnavitem2, target, anchor);
    			insert_dev(target, t2, anchor);
    			mount_component(mdbnavitem3, target, anchor);
    			current = true;
    		},
    		p: function update(ctx, dirty) {
    			const mdbnavitem0_changes = {};

    			if (dirty & /*$$scope*/ 8) {
    				mdbnavitem0_changes.$$scope = { dirty, ctx };
    			}

    			mdbnavitem0.$set(mdbnavitem0_changes);
    			const mdbnavitem1_changes = {};

    			if (dirty & /*$$scope*/ 8) {
    				mdbnavitem1_changes.$$scope = { dirty, ctx };
    			}

    			mdbnavitem1.$set(mdbnavitem1_changes);
    			const mdbnavitem2_changes = {};

    			if (dirty & /*$$scope*/ 8) {
    				mdbnavitem2_changes.$$scope = { dirty, ctx };
    			}

    			mdbnavitem2.$set(mdbnavitem2_changes);
    			const mdbnavitem3_changes = {};

    			if (dirty & /*$$scope*/ 8) {
    				mdbnavitem3_changes.$$scope = { dirty, ctx };
    			}

    			mdbnavitem3.$set(mdbnavitem3_changes);
    		},
    		i: function intro(local) {
    			if (current) return;
    			transition_in(mdbnavitem0.$$.fragment, local);
    			transition_in(mdbnavitem1.$$.fragment, local);
    			transition_in(mdbnavitem2.$$.fragment, local);
    			transition_in(mdbnavitem3.$$.fragment, local);
    			current = true;
    		},
    		o: function outro(local) {
    			transition_out(mdbnavitem0.$$.fragment, local);
    			transition_out(mdbnavitem1.$$.fragment, local);
    			transition_out(mdbnavitem2.$$.fragment, local);
    			transition_out(mdbnavitem3.$$.fragment, local);
    			current = false;
    		},
    		d: function destroy(detaching) {
    			destroy_component(mdbnavitem0, detaching);
    			if (detaching) detach_dev(t0);
    			destroy_component(mdbnavitem1, detaching);
    			if (detaching) detach_dev(t1);
    			destroy_component(mdbnavitem2, detaching);
    			if (detaching) detach_dev(t2);
    			destroy_component(mdbnavitem3, detaching);
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_default_slot_2$c.name,
    		type: "slot",
    		source: "(33:4) <MDBNavbarNav right>",
    		ctx
    	});

    	return block;
    }

    // (27:2) <MDBCollapse isOpen = { collapse } navbar expand="md" on:update={handleUpdate}>
    function create_default_slot_1$c(ctx) {
    	let mdbnavbarnav0;
    	let t;
    	let mdbnavbarnav1;
    	let current;

    	mdbnavbarnav0 = new MDBNavbarNav({
    			props: {
    				left: true,
    				$$slots: { default: [create_default_slot_7$9] },
    				$$scope: { ctx }
    			},
    			$$inline: true
    		});

    	mdbnavbarnav1 = new MDBNavbarNav({
    			props: {
    				right: true,
    				$$slots: { default: [create_default_slot_2$c] },
    				$$scope: { ctx }
    			},
    			$$inline: true
    		});

    	const block = {
    		c: function create() {
    			create_component(mdbnavbarnav0.$$.fragment);
    			t = space();
    			create_component(mdbnavbarnav1.$$.fragment);
    		},
    		m: function mount(target, anchor) {
    			mount_component(mdbnavbarnav0, target, anchor);
    			insert_dev(target, t, anchor);
    			mount_component(mdbnavbarnav1, target, anchor);
    			current = true;
    		},
    		p: function update(ctx, dirty) {
    			const mdbnavbarnav0_changes = {};

    			if (dirty & /*$$scope*/ 8) {
    				mdbnavbarnav0_changes.$$scope = { dirty, ctx };
    			}

    			mdbnavbarnav0.$set(mdbnavbarnav0_changes);
    			const mdbnavbarnav1_changes = {};

    			if (dirty & /*$$scope*/ 8) {
    				mdbnavbarnav1_changes.$$scope = { dirty, ctx };
    			}

    			mdbnavbarnav1.$set(mdbnavbarnav1_changes);
    		},
    		i: function intro(local) {
    			if (current) return;
    			transition_in(mdbnavbarnav0.$$.fragment, local);
    			transition_in(mdbnavbarnav1.$$.fragment, local);
    			current = true;
    		},
    		o: function outro(local) {
    			transition_out(mdbnavbarnav0.$$.fragment, local);
    			transition_out(mdbnavbarnav1.$$.fragment, local);
    			current = false;
    		},
    		d: function destroy(detaching) {
    			destroy_component(mdbnavbarnav0, detaching);
    			if (detaching) detach_dev(t);
    			destroy_component(mdbnavbarnav1, detaching);
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_default_slot_1$c.name,
    		type: "slot",
    		source: "(27:2) <MDBCollapse isOpen = { collapse } navbar expand=\\\"md\\\" on:update={handleUpdate}>",
    		ctx
    	});

    	return block;
    }

    // (22:0) <MDBNavbar class="flexible-navbar" light expand="md">
    function create_default_slot$d(ctx) {
    	let mdbnavbarbrand;
    	let t0;
    	let mdbnavbartoggler;
    	let t1;
    	let mdbcollapse;
    	let current;

    	mdbnavbarbrand = new MDBNavbarBrand({
    			props: {
    				href: "/",
    				$$slots: { default: [create_default_slot_10$9] },
    				$$scope: { ctx }
    			},
    			$$inline: true
    		});

    	mdbnavbartoggler = new MDBNavbarToggler({ $$inline: true });
    	mdbnavbartoggler.$on("click", /*toggle*/ ctx[1]);

    	mdbcollapse = new MDBCollapse({
    			props: {
    				isOpen: /*collapse*/ ctx[0],
    				navbar: true,
    				expand: "md",
    				$$slots: { default: [create_default_slot_1$c] },
    				$$scope: { ctx }
    			},
    			$$inline: true
    		});

    	mdbcollapse.$on("update", /*handleUpdate*/ ctx[2]);

    	const block = {
    		c: function create() {
    			create_component(mdbnavbarbrand.$$.fragment);
    			t0 = space();
    			create_component(mdbnavbartoggler.$$.fragment);
    			t1 = space();
    			create_component(mdbcollapse.$$.fragment);
    		},
    		m: function mount(target, anchor) {
    			mount_component(mdbnavbarbrand, target, anchor);
    			insert_dev(target, t0, anchor);
    			mount_component(mdbnavbartoggler, target, anchor);
    			insert_dev(target, t1, anchor);
    			mount_component(mdbcollapse, target, anchor);
    			current = true;
    		},
    		p: function update(ctx, dirty) {
    			const mdbnavbarbrand_changes = {};

    			if (dirty & /*$$scope*/ 8) {
    				mdbnavbarbrand_changes.$$scope = { dirty, ctx };
    			}

    			mdbnavbarbrand.$set(mdbnavbarbrand_changes);
    			const mdbcollapse_changes = {};
    			if (dirty & /*collapse*/ 1) mdbcollapse_changes.isOpen = /*collapse*/ ctx[0];

    			if (dirty & /*$$scope*/ 8) {
    				mdbcollapse_changes.$$scope = { dirty, ctx };
    			}

    			mdbcollapse.$set(mdbcollapse_changes);
    		},
    		i: function intro(local) {
    			if (current) return;
    			transition_in(mdbnavbarbrand.$$.fragment, local);
    			transition_in(mdbnavbartoggler.$$.fragment, local);
    			transition_in(mdbcollapse.$$.fragment, local);
    			current = true;
    		},
    		o: function outro(local) {
    			transition_out(mdbnavbarbrand.$$.fragment, local);
    			transition_out(mdbnavbartoggler.$$.fragment, local);
    			transition_out(mdbcollapse.$$.fragment, local);
    			current = false;
    		},
    		d: function destroy(detaching) {
    			destroy_component(mdbnavbarbrand, detaching);
    			if (detaching) detach_dev(t0);
    			destroy_component(mdbnavbartoggler, detaching);
    			if (detaching) detach_dev(t1);
    			destroy_component(mdbcollapse, detaching);
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_default_slot$d.name,
    		type: "slot",
    		source: "(22:0) <MDBNavbar class=\\\"flexible-navbar\\\" light expand=\\\"md\\\">",
    		ctx
    	});

    	return block;
    }

    function create_fragment$L(ctx) {
    	let mdbnavbar;
    	let current;

    	mdbnavbar = new MDBNavbar({
    			props: {
    				class: "flexible-navbar",
    				light: true,
    				expand: "md",
    				$$slots: { default: [create_default_slot$d] },
    				$$scope: { ctx }
    			},
    			$$inline: true
    		});

    	const block = {
    		c: function create() {
    			create_component(mdbnavbar.$$.fragment);
    		},
    		l: function claim(nodes) {
    			throw new Error("options.hydrate only works if the component was compiled with the `hydratable: true` option");
    		},
    		m: function mount(target, anchor) {
    			mount_component(mdbnavbar, target, anchor);
    			current = true;
    		},
    		p: function update(ctx, [dirty]) {
    			const mdbnavbar_changes = {};

    			if (dirty & /*$$scope, collapse*/ 9) {
    				mdbnavbar_changes.$$scope = { dirty, ctx };
    			}

    			mdbnavbar.$set(mdbnavbar_changes);
    		},
    		i: function intro(local) {
    			if (current) return;
    			transition_in(mdbnavbar.$$.fragment, local);
    			current = true;
    		},
    		o: function outro(local) {
    			transition_out(mdbnavbar.$$.fragment, local);
    			current = false;
    		},
    		d: function destroy(detaching) {
    			destroy_component(mdbnavbar, detaching);
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_fragment$L.name,
    		type: "component",
    		source: "",
    		ctx
    	});

    	return block;
    }

    function instance$L($$self, $$props, $$invalidate) {
    	let { $$slots: slots = {}, $$scope } = $$props;
    	validate_slots("TopNavigation", slots, []);
    	let collapse = false;

    	function toggle() {
    		$$invalidate(0, collapse = !collapse);
    	}

    	function handleUpdate(event) {
    		$$invalidate(0, collapse = event.detail.isOpen);
    	}

    	const writable_props = [];

    	Object.keys($$props).forEach(key => {
    		if (!~writable_props.indexOf(key) && key.slice(0, 2) !== "$$") console.warn(`<TopNavigation> was created with unknown prop '${key}'`);
    	});

    	$$self.$capture_state = () => ({
    		MDBNavbar,
    		MDBNavbarBrand,
    		MDBNavbarNav,
    		MDBNavbarToggler,
    		MDBCollapse,
    		MDBNavItem,
    		MDBNavLink,
    		MDBIcon,
    		collapse,
    		toggle,
    		handleUpdate
    	});

    	$$self.$inject_state = $$props => {
    		if ("collapse" in $$props) $$invalidate(0, collapse = $$props.collapse);
    	};

    	if ($$props && "$$inject" in $$props) {
    		$$self.$inject_state($$props.$$inject);
    	}

    	return [collapse, toggle, handleUpdate];
    }

    class TopNavigation extends SvelteComponentDev {
    	constructor(options) {
    		super(options);
    		init(this, options, instance$L, create_fragment$L, safe_not_equal, {});

    		dispatch_dev("SvelteRegisterComponent", {
    			component: this,
    			tagName: "TopNavigation",
    			options,
    			id: create_fragment$L.name
    		});
    	}
    }

    /* node_modules/mdbsvelte/src/MDBFooter.svelte generated by Svelte v3.37.0 */
    const file$C = "node_modules/mdbsvelte/src/MDBFooter.svelte";

    function create_fragment$K(ctx) {
    	let footer;
    	let current;
    	let mounted;
    	let dispose;
    	const default_slot_template = /*#slots*/ ctx[6].default;
    	const default_slot = create_slot(default_slot_template, ctx, /*$$scope*/ ctx[5], null);
    	let footer_levels = [/*props*/ ctx[2], { class: /*elementClasses*/ ctx[0] }];
    	let footer_data = {};

    	for (let i = 0; i < footer_levels.length; i += 1) {
    		footer_data = assign(footer_data, footer_levels[i]);
    	}

    	const block = {
    		c: function create() {
    			footer = element("footer");
    			if (default_slot) default_slot.c();
    			set_attributes(footer, footer_data);
    			add_location(footer, file$C, 16, 0, 422);
    		},
    		l: function claim(nodes) {
    			throw new Error("options.hydrate only works if the component was compiled with the `hydratable: true` option");
    		},
    		m: function mount(target, anchor) {
    			insert_dev(target, footer, anchor);

    			if (default_slot) {
    				default_slot.m(footer, null);
    			}

    			current = true;

    			if (!mounted) {
    				dispose = action_destroyer(/*forwardEvents*/ ctx[1].call(null, footer));
    				mounted = true;
    			}
    		},
    		p: function update(ctx, [dirty]) {
    			if (default_slot) {
    				if (default_slot.p && dirty & /*$$scope*/ 32) {
    					update_slot(default_slot, default_slot_template, ctx, /*$$scope*/ ctx[5], dirty, null, null);
    				}
    			}

    			set_attributes(footer, footer_data = get_spread_update(footer_levels, [
    				/*props*/ ctx[2],
    				(!current || dirty & /*elementClasses*/ 1) && { class: /*elementClasses*/ ctx[0] }
    			]));
    		},
    		i: function intro(local) {
    			if (current) return;
    			transition_in(default_slot, local);
    			current = true;
    		},
    		o: function outro(local) {
    			transition_out(default_slot, local);
    			current = false;
    		},
    		d: function destroy(detaching) {
    			if (detaching) detach_dev(footer);
    			if (default_slot) default_slot.d(detaching);
    			mounted = false;
    			dispose();
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_fragment$K.name,
    		type: "component",
    		source: "",
    		ctx
    	});

    	return block;
    }

    function instance$K($$self, $$props, $$invalidate) {
    	let { $$slots: slots = {}, $$scope } = $$props;
    	validate_slots("MDBFooter", slots, ['default']);
    	const forwardEvents = forwardEventsBuilder(current_component);
    	let { class: className = "" } = $$props;
    	let { color } = $$props;
    	const props = clean$1($$props, []);
    	let elementClasses;

    	$$self.$$set = $$new_props => {
    		$$invalidate(7, $$props = assign(assign({}, $$props), exclude_internal_props($$new_props)));
    		if ("class" in $$new_props) $$invalidate(3, className = $$new_props.class);
    		if ("color" in $$new_props) $$invalidate(4, color = $$new_props.color);
    		if ("$$scope" in $$new_props) $$invalidate(5, $$scope = $$new_props.$$scope);
    	};

    	$$self.$capture_state = () => ({
    		clean: clean$1,
    		clsx,
    		forwardEventsBuilder,
    		getColorClass,
    		current_component,
    		forwardEvents,
    		className,
    		color,
    		props,
    		elementClasses
    	});

    	$$self.$inject_state = $$new_props => {
    		$$invalidate(7, $$props = assign(assign({}, $$props), $$new_props));
    		if ("className" in $$props) $$invalidate(3, className = $$new_props.className);
    		if ("color" in $$props) $$invalidate(4, color = $$new_props.color);
    		if ("elementClasses" in $$props) $$invalidate(0, elementClasses = $$new_props.elementClasses);
    	};

    	if ($$props && "$$inject" in $$props) {
    		$$self.$inject_state($$props.$$inject);
    	}

    	$$self.$$.update = () => {
    		if ($$self.$$.dirty & /*className, color*/ 24) {
    			$$invalidate(0, elementClasses = clsx(className, "page-footer", getColorClass(color)));
    		}
    	};

    	$$props = exclude_internal_props($$props);
    	return [elementClasses, forwardEvents, props, className, color, $$scope, slots];
    }

    class MDBFooter extends SvelteComponentDev {
    	constructor(options) {
    		super(options);
    		init(this, options, instance$K, create_fragment$K, safe_not_equal, { class: 3, color: 4 });

    		dispatch_dev("SvelteRegisterComponent", {
    			component: this,
    			tagName: "MDBFooter",
    			options,
    			id: create_fragment$K.name
    		});

    		const { ctx } = this.$$;
    		const props = options.props || {};

    		if (/*color*/ ctx[4] === undefined && !("color" in props)) {
    			console.warn("<MDBFooter> was created without expected prop 'color'");
    		}
    	}

    	get class() {
    		throw new Error("<MDBFooter>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	set class(value) {
    		throw new Error("<MDBFooter>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	get color() {
    		throw new Error("<MDBFooter>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	set color(value) {
    		throw new Error("<MDBFooter>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}
    }

    /* node_modules/mdbsvelte/src/MDBBtn.svelte generated by Svelte v3.37.0 */
    const file$B = "node_modules/mdbsvelte/src/MDBBtn.svelte";

    // (64:0) {:else}
    function create_else_block_1$1(ctx) {
    	let button;
    	let button_aria_label_value;
    	let current;
    	let mounted;
    	let dispose;
    	const default_slot_template = /*#slots*/ ctx[22].default;
    	const default_slot = create_slot(default_slot_template, ctx, /*$$scope*/ ctx[21], null);
    	const default_slot_or_fallback = default_slot || fallback_block$1(ctx);

    	let button_levels = [
    		/*props*/ ctx[12],
    		{ type: /*type*/ ctx[4] },
    		{ class: /*classes*/ ctx[9] },
    		{ disabled: /*disabled*/ ctx[3] },
    		{ value: /*value*/ ctx[6] },
    		{
    			"aria-label": button_aria_label_value = /*ariaLabel*/ ctx[8] || /*defaultAriaLabel*/ ctx[10]
    		},
    		{ style: /*style*/ ctx[0] }
    	];

    	let button_data = {};

    	for (let i = 0; i < button_levels.length; i += 1) {
    		button_data = assign(button_data, button_levels[i]);
    	}

    	const block_1 = {
    		c: function create() {
    			button = element("button");
    			if (default_slot_or_fallback) default_slot_or_fallback.c();
    			set_attributes(button, button_data);
    			add_location(button, file$B, 64, 2, 1463);
    		},
    		m: function mount(target, anchor) {
    			insert_dev(target, button, anchor);

    			if (default_slot_or_fallback) {
    				default_slot_or_fallback.m(button, null);
    			}

    			/*button_binding*/ ctx[23](button);
    			current = true;

    			if (!mounted) {
    				dispose = action_destroyer(/*forwardEvents*/ ctx[11].call(null, button));
    				mounted = true;
    			}
    		},
    		p: function update(ctx, dirty) {
    			if (default_slot) {
    				if (default_slot.p && dirty & /*$$scope*/ 2097152) {
    					update_slot(default_slot, default_slot_template, ctx, /*$$scope*/ ctx[21], dirty, null, null);
    				}
    			} else {
    				if (default_slot_or_fallback && default_slot_or_fallback.p && dirty & /*close, children, $$scope*/ 2097158) {
    					default_slot_or_fallback.p(ctx, dirty);
    				}
    			}

    			set_attributes(button, button_data = get_spread_update(button_levels, [
    				/*props*/ ctx[12],
    				(!current || dirty & /*type*/ 16) && { type: /*type*/ ctx[4] },
    				(!current || dirty & /*classes*/ 512) && { class: /*classes*/ ctx[9] },
    				(!current || dirty & /*disabled*/ 8) && { disabled: /*disabled*/ ctx[3] },
    				(!current || dirty & /*value*/ 64) && { value: /*value*/ ctx[6] },
    				(!current || dirty & /*ariaLabel, defaultAriaLabel*/ 1280 && button_aria_label_value !== (button_aria_label_value = /*ariaLabel*/ ctx[8] || /*defaultAriaLabel*/ ctx[10])) && { "aria-label": button_aria_label_value },
    				(!current || dirty & /*style*/ 1) && { style: /*style*/ ctx[0] }
    			]));
    		},
    		i: function intro(local) {
    			if (current) return;
    			transition_in(default_slot_or_fallback, local);
    			current = true;
    		},
    		o: function outro(local) {
    			transition_out(default_slot_or_fallback, local);
    			current = false;
    		},
    		d: function destroy(detaching) {
    			if (detaching) detach_dev(button);
    			if (default_slot_or_fallback) default_slot_or_fallback.d(detaching);
    			/*button_binding*/ ctx[23](null);
    			mounted = false;
    			dispose();
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block: block_1,
    		id: create_else_block_1$1.name,
    		type: "else",
    		source: "(64:0) {:else}",
    		ctx
    	});

    	return block_1;
    }

    // (50:0) {#if href}
    function create_if_block$9(ctx) {
    	let a;
    	let current_block_type_index;
    	let if_block;
    	let a_aria_label_value;
    	let current;
    	let mounted;
    	let dispose;
    	const if_block_creators = [create_if_block_1$4, create_else_block$8];
    	const if_blocks = [];

    	function select_block_type_1(ctx, dirty) {
    		if (/*children*/ ctx[1]) return 0;
    		return 1;
    	}

    	current_block_type_index = select_block_type_1(ctx);
    	if_block = if_blocks[current_block_type_index] = if_block_creators[current_block_type_index](ctx);

    	let a_levels = [
    		/*props*/ ctx[12],
    		{ class: /*classes*/ ctx[9] },
    		{ disabled: /*disabled*/ ctx[3] },
    		{ href: /*href*/ ctx[5] },
    		{
    			"aria-label": a_aria_label_value = /*ariaLabel*/ ctx[8] || /*defaultAriaLabel*/ ctx[10]
    		},
    		{ style: /*style*/ ctx[0] }
    	];

    	let a_data = {};

    	for (let i = 0; i < a_levels.length; i += 1) {
    		a_data = assign(a_data, a_levels[i]);
    	}

    	const block_1 = {
    		c: function create() {
    			a = element("a");
    			if_block.c();
    			set_attributes(a, a_data);
    			add_location(a, file$B, 50, 2, 1232);
    		},
    		m: function mount(target, anchor) {
    			insert_dev(target, a, anchor);
    			if_blocks[current_block_type_index].m(a, null);
    			current = true;

    			if (!mounted) {
    				dispose = action_destroyer(/*forwardEvents*/ ctx[11].call(null, a));
    				mounted = true;
    			}
    		},
    		p: function update(ctx, dirty) {
    			let previous_block_index = current_block_type_index;
    			current_block_type_index = select_block_type_1(ctx);

    			if (current_block_type_index === previous_block_index) {
    				if_blocks[current_block_type_index].p(ctx, dirty);
    			} else {
    				group_outros();

    				transition_out(if_blocks[previous_block_index], 1, 1, () => {
    					if_blocks[previous_block_index] = null;
    				});

    				check_outros();
    				if_block = if_blocks[current_block_type_index];

    				if (!if_block) {
    					if_block = if_blocks[current_block_type_index] = if_block_creators[current_block_type_index](ctx);
    					if_block.c();
    				} else {
    					if_block.p(ctx, dirty);
    				}

    				transition_in(if_block, 1);
    				if_block.m(a, null);
    			}

    			set_attributes(a, a_data = get_spread_update(a_levels, [
    				/*props*/ ctx[12],
    				(!current || dirty & /*classes*/ 512) && { class: /*classes*/ ctx[9] },
    				(!current || dirty & /*disabled*/ 8) && { disabled: /*disabled*/ ctx[3] },
    				(!current || dirty & /*href*/ 32) && { href: /*href*/ ctx[5] },
    				(!current || dirty & /*ariaLabel, defaultAriaLabel*/ 1280 && a_aria_label_value !== (a_aria_label_value = /*ariaLabel*/ ctx[8] || /*defaultAriaLabel*/ ctx[10])) && { "aria-label": a_aria_label_value },
    				(!current || dirty & /*style*/ 1) && { style: /*style*/ ctx[0] }
    			]));
    		},
    		i: function intro(local) {
    			if (current) return;
    			transition_in(if_block);
    			current = true;
    		},
    		o: function outro(local) {
    			transition_out(if_block);
    			current = false;
    		},
    		d: function destroy(detaching) {
    			if (detaching) detach_dev(a);
    			if_blocks[current_block_type_index].d();
    			mounted = false;
    			dispose();
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block: block_1,
    		id: create_if_block$9.name,
    		type: "if",
    		source: "(50:0) {#if href}",
    		ctx
    	});

    	return block_1;
    }

    // (80:6) {:else}
    function create_else_block_2$1(ctx) {
    	let current;
    	const default_slot_template = /*#slots*/ ctx[22].default;
    	const default_slot = create_slot(default_slot_template, ctx, /*$$scope*/ ctx[21], null);

    	const block_1 = {
    		c: function create() {
    			if (default_slot) default_slot.c();
    		},
    		m: function mount(target, anchor) {
    			if (default_slot) {
    				default_slot.m(target, anchor);
    			}

    			current = true;
    		},
    		p: function update(ctx, dirty) {
    			if (default_slot) {
    				if (default_slot.p && dirty & /*$$scope*/ 2097152) {
    					update_slot(default_slot, default_slot_template, ctx, /*$$scope*/ ctx[21], dirty, null, null);
    				}
    			}
    		},
    		i: function intro(local) {
    			if (current) return;
    			transition_in(default_slot, local);
    			current = true;
    		},
    		o: function outro(local) {
    			transition_out(default_slot, local);
    			current = false;
    		},
    		d: function destroy(detaching) {
    			if (default_slot) default_slot.d(detaching);
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block: block_1,
    		id: create_else_block_2$1.name,
    		type: "else",
    		source: "(80:6) {:else}",
    		ctx
    	});

    	return block_1;
    }

    // (78:25) 
    function create_if_block_3$1(ctx) {
    	let t;

    	const block_1 = {
    		c: function create() {
    			t = text(/*children*/ ctx[1]);
    		},
    		m: function mount(target, anchor) {
    			insert_dev(target, t, anchor);
    		},
    		p: function update(ctx, dirty) {
    			if (dirty & /*children*/ 2) set_data_dev(t, /*children*/ ctx[1]);
    		},
    		i: noop,
    		o: noop,
    		d: function destroy(detaching) {
    			if (detaching) detach_dev(t);
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block: block_1,
    		id: create_if_block_3$1.name,
    		type: "if",
    		source: "(78:25) ",
    		ctx
    	});

    	return block_1;
    }

    // (76:6) {#if close}
    function create_if_block_2$2(ctx) {
    	let span;

    	const block_1 = {
    		c: function create() {
    			span = element("span");
    			span.textContent = "×";
    			attr_dev(span, "aria-hidden", "true");
    			add_location(span, file$B, 76, 8, 1694);
    		},
    		m: function mount(target, anchor) {
    			insert_dev(target, span, anchor);
    		},
    		p: noop,
    		i: noop,
    		o: noop,
    		d: function destroy(detaching) {
    			if (detaching) detach_dev(span);
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block: block_1,
    		id: create_if_block_2$2.name,
    		type: "if",
    		source: "(76:6) {#if close}",
    		ctx
    	});

    	return block_1;
    }

    // (75:10)        
    function fallback_block$1(ctx) {
    	let current_block_type_index;
    	let if_block;
    	let if_block_anchor;
    	let current;
    	const if_block_creators = [create_if_block_2$2, create_if_block_3$1, create_else_block_2$1];
    	const if_blocks = [];

    	function select_block_type_2(ctx, dirty) {
    		if (/*close*/ ctx[2]) return 0;
    		if (/*children*/ ctx[1]) return 1;
    		return 2;
    	}

    	current_block_type_index = select_block_type_2(ctx);
    	if_block = if_blocks[current_block_type_index] = if_block_creators[current_block_type_index](ctx);

    	const block_1 = {
    		c: function create() {
    			if_block.c();
    			if_block_anchor = empty();
    		},
    		m: function mount(target, anchor) {
    			if_blocks[current_block_type_index].m(target, anchor);
    			insert_dev(target, if_block_anchor, anchor);
    			current = true;
    		},
    		p: function update(ctx, dirty) {
    			let previous_block_index = current_block_type_index;
    			current_block_type_index = select_block_type_2(ctx);

    			if (current_block_type_index === previous_block_index) {
    				if_blocks[current_block_type_index].p(ctx, dirty);
    			} else {
    				group_outros();

    				transition_out(if_blocks[previous_block_index], 1, 1, () => {
    					if_blocks[previous_block_index] = null;
    				});

    				check_outros();
    				if_block = if_blocks[current_block_type_index];

    				if (!if_block) {
    					if_block = if_blocks[current_block_type_index] = if_block_creators[current_block_type_index](ctx);
    					if_block.c();
    				} else {
    					if_block.p(ctx, dirty);
    				}

    				transition_in(if_block, 1);
    				if_block.m(if_block_anchor.parentNode, if_block_anchor);
    			}
    		},
    		i: function intro(local) {
    			if (current) return;
    			transition_in(if_block);
    			current = true;
    		},
    		o: function outro(local) {
    			transition_out(if_block);
    			current = false;
    		},
    		d: function destroy(detaching) {
    			if_blocks[current_block_type_index].d(detaching);
    			if (detaching) detach_dev(if_block_anchor);
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block: block_1,
    		id: fallback_block$1.name,
    		type: "fallback",
    		source: "(75:10)        ",
    		ctx
    	});

    	return block_1;
    }

    // (60:4) {:else}
    function create_else_block$8(ctx) {
    	let current;
    	const default_slot_template = /*#slots*/ ctx[22].default;
    	const default_slot = create_slot(default_slot_template, ctx, /*$$scope*/ ctx[21], null);

    	const block_1 = {
    		c: function create() {
    			if (default_slot) default_slot.c();
    		},
    		m: function mount(target, anchor) {
    			if (default_slot) {
    				default_slot.m(target, anchor);
    			}

    			current = true;
    		},
    		p: function update(ctx, dirty) {
    			if (default_slot) {
    				if (default_slot.p && dirty & /*$$scope*/ 2097152) {
    					update_slot(default_slot, default_slot_template, ctx, /*$$scope*/ ctx[21], dirty, null, null);
    				}
    			}
    		},
    		i: function intro(local) {
    			if (current) return;
    			transition_in(default_slot, local);
    			current = true;
    		},
    		o: function outro(local) {
    			transition_out(default_slot, local);
    			current = false;
    		},
    		d: function destroy(detaching) {
    			if (default_slot) default_slot.d(detaching);
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block: block_1,
    		id: create_else_block$8.name,
    		type: "else",
    		source: "(60:4) {:else}",
    		ctx
    	});

    	return block_1;
    }

    // (58:4) {#if children}
    function create_if_block_1$4(ctx) {
    	let t;

    	const block_1 = {
    		c: function create() {
    			t = text(/*children*/ ctx[1]);
    		},
    		m: function mount(target, anchor) {
    			insert_dev(target, t, anchor);
    		},
    		p: function update(ctx, dirty) {
    			if (dirty & /*children*/ 2) set_data_dev(t, /*children*/ ctx[1]);
    		},
    		i: noop,
    		o: noop,
    		d: function destroy(detaching) {
    			if (detaching) detach_dev(t);
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block: block_1,
    		id: create_if_block_1$4.name,
    		type: "if",
    		source: "(58:4) {#if children}",
    		ctx
    	});

    	return block_1;
    }

    function create_fragment$J(ctx) {
    	let current_block_type_index;
    	let if_block;
    	let if_block_anchor;
    	let current;
    	const if_block_creators = [create_if_block$9, create_else_block_1$1];
    	const if_blocks = [];

    	function select_block_type(ctx, dirty) {
    		if (/*href*/ ctx[5]) return 0;
    		return 1;
    	}

    	current_block_type_index = select_block_type(ctx);
    	if_block = if_blocks[current_block_type_index] = if_block_creators[current_block_type_index](ctx);

    	const block_1 = {
    		c: function create() {
    			if_block.c();
    			if_block_anchor = empty();
    		},
    		l: function claim(nodes) {
    			throw new Error("options.hydrate only works if the component was compiled with the `hydratable: true` option");
    		},
    		m: function mount(target, anchor) {
    			if_blocks[current_block_type_index].m(target, anchor);
    			insert_dev(target, if_block_anchor, anchor);
    			current = true;
    		},
    		p: function update(ctx, [dirty]) {
    			let previous_block_index = current_block_type_index;
    			current_block_type_index = select_block_type(ctx);

    			if (current_block_type_index === previous_block_index) {
    				if_blocks[current_block_type_index].p(ctx, dirty);
    			} else {
    				group_outros();

    				transition_out(if_blocks[previous_block_index], 1, 1, () => {
    					if_blocks[previous_block_index] = null;
    				});

    				check_outros();
    				if_block = if_blocks[current_block_type_index];

    				if (!if_block) {
    					if_block = if_blocks[current_block_type_index] = if_block_creators[current_block_type_index](ctx);
    					if_block.c();
    				} else {
    					if_block.p(ctx, dirty);
    				}

    				transition_in(if_block, 1);
    				if_block.m(if_block_anchor.parentNode, if_block_anchor);
    			}
    		},
    		i: function intro(local) {
    			if (current) return;
    			transition_in(if_block);
    			current = true;
    		},
    		o: function outro(local) {
    			transition_out(if_block);
    			current = false;
    		},
    		d: function destroy(detaching) {
    			if_blocks[current_block_type_index].d(detaching);
    			if (detaching) detach_dev(if_block_anchor);
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block: block_1,
    		id: create_fragment$J.name,
    		type: "component",
    		source: "",
    		ctx
    	});

    	return block_1;
    }

    function instance$J($$self, $$props, $$invalidate) {
    	let ariaLabel;
    	let classes;
    	let defaultAriaLabel;
    	let { $$slots: slots = {}, $$scope } = $$props;
    	validate_slots("MDBBtn", slots, ['default']);
    	const forwardEvents = forwardEventsBuilder(current_component);
    	let { class: className = "" } = $$props;
    	let { active = false } = $$props;
    	let { block = false } = $$props;
    	let { children = undefined } = $$props;
    	let { close = false } = $$props;
    	let { color } = $$props;
    	let { disabled = false } = $$props;
    	let { type = "button" } = $$props;
    	let { href = "" } = $$props;
    	let { outline = false } = $$props;
    	let { size = "" } = $$props;
    	let { style = "" } = $$props;
    	let { value = "" } = $$props;
    	let { gradient } = $$props;
    	let domElement;
    	let { rounded } = $$props;

    	if (rounded) {
    		style = "border-radius: 10em" + style;
    	}

    	if (!color) {
    		href ? color = "primary" : color = "default";
    	}

    	const props = clean$1($$props, ["color", "gradient", "value", "style", "size"]);

    	function button_binding($$value) {
    		binding_callbacks[$$value ? "unshift" : "push"](() => {
    			domElement = $$value;
    			$$invalidate(7, domElement);
    		});
    	}

    	$$self.$$set = $$new_props => {
    		$$invalidate(24, $$props = assign(assign({}, $$props), exclude_internal_props($$new_props)));
    		if ("class" in $$new_props) $$invalidate(14, className = $$new_props.class);
    		if ("active" in $$new_props) $$invalidate(15, active = $$new_props.active);
    		if ("block" in $$new_props) $$invalidate(16, block = $$new_props.block);
    		if ("children" in $$new_props) $$invalidate(1, children = $$new_props.children);
    		if ("close" in $$new_props) $$invalidate(2, close = $$new_props.close);
    		if ("color" in $$new_props) $$invalidate(13, color = $$new_props.color);
    		if ("disabled" in $$new_props) $$invalidate(3, disabled = $$new_props.disabled);
    		if ("type" in $$new_props) $$invalidate(4, type = $$new_props.type);
    		if ("href" in $$new_props) $$invalidate(5, href = $$new_props.href);
    		if ("outline" in $$new_props) $$invalidate(17, outline = $$new_props.outline);
    		if ("size" in $$new_props) $$invalidate(18, size = $$new_props.size);
    		if ("style" in $$new_props) $$invalidate(0, style = $$new_props.style);
    		if ("value" in $$new_props) $$invalidate(6, value = $$new_props.value);
    		if ("gradient" in $$new_props) $$invalidate(19, gradient = $$new_props.gradient);
    		if ("rounded" in $$new_props) $$invalidate(20, rounded = $$new_props.rounded);
    		if ("$$scope" in $$new_props) $$invalidate(21, $$scope = $$new_props.$$scope);
    	};

    	$$self.$capture_state = () => ({
    		clean: clean$1,
    		clsx,
    		forwardEventsBuilder,
    		current_component,
    		forwardEvents,
    		className,
    		active,
    		block,
    		children,
    		close,
    		color,
    		disabled,
    		type,
    		href,
    		outline,
    		size,
    		style,
    		value,
    		gradient,
    		domElement,
    		rounded,
    		props,
    		ariaLabel,
    		classes,
    		defaultAriaLabel
    	});

    	$$self.$inject_state = $$new_props => {
    		$$invalidate(24, $$props = assign(assign({}, $$props), $$new_props));
    		if ("className" in $$props) $$invalidate(14, className = $$new_props.className);
    		if ("active" in $$props) $$invalidate(15, active = $$new_props.active);
    		if ("block" in $$props) $$invalidate(16, block = $$new_props.block);
    		if ("children" in $$props) $$invalidate(1, children = $$new_props.children);
    		if ("close" in $$props) $$invalidate(2, close = $$new_props.close);
    		if ("color" in $$props) $$invalidate(13, color = $$new_props.color);
    		if ("disabled" in $$props) $$invalidate(3, disabled = $$new_props.disabled);
    		if ("type" in $$props) $$invalidate(4, type = $$new_props.type);
    		if ("href" in $$props) $$invalidate(5, href = $$new_props.href);
    		if ("outline" in $$props) $$invalidate(17, outline = $$new_props.outline);
    		if ("size" in $$props) $$invalidate(18, size = $$new_props.size);
    		if ("style" in $$props) $$invalidate(0, style = $$new_props.style);
    		if ("value" in $$props) $$invalidate(6, value = $$new_props.value);
    		if ("gradient" in $$props) $$invalidate(19, gradient = $$new_props.gradient);
    		if ("domElement" in $$props) $$invalidate(7, domElement = $$new_props.domElement);
    		if ("rounded" in $$props) $$invalidate(20, rounded = $$new_props.rounded);
    		if ("ariaLabel" in $$props) $$invalidate(8, ariaLabel = $$new_props.ariaLabel);
    		if ("classes" in $$props) $$invalidate(9, classes = $$new_props.classes);
    		if ("defaultAriaLabel" in $$props) $$invalidate(10, defaultAriaLabel = $$new_props.defaultAriaLabel);
    	};

    	if ($$props && "$$inject" in $$props) {
    		$$self.$inject_state($$props.$$inject);
    	}

    	$$self.$$.update = () => {
    		$$invalidate(8, ariaLabel = $$props["aria-label"]);

    		if ($$self.$$.dirty & /*className, close, gradient, outline, color, size, block, active*/ 1040388) {
    			$$invalidate(9, classes = clsx(
    				className,
    				{ close },
    				close || "btn waves-effect waves-light",
    				gradient
    				? `${gradient}-gradient`
    				: close || `btn${outline ? "-outline" : ""}-${color}`,
    				size ? `btn-${size}` : false,
    				block ? "btn-block" : false,
    				{ active }
    			));
    		}

    		if ($$self.$$.dirty & /*close*/ 4) {
    			$$invalidate(10, defaultAriaLabel = close ? "Close" : null);
    		}
    	};

    	$$props = exclude_internal_props($$props);

    	return [
    		style,
    		children,
    		close,
    		disabled,
    		type,
    		href,
    		value,
    		domElement,
    		ariaLabel,
    		classes,
    		defaultAriaLabel,
    		forwardEvents,
    		props,
    		color,
    		className,
    		active,
    		block,
    		outline,
    		size,
    		gradient,
    		rounded,
    		$$scope,
    		slots,
    		button_binding
    	];
    }

    class MDBBtn extends SvelteComponentDev {
    	constructor(options) {
    		super(options);

    		init(this, options, instance$J, create_fragment$J, safe_not_equal, {
    			class: 14,
    			active: 15,
    			block: 16,
    			children: 1,
    			close: 2,
    			color: 13,
    			disabled: 3,
    			type: 4,
    			href: 5,
    			outline: 17,
    			size: 18,
    			style: 0,
    			value: 6,
    			gradient: 19,
    			rounded: 20
    		});

    		dispatch_dev("SvelteRegisterComponent", {
    			component: this,
    			tagName: "MDBBtn",
    			options,
    			id: create_fragment$J.name
    		});

    		const { ctx } = this.$$;
    		const props = options.props || {};

    		if (/*color*/ ctx[13] === undefined && !("color" in props)) {
    			console.warn("<MDBBtn> was created without expected prop 'color'");
    		}

    		if (/*gradient*/ ctx[19] === undefined && !("gradient" in props)) {
    			console.warn("<MDBBtn> was created without expected prop 'gradient'");
    		}

    		if (/*rounded*/ ctx[20] === undefined && !("rounded" in props)) {
    			console.warn("<MDBBtn> was created without expected prop 'rounded'");
    		}
    	}

    	get class() {
    		throw new Error("<MDBBtn>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	set class(value) {
    		throw new Error("<MDBBtn>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	get active() {
    		throw new Error("<MDBBtn>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	set active(value) {
    		throw new Error("<MDBBtn>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	get block() {
    		throw new Error("<MDBBtn>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	set block(value) {
    		throw new Error("<MDBBtn>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	get children() {
    		throw new Error("<MDBBtn>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	set children(value) {
    		throw new Error("<MDBBtn>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	get close() {
    		throw new Error("<MDBBtn>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	set close(value) {
    		throw new Error("<MDBBtn>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	get color() {
    		throw new Error("<MDBBtn>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	set color(value) {
    		throw new Error("<MDBBtn>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	get disabled() {
    		throw new Error("<MDBBtn>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	set disabled(value) {
    		throw new Error("<MDBBtn>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	get type() {
    		throw new Error("<MDBBtn>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	set type(value) {
    		throw new Error("<MDBBtn>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	get href() {
    		throw new Error("<MDBBtn>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	set href(value) {
    		throw new Error("<MDBBtn>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	get outline() {
    		throw new Error("<MDBBtn>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	set outline(value) {
    		throw new Error("<MDBBtn>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	get size() {
    		throw new Error("<MDBBtn>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	set size(value) {
    		throw new Error("<MDBBtn>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	get style() {
    		throw new Error("<MDBBtn>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	set style(value) {
    		throw new Error("<MDBBtn>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	get value() {
    		throw new Error("<MDBBtn>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	set value(value) {
    		throw new Error("<MDBBtn>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	get gradient() {
    		throw new Error("<MDBBtn>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	set gradient(value) {
    		throw new Error("<MDBBtn>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	get rounded() {
    		throw new Error("<MDBBtn>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	set rounded(value) {
    		throw new Error("<MDBBtn>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}
    }

    /* src/components/_shared/Footer.svelte generated by Svelte v3.37.0 */
    const file$A = "src/components/_shared/Footer.svelte";

    // (9:4) <MDBBtn outline color="white" href="#" target="_blank">
    function create_default_slot_2$b(ctx) {
    	let t;
    	let mdbicon;
    	let current;

    	mdbicon = new MDBIcon({
    			props: { icon: "download", class: "ml-2" },
    			$$inline: true
    		});

    	const block = {
    		c: function create() {
    			t = text("Download MDB\n      ");
    			create_component(mdbicon.$$.fragment);
    		},
    		m: function mount(target, anchor) {
    			insert_dev(target, t, anchor);
    			mount_component(mdbicon, target, anchor);
    			current = true;
    		},
    		p: noop,
    		i: function intro(local) {
    			if (current) return;
    			transition_in(mdbicon.$$.fragment, local);
    			current = true;
    		},
    		o: function outro(local) {
    			transition_out(mdbicon.$$.fragment, local);
    			current = false;
    		},
    		d: function destroy(detaching) {
    			if (detaching) detach_dev(t);
    			destroy_component(mdbicon, detaching);
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_default_slot_2$b.name,
    		type: "slot",
    		source: "(9:4) <MDBBtn outline color=\\\"white\\\" href=\\\"#\\\" target=\\\"_blank\\\">",
    		ctx
    	});

    	return block;
    }

    // (13:4) <MDBBtn outline color="white" href="#" target="_blank">
    function create_default_slot_1$b(ctx) {
    	let t;
    	let mdbicon;
    	let current;

    	mdbicon = new MDBIcon({
    			props: { icon: "graduation-cap", class: "ml-2" },
    			$$inline: true
    		});

    	const block = {
    		c: function create() {
    			t = text("Start free tutorial\n      ");
    			create_component(mdbicon.$$.fragment);
    		},
    		m: function mount(target, anchor) {
    			insert_dev(target, t, anchor);
    			mount_component(mdbicon, target, anchor);
    			current = true;
    		},
    		p: noop,
    		i: function intro(local) {
    			if (current) return;
    			transition_in(mdbicon.$$.fragment, local);
    			current = true;
    		},
    		o: function outro(local) {
    			transition_out(mdbicon.$$.fragment, local);
    			current = false;
    		},
    		d: function destroy(detaching) {
    			if (detaching) detach_dev(t);
    			destroy_component(mdbicon, detaching);
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_default_slot_1$b.name,
    		type: "slot",
    		source: "(13:4) <MDBBtn outline color=\\\"white\\\" href=\\\"#\\\" target=\\\"_blank\\\">",
    		ctx
    	});

    	return block;
    }

    // (7:0) <MDBFooter color="blue" class="text-center font-small darken-2 footer">
    function create_default_slot$c(ctx) {
    	let div0;
    	let mdbbtn0;
    	let t0;
    	let mdbbtn1;
    	let t1;
    	let hr;
    	let t2;
    	let div1;
    	let mdbicon0;
    	let t3;
    	let mdbicon1;
    	let t4;
    	let mdbicon2;
    	let t5;
    	let mdbicon3;
    	let t6;
    	let mdbicon4;
    	let t7;
    	let mdbicon5;
    	let t8;
    	let mdbicon6;
    	let t9;
    	let mdbicon7;
    	let t10;
    	let p;
    	let t11;
    	let t12_value = new Date().getFullYear() + "";
    	let t12;
    	let t13;
    	let a;
    	let current;

    	mdbbtn0 = new MDBBtn({
    			props: {
    				outline: true,
    				color: "white",
    				href: "#",
    				target: "_blank",
    				$$slots: { default: [create_default_slot_2$b] },
    				$$scope: { ctx }
    			},
    			$$inline: true
    		});

    	mdbbtn1 = new MDBBtn({
    			props: {
    				outline: true,
    				color: "white",
    				href: "#",
    				target: "_blank",
    				$$slots: { default: [create_default_slot_1$b] },
    				$$scope: { ctx }
    			},
    			$$inline: true
    		});

    	mdbicon0 = new MDBIcon({
    			props: {
    				fab: true,
    				icon: "facebook",
    				class: "mr-3"
    			},
    			$$inline: true
    		});

    	mdbicon1 = new MDBIcon({
    			props: {
    				fab: true,
    				icon: "twitter",
    				class: "mr-3"
    			},
    			$$inline: true
    		});

    	mdbicon2 = new MDBIcon({
    			props: {
    				fab: true,
    				icon: "youtube",
    				class: "mr-3"
    			},
    			$$inline: true
    		});

    	mdbicon3 = new MDBIcon({
    			props: {
    				fab: true,
    				icon: "google-plus",
    				class: "mr-3"
    			},
    			$$inline: true
    		});

    	mdbicon4 = new MDBIcon({
    			props: {
    				fab: true,
    				icon: "dribbble",
    				class: "mr-3"
    			},
    			$$inline: true
    		});

    	mdbicon5 = new MDBIcon({
    			props: {
    				fab: true,
    				icon: "pinterest",
    				class: "mr-3"
    			},
    			$$inline: true
    		});

    	mdbicon6 = new MDBIcon({
    			props: { fab: true, icon: "github", class: "mr-3" },
    			$$inline: true
    		});

    	mdbicon7 = new MDBIcon({
    			props: {
    				fab: true,
    				icon: "codepen",
    				class: "mr-3"
    			},
    			$$inline: true
    		});

    	const block = {
    		c: function create() {
    			div0 = element("div");
    			create_component(mdbbtn0.$$.fragment);
    			t0 = space();
    			create_component(mdbbtn1.$$.fragment);
    			t1 = space();
    			hr = element("hr");
    			t2 = space();
    			div1 = element("div");
    			create_component(mdbicon0.$$.fragment);
    			t3 = space();
    			create_component(mdbicon1.$$.fragment);
    			t4 = space();
    			create_component(mdbicon2.$$.fragment);
    			t5 = space();
    			create_component(mdbicon3.$$.fragment);
    			t6 = space();
    			create_component(mdbicon4.$$.fragment);
    			t7 = space();
    			create_component(mdbicon5.$$.fragment);
    			t8 = space();
    			create_component(mdbicon6.$$.fragment);
    			t9 = space();
    			create_component(mdbicon7.$$.fragment);
    			t10 = space();
    			p = element("p");
    			t11 = text("© ");
    			t12 = text(t12_value);
    			t13 = text(" Copyright:\n    ");
    			a = element("a");
    			a.textContent = "saurav.tech/mdbsvelte";
    			attr_dev(hr, "class", "my4");
    			add_location(hr, file$A, 16, 4, 574);
    			attr_dev(div0, "class", "pt-4");
    			add_location(div0, file$A, 7, 2, 258);
    			attr_dev(div1, "class", "pb-4");
    			add_location(div1, file$A, 18, 2, 604);
    			attr_dev(a, "href", "https://saurav.tech/mdbsvelte");
    			add_location(a, file$A, 30, 4, 1129);
    			attr_dev(p, "class", "footer-copyright mb-0 py-3 text-center");
    			add_location(p, file$A, 28, 2, 1025);
    		},
    		m: function mount(target, anchor) {
    			insert_dev(target, div0, anchor);
    			mount_component(mdbbtn0, div0, null);
    			append_dev(div0, t0);
    			mount_component(mdbbtn1, div0, null);
    			append_dev(div0, t1);
    			append_dev(div0, hr);
    			insert_dev(target, t2, anchor);
    			insert_dev(target, div1, anchor);
    			mount_component(mdbicon0, div1, null);
    			append_dev(div1, t3);
    			mount_component(mdbicon1, div1, null);
    			append_dev(div1, t4);
    			mount_component(mdbicon2, div1, null);
    			append_dev(div1, t5);
    			mount_component(mdbicon3, div1, null);
    			append_dev(div1, t6);
    			mount_component(mdbicon4, div1, null);
    			append_dev(div1, t7);
    			mount_component(mdbicon5, div1, null);
    			append_dev(div1, t8);
    			mount_component(mdbicon6, div1, null);
    			append_dev(div1, t9);
    			mount_component(mdbicon7, div1, null);
    			insert_dev(target, t10, anchor);
    			insert_dev(target, p, anchor);
    			append_dev(p, t11);
    			append_dev(p, t12);
    			append_dev(p, t13);
    			append_dev(p, a);
    			current = true;
    		},
    		p: function update(ctx, dirty) {
    			const mdbbtn0_changes = {};

    			if (dirty & /*$$scope*/ 1) {
    				mdbbtn0_changes.$$scope = { dirty, ctx };
    			}

    			mdbbtn0.$set(mdbbtn0_changes);
    			const mdbbtn1_changes = {};

    			if (dirty & /*$$scope*/ 1) {
    				mdbbtn1_changes.$$scope = { dirty, ctx };
    			}

    			mdbbtn1.$set(mdbbtn1_changes);
    		},
    		i: function intro(local) {
    			if (current) return;
    			transition_in(mdbbtn0.$$.fragment, local);
    			transition_in(mdbbtn1.$$.fragment, local);
    			transition_in(mdbicon0.$$.fragment, local);
    			transition_in(mdbicon1.$$.fragment, local);
    			transition_in(mdbicon2.$$.fragment, local);
    			transition_in(mdbicon3.$$.fragment, local);
    			transition_in(mdbicon4.$$.fragment, local);
    			transition_in(mdbicon5.$$.fragment, local);
    			transition_in(mdbicon6.$$.fragment, local);
    			transition_in(mdbicon7.$$.fragment, local);
    			current = true;
    		},
    		o: function outro(local) {
    			transition_out(mdbbtn0.$$.fragment, local);
    			transition_out(mdbbtn1.$$.fragment, local);
    			transition_out(mdbicon0.$$.fragment, local);
    			transition_out(mdbicon1.$$.fragment, local);
    			transition_out(mdbicon2.$$.fragment, local);
    			transition_out(mdbicon3.$$.fragment, local);
    			transition_out(mdbicon4.$$.fragment, local);
    			transition_out(mdbicon5.$$.fragment, local);
    			transition_out(mdbicon6.$$.fragment, local);
    			transition_out(mdbicon7.$$.fragment, local);
    			current = false;
    		},
    		d: function destroy(detaching) {
    			if (detaching) detach_dev(div0);
    			destroy_component(mdbbtn0);
    			destroy_component(mdbbtn1);
    			if (detaching) detach_dev(t2);
    			if (detaching) detach_dev(div1);
    			destroy_component(mdbicon0);
    			destroy_component(mdbicon1);
    			destroy_component(mdbicon2);
    			destroy_component(mdbicon3);
    			destroy_component(mdbicon4);
    			destroy_component(mdbicon5);
    			destroy_component(mdbicon6);
    			destroy_component(mdbicon7);
    			if (detaching) detach_dev(t10);
    			if (detaching) detach_dev(p);
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_default_slot$c.name,
    		type: "slot",
    		source: "(7:0) <MDBFooter color=\\\"blue\\\" class=\\\"text-center font-small darken-2 footer\\\">",
    		ctx
    	});

    	return block;
    }

    function create_fragment$I(ctx) {
    	let mdbfooter;
    	let current;

    	mdbfooter = new MDBFooter({
    			props: {
    				color: "blue",
    				class: "text-center font-small darken-2 footer",
    				$$slots: { default: [create_default_slot$c] },
    				$$scope: { ctx }
    			},
    			$$inline: true
    		});

    	const block = {
    		c: function create() {
    			create_component(mdbfooter.$$.fragment);
    		},
    		l: function claim(nodes) {
    			throw new Error("options.hydrate only works if the component was compiled with the `hydratable: true` option");
    		},
    		m: function mount(target, anchor) {
    			mount_component(mdbfooter, target, anchor);
    			current = true;
    		},
    		p: function update(ctx, [dirty]) {
    			const mdbfooter_changes = {};

    			if (dirty & /*$$scope*/ 1) {
    				mdbfooter_changes.$$scope = { dirty, ctx };
    			}

    			mdbfooter.$set(mdbfooter_changes);
    		},
    		i: function intro(local) {
    			if (current) return;
    			transition_in(mdbfooter.$$.fragment, local);
    			current = true;
    		},
    		o: function outro(local) {
    			transition_out(mdbfooter.$$.fragment, local);
    			current = false;
    		},
    		d: function destroy(detaching) {
    			destroy_component(mdbfooter, detaching);
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_fragment$I.name,
    		type: "component",
    		source: "",
    		ctx
    	});

    	return block;
    }

    function instance$I($$self, $$props, $$invalidate) {
    	let { $$slots: slots = {}, $$scope } = $$props;
    	validate_slots("Footer", slots, []);
    	const writable_props = [];

    	Object.keys($$props).forEach(key => {
    		if (!~writable_props.indexOf(key) && key.slice(0, 2) !== "$$") console.warn(`<Footer> was created with unknown prop '${key}'`);
    	});

    	$$self.$capture_state = () => ({ MDBFooter, MDBBtn, MDBIcon });
    	return [];
    }

    class Footer extends SvelteComponentDev {
    	constructor(options) {
    		super(options);
    		init(this, options, instance$I, create_fragment$I, safe_not_equal, {});

    		dispatch_dev("SvelteRegisterComponent", {
    			component: this,
    			tagName: "Footer",
    			options,
    			id: create_fragment$I.name
    		});
    	}
    }

    /* src/components/_layout.svelte generated by Svelte v3.37.0 */
    const file$z = "src/components/_layout.svelte";

    function create_fragment$H(ctx) {
    	let div1;
    	let topnavigation;
    	let t0;
    	let sidenavigation;
    	let t1;
    	let div0;
    	let route;
    	let t2;
    	let footer;
    	let current;
    	topnavigation = new TopNavigation({ $$inline: true });

    	sidenavigation = new SideNavigation({
    			props: {
    				segment: /*segment*/ ctx[1],
    				isOpen: /*isOpen*/ ctx[2]
    			},
    			$$inline: true
    		});

    	route = new Route({
    			props: {
    				currentRoute: /*currentRoute*/ ctx[0],
    				params: /*params*/ ctx[3]
    			},
    			$$inline: true
    		});

    	footer = new Footer({ $$inline: true });

    	const block = {
    		c: function create() {
    			div1 = element("div");
    			create_component(topnavigation.$$.fragment);
    			t0 = space();
    			create_component(sidenavigation.$$.fragment);
    			t1 = space();
    			div0 = element("div");
    			create_component(route.$$.fragment);
    			t2 = space();
    			create_component(footer.$$.fragment);
    			attr_dev(div0, "class", "px-2 pt-4 p-md-5");
    			attr_dev(div0, "id", "content");
    			add_location(div0, file$z, 17, 2, 462);
    			attr_dev(div1, "class", "flexible-content");
    			add_location(div1, file$z, 14, 0, 369);
    		},
    		l: function claim(nodes) {
    			throw new Error("options.hydrate only works if the component was compiled with the `hydratable: true` option");
    		},
    		m: function mount(target, anchor) {
    			insert_dev(target, div1, anchor);
    			mount_component(topnavigation, div1, null);
    			append_dev(div1, t0);
    			mount_component(sidenavigation, div1, null);
    			append_dev(div1, t1);
    			append_dev(div1, div0);
    			mount_component(route, div0, null);
    			append_dev(div1, t2);
    			mount_component(footer, div1, null);
    			current = true;
    		},
    		p: function update(ctx, [dirty]) {
    			const sidenavigation_changes = {};
    			if (dirty & /*segment*/ 2) sidenavigation_changes.segment = /*segment*/ ctx[1];
    			sidenavigation.$set(sidenavigation_changes);
    			const route_changes = {};
    			if (dirty & /*currentRoute*/ 1) route_changes.currentRoute = /*currentRoute*/ ctx[0];
    			route.$set(route_changes);
    		},
    		i: function intro(local) {
    			if (current) return;
    			transition_in(topnavigation.$$.fragment, local);
    			transition_in(sidenavigation.$$.fragment, local);
    			transition_in(route.$$.fragment, local);
    			transition_in(footer.$$.fragment, local);
    			current = true;
    		},
    		o: function outro(local) {
    			transition_out(topnavigation.$$.fragment, local);
    			transition_out(sidenavigation.$$.fragment, local);
    			transition_out(route.$$.fragment, local);
    			transition_out(footer.$$.fragment, local);
    			current = false;
    		},
    		d: function destroy(detaching) {
    			if (detaching) detach_dev(div1);
    			destroy_component(topnavigation);
    			destroy_component(sidenavigation);
    			destroy_component(route);
    			destroy_component(footer);
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_fragment$H.name,
    		type: "component",
    		source: "",
    		ctx
    	});

    	return block;
    }

    function instance$H($$self, $$props, $$invalidate) {
    	let { $$slots: slots = {}, $$scope } = $$props;
    	validate_slots("Layout", slots, []);
    	let { currentRoute } = $$props;
    	let { segment } = $$props;
    	let isOpen = true;
    	const params = {};
    	const writable_props = ["currentRoute", "segment"];

    	Object.keys($$props).forEach(key => {
    		if (!~writable_props.indexOf(key) && key.slice(0, 2) !== "$$") console.warn(`<Layout> was created with unknown prop '${key}'`);
    	});

    	$$self.$$set = $$props => {
    		if ("currentRoute" in $$props) $$invalidate(0, currentRoute = $$props.currentRoute);
    		if ("segment" in $$props) $$invalidate(1, segment = $$props.segment);
    	};

    	$$self.$capture_state = () => ({
    		Route,
    		SideNavigation,
    		TopNavigation,
    		Footer,
    		currentRoute,
    		segment,
    		isOpen,
    		params
    	});

    	$$self.$inject_state = $$props => {
    		if ("currentRoute" in $$props) $$invalidate(0, currentRoute = $$props.currentRoute);
    		if ("segment" in $$props) $$invalidate(1, segment = $$props.segment);
    		if ("isOpen" in $$props) $$invalidate(2, isOpen = $$props.isOpen);
    	};

    	if ($$props && "$$inject" in $$props) {
    		$$self.$inject_state($$props.$$inject);
    	}

    	return [currentRoute, segment, isOpen, params];
    }

    class Layout extends SvelteComponentDev {
    	constructor(options) {
    		super(options);
    		init(this, options, instance$H, create_fragment$H, safe_not_equal, { currentRoute: 0, segment: 1 });

    		dispatch_dev("SvelteRegisterComponent", {
    			component: this,
    			tagName: "Layout",
    			options,
    			id: create_fragment$H.name
    		});

    		const { ctx } = this.$$;
    		const props = options.props || {};

    		if (/*currentRoute*/ ctx[0] === undefined && !("currentRoute" in props)) {
    			console.warn("<Layout> was created without expected prop 'currentRoute'");
    		}

    		if (/*segment*/ ctx[1] === undefined && !("segment" in props)) {
    			console.warn("<Layout> was created without expected prop 'segment'");
    		}
    	}

    	get currentRoute() {
    		throw new Error("<Layout>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	set currentRoute(value) {
    		throw new Error("<Layout>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	get segment() {
    		throw new Error("<Layout>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	set segment(value) {
    		throw new Error("<Layout>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}
    }

    /* node_modules/mdbsvelte/src/MDBRow.svelte generated by Svelte v3.37.0 */
    const file$y = "node_modules/mdbsvelte/src/MDBRow.svelte";

    function create_fragment$G(ctx) {
    	let div;
    	let div_class_value;
    	let current;
    	let mounted;
    	let dispose;
    	const default_slot_template = /*#slots*/ ctx[7].default;
    	const default_slot = create_slot(default_slot_template, ctx, /*$$scope*/ ctx[6], null);

    	let div_levels = [
    		/*props*/ ctx[1],
    		{
    			class: div_class_value = /*rowClasses*/ ctx[2].join(" ")
    		}
    	];

    	let div_data = {};

    	for (let i = 0; i < div_levels.length; i += 1) {
    		div_data = assign(div_data, div_levels[i]);
    	}

    	const block = {
    		c: function create() {
    			div = element("div");
    			if (default_slot) default_slot.c();
    			set_attributes(div, div_data);
    			add_location(div, file$y, 34, 0, 768);
    		},
    		l: function claim(nodes) {
    			throw new Error("options.hydrate only works if the component was compiled with the `hydratable: true` option");
    		},
    		m: function mount(target, anchor) {
    			insert_dev(target, div, anchor);

    			if (default_slot) {
    				default_slot.m(div, null);
    			}

    			current = true;

    			if (!mounted) {
    				dispose = action_destroyer(/*forwardEvents*/ ctx[0].call(null, div));
    				mounted = true;
    			}
    		},
    		p: function update(ctx, [dirty]) {
    			if (default_slot) {
    				if (default_slot.p && dirty & /*$$scope*/ 64) {
    					update_slot(default_slot, default_slot_template, ctx, /*$$scope*/ ctx[6], dirty, null, null);
    				}
    			}

    			set_attributes(div, div_data = get_spread_update(div_levels, [/*props*/ ctx[1], { class: div_class_value }]));
    		},
    		i: function intro(local) {
    			if (current) return;
    			transition_in(default_slot, local);
    			current = true;
    		},
    		o: function outro(local) {
    			transition_out(default_slot, local);
    			current = false;
    		},
    		d: function destroy(detaching) {
    			if (detaching) detach_dev(div);
    			if (default_slot) default_slot.d(detaching);
    			mounted = false;
    			dispose();
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_fragment$G.name,
    		type: "component",
    		source: "",
    		ctx
    	});

    	return block;
    }

    function instance$G($$self, $$props, $$invalidate) {
    	let { $$slots: slots = {}, $$scope } = $$props;
    	validate_slots("MDBRow", slots, ['default']);
    	const forwardEvents = forwardEventsBuilder(current_component);
    	let { class: className = "" } = $$props;
    	let { noGutters = false } = $$props;
    	let { form = false } = $$props;
    	const props = clean$1($$props, []);
    	let rowClasses = [];
    	let position = ["start", "center", "end", "around", "between"];

    	for (let pos in position) {
    		if (props[position[pos]]) {
    			rowClasses.push(`justify-content-${position[pos]}`);
    		}
    	}

    	if (className) {
    		rowClasses.push(className);
    	}

    	if (form) {
    		rowClasses.push("form-row");
    	} else {
    		rowClasses.push("row");
    	}

    	if (noGutters) {
    		rowClasses.push("no-gutters");
    	}

    	$$self.$$set = $$new_props => {
    		$$invalidate(9, $$props = assign(assign({}, $$props), exclude_internal_props($$new_props)));
    		if ("class" in $$new_props) $$invalidate(3, className = $$new_props.class);
    		if ("noGutters" in $$new_props) $$invalidate(4, noGutters = $$new_props.noGutters);
    		if ("form" in $$new_props) $$invalidate(5, form = $$new_props.form);
    		if ("$$scope" in $$new_props) $$invalidate(6, $$scope = $$new_props.$$scope);
    	};

    	$$self.$capture_state = () => ({
    		clean: clean$1,
    		clsx,
    		forwardEventsBuilder,
    		current_component,
    		forwardEvents,
    		className,
    		noGutters,
    		form,
    		props,
    		rowClasses,
    		position
    	});

    	$$self.$inject_state = $$new_props => {
    		$$invalidate(9, $$props = assign(assign({}, $$props), $$new_props));
    		if ("className" in $$props) $$invalidate(3, className = $$new_props.className);
    		if ("noGutters" in $$props) $$invalidate(4, noGutters = $$new_props.noGutters);
    		if ("form" in $$props) $$invalidate(5, form = $$new_props.form);
    		if ("rowClasses" in $$props) $$invalidate(2, rowClasses = $$new_props.rowClasses);
    		if ("position" in $$props) position = $$new_props.position;
    	};

    	if ($$props && "$$inject" in $$props) {
    		$$self.$inject_state($$props.$$inject);
    	}

    	$$props = exclude_internal_props($$props);
    	return [forwardEvents, props, rowClasses, className, noGutters, form, $$scope, slots];
    }

    class MDBRow extends SvelteComponentDev {
    	constructor(options) {
    		super(options);
    		init(this, options, instance$G, create_fragment$G, safe_not_equal, { class: 3, noGutters: 4, form: 5 });

    		dispatch_dev("SvelteRegisterComponent", {
    			component: this,
    			tagName: "MDBRow",
    			options,
    			id: create_fragment$G.name
    		});
    	}

    	get class() {
    		throw new Error("<MDBRow>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	set class(value) {
    		throw new Error("<MDBRow>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	get noGutters() {
    		throw new Error("<MDBRow>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	set noGutters(value) {
    		throw new Error("<MDBRow>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	get form() {
    		throw new Error("<MDBRow>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	set form(value) {
    		throw new Error("<MDBRow>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}
    }

    /* node_modules/mdbsvelte/src/MDBCol.svelte generated by Svelte v3.37.0 */
    const file$x = "node_modules/mdbsvelte/src/MDBCol.svelte";

    function create_fragment$F(ctx) {
    	let div;
    	let div_class_value;
    	let current;
    	let mounted;
    	let dispose;
    	const default_slot_template = /*#slots*/ ctx[6].default;
    	const default_slot = create_slot(default_slot_template, ctx, /*$$scope*/ ctx[5], null);

    	let div_levels = [
    		/*props*/ ctx[2],
    		{
    			class: div_class_value = /*colClasses*/ ctx[1].join(" ")
    		}
    	];

    	let div_data = {};

    	for (let i = 0; i < div_levels.length; i += 1) {
    		div_data = assign(div_data, div_levels[i]);
    	}

    	const block = {
    		c: function create() {
    			div = element("div");
    			if (default_slot) default_slot.c();
    			set_attributes(div, div_data);
    			add_location(div, file$x, 56, 0, 1525);
    		},
    		l: function claim(nodes) {
    			throw new Error("options.hydrate only works if the component was compiled with the `hydratable: true` option");
    		},
    		m: function mount(target, anchor) {
    			insert_dev(target, div, anchor);

    			if (default_slot) {
    				default_slot.m(div, null);
    			}

    			current = true;

    			if (!mounted) {
    				dispose = action_destroyer(/*forwardEvents*/ ctx[0].call(null, div));
    				mounted = true;
    			}
    		},
    		p: function update(ctx, [dirty]) {
    			if (default_slot) {
    				if (default_slot.p && dirty & /*$$scope*/ 32) {
    					update_slot(default_slot, default_slot_template, ctx, /*$$scope*/ ctx[5], dirty, null, null);
    				}
    			}

    			set_attributes(div, div_data = get_spread_update(div_levels, [/*props*/ ctx[2], { class: div_class_value }]));
    		},
    		i: function intro(local) {
    			if (current) return;
    			transition_in(default_slot, local);
    			current = true;
    		},
    		o: function outro(local) {
    			transition_out(default_slot, local);
    			current = false;
    		},
    		d: function destroy(detaching) {
    			if (detaching) detach_dev(div);
    			if (default_slot) default_slot.d(detaching);
    			mounted = false;
    			dispose();
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_fragment$F.name,
    		type: "component",
    		source: "",
    		ctx
    	});

    	return block;
    }

    function instance$F($$self, $$props, $$invalidate) {
    	let { $$slots: slots = {}, $$scope } = $$props;
    	validate_slots("MDBCol", slots, ['default']);
    	const forwardEvents = forwardEventsBuilder(current_component);
    	let { class: className = "" } = $$props;
    	let { size } = $$props;
    	const colClasses = [];
    	const widths = ["xs", "sm", "md", "lg", "xl"];
    	const props = clean$1($$props, [...widths].concat(["size"]));

    	widths.forEach(colWidth => {
    		const columnProp = $$props[colWidth];

    		if (!columnProp && columnProp !== "") {
    			return; //no value for this width
    		}

    		const isXs = colWidth === "xs";

    		if (isObject(columnProp)) {
    			const colSizeInterfix = isXs ? "-" : `-${colWidth}-`;
    			const colClass = getColumnSizeClass(isXs, colWidth, columnProp.size);

    			if (columnProp.size || columnProp.size === "") {
    				colClasses.push(colClass);
    			}

    			if (columnProp.push) {
    				colClasses.push(`push${colSizeInterfix}${columnProp.push}`);
    			}

    			if (columnProp.pull) {
    				colClasses.push(`pull${colSizeInterfix}${columnProp.pull}`);
    			}

    			if (columnProp.offset) {
    				colClasses.push(`offset${colSizeInterfix}${columnProp.offset}`);
    			}
    		} else {
    			colClasses.push(getColumnSizeClass(isXs, colWidth, columnProp));
    		}
    	});

    	if (size) {
    		colClasses.push(`col-${size}`);
    	}

    	if (!colClasses.length) {
    		colClasses.push("col");
    	}

    	if (className) {
    		colClasses.push(className);
    	}

    	$$self.$$set = $$new_props => {
    		$$invalidate(8, $$props = assign(assign({}, $$props), exclude_internal_props($$new_props)));
    		if ("class" in $$new_props) $$invalidate(3, className = $$new_props.class);
    		if ("size" in $$new_props) $$invalidate(4, size = $$new_props.size);
    		if ("$$scope" in $$new_props) $$invalidate(5, $$scope = $$new_props.$$scope);
    	};

    	$$self.$capture_state = () => ({
    		clean: clean$1,
    		clsx,
    		forwardEventsBuilder,
    		current_component,
    		forwardEvents,
    		getColumnSizeClass,
    		isObject,
    		className,
    		size,
    		colClasses,
    		widths,
    		props
    	});

    	$$self.$inject_state = $$new_props => {
    		$$invalidate(8, $$props = assign(assign({}, $$props), $$new_props));
    		if ("className" in $$props) $$invalidate(3, className = $$new_props.className);
    		if ("size" in $$props) $$invalidate(4, size = $$new_props.size);
    	};

    	if ($$props && "$$inject" in $$props) {
    		$$self.$inject_state($$props.$$inject);
    	}

    	$$props = exclude_internal_props($$props);
    	return [forwardEvents, colClasses, props, className, size, $$scope, slots];
    }

    class MDBCol extends SvelteComponentDev {
    	constructor(options) {
    		super(options);
    		init(this, options, instance$F, create_fragment$F, safe_not_equal, { class: 3, size: 4 });

    		dispatch_dev("SvelteRegisterComponent", {
    			component: this,
    			tagName: "MDBCol",
    			options,
    			id: create_fragment$F.name
    		});

    		const { ctx } = this.$$;
    		const props = options.props || {};

    		if (/*size*/ ctx[4] === undefined && !("size" in props)) {
    			console.warn("<MDBCol> was created without expected prop 'size'");
    		}
    	}

    	get class() {
    		throw new Error("<MDBCol>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	set class(value) {
    		throw new Error("<MDBCol>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	get size() {
    		throw new Error("<MDBCol>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	set size(value) {
    		throw new Error("<MDBCol>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}
    }

    /* node_modules/mdbsvelte/src/MDBCard.svelte generated by Svelte v3.37.0 */
    const file$w = "node_modules/mdbsvelte/src/MDBCard.svelte";

    function create_fragment$E(ctx) {
    	let div;
    	let current;
    	let mounted;
    	let dispose;
    	const default_slot_template = /*#slots*/ ctx[10].default;
    	const default_slot = create_slot(default_slot_template, ctx, /*$$scope*/ ctx[9], null);
    	let div_levels = [/*props*/ ctx[3], { class: /*classes*/ ctx[1] }, { style: /*style*/ ctx[0] }];
    	let div_data = {};

    	for (let i = 0; i < div_levels.length; i += 1) {
    		div_data = assign(div_data, div_levels[i]);
    	}

    	const block = {
    		c: function create() {
    			div = element("div");
    			if (default_slot) default_slot.c();
    			set_attributes(div, div_data);
    			add_location(div, file$w, 27, 0, 673);
    		},
    		l: function claim(nodes) {
    			throw new Error("options.hydrate only works if the component was compiled with the `hydratable: true` option");
    		},
    		m: function mount(target, anchor) {
    			insert_dev(target, div, anchor);

    			if (default_slot) {
    				default_slot.m(div, null);
    			}

    			current = true;

    			if (!mounted) {
    				dispose = action_destroyer(/*forwardEvents*/ ctx[2].call(null, div));
    				mounted = true;
    			}
    		},
    		p: function update(ctx, [dirty]) {
    			if (default_slot) {
    				if (default_slot.p && dirty & /*$$scope*/ 512) {
    					update_slot(default_slot, default_slot_template, ctx, /*$$scope*/ ctx[9], dirty, null, null);
    				}
    			}

    			set_attributes(div, div_data = get_spread_update(div_levels, [
    				/*props*/ ctx[3],
    				(!current || dirty & /*classes*/ 2) && { class: /*classes*/ ctx[1] },
    				(!current || dirty & /*style*/ 1) && { style: /*style*/ ctx[0] }
    			]));
    		},
    		i: function intro(local) {
    			if (current) return;
    			transition_in(default_slot, local);
    			current = true;
    		},
    		o: function outro(local) {
    			transition_out(default_slot, local);
    			current = false;
    		},
    		d: function destroy(detaching) {
    			if (detaching) detach_dev(div);
    			if (default_slot) default_slot.d(detaching);
    			mounted = false;
    			dispose();
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_fragment$E.name,
    		type: "component",
    		source: "",
    		ctx
    	});

    	return block;
    }

    function instance$E($$self, $$props, $$invalidate) {
    	let classes;
    	let { $$slots: slots = {}, $$scope } = $$props;
    	validate_slots("MDBCard", slots, ['default']);
    	const forwardEvents = forwardEventsBuilder(current_component);
    	let { class: className = "" } = $$props;
    	let { body = false } = $$props;
    	let { color = "" } = $$props;
    	let { inverse = false } = $$props;
    	let { outline = false } = $$props;
    	let { style = "" } = $$props;
    	const props = clean$1($$props);

    	$$self.$$set = $$new_props => {
    		$$invalidate(11, $$props = assign(assign({}, $$props), exclude_internal_props($$new_props)));
    		if ("class" in $$new_props) $$invalidate(4, className = $$new_props.class);
    		if ("body" in $$new_props) $$invalidate(5, body = $$new_props.body);
    		if ("color" in $$new_props) $$invalidate(6, color = $$new_props.color);
    		if ("inverse" in $$new_props) $$invalidate(7, inverse = $$new_props.inverse);
    		if ("outline" in $$new_props) $$invalidate(8, outline = $$new_props.outline);
    		if ("style" in $$new_props) $$invalidate(0, style = $$new_props.style);
    		if ("$$scope" in $$new_props) $$invalidate(9, $$scope = $$new_props.$$scope);
    	};

    	$$self.$capture_state = () => ({
    		clean: clean$1,
    		clsx,
    		forwardEventsBuilder,
    		getColorClass,
    		current_component,
    		forwardEvents,
    		className,
    		body,
    		color,
    		inverse,
    		outline,
    		style,
    		props,
    		classes
    	});

    	$$self.$inject_state = $$new_props => {
    		$$invalidate(11, $$props = assign(assign({}, $$props), $$new_props));
    		if ("className" in $$props) $$invalidate(4, className = $$new_props.className);
    		if ("body" in $$props) $$invalidate(5, body = $$new_props.body);
    		if ("color" in $$props) $$invalidate(6, color = $$new_props.color);
    		if ("inverse" in $$props) $$invalidate(7, inverse = $$new_props.inverse);
    		if ("outline" in $$props) $$invalidate(8, outline = $$new_props.outline);
    		if ("style" in $$props) $$invalidate(0, style = $$new_props.style);
    		if ("classes" in $$props) $$invalidate(1, classes = $$new_props.classes);
    	};

    	if ($$props && "$$inject" in $$props) {
    		$$self.$inject_state($$props.$$inject);
    	}

    	$$self.$$.update = () => {
    		if ($$self.$$.dirty & /*className, inverse, body, color, outline*/ 496) {
    			$$invalidate(1, classes = clsx(className, "card", inverse ? "text-white" : false, body ? "card-body" : false, color & outline ? `border-${color}` : false, color && !outline ? `${getColorClass(color)}` : false));
    		}
    	};

    	$$props = exclude_internal_props($$props);

    	return [
    		style,
    		classes,
    		forwardEvents,
    		props,
    		className,
    		body,
    		color,
    		inverse,
    		outline,
    		$$scope,
    		slots
    	];
    }

    class MDBCard extends SvelteComponentDev {
    	constructor(options) {
    		super(options);

    		init(this, options, instance$E, create_fragment$E, safe_not_equal, {
    			class: 4,
    			body: 5,
    			color: 6,
    			inverse: 7,
    			outline: 8,
    			style: 0
    		});

    		dispatch_dev("SvelteRegisterComponent", {
    			component: this,
    			tagName: "MDBCard",
    			options,
    			id: create_fragment$E.name
    		});
    	}

    	get class() {
    		throw new Error("<MDBCard>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	set class(value) {
    		throw new Error("<MDBCard>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	get body() {
    		throw new Error("<MDBCard>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	set body(value) {
    		throw new Error("<MDBCard>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	get color() {
    		throw new Error("<MDBCard>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	set color(value) {
    		throw new Error("<MDBCard>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	get inverse() {
    		throw new Error("<MDBCard>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	set inverse(value) {
    		throw new Error("<MDBCard>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	get outline() {
    		throw new Error("<MDBCard>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	set outline(value) {
    		throw new Error("<MDBCard>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	get style() {
    		throw new Error("<MDBCard>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	set style(value) {
    		throw new Error("<MDBCard>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}
    }

    /* node_modules/mdbsvelte/src/MDBCardBody.svelte generated by Svelte v3.37.0 */
    const file$v = "node_modules/mdbsvelte/src/MDBCardBody.svelte";

    function create_fragment$D(ctx) {
    	let div;
    	let current;
    	let mounted;
    	let dispose;
    	const default_slot_template = /*#slots*/ ctx[5].default;
    	const default_slot = create_slot(default_slot_template, ctx, /*$$scope*/ ctx[4], null);
    	let div_levels = [/*props*/ ctx[2], { class: /*classes*/ ctx[0] }];
    	let div_data = {};

    	for (let i = 0; i < div_levels.length; i += 1) {
    		div_data = assign(div_data, div_levels[i]);
    	}

    	const block = {
    		c: function create() {
    			div = element("div");
    			if (default_slot) default_slot.c();
    			set_attributes(div, div_data);
    			add_location(div, file$v, 14, 0, 331);
    		},
    		l: function claim(nodes) {
    			throw new Error("options.hydrate only works if the component was compiled with the `hydratable: true` option");
    		},
    		m: function mount(target, anchor) {
    			insert_dev(target, div, anchor);

    			if (default_slot) {
    				default_slot.m(div, null);
    			}

    			current = true;

    			if (!mounted) {
    				dispose = action_destroyer(/*forwardEvents*/ ctx[1].call(null, div));
    				mounted = true;
    			}
    		},
    		p: function update(ctx, [dirty]) {
    			if (default_slot) {
    				if (default_slot.p && dirty & /*$$scope*/ 16) {
    					update_slot(default_slot, default_slot_template, ctx, /*$$scope*/ ctx[4], dirty, null, null);
    				}
    			}

    			set_attributes(div, div_data = get_spread_update(div_levels, [
    				/*props*/ ctx[2],
    				(!current || dirty & /*classes*/ 1) && { class: /*classes*/ ctx[0] }
    			]));
    		},
    		i: function intro(local) {
    			if (current) return;
    			transition_in(default_slot, local);
    			current = true;
    		},
    		o: function outro(local) {
    			transition_out(default_slot, local);
    			current = false;
    		},
    		d: function destroy(detaching) {
    			if (detaching) detach_dev(div);
    			if (default_slot) default_slot.d(detaching);
    			mounted = false;
    			dispose();
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_fragment$D.name,
    		type: "component",
    		source: "",
    		ctx
    	});

    	return block;
    }

    function instance$D($$self, $$props, $$invalidate) {
    	let classes;
    	let { $$slots: slots = {}, $$scope } = $$props;
    	validate_slots("MDBCardBody", slots, ['default']);
    	const forwardEvents = forwardEventsBuilder(current_component);
    	let { class: className = "" } = $$props;
    	const props = clean$1($$props);

    	$$self.$$set = $$new_props => {
    		$$invalidate(6, $$props = assign(assign({}, $$props), exclude_internal_props($$new_props)));
    		if ("class" in $$new_props) $$invalidate(3, className = $$new_props.class);
    		if ("$$scope" in $$new_props) $$invalidate(4, $$scope = $$new_props.$$scope);
    	};

    	$$self.$capture_state = () => ({
    		clean: clean$1,
    		clsx,
    		forwardEventsBuilder,
    		current_component,
    		forwardEvents,
    		className,
    		props,
    		classes
    	});

    	$$self.$inject_state = $$new_props => {
    		$$invalidate(6, $$props = assign(assign({}, $$props), $$new_props));
    		if ("className" in $$props) $$invalidate(3, className = $$new_props.className);
    		if ("classes" in $$props) $$invalidate(0, classes = $$new_props.classes);
    	};

    	if ($$props && "$$inject" in $$props) {
    		$$self.$inject_state($$props.$$inject);
    	}

    	$$self.$$.update = () => {
    		if ($$self.$$.dirty & /*className*/ 8) {
    			$$invalidate(0, classes = clsx(className, "card-body"));
    		}
    	};

    	$$props = exclude_internal_props($$props);
    	return [classes, forwardEvents, props, className, $$scope, slots];
    }

    class MDBCardBody extends SvelteComponentDev {
    	constructor(options) {
    		super(options);
    		init(this, options, instance$D, create_fragment$D, safe_not_equal, { class: 3 });

    		dispatch_dev("SvelteRegisterComponent", {
    			component: this,
    			tagName: "MDBCardBody",
    			options,
    			id: create_fragment$D.name
    		});
    	}

    	get class() {
    		throw new Error("<MDBCardBody>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	set class(value) {
    		throw new Error("<MDBCardBody>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}
    }

    /* node_modules/mdbsvelte/src/MDBCardText.svelte generated by Svelte v3.37.0 */
    const file$u = "node_modules/mdbsvelte/src/MDBCardText.svelte";

    function create_fragment$C(ctx) {
    	let p;
    	let current;
    	let mounted;
    	let dispose;
    	const default_slot_template = /*#slots*/ ctx[5].default;
    	const default_slot = create_slot(default_slot_template, ctx, /*$$scope*/ ctx[4], null);
    	let p_levels = [/*props*/ ctx[2], { class: /*classes*/ ctx[0] }];
    	let p_data = {};

    	for (let i = 0; i < p_levels.length; i += 1) {
    		p_data = assign(p_data, p_levels[i]);
    	}

    	const block = {
    		c: function create() {
    			p = element("p");
    			if (default_slot) default_slot.c();
    			set_attributes(p, p_data);
    			add_location(p, file$u, 13, 0, 330);
    		},
    		l: function claim(nodes) {
    			throw new Error("options.hydrate only works if the component was compiled with the `hydratable: true` option");
    		},
    		m: function mount(target, anchor) {
    			insert_dev(target, p, anchor);

    			if (default_slot) {
    				default_slot.m(p, null);
    			}

    			current = true;

    			if (!mounted) {
    				dispose = action_destroyer(/*forwardEvents*/ ctx[1].call(null, p));
    				mounted = true;
    			}
    		},
    		p: function update(ctx, [dirty]) {
    			if (default_slot) {
    				if (default_slot.p && dirty & /*$$scope*/ 16) {
    					update_slot(default_slot, default_slot_template, ctx, /*$$scope*/ ctx[4], dirty, null, null);
    				}
    			}

    			set_attributes(p, p_data = get_spread_update(p_levels, [
    				/*props*/ ctx[2],
    				(!current || dirty & /*classes*/ 1) && { class: /*classes*/ ctx[0] }
    			]));
    		},
    		i: function intro(local) {
    			if (current) return;
    			transition_in(default_slot, local);
    			current = true;
    		},
    		o: function outro(local) {
    			transition_out(default_slot, local);
    			current = false;
    		},
    		d: function destroy(detaching) {
    			if (detaching) detach_dev(p);
    			if (default_slot) default_slot.d(detaching);
    			mounted = false;
    			dispose();
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_fragment$C.name,
    		type: "component",
    		source: "",
    		ctx
    	});

    	return block;
    }

    function instance$C($$self, $$props, $$invalidate) {
    	let classes;
    	let { $$slots: slots = {}, $$scope } = $$props;
    	validate_slots("MDBCardText", slots, ['default']);
    	const forwardEvents = forwardEventsBuilder(current_component);
    	let { class: className = "" } = $$props;
    	const props = clean$1($$props);

    	$$self.$$set = $$new_props => {
    		$$invalidate(6, $$props = assign(assign({}, $$props), exclude_internal_props($$new_props)));
    		if ("class" in $$new_props) $$invalidate(3, className = $$new_props.class);
    		if ("$$scope" in $$new_props) $$invalidate(4, $$scope = $$new_props.$$scope);
    	};

    	$$self.$capture_state = () => ({
    		clean: clean$1,
    		clsx,
    		forwardEventsBuilder,
    		current_component,
    		forwardEvents,
    		className,
    		props,
    		classes
    	});

    	$$self.$inject_state = $$new_props => {
    		$$invalidate(6, $$props = assign(assign({}, $$props), $$new_props));
    		if ("className" in $$props) $$invalidate(3, className = $$new_props.className);
    		if ("classes" in $$props) $$invalidate(0, classes = $$new_props.classes);
    	};

    	if ($$props && "$$inject" in $$props) {
    		$$self.$inject_state($$props.$$inject);
    	}

    	$$self.$$.update = () => {
    		if ($$self.$$.dirty & /*className*/ 8) {
    			$$invalidate(0, classes = clsx(className, "card-text"));
    		}
    	};

    	$$props = exclude_internal_props($$props);
    	return [classes, forwardEvents, props, className, $$scope, slots];
    }

    class MDBCardText extends SvelteComponentDev {
    	constructor(options) {
    		super(options);
    		init(this, options, instance$C, create_fragment$C, safe_not_equal, { class: 3 });

    		dispatch_dev("SvelteRegisterComponent", {
    			component: this,
    			tagName: "MDBCardText",
    			options,
    			id: create_fragment$C.name
    		});
    	}

    	get class() {
    		throw new Error("<MDBCardText>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	set class(value) {
    		throw new Error("<MDBCardText>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}
    }

    /* src/components/pages/sections/AdminCardSection1.svelte generated by Svelte v3.37.0 */
    const file$t = "src/components/pages/sections/AdminCardSection1.svelte";

    // (27:8) <MDBCardText>
    function create_default_slot_16$5(ctx) {
    	let t;

    	const block = {
    		c: function create() {
    			t = text("Better than last week (25%)");
    		},
    		m: function mount(target, anchor) {
    			insert_dev(target, t, anchor);
    		},
    		d: function destroy(detaching) {
    			if (detaching) detach_dev(t);
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_default_slot_16$5.name,
    		type: "slot",
    		source: "(27:8) <MDBCardText>",
    		ctx
    	});

    	return block;
    }

    // (22:6) <MDBCardBody>
    function create_default_slot_15$5(ctx) {
    	let div1;
    	let div0;
    	let t;
    	let mdbcardtext;
    	let current;

    	mdbcardtext = new MDBCardText({
    			props: {
    				$$slots: { default: [create_default_slot_16$5] },
    				$$scope: { ctx }
    			},
    			$$inline: true
    		});

    	const block = {
    		c: function create() {
    			div1 = element("div");
    			div0 = element("div");
    			t = space();
    			create_component(mdbcardtext.$$.fragment);
    			attr_dev(div0, "aria-valuemax", "100");
    			attr_dev(div0, "aria-valuemin", "0");
    			attr_dev(div0, "aria-valuenow", "25");
    			attr_dev(div0, "class", "progress-bar bg-primary");
    			attr_dev(div0, "role", "progressbar");
    			set_style(div0, "width", "25%");
    			add_location(div0, file$t, 23, 10, 754);
    			attr_dev(div1, "class", "progress");
    			add_location(div1, file$t, 22, 8, 721);
    		},
    		m: function mount(target, anchor) {
    			insert_dev(target, div1, anchor);
    			append_dev(div1, div0);
    			insert_dev(target, t, anchor);
    			mount_component(mdbcardtext, target, anchor);
    			current = true;
    		},
    		p: function update(ctx, dirty) {
    			const mdbcardtext_changes = {};

    			if (dirty & /*$$scope*/ 1) {
    				mdbcardtext_changes.$$scope = { dirty, ctx };
    			}

    			mdbcardtext.$set(mdbcardtext_changes);
    		},
    		i: function intro(local) {
    			if (current) return;
    			transition_in(mdbcardtext.$$.fragment, local);
    			current = true;
    		},
    		o: function outro(local) {
    			transition_out(mdbcardtext.$$.fragment, local);
    			current = false;
    		},
    		d: function destroy(detaching) {
    			if (detaching) detach_dev(div1);
    			if (detaching) detach_dev(t);
    			destroy_component(mdbcardtext, detaching);
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_default_slot_15$5.name,
    		type: "slot",
    		source: "(22:6) <MDBCardBody>",
    		ctx
    	});

    	return block;
    }

    // (12:4) <MDBCard class="cascading-admin-card">
    function create_default_slot_14$5(ctx) {
    	let div1;
    	let mdbicon;
    	let t0;
    	let div0;
    	let p;
    	let t2;
    	let h4;
    	let strong;
    	let t4;
    	let mdbcardbody;
    	let current;

    	mdbicon = new MDBIcon({
    			props: {
    				fas: true,
    				icon: "money-bill-alt",
    				class: "primary-color"
    			},
    			$$inline: true
    		});

    	mdbcardbody = new MDBCardBody({
    			props: {
    				$$slots: { default: [create_default_slot_15$5] },
    				$$scope: { ctx }
    			},
    			$$inline: true
    		});

    	const block = {
    		c: function create() {
    			div1 = element("div");
    			create_component(mdbicon.$$.fragment);
    			t0 = space();
    			div0 = element("div");
    			p = element("p");
    			p.textContent = "SALES";
    			t2 = space();
    			h4 = element("h4");
    			strong = element("strong");
    			strong.textContent = "$2000";
    			t4 = space();
    			create_component(mdbcardbody.$$.fragment);
    			add_location(p, file$t, 15, 10, 586);
    			add_location(strong, file$t, 17, 12, 626);
    			add_location(h4, file$t, 16, 10, 609);
    			attr_dev(div0, "class", "data");
    			add_location(div0, file$t, 14, 8, 557);
    			attr_dev(div1, "class", "admin-up");
    			add_location(div1, file$t, 12, 6, 459);
    		},
    		m: function mount(target, anchor) {
    			insert_dev(target, div1, anchor);
    			mount_component(mdbicon, div1, null);
    			append_dev(div1, t0);
    			append_dev(div1, div0);
    			append_dev(div0, p);
    			append_dev(div0, t2);
    			append_dev(div0, h4);
    			append_dev(h4, strong);
    			insert_dev(target, t4, anchor);
    			mount_component(mdbcardbody, target, anchor);
    			current = true;
    		},
    		p: function update(ctx, dirty) {
    			const mdbcardbody_changes = {};

    			if (dirty & /*$$scope*/ 1) {
    				mdbcardbody_changes.$$scope = { dirty, ctx };
    			}

    			mdbcardbody.$set(mdbcardbody_changes);
    		},
    		i: function intro(local) {
    			if (current) return;
    			transition_in(mdbicon.$$.fragment, local);
    			transition_in(mdbcardbody.$$.fragment, local);
    			current = true;
    		},
    		o: function outro(local) {
    			transition_out(mdbicon.$$.fragment, local);
    			transition_out(mdbcardbody.$$.fragment, local);
    			current = false;
    		},
    		d: function destroy(detaching) {
    			if (detaching) detach_dev(div1);
    			destroy_component(mdbicon);
    			if (detaching) detach_dev(t4);
    			destroy_component(mdbcardbody, detaching);
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_default_slot_14$5.name,
    		type: "slot",
    		source: "(12:4) <MDBCard class=\\\"cascading-admin-card\\\">",
    		ctx
    	});

    	return block;
    }

    // (11:2) <MDBCol xl="3" md="6" class="mb-r">
    function create_default_slot_13$5(ctx) {
    	let mdbcard;
    	let current;

    	mdbcard = new MDBCard({
    			props: {
    				class: "cascading-admin-card",
    				$$slots: { default: [create_default_slot_14$5] },
    				$$scope: { ctx }
    			},
    			$$inline: true
    		});

    	const block = {
    		c: function create() {
    			create_component(mdbcard.$$.fragment);
    		},
    		m: function mount(target, anchor) {
    			mount_component(mdbcard, target, anchor);
    			current = true;
    		},
    		p: function update(ctx, dirty) {
    			const mdbcard_changes = {};

    			if (dirty & /*$$scope*/ 1) {
    				mdbcard_changes.$$scope = { dirty, ctx };
    			}

    			mdbcard.$set(mdbcard_changes);
    		},
    		i: function intro(local) {
    			if (current) return;
    			transition_in(mdbcard.$$.fragment, local);
    			current = true;
    		},
    		o: function outro(local) {
    			transition_out(mdbcard.$$.fragment, local);
    			current = false;
    		},
    		d: function destroy(detaching) {
    			destroy_component(mdbcard, detaching);
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_default_slot_13$5.name,
    		type: "slot",
    		source: "(11:2) <MDBCol xl=\\\"3\\\" md=\\\"6\\\" class=\\\"mb-r\\\">",
    		ctx
    	});

    	return block;
    }

    // (47:8) <MDBCardText>
    function create_default_slot_12$8(ctx) {
    	let t;

    	const block = {
    		c: function create() {
    			t = text("Worse than last week (25%)");
    		},
    		m: function mount(target, anchor) {
    			insert_dev(target, t, anchor);
    		},
    		d: function destroy(detaching) {
    			if (detaching) detach_dev(t);
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_default_slot_12$8.name,
    		type: "slot",
    		source: "(47:8) <MDBCardText>",
    		ctx
    	});

    	return block;
    }

    // (42:6) <MDBCardBody>
    function create_default_slot_11$8(ctx) {
    	let div1;
    	let div0;
    	let t;
    	let mdbcardtext;
    	let current;

    	mdbcardtext = new MDBCardText({
    			props: {
    				$$slots: { default: [create_default_slot_12$8] },
    				$$scope: { ctx }
    			},
    			$$inline: true
    		});

    	const block = {
    		c: function create() {
    			div1 = element("div");
    			div0 = element("div");
    			t = space();
    			create_component(mdbcardtext.$$.fragment);
    			attr_dev(div0, "aria-valuemax", "100");
    			attr_dev(div0, "aria-valuemin", "0");
    			attr_dev(div0, "aria-valuenow", "25");
    			attr_dev(div0, "class", "progress-bar bg grey");
    			attr_dev(div0, "role", "progressbar");
    			set_style(div0, "width", "25%");
    			add_location(div0, file$t, 43, 10, 1418);
    			attr_dev(div1, "class", "progress");
    			add_location(div1, file$t, 42, 8, 1385);
    		},
    		m: function mount(target, anchor) {
    			insert_dev(target, div1, anchor);
    			append_dev(div1, div0);
    			insert_dev(target, t, anchor);
    			mount_component(mdbcardtext, target, anchor);
    			current = true;
    		},
    		p: function update(ctx, dirty) {
    			const mdbcardtext_changes = {};

    			if (dirty & /*$$scope*/ 1) {
    				mdbcardtext_changes.$$scope = { dirty, ctx };
    			}

    			mdbcardtext.$set(mdbcardtext_changes);
    		},
    		i: function intro(local) {
    			if (current) return;
    			transition_in(mdbcardtext.$$.fragment, local);
    			current = true;
    		},
    		o: function outro(local) {
    			transition_out(mdbcardtext.$$.fragment, local);
    			current = false;
    		},
    		d: function destroy(detaching) {
    			if (detaching) detach_dev(div1);
    			if (detaching) detach_dev(t);
    			destroy_component(mdbcardtext, detaching);
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_default_slot_11$8.name,
    		type: "slot",
    		source: "(42:6) <MDBCardBody>",
    		ctx
    	});

    	return block;
    }

    // (32:4) <MDBCard class="cascading-admin-card">
    function create_default_slot_10$8(ctx) {
    	let div1;
    	let mdbicon;
    	let t0;
    	let div0;
    	let p;
    	let t2;
    	let h4;
    	let strong;
    	let t4;
    	let mdbcardbody;
    	let current;

    	mdbicon = new MDBIcon({
    			props: {
    				fas: true,
    				icon: "chart-line",
    				class: "warning-color"
    			},
    			$$inline: true
    		});

    	mdbcardbody = new MDBCardBody({
    			props: {
    				$$slots: { default: [create_default_slot_11$8] },
    				$$scope: { ctx }
    			},
    			$$inline: true
    		});

    	const block = {
    		c: function create() {
    			div1 = element("div");
    			create_component(mdbicon.$$.fragment);
    			t0 = space();
    			div0 = element("div");
    			p = element("p");
    			p.textContent = "SUBSCRIPTIONS";
    			t2 = space();
    			h4 = element("h4");
    			strong = element("strong");
    			strong.textContent = "200";
    			t4 = space();
    			create_component(mdbcardbody.$$.fragment);
    			add_location(p, file$t, 35, 10, 1244);
    			add_location(strong, file$t, 37, 12, 1292);
    			add_location(h4, file$t, 36, 10, 1275);
    			attr_dev(div0, "class", "data");
    			add_location(div0, file$t, 34, 8, 1215);
    			attr_dev(div1, "class", "admin-up");
    			add_location(div1, file$t, 32, 6, 1121);
    		},
    		m: function mount(target, anchor) {
    			insert_dev(target, div1, anchor);
    			mount_component(mdbicon, div1, null);
    			append_dev(div1, t0);
    			append_dev(div1, div0);
    			append_dev(div0, p);
    			append_dev(div0, t2);
    			append_dev(div0, h4);
    			append_dev(h4, strong);
    			insert_dev(target, t4, anchor);
    			mount_component(mdbcardbody, target, anchor);
    			current = true;
    		},
    		p: function update(ctx, dirty) {
    			const mdbcardbody_changes = {};

    			if (dirty & /*$$scope*/ 1) {
    				mdbcardbody_changes.$$scope = { dirty, ctx };
    			}

    			mdbcardbody.$set(mdbcardbody_changes);
    		},
    		i: function intro(local) {
    			if (current) return;
    			transition_in(mdbicon.$$.fragment, local);
    			transition_in(mdbcardbody.$$.fragment, local);
    			current = true;
    		},
    		o: function outro(local) {
    			transition_out(mdbicon.$$.fragment, local);
    			transition_out(mdbcardbody.$$.fragment, local);
    			current = false;
    		},
    		d: function destroy(detaching) {
    			if (detaching) detach_dev(div1);
    			destroy_component(mdbicon);
    			if (detaching) detach_dev(t4);
    			destroy_component(mdbcardbody, detaching);
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_default_slot_10$8.name,
    		type: "slot",
    		source: "(32:4) <MDBCard class=\\\"cascading-admin-card\\\">",
    		ctx
    	});

    	return block;
    }

    // (31:2) <MDBCol xl="3" md="6" class="mb-r">
    function create_default_slot_9$8(ctx) {
    	let mdbcard;
    	let current;

    	mdbcard = new MDBCard({
    			props: {
    				class: "cascading-admin-card",
    				$$slots: { default: [create_default_slot_10$8] },
    				$$scope: { ctx }
    			},
    			$$inline: true
    		});

    	const block = {
    		c: function create() {
    			create_component(mdbcard.$$.fragment);
    		},
    		m: function mount(target, anchor) {
    			mount_component(mdbcard, target, anchor);
    			current = true;
    		},
    		p: function update(ctx, dirty) {
    			const mdbcard_changes = {};

    			if (dirty & /*$$scope*/ 1) {
    				mdbcard_changes.$$scope = { dirty, ctx };
    			}

    			mdbcard.$set(mdbcard_changes);
    		},
    		i: function intro(local) {
    			if (current) return;
    			transition_in(mdbcard.$$.fragment, local);
    			current = true;
    		},
    		o: function outro(local) {
    			transition_out(mdbcard.$$.fragment, local);
    			current = false;
    		},
    		d: function destroy(detaching) {
    			destroy_component(mdbcard, detaching);
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_default_slot_9$8.name,
    		type: "slot",
    		source: "(31:2) <MDBCol xl=\\\"3\\\" md=\\\"6\\\" class=\\\"mb-r\\\">",
    		ctx
    	});

    	return block;
    }

    // (67:8) <MDBCardText>
    function create_default_slot_8$8(ctx) {
    	let t;

    	const block = {
    		c: function create() {
    			t = text("Worse than last week (75%)");
    		},
    		m: function mount(target, anchor) {
    			insert_dev(target, t, anchor);
    		},
    		d: function destroy(detaching) {
    			if (detaching) detach_dev(t);
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_default_slot_8$8.name,
    		type: "slot",
    		source: "(67:8) <MDBCardText>",
    		ctx
    	});

    	return block;
    }

    // (62:6) <MDBCardBody>
    function create_default_slot_7$8(ctx) {
    	let div1;
    	let div0;
    	let t;
    	let mdbcardtext;
    	let current;

    	mdbcardtext = new MDBCardText({
    			props: {
    				$$slots: { default: [create_default_slot_8$8] },
    				$$scope: { ctx }
    			},
    			$$inline: true
    		});

    	const block = {
    		c: function create() {
    			div1 = element("div");
    			div0 = element("div");
    			t = space();
    			create_component(mdbcardtext.$$.fragment);
    			attr_dev(div0, "aria-valuemax", "100");
    			attr_dev(div0, "aria-valuemin", "0");
    			attr_dev(div0, "aria-valuenow", "25");
    			attr_dev(div0, "class", "progress-bar grey darken-2");
    			attr_dev(div0, "role", "progressbar");
    			set_style(div0, "width", "75%");
    			add_location(div0, file$t, 63, 10, 2080);
    			attr_dev(div1, "class", "progress");
    			add_location(div1, file$t, 62, 8, 2047);
    		},
    		m: function mount(target, anchor) {
    			insert_dev(target, div1, anchor);
    			append_dev(div1, div0);
    			insert_dev(target, t, anchor);
    			mount_component(mdbcardtext, target, anchor);
    			current = true;
    		},
    		p: function update(ctx, dirty) {
    			const mdbcardtext_changes = {};

    			if (dirty & /*$$scope*/ 1) {
    				mdbcardtext_changes.$$scope = { dirty, ctx };
    			}

    			mdbcardtext.$set(mdbcardtext_changes);
    		},
    		i: function intro(local) {
    			if (current) return;
    			transition_in(mdbcardtext.$$.fragment, local);
    			current = true;
    		},
    		o: function outro(local) {
    			transition_out(mdbcardtext.$$.fragment, local);
    			current = false;
    		},
    		d: function destroy(detaching) {
    			if (detaching) detach_dev(div1);
    			if (detaching) detach_dev(t);
    			destroy_component(mdbcardtext, detaching);
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_default_slot_7$8.name,
    		type: "slot",
    		source: "(62:6) <MDBCardBody>",
    		ctx
    	});

    	return block;
    }

    // (52:4) <MDBCard class="cascading-admin-card">
    function create_default_slot_6$9(ctx) {
    	let div1;
    	let mdbicon;
    	let t0;
    	let div0;
    	let p;
    	let t2;
    	let h4;
    	let strong;
    	let t4;
    	let mdbcardbody;
    	let current;

    	mdbicon = new MDBIcon({
    			props: {
    				fas: true,
    				icon: "chart-pie",
    				class: "light-blue lighten-1"
    			},
    			$$inline: true
    		});

    	mdbcardbody = new MDBCardBody({
    			props: {
    				$$slots: { default: [create_default_slot_7$8] },
    				$$scope: { ctx }
    			},
    			$$inline: true
    		});

    	const block = {
    		c: function create() {
    			div1 = element("div");
    			create_component(mdbicon.$$.fragment);
    			t0 = space();
    			div0 = element("div");
    			p = element("p");
    			p.textContent = "TRAFFIC";
    			t2 = space();
    			h4 = element("h4");
    			strong = element("strong");
    			strong.textContent = "20000";
    			t4 = space();
    			create_component(mdbcardbody.$$.fragment);
    			add_location(p, file$t, 55, 10, 1910);
    			add_location(strong, file$t, 57, 12, 1952);
    			add_location(h4, file$t, 56, 10, 1935);
    			attr_dev(div0, "class", "data");
    			add_location(div0, file$t, 54, 8, 1881);
    			attr_dev(div1, "class", "admin-up");
    			add_location(div1, file$t, 52, 6, 1781);
    		},
    		m: function mount(target, anchor) {
    			insert_dev(target, div1, anchor);
    			mount_component(mdbicon, div1, null);
    			append_dev(div1, t0);
    			append_dev(div1, div0);
    			append_dev(div0, p);
    			append_dev(div0, t2);
    			append_dev(div0, h4);
    			append_dev(h4, strong);
    			insert_dev(target, t4, anchor);
    			mount_component(mdbcardbody, target, anchor);
    			current = true;
    		},
    		p: function update(ctx, dirty) {
    			const mdbcardbody_changes = {};

    			if (dirty & /*$$scope*/ 1) {
    				mdbcardbody_changes.$$scope = { dirty, ctx };
    			}

    			mdbcardbody.$set(mdbcardbody_changes);
    		},
    		i: function intro(local) {
    			if (current) return;
    			transition_in(mdbicon.$$.fragment, local);
    			transition_in(mdbcardbody.$$.fragment, local);
    			current = true;
    		},
    		o: function outro(local) {
    			transition_out(mdbicon.$$.fragment, local);
    			transition_out(mdbcardbody.$$.fragment, local);
    			current = false;
    		},
    		d: function destroy(detaching) {
    			if (detaching) detach_dev(div1);
    			destroy_component(mdbicon);
    			if (detaching) detach_dev(t4);
    			destroy_component(mdbcardbody, detaching);
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_default_slot_6$9.name,
    		type: "slot",
    		source: "(52:4) <MDBCard class=\\\"cascading-admin-card\\\">",
    		ctx
    	});

    	return block;
    }

    // (51:2) <MDBCol xl="3" md="6" class="mb-r">
    function create_default_slot_5$a(ctx) {
    	let mdbcard;
    	let current;

    	mdbcard = new MDBCard({
    			props: {
    				class: "cascading-admin-card",
    				$$slots: { default: [create_default_slot_6$9] },
    				$$scope: { ctx }
    			},
    			$$inline: true
    		});

    	const block = {
    		c: function create() {
    			create_component(mdbcard.$$.fragment);
    		},
    		m: function mount(target, anchor) {
    			mount_component(mdbcard, target, anchor);
    			current = true;
    		},
    		p: function update(ctx, dirty) {
    			const mdbcard_changes = {};

    			if (dirty & /*$$scope*/ 1) {
    				mdbcard_changes.$$scope = { dirty, ctx };
    			}

    			mdbcard.$set(mdbcard_changes);
    		},
    		i: function intro(local) {
    			if (current) return;
    			transition_in(mdbcard.$$.fragment, local);
    			current = true;
    		},
    		o: function outro(local) {
    			transition_out(mdbcard.$$.fragment, local);
    			current = false;
    		},
    		d: function destroy(detaching) {
    			destroy_component(mdbcard, detaching);
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_default_slot_5$a.name,
    		type: "slot",
    		source: "(51:2) <MDBCol xl=\\\"3\\\" md=\\\"6\\\" class=\\\"mb-r\\\">",
    		ctx
    	});

    	return block;
    }

    // (87:8) <MDBCardText>
    function create_default_slot_4$a(ctx) {
    	let t;

    	const block = {
    		c: function create() {
    			t = text("Better than last week (25%)");
    		},
    		m: function mount(target, anchor) {
    			insert_dev(target, t, anchor);
    		},
    		d: function destroy(detaching) {
    			if (detaching) detach_dev(t);
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_default_slot_4$a.name,
    		type: "slot",
    		source: "(87:8) <MDBCardText>",
    		ctx
    	});

    	return block;
    }

    // (82:6) <MDBCardBody>
    function create_default_slot_3$a(ctx) {
    	let div1;
    	let div0;
    	let t;
    	let mdbcardtext;
    	let current;

    	mdbcardtext = new MDBCardText({
    			props: {
    				$$slots: { default: [create_default_slot_4$a] },
    				$$scope: { ctx }
    			},
    			$$inline: true
    		});

    	const block = {
    		c: function create() {
    			div1 = element("div");
    			div0 = element("div");
    			t = space();
    			create_component(mdbcardtext.$$.fragment);
    			attr_dev(div0, "aria-valuemax", "100");
    			attr_dev(div0, "aria-valuemin", "0");
    			attr_dev(div0, "aria-valuenow", "25");
    			attr_dev(div0, "class", "progress-bar bg-primary");
    			attr_dev(div0, "role", "progressbar");
    			set_style(div0, "width", "25%");
    			add_location(div0, file$t, 83, 10, 2747);
    			attr_dev(div1, "class", "progress");
    			add_location(div1, file$t, 82, 8, 2714);
    		},
    		m: function mount(target, anchor) {
    			insert_dev(target, div1, anchor);
    			append_dev(div1, div0);
    			insert_dev(target, t, anchor);
    			mount_component(mdbcardtext, target, anchor);
    			current = true;
    		},
    		p: function update(ctx, dirty) {
    			const mdbcardtext_changes = {};

    			if (dirty & /*$$scope*/ 1) {
    				mdbcardtext_changes.$$scope = { dirty, ctx };
    			}

    			mdbcardtext.$set(mdbcardtext_changes);
    		},
    		i: function intro(local) {
    			if (current) return;
    			transition_in(mdbcardtext.$$.fragment, local);
    			current = true;
    		},
    		o: function outro(local) {
    			transition_out(mdbcardtext.$$.fragment, local);
    			current = false;
    		},
    		d: function destroy(detaching) {
    			if (detaching) detach_dev(div1);
    			if (detaching) detach_dev(t);
    			destroy_component(mdbcardtext, detaching);
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_default_slot_3$a.name,
    		type: "slot",
    		source: "(82:6) <MDBCardBody>",
    		ctx
    	});

    	return block;
    }

    // (72:4) <MDBCard class="cascading-admin-card">
    function create_default_slot_2$a(ctx) {
    	let div1;
    	let mdbicon;
    	let t0;
    	let div0;
    	let p;
    	let t2;
    	let h4;
    	let strong;
    	let t4;
    	let mdbcardbody;
    	let current;

    	mdbicon = new MDBIcon({
    			props: {
    				fas: true,
    				icon: "chart-bar",
    				class: "red accent-2"
    			},
    			$$inline: true
    		});

    	mdbcardbody = new MDBCardBody({
    			props: {
    				$$slots: { default: [create_default_slot_3$a] },
    				$$scope: { ctx }
    			},
    			$$inline: true
    		});

    	const block = {
    		c: function create() {
    			div1 = element("div");
    			create_component(mdbicon.$$.fragment);
    			t0 = space();
    			div0 = element("div");
    			p = element("p");
    			p.textContent = "ORGANIC TRAFFIC";
    			t2 = space();
    			h4 = element("h4");
    			strong = element("strong");
    			strong.textContent = "2000";
    			t4 = space();
    			create_component(mdbcardbody.$$.fragment);
    			add_location(p, file$t, 75, 10, 2570);
    			add_location(strong, file$t, 77, 12, 2620);
    			add_location(h4, file$t, 76, 10, 2603);
    			attr_dev(div0, "class", "data");
    			add_location(div0, file$t, 74, 8, 2541);
    			attr_dev(div1, "class", "admin-up");
    			add_location(div1, file$t, 72, 6, 2449);
    		},
    		m: function mount(target, anchor) {
    			insert_dev(target, div1, anchor);
    			mount_component(mdbicon, div1, null);
    			append_dev(div1, t0);
    			append_dev(div1, div0);
    			append_dev(div0, p);
    			append_dev(div0, t2);
    			append_dev(div0, h4);
    			append_dev(h4, strong);
    			insert_dev(target, t4, anchor);
    			mount_component(mdbcardbody, target, anchor);
    			current = true;
    		},
    		p: function update(ctx, dirty) {
    			const mdbcardbody_changes = {};

    			if (dirty & /*$$scope*/ 1) {
    				mdbcardbody_changes.$$scope = { dirty, ctx };
    			}

    			mdbcardbody.$set(mdbcardbody_changes);
    		},
    		i: function intro(local) {
    			if (current) return;
    			transition_in(mdbicon.$$.fragment, local);
    			transition_in(mdbcardbody.$$.fragment, local);
    			current = true;
    		},
    		o: function outro(local) {
    			transition_out(mdbicon.$$.fragment, local);
    			transition_out(mdbcardbody.$$.fragment, local);
    			current = false;
    		},
    		d: function destroy(detaching) {
    			if (detaching) detach_dev(div1);
    			destroy_component(mdbicon);
    			if (detaching) detach_dev(t4);
    			destroy_component(mdbcardbody, detaching);
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_default_slot_2$a.name,
    		type: "slot",
    		source: "(72:4) <MDBCard class=\\\"cascading-admin-card\\\">",
    		ctx
    	});

    	return block;
    }

    // (71:2) <MDBCol xl="3" md="6" class="mb-r">
    function create_default_slot_1$a(ctx) {
    	let mdbcard;
    	let current;

    	mdbcard = new MDBCard({
    			props: {
    				class: "cascading-admin-card",
    				$$slots: { default: [create_default_slot_2$a] },
    				$$scope: { ctx }
    			},
    			$$inline: true
    		});

    	const block = {
    		c: function create() {
    			create_component(mdbcard.$$.fragment);
    		},
    		m: function mount(target, anchor) {
    			mount_component(mdbcard, target, anchor);
    			current = true;
    		},
    		p: function update(ctx, dirty) {
    			const mdbcard_changes = {};

    			if (dirty & /*$$scope*/ 1) {
    				mdbcard_changes.$$scope = { dirty, ctx };
    			}

    			mdbcard.$set(mdbcard_changes);
    		},
    		i: function intro(local) {
    			if (current) return;
    			transition_in(mdbcard.$$.fragment, local);
    			current = true;
    		},
    		o: function outro(local) {
    			transition_out(mdbcard.$$.fragment, local);
    			current = false;
    		},
    		d: function destroy(detaching) {
    			destroy_component(mdbcard, detaching);
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_default_slot_1$a.name,
    		type: "slot",
    		source: "(71:2) <MDBCol xl=\\\"3\\\" md=\\\"6\\\" class=\\\"mb-r\\\">",
    		ctx
    	});

    	return block;
    }

    // (10:0) <MDBRow class="mb-4">
    function create_default_slot$b(ctx) {
    	let mdbcol0;
    	let t0;
    	let mdbcol1;
    	let t1;
    	let mdbcol2;
    	let t2;
    	let mdbcol3;
    	let current;

    	mdbcol0 = new MDBCol({
    			props: {
    				xl: "3",
    				md: "6",
    				class: "mb-r",
    				$$slots: { default: [create_default_slot_13$5] },
    				$$scope: { ctx }
    			},
    			$$inline: true
    		});

    	mdbcol1 = new MDBCol({
    			props: {
    				xl: "3",
    				md: "6",
    				class: "mb-r",
    				$$slots: { default: [create_default_slot_9$8] },
    				$$scope: { ctx }
    			},
    			$$inline: true
    		});

    	mdbcol2 = new MDBCol({
    			props: {
    				xl: "3",
    				md: "6",
    				class: "mb-r",
    				$$slots: { default: [create_default_slot_5$a] },
    				$$scope: { ctx }
    			},
    			$$inline: true
    		});

    	mdbcol3 = new MDBCol({
    			props: {
    				xl: "3",
    				md: "6",
    				class: "mb-r",
    				$$slots: { default: [create_default_slot_1$a] },
    				$$scope: { ctx }
    			},
    			$$inline: true
    		});

    	const block = {
    		c: function create() {
    			create_component(mdbcol0.$$.fragment);
    			t0 = space();
    			create_component(mdbcol1.$$.fragment);
    			t1 = space();
    			create_component(mdbcol2.$$.fragment);
    			t2 = space();
    			create_component(mdbcol3.$$.fragment);
    		},
    		m: function mount(target, anchor) {
    			mount_component(mdbcol0, target, anchor);
    			insert_dev(target, t0, anchor);
    			mount_component(mdbcol1, target, anchor);
    			insert_dev(target, t1, anchor);
    			mount_component(mdbcol2, target, anchor);
    			insert_dev(target, t2, anchor);
    			mount_component(mdbcol3, target, anchor);
    			current = true;
    		},
    		p: function update(ctx, dirty) {
    			const mdbcol0_changes = {};

    			if (dirty & /*$$scope*/ 1) {
    				mdbcol0_changes.$$scope = { dirty, ctx };
    			}

    			mdbcol0.$set(mdbcol0_changes);
    			const mdbcol1_changes = {};

    			if (dirty & /*$$scope*/ 1) {
    				mdbcol1_changes.$$scope = { dirty, ctx };
    			}

    			mdbcol1.$set(mdbcol1_changes);
    			const mdbcol2_changes = {};

    			if (dirty & /*$$scope*/ 1) {
    				mdbcol2_changes.$$scope = { dirty, ctx };
    			}

    			mdbcol2.$set(mdbcol2_changes);
    			const mdbcol3_changes = {};

    			if (dirty & /*$$scope*/ 1) {
    				mdbcol3_changes.$$scope = { dirty, ctx };
    			}

    			mdbcol3.$set(mdbcol3_changes);
    		},
    		i: function intro(local) {
    			if (current) return;
    			transition_in(mdbcol0.$$.fragment, local);
    			transition_in(mdbcol1.$$.fragment, local);
    			transition_in(mdbcol2.$$.fragment, local);
    			transition_in(mdbcol3.$$.fragment, local);
    			current = true;
    		},
    		o: function outro(local) {
    			transition_out(mdbcol0.$$.fragment, local);
    			transition_out(mdbcol1.$$.fragment, local);
    			transition_out(mdbcol2.$$.fragment, local);
    			transition_out(mdbcol3.$$.fragment, local);
    			current = false;
    		},
    		d: function destroy(detaching) {
    			destroy_component(mdbcol0, detaching);
    			if (detaching) detach_dev(t0);
    			destroy_component(mdbcol1, detaching);
    			if (detaching) detach_dev(t1);
    			destroy_component(mdbcol2, detaching);
    			if (detaching) detach_dev(t2);
    			destroy_component(mdbcol3, detaching);
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_default_slot$b.name,
    		type: "slot",
    		source: "(10:0) <MDBRow class=\\\"mb-4\\\">",
    		ctx
    	});

    	return block;
    }

    function create_fragment$B(ctx) {
    	let mdbrow;
    	let current;

    	mdbrow = new MDBRow({
    			props: {
    				class: "mb-4",
    				$$slots: { default: [create_default_slot$b] },
    				$$scope: { ctx }
    			},
    			$$inline: true
    		});

    	const block = {
    		c: function create() {
    			create_component(mdbrow.$$.fragment);
    		},
    		l: function claim(nodes) {
    			throw new Error("options.hydrate only works if the component was compiled with the `hydratable: true` option");
    		},
    		m: function mount(target, anchor) {
    			mount_component(mdbrow, target, anchor);
    			current = true;
    		},
    		p: function update(ctx, [dirty]) {
    			const mdbrow_changes = {};

    			if (dirty & /*$$scope*/ 1) {
    				mdbrow_changes.$$scope = { dirty, ctx };
    			}

    			mdbrow.$set(mdbrow_changes);
    		},
    		i: function intro(local) {
    			if (current) return;
    			transition_in(mdbrow.$$.fragment, local);
    			current = true;
    		},
    		o: function outro(local) {
    			transition_out(mdbrow.$$.fragment, local);
    			current = false;
    		},
    		d: function destroy(detaching) {
    			destroy_component(mdbrow, detaching);
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_fragment$B.name,
    		type: "component",
    		source: "",
    		ctx
    	});

    	return block;
    }

    function instance$B($$self, $$props, $$invalidate) {
    	let { $$slots: slots = {}, $$scope } = $$props;
    	validate_slots("AdminCardSection1", slots, []);
    	const writable_props = [];

    	Object.keys($$props).forEach(key => {
    		if (!~writable_props.indexOf(key) && key.slice(0, 2) !== "$$") console.warn(`<AdminCardSection1> was created with unknown prop '${key}'`);
    	});

    	$$self.$capture_state = () => ({
    		MDBRow,
    		MDBCol,
    		MDBCard,
    		MDBIcon,
    		MDBCardBody,
    		MDBCardText
    	});

    	return [];
    }

    class AdminCardSection1 extends SvelteComponentDev {
    	constructor(options) {
    		super(options);
    		init(this, options, instance$B, create_fragment$B, safe_not_equal, {});

    		dispatch_dev("SvelteRegisterComponent", {
    			component: this,
    			tagName: "AdminCardSection1",
    			options,
    			id: create_fragment$B.name
    		});
    	}
    }

    /* src/components/pages/sections/AdminCardSection2.svelte generated by Svelte v3.37.0 */
    const file$s = "src/components/pages/sections/AdminCardSection2.svelte";

    // (12:6) <MDBCardBody>
    function create_default_slot_16$4(ctx) {
    	let div;
    	let mdbicon;
    	let t0;
    	let p;
    	let t2;
    	let h4;
    	let strong;
    	let current;

    	mdbicon = new MDBIcon({
    			props: { far: true, icon: "money-bill-alt" },
    			$$inline: true
    		});

    	const block = {
    		c: function create() {
    			div = element("div");
    			create_component(mdbicon.$$.fragment);
    			t0 = space();
    			p = element("p");
    			p.textContent = "SALES";
    			t2 = space();
    			h4 = element("h4");
    			strong = element("strong");
    			strong.textContent = "$2000";
    			attr_dev(div, "class", "float-right");
    			add_location(div, file$s, 12, 8, 440);
    			attr_dev(p, "class", "white-text");
    			add_location(p, file$s, 15, 8, 536);
    			add_location(strong, file$s, 16, 12, 580);
    			add_location(h4, file$s, 16, 8, 576);
    		},
    		m: function mount(target, anchor) {
    			insert_dev(target, div, anchor);
    			mount_component(mdbicon, div, null);
    			insert_dev(target, t0, anchor);
    			insert_dev(target, p, anchor);
    			insert_dev(target, t2, anchor);
    			insert_dev(target, h4, anchor);
    			append_dev(h4, strong);
    			current = true;
    		},
    		p: noop,
    		i: function intro(local) {
    			if (current) return;
    			transition_in(mdbicon.$$.fragment, local);
    			current = true;
    		},
    		o: function outro(local) {
    			transition_out(mdbicon.$$.fragment, local);
    			current = false;
    		},
    		d: function destroy(detaching) {
    			if (detaching) detach_dev(div);
    			destroy_component(mdbicon);
    			if (detaching) detach_dev(t0);
    			if (detaching) detach_dev(p);
    			if (detaching) detach_dev(t2);
    			if (detaching) detach_dev(h4);
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_default_slot_16$4.name,
    		type: "slot",
    		source: "(12:6) <MDBCardBody>",
    		ctx
    	});

    	return block;
    }

    // (22:6) <MDBCardBody>
    function create_default_slot_15$4(ctx) {
    	let p;

    	const block = {
    		c: function create() {
    			p = element("p");
    			p.textContent = "Better than last week (25%)";
    			add_location(p, file$s, 22, 8, 856);
    		},
    		m: function mount(target, anchor) {
    			insert_dev(target, p, anchor);
    		},
    		d: function destroy(detaching) {
    			if (detaching) detach_dev(p);
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_default_slot_15$4.name,
    		type: "slot",
    		source: "(22:6) <MDBCardBody>",
    		ctx
    	});

    	return block;
    }

    // (11:4) <MDBCard color="primary-color" class="classic-admin-card">
    function create_default_slot_14$4(ctx) {
    	let mdbcardbody0;
    	let t0;
    	let div1;
    	let div0;
    	let t1;
    	let mdbcardbody1;
    	let current;

    	mdbcardbody0 = new MDBCardBody({
    			props: {
    				$$slots: { default: [create_default_slot_16$4] },
    				$$scope: { ctx }
    			},
    			$$inline: true
    		});

    	mdbcardbody1 = new MDBCardBody({
    			props: {
    				$$slots: { default: [create_default_slot_15$4] },
    				$$scope: { ctx }
    			},
    			$$inline: true
    		});

    	const block = {
    		c: function create() {
    			create_component(mdbcardbody0.$$.fragment);
    			t0 = space();
    			div1 = element("div");
    			div0 = element("div");
    			t1 = space();
    			create_component(mdbcardbody1.$$.fragment);
    			attr_dev(div0, "aria-valuemax", "100");
    			attr_dev(div0, "aria-valuemin", "0");
    			attr_dev(div0, "aria-valuenow", "25");
    			attr_dev(div0, "class", "progress-bar bg grey darken-3");
    			attr_dev(div0, "role", "progressbar");
    			attr_dev(div0, "style", { width: "25%" });
    			add_location(div0, file$s, 19, 8, 666);
    			attr_dev(div1, "class", "progress");
    			add_location(div1, file$s, 18, 6, 635);
    		},
    		m: function mount(target, anchor) {
    			mount_component(mdbcardbody0, target, anchor);
    			insert_dev(target, t0, anchor);
    			insert_dev(target, div1, anchor);
    			append_dev(div1, div0);
    			insert_dev(target, t1, anchor);
    			mount_component(mdbcardbody1, target, anchor);
    			current = true;
    		},
    		p: function update(ctx, dirty) {
    			const mdbcardbody0_changes = {};

    			if (dirty & /*$$scope*/ 1) {
    				mdbcardbody0_changes.$$scope = { dirty, ctx };
    			}

    			mdbcardbody0.$set(mdbcardbody0_changes);
    			const mdbcardbody1_changes = {};

    			if (dirty & /*$$scope*/ 1) {
    				mdbcardbody1_changes.$$scope = { dirty, ctx };
    			}

    			mdbcardbody1.$set(mdbcardbody1_changes);
    		},
    		i: function intro(local) {
    			if (current) return;
    			transition_in(mdbcardbody0.$$.fragment, local);
    			transition_in(mdbcardbody1.$$.fragment, local);
    			current = true;
    		},
    		o: function outro(local) {
    			transition_out(mdbcardbody0.$$.fragment, local);
    			transition_out(mdbcardbody1.$$.fragment, local);
    			current = false;
    		},
    		d: function destroy(detaching) {
    			destroy_component(mdbcardbody0, detaching);
    			if (detaching) detach_dev(t0);
    			if (detaching) detach_dev(div1);
    			if (detaching) detach_dev(t1);
    			destroy_component(mdbcardbody1, detaching);
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_default_slot_14$4.name,
    		type: "slot",
    		source: "(11:4) <MDBCard color=\\\"primary-color\\\" class=\\\"classic-admin-card\\\">",
    		ctx
    	});

    	return block;
    }

    // (10:2) <MDBCol xl="3" md="6" class="mb-3">
    function create_default_slot_13$4(ctx) {
    	let mdbcard;
    	let current;

    	mdbcard = new MDBCard({
    			props: {
    				color: "primary-color",
    				class: "classic-admin-card",
    				$$slots: { default: [create_default_slot_14$4] },
    				$$scope: { ctx }
    			},
    			$$inline: true
    		});

    	const block = {
    		c: function create() {
    			create_component(mdbcard.$$.fragment);
    		},
    		m: function mount(target, anchor) {
    			mount_component(mdbcard, target, anchor);
    			current = true;
    		},
    		p: function update(ctx, dirty) {
    			const mdbcard_changes = {};

    			if (dirty & /*$$scope*/ 1) {
    				mdbcard_changes.$$scope = { dirty, ctx };
    			}

    			mdbcard.$set(mdbcard_changes);
    		},
    		i: function intro(local) {
    			if (current) return;
    			transition_in(mdbcard.$$.fragment, local);
    			current = true;
    		},
    		o: function outro(local) {
    			transition_out(mdbcard.$$.fragment, local);
    			current = false;
    		},
    		d: function destroy(detaching) {
    			destroy_component(mdbcard, detaching);
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_default_slot_13$4.name,
    		type: "slot",
    		source: "(10:2) <MDBCol xl=\\\"3\\\" md=\\\"6\\\" class=\\\"mb-3\\\">",
    		ctx
    	});

    	return block;
    }

    // (29:6) <MDBCardBody>
    function create_default_slot_12$7(ctx) {
    	let div;
    	let mdbicon;
    	let t0;
    	let p;
    	let t2;
    	let h4;
    	let strong;
    	let current;

    	mdbicon = new MDBIcon({
    			props: { icon: "chart-line" },
    			$$inline: true
    		});

    	const block = {
    		c: function create() {
    			div = element("div");
    			create_component(mdbicon.$$.fragment);
    			t0 = space();
    			p = element("p");
    			p.textContent = "SUBSCRIPTIONS";
    			t2 = space();
    			h4 = element("h4");
    			strong = element("strong");
    			strong.textContent = "200";
    			attr_dev(div, "class", "float-right");
    			add_location(div, file$s, 29, 8, 1068);
    			attr_dev(p, "class", "white-text");
    			add_location(p, file$s, 32, 8, 1156);
    			add_location(strong, file$s, 33, 12, 1208);
    			add_location(h4, file$s, 33, 8, 1204);
    		},
    		m: function mount(target, anchor) {
    			insert_dev(target, div, anchor);
    			mount_component(mdbicon, div, null);
    			insert_dev(target, t0, anchor);
    			insert_dev(target, p, anchor);
    			insert_dev(target, t2, anchor);
    			insert_dev(target, h4, anchor);
    			append_dev(h4, strong);
    			current = true;
    		},
    		p: noop,
    		i: function intro(local) {
    			if (current) return;
    			transition_in(mdbicon.$$.fragment, local);
    			current = true;
    		},
    		o: function outro(local) {
    			transition_out(mdbicon.$$.fragment, local);
    			current = false;
    		},
    		d: function destroy(detaching) {
    			if (detaching) detach_dev(div);
    			destroy_component(mdbicon);
    			if (detaching) detach_dev(t0);
    			if (detaching) detach_dev(p);
    			if (detaching) detach_dev(t2);
    			if (detaching) detach_dev(h4);
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_default_slot_12$7.name,
    		type: "slot",
    		source: "(29:6) <MDBCardBody>",
    		ctx
    	});

    	return block;
    }

    // (39:6) <MDBCardBody>
    function create_default_slot_11$7(ctx) {
    	let p;

    	const block = {
    		c: function create() {
    			p = element("p");
    			p.textContent = "Worse than last week (25%)";
    			add_location(p, file$s, 39, 8, 1482);
    		},
    		m: function mount(target, anchor) {
    			insert_dev(target, p, anchor);
    		},
    		d: function destroy(detaching) {
    			if (detaching) detach_dev(p);
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_default_slot_11$7.name,
    		type: "slot",
    		source: "(39:6) <MDBCardBody>",
    		ctx
    	});

    	return block;
    }

    // (28:4) <MDBCard color="warning-color" class="classic-admin-card">
    function create_default_slot_10$7(ctx) {
    	let mdbcardbody0;
    	let t0;
    	let div1;
    	let div0;
    	let t1;
    	let mdbcardbody1;
    	let current;

    	mdbcardbody0 = new MDBCardBody({
    			props: {
    				$$slots: { default: [create_default_slot_12$7] },
    				$$scope: { ctx }
    			},
    			$$inline: true
    		});

    	mdbcardbody1 = new MDBCardBody({
    			props: {
    				$$slots: { default: [create_default_slot_11$7] },
    				$$scope: { ctx }
    			},
    			$$inline: true
    		});

    	const block = {
    		c: function create() {
    			create_component(mdbcardbody0.$$.fragment);
    			t0 = space();
    			div1 = element("div");
    			div0 = element("div");
    			t1 = space();
    			create_component(mdbcardbody1.$$.fragment);
    			attr_dev(div0, "aria-valuemax", "100");
    			attr_dev(div0, "aria-valuemin", "0");
    			attr_dev(div0, "aria-valuenow", "25");
    			attr_dev(div0, "class", "progress-bar bg grey darken-3");
    			attr_dev(div0, "role", "progressbar");
    			attr_dev(div0, "style", { width: "25%" });
    			add_location(div0, file$s, 36, 8, 1292);
    			attr_dev(div1, "class", "progress");
    			add_location(div1, file$s, 35, 6, 1261);
    		},
    		m: function mount(target, anchor) {
    			mount_component(mdbcardbody0, target, anchor);
    			insert_dev(target, t0, anchor);
    			insert_dev(target, div1, anchor);
    			append_dev(div1, div0);
    			insert_dev(target, t1, anchor);
    			mount_component(mdbcardbody1, target, anchor);
    			current = true;
    		},
    		p: function update(ctx, dirty) {
    			const mdbcardbody0_changes = {};

    			if (dirty & /*$$scope*/ 1) {
    				mdbcardbody0_changes.$$scope = { dirty, ctx };
    			}

    			mdbcardbody0.$set(mdbcardbody0_changes);
    			const mdbcardbody1_changes = {};

    			if (dirty & /*$$scope*/ 1) {
    				mdbcardbody1_changes.$$scope = { dirty, ctx };
    			}

    			mdbcardbody1.$set(mdbcardbody1_changes);
    		},
    		i: function intro(local) {
    			if (current) return;
    			transition_in(mdbcardbody0.$$.fragment, local);
    			transition_in(mdbcardbody1.$$.fragment, local);
    			current = true;
    		},
    		o: function outro(local) {
    			transition_out(mdbcardbody0.$$.fragment, local);
    			transition_out(mdbcardbody1.$$.fragment, local);
    			current = false;
    		},
    		d: function destroy(detaching) {
    			destroy_component(mdbcardbody0, detaching);
    			if (detaching) detach_dev(t0);
    			if (detaching) detach_dev(div1);
    			if (detaching) detach_dev(t1);
    			destroy_component(mdbcardbody1, detaching);
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_default_slot_10$7.name,
    		type: "slot",
    		source: "(28:4) <MDBCard color=\\\"warning-color\\\" class=\\\"classic-admin-card\\\">",
    		ctx
    	});

    	return block;
    }

    // (27:2) <MDBCol xl="3" md="6" class="mb-3">
    function create_default_slot_9$7(ctx) {
    	let mdbcard;
    	let current;

    	mdbcard = new MDBCard({
    			props: {
    				color: "warning-color",
    				class: "classic-admin-card",
    				$$slots: { default: [create_default_slot_10$7] },
    				$$scope: { ctx }
    			},
    			$$inline: true
    		});

    	const block = {
    		c: function create() {
    			create_component(mdbcard.$$.fragment);
    		},
    		m: function mount(target, anchor) {
    			mount_component(mdbcard, target, anchor);
    			current = true;
    		},
    		p: function update(ctx, dirty) {
    			const mdbcard_changes = {};

    			if (dirty & /*$$scope*/ 1) {
    				mdbcard_changes.$$scope = { dirty, ctx };
    			}

    			mdbcard.$set(mdbcard_changes);
    		},
    		i: function intro(local) {
    			if (current) return;
    			transition_in(mdbcard.$$.fragment, local);
    			current = true;
    		},
    		o: function outro(local) {
    			transition_out(mdbcard.$$.fragment, local);
    			current = false;
    		},
    		d: function destroy(detaching) {
    			destroy_component(mdbcard, detaching);
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_default_slot_9$7.name,
    		type: "slot",
    		source: "(27:2) <MDBCol xl=\\\"3\\\" md=\\\"6\\\" class=\\\"mb-3\\\">",
    		ctx
    	});

    	return block;
    }

    // (46:6) <MDBCardBody>
    function create_default_slot_8$7(ctx) {
    	let div;
    	let mdbicon;
    	let t0;
    	let p;
    	let t2;
    	let h4;
    	let strong;
    	let current;

    	mdbicon = new MDBIcon({
    			props: { icon: "chart-pie" },
    			$$inline: true
    		});

    	const block = {
    		c: function create() {
    			div = element("div");
    			create_component(mdbicon.$$.fragment);
    			t0 = space();
    			p = element("p");
    			p.textContent = "TRAFFIC";
    			t2 = space();
    			h4 = element("h4");
    			strong = element("strong");
    			strong.textContent = "20000";
    			attr_dev(div, "class", "float-right");
    			add_location(div, file$s, 46, 8, 1693);
    			attr_dev(p, "class", "white-text");
    			add_location(p, file$s, 49, 8, 1780);
    			add_location(strong, file$s, 50, 12, 1826);
    			add_location(h4, file$s, 50, 8, 1822);
    		},
    		m: function mount(target, anchor) {
    			insert_dev(target, div, anchor);
    			mount_component(mdbicon, div, null);
    			insert_dev(target, t0, anchor);
    			insert_dev(target, p, anchor);
    			insert_dev(target, t2, anchor);
    			insert_dev(target, h4, anchor);
    			append_dev(h4, strong);
    			current = true;
    		},
    		p: noop,
    		i: function intro(local) {
    			if (current) return;
    			transition_in(mdbicon.$$.fragment, local);
    			current = true;
    		},
    		o: function outro(local) {
    			transition_out(mdbicon.$$.fragment, local);
    			current = false;
    		},
    		d: function destroy(detaching) {
    			if (detaching) detach_dev(div);
    			destroy_component(mdbicon);
    			if (detaching) detach_dev(t0);
    			if (detaching) detach_dev(p);
    			if (detaching) detach_dev(t2);
    			if (detaching) detach_dev(h4);
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_default_slot_8$7.name,
    		type: "slot",
    		source: "(46:6) <MDBCardBody>",
    		ctx
    	});

    	return block;
    }

    // (56:6) <MDBCardBody>
    function create_default_slot_7$7(ctx) {
    	let p;

    	const block = {
    		c: function create() {
    			p = element("p");
    			p.textContent = "Better than last week (75%)";
    			add_location(p, file$s, 56, 8, 2102);
    		},
    		m: function mount(target, anchor) {
    			insert_dev(target, p, anchor);
    		},
    		d: function destroy(detaching) {
    			if (detaching) detach_dev(p);
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_default_slot_7$7.name,
    		type: "slot",
    		source: "(56:6) <MDBCardBody>",
    		ctx
    	});

    	return block;
    }

    // (45:4) <MDBCard color="primary-color" class="classic-admin-card">
    function create_default_slot_6$8(ctx) {
    	let mdbcardbody0;
    	let t0;
    	let div1;
    	let div0;
    	let t1;
    	let mdbcardbody1;
    	let current;

    	mdbcardbody0 = new MDBCardBody({
    			props: {
    				$$slots: { default: [create_default_slot_8$7] },
    				$$scope: { ctx }
    			},
    			$$inline: true
    		});

    	mdbcardbody1 = new MDBCardBody({
    			props: {
    				$$slots: { default: [create_default_slot_7$7] },
    				$$scope: { ctx }
    			},
    			$$inline: true
    		});

    	const block = {
    		c: function create() {
    			create_component(mdbcardbody0.$$.fragment);
    			t0 = space();
    			div1 = element("div");
    			div0 = element("div");
    			t1 = space();
    			create_component(mdbcardbody1.$$.fragment);
    			attr_dev(div0, "aria-valuemax", "100");
    			attr_dev(div0, "aria-valuemin", "0");
    			attr_dev(div0, "aria-valuenow", "75");
    			attr_dev(div0, "class", "progress-bar bg grey darken-3");
    			attr_dev(div0, "role", "progressbar");
    			attr_dev(div0, "style", { width: "75%" });
    			add_location(div0, file$s, 53, 8, 1912);
    			attr_dev(div1, "class", "progress");
    			add_location(div1, file$s, 52, 6, 1881);
    		},
    		m: function mount(target, anchor) {
    			mount_component(mdbcardbody0, target, anchor);
    			insert_dev(target, t0, anchor);
    			insert_dev(target, div1, anchor);
    			append_dev(div1, div0);
    			insert_dev(target, t1, anchor);
    			mount_component(mdbcardbody1, target, anchor);
    			current = true;
    		},
    		p: function update(ctx, dirty) {
    			const mdbcardbody0_changes = {};

    			if (dirty & /*$$scope*/ 1) {
    				mdbcardbody0_changes.$$scope = { dirty, ctx };
    			}

    			mdbcardbody0.$set(mdbcardbody0_changes);
    			const mdbcardbody1_changes = {};

    			if (dirty & /*$$scope*/ 1) {
    				mdbcardbody1_changes.$$scope = { dirty, ctx };
    			}

    			mdbcardbody1.$set(mdbcardbody1_changes);
    		},
    		i: function intro(local) {
    			if (current) return;
    			transition_in(mdbcardbody0.$$.fragment, local);
    			transition_in(mdbcardbody1.$$.fragment, local);
    			current = true;
    		},
    		o: function outro(local) {
    			transition_out(mdbcardbody0.$$.fragment, local);
    			transition_out(mdbcardbody1.$$.fragment, local);
    			current = false;
    		},
    		d: function destroy(detaching) {
    			destroy_component(mdbcardbody0, detaching);
    			if (detaching) detach_dev(t0);
    			if (detaching) detach_dev(div1);
    			if (detaching) detach_dev(t1);
    			destroy_component(mdbcardbody1, detaching);
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_default_slot_6$8.name,
    		type: "slot",
    		source: "(45:4) <MDBCard color=\\\"primary-color\\\" class=\\\"classic-admin-card\\\">",
    		ctx
    	});

    	return block;
    }

    // (44:2) <MDBCol xl="3" md="6" class="mb-3">
    function create_default_slot_5$9(ctx) {
    	let mdbcard;
    	let current;

    	mdbcard = new MDBCard({
    			props: {
    				color: "primary-color",
    				class: "classic-admin-card",
    				$$slots: { default: [create_default_slot_6$8] },
    				$$scope: { ctx }
    			},
    			$$inline: true
    		});

    	const block = {
    		c: function create() {
    			create_component(mdbcard.$$.fragment);
    		},
    		m: function mount(target, anchor) {
    			mount_component(mdbcard, target, anchor);
    			current = true;
    		},
    		p: function update(ctx, dirty) {
    			const mdbcard_changes = {};

    			if (dirty & /*$$scope*/ 1) {
    				mdbcard_changes.$$scope = { dirty, ctx };
    			}

    			mdbcard.$set(mdbcard_changes);
    		},
    		i: function intro(local) {
    			if (current) return;
    			transition_in(mdbcard.$$.fragment, local);
    			current = true;
    		},
    		o: function outro(local) {
    			transition_out(mdbcard.$$.fragment, local);
    			current = false;
    		},
    		d: function destroy(detaching) {
    			destroy_component(mdbcard, detaching);
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_default_slot_5$9.name,
    		type: "slot",
    		source: "(44:2) <MDBCol xl=\\\"3\\\" md=\\\"6\\\" class=\\\"mb-3\\\">",
    		ctx
    	});

    	return block;
    }

    // (63:6) <MDBCardBody>
    function create_default_slot_4$9(ctx) {
    	let div;
    	let mdbicon;
    	let t0;
    	let p;
    	let t2;
    	let h4;
    	let strong;
    	let current;

    	mdbicon = new MDBIcon({
    			props: { icon: "chart-bar" },
    			$$inline: true
    		});

    	const block = {
    		c: function create() {
    			div = element("div");
    			create_component(mdbicon.$$.fragment);
    			t0 = space();
    			p = element("p");
    			p.textContent = "ORGANIC TRAFFIC";
    			t2 = space();
    			h4 = element("h4");
    			strong = element("strong");
    			strong.textContent = "2000";
    			attr_dev(div, "class", "float-right");
    			add_location(div, file$s, 63, 8, 2313);
    			attr_dev(p, "class", "white-text");
    			add_location(p, file$s, 66, 8, 2400);
    			add_location(strong, file$s, 67, 12, 2454);
    			add_location(h4, file$s, 67, 8, 2450);
    		},
    		m: function mount(target, anchor) {
    			insert_dev(target, div, anchor);
    			mount_component(mdbicon, div, null);
    			insert_dev(target, t0, anchor);
    			insert_dev(target, p, anchor);
    			insert_dev(target, t2, anchor);
    			insert_dev(target, h4, anchor);
    			append_dev(h4, strong);
    			current = true;
    		},
    		p: noop,
    		i: function intro(local) {
    			if (current) return;
    			transition_in(mdbicon.$$.fragment, local);
    			current = true;
    		},
    		o: function outro(local) {
    			transition_out(mdbicon.$$.fragment, local);
    			current = false;
    		},
    		d: function destroy(detaching) {
    			if (detaching) detach_dev(div);
    			destroy_component(mdbicon);
    			if (detaching) detach_dev(t0);
    			if (detaching) detach_dev(p);
    			if (detaching) detach_dev(t2);
    			if (detaching) detach_dev(h4);
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_default_slot_4$9.name,
    		type: "slot",
    		source: "(63:6) <MDBCardBody>",
    		ctx
    	});

    	return block;
    }

    // (73:6) <MDBCardBody>
    function create_default_slot_3$9(ctx) {
    	let p;

    	const block = {
    		c: function create() {
    			p = element("p");
    			p.textContent = "Better than last week (75%)";
    			add_location(p, file$s, 73, 8, 2729);
    		},
    		m: function mount(target, anchor) {
    			insert_dev(target, p, anchor);
    		},
    		d: function destroy(detaching) {
    			if (detaching) detach_dev(p);
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_default_slot_3$9.name,
    		type: "slot",
    		source: "(73:6) <MDBCardBody>",
    		ctx
    	});

    	return block;
    }

    // (62:4) <MDBCard color="red accent-2" class="classic-admin-card">
    function create_default_slot_2$9(ctx) {
    	let mdbcardbody0;
    	let t0;
    	let div1;
    	let div0;
    	let t1;
    	let mdbcardbody1;
    	let current;

    	mdbcardbody0 = new MDBCardBody({
    			props: {
    				$$slots: { default: [create_default_slot_4$9] },
    				$$scope: { ctx }
    			},
    			$$inline: true
    		});

    	mdbcardbody1 = new MDBCardBody({
    			props: {
    				$$slots: { default: [create_default_slot_3$9] },
    				$$scope: { ctx }
    			},
    			$$inline: true
    		});

    	const block = {
    		c: function create() {
    			create_component(mdbcardbody0.$$.fragment);
    			t0 = space();
    			div1 = element("div");
    			div0 = element("div");
    			t1 = space();
    			create_component(mdbcardbody1.$$.fragment);
    			attr_dev(div0, "aria-valuemax", "100");
    			attr_dev(div0, "aria-valuemin", "0");
    			attr_dev(div0, "aria-valuenow", "25");
    			attr_dev(div0, "class", "progress-bar bg grey darken-3");
    			attr_dev(div0, "role", "progressbar");
    			attr_dev(div0, "style", { width: "25%" });
    			add_location(div0, file$s, 70, 8, 2539);
    			attr_dev(div1, "class", "progress");
    			add_location(div1, file$s, 69, 6, 2508);
    		},
    		m: function mount(target, anchor) {
    			mount_component(mdbcardbody0, target, anchor);
    			insert_dev(target, t0, anchor);
    			insert_dev(target, div1, anchor);
    			append_dev(div1, div0);
    			insert_dev(target, t1, anchor);
    			mount_component(mdbcardbody1, target, anchor);
    			current = true;
    		},
    		p: function update(ctx, dirty) {
    			const mdbcardbody0_changes = {};

    			if (dirty & /*$$scope*/ 1) {
    				mdbcardbody0_changes.$$scope = { dirty, ctx };
    			}

    			mdbcardbody0.$set(mdbcardbody0_changes);
    			const mdbcardbody1_changes = {};

    			if (dirty & /*$$scope*/ 1) {
    				mdbcardbody1_changes.$$scope = { dirty, ctx };
    			}

    			mdbcardbody1.$set(mdbcardbody1_changes);
    		},
    		i: function intro(local) {
    			if (current) return;
    			transition_in(mdbcardbody0.$$.fragment, local);
    			transition_in(mdbcardbody1.$$.fragment, local);
    			current = true;
    		},
    		o: function outro(local) {
    			transition_out(mdbcardbody0.$$.fragment, local);
    			transition_out(mdbcardbody1.$$.fragment, local);
    			current = false;
    		},
    		d: function destroy(detaching) {
    			destroy_component(mdbcardbody0, detaching);
    			if (detaching) detach_dev(t0);
    			if (detaching) detach_dev(div1);
    			if (detaching) detach_dev(t1);
    			destroy_component(mdbcardbody1, detaching);
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_default_slot_2$9.name,
    		type: "slot",
    		source: "(62:4) <MDBCard color=\\\"red accent-2\\\" class=\\\"classic-admin-card\\\">",
    		ctx
    	});

    	return block;
    }

    // (61:2) <MDBCol xl="3" md="6" class="mb-3">
    function create_default_slot_1$9(ctx) {
    	let mdbcard;
    	let current;

    	mdbcard = new MDBCard({
    			props: {
    				color: "red accent-2",
    				class: "classic-admin-card",
    				$$slots: { default: [create_default_slot_2$9] },
    				$$scope: { ctx }
    			},
    			$$inline: true
    		});

    	const block = {
    		c: function create() {
    			create_component(mdbcard.$$.fragment);
    		},
    		m: function mount(target, anchor) {
    			mount_component(mdbcard, target, anchor);
    			current = true;
    		},
    		p: function update(ctx, dirty) {
    			const mdbcard_changes = {};

    			if (dirty & /*$$scope*/ 1) {
    				mdbcard_changes.$$scope = { dirty, ctx };
    			}

    			mdbcard.$set(mdbcard_changes);
    		},
    		i: function intro(local) {
    			if (current) return;
    			transition_in(mdbcard.$$.fragment, local);
    			current = true;
    		},
    		o: function outro(local) {
    			transition_out(mdbcard.$$.fragment, local);
    			current = false;
    		},
    		d: function destroy(detaching) {
    			destroy_component(mdbcard, detaching);
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_default_slot_1$9.name,
    		type: "slot",
    		source: "(61:2) <MDBCol xl=\\\"3\\\" md=\\\"6\\\" class=\\\"mb-3\\\">",
    		ctx
    	});

    	return block;
    }

    // (9:0) <MDBRow class="mb-4">
    function create_default_slot$a(ctx) {
    	let mdbcol0;
    	let t0;
    	let mdbcol1;
    	let t1;
    	let mdbcol2;
    	let t2;
    	let mdbcol3;
    	let current;

    	mdbcol0 = new MDBCol({
    			props: {
    				xl: "3",
    				md: "6",
    				class: "mb-3",
    				$$slots: { default: [create_default_slot_13$4] },
    				$$scope: { ctx }
    			},
    			$$inline: true
    		});

    	mdbcol1 = new MDBCol({
    			props: {
    				xl: "3",
    				md: "6",
    				class: "mb-3",
    				$$slots: { default: [create_default_slot_9$7] },
    				$$scope: { ctx }
    			},
    			$$inline: true
    		});

    	mdbcol2 = new MDBCol({
    			props: {
    				xl: "3",
    				md: "6",
    				class: "mb-3",
    				$$slots: { default: [create_default_slot_5$9] },
    				$$scope: { ctx }
    			},
    			$$inline: true
    		});

    	mdbcol3 = new MDBCol({
    			props: {
    				xl: "3",
    				md: "6",
    				class: "mb-3",
    				$$slots: { default: [create_default_slot_1$9] },
    				$$scope: { ctx }
    			},
    			$$inline: true
    		});

    	const block = {
    		c: function create() {
    			create_component(mdbcol0.$$.fragment);
    			t0 = space();
    			create_component(mdbcol1.$$.fragment);
    			t1 = space();
    			create_component(mdbcol2.$$.fragment);
    			t2 = space();
    			create_component(mdbcol3.$$.fragment);
    		},
    		m: function mount(target, anchor) {
    			mount_component(mdbcol0, target, anchor);
    			insert_dev(target, t0, anchor);
    			mount_component(mdbcol1, target, anchor);
    			insert_dev(target, t1, anchor);
    			mount_component(mdbcol2, target, anchor);
    			insert_dev(target, t2, anchor);
    			mount_component(mdbcol3, target, anchor);
    			current = true;
    		},
    		p: function update(ctx, dirty) {
    			const mdbcol0_changes = {};

    			if (dirty & /*$$scope*/ 1) {
    				mdbcol0_changes.$$scope = { dirty, ctx };
    			}

    			mdbcol0.$set(mdbcol0_changes);
    			const mdbcol1_changes = {};

    			if (dirty & /*$$scope*/ 1) {
    				mdbcol1_changes.$$scope = { dirty, ctx };
    			}

    			mdbcol1.$set(mdbcol1_changes);
    			const mdbcol2_changes = {};

    			if (dirty & /*$$scope*/ 1) {
    				mdbcol2_changes.$$scope = { dirty, ctx };
    			}

    			mdbcol2.$set(mdbcol2_changes);
    			const mdbcol3_changes = {};

    			if (dirty & /*$$scope*/ 1) {
    				mdbcol3_changes.$$scope = { dirty, ctx };
    			}

    			mdbcol3.$set(mdbcol3_changes);
    		},
    		i: function intro(local) {
    			if (current) return;
    			transition_in(mdbcol0.$$.fragment, local);
    			transition_in(mdbcol1.$$.fragment, local);
    			transition_in(mdbcol2.$$.fragment, local);
    			transition_in(mdbcol3.$$.fragment, local);
    			current = true;
    		},
    		o: function outro(local) {
    			transition_out(mdbcol0.$$.fragment, local);
    			transition_out(mdbcol1.$$.fragment, local);
    			transition_out(mdbcol2.$$.fragment, local);
    			transition_out(mdbcol3.$$.fragment, local);
    			current = false;
    		},
    		d: function destroy(detaching) {
    			destroy_component(mdbcol0, detaching);
    			if (detaching) detach_dev(t0);
    			destroy_component(mdbcol1, detaching);
    			if (detaching) detach_dev(t1);
    			destroy_component(mdbcol2, detaching);
    			if (detaching) detach_dev(t2);
    			destroy_component(mdbcol3, detaching);
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_default_slot$a.name,
    		type: "slot",
    		source: "(9:0) <MDBRow class=\\\"mb-4\\\">",
    		ctx
    	});

    	return block;
    }

    function create_fragment$A(ctx) {
    	let mdbrow;
    	let current;

    	mdbrow = new MDBRow({
    			props: {
    				class: "mb-4",
    				$$slots: { default: [create_default_slot$a] },
    				$$scope: { ctx }
    			},
    			$$inline: true
    		});

    	const block = {
    		c: function create() {
    			create_component(mdbrow.$$.fragment);
    		},
    		l: function claim(nodes) {
    			throw new Error("options.hydrate only works if the component was compiled with the `hydratable: true` option");
    		},
    		m: function mount(target, anchor) {
    			mount_component(mdbrow, target, anchor);
    			current = true;
    		},
    		p: function update(ctx, [dirty]) {
    			const mdbrow_changes = {};

    			if (dirty & /*$$scope*/ 1) {
    				mdbrow_changes.$$scope = { dirty, ctx };
    			}

    			mdbrow.$set(mdbrow_changes);
    		},
    		i: function intro(local) {
    			if (current) return;
    			transition_in(mdbrow.$$.fragment, local);
    			current = true;
    		},
    		o: function outro(local) {
    			transition_out(mdbrow.$$.fragment, local);
    			current = false;
    		},
    		d: function destroy(detaching) {
    			destroy_component(mdbrow, detaching);
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_fragment$A.name,
    		type: "component",
    		source: "",
    		ctx
    	});

    	return block;
    }

    function instance$A($$self, $$props, $$invalidate) {
    	let { $$slots: slots = {}, $$scope } = $$props;
    	validate_slots("AdminCardSection2", slots, []);
    	const writable_props = [];

    	Object.keys($$props).forEach(key => {
    		if (!~writable_props.indexOf(key) && key.slice(0, 2) !== "$$") console.warn(`<AdminCardSection2> was created with unknown prop '${key}'`);
    	});

    	$$self.$capture_state = () => ({
    		MDBRow,
    		MDBCol,
    		MDBCard,
    		MDBIcon,
    		MDBCardBody
    	});

    	return [];
    }

    class AdminCardSection2 extends SvelteComponentDev {
    	constructor(options) {
    		super(options);
    		init(this, options, instance$A, create_fragment$A, safe_not_equal, {});

    		dispatch_dev("SvelteRegisterComponent", {
    			component: this,
    			tagName: "AdminCardSection2",
    			options,
    			id: create_fragment$A.name
    		});
    	}
    }

    /* node_modules/mdbsvelte/src/MDBBreadcrumb.svelte generated by Svelte v3.37.0 */
    const file$r = "node_modules/mdbsvelte/src/MDBBreadcrumb.svelte";

    function create_fragment$z(ctx) {
    	let nav;
    	let ol;
    	let current;
    	let mounted;
    	let dispose;
    	const default_slot_template = /*#slots*/ ctx[10].default;
    	const default_slot = create_slot(default_slot_template, ctx, /*$$scope*/ ctx[9], null);

    	let nav_levels = [
    		/*props*/ ctx[4],
    		{ "aria-label": /*ariaLabel*/ ctx[1] },
    		{ class: /*elementClasses*/ ctx[2] }
    	];

    	let nav_data = {};

    	for (let i = 0; i < nav_levels.length; i += 1) {
    		nav_data = assign(nav_data, nav_levels[i]);
    	}

    	const block = {
    		c: function create() {
    			nav = element("nav");
    			ol = element("ol");
    			if (default_slot) default_slot.c();
    			attr_dev(ol, "class", /*listClasses*/ ctx[0]);
    			add_location(ol, file$r, 24, 2, 747);
    			set_attributes(nav, nav_data);
    			add_location(nav, file$r, 23, 0, 664);
    		},
    		l: function claim(nodes) {
    			throw new Error("options.hydrate only works if the component was compiled with the `hydratable: true` option");
    		},
    		m: function mount(target, anchor) {
    			insert_dev(target, nav, anchor);
    			append_dev(nav, ol);

    			if (default_slot) {
    				default_slot.m(ol, null);
    			}

    			current = true;

    			if (!mounted) {
    				dispose = action_destroyer(/*forwardEvents*/ ctx[3].call(null, nav));
    				mounted = true;
    			}
    		},
    		p: function update(ctx, [dirty]) {
    			if (default_slot) {
    				if (default_slot.p && dirty & /*$$scope*/ 512) {
    					update_slot(default_slot, default_slot_template, ctx, /*$$scope*/ ctx[9], dirty, null, null);
    				}
    			}

    			if (!current || dirty & /*listClasses*/ 1) {
    				attr_dev(ol, "class", /*listClasses*/ ctx[0]);
    			}

    			set_attributes(nav, nav_data = get_spread_update(nav_levels, [
    				/*props*/ ctx[4],
    				(!current || dirty & /*ariaLabel*/ 2) && { "aria-label": /*ariaLabel*/ ctx[1] },
    				(!current || dirty & /*elementClasses*/ 4) && { class: /*elementClasses*/ ctx[2] }
    			]));
    		},
    		i: function intro(local) {
    			if (current) return;
    			transition_in(default_slot, local);
    			current = true;
    		},
    		o: function outro(local) {
    			transition_out(default_slot, local);
    			current = false;
    		},
    		d: function destroy(detaching) {
    			if (detaching) detach_dev(nav);
    			if (default_slot) default_slot.d(detaching);
    			mounted = false;
    			dispose();
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_fragment$z.name,
    		type: "component",
    		source: "",
    		ctx
    	});

    	return block;
    }

    function instance$z($$self, $$props, $$invalidate) {
    	let { $$slots: slots = {}, $$scope } = $$props;
    	validate_slots("MDBBreadcrumb", slots, ['default']);
    	const forwardEvents = forwardEventsBuilder(current_component);
    	let { class: className = "" } = $$props;
    	let elementClasses;
    	let { color } = $$props;
    	let { ariaLabel = "breadcrumb" } = $$props;
    	let { listClasses = "breadcrumb" } = $$props;
    	let { light } = $$props;
    	let { bold } = $$props;
    	const props = clean$1($$props, ["color", "listClasses", "ariaLabel"]);
    	elementClasses = clsx(className);
    	listClasses = clsx(listClasses, color ? getColorClass(color) : false, bold && "font-up-bold", light && "white-text");

    	$$self.$$set = $$new_props => {
    		$$invalidate(11, $$props = assign(assign({}, $$props), exclude_internal_props($$new_props)));
    		if ("class" in $$new_props) $$invalidate(5, className = $$new_props.class);
    		if ("color" in $$new_props) $$invalidate(6, color = $$new_props.color);
    		if ("ariaLabel" in $$new_props) $$invalidate(1, ariaLabel = $$new_props.ariaLabel);
    		if ("listClasses" in $$new_props) $$invalidate(0, listClasses = $$new_props.listClasses);
    		if ("light" in $$new_props) $$invalidate(7, light = $$new_props.light);
    		if ("bold" in $$new_props) $$invalidate(8, bold = $$new_props.bold);
    		if ("$$scope" in $$new_props) $$invalidate(9, $$scope = $$new_props.$$scope);
    	};

    	$$self.$capture_state = () => ({
    		clean: clean$1,
    		clsx,
    		forwardEventsBuilder,
    		getColorClass,
    		current_component,
    		forwardEvents,
    		className,
    		elementClasses,
    		color,
    		ariaLabel,
    		listClasses,
    		light,
    		bold,
    		props
    	});

    	$$self.$inject_state = $$new_props => {
    		$$invalidate(11, $$props = assign(assign({}, $$props), $$new_props));
    		if ("className" in $$props) $$invalidate(5, className = $$new_props.className);
    		if ("elementClasses" in $$props) $$invalidate(2, elementClasses = $$new_props.elementClasses);
    		if ("color" in $$props) $$invalidate(6, color = $$new_props.color);
    		if ("ariaLabel" in $$props) $$invalidate(1, ariaLabel = $$new_props.ariaLabel);
    		if ("listClasses" in $$props) $$invalidate(0, listClasses = $$new_props.listClasses);
    		if ("light" in $$props) $$invalidate(7, light = $$new_props.light);
    		if ("bold" in $$props) $$invalidate(8, bold = $$new_props.bold);
    	};

    	if ($$props && "$$inject" in $$props) {
    		$$self.$inject_state($$props.$$inject);
    	}

    	$$props = exclude_internal_props($$props);

    	return [
    		listClasses,
    		ariaLabel,
    		elementClasses,
    		forwardEvents,
    		props,
    		className,
    		color,
    		light,
    		bold,
    		$$scope,
    		slots
    	];
    }

    class MDBBreadcrumb extends SvelteComponentDev {
    	constructor(options) {
    		super(options);

    		init(this, options, instance$z, create_fragment$z, safe_not_equal, {
    			class: 5,
    			color: 6,
    			ariaLabel: 1,
    			listClasses: 0,
    			light: 7,
    			bold: 8
    		});

    		dispatch_dev("SvelteRegisterComponent", {
    			component: this,
    			tagName: "MDBBreadcrumb",
    			options,
    			id: create_fragment$z.name
    		});

    		const { ctx } = this.$$;
    		const props = options.props || {};

    		if (/*color*/ ctx[6] === undefined && !("color" in props)) {
    			console.warn("<MDBBreadcrumb> was created without expected prop 'color'");
    		}

    		if (/*light*/ ctx[7] === undefined && !("light" in props)) {
    			console.warn("<MDBBreadcrumb> was created without expected prop 'light'");
    		}

    		if (/*bold*/ ctx[8] === undefined && !("bold" in props)) {
    			console.warn("<MDBBreadcrumb> was created without expected prop 'bold'");
    		}
    	}

    	get class() {
    		throw new Error("<MDBBreadcrumb>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	set class(value) {
    		throw new Error("<MDBBreadcrumb>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	get color() {
    		throw new Error("<MDBBreadcrumb>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	set color(value) {
    		throw new Error("<MDBBreadcrumb>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	get ariaLabel() {
    		throw new Error("<MDBBreadcrumb>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	set ariaLabel(value) {
    		throw new Error("<MDBBreadcrumb>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	get listClasses() {
    		throw new Error("<MDBBreadcrumb>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	set listClasses(value) {
    		throw new Error("<MDBBreadcrumb>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	get light() {
    		throw new Error("<MDBBreadcrumb>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	set light(value) {
    		throw new Error("<MDBBreadcrumb>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	get bold() {
    		throw new Error("<MDBBreadcrumb>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	set bold(value) {
    		throw new Error("<MDBBreadcrumb>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}
    }

    /* node_modules/mdbsvelte/src/MDBBreadcrumbItem.svelte generated by Svelte v3.37.0 */
    const file$q = "node_modules/mdbsvelte/src/MDBBreadcrumbItem.svelte";

    // (26:2) {#if icon}
    function create_if_block_1$3(ctx) {
    	let mdbicon;
    	let current;

    	mdbicon = new MDBIcon({
    			props: { far: true, icon: /*icon*/ ctx[2] },
    			$$inline: true
    		});

    	const block = {
    		c: function create() {
    			create_component(mdbicon.$$.fragment);
    		},
    		m: function mount(target, anchor) {
    			mount_component(mdbicon, target, anchor);
    			current = true;
    		},
    		p: function update(ctx, dirty) {
    			const mdbicon_changes = {};
    			if (dirty & /*icon*/ 4) mdbicon_changes.icon = /*icon*/ ctx[2];
    			mdbicon.$set(mdbicon_changes);
    		},
    		i: function intro(local) {
    			if (current) return;
    			transition_in(mdbicon.$$.fragment, local);
    			current = true;
    		},
    		o: function outro(local) {
    			transition_out(mdbicon.$$.fragment, local);
    			current = false;
    		},
    		d: function destroy(detaching) {
    			destroy_component(mdbicon, detaching);
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_if_block_1$3.name,
    		type: "if",
    		source: "(26:2) {#if icon}",
    		ctx
    	});

    	return block;
    }

    // (31:2) {:else}
    function create_else_block$7(ctx) {
    	let a;
    	let current;
    	const default_slot_template = /*#slots*/ ctx[12].default;
    	const default_slot = create_slot(default_slot_template, ctx, /*$$scope*/ ctx[11], null);

    	const block = {
    		c: function create() {
    			a = element("a");
    			if (default_slot) default_slot.c();
    			attr_dev(a, "href", /*href*/ ctx[1]);
    			attr_dev(a, "class", /*childClasses*/ ctx[4]);
    			add_location(a, file$q, 31, 4, 874);
    		},
    		m: function mount(target, anchor) {
    			insert_dev(target, a, anchor);

    			if (default_slot) {
    				default_slot.m(a, null);
    			}

    			current = true;
    		},
    		p: function update(ctx, dirty) {
    			if (default_slot) {
    				if (default_slot.p && dirty & /*$$scope*/ 2048) {
    					update_slot(default_slot, default_slot_template, ctx, /*$$scope*/ ctx[11], dirty, null, null);
    				}
    			}

    			if (!current || dirty & /*href*/ 2) {
    				attr_dev(a, "href", /*href*/ ctx[1]);
    			}

    			if (!current || dirty & /*childClasses*/ 16) {
    				attr_dev(a, "class", /*childClasses*/ ctx[4]);
    			}
    		},
    		i: function intro(local) {
    			if (current) return;
    			transition_in(default_slot, local);
    			current = true;
    		},
    		o: function outro(local) {
    			transition_out(default_slot, local);
    			current = false;
    		},
    		d: function destroy(detaching) {
    			if (detaching) detach_dev(a);
    			if (default_slot) default_slot.d(detaching);
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_else_block$7.name,
    		type: "else",
    		source: "(31:2) {:else}",
    		ctx
    	});

    	return block;
    }

    // (29:2) {#if active}
    function create_if_block$8(ctx) {
    	let current;
    	const default_slot_template = /*#slots*/ ctx[12].default;
    	const default_slot = create_slot(default_slot_template, ctx, /*$$scope*/ ctx[11], null);

    	const block = {
    		c: function create() {
    			if (default_slot) default_slot.c();
    		},
    		m: function mount(target, anchor) {
    			if (default_slot) {
    				default_slot.m(target, anchor);
    			}

    			current = true;
    		},
    		p: function update(ctx, dirty) {
    			if (default_slot) {
    				if (default_slot.p && dirty & /*$$scope*/ 2048) {
    					update_slot(default_slot, default_slot_template, ctx, /*$$scope*/ ctx[11], dirty, null, null);
    				}
    			}
    		},
    		i: function intro(local) {
    			if (current) return;
    			transition_in(default_slot, local);
    			current = true;
    		},
    		o: function outro(local) {
    			transition_out(default_slot, local);
    			current = false;
    		},
    		d: function destroy(detaching) {
    			if (default_slot) default_slot.d(detaching);
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_if_block$8.name,
    		type: "if",
    		source: "(29:2) {#if active}",
    		ctx
    	});

    	return block;
    }

    function create_fragment$y(ctx) {
    	let li;
    	let t;
    	let current_block_type_index;
    	let if_block1;
    	let li_aria_current_value;
    	let current;
    	let mounted;
    	let dispose;
    	let if_block0 = /*icon*/ ctx[2] && create_if_block_1$3(ctx);
    	const if_block_creators = [create_if_block$8, create_else_block$7];
    	const if_blocks = [];

    	function select_block_type(ctx, dirty) {
    		if (/*active*/ ctx[0]) return 0;
    		return 1;
    	}

    	current_block_type_index = select_block_type(ctx);
    	if_block1 = if_blocks[current_block_type_index] = if_block_creators[current_block_type_index](ctx);

    	let li_levels = [
    		/*props*/ ctx[6],
    		{ class: /*elementClasses*/ ctx[3] },
    		{
    			"aria-current": li_aria_current_value = /*active*/ ctx[0] ? "page" : undefined
    		}
    	];

    	let li_data = {};

    	for (let i = 0; i < li_levels.length; i += 1) {
    		li_data = assign(li_data, li_levels[i]);
    	}

    	const block = {
    		c: function create() {
    			li = element("li");
    			if (if_block0) if_block0.c();
    			t = space();
    			if_block1.c();
    			set_attributes(li, li_data);
    			add_location(li, file$q, 24, 0, 680);
    		},
    		l: function claim(nodes) {
    			throw new Error("options.hydrate only works if the component was compiled with the `hydratable: true` option");
    		},
    		m: function mount(target, anchor) {
    			insert_dev(target, li, anchor);
    			if (if_block0) if_block0.m(li, null);
    			append_dev(li, t);
    			if_blocks[current_block_type_index].m(li, null);
    			current = true;

    			if (!mounted) {
    				dispose = action_destroyer(/*forwardEvents*/ ctx[5].call(null, li));
    				mounted = true;
    			}
    		},
    		p: function update(ctx, [dirty]) {
    			if (/*icon*/ ctx[2]) {
    				if (if_block0) {
    					if_block0.p(ctx, dirty);

    					if (dirty & /*icon*/ 4) {
    						transition_in(if_block0, 1);
    					}
    				} else {
    					if_block0 = create_if_block_1$3(ctx);
    					if_block0.c();
    					transition_in(if_block0, 1);
    					if_block0.m(li, t);
    				}
    			} else if (if_block0) {
    				group_outros();

    				transition_out(if_block0, 1, 1, () => {
    					if_block0 = null;
    				});

    				check_outros();
    			}

    			let previous_block_index = current_block_type_index;
    			current_block_type_index = select_block_type(ctx);

    			if (current_block_type_index === previous_block_index) {
    				if_blocks[current_block_type_index].p(ctx, dirty);
    			} else {
    				group_outros();

    				transition_out(if_blocks[previous_block_index], 1, 1, () => {
    					if_blocks[previous_block_index] = null;
    				});

    				check_outros();
    				if_block1 = if_blocks[current_block_type_index];

    				if (!if_block1) {
    					if_block1 = if_blocks[current_block_type_index] = if_block_creators[current_block_type_index](ctx);
    					if_block1.c();
    				} else {
    					if_block1.p(ctx, dirty);
    				}

    				transition_in(if_block1, 1);
    				if_block1.m(li, null);
    			}

    			set_attributes(li, li_data = get_spread_update(li_levels, [
    				/*props*/ ctx[6],
    				(!current || dirty & /*elementClasses*/ 8) && { class: /*elementClasses*/ ctx[3] },
    				(!current || dirty & /*active*/ 1 && li_aria_current_value !== (li_aria_current_value = /*active*/ ctx[0] ? "page" : undefined)) && { "aria-current": li_aria_current_value }
    			]));
    		},
    		i: function intro(local) {
    			if (current) return;
    			transition_in(if_block0);
    			transition_in(if_block1);
    			current = true;
    		},
    		o: function outro(local) {
    			transition_out(if_block0);
    			transition_out(if_block1);
    			current = false;
    		},
    		d: function destroy(detaching) {
    			if (detaching) detach_dev(li);
    			if (if_block0) if_block0.d();
    			if_blocks[current_block_type_index].d();
    			mounted = false;
    			dispose();
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_fragment$y.name,
    		type: "component",
    		source: "",
    		ctx
    	});

    	return block;
    }

    function instance$y($$self, $$props, $$invalidate) {
    	let { $$slots: slots = {}, $$scope } = $$props;
    	validate_slots("MDBBreadcrumbItem", slots, ['default']);
    	const forwardEvents = forwardEventsBuilder(current_component);
    	let { class: className = "" } = $$props;
    	let elementClasses;
    	let childClasses;
    	let { color } = $$props;
    	let { active } = $$props;
    	let { activeClassName = "active" } = $$props;
    	let { href = "#" } = $$props;
    	let { light } = $$props;
    	let { icon } = $$props;
    	const props = clean$1($$props, ["color"]);
    	childClasses = clsx(light ? "white-text" : false);

    	$$self.$$set = $$new_props => {
    		$$invalidate(13, $$props = assign(assign({}, $$props), exclude_internal_props($$new_props)));
    		if ("class" in $$new_props) $$invalidate(7, className = $$new_props.class);
    		if ("color" in $$new_props) $$invalidate(8, color = $$new_props.color);
    		if ("active" in $$new_props) $$invalidate(0, active = $$new_props.active);
    		if ("activeClassName" in $$new_props) $$invalidate(9, activeClassName = $$new_props.activeClassName);
    		if ("href" in $$new_props) $$invalidate(1, href = $$new_props.href);
    		if ("light" in $$new_props) $$invalidate(10, light = $$new_props.light);
    		if ("icon" in $$new_props) $$invalidate(2, icon = $$new_props.icon);
    		if ("$$scope" in $$new_props) $$invalidate(11, $$scope = $$new_props.$$scope);
    	};

    	$$self.$capture_state = () => ({
    		clean: clean$1,
    		clsx,
    		forwardEventsBuilder,
    		current_component,
    		MDBIcon,
    		forwardEvents,
    		className,
    		elementClasses,
    		childClasses,
    		color,
    		active,
    		activeClassName,
    		href,
    		light,
    		icon,
    		props
    	});

    	$$self.$inject_state = $$new_props => {
    		$$invalidate(13, $$props = assign(assign({}, $$props), $$new_props));
    		if ("className" in $$props) $$invalidate(7, className = $$new_props.className);
    		if ("elementClasses" in $$props) $$invalidate(3, elementClasses = $$new_props.elementClasses);
    		if ("childClasses" in $$props) $$invalidate(4, childClasses = $$new_props.childClasses);
    		if ("color" in $$props) $$invalidate(8, color = $$new_props.color);
    		if ("active" in $$props) $$invalidate(0, active = $$new_props.active);
    		if ("activeClassName" in $$props) $$invalidate(9, activeClassName = $$new_props.activeClassName);
    		if ("href" in $$props) $$invalidate(1, href = $$new_props.href);
    		if ("light" in $$props) $$invalidate(10, light = $$new_props.light);
    		if ("icon" in $$props) $$invalidate(2, icon = $$new_props.icon);
    	};

    	if ($$props && "$$inject" in $$props) {
    		$$self.$inject_state($$props.$$inject);
    	}

    	$$self.$$.update = () => {
    		if ($$self.$$.dirty & /*className, color, active, activeClassName*/ 897) {
    			$$invalidate(3, elementClasses = clsx(className, color, active ? activeClassName : false, "breadcrumb-item"));
    		}
    	};

    	$$props = exclude_internal_props($$props);

    	return [
    		active,
    		href,
    		icon,
    		elementClasses,
    		childClasses,
    		forwardEvents,
    		props,
    		className,
    		color,
    		activeClassName,
    		light,
    		$$scope,
    		slots
    	];
    }

    class MDBBreadcrumbItem extends SvelteComponentDev {
    	constructor(options) {
    		super(options);

    		init(this, options, instance$y, create_fragment$y, safe_not_equal, {
    			class: 7,
    			color: 8,
    			active: 0,
    			activeClassName: 9,
    			href: 1,
    			light: 10,
    			icon: 2
    		});

    		dispatch_dev("SvelteRegisterComponent", {
    			component: this,
    			tagName: "MDBBreadcrumbItem",
    			options,
    			id: create_fragment$y.name
    		});

    		const { ctx } = this.$$;
    		const props = options.props || {};

    		if (/*color*/ ctx[8] === undefined && !("color" in props)) {
    			console.warn("<MDBBreadcrumbItem> was created without expected prop 'color'");
    		}

    		if (/*active*/ ctx[0] === undefined && !("active" in props)) {
    			console.warn("<MDBBreadcrumbItem> was created without expected prop 'active'");
    		}

    		if (/*light*/ ctx[10] === undefined && !("light" in props)) {
    			console.warn("<MDBBreadcrumbItem> was created without expected prop 'light'");
    		}

    		if (/*icon*/ ctx[2] === undefined && !("icon" in props)) {
    			console.warn("<MDBBreadcrumbItem> was created without expected prop 'icon'");
    		}
    	}

    	get class() {
    		throw new Error("<MDBBreadcrumbItem>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	set class(value) {
    		throw new Error("<MDBBreadcrumbItem>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	get color() {
    		throw new Error("<MDBBreadcrumbItem>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	set color(value) {
    		throw new Error("<MDBBreadcrumbItem>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	get active() {
    		throw new Error("<MDBBreadcrumbItem>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	set active(value) {
    		throw new Error("<MDBBreadcrumbItem>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	get activeClassName() {
    		throw new Error("<MDBBreadcrumbItem>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	set activeClassName(value) {
    		throw new Error("<MDBBreadcrumbItem>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	get href() {
    		throw new Error("<MDBBreadcrumbItem>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	set href(value) {
    		throw new Error("<MDBBreadcrumbItem>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	get light() {
    		throw new Error("<MDBBreadcrumbItem>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	set light(value) {
    		throw new Error("<MDBBreadcrumbItem>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	get icon() {
    		throw new Error("<MDBBreadcrumbItem>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	set icon(value) {
    		throw new Error("<MDBBreadcrumbItem>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}
    }

    /* node_modules/mdbsvelte/src/MDBFormInline.svelte generated by Svelte v3.37.0 */
    const file$p = "node_modules/mdbsvelte/src/MDBFormInline.svelte";

    function create_fragment$x(ctx) {
    	let form;
    	let current;
    	let mounted;
    	let dispose;
    	const default_slot_template = /*#slots*/ ctx[5].default;
    	const default_slot = create_slot(default_slot_template, ctx, /*$$scope*/ ctx[4], null);
    	let form_levels = [/*props*/ ctx[2], { class: /*elementClasses*/ ctx[0] }];
    	let form_data = {};

    	for (let i = 0; i < form_levels.length; i += 1) {
    		form_data = assign(form_data, form_levels[i]);
    	}

    	const block = {
    		c: function create() {
    			form = element("form");
    			if (default_slot) default_slot.c();
    			set_attributes(form, form_data);
    			add_location(form, file$p, 12, 0, 362);
    		},
    		l: function claim(nodes) {
    			throw new Error("options.hydrate only works if the component was compiled with the `hydratable: true` option");
    		},
    		m: function mount(target, anchor) {
    			insert_dev(target, form, anchor);

    			if (default_slot) {
    				default_slot.m(form, null);
    			}

    			current = true;

    			if (!mounted) {
    				dispose = action_destroyer(/*forwardEvents*/ ctx[1].call(null, form));
    				mounted = true;
    			}
    		},
    		p: function update(ctx, [dirty]) {
    			if (default_slot) {
    				if (default_slot.p && dirty & /*$$scope*/ 16) {
    					update_slot(default_slot, default_slot_template, ctx, /*$$scope*/ ctx[4], dirty, null, null);
    				}
    			}

    			set_attributes(form, form_data = get_spread_update(form_levels, [
    				/*props*/ ctx[2],
    				(!current || dirty & /*elementClasses*/ 1) && { class: /*elementClasses*/ ctx[0] }
    			]));
    		},
    		i: function intro(local) {
    			if (current) return;
    			transition_in(default_slot, local);
    			current = true;
    		},
    		o: function outro(local) {
    			transition_out(default_slot, local);
    			current = false;
    		},
    		d: function destroy(detaching) {
    			if (detaching) detach_dev(form);
    			if (default_slot) default_slot.d(detaching);
    			mounted = false;
    			dispose();
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_fragment$x.name,
    		type: "component",
    		source: "",
    		ctx
    	});

    	return block;
    }

    function instance$x($$self, $$props, $$invalidate) {
    	let { $$slots: slots = {}, $$scope } = $$props;
    	validate_slots("MDBFormInline", slots, ['default']);
    	const forwardEvents = forwardEventsBuilder(current_component);
    	let { class: className = "" } = $$props;
    	const props = clean$1($$props, []);
    	let elementClasses;

    	$$self.$$set = $$new_props => {
    		$$invalidate(6, $$props = assign(assign({}, $$props), exclude_internal_props($$new_props)));
    		if ("class" in $$new_props) $$invalidate(3, className = $$new_props.class);
    		if ("$$scope" in $$new_props) $$invalidate(4, $$scope = $$new_props.$$scope);
    	};

    	$$self.$capture_state = () => ({
    		clean: clean$1,
    		clsx,
    		forwardEventsBuilder,
    		current_component,
    		forwardEvents,
    		className,
    		props,
    		elementClasses
    	});

    	$$self.$inject_state = $$new_props => {
    		$$invalidate(6, $$props = assign(assign({}, $$props), $$new_props));
    		if ("className" in $$props) $$invalidate(3, className = $$new_props.className);
    		if ("elementClasses" in $$props) $$invalidate(0, elementClasses = $$new_props.elementClasses);
    	};

    	if ($$props && "$$inject" in $$props) {
    		$$self.$inject_state($$props.$$inject);
    	}

    	$$self.$$.update = () => {
    		if ($$self.$$.dirty & /*className*/ 8) {
    			$$invalidate(0, elementClasses = clsx(className, "form-inline"));
    		}
    	};

    	$$props = exclude_internal_props($$props);
    	return [elementClasses, forwardEvents, props, className, $$scope, slots];
    }

    class MDBFormInline extends SvelteComponentDev {
    	constructor(options) {
    		super(options);
    		init(this, options, instance$x, create_fragment$x, safe_not_equal, { class: 3 });

    		dispatch_dev("SvelteRegisterComponent", {
    			component: this,
    			tagName: "MDBFormInline",
    			options,
    			id: create_fragment$x.name
    		});
    	}

    	get class() {
    		throw new Error("<MDBFormInline>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	set class(value) {
    		throw new Error("<MDBFormInline>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}
    }

    /* src/components/pages/sections/BreadcrumbSection.svelte generated by Svelte v3.37.0 */
    const file$o = "src/components/pages/sections/BreadcrumbSection.svelte";

    // (14:6) <MDBBreadcrumbItem>
    function create_default_slot_6$7(ctx) {
    	let t;

    	const block = {
    		c: function create() {
    			t = text("Home");
    		},
    		m: function mount(target, anchor) {
    			insert_dev(target, t, anchor);
    		},
    		d: function destroy(detaching) {
    			if (detaching) detach_dev(t);
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_default_slot_6$7.name,
    		type: "slot",
    		source: "(14:6) <MDBBreadcrumbItem>",
    		ctx
    	});

    	return block;
    }

    // (15:6) <MDBBreadcrumbItem active>
    function create_default_slot_5$8(ctx) {
    	let t;

    	const block = {
    		c: function create() {
    			t = text("Dashboard");
    		},
    		m: function mount(target, anchor) {
    			insert_dev(target, t, anchor);
    		},
    		d: function destroy(detaching) {
    			if (detaching) detach_dev(t);
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_default_slot_5$8.name,
    		type: "slot",
    		source: "(15:6) <MDBBreadcrumbItem active>",
    		ctx
    	});

    	return block;
    }

    // (13:4) <MDBBreadcrumb>
    function create_default_slot_4$8(ctx) {
    	let mdbbreadcrumbitem0;
    	let t;
    	let mdbbreadcrumbitem1;
    	let current;

    	mdbbreadcrumbitem0 = new MDBBreadcrumbItem({
    			props: {
    				$$slots: { default: [create_default_slot_6$7] },
    				$$scope: { ctx }
    			},
    			$$inline: true
    		});

    	mdbbreadcrumbitem1 = new MDBBreadcrumbItem({
    			props: {
    				active: true,
    				$$slots: { default: [create_default_slot_5$8] },
    				$$scope: { ctx }
    			},
    			$$inline: true
    		});

    	const block = {
    		c: function create() {
    			create_component(mdbbreadcrumbitem0.$$.fragment);
    			t = space();
    			create_component(mdbbreadcrumbitem1.$$.fragment);
    		},
    		m: function mount(target, anchor) {
    			mount_component(mdbbreadcrumbitem0, target, anchor);
    			insert_dev(target, t, anchor);
    			mount_component(mdbbreadcrumbitem1, target, anchor);
    			current = true;
    		},
    		p: function update(ctx, dirty) {
    			const mdbbreadcrumbitem0_changes = {};

    			if (dirty & /*$$scope*/ 1) {
    				mdbbreadcrumbitem0_changes.$$scope = { dirty, ctx };
    			}

    			mdbbreadcrumbitem0.$set(mdbbreadcrumbitem0_changes);
    			const mdbbreadcrumbitem1_changes = {};

    			if (dirty & /*$$scope*/ 1) {
    				mdbbreadcrumbitem1_changes.$$scope = { dirty, ctx };
    			}

    			mdbbreadcrumbitem1.$set(mdbbreadcrumbitem1_changes);
    		},
    		i: function intro(local) {
    			if (current) return;
    			transition_in(mdbbreadcrumbitem0.$$.fragment, local);
    			transition_in(mdbbreadcrumbitem1.$$.fragment, local);
    			current = true;
    		},
    		o: function outro(local) {
    			transition_out(mdbbreadcrumbitem0.$$.fragment, local);
    			transition_out(mdbbreadcrumbitem1.$$.fragment, local);
    			current = false;
    		},
    		d: function destroy(detaching) {
    			destroy_component(mdbbreadcrumbitem0, detaching);
    			if (detaching) detach_dev(t);
    			destroy_component(mdbbreadcrumbitem1, detaching);
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_default_slot_4$8.name,
    		type: "slot",
    		source: "(13:4) <MDBBreadcrumb>",
    		ctx
    	});

    	return block;
    }

    // (19:6) <MDBBtn size="sm" color="primary" class="my-0" type="submit">
    function create_default_slot_3$8(ctx) {
    	let mdbicon;
    	let current;

    	mdbicon = new MDBIcon({
    			props: { icon: "search" },
    			$$inline: true
    		});

    	const block = {
    		c: function create() {
    			create_component(mdbicon.$$.fragment);
    		},
    		m: function mount(target, anchor) {
    			mount_component(mdbicon, target, anchor);
    			current = true;
    		},
    		p: noop,
    		i: function intro(local) {
    			if (current) return;
    			transition_in(mdbicon.$$.fragment, local);
    			current = true;
    		},
    		o: function outro(local) {
    			transition_out(mdbicon.$$.fragment, local);
    			current = false;
    		},
    		d: function destroy(detaching) {
    			destroy_component(mdbicon, detaching);
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_default_slot_3$8.name,
    		type: "slot",
    		source: "(19:6) <MDBBtn size=\\\"sm\\\" color=\\\"primary\\\" class=\\\"my-0\\\" type=\\\"submit\\\">",
    		ctx
    	});

    	return block;
    }

    // (17:4) <MDBFormInline class="md-form m-0">
    function create_default_slot_2$8(ctx) {
    	let input;
    	let t;
    	let mdbbtn;
    	let current;

    	mdbbtn = new MDBBtn({
    			props: {
    				size: "sm",
    				color: "primary",
    				class: "my-0",
    				type: "submit",
    				$$slots: { default: [create_default_slot_3$8] },
    				$$scope: { ctx }
    			},
    			$$inline: true
    		});

    	const block = {
    		c: function create() {
    			input = element("input");
    			t = space();
    			create_component(mdbbtn.$$.fragment);
    			attr_dev(input, "class", "form-control form-control-sm");
    			attr_dev(input, "type", "search");
    			attr_dev(input, "placeholder", "Type your query");
    			attr_dev(input, "aria-label", "Search");
    			add_location(input, file$o, 17, 6, 760);
    		},
    		m: function mount(target, anchor) {
    			insert_dev(target, input, anchor);
    			insert_dev(target, t, anchor);
    			mount_component(mdbbtn, target, anchor);
    			current = true;
    		},
    		p: function update(ctx, dirty) {
    			const mdbbtn_changes = {};

    			if (dirty & /*$$scope*/ 1) {
    				mdbbtn_changes.$$scope = { dirty, ctx };
    			}

    			mdbbtn.$set(mdbbtn_changes);
    		},
    		i: function intro(local) {
    			if (current) return;
    			transition_in(mdbbtn.$$.fragment, local);
    			current = true;
    		},
    		o: function outro(local) {
    			transition_out(mdbbtn.$$.fragment, local);
    			current = false;
    		},
    		d: function destroy(detaching) {
    			if (detaching) detach_dev(input);
    			if (detaching) detach_dev(t);
    			destroy_component(mdbbtn, detaching);
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_default_slot_2$8.name,
    		type: "slot",
    		source: "(17:4) <MDBFormInline class=\\\"md-form m-0\\\">",
    		ctx
    	});

    	return block;
    }

    // (12:2) <MDBCardBody id="breadcrumb" class="d-flex align-items-center justify-content-between">
    function create_default_slot_1$8(ctx) {
    	let mdbbreadcrumb;
    	let t;
    	let mdbforminline;
    	let current;

    	mdbbreadcrumb = new MDBBreadcrumb({
    			props: {
    				$$slots: { default: [create_default_slot_4$8] },
    				$$scope: { ctx }
    			},
    			$$inline: true
    		});

    	mdbforminline = new MDBFormInline({
    			props: {
    				class: "md-form m-0",
    				$$slots: { default: [create_default_slot_2$8] },
    				$$scope: { ctx }
    			},
    			$$inline: true
    		});

    	const block = {
    		c: function create() {
    			create_component(mdbbreadcrumb.$$.fragment);
    			t = space();
    			create_component(mdbforminline.$$.fragment);
    		},
    		m: function mount(target, anchor) {
    			mount_component(mdbbreadcrumb, target, anchor);
    			insert_dev(target, t, anchor);
    			mount_component(mdbforminline, target, anchor);
    			current = true;
    		},
    		p: function update(ctx, dirty) {
    			const mdbbreadcrumb_changes = {};

    			if (dirty & /*$$scope*/ 1) {
    				mdbbreadcrumb_changes.$$scope = { dirty, ctx };
    			}

    			mdbbreadcrumb.$set(mdbbreadcrumb_changes);
    			const mdbforminline_changes = {};

    			if (dirty & /*$$scope*/ 1) {
    				mdbforminline_changes.$$scope = { dirty, ctx };
    			}

    			mdbforminline.$set(mdbforminline_changes);
    		},
    		i: function intro(local) {
    			if (current) return;
    			transition_in(mdbbreadcrumb.$$.fragment, local);
    			transition_in(mdbforminline.$$.fragment, local);
    			current = true;
    		},
    		o: function outro(local) {
    			transition_out(mdbbreadcrumb.$$.fragment, local);
    			transition_out(mdbforminline.$$.fragment, local);
    			current = false;
    		},
    		d: function destroy(detaching) {
    			destroy_component(mdbbreadcrumb, detaching);
    			if (detaching) detach_dev(t);
    			destroy_component(mdbforminline, detaching);
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_default_slot_1$8.name,
    		type: "slot",
    		source: "(12:2) <MDBCardBody id=\\\"breadcrumb\\\" class=\\\"d-flex align-items-center justify-content-between\\\">",
    		ctx
    	});

    	return block;
    }

    // (11:0) <MDBCard class="mb-5">
    function create_default_slot$9(ctx) {
    	let mdbcardbody;
    	let current;

    	mdbcardbody = new MDBCardBody({
    			props: {
    				id: "breadcrumb",
    				class: "d-flex align-items-center justify-content-between",
    				$$slots: { default: [create_default_slot_1$8] },
    				$$scope: { ctx }
    			},
    			$$inline: true
    		});

    	const block = {
    		c: function create() {
    			create_component(mdbcardbody.$$.fragment);
    		},
    		m: function mount(target, anchor) {
    			mount_component(mdbcardbody, target, anchor);
    			current = true;
    		},
    		p: function update(ctx, dirty) {
    			const mdbcardbody_changes = {};

    			if (dirty & /*$$scope*/ 1) {
    				mdbcardbody_changes.$$scope = { dirty, ctx };
    			}

    			mdbcardbody.$set(mdbcardbody_changes);
    		},
    		i: function intro(local) {
    			if (current) return;
    			transition_in(mdbcardbody.$$.fragment, local);
    			current = true;
    		},
    		o: function outro(local) {
    			transition_out(mdbcardbody.$$.fragment, local);
    			current = false;
    		},
    		d: function destroy(detaching) {
    			destroy_component(mdbcardbody, detaching);
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_default_slot$9.name,
    		type: "slot",
    		source: "(11:0) <MDBCard class=\\\"mb-5\\\">",
    		ctx
    	});

    	return block;
    }

    function create_fragment$w(ctx) {
    	let mdbcard;
    	let current;

    	mdbcard = new MDBCard({
    			props: {
    				class: "mb-5",
    				$$slots: { default: [create_default_slot$9] },
    				$$scope: { ctx }
    			},
    			$$inline: true
    		});

    	const block = {
    		c: function create() {
    			create_component(mdbcard.$$.fragment);
    		},
    		l: function claim(nodes) {
    			throw new Error("options.hydrate only works if the component was compiled with the `hydratable: true` option");
    		},
    		m: function mount(target, anchor) {
    			mount_component(mdbcard, target, anchor);
    			current = true;
    		},
    		p: function update(ctx, [dirty]) {
    			const mdbcard_changes = {};

    			if (dirty & /*$$scope*/ 1) {
    				mdbcard_changes.$$scope = { dirty, ctx };
    			}

    			mdbcard.$set(mdbcard_changes);
    		},
    		i: function intro(local) {
    			if (current) return;
    			transition_in(mdbcard.$$.fragment, local);
    			current = true;
    		},
    		o: function outro(local) {
    			transition_out(mdbcard.$$.fragment, local);
    			current = false;
    		},
    		d: function destroy(detaching) {
    			destroy_component(mdbcard, detaching);
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_fragment$w.name,
    		type: "component",
    		source: "",
    		ctx
    	});

    	return block;
    }

    function instance$w($$self, $$props, $$invalidate) {
    	let { $$slots: slots = {}, $$scope } = $$props;
    	validate_slots("BreadcrumbSection", slots, []);
    	const writable_props = [];

    	Object.keys($$props).forEach(key => {
    		if (!~writable_props.indexOf(key) && key.slice(0, 2) !== "$$") console.warn(`<BreadcrumbSection> was created with unknown prop '${key}'`);
    	});

    	$$self.$capture_state = () => ({
    		MDBCard,
    		MDBCardBody,
    		MDBBreadcrumb,
    		MDBBreadcrumbItem,
    		MDBFormInline,
    		MDBBtn,
    		MDBIcon
    	});

    	return [];
    }

    class BreadcrumbSection extends SvelteComponentDev {
    	constructor(options) {
    		super(options);
    		init(this, options, instance$w, create_fragment$w, safe_not_equal, {});

    		dispatch_dev("SvelteRegisterComponent", {
    			component: this,
    			tagName: "BreadcrumbSection",
    			options,
    			id: create_fragment$w.name
    		});
    	}
    }

    /* node_modules/mdbsvelte/src/MDBCardHeader.svelte generated by Svelte v3.37.0 */
    const file$n = "node_modules/mdbsvelte/src/MDBCardHeader.svelte";

    // (20:0) {:else}
    function create_else_block$6(ctx) {
    	let div;
    	let current;
    	let mounted;
    	let dispose;
    	const default_slot_template = /*#slots*/ ctx[6].default;
    	const default_slot = create_slot(default_slot_template, ctx, /*$$scope*/ ctx[5], null);
    	let div_levels = [/*props*/ ctx[3], { class: /*classes*/ ctx[1] }];
    	let div_data = {};

    	for (let i = 0; i < div_levels.length; i += 1) {
    		div_data = assign(div_data, div_levels[i]);
    	}

    	const block = {
    		c: function create() {
    			div = element("div");
    			if (default_slot) default_slot.c();
    			set_attributes(div, div_data);
    			add_location(div, file$n, 20, 2, 460);
    		},
    		m: function mount(target, anchor) {
    			insert_dev(target, div, anchor);

    			if (default_slot) {
    				default_slot.m(div, null);
    			}

    			current = true;

    			if (!mounted) {
    				dispose = action_destroyer(/*forwardEvents*/ ctx[2].call(null, div));
    				mounted = true;
    			}
    		},
    		p: function update(ctx, dirty) {
    			if (default_slot) {
    				if (default_slot.p && dirty & /*$$scope*/ 32) {
    					update_slot(default_slot, default_slot_template, ctx, /*$$scope*/ ctx[5], dirty, null, null);
    				}
    			}

    			set_attributes(div, div_data = get_spread_update(div_levels, [
    				/*props*/ ctx[3],
    				(!current || dirty & /*classes*/ 2) && { class: /*classes*/ ctx[1] }
    			]));
    		},
    		i: function intro(local) {
    			if (current) return;
    			transition_in(default_slot, local);
    			current = true;
    		},
    		o: function outro(local) {
    			transition_out(default_slot, local);
    			current = false;
    		},
    		d: function destroy(detaching) {
    			if (detaching) detach_dev(div);
    			if (default_slot) default_slot.d(detaching);
    			mounted = false;
    			dispose();
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_else_block$6.name,
    		type: "else",
    		source: "(20:0) {:else}",
    		ctx
    	});

    	return block;
    }

    // (16:0) {#if tag === 'h3'}
    function create_if_block$7(ctx) {
    	let h3;
    	let current;
    	let mounted;
    	let dispose;
    	const default_slot_template = /*#slots*/ ctx[6].default;
    	const default_slot = create_slot(default_slot_template, ctx, /*$$scope*/ ctx[5], null);
    	let h3_levels = [/*props*/ ctx[3], { class: /*classes*/ ctx[1] }];
    	let h3_data = {};

    	for (let i = 0; i < h3_levels.length; i += 1) {
    		h3_data = assign(h3_data, h3_levels[i]);
    	}

    	const block = {
    		c: function create() {
    			h3 = element("h3");
    			if (default_slot) default_slot.c();
    			set_attributes(h3, h3_data);
    			add_location(h3, file$n, 16, 2, 380);
    		},
    		m: function mount(target, anchor) {
    			insert_dev(target, h3, anchor);

    			if (default_slot) {
    				default_slot.m(h3, null);
    			}

    			current = true;

    			if (!mounted) {
    				dispose = action_destroyer(/*forwardEvents*/ ctx[2].call(null, h3));
    				mounted = true;
    			}
    		},
    		p: function update(ctx, dirty) {
    			if (default_slot) {
    				if (default_slot.p && dirty & /*$$scope*/ 32) {
    					update_slot(default_slot, default_slot_template, ctx, /*$$scope*/ ctx[5], dirty, null, null);
    				}
    			}

    			set_attributes(h3, h3_data = get_spread_update(h3_levels, [
    				/*props*/ ctx[3],
    				(!current || dirty & /*classes*/ 2) && { class: /*classes*/ ctx[1] }
    			]));
    		},
    		i: function intro(local) {
    			if (current) return;
    			transition_in(default_slot, local);
    			current = true;
    		},
    		o: function outro(local) {
    			transition_out(default_slot, local);
    			current = false;
    		},
    		d: function destroy(detaching) {
    			if (detaching) detach_dev(h3);
    			if (default_slot) default_slot.d(detaching);
    			mounted = false;
    			dispose();
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_if_block$7.name,
    		type: "if",
    		source: "(16:0) {#if tag === 'h3'}",
    		ctx
    	});

    	return block;
    }

    function create_fragment$v(ctx) {
    	let current_block_type_index;
    	let if_block;
    	let if_block_anchor;
    	let current;
    	const if_block_creators = [create_if_block$7, create_else_block$6];
    	const if_blocks = [];

    	function select_block_type(ctx, dirty) {
    		if (/*tag*/ ctx[0] === "h3") return 0;
    		return 1;
    	}

    	current_block_type_index = select_block_type(ctx);
    	if_block = if_blocks[current_block_type_index] = if_block_creators[current_block_type_index](ctx);

    	const block = {
    		c: function create() {
    			if_block.c();
    			if_block_anchor = empty();
    		},
    		l: function claim(nodes) {
    			throw new Error("options.hydrate only works if the component was compiled with the `hydratable: true` option");
    		},
    		m: function mount(target, anchor) {
    			if_blocks[current_block_type_index].m(target, anchor);
    			insert_dev(target, if_block_anchor, anchor);
    			current = true;
    		},
    		p: function update(ctx, [dirty]) {
    			let previous_block_index = current_block_type_index;
    			current_block_type_index = select_block_type(ctx);

    			if (current_block_type_index === previous_block_index) {
    				if_blocks[current_block_type_index].p(ctx, dirty);
    			} else {
    				group_outros();

    				transition_out(if_blocks[previous_block_index], 1, 1, () => {
    					if_blocks[previous_block_index] = null;
    				});

    				check_outros();
    				if_block = if_blocks[current_block_type_index];

    				if (!if_block) {
    					if_block = if_blocks[current_block_type_index] = if_block_creators[current_block_type_index](ctx);
    					if_block.c();
    				} else {
    					if_block.p(ctx, dirty);
    				}

    				transition_in(if_block, 1);
    				if_block.m(if_block_anchor.parentNode, if_block_anchor);
    			}
    		},
    		i: function intro(local) {
    			if (current) return;
    			transition_in(if_block);
    			current = true;
    		},
    		o: function outro(local) {
    			transition_out(if_block);
    			current = false;
    		},
    		d: function destroy(detaching) {
    			if_blocks[current_block_type_index].d(detaching);
    			if (detaching) detach_dev(if_block_anchor);
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_fragment$v.name,
    		type: "component",
    		source: "",
    		ctx
    	});

    	return block;
    }

    function instance$v($$self, $$props, $$invalidate) {
    	let classes;
    	let { $$slots: slots = {}, $$scope } = $$props;
    	validate_slots("MDBCardHeader", slots, ['default']);
    	const forwardEvents = forwardEventsBuilder(current_component);
    	let { class: className = "" } = $$props;
    	let { tag = "div" } = $$props;
    	const props = clean$1($$props);

    	$$self.$$set = $$new_props => {
    		$$invalidate(7, $$props = assign(assign({}, $$props), exclude_internal_props($$new_props)));
    		if ("class" in $$new_props) $$invalidate(4, className = $$new_props.class);
    		if ("tag" in $$new_props) $$invalidate(0, tag = $$new_props.tag);
    		if ("$$scope" in $$new_props) $$invalidate(5, $$scope = $$new_props.$$scope);
    	};

    	$$self.$capture_state = () => ({
    		clean: clean$1,
    		clsx,
    		forwardEventsBuilder,
    		current_component,
    		forwardEvents,
    		className,
    		tag,
    		props,
    		classes
    	});

    	$$self.$inject_state = $$new_props => {
    		$$invalidate(7, $$props = assign(assign({}, $$props), $$new_props));
    		if ("className" in $$props) $$invalidate(4, className = $$new_props.className);
    		if ("tag" in $$props) $$invalidate(0, tag = $$new_props.tag);
    		if ("classes" in $$props) $$invalidate(1, classes = $$new_props.classes);
    	};

    	if ($$props && "$$inject" in $$props) {
    		$$self.$inject_state($$props.$$inject);
    	}

    	$$self.$$.update = () => {
    		if ($$self.$$.dirty & /*className*/ 16) {
    			$$invalidate(1, classes = clsx(className, "card-header"));
    		}
    	};

    	$$props = exclude_internal_props($$props);
    	return [tag, classes, forwardEvents, props, className, $$scope, slots];
    }

    class MDBCardHeader extends SvelteComponentDev {
    	constructor(options) {
    		super(options);
    		init(this, options, instance$v, create_fragment$v, safe_not_equal, { class: 4, tag: 0 });

    		dispatch_dev("SvelteRegisterComponent", {
    			component: this,
    			tagName: "MDBCardHeader",
    			options,
    			id: create_fragment$v.name
    		});
    	}

    	get class() {
    		throw new Error("<MDBCardHeader>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	set class(value) {
    		throw new Error("<MDBCardHeader>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	get tag() {
    		throw new Error("<MDBCardHeader>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	set tag(value) {
    		throw new Error("<MDBCardHeader>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}
    }

    /* node_modules/mdbsvelte/src/MDBBadge.svelte generated by Svelte v3.37.0 */
    const file$m = "node_modules/mdbsvelte/src/MDBBadge.svelte";

    // (46:0) {:else}
    function create_else_block_1(ctx) {
    	let span;
    	let current_block_type_index;
    	let if_block;
    	let current;
    	let mounted;
    	let dispose;
    	const if_block_creators = [create_if_block_2$1, create_else_block_2];
    	const if_blocks = [];

    	function select_block_type_2(ctx, dirty) {
    		if (/*children*/ ctx[1]) return 0;
    		return 1;
    	}

    	current_block_type_index = select_block_type_2(ctx);
    	if_block = if_blocks[current_block_type_index] = if_block_creators[current_block_type_index](ctx);
    	let span_levels = [/*props*/ ctx[4], { class: /*classes*/ ctx[2] }];
    	let span_data = {};

    	for (let i = 0; i < span_levels.length; i += 1) {
    		span_data = assign(span_data, span_levels[i]);
    	}

    	const block = {
    		c: function create() {
    			span = element("span");
    			if_block.c();
    			set_attributes(span, span_data);
    			add_location(span, file$m, 46, 2, 1004);
    		},
    		m: function mount(target, anchor) {
    			insert_dev(target, span, anchor);
    			if_blocks[current_block_type_index].m(span, null);
    			current = true;

    			if (!mounted) {
    				dispose = action_destroyer(/*forwardEvents*/ ctx[3].call(null, span));
    				mounted = true;
    			}
    		},
    		p: function update(ctx, dirty) {
    			let previous_block_index = current_block_type_index;
    			current_block_type_index = select_block_type_2(ctx);

    			if (current_block_type_index === previous_block_index) {
    				if_blocks[current_block_type_index].p(ctx, dirty);
    			} else {
    				group_outros();

    				transition_out(if_blocks[previous_block_index], 1, 1, () => {
    					if_blocks[previous_block_index] = null;
    				});

    				check_outros();
    				if_block = if_blocks[current_block_type_index];

    				if (!if_block) {
    					if_block = if_blocks[current_block_type_index] = if_block_creators[current_block_type_index](ctx);
    					if_block.c();
    				} else {
    					if_block.p(ctx, dirty);
    				}

    				transition_in(if_block, 1);
    				if_block.m(span, null);
    			}

    			set_attributes(span, span_data = get_spread_update(span_levels, [
    				/*props*/ ctx[4],
    				(!current || dirty & /*classes*/ 4) && { class: /*classes*/ ctx[2] }
    			]));
    		},
    		i: function intro(local) {
    			if (current) return;
    			transition_in(if_block);
    			current = true;
    		},
    		o: function outro(local) {
    			transition_out(if_block);
    			current = false;
    		},
    		d: function destroy(detaching) {
    			if (detaching) detach_dev(span);
    			if_blocks[current_block_type_index].d();
    			mounted = false;
    			dispose();
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_else_block_1.name,
    		type: "else",
    		source: "(46:0) {:else}",
    		ctx
    	});

    	return block;
    }

    // (38:0) {#if href}
    function create_if_block$6(ctx) {
    	let a;
    	let current_block_type_index;
    	let if_block;
    	let current;
    	let mounted;
    	let dispose;
    	const if_block_creators = [create_if_block_1$2, create_else_block$5];
    	const if_blocks = [];

    	function select_block_type_1(ctx, dirty) {
    		if (/*children*/ ctx[1]) return 0;
    		return 1;
    	}

    	current_block_type_index = select_block_type_1(ctx);
    	if_block = if_blocks[current_block_type_index] = if_block_creators[current_block_type_index](ctx);
    	let a_levels = [/*props*/ ctx[4], { href: /*href*/ ctx[0] }, { class: /*classes*/ ctx[2] }];
    	let a_data = {};

    	for (let i = 0; i < a_levels.length; i += 1) {
    		a_data = assign(a_data, a_levels[i]);
    	}

    	const block = {
    		c: function create() {
    			a = element("a");
    			if_block.c();
    			set_attributes(a, a_data);
    			add_location(a, file$m, 38, 2, 859);
    		},
    		m: function mount(target, anchor) {
    			insert_dev(target, a, anchor);
    			if_blocks[current_block_type_index].m(a, null);
    			current = true;

    			if (!mounted) {
    				dispose = action_destroyer(/*forwardEvents*/ ctx[3].call(null, a));
    				mounted = true;
    			}
    		},
    		p: function update(ctx, dirty) {
    			let previous_block_index = current_block_type_index;
    			current_block_type_index = select_block_type_1(ctx);

    			if (current_block_type_index === previous_block_index) {
    				if_blocks[current_block_type_index].p(ctx, dirty);
    			} else {
    				group_outros();

    				transition_out(if_blocks[previous_block_index], 1, 1, () => {
    					if_blocks[previous_block_index] = null;
    				});

    				check_outros();
    				if_block = if_blocks[current_block_type_index];

    				if (!if_block) {
    					if_block = if_blocks[current_block_type_index] = if_block_creators[current_block_type_index](ctx);
    					if_block.c();
    				} else {
    					if_block.p(ctx, dirty);
    				}

    				transition_in(if_block, 1);
    				if_block.m(a, null);
    			}

    			set_attributes(a, a_data = get_spread_update(a_levels, [
    				/*props*/ ctx[4],
    				(!current || dirty & /*href*/ 1) && { href: /*href*/ ctx[0] },
    				(!current || dirty & /*classes*/ 4) && { class: /*classes*/ ctx[2] }
    			]));
    		},
    		i: function intro(local) {
    			if (current) return;
    			transition_in(if_block);
    			current = true;
    		},
    		o: function outro(local) {
    			transition_out(if_block);
    			current = false;
    		},
    		d: function destroy(detaching) {
    			if (detaching) detach_dev(a);
    			if_blocks[current_block_type_index].d();
    			mounted = false;
    			dispose();
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_if_block$6.name,
    		type: "if",
    		source: "(38:0) {#if href}",
    		ctx
    	});

    	return block;
    }

    // (50:4) {:else}
    function create_else_block_2(ctx) {
    	let current;
    	const default_slot_template = /*#slots*/ ctx[10].default;
    	const default_slot = create_slot(default_slot_template, ctx, /*$$scope*/ ctx[9], null);

    	const block = {
    		c: function create() {
    			if (default_slot) default_slot.c();
    		},
    		m: function mount(target, anchor) {
    			if (default_slot) {
    				default_slot.m(target, anchor);
    			}

    			current = true;
    		},
    		p: function update(ctx, dirty) {
    			if (default_slot) {
    				if (default_slot.p && dirty & /*$$scope*/ 512) {
    					update_slot(default_slot, default_slot_template, ctx, /*$$scope*/ ctx[9], dirty, null, null);
    				}
    			}
    		},
    		i: function intro(local) {
    			if (current) return;
    			transition_in(default_slot, local);
    			current = true;
    		},
    		o: function outro(local) {
    			transition_out(default_slot, local);
    			current = false;
    		},
    		d: function destroy(detaching) {
    			if (default_slot) default_slot.d(detaching);
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_else_block_2.name,
    		type: "else",
    		source: "(50:4) {:else}",
    		ctx
    	});

    	return block;
    }

    // (48:4) {#if children}
    function create_if_block_2$1(ctx) {
    	let t;

    	const block = {
    		c: function create() {
    			t = text(/*children*/ ctx[1]);
    		},
    		m: function mount(target, anchor) {
    			insert_dev(target, t, anchor);
    		},
    		p: function update(ctx, dirty) {
    			if (dirty & /*children*/ 2) set_data_dev(t, /*children*/ ctx[1]);
    		},
    		i: noop,
    		o: noop,
    		d: function destroy(detaching) {
    			if (detaching) detach_dev(t);
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_if_block_2$1.name,
    		type: "if",
    		source: "(48:4) {#if children}",
    		ctx
    	});

    	return block;
    }

    // (42:4) {:else}
    function create_else_block$5(ctx) {
    	let current;
    	const default_slot_template = /*#slots*/ ctx[10].default;
    	const default_slot = create_slot(default_slot_template, ctx, /*$$scope*/ ctx[9], null);

    	const block = {
    		c: function create() {
    			if (default_slot) default_slot.c();
    		},
    		m: function mount(target, anchor) {
    			if (default_slot) {
    				default_slot.m(target, anchor);
    			}

    			current = true;
    		},
    		p: function update(ctx, dirty) {
    			if (default_slot) {
    				if (default_slot.p && dirty & /*$$scope*/ 512) {
    					update_slot(default_slot, default_slot_template, ctx, /*$$scope*/ ctx[9], dirty, null, null);
    				}
    			}
    		},
    		i: function intro(local) {
    			if (current) return;
    			transition_in(default_slot, local);
    			current = true;
    		},
    		o: function outro(local) {
    			transition_out(default_slot, local);
    			current = false;
    		},
    		d: function destroy(detaching) {
    			if (default_slot) default_slot.d(detaching);
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_else_block$5.name,
    		type: "else",
    		source: "(42:4) {:else}",
    		ctx
    	});

    	return block;
    }

    // (40:4) {#if children}
    function create_if_block_1$2(ctx) {
    	let t;

    	const block = {
    		c: function create() {
    			t = text(/*children*/ ctx[1]);
    		},
    		m: function mount(target, anchor) {
    			insert_dev(target, t, anchor);
    		},
    		p: function update(ctx, dirty) {
    			if (dirty & /*children*/ 2) set_data_dev(t, /*children*/ ctx[1]);
    		},
    		i: noop,
    		o: noop,
    		d: function destroy(detaching) {
    			if (detaching) detach_dev(t);
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_if_block_1$2.name,
    		type: "if",
    		source: "(40:4) {#if children}",
    		ctx
    	});

    	return block;
    }

    function create_fragment$u(ctx) {
    	let current_block_type_index;
    	let if_block;
    	let if_block_anchor;
    	let current;
    	const if_block_creators = [create_if_block$6, create_else_block_1];
    	const if_blocks = [];

    	function select_block_type(ctx, dirty) {
    		if (/*href*/ ctx[0]) return 0;
    		return 1;
    	}

    	current_block_type_index = select_block_type(ctx);
    	if_block = if_blocks[current_block_type_index] = if_block_creators[current_block_type_index](ctx);

    	const block = {
    		c: function create() {
    			if_block.c();
    			if_block_anchor = empty();
    		},
    		l: function claim(nodes) {
    			throw new Error("options.hydrate only works if the component was compiled with the `hydratable: true` option");
    		},
    		m: function mount(target, anchor) {
    			if_blocks[current_block_type_index].m(target, anchor);
    			insert_dev(target, if_block_anchor, anchor);
    			current = true;
    		},
    		p: function update(ctx, [dirty]) {
    			let previous_block_index = current_block_type_index;
    			current_block_type_index = select_block_type(ctx);

    			if (current_block_type_index === previous_block_index) {
    				if_blocks[current_block_type_index].p(ctx, dirty);
    			} else {
    				group_outros();

    				transition_out(if_blocks[previous_block_index], 1, 1, () => {
    					if_blocks[previous_block_index] = null;
    				});

    				check_outros();
    				if_block = if_blocks[current_block_type_index];

    				if (!if_block) {
    					if_block = if_blocks[current_block_type_index] = if_block_creators[current_block_type_index](ctx);
    					if_block.c();
    				} else {
    					if_block.p(ctx, dirty);
    				}

    				transition_in(if_block, 1);
    				if_block.m(if_block_anchor.parentNode, if_block_anchor);
    			}
    		},
    		i: function intro(local) {
    			if (current) return;
    			transition_in(if_block);
    			current = true;
    		},
    		o: function outro(local) {
    			transition_out(if_block);
    			current = false;
    		},
    		d: function destroy(detaching) {
    			if_blocks[current_block_type_index].d(detaching);
    			if (detaching) detach_dev(if_block_anchor);
    		}
    	};

    	dispatch_dev("SvelteRegisterBlock", {
    		block,
    		id: create_fragment$u.name,
    		type: "component",
    		source: "",
    		ctx
    	});

    	return block;
    }

    function instance$u($$self, $$props, $$invalidate) {
    	let classes;
    	let { $$slots: slots = {}, $$scope } = $$props;
    	validate_slots("MDBBadge", slots, ['default']);
    	const forwardEvents = forwardEventsBuilder(current_component);
    	let { class: className = "" } = $$props;
    	let { children = undefined } = $$props;
    	let { color = "secondary" } = $$props;
    	let { href = undefined } = $$props;
    	let { pill = false } = $$props;
    	let { tag } = $$props;

    	if (tag === "a" && !href) {
    		href = "#";
    	}

    	let badge_colors = [
    		"primary",
    		"secondary",
    		"default",
    		"success",
    		"info",
    		"warning",
    		"danger",
    		"light",
    		"dark"
    	];

    	const props = clean$1($$props, ["children", "color", "href", "pill", "tag"]);

    	$$self.$$set = $$new_props => {
    		$$invalidate(12, $$props = assign(assign({}, $$props), exclude_internal_props($$new_props)));
    		if ("class" in $$new_props) $$invalidate(5, className = $$new_props.class);
    		if ("children" in $$new_props) $$invalidate(1, children = $$new_props.children);
    		if ("color" in $$new_props) $$invalidate(6, color = $$new_props.color);
    		if ("href" in $$new_props) $$invalidate(0, href = $$new_props.href);
    		if ("pill" in $$new_props) $$invalidate(7, pill = $$new_props.pill);
    		if ("tag" in $$new_props) $$invalidate(8, tag = $$new_props.tag);
    		if ("$$scope" in $$new_props) $$invalidate(9, $$scope = $$new_props.$$scope);
    	};

    	$$self.$capture_state = () => ({
    		clean: clean$1,
    		clsx,
    		forwardEventsBuilder,
    		getColorClass,
    		current_component,
    		forwardEvents,
    		className,
    		children,
    		color,
    		href,
    		pill,
    		tag,
    		badge_colors,
    		props,
    		classes
    	});

    	$$self.$inject_state = $$new_props => {
    		$$invalidate(12, $$props = assign(assign({}, $$props), $$new_props));
    		if ("className" in $$props) $$invalidate(5, className = $$new_props.className);
    		if ("children" in $$props) $$invalidate(1, children = $$new_props.children);
    		if ("color" in $$props) $$invalidate(6, color = $$new_props.color);
    		if ("href" in $$props) $$invalidate(0, href = $$new_props.href);
    		if ("pill" in $$props) $$invalidate(7, pill = $$new_props.pill);
    		if ("tag" in $$props) $$invalidate(8, tag = $$new_props.tag);
    		if ("badge_colors" in $$props) $$invalidate(11, badge_colors = $$new_props.badge_colors);
    		if ("classes" in $$props) $$invalidate(2, classes = $$new_props.classes);
    	};

    	if ($$props && "$$inject" in $$props) {
    		$$self.$inject_state($$props.$$inject);
    	}

    	$$self.$$.update = () => {
    		if ($$self.$$.dirty & /*className, color, pill*/ 224) {
    			$$invalidate(2, classes = clsx(
    				className,
    				"badge",
    				badge_colors.includes(color)
    				? `badge-${color}`
    				: getColorClass(color),
    				pill ? "badge-pill" : false
    			));
    		}
    	};

    	$$props = exclude_internal_props($$props);

    	return [
    		href,
    		children,
    		classes,
    		forwardEvents,
    		props,
    		className,
    		color,
    		pill,
    		tag,
    		$$scope,
    		slots
    	];
    }

    class MDBBadge extends SvelteComponentDev {
    	constructor(options) {
    		super(options);

    		init(this, options, instance$u, create_fragment$u, safe_not_equal, {
    			class: 5,
    			children: 1,
    			color: 6,
    			href: 0,
    			pill: 7,
    			tag: 8
    		});

    		dispatch_dev("SvelteRegisterComponent", {
    			component: this,
    			tagName: "MDBBadge",
    			options,
    			id: create_fragment$u.name
    		});

    		const { ctx } = this.$$;
    		const props = options.props || {};

    		if (/*tag*/ ctx[8] === undefined && !("tag" in props)) {
    			console.warn("<MDBBadge> was created without expected prop 'tag'");
    		}
    	}

    	get class() {
    		throw new Error("<MDBBadge>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	set class(value) {
    		throw new Error("<MDBBadge>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	get children() {
    		throw new Error("<MDBBadge>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	set children(value) {
    		throw new Error("<MDBBadge>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	get color() {
    		throw new Error("<MDBBadge>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	set color(value) {
    		throw new Error("<MDBBadge>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	get href() {
    		throw new Error("<MDBBadge>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	set href(value) {
    		throw new Error("<MDBBadge>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	get pill() {
    		throw new Error("<MDBBadge>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	set pill(value) {
    		throw new Error("<MDBBadge>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	get tag() {
    		throw new Error("<MDBBadge>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}

    	set tag(value) {
    		throw new Error("<MDBBadge>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
    	}
    }

    function clean($$props, extra_keys) {
      let keys = ["children", "$$scope", "$$slots"].concat(extra_keys);
      const rest = {};
      for (const key of Object.keys($$props)) {
        if (!(keys.includes(key))) {
          rest[key] = $$props[key];
        }
      }
      return rest;
    }

    var commonjsGlobal = typeof globalThis !== 'undefined' ? globalThis : typeof window !== 'undefined' ? window : typeof global !== 'undefined' ? global : typeof self !== 'undefined' ? self : {};

    function createCommonjsModule(fn) {
      var module = { exports: {} };
    	return fn(module, module.exports), module.exports;
    }

    function commonjsRequire (target) {
    	throw new Error('Could not dynamically require "' + target + '". Please configure the dynamicRequireTargets option of @rollup/plugin-commonjs appropriately for this require call to behave properly.');
    }

    var moment = createCommonjsModule(function (module, exports) {
    (function (global, factory) {
        module.exports = factory() ;
    }(commonjsGlobal, (function () {
        var hookCallback;

        function hooks() {
            return hookCallback.apply(null, arguments);
        }

        // This is done to register the method called with moment()
        // without creating circular dependencies.
        function setHookCallback(callback) {
            hookCallback = callback;
        }

        function isArray(input) {
            return (
                input instanceof Array ||
                Object.prototype.toString.call(input) === '[object Array]'
            );
        }

        function isObject(input) {
            // IE8 will treat undefined and null as object if it wasn't for
            // input != null
            return (
                input != null &&
                Object.prototype.toString.call(input) === '[object Object]'
            );
        }

        function hasOwnProp(a, b) {
            return Object.prototype.hasOwnProperty.call(a, b);
        }

        function isObjectEmpty(obj) {
            if (Object.getOwnPropertyNames) {
                return Object.getOwnPropertyNames(obj).length === 0;
            } else {
                var k;
                for (k in obj) {
                    if (hasOwnProp(obj, k)) {
                        return false;
                    }
                }
                return true;
            }
        }

        function isUndefined(input) {
            return input === void 0;
        }

        function isNumber(input) {
            return (
                typeof input === 'number' ||
                Object.prototype.toString.call(input) === '[object Number]'
            );
        }

        function isDate(input) {
            return (
                input instanceof Date ||
                Object.prototype.toString.call(input) === '[object Date]'
            );
        }

        function map(arr, fn) {
            var res = [],
                i;
            for (i = 0; i < arr.length; ++i) {
                res.push(fn(arr[i], i));
            }
            return res;
        }

        function extend(a, b) {
            for (var i in b) {
                if (hasOwnProp(b, i)) {
                    a[i] = b[i];
                }
            }

            if (hasOwnProp(b, 'toString')) {
                a.toString = b.toString;
            }

            if (hasOwnProp(b, 'valueOf')) {
                a.valueOf = b.valueOf;
            }

            return a;
        }

        function createUTC(input, format, locale, strict) {
            return createLocalOrUTC(input, format, locale, strict, true).utc();
        }

        function defaultParsingFlags() {
            // We need to deep clone this object.
            return {
                empty: false,
                unusedTokens: [],
                unusedInput: [],
                overflow: -2,
                charsLeftOver: 0,
                nullInput: false,
                invalidEra: null,
                invalidMonth: null,
                invalidFormat: false,
                userInvalidated: false,
                iso: false,
                parsedDateParts: [],
                era: null,
                meridiem: null,
                rfc2822: false,
                weekdayMismatch: false,
            };
        }

        function getParsingFlags(m) {
            if (m._pf == null) {
                m._pf = defaultParsingFlags();
            }
            return m._pf;
        }

        var some;
        if (Array.prototype.some) {
            some = Array.prototype.some;
        } else {
            some = function (fun) {
                var t = Object(this),
                    len = t.length >>> 0,
                    i;

                for (i = 0; i < len; i++) {
                    if (i in t && fun.call(this, t[i], i, t)) {
                        return true;
                    }
                }

                return false;
            };
        }

        function isValid(m) {
            if (m._isValid == null) {
                var flags = getParsingFlags(m),
                    parsedParts = some.call(flags.parsedDateParts, function (i) {
                        return i != null;
                    }),
                    isNowValid =
                        !isNaN(m._d.getTime()) &&
                        flags.overflow < 0 &&
                        !flags.empty &&
                        !flags.invalidEra &&
                        !flags.invalidMonth &&
                        !flags.invalidWeekday &&
                        !flags.weekdayMismatch &&
                        !flags.nullInput &&
                        !flags.invalidFormat &&
                        !flags.userInvalidated &&
                        (!flags.meridiem || (flags.meridiem && parsedParts));

                if (m._strict) {
                    isNowValid =
                        isNowValid &&
                        flags.charsLeftOver === 0 &&
                        flags.unusedTokens.length === 0 &&
                        flags.bigHour === undefined;
                }

                if (Object.isFrozen == null || !Object.isFrozen(m)) {
                    m._isValid = isNowValid;
                } else {
                    return isNowValid;
                }
            }
            return m._isValid;
        }

        function createInvalid(flags) {
            var m = createUTC(NaN);
            if (flags != null) {
                extend(getParsingFlags(m), flags);
            } else {
                getParsingFlags(m).userInvalidated = true;
            }

            return m;
        }

        // Plugins that add properties should also add the key here (null value),
        // so we can properly clone ourselves.
        var momentProperties = (hooks.momentProperties = []),
            updateInProgress = false;

        function copyConfig(to, from) {
            var i, prop, val;

            if (!isUndefined(from._isAMomentObject)) {
                to._isAMomentObject = from._isAMomentObject;
            }
            if (!isUndefined(from._i)) {
                to._i = from._i;
            }
            if (!isUndefined(from._f)) {
                to._f = from._f;
            }
            if (!isUndefined(from._l)) {
                to._l = from._l;
            }
            if (!isUndefined(from._strict)) {
                to._strict = from._strict;
            }
            if (!isUndefined(from._tzm)) {
                to._tzm = from._tzm;
            }
            if (!isUndefined(from._isUTC)) {
                to._isUTC = from._isUTC;
            }
            if (!isUndefined(from._offset)) {
                to._offset = from._offset;
            }
            if (!isUndefined(from._pf)) {
                to._pf = getParsingFlags(from);
            }
            if (!isUndefined(from._locale)) {
                to._locale = from._locale;
            }

            if (momentProperties.length > 0) {
                for (i = 0; i < momentProperties.length; i++) {
                    prop = momentProperties[i];
                    val = from[prop];
                    if (!isUndefined(val)) {
                        to[prop] = val;
                    }
                }
            }

            return to;
        }

        // Moment prototype object
        function Moment(config) {
            copyConfig(this, config);
            this._d = new Date(config._d != null ? config._d.getTime() : NaN);
            if (!this.isValid()) {
                this._d = new Date(NaN);
            }
            // Prevent infinite loop in case updateOffset creates new moment
            // objects.
            if (updateInProgress === false) {
                updateInProgress = true;
                hooks.updateOffset(this);
                updateInProgress = false;
            }
        }

        function isMoment(obj) {
            return (
                obj instanceof Moment || (obj != null && obj._isAMomentObject != null)
            );
        }

        function warn(msg) {
            if (
                hooks.suppressDeprecationWarnings === false &&
                typeof console !== 'undefined' &&
                console.warn
            ) {
                console.warn('Deprecation warning: ' + msg);
            }
        }

        function deprecate(msg, fn) {
            var firstTime = true;

            return extend(function () {
                if (hooks.deprecationHandler != null) {
                    hooks.deprecationHandler(null, msg);
                }
                if (firstTime) {
                    var args = [],
                        arg,
                        i,
                        key;
                    for (i = 0; i < arguments.length; i++) {
                        arg = '';
                        if (typeof arguments[i] === 'object') {
                            arg += '\n[' + i + '] ';
                            for (key in arguments[0]) {
                                if (hasOwnProp(arguments[0], key)) {
                                    arg += key + ': ' + arguments[0][key] + ', ';
                                }
                            }
                            arg = arg.slice(0, -2); // Remove trailing comma and space
                        } else {
                            arg = arguments[i];
                        }
                        args.push(arg);
                    }
                    warn(
                        msg +
                            '\nArguments: ' +
                            Array.prototype.slice.call(args).join('') +
                            '\n' +
                            new Error().stack
                    );
                    firstTime = false;
                }
                return fn.apply(this, arguments);
            }, fn);
        }

        var deprecations = {};

        function deprecateSimple(name, msg) {
            if (hooks.deprecationHandler != null) {
                hooks.deprecationHandler(name, msg);
            }
            if (!deprecations[name]) {
                warn(msg);
                deprecations[name] = true;
            }
        }

        hooks.suppressDeprecationWarnings = false;
        hooks.deprecationHandler = null;

        function isFunction(input) {
            return (
                (typeof Function !== 'undefined' && input instanceof Function) ||
                Object.prototype.toString.call(input) === '[object Function]'
            );
        }

        function set(config) {
            var prop, i;
            for (i in config) {
                if (hasOwnProp(config, i)) {
                    prop = config[i];
                    if (isFunction(prop)) {
                        this[i] = prop;
                    } else {
                        this['_' + i] = prop;
                    }
                }
            }
            this._config = config;
            // Lenient ordinal parsing accepts just a number in addition to
            // number + (possibly) stuff coming from _dayOfMonthOrdinalParse.
            // TODO: Remove "ordinalParse" fallback in next major release.
            this._dayOfMonthOrdinalParseLenient = new RegExp(
                (this._dayOfMonthOrdinalParse.source || this._ordinalParse.source) +
                    '|' +
                    /\d{1,2}/.source
            );
        }

        function mergeConfigs(parentConfig, childConfig) {
            var res = extend({}, parentConfig),
                prop;
            for (prop in childConfig) {
                if (hasOwnProp(childConfig, prop)) {
                    if (isObject(parentConfig[prop]) && isObject(childConfig[prop])) {
                        res[prop] = {};
                        extend(res[prop], parentConfig[prop]);
                        extend(res[prop], childConfig[prop]);
                    } else if (childConfig[prop] != null) {
                        res[prop] = childConfig[prop];
                    } else {
                        delete res[prop];
                    }
                }
            }
            for (prop in parentConfig) {
                if (
                    hasOwnProp(parentConfig, prop) &&
                    !hasOwnProp(childConfig, prop) &&
                    isObject(parentConfig[prop])
                ) {
                    // make sure changes to properties don't modify parent config
                    res[prop] = extend({}, res[prop]);
                }
            }
            return res;
        }

        function Locale(config) {
            if (config != null) {
                this.set(config);
            }
        }

        var keys;

        if (Object.keys) {
            keys = Object.keys;
        } else {
            keys = function (obj) {
                var i,
                    res = [];
                for (i in obj) {
                    if (hasOwnProp(obj, i)) {
                        res.push(i);
                    }
                }
                return res;
            };
        }

        var defaultCalendar = {
            sameDay: '[Today at] LT',
            nextDay: '[Tomorrow at] LT',
            nextWeek: 'dddd [at] LT',
            lastDay: '[Yesterday at] LT',
            lastWeek: '[Last] dddd [at] LT',
            sameElse: 'L',
        };

        function calendar(key, mom, now) {
            var output = this._calendar[key] || this._calendar['sameElse'];
            return isFunction(output) ? output.call(mom, now) : output;
        }

        function zeroFill(number, targetLength, forceSign) {
            var absNumber = '' + Math.abs(number),
                zerosToFill = targetLength - absNumber.length,
                sign = number >= 0;
            return (
                (sign ? (forceSign ? '+' : '') : '-') +
                Math.pow(10, Math.max(0, zerosToFill)).toString().substr(1) +
                absNumber
            );
        }

        var formattingTokens = /(\[[^\[]*\])|(\\)?([Hh]mm(ss)?|Mo|MM?M?M?|Do|DDDo|DD?D?D?|ddd?d?|do?|w[o|w]?|W[o|W]?|Qo?|N{1,5}|YYYYYY|YYYYY|YYYY|YY|y{2,4}|yo?|gg(ggg?)?|GG(GGG?)?|e|E|a|A|hh?|HH?|kk?|mm?|ss?|S{1,9}|x|X|zz?|ZZ?|.)/g,
            localFormattingTokens = /(\[[^\[]*\])|(\\)?(LTS|LT|LL?L?L?|l{1,4})/g,
            formatFunctions = {},
            formatTokenFunctions = {};

        // token:    'M'
        // padded:   ['MM', 2]
        // ordinal:  'Mo'
        // callback: function () { this.month() + 1 }
        function addFormatToken(token, padded, ordinal, callback) {
            var func = callback;
            if (typeof callback === 'string') {
                func = function () {
                    return this[callback]();
                };
            }
            if (token) {
                formatTokenFunctions[token] = func;
            }
            if (padded) {
                formatTokenFunctions[padded[0]] = function () {
                    return zeroFill(func.apply(this, arguments), padded[1], padded[2]);
                };
            }
            if (ordinal) {
                formatTokenFunctions[ordinal] = function () {
                    return this.localeData().ordinal(
                        func.apply(this, arguments),
                        token
                    );
                };
            }
        }

        function removeFormattingTokens(input) {
            if (input.match(/\[[\s\S]/)) {
                return input.replace(/^\[|\]$/g, '');
            }
            return input.replace(/\\/g, '');
        }

        function makeFormatFunction(format) {
            var array = format.match(formattingTokens),
                i,
                length;

            for (i = 0, length = array.length; i < length; i++) {
                if (formatTokenFunctions[array[i]]) {
                    array[i] = formatTokenFunctions[array[i]];
                } else {
                    array[i] = removeFormattingTokens(array[i]);
                }
            }

            return function (mom) {
                var output = '',
                    i;
                for (i = 0; i < length; i++) {
                    output += isFunction(array[i])
                        ? array[i].call(mom, format)
                        : array[i];
                }
                return output;
            };
        }

        // format date using native date object
        function formatMoment(m, format) {
            if (!m.isValid()) {
                return m.localeData().invalidDate();
            }

            format = expandFormat(format, m.localeData());
            formatFunctions[format] =
                formatFunctions[format] || makeFormatFunction(format);

            return formatFunctions[format](m);
        }

        function expandFormat(format, locale) {
            var i = 5;

            function replaceLongDateFormatTokens(input) {
                return locale.longDateFormat(input) || input;
            }

            localFormattingTokens.lastIndex = 0;
            while (i >= 0 && localFormattingTokens.test(format)) {
                format = format.replace(
                    localFormattingTokens,
                    replaceLongDateFormatTokens
                );
                localFormattingTokens.lastIndex = 0;
                i -= 1;
            }

            return format;
        }

        var defaultLongDateFormat = {
            LTS: 'h:mm:ss A',
            LT: 'h:mm A',
            L: 'MM/DD/YYYY',
            LL: 'MMMM D, YYYY',
            LLL: 'MMMM D, YYYY h:mm A',
            LLLL: 'dddd, MMMM D, YYYY h:mm A',
        };

        function longDateFormat(key) {
            var format = this._longDateFormat[key],
                formatUpper = this._longDateFormat[key.toUpperCase()];

            if (format || !formatUpper) {
                return format;
            }

            this._longDateFormat[key] = formatUpper
                .match(formattingTokens)
                .map(function (tok) {
                    if (
                        tok === 'MMMM' ||
                        tok === 'MM' ||
                        tok === 'DD' ||
                        tok === 'dddd'
                    ) {
                        return tok.slice(1);
                    }
                    return tok;
                })
                .join('');

            return this._longDateFormat[key];
        }

        var defaultInvalidDate = 'Invalid date';

        function invalidDate() {
            return this._invalidDate;
        }

        var defaultOrdinal = '%d',
            defaultDayOfMonthOrdinalParse = /\d{1,2}/;

        function ordinal(number) {
            return this._ordinal.replace('%d', number);
        }

        var defaultRelativeTime = {
            future: 'in %s',
            past: '%s ago',
            s: 'a few seconds',
            ss: '%d seconds',
            m: 'a minute',
            mm: '%d minutes',
            h: 'an hour',
            hh: '%d hours',
            d: 'a day',
            dd: '%d days',
            w: 'a week',
            ww: '%d weeks',
            M: 'a month',
            MM: '%d months',
            y: 'a year',
            yy: '%d years',
        };

        function relativeTime(number, withoutSuffix, string, isFuture) {
            var output = this._relativeTime[string];
            return isFunction(output)
                ? output(number, withoutSuffix, string, isFuture)
                : output.replace(/%d/i, number);
        }

        function pastFuture(diff, output) {
            var format = this._relativeTime[diff > 0 ? 'future' : 'past'];
            return isFunction(format) ? format(output) : format.replace(/%s/i, output);
        }

        var aliases = {};

        function addUnitAlias(unit, shorthand) {
            var lowerCase = unit.toLowerCase();
            aliases[lowerCase] = aliases[lowerCase + 's'] = aliases[shorthand] = unit;
        }

        function normalizeUnits(units) {
            return typeof units === 'string'
                ? aliases[units] || aliases[units.toLowerCase()]
                : undefined;
        }

        function normalizeObjectUnits(inputObject) {
            var normalizedInput = {},
                normalizedProp,
                prop;

            for (prop in inputObject) {
                if (hasOwnProp(inputObject, prop)) {
                    normalizedProp = normalizeUnits(prop);
                    if (normalizedProp) {
                        normalizedInput[normalizedProp] = inputObject[prop];
                    }
                }
            }

            return normalizedInput;
        }

        var priorities = {};

        function addUnitPriority(unit, priority) {
            priorities[unit] = priority;
        }

        function getPrioritizedUnits(unitsObj) {
            var units = [],
                u;
            for (u in unitsObj) {
                if (hasOwnProp(unitsObj, u)) {
                    units.push({ unit: u, priority: priorities[u] });
                }
            }
            units.sort(function (a, b) {
                return a.priority - b.priority;
            });
            return units;
        }

        function isLeapYear(year) {
            return (year % 4 === 0 && year % 100 !== 0) || year % 400 === 0;
        }

        function absFloor(number) {
            if (number < 0) {
                // -0 -> 0
                return Math.ceil(number) || 0;
            } else {
                return Math.floor(number);
            }
        }

        function toInt(argumentForCoercion) {
            var coercedNumber = +argumentForCoercion,
                value = 0;

            if (coercedNumber !== 0 && isFinite(coercedNumber)) {
                value = absFloor(coercedNumber);
            }

            return value;
        }

        function makeGetSet(unit, keepTime) {
            return function (value) {
                if (value != null) {
                    set$1(this, unit, value);
                    hooks.updateOffset(this, keepTime);
                    return this;
                } else {
                    return get(this, unit);
                }
            };
        }

        function get(mom, unit) {
            return mom.isValid()
                ? mom._d['get' + (mom._isUTC ? 'UTC' : '') + unit]()
                : NaN;
        }

        function set$1(mom, unit, value) {
            if (mom.isValid() && !isNaN(value)) {
                if (
                    unit === 'FullYear' &&
                    isLeapYear(mom.year()) &&
                    mom.month() === 1 &&
                    mom.date() === 29
                ) {
                    value = toInt(value);
                    mom._d['set' + (mom._isUTC ? 'UTC' : '') + unit](
                        value,
                        mom.month(),
                        daysInMonth(value, mom.month())
                    );
                } else {
                    mom._d['set' + (mom._isUTC ? 'UTC' : '') + unit](value);
                }
            }
        }

        // MOMENTS

        function stringGet(units) {
            units = normalizeUnits(units);
            if (isFunction(this[units])) {
                return this[units]();
            }
            return this;
        }

        function stringSet(units, value) {
            if (typeof units === 'object') {
                units = normalizeObjectUnits(units);
                var prioritized = getPrioritizedUnits(units),
                    i;
                for (i = 0; i < prioritized.length; i++) {
                    this[prioritized[i].unit](units[prioritized[i].unit]);
                }
            } else {
                units = normalizeUnits(units);
                if (isFunction(this[units])) {
                    return this[units](value);
                }
            }
            return this;
        }

        var match1 = /\d/, //       0 - 9
            match2 = /\d\d/, //      00 - 99
            match3 = /\d{3}/, //     000 - 999
            match4 = /\d{4}/, //    0000 - 9999
            match6 = /[+-]?\d{6}/, // -999999 - 999999
            match1to2 = /\d\d?/, //       0 - 99
            match3to4 = /\d\d\d\d?/, //     999 - 9999
            match5to6 = /\d\d\d\d\d\d?/, //   99999 - 999999
            match1to3 = /\d{1,3}/, //       0 - 999
            match1to4 = /\d{1,4}/, //       0 - 9999
            match1to6 = /[+-]?\d{1,6}/, // -999999 - 999999
            matchUnsigned = /\d+/, //       0 - inf
            matchSigned = /[+-]?\d+/, //    -inf - inf
            matchOffset = /Z|[+-]\d\d:?\d\d/gi, // +00:00 -00:00 +0000 -0000 or Z
            matchShortOffset = /Z|[+-]\d\d(?::?\d\d)?/gi, // +00 -00 +00:00 -00:00 +0000 -0000 or Z
            matchTimestamp = /[+-]?\d+(\.\d{1,3})?/, // 123456789 123456789.123
            // any word (or two) characters or numbers including two/three word month in arabic.
            // includes scottish gaelic two word and hyphenated months
            matchWord = /[0-9]{0,256}['a-z\u00A0-\u05FF\u0700-\uD7FF\uF900-\uFDCF\uFDF0-\uFF07\uFF10-\uFFEF]{1,256}|[\u0600-\u06FF\/]{1,256}(\s*?[\u0600-\u06FF]{1,256}){1,2}/i,
            regexes;

        regexes = {};

        function addRegexToken(token, regex, strictRegex) {
            regexes[token] = isFunction(regex)
                ? regex
                : function (isStrict, localeData) {
                      return isStrict && strictRegex ? strictRegex : regex;
                  };
        }

        function getParseRegexForToken(token, config) {
            if (!hasOwnProp(regexes, token)) {
                return new RegExp(unescapeFormat(token));
            }

            return regexes[token](config._strict, config._locale);
        }

        // Code from http://stackoverflow.com/questions/3561493/is-there-a-regexp-escape-function-in-javascript
        function unescapeFormat(s) {
            return regexEscape(
                s
                    .replace('\\', '')
                    .replace(/\\(\[)|\\(\])|\[([^\]\[]*)\]|\\(.)/g, function (
                        matched,
                        p1,
                        p2,
                        p3,
                        p4
                    ) {
                        return p1 || p2 || p3 || p4;
                    })
            );
        }

        function regexEscape(s) {
            return s.replace(/[-\/\\^$*+?.()|[\]{}]/g, '\\$&');
        }

        var tokens = {};

        function addParseToken(token, callback) {
            var i,
                func = callback;
            if (typeof token === 'string') {
                token = [token];
            }
            if (isNumber(callback)) {
                func = function (input, array) {
                    array[callback] = toInt(input);
                };
            }
            for (i = 0; i < token.length; i++) {
                tokens[token[i]] = func;
            }
        }

        function addWeekParseToken(token, callback) {
            addParseToken(token, function (input, array, config, token) {
                config._w = config._w || {};
                callback(input, config._w, config, token);
            });
        }

        function addTimeToArrayFromToken(token, input, config) {
            if (input != null && hasOwnProp(tokens, token)) {
                tokens[token](input, config._a, config, token);
            }
        }

        var YEAR = 0,
            MONTH = 1,
            DATE = 2,
            HOUR = 3,
            MINUTE = 4,
            SECOND = 5,
            MILLISECOND = 6,
            WEEK = 7,
            WEEKDAY = 8;

        function mod(n, x) {
            return ((n % x) + x) % x;
        }

        var indexOf;

        if (Array.prototype.indexOf) {
            indexOf = Array.prototype.indexOf;
        } else {
            indexOf = function (o) {
                // I know
                var i;
                for (i = 0; i < this.length; ++i) {
                    if (this[i] === o) {
                        return i;
                    }
                }
                return -1;
            };
        }

        function daysInMonth(year, month) {
            if (isNaN(year) || isNaN(month)) {
                return NaN;
            }
            var modMonth = mod(month, 12);
            year += (month - modMonth) / 12;
            return modMonth === 1
                ? isLeapYear(year)
                    ? 29
                    : 28
                : 31 - ((modMonth % 7) % 2);
        }

        // FORMATTING

        addFormatToken('M', ['MM', 2], 'Mo', function () {
            return this.month() + 1;
        });

        addFormatToken('MMM', 0, 0, function (format) {
            return this.localeData().monthsShort(this, format);
        });

        addFormatToken('MMMM', 0, 0, function (format) {
            return this.localeData().months(this, format);
        });

        // ALIASES

        addUnitAlias('month', 'M');

        // PRIORITY

        addUnitPriority('month', 8);

        // PARSING

        addRegexToken('M', match1to2);
        addRegexToken('MM', match1to2, match2);
        addRegexToken('MMM', function (isStrict, locale) {
            return locale.monthsShortRegex(isStrict);
        });
        addRegexToken('MMMM', function (isStrict, locale) {
            return locale.monthsRegex(isStrict);
        });

        addParseToken(['M', 'MM'], function (input, array) {
            array[MONTH] = toInt(input) - 1;
        });

        addParseToken(['MMM', 'MMMM'], function (input, array, config, token) {
            var month = config._locale.monthsParse(input, token, config._strict);
            // if we didn't find a month name, mark the date as invalid.
            if (month != null) {
                array[MONTH] = month;
            } else {
                getParsingFlags(config).invalidMonth = input;
            }
        });

        // LOCALES

        var defaultLocaleMonths = 'January_February_March_April_May_June_July_August_September_October_November_December'.split(
                '_'
            ),
            defaultLocaleMonthsShort = 'Jan_Feb_Mar_Apr_May_Jun_Jul_Aug_Sep_Oct_Nov_Dec'.split(
                '_'
            ),
            MONTHS_IN_FORMAT = /D[oD]?(\[[^\[\]]*\]|\s)+MMMM?/,
            defaultMonthsShortRegex = matchWord,
            defaultMonthsRegex = matchWord;

        function localeMonths(m, format) {
            if (!m) {
                return isArray(this._months)
                    ? this._months
                    : this._months['standalone'];
            }
            return isArray(this._months)
                ? this._months[m.month()]
                : this._months[
                      (this._months.isFormat || MONTHS_IN_FORMAT).test(format)
                          ? 'format'
                          : 'standalone'
                  ][m.month()];
        }

        function localeMonthsShort(m, format) {
            if (!m) {
                return isArray(this._monthsShort)
                    ? this._monthsShort
                    : this._monthsShort['standalone'];
            }
            return isArray(this._monthsShort)
                ? this._monthsShort[m.month()]
                : this._monthsShort[
                      MONTHS_IN_FORMAT.test(format) ? 'format' : 'standalone'
                  ][m.month()];
        }

        function handleStrictParse(monthName, format, strict) {
            var i,
                ii,
                mom,
                llc = monthName.toLocaleLowerCase();
            if (!this._monthsParse) {
                // this is not used
                this._monthsParse = [];
                this._longMonthsParse = [];
                this._shortMonthsParse = [];
                for (i = 0; i < 12; ++i) {
                    mom = createUTC([2000, i]);
                    this._shortMonthsParse[i] = this.monthsShort(
                        mom,
                        ''
                    ).toLocaleLowerCase();
                    this._longMonthsParse[i] = this.months(mom, '').toLocaleLowerCase();
                }
            }

            if (strict) {
                if (format === 'MMM') {
                    ii = indexOf.call(this._shortMonthsParse, llc);
                    return ii !== -1 ? ii : null;
                } else {
                    ii = indexOf.call(this._longMonthsParse, llc);
                    return ii !== -1 ? ii : null;
                }
            } else {
                if (format === 'MMM') {
                    ii = indexOf.call(this._shortMonthsParse, llc);
                    if (ii !== -1) {
                        return ii;
                    }
                    ii = indexOf.call(this._longMonthsParse, llc);
                    return ii !== -1 ? ii : null;
                } else {
                    ii = indexOf.call(this._longMonthsParse, llc);
                    if (ii !== -1) {
                        return ii;
                    }
                    ii = indexOf.call(this._shortMonthsParse, llc);
                    return ii !== -1 ? ii : null;
                }
            }
        }

        function localeMonthsParse(monthName, format, strict) {
            var i, mom, regex;

            if (this._monthsParseExact) {
                return handleStrictParse.call(this, monthName, format, strict);
            }

            if (!this._monthsParse) {
                this._monthsParse = [];
                this._longMonthsParse = [];
                this._shortMonthsParse = [];
            }

            // TODO: add sorting
            // Sorting makes sure if one month (or abbr) is a prefix of another
            // see sorting in computeMonthsParse
            for (i = 0; i < 12; i++) {
                // make the regex if we don't have it already
                mom = createUTC([2000, i]);
                if (strict && !this._longMonthsParse[i]) {
                    this._longMonthsParse[i] = new RegExp(
                        '^' + this.months(mom, '').replace('.', '') + '$',
                        'i'
                    );
                    this._shortMonthsParse[i] = new RegExp(
                        '^' + this.monthsShort(mom, '').replace('.', '') + '$',
                        'i'
                    );
                }
                if (!strict && !this._monthsParse[i]) {
                    regex =
                        '^' + this.months(mom, '') + '|^' + this.monthsShort(mom, '');
                    this._monthsParse[i] = new RegExp(regex.replace('.', ''), 'i');
                }
                // test the regex
                if (
                    strict &&
                    format === 'MMMM' &&
                    this._longMonthsParse[i].test(monthName)
                ) {
                    return i;
                } else if (
                    strict &&
                    format === 'MMM' &&
                    this._shortMonthsParse[i].test(monthName)
                ) {
                    return i;
                } else if (!strict && this._monthsParse[i].test(monthName)) {
                    return i;
                }
            }
        }

        // MOMENTS

        function setMonth(mom, value) {
            var dayOfMonth;

            if (!mom.isValid()) {
                // No op
                return mom;
            }

            if (typeof value === 'string') {
                if (/^\d+$/.test(value)) {
                    value = toInt(value);
                } else {
                    value = mom.localeData().monthsParse(value);
                    // TODO: Another silent failure?
                    if (!isNumber(value)) {
                        return mom;
                    }
                }
            }

            dayOfMonth = Math.min(mom.date(), daysInMonth(mom.year(), value));
            mom._d['set' + (mom._isUTC ? 'UTC' : '') + 'Month'](value, dayOfMonth);
            return mom;
        }

        function getSetMonth(value) {
            if (value != null) {
                setMonth(this, value);
                hooks.updateOffset(this, true);
                return this;
            } else {
                return get(this, 'Month');
            }
        }

        function getDaysInMonth() {
            return daysInMonth(this.year(), this.month());
        }

        function monthsShortRegex(isStrict) {
            if (this._monthsParseExact) {
                if (!hasOwnProp(this, '_monthsRegex')) {
                    computeMonthsParse.call(this);
                }
                if (isStrict) {
                    return this._monthsShortStrictRegex;
                } else {
                    return this._monthsShortRegex;
                }
            } else {
                if (!hasOwnProp(this, '_monthsShortRegex')) {
                    this._monthsShortRegex = defaultMonthsShortRegex;
                }
                return this._monthsShortStrictRegex && isStrict
                    ? this._monthsShortStrictRegex
                    : this._monthsShortRegex;
            }
        }

        function monthsRegex(isStrict) {
            if (this._monthsParseExact) {
                if (!hasOwnProp(this, '_monthsRegex')) {
                    computeMonthsParse.call(this);
                }
                if (isStrict) {
                    return this._monthsStrictRegex;
                } else {
                    return this._monthsRegex;
                }
            } else {
                if (!hasOwnProp(this, '_monthsRegex')) {
                    this._monthsRegex = defaultMonthsRegex;
                }
                return this._monthsStrictRegex && isStrict
                    ? this._monthsStrictRegex
                    : this._monthsRegex;
            }
        }

        function computeMonthsParse() {
            function cmpLenRev(a, b) {
                return b.length - a.length;
            }

            var shortPieces = [],
                longPieces = [],
                mixedPieces = [],
                i,
                mom;
            for (i = 0; i < 12; i++) {
                // make the regex if we don't have it already
                mom = createUTC([2000, i]);
                shortPieces.push(this.monthsShort(mom, ''));
                longPieces.push(this.months(mom, ''));
                mixedPieces.push(this.months(mom, ''));
                mixedPieces.push(this.monthsShort(mom, ''));
            }
            // Sorting makes sure if one month (or abbr) is a prefix of another it
            // will match the longer piece.
            shortPieces.sort(cmpLenRev);
            longPieces.sort(cmpLenRev);
            mixedPieces.sort(cmpLenRev);
            for (i = 0; i < 12; i++) {
                shortPieces[i] = regexEscape(shortPieces[i]);
                longPieces[i] = regexEscape(longPieces[i]);
            }
            for (i = 0; i < 24; i++) {
                mixedPieces[i] = regexEscape(mixedPieces[i]);
            }

            this._monthsRegex = new RegExp('^(' + mixedPieces.join('|') + ')', 'i');
            this._monthsShortRegex = this._monthsRegex;
            this._monthsStrictRegex = new RegExp(
                '^(' + longPieces.join('|') + ')',
                'i'
            );
            this._monthsShortStrictRegex = new RegExp(
                '^(' + shortPieces.join('|') + ')',
                'i'
            );
        }

        // FORMATTING

        addFormatToken('Y', 0, 0, function () {
            var y = this.year();
            return y <= 9999 ? zeroFill(y, 4) : '+' + y;
        });

        addFormatToken(0, ['YY', 2], 0, function () {
            return this.year() % 100;
        });

        addFormatToken(0, ['YYYY', 4], 0, 'year');
        addFormatToken(0, ['YYYYY', 5], 0, 'year');
        addFormatToken(0, ['YYYYYY', 6, true], 0, 'year');

        // ALIASES

        addUnitAlias('year', 'y');

        // PRIORITIES

        addUnitPriority('year', 1);

        // PARSING

        addRegexToken('Y', matchSigned);
        addRegexToken('YY', match1to2, match2);
        addRegexToken('YYYY', match1to4, match4);
        addRegexToken('YYYYY', match1to6, match6);
        addRegexToken('YYYYYY', match1to6, match6);

        addParseToken(['YYYYY', 'YYYYYY'], YEAR);
        addParseToken('YYYY', function (input, array) {
            array[YEAR] =
                input.length === 2 ? hooks.parseTwoDigitYear(input) : toInt(input);
        });
        addParseToken('YY', function (input, array) {
            array[YEAR] = hooks.parseTwoDigitYear(input);
        });
        addParseToken('Y', function (input, array) {
            array[YEAR] = parseInt(input, 10);
        });

        // HELPERS

        function daysInYear(year) {
            return isLeapYear(year) ? 366 : 365;
        }

        // HOOKS

        hooks.parseTwoDigitYear = function (input) {
            return toInt(input) + (toInt(input) > 68 ? 1900 : 2000);
        };

        // MOMENTS

        var getSetYear = makeGetSet('FullYear', true);

        function getIsLeapYear() {
            return isLeapYear(this.year());
        }

        function createDate(y, m, d, h, M, s, ms) {
            // can't just apply() to create a date:
            // https://stackoverflow.com/q/181348
            var date;
            // the date constructor remaps years 0-99 to 1900-1999
            if (y < 100 && y >= 0) {
                // preserve leap years using a full 400 year cycle, then reset
                date = new Date(y + 400, m, d, h, M, s, ms);
                if (isFinite(date.getFullYear())) {
                    date.setFullYear(y);
                }
            } else {
                date = new Date(y, m, d, h, M, s, ms);
            }

            return date;
        }

        function createUTCDate(y) {
            var date, args;
            // the Date.UTC function remaps years 0-99 to 1900-1999
            if (y < 100 && y >= 0) {
                args = Array.prototype.slice.call(arguments);
                // preserve leap years using a full 400 year cycle, then reset
                args[0] = y + 400;
                date = new Date(Date.UTC.apply(null, args));
                if (isFinite(date.getUTCFullYear())) {
                    date.setUTCFullYear(y);
                }
            } else {
                date = new Date(Date.UTC.apply(null, arguments));
            }

            return date;
        }

        // start-of-first-week - start-of-year
        function firstWeekOffset(year, dow, doy) {
            var // first-week day -- which january is always in the first week (4 for iso, 1 for other)
                fwd = 7 + dow - doy,
                // first-week day local weekday -- which local weekday is fwd
                fwdlw = (7 + createUTCDate(year, 0, fwd).getUTCDay() - dow) % 7;

            return -fwdlw + fwd - 1;
        }

        // https://en.wikipedia.org/wiki/ISO_week_date#Calculating_a_date_given_the_year.2C_week_number_and_weekday
        function dayOfYearFromWeeks(year, week, weekday, dow, doy) {
            var localWeekday = (7 + weekday - dow) % 7,
                weekOffset = firstWeekOffset(year, dow, doy),
                dayOfYear = 1 + 7 * (week - 1) + localWeekday + weekOffset,
                resYear,
                resDayOfYear;

            if (dayOfYear <= 0) {
                resYear = year - 1;
                resDayOfYear = daysInYear(resYear) + dayOfYear;
            } else if (dayOfYear > daysInYear(year)) {
                resYear = year + 1;
                resDayOfYear = dayOfYear - daysInYear(year);
            } else {
                resYear = year;
                resDayOfYear = dayOfYear;
            }

            return {
                year: resYear,
                dayOfYear: resDayOfYear,
            };
        }

        function weekOfYear(mom, dow, doy) {
            var weekOffset = firstWeekOffset(mom.year(), dow, doy),
                week = Math.floor((mom.dayOfYear() - weekOffset - 1) / 7) + 1,
                resWeek,
                resYear;

            if (week < 1) {
                resYear = mom.year() - 1;
                resWeek = week + weeksInYear(resYear, dow, doy);
            } else if (week > weeksInYear(mom.year(), dow, doy)) {
                resWeek = week - weeksInYear(mom.year(), dow, doy);
                resYear = mom.year() + 1;
            } else {
                resYear = mom.year();
                resWeek = week;
            }

            return {
                week: resWeek,
                year: resYear,
            };
        }

        function weeksInYear(year, dow, doy) {
            var weekOffset = firstWeekOffset(year, dow, doy),
                weekOffsetNext = firstWeekOffset(year + 1, dow, doy);
            return (daysInYear(year) - weekOffset + weekOffsetNext) / 7;
        }

        // FORMATTING

        addFormatToken('w', ['ww', 2], 'wo', 'week');
        addFormatToken('W', ['WW', 2], 'Wo', 'isoWeek');

        // ALIASES

        addUnitAlias('week', 'w');
        addUnitAlias('isoWeek', 'W');

        // PRIORITIES

        addUnitPriority('week', 5);
        addUnitPriority('isoWeek', 5);

        // PARSING

        addRegexToken('w', match1to2);
        addRegexToken('ww', match1to2, match2);
        addRegexToken('W', match1to2);
        addRegexToken('WW', match1to2, match2);

        addWeekParseToken(['w', 'ww', 'W', 'WW'], function (
            input,
            week,
            config,
            token
        ) {
            week[token.substr(0, 1)] = toInt(input);
        });

        // HELPERS

        // LOCALES

        function localeWeek(mom) {
            return weekOfYear(mom, this._week.dow, this._week.doy).week;
        }

        var defaultLocaleWeek = {
            dow: 0, // Sunday is the first day of the week.
            doy: 6, // The week that contains Jan 6th is the first week of the year.
        };

        function localeFirstDayOfWeek() {
            return this._week.dow;
        }

        function localeFirstDayOfYear() {
            return this._week.doy;
        }

        // MOMENTS

        function getSetWeek(input) {
            var week = this.localeData().week(this);
            return input == null ? week : this.add((input - week) * 7, 'd');
        }

        function getSetISOWeek(input) {
            var week = weekOfYear(this, 1, 4).week;
            return input == null ? week : this.add((input - week) * 7, 'd');
        }

        // FORMATTING

        addFormatToken('d', 0, 'do', 'day');

        addFormatToken('dd', 0, 0, function (format) {
            return this.localeData().weekdaysMin(this, format);
        });

        addFormatToken('ddd', 0, 0, function (format) {
            return this.localeData().weekdaysShort(this, format);
        });

        addFormatToken('dddd', 0, 0, function (format) {
            return this.localeData().weekdays(this, format);
        });

        addFormatToken('e', 0, 0, 'weekday');
        addFormatToken('E', 0, 0, 'isoWeekday');

        // ALIASES

        addUnitAlias('day', 'd');
        addUnitAlias('weekday', 'e');
        addUnitAlias('isoWeekday', 'E');

        // PRIORITY
        addUnitPriority('day', 11);
        addUnitPriority('weekday', 11);
        addUnitPriority('isoWeekday', 11);

        // PARSING

        addRegexToken('d', match1to2);
        addRegexToken('e', match1to2);
        addRegexToken('E', match1to2);
        addRegexToken('dd', function (isStrict, locale) {
            return locale.weekdaysMinRegex(isStrict);
        });
        addRegexToken('ddd', function (isStrict, locale) {
            return locale.weekdaysShortRegex(isStrict);
        });
        addRegexToken('dddd', function (isStrict, locale) {
            return locale.weekdaysRegex(isStrict);
        });

        addWeekParseToken(['dd', 'ddd', 'dddd'], function (input, week, config, token) {
            var weekday = config._locale.weekdaysParse(input, token, config._strict);
            // if we didn't get a weekday name, mark the date as invalid
            if (weekday != null) {
                week.d = weekday;
            } else {
                getParsingFlags(config).invalidWeekday = input;
            }
        });

        addWeekParseToken(['d', 'e', 'E'], function (input, week, config, token) {
            week[token] = toInt(input);
        });

        // HELPERS

        function parseWeekday(input, locale) {
            if (typeof input !== 'string') {
                return input;
            }

            if (!isNaN(input)) {
                return parseInt(input, 10);
            }

            input = locale.weekdaysParse(input);
            if (typeof input === 'number') {
                return input;
            }

            return null;
        }

        function parseIsoWeekday(input, locale) {
            if (typeof input === 'string') {
                return locale.weekdaysParse(input) % 7 || 7;
            }
            return isNaN(input) ? null : input;
        }

        // LOCALES
        function shiftWeekdays(ws, n) {
            return ws.slice(n, 7).concat(ws.slice(0, n));
        }

        var defaultLocaleWeekdays = 'Sunday_Monday_Tuesday_Wednesday_Thursday_Friday_Saturday'.split(
                '_'
            ),
            defaultLocaleWeekdaysShort = 'Sun_Mon_Tue_Wed_Thu_Fri_Sat'.split('_'),
            defaultLocaleWeekdaysMin = 'Su_Mo_Tu_We_Th_Fr_Sa'.split('_'),
            defaultWeekdaysRegex = matchWord,
            defaultWeekdaysShortRegex = matchWord,
            defaultWeekdaysMinRegex = matchWord;

        function localeWeekdays(m, format) {
            var weekdays = isArray(this._weekdays)
                ? this._weekdays
                : this._weekdays[
                      m && m !== true && this._weekdays.isFormat.test(format)
                          ? 'format'
                          : 'standalone'
                  ];
            return m === true
                ? shiftWeekdays(weekdays, this._week.dow)
                : m
                ? weekdays[m.day()]
                : weekdays;
        }

        function localeWeekdaysShort(m) {
            return m === true
                ? shiftWeekdays(this._weekdaysShort, this._week.dow)
                : m
                ? this._weekdaysShort[m.day()]
                : this._weekdaysShort;
        }

        function localeWeekdaysMin(m) {
            return m === true
                ? shiftWeekdays(this._weekdaysMin, this._week.dow)
                : m
                ? this._weekdaysMin[m.day()]
                : this._weekdaysMin;
        }

        function handleStrictParse$1(weekdayName, format, strict) {
            var i,
                ii,
                mom,
                llc = weekdayName.toLocaleLowerCase();
            if (!this._weekdaysParse) {
                this._weekdaysParse = [];
                this._shortWeekdaysParse = [];
                this._minWeekdaysParse = [];

                for (i = 0; i < 7; ++i) {
                    mom = createUTC([2000, 1]).day(i);
                    this._minWeekdaysParse[i] = this.weekdaysMin(
                        mom,
                        ''
                    ).toLocaleLowerCase();
                    this._shortWeekdaysParse[i] = this.weekdaysShort(
                        mom,
                        ''
                    ).toLocaleLowerCase();
                    this._weekdaysParse[i] = this.weekdays(mom, '').toLocaleLowerCase();
                }
            }

            if (strict) {
                if (format === 'dddd') {
                    ii = indexOf.call(this._weekdaysParse, llc);
                    return ii !== -1 ? ii : null;
                } else if (format === 'ddd') {
                    ii = indexOf.call(this._shortWeekdaysParse, llc);
                    return ii !== -1 ? ii : null;
                } else {
                    ii = indexOf.call(this._minWeekdaysParse, llc);
                    return ii !== -1 ? ii : null;
                }
            } else {
                if (format === 'dddd') {
                    ii = indexOf.call(this._weekdaysParse, llc);
                    if (ii !== -1) {
                        return ii;
                    }
                    ii = indexOf.call(this._shortWeekdaysParse, llc);
                    if (ii !== -1) {
                        return ii;
                    }
                    ii = indexOf.call(this._minWeekdaysParse, llc);
                    return ii !== -1 ? ii : null;
                } else if (format === 'ddd') {
                    ii = indexOf.call(this._shortWeekdaysParse, llc);
                    if (ii !== -1) {
                        return ii;
                    }
                    ii = indexOf.call(this._weekdaysParse, llc);
                    if (ii !== -1) {
                        return ii;
                    }
                    ii = indexOf.call(this._minWeekdaysParse, llc);
                    return ii !== -1 ? ii : null;
                } else {
                    ii = indexOf.call(this._minWeekdaysParse, llc);
                    if (ii !== -1) {
                        return ii;
                    }
                    ii = indexOf.call(this._weekdaysParse, llc);
                    if (ii !== -1) {
                        return ii;
                    }
                    ii = indexOf.call(this._shortWeekdaysParse, llc);
                    return ii !== -1 ? ii : null;
                }
            }
        }

        function localeWeekdaysParse(weekdayName, format, strict) {
            var i, mom, regex;

            if (this._weekdaysParseExact) {
                return handleStrictParse$1.call(this, weekdayName, format, strict);
            }

            if (!this._weekdaysParse) {
                this._weekdaysParse = [];
                this._minWeekdaysParse = [];
                this._shortWeekdaysParse = [];
                this._fullWeekdaysParse = [];
            }

            for (i = 0; i < 7; i++) {
                // make the regex if we don't have it already

                mom = createUTC([2000, 1]).day(i);
                if (strict && !this._fullWeekdaysParse[i]) {
                    this._fullWeekdaysParse[i] = new RegExp(
                        '^' + this.weekdays(mom, '').replace('.', '\\.?') + '$',
                        'i'
                    );
                    this._shortWeekdaysParse[i] = new RegExp(
                        '^' + this.weekdaysShort(mom, '').replace('.', '\\.?') + '$',
                        'i'
                    );
                    this._minWeekdaysParse[i] = new RegExp(
                        '^' + this.weekdaysMin(mom, '').replace('.', '\\.?') + '$',
                        'i'
                    );
                }
                if (!this._weekdaysParse[i]) {
                    regex =
                        '^' +
                        this.weekdays(mom, '') +
                        '|^' +
                        this.weekdaysShort(mom, '') +
                        '|^' +
                        this.weekdaysMin(mom, '');
                    this._weekdaysParse[i] = new RegExp(regex.replace('.', ''), 'i');
                }
                // test the regex
                if (
                    strict &&
                    format === 'dddd' &&
                    this._fullWeekdaysParse[i].test(weekdayName)
                ) {
                    return i;
                } else if (
                    strict &&
                    format === 'ddd' &&
                    this._shortWeekdaysParse[i].test(weekdayName)
                ) {
                    return i;
                } else if (
                    strict &&
                    format === 'dd' &&
                    this._minWeekdaysParse[i].test(weekdayName)
                ) {
                    return i;
                } else if (!strict && this._weekdaysParse[i].test(weekdayName)) {
                    return i;
                }
            }
        }

        // MOMENTS

        function getSetDayOfWeek(input) {
            if (!this.isValid()) {
                return input != null ? this : NaN;
            }
            var day = this._isUTC ? this._d.getUTCDay() : this._d.getDay();
            if (input != null) {
                input = parseWeekday(input, this.localeData());
                return this.add(input - day, 'd');
            } else {
                return day;
            }
        }

        function getSetLocaleDayOfWeek(input) {
            if (!this.isValid()) {
                return input != null ? this : NaN;
            }
            var weekday = (this.day() + 7 - this.localeData()._week.dow) % 7;
            return input == null ? weekday : this.add(input - weekday, 'd');
        }

        function getSetISODayOfWeek(input) {
            if (!this.isValid()) {
                return input != null ? this : NaN;
            }

            // behaves the same as moment#day except
            // as a getter, returns 7 instead of 0 (1-7 range instead of 0-6)
            // as a setter, sunday should belong to the previous week.

            if (input != null) {
                var weekday = parseIsoWeekday(input, this.localeData());
                return this.day(this.day() % 7 ? weekday : weekday - 7);
            } else {
                return this.day() || 7;
            }
        }

        function weekdaysRegex(isStrict) {
            if (this._weekdaysParseExact) {
                if (!hasOwnProp(this, '_weekdaysRegex')) {
                    computeWeekdaysParse.call(this);
                }
                if (isStrict) {
                    return this._weekdaysStrictRegex;
                } else {
                    return this._weekdaysRegex;
                }
            } else {
                if (!hasOwnProp(this, '_weekdaysRegex')) {
                    this._weekdaysRegex = defaultWeekdaysRegex;
                }
                return this._weekdaysStrictRegex && isStrict
                    ? this._weekdaysStrictRegex
                    : this._weekdaysRegex;
            }
        }

        function weekdaysShortRegex(isStrict) {
            if (this._weekdaysParseExact) {
                if (!hasOwnProp(this, '_weekdaysRegex')) {
                    computeWeekdaysParse.call(this);
                }
                if (isStrict) {
                    return this._weekdaysShortStrictRegex;
                } else {
                    return this._weekdaysShortRegex;
                }
            } else {
                if (!hasOwnProp(this, '_weekdaysShortRegex')) {
                    this._weekdaysShortRegex = defaultWeekdaysShortRegex;
                }
                return this._weekdaysShortStrictRegex && isStrict
                    ? this._weekdaysShortStrictRegex
                    : this._weekdaysShortRegex;
            }
        }

        function weekdaysMinRegex(isStrict) {
            if (this._weekdaysParseExact) {
                if (!hasOwnProp(this, '_weekdaysRegex')) {
                    computeWeekdaysParse.call(this);
                }
                if (isStrict) {
                    return this._weekdaysMinStrictRegex;
                } else {
                    return this._weekdaysMinRegex;
                }
            } else {
                if (!hasOwnProp(this, '_weekdaysMinRegex')) {
                    this._weekdaysMinRegex = defaultWeekdaysMinRegex;
                }
                return this._weekdaysMinStrictRegex && isStrict
                    ? this._weekdaysMinStrictRegex
                    : this._weekdaysMinRegex;
            }
        }

        function computeWeekdaysParse() {
            function cmpLenRev(a, b) {
                return b.length - a.length;
            }

            var minPieces = [],
                shortPieces = [],
                longPieces = [],
                mixedPieces = [],
                i,
                mom,
                minp,
                shortp,
                longp;
            for (i = 0; i < 7; i++) {
                // make the regex if we don't have it already
                mom = createUTC([2000, 1]).day(i);
                minp = regexEscape(this.weekdaysMin(mom, ''));
                shortp = regexEscape(this.weekdaysShort(mom, ''));
                longp = regexEscape(this.weekdays(mom, ''));
                minPieces.push(minp);
                shortPieces.push(shortp);
                longPieces.push(longp);
                mixedPieces.push(minp);
                mixedPieces.push(shortp);
                mixedPieces.push(longp);
            }
            // Sorting makes sure if one weekday (or abbr) is a prefix of another it
            // will match the longer piece.
            minPieces.sort(cmpLenRev);
            shortPieces.sort(cmpLenRev);
            longPieces.sort(cmpLenRev);
            mixedPieces.sort(cmpLenRev);

            this._weekdaysRegex = new RegExp('^(' + mixedPieces.join('|') + ')', 'i');
            this._weekdaysShortRegex = this._weekdaysRegex;
            this._weekdaysMinRegex = this._weekdaysRegex;

            this._weekdaysStrictRegex = new RegExp(
                '^(' + longPieces.join('|') + ')',
                'i'
            );
            this._weekdaysShortStrictRegex = new RegExp(
                '^(' + shortPieces.join('|') + ')',
                'i'
            );
            this._weekdaysMinStrictRegex = new RegExp(
                '^(' + minPieces.join('|') + ')',
                'i'
            );
        }

        // FORMATTING

        function hFormat() {
            return this.hours() % 12 || 12;
        }

        function kFormat() {
            return this.hours() || 24;
        }

        addFormatToken('H', ['HH', 2], 0, 'hour');
        addFormatToken('h', ['hh', 2], 0, hFormat);
        addFormatToken('k', ['kk', 2], 0, kFormat);

        addFormatToken('hmm', 0, 0, function () {
            return '' + hFormat.apply(this) + zeroFill(this.minutes(), 2);
        });

        addFormatToken('hmmss', 0, 0, function () {
            return (
                '' +
                hFormat.apply(this) +
                zeroFill(this.minutes(), 2) +
                zeroFill(this.seconds(), 2)
            );
        });

        addFormatToken('Hmm', 0, 0, function () {
            return '' + this.hours() + zeroFill(this.minutes(), 2);
        });

        addFormatToken('Hmmss', 0, 0, function () {
            return (
                '' +
                this.hours() +
                zeroFill(this.minutes(), 2) +
                zeroFill(this.seconds(), 2)
            );
        });

        function meridiem(token, lowercase) {
            addFormatToken(token, 0, 0, function () {
                return this.localeData().meridiem(
                    this.hours(),
                    this.minutes(),
                    lowercase
                );
            });
        }

        meridiem('a', true);
        meridiem('A', false);

        // ALIASES

        addUnitAlias('hour', 'h');

        // PRIORITY
        addUnitPriority('hour', 13);

        // PARSING

        function matchMeridiem(isStrict, locale) {
            return locale._meridiemParse;
        }

        addRegexToken('a', matchMeridiem);
        addRegexToken('A', matchMeridiem);
        addRegexToken('H', match1to2);
        addRegexToken('h', match1to2);
        addRegexToken('k', match1to2);
        addRegexToken('HH', match1to2, match2);
        addRegexToken('hh', match1to2, match2);
        addRegexToken('kk', match1to2, match2);

        addRegexToken('hmm', match3to4);
        addRegexToken('hmmss', match5to6);
        addRegexToken('Hmm', match3to4);
        addRegexToken('Hmmss', match5to6);

        addParseToken(['H', 'HH'], HOUR);
        addParseToken(['k', 'kk'], function (input, array, config) {
            var kInput = toInt(input);
            array[HOUR] = kInput === 24 ? 0 : kInput;
        });
        addParseToken(['a', 'A'], function (input, array, config) {
            config._isPm = config._locale.isPM(input);
            config._meridiem = input;
        });
        addParseToken(['h', 'hh'], function (input, array, config) {
            array[HOUR] = toInt(input);
            getParsingFlags(config).bigHour = true;
        });
        addParseToken('hmm', function (input, array, config) {
            var pos = input.length - 2;
            array[HOUR] = toInt(input.substr(0, pos));
            array[MINUTE] = toInt(input.substr(pos));
            getParsingFlags(config).bigHour = true;
        });
        addParseToken('hmmss', function (input, array, config) {
            var pos1 = input.length - 4,
                pos2 = input.length - 2;
            array[HOUR] = toInt(input.substr(0, pos1));
            array[MINUTE] = toInt(input.substr(pos1, 2));
            array[SECOND] = toInt(input.substr(pos2));
            getParsingFlags(config).bigHour = true;
        });
        addParseToken('Hmm', function (input, array, config) {
            var pos = input.length - 2;
            array[HOUR] = toInt(input.substr(0, pos));
            array[MINUTE] = toInt(input.substr(pos));
        });
        addParseToken('Hmmss', function (input, array, config) {
            var pos1 = input.length - 4,
                pos2 = input.length - 2;
            array[HOUR] = toInt(input.substr(0, pos1));
            array[MINUTE] = toInt(input.substr(pos1, 2));
            array[SECOND] = toInt(input.substr(pos2));
        });

        // LOCALES

        function localeIsPM(input) {
            // IE8 Quirks Mode & IE7 Standards Mode do not allow accessing strings like arrays
            // Using charAt should be more compatible.
            return (input + '').toLowerCase().charAt(0) === 'p';
        }

        var defaultLocaleMeridiemParse = /[ap]\.?m?\.?/i,
            // Setting the hour should keep the time, because the user explicitly
            // specified which hour they want. So trying to maintain the same hour (in
            // a new timezone) makes sense. Adding/subtracting hours does not follow
            // this rule.
            getSetHour = makeGetSet('Hours', true);

        function localeMeridiem(hours, minutes, isLower) {
            if (hours > 11) {
                return isLower ? 'pm' : 'PM';
            } else {
                return isLower ? 'am' : 'AM';
            }
        }

        var baseConfig = {
            calendar: defaultCalendar,
            longDateFormat: defaultLongDateFormat,
            invalidDate: defaultInvalidDate,
            ordinal: defaultOrdinal,
            dayOfMonthOrdinalParse: defaultDayOfMonthOrdinalParse,
            relativeTime: defaultRelativeTime,

            months: defaultLocaleMonths,
            monthsShort: defaultLocaleMonthsShort,

            week: defaultLocaleWeek,

            weekdays: defaultLocaleWeekdays,
            weekdaysMin: defaultLocaleWeekdaysMin,
            weekdaysShort: defaultLocaleWeekdaysShort,

            meridiemParse: defaultLocaleMeridiemParse,
        };

        // internal storage for locale config files
        var locales = {},
            localeFamilies = {},
            globalLocale;

        function commonPrefix(arr1, arr2) {
            var i,
                minl = Math.min(arr1.length, arr2.length);
            for (i = 0; i < minl; i += 1) {
                if (arr1[i] !== arr2[i]) {
                    return i;
                }
            }
            return minl;
        }

        function normalizeLocale(key) {
            return key ? key.toLowerCase().replace('_', '-') : key;
        }

        // pick the locale from the array
        // try ['en-au', 'en-gb'] as 'en-au', 'en-gb', 'en', as in move through the list trying each
        // substring from most specific to least, but move to the next array item if it's a more specific variant than the current root
        function chooseLocale(names) {
            var i = 0,
                j,
                next,
                locale,
                split;

            while (i < names.length) {
                split = normalizeLocale(names[i]).split('-');
                j = split.length;
                next = normalizeLocale(names[i + 1]);
                next = next ? next.split('-') : null;
                while (j > 0) {
                    locale = loadLocale(split.slice(0, j).join('-'));
                    if (locale) {
                        return locale;
                    }
                    if (
                        next &&
                        next.length >= j &&
                        commonPrefix(split, next) >= j - 1
                    ) {
                        //the next array item is better than a shallower substring of this one
                        break;
                    }
                    j--;
                }
                i++;
            }
            return globalLocale;
        }

        function loadLocale(name) {
            var oldLocale = null,
                aliasedRequire;
            // TODO: Find a better way to register and load all the locales in Node
            if (
                locales[name] === undefined &&
                'object' !== 'undefined' &&
                module &&
                module.exports
            ) {
                try {
                    oldLocale = globalLocale._abbr;
                    aliasedRequire = commonjsRequire;
                    aliasedRequire('./locale/' + name);
                    getSetGlobalLocale(oldLocale);
                } catch (e) {
                    // mark as not found to avoid repeating expensive file require call causing high CPU
                    // when trying to find en-US, en_US, en-us for every format call
                    locales[name] = null; // null means not found
                }
            }
            return locales[name];
        }

        // This function will load locale and then set the global locale.  If
        // no arguments are passed in, it will simply return the current global
        // locale key.
        function getSetGlobalLocale(key, values) {
            var data;
            if (key) {
                if (isUndefined(values)) {
                    data = getLocale(key);
                } else {
                    data = defineLocale(key, values);
                }

                if (data) {
                    // moment.duration._locale = moment._locale = data;
                    globalLocale = data;
                } else {
                    if (typeof console !== 'undefined' && console.warn) {
                        //warn user if arguments are passed but the locale could not be set
                        console.warn(
                            'Locale ' + key + ' not found. Did you forget to load it?'
                        );
                    }
                }
            }

            return globalLocale._abbr;
        }

        function defineLocale(name, config) {
            if (config !== null) {
                var locale,
                    parentConfig = baseConfig;
                config.abbr = name;
                if (locales[name] != null) {
                    deprecateSimple(
                        'defineLocaleOverride',
                        'use moment.updateLocale(localeName, config) to change ' +
                            'an existing locale. moment.defineLocale(localeName, ' +
                            'config) should only be used for creating a new locale ' +
                            'See http://momentjs.com/guides/#/warnings/define-locale/ for more info.'
                    );
                    parentConfig = locales[name]._config;
                } else if (config.parentLocale != null) {
                    if (locales[config.parentLocale] != null) {
                        parentConfig = locales[config.parentLocale]._config;
                    } else {
                        locale = loadLocale(config.parentLocale);
                        if (locale != null) {
                            parentConfig = locale._config;
                        } else {
                            if (!localeFamilies[config.parentLocale]) {
                                localeFamilies[config.parentLocale] = [];
                            }
                            localeFamilies[config.parentLocale].push({
                                name: name,
                                config: config,
                            });
                            return null;
                        }
                    }
                }
                locales[name] = new Locale(mergeConfigs(parentConfig, config));

                if (localeFamilies[name]) {
                    localeFamilies[name].forEach(function (x) {
                        defineLocale(x.name, x.config);
                    });
                }

                // backwards compat for now: also set the locale
                // make sure we set the locale AFTER all child locales have been
                // created, so we won't end up with the child locale set.
                getSetGlobalLocale(name);

                return locales[name];
            } else {
                // useful for testing
                delete locales[name];
                return null;
            }
        }

        function updateLocale(name, config) {
            if (config != null) {
                var locale,
                    tmpLocale,
                    parentConfig = baseConfig;

                if (locales[name] != null && locales[name].parentLocale != null) {
                    // Update existing child locale in-place to avoid memory-leaks
                    locales[name].set(mergeConfigs(locales[name]._config, config));
                } else {
                    // MERGE
                    tmpLocale = loadLocale(name);
                    if (tmpLocale != null) {
                        parentConfig = tmpLocale._config;
                    }
                    config = mergeConfigs(parentConfig, config);
                    if (tmpLocale == null) {
                        // updateLocale is called for creating a new locale
                        // Set abbr so it will have a name (getters return
                        // undefined otherwise).
                        config.abbr = name;
                    }
                    locale = new Locale(config);
                    locale.parentLocale = locales[name];
                    locales[name] = locale;
                }

                // backwards compat for now: also set the locale
                getSetGlobalLocale(name);
            } else {
                // pass null for config to unupdate, useful for tests
                if (locales[name] != null) {
                    if (locales[name].parentLocale != null) {
                        locales[name] = locales[name].parentLocale;
                        if (name === getSetGlobalLocale()) {
                            getSetGlobalLocale(name);
                        }
                    } else if (locales[name] != null) {
                        delete locales[name];
                    }
                }
            }
            return locales[name];
        }

        // returns locale data
        function getLocale(key) {
            var locale;

            if (key && key._locale && key._locale._abbr) {
                key = key._locale._abbr;
            }

            if (!key) {
                return globalLocale;
            }

            if (!isArray(key)) {
                //short-circuit everything else
                locale = loadLocale(key);
                if (locale) {
                    return locale;
                }
                key = [key];
            }

            return chooseLocale(key);
        }

        function listLocales() {
            return keys(locales);
        }

        function checkOverflow(m) {
            var overflow,
                a = m._a;

            if (a && getParsingFlags(m).overflow === -2) {
                overflow =
                    a[MONTH] < 0 || a[MONTH] > 11
                        ? MONTH
                        : a[DATE] < 1 || a[DATE] > daysInMonth(a[YEAR], a[MONTH])
                        ? DATE
                        : a[HOUR] < 0 ||
                          a[HOUR] > 24 ||
                          (a[HOUR] === 24 &&
                              (a[MINUTE] !== 0 ||
                                  a[SECOND] !== 0 ||
                                  a[MILLISECOND] !== 0))
                        ? HOUR
                        : a[MINUTE] < 0 || a[MINUTE] > 59
                        ? MINUTE
                        : a[SECOND] < 0 || a[SECOND] > 59
                        ? SECOND
                        : a[MILLISECOND] < 0 || a[MILLISECOND] > 999
                        ? MILLISECOND
                        : -1;

                if (
                    getParsingFlags(m)._overflowDayOfYear &&
                    (overflow < YEAR || overflow > DATE)
                ) {
                    overflow = DATE;
                }
                if (getParsingFlags(m)._overflowWeeks && overflow === -1) {
                    overflow = WEEK;
                }
                if (getParsingFlags(m)._overflowWeekday && overflow === -1) {
                    overflow = WEEKDAY;
                }

                getParsingFlags(m).overflow = overflow;
            }

            return m;
        }

        // iso 8601 regex
        // 0000-00-00 0000-W00 or 0000-W00-0 + T + 00 or 00:00 or 00:00:00 or 00:00:00.000 + +00:00 or +0000 or +00)
        var extendedIsoRegex = /^\s*((?:[+-]\d{6}|\d{4})-(?:\d\d-\d\d|W\d\d-\d|W\d\d|\d\d\d|\d\d))(?:(T| )(\d\d(?::\d\d(?::\d\d(?:[.,]\d+)?)?)?)([+-]\d\d(?::?\d\d)?|\s*Z)?)?$/,
            basicIsoRegex = /^\s*((?:[+-]\d{6}|\d{4})(?:\d\d\d\d|W\d\d\d|W\d\d|\d\d\d|\d\d|))(?:(T| )(\d\d(?:\d\d(?:\d\d(?:[.,]\d+)?)?)?)([+-]\d\d(?::?\d\d)?|\s*Z)?)?$/,
            tzRegex = /Z|[+-]\d\d(?::?\d\d)?/,
            isoDates = [
                ['YYYYYY-MM-DD', /[+-]\d{6}-\d\d-\d\d/],
                ['YYYY-MM-DD', /\d{4}-\d\d-\d\d/],
                ['GGGG-[W]WW-E', /\d{4}-W\d\d-\d/],
                ['GGGG-[W]WW', /\d{4}-W\d\d/, false],
                ['YYYY-DDD', /\d{4}-\d{3}/],
                ['YYYY-MM', /\d{4}-\d\d/, false],
                ['YYYYYYMMDD', /[+-]\d{10}/],
                ['YYYYMMDD', /\d{8}/],
                ['GGGG[W]WWE', /\d{4}W\d{3}/],
                ['GGGG[W]WW', /\d{4}W\d{2}/, false],
                ['YYYYDDD', /\d{7}/],
                ['YYYYMM', /\d{6}/, false],
                ['YYYY', /\d{4}/, false],
            ],
            // iso time formats and regexes
            isoTimes = [
                ['HH:mm:ss.SSSS', /\d\d:\d\d:\d\d\.\d+/],
                ['HH:mm:ss,SSSS', /\d\d:\d\d:\d\d,\d+/],
                ['HH:mm:ss', /\d\d:\d\d:\d\d/],
                ['HH:mm', /\d\d:\d\d/],
                ['HHmmss.SSSS', /\d\d\d\d\d\d\.\d+/],
                ['HHmmss,SSSS', /\d\d\d\d\d\d,\d+/],
                ['HHmmss', /\d\d\d\d\d\d/],
                ['HHmm', /\d\d\d\d/],
                ['HH', /\d\d/],
            ],
            aspNetJsonRegex = /^\/?Date\((-?\d+)/i,
            // RFC 2822 regex: For details see https://tools.ietf.org/html/rfc2822#section-3.3
            rfc2822 = /^(?:(Mon|Tue|Wed|Thu|Fri|Sat|Sun),?\s)?(\d{1,2})\s(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)\s(\d{2,4})\s(\d\d):(\d\d)(?::(\d\d))?\s(?:(UT|GMT|[ECMP][SD]T)|([Zz])|([+-]\d{4}))$/,
            obsOffsets = {
                UT: 0,
                GMT: 0,
                EDT: -4 * 60,
                EST: -5 * 60,
                CDT: -5 * 60,
                CST: -6 * 60,
                MDT: -6 * 60,
                MST: -7 * 60,
                PDT: -7 * 60,
                PST: -8 * 60,
            };

        // date from iso format
        function configFromISO(config) {
            var i,
                l,
                string = config._i,
                match = extendedIsoRegex.exec(string) || basicIsoRegex.exec(string),
                allowTime,
                dateFormat,
                timeFormat,
                tzFormat;

            if (match) {
                getParsingFlags(config).iso = true;

                for (i = 0, l = isoDates.length; i < l; i++) {
                    if (isoDates[i][1].exec(match[1])) {
                        dateFormat = isoDates[i][0];
                        allowTime = isoDates[i][2] !== false;
                        break;
                    }
                }
                if (dateFormat == null) {
                    config._isValid = false;
                    return;
                }
                if (match[3]) {
                    for (i = 0, l = isoTimes.length; i < l; i++) {
                        if (isoTimes[i][1].exec(match[3])) {
                            // match[2] should be 'T' or space
                            timeFormat = (match[2] || ' ') + isoTimes[i][0];
                            break;
                        }
                    }
                    if (timeFormat == null) {
                        config._isValid = false;
                        return;
                    }
                }
                if (!allowTime && timeFormat != null) {
                    config._isValid = false;
                    return;
                }
                if (match[4]) {
                    if (tzRegex.exec(match[4])) {
                        tzFormat = 'Z';
                    } else {
                        config._isValid = false;
                        return;
                    }
                }
                config._f = dateFormat + (timeFormat || '') + (tzFormat || '');
                configFromStringAndFormat(config);
            } else {
                config._isValid = false;
            }
        }

        function extractFromRFC2822Strings(
            yearStr,
            monthStr,
            dayStr,
            hourStr,
            minuteStr,
            secondStr
        ) {
            var result = [
                untruncateYear(yearStr),
                defaultLocaleMonthsShort.indexOf(monthStr),
                parseInt(dayStr, 10),
                parseInt(hourStr, 10),
                parseInt(minuteStr, 10),
            ];

            if (secondStr) {
                result.push(parseInt(secondStr, 10));
            }

            return result;
        }

        function untruncateYear(yearStr) {
            var year = parseInt(yearStr, 10);
            if (year <= 49) {
                return 2000 + year;
            } else if (year <= 999) {
                return 1900 + year;
            }
            return year;
        }

        function preprocessRFC2822(s) {
            // Remove comments and folding whitespace and replace multiple-spaces with a single space
            return s
                .replace(/\([^)]*\)|[\n\t]/g, ' ')
                .replace(/(\s\s+)/g, ' ')
                .replace(/^\s\s*/, '')
                .replace(/\s\s*$/, '');
        }

        function checkWeekday(weekdayStr, parsedInput, config) {
            if (weekdayStr) {
                // TODO: Replace the vanilla JS Date object with an independent day-of-week check.
                var weekdayProvided = defaultLocaleWeekdaysShort.indexOf(weekdayStr),
                    weekdayActual = new Date(
                        parsedInput[0],
                        parsedInput[1],
                        parsedInput[2]
                    ).getDay();
                if (weekdayProvided !== weekdayActual) {
                    getParsingFlags(config).weekdayMismatch = true;
                    config._isValid = false;
                    return false;
                }
            }
            return true;
        }

        function calculateOffset(obsOffset, militaryOffset, numOffset) {
            if (obsOffset) {
                return obsOffsets[obsOffset];
            } else if (militaryOffset) {
                // the only allowed military tz is Z
                return 0;
            } else {
                var hm = parseInt(numOffset, 10),
                    m = hm % 100,
                    h = (hm - m) / 100;
                return h * 60 + m;
            }
        }

        // date and time from ref 2822 format
        function configFromRFC2822(config) {
            var match = rfc2822.exec(preprocessRFC2822(config._i)),
                parsedArray;
            if (match) {
                parsedArray = extractFromRFC2822Strings(
                    match[4],
                    match[3],
                    match[2],
                    match[5],
                    match[6],
                    match[7]
                );
                if (!checkWeekday(match[1], parsedArray, config)) {
                    return;
                }

                config._a = parsedArray;
                config._tzm = calculateOffset(match[8], match[9], match[10]);

                config._d = createUTCDate.apply(null, config._a);
                config._d.setUTCMinutes(config._d.getUTCMinutes() - config._tzm);

                getParsingFlags(config).rfc2822 = true;
            } else {
                config._isValid = false;
            }
        }

        // date from 1) ASP.NET, 2) ISO, 3) RFC 2822 formats, or 4) optional fallback if parsing isn't strict
        function configFromString(config) {
            var matched = aspNetJsonRegex.exec(config._i);
            if (matched !== null) {
                config._d = new Date(+matched[1]);
                return;
            }

            configFromISO(config);
            if (config._isValid === false) {
                delete config._isValid;
            } else {
                return;
            }

            configFromRFC2822(config);
            if (config._isValid === false) {
                delete config._isValid;
            } else {
                return;
            }

            if (config._strict) {
                config._isValid = false;
            } else {
                // Final attempt, use Input Fallback
                hooks.createFromInputFallback(config);
            }
        }

        hooks.createFromInputFallback = deprecate(
            'value provided is not in a recognized RFC2822 or ISO format. moment construction falls back to js Date(), ' +
                'which is not reliable across all browsers and versions. Non RFC2822/ISO date formats are ' +
                'discouraged. Please refer to http://momentjs.com/guides/#/warnings/js-date/ for more info.',
            function (config) {
                config._d = new Date(config._i + (config._useUTC ? ' UTC' : ''));
            }
        );

        // Pick the first defined of two or three arguments.
        function defaults(a, b, c) {
            if (a != null) {
                return a;
            }
            if (b != null) {
                return b;
            }
            return c;
        }

        function currentDateArray(config) {
            // hooks is actually the exported moment object
            var nowValue = new Date(hooks.now());
            if (config._useUTC) {
                return [
                    nowValue.getUTCFullYear(),
                    nowValue.getUTCMonth(),
                    nowValue.getUTCDate(),
                ];
            }
            return [nowValue.getFullYear(), nowValue.getMonth(), nowValue.getDate()];
        }

        // convert an array to a date.
        // the array should mirror the parameters below
        // note: all values past the year are optional and will default to the lowest possible value.
        // [year, month, day , hour, minute, second, millisecond]
        function configFromArray(config) {
            var i,
                date,
                input = [],
                currentDate,
                expectedWeekday,
                yearToUse;

            if (config._d) {
                return;
            }

            currentDate = currentDateArray(config);

            //compute day of the year from weeks and weekdays
            if (config._w && config._a[DATE] == null && config._a[MONTH] == null) {
                dayOfYearFromWeekInfo(config);
            }

            //if the day of the year is set, figure out what it is
            if (config._dayOfYear != null) {
                yearToUse = defaults(config._a[YEAR], currentDate[YEAR]);

                if (
                    config._dayOfYear > daysInYear(yearToUse) ||
                    config._dayOfYear === 0
                ) {
                    getParsingFlags(config)._overflowDayOfYear = true;
                }

                date = createUTCDate(yearToUse, 0, config._dayOfYear);
                config._a[MONTH] = date.getUTCMonth();
                config._a[DATE] = date.getUTCDate();
            }

            // Default to current date.
            // * if no year, month, day of month are given, default to today
            // * if day of month is given, default month and year
            // * if month is given, default only year
            // * if year is given, don't default anything
            for (i = 0; i < 3 && config._a[i] == null; ++i) {
                config._a[i] = input[i] = currentDate[i];
            }

            // Zero out whatever was not defaulted, including time
            for (; i < 7; i++) {
                config._a[i] = input[i] =
                    config._a[i] == null ? (i === 2 ? 1 : 0) : config._a[i];
            }

            // Check for 24:00:00.000
            if (
                config._a[HOUR] === 24 &&
                config._a[MINUTE] === 0 &&
                config._a[SECOND] === 0 &&
                config._a[MILLISECOND] === 0
            ) {
                config._nextDay = true;
                config._a[HOUR] = 0;
            }

            config._d = (config._useUTC ? createUTCDate : createDate).apply(
                null,
                input
            );
            expectedWeekday = config._useUTC
                ? config._d.getUTCDay()
                : config._d.getDay();

            // Apply timezone offset from input. The actual utcOffset can be changed
            // with parseZone.
            if (config._tzm != null) {
                config._d.setUTCMinutes(config._d.getUTCMinutes() - config._tzm);
            }

            if (config._nextDay) {
                config._a[HOUR] = 24;
            }

            // check for mismatching day of week
            if (
                config._w &&
                typeof config._w.d !== 'undefined' &&
                config._w.d !== expectedWeekday
            ) {
                getParsingFlags(config).weekdayMismatch = true;
            }
        }

        function dayOfYearFromWeekInfo(config) {
            var w, weekYear, week, weekday, dow, doy, temp, weekdayOverflow, curWeek;

            w = config._w;
            if (w.GG != null || w.W != null || w.E != null) {
                dow = 1;
                doy = 4;

                // TODO: We need to take the current isoWeekYear, but that depends on
                // how we interpret now (local, utc, fixed offset). So create
                // a now version of current config (take local/utc/offset flags, and
                // create now).
                weekYear = defaults(
                    w.GG,
                    config._a[YEAR],
                    weekOfYear(createLocal(), 1, 4).year
                );
                week = defaults(w.W, 1);
                weekday = defaults(w.E, 1);
                if (weekday < 1 || weekday > 7) {
                    weekdayOverflow = true;
                }
            } else {
                dow = config._locale._week.dow;
                doy = config._locale._week.doy;

                curWeek = weekOfYear(createLocal(), dow, doy);

                weekYear = defaults(w.gg, config._a[YEAR], curWeek.year);

                // Default to current week.
                week = defaults(w.w, curWeek.week);

                if (w.d != null) {
                    // weekday -- low day numbers are considered next week
                    weekday = w.d;
                    if (weekday < 0 || weekday > 6) {
                        weekdayOverflow = true;
                    }
                } else if (w.e != null) {
                    // local weekday -- counting starts from beginning of week
                    weekday = w.e + dow;
                    if (w.e < 0 || w.e > 6) {
                        weekdayOverflow = true;
                    }
                } else {
                    // default to beginning of week
                    weekday = dow;
                }
            }
            if (week < 1 || week > weeksInYear(weekYear, dow, doy)) {
                getParsingFlags(config)._overflowWeeks = true;
            } else if (weekdayOverflow != null) {
                getParsingFlags(config)._overflowWeekday = true;
            } else {
                temp = dayOfYearFromWeeks(weekYear, week, weekday, dow, doy);
                config._a[YEAR] = temp.year;
                config._dayOfYear = temp.dayOfYear;
            }
        }

        // constant that refers to the ISO standard
        hooks.ISO_8601 = function () {};

        // constant that refers to the RFC 2822 form
        hooks.RFC_2822 = function () {};

        // date from string and format string
        function configFromStringAndFormat(config) {
            // TODO: Move this to another part of the creation flow to prevent circular deps
            if (config._f === hooks.ISO_8601) {
                configFromISO(config);
                return;
            }
            if (config._f === hooks.RFC_2822) {
                configFromRFC2822(config);
                return;
            }
            config._a = [];
            getParsingFlags(config).empty = true;

            // This array is used to make a Date, either with `new Date` or `Date.UTC`
            var string = '' + config._i,
                i,
                parsedInput,
                tokens,
                token,
                skipped,
                stringLength = string.length,
                totalParsedInputLength = 0,
                era;

            tokens =
                expandFormat(config._f, config._locale).match(formattingTokens) || [];

            for (i = 0; i < tokens.length; i++) {
                token = tokens[i];
                parsedInput = (string.match(getParseRegexForToken(token, config)) ||
                    [])[0];
                if (parsedInput) {
                    skipped = string.substr(0, string.indexOf(parsedInput));
                    if (skipped.length > 0) {
                        getParsingFlags(config).unusedInput.push(skipped);
                    }
                    string = string.slice(
                        string.indexOf(parsedInput) + parsedInput.length
                    );
                    totalParsedInputLength += parsedInput.length;
                }
                // don't parse if it's not a known token
                if (formatTokenFunctions[token]) {
                    if (parsedInput) {
                        getParsingFlags(config).empty = false;
                    } else {
                        getParsingFlags(config).unusedTokens.push(token);
                    }
                    addTimeToArrayFromToken(token, parsedInput, config);
                } else if (config._strict && !parsedInput) {
                    getParsingFlags(config).unusedTokens.push(token);
                }
            }

            // add remaining unparsed input length to the string
            getParsingFlags(config).charsLeftOver =
                stringLength - totalParsedInputLength;
            if (string.length > 0) {
                getParsingFlags(config).unusedInput.push(string);
            }

            // clear _12h flag if hour is <= 12
            if (
                config._a[HOUR] <= 12 &&
                getParsingFlags(config).bigHour === true &&
                config._a[HOUR] > 0
            ) {
                getParsingFlags(config).bigHour = undefined;
            }

            getParsingFlags(config).parsedDateParts = config._a.slice(0);
            getParsingFlags(config).meridiem = config._meridiem;
            // handle meridiem
            config._a[HOUR] = meridiemFixWrap(
                config._locale,
                config._a[HOUR],
                config._meridiem
            );

            // handle era
            era = getParsingFlags(config).era;
            if (era !== null) {
                config._a[YEAR] = config._locale.erasConvertYear(era, config._a[YEAR]);
            }

            configFromArray(config);
            checkOverflow(config);
        }

        function meridiemFixWrap(locale, hour, meridiem) {
            var isPm;

            if (meridiem == null) {
                // nothing to do
                return hour;
            }
            if (locale.meridiemHour != null) {
                return locale.meridiemHour(hour, meridiem);
            } else if (locale.isPM != null) {
                // Fallback
                isPm = locale.isPM(meridiem);
                if (isPm && hour < 12) {
                    hour += 12;
                }
                if (!isPm && hour === 12) {
                    hour = 0;
                }
                return hour;
            } else {
                // this is not supposed to happen
                return hour;
            }
        }

        // date from string and array of format strings
        function configFromStringAndArray(config) {
            var tempConfig,
                bestMoment,
                scoreToBeat,
                i,
                currentScore,
                validFormatFound,
                bestFormatIsValid = false;

            if (config._f.length === 0) {
                getParsingFlags(config).invalidFormat = true;
                config._d = new Date(NaN);
                return;
            }

            for (i = 0; i < config._f.length; i++) {
                currentScore = 0;
                validFormatFound = false;
                tempConfig = copyConfig({}, config);
                if (config._useUTC != null) {
                    tempConfig._useUTC = config._useUTC;
                }
                tempConfig._f = config._f[i];
                configFromStringAndFormat(tempConfig);

                if (isValid(tempConfig)) {
                    validFormatFound = true;
                }

                // if there is any input that was not parsed add a penalty for that format
                currentScore += getParsingFlags(tempConfig).charsLeftOver;

                //or tokens
                currentScore += getParsingFlags(tempConfig).unusedTokens.length * 10;

                getParsingFlags(tempConfig).score = currentScore;

                if (!bestFormatIsValid) {
                    if (
                        scoreToBeat == null ||
                        currentScore < scoreToBeat ||
                        validFormatFound
                    ) {
                        scoreToBeat = currentScore;
                        bestMoment = tempConfig;
                        if (validFormatFound) {
                            bestFormatIsValid = true;
                        }
                    }
                } else {
                    if (currentScore < scoreToBeat) {
                        scoreToBeat = currentScore;
                        bestMoment = tempConfig;
                    }
                }
            }

            extend(config, bestMoment || tempConfig);
        }

        function configFromObject(config) {
            if (config._d) {
                return;
            }

            var i = normalizeObjectUnits(config._i),
                dayOrDate = i.day === undefined ? i.date : i.day;
            config._a = map(
                [i.year, i.month, dayOrDate, i.hour, i.minute, i.second, i.millisecond],
                function (obj) {
                    return obj && parseInt(obj, 10);
                }
            );

            configFromArray(config);
        }

        function createFromConfig(config) {
            var res = new Moment(checkOverflow(prepareConfig(config)));
            if (res._nextDay) {
                // Adding is smart enough around DST
                res.add(1, 'd');
                res._nextDay = undefined;
            }

            return res;
        }

        function prepareConfig(config) {
            var input = config._i,
                format = config._f;

            config._locale = config._locale || getLocale(config._l);

            if (input === null || (format === undefined && input === '')) {
                return createInvalid({ nullInput: true });
            }

            if (typeof input === 'string') {
                config._i = input = config._locale.preparse(input);
            }

            if (isMoment(input)) {
                return new Moment(checkOverflow(input));
            } else if (isDate(input)) {
                config._d = input;
            } else if (isArray(format)) {
                configFromStringAndArray(config);
            } else if (format) {
                configFromStringAndFormat(config);
            } else {
                configFromInput(config);
            }

            if (!isValid(config)) {
                config._d = null;
            }

            return config;
        }

        function configFromInput(config) {
            var input = config._i;
            if (isUndefined(input)) {
                config._d = new Date(hooks.now());
            } else if (isDate(input)) {
                config._d = new Date(input.valueOf());
            } else if (typeof input === 'string') {
                configFromString(config);
            } else if (isArray(input)) {
                config._a = map(input.slice(0), function (obj) {
                    return parseInt(obj, 10);
                });
                configFromArray(config);
            } else if (isObject(input)) {
                configFromObject(config);
            } else if (isNumber(input)) {
                // from milliseconds
                config._d = new Date(input);
            } else {
                hooks.createFromInputFallback(config);
            }
        }

        function createLocalOrUTC(input, format, locale, strict, isUTC) {
            var c = {};

            if (format === true || format === false) {
                strict = format;
                format = undefined;
            }

            if (locale === true || locale === false) {
                strict = locale;
                locale = undefined;
            }

            if (
                (isObject(input) && isObjectEmpty(input)) ||
                (isArray(input) && input.length === 0)
            ) {
                input = undefined;
            }
            // object construction must be done this way.
            // https://github.com/moment/moment/issues/1423
            c._isAMomentObject = true;
            c._useUTC = c._isUTC = isUTC;
            c._l = locale;
            c._i = input;
            c._f = format;
            c._strict = strict;

            return createFromConfig(c);
        }

        function createLocal(input, format, locale, strict) {
            return createLocalOrUTC(input, format, locale, strict, false);
        }

        var prototypeMin = deprecate(
                'moment().min is deprecated, use moment.max instead. http://momentjs.com/guides/#/warnings/min-max/',
                function () {
                    var other = createLocal.apply(null, arguments);
                    if (this.isValid() && other.isValid()) {
                        return other < this ? this : other;
                    } else {
                        return createInvalid();
                    }
                }
            ),
            prototypeMax = deprecate(
                'moment().max is deprecated, use moment.min instead. http://momentjs.com/guides/#/warnings/min-max/',
                function () {
                    var other = createLocal.apply(null, arguments);
                    if (this.isValid() && other.isValid()) {
                        return other > this ? this : other;
                    } else {
                        return createInvalid();
                    }
                }
            );

        // Pick a moment m from moments so that m[fn](other) is true for all
        // other. This relies on the function fn to be transitive.
        //
        // moments should either be an array of moment objects or an array, whose
        // first element is an array of moment objects.
        function pickBy(fn, moments) {
            var res, i;
            if (moments.length === 1 && isArray(moments[0])) {
                moments = moments[0];
            }
            if (!moments.length) {
                return createLocal();
            }
            res = moments[0];
            for (i = 1; i < moments.length; ++i) {
                if (!moments[i].isValid() || moments[i][fn](res)) {
                    res = moments[i];
                }
            }
            return res;
        }

        // TODO: Use [].sort instead?
        function min() {
            var args = [].slice.call(arguments, 0);

            return pickBy('isBefore', args);
        }

        function max() {
            var args = [].slice.call(arguments, 0);

            return pickBy('isAfter', args);
        }

        var now = function () {
            return Date.now ? Date.now() : +new Date();
        };

        var ordering = [
            'year',
            'quarter',
            'month',
            'week',
            'day',
            'hour',
            'minute',
            'second',
            'millisecond',
        ];

        function isDurationValid(m) {
            var key,
                unitHasDecimal = false,
                i;
            for (key in m) {
                if (
                    hasOwnProp(m, key) &&
                    !(
                        indexOf.call(ordering, key) !== -1 &&
                        (m[key] == null || !isNaN(m[key]))
                    )
                ) {
                    return false;
                }
            }

            for (i = 0; i < ordering.length; ++i) {
                if (m[ordering[i]]) {
                    if (unitHasDecimal) {
                        return false; // only allow non-integers for smallest unit
                    }
                    if (parseFloat(m[ordering[i]]) !== toInt(m[ordering[i]])) {
                        unitHasDecimal = true;
                    }
                }
            }

            return true;
        }

        function isValid$1() {
            return this._isValid;
        }

        function createInvalid$1() {
            return createDuration(NaN);
        }

        function Duration(duration) {
            var normalizedInput = normalizeObjectUnits(duration),
                years = normalizedInput.year || 0,
                quarters = normalizedInput.quarter || 0,
                months = normalizedInput.month || 0,
                weeks = normalizedInput.week || normalizedInput.isoWeek || 0,
                days = normalizedInput.day || 0,
                hours = normalizedInput.hour || 0,
                minutes = normalizedInput.minute || 0,
                seconds = normalizedInput.second || 0,
                milliseconds = normalizedInput.millisecond || 0;

            this._isValid = isDurationValid(normalizedInput);

            // representation for dateAddRemove
            this._milliseconds =
                +milliseconds +
                seconds * 1e3 + // 1000
                minutes * 6e4 + // 1000 * 60
                hours * 1000 * 60 * 60; //using 1000 * 60 * 60 instead of 36e5 to avoid floating point rounding errors https://github.com/moment/moment/issues/2978
            // Because of dateAddRemove treats 24 hours as different from a
            // day when working around DST, we need to store them separately
            this._days = +days + weeks * 7;
            // It is impossible to translate months into days without knowing
            // which months you are are talking about, so we have to store
            // it separately.
            this._months = +months + quarters * 3 + years * 12;

            this._data = {};

            this._locale = getLocale();

            this._bubble();
        }

        function isDuration(obj) {
            return obj instanceof Duration;
        }

        function absRound(number) {
            if (number < 0) {
                return Math.round(-1 * number) * -1;
            } else {
                return Math.round(number);
            }
        }

        // compare two arrays, return the number of differences
        function compareArrays(array1, array2, dontConvert) {
            var len = Math.min(array1.length, array2.length),
                lengthDiff = Math.abs(array1.length - array2.length),
                diffs = 0,
                i;
            for (i = 0; i < len; i++) {
                if (
                    (dontConvert && array1[i] !== array2[i]) ||
                    (!dontConvert && toInt(array1[i]) !== toInt(array2[i]))
                ) {
                    diffs++;
                }
            }
            return diffs + lengthDiff;
        }

        // FORMATTING

        function offset(token, separator) {
            addFormatToken(token, 0, 0, function () {
                var offset = this.utcOffset(),
                    sign = '+';
                if (offset < 0) {
                    offset = -offset;
                    sign = '-';
                }
                return (
                    sign +
                    zeroFill(~~(offset / 60), 2) +
                    separator +
                    zeroFill(~~offset % 60, 2)
                );
            });
        }

        offset('Z', ':');
        offset('ZZ', '');

        // PARSING

        addRegexToken('Z', matchShortOffset);
        addRegexToken('ZZ', matchShortOffset);
        addParseToken(['Z', 'ZZ'], function (input, array, config) {
            config._useUTC = true;
            config._tzm = offsetFromString(matchShortOffset, input);
        });

        // HELPERS

        // timezone chunker
        // '+10:00' > ['10',  '00']
        // '-1530'  > ['-15', '30']
        var chunkOffset = /([\+\-]|\d\d)/gi;

        function offsetFromString(matcher, string) {
            var matches = (string || '').match(matcher),
                chunk,
                parts,
                minutes;

            if (matches === null) {
                return null;
            }

            chunk = matches[matches.length - 1] || [];
            parts = (chunk + '').match(chunkOffset) || ['-', 0, 0];
            minutes = +(parts[1] * 60) + toInt(parts[2]);

            return minutes === 0 ? 0 : parts[0] === '+' ? minutes : -minutes;
        }

        // Return a moment from input, that is local/utc/zone equivalent to model.
        function cloneWithOffset(input, model) {
            var res, diff;
            if (model._isUTC) {
                res = model.clone();
                diff =
                    (isMoment(input) || isDate(input)
                        ? input.valueOf()
                        : createLocal(input).valueOf()) - res.valueOf();
                // Use low-level api, because this fn is low-level api.
                res._d.setTime(res._d.valueOf() + diff);
                hooks.updateOffset(res, false);
                return res;
            } else {
                return createLocal(input).local();
            }
        }

        function getDateOffset(m) {
            // On Firefox.24 Date#getTimezoneOffset returns a floating point.
            // https://github.com/moment/moment/pull/1871
            return -Math.round(m._d.getTimezoneOffset());
        }

        // HOOKS

        // This function will be called whenever a moment is mutated.
        // It is intended to keep the offset in sync with the timezone.
        hooks.updateOffset = function () {};

        // MOMENTS

        // keepLocalTime = true means only change the timezone, without
        // affecting the local hour. So 5:31:26 +0300 --[utcOffset(2, true)]-->
        // 5:31:26 +0200 It is possible that 5:31:26 doesn't exist with offset
        // +0200, so we adjust the time as needed, to be valid.
        //
        // Keeping the time actually adds/subtracts (one hour)
        // from the actual represented time. That is why we call updateOffset
        // a second time. In case it wants us to change the offset again
        // _changeInProgress == true case, then we have to adjust, because
        // there is no such time in the given timezone.
        function getSetOffset(input, keepLocalTime, keepMinutes) {
            var offset = this._offset || 0,
                localAdjust;
            if (!this.isValid()) {
                return input != null ? this : NaN;
            }
            if (input != null) {
                if (typeof input === 'string') {
                    input = offsetFromString(matchShortOffset, input);
                    if (input === null) {
                        return this;
                    }
                } else if (Math.abs(input) < 16 && !keepMinutes) {
                    input = input * 60;
                }
                if (!this._isUTC && keepLocalTime) {
                    localAdjust = getDateOffset(this);
                }
                this._offset = input;
                this._isUTC = true;
                if (localAdjust != null) {
                    this.add(localAdjust, 'm');
                }
                if (offset !== input) {
                    if (!keepLocalTime || this._changeInProgress) {
                        addSubtract(
                            this,
                            createDuration(input - offset, 'm'),
                            1,
                            false
                        );
                    } else if (!this._changeInProgress) {
                        this._changeInProgress = true;
                        hooks.updateOffset(this, true);
                        this._changeInProgress = null;
                    }
                }
                return this;
            } else {
                return this._isUTC ? offset : getDateOffset(this);
            }
        }

        function getSetZone(input, keepLocalTime) {
            if (input != null) {
                if (typeof input !== 'string') {
                    input = -input;
                }

                this.utcOffset(input, keepLocalTime);

                return this;
            } else {
                return -this.utcOffset();
            }
        }

        function setOffsetToUTC(keepLocalTime) {
            return this.utcOffset(0, keepLocalTime);
        }

        function setOffsetToLocal(keepLocalTime) {
            if (this._isUTC) {
                this.utcOffset(0, keepLocalTime);
                this._isUTC = false;

                if (keepLocalTime) {
                    this.subtract(getDateOffset(this), 'm');
                }
            }
            return this;
        }

        function setOffsetToParsedOffset() {
            if (this._tzm != null) {
                this.utcOffset(this._tzm, false, true);
            } else if (typeof this._i === 'string') {
                var tZone = offsetFromString(matchOffset, this._i);
                if (tZone != null) {
                    this.utcOffset(tZone);
                } else {
                    this.utcOffset(0, true);
                }
            }
            return this;
        }

        function hasAlignedHourOffset(input) {
            if (!this.isValid()) {
                return false;
            }
            input = input ? createLocal(input).utcOffset() : 0;

            return (this.utcOffset() - input) % 60 === 0;
        }

        function isDaylightSavingTime() {
            return (
                this.utcOffset() > this.clone().month(0).utcOffset() ||
                this.utcOffset() > this.clone().month(5).utcOffset()
            );
        }

        function isDaylightSavingTimeShifted() {
            if (!isUndefined(this._isDSTShifted)) {
                return this._isDSTShifted;
            }

            var c = {},
                other;

            copyConfig(c, this);
            c = prepareConfig(c);

            if (c._a) {
                other = c._isUTC ? createUTC(c._a) : createLocal(c._a);
                this._isDSTShifted =
                    this.isValid() && compareArrays(c._a, other.toArray()) > 0;
            } else {
                this._isDSTShifted = false;
            }

            return this._isDSTShifted;
        }

        function isLocal() {
            return this.isValid() ? !this._isUTC : false;
        }

        function isUtcOffset() {
            return this.isValid() ? this._isUTC : false;
        }

        function isUtc() {
            return this.isValid() ? this._isUTC && this._offset === 0 : false;
        }

        // ASP.NET json date format regex
        var aspNetRegex = /^(-|\+)?(?:(\d*)[. ])?(\d+):(\d+)(?::(\d+)(\.\d*)?)?$/,
            // from http://docs.closure-library.googlecode.com/git/closure_goog_date_date.js.source.html
            // somewhat more in line with 4.4.3.2 2004 spec, but allows decimal anywhere
            // and further modified to allow for strings containing both week and day
            isoRegex = /^(-|\+)?P(?:([-+]?[0-9,.]*)Y)?(?:([-+]?[0-9,.]*)M)?(?:([-+]?[0-9,.]*)W)?(?:([-+]?[0-9,.]*)D)?(?:T(?:([-+]?[0-9,.]*)H)?(?:([-+]?[0-9,.]*)M)?(?:([-+]?[0-9,.]*)S)?)?$/;

        function createDuration(input, key) {
            var duration = input,
                // matching against regexp is expensive, do it on demand
                match = null,
                sign,
                ret,
                diffRes;

            if (isDuration(input)) {
                duration = {
                    ms: input._milliseconds,
                    d: input._days,
                    M: input._months,
                };
            } else if (isNumber(input) || !isNaN(+input)) {
                duration = {};
                if (key) {
                    duration[key] = +input;
                } else {
                    duration.milliseconds = +input;
                }
            } else if ((match = aspNetRegex.exec(input))) {
                sign = match[1] === '-' ? -1 : 1;
                duration = {
                    y: 0,
                    d: toInt(match[DATE]) * sign,
                    h: toInt(match[HOUR]) * sign,
                    m: toInt(match[MINUTE]) * sign,
                    s: toInt(match[SECOND]) * sign,
                    ms: toInt(absRound(match[MILLISECOND] * 1000)) * sign, // the millisecond decimal point is included in the match
                };
            } else if ((match = isoRegex.exec(input))) {
                sign = match[1] === '-' ? -1 : 1;
                duration = {
                    y: parseIso(match[2], sign),
                    M: parseIso(match[3], sign),
                    w: parseIso(match[4], sign),
                    d: parseIso(match[5], sign),
                    h: parseIso(match[6], sign),
                    m: parseIso(match[7], sign),
                    s: parseIso(match[8], sign),
                };
            } else if (duration == null) {
                // checks for null or undefined
                duration = {};
            } else if (
                typeof duration === 'object' &&
                ('from' in duration || 'to' in duration)
            ) {
                diffRes = momentsDifference(
                    createLocal(duration.from),
                    createLocal(duration.to)
                );

                duration = {};
                duration.ms = diffRes.milliseconds;
                duration.M = diffRes.months;
            }

            ret = new Duration(duration);

            if (isDuration(input) && hasOwnProp(input, '_locale')) {
                ret._locale = input._locale;
            }

            if (isDuration(input) && hasOwnProp(input, '_isValid')) {
                ret._isValid = input._isValid;
            }

            return ret;
        }

        createDuration.fn = Duration.prototype;
        createDuration.invalid = createInvalid$1;

        function parseIso(inp, sign) {
            // We'd normally use ~~inp for this, but unfortunately it also
            // converts floats to ints.
            // inp may be undefined, so careful calling replace on it.
            var res = inp && parseFloat(inp.replace(',', '.'));
            // apply sign while we're at it
            return (isNaN(res) ? 0 : res) * sign;
        }

        function positiveMomentsDifference(base, other) {
            var res = {};

            res.months =
                other.month() - base.month() + (other.year() - base.year()) * 12;
            if (base.clone().add(res.months, 'M').isAfter(other)) {
                --res.months;
            }

            res.milliseconds = +other - +base.clone().add(res.months, 'M');

            return res;
        }

        function momentsDifference(base, other) {
            var res;
            if (!(base.isValid() && other.isValid())) {
                return { milliseconds: 0, months: 0 };
            }

            other = cloneWithOffset(other, base);
            if (base.isBefore(other)) {
                res = positiveMomentsDifference(base, other);
            } else {
                res = positiveMomentsDifference(other, base);
                res.milliseconds = -res.milliseconds;
                res.months = -res.months;
            }

            return res;
        }

        // TODO: remove 'name' arg after deprecation is removed
        function createAdder(direction, name) {
            return function (val, period) {
                var dur, tmp;
                //invert the arguments, but complain about it
                if (period !== null && !isNaN(+period)) {
                    deprecateSimple(
                        name,
                        'moment().' +
                            name +
                            '(period, number) is deprecated. Please use moment().' +
                            name +
                            '(number, period). ' +
                            'See http://momentjs.com/guides/#/warnings/add-inverted-param/ for more info.'
                    );
                    tmp = val;
                    val = period;
                    period = tmp;
                }

                dur = createDuration(val, period);
                addSubtract(this, dur, direction);
                return this;
            };
        }

        function addSubtract(mom, duration, isAdding, updateOffset) {
            var milliseconds = duration._milliseconds,
                days = absRound(duration._days),
                months = absRound(duration._months);

            if (!mom.isValid()) {
                // No op
                return;
            }

            updateOffset = updateOffset == null ? true : updateOffset;

            if (months) {
                setMonth(mom, get(mom, 'Month') + months * isAdding);
            }
            if (days) {
                set$1(mom, 'Date', get(mom, 'Date') + days * isAdding);
            }
            if (milliseconds) {
                mom._d.setTime(mom._d.valueOf() + milliseconds * isAdding);
            }
            if (updateOffset) {
                hooks.updateOffset(mom, days || months);
            }
        }

        var add = createAdder(1, 'add'),
            subtract = createAdder(-1, 'subtract');

        function isString(input) {
            return typeof input === 'string' || input instanceof String;
        }

        // type MomentInput = Moment | Date | string | number | (number | string)[] | MomentInputObject | void; // null | undefined
        function isMomentInput(input) {
            return (
                isMoment(input) ||
                isDate(input) ||
                isString(input) ||
                isNumber(input) ||
                isNumberOrStringArray(input) ||
                isMomentInputObject(input) ||
                input === null ||
                input === undefined
            );
        }

        function isMomentInputObject(input) {
            var objectTest = isObject(input) && !isObjectEmpty(input),
                propertyTest = false,
                properties = [
                    'years',
                    'year',
                    'y',
                    'months',
                    'month',
                    'M',
                    'days',
                    'day',
                    'd',
                    'dates',
                    'date',
                    'D',
                    'hours',
                    'hour',
                    'h',
                    'minutes',
                    'minute',
                    'm',
                    'seconds',
                    'second',
                    's',
                    'milliseconds',
                    'millisecond',
                    'ms',
                ],
                i,
                property;

            for (i = 0; i < properties.length; i += 1) {
                property = properties[i];
                propertyTest = propertyTest || hasOwnProp(input, property);
            }

            return objectTest && propertyTest;
        }

        function isNumberOrStringArray(input) {
            var arrayTest = isArray(input),
                dataTypeTest = false;
            if (arrayTest) {
                dataTypeTest =
                    input.filter(function (item) {
                        return !isNumber(item) && isString(input);
                    }).length === 0;
            }
            return arrayTest && dataTypeTest;
        }

        function isCalendarSpec(input) {
            var objectTest = isObject(input) && !isObjectEmpty(input),
                propertyTest = false,
                properties = [
                    'sameDay',
                    'nextDay',
                    'lastDay',
                    'nextWeek',
                    'lastWeek',
                    'sameElse',
                ],
                i,
                property;

            for (i = 0; i < properties.length; i += 1) {
                property = properties[i];
                propertyTest = propertyTest || hasOwnProp(input, property);
            }

            return objectTest && propertyTest;
        }

        function getCalendarFormat(myMoment, now) {
            var diff = myMoment.diff(now, 'days', true);
            return diff < -6
                ? 'sameElse'
                : diff < -1
                ? 'lastWeek'
                : diff < 0
                ? 'lastDay'
                : diff < 1
                ? 'sameDay'
                : diff < 2
                ? 'nextDay'
                : diff < 7
                ? 'nextWeek'
                : 'sameElse';
        }

        function calendar$1(time, formats) {
            // Support for single parameter, formats only overload to the calendar function
            if (arguments.length === 1) {
                if (!arguments[0]) {
                    time = undefined;
                    formats = undefined;
                } else if (isMomentInput(arguments[0])) {
                    time = arguments[0];
                    formats = undefined;
                } else if (isCalendarSpec(arguments[0])) {
                    formats = arguments[0];
                    time = undefined;
                }
            }
            // We want to compare the start of today, vs this.
            // Getting start-of-today depends on whether we're local/utc/offset or not.
            var now = time || createLocal(),
                sod = cloneWithOffset(now, this).startOf('day'),
                format = hooks.calendarFormat(this, sod) || 'sameElse',
                output =
                    formats &&
                    (isFunction(formats[format])
                        ? formats[format].call(this, now)
                        : formats[format]);

            return this.format(
                output || this.localeData().calendar(format, this, createLocal(now))
            );
        }

        function clone() {
            return new Moment(this);
        }

        function isAfter(input, units) {
            var localInput = isMoment(input) ? input : createLocal(input);
            if (!(this.isValid() && localInput.isValid())) {
                return false;
            }
            units = normalizeUnits(units) || 'millisecond';
            if (units === 'millisecond') {
                return this.valueOf() > localInput.valueOf();
            } else {
                return localInput.valueOf() < this.clone().startOf(units).valueOf();
            }
        }

        function isBefore(input, units) {
            var localInput = isMoment(input) ? input : createLocal(input);
            if (!(this.isValid() && localInput.isValid())) {
                return false;
            }
            units = normalizeUnits(units) || 'millisecond';
            if (units === 'millisecond') {
                return this.valueOf() < localInput.valueOf();
            } else {
                return this.clone().endOf(units).valueOf() < localInput.valueOf();
            }
        }

        function isBetween(from, to, units, inclusivity) {
            var localFrom = isMoment(from) ? from : createLocal(from),
                localTo = isMoment(to) ? to : createLocal(to);
            if (!(this.isValid() && localFrom.isValid() && localTo.isValid())) {
                return false;
            }
            inclusivity = inclusivity || '()';
            return (
                (inclusivity[0] === '('
                    ? this.isAfter(localFrom, units)
                    : !this.isBefore(localFrom, units)) &&
                (inclusivity[1] === ')'
                    ? this.isBefore(localTo, units)
                    : !this.isAfter(localTo, units))
            );
        }

        function isSame(input, units) {
            var localInput = isMoment(input) ? input : createLocal(input),
                inputMs;
            if (!(this.isValid() && localInput.isValid())) {
                return false;
            }
            units = normalizeUnits(units) || 'millisecond';
            if (units === 'millisecond') {
                return this.valueOf() === localInput.valueOf();
            } else {
                inputMs = localInput.valueOf();
                return (
                    this.clone().startOf(units).valueOf() <= inputMs &&
                    inputMs <= this.clone().endOf(units).valueOf()
                );
            }
        }

        function isSameOrAfter(input, units) {
            return this.isSame(input, units) || this.isAfter(input, units);
        }

        function isSameOrBefore(input, units) {
            return this.isSame(input, units) || this.isBefore(input, units);
        }

        function diff(input, units, asFloat) {
            var that, zoneDelta, output;

            if (!this.isValid()) {
                return NaN;
            }

            that = cloneWithOffset(input, this);

            if (!that.isValid()) {
                return NaN;
            }

            zoneDelta = (that.utcOffset() - this.utcOffset()) * 6e4;

            units = normalizeUnits(units);

            switch (units) {
                case 'year':
                    output = monthDiff(this, that) / 12;
                    break;
                case 'month':
                    output = monthDiff(this, that);
                    break;
                case 'quarter':
                    output = monthDiff(this, that) / 3;
                    break;
                case 'second':
                    output = (this - that) / 1e3;
                    break; // 1000
                case 'minute':
                    output = (this - that) / 6e4;
                    break; // 1000 * 60
                case 'hour':
                    output = (this - that) / 36e5;
                    break; // 1000 * 60 * 60
                case 'day':
                    output = (this - that - zoneDelta) / 864e5;
                    break; // 1000 * 60 * 60 * 24, negate dst
                case 'week':
                    output = (this - that - zoneDelta) / 6048e5;
                    break; // 1000 * 60 * 60 * 24 * 7, negate dst
                default:
                    output = this - that;
            }

            return asFloat ? output : absFloor(output);
        }

        function monthDiff(a, b) {
            if (a.date() < b.date()) {
                // end-of-month calculations work correct when the start month has more
                // days than the end month.
                return -monthDiff(b, a);
            }
            // difference in months
            var wholeMonthDiff = (b.year() - a.year()) * 12 + (b.month() - a.month()),
                // b is in (anchor - 1 month, anchor + 1 month)
                anchor = a.clone().add(wholeMonthDiff, 'months'),
                anchor2,
                adjust;

            if (b - anchor < 0) {
                anchor2 = a.clone().add(wholeMonthDiff - 1, 'months');
                // linear across the month
                adjust = (b - anchor) / (anchor - anchor2);
            } else {
                anchor2 = a.clone().add(wholeMonthDiff + 1, 'months');
                // linear across the month
                adjust = (b - anchor) / (anchor2 - anchor);
            }

            //check for negative zero, return zero if negative zero
            return -(wholeMonthDiff + adjust) || 0;
        }

        hooks.defaultFormat = 'YYYY-MM-DDTHH:mm:ssZ';
        hooks.defaultFormatUtc = 'YYYY-MM-DDTHH:mm:ss[Z]';

        function toString() {
            return this.clone().locale('en').format('ddd MMM DD YYYY HH:mm:ss [GMT]ZZ');
        }

        function toISOString(keepOffset) {
            if (!this.isValid()) {
                return null;
            }
            var utc = keepOffset !== true,
                m = utc ? this.clone().utc() : this;
            if (m.year() < 0 || m.year() > 9999) {
                return formatMoment(
                    m,
                    utc
                        ? 'YYYYYY-MM-DD[T]HH:mm:ss.SSS[Z]'
                        : 'YYYYYY-MM-DD[T]HH:mm:ss.SSSZ'
                );
            }
            if (isFunction(Date.prototype.toISOString)) {
                // native implementation is ~50x faster, use it when we can
                if (utc) {
                    return this.toDate().toISOString();
                } else {
                    return new Date(this.valueOf() + this.utcOffset() * 60 * 1000)
                        .toISOString()
                        .replace('Z', formatMoment(m, 'Z'));
                }
            }
            return formatMoment(
                m,
                utc ? 'YYYY-MM-DD[T]HH:mm:ss.SSS[Z]' : 'YYYY-MM-DD[T]HH:mm:ss.SSSZ'
            );
        }

        /**
         * Return a human readable representation of a moment that can
         * also be evaluated to get a new moment which is the same
         *
         * @link https://nodejs.org/dist/latest/docs/api/util.html#util_custom_inspect_function_on_objects
         */
        function inspect() {
            if (!this.isValid()) {
                return 'moment.invalid(/* ' + this._i + ' */)';
            }
            var func = 'moment',
                zone = '',
                prefix,
                year,
                datetime,
                suffix;
            if (!this.isLocal()) {
                func = this.utcOffset() === 0 ? 'moment.utc' : 'moment.parseZone';
                zone = 'Z';
            }
            prefix = '[' + func + '("]';
            year = 0 <= this.year() && this.year() <= 9999 ? 'YYYY' : 'YYYYYY';
            datetime = '-MM-DD[T]HH:mm:ss.SSS';
            suffix = zone + '[")]';

            return this.format(prefix + year + datetime + suffix);
        }

        function format(inputString) {
            if (!inputString) {
                inputString = this.isUtc()
                    ? hooks.defaultFormatUtc
                    : hooks.defaultFormat;
            }
            var output = formatMoment(this, inputString);
            return this.localeData().postformat(output);
        }

        function from(time, withoutSuffix) {
            if (
                this.isValid() &&
                ((isMoment(time) && time.isValid()) || createLocal(time).isValid())
            ) {
                return createDuration({ to: this, from: time })
                    .locale(this.locale())
                    .humanize(!withoutSuffix);
            } else {
                return this.localeData().invalidDate();
            }
        }

        function fromNow(withoutSuffix) {
            return this.from(createLocal(), withoutSuffix);
        }

        function to(time, withoutSuffix) {
            if (
                this.isValid() &&
                ((isMoment(time) && time.isValid()) || createLocal(time).isValid())
            ) {
                return createDuration({ from: this, to: time })
                    .locale(this.locale())
                    .humanize(!withoutSuffix);
            } else {
                return this.localeData().invalidDate();
            }
        }

        function toNow(withoutSuffix) {
            return this.to(createLocal(), withoutSuffix);
        }

        // If passed a locale key, it will set the locale for this
        // instance.  Otherwise, it will return the locale configuration
        // variables for this instance.
        function locale(key) {
            var newLocaleData;

            if (key === undefined) {
                return this._locale._abbr;
            } else {
                newLocaleData = getLocale(key);
                if (newLocaleData != null) {
                    this._locale = newLocaleData;
                }
                return this;
            }
        }

        var lang = deprecate(
            'moment().lang() is deprecated. Instead, use moment().localeData() to get the language configuration. Use moment().locale() to change languages.',
            function (key) {
                if (key === undefined) {
                    return this.localeData();
                } else {
                    return this.locale(key);
                }
            }
        );

        function localeData() {
            return this._locale;
        }

        var MS_PER_SECOND = 1000,
            MS_PER_MINUTE = 60 * MS_PER_SECOND,
            MS_PER_HOUR = 60 * MS_PER_MINUTE,
            MS_PER_400_YEARS = (365 * 400 + 97) * 24 * MS_PER_HOUR;

        // actual modulo - handles negative numbers (for dates before 1970):
        function mod$1(dividend, divisor) {
            return ((dividend % divisor) + divisor) % divisor;
        }

        function localStartOfDate(y, m, d) {
            // the date constructor remaps years 0-99 to 1900-1999
            if (y < 100 && y >= 0) {
                // preserve leap years using a full 400 year cycle, then reset
                return new Date(y + 400, m, d) - MS_PER_400_YEARS;
            } else {
                return new Date(y, m, d).valueOf();
            }
        }

        function utcStartOfDate(y, m, d) {
            // Date.UTC remaps years 0-99 to 1900-1999
            if (y < 100 && y >= 0) {
                // preserve leap years using a full 400 year cycle, then reset
                return Date.UTC(y + 400, m, d) - MS_PER_400_YEARS;
            } else {
                return Date.UTC(y, m, d);
            }
        }

        function startOf(units) {
            var time, startOfDate;
            units = normalizeUnits(units);
            if (units === undefined || units === 'millisecond' || !this.isValid()) {
                return this;
            }

            startOfDate = this._isUTC ? utcStartOfDate : localStartOfDate;

            switch (units) {
                case 'year':
                    time = startOfDate(this.year(), 0, 1);
                    break;
                case 'quarter':
                    time = startOfDate(
                        this.year(),
                        this.month() - (this.month() % 3),
                        1
                    );
                    break;
                case 'month':
                    time = startOfDate(this.year(), this.month(), 1);
                    break;
                case 'week':
                    time = startOfDate(
                        this.year(),
                        this.month(),
                        this.date() - this.weekday()
                    );
                    break;
                case 'isoWeek':
                    time = startOfDate(
                        this.year(),
                        this.month(),
                        this.date() - (this.isoWeekday() - 1)
                    );
                    break;
                case 'day':
                case 'date':
                    time = startOfDate(this.year(), this.month(), this.date());
                    break;
                case 'hour':
                    time = this._d.valueOf();
                    time -= mod$1(
                        time + (this._isUTC ? 0 : this.utcOffset() * MS_PER_MINUTE),
                        MS_PER_HOUR
                    );
                    break;
                case 'minute':
                    time = this._d.valueOf();
                    time -= mod$1(time, MS_PER_MINUTE);
                    break;
                case 'second':
                    time = this._d.valueOf();
                    time -= mod$1(time, MS_PER_SECOND);
                    break;
            }

            this._d.setTime(time);
            hooks.updateOffset(this, true);
            return this;
        }

        function endOf(units) {
            var time, startOfDate;
            units = normalizeUnits(units);
            if (units === undefined || units === 'millisecond' || !this.isValid()) {
                return this;
            }

            startOfDate = this._isUTC ? utcStartOfDate : localStartOfDate;

            switch (units) {
                case 'year':
                    time = startOfDate(this.year() + 1, 0, 1) - 1;
                    break;
                case 'quarter':
                    time =
                        startOfDate(
                            this.year(),
                            this.month() - (this.month() % 3) + 3,
                            1
                        ) - 1;
                    break;
                case 'month':
                    time = startOfDate(this.year(), this.month() + 1, 1) - 1;
                    break;
                case 'week':
                    time =
                        startOfDate(
                            this.year(),
                            this.month(),
                            this.date() - this.weekday() + 7
                        ) - 1;
                    break;
                case 'isoWeek':
                    time =
                        startOfDate(
                            this.year(),
                            this.month(),
                            this.date() - (this.isoWeekday() - 1) + 7
                        ) - 1;
                    break;
                case 'day':
                case 'date':
                    time = startOfDate(this.year(), this.month(), this.date() + 1) - 1;
                    break;
                case 'hour':
                    time = this._d.valueOf();
                    time +=
                        MS_PER_HOUR -
                        mod$1(
                            time + (this._isUTC ? 0 : this.utcOffset() * MS_PER_MINUTE),
                            MS_PER_HOUR
                        ) -
                        1;
                    break;
                case 'minute':
                    time = this._d.valueOf();
                    time += MS_PER_MINUTE - mod$1(time, MS_PER_MINUTE) - 1;
                    break;
                case 'second':
                    time = this._d.valueOf();
                    time += MS_PER_SECOND - mod$1(time, MS_PER_SECOND) - 1;
                    break;
            }

            this._d.setTime(time);
            hooks.updateOffset(this, true);
            return this;
        }

        function valueOf() {
            return this._d.valueOf() - (this._offset || 0) * 60000;
        }

        function unix() {
            return Math.floor(this.valueOf() / 1000);
        }

        function toDate() {
            return new Date(this.valueOf());
        }

        function toArray() {
            var m = this;
            return [
                m.year(),
                m.month(),
                m.date(),
                m.hour(),
                m.minute(),
                m.second(),
                m.millisecond(),
            ];
        }

        function toObject() {
            var m = this;
            return {
                years: m.year(),
                months: m.month(),
                date: m.date(),
                hours: m.hours(),
                minutes: m.minutes(),
                seconds: m.seconds(),
                milliseconds: m.milliseconds(),
            };
        }

        function toJSON() {
            // new Date(NaN).toJSON() === null
            return this.isValid() ? this.toISOString() : null;
        }

        function isValid$2() {
            return isValid(this);
        }

        function parsingFlags() {
            return extend({}, getParsingFlags(this));
        }

        function invalidAt() {
            return getParsingFlags(this).overflow;
        }

        function creationData() {
            return {
                input: this._i,
                format: this._f,
                locale: this._locale,
                isUTC: this._isUTC,
                strict: this._strict,
            };
        }

        addFormatToken('N', 0, 0, 'eraAbbr');
        addFormatToken('NN', 0, 0, 'eraAbbr');
        addFormatToken('NNN', 0, 0, 'eraAbbr');
        addFormatToken('NNNN', 0, 0, 'eraName');
        addFormatToken('NNNNN', 0, 0, 'eraNarrow');

        addFormatToken('y', ['y', 1], 'yo', 'eraYear');
        addFormatToken('y', ['yy', 2], 0, 'eraYear');
        addFormatToken('y', ['yyy', 3], 0, 'eraYear');
        addFormatToken('y', ['yyyy', 4], 0, 'eraYear');

        addRegexToken('N', matchEraAbbr);
        addRegexToken('NN', matchEraAbbr);
        addRegexToken('NNN', matchEraAbbr);
        addRegexToken('NNNN', matchEraName);
        addRegexToken('NNNNN', matchEraNarrow);

        addParseToken(['N', 'NN', 'NNN', 'NNNN', 'NNNNN'], function (
            input,
            array,
            config,
            token
        ) {
            var era = config._locale.erasParse(input, token, config._strict);
            if (era) {
                getParsingFlags(config).era = era;
            } else {
                getParsingFlags(config).invalidEra = input;
            }
        });

        addRegexToken('y', matchUnsigned);
        addRegexToken('yy', matchUnsigned);
        addRegexToken('yyy', matchUnsigned);
        addRegexToken('yyyy', matchUnsigned);
        addRegexToken('yo', matchEraYearOrdinal);

        addParseToken(['y', 'yy', 'yyy', 'yyyy'], YEAR);
        addParseToken(['yo'], function (input, array, config, token) {
            var match;
            if (config._locale._eraYearOrdinalRegex) {
                match = input.match(config._locale._eraYearOrdinalRegex);
            }

            if (config._locale.eraYearOrdinalParse) {
                array[YEAR] = config._locale.eraYearOrdinalParse(input, match);
            } else {
                array[YEAR] = parseInt(input, 10);
            }
        });

        function localeEras(m, format) {
            var i,
                l,
                date,
                eras = this._eras || getLocale('en')._eras;
            for (i = 0, l = eras.length; i < l; ++i) {
                switch (typeof eras[i].since) {
                    case 'string':
                        // truncate time
                        date = hooks(eras[i].since).startOf('day');
                        eras[i].since = date.valueOf();
                        break;
                }

                switch (typeof eras[i].until) {
                    case 'undefined':
                        eras[i].until = +Infinity;
                        break;
                    case 'string':
                        // truncate time
                        date = hooks(eras[i].until).startOf('day').valueOf();
                        eras[i].until = date.valueOf();
                        break;
                }
            }
            return eras;
        }

        function localeErasParse(eraName, format, strict) {
            var i,
                l,
                eras = this.eras(),
                name,
                abbr,
                narrow;
            eraName = eraName.toUpperCase();

            for (i = 0, l = eras.length; i < l; ++i) {
                name = eras[i].name.toUpperCase();
                abbr = eras[i].abbr.toUpperCase();
                narrow = eras[i].narrow.toUpperCase();

                if (strict) {
                    switch (format) {
                        case 'N':
                        case 'NN':
                        case 'NNN':
                            if (abbr === eraName) {
                                return eras[i];
                            }
                            break;

                        case 'NNNN':
                            if (name === eraName) {
                                return eras[i];
                            }
                            break;

                        case 'NNNNN':
                            if (narrow === eraName) {
                                return eras[i];
                            }
                            break;
                    }
                } else if ([name, abbr, narrow].indexOf(eraName) >= 0) {
                    return eras[i];
                }
            }
        }

        function localeErasConvertYear(era, year) {
            var dir = era.since <= era.until ? +1 : -1;
            if (year === undefined) {
                return hooks(era.since).year();
            } else {
                return hooks(era.since).year() + (year - era.offset) * dir;
            }
        }

        function getEraName() {
            var i,
                l,
                val,
                eras = this.localeData().eras();
            for (i = 0, l = eras.length; i < l; ++i) {
                // truncate time
                val = this.clone().startOf('day').valueOf();

                if (eras[i].since <= val && val <= eras[i].until) {
                    return eras[i].name;
                }
                if (eras[i].until <= val && val <= eras[i].since) {
                    return eras[i].name;
                }
            }

            return '';
        }

        function getEraNarrow() {
            var i,
                l,
                val,
                eras = this.localeData().eras();
            for (i = 0, l = eras.length; i < l; ++i) {
                // truncate time
                val = this.clone().startOf('day').valueOf();

                if (eras[i].since <= val && val <= eras[i].until) {
                    return eras[i].narrow;
                }
                if (eras[i].until <= val && val <= eras[i].since) {
                    return eras[i].narrow;
                }
            }

            return '';
        }

        function getEraAbbr() {
            var i,
                l,
                val,
                eras = this.localeData().eras();
            for (i = 0, l = eras.length; i < l; ++i) {
                // truncate time
                val = this.clone().startOf('day').valueOf();

                if (eras[i].since <= val && val <= eras[i].until) {
                    return eras[i].abbr;
                }
                if (eras[i].until <= val && val <= eras[i].since) {
                    return eras[i].abbr;
                }
            }

            return '';
        }

        function getEraYear() {
            var i,
                l,
                dir,
                val,
                eras = this.localeData().eras();
            for (i = 0, l = eras.length; i < l; ++i) {
                dir = eras[i].since <= eras[i].until ? +1 : -1;

                // truncate time
                val = this.clone().startOf('day').valueOf();

                if (
                    (eras[i].since <= val && val <= eras[i].until) ||
                    (eras[i].until <= val && val <= eras[i].since)
                ) {
                    return (
                        (this.year() - hooks(eras[i].since).year()) * dir +
                        eras[i].offset
                    );
                }
            }

            return this.year();
        }

        function erasNameRegex(isStrict) {
            if (!hasOwnProp(this, '_erasNameRegex')) {
                computeErasParse.call(this);
            }
            return isStrict ? this._erasNameRegex : this._erasRegex;
        }

        function erasAbbrRegex(isStrict) {
            if (!hasOwnProp(this, '_erasAbbrRegex')) {
                computeErasParse.call(this);
            }
            return isStrict ? this._erasAbbrRegex : this._erasRegex;
        }

        function erasNarrowRegex(isStrict) {
            if (!hasOwnProp(this, '_erasNarrowRegex')) {
                computeErasParse.call(this);
            }
            return isStrict ? this._erasNarrowRegex : this._erasRegex;
        }

        function matchEraAbbr(isStrict, locale) {
            return locale.erasAbbrRegex(isStrict);
        }

        function matchEraName(isStrict, locale) {
            return locale.erasNameRegex(isStrict);
        }

        function matchEraNarrow(isStrict, locale) {
            return locale.erasNarrowRegex(isStrict);
        }

        function matchEraYearOrdinal(isStrict, locale) {
            return locale._eraYearOrdinalRegex || matchUnsigned;
        }

        function computeErasParse() {
            var abbrPieces = [],
                namePieces = [],
                narrowPieces = [],
                mixedPieces = [],
                i,
                l,
                eras = this.eras();

            for (i = 0, l = eras.length; i < l; ++i) {
                namePieces.push(regexEscape(eras[i].name));
                abbrPieces.push(regexEscape(eras[i].abbr));
                narrowPieces.push(regexEscape(eras[i].narrow));

                mixedPieces.push(regexEscape(eras[i].name));
                mixedPieces.push(regexEscape(eras[i].abbr));
                mixedPieces.push(regexEscape(eras[i].narrow));
            }

            this._erasRegex = new RegExp('^(' + mixedPieces.join('|') + ')', 'i');
            this._erasNameRegex = new RegExp('^(' + namePieces.join('|') + ')', 'i');
            this._erasAbbrRegex = new RegExp('^(' + abbrPieces.join('|') + ')', 'i');
            this._erasNarrowRegex = new RegExp(
                '^(' + narrowPieces.join('|') + ')',
                'i'
            );
        }

        // FORMATTING

        addFormatToken(0, ['gg', 2], 0, function () {
            return this.weekYear() % 100;
        });

        addFormatToken(0, ['GG', 2], 0, function () {
            return this.isoWeekYear() % 100;
        });

        function addWeekYearFormatToken(token, getter) {
            addFormatToken(0, [token, token.length], 0, getter);
        }

        addWeekYearFormatToken('gggg', 'weekYear');
        addWeekYearFormatToken('ggggg', 'weekYear');
        addWeekYearFormatToken('GGGG', 'isoWeekYear');
        addWeekYearFormatToken('GGGGG', 'isoWeekYear');

        // ALIASES

        addUnitAlias('weekYear', 'gg');
        addUnitAlias('isoWeekYear', 'GG');

        // PRIORITY

        addUnitPriority('weekYear', 1);
        addUnitPriority('isoWeekYear', 1);

        // PARSING

        addRegexToken('G', matchSigned);
        addRegexToken('g', matchSigned);
        addRegexToken('GG', match1to2, match2);
        addRegexToken('gg', match1to2, match2);
        addRegexToken('GGGG', match1to4, match4);
        addRegexToken('gggg', match1to4, match4);
        addRegexToken('GGGGG', match1to6, match6);
        addRegexToken('ggggg', match1to6, match6);

        addWeekParseToken(['gggg', 'ggggg', 'GGGG', 'GGGGG'], function (
            input,
            week,
            config,
            token
        ) {
            week[token.substr(0, 2)] = toInt(input);
        });

        addWeekParseToken(['gg', 'GG'], function (input, week, config, token) {
            week[token] = hooks.parseTwoDigitYear(input);
        });

        // MOMENTS

        function getSetWeekYear(input) {
            return getSetWeekYearHelper.call(
                this,
                input,
                this.week(),
                this.weekday(),
                this.localeData()._week.dow,
                this.localeData()._week.doy
            );
        }

        function getSetISOWeekYear(input) {
            return getSetWeekYearHelper.call(
                this,
                input,
                this.isoWeek(),
                this.isoWeekday(),
                1,
                4
            );
        }

        function getISOWeeksInYear() {
            return weeksInYear(this.year(), 1, 4);
        }

        function getISOWeeksInISOWeekYear() {
            return weeksInYear(this.isoWeekYear(), 1, 4);
        }

        function getWeeksInYear() {
            var weekInfo = this.localeData()._week;
            return weeksInYear(this.year(), weekInfo.dow, weekInfo.doy);
        }

        function getWeeksInWeekYear() {
            var weekInfo = this.localeData()._week;
            return weeksInYear(this.weekYear(), weekInfo.dow, weekInfo.doy);
        }

        function getSetWeekYearHelper(input, week, weekday, dow, doy) {
            var weeksTarget;
            if (input == null) {
                return weekOfYear(this, dow, doy).year;
            } else {
                weeksTarget = weeksInYear(input, dow, doy);
                if (week > weeksTarget) {
                    week = weeksTarget;
                }
                return setWeekAll.call(this, input, week, weekday, dow, doy);
            }
        }

        function setWeekAll(weekYear, week, weekday, dow, doy) {
            var dayOfYearData = dayOfYearFromWeeks(weekYear, week, weekday, dow, doy),
                date = createUTCDate(dayOfYearData.year, 0, dayOfYearData.dayOfYear);

            this.year(date.getUTCFullYear());
            this.month(date.getUTCMonth());
            this.date(date.getUTCDate());
            return this;
        }

        // FORMATTING

        addFormatToken('Q', 0, 'Qo', 'quarter');

        // ALIASES

        addUnitAlias('quarter', 'Q');

        // PRIORITY

        addUnitPriority('quarter', 7);

        // PARSING

        addRegexToken('Q', match1);
        addParseToken('Q', function (input, array) {
            array[MONTH] = (toInt(input) - 1) * 3;
        });

        // MOMENTS

        function getSetQuarter(input) {
            return input == null
                ? Math.ceil((this.month() + 1) / 3)
                : this.month((input - 1) * 3 + (this.month() % 3));
        }

        // FORMATTING

        addFormatToken('D', ['DD', 2], 'Do', 'date');

        // ALIASES

        addUnitAlias('date', 'D');

        // PRIORITY
        addUnitPriority('date', 9);

        // PARSING

        addRegexToken('D', match1to2);
        addRegexToken('DD', match1to2, match2);
        addRegexToken('Do', function (isStrict, locale) {
            // TODO: Remove "ordinalParse" fallback in next major release.
            return isStrict
                ? locale._dayOfMonthOrdinalParse || locale._ordinalParse
                : locale._dayOfMonthOrdinalParseLenient;
        });

        addParseToken(['D', 'DD'], DATE);
        addParseToken('Do', function (input, array) {
            array[DATE] = toInt(input.match(match1to2)[0]);
        });

        // MOMENTS

        var getSetDayOfMonth = makeGetSet('Date', true);

        // FORMATTING

        addFormatToken('DDD', ['DDDD', 3], 'DDDo', 'dayOfYear');

        // ALIASES

        addUnitAlias('dayOfYear', 'DDD');

        // PRIORITY
        addUnitPriority('dayOfYear', 4);

        // PARSING

        addRegexToken('DDD', match1to3);
        addRegexToken('DDDD', match3);
        addParseToken(['DDD', 'DDDD'], function (input, array, config) {
            config._dayOfYear = toInt(input);
        });

        // HELPERS

        // MOMENTS

        function getSetDayOfYear(input) {
            var dayOfYear =
                Math.round(
                    (this.clone().startOf('day') - this.clone().startOf('year')) / 864e5
                ) + 1;
            return input == null ? dayOfYear : this.add(input - dayOfYear, 'd');
        }

        // FORMATTING

        addFormatToken('m', ['mm', 2], 0, 'minute');

        // ALIASES

        addUnitAlias('minute', 'm');

        // PRIORITY

        addUnitPriority('minute', 14);

        // PARSING

        addRegexToken('m', match1to2);
        addRegexToken('mm', match1to2, match2);
        addParseToken(['m', 'mm'], MINUTE);

        // MOMENTS

        var getSetMinute = makeGetSet('Minutes', false);

        // FORMATTING

        addFormatToken('s', ['ss', 2], 0, 'second');

        // ALIASES

        addUnitAlias('second', 's');

        // PRIORITY

        addUnitPriority('second', 15);

        // PARSING

        addRegexToken('s', match1to2);
        addRegexToken('ss', match1to2, match2);
        addParseToken(['s', 'ss'], SECOND);

        // MOMENTS

        var getSetSecond = makeGetSet('Seconds', false);

        // FORMATTING

        addFormatToken('S', 0, 0, function () {
            return ~~(this.millisecond() / 100);
        });

        addFormatToken(0, ['SS', 2], 0, function () {
            return ~~(this.millisecond() / 10);
        });

        addFormatToken(0, ['SSS', 3], 0, 'millisecond');
        addFormatToken(0, ['SSSS', 4], 0, function () {
            return this.millisecond() * 10;
        });
        addFormatToken(0, ['SSSSS', 5], 0, function () {
            return this.millisecond() * 100;
        });
        addFormatToken(0, ['SSSSSS', 6], 0, function () {
            return this.millisecond() * 1000;
        });
        addFormatToken(0, ['SSSSSSS', 7], 0, function () {
            return this.millisecond() * 10000;
        });
        addFormatToken(0, ['SSSSSSSS', 8], 0, function () {
            return this.millisecond() * 100000;
        });
        addFormatToken(0, ['SSSSSSSSS', 9], 0, function () {
            return this.millisecond() * 1000000;
        });

        // ALIASES

        addUnitAlias('millisecond', 'ms');

        // PRIORITY

        addUnitPriority('millisecond', 16);

        // PARSING

        addRegexToken('S', match1to3, match1);
        addRegexToken('SS', match1to3, match2);
        addRegexToken('SSS', match1to3, match3);

        var token, getSetMillisecond;
        for (token = 'SSSS'; token.length <= 9; token += 'S') {
            addRegexToken(token, matchUnsigned);
        }

        function parseMs(input, array) {
            array[MILLISECOND] = toInt(('0.' + input) * 1000);
        }

        for (token = 'S'; token.length <= 9; token += 'S') {
            addParseToken(token, parseMs);
        }

        getSetMillisecond = makeGetSet('Milliseconds', false);

        // FORMATTING

        addFormatToken('z', 0, 0, 'zoneAbbr');
        addFormatToken('zz', 0, 0, 'zoneName');

        // MOMENTS

        function getZoneAbbr() {
            return this._isUTC ? 'UTC' : '';
        }

        function getZoneName() {
            return this._isUTC ? 'Coordinated Universal Time' : '';
        }

        var proto = Moment.prototype;

        proto.add = add;
        proto.calendar = calendar$1;
        proto.clone = clone;
        proto.diff = diff;
        proto.endOf = endOf;
        proto.format = format;
        proto.from = from;
        proto.fromNow = fromNow;
        proto.to = to;
        proto.toNow = toNow;
        proto.get = stringGet;
        proto.invalidAt = invalidAt;
        proto.isAfter = isAfter;
        proto.isBefore = isBefore;
        proto.isBetween = isBetween;
        proto.isSame = isSame;
        proto.isSameOrAfter = isSameOrAfter;
        proto.isSameOrBefore = isSameOrBefore;
        proto.isValid = isValid$2;
        proto.lang = lang;
        proto.locale = locale;
        proto.localeData = localeData;
        proto.max = prototypeMax;
        proto.min = prototypeMin;
        proto.parsingFlags = parsingFlags;
        proto.set = stringSet;
        proto.startOf = startOf;
        proto.subtract = subtract;
        proto.toArray = toArray;
        proto.toObject = toObject;
        proto.toDate = toDate;
        proto.toISOString = toISOString;
        proto.inspect = inspect;
        if (typeof Symbol !== 'undefined' && Symbol.for != null) {
            proto[Symbol.for('nodejs.util.inspect.custom')] = function () {
                return 'Moment<' + this.format() + '>';
            };
        }
        proto.toJSON = toJSON;
        proto.toString = toString;
        proto.unix = unix;
        proto.valueOf = valueOf;
        proto.creationData = creationData;
        proto.eraName = getEraName;
        proto.eraNarrow = getEraNarrow;
        proto.eraAbbr = getEraAbbr;
        proto.eraYear = getEraYear;
        proto.year = getSetYear;
        proto.isLeapYear = getIsLeapYear;
        proto.weekYear = getSetWeekYear;
        proto.isoWeekYear = getSetISOWeekYear;
        proto.quarter = proto.quarters = getSetQuarter;
        proto.month = getSetMonth;
        proto.daysInMonth = getDaysInMonth;
        proto.week = proto.weeks = getSetWeek;
        proto.isoWeek = proto.isoWeeks = getSetISOWeek;
        proto.weeksInYear = getWeeksInYear;
        proto.weeksInWeekYear = getWeeksInWeekYear;
        proto.isoWeeksInYear = getISOWeeksInYear;
        proto.isoWeeksInISOWeekYear = getISOWeeksInISOWeekYear;
        proto.date = getSetDayOfMonth;
        proto.day = proto.days = getSetDayOfWeek;
        proto.weekday = getSetLocaleDayOfWeek;
        proto.isoWeekday = getSetISODayOfWeek;
        proto.dayOfYear = getSetDayOfYear;
        proto.hour = proto.hours = getSetHour;
        proto.minute = proto.minutes = getSetMinute;
        proto.second = proto.seconds = getSetSecond;
        proto.millisecond = proto.milliseconds = getSetMillisecond;
        proto.utcOffset = getSetOffset;
        proto.utc = setOffsetToUTC;
        proto.local = setOffsetToLocal;
        proto.parseZone = setOffsetToParsedOffset;
        proto.hasAlignedHourOffset = hasAlignedHourOffset;
        proto.isDST = isDaylightSavingTime;
        proto.isLocal = isLocal;
        proto.isUtcOffset = isUtcOffset;
        proto.isUtc = isUtc;
        proto.isUTC = isUtc;
        proto.zoneAbbr = getZoneAbbr;
        proto.zoneName = getZoneName;
        proto.dates = deprecate(
            'dates accessor is deprecated. Use date instead.',
            getSetDayOfMonth
        );
        proto.months = deprecate(
            'months accessor is deprecated. Use month instead',
            getSetMonth
        );
        proto.years = deprecate(
            'years accessor is deprecated. Use year instead',
            getSetYear
        );
        proto.zone = deprecate(
            'moment().zone is deprecated, use moment().utcOffset instead. http://momentjs.com/guides/#/warnings/zone/',
            getSetZone
        );
        proto.isDSTShifted = deprecate(
            'isDSTShifted is deprecated. See http://momentjs.com/guides/#/warnings/dst-shifted/ for more information',
            isDaylightSavingTimeShifted
        );

        function createUnix(input) {
            return createLocal(input * 1000);
        }

        function createInZone() {
            return createLocal.apply(null, arguments).parseZone();
        }

        function preParsePostFormat(string) {
            return string;
        }

        var proto$1 = Locale.prototype;

        proto$1.calendar = calendar;
        proto$1.longDateFormat = longDateFormat;
        proto$1.invalidDate = invalidDate;
        proto$1.ordinal = ordinal;
        proto$1.preparse = preParsePostFormat;
        proto$1.postformat = preParsePostFormat;
        proto$1.relativeTime = relativeTime;
        proto$1.pastFuture = pastFuture;
        proto$1.set = set;
        proto$1.eras = localeEras;
        proto$1.erasParse = localeErasParse;
        proto$1.erasConvertYear = localeErasConvertYear;
        proto$1.erasAbbrRegex = erasAbbrRegex;
        proto$1.erasNameRegex = erasNameRegex;
        proto$1.erasNarrowRegex = erasNarrowRegex;

        proto$1.months = localeMonths;
        proto$1.monthsShort = localeMonthsShort;
        proto$1.monthsParse = localeMonthsParse;
        proto$1.monthsRegex = monthsRegex;
        proto$1.monthsShortRegex = monthsShortRegex;
        proto$1.week = localeWeek;
        proto$1.firstDayOfYear = localeFirstDayOfYear;
        proto$1.firstDayOfWeek = localeFirstDayOfWeek;

        proto$1.weekdays = localeWeekdays;
        proto$1.weekdaysMin = localeWeekdaysMin;
        proto$1.weekdaysShort = localeWeekdaysShort;
        proto$1.weekdaysParse = localeWeekdaysParse;

        proto$1.weekdaysRegex = weekdaysRegex;
        proto$1.weekdaysShortRegex = weekdaysShortRegex;
        proto$1.weekdaysMinRegex = weekdaysMinRegex;

        proto$1.isPM = localeIsPM;
        proto$1.meridiem = localeMeridiem;

        function get$1(format, index, field, setter) {
            var locale = getLocale(),
                utc = createUTC().set(setter, index);
            return locale[field](utc, format);
        }

        function listMonthsImpl(format, index, field) {
            if (isNumber(format)) {
                index = format;
                format = undefined;
            }

            format = format || '';

            if (index != null) {
                return get$1(format, index, field, 'month');
            }

            var i,
                out = [];
            for (i = 0; i < 12; i++) {
                out[i] = get$1(format, i, field, 'month');
            }
            return out;
        }

        // ()
        // (5)
        // (fmt, 5)
        // (fmt)
        // (true)
        // (true, 5)
        // (true, fmt, 5)
        // (true, fmt)
        function listWeekdaysImpl(localeSorted, format, index, field) {
            if (typeof localeSorted === 'boolean') {
                if (isNumber(format)) {
                    index = format;
                    format = undefined;
                }

                format = format || '';
            } else {
                format = localeSorted;
                index = format;
                localeSorted = false;

                if (isNumber(format)) {
                    index = format;
                    format = undefined;
                }

                format = format || '';
            }

            var locale = getLocale(),
                shift = localeSorted ? locale._week.dow : 0,
                i,
                out = [];

            if (index != null) {
                return get$1(format, (index + shift) % 7, field, 'day');
            }

            for (i = 0; i < 7; i++) {
                out[i] = get$1(format, (i + shift) % 7, field, 'day');
            }
            return out;
        }

        function listMonths(format, index) {
            return listMonthsImpl(format, index, 'months');
        }

        function listMonthsShort(format, index) {
            return listMonthsImpl(format, index, 'monthsShort');
        }

        function listWeekdays(localeSorted, format, index) {
            return listWeekdaysImpl(localeSorted, format, index, 'weekdays');
        }

        function listWeekdaysShort(localeSorted, format, index) {
            return listWeekdaysImpl(localeSorted, format, index, 'weekdaysShort');
        }

        function listWeekdaysMin(localeSorted, format, index) {
            return listWeekdaysImpl(localeSorted, format, index, 'weekdaysMin');
        }

        getSetGlobalLocale('en', {
            eras: [
                {
                    since: '0001-01-01',
                    until: +Infinity,
                    offset: 1,
                    name: 'Anno Domini',
                    narrow: 'AD',
                    abbr: 'AD',
                },
                {
                    since: '0000-12-31',
                    until: -Infinity,
                    offset: 1,
                    name: 'Before Christ',
                    narrow: 'BC',
                    abbr: 'BC',
                },
            ],
            dayOfMonthOrdinalParse: /\d{1,2}(th|st|nd|rd)/,
            ordinal: function (number) {
                var b = number % 10,
                    output =
                        toInt((number % 100) / 10) === 1
                            ? 'th'
                            : b === 1
                            ? 'st'
                            : b === 2
                            ? 'nd'
                            : b === 3
                            ? 'rd'
                            : 'th';
                return number + output;
            },
        });

        // Side effect imports

        hooks.lang = deprecate(
            'moment.lang is deprecated. Use moment.locale instead.',
            getSetGlobalLocale
        );
        hooks.langData = deprecate(
            'moment.langData is deprecated. Use moment.localeData instead.',
            getLocale
        );

        var mathAbs = Math.abs;

        function abs() {
            var data = this._data;

            this._milliseconds = mathAbs(this._milliseconds);
            this._days = mathAbs(this._days);
            this._months = mathAbs(this._months);

            data.milliseconds = mathAbs(data.milliseconds);
            data.seconds = mathAbs(data.seconds);
            data.minutes = mathAbs(data.minutes);
            data.hours = mathAbs(data.hours);
            data.months = mathAbs(data.months);
            data.years = mathAbs(data.years);

            return this;
        }

        function addSubtract$1(duration, input, value, direction) {
            var other = createDuration(input, value);

            duration._milliseconds += direction * other._milliseconds;
            duration._days += direction * other._days;
            duration._months += direction * other._months;

            return duration._bubble();
        }

        // supports only 2.0-style add(1, 's') or add(duration)
        function add$1(input, value) {
            return addSubtract$1(this, input, value, 1);
        }

        // supports only 2.0-style subtract(1, 's') or subtract(duration)
        function subtract$1(input, value) {
            return addSubtract$1(this, input, value, -1);
        }

        function absCeil(number) {
            if (number < 0) {
                return Math.floor(number);
            } else {
                return Math.ceil(number);
            }
        }

        function bubble() {
            var milliseconds = this._milliseconds,
                days = this._days,
                months = this._months,
                data = this._data,
                seconds,
                minutes,
                hours,
                years,
                monthsFromDays;

            // if we have a mix of positive and negative values, bubble down first
            // check: https://github.com/moment/moment/issues/2166
            if (
                !(
                    (milliseconds >= 0 && days >= 0 && months >= 0) ||
                    (milliseconds <= 0 && days <= 0 && months <= 0)
                )
            ) {
                milliseconds += absCeil(monthsToDays(months) + days) * 864e5;
                days = 0;
                months = 0;
            }

            // The following code bubbles up values, see the tests for
            // examples of what that means.
            data.milliseconds = milliseconds % 1000;

            seconds = absFloor(milliseconds / 1000);
            data.seconds = seconds % 60;

            minutes = absFloor(seconds / 60);
            data.minutes = minutes % 60;

            hours = absFloor(minutes / 60);
            data.hours = hours % 24;

            days += absFloor(hours / 24);

            // convert days to months
            monthsFromDays = absFloor(daysToMonths(days));
            months += monthsFromDays;
            days -= absCeil(monthsToDays(monthsFromDays));

            // 12 months -> 1 year
            years = absFloor(months / 12);
            months %= 12;

            data.days = days;
            data.months = months;
            data.years = years;

            return this;
        }

        function daysToMonths(days) {
            // 400 years have 146097 days (taking into account leap year rules)
            // 400 years have 12 months === 4800
            return (days * 4800) / 146097;
        }

        function monthsToDays(months) {
            // the reverse of daysToMonths
            return (months * 146097) / 4800;
        }

        function as(units) {
            if (!this.isValid()) {
                return NaN;
            }
            var days,
                months,
                milliseconds = this._milliseconds;

            units = normalizeUnits(units);

            if (units === 'month' || units === 'quarter' || units === 'year') {
                days = this._days + milliseconds / 864e5;
                months = this._months + daysToMonths(days);
                switch (units) {
                    case 'month':
                        return months;
                    case 'quarter':
                        return months / 3;
                    case 'year':
                        return months / 12;
                }
            } else {
                // handle milliseconds separately because of floating point math errors (issue #1867)
                days = this._days + Math.round(monthsToDays(this._months));
                switch (units) {
                    case 'week':
                        return days / 7 + milliseconds / 6048e5;
                    case 'day':
                        return days + milliseconds / 864e5;
                    case 'hour':
                        return days * 24 + milliseconds / 36e5;
                    case 'minute':
                        return days * 1440 + milliseconds / 6e4;
                    case 'second':
                        return days * 86400 + milliseconds / 1000;
                    // Math.floor prevents floating point math errors here
                    case 'millisecond':
                        return Math.floor(days * 864e5) + milliseconds;
                    default:
                        throw new Error('Unknown unit ' + units);
                }
            }
        }

        // TODO: Use this.as('ms')?
        function valueOf$1() {
            if (!this.isValid()) {
                return NaN;
            }
            return (
                this._milliseconds +
                this._days * 864e5 +
                (this._months % 12) * 2592e6 +
                toInt(this._months / 12) * 31536e6
            );
        }

        function makeAs(alias) {
            return function () {
                return this.as(alias);
            };
        }

        var asMilliseconds = makeAs('ms'),
            asSeconds = makeAs('s'),
            asMinutes = makeAs('m'),
            asHours = makeAs('h'),
            asDays = makeAs('d'),
            asWeeks = makeAs('w'),
            asMonths = makeAs('M'),
            asQuarters = makeAs('Q'),
            asYears = makeAs('y');

        function clone$1() {
            return createDuration(this);
        }

        function get$2(units) {
            units = normalizeUnits(units);
            return this.isValid() ? this[units + 's']() : NaN;
        }

        function makeGetter(name) {
            return function () {
                return this.isValid() ? this._data[name] : NaN;
            };
        }

        var milliseconds = makeGetter('milliseconds'),
            seconds = makeGetter('seconds'),
            minutes = makeGetter('minutes'),
            hours = makeGetter('hours'),
            days = makeGetter('days'),
            months = makeGetter('months'),
            years = makeGetter('years');

        function weeks() {
            return absFloor(this.days() / 7);
        }

        var round = Math.round,
            thresholds = {
                ss: 44, // a few seconds to seconds
                s: 45, // seconds to minute
                m: 45, // minutes to hour
                h: 22, // hours to day
                d: 26, // days to month/week
                w: null, // weeks to month
                M: 11, // months to year
            };

        // helper function for moment.fn.from, moment.fn.fromNow, and moment.duration.fn.humanize
        function substituteTimeAgo(string, number, withoutSuffix, isFuture, locale) {
            return locale.relativeTime(number || 1, !!withoutSuffix, string, isFuture);
        }

        function relativeTime$1(posNegDuration, withoutSuffix, thresholds, locale) {
            var duration = createDuration(posNegDuration).abs(),
                seconds = round(duration.as('s')),
                minutes = round(duration.as('m')),
                hours = round(duration.as('h')),
                days = round(duration.as('d')),
                months = round(duration.as('M')),
                weeks = round(duration.as('w')),
                years = round(duration.as('y')),
                a =
                    (seconds <= thresholds.ss && ['s', seconds]) ||
                    (seconds < thresholds.s && ['ss', seconds]) ||
                    (minutes <= 1 && ['m']) ||
                    (minutes < thresholds.m && ['mm', minutes]) ||
                    (hours <= 1 && ['h']) ||
                    (hours < thresholds.h && ['hh', hours]) ||
                    (days <= 1 && ['d']) ||
                    (days < thresholds.d && ['dd', days]);

            if (thresholds.w != null) {
                a =
                    a ||
                    (weeks <= 1 && ['w']) ||
                    (weeks < thresholds.w && ['ww', weeks]);
            }
            a = a ||
                (months <= 1 && ['M']) ||
                (months < thresholds.M && ['MM', months]) ||
                (years <= 1 && ['y']) || ['yy', years];

            a[2] = withoutSuffix;
            a[3] = +posNegDuration > 0;
            a[4] = locale;
            return substituteTimeAgo.apply(null, a);
        }

        // This function allows you to set the rounding function for relative time strings
        function getSetRelativeTimeRounding(roundingFunction) {
            if (roundingFunction === undefined) {
                return round;
            }
            if (typeof roundingFunction === 'function') {
                round = roundingFunction;
                return true;
            }
            return false;
        }

        // This function allows you to set a threshold for relative time strings
        function getSetRelativeTimeThreshold(threshold, limit) {
            if (thresholds[threshold] === undefined) {
                return false;
            }
            if (limit === undefined) {
                return thresholds[threshold];
            }
            thresholds[threshold] = limit;
            if (threshold === 's') {
                thresholds.ss = limit - 1;
            }
            return true;
        }

        function humanize(argWithSuffix, argThresholds) {
            if (!this.isValid()) {
                return this.localeData().invalidDate();
            }

            var withSuffix = false,
                th = thresholds,
                locale,
                output;

            if (typeof argWithSuffix === 'object') {
                argThresholds = argWithSuffix;
                argWithSuffix = false;
            }
            if (typeof argWithSuffix === 'boolean') {
                withSuffix = argWithSuffix;
            }
            if (typeof argThresholds === 'object') {
                th = Object.assign({}, thresholds, argThresholds);
                if (argThresholds.s != null && argThresholds.ss == null) {
                    th.ss = argThresholds.s - 1;
                }
            }

            locale = this.localeData();
            output = relativeTime$1(this, !withSuffix, th, locale);

            if (withSuffix) {
                output = locale.pastFuture(+this, output);
            }

            return locale.postformat(output);
        }

        var abs$1 = Math.abs;

        function sign(x) {
            return (x > 0) - (x < 0) || +x;
        }

        function toISOString$1() {
            // for ISO strings we do not use the normal bubbling rules:
            //  * milliseconds bubble up until they become hours
            //  * days do not bubble at all
            //  * months bubble up until they become years
            // This is because there is no context-free conversion between hours and days
            // (think of clock changes)
            // and also not between days and months (28-31 days per month)
            if (!this.isValid()) {
                return this.localeData().invalidDate();
            }

            var seconds = abs$1(this._milliseconds) / 1000,
                days = abs$1(this._days),
                months = abs$1(this._months),
                minutes,
                hours,
                years,
                s,
                total = this.asSeconds(),
                totalSign,
                ymSign,
                daysSign,
                hmsSign;

            if (!total) {
                // this is the same as C#'s (Noda) and python (isodate)...
                // but not other JS (goog.date)
                return 'P0D';
            }

            // 3600 seconds -> 60 minutes -> 1 hour
            minutes = absFloor(seconds / 60);
            hours = absFloor(minutes / 60);
            seconds %= 60;
            minutes %= 60;

            // 12 months -> 1 year
            years = absFloor(months / 12);
            months %= 12;

            // inspired by https://github.com/dordille/moment-isoduration/blob/master/moment.isoduration.js
            s = seconds ? seconds.toFixed(3).replace(/\.?0+$/, '') : '';

            totalSign = total < 0 ? '-' : '';
            ymSign = sign(this._months) !== sign(total) ? '-' : '';
            daysSign = sign(this._days) !== sign(total) ? '-' : '';
            hmsSign = sign(this._milliseconds) !== sign(total) ? '-' : '';

            return (
                totalSign +
                'P' +
                (years ? ymSign + years + 'Y' : '') +
                (months ? ymSign + months + 'M' : '') +
                (days ? daysSign + days + 'D' : '') +
                (hours || minutes || seconds ? 'T' : '') +
                (hours ? hmsSign + hours + 'H' : '') +
                (minutes ? hmsSign + minutes + 'M' : '') +
                (seconds ? hmsSign + s + 'S' : '')
            );
        }

        var proto$2 = Duration.prototype;

        proto$2.isValid = isValid$1;
        proto$2.abs = abs;
        proto$2.add = add$1;
        proto$2.subtract = subtract$1;
        proto$2.as = as;
        proto$2.asMilliseconds = asMilliseconds;
        proto$2.asSeconds = asSeconds;
        proto$2.asMinutes = asMinutes;
        proto$2.asHours = asHours;
        proto$2.asDays = asDays;
        proto$2.asWeeks = asWeeks;
        proto$2.asMonths = asMonths;
        proto$2.asQuarters = asQuarters;
        proto$2.asYears = asYears;
        proto$2.valueOf = valueOf$1;
        proto$2._bubble = bubble;
        proto$2.clone = clone$1;
        proto$2.get = get$2;
        proto$2.milliseconds = milliseconds;
        proto$2.seconds = seconds;
        proto$2.minutes = minutes;
        proto$2.hours = hours;
        proto$2.days = days;
        proto$2.weeks = weeks;
        proto$2.months = months;
        proto$2.years = years;
        proto$2.humanize = humanize;
        proto$2.toISOString = toISOString$1;
        proto$2.toString = toISOString$1;
        proto$2.toJSON = toISOString$1;
        proto$2.locale = locale;
        proto$2.localeData = localeData;

        proto$2.toIsoString = deprecate(
            'toIsoString() is deprecated. Please use toISOString() instead (notice the capitals)',
            toISOString$1
        );
        proto$2.lang = lang;

        // FORMATTING

        addFormatToken('X', 0, 0, 'unix');
        addFormatToken('x', 0, 0, 'valueOf');

        // PARSING

        addRegexToken('x', matchSigned);
        addRegexToken('X', matchTimestamp);
        addParseToken('X', function (input, array, config) {
            config._d = new Date(parseFloat(input) * 1000);
        });
        addParseToken('x', function (input, array, config) {
            config._d = new Date(toInt(input));
        });

        //! moment.js

        hooks.version = '2.29.1';

        setHookCallback(createLocal);

        hooks.fn = proto;
        hooks.min = min;
        hooks.max = max;
        hooks.now = now;
        hooks.utc = createUTC;
        hooks.unix = createUnix;
        hooks.months = listMonths;
        hooks.isDate = isDate;
        hooks.locale = getSetGlobalLocale;
        hooks.invalid = createInvalid;
        hooks.duration = createDuration;
        hooks.isMoment = isMoment;
        hooks.weekdays = listWeekdays;
        hooks.parseZone = createInZone;
        hooks.localeData = getLocale;
        hooks.isDuration = isDuration;
        hooks.monthsShort = listMonthsShort;
        hooks.weekdaysMin = listWeekdaysMin;
        hooks.defineLocale = defineLocale;
        hooks.updateLocale = updateLocale;
        hooks.locales = listLocales;
        hooks.weekdaysShort = listWeekdaysShort;
        hooks.normalizeUnits = normalizeUnits;
        hooks.relativeTimeRounding = getSetRelativeTimeRounding;
        hooks.relativeTimeThreshold = getSetRelativeTimeThreshold;
        hooks.calendarFormat = getCalendarFormat;
        hooks.prototype = proto;

        // currently HTML5 input type only supports 24-hour formats
        hooks.HTML5_FMT = {
            DATETIME_LOCAL: 'YYYY-MM-DDTHH:mm', // <input type="datetime-local" />
            DATETIME_LOCAL_SECONDS: 'YYYY-MM-DDTHH:mm:ss', // <input type="datetime-local" step="1" />
            DATETIME_LOCAL_MS: 'YYYY-MM-DDTHH:mm:ss.SSS', // <input type="datetime-local" step="0.001" />
            DATE: 'YYYY-MM-DD', // <input type="date" />
            TIME: 'HH:mm', // <input type="time" />
            TIME_SECONDS: 'HH:mm:ss', // <input type="time" step="1" />
            TIME_MS: 'HH:mm:ss.SSS', // <input type="time" step="0.001" />
            WEEK: 'GGGG-[W]WW', // <input type="week" />
            MONTH: 'YYYY-MM', // <input type="month" />
        };

        return hooks;

    })));
    });

    /*!
     * Chart.js v2.9.4
     * https://www.chartjs.org
     * (c) 2020 Chart.js Contributors
     * Released under the MIT License
     */

    var Chart = createCommonjsModule(function (module, exports) {
    (function (global, factory) {
    module.exports = factory(function() { try { return moment; } catch(e) { } }()) ;
    }(commonjsGlobal, (function (moment) {
    moment = moment && moment.hasOwnProperty('default') ? moment['default'] : moment;

    function createCommonjsModule(fn, module) {
    	return module = { exports: {} }, fn(module, module.exports), module.exports;
    }

    function getCjsExportFromNamespace (n) {
    	return n && n['default'] || n;
    }

    var colorName = {
    	"aliceblue": [240, 248, 255],
    	"antiquewhite": [250, 235, 215],
    	"aqua": [0, 255, 255],
    	"aquamarine": [127, 255, 212],
    	"azure": [240, 255, 255],
    	"beige": [245, 245, 220],
    	"bisque": [255, 228, 196],
    	"black": [0, 0, 0],
    	"blanchedalmond": [255, 235, 205],
    	"blue": [0, 0, 255],
    	"blueviolet": [138, 43, 226],
    	"brown": [165, 42, 42],
    	"burlywood": [222, 184, 135],
    	"cadetblue": [95, 158, 160],
    	"chartreuse": [127, 255, 0],
    	"chocolate": [210, 105, 30],
    	"coral": [255, 127, 80],
    	"cornflowerblue": [100, 149, 237],
    	"cornsilk": [255, 248, 220],
    	"crimson": [220, 20, 60],
    	"cyan": [0, 255, 255],
    	"darkblue": [0, 0, 139],
    	"darkcyan": [0, 139, 139],
    	"darkgoldenrod": [184, 134, 11],
    	"darkgray": [169, 169, 169],
    	"darkgreen": [0, 100, 0],
    	"darkgrey": [169, 169, 169],
    	"darkkhaki": [189, 183, 107],
    	"darkmagenta": [139, 0, 139],
    	"darkolivegreen": [85, 107, 47],
    	"darkorange": [255, 140, 0],
    	"darkorchid": [153, 50, 204],
    	"darkred": [139, 0, 0],
    	"darksalmon": [233, 150, 122],
    	"darkseagreen": [143, 188, 143],
    	"darkslateblue": [72, 61, 139],
    	"darkslategray": [47, 79, 79],
    	"darkslategrey": [47, 79, 79],
    	"darkturquoise": [0, 206, 209],
    	"darkviolet": [148, 0, 211],
    	"deeppink": [255, 20, 147],
    	"deepskyblue": [0, 191, 255],
    	"dimgray": [105, 105, 105],
    	"dimgrey": [105, 105, 105],
    	"dodgerblue": [30, 144, 255],
    	"firebrick": [178, 34, 34],
    	"floralwhite": [255, 250, 240],
    	"forestgreen": [34, 139, 34],
    	"fuchsia": [255, 0, 255],
    	"gainsboro": [220, 220, 220],
    	"ghostwhite": [248, 248, 255],
    	"gold": [255, 215, 0],
    	"goldenrod": [218, 165, 32],
    	"gray": [128, 128, 128],
    	"green": [0, 128, 0],
    	"greenyellow": [173, 255, 47],
    	"grey": [128, 128, 128],
    	"honeydew": [240, 255, 240],
    	"hotpink": [255, 105, 180],
    	"indianred": [205, 92, 92],
    	"indigo": [75, 0, 130],
    	"ivory": [255, 255, 240],
    	"khaki": [240, 230, 140],
    	"lavender": [230, 230, 250],
    	"lavenderblush": [255, 240, 245],
    	"lawngreen": [124, 252, 0],
    	"lemonchiffon": [255, 250, 205],
    	"lightblue": [173, 216, 230],
    	"lightcoral": [240, 128, 128],
    	"lightcyan": [224, 255, 255],
    	"lightgoldenrodyellow": [250, 250, 210],
    	"lightgray": [211, 211, 211],
    	"lightgreen": [144, 238, 144],
    	"lightgrey": [211, 211, 211],
    	"lightpink": [255, 182, 193],
    	"lightsalmon": [255, 160, 122],
    	"lightseagreen": [32, 178, 170],
    	"lightskyblue": [135, 206, 250],
    	"lightslategray": [119, 136, 153],
    	"lightslategrey": [119, 136, 153],
    	"lightsteelblue": [176, 196, 222],
    	"lightyellow": [255, 255, 224],
    	"lime": [0, 255, 0],
    	"limegreen": [50, 205, 50],
    	"linen": [250, 240, 230],
    	"magenta": [255, 0, 255],
    	"maroon": [128, 0, 0],
    	"mediumaquamarine": [102, 205, 170],
    	"mediumblue": [0, 0, 205],
    	"mediumorchid": [186, 85, 211],
    	"mediumpurple": [147, 112, 219],
    	"mediumseagreen": [60, 179, 113],
    	"mediumslateblue": [123, 104, 238],
    	"mediumspringgreen": [0, 250, 154],
    	"mediumturquoise": [72, 209, 204],
    	"mediumvioletred": [199, 21, 133],
    	"midnightblue": [25, 25, 112],
    	"mintcream": [245, 255, 250],
    	"mistyrose": [255, 228, 225],
    	"moccasin": [255, 228, 181],
    	"navajowhite": [255, 222, 173],
    	"navy": [0, 0, 128],
    	"oldlace": [253, 245, 230],
    	"olive": [128, 128, 0],
    	"olivedrab": [107, 142, 35],
    	"orange": [255, 165, 0],
    	"orangered": [255, 69, 0],
    	"orchid": [218, 112, 214],
    	"palegoldenrod": [238, 232, 170],
    	"palegreen": [152, 251, 152],
    	"paleturquoise": [175, 238, 238],
    	"palevioletred": [219, 112, 147],
    	"papayawhip": [255, 239, 213],
    	"peachpuff": [255, 218, 185],
    	"peru": [205, 133, 63],
    	"pink": [255, 192, 203],
    	"plum": [221, 160, 221],
    	"powderblue": [176, 224, 230],
    	"purple": [128, 0, 128],
    	"rebeccapurple": [102, 51, 153],
    	"red": [255, 0, 0],
    	"rosybrown": [188, 143, 143],
    	"royalblue": [65, 105, 225],
    	"saddlebrown": [139, 69, 19],
    	"salmon": [250, 128, 114],
    	"sandybrown": [244, 164, 96],
    	"seagreen": [46, 139, 87],
    	"seashell": [255, 245, 238],
    	"sienna": [160, 82, 45],
    	"silver": [192, 192, 192],
    	"skyblue": [135, 206, 235],
    	"slateblue": [106, 90, 205],
    	"slategray": [112, 128, 144],
    	"slategrey": [112, 128, 144],
    	"snow": [255, 250, 250],
    	"springgreen": [0, 255, 127],
    	"steelblue": [70, 130, 180],
    	"tan": [210, 180, 140],
    	"teal": [0, 128, 128],
    	"thistle": [216, 191, 216],
    	"tomato": [255, 99, 71],
    	"turquoise": [64, 224, 208],
    	"violet": [238, 130, 238],
    	"wheat": [245, 222, 179],
    	"white": [255, 255, 255],
    	"whitesmoke": [245, 245, 245],
    	"yellow": [255, 255, 0],
    	"yellowgreen": [154, 205, 50]
    };

    var conversions = createCommonjsModule(function (module) {
    /* MIT license */


    // NOTE: conversions should only return primitive values (i.e. arrays, or
    //       values that give correct `typeof` results).
    //       do not use box values types (i.e. Number(), String(), etc.)

    var reverseKeywords = {};
    for (var key in colorName) {
    	if (colorName.hasOwnProperty(key)) {
    		reverseKeywords[colorName[key]] = key;
    	}
    }

    var convert = module.exports = {
    	rgb: {channels: 3, labels: 'rgb'},
    	hsl: {channels: 3, labels: 'hsl'},
    	hsv: {channels: 3, labels: 'hsv'},
    	hwb: {channels: 3, labels: 'hwb'},
    	cmyk: {channels: 4, labels: 'cmyk'},
    	xyz: {channels: 3, labels: 'xyz'},
    	lab: {channels: 3, labels: 'lab'},
    	lch: {channels: 3, labels: 'lch'},
    	hex: {channels: 1, labels: ['hex']},
    	keyword: {channels: 1, labels: ['keyword']},
    	ansi16: {channels: 1, labels: ['ansi16']},
    	ansi256: {channels: 1, labels: ['ansi256']},
    	hcg: {channels: 3, labels: ['h', 'c', 'g']},
    	apple: {channels: 3, labels: ['r16', 'g16', 'b16']},
    	gray: {channels: 1, labels: ['gray']}
    };

    // hide .channels and .labels properties
    for (var model in convert) {
    	if (convert.hasOwnProperty(model)) {
    		if (!('channels' in convert[model])) {
    			throw new Error('missing channels property: ' + model);
    		}

    		if (!('labels' in convert[model])) {
    			throw new Error('missing channel labels property: ' + model);
    		}

    		if (convert[model].labels.length !== convert[model].channels) {
    			throw new Error('channel and label counts mismatch: ' + model);
    		}

    		var channels = convert[model].channels;
    		var labels = convert[model].labels;
    		delete convert[model].channels;
    		delete convert[model].labels;
    		Object.defineProperty(convert[model], 'channels', {value: channels});
    		Object.defineProperty(convert[model], 'labels', {value: labels});
    	}
    }

    convert.rgb.hsl = function (rgb) {
    	var r = rgb[0] / 255;
    	var g = rgb[1] / 255;
    	var b = rgb[2] / 255;
    	var min = Math.min(r, g, b);
    	var max = Math.max(r, g, b);
    	var delta = max - min;
    	var h;
    	var s;
    	var l;

    	if (max === min) {
    		h = 0;
    	} else if (r === max) {
    		h = (g - b) / delta;
    	} else if (g === max) {
    		h = 2 + (b - r) / delta;
    	} else if (b === max) {
    		h = 4 + (r - g) / delta;
    	}

    	h = Math.min(h * 60, 360);

    	if (h < 0) {
    		h += 360;
    	}

    	l = (min + max) / 2;

    	if (max === min) {
    		s = 0;
    	} else if (l <= 0.5) {
    		s = delta / (max + min);
    	} else {
    		s = delta / (2 - max - min);
    	}

    	return [h, s * 100, l * 100];
    };

    convert.rgb.hsv = function (rgb) {
    	var rdif;
    	var gdif;
    	var bdif;
    	var h;
    	var s;

    	var r = rgb[0] / 255;
    	var g = rgb[1] / 255;
    	var b = rgb[2] / 255;
    	var v = Math.max(r, g, b);
    	var diff = v - Math.min(r, g, b);
    	var diffc = function (c) {
    		return (v - c) / 6 / diff + 1 / 2;
    	};

    	if (diff === 0) {
    		h = s = 0;
    	} else {
    		s = diff / v;
    		rdif = diffc(r);
    		gdif = diffc(g);
    		bdif = diffc(b);

    		if (r === v) {
    			h = bdif - gdif;
    		} else if (g === v) {
    			h = (1 / 3) + rdif - bdif;
    		} else if (b === v) {
    			h = (2 / 3) + gdif - rdif;
    		}
    		if (h < 0) {
    			h += 1;
    		} else if (h > 1) {
    			h -= 1;
    		}
    	}

    	return [
    		h * 360,
    		s * 100,
    		v * 100
    	];
    };

    convert.rgb.hwb = function (rgb) {
    	var r = rgb[0];
    	var g = rgb[1];
    	var b = rgb[2];
    	var h = convert.rgb.hsl(rgb)[0];
    	var w = 1 / 255 * Math.min(r, Math.min(g, b));

    	b = 1 - 1 / 255 * Math.max(r, Math.max(g, b));

    	return [h, w * 100, b * 100];
    };

    convert.rgb.cmyk = function (rgb) {
    	var r = rgb[0] / 255;
    	var g = rgb[1] / 255;
    	var b = rgb[2] / 255;
    	var c;
    	var m;
    	var y;
    	var k;

    	k = Math.min(1 - r, 1 - g, 1 - b);
    	c = (1 - r - k) / (1 - k) || 0;
    	m = (1 - g - k) / (1 - k) || 0;
    	y = (1 - b - k) / (1 - k) || 0;

    	return [c * 100, m * 100, y * 100, k * 100];
    };

    /**
     * See https://en.m.wikipedia.org/wiki/Euclidean_distance#Squared_Euclidean_distance
     * */
    function comparativeDistance(x, y) {
    	return (
    		Math.pow(x[0] - y[0], 2) +
    		Math.pow(x[1] - y[1], 2) +
    		Math.pow(x[2] - y[2], 2)
    	);
    }

    convert.rgb.keyword = function (rgb) {
    	var reversed = reverseKeywords[rgb];
    	if (reversed) {
    		return reversed;
    	}

    	var currentClosestDistance = Infinity;
    	var currentClosestKeyword;

    	for (var keyword in colorName) {
    		if (colorName.hasOwnProperty(keyword)) {
    			var value = colorName[keyword];

    			// Compute comparative distance
    			var distance = comparativeDistance(rgb, value);

    			// Check if its less, if so set as closest
    			if (distance < currentClosestDistance) {
    				currentClosestDistance = distance;
    				currentClosestKeyword = keyword;
    			}
    		}
    	}

    	return currentClosestKeyword;
    };

    convert.keyword.rgb = function (keyword) {
    	return colorName[keyword];
    };

    convert.rgb.xyz = function (rgb) {
    	var r = rgb[0] / 255;
    	var g = rgb[1] / 255;
    	var b = rgb[2] / 255;

    	// assume sRGB
    	r = r > 0.04045 ? Math.pow(((r + 0.055) / 1.055), 2.4) : (r / 12.92);
    	g = g > 0.04045 ? Math.pow(((g + 0.055) / 1.055), 2.4) : (g / 12.92);
    	b = b > 0.04045 ? Math.pow(((b + 0.055) / 1.055), 2.4) : (b / 12.92);

    	var x = (r * 0.4124) + (g * 0.3576) + (b * 0.1805);
    	var y = (r * 0.2126) + (g * 0.7152) + (b * 0.0722);
    	var z = (r * 0.0193) + (g * 0.1192) + (b * 0.9505);

    	return [x * 100, y * 100, z * 100];
    };

    convert.rgb.lab = function (rgb) {
    	var xyz = convert.rgb.xyz(rgb);
    	var x = xyz[0];
    	var y = xyz[1];
    	var z = xyz[2];
    	var l;
    	var a;
    	var b;

    	x /= 95.047;
    	y /= 100;
    	z /= 108.883;

    	x = x > 0.008856 ? Math.pow(x, 1 / 3) : (7.787 * x) + (16 / 116);
    	y = y > 0.008856 ? Math.pow(y, 1 / 3) : (7.787 * y) + (16 / 116);
    	z = z > 0.008856 ? Math.pow(z, 1 / 3) : (7.787 * z) + (16 / 116);

    	l = (116 * y) - 16;
    	a = 500 * (x - y);
    	b = 200 * (y - z);

    	return [l, a, b];
    };

    convert.hsl.rgb = function (hsl) {
    	var h = hsl[0] / 360;
    	var s = hsl[1] / 100;
    	var l = hsl[2] / 100;
    	var t1;
    	var t2;
    	var t3;
    	var rgb;
    	var val;

    	if (s === 0) {
    		val = l * 255;
    		return [val, val, val];
    	}

    	if (l < 0.5) {
    		t2 = l * (1 + s);
    	} else {
    		t2 = l + s - l * s;
    	}

    	t1 = 2 * l - t2;

    	rgb = [0, 0, 0];
    	for (var i = 0; i < 3; i++) {
    		t3 = h + 1 / 3 * -(i - 1);
    		if (t3 < 0) {
    			t3++;
    		}
    		if (t3 > 1) {
    			t3--;
    		}

    		if (6 * t3 < 1) {
    			val = t1 + (t2 - t1) * 6 * t3;
    		} else if (2 * t3 < 1) {
    			val = t2;
    		} else if (3 * t3 < 2) {
    			val = t1 + (t2 - t1) * (2 / 3 - t3) * 6;
    		} else {
    			val = t1;
    		}

    		rgb[i] = val * 255;
    	}

    	return rgb;
    };

    convert.hsl.hsv = function (hsl) {
    	var h = hsl[0];
    	var s = hsl[1] / 100;
    	var l = hsl[2] / 100;
    	var smin = s;
    	var lmin = Math.max(l, 0.01);
    	var sv;
    	var v;

    	l *= 2;
    	s *= (l <= 1) ? l : 2 - l;
    	smin *= lmin <= 1 ? lmin : 2 - lmin;
    	v = (l + s) / 2;
    	sv = l === 0 ? (2 * smin) / (lmin + smin) : (2 * s) / (l + s);

    	return [h, sv * 100, v * 100];
    };

    convert.hsv.rgb = function (hsv) {
    	var h = hsv[0] / 60;
    	var s = hsv[1] / 100;
    	var v = hsv[2] / 100;
    	var hi = Math.floor(h) % 6;

    	var f = h - Math.floor(h);
    	var p = 255 * v * (1 - s);
    	var q = 255 * v * (1 - (s * f));
    	var t = 255 * v * (1 - (s * (1 - f)));
    	v *= 255;

    	switch (hi) {
    		case 0:
    			return [v, t, p];
    		case 1:
    			return [q, v, p];
    		case 2:
    			return [p, v, t];
    		case 3:
    			return [p, q, v];
    		case 4:
    			return [t, p, v];
    		case 5:
    			return [v, p, q];
    	}
    };

    convert.hsv.hsl = function (hsv) {
    	var h = hsv[0];
    	var s = hsv[1] / 100;
    	var v = hsv[2] / 100;
    	var vmin = Math.max(v, 0.01);
    	var lmin;
    	var sl;
    	var l;

    	l = (2 - s) * v;
    	lmin = (2 - s) * vmin;
    	sl = s * vmin;
    	sl /= (lmin <= 1) ? lmin : 2 - lmin;
    	sl = sl || 0;
    	l /= 2;

    	return [h, sl * 100, l * 100];
    };

    // http://dev.w3.org/csswg/css-color/#hwb-to-rgb
    convert.hwb.rgb = function (hwb) {
    	var h = hwb[0] / 360;
    	var wh = hwb[1] / 100;
    	var bl = hwb[2] / 100;
    	var ratio = wh + bl;
    	var i;
    	var v;
    	var f;
    	var n;

    	// wh + bl cant be > 1
    	if (ratio > 1) {
    		wh /= ratio;
    		bl /= ratio;
    	}

    	i = Math.floor(6 * h);
    	v = 1 - bl;
    	f = 6 * h - i;

    	if ((i & 0x01) !== 0) {
    		f = 1 - f;
    	}

    	n = wh + f * (v - wh); // linear interpolation

    	var r;
    	var g;
    	var b;
    	switch (i) {
    		default:
    		case 6:
    		case 0: r = v; g = n; b = wh; break;
    		case 1: r = n; g = v; b = wh; break;
    		case 2: r = wh; g = v; b = n; break;
    		case 3: r = wh; g = n; b = v; break;
    		case 4: r = n; g = wh; b = v; break;
    		case 5: r = v; g = wh; b = n; break;
    	}

    	return [r * 255, g * 255, b * 255];
    };

    convert.cmyk.rgb = function (cmyk) {
    	var c = cmyk[0] / 100;
    	var m = cmyk[1] / 100;
    	var y = cmyk[2] / 100;
    	var k = cmyk[3] / 100;
    	var r;
    	var g;
    	var b;

    	r = 1 - Math.min(1, c * (1 - k) + k);
    	g = 1 - Math.min(1, m * (1 - k) + k);
    	b = 1 - Math.min(1, y * (1 - k) + k);

    	return [r * 255, g * 255, b * 255];
    };

    convert.xyz.rgb = function (xyz) {
    	var x = xyz[0] / 100;
    	var y = xyz[1] / 100;
    	var z = xyz[2] / 100;
    	var r;
    	var g;
    	var b;

    	r = (x * 3.2406) + (y * -1.5372) + (z * -0.4986);
    	g = (x * -0.9689) + (y * 1.8758) + (z * 0.0415);
    	b = (x * 0.0557) + (y * -0.2040) + (z * 1.0570);

    	// assume sRGB
    	r = r > 0.0031308
    		? ((1.055 * Math.pow(r, 1.0 / 2.4)) - 0.055)
    		: r * 12.92;

    	g = g > 0.0031308
    		? ((1.055 * Math.pow(g, 1.0 / 2.4)) - 0.055)
    		: g * 12.92;

    	b = b > 0.0031308
    		? ((1.055 * Math.pow(b, 1.0 / 2.4)) - 0.055)
    		: b * 12.92;

    	r = Math.min(Math.max(0, r), 1);
    	g = Math.min(Math.max(0, g), 1);
    	b = Math.min(Math.max(0, b), 1);

    	return [r * 255, g * 255, b * 255];
    };

    convert.xyz.lab = function (xyz) {
    	var x = xyz[0];
    	var y = xyz[1];
    	var z = xyz[2];
    	var l;
    	var a;
    	var b;

    	x /= 95.047;
    	y /= 100;
    	z /= 108.883;

    	x = x > 0.008856 ? Math.pow(x, 1 / 3) : (7.787 * x) + (16 / 116);
    	y = y > 0.008856 ? Math.pow(y, 1 / 3) : (7.787 * y) + (16 / 116);
    	z = z > 0.008856 ? Math.pow(z, 1 / 3) : (7.787 * z) + (16 / 116);

    	l = (116 * y) - 16;
    	a = 500 * (x - y);
    	b = 200 * (y - z);

    	return [l, a, b];
    };

    convert.lab.xyz = function (lab) {
    	var l = lab[0];
    	var a = lab[1];
    	var b = lab[2];
    	var x;
    	var y;
    	var z;

    	y = (l + 16) / 116;
    	x = a / 500 + y;
    	z = y - b / 200;

    	var y2 = Math.pow(y, 3);
    	var x2 = Math.pow(x, 3);
    	var z2 = Math.pow(z, 3);
    	y = y2 > 0.008856 ? y2 : (y - 16 / 116) / 7.787;
    	x = x2 > 0.008856 ? x2 : (x - 16 / 116) / 7.787;
    	z = z2 > 0.008856 ? z2 : (z - 16 / 116) / 7.787;

    	x *= 95.047;
    	y *= 100;
    	z *= 108.883;

    	return [x, y, z];
    };

    convert.lab.lch = function (lab) {
    	var l = lab[0];
    	var a = lab[1];
    	var b = lab[2];
    	var hr;
    	var h;
    	var c;

    	hr = Math.atan2(b, a);
    	h = hr * 360 / 2 / Math.PI;

    	if (h < 0) {
    		h += 360;
    	}

    	c = Math.sqrt(a * a + b * b);

    	return [l, c, h];
    };

    convert.lch.lab = function (lch) {
    	var l = lch[0];
    	var c = lch[1];
    	var h = lch[2];
    	var a;
    	var b;
    	var hr;

    	hr = h / 360 * 2 * Math.PI;
    	a = c * Math.cos(hr);
    	b = c * Math.sin(hr);

    	return [l, a, b];
    };

    convert.rgb.ansi16 = function (args) {
    	var r = args[0];
    	var g = args[1];
    	var b = args[2];
    	var value = 1 in arguments ? arguments[1] : convert.rgb.hsv(args)[2]; // hsv -> ansi16 optimization

    	value = Math.round(value / 50);

    	if (value === 0) {
    		return 30;
    	}

    	var ansi = 30
    		+ ((Math.round(b / 255) << 2)
    		| (Math.round(g / 255) << 1)
    		| Math.round(r / 255));

    	if (value === 2) {
    		ansi += 60;
    	}

    	return ansi;
    };

    convert.hsv.ansi16 = function (args) {
    	// optimization here; we already know the value and don't need to get
    	// it converted for us.
    	return convert.rgb.ansi16(convert.hsv.rgb(args), args[2]);
    };

    convert.rgb.ansi256 = function (args) {
    	var r = args[0];
    	var g = args[1];
    	var b = args[2];

    	// we use the extended greyscale palette here, with the exception of
    	// black and white. normal palette only has 4 greyscale shades.
    	if (r === g && g === b) {
    		if (r < 8) {
    			return 16;
    		}

    		if (r > 248) {
    			return 231;
    		}

    		return Math.round(((r - 8) / 247) * 24) + 232;
    	}

    	var ansi = 16
    		+ (36 * Math.round(r / 255 * 5))
    		+ (6 * Math.round(g / 255 * 5))
    		+ Math.round(b / 255 * 5);

    	return ansi;
    };

    convert.ansi16.rgb = function (args) {
    	var color = args % 10;

    	// handle greyscale
    	if (color === 0 || color === 7) {
    		if (args > 50) {
    			color += 3.5;
    		}

    		color = color / 10.5 * 255;

    		return [color, color, color];
    	}

    	var mult = (~~(args > 50) + 1) * 0.5;
    	var r = ((color & 1) * mult) * 255;
    	var g = (((color >> 1) & 1) * mult) * 255;
    	var b = (((color >> 2) & 1) * mult) * 255;

    	return [r, g, b];
    };

    convert.ansi256.rgb = function (args) {
    	// handle greyscale
    	if (args >= 232) {
    		var c = (args - 232) * 10 + 8;
    		return [c, c, c];
    	}

    	args -= 16;

    	var rem;
    	var r = Math.floor(args / 36) / 5 * 255;
    	var g = Math.floor((rem = args % 36) / 6) / 5 * 255;
    	var b = (rem % 6) / 5 * 255;

    	return [r, g, b];
    };

    convert.rgb.hex = function (args) {
    	var integer = ((Math.round(args[0]) & 0xFF) << 16)
    		+ ((Math.round(args[1]) & 0xFF) << 8)
    		+ (Math.round(args[2]) & 0xFF);

    	var string = integer.toString(16).toUpperCase();
    	return '000000'.substring(string.length) + string;
    };

    convert.hex.rgb = function (args) {
    	var match = args.toString(16).match(/[a-f0-9]{6}|[a-f0-9]{3}/i);
    	if (!match) {
    		return [0, 0, 0];
    	}

    	var colorString = match[0];

    	if (match[0].length === 3) {
    		colorString = colorString.split('').map(function (char) {
    			return char + char;
    		}).join('');
    	}

    	var integer = parseInt(colorString, 16);
    	var r = (integer >> 16) & 0xFF;
    	var g = (integer >> 8) & 0xFF;
    	var b = integer & 0xFF;

    	return [r, g, b];
    };

    convert.rgb.hcg = function (rgb) {
    	var r = rgb[0] / 255;
    	var g = rgb[1] / 255;
    	var b = rgb[2] / 255;
    	var max = Math.max(Math.max(r, g), b);
    	var min = Math.min(Math.min(r, g), b);
    	var chroma = (max - min);
    	var grayscale;
    	var hue;

    	if (chroma < 1) {
    		grayscale = min / (1 - chroma);
    	} else {
    		grayscale = 0;
    	}

    	if (chroma <= 0) {
    		hue = 0;
    	} else
    	if (max === r) {
    		hue = ((g - b) / chroma) % 6;
    	} else
    	if (max === g) {
    		hue = 2 + (b - r) / chroma;
    	} else {
    		hue = 4 + (r - g) / chroma + 4;
    	}

    	hue /= 6;
    	hue %= 1;

    	return [hue * 360, chroma * 100, grayscale * 100];
    };

    convert.hsl.hcg = function (hsl) {
    	var s = hsl[1] / 100;
    	var l = hsl[2] / 100;
    	var c = 1;
    	var f = 0;

    	if (l < 0.5) {
    		c = 2.0 * s * l;
    	} else {
    		c = 2.0 * s * (1.0 - l);
    	}

    	if (c < 1.0) {
    		f = (l - 0.5 * c) / (1.0 - c);
    	}

    	return [hsl[0], c * 100, f * 100];
    };

    convert.hsv.hcg = function (hsv) {
    	var s = hsv[1] / 100;
    	var v = hsv[2] / 100;

    	var c = s * v;
    	var f = 0;

    	if (c < 1.0) {
    		f = (v - c) / (1 - c);
    	}

    	return [hsv[0], c * 100, f * 100];
    };

    convert.hcg.rgb = function (hcg) {
    	var h = hcg[0] / 360;
    	var c = hcg[1] / 100;
    	var g = hcg[2] / 100;

    	if (c === 0.0) {
    		return [g * 255, g * 255, g * 255];
    	}

    	var pure = [0, 0, 0];
    	var hi = (h % 1) * 6;
    	var v = hi % 1;
    	var w = 1 - v;
    	var mg = 0;

    	switch (Math.floor(hi)) {
    		case 0:
    			pure[0] = 1; pure[1] = v; pure[2] = 0; break;
    		case 1:
    			pure[0] = w; pure[1] = 1; pure[2] = 0; break;
    		case 2:
    			pure[0] = 0; pure[1] = 1; pure[2] = v; break;
    		case 3:
    			pure[0] = 0; pure[1] = w; pure[2] = 1; break;
    		case 4:
    			pure[0] = v; pure[1] = 0; pure[2] = 1; break;
    		default:
    			pure[0] = 1; pure[1] = 0; pure[2] = w;
    	}

    	mg = (1.0 - c) * g;

    	return [
    		(c * pure[0] + mg) * 255,
    		(c * pure[1] + mg) * 255,
    		(c * pure[2] + mg) * 255
    	];
    };

    convert.hcg.hsv = function (hcg) {
    	var c = hcg[1] / 100;
    	var g = hcg[2] / 100;

    	var v = c + g * (1.0 - c);
    	var f = 0;

    	if (v > 0.0) {
    		f = c / v;
    	}

    	return [hcg[0], f * 100, v * 100];
    };

    convert.hcg.hsl = function (hcg) {
    	var c = hcg[1] / 100;
    	var g = hcg[2] / 100;

    	var l = g * (1.0 - c) + 0.5 * c;
    	var s = 0;

    	if (l > 0.0 && l < 0.5) {
    		s = c / (2 * l);
    	} else
    	if (l >= 0.5 && l < 1.0) {
    		s = c / (2 * (1 - l));
    	}

    	return [hcg[0], s * 100, l * 100];
    };

    convert.hcg.hwb = function (hcg) {
    	var c = hcg[1] / 100;
    	var g = hcg[2] / 100;
    	var v = c + g * (1.0 - c);
    	return [hcg[0], (v - c) * 100, (1 - v) * 100];
    };

    convert.hwb.hcg = function (hwb) {
    	var w = hwb[1] / 100;
    	var b = hwb[2] / 100;
    	var v = 1 - b;
    	var c = v - w;
    	var g = 0;

    	if (c < 1) {
    		g = (v - c) / (1 - c);
    	}

    	return [hwb[0], c * 100, g * 100];
    };

    convert.apple.rgb = function (apple) {
    	return [(apple[0] / 65535) * 255, (apple[1] / 65535) * 255, (apple[2] / 65535) * 255];
    };

    convert.rgb.apple = function (rgb) {
    	return [(rgb[0] / 255) * 65535, (rgb[1] / 255) * 65535, (rgb[2] / 255) * 65535];
    };

    convert.gray.rgb = function (args) {
    	return [args[0] / 100 * 255, args[0] / 100 * 255, args[0] / 100 * 255];
    };

    convert.gray.hsl = convert.gray.hsv = function (args) {
    	return [0, 0, args[0]];
    };

    convert.gray.hwb = function (gray) {
    	return [0, 100, gray[0]];
    };

    convert.gray.cmyk = function (gray) {
    	return [0, 0, 0, gray[0]];
    };

    convert.gray.lab = function (gray) {
    	return [gray[0], 0, 0];
    };

    convert.gray.hex = function (gray) {
    	var val = Math.round(gray[0] / 100 * 255) & 0xFF;
    	var integer = (val << 16) + (val << 8) + val;

    	var string = integer.toString(16).toUpperCase();
    	return '000000'.substring(string.length) + string;
    };

    convert.rgb.gray = function (rgb) {
    	var val = (rgb[0] + rgb[1] + rgb[2]) / 3;
    	return [val / 255 * 100];
    };
    });
    conversions.rgb;
    conversions.hsl;
    conversions.hsv;
    conversions.hwb;
    conversions.cmyk;
    conversions.xyz;
    conversions.lab;
    conversions.lch;
    conversions.hex;
    conversions.keyword;
    conversions.ansi16;
    conversions.ansi256;
    conversions.hcg;
    conversions.apple;
    conversions.gray;

    /*
    	this function routes a model to all other models.

    	all functions that are routed have a property `.conversion` attached
    	to the returned synthetic function. This property is an array
    	of strings, each with the steps in between the 'from' and 'to'
    	color models (inclusive).

    	conversions that are not possible simply are not included.
    */

    function buildGraph() {
    	var graph = {};
    	// https://jsperf.com/object-keys-vs-for-in-with-closure/3
    	var models = Object.keys(conversions);

    	for (var len = models.length, i = 0; i < len; i++) {
    		graph[models[i]] = {
    			// http://jsperf.com/1-vs-infinity
    			// micro-opt, but this is simple.
    			distance: -1,
    			parent: null
    		};
    	}

    	return graph;
    }

    // https://en.wikipedia.org/wiki/Breadth-first_search
    function deriveBFS(fromModel) {
    	var graph = buildGraph();
    	var queue = [fromModel]; // unshift -> queue -> pop

    	graph[fromModel].distance = 0;

    	while (queue.length) {
    		var current = queue.pop();
    		var adjacents = Object.keys(conversions[current]);

    		for (var len = adjacents.length, i = 0; i < len; i++) {
    			var adjacent = adjacents[i];
    			var node = graph[adjacent];

    			if (node.distance === -1) {
    				node.distance = graph[current].distance + 1;
    				node.parent = current;
    				queue.unshift(adjacent);
    			}
    		}
    	}

    	return graph;
    }

    function link(from, to) {
    	return function (args) {
    		return to(from(args));
    	};
    }

    function wrapConversion(toModel, graph) {
    	var path = [graph[toModel].parent, toModel];
    	var fn = conversions[graph[toModel].parent][toModel];

    	var cur = graph[toModel].parent;
    	while (graph[cur].parent) {
    		path.unshift(graph[cur].parent);
    		fn = link(conversions[graph[cur].parent][cur], fn);
    		cur = graph[cur].parent;
    	}

    	fn.conversion = path;
    	return fn;
    }

    var route = function (fromModel) {
    	var graph = deriveBFS(fromModel);
    	var conversion = {};

    	var models = Object.keys(graph);
    	for (var len = models.length, i = 0; i < len; i++) {
    		var toModel = models[i];
    		var node = graph[toModel];

    		if (node.parent === null) {
    			// no possible conversion, or this node is the source model.
    			continue;
    		}

    		conversion[toModel] = wrapConversion(toModel, graph);
    	}

    	return conversion;
    };

    var convert = {};

    var models = Object.keys(conversions);

    function wrapRaw(fn) {
    	var wrappedFn = function (args) {
    		if (args === undefined || args === null) {
    			return args;
    		}

    		if (arguments.length > 1) {
    			args = Array.prototype.slice.call(arguments);
    		}

    		return fn(args);
    	};

    	// preserve .conversion property if there is one
    	if ('conversion' in fn) {
    		wrappedFn.conversion = fn.conversion;
    	}

    	return wrappedFn;
    }

    function wrapRounded(fn) {
    	var wrappedFn = function (args) {
    		if (args === undefined || args === null) {
    			return args;
    		}

    		if (arguments.length > 1) {
    			args = Array.prototype.slice.call(arguments);
    		}

    		var result = fn(args);

    		// we're assuming the result is an array here.
    		// see notice in conversions.js; don't use box types
    		// in conversion functions.
    		if (typeof result === 'object') {
    			for (var len = result.length, i = 0; i < len; i++) {
    				result[i] = Math.round(result[i]);
    			}
    		}

    		return result;
    	};

    	// preserve .conversion property if there is one
    	if ('conversion' in fn) {
    		wrappedFn.conversion = fn.conversion;
    	}

    	return wrappedFn;
    }

    models.forEach(function (fromModel) {
    	convert[fromModel] = {};

    	Object.defineProperty(convert[fromModel], 'channels', {value: conversions[fromModel].channels});
    	Object.defineProperty(convert[fromModel], 'labels', {value: conversions[fromModel].labels});

    	var routes = route(fromModel);
    	var routeModels = Object.keys(routes);

    	routeModels.forEach(function (toModel) {
    		var fn = routes[toModel];

    		convert[fromModel][toModel] = wrapRounded(fn);
    		convert[fromModel][toModel].raw = wrapRaw(fn);
    	});
    });

    var colorConvert = convert;

    var colorName$1 = {
    	"aliceblue": [240, 248, 255],
    	"antiquewhite": [250, 235, 215],
    	"aqua": [0, 255, 255],
    	"aquamarine": [127, 255, 212],
    	"azure": [240, 255, 255],
    	"beige": [245, 245, 220],
    	"bisque": [255, 228, 196],
    	"black": [0, 0, 0],
    	"blanchedalmond": [255, 235, 205],
    	"blue": [0, 0, 255],
    	"blueviolet": [138, 43, 226],
    	"brown": [165, 42, 42],
    	"burlywood": [222, 184, 135],
    	"cadetblue": [95, 158, 160],
    	"chartreuse": [127, 255, 0],
    	"chocolate": [210, 105, 30],
    	"coral": [255, 127, 80],
    	"cornflowerblue": [100, 149, 237],
    	"cornsilk": [255, 248, 220],
    	"crimson": [220, 20, 60],
    	"cyan": [0, 255, 255],
    	"darkblue": [0, 0, 139],
    	"darkcyan": [0, 139, 139],
    	"darkgoldenrod": [184, 134, 11],
    	"darkgray": [169, 169, 169],
    	"darkgreen": [0, 100, 0],
    	"darkgrey": [169, 169, 169],
    	"darkkhaki": [189, 183, 107],
    	"darkmagenta": [139, 0, 139],
    	"darkolivegreen": [85, 107, 47],
    	"darkorange": [255, 140, 0],
    	"darkorchid": [153, 50, 204],
    	"darkred": [139, 0, 0],
    	"darksalmon": [233, 150, 122],
    	"darkseagreen": [143, 188, 143],
    	"darkslateblue": [72, 61, 139],
    	"darkslategray": [47, 79, 79],
    	"darkslategrey": [47, 79, 79],
    	"darkturquoise": [0, 206, 209],
    	"darkviolet": [148, 0, 211],
    	"deeppink": [255, 20, 147],
    	"deepskyblue": [0, 191, 255],
    	"dimgray": [105, 105, 105],
    	"dimgrey": [105, 105, 105],
    	"dodgerblue": [30, 144, 255],
    	"firebrick": [178, 34, 34],
    	"floralwhite": [255, 250, 240],
    	"forestgreen": [34, 139, 34],
    	"fuchsia": [255, 0, 255],
    	"gainsboro": [220, 220, 220],
    	"ghostwhite": [248, 248, 255],
    	"gold": [255, 215, 0],
    	"goldenrod": [218, 165, 32],
    	"gray": [128, 128, 128],
    	"green": [0, 128, 0],
    	"greenyellow": [173, 255, 47],
    	"grey": [128, 128, 128],
    	"honeydew": [240, 255, 240],
    	"hotpink": [255, 105, 180],
    	"indianred": [205, 92, 92],
    	"indigo": [75, 0, 130],
    	"ivory": [255, 255, 240],
    	"khaki": [240, 230, 140],
    	"lavender": [230, 230, 250],
    	"lavenderblush": [255, 240, 245],
    	"lawngreen": [124, 252, 0],
    	"lemonchiffon": [255, 250, 205],
    	"lightblue": [173, 216, 230],
    	"lightcoral": [240, 128, 128],
    	"lightcyan": [224, 255, 255],
    	"lightgoldenrodyellow": [250, 250, 210],
    	"lightgray": [211, 211, 211],
    	"lightgreen": [144, 238, 144],
    	"lightgrey": [211, 211, 211],
    	"lightpink": [255, 182, 193],
    	"lightsalmon": [255, 160, 122],
    	"lightseagreen": [32, 178, 170],
    	"lightskyblue": [135, 206, 250],
    	"lightslategray": [119, 136, 153],
    	"lightslategrey": [119, 136, 153],
    	"lightsteelblue": [176, 196, 222],
    	"lightyellow": [255, 255, 224],
    	"lime": [0, 255, 0],
    	"limegreen": [50, 205, 50],
    	"linen": [250, 240, 230],
    	"magenta": [255, 0, 255],
    	"maroon": [128, 0, 0],
    	"mediumaquamarine": [102, 205, 170],
    	"mediumblue": [0, 0, 205],
    	"mediumorchid": [186, 85, 211],
    	"mediumpurple": [147, 112, 219],
    	"mediumseagreen": [60, 179, 113],
    	"mediumslateblue": [123, 104, 238],
    	"mediumspringgreen": [0, 250, 154],
    	"mediumturquoise": [72, 209, 204],
    	"mediumvioletred": [199, 21, 133],
    	"midnightblue": [25, 25, 112],
    	"mintcream": [245, 255, 250],
    	"mistyrose": [255, 228, 225],
    	"moccasin": [255, 228, 181],
    	"navajowhite": [255, 222, 173],
    	"navy": [0, 0, 128],
    	"oldlace": [253, 245, 230],
    	"olive": [128, 128, 0],
    	"olivedrab": [107, 142, 35],
    	"orange": [255, 165, 0],
    	"orangered": [255, 69, 0],
    	"orchid": [218, 112, 214],
    	"palegoldenrod": [238, 232, 170],
    	"palegreen": [152, 251, 152],
    	"paleturquoise": [175, 238, 238],
    	"palevioletred": [219, 112, 147],
    	"papayawhip": [255, 239, 213],
    	"peachpuff": [255, 218, 185],
    	"peru": [205, 133, 63],
    	"pink": [255, 192, 203],
    	"plum": [221, 160, 221],
    	"powderblue": [176, 224, 230],
    	"purple": [128, 0, 128],
    	"rebeccapurple": [102, 51, 153],
    	"red": [255, 0, 0],
    	"rosybrown": [188, 143, 143],
    	"royalblue": [65, 105, 225],
    	"saddlebrown": [139, 69, 19],
    	"salmon": [250, 128, 114],
    	"sandybrown": [244, 164, 96],
    	"seagreen": [46, 139, 87],
    	"seashell": [255, 245, 238],
    	"sienna": [160, 82, 45],
    	"silver": [192, 192, 192],
    	"skyblue": [135, 206, 235],
    	"slateblue": [106, 90, 205],
    	"slategray": [112, 128, 144],
    	"slategrey": [112, 128, 144],
    	"snow": [255, 250, 250],
    	"springgreen": [0, 255, 127],
    	"steelblue": [70, 130, 180],
    	"tan": [210, 180, 140],
    	"teal": [0, 128, 128],
    	"thistle": [216, 191, 216],
    	"tomato": [255, 99, 71],
    	"turquoise": [64, 224, 208],
    	"violet": [238, 130, 238],
    	"wheat": [245, 222, 179],
    	"white": [255, 255, 255],
    	"whitesmoke": [245, 245, 245],
    	"yellow": [255, 255, 0],
    	"yellowgreen": [154, 205, 50]
    };

    /* MIT license */


    var colorString = {
       getRgba: getRgba,
       getHsla: getHsla,
       getRgb: getRgb,
       getHsl: getHsl,
       getHwb: getHwb,
       getAlpha: getAlpha,

       hexString: hexString,
       rgbString: rgbString,
       rgbaString: rgbaString,
       percentString: percentString,
       percentaString: percentaString,
       hslString: hslString,
       hslaString: hslaString,
       hwbString: hwbString,
       keyword: keyword
    };

    function getRgba(string) {
       if (!string) {
          return;
       }
       var abbr =  /^#([a-fA-F0-9]{3,4})$/i,
           hex =  /^#([a-fA-F0-9]{6}([a-fA-F0-9]{2})?)$/i,
           rgba = /^rgba?\(\s*([+-]?\d+)\s*,\s*([+-]?\d+)\s*,\s*([+-]?\d+)\s*(?:,\s*([+-]?[\d\.]+)\s*)?\)$/i,
           per = /^rgba?\(\s*([+-]?[\d\.]+)\%\s*,\s*([+-]?[\d\.]+)\%\s*,\s*([+-]?[\d\.]+)\%\s*(?:,\s*([+-]?[\d\.]+)\s*)?\)$/i,
           keyword = /(\w+)/;

       var rgb = [0, 0, 0],
           a = 1,
           match = string.match(abbr),
           hexAlpha = "";
       if (match) {
          match = match[1];
          hexAlpha = match[3];
          for (var i = 0; i < rgb.length; i++) {
             rgb[i] = parseInt(match[i] + match[i], 16);
          }
          if (hexAlpha) {
             a = Math.round((parseInt(hexAlpha + hexAlpha, 16) / 255) * 100) / 100;
          }
       }
       else if (match = string.match(hex)) {
          hexAlpha = match[2];
          match = match[1];
          for (var i = 0; i < rgb.length; i++) {
             rgb[i] = parseInt(match.slice(i * 2, i * 2 + 2), 16);
          }
          if (hexAlpha) {
             a = Math.round((parseInt(hexAlpha, 16) / 255) * 100) / 100;
          }
       }
       else if (match = string.match(rgba)) {
          for (var i = 0; i < rgb.length; i++) {
             rgb[i] = parseInt(match[i + 1]);
          }
          a = parseFloat(match[4]);
       }
       else if (match = string.match(per)) {
          for (var i = 0; i < rgb.length; i++) {
             rgb[i] = Math.round(parseFloat(match[i + 1]) * 2.55);
          }
          a = parseFloat(match[4]);
       }
       else if (match = string.match(keyword)) {
          if (match[1] == "transparent") {
             return [0, 0, 0, 0];
          }
          rgb = colorName$1[match[1]];
          if (!rgb) {
             return;
          }
       }

       for (var i = 0; i < rgb.length; i++) {
          rgb[i] = scale(rgb[i], 0, 255);
       }
       if (!a && a != 0) {
          a = 1;
       }
       else {
          a = scale(a, 0, 1);
       }
       rgb[3] = a;
       return rgb;
    }

    function getHsla(string) {
       if (!string) {
          return;
       }
       var hsl = /^hsla?\(\s*([+-]?\d+)(?:deg)?\s*,\s*([+-]?[\d\.]+)%\s*,\s*([+-]?[\d\.]+)%\s*(?:,\s*([+-]?[\d\.]+)\s*)?\)/;
       var match = string.match(hsl);
       if (match) {
          var alpha = parseFloat(match[4]);
          var h = scale(parseInt(match[1]), 0, 360),
              s = scale(parseFloat(match[2]), 0, 100),
              l = scale(parseFloat(match[3]), 0, 100),
              a = scale(isNaN(alpha) ? 1 : alpha, 0, 1);
          return [h, s, l, a];
       }
    }

    function getHwb(string) {
       if (!string) {
          return;
       }
       var hwb = /^hwb\(\s*([+-]?\d+)(?:deg)?\s*,\s*([+-]?[\d\.]+)%\s*,\s*([+-]?[\d\.]+)%\s*(?:,\s*([+-]?[\d\.]+)\s*)?\)/;
       var match = string.match(hwb);
       if (match) {
        var alpha = parseFloat(match[4]);
          var h = scale(parseInt(match[1]), 0, 360),
              w = scale(parseFloat(match[2]), 0, 100),
              b = scale(parseFloat(match[3]), 0, 100),
              a = scale(isNaN(alpha) ? 1 : alpha, 0, 1);
          return [h, w, b, a];
       }
    }

    function getRgb(string) {
       var rgba = getRgba(string);
       return rgba && rgba.slice(0, 3);
    }

    function getHsl(string) {
      var hsla = getHsla(string);
      return hsla && hsla.slice(0, 3);
    }

    function getAlpha(string) {
       var vals = getRgba(string);
       if (vals) {
          return vals[3];
       }
       else if (vals = getHsla(string)) {
          return vals[3];
       }
       else if (vals = getHwb(string)) {
          return vals[3];
       }
    }

    // generators
    function hexString(rgba, a) {
       var a = (a !== undefined && rgba.length === 3) ? a : rgba[3];
       return "#" + hexDouble(rgba[0]) 
                  + hexDouble(rgba[1])
                  + hexDouble(rgba[2])
                  + (
                     (a >= 0 && a < 1)
                     ? hexDouble(Math.round(a * 255))
                     : ""
                  );
    }

    function rgbString(rgba, alpha) {
       if (alpha < 1 || (rgba[3] && rgba[3] < 1)) {
          return rgbaString(rgba, alpha);
       }
       return "rgb(" + rgba[0] + ", " + rgba[1] + ", " + rgba[2] + ")";
    }

    function rgbaString(rgba, alpha) {
       if (alpha === undefined) {
          alpha = (rgba[3] !== undefined ? rgba[3] : 1);
       }
       return "rgba(" + rgba[0] + ", " + rgba[1] + ", " + rgba[2]
               + ", " + alpha + ")";
    }

    function percentString(rgba, alpha) {
       if (alpha < 1 || (rgba[3] && rgba[3] < 1)) {
          return percentaString(rgba, alpha);
       }
       var r = Math.round(rgba[0]/255 * 100),
           g = Math.round(rgba[1]/255 * 100),
           b = Math.round(rgba[2]/255 * 100);

       return "rgb(" + r + "%, " + g + "%, " + b + "%)";
    }

    function percentaString(rgba, alpha) {
       var r = Math.round(rgba[0]/255 * 100),
           g = Math.round(rgba[1]/255 * 100),
           b = Math.round(rgba[2]/255 * 100);
       return "rgba(" + r + "%, " + g + "%, " + b + "%, " + (alpha || rgba[3] || 1) + ")";
    }

    function hslString(hsla, alpha) {
       if (alpha < 1 || (hsla[3] && hsla[3] < 1)) {
          return hslaString(hsla, alpha);
       }
       return "hsl(" + hsla[0] + ", " + hsla[1] + "%, " + hsla[2] + "%)";
    }

    function hslaString(hsla, alpha) {
       if (alpha === undefined) {
          alpha = (hsla[3] !== undefined ? hsla[3] : 1);
       }
       return "hsla(" + hsla[0] + ", " + hsla[1] + "%, " + hsla[2] + "%, "
               + alpha + ")";
    }

    // hwb is a bit different than rgb(a) & hsl(a) since there is no alpha specific syntax
    // (hwb have alpha optional & 1 is default value)
    function hwbString(hwb, alpha) {
       if (alpha === undefined) {
          alpha = (hwb[3] !== undefined ? hwb[3] : 1);
       }
       return "hwb(" + hwb[0] + ", " + hwb[1] + "%, " + hwb[2] + "%"
               + (alpha !== undefined && alpha !== 1 ? ", " + alpha : "") + ")";
    }

    function keyword(rgb) {
      return reverseNames[rgb.slice(0, 3)];
    }

    // helpers
    function scale(num, min, max) {
       return Math.min(Math.max(min, num), max);
    }

    function hexDouble(num) {
      var str = num.toString(16).toUpperCase();
      return (str.length < 2) ? "0" + str : str;
    }


    //create a list of reverse color names
    var reverseNames = {};
    for (var name in colorName$1) {
       reverseNames[colorName$1[name]] = name;
    }

    /* MIT license */



    var Color = function (obj) {
    	if (obj instanceof Color) {
    		return obj;
    	}
    	if (!(this instanceof Color)) {
    		return new Color(obj);
    	}

    	this.valid = false;
    	this.values = {
    		rgb: [0, 0, 0],
    		hsl: [0, 0, 0],
    		hsv: [0, 0, 0],
    		hwb: [0, 0, 0],
    		cmyk: [0, 0, 0, 0],
    		alpha: 1
    	};

    	// parse Color() argument
    	var vals;
    	if (typeof obj === 'string') {
    		vals = colorString.getRgba(obj);
    		if (vals) {
    			this.setValues('rgb', vals);
    		} else if (vals = colorString.getHsla(obj)) {
    			this.setValues('hsl', vals);
    		} else if (vals = colorString.getHwb(obj)) {
    			this.setValues('hwb', vals);
    		}
    	} else if (typeof obj === 'object') {
    		vals = obj;
    		if (vals.r !== undefined || vals.red !== undefined) {
    			this.setValues('rgb', vals);
    		} else if (vals.l !== undefined || vals.lightness !== undefined) {
    			this.setValues('hsl', vals);
    		} else if (vals.v !== undefined || vals.value !== undefined) {
    			this.setValues('hsv', vals);
    		} else if (vals.w !== undefined || vals.whiteness !== undefined) {
    			this.setValues('hwb', vals);
    		} else if (vals.c !== undefined || vals.cyan !== undefined) {
    			this.setValues('cmyk', vals);
    		}
    	}
    };

    Color.prototype = {
    	isValid: function () {
    		return this.valid;
    	},
    	rgb: function () {
    		return this.setSpace('rgb', arguments);
    	},
    	hsl: function () {
    		return this.setSpace('hsl', arguments);
    	},
    	hsv: function () {
    		return this.setSpace('hsv', arguments);
    	},
    	hwb: function () {
    		return this.setSpace('hwb', arguments);
    	},
    	cmyk: function () {
    		return this.setSpace('cmyk', arguments);
    	},

    	rgbArray: function () {
    		return this.values.rgb;
    	},
    	hslArray: function () {
    		return this.values.hsl;
    	},
    	hsvArray: function () {
    		return this.values.hsv;
    	},
    	hwbArray: function () {
    		var values = this.values;
    		if (values.alpha !== 1) {
    			return values.hwb.concat([values.alpha]);
    		}
    		return values.hwb;
    	},
    	cmykArray: function () {
    		return this.values.cmyk;
    	},
    	rgbaArray: function () {
    		var values = this.values;
    		return values.rgb.concat([values.alpha]);
    	},
    	hslaArray: function () {
    		var values = this.values;
    		return values.hsl.concat([values.alpha]);
    	},
    	alpha: function (val) {
    		if (val === undefined) {
    			return this.values.alpha;
    		}
    		this.setValues('alpha', val);
    		return this;
    	},

    	red: function (val) {
    		return this.setChannel('rgb', 0, val);
    	},
    	green: function (val) {
    		return this.setChannel('rgb', 1, val);
    	},
    	blue: function (val) {
    		return this.setChannel('rgb', 2, val);
    	},
    	hue: function (val) {
    		if (val) {
    			val %= 360;
    			val = val < 0 ? 360 + val : val;
    		}
    		return this.setChannel('hsl', 0, val);
    	},
    	saturation: function (val) {
    		return this.setChannel('hsl', 1, val);
    	},
    	lightness: function (val) {
    		return this.setChannel('hsl', 2, val);
    	},
    	saturationv: function (val) {
    		return this.setChannel('hsv', 1, val);
    	},
    	whiteness: function (val) {
    		return this.setChannel('hwb', 1, val);
    	},
    	blackness: function (val) {
    		return this.setChannel('hwb', 2, val);
    	},
    	value: function (val) {
    		return this.setChannel('hsv', 2, val);
    	},
    	cyan: function (val) {
    		return this.setChannel('cmyk', 0, val);
    	},
    	magenta: function (val) {
    		return this.setChannel('cmyk', 1, val);
    	},
    	yellow: function (val) {
    		return this.setChannel('cmyk', 2, val);
    	},
    	black: function (val) {
    		return this.setChannel('cmyk', 3, val);
    	},

    	hexString: function () {
    		return colorString.hexString(this.values.rgb);
    	},
    	rgbString: function () {
    		return colorString.rgbString(this.values.rgb, this.values.alpha);
    	},
    	rgbaString: function () {
    		return colorString.rgbaString(this.values.rgb, this.values.alpha);
    	},
    	percentString: function () {
    		return colorString.percentString(this.values.rgb, this.values.alpha);
    	},
    	hslString: function () {
    		return colorString.hslString(this.values.hsl, this.values.alpha);
    	},
    	hslaString: function () {
    		return colorString.hslaString(this.values.hsl, this.values.alpha);
    	},
    	hwbString: function () {
    		return colorString.hwbString(this.values.hwb, this.values.alpha);
    	},
    	keyword: function () {
    		return colorString.keyword(this.values.rgb, this.values.alpha);
    	},

    	rgbNumber: function () {
    		var rgb = this.values.rgb;
    		return (rgb[0] << 16) | (rgb[1] << 8) | rgb[2];
    	},

    	luminosity: function () {
    		// http://www.w3.org/TR/WCAG20/#relativeluminancedef
    		var rgb = this.values.rgb;
    		var lum = [];
    		for (var i = 0; i < rgb.length; i++) {
    			var chan = rgb[i] / 255;
    			lum[i] = (chan <= 0.03928) ? chan / 12.92 : Math.pow(((chan + 0.055) / 1.055), 2.4);
    		}
    		return 0.2126 * lum[0] + 0.7152 * lum[1] + 0.0722 * lum[2];
    	},

    	contrast: function (color2) {
    		// http://www.w3.org/TR/WCAG20/#contrast-ratiodef
    		var lum1 = this.luminosity();
    		var lum2 = color2.luminosity();
    		if (lum1 > lum2) {
    			return (lum1 + 0.05) / (lum2 + 0.05);
    		}
    		return (lum2 + 0.05) / (lum1 + 0.05);
    	},

    	level: function (color2) {
    		var contrastRatio = this.contrast(color2);
    		if (contrastRatio >= 7.1) {
    			return 'AAA';
    		}

    		return (contrastRatio >= 4.5) ? 'AA' : '';
    	},

    	dark: function () {
    		// YIQ equation from http://24ways.org/2010/calculating-color-contrast
    		var rgb = this.values.rgb;
    		var yiq = (rgb[0] * 299 + rgb[1] * 587 + rgb[2] * 114) / 1000;
    		return yiq < 128;
    	},

    	light: function () {
    		return !this.dark();
    	},

    	negate: function () {
    		var rgb = [];
    		for (var i = 0; i < 3; i++) {
    			rgb[i] = 255 - this.values.rgb[i];
    		}
    		this.setValues('rgb', rgb);
    		return this;
    	},

    	lighten: function (ratio) {
    		var hsl = this.values.hsl;
    		hsl[2] += hsl[2] * ratio;
    		this.setValues('hsl', hsl);
    		return this;
    	},

    	darken: function (ratio) {
    		var hsl = this.values.hsl;
    		hsl[2] -= hsl[2] * ratio;
    		this.setValues('hsl', hsl);
    		return this;
    	},

    	saturate: function (ratio) {
    		var hsl = this.values.hsl;
    		hsl[1] += hsl[1] * ratio;
    		this.setValues('hsl', hsl);
    		return this;
    	},

    	desaturate: function (ratio) {
    		var hsl = this.values.hsl;
    		hsl[1] -= hsl[1] * ratio;
    		this.setValues('hsl', hsl);
    		return this;
    	},

    	whiten: function (ratio) {
    		var hwb = this.values.hwb;
    		hwb[1] += hwb[1] * ratio;
    		this.setValues('hwb', hwb);
    		return this;
    	},

    	blacken: function (ratio) {
    		var hwb = this.values.hwb;
    		hwb[2] += hwb[2] * ratio;
    		this.setValues('hwb', hwb);
    		return this;
    	},

    	greyscale: function () {
    		var rgb = this.values.rgb;
    		// http://en.wikipedia.org/wiki/Grayscale#Converting_color_to_grayscale
    		var val = rgb[0] * 0.3 + rgb[1] * 0.59 + rgb[2] * 0.11;
    		this.setValues('rgb', [val, val, val]);
    		return this;
    	},

    	clearer: function (ratio) {
    		var alpha = this.values.alpha;
    		this.setValues('alpha', alpha - (alpha * ratio));
    		return this;
    	},

    	opaquer: function (ratio) {
    		var alpha = this.values.alpha;
    		this.setValues('alpha', alpha + (alpha * ratio));
    		return this;
    	},

    	rotate: function (degrees) {
    		var hsl = this.values.hsl;
    		var hue = (hsl[0] + degrees) % 360;
    		hsl[0] = hue < 0 ? 360 + hue : hue;
    		this.setValues('hsl', hsl);
    		return this;
    	},

    	/**
    	 * Ported from sass implementation in C
    	 * https://github.com/sass/libsass/blob/0e6b4a2850092356aa3ece07c6b249f0221caced/functions.cpp#L209
    	 */
    	mix: function (mixinColor, weight) {
    		var color1 = this;
    		var color2 = mixinColor;
    		var p = weight === undefined ? 0.5 : weight;

    		var w = 2 * p - 1;
    		var a = color1.alpha() - color2.alpha();

    		var w1 = (((w * a === -1) ? w : (w + a) / (1 + w * a)) + 1) / 2.0;
    		var w2 = 1 - w1;

    		return this
    			.rgb(
    				w1 * color1.red() + w2 * color2.red(),
    				w1 * color1.green() + w2 * color2.green(),
    				w1 * color1.blue() + w2 * color2.blue()
    			)
    			.alpha(color1.alpha() * p + color2.alpha() * (1 - p));
    	},

    	toJSON: function () {
    		return this.rgb();
    	},

    	clone: function () {
    		// NOTE(SB): using node-clone creates a dependency to Buffer when using browserify,
    		// making the final build way to big to embed in Chart.js. So let's do it manually,
    		// assuming that values to clone are 1 dimension arrays containing only numbers,
    		// except 'alpha' which is a number.
    		var result = new Color();
    		var source = this.values;
    		var target = result.values;
    		var value, type;

    		for (var prop in source) {
    			if (source.hasOwnProperty(prop)) {
    				value = source[prop];
    				type = ({}).toString.call(value);
    				if (type === '[object Array]') {
    					target[prop] = value.slice(0);
    				} else if (type === '[object Number]') {
    					target[prop] = value;
    				} else {
    					console.error('unexpected color value:', value);
    				}
    			}
    		}

    		return result;
    	}
    };

    Color.prototype.spaces = {
    	rgb: ['red', 'green', 'blue'],
    	hsl: ['hue', 'saturation', 'lightness'],
    	hsv: ['hue', 'saturation', 'value'],
    	hwb: ['hue', 'whiteness', 'blackness'],
    	cmyk: ['cyan', 'magenta', 'yellow', 'black']
    };

    Color.prototype.maxes = {
    	rgb: [255, 255, 255],
    	hsl: [360, 100, 100],
    	hsv: [360, 100, 100],
    	hwb: [360, 100, 100],
    	cmyk: [100, 100, 100, 100]
    };

    Color.prototype.getValues = function (space) {
    	var values = this.values;
    	var vals = {};

    	for (var i = 0; i < space.length; i++) {
    		vals[space.charAt(i)] = values[space][i];
    	}

    	if (values.alpha !== 1) {
    		vals.a = values.alpha;
    	}

    	// {r: 255, g: 255, b: 255, a: 0.4}
    	return vals;
    };

    Color.prototype.setValues = function (space, vals) {
    	var values = this.values;
    	var spaces = this.spaces;
    	var maxes = this.maxes;
    	var alpha = 1;
    	var i;

    	this.valid = true;

    	if (space === 'alpha') {
    		alpha = vals;
    	} else if (vals.length) {
    		// [10, 10, 10]
    		values[space] = vals.slice(0, space.length);
    		alpha = vals[space.length];
    	} else if (vals[space.charAt(0)] !== undefined) {
    		// {r: 10, g: 10, b: 10}
    		for (i = 0; i < space.length; i++) {
    			values[space][i] = vals[space.charAt(i)];
    		}

    		alpha = vals.a;
    	} else if (vals[spaces[space][0]] !== undefined) {
    		// {red: 10, green: 10, blue: 10}
    		var chans = spaces[space];

    		for (i = 0; i < space.length; i++) {
    			values[space][i] = vals[chans[i]];
    		}

    		alpha = vals.alpha;
    	}

    	values.alpha = Math.max(0, Math.min(1, (alpha === undefined ? values.alpha : alpha)));

    	if (space === 'alpha') {
    		return false;
    	}

    	var capped;

    	// cap values of the space prior converting all values
    	for (i = 0; i < space.length; i++) {
    		capped = Math.max(0, Math.min(maxes[space][i], values[space][i]));
    		values[space][i] = Math.round(capped);
    	}

    	// convert to all the other color spaces
    	for (var sname in spaces) {
    		if (sname !== space) {
    			values[sname] = colorConvert[space][sname](values[space]);
    		}
    	}

    	return true;
    };

    Color.prototype.setSpace = function (space, args) {
    	var vals = args[0];

    	if (vals === undefined) {
    		// color.rgb()
    		return this.getValues(space);
    	}

    	// color.rgb(10, 10, 10)
    	if (typeof vals === 'number') {
    		vals = Array.prototype.slice.call(args);
    	}

    	this.setValues(space, vals);
    	return this;
    };

    Color.prototype.setChannel = function (space, index, val) {
    	var svalues = this.values[space];
    	if (val === undefined) {
    		// color.red()
    		return svalues[index];
    	} else if (val === svalues[index]) {
    		// color.red(color.red())
    		return this;
    	}

    	// color.red(100)
    	svalues[index] = val;
    	this.setValues(space, svalues);

    	return this;
    };

    if (typeof window !== 'undefined') {
    	window.Color = Color;
    }

    var chartjsColor = Color;

    function isValidKey(key) {
    	return ['__proto__', 'prototype', 'constructor'].indexOf(key) === -1;
    }

    /**
     * @namespace Chart.helpers
     */
    var helpers = {
    	/**
    	 * An empty function that can be used, for example, for optional callback.
    	 */
    	noop: function() {},

    	/**
    	 * Returns a unique id, sequentially generated from a global variable.
    	 * @returns {number}
    	 * @function
    	 */
    	uid: (function() {
    		var id = 0;
    		return function() {
    			return id++;
    		};
    	}()),

    	/**
    	 * Returns true if `value` is neither null nor undefined, else returns false.
    	 * @param {*} value - The value to test.
    	 * @returns {boolean}
    	 * @since 2.7.0
    	 */
    	isNullOrUndef: function(value) {
    		return value === null || typeof value === 'undefined';
    	},

    	/**
    	 * Returns true if `value` is an array (including typed arrays), else returns false.
    	 * @param {*} value - The value to test.
    	 * @returns {boolean}
    	 * @function
    	 */
    	isArray: function(value) {
    		if (Array.isArray && Array.isArray(value)) {
    			return true;
    		}
    		var type = Object.prototype.toString.call(value);
    		if (type.substr(0, 7) === '[object' && type.substr(-6) === 'Array]') {
    			return true;
    		}
    		return false;
    	},

    	/**
    	 * Returns true if `value` is an object (excluding null), else returns false.
    	 * @param {*} value - The value to test.
    	 * @returns {boolean}
    	 * @since 2.7.0
    	 */
    	isObject: function(value) {
    		return value !== null && Object.prototype.toString.call(value) === '[object Object]';
    	},

    	/**
    	 * Returns true if `value` is a finite number, else returns false
    	 * @param {*} value  - The value to test.
    	 * @returns {boolean}
    	 */
    	isFinite: function(value) {
    		return (typeof value === 'number' || value instanceof Number) && isFinite(value);
    	},

    	/**
    	 * Returns `value` if defined, else returns `defaultValue`.
    	 * @param {*} value - The value to return if defined.
    	 * @param {*} defaultValue - The value to return if `value` is undefined.
    	 * @returns {*}
    	 */
    	valueOrDefault: function(value, defaultValue) {
    		return typeof value === 'undefined' ? defaultValue : value;
    	},

    	/**
    	 * Returns value at the given `index` in array if defined, else returns `defaultValue`.
    	 * @param {Array} value - The array to lookup for value at `index`.
    	 * @param {number} index - The index in `value` to lookup for value.
    	 * @param {*} defaultValue - The value to return if `value[index]` is undefined.
    	 * @returns {*}
    	 */
    	valueAtIndexOrDefault: function(value, index, defaultValue) {
    		return helpers.valueOrDefault(helpers.isArray(value) ? value[index] : value, defaultValue);
    	},

    	/**
    	 * Calls `fn` with the given `args` in the scope defined by `thisArg` and returns the
    	 * value returned by `fn`. If `fn` is not a function, this method returns undefined.
    	 * @param {function} fn - The function to call.
    	 * @param {Array|undefined|null} args - The arguments with which `fn` should be called.
    	 * @param {object} [thisArg] - The value of `this` provided for the call to `fn`.
    	 * @returns {*}
    	 */
    	callback: function(fn, args, thisArg) {
    		if (fn && typeof fn.call === 'function') {
    			return fn.apply(thisArg, args);
    		}
    	},

    	/**
    	 * Note(SB) for performance sake, this method should only be used when loopable type
    	 * is unknown or in none intensive code (not called often and small loopable). Else
    	 * it's preferable to use a regular for() loop and save extra function calls.
    	 * @param {object|Array} loopable - The object or array to be iterated.
    	 * @param {function} fn - The function to call for each item.
    	 * @param {object} [thisArg] - The value of `this` provided for the call to `fn`.
    	 * @param {boolean} [reverse] - If true, iterates backward on the loopable.
    	 */
    	each: function(loopable, fn, thisArg, reverse) {
    		var i, len, keys;
    		if (helpers.isArray(loopable)) {
    			len = loopable.length;
    			if (reverse) {
    				for (i = len - 1; i >= 0; i--) {
    					fn.call(thisArg, loopable[i], i);
    				}
    			} else {
    				for (i = 0; i < len; i++) {
    					fn.call(thisArg, loopable[i], i);
    				}
    			}
    		} else if (helpers.isObject(loopable)) {
    			keys = Object.keys(loopable);
    			len = keys.length;
    			for (i = 0; i < len; i++) {
    				fn.call(thisArg, loopable[keys[i]], keys[i]);
    			}
    		}
    	},

    	/**
    	 * Returns true if the `a0` and `a1` arrays have the same content, else returns false.
    	 * @see https://stackoverflow.com/a/14853974
    	 * @param {Array} a0 - The array to compare
    	 * @param {Array} a1 - The array to compare
    	 * @returns {boolean}
    	 */
    	arrayEquals: function(a0, a1) {
    		var i, ilen, v0, v1;

    		if (!a0 || !a1 || a0.length !== a1.length) {
    			return false;
    		}

    		for (i = 0, ilen = a0.length; i < ilen; ++i) {
    			v0 = a0[i];
    			v1 = a1[i];

    			if (v0 instanceof Array && v1 instanceof Array) {
    				if (!helpers.arrayEquals(v0, v1)) {
    					return false;
    				}
    			} else if (v0 !== v1) {
    				// NOTE: two different object instances will never be equal: {x:20} != {x:20}
    				return false;
    			}
    		}

    		return true;
    	},

    	/**
    	 * Returns a deep copy of `source` without keeping references on objects and arrays.
    	 * @param {*} source - The value to clone.
    	 * @returns {*}
    	 */
    	clone: function(source) {
    		if (helpers.isArray(source)) {
    			return source.map(helpers.clone);
    		}

    		if (helpers.isObject(source)) {
    			var target = Object.create(source);
    			var keys = Object.keys(source);
    			var klen = keys.length;
    			var k = 0;

    			for (; k < klen; ++k) {
    				target[keys[k]] = helpers.clone(source[keys[k]]);
    			}

    			return target;
    		}

    		return source;
    	},

    	/**
    	 * The default merger when Chart.helpers.merge is called without merger option.
    	 * Note(SB): also used by mergeConfig and mergeScaleConfig as fallback.
    	 * @private
    	 */
    	_merger: function(key, target, source, options) {
    		if (!isValidKey(key)) {
    			// We want to ensure we do not copy prototypes over
    			// as this can pollute global namespaces
    			return;
    		}

    		var tval = target[key];
    		var sval = source[key];

    		if (helpers.isObject(tval) && helpers.isObject(sval)) {
    			helpers.merge(tval, sval, options);
    		} else {
    			target[key] = helpers.clone(sval);
    		}
    	},

    	/**
    	 * Merges source[key] in target[key] only if target[key] is undefined.
    	 * @private
    	 */
    	_mergerIf: function(key, target, source) {
    		if (!isValidKey(key)) {
    			// We want to ensure we do not copy prototypes over
    			// as this can pollute global namespaces
    			return;
    		}

    		var tval = target[key];
    		var sval = source[key];

    		if (helpers.isObject(tval) && helpers.isObject(sval)) {
    			helpers.mergeIf(tval, sval);
    		} else if (!target.hasOwnProperty(key)) {
    			target[key] = helpers.clone(sval);
    		}
    	},

    	/**
    	 * Recursively deep copies `source` properties into `target` with the given `options`.
    	 * IMPORTANT: `target` is not cloned and will be updated with `source` properties.
    	 * @param {object} target - The target object in which all sources are merged into.
    	 * @param {object|object[]} source - Object(s) to merge into `target`.
    	 * @param {object} [options] - Merging options:
    	 * @param {function} [options.merger] - The merge method (key, target, source, options)
    	 * @returns {object} The `target` object.
    	 */
    	merge: function(target, source, options) {
    		var sources = helpers.isArray(source) ? source : [source];
    		var ilen = sources.length;
    		var merge, i, keys, klen, k;

    		if (!helpers.isObject(target)) {
    			return target;
    		}

    		options = options || {};
    		merge = options.merger || helpers._merger;

    		for (i = 0; i < ilen; ++i) {
    			source = sources[i];
    			if (!helpers.isObject(source)) {
    				continue;
    			}

    			keys = Object.keys(source);
    			for (k = 0, klen = keys.length; k < klen; ++k) {
    				merge(keys[k], target, source, options);
    			}
    		}

    		return target;
    	},

    	/**
    	 * Recursively deep copies `source` properties into `target` *only* if not defined in target.
    	 * IMPORTANT: `target` is not cloned and will be updated with `source` properties.
    	 * @param {object} target - The target object in which all sources are merged into.
    	 * @param {object|object[]} source - Object(s) to merge into `target`.
    	 * @returns {object} The `target` object.
    	 */
    	mergeIf: function(target, source) {
    		return helpers.merge(target, source, {merger: helpers._mergerIf});
    	},

    	/**
    	 * Applies the contents of two or more objects together into the first object.
    	 * @param {object} target - The target object in which all objects are merged into.
    	 * @param {object} arg1 - Object containing additional properties to merge in target.
    	 * @param {object} argN - Additional objects containing properties to merge in target.
    	 * @returns {object} The `target` object.
    	 */
    	extend: Object.assign || function(target) {
    		return helpers.merge(target, [].slice.call(arguments, 1), {
    			merger: function(key, dst, src) {
    				dst[key] = src[key];
    			}
    		});
    	},

    	/**
    	 * Basic javascript inheritance based on the model created in Backbone.js
    	 */
    	inherits: function(extensions) {
    		var me = this;
    		var ChartElement = (extensions && extensions.hasOwnProperty('constructor')) ? extensions.constructor : function() {
    			return me.apply(this, arguments);
    		};

    		var Surrogate = function() {
    			this.constructor = ChartElement;
    		};

    		Surrogate.prototype = me.prototype;
    		ChartElement.prototype = new Surrogate();
    		ChartElement.extend = helpers.inherits;

    		if (extensions) {
    			helpers.extend(ChartElement.prototype, extensions);
    		}

    		ChartElement.__super__ = me.prototype;
    		return ChartElement;
    	},

    	_deprecated: function(scope, value, previous, current) {
    		if (value !== undefined) {
    			console.warn(scope + ': "' + previous +
    				'" is deprecated. Please use "' + current + '" instead');
    		}
    	}
    };

    var helpers_core = helpers;

    // DEPRECATIONS

    /**
     * Provided for backward compatibility, use Chart.helpers.callback instead.
     * @function Chart.helpers.callCallback
     * @deprecated since version 2.6.0
     * @todo remove at version 3
     * @private
     */
    helpers.callCallback = helpers.callback;

    /**
     * Provided for backward compatibility, use Array.prototype.indexOf instead.
     * Array.prototype.indexOf compatibility: Chrome, Opera, Safari, FF1.5+, IE9+
     * @function Chart.helpers.indexOf
     * @deprecated since version 2.7.0
     * @todo remove at version 3
     * @private
     */
    helpers.indexOf = function(array, item, fromIndex) {
    	return Array.prototype.indexOf.call(array, item, fromIndex);
    };

    /**
     * Provided for backward compatibility, use Chart.helpers.valueOrDefault instead.
     * @function Chart.helpers.getValueOrDefault
     * @deprecated since version 2.7.0
     * @todo remove at version 3
     * @private
     */
    helpers.getValueOrDefault = helpers.valueOrDefault;

    /**
     * Provided for backward compatibility, use Chart.helpers.valueAtIndexOrDefault instead.
     * @function Chart.helpers.getValueAtIndexOrDefault
     * @deprecated since version 2.7.0
     * @todo remove at version 3
     * @private
     */
    helpers.getValueAtIndexOrDefault = helpers.valueAtIndexOrDefault;

    /**
     * Easing functions adapted from Robert Penner's easing equations.
     * @namespace Chart.helpers.easingEffects
     * @see http://www.robertpenner.com/easing/
     */
    var effects = {
    	linear: function(t) {
    		return t;
    	},

    	easeInQuad: function(t) {
    		return t * t;
    	},

    	easeOutQuad: function(t) {
    		return -t * (t - 2);
    	},

    	easeInOutQuad: function(t) {
    		if ((t /= 0.5) < 1) {
    			return 0.5 * t * t;
    		}
    		return -0.5 * ((--t) * (t - 2) - 1);
    	},

    	easeInCubic: function(t) {
    		return t * t * t;
    	},

    	easeOutCubic: function(t) {
    		return (t = t - 1) * t * t + 1;
    	},

    	easeInOutCubic: function(t) {
    		if ((t /= 0.5) < 1) {
    			return 0.5 * t * t * t;
    		}
    		return 0.5 * ((t -= 2) * t * t + 2);
    	},

    	easeInQuart: function(t) {
    		return t * t * t * t;
    	},

    	easeOutQuart: function(t) {
    		return -((t = t - 1) * t * t * t - 1);
    	},

    	easeInOutQuart: function(t) {
    		if ((t /= 0.5) < 1) {
    			return 0.5 * t * t * t * t;
    		}
    		return -0.5 * ((t -= 2) * t * t * t - 2);
    	},

    	easeInQuint: function(t) {
    		return t * t * t * t * t;
    	},

    	easeOutQuint: function(t) {
    		return (t = t - 1) * t * t * t * t + 1;
    	},

    	easeInOutQuint: function(t) {
    		if ((t /= 0.5) < 1) {
    			return 0.5 * t * t * t * t * t;
    		}
    		return 0.5 * ((t -= 2) * t * t * t * t + 2);
    	},

    	easeInSine: function(t) {
    		return -Math.cos(t * (Math.PI / 2)) + 1;
    	},

    	easeOutSine: function(t) {
    		return Math.sin(t * (Math.PI / 2));
    	},

    	easeInOutSine: function(t) {
    		return -0.5 * (Math.cos(Math.PI * t) - 1);
    	},

    	easeInExpo: function(t) {
    		return (t === 0) ? 0 : Math.pow(2, 10 * (t - 1));
    	},

    	easeOutExpo: function(t) {
    		return (t === 1) ? 1 : -Math.pow(2, -10 * t) + 1;
    	},

    	easeInOutExpo: function(t) {
    		if (t === 0) {
    			return 0;
    		}
    		if (t === 1) {
    			return 1;
    		}
    		if ((t /= 0.5) < 1) {
    			return 0.5 * Math.pow(2, 10 * (t - 1));
    		}
    		return 0.5 * (-Math.pow(2, -10 * --t) + 2);
    	},

    	easeInCirc: function(t) {
    		if (t >= 1) {
    			return t;
    		}
    		return -(Math.sqrt(1 - t * t) - 1);
    	},

    	easeOutCirc: function(t) {
    		return Math.sqrt(1 - (t = t - 1) * t);
    	},

    	easeInOutCirc: function(t) {
    		if ((t /= 0.5) < 1) {
    			return -0.5 * (Math.sqrt(1 - t * t) - 1);
    		}
    		return 0.5 * (Math.sqrt(1 - (t -= 2) * t) + 1);
    	},

    	easeInElastic: function(t) {
    		var s = 1.70158;
    		var p = 0;
    		var a = 1;
    		if (t === 0) {
    			return 0;
    		}
    		if (t === 1) {
    			return 1;
    		}
    		if (!p) {
    			p = 0.3;
    		}
    		{
    			s = p / (2 * Math.PI) * Math.asin(1 / a);
    		}
    		return -(a * Math.pow(2, 10 * (t -= 1)) * Math.sin((t - s) * (2 * Math.PI) / p));
    	},

    	easeOutElastic: function(t) {
    		var s = 1.70158;
    		var p = 0;
    		var a = 1;
    		if (t === 0) {
    			return 0;
    		}
    		if (t === 1) {
    			return 1;
    		}
    		if (!p) {
    			p = 0.3;
    		}
    		{
    			s = p / (2 * Math.PI) * Math.asin(1 / a);
    		}
    		return a * Math.pow(2, -10 * t) * Math.sin((t - s) * (2 * Math.PI) / p) + 1;
    	},

    	easeInOutElastic: function(t) {
    		var s = 1.70158;
    		var p = 0;
    		var a = 1;
    		if (t === 0) {
    			return 0;
    		}
    		if ((t /= 0.5) === 2) {
    			return 1;
    		}
    		if (!p) {
    			p = 0.45;
    		}
    		{
    			s = p / (2 * Math.PI) * Math.asin(1 / a);
    		}
    		if (t < 1) {
    			return -0.5 * (a * Math.pow(2, 10 * (t -= 1)) * Math.sin((t - s) * (2 * Math.PI) / p));
    		}
    		return a * Math.pow(2, -10 * (t -= 1)) * Math.sin((t - s) * (2 * Math.PI) / p) * 0.5 + 1;
    	},
    	easeInBack: function(t) {
    		var s = 1.70158;
    		return t * t * ((s + 1) * t - s);
    	},

    	easeOutBack: function(t) {
    		var s = 1.70158;
    		return (t = t - 1) * t * ((s + 1) * t + s) + 1;
    	},

    	easeInOutBack: function(t) {
    		var s = 1.70158;
    		if ((t /= 0.5) < 1) {
    			return 0.5 * (t * t * (((s *= (1.525)) + 1) * t - s));
    		}
    		return 0.5 * ((t -= 2) * t * (((s *= (1.525)) + 1) * t + s) + 2);
    	},

    	easeInBounce: function(t) {
    		return 1 - effects.easeOutBounce(1 - t);
    	},

    	easeOutBounce: function(t) {
    		if (t < (1 / 2.75)) {
    			return 7.5625 * t * t;
    		}
    		if (t < (2 / 2.75)) {
    			return 7.5625 * (t -= (1.5 / 2.75)) * t + 0.75;
    		}
    		if (t < (2.5 / 2.75)) {
    			return 7.5625 * (t -= (2.25 / 2.75)) * t + 0.9375;
    		}
    		return 7.5625 * (t -= (2.625 / 2.75)) * t + 0.984375;
    	},

    	easeInOutBounce: function(t) {
    		if (t < 0.5) {
    			return effects.easeInBounce(t * 2) * 0.5;
    		}
    		return effects.easeOutBounce(t * 2 - 1) * 0.5 + 0.5;
    	}
    };

    var helpers_easing = {
    	effects: effects
    };

    // DEPRECATIONS

    /**
     * Provided for backward compatibility, use Chart.helpers.easing.effects instead.
     * @function Chart.helpers.easingEffects
     * @deprecated since version 2.7.0
     * @todo remove at version 3
     * @private
     */
    helpers_core.easingEffects = effects;

    var PI = Math.PI;
    var RAD_PER_DEG = PI / 180;
    var DOUBLE_PI = PI * 2;
    var HALF_PI = PI / 2;
    var QUARTER_PI = PI / 4;
    var TWO_THIRDS_PI = PI * 2 / 3;

    /**
     * @namespace Chart.helpers.canvas
     */
    var exports$1 = {
    	/**
    	 * Clears the entire canvas associated to the given `chart`.
    	 * @param {Chart} chart - The chart for which to clear the canvas.
    	 */
    	clear: function(chart) {
    		chart.ctx.clearRect(0, 0, chart.width, chart.height);
    	},

    	/**
    	 * Creates a "path" for a rectangle with rounded corners at position (x, y) with a
    	 * given size (width, height) and the same `radius` for all corners.
    	 * @param {CanvasRenderingContext2D} ctx - The canvas 2D Context.
    	 * @param {number} x - The x axis of the coordinate for the rectangle starting point.
    	 * @param {number} y - The y axis of the coordinate for the rectangle starting point.
    	 * @param {number} width - The rectangle's width.
    	 * @param {number} height - The rectangle's height.
    	 * @param {number} radius - The rounded amount (in pixels) for the four corners.
    	 * @todo handle `radius` as top-left, top-right, bottom-right, bottom-left array/object?
    	 */
    	roundedRect: function(ctx, x, y, width, height, radius) {
    		if (radius) {
    			var r = Math.min(radius, height / 2, width / 2);
    			var left = x + r;
    			var top = y + r;
    			var right = x + width - r;
    			var bottom = y + height - r;

    			ctx.moveTo(x, top);
    			if (left < right && top < bottom) {
    				ctx.arc(left, top, r, -PI, -HALF_PI);
    				ctx.arc(right, top, r, -HALF_PI, 0);
    				ctx.arc(right, bottom, r, 0, HALF_PI);
    				ctx.arc(left, bottom, r, HALF_PI, PI);
    			} else if (left < right) {
    				ctx.moveTo(left, y);
    				ctx.arc(right, top, r, -HALF_PI, HALF_PI);
    				ctx.arc(left, top, r, HALF_PI, PI + HALF_PI);
    			} else if (top < bottom) {
    				ctx.arc(left, top, r, -PI, 0);
    				ctx.arc(left, bottom, r, 0, PI);
    			} else {
    				ctx.arc(left, top, r, -PI, PI);
    			}
    			ctx.closePath();
    			ctx.moveTo(x, y);
    		} else {
    			ctx.rect(x, y, width, height);
    		}
    	},

    	drawPoint: function(ctx, style, radius, x, y, rotation) {
    		var type, xOffset, yOffset, size, cornerRadius;
    		var rad = (rotation || 0) * RAD_PER_DEG;

    		if (style && typeof style === 'object') {
    			type = style.toString();
    			if (type === '[object HTMLImageElement]' || type === '[object HTMLCanvasElement]') {
    				ctx.save();
    				ctx.translate(x, y);
    				ctx.rotate(rad);
    				ctx.drawImage(style, -style.width / 2, -style.height / 2, style.width, style.height);
    				ctx.restore();
    				return;
    			}
    		}

    		if (isNaN(radius) || radius <= 0) {
    			return;
    		}

    		ctx.beginPath();

    		switch (style) {
    		// Default includes circle
    		default:
    			ctx.arc(x, y, radius, 0, DOUBLE_PI);
    			ctx.closePath();
    			break;
    		case 'triangle':
    			ctx.moveTo(x + Math.sin(rad) * radius, y - Math.cos(rad) * radius);
    			rad += TWO_THIRDS_PI;
    			ctx.lineTo(x + Math.sin(rad) * radius, y - Math.cos(rad) * radius);
    			rad += TWO_THIRDS_PI;
    			ctx.lineTo(x + Math.sin(rad) * radius, y - Math.cos(rad) * radius);
    			ctx.closePath();
    			break;
    		case 'rectRounded':
    			// NOTE: the rounded rect implementation changed to use `arc` instead of
    			// `quadraticCurveTo` since it generates better results when rect is
    			// almost a circle. 0.516 (instead of 0.5) produces results with visually
    			// closer proportion to the previous impl and it is inscribed in the
    			// circle with `radius`. For more details, see the following PRs:
    			// https://github.com/chartjs/Chart.js/issues/5597
    			// https://github.com/chartjs/Chart.js/issues/5858
    			cornerRadius = radius * 0.516;
    			size = radius - cornerRadius;
    			xOffset = Math.cos(rad + QUARTER_PI) * size;
    			yOffset = Math.sin(rad + QUARTER_PI) * size;
    			ctx.arc(x - xOffset, y - yOffset, cornerRadius, rad - PI, rad - HALF_PI);
    			ctx.arc(x + yOffset, y - xOffset, cornerRadius, rad - HALF_PI, rad);
    			ctx.arc(x + xOffset, y + yOffset, cornerRadius, rad, rad + HALF_PI);
    			ctx.arc(x - yOffset, y + xOffset, cornerRadius, rad + HALF_PI, rad + PI);
    			ctx.closePath();
    			break;
    		case 'rect':
    			if (!rotation) {
    				size = Math.SQRT1_2 * radius;
    				ctx.rect(x - size, y - size, 2 * size, 2 * size);
    				break;
    			}
    			rad += QUARTER_PI;
    			/* falls through */
    		case 'rectRot':
    			xOffset = Math.cos(rad) * radius;
    			yOffset = Math.sin(rad) * radius;
    			ctx.moveTo(x - xOffset, y - yOffset);
    			ctx.lineTo(x + yOffset, y - xOffset);
    			ctx.lineTo(x + xOffset, y + yOffset);
    			ctx.lineTo(x - yOffset, y + xOffset);
    			ctx.closePath();
    			break;
    		case 'crossRot':
    			rad += QUARTER_PI;
    			/* falls through */
    		case 'cross':
    			xOffset = Math.cos(rad) * radius;
    			yOffset = Math.sin(rad) * radius;
    			ctx.moveTo(x - xOffset, y - yOffset);
    			ctx.lineTo(x + xOffset, y + yOffset);
    			ctx.moveTo(x + yOffset, y - xOffset);
    			ctx.lineTo(x - yOffset, y + xOffset);
    			break;
    		case 'star':
    			xOffset = Math.cos(rad) * radius;
    			yOffset = Math.sin(rad) * radius;
    			ctx.moveTo(x - xOffset, y - yOffset);
    			ctx.lineTo(x + xOffset, y + yOffset);
    			ctx.moveTo(x + yOffset, y - xOffset);
    			ctx.lineTo(x - yOffset, y + xOffset);
    			rad += QUARTER_PI;
    			xOffset = Math.cos(rad) * radius;
    			yOffset = Math.sin(rad) * radius;
    			ctx.moveTo(x - xOffset, y - yOffset);
    			ctx.lineTo(x + xOffset, y + yOffset);
    			ctx.moveTo(x + yOffset, y - xOffset);
    			ctx.lineTo(x - yOffset, y + xOffset);
    			break;
    		case 'line':
    			xOffset = Math.cos(rad) * radius;
    			yOffset = Math.sin(rad) * radius;
    			ctx.moveTo(x - xOffset, y - yOffset);
    			ctx.lineTo(x + xOffset, y + yOffset);
    			break;
    		case 'dash':
    			ctx.moveTo(x, y);
    			ctx.lineTo(x + Math.cos(rad) * radius, y + Math.sin(rad) * radius);
    			break;
    		}

    		ctx.fill();
    		ctx.stroke();
    	},

    	/**
    	 * Returns true if the point is inside the rectangle
    	 * @param {object} point - The point to test
    	 * @param {object} area - The rectangle
    	 * @returns {boolean}
    	 * @private
    	 */
    	_isPointInArea: function(point, area) {
    		var epsilon = 1e-6; // 1e-6 is margin in pixels for accumulated error.

    		return point.x > area.left - epsilon && point.x < area.right + epsilon &&
    			point.y > area.top - epsilon && point.y < area.bottom + epsilon;
    	},

    	clipArea: function(ctx, area) {
    		ctx.save();
    		ctx.beginPath();
    		ctx.rect(area.left, area.top, area.right - area.left, area.bottom - area.top);
    		ctx.clip();
    	},

    	unclipArea: function(ctx) {
    		ctx.restore();
    	},

    	lineTo: function(ctx, previous, target, flip) {
    		var stepped = target.steppedLine;
    		if (stepped) {
    			if (stepped === 'middle') {
    				var midpoint = (previous.x + target.x) / 2.0;
    				ctx.lineTo(midpoint, flip ? target.y : previous.y);
    				ctx.lineTo(midpoint, flip ? previous.y : target.y);
    			} else if ((stepped === 'after' && !flip) || (stepped !== 'after' && flip)) {
    				ctx.lineTo(previous.x, target.y);
    			} else {
    				ctx.lineTo(target.x, previous.y);
    			}
    			ctx.lineTo(target.x, target.y);
    			return;
    		}

    		if (!target.tension) {
    			ctx.lineTo(target.x, target.y);
    			return;
    		}

    		ctx.bezierCurveTo(
    			flip ? previous.controlPointPreviousX : previous.controlPointNextX,
    			flip ? previous.controlPointPreviousY : previous.controlPointNextY,
    			flip ? target.controlPointNextX : target.controlPointPreviousX,
    			flip ? target.controlPointNextY : target.controlPointPreviousY,
    			target.x,
    			target.y);
    	}
    };

    var helpers_canvas = exports$1;

    // DEPRECATIONS

    /**
     * Provided for backward compatibility, use Chart.helpers.canvas.clear instead.
     * @namespace Chart.helpers.clear
     * @deprecated since version 2.7.0
     * @todo remove at version 3
     * @private
     */
    helpers_core.clear = exports$1.clear;

    /**
     * Provided for backward compatibility, use Chart.helpers.canvas.roundedRect instead.
     * @namespace Chart.helpers.drawRoundedRectangle
     * @deprecated since version 2.7.0
     * @todo remove at version 3
     * @private
     */
    helpers_core.drawRoundedRectangle = function(ctx) {
    	ctx.beginPath();
    	exports$1.roundedRect.apply(exports$1, arguments);
    };

    var defaults = {
    	/**
    	 * @private
    	 */
    	_set: function(scope, values) {
    		return helpers_core.merge(this[scope] || (this[scope] = {}), values);
    	}
    };

    // TODO(v3): remove 'global' from namespace.  all default are global and
    // there's inconsistency around which options are under 'global'
    defaults._set('global', {
    	defaultColor: 'rgba(0,0,0,0.1)',
    	defaultFontColor: '#666',
    	defaultFontFamily: "'Helvetica Neue', 'Helvetica', 'Arial', sans-serif",
    	defaultFontSize: 12,
    	defaultFontStyle: 'normal',
    	defaultLineHeight: 1.2,
    	showLines: true
    });

    var core_defaults = defaults;

    var valueOrDefault = helpers_core.valueOrDefault;

    /**
     * Converts the given font object into a CSS font string.
     * @param {object} font - A font object.
     * @return {string} The CSS font string. See https://developer.mozilla.org/en-US/docs/Web/CSS/font
     * @private
     */
    function toFontString(font) {
    	if (!font || helpers_core.isNullOrUndef(font.size) || helpers_core.isNullOrUndef(font.family)) {
    		return null;
    	}

    	return (font.style ? font.style + ' ' : '')
    		+ (font.weight ? font.weight + ' ' : '')
    		+ font.size + 'px '
    		+ font.family;
    }

    /**
     * @alias Chart.helpers.options
     * @namespace
     */
    var helpers_options = {
    	/**
    	 * Converts the given line height `value` in pixels for a specific font `size`.
    	 * @param {number|string} value - The lineHeight to parse (eg. 1.6, '14px', '75%', '1.6em').
    	 * @param {number} size - The font size (in pixels) used to resolve relative `value`.
    	 * @returns {number} The effective line height in pixels (size * 1.2 if value is invalid).
    	 * @see https://developer.mozilla.org/en-US/docs/Web/CSS/line-height
    	 * @since 2.7.0
    	 */
    	toLineHeight: function(value, size) {
    		var matches = ('' + value).match(/^(normal|(\d+(?:\.\d+)?)(px|em|%)?)$/);
    		if (!matches || matches[1] === 'normal') {
    			return size * 1.2;
    		}

    		value = +matches[2];

    		switch (matches[3]) {
    		case 'px':
    			return value;
    		case '%':
    			value /= 100;
    			break;
    		}

    		return size * value;
    	},

    	/**
    	 * Converts the given value into a padding object with pre-computed width/height.
    	 * @param {number|object} value - If a number, set the value to all TRBL component,
    	 *  else, if and object, use defined properties and sets undefined ones to 0.
    	 * @returns {object} The padding values (top, right, bottom, left, width, height)
    	 * @since 2.7.0
    	 */
    	toPadding: function(value) {
    		var t, r, b, l;

    		if (helpers_core.isObject(value)) {
    			t = +value.top || 0;
    			r = +value.right || 0;
    			b = +value.bottom || 0;
    			l = +value.left || 0;
    		} else {
    			t = r = b = l = +value || 0;
    		}

    		return {
    			top: t,
    			right: r,
    			bottom: b,
    			left: l,
    			height: t + b,
    			width: l + r
    		};
    	},

    	/**
    	 * Parses font options and returns the font object.
    	 * @param {object} options - A object that contains font options to be parsed.
    	 * @return {object} The font object.
    	 * @todo Support font.* options and renamed to toFont().
    	 * @private
    	 */
    	_parseFont: function(options) {
    		var globalDefaults = core_defaults.global;
    		var size = valueOrDefault(options.fontSize, globalDefaults.defaultFontSize);
    		var font = {
    			family: valueOrDefault(options.fontFamily, globalDefaults.defaultFontFamily),
    			lineHeight: helpers_core.options.toLineHeight(valueOrDefault(options.lineHeight, globalDefaults.defaultLineHeight), size),
    			size: size,
    			style: valueOrDefault(options.fontStyle, globalDefaults.defaultFontStyle),
    			weight: null,
    			string: ''
    		};

    		font.string = toFontString(font);
    		return font;
    	},

    	/**
    	 * Evaluates the given `inputs` sequentially and returns the first defined value.
    	 * @param {Array} inputs - An array of values, falling back to the last value.
    	 * @param {object} [context] - If defined and the current value is a function, the value
    	 * is called with `context` as first argument and the result becomes the new input.
    	 * @param {number} [index] - If defined and the current value is an array, the value
    	 * at `index` become the new input.
    	 * @param {object} [info] - object to return information about resolution in
    	 * @param {boolean} [info.cacheable] - Will be set to `false` if option is not cacheable.
    	 * @since 2.7.0
    	 */
    	resolve: function(inputs, context, index, info) {
    		var cacheable = true;
    		var i, ilen, value;

    		for (i = 0, ilen = inputs.length; i < ilen; ++i) {
    			value = inputs[i];
    			if (value === undefined) {
    				continue;
    			}
    			if (context !== undefined && typeof value === 'function') {
    				value = value(context);
    				cacheable = false;
    			}
    			if (index !== undefined && helpers_core.isArray(value)) {
    				value = value[index];
    				cacheable = false;
    			}
    			if (value !== undefined) {
    				if (info && !cacheable) {
    					info.cacheable = false;
    				}
    				return value;
    			}
    		}
    	}
    };

    /**
     * @alias Chart.helpers.math
     * @namespace
     */
    var exports$2 = {
    	/**
    	 * Returns an array of factors sorted from 1 to sqrt(value)
    	 * @private
    	 */
    	_factorize: function(value) {
    		var result = [];
    		var sqrt = Math.sqrt(value);
    		var i;

    		for (i = 1; i < sqrt; i++) {
    			if (value % i === 0) {
    				result.push(i);
    				result.push(value / i);
    			}
    		}
    		if (sqrt === (sqrt | 0)) { // if value is a square number
    			result.push(sqrt);
    		}

    		result.sort(function(a, b) {
    			return a - b;
    		}).pop();
    		return result;
    	},

    	log10: Math.log10 || function(x) {
    		var exponent = Math.log(x) * Math.LOG10E; // Math.LOG10E = 1 / Math.LN10.
    		// Check for whole powers of 10,
    		// which due to floating point rounding error should be corrected.
    		var powerOf10 = Math.round(exponent);
    		var isPowerOf10 = x === Math.pow(10, powerOf10);

    		return isPowerOf10 ? powerOf10 : exponent;
    	}
    };

    var helpers_math = exports$2;

    // DEPRECATIONS

    /**
     * Provided for backward compatibility, use Chart.helpers.math.log10 instead.
     * @namespace Chart.helpers.log10
     * @deprecated since version 2.9.0
     * @todo remove at version 3
     * @private
     */
    helpers_core.log10 = exports$2.log10;

    var getRtlAdapter = function(rectX, width) {
    	return {
    		x: function(x) {
    			return rectX + rectX + width - x;
    		},
    		setWidth: function(w) {
    			width = w;
    		},
    		textAlign: function(align) {
    			if (align === 'center') {
    				return align;
    			}
    			return align === 'right' ? 'left' : 'right';
    		},
    		xPlus: function(x, value) {
    			return x - value;
    		},
    		leftForLtr: function(x, itemWidth) {
    			return x - itemWidth;
    		},
    	};
    };

    var getLtrAdapter = function() {
    	return {
    		x: function(x) {
    			return x;
    		},
    		setWidth: function(w) { // eslint-disable-line no-unused-vars
    		},
    		textAlign: function(align) {
    			return align;
    		},
    		xPlus: function(x, value) {
    			return x + value;
    		},
    		leftForLtr: function(x, _itemWidth) { // eslint-disable-line no-unused-vars
    			return x;
    		},
    	};
    };

    var getAdapter = function(rtl, rectX, width) {
    	return rtl ? getRtlAdapter(rectX, width) : getLtrAdapter();
    };

    var overrideTextDirection = function(ctx, direction) {
    	var style, original;
    	if (direction === 'ltr' || direction === 'rtl') {
    		style = ctx.canvas.style;
    		original = [
    			style.getPropertyValue('direction'),
    			style.getPropertyPriority('direction'),
    		];

    		style.setProperty('direction', direction, 'important');
    		ctx.prevTextDirection = original;
    	}
    };

    var restoreTextDirection = function(ctx) {
    	var original = ctx.prevTextDirection;
    	if (original !== undefined) {
    		delete ctx.prevTextDirection;
    		ctx.canvas.style.setProperty('direction', original[0], original[1]);
    	}
    };

    var helpers_rtl = {
    	getRtlAdapter: getAdapter,
    	overrideTextDirection: overrideTextDirection,
    	restoreTextDirection: restoreTextDirection,
    };

    var helpers$1 = helpers_core;
    var easing = helpers_easing;
    var canvas = helpers_canvas;
    var options = helpers_options;
    var math = helpers_math;
    var rtl = helpers_rtl;
    helpers$1.easing = easing;
    helpers$1.canvas = canvas;
    helpers$1.options = options;
    helpers$1.math = math;
    helpers$1.rtl = rtl;

    function interpolate(start, view, model, ease) {
    	var keys = Object.keys(model);
    	var i, ilen, key, actual, origin, target, type, c0, c1;

    	for (i = 0, ilen = keys.length; i < ilen; ++i) {
    		key = keys[i];

    		target = model[key];

    		// if a value is added to the model after pivot() has been called, the view
    		// doesn't contain it, so let's initialize the view to the target value.
    		if (!view.hasOwnProperty(key)) {
    			view[key] = target;
    		}

    		actual = view[key];

    		if (actual === target || key[0] === '_') {
    			continue;
    		}

    		if (!start.hasOwnProperty(key)) {
    			start[key] = actual;
    		}

    		origin = start[key];

    		type = typeof target;

    		if (type === typeof origin) {
    			if (type === 'string') {
    				c0 = chartjsColor(origin);
    				if (c0.valid) {
    					c1 = chartjsColor(target);
    					if (c1.valid) {
    						view[key] = c1.mix(c0, ease).rgbString();
    						continue;
    					}
    				}
    			} else if (helpers$1.isFinite(origin) && helpers$1.isFinite(target)) {
    				view[key] = origin + (target - origin) * ease;
    				continue;
    			}
    		}

    		view[key] = target;
    	}
    }

    var Element = function(configuration) {
    	helpers$1.extend(this, configuration);
    	this.initialize.apply(this, arguments);
    };

    helpers$1.extend(Element.prototype, {
    	_type: undefined,

    	initialize: function() {
    		this.hidden = false;
    	},

    	pivot: function() {
    		var me = this;
    		if (!me._view) {
    			me._view = helpers$1.extend({}, me._model);
    		}
    		me._start = {};
    		return me;
    	},

    	transition: function(ease) {
    		var me = this;
    		var model = me._model;
    		var start = me._start;
    		var view = me._view;

    		// No animation -> No Transition
    		if (!model || ease === 1) {
    			me._view = helpers$1.extend({}, model);
    			me._start = null;
    			return me;
    		}

    		if (!view) {
    			view = me._view = {};
    		}

    		if (!start) {
    			start = me._start = {};
    		}

    		interpolate(start, view, model, ease);

    		return me;
    	},

    	tooltipPosition: function() {
    		return {
    			x: this._model.x,
    			y: this._model.y
    		};
    	},

    	hasValue: function() {
    		return helpers$1.isNumber(this._model.x) && helpers$1.isNumber(this._model.y);
    	}
    });

    Element.extend = helpers$1.inherits;

    var core_element = Element;

    var exports$3 = core_element.extend({
    	chart: null, // the animation associated chart instance
    	currentStep: 0, // the current animation step
    	numSteps: 60, // default number of steps
    	easing: '', // the easing to use for this animation
    	render: null, // render function used by the animation service

    	onAnimationProgress: null, // user specified callback to fire on each step of the animation
    	onAnimationComplete: null, // user specified callback to fire when the animation finishes
    });

    var core_animation = exports$3;

    // DEPRECATIONS

    /**
     * Provided for backward compatibility, use Chart.Animation instead
     * @prop Chart.Animation#animationObject
     * @deprecated since version 2.6.0
     * @todo remove at version 3
     */
    Object.defineProperty(exports$3.prototype, 'animationObject', {
    	get: function() {
    		return this;
    	}
    });

    /**
     * Provided for backward compatibility, use Chart.Animation#chart instead
     * @prop Chart.Animation#chartInstance
     * @deprecated since version 2.6.0
     * @todo remove at version 3
     */
    Object.defineProperty(exports$3.prototype, 'chartInstance', {
    	get: function() {
    		return this.chart;
    	},
    	set: function(value) {
    		this.chart = value;
    	}
    });

    core_defaults._set('global', {
    	animation: {
    		duration: 1000,
    		easing: 'easeOutQuart',
    		onProgress: helpers$1.noop,
    		onComplete: helpers$1.noop
    	}
    });

    var core_animations = {
    	animations: [],
    	request: null,

    	/**
    	 * @param {Chart} chart - The chart to animate.
    	 * @param {Chart.Animation} animation - The animation that we will animate.
    	 * @param {number} duration - The animation duration in ms.
    	 * @param {boolean} lazy - if true, the chart is not marked as animating to enable more responsive interactions
    	 */
    	addAnimation: function(chart, animation, duration, lazy) {
    		var animations = this.animations;
    		var i, ilen;

    		animation.chart = chart;
    		animation.startTime = Date.now();
    		animation.duration = duration;

    		if (!lazy) {
    			chart.animating = true;
    		}

    		for (i = 0, ilen = animations.length; i < ilen; ++i) {
    			if (animations[i].chart === chart) {
    				animations[i] = animation;
    				return;
    			}
    		}

    		animations.push(animation);

    		// If there are no animations queued, manually kickstart a digest, for lack of a better word
    		if (animations.length === 1) {
    			this.requestAnimationFrame();
    		}
    	},

    	cancelAnimation: function(chart) {
    		var index = helpers$1.findIndex(this.animations, function(animation) {
    			return animation.chart === chart;
    		});

    		if (index !== -1) {
    			this.animations.splice(index, 1);
    			chart.animating = false;
    		}
    	},

    	requestAnimationFrame: function() {
    		var me = this;
    		if (me.request === null) {
    			// Skip animation frame requests until the active one is executed.
    			// This can happen when processing mouse events, e.g. 'mousemove'
    			// and 'mouseout' events will trigger multiple renders.
    			me.request = helpers$1.requestAnimFrame.call(window, function() {
    				me.request = null;
    				me.startDigest();
    			});
    		}
    	},

    	/**
    	 * @private
    	 */
    	startDigest: function() {
    		var me = this;

    		me.advance();

    		// Do we have more stuff to animate?
    		if (me.animations.length > 0) {
    			me.requestAnimationFrame();
    		}
    	},

    	/**
    	 * @private
    	 */
    	advance: function() {
    		var animations = this.animations;
    		var animation, chart, numSteps, nextStep;
    		var i = 0;

    		// 1 animation per chart, so we are looping charts here
    		while (i < animations.length) {
    			animation = animations[i];
    			chart = animation.chart;
    			numSteps = animation.numSteps;

    			// Make sure that currentStep starts at 1
    			// https://github.com/chartjs/Chart.js/issues/6104
    			nextStep = Math.floor((Date.now() - animation.startTime) / animation.duration * numSteps) + 1;
    			animation.currentStep = Math.min(nextStep, numSteps);

    			helpers$1.callback(animation.render, [chart, animation], chart);
    			helpers$1.callback(animation.onAnimationProgress, [animation], chart);

    			if (animation.currentStep >= numSteps) {
    				helpers$1.callback(animation.onAnimationComplete, [animation], chart);
    				chart.animating = false;
    				animations.splice(i, 1);
    			} else {
    				++i;
    			}
    		}
    	}
    };

    var resolve = helpers$1.options.resolve;

    var arrayEvents = ['push', 'pop', 'shift', 'splice', 'unshift'];

    /**
     * Hooks the array methods that add or remove values ('push', pop', 'shift', 'splice',
     * 'unshift') and notify the listener AFTER the array has been altered. Listeners are
     * called on the 'onData*' callbacks (e.g. onDataPush, etc.) with same arguments.
     */
    function listenArrayEvents(array, listener) {
    	if (array._chartjs) {
    		array._chartjs.listeners.push(listener);
    		return;
    	}

    	Object.defineProperty(array, '_chartjs', {
    		configurable: true,
    		enumerable: false,
    		value: {
    			listeners: [listener]
    		}
    	});

    	arrayEvents.forEach(function(key) {
    		var method = 'onData' + key.charAt(0).toUpperCase() + key.slice(1);
    		var base = array[key];

    		Object.defineProperty(array, key, {
    			configurable: true,
    			enumerable: false,
    			value: function() {
    				var args = Array.prototype.slice.call(arguments);
    				var res = base.apply(this, args);

    				helpers$1.each(array._chartjs.listeners, function(object) {
    					if (typeof object[method] === 'function') {
    						object[method].apply(object, args);
    					}
    				});

    				return res;
    			}
    		});
    	});
    }

    /**
     * Removes the given array event listener and cleanup extra attached properties (such as
     * the _chartjs stub and overridden methods) if array doesn't have any more listeners.
     */
    function unlistenArrayEvents(array, listener) {
    	var stub = array._chartjs;
    	if (!stub) {
    		return;
    	}

    	var listeners = stub.listeners;
    	var index = listeners.indexOf(listener);
    	if (index !== -1) {
    		listeners.splice(index, 1);
    	}

    	if (listeners.length > 0) {
    		return;
    	}

    	arrayEvents.forEach(function(key) {
    		delete array[key];
    	});

    	delete array._chartjs;
    }

    // Base class for all dataset controllers (line, bar, etc)
    var DatasetController = function(chart, datasetIndex) {
    	this.initialize(chart, datasetIndex);
    };

    helpers$1.extend(DatasetController.prototype, {

    	/**
    	 * Element type used to generate a meta dataset (e.g. Chart.element.Line).
    	 * @type {Chart.core.element}
    	 */
    	datasetElementType: null,

    	/**
    	 * Element type used to generate a meta data (e.g. Chart.element.Point).
    	 * @type {Chart.core.element}
    	 */
    	dataElementType: null,

    	/**
    	 * Dataset element option keys to be resolved in _resolveDatasetElementOptions.
    	 * A derived controller may override this to resolve controller-specific options.
    	 * The keys defined here are for backward compatibility for legend styles.
    	 * @private
    	 */
    	_datasetElementOptions: [
    		'backgroundColor',
    		'borderCapStyle',
    		'borderColor',
    		'borderDash',
    		'borderDashOffset',
    		'borderJoinStyle',
    		'borderWidth'
    	],

    	/**
    	 * Data element option keys to be resolved in _resolveDataElementOptions.
    	 * A derived controller may override this to resolve controller-specific options.
    	 * The keys defined here are for backward compatibility for legend styles.
    	 * @private
    	 */
    	_dataElementOptions: [
    		'backgroundColor',
    		'borderColor',
    		'borderWidth',
    		'pointStyle'
    	],

    	initialize: function(chart, datasetIndex) {
    		var me = this;
    		me.chart = chart;
    		me.index = datasetIndex;
    		me.linkScales();
    		me.addElements();
    		me._type = me.getMeta().type;
    	},

    	updateIndex: function(datasetIndex) {
    		this.index = datasetIndex;
    	},

    	linkScales: function() {
    		var me = this;
    		var meta = me.getMeta();
    		var chart = me.chart;
    		var scales = chart.scales;
    		var dataset = me.getDataset();
    		var scalesOpts = chart.options.scales;

    		if (meta.xAxisID === null || !(meta.xAxisID in scales) || dataset.xAxisID) {
    			meta.xAxisID = dataset.xAxisID || scalesOpts.xAxes[0].id;
    		}
    		if (meta.yAxisID === null || !(meta.yAxisID in scales) || dataset.yAxisID) {
    			meta.yAxisID = dataset.yAxisID || scalesOpts.yAxes[0].id;
    		}
    	},

    	getDataset: function() {
    		return this.chart.data.datasets[this.index];
    	},

    	getMeta: function() {
    		return this.chart.getDatasetMeta(this.index);
    	},

    	getScaleForId: function(scaleID) {
    		return this.chart.scales[scaleID];
    	},

    	/**
    	 * @private
    	 */
    	_getValueScaleId: function() {
    		return this.getMeta().yAxisID;
    	},

    	/**
    	 * @private
    	 */
    	_getIndexScaleId: function() {
    		return this.getMeta().xAxisID;
    	},

    	/**
    	 * @private
    	 */
    	_getValueScale: function() {
    		return this.getScaleForId(this._getValueScaleId());
    	},

    	/**
    	 * @private
    	 */
    	_getIndexScale: function() {
    		return this.getScaleForId(this._getIndexScaleId());
    	},

    	reset: function() {
    		this._update(true);
    	},

    	/**
    	 * @private
    	 */
    	destroy: function() {
    		if (this._data) {
    			unlistenArrayEvents(this._data, this);
    		}
    	},

    	createMetaDataset: function() {
    		var me = this;
    		var type = me.datasetElementType;
    		return type && new type({
    			_chart: me.chart,
    			_datasetIndex: me.index
    		});
    	},

    	createMetaData: function(index) {
    		var me = this;
    		var type = me.dataElementType;
    		return type && new type({
    			_chart: me.chart,
    			_datasetIndex: me.index,
    			_index: index
    		});
    	},

    	addElements: function() {
    		var me = this;
    		var meta = me.getMeta();
    		var data = me.getDataset().data || [];
    		var metaData = meta.data;
    		var i, ilen;

    		for (i = 0, ilen = data.length; i < ilen; ++i) {
    			metaData[i] = metaData[i] || me.createMetaData(i);
    		}

    		meta.dataset = meta.dataset || me.createMetaDataset();
    	},

    	addElementAndReset: function(index) {
    		var element = this.createMetaData(index);
    		this.getMeta().data.splice(index, 0, element);
    		this.updateElement(element, index, true);
    	},

    	buildOrUpdateElements: function() {
    		var me = this;
    		var dataset = me.getDataset();
    		var data = dataset.data || (dataset.data = []);

    		// In order to correctly handle data addition/deletion animation (an thus simulate
    		// real-time charts), we need to monitor these data modifications and synchronize
    		// the internal meta data accordingly.
    		if (me._data !== data) {
    			if (me._data) {
    				// This case happens when the user replaced the data array instance.
    				unlistenArrayEvents(me._data, me);
    			}

    			if (data && Object.isExtensible(data)) {
    				listenArrayEvents(data, me);
    			}
    			me._data = data;
    		}

    		// Re-sync meta data in case the user replaced the data array or if we missed
    		// any updates and so make sure that we handle number of datapoints changing.
    		me.resyncElements();
    	},

    	/**
    	 * Returns the merged user-supplied and default dataset-level options
    	 * @private
    	 */
    	_configure: function() {
    		var me = this;
    		me._config = helpers$1.merge(Object.create(null), [
    			me.chart.options.datasets[me._type],
    			me.getDataset(),
    		], {
    			merger: function(key, target, source) {
    				if (key !== '_meta' && key !== 'data') {
    					helpers$1._merger(key, target, source);
    				}
    			}
    		});
    	},

    	_update: function(reset) {
    		var me = this;
    		me._configure();
    		me._cachedDataOpts = null;
    		me.update(reset);
    	},

    	update: helpers$1.noop,

    	transition: function(easingValue) {
    		var meta = this.getMeta();
    		var elements = meta.data || [];
    		var ilen = elements.length;
    		var i = 0;

    		for (; i < ilen; ++i) {
    			elements[i].transition(easingValue);
    		}

    		if (meta.dataset) {
    			meta.dataset.transition(easingValue);
    		}
    	},

    	draw: function() {
    		var meta = this.getMeta();
    		var elements = meta.data || [];
    		var ilen = elements.length;
    		var i = 0;

    		if (meta.dataset) {
    			meta.dataset.draw();
    		}

    		for (; i < ilen; ++i) {
    			elements[i].draw();
    		}
    	},

    	/**
    	 * Returns a set of predefined style properties that should be used to represent the dataset
    	 * or the data if the index is specified
    	 * @param {number} index - data index
    	 * @return {IStyleInterface} style object
    	 */
    	getStyle: function(index) {
    		var me = this;
    		var meta = me.getMeta();
    		var dataset = meta.dataset;
    		var style;

    		me._configure();
    		if (dataset && index === undefined) {
    			style = me._resolveDatasetElementOptions(dataset || {});
    		} else {
    			index = index || 0;
    			style = me._resolveDataElementOptions(meta.data[index] || {}, index);
    		}

    		if (style.fill === false || style.fill === null) {
    			style.backgroundColor = style.borderColor;
    		}

    		return style;
    	},

    	/**
    	 * @private
    	 */
    	_resolveDatasetElementOptions: function(element, hover) {
    		var me = this;
    		var chart = me.chart;
    		var datasetOpts = me._config;
    		var custom = element.custom || {};
    		var options = chart.options.elements[me.datasetElementType.prototype._type] || {};
    		var elementOptions = me._datasetElementOptions;
    		var values = {};
    		var i, ilen, key, readKey;

    		// Scriptable options
    		var context = {
    			chart: chart,
    			dataset: me.getDataset(),
    			datasetIndex: me.index,
    			hover: hover
    		};

    		for (i = 0, ilen = elementOptions.length; i < ilen; ++i) {
    			key = elementOptions[i];
    			readKey = hover ? 'hover' + key.charAt(0).toUpperCase() + key.slice(1) : key;
    			values[key] = resolve([
    				custom[readKey],
    				datasetOpts[readKey],
    				options[readKey]
    			], context);
    		}

    		return values;
    	},

    	/**
    	 * @private
    	 */
    	_resolveDataElementOptions: function(element, index) {
    		var me = this;
    		var custom = element && element.custom;
    		var cached = me._cachedDataOpts;
    		if (cached && !custom) {
    			return cached;
    		}
    		var chart = me.chart;
    		var datasetOpts = me._config;
    		var options = chart.options.elements[me.dataElementType.prototype._type] || {};
    		var elementOptions = me._dataElementOptions;
    		var values = {};

    		// Scriptable options
    		var context = {
    			chart: chart,
    			dataIndex: index,
    			dataset: me.getDataset(),
    			datasetIndex: me.index
    		};

    		// `resolve` sets cacheable to `false` if any option is indexed or scripted
    		var info = {cacheable: !custom};

    		var keys, i, ilen, key;

    		custom = custom || {};

    		if (helpers$1.isArray(elementOptions)) {
    			for (i = 0, ilen = elementOptions.length; i < ilen; ++i) {
    				key = elementOptions[i];
    				values[key] = resolve([
    					custom[key],
    					datasetOpts[key],
    					options[key]
    				], context, index, info);
    			}
    		} else {
    			keys = Object.keys(elementOptions);
    			for (i = 0, ilen = keys.length; i < ilen; ++i) {
    				key = keys[i];
    				values[key] = resolve([
    					custom[key],
    					datasetOpts[elementOptions[key]],
    					datasetOpts[key],
    					options[key]
    				], context, index, info);
    			}
    		}

    		if (info.cacheable) {
    			me._cachedDataOpts = Object.freeze(values);
    		}

    		return values;
    	},

    	removeHoverStyle: function(element) {
    		helpers$1.merge(element._model, element.$previousStyle || {});
    		delete element.$previousStyle;
    	},

    	setHoverStyle: function(element) {
    		var dataset = this.chart.data.datasets[element._datasetIndex];
    		var index = element._index;
    		var custom = element.custom || {};
    		var model = element._model;
    		var getHoverColor = helpers$1.getHoverColor;

    		element.$previousStyle = {
    			backgroundColor: model.backgroundColor,
    			borderColor: model.borderColor,
    			borderWidth: model.borderWidth
    		};

    		model.backgroundColor = resolve([custom.hoverBackgroundColor, dataset.hoverBackgroundColor, getHoverColor(model.backgroundColor)], undefined, index);
    		model.borderColor = resolve([custom.hoverBorderColor, dataset.hoverBorderColor, getHoverColor(model.borderColor)], undefined, index);
    		model.borderWidth = resolve([custom.hoverBorderWidth, dataset.hoverBorderWidth, model.borderWidth], undefined, index);
    	},

    	/**
    	 * @private
    	 */
    	_removeDatasetHoverStyle: function() {
    		var element = this.getMeta().dataset;

    		if (element) {
    			this.removeHoverStyle(element);
    		}
    	},

    	/**
    	 * @private
    	 */
    	_setDatasetHoverStyle: function() {
    		var element = this.getMeta().dataset;
    		var prev = {};
    		var i, ilen, key, keys, hoverOptions, model;

    		if (!element) {
    			return;
    		}

    		model = element._model;
    		hoverOptions = this._resolveDatasetElementOptions(element, true);

    		keys = Object.keys(hoverOptions);
    		for (i = 0, ilen = keys.length; i < ilen; ++i) {
    			key = keys[i];
    			prev[key] = model[key];
    			model[key] = hoverOptions[key];
    		}

    		element.$previousStyle = prev;
    	},

    	/**
    	 * @private
    	 */
    	resyncElements: function() {
    		var me = this;
    		var meta = me.getMeta();
    		var data = me.getDataset().data;
    		var numMeta = meta.data.length;
    		var numData = data.length;

    		if (numData < numMeta) {
    			meta.data.splice(numData, numMeta - numData);
    		} else if (numData > numMeta) {
    			me.insertElements(numMeta, numData - numMeta);
    		}
    	},

    	/**
    	 * @private
    	 */
    	insertElements: function(start, count) {
    		for (var i = 0; i < count; ++i) {
    			this.addElementAndReset(start + i);
    		}
    	},

    	/**
    	 * @private
    	 */
    	onDataPush: function() {
    		var count = arguments.length;
    		this.insertElements(this.getDataset().data.length - count, count);
    	},

    	/**
    	 * @private
    	 */
    	onDataPop: function() {
    		this.getMeta().data.pop();
    	},

    	/**
    	 * @private
    	 */
    	onDataShift: function() {
    		this.getMeta().data.shift();
    	},

    	/**
    	 * @private
    	 */
    	onDataSplice: function(start, count) {
    		this.getMeta().data.splice(start, count);
    		this.insertElements(start, arguments.length - 2);
    	},

    	/**
    	 * @private
    	 */
    	onDataUnshift: function() {
    		this.insertElements(0, arguments.length);
    	}
    });

    DatasetController.extend = helpers$1.inherits;

    var core_datasetController = DatasetController;

    var TAU = Math.PI * 2;

    core_defaults._set('global', {
    	elements: {
    		arc: {
    			backgroundColor: core_defaults.global.defaultColor,
    			borderColor: '#fff',
    			borderWidth: 2,
    			borderAlign: 'center'
    		}
    	}
    });

    function clipArc(ctx, arc) {
    	var startAngle = arc.startAngle;
    	var endAngle = arc.endAngle;
    	var pixelMargin = arc.pixelMargin;
    	var angleMargin = pixelMargin / arc.outerRadius;
    	var x = arc.x;
    	var y = arc.y;

    	// Draw an inner border by cliping the arc and drawing a double-width border
    	// Enlarge the clipping arc by 0.33 pixels to eliminate glitches between borders
    	ctx.beginPath();
    	ctx.arc(x, y, arc.outerRadius, startAngle - angleMargin, endAngle + angleMargin);
    	if (arc.innerRadius > pixelMargin) {
    		angleMargin = pixelMargin / arc.innerRadius;
    		ctx.arc(x, y, arc.innerRadius - pixelMargin, endAngle + angleMargin, startAngle - angleMargin, true);
    	} else {
    		ctx.arc(x, y, pixelMargin, endAngle + Math.PI / 2, startAngle - Math.PI / 2);
    	}
    	ctx.closePath();
    	ctx.clip();
    }

    function drawFullCircleBorders(ctx, vm, arc, inner) {
    	var endAngle = arc.endAngle;
    	var i;

    	if (inner) {
    		arc.endAngle = arc.startAngle + TAU;
    		clipArc(ctx, arc);
    		arc.endAngle = endAngle;
    		if (arc.endAngle === arc.startAngle && arc.fullCircles) {
    			arc.endAngle += TAU;
    			arc.fullCircles--;
    		}
    	}

    	ctx.beginPath();
    	ctx.arc(arc.x, arc.y, arc.innerRadius, arc.startAngle + TAU, arc.startAngle, true);
    	for (i = 0; i < arc.fullCircles; ++i) {
    		ctx.stroke();
    	}

    	ctx.beginPath();
    	ctx.arc(arc.x, arc.y, vm.outerRadius, arc.startAngle, arc.startAngle + TAU);
    	for (i = 0; i < arc.fullCircles; ++i) {
    		ctx.stroke();
    	}
    }

    function drawBorder(ctx, vm, arc) {
    	var inner = vm.borderAlign === 'inner';

    	if (inner) {
    		ctx.lineWidth = vm.borderWidth * 2;
    		ctx.lineJoin = 'round';
    	} else {
    		ctx.lineWidth = vm.borderWidth;
    		ctx.lineJoin = 'bevel';
    	}

    	if (arc.fullCircles) {
    		drawFullCircleBorders(ctx, vm, arc, inner);
    	}

    	if (inner) {
    		clipArc(ctx, arc);
    	}

    	ctx.beginPath();
    	ctx.arc(arc.x, arc.y, vm.outerRadius, arc.startAngle, arc.endAngle);
    	ctx.arc(arc.x, arc.y, arc.innerRadius, arc.endAngle, arc.startAngle, true);
    	ctx.closePath();
    	ctx.stroke();
    }

    var element_arc = core_element.extend({
    	_type: 'arc',

    	inLabelRange: function(mouseX) {
    		var vm = this._view;

    		if (vm) {
    			return (Math.pow(mouseX - vm.x, 2) < Math.pow(vm.radius + vm.hoverRadius, 2));
    		}
    		return false;
    	},

    	inRange: function(chartX, chartY) {
    		var vm = this._view;

    		if (vm) {
    			var pointRelativePosition = helpers$1.getAngleFromPoint(vm, {x: chartX, y: chartY});
    			var angle = pointRelativePosition.angle;
    			var distance = pointRelativePosition.distance;

    			// Sanitise angle range
    			var startAngle = vm.startAngle;
    			var endAngle = vm.endAngle;
    			while (endAngle < startAngle) {
    				endAngle += TAU;
    			}
    			while (angle > endAngle) {
    				angle -= TAU;
    			}
    			while (angle < startAngle) {
    				angle += TAU;
    			}

    			// Check if within the range of the open/close angle
    			var betweenAngles = (angle >= startAngle && angle <= endAngle);
    			var withinRadius = (distance >= vm.innerRadius && distance <= vm.outerRadius);

    			return (betweenAngles && withinRadius);
    		}
    		return false;
    	},

    	getCenterPoint: function() {
    		var vm = this._view;
    		var halfAngle = (vm.startAngle + vm.endAngle) / 2;
    		var halfRadius = (vm.innerRadius + vm.outerRadius) / 2;
    		return {
    			x: vm.x + Math.cos(halfAngle) * halfRadius,
    			y: vm.y + Math.sin(halfAngle) * halfRadius
    		};
    	},

    	getArea: function() {
    		var vm = this._view;
    		return Math.PI * ((vm.endAngle - vm.startAngle) / (2 * Math.PI)) * (Math.pow(vm.outerRadius, 2) - Math.pow(vm.innerRadius, 2));
    	},

    	tooltipPosition: function() {
    		var vm = this._view;
    		var centreAngle = vm.startAngle + ((vm.endAngle - vm.startAngle) / 2);
    		var rangeFromCentre = (vm.outerRadius - vm.innerRadius) / 2 + vm.innerRadius;

    		return {
    			x: vm.x + (Math.cos(centreAngle) * rangeFromCentre),
    			y: vm.y + (Math.sin(centreAngle) * rangeFromCentre)
    		};
    	},

    	draw: function() {
    		var ctx = this._chart.ctx;
    		var vm = this._view;
    		var pixelMargin = (vm.borderAlign === 'inner') ? 0.33 : 0;
    		var arc = {
    			x: vm.x,
    			y: vm.y,
    			innerRadius: vm.innerRadius,
    			outerRadius: Math.max(vm.outerRadius - pixelMargin, 0),
    			pixelMargin: pixelMargin,
    			startAngle: vm.startAngle,
    			endAngle: vm.endAngle,
    			fullCircles: Math.floor(vm.circumference / TAU)
    		};
    		var i;

    		ctx.save();

    		ctx.fillStyle = vm.backgroundColor;
    		ctx.strokeStyle = vm.borderColor;

    		if (arc.fullCircles) {
    			arc.endAngle = arc.startAngle + TAU;
    			ctx.beginPath();
    			ctx.arc(arc.x, arc.y, arc.outerRadius, arc.startAngle, arc.endAngle);
    			ctx.arc(arc.x, arc.y, arc.innerRadius, arc.endAngle, arc.startAngle, true);
    			ctx.closePath();
    			for (i = 0; i < arc.fullCircles; ++i) {
    				ctx.fill();
    			}
    			arc.endAngle = arc.startAngle + vm.circumference % TAU;
    		}

    		ctx.beginPath();
    		ctx.arc(arc.x, arc.y, arc.outerRadius, arc.startAngle, arc.endAngle);
    		ctx.arc(arc.x, arc.y, arc.innerRadius, arc.endAngle, arc.startAngle, true);
    		ctx.closePath();
    		ctx.fill();

    		if (vm.borderWidth) {
    			drawBorder(ctx, vm, arc);
    		}

    		ctx.restore();
    	}
    });

    var valueOrDefault$1 = helpers$1.valueOrDefault;

    var defaultColor = core_defaults.global.defaultColor;

    core_defaults._set('global', {
    	elements: {
    		line: {
    			tension: 0.4,
    			backgroundColor: defaultColor,
    			borderWidth: 3,
    			borderColor: defaultColor,
    			borderCapStyle: 'butt',
    			borderDash: [],
    			borderDashOffset: 0.0,
    			borderJoinStyle: 'miter',
    			capBezierPoints: true,
    			fill: true, // do we fill in the area between the line and its base axis
    		}
    	}
    });

    var element_line = core_element.extend({
    	_type: 'line',

    	draw: function() {
    		var me = this;
    		var vm = me._view;
    		var ctx = me._chart.ctx;
    		var spanGaps = vm.spanGaps;
    		var points = me._children.slice(); // clone array
    		var globalDefaults = core_defaults.global;
    		var globalOptionLineElements = globalDefaults.elements.line;
    		var lastDrawnIndex = -1;
    		var closePath = me._loop;
    		var index, previous, currentVM;

    		if (!points.length) {
    			return;
    		}

    		if (me._loop) {
    			for (index = 0; index < points.length; ++index) {
    				previous = helpers$1.previousItem(points, index);
    				// If the line has an open path, shift the point array
    				if (!points[index]._view.skip && previous._view.skip) {
    					points = points.slice(index).concat(points.slice(0, index));
    					closePath = spanGaps;
    					break;
    				}
    			}
    			// If the line has a close path, add the first point again
    			if (closePath) {
    				points.push(points[0]);
    			}
    		}

    		ctx.save();

    		// Stroke Line Options
    		ctx.lineCap = vm.borderCapStyle || globalOptionLineElements.borderCapStyle;

    		// IE 9 and 10 do not support line dash
    		if (ctx.setLineDash) {
    			ctx.setLineDash(vm.borderDash || globalOptionLineElements.borderDash);
    		}

    		ctx.lineDashOffset = valueOrDefault$1(vm.borderDashOffset, globalOptionLineElements.borderDashOffset);
    		ctx.lineJoin = vm.borderJoinStyle || globalOptionLineElements.borderJoinStyle;
    		ctx.lineWidth = valueOrDefault$1(vm.borderWidth, globalOptionLineElements.borderWidth);
    		ctx.strokeStyle = vm.borderColor || globalDefaults.defaultColor;

    		// Stroke Line
    		ctx.beginPath();

    		// First point moves to it's starting position no matter what
    		currentVM = points[0]._view;
    		if (!currentVM.skip) {
    			ctx.moveTo(currentVM.x, currentVM.y);
    			lastDrawnIndex = 0;
    		}

    		for (index = 1; index < points.length; ++index) {
    			currentVM = points[index]._view;
    			previous = lastDrawnIndex === -1 ? helpers$1.previousItem(points, index) : points[lastDrawnIndex];

    			if (!currentVM.skip) {
    				if ((lastDrawnIndex !== (index - 1) && !spanGaps) || lastDrawnIndex === -1) {
    					// There was a gap and this is the first point after the gap
    					ctx.moveTo(currentVM.x, currentVM.y);
    				} else {
    					// Line to next point
    					helpers$1.canvas.lineTo(ctx, previous._view, currentVM);
    				}
    				lastDrawnIndex = index;
    			}
    		}

    		if (closePath) {
    			ctx.closePath();
    		}

    		ctx.stroke();
    		ctx.restore();
    	}
    });

    var valueOrDefault$2 = helpers$1.valueOrDefault;

    var defaultColor$1 = core_defaults.global.defaultColor;

    core_defaults._set('global', {
    	elements: {
    		point: {
    			radius: 3,
    			pointStyle: 'circle',
    			backgroundColor: defaultColor$1,
    			borderColor: defaultColor$1,
    			borderWidth: 1,
    			// Hover
    			hitRadius: 1,
    			hoverRadius: 4,
    			hoverBorderWidth: 1
    		}
    	}
    });

    function xRange(mouseX) {
    	var vm = this._view;
    	return vm ? (Math.abs(mouseX - vm.x) < vm.radius + vm.hitRadius) : false;
    }

    function yRange(mouseY) {
    	var vm = this._view;
    	return vm ? (Math.abs(mouseY - vm.y) < vm.radius + vm.hitRadius) : false;
    }

    var element_point = core_element.extend({
    	_type: 'point',

    	inRange: function(mouseX, mouseY) {
    		var vm = this._view;
    		return vm ? ((Math.pow(mouseX - vm.x, 2) + Math.pow(mouseY - vm.y, 2)) < Math.pow(vm.hitRadius + vm.radius, 2)) : false;
    	},

    	inLabelRange: xRange,
    	inXRange: xRange,
    	inYRange: yRange,

    	getCenterPoint: function() {
    		var vm = this._view;
    		return {
    			x: vm.x,
    			y: vm.y
    		};
    	},

    	getArea: function() {
    		return Math.PI * Math.pow(this._view.radius, 2);
    	},

    	tooltipPosition: function() {
    		var vm = this._view;
    		return {
    			x: vm.x,
    			y: vm.y,
    			padding: vm.radius + vm.borderWidth
    		};
    	},

    	draw: function(chartArea) {
    		var vm = this._view;
    		var ctx = this._chart.ctx;
    		var pointStyle = vm.pointStyle;
    		var rotation = vm.rotation;
    		var radius = vm.radius;
    		var x = vm.x;
    		var y = vm.y;
    		var globalDefaults = core_defaults.global;
    		var defaultColor = globalDefaults.defaultColor; // eslint-disable-line no-shadow

    		if (vm.skip) {
    			return;
    		}

    		// Clipping for Points.
    		if (chartArea === undefined || helpers$1.canvas._isPointInArea(vm, chartArea)) {
    			ctx.strokeStyle = vm.borderColor || defaultColor;
    			ctx.lineWidth = valueOrDefault$2(vm.borderWidth, globalDefaults.elements.point.borderWidth);
    			ctx.fillStyle = vm.backgroundColor || defaultColor;
    			helpers$1.canvas.drawPoint(ctx, pointStyle, radius, x, y, rotation);
    		}
    	}
    });

    var defaultColor$2 = core_defaults.global.defaultColor;

    core_defaults._set('global', {
    	elements: {
    		rectangle: {
    			backgroundColor: defaultColor$2,
    			borderColor: defaultColor$2,
    			borderSkipped: 'bottom',
    			borderWidth: 0
    		}
    	}
    });

    function isVertical(vm) {
    	return vm && vm.width !== undefined;
    }

    /**
     * Helper function to get the bounds of the bar regardless of the orientation
     * @param bar {Chart.Element.Rectangle} the bar
     * @return {Bounds} bounds of the bar
     * @private
     */
    function getBarBounds(vm) {
    	var x1, x2, y1, y2, half;

    	if (isVertical(vm)) {
    		half = vm.width / 2;
    		x1 = vm.x - half;
    		x2 = vm.x + half;
    		y1 = Math.min(vm.y, vm.base);
    		y2 = Math.max(vm.y, vm.base);
    	} else {
    		half = vm.height / 2;
    		x1 = Math.min(vm.x, vm.base);
    		x2 = Math.max(vm.x, vm.base);
    		y1 = vm.y - half;
    		y2 = vm.y + half;
    	}

    	return {
    		left: x1,
    		top: y1,
    		right: x2,
    		bottom: y2
    	};
    }

    function swap(orig, v1, v2) {
    	return orig === v1 ? v2 : orig === v2 ? v1 : orig;
    }

    function parseBorderSkipped(vm) {
    	var edge = vm.borderSkipped;
    	var res = {};

    	if (!edge) {
    		return res;
    	}

    	if (vm.horizontal) {
    		if (vm.base > vm.x) {
    			edge = swap(edge, 'left', 'right');
    		}
    	} else if (vm.base < vm.y) {
    		edge = swap(edge, 'bottom', 'top');
    	}

    	res[edge] = true;
    	return res;
    }

    function parseBorderWidth(vm, maxW, maxH) {
    	var value = vm.borderWidth;
    	var skip = parseBorderSkipped(vm);
    	var t, r, b, l;

    	if (helpers$1.isObject(value)) {
    		t = +value.top || 0;
    		r = +value.right || 0;
    		b = +value.bottom || 0;
    		l = +value.left || 0;
    	} else {
    		t = r = b = l = +value || 0;
    	}

    	return {
    		t: skip.top || (t < 0) ? 0 : t > maxH ? maxH : t,
    		r: skip.right || (r < 0) ? 0 : r > maxW ? maxW : r,
    		b: skip.bottom || (b < 0) ? 0 : b > maxH ? maxH : b,
    		l: skip.left || (l < 0) ? 0 : l > maxW ? maxW : l
    	};
    }

    function boundingRects(vm) {
    	var bounds = getBarBounds(vm);
    	var width = bounds.right - bounds.left;
    	var height = bounds.bottom - bounds.top;
    	var border = parseBorderWidth(vm, width / 2, height / 2);

    	return {
    		outer: {
    			x: bounds.left,
    			y: bounds.top,
    			w: width,
    			h: height
    		},
    		inner: {
    			x: bounds.left + border.l,
    			y: bounds.top + border.t,
    			w: width - border.l - border.r,
    			h: height - border.t - border.b
    		}
    	};
    }

    function inRange(vm, x, y) {
    	var skipX = x === null;
    	var skipY = y === null;
    	var bounds = !vm || (skipX && skipY) ? false : getBarBounds(vm);

    	return bounds
    		&& (skipX || x >= bounds.left && x <= bounds.right)
    		&& (skipY || y >= bounds.top && y <= bounds.bottom);
    }

    var element_rectangle = core_element.extend({
    	_type: 'rectangle',

    	draw: function() {
    		var ctx = this._chart.ctx;
    		var vm = this._view;
    		var rects = boundingRects(vm);
    		var outer = rects.outer;
    		var inner = rects.inner;

    		ctx.fillStyle = vm.backgroundColor;
    		ctx.fillRect(outer.x, outer.y, outer.w, outer.h);

    		if (outer.w === inner.w && outer.h === inner.h) {
    			return;
    		}

    		ctx.save();
    		ctx.beginPath();
    		ctx.rect(outer.x, outer.y, outer.w, outer.h);
    		ctx.clip();
    		ctx.fillStyle = vm.borderColor;
    		ctx.rect(inner.x, inner.y, inner.w, inner.h);
    		ctx.fill('evenodd');
    		ctx.restore();
    	},

    	height: function() {
    		var vm = this._view;
    		return vm.base - vm.y;
    	},

    	inRange: function(mouseX, mouseY) {
    		return inRange(this._view, mouseX, mouseY);
    	},

    	inLabelRange: function(mouseX, mouseY) {
    		var vm = this._view;
    		return isVertical(vm)
    			? inRange(vm, mouseX, null)
    			: inRange(vm, null, mouseY);
    	},

    	inXRange: function(mouseX) {
    		return inRange(this._view, mouseX, null);
    	},

    	inYRange: function(mouseY) {
    		return inRange(this._view, null, mouseY);
    	},

    	getCenterPoint: function() {
    		var vm = this._view;
    		var x, y;
    		if (isVertical(vm)) {
    			x = vm.x;
    			y = (vm.y + vm.base) / 2;
    		} else {
    			x = (vm.x + vm.base) / 2;
    			y = vm.y;
    		}

    		return {x: x, y: y};
    	},

    	getArea: function() {
    		var vm = this._view;

    		return isVertical(vm)
    			? vm.width * Math.abs(vm.y - vm.base)
    			: vm.height * Math.abs(vm.x - vm.base);
    	},

    	tooltipPosition: function() {
    		var vm = this._view;
    		return {
    			x: vm.x,
    			y: vm.y
    		};
    	}
    });

    var elements = {};
    var Arc = element_arc;
    var Line = element_line;
    var Point = element_point;
    var Rectangle = element_rectangle;
    elements.Arc = Arc;
    elements.Line = Line;
    elements.Point = Point;
    elements.Rectangle = Rectangle;

    var deprecated = helpers$1._deprecated;
    var valueOrDefault$3 = helpers$1.valueOrDefault;

    core_defaults._set('bar', {
    	hover: {
    		mode: 'label'
    	},

    	scales: {
    		xAxes: [{
    			type: 'category',
    			offset: true,
    			gridLines: {
    				offsetGridLines: true
    			}
    		}],

    		yAxes: [{
    			type: 'linear'
    		}]
    	}
    });

    core_defaults._set('global', {
    	datasets: {
    		bar: {
    			categoryPercentage: 0.8,
    			barPercentage: 0.9
    		}
    	}
    });

    /**
     * Computes the "optimal" sample size to maintain bars equally sized while preventing overlap.
     * @private
     */
    function computeMinSampleSize(scale, pixels) {
    	var min = scale._length;
    	var prev, curr, i, ilen;

    	for (i = 1, ilen = pixels.length; i < ilen; ++i) {
    		min = Math.min(min, Math.abs(pixels[i] - pixels[i - 1]));
    	}

    	for (i = 0, ilen = scale.getTicks().length; i < ilen; ++i) {
    		curr = scale.getPixelForTick(i);
    		min = i > 0 ? Math.min(min, Math.abs(curr - prev)) : min;
    		prev = curr;
    	}

    	return min;
    }

    /**
     * Computes an "ideal" category based on the absolute bar thickness or, if undefined or null,
     * uses the smallest interval (see computeMinSampleSize) that prevents bar overlapping. This
     * mode currently always generates bars equally sized (until we introduce scriptable options?).
     * @private
     */
    function computeFitCategoryTraits(index, ruler, options) {
    	var thickness = options.barThickness;
    	var count = ruler.stackCount;
    	var curr = ruler.pixels[index];
    	var min = helpers$1.isNullOrUndef(thickness)
    		? computeMinSampleSize(ruler.scale, ruler.pixels)
    		: -1;
    	var size, ratio;

    	if (helpers$1.isNullOrUndef(thickness)) {
    		size = min * options.categoryPercentage;
    		ratio = options.barPercentage;
    	} else {
    		// When bar thickness is enforced, category and bar percentages are ignored.
    		// Note(SB): we could add support for relative bar thickness (e.g. barThickness: '50%')
    		// and deprecate barPercentage since this value is ignored when thickness is absolute.
    		size = thickness * count;
    		ratio = 1;
    	}

    	return {
    		chunk: size / count,
    		ratio: ratio,
    		start: curr - (size / 2)
    	};
    }

    /**
     * Computes an "optimal" category that globally arranges bars side by side (no gap when
     * percentage options are 1), based on the previous and following categories. This mode
     * generates bars with different widths when data are not evenly spaced.
     * @private
     */
    function computeFlexCategoryTraits(index, ruler, options) {
    	var pixels = ruler.pixels;
    	var curr = pixels[index];
    	var prev = index > 0 ? pixels[index - 1] : null;
    	var next = index < pixels.length - 1 ? pixels[index + 1] : null;
    	var percent = options.categoryPercentage;
    	var start, size;

    	if (prev === null) {
    		// first data: its size is double based on the next point or,
    		// if it's also the last data, we use the scale size.
    		prev = curr - (next === null ? ruler.end - ruler.start : next - curr);
    	}

    	if (next === null) {
    		// last data: its size is also double based on the previous point.
    		next = curr + curr - prev;
    	}

    	start = curr - (curr - Math.min(prev, next)) / 2 * percent;
    	size = Math.abs(next - prev) / 2 * percent;

    	return {
    		chunk: size / ruler.stackCount,
    		ratio: options.barPercentage,
    		start: start
    	};
    }

    var controller_bar = core_datasetController.extend({

    	dataElementType: elements.Rectangle,

    	/**
    	 * @private
    	 */
    	_dataElementOptions: [
    		'backgroundColor',
    		'borderColor',
    		'borderSkipped',
    		'borderWidth',
    		'barPercentage',
    		'barThickness',
    		'categoryPercentage',
    		'maxBarThickness',
    		'minBarLength'
    	],

    	initialize: function() {
    		var me = this;
    		var meta, scaleOpts;

    		core_datasetController.prototype.initialize.apply(me, arguments);

    		meta = me.getMeta();
    		meta.stack = me.getDataset().stack;
    		meta.bar = true;

    		scaleOpts = me._getIndexScale().options;
    		deprecated('bar chart', scaleOpts.barPercentage, 'scales.[x/y]Axes.barPercentage', 'dataset.barPercentage');
    		deprecated('bar chart', scaleOpts.barThickness, 'scales.[x/y]Axes.barThickness', 'dataset.barThickness');
    		deprecated('bar chart', scaleOpts.categoryPercentage, 'scales.[x/y]Axes.categoryPercentage', 'dataset.categoryPercentage');
    		deprecated('bar chart', me._getValueScale().options.minBarLength, 'scales.[x/y]Axes.minBarLength', 'dataset.minBarLength');
    		deprecated('bar chart', scaleOpts.maxBarThickness, 'scales.[x/y]Axes.maxBarThickness', 'dataset.maxBarThickness');
    	},

    	update: function(reset) {
    		var me = this;
    		var rects = me.getMeta().data;
    		var i, ilen;

    		me._ruler = me.getRuler();

    		for (i = 0, ilen = rects.length; i < ilen; ++i) {
    			me.updateElement(rects[i], i, reset);
    		}
    	},

    	updateElement: function(rectangle, index, reset) {
    		var me = this;
    		var meta = me.getMeta();
    		var dataset = me.getDataset();
    		var options = me._resolveDataElementOptions(rectangle, index);

    		rectangle._xScale = me.getScaleForId(meta.xAxisID);
    		rectangle._yScale = me.getScaleForId(meta.yAxisID);
    		rectangle._datasetIndex = me.index;
    		rectangle._index = index;
    		rectangle._model = {
    			backgroundColor: options.backgroundColor,
    			borderColor: options.borderColor,
    			borderSkipped: options.borderSkipped,
    			borderWidth: options.borderWidth,
    			datasetLabel: dataset.label,
    			label: me.chart.data.labels[index]
    		};

    		if (helpers$1.isArray(dataset.data[index])) {
    			rectangle._model.borderSkipped = null;
    		}

    		me._updateElementGeometry(rectangle, index, reset, options);

    		rectangle.pivot();
    	},

    	/**
    	 * @private
    	 */
    	_updateElementGeometry: function(rectangle, index, reset, options) {
    		var me = this;
    		var model = rectangle._model;
    		var vscale = me._getValueScale();
    		var base = vscale.getBasePixel();
    		var horizontal = vscale.isHorizontal();
    		var ruler = me._ruler || me.getRuler();
    		var vpixels = me.calculateBarValuePixels(me.index, index, options);
    		var ipixels = me.calculateBarIndexPixels(me.index, index, ruler, options);

    		model.horizontal = horizontal;
    		model.base = reset ? base : vpixels.base;
    		model.x = horizontal ? reset ? base : vpixels.head : ipixels.center;
    		model.y = horizontal ? ipixels.center : reset ? base : vpixels.head;
    		model.height = horizontal ? ipixels.size : undefined;
    		model.width = horizontal ? undefined : ipixels.size;
    	},

    	/**
    	 * Returns the stacks based on groups and bar visibility.
    	 * @param {number} [last] - The dataset index
    	 * @returns {string[]} The list of stack IDs
    	 * @private
    	 */
    	_getStacks: function(last) {
    		var me = this;
    		var scale = me._getIndexScale();
    		var metasets = scale._getMatchingVisibleMetas(me._type);
    		var stacked = scale.options.stacked;
    		var ilen = metasets.length;
    		var stacks = [];
    		var i, meta;

    		for (i = 0; i < ilen; ++i) {
    			meta = metasets[i];
    			// stacked   | meta.stack
    			//           | found | not found | undefined
    			// false     |   x   |     x     |     x
    			// true      |       |     x     |
    			// undefined |       |     x     |     x
    			if (stacked === false || stacks.indexOf(meta.stack) === -1 ||
    				(stacked === undefined && meta.stack === undefined)) {
    				stacks.push(meta.stack);
    			}
    			if (meta.index === last) {
    				break;
    			}
    		}

    		return stacks;
    	},

    	/**
    	 * Returns the effective number of stacks based on groups and bar visibility.
    	 * @private
    	 */
    	getStackCount: function() {
    		return this._getStacks().length;
    	},

    	/**
    	 * Returns the stack index for the given dataset based on groups and bar visibility.
    	 * @param {number} [datasetIndex] - The dataset index
    	 * @param {string} [name] - The stack name to find
    	 * @returns {number} The stack index
    	 * @private
    	 */
    	getStackIndex: function(datasetIndex, name) {
    		var stacks = this._getStacks(datasetIndex);
    		var index = (name !== undefined)
    			? stacks.indexOf(name)
    			: -1; // indexOf returns -1 if element is not present

    		return (index === -1)
    			? stacks.length - 1
    			: index;
    	},

    	/**
    	 * @private
    	 */
    	getRuler: function() {
    		var me = this;
    		var scale = me._getIndexScale();
    		var pixels = [];
    		var i, ilen;

    		for (i = 0, ilen = me.getMeta().data.length; i < ilen; ++i) {
    			pixels.push(scale.getPixelForValue(null, i, me.index));
    		}

    		return {
    			pixels: pixels,
    			start: scale._startPixel,
    			end: scale._endPixel,
    			stackCount: me.getStackCount(),
    			scale: scale
    		};
    	},

    	/**
    	 * Note: pixel values are not clamped to the scale area.
    	 * @private
    	 */
    	calculateBarValuePixels: function(datasetIndex, index, options) {
    		var me = this;
    		var chart = me.chart;
    		var scale = me._getValueScale();
    		var isHorizontal = scale.isHorizontal();
    		var datasets = chart.data.datasets;
    		var metasets = scale._getMatchingVisibleMetas(me._type);
    		var value = scale._parseValue(datasets[datasetIndex].data[index]);
    		var minBarLength = options.minBarLength;
    		var stacked = scale.options.stacked;
    		var stack = me.getMeta().stack;
    		var start = value.start === undefined ? 0 : value.max >= 0 && value.min >= 0 ? value.min : value.max;
    		var length = value.start === undefined ? value.end : value.max >= 0 && value.min >= 0 ? value.max - value.min : value.min - value.max;
    		var ilen = metasets.length;
    		var i, imeta, ivalue, base, head, size, stackLength;

    		if (stacked || (stacked === undefined && stack !== undefined)) {
    			for (i = 0; i < ilen; ++i) {
    				imeta = metasets[i];

    				if (imeta.index === datasetIndex) {
    					break;
    				}

    				if (imeta.stack === stack) {
    					stackLength = scale._parseValue(datasets[imeta.index].data[index]);
    					ivalue = stackLength.start === undefined ? stackLength.end : stackLength.min >= 0 && stackLength.max >= 0 ? stackLength.max : stackLength.min;

    					if ((value.min < 0 && ivalue < 0) || (value.max >= 0 && ivalue > 0)) {
    						start += ivalue;
    					}
    				}
    			}
    		}

    		base = scale.getPixelForValue(start);
    		head = scale.getPixelForValue(start + length);
    		size = head - base;

    		if (minBarLength !== undefined && Math.abs(size) < minBarLength) {
    			size = minBarLength;
    			if (length >= 0 && !isHorizontal || length < 0 && isHorizontal) {
    				head = base - minBarLength;
    			} else {
    				head = base + minBarLength;
    			}
    		}

    		return {
    			size: size,
    			base: base,
    			head: head,
    			center: head + size / 2
    		};
    	},

    	/**
    	 * @private
    	 */
    	calculateBarIndexPixels: function(datasetIndex, index, ruler, options) {
    		var me = this;
    		var range = options.barThickness === 'flex'
    			? computeFlexCategoryTraits(index, ruler, options)
    			: computeFitCategoryTraits(index, ruler, options);

    		var stackIndex = me.getStackIndex(datasetIndex, me.getMeta().stack);
    		var center = range.start + (range.chunk * stackIndex) + (range.chunk / 2);
    		var size = Math.min(
    			valueOrDefault$3(options.maxBarThickness, Infinity),
    			range.chunk * range.ratio);

    		return {
    			base: center - size / 2,
    			head: center + size / 2,
    			center: center,
    			size: size
    		};
    	},

    	draw: function() {
    		var me = this;
    		var chart = me.chart;
    		var scale = me._getValueScale();
    		var rects = me.getMeta().data;
    		var dataset = me.getDataset();
    		var ilen = rects.length;
    		var i = 0;

    		helpers$1.canvas.clipArea(chart.ctx, chart.chartArea);

    		for (; i < ilen; ++i) {
    			var val = scale._parseValue(dataset.data[i]);
    			if (!isNaN(val.min) && !isNaN(val.max)) {
    				rects[i].draw();
    			}
    		}

    		helpers$1.canvas.unclipArea(chart.ctx);
    	},

    	/**
    	 * @private
    	 */
    	_resolveDataElementOptions: function() {
    		var me = this;
    		var values = helpers$1.extend({}, core_datasetController.prototype._resolveDataElementOptions.apply(me, arguments));
    		var indexOpts = me._getIndexScale().options;
    		var valueOpts = me._getValueScale().options;

    		values.barPercentage = valueOrDefault$3(indexOpts.barPercentage, values.barPercentage);
    		values.barThickness = valueOrDefault$3(indexOpts.barThickness, values.barThickness);
    		values.categoryPercentage = valueOrDefault$3(indexOpts.categoryPercentage, values.categoryPercentage);
    		values.maxBarThickness = valueOrDefault$3(indexOpts.maxBarThickness, values.maxBarThickness);
    		values.minBarLength = valueOrDefault$3(valueOpts.minBarLength, values.minBarLength);

    		return values;
    	}

    });

    var valueOrDefault$4 = helpers$1.valueOrDefault;
    var resolve$1 = helpers$1.options.resolve;

    core_defaults._set('bubble', {
    	hover: {
    		mode: 'single'
    	},

    	scales: {
    		xAxes: [{
    			type: 'linear', // bubble should probably use a linear scale by default
    			position: 'bottom',
    			id: 'x-axis-0' // need an ID so datasets can reference the scale
    		}],
    		yAxes: [{
    			type: 'linear',
    			position: 'left',
    			id: 'y-axis-0'
    		}]
    	},

    	tooltips: {
    		callbacks: {
    			title: function() {
    				// Title doesn't make sense for scatter since we format the data as a point
    				return '';
    			},
    			label: function(item, data) {
    				var datasetLabel = data.datasets[item.datasetIndex].label || '';
    				var dataPoint = data.datasets[item.datasetIndex].data[item.index];
    				return datasetLabel + ': (' + item.xLabel + ', ' + item.yLabel + ', ' + dataPoint.r + ')';
    			}
    		}
    	}
    });

    var controller_bubble = core_datasetController.extend({
    	/**
    	 * @protected
    	 */
    	dataElementType: elements.Point,

    	/**
    	 * @private
    	 */
    	_dataElementOptions: [
    		'backgroundColor',
    		'borderColor',
    		'borderWidth',
    		'hoverBackgroundColor',
    		'hoverBorderColor',
    		'hoverBorderWidth',
    		'hoverRadius',
    		'hitRadius',
    		'pointStyle',
    		'rotation'
    	],

    	/**
    	 * @protected
    	 */
    	update: function(reset) {
    		var me = this;
    		var meta = me.getMeta();
    		var points = meta.data;

    		// Update Points
    		helpers$1.each(points, function(point, index) {
    			me.updateElement(point, index, reset);
    		});
    	},

    	/**
    	 * @protected
    	 */
    	updateElement: function(point, index, reset) {
    		var me = this;
    		var meta = me.getMeta();
    		var custom = point.custom || {};
    		var xScale = me.getScaleForId(meta.xAxisID);
    		var yScale = me.getScaleForId(meta.yAxisID);
    		var options = me._resolveDataElementOptions(point, index);
    		var data = me.getDataset().data[index];
    		var dsIndex = me.index;

    		var x = reset ? xScale.getPixelForDecimal(0.5) : xScale.getPixelForValue(typeof data === 'object' ? data : NaN, index, dsIndex);
    		var y = reset ? yScale.getBasePixel() : yScale.getPixelForValue(data, index, dsIndex);

    		point._xScale = xScale;
    		point._yScale = yScale;
    		point._options = options;
    		point._datasetIndex = dsIndex;
    		point._index = index;
    		point._model = {
    			backgroundColor: options.backgroundColor,
    			borderColor: options.borderColor,
    			borderWidth: options.borderWidth,
    			hitRadius: options.hitRadius,
    			pointStyle: options.pointStyle,
    			rotation: options.rotation,
    			radius: reset ? 0 : options.radius,
    			skip: custom.skip || isNaN(x) || isNaN(y),
    			x: x,
    			y: y,
    		};

    		point.pivot();
    	},

    	/**
    	 * @protected
    	 */
    	setHoverStyle: function(point) {
    		var model = point._model;
    		var options = point._options;
    		var getHoverColor = helpers$1.getHoverColor;

    		point.$previousStyle = {
    			backgroundColor: model.backgroundColor,
    			borderColor: model.borderColor,
    			borderWidth: model.borderWidth,
    			radius: model.radius
    		};

    		model.backgroundColor = valueOrDefault$4(options.hoverBackgroundColor, getHoverColor(options.backgroundColor));
    		model.borderColor = valueOrDefault$4(options.hoverBorderColor, getHoverColor(options.borderColor));
    		model.borderWidth = valueOrDefault$4(options.hoverBorderWidth, options.borderWidth);
    		model.radius = options.radius + options.hoverRadius;
    	},

    	/**
    	 * @private
    	 */
    	_resolveDataElementOptions: function(point, index) {
    		var me = this;
    		var chart = me.chart;
    		var dataset = me.getDataset();
    		var custom = point.custom || {};
    		var data = dataset.data[index] || {};
    		var values = core_datasetController.prototype._resolveDataElementOptions.apply(me, arguments);

    		// Scriptable options
    		var context = {
    			chart: chart,
    			dataIndex: index,
    			dataset: dataset,
    			datasetIndex: me.index
    		};

    		// In case values were cached (and thus frozen), we need to clone the values
    		if (me._cachedDataOpts === values) {
    			values = helpers$1.extend({}, values);
    		}

    		// Custom radius resolution
    		values.radius = resolve$1([
    			custom.radius,
    			data.r,
    			me._config.radius,
    			chart.options.elements.point.radius
    		], context, index);

    		return values;
    	}
    });

    var valueOrDefault$5 = helpers$1.valueOrDefault;

    var PI$1 = Math.PI;
    var DOUBLE_PI$1 = PI$1 * 2;
    var HALF_PI$1 = PI$1 / 2;

    core_defaults._set('doughnut', {
    	animation: {
    		// Boolean - Whether we animate the rotation of the Doughnut
    		animateRotate: true,
    		// Boolean - Whether we animate scaling the Doughnut from the centre
    		animateScale: false
    	},
    	hover: {
    		mode: 'single'
    	},
    	legendCallback: function(chart) {
    		var list = document.createElement('ul');
    		var data = chart.data;
    		var datasets = data.datasets;
    		var labels = data.labels;
    		var i, ilen, listItem, listItemSpan;

    		list.setAttribute('class', chart.id + '-legend');
    		if (datasets.length) {
    			for (i = 0, ilen = datasets[0].data.length; i < ilen; ++i) {
    				listItem = list.appendChild(document.createElement('li'));
    				listItemSpan = listItem.appendChild(document.createElement('span'));
    				listItemSpan.style.backgroundColor = datasets[0].backgroundColor[i];
    				if (labels[i]) {
    					listItem.appendChild(document.createTextNode(labels[i]));
    				}
    			}
    		}

    		return list.outerHTML;
    	},
    	legend: {
    		labels: {
    			generateLabels: function(chart) {
    				var data = chart.data;
    				if (data.labels.length && data.datasets.length) {
    					return data.labels.map(function(label, i) {
    						var meta = chart.getDatasetMeta(0);
    						var style = meta.controller.getStyle(i);

    						return {
    							text: label,
    							fillStyle: style.backgroundColor,
    							strokeStyle: style.borderColor,
    							lineWidth: style.borderWidth,
    							hidden: isNaN(data.datasets[0].data[i]) || meta.data[i].hidden,

    							// Extra data used for toggling the correct item
    							index: i
    						};
    					});
    				}
    				return [];
    			}
    		},

    		onClick: function(e, legendItem) {
    			var index = legendItem.index;
    			var chart = this.chart;
    			var i, ilen, meta;

    			for (i = 0, ilen = (chart.data.datasets || []).length; i < ilen; ++i) {
    				meta = chart.getDatasetMeta(i);
    				// toggle visibility of index if exists
    				if (meta.data[index]) {
    					meta.data[index].hidden = !meta.data[index].hidden;
    				}
    			}

    			chart.update();
    		}
    	},

    	// The percentage of the chart that we cut out of the middle.
    	cutoutPercentage: 50,

    	// The rotation of the chart, where the first data arc begins.
    	rotation: -HALF_PI$1,

    	// The total circumference of the chart.
    	circumference: DOUBLE_PI$1,

    	// Need to override these to give a nice default
    	tooltips: {
    		callbacks: {
    			title: function() {
    				return '';
    			},
    			label: function(tooltipItem, data) {
    				var dataLabel = data.labels[tooltipItem.index];
    				var value = ': ' + data.datasets[tooltipItem.datasetIndex].data[tooltipItem.index];

    				if (helpers$1.isArray(dataLabel)) {
    					// show value on first line of multiline label
    					// need to clone because we are changing the value
    					dataLabel = dataLabel.slice();
    					dataLabel[0] += value;
    				} else {
    					dataLabel += value;
    				}

    				return dataLabel;
    			}
    		}
    	}
    });

    var controller_doughnut = core_datasetController.extend({

    	dataElementType: elements.Arc,

    	linkScales: helpers$1.noop,

    	/**
    	 * @private
    	 */
    	_dataElementOptions: [
    		'backgroundColor',
    		'borderColor',
    		'borderWidth',
    		'borderAlign',
    		'hoverBackgroundColor',
    		'hoverBorderColor',
    		'hoverBorderWidth',
    	],

    	// Get index of the dataset in relation to the visible datasets. This allows determining the inner and outer radius correctly
    	getRingIndex: function(datasetIndex) {
    		var ringIndex = 0;

    		for (var j = 0; j < datasetIndex; ++j) {
    			if (this.chart.isDatasetVisible(j)) {
    				++ringIndex;
    			}
    		}

    		return ringIndex;
    	},

    	update: function(reset) {
    		var me = this;
    		var chart = me.chart;
    		var chartArea = chart.chartArea;
    		var opts = chart.options;
    		var ratioX = 1;
    		var ratioY = 1;
    		var offsetX = 0;
    		var offsetY = 0;
    		var meta = me.getMeta();
    		var arcs = meta.data;
    		var cutout = opts.cutoutPercentage / 100 || 0;
    		var circumference = opts.circumference;
    		var chartWeight = me._getRingWeight(me.index);
    		var maxWidth, maxHeight, i, ilen;

    		// If the chart's circumference isn't a full circle, calculate size as a ratio of the width/height of the arc
    		if (circumference < DOUBLE_PI$1) {
    			var startAngle = opts.rotation % DOUBLE_PI$1;
    			startAngle += startAngle >= PI$1 ? -DOUBLE_PI$1 : startAngle < -PI$1 ? DOUBLE_PI$1 : 0;
    			var endAngle = startAngle + circumference;
    			var startX = Math.cos(startAngle);
    			var startY = Math.sin(startAngle);
    			var endX = Math.cos(endAngle);
    			var endY = Math.sin(endAngle);
    			var contains0 = (startAngle <= 0 && endAngle >= 0) || endAngle >= DOUBLE_PI$1;
    			var contains90 = (startAngle <= HALF_PI$1 && endAngle >= HALF_PI$1) || endAngle >= DOUBLE_PI$1 + HALF_PI$1;
    			var contains180 = startAngle === -PI$1 || endAngle >= PI$1;
    			var contains270 = (startAngle <= -HALF_PI$1 && endAngle >= -HALF_PI$1) || endAngle >= PI$1 + HALF_PI$1;
    			var minX = contains180 ? -1 : Math.min(startX, startX * cutout, endX, endX * cutout);
    			var minY = contains270 ? -1 : Math.min(startY, startY * cutout, endY, endY * cutout);
    			var maxX = contains0 ? 1 : Math.max(startX, startX * cutout, endX, endX * cutout);
    			var maxY = contains90 ? 1 : Math.max(startY, startY * cutout, endY, endY * cutout);
    			ratioX = (maxX - minX) / 2;
    			ratioY = (maxY - minY) / 2;
    			offsetX = -(maxX + minX) / 2;
    			offsetY = -(maxY + minY) / 2;
    		}

    		for (i = 0, ilen = arcs.length; i < ilen; ++i) {
    			arcs[i]._options = me._resolveDataElementOptions(arcs[i], i);
    		}

    		chart.borderWidth = me.getMaxBorderWidth();
    		maxWidth = (chartArea.right - chartArea.left - chart.borderWidth) / ratioX;
    		maxHeight = (chartArea.bottom - chartArea.top - chart.borderWidth) / ratioY;
    		chart.outerRadius = Math.max(Math.min(maxWidth, maxHeight) / 2, 0);
    		chart.innerRadius = Math.max(chart.outerRadius * cutout, 0);
    		chart.radiusLength = (chart.outerRadius - chart.innerRadius) / (me._getVisibleDatasetWeightTotal() || 1);
    		chart.offsetX = offsetX * chart.outerRadius;
    		chart.offsetY = offsetY * chart.outerRadius;

    		meta.total = me.calculateTotal();

    		me.outerRadius = chart.outerRadius - chart.radiusLength * me._getRingWeightOffset(me.index);
    		me.innerRadius = Math.max(me.outerRadius - chart.radiusLength * chartWeight, 0);

    		for (i = 0, ilen = arcs.length; i < ilen; ++i) {
    			me.updateElement(arcs[i], i, reset);
    		}
    	},

    	updateElement: function(arc, index, reset) {
    		var me = this;
    		var chart = me.chart;
    		var chartArea = chart.chartArea;
    		var opts = chart.options;
    		var animationOpts = opts.animation;
    		var centerX = (chartArea.left + chartArea.right) / 2;
    		var centerY = (chartArea.top + chartArea.bottom) / 2;
    		var startAngle = opts.rotation; // non reset case handled later
    		var endAngle = opts.rotation; // non reset case handled later
    		var dataset = me.getDataset();
    		var circumference = reset && animationOpts.animateRotate ? 0 : arc.hidden ? 0 : me.calculateCircumference(dataset.data[index]) * (opts.circumference / DOUBLE_PI$1);
    		var innerRadius = reset && animationOpts.animateScale ? 0 : me.innerRadius;
    		var outerRadius = reset && animationOpts.animateScale ? 0 : me.outerRadius;
    		var options = arc._options || {};

    		helpers$1.extend(arc, {
    			// Utility
    			_datasetIndex: me.index,
    			_index: index,

    			// Desired view properties
    			_model: {
    				backgroundColor: options.backgroundColor,
    				borderColor: options.borderColor,
    				borderWidth: options.borderWidth,
    				borderAlign: options.borderAlign,
    				x: centerX + chart.offsetX,
    				y: centerY + chart.offsetY,
    				startAngle: startAngle,
    				endAngle: endAngle,
    				circumference: circumference,
    				outerRadius: outerRadius,
    				innerRadius: innerRadius,
    				label: helpers$1.valueAtIndexOrDefault(dataset.label, index, chart.data.labels[index])
    			}
    		});

    		var model = arc._model;

    		// Set correct angles if not resetting
    		if (!reset || !animationOpts.animateRotate) {
    			if (index === 0) {
    				model.startAngle = opts.rotation;
    			} else {
    				model.startAngle = me.getMeta().data[index - 1]._model.endAngle;
    			}

    			model.endAngle = model.startAngle + model.circumference;
    		}

    		arc.pivot();
    	},

    	calculateTotal: function() {
    		var dataset = this.getDataset();
    		var meta = this.getMeta();
    		var total = 0;
    		var value;

    		helpers$1.each(meta.data, function(element, index) {
    			value = dataset.data[index];
    			if (!isNaN(value) && !element.hidden) {
    				total += Math.abs(value);
    			}
    		});

    		/* if (total === 0) {
    			total = NaN;
    		}*/

    		return total;
    	},

    	calculateCircumference: function(value) {
    		var total = this.getMeta().total;
    		if (total > 0 && !isNaN(value)) {
    			return DOUBLE_PI$1 * (Math.abs(value) / total);
    		}
    		return 0;
    	},

    	// gets the max border or hover width to properly scale pie charts
    	getMaxBorderWidth: function(arcs) {
    		var me = this;
    		var max = 0;
    		var chart = me.chart;
    		var i, ilen, meta, arc, controller, options, borderWidth, hoverWidth;

    		if (!arcs) {
    			// Find the outmost visible dataset
    			for (i = 0, ilen = chart.data.datasets.length; i < ilen; ++i) {
    				if (chart.isDatasetVisible(i)) {
    					meta = chart.getDatasetMeta(i);
    					arcs = meta.data;
    					if (i !== me.index) {
    						controller = meta.controller;
    					}
    					break;
    				}
    			}
    		}

    		if (!arcs) {
    			return 0;
    		}

    		for (i = 0, ilen = arcs.length; i < ilen; ++i) {
    			arc = arcs[i];
    			if (controller) {
    				controller._configure();
    				options = controller._resolveDataElementOptions(arc, i);
    			} else {
    				options = arc._options;
    			}
    			if (options.borderAlign !== 'inner') {
    				borderWidth = options.borderWidth;
    				hoverWidth = options.hoverBorderWidth;

    				max = borderWidth > max ? borderWidth : max;
    				max = hoverWidth > max ? hoverWidth : max;
    			}
    		}
    		return max;
    	},

    	/**
    	 * @protected
    	 */
    	setHoverStyle: function(arc) {
    		var model = arc._model;
    		var options = arc._options;
    		var getHoverColor = helpers$1.getHoverColor;

    		arc.$previousStyle = {
    			backgroundColor: model.backgroundColor,
    			borderColor: model.borderColor,
    			borderWidth: model.borderWidth,
    		};

    		model.backgroundColor = valueOrDefault$5(options.hoverBackgroundColor, getHoverColor(options.backgroundColor));
    		model.borderColor = valueOrDefault$5(options.hoverBorderColor, getHoverColor(options.borderColor));
    		model.borderWidth = valueOrDefault$5(options.hoverBorderWidth, options.borderWidth);
    	},

    	/**
    	 * Get radius length offset of the dataset in relation to the visible datasets weights. This allows determining the inner and outer radius correctly
    	 * @private
    	 */
    	_getRingWeightOffset: function(datasetIndex) {
    		var ringWeightOffset = 0;

    		for (var i = 0; i < datasetIndex; ++i) {
    			if (this.chart.isDatasetVisible(i)) {
    				ringWeightOffset += this._getRingWeight(i);
    			}
    		}

    		return ringWeightOffset;
    	},

    	/**
    	 * @private
    	 */
    	_getRingWeight: function(dataSetIndex) {
    		return Math.max(valueOrDefault$5(this.chart.data.datasets[dataSetIndex].weight, 1), 0);
    	},

    	/**
    	 * Returns the sum of all visibile data set weights.  This value can be 0.
    	 * @private
    	 */
    	_getVisibleDatasetWeightTotal: function() {
    		return this._getRingWeightOffset(this.chart.data.datasets.length);
    	}
    });

    core_defaults._set('horizontalBar', {
    	hover: {
    		mode: 'index',
    		axis: 'y'
    	},

    	scales: {
    		xAxes: [{
    			type: 'linear',
    			position: 'bottom'
    		}],

    		yAxes: [{
    			type: 'category',
    			position: 'left',
    			offset: true,
    			gridLines: {
    				offsetGridLines: true
    			}
    		}]
    	},

    	elements: {
    		rectangle: {
    			borderSkipped: 'left'
    		}
    	},

    	tooltips: {
    		mode: 'index',
    		axis: 'y'
    	}
    });

    core_defaults._set('global', {
    	datasets: {
    		horizontalBar: {
    			categoryPercentage: 0.8,
    			barPercentage: 0.9
    		}
    	}
    });

    var controller_horizontalBar = controller_bar.extend({
    	/**
    	 * @private
    	 */
    	_getValueScaleId: function() {
    		return this.getMeta().xAxisID;
    	},

    	/**
    	 * @private
    	 */
    	_getIndexScaleId: function() {
    		return this.getMeta().yAxisID;
    	}
    });

    var valueOrDefault$6 = helpers$1.valueOrDefault;
    var resolve$2 = helpers$1.options.resolve;
    var isPointInArea = helpers$1.canvas._isPointInArea;

    core_defaults._set('line', {
    	showLines: true,
    	spanGaps: false,

    	hover: {
    		mode: 'label'
    	},

    	scales: {
    		xAxes: [{
    			type: 'category',
    			id: 'x-axis-0'
    		}],
    		yAxes: [{
    			type: 'linear',
    			id: 'y-axis-0'
    		}]
    	}
    });

    function scaleClip(scale, halfBorderWidth) {
    	var tickOpts = scale && scale.options.ticks || {};
    	var reverse = tickOpts.reverse;
    	var min = tickOpts.min === undefined ? halfBorderWidth : 0;
    	var max = tickOpts.max === undefined ? halfBorderWidth : 0;
    	return {
    		start: reverse ? max : min,
    		end: reverse ? min : max
    	};
    }

    function defaultClip(xScale, yScale, borderWidth) {
    	var halfBorderWidth = borderWidth / 2;
    	var x = scaleClip(xScale, halfBorderWidth);
    	var y = scaleClip(yScale, halfBorderWidth);

    	return {
    		top: y.end,
    		right: x.end,
    		bottom: y.start,
    		left: x.start
    	};
    }

    function toClip(value) {
    	var t, r, b, l;

    	if (helpers$1.isObject(value)) {
    		t = value.top;
    		r = value.right;
    		b = value.bottom;
    		l = value.left;
    	} else {
    		t = r = b = l = value;
    	}

    	return {
    		top: t,
    		right: r,
    		bottom: b,
    		left: l
    	};
    }


    var controller_line = core_datasetController.extend({

    	datasetElementType: elements.Line,

    	dataElementType: elements.Point,

    	/**
    	 * @private
    	 */
    	_datasetElementOptions: [
    		'backgroundColor',
    		'borderCapStyle',
    		'borderColor',
    		'borderDash',
    		'borderDashOffset',
    		'borderJoinStyle',
    		'borderWidth',
    		'cubicInterpolationMode',
    		'fill'
    	],

    	/**
    	 * @private
    	 */
    	_dataElementOptions: {
    		backgroundColor: 'pointBackgroundColor',
    		borderColor: 'pointBorderColor',
    		borderWidth: 'pointBorderWidth',
    		hitRadius: 'pointHitRadius',
    		hoverBackgroundColor: 'pointHoverBackgroundColor',
    		hoverBorderColor: 'pointHoverBorderColor',
    		hoverBorderWidth: 'pointHoverBorderWidth',
    		hoverRadius: 'pointHoverRadius',
    		pointStyle: 'pointStyle',
    		radius: 'pointRadius',
    		rotation: 'pointRotation'
    	},

    	update: function(reset) {
    		var me = this;
    		var meta = me.getMeta();
    		var line = meta.dataset;
    		var points = meta.data || [];
    		var options = me.chart.options;
    		var config = me._config;
    		var showLine = me._showLine = valueOrDefault$6(config.showLine, options.showLines);
    		var i, ilen;

    		me._xScale = me.getScaleForId(meta.xAxisID);
    		me._yScale = me.getScaleForId(meta.yAxisID);

    		// Update Line
    		if (showLine) {
    			// Compatibility: If the properties are defined with only the old name, use those values
    			if (config.tension !== undefined && config.lineTension === undefined) {
    				config.lineTension = config.tension;
    			}

    			// Utility
    			line._scale = me._yScale;
    			line._datasetIndex = me.index;
    			// Data
    			line._children = points;
    			// Model
    			line._model = me._resolveDatasetElementOptions(line);

    			line.pivot();
    		}

    		// Update Points
    		for (i = 0, ilen = points.length; i < ilen; ++i) {
    			me.updateElement(points[i], i, reset);
    		}

    		if (showLine && line._model.tension !== 0) {
    			me.updateBezierControlPoints();
    		}

    		// Now pivot the point for animation
    		for (i = 0, ilen = points.length; i < ilen; ++i) {
    			points[i].pivot();
    		}
    	},

    	updateElement: function(point, index, reset) {
    		var me = this;
    		var meta = me.getMeta();
    		var custom = point.custom || {};
    		var dataset = me.getDataset();
    		var datasetIndex = me.index;
    		var value = dataset.data[index];
    		var xScale = me._xScale;
    		var yScale = me._yScale;
    		var lineModel = meta.dataset._model;
    		var x, y;

    		var options = me._resolveDataElementOptions(point, index);

    		x = xScale.getPixelForValue(typeof value === 'object' ? value : NaN, index, datasetIndex);
    		y = reset ? yScale.getBasePixel() : me.calculatePointY(value, index, datasetIndex);

    		// Utility
    		point._xScale = xScale;
    		point._yScale = yScale;
    		point._options = options;
    		point._datasetIndex = datasetIndex;
    		point._index = index;

    		// Desired view properties
    		point._model = {
    			x: x,
    			y: y,
    			skip: custom.skip || isNaN(x) || isNaN(y),
    			// Appearance
    			radius: options.radius,
    			pointStyle: options.pointStyle,
    			rotation: options.rotation,
    			backgroundColor: options.backgroundColor,
    			borderColor: options.borderColor,
    			borderWidth: options.borderWidth,
    			tension: valueOrDefault$6(custom.tension, lineModel ? lineModel.tension : 0),
    			steppedLine: lineModel ? lineModel.steppedLine : false,
    			// Tooltip
    			hitRadius: options.hitRadius
    		};
    	},

    	/**
    	 * @private
    	 */
    	_resolveDatasetElementOptions: function(element) {
    		var me = this;
    		var config = me._config;
    		var custom = element.custom || {};
    		var options = me.chart.options;
    		var lineOptions = options.elements.line;
    		var values = core_datasetController.prototype._resolveDatasetElementOptions.apply(me, arguments);

    		// The default behavior of lines is to break at null values, according
    		// to https://github.com/chartjs/Chart.js/issues/2435#issuecomment-216718158
    		// This option gives lines the ability to span gaps
    		values.spanGaps = valueOrDefault$6(config.spanGaps, options.spanGaps);
    		values.tension = valueOrDefault$6(config.lineTension, lineOptions.tension);
    		values.steppedLine = resolve$2([custom.steppedLine, config.steppedLine, lineOptions.stepped]);
    		values.clip = toClip(valueOrDefault$6(config.clip, defaultClip(me._xScale, me._yScale, values.borderWidth)));

    		return values;
    	},

    	calculatePointY: function(value, index, datasetIndex) {
    		var me = this;
    		var chart = me.chart;
    		var yScale = me._yScale;
    		var sumPos = 0;
    		var sumNeg = 0;
    		var i, ds, dsMeta, stackedRightValue, rightValue, metasets, ilen;

    		if (yScale.options.stacked) {
    			rightValue = +yScale.getRightValue(value);
    			metasets = chart._getSortedVisibleDatasetMetas();
    			ilen = metasets.length;

    			for (i = 0; i < ilen; ++i) {
    				dsMeta = metasets[i];
    				if (dsMeta.index === datasetIndex) {
    					break;
    				}

    				ds = chart.data.datasets[dsMeta.index];
    				if (dsMeta.type === 'line' && dsMeta.yAxisID === yScale.id) {
    					stackedRightValue = +yScale.getRightValue(ds.data[index]);
    					if (stackedRightValue < 0) {
    						sumNeg += stackedRightValue || 0;
    					} else {
    						sumPos += stackedRightValue || 0;
    					}
    				}
    			}

    			if (rightValue < 0) {
    				return yScale.getPixelForValue(sumNeg + rightValue);
    			}
    			return yScale.getPixelForValue(sumPos + rightValue);
    		}
    		return yScale.getPixelForValue(value);
    	},

    	updateBezierControlPoints: function() {
    		var me = this;
    		var chart = me.chart;
    		var meta = me.getMeta();
    		var lineModel = meta.dataset._model;
    		var area = chart.chartArea;
    		var points = meta.data || [];
    		var i, ilen, model, controlPoints;

    		// Only consider points that are drawn in case the spanGaps option is used
    		if (lineModel.spanGaps) {
    			points = points.filter(function(pt) {
    				return !pt._model.skip;
    			});
    		}

    		function capControlPoint(pt, min, max) {
    			return Math.max(Math.min(pt, max), min);
    		}

    		if (lineModel.cubicInterpolationMode === 'monotone') {
    			helpers$1.splineCurveMonotone(points);
    		} else {
    			for (i = 0, ilen = points.length; i < ilen; ++i) {
    				model = points[i]._model;
    				controlPoints = helpers$1.splineCurve(
    					helpers$1.previousItem(points, i)._model,
    					model,
    					helpers$1.nextItem(points, i)._model,
    					lineModel.tension
    				);
    				model.controlPointPreviousX = controlPoints.previous.x;
    				model.controlPointPreviousY = controlPoints.previous.y;
    				model.controlPointNextX = controlPoints.next.x;
    				model.controlPointNextY = controlPoints.next.y;
    			}
    		}

    		if (chart.options.elements.line.capBezierPoints) {
    			for (i = 0, ilen = points.length; i < ilen; ++i) {
    				model = points[i]._model;
    				if (isPointInArea(model, area)) {
    					if (i > 0 && isPointInArea(points[i - 1]._model, area)) {
    						model.controlPointPreviousX = capControlPoint(model.controlPointPreviousX, area.left, area.right);
    						model.controlPointPreviousY = capControlPoint(model.controlPointPreviousY, area.top, area.bottom);
    					}
    					if (i < points.length - 1 && isPointInArea(points[i + 1]._model, area)) {
    						model.controlPointNextX = capControlPoint(model.controlPointNextX, area.left, area.right);
    						model.controlPointNextY = capControlPoint(model.controlPointNextY, area.top, area.bottom);
    					}
    				}
    			}
    		}
    	},

    	draw: function() {
    		var me = this;
    		var chart = me.chart;
    		var meta = me.getMeta();
    		var points = meta.data || [];
    		var area = chart.chartArea;
    		var canvas = chart.canvas;
    		var i = 0;
    		var ilen = points.length;
    		var clip;

    		if (me._showLine) {
    			clip = meta.dataset._model.clip;

    			helpers$1.canvas.clipArea(chart.ctx, {
    				left: clip.left === false ? 0 : area.left - clip.left,
    				right: clip.right === false ? canvas.width : area.right + clip.right,
    				top: clip.top === false ? 0 : area.top - clip.top,
    				bottom: clip.bottom === false ? canvas.height : area.bottom + clip.bottom
    			});

    			meta.dataset.draw();

    			helpers$1.canvas.unclipArea(chart.ctx);
    		}

    		// Draw the points
    		for (; i < ilen; ++i) {
    			points[i].draw(area);
    		}
    	},

    	/**
    	 * @protected
    	 */
    	setHoverStyle: function(point) {
    		var model = point._model;
    		var options = point._options;
    		var getHoverColor = helpers$1.getHoverColor;

    		point.$previousStyle = {
    			backgroundColor: model.backgroundColor,
    			borderColor: model.borderColor,
    			borderWidth: model.borderWidth,
    			radius: model.radius
    		};

    		model.backgroundColor = valueOrDefault$6(options.hoverBackgroundColor, getHoverColor(options.backgroundColor));
    		model.borderColor = valueOrDefault$6(options.hoverBorderColor, getHoverColor(options.borderColor));
    		model.borderWidth = valueOrDefault$6(options.hoverBorderWidth, options.borderWidth);
    		model.radius = valueOrDefault$6(options.hoverRadius, options.radius);
    	},
    });

    var resolve$3 = helpers$1.options.resolve;

    core_defaults._set('polarArea', {
    	scale: {
    		type: 'radialLinear',
    		angleLines: {
    			display: false
    		},
    		gridLines: {
    			circular: true
    		},
    		pointLabels: {
    			display: false
    		},
    		ticks: {
    			beginAtZero: true
    		}
    	},

    	// Boolean - Whether to animate the rotation of the chart
    	animation: {
    		animateRotate: true,
    		animateScale: true
    	},

    	startAngle: -0.5 * Math.PI,
    	legendCallback: function(chart) {
    		var list = document.createElement('ul');
    		var data = chart.data;
    		var datasets = data.datasets;
    		var labels = data.labels;
    		var i, ilen, listItem, listItemSpan;

    		list.setAttribute('class', chart.id + '-legend');
    		if (datasets.length) {
    			for (i = 0, ilen = datasets[0].data.length; i < ilen; ++i) {
    				listItem = list.appendChild(document.createElement('li'));
    				listItemSpan = listItem.appendChild(document.createElement('span'));
    				listItemSpan.style.backgroundColor = datasets[0].backgroundColor[i];
    				if (labels[i]) {
    					listItem.appendChild(document.createTextNode(labels[i]));
    				}
    			}
    		}

    		return list.outerHTML;
    	},
    	legend: {
    		labels: {
    			generateLabels: function(chart) {
    				var data = chart.data;
    				if (data.labels.length && data.datasets.length) {
    					return data.labels.map(function(label, i) {
    						var meta = chart.getDatasetMeta(0);
    						var style = meta.controller.getStyle(i);

    						return {
    							text: label,
    							fillStyle: style.backgroundColor,
    							strokeStyle: style.borderColor,
    							lineWidth: style.borderWidth,
    							hidden: isNaN(data.datasets[0].data[i]) || meta.data[i].hidden,

    							// Extra data used for toggling the correct item
    							index: i
    						};
    					});
    				}
    				return [];
    			}
    		},

    		onClick: function(e, legendItem) {
    			var index = legendItem.index;
    			var chart = this.chart;
    			var i, ilen, meta;

    			for (i = 0, ilen = (chart.data.datasets || []).length; i < ilen; ++i) {
    				meta = chart.getDatasetMeta(i);
    				meta.data[index].hidden = !meta.data[index].hidden;
    			}

    			chart.update();
    		}
    	},

    	// Need to override these to give a nice default
    	tooltips: {
    		callbacks: {
    			title: function() {
    				return '';
    			},
    			label: function(item, data) {
    				return data.labels[item.index] + ': ' + item.yLabel;
    			}
    		}
    	}
    });

    var controller_polarArea = core_datasetController.extend({

    	dataElementType: elements.Arc,

    	linkScales: helpers$1.noop,

    	/**
    	 * @private
    	 */
    	_dataElementOptions: [
    		'backgroundColor',
    		'borderColor',
    		'borderWidth',
    		'borderAlign',
    		'hoverBackgroundColor',
    		'hoverBorderColor',
    		'hoverBorderWidth',
    	],

    	/**
    	 * @private
    	 */
    	_getIndexScaleId: function() {
    		return this.chart.scale.id;
    	},

    	/**
    	 * @private
    	 */
    	_getValueScaleId: function() {
    		return this.chart.scale.id;
    	},

    	update: function(reset) {
    		var me = this;
    		var dataset = me.getDataset();
    		var meta = me.getMeta();
    		var start = me.chart.options.startAngle || 0;
    		var starts = me._starts = [];
    		var angles = me._angles = [];
    		var arcs = meta.data;
    		var i, ilen, angle;

    		me._updateRadius();

    		meta.count = me.countVisibleElements();

    		for (i = 0, ilen = dataset.data.length; i < ilen; i++) {
    			starts[i] = start;
    			angle = me._computeAngle(i);
    			angles[i] = angle;
    			start += angle;
    		}

    		for (i = 0, ilen = arcs.length; i < ilen; ++i) {
    			arcs[i]._options = me._resolveDataElementOptions(arcs[i], i);
    			me.updateElement(arcs[i], i, reset);
    		}
    	},

    	/**
    	 * @private
    	 */
    	_updateRadius: function() {
    		var me = this;
    		var chart = me.chart;
    		var chartArea = chart.chartArea;
    		var opts = chart.options;
    		var minSize = Math.min(chartArea.right - chartArea.left, chartArea.bottom - chartArea.top);

    		chart.outerRadius = Math.max(minSize / 2, 0);
    		chart.innerRadius = Math.max(opts.cutoutPercentage ? (chart.outerRadius / 100) * (opts.cutoutPercentage) : 1, 0);
    		chart.radiusLength = (chart.outerRadius - chart.innerRadius) / chart.getVisibleDatasetCount();

    		me.outerRadius = chart.outerRadius - (chart.radiusLength * me.index);
    		me.innerRadius = me.outerRadius - chart.radiusLength;
    	},

    	updateElement: function(arc, index, reset) {
    		var me = this;
    		var chart = me.chart;
    		var dataset = me.getDataset();
    		var opts = chart.options;
    		var animationOpts = opts.animation;
    		var scale = chart.scale;
    		var labels = chart.data.labels;

    		var centerX = scale.xCenter;
    		var centerY = scale.yCenter;

    		// var negHalfPI = -0.5 * Math.PI;
    		var datasetStartAngle = opts.startAngle;
    		var distance = arc.hidden ? 0 : scale.getDistanceFromCenterForValue(dataset.data[index]);
    		var startAngle = me._starts[index];
    		var endAngle = startAngle + (arc.hidden ? 0 : me._angles[index]);

    		var resetRadius = animationOpts.animateScale ? 0 : scale.getDistanceFromCenterForValue(dataset.data[index]);
    		var options = arc._options || {};

    		helpers$1.extend(arc, {
    			// Utility
    			_datasetIndex: me.index,
    			_index: index,
    			_scale: scale,

    			// Desired view properties
    			_model: {
    				backgroundColor: options.backgroundColor,
    				borderColor: options.borderColor,
    				borderWidth: options.borderWidth,
    				borderAlign: options.borderAlign,
    				x: centerX,
    				y: centerY,
    				innerRadius: 0,
    				outerRadius: reset ? resetRadius : distance,
    				startAngle: reset && animationOpts.animateRotate ? datasetStartAngle : startAngle,
    				endAngle: reset && animationOpts.animateRotate ? datasetStartAngle : endAngle,
    				label: helpers$1.valueAtIndexOrDefault(labels, index, labels[index])
    			}
    		});

    		arc.pivot();
    	},

    	countVisibleElements: function() {
    		var dataset = this.getDataset();
    		var meta = this.getMeta();
    		var count = 0;

    		helpers$1.each(meta.data, function(element, index) {
    			if (!isNaN(dataset.data[index]) && !element.hidden) {
    				count++;
    			}
    		});

    		return count;
    	},

    	/**
    	 * @protected
    	 */
    	setHoverStyle: function(arc) {
    		var model = arc._model;
    		var options = arc._options;
    		var getHoverColor = helpers$1.getHoverColor;
    		var valueOrDefault = helpers$1.valueOrDefault;

    		arc.$previousStyle = {
    			backgroundColor: model.backgroundColor,
    			borderColor: model.borderColor,
    			borderWidth: model.borderWidth,
    		};

    		model.backgroundColor = valueOrDefault(options.hoverBackgroundColor, getHoverColor(options.backgroundColor));
    		model.borderColor = valueOrDefault(options.hoverBorderColor, getHoverColor(options.borderColor));
    		model.borderWidth = valueOrDefault(options.hoverBorderWidth, options.borderWidth);
    	},

    	/**
    	 * @private
    	 */
    	_computeAngle: function(index) {
    		var me = this;
    		var count = this.getMeta().count;
    		var dataset = me.getDataset();
    		var meta = me.getMeta();

    		if (isNaN(dataset.data[index]) || meta.data[index].hidden) {
    			return 0;
    		}

    		// Scriptable options
    		var context = {
    			chart: me.chart,
    			dataIndex: index,
    			dataset: dataset,
    			datasetIndex: me.index
    		};

    		return resolve$3([
    			me.chart.options.elements.arc.angle,
    			(2 * Math.PI) / count
    		], context, index);
    	}
    });

    core_defaults._set('pie', helpers$1.clone(core_defaults.doughnut));
    core_defaults._set('pie', {
    	cutoutPercentage: 0
    });

    // Pie charts are Doughnut chart with different defaults
    var controller_pie = controller_doughnut;

    var valueOrDefault$7 = helpers$1.valueOrDefault;

    core_defaults._set('radar', {
    	spanGaps: false,
    	scale: {
    		type: 'radialLinear'
    	},
    	elements: {
    		line: {
    			fill: 'start',
    			tension: 0 // no bezier in radar
    		}
    	}
    });

    var controller_radar = core_datasetController.extend({
    	datasetElementType: elements.Line,

    	dataElementType: elements.Point,

    	linkScales: helpers$1.noop,

    	/**
    	 * @private
    	 */
    	_datasetElementOptions: [
    		'backgroundColor',
    		'borderWidth',
    		'borderColor',
    		'borderCapStyle',
    		'borderDash',
    		'borderDashOffset',
    		'borderJoinStyle',
    		'fill'
    	],

    	/**
    	 * @private
    	 */
    	_dataElementOptions: {
    		backgroundColor: 'pointBackgroundColor',
    		borderColor: 'pointBorderColor',
    		borderWidth: 'pointBorderWidth',
    		hitRadius: 'pointHitRadius',
    		hoverBackgroundColor: 'pointHoverBackgroundColor',
    		hoverBorderColor: 'pointHoverBorderColor',
    		hoverBorderWidth: 'pointHoverBorderWidth',
    		hoverRadius: 'pointHoverRadius',
    		pointStyle: 'pointStyle',
    		radius: 'pointRadius',
    		rotation: 'pointRotation'
    	},

    	/**
    	 * @private
    	 */
    	_getIndexScaleId: function() {
    		return this.chart.scale.id;
    	},

    	/**
    	 * @private
    	 */
    	_getValueScaleId: function() {
    		return this.chart.scale.id;
    	},

    	update: function(reset) {
    		var me = this;
    		var meta = me.getMeta();
    		var line = meta.dataset;
    		var points = meta.data || [];
    		var scale = me.chart.scale;
    		var config = me._config;
    		var i, ilen;

    		// Compatibility: If the properties are defined with only the old name, use those values
    		if (config.tension !== undefined && config.lineTension === undefined) {
    			config.lineTension = config.tension;
    		}

    		// Utility
    		line._scale = scale;
    		line._datasetIndex = me.index;
    		// Data
    		line._children = points;
    		line._loop = true;
    		// Model
    		line._model = me._resolveDatasetElementOptions(line);

    		line.pivot();

    		// Update Points
    		for (i = 0, ilen = points.length; i < ilen; ++i) {
    			me.updateElement(points[i], i, reset);
    		}

    		// Update bezier control points
    		me.updateBezierControlPoints();

    		// Now pivot the point for animation
    		for (i = 0, ilen = points.length; i < ilen; ++i) {
    			points[i].pivot();
    		}
    	},

    	updateElement: function(point, index, reset) {
    		var me = this;
    		var custom = point.custom || {};
    		var dataset = me.getDataset();
    		var scale = me.chart.scale;
    		var pointPosition = scale.getPointPositionForValue(index, dataset.data[index]);
    		var options = me._resolveDataElementOptions(point, index);
    		var lineModel = me.getMeta().dataset._model;
    		var x = reset ? scale.xCenter : pointPosition.x;
    		var y = reset ? scale.yCenter : pointPosition.y;

    		// Utility
    		point._scale = scale;
    		point._options = options;
    		point._datasetIndex = me.index;
    		point._index = index;

    		// Desired view properties
    		point._model = {
    			x: x, // value not used in dataset scale, but we want a consistent API between scales
    			y: y,
    			skip: custom.skip || isNaN(x) || isNaN(y),
    			// Appearance
    			radius: options.radius,
    			pointStyle: options.pointStyle,
    			rotation: options.rotation,
    			backgroundColor: options.backgroundColor,
    			borderColor: options.borderColor,
    			borderWidth: options.borderWidth,
    			tension: valueOrDefault$7(custom.tension, lineModel ? lineModel.tension : 0),

    			// Tooltip
    			hitRadius: options.hitRadius
    		};
    	},

    	/**
    	 * @private
    	 */
    	_resolveDatasetElementOptions: function() {
    		var me = this;
    		var config = me._config;
    		var options = me.chart.options;
    		var values = core_datasetController.prototype._resolveDatasetElementOptions.apply(me, arguments);

    		values.spanGaps = valueOrDefault$7(config.spanGaps, options.spanGaps);
    		values.tension = valueOrDefault$7(config.lineTension, options.elements.line.tension);

    		return values;
    	},

    	updateBezierControlPoints: function() {
    		var me = this;
    		var meta = me.getMeta();
    		var area = me.chart.chartArea;
    		var points = meta.data || [];
    		var i, ilen, model, controlPoints;

    		// Only consider points that are drawn in case the spanGaps option is used
    		if (meta.dataset._model.spanGaps) {
    			points = points.filter(function(pt) {
    				return !pt._model.skip;
    			});
    		}

    		function capControlPoint(pt, min, max) {
    			return Math.max(Math.min(pt, max), min);
    		}

    		for (i = 0, ilen = points.length; i < ilen; ++i) {
    			model = points[i]._model;
    			controlPoints = helpers$1.splineCurve(
    				helpers$1.previousItem(points, i, true)._model,
    				model,
    				helpers$1.nextItem(points, i, true)._model,
    				model.tension
    			);

    			// Prevent the bezier going outside of the bounds of the graph
    			model.controlPointPreviousX = capControlPoint(controlPoints.previous.x, area.left, area.right);
    			model.controlPointPreviousY = capControlPoint(controlPoints.previous.y, area.top, area.bottom);
    			model.controlPointNextX = capControlPoint(controlPoints.next.x, area.left, area.right);
    			model.controlPointNextY = capControlPoint(controlPoints.next.y, area.top, area.bottom);
    		}
    	},

    	setHoverStyle: function(point) {
    		var model = point._model;
    		var options = point._options;
    		var getHoverColor = helpers$1.getHoverColor;

    		point.$previousStyle = {
    			backgroundColor: model.backgroundColor,
    			borderColor: model.borderColor,
    			borderWidth: model.borderWidth,
    			radius: model.radius
    		};

    		model.backgroundColor = valueOrDefault$7(options.hoverBackgroundColor, getHoverColor(options.backgroundColor));
    		model.borderColor = valueOrDefault$7(options.hoverBorderColor, getHoverColor(options.borderColor));
    		model.borderWidth = valueOrDefault$7(options.hoverBorderWidth, options.borderWidth);
    		model.radius = valueOrDefault$7(options.hoverRadius, options.radius);
    	}
    });

    core_defaults._set('scatter', {
    	hover: {
    		mode: 'single'
    	},

    	scales: {
    		xAxes: [{
    			id: 'x-axis-1',    // need an ID so datasets can reference the scale
    			type: 'linear',    // scatter should not use a category axis
    			position: 'bottom'
    		}],
    		yAxes: [{
    			id: 'y-axis-1',
    			type: 'linear',
    			position: 'left'
    		}]
    	},

    	tooltips: {
    		callbacks: {
    			title: function() {
    				return '';     // doesn't make sense for scatter since data are formatted as a point
    			},
    			label: function(item) {
    				return '(' + item.xLabel + ', ' + item.yLabel + ')';
    			}
    		}
    	}
    });

    core_defaults._set('global', {
    	datasets: {
    		scatter: {
    			showLine: false
    		}
    	}
    });

    // Scatter charts use line controllers
    var controller_scatter = controller_line;

    // NOTE export a map in which the key represents the controller type, not
    // the class, and so must be CamelCase in order to be correctly retrieved
    // by the controller in core.controller.js (`controllers[meta.type]`).

    var controllers = {
    	bar: controller_bar,
    	bubble: controller_bubble,
    	doughnut: controller_doughnut,
    	horizontalBar: controller_horizontalBar,
    	line: controller_line,
    	polarArea: controller_polarArea,
    	pie: controller_pie,
    	radar: controller_radar,
    	scatter: controller_scatter
    };

    /**
     * Helper function to get relative position for an event
     * @param {Event|IEvent} event - The event to get the position for
     * @param {Chart} chart - The chart
     * @returns {object} the event position
     */
    function getRelativePosition(e, chart) {
    	if (e.native) {
    		return {
    			x: e.x,
    			y: e.y
    		};
    	}

    	return helpers$1.getRelativePosition(e, chart);
    }

    /**
     * Helper function to traverse all of the visible elements in the chart
     * @param {Chart} chart - the chart
     * @param {function} handler - the callback to execute for each visible item
     */
    function parseVisibleItems(chart, handler) {
    	var metasets = chart._getSortedVisibleDatasetMetas();
    	var metadata, i, j, ilen, jlen, element;

    	for (i = 0, ilen = metasets.length; i < ilen; ++i) {
    		metadata = metasets[i].data;
    		for (j = 0, jlen = metadata.length; j < jlen; ++j) {
    			element = metadata[j];
    			if (!element._view.skip) {
    				handler(element);
    			}
    		}
    	}
    }

    /**
     * Helper function to get the items that intersect the event position
     * @param {ChartElement[]} items - elements to filter
     * @param {object} position - the point to be nearest to
     * @return {ChartElement[]} the nearest items
     */
    function getIntersectItems(chart, position) {
    	var elements = [];

    	parseVisibleItems(chart, function(element) {
    		if (element.inRange(position.x, position.y)) {
    			elements.push(element);
    		}
    	});

    	return elements;
    }

    /**
     * Helper function to get the items nearest to the event position considering all visible items in teh chart
     * @param {Chart} chart - the chart to look at elements from
     * @param {object} position - the point to be nearest to
     * @param {boolean} intersect - if true, only consider items that intersect the position
     * @param {function} distanceMetric - function to provide the distance between points
     * @return {ChartElement[]} the nearest items
     */
    function getNearestItems(chart, position, intersect, distanceMetric) {
    	var minDistance = Number.POSITIVE_INFINITY;
    	var nearestItems = [];

    	parseVisibleItems(chart, function(element) {
    		if (intersect && !element.inRange(position.x, position.y)) {
    			return;
    		}

    		var center = element.getCenterPoint();
    		var distance = distanceMetric(position, center);
    		if (distance < minDistance) {
    			nearestItems = [element];
    			minDistance = distance;
    		} else if (distance === minDistance) {
    			// Can have multiple items at the same distance in which case we sort by size
    			nearestItems.push(element);
    		}
    	});

    	return nearestItems;
    }

    /**
     * Get a distance metric function for two points based on the
     * axis mode setting
     * @param {string} axis - the axis mode. x|y|xy
     */
    function getDistanceMetricForAxis(axis) {
    	var useX = axis.indexOf('x') !== -1;
    	var useY = axis.indexOf('y') !== -1;

    	return function(pt1, pt2) {
    		var deltaX = useX ? Math.abs(pt1.x - pt2.x) : 0;
    		var deltaY = useY ? Math.abs(pt1.y - pt2.y) : 0;
    		return Math.sqrt(Math.pow(deltaX, 2) + Math.pow(deltaY, 2));
    	};
    }

    function indexMode(chart, e, options) {
    	var position = getRelativePosition(e, chart);
    	// Default axis for index mode is 'x' to match old behaviour
    	options.axis = options.axis || 'x';
    	var distanceMetric = getDistanceMetricForAxis(options.axis);
    	var items = options.intersect ? getIntersectItems(chart, position) : getNearestItems(chart, position, false, distanceMetric);
    	var elements = [];

    	if (!items.length) {
    		return [];
    	}

    	chart._getSortedVisibleDatasetMetas().forEach(function(meta) {
    		var element = meta.data[items[0]._index];

    		// don't count items that are skipped (null data)
    		if (element && !element._view.skip) {
    			elements.push(element);
    		}
    	});

    	return elements;
    }

    /**
     * @interface IInteractionOptions
     */
    /**
     * If true, only consider items that intersect the point
     * @name IInterfaceOptions#boolean
     * @type Boolean
     */

    /**
     * Contains interaction related functions
     * @namespace Chart.Interaction
     */
    var core_interaction = {
    	// Helper function for different modes
    	modes: {
    		single: function(chart, e) {
    			var position = getRelativePosition(e, chart);
    			var elements = [];

    			parseVisibleItems(chart, function(element) {
    				if (element.inRange(position.x, position.y)) {
    					elements.push(element);
    					return elements;
    				}
    			});

    			return elements.slice(0, 1);
    		},

    		/**
    		 * @function Chart.Interaction.modes.label
    		 * @deprecated since version 2.4.0
    		 * @todo remove at version 3
    		 * @private
    		 */
    		label: indexMode,

    		/**
    		 * Returns items at the same index. If the options.intersect parameter is true, we only return items if we intersect something
    		 * If the options.intersect mode is false, we find the nearest item and return the items at the same index as that item
    		 * @function Chart.Interaction.modes.index
    		 * @since v2.4.0
    		 * @param {Chart} chart - the chart we are returning items from
    		 * @param {Event} e - the event we are find things at
    		 * @param {IInteractionOptions} options - options to use during interaction
    		 * @return {Chart.Element[]} Array of elements that are under the point. If none are found, an empty array is returned
    		 */
    		index: indexMode,

    		/**
    		 * Returns items in the same dataset. If the options.intersect parameter is true, we only return items if we intersect something
    		 * If the options.intersect is false, we find the nearest item and return the items in that dataset
    		 * @function Chart.Interaction.modes.dataset
    		 * @param {Chart} chart - the chart we are returning items from
    		 * @param {Event} e - the event we are find things at
    		 * @param {IInteractionOptions} options - options to use during interaction
    		 * @return {Chart.Element[]} Array of elements that are under the point. If none are found, an empty array is returned
    		 */
    		dataset: function(chart, e, options) {
    			var position = getRelativePosition(e, chart);
    			options.axis = options.axis || 'xy';
    			var distanceMetric = getDistanceMetricForAxis(options.axis);
    			var items = options.intersect ? getIntersectItems(chart, position) : getNearestItems(chart, position, false, distanceMetric);

    			if (items.length > 0) {
    				items = chart.getDatasetMeta(items[0]._datasetIndex).data;
    			}

    			return items;
    		},

    		/**
    		 * @function Chart.Interaction.modes.x-axis
    		 * @deprecated since version 2.4.0. Use index mode and intersect == true
    		 * @todo remove at version 3
    		 * @private
    		 */
    		'x-axis': function(chart, e) {
    			return indexMode(chart, e, {intersect: false});
    		},

    		/**
    		 * Point mode returns all elements that hit test based on the event position
    		 * of the event
    		 * @function Chart.Interaction.modes.intersect
    		 * @param {Chart} chart - the chart we are returning items from
    		 * @param {Event} e - the event we are find things at
    		 * @return {Chart.Element[]} Array of elements that are under the point. If none are found, an empty array is returned
    		 */
    		point: function(chart, e) {
    			var position = getRelativePosition(e, chart);
    			return getIntersectItems(chart, position);
    		},

    		/**
    		 * nearest mode returns the element closest to the point
    		 * @function Chart.Interaction.modes.intersect
    		 * @param {Chart} chart - the chart we are returning items from
    		 * @param {Event} e - the event we are find things at
    		 * @param {IInteractionOptions} options - options to use
    		 * @return {Chart.Element[]} Array of elements that are under the point. If none are found, an empty array is returned
    		 */
    		nearest: function(chart, e, options) {
    			var position = getRelativePosition(e, chart);
    			options.axis = options.axis || 'xy';
    			var distanceMetric = getDistanceMetricForAxis(options.axis);
    			return getNearestItems(chart, position, options.intersect, distanceMetric);
    		},

    		/**
    		 * x mode returns the elements that hit-test at the current x coordinate
    		 * @function Chart.Interaction.modes.x
    		 * @param {Chart} chart - the chart we are returning items from
    		 * @param {Event} e - the event we are find things at
    		 * @param {IInteractionOptions} options - options to use
    		 * @return {Chart.Element[]} Array of elements that are under the point. If none are found, an empty array is returned
    		 */
    		x: function(chart, e, options) {
    			var position = getRelativePosition(e, chart);
    			var items = [];
    			var intersectsItem = false;

    			parseVisibleItems(chart, function(element) {
    				if (element.inXRange(position.x)) {
    					items.push(element);
    				}

    				if (element.inRange(position.x, position.y)) {
    					intersectsItem = true;
    				}
    			});

    			// If we want to trigger on an intersect and we don't have any items
    			// that intersect the position, return nothing
    			if (options.intersect && !intersectsItem) {
    				items = [];
    			}
    			return items;
    		},

    		/**
    		 * y mode returns the elements that hit-test at the current y coordinate
    		 * @function Chart.Interaction.modes.y
    		 * @param {Chart} chart - the chart we are returning items from
    		 * @param {Event} e - the event we are find things at
    		 * @param {IInteractionOptions} options - options to use
    		 * @return {Chart.Element[]} Array of elements that are under the point. If none are found, an empty array is returned
    		 */
    		y: function(chart, e, options) {
    			var position = getRelativePosition(e, chart);
    			var items = [];
    			var intersectsItem = false;

    			parseVisibleItems(chart, function(element) {
    				if (element.inYRange(position.y)) {
    					items.push(element);
    				}

    				if (element.inRange(position.x, position.y)) {
    					intersectsItem = true;
    				}
    			});

    			// If we want to trigger on an intersect and we don't have any items
    			// that intersect the position, return nothing
    			if (options.intersect && !intersectsItem) {
    				items = [];
    			}
    			return items;
    		}
    	}
    };

    var extend = helpers$1.extend;

    function filterByPosition(array, position) {
    	return helpers$1.where(array, function(v) {
    		return v.pos === position;
    	});
    }

    function sortByWeight(array, reverse) {
    	return array.sort(function(a, b) {
    		var v0 = reverse ? b : a;
    		var v1 = reverse ? a : b;
    		return v0.weight === v1.weight ?
    			v0.index - v1.index :
    			v0.weight - v1.weight;
    	});
    }

    function wrapBoxes(boxes) {
    	var layoutBoxes = [];
    	var i, ilen, box;

    	for (i = 0, ilen = (boxes || []).length; i < ilen; ++i) {
    		box = boxes[i];
    		layoutBoxes.push({
    			index: i,
    			box: box,
    			pos: box.position,
    			horizontal: box.isHorizontal(),
    			weight: box.weight
    		});
    	}
    	return layoutBoxes;
    }

    function setLayoutDims(layouts, params) {
    	var i, ilen, layout;
    	for (i = 0, ilen = layouts.length; i < ilen; ++i) {
    		layout = layouts[i];
    		// store width used instead of chartArea.w in fitBoxes
    		layout.width = layout.horizontal
    			? layout.box.fullWidth && params.availableWidth
    			: params.vBoxMaxWidth;
    		// store height used instead of chartArea.h in fitBoxes
    		layout.height = layout.horizontal && params.hBoxMaxHeight;
    	}
    }

    function buildLayoutBoxes(boxes) {
    	var layoutBoxes = wrapBoxes(boxes);
    	var left = sortByWeight(filterByPosition(layoutBoxes, 'left'), true);
    	var right = sortByWeight(filterByPosition(layoutBoxes, 'right'));
    	var top = sortByWeight(filterByPosition(layoutBoxes, 'top'), true);
    	var bottom = sortByWeight(filterByPosition(layoutBoxes, 'bottom'));

    	return {
    		leftAndTop: left.concat(top),
    		rightAndBottom: right.concat(bottom),
    		chartArea: filterByPosition(layoutBoxes, 'chartArea'),
    		vertical: left.concat(right),
    		horizontal: top.concat(bottom)
    	};
    }

    function getCombinedMax(maxPadding, chartArea, a, b) {
    	return Math.max(maxPadding[a], chartArea[a]) + Math.max(maxPadding[b], chartArea[b]);
    }

    function updateDims(chartArea, params, layout) {
    	var box = layout.box;
    	var maxPadding = chartArea.maxPadding;
    	var newWidth, newHeight;

    	if (layout.size) {
    		// this layout was already counted for, lets first reduce old size
    		chartArea[layout.pos] -= layout.size;
    	}
    	layout.size = layout.horizontal ? box.height : box.width;
    	chartArea[layout.pos] += layout.size;

    	if (box.getPadding) {
    		var boxPadding = box.getPadding();
    		maxPadding.top = Math.max(maxPadding.top, boxPadding.top);
    		maxPadding.left = Math.max(maxPadding.left, boxPadding.left);
    		maxPadding.bottom = Math.max(maxPadding.bottom, boxPadding.bottom);
    		maxPadding.right = Math.max(maxPadding.right, boxPadding.right);
    	}

    	newWidth = params.outerWidth - getCombinedMax(maxPadding, chartArea, 'left', 'right');
    	newHeight = params.outerHeight - getCombinedMax(maxPadding, chartArea, 'top', 'bottom');

    	if (newWidth !== chartArea.w || newHeight !== chartArea.h) {
    		chartArea.w = newWidth;
    		chartArea.h = newHeight;

    		// return true if chart area changed in layout's direction
    		var sizes = layout.horizontal ? [newWidth, chartArea.w] : [newHeight, chartArea.h];
    		return sizes[0] !== sizes[1] && (!isNaN(sizes[0]) || !isNaN(sizes[1]));
    	}
    }

    function handleMaxPadding(chartArea) {
    	var maxPadding = chartArea.maxPadding;

    	function updatePos(pos) {
    		var change = Math.max(maxPadding[pos] - chartArea[pos], 0);
    		chartArea[pos] += change;
    		return change;
    	}
    	chartArea.y += updatePos('top');
    	chartArea.x += updatePos('left');
    	updatePos('right');
    	updatePos('bottom');
    }

    function getMargins(horizontal, chartArea) {
    	var maxPadding = chartArea.maxPadding;

    	function marginForPositions(positions) {
    		var margin = {left: 0, top: 0, right: 0, bottom: 0};
    		positions.forEach(function(pos) {
    			margin[pos] = Math.max(chartArea[pos], maxPadding[pos]);
    		});
    		return margin;
    	}

    	return horizontal
    		? marginForPositions(['left', 'right'])
    		: marginForPositions(['top', 'bottom']);
    }

    function fitBoxes(boxes, chartArea, params) {
    	var refitBoxes = [];
    	var i, ilen, layout, box, refit, changed;

    	for (i = 0, ilen = boxes.length; i < ilen; ++i) {
    		layout = boxes[i];
    		box = layout.box;

    		box.update(
    			layout.width || chartArea.w,
    			layout.height || chartArea.h,
    			getMargins(layout.horizontal, chartArea)
    		);
    		if (updateDims(chartArea, params, layout)) {
    			changed = true;
    			if (refitBoxes.length) {
    				// Dimensions changed and there were non full width boxes before this
    				// -> we have to refit those
    				refit = true;
    			}
    		}
    		if (!box.fullWidth) { // fullWidth boxes don't need to be re-fitted in any case
    			refitBoxes.push(layout);
    		}
    	}

    	return refit ? fitBoxes(refitBoxes, chartArea, params) || changed : changed;
    }

    function placeBoxes(boxes, chartArea, params) {
    	var userPadding = params.padding;
    	var x = chartArea.x;
    	var y = chartArea.y;
    	var i, ilen, layout, box;

    	for (i = 0, ilen = boxes.length; i < ilen; ++i) {
    		layout = boxes[i];
    		box = layout.box;
    		if (layout.horizontal) {
    			box.left = box.fullWidth ? userPadding.left : chartArea.left;
    			box.right = box.fullWidth ? params.outerWidth - userPadding.right : chartArea.left + chartArea.w;
    			box.top = y;
    			box.bottom = y + box.height;
    			box.width = box.right - box.left;
    			y = box.bottom;
    		} else {
    			box.left = x;
    			box.right = x + box.width;
    			box.top = chartArea.top;
    			box.bottom = chartArea.top + chartArea.h;
    			box.height = box.bottom - box.top;
    			x = box.right;
    		}
    	}

    	chartArea.x = x;
    	chartArea.y = y;
    }

    core_defaults._set('global', {
    	layout: {
    		padding: {
    			top: 0,
    			right: 0,
    			bottom: 0,
    			left: 0
    		}
    	}
    });

    /**
     * @interface ILayoutItem
     * @prop {string} position - The position of the item in the chart layout. Possible values are
     * 'left', 'top', 'right', 'bottom', and 'chartArea'
     * @prop {number} weight - The weight used to sort the item. Higher weights are further away from the chart area
     * @prop {boolean} fullWidth - if true, and the item is horizontal, then push vertical boxes down
     * @prop {function} isHorizontal - returns true if the layout item is horizontal (ie. top or bottom)
     * @prop {function} update - Takes two parameters: width and height. Returns size of item
     * @prop {function} getPadding -  Returns an object with padding on the edges
     * @prop {number} width - Width of item. Must be valid after update()
     * @prop {number} height - Height of item. Must be valid after update()
     * @prop {number} left - Left edge of the item. Set by layout system and cannot be used in update
     * @prop {number} top - Top edge of the item. Set by layout system and cannot be used in update
     * @prop {number} right - Right edge of the item. Set by layout system and cannot be used in update
     * @prop {number} bottom - Bottom edge of the item. Set by layout system and cannot be used in update
     */

    // The layout service is very self explanatory.  It's responsible for the layout within a chart.
    // Scales, Legends and Plugins all rely on the layout service and can easily register to be placed anywhere they need
    // It is this service's responsibility of carrying out that layout.
    var core_layouts = {
    	defaults: {},

    	/**
    	 * Register a box to a chart.
    	 * A box is simply a reference to an object that requires layout. eg. Scales, Legend, Title.
    	 * @param {Chart} chart - the chart to use
    	 * @param {ILayoutItem} item - the item to add to be layed out
    	 */
    	addBox: function(chart, item) {
    		if (!chart.boxes) {
    			chart.boxes = [];
    		}

    		// initialize item with default values
    		item.fullWidth = item.fullWidth || false;
    		item.position = item.position || 'top';
    		item.weight = item.weight || 0;
    		item._layers = item._layers || function() {
    			return [{
    				z: 0,
    				draw: function() {
    					item.draw.apply(item, arguments);
    				}
    			}];
    		};

    		chart.boxes.push(item);
    	},

    	/**
    	 * Remove a layoutItem from a chart
    	 * @param {Chart} chart - the chart to remove the box from
    	 * @param {ILayoutItem} layoutItem - the item to remove from the layout
    	 */
    	removeBox: function(chart, layoutItem) {
    		var index = chart.boxes ? chart.boxes.indexOf(layoutItem) : -1;
    		if (index !== -1) {
    			chart.boxes.splice(index, 1);
    		}
    	},

    	/**
    	 * Sets (or updates) options on the given `item`.
    	 * @param {Chart} chart - the chart in which the item lives (or will be added to)
    	 * @param {ILayoutItem} item - the item to configure with the given options
    	 * @param {object} options - the new item options.
    	 */
    	configure: function(chart, item, options) {
    		var props = ['fullWidth', 'position', 'weight'];
    		var ilen = props.length;
    		var i = 0;
    		var prop;

    		for (; i < ilen; ++i) {
    			prop = props[i];
    			if (options.hasOwnProperty(prop)) {
    				item[prop] = options[prop];
    			}
    		}
    	},

    	/**
    	 * Fits boxes of the given chart into the given size by having each box measure itself
    	 * then running a fitting algorithm
    	 * @param {Chart} chart - the chart
    	 * @param {number} width - the width to fit into
    	 * @param {number} height - the height to fit into
    	 */
    	update: function(chart, width, height) {
    		if (!chart) {
    			return;
    		}

    		var layoutOptions = chart.options.layout || {};
    		var padding = helpers$1.options.toPadding(layoutOptions.padding);

    		var availableWidth = width - padding.width;
    		var availableHeight = height - padding.height;
    		var boxes = buildLayoutBoxes(chart.boxes);
    		var verticalBoxes = boxes.vertical;
    		var horizontalBoxes = boxes.horizontal;

    		// Essentially we now have any number of boxes on each of the 4 sides.
    		// Our canvas looks like the following.
    		// The areas L1 and L2 are the left axes. R1 is the right axis, T1 is the top axis and
    		// B1 is the bottom axis
    		// There are also 4 quadrant-like locations (left to right instead of clockwise) reserved for chart overlays
    		// These locations are single-box locations only, when trying to register a chartArea location that is already taken,
    		// an error will be thrown.
    		//
    		// |----------------------------------------------------|
    		// |                  T1 (Full Width)                   |
    		// |----------------------------------------------------|
    		// |    |    |                 T2                  |    |
    		// |    |----|-------------------------------------|----|
    		// |    |    | C1 |                           | C2 |    |
    		// |    |    |----|                           |----|    |
    		// |    |    |                                     |    |
    		// | L1 | L2 |           ChartArea (C0)            | R1 |
    		// |    |    |                                     |    |
    		// |    |    |----|                           |----|    |
    		// |    |    | C3 |                           | C4 |    |
    		// |    |----|-------------------------------------|----|
    		// |    |    |                 B1                  |    |
    		// |----------------------------------------------------|
    		// |                  B2 (Full Width)                   |
    		// |----------------------------------------------------|
    		//

    		var params = Object.freeze({
    			outerWidth: width,
    			outerHeight: height,
    			padding: padding,
    			availableWidth: availableWidth,
    			vBoxMaxWidth: availableWidth / 2 / verticalBoxes.length,
    			hBoxMaxHeight: availableHeight / 2
    		});
    		var chartArea = extend({
    			maxPadding: extend({}, padding),
    			w: availableWidth,
    			h: availableHeight,
    			x: padding.left,
    			y: padding.top
    		}, padding);

    		setLayoutDims(verticalBoxes.concat(horizontalBoxes), params);

    		// First fit vertical boxes
    		fitBoxes(verticalBoxes, chartArea, params);

    		// Then fit horizontal boxes
    		if (fitBoxes(horizontalBoxes, chartArea, params)) {
    			// if the area changed, re-fit vertical boxes
    			fitBoxes(verticalBoxes, chartArea, params);
    		}

    		handleMaxPadding(chartArea);

    		// Finally place the boxes to correct coordinates
    		placeBoxes(boxes.leftAndTop, chartArea, params);

    		// Move to opposite side of chart
    		chartArea.x += chartArea.w;
    		chartArea.y += chartArea.h;

    		placeBoxes(boxes.rightAndBottom, chartArea, params);

    		chart.chartArea = {
    			left: chartArea.left,
    			top: chartArea.top,
    			right: chartArea.left + chartArea.w,
    			bottom: chartArea.top + chartArea.h
    		};

    		// Finally update boxes in chartArea (radial scale for example)
    		helpers$1.each(boxes.chartArea, function(layout) {
    			var box = layout.box;
    			extend(box, chart.chartArea);
    			box.update(chartArea.w, chartArea.h);
    		});
    	}
    };

    /**
     * Platform fallback implementation (minimal).
     * @see https://github.com/chartjs/Chart.js/pull/4591#issuecomment-319575939
     */

    var platform_basic = {
    	acquireContext: function(item) {
    		if (item && item.canvas) {
    			// Support for any object associated to a canvas (including a context2d)
    			item = item.canvas;
    		}

    		return item && item.getContext('2d') || null;
    	}
    };

    var platform_dom = "/*\r\n * DOM element rendering detection\r\n * https://davidwalsh.name/detect-node-insertion\r\n */\r\n@keyframes chartjs-render-animation {\r\n\tfrom { opacity: 0.99; }\r\n\tto { opacity: 1; }\r\n}\r\n\r\n.chartjs-render-monitor {\r\n\tanimation: chartjs-render-animation 0.001s;\r\n}\r\n\r\n/*\r\n * DOM element resizing detection\r\n * https://github.com/marcj/css-element-queries\r\n */\r\n.chartjs-size-monitor,\r\n.chartjs-size-monitor-expand,\r\n.chartjs-size-monitor-shrink {\r\n\tposition: absolute;\r\n\tdirection: ltr;\r\n\tleft: 0;\r\n\ttop: 0;\r\n\tright: 0;\r\n\tbottom: 0;\r\n\toverflow: hidden;\r\n\tpointer-events: none;\r\n\tvisibility: hidden;\r\n\tz-index: -1;\r\n}\r\n\r\n.chartjs-size-monitor-expand > div {\r\n\tposition: absolute;\r\n\twidth: 1000000px;\r\n\theight: 1000000px;\r\n\tleft: 0;\r\n\ttop: 0;\r\n}\r\n\r\n.chartjs-size-monitor-shrink > div {\r\n\tposition: absolute;\r\n\twidth: 200%;\r\n\theight: 200%;\r\n\tleft: 0;\r\n\ttop: 0;\r\n}\r\n";

    var platform_dom$1 = /*#__PURE__*/Object.freeze({
    __proto__: null,
    'default': platform_dom
    });

    var stylesheet = getCjsExportFromNamespace(platform_dom$1);

    var EXPANDO_KEY = '$chartjs';
    var CSS_PREFIX = 'chartjs-';
    var CSS_SIZE_MONITOR = CSS_PREFIX + 'size-monitor';
    var CSS_RENDER_MONITOR = CSS_PREFIX + 'render-monitor';
    var CSS_RENDER_ANIMATION = CSS_PREFIX + 'render-animation';
    var ANIMATION_START_EVENTS = ['animationstart', 'webkitAnimationStart'];

    /**
     * DOM event types -> Chart.js event types.
     * Note: only events with different types are mapped.
     * @see https://developer.mozilla.org/en-US/docs/Web/Events
     */
    var EVENT_TYPES = {
    	touchstart: 'mousedown',
    	touchmove: 'mousemove',
    	touchend: 'mouseup',
    	pointerenter: 'mouseenter',
    	pointerdown: 'mousedown',
    	pointermove: 'mousemove',
    	pointerup: 'mouseup',
    	pointerleave: 'mouseout',
    	pointerout: 'mouseout'
    };

    /**
     * The "used" size is the final value of a dimension property after all calculations have
     * been performed. This method uses the computed style of `element` but returns undefined
     * if the computed style is not expressed in pixels. That can happen in some cases where
     * `element` has a size relative to its parent and this last one is not yet displayed,
     * for example because of `display: none` on a parent node.
     * @see https://developer.mozilla.org/en-US/docs/Web/CSS/used_value
     * @returns {number} Size in pixels or undefined if unknown.
     */
    function readUsedSize(element, property) {
    	var value = helpers$1.getStyle(element, property);
    	var matches = value && value.match(/^(\d+)(\.\d+)?px$/);
    	return matches ? Number(matches[1]) : undefined;
    }

    /**
     * Initializes the canvas style and render size without modifying the canvas display size,
     * since responsiveness is handled by the controller.resize() method. The config is used
     * to determine the aspect ratio to apply in case no explicit height has been specified.
     */
    function initCanvas(canvas, config) {
    	var style = canvas.style;

    	// NOTE(SB) canvas.getAttribute('width') !== canvas.width: in the first case it
    	// returns null or '' if no explicit value has been set to the canvas attribute.
    	var renderHeight = canvas.getAttribute('height');
    	var renderWidth = canvas.getAttribute('width');

    	// Chart.js modifies some canvas values that we want to restore on destroy
    	canvas[EXPANDO_KEY] = {
    		initial: {
    			height: renderHeight,
    			width: renderWidth,
    			style: {
    				display: style.display,
    				height: style.height,
    				width: style.width
    			}
    		}
    	};

    	// Force canvas to display as block to avoid extra space caused by inline
    	// elements, which would interfere with the responsive resize process.
    	// https://github.com/chartjs/Chart.js/issues/2538
    	style.display = style.display || 'block';

    	if (renderWidth === null || renderWidth === '') {
    		var displayWidth = readUsedSize(canvas, 'width');
    		if (displayWidth !== undefined) {
    			canvas.width = displayWidth;
    		}
    	}

    	if (renderHeight === null || renderHeight === '') {
    		if (canvas.style.height === '') {
    			// If no explicit render height and style height, let's apply the aspect ratio,
    			// which one can be specified by the user but also by charts as default option
    			// (i.e. options.aspectRatio). If not specified, use canvas aspect ratio of 2.
    			canvas.height = canvas.width / (config.options.aspectRatio || 2);
    		} else {
    			var displayHeight = readUsedSize(canvas, 'height');
    			if (displayWidth !== undefined) {
    				canvas.height = displayHeight;
    			}
    		}
    	}

    	return canvas;
    }

    /**
     * Detects support for options object argument in addEventListener.
     * https://developer.mozilla.org/en-US/docs/Web/API/EventTarget/addEventListener#Safely_detecting_option_support
     * @private
     */
    var supportsEventListenerOptions = (function() {
    	var supports = false;
    	try {
    		var options = Object.defineProperty({}, 'passive', {
    			// eslint-disable-next-line getter-return
    			get: function() {
    				supports = true;
    			}
    		});
    		window.addEventListener('e', null, options);
    	} catch (e) {
    		// continue regardless of error
    	}
    	return supports;
    }());

    // Default passive to true as expected by Chrome for 'touchstart' and 'touchend' events.
    // https://github.com/chartjs/Chart.js/issues/4287
    var eventListenerOptions = supportsEventListenerOptions ? {passive: true} : false;

    function addListener(node, type, listener) {
    	node.addEventListener(type, listener, eventListenerOptions);
    }

    function removeListener(node, type, listener) {
    	node.removeEventListener(type, listener, eventListenerOptions);
    }

    function createEvent(type, chart, x, y, nativeEvent) {
    	return {
    		type: type,
    		chart: chart,
    		native: nativeEvent || null,
    		x: x !== undefined ? x : null,
    		y: y !== undefined ? y : null,
    	};
    }

    function fromNativeEvent(event, chart) {
    	var type = EVENT_TYPES[event.type] || event.type;
    	var pos = helpers$1.getRelativePosition(event, chart);
    	return createEvent(type, chart, pos.x, pos.y, event);
    }

    function throttled(fn, thisArg) {
    	var ticking = false;
    	var args = [];

    	return function() {
    		args = Array.prototype.slice.call(arguments);
    		thisArg = thisArg || this;

    		if (!ticking) {
    			ticking = true;
    			helpers$1.requestAnimFrame.call(window, function() {
    				ticking = false;
    				fn.apply(thisArg, args);
    			});
    		}
    	};
    }

    function createDiv(cls) {
    	var el = document.createElement('div');
    	el.className = cls || '';
    	return el;
    }

    // Implementation based on https://github.com/marcj/css-element-queries
    function createResizer(handler) {
    	var maxSize = 1000000;

    	// NOTE(SB) Don't use innerHTML because it could be considered unsafe.
    	// https://github.com/chartjs/Chart.js/issues/5902
    	var resizer = createDiv(CSS_SIZE_MONITOR);
    	var expand = createDiv(CSS_SIZE_MONITOR + '-expand');
    	var shrink = createDiv(CSS_SIZE_MONITOR + '-shrink');

    	expand.appendChild(createDiv());
    	shrink.appendChild(createDiv());

    	resizer.appendChild(expand);
    	resizer.appendChild(shrink);
    	resizer._reset = function() {
    		expand.scrollLeft = maxSize;
    		expand.scrollTop = maxSize;
    		shrink.scrollLeft = maxSize;
    		shrink.scrollTop = maxSize;
    	};

    	var onScroll = function() {
    		resizer._reset();
    		handler();
    	};

    	addListener(expand, 'scroll', onScroll.bind(expand, 'expand'));
    	addListener(shrink, 'scroll', onScroll.bind(shrink, 'shrink'));

    	return resizer;
    }

    // https://davidwalsh.name/detect-node-insertion
    function watchForRender(node, handler) {
    	var expando = node[EXPANDO_KEY] || (node[EXPANDO_KEY] = {});
    	var proxy = expando.renderProxy = function(e) {
    		if (e.animationName === CSS_RENDER_ANIMATION) {
    			handler();
    		}
    	};

    	helpers$1.each(ANIMATION_START_EVENTS, function(type) {
    		addListener(node, type, proxy);
    	});

    	// #4737: Chrome might skip the CSS animation when the CSS_RENDER_MONITOR class
    	// is removed then added back immediately (same animation frame?). Accessing the
    	// `offsetParent` property will force a reflow and re-evaluate the CSS animation.
    	// https://gist.github.com/paulirish/5d52fb081b3570c81e3a#box-metrics
    	// https://github.com/chartjs/Chart.js/issues/4737
    	expando.reflow = !!node.offsetParent;

    	node.classList.add(CSS_RENDER_MONITOR);
    }

    function unwatchForRender(node) {
    	var expando = node[EXPANDO_KEY] || {};
    	var proxy = expando.renderProxy;

    	if (proxy) {
    		helpers$1.each(ANIMATION_START_EVENTS, function(type) {
    			removeListener(node, type, proxy);
    		});

    		delete expando.renderProxy;
    	}

    	node.classList.remove(CSS_RENDER_MONITOR);
    }

    function addResizeListener(node, listener, chart) {
    	var expando = node[EXPANDO_KEY] || (node[EXPANDO_KEY] = {});

    	// Let's keep track of this added resizer and thus avoid DOM query when removing it.
    	var resizer = expando.resizer = createResizer(throttled(function() {
    		if (expando.resizer) {
    			var container = chart.options.maintainAspectRatio && node.parentNode;
    			var w = container ? container.clientWidth : 0;
    			listener(createEvent('resize', chart));
    			if (container && container.clientWidth < w && chart.canvas) {
    				// If the container size shrank during chart resize, let's assume
    				// scrollbar appeared. So we resize again with the scrollbar visible -
    				// effectively making chart smaller and the scrollbar hidden again.
    				// Because we are inside `throttled`, and currently `ticking`, scroll
    				// events are ignored during this whole 2 resize process.
    				// If we assumed wrong and something else happened, we are resizing
    				// twice in a frame (potential performance issue)
    				listener(createEvent('resize', chart));
    			}
    		}
    	}));

    	// The resizer needs to be attached to the node parent, so we first need to be
    	// sure that `node` is attached to the DOM before injecting the resizer element.
    	watchForRender(node, function() {
    		if (expando.resizer) {
    			var container = node.parentNode;
    			if (container && container !== resizer.parentNode) {
    				container.insertBefore(resizer, container.firstChild);
    			}

    			// The container size might have changed, let's reset the resizer state.
    			resizer._reset();
    		}
    	});
    }

    function removeResizeListener(node) {
    	var expando = node[EXPANDO_KEY] || {};
    	var resizer = expando.resizer;

    	delete expando.resizer;
    	unwatchForRender(node);

    	if (resizer && resizer.parentNode) {
    		resizer.parentNode.removeChild(resizer);
    	}
    }

    /**
     * Injects CSS styles inline if the styles are not already present.
     * @param {HTMLDocument|ShadowRoot} rootNode - the node to contain the <style>.
     * @param {string} css - the CSS to be injected.
     */
    function injectCSS(rootNode, css) {
    	// https://stackoverflow.com/q/3922139
    	var expando = rootNode[EXPANDO_KEY] || (rootNode[EXPANDO_KEY] = {});
    	if (!expando.containsStyles) {
    		expando.containsStyles = true;
    		css = '/* Chart.js */\n' + css;
    		var style = document.createElement('style');
    		style.setAttribute('type', 'text/css');
    		style.appendChild(document.createTextNode(css));
    		rootNode.appendChild(style);
    	}
    }

    var platform_dom$2 = {
    	/**
    	 * When `true`, prevents the automatic injection of the stylesheet required to
    	 * correctly detect when the chart is added to the DOM and then resized. This
    	 * switch has been added to allow external stylesheet (`dist/Chart(.min)?.js`)
    	 * to be manually imported to make this library compatible with any CSP.
    	 * See https://github.com/chartjs/Chart.js/issues/5208
    	 */
    	disableCSSInjection: false,

    	/**
    	 * This property holds whether this platform is enabled for the current environment.
    	 * Currently used by platform.js to select the proper implementation.
    	 * @private
    	 */
    	_enabled: typeof window !== 'undefined' && typeof document !== 'undefined',

    	/**
    	 * Initializes resources that depend on platform options.
    	 * @param {HTMLCanvasElement} canvas - The Canvas element.
    	 * @private
    	 */
    	_ensureLoaded: function(canvas) {
    		if (!this.disableCSSInjection) {
    			// If the canvas is in a shadow DOM, then the styles must also be inserted
    			// into the same shadow DOM.
    			// https://github.com/chartjs/Chart.js/issues/5763
    			var root = canvas.getRootNode ? canvas.getRootNode() : document;
    			var targetNode = root.host ? root : document.head;
    			injectCSS(targetNode, stylesheet);
    		}
    	},

    	acquireContext: function(item, config) {
    		if (typeof item === 'string') {
    			item = document.getElementById(item);
    		} else if (item.length) {
    			// Support for array based queries (such as jQuery)
    			item = item[0];
    		}

    		if (item && item.canvas) {
    			// Support for any object associated to a canvas (including a context2d)
    			item = item.canvas;
    		}

    		// To prevent canvas fingerprinting, some add-ons undefine the getContext
    		// method, for example: https://github.com/kkapsner/CanvasBlocker
    		// https://github.com/chartjs/Chart.js/issues/2807
    		var context = item && item.getContext && item.getContext('2d');

    		// `instanceof HTMLCanvasElement/CanvasRenderingContext2D` fails when the item is
    		// inside an iframe or when running in a protected environment. We could guess the
    		// types from their toString() value but let's keep things flexible and assume it's
    		// a sufficient condition if the item has a context2D which has item as `canvas`.
    		// https://github.com/chartjs/Chart.js/issues/3887
    		// https://github.com/chartjs/Chart.js/issues/4102
    		// https://github.com/chartjs/Chart.js/issues/4152
    		if (context && context.canvas === item) {
    			// Load platform resources on first chart creation, to make it possible to
    			// import the library before setting platform options.
    			this._ensureLoaded(item);
    			initCanvas(item, config);
    			return context;
    		}

    		return null;
    	},

    	releaseContext: function(context) {
    		var canvas = context.canvas;
    		if (!canvas[EXPANDO_KEY]) {
    			return;
    		}

    		var initial = canvas[EXPANDO_KEY].initial;
    		['height', 'width'].forEach(function(prop) {
    			var value = initial[prop];
    			if (helpers$1.isNullOrUndef(value)) {
    				canvas.removeAttribute(prop);
    			} else {
    				canvas.setAttribute(prop, value);
    			}
    		});

    		helpers$1.each(initial.style || {}, function(value, key) {
    			canvas.style[key] = value;
    		});

    		// The canvas render size might have been changed (and thus the state stack discarded),
    		// we can't use save() and restore() to restore the initial state. So make sure that at
    		// least the canvas context is reset to the default state by setting the canvas width.
    		// https://www.w3.org/TR/2011/WD-html5-20110525/the-canvas-element.html
    		// eslint-disable-next-line no-self-assign
    		canvas.width = canvas.width;

    		delete canvas[EXPANDO_KEY];
    	},

    	addEventListener: function(chart, type, listener) {
    		var canvas = chart.canvas;
    		if (type === 'resize') {
    			// Note: the resize event is not supported on all browsers.
    			addResizeListener(canvas, listener, chart);
    			return;
    		}

    		var expando = listener[EXPANDO_KEY] || (listener[EXPANDO_KEY] = {});
    		var proxies = expando.proxies || (expando.proxies = {});
    		var proxy = proxies[chart.id + '_' + type] = function(event) {
    			listener(fromNativeEvent(event, chart));
    		};

    		addListener(canvas, type, proxy);
    	},

    	removeEventListener: function(chart, type, listener) {
    		var canvas = chart.canvas;
    		if (type === 'resize') {
    			// Note: the resize event is not supported on all browsers.
    			removeResizeListener(canvas);
    			return;
    		}

    		var expando = listener[EXPANDO_KEY] || {};
    		var proxies = expando.proxies || {};
    		var proxy = proxies[chart.id + '_' + type];
    		if (!proxy) {
    			return;
    		}

    		removeListener(canvas, type, proxy);
    	}
    };

    // DEPRECATIONS

    /**
     * Provided for backward compatibility, use EventTarget.addEventListener instead.
     * EventTarget.addEventListener compatibility: Chrome, Opera 7, Safari, FF1.5+, IE9+
     * @see https://developer.mozilla.org/en-US/docs/Web/API/EventTarget/addEventListener
     * @function Chart.helpers.addEvent
     * @deprecated since version 2.7.0
     * @todo remove at version 3
     * @private
     */
    helpers$1.addEvent = addListener;

    /**
     * Provided for backward compatibility, use EventTarget.removeEventListener instead.
     * EventTarget.removeEventListener compatibility: Chrome, Opera 7, Safari, FF1.5+, IE9+
     * @see https://developer.mozilla.org/en-US/docs/Web/API/EventTarget/removeEventListener
     * @function Chart.helpers.removeEvent
     * @deprecated since version 2.7.0
     * @todo remove at version 3
     * @private
     */
    helpers$1.removeEvent = removeListener;

    // @TODO Make possible to select another platform at build time.
    var implementation = platform_dom$2._enabled ? platform_dom$2 : platform_basic;

    /**
     * @namespace Chart.platform
     * @see https://chartjs.gitbooks.io/proposals/content/Platform.html
     * @since 2.4.0
     */
    var platform = helpers$1.extend({
    	/**
    	 * @since 2.7.0
    	 */
    	initialize: function() {},

    	/**
    	 * Called at chart construction time, returns a context2d instance implementing
    	 * the [W3C Canvas 2D Context API standard]{@link https://www.w3.org/TR/2dcontext/}.
    	 * @param {*} item - The native item from which to acquire context (platform specific)
    	 * @param {object} options - The chart options
    	 * @returns {CanvasRenderingContext2D} context2d instance
    	 */
    	acquireContext: function() {},

    	/**
    	 * Called at chart destruction time, releases any resources associated to the context
    	 * previously returned by the acquireContext() method.
    	 * @param {CanvasRenderingContext2D} context - The context2d instance
    	 * @returns {boolean} true if the method succeeded, else false
    	 */
    	releaseContext: function() {},

    	/**
    	 * Registers the specified listener on the given chart.
    	 * @param {Chart} chart - Chart from which to listen for event
    	 * @param {string} type - The ({@link IEvent}) type to listen for
    	 * @param {function} listener - Receives a notification (an object that implements
    	 * the {@link IEvent} interface) when an event of the specified type occurs.
    	 */
    	addEventListener: function() {},

    	/**
    	 * Removes the specified listener previously registered with addEventListener.
    	 * @param {Chart} chart - Chart from which to remove the listener
    	 * @param {string} type - The ({@link IEvent}) type to remove
    	 * @param {function} listener - The listener function to remove from the event target.
    	 */
    	removeEventListener: function() {}

    }, implementation);

    core_defaults._set('global', {
    	plugins: {}
    });

    /**
     * The plugin service singleton
     * @namespace Chart.plugins
     * @since 2.1.0
     */
    var core_plugins = {
    	/**
    	 * Globally registered plugins.
    	 * @private
    	 */
    	_plugins: [],

    	/**
    	 * This identifier is used to invalidate the descriptors cache attached to each chart
    	 * when a global plugin is registered or unregistered. In this case, the cache ID is
    	 * incremented and descriptors are regenerated during following API calls.
    	 * @private
    	 */
    	_cacheId: 0,

    	/**
    	 * Registers the given plugin(s) if not already registered.
    	 * @param {IPlugin[]|IPlugin} plugins plugin instance(s).
    	 */
    	register: function(plugins) {
    		var p = this._plugins;
    		([]).concat(plugins).forEach(function(plugin) {
    			if (p.indexOf(plugin) === -1) {
    				p.push(plugin);
    			}
    		});

    		this._cacheId++;
    	},

    	/**
    	 * Unregisters the given plugin(s) only if registered.
    	 * @param {IPlugin[]|IPlugin} plugins plugin instance(s).
    	 */
    	unregister: function(plugins) {
    		var p = this._plugins;
    		([]).concat(plugins).forEach(function(plugin) {
    			var idx = p.indexOf(plugin);
    			if (idx !== -1) {
    				p.splice(idx, 1);
    			}
    		});

    		this._cacheId++;
    	},

    	/**
    	 * Remove all registered plugins.
    	 * @since 2.1.5
    	 */
    	clear: function() {
    		this._plugins = [];
    		this._cacheId++;
    	},

    	/**
    	 * Returns the number of registered plugins?
    	 * @returns {number}
    	 * @since 2.1.5
    	 */
    	count: function() {
    		return this._plugins.length;
    	},

    	/**
    	 * Returns all registered plugin instances.
    	 * @returns {IPlugin[]} array of plugin objects.
    	 * @since 2.1.5
    	 */
    	getAll: function() {
    		return this._plugins;
    	},

    	/**
    	 * Calls enabled plugins for `chart` on the specified hook and with the given args.
    	 * This method immediately returns as soon as a plugin explicitly returns false. The
    	 * returned value can be used, for instance, to interrupt the current action.
    	 * @param {Chart} chart - The chart instance for which plugins should be called.
    	 * @param {string} hook - The name of the plugin method to call (e.g. 'beforeUpdate').
    	 * @param {Array} [args] - Extra arguments to apply to the hook call.
    	 * @returns {boolean} false if any of the plugins return false, else returns true.
    	 */
    	notify: function(chart, hook, args) {
    		var descriptors = this.descriptors(chart);
    		var ilen = descriptors.length;
    		var i, descriptor, plugin, params, method;

    		for (i = 0; i < ilen; ++i) {
    			descriptor = descriptors[i];
    			plugin = descriptor.plugin;
    			method = plugin[hook];
    			if (typeof method === 'function') {
    				params = [chart].concat(args || []);
    				params.push(descriptor.options);
    				if (method.apply(plugin, params) === false) {
    					return false;
    				}
    			}
    		}

    		return true;
    	},

    	/**
    	 * Returns descriptors of enabled plugins for the given chart.
    	 * @returns {object[]} [{ plugin, options }]
    	 * @private
    	 */
    	descriptors: function(chart) {
    		var cache = chart.$plugins || (chart.$plugins = {});
    		if (cache.id === this._cacheId) {
    			return cache.descriptors;
    		}

    		var plugins = [];
    		var descriptors = [];
    		var config = (chart && chart.config) || {};
    		var options = (config.options && config.options.plugins) || {};

    		this._plugins.concat(config.plugins || []).forEach(function(plugin) {
    			var idx = plugins.indexOf(plugin);
    			if (idx !== -1) {
    				return;
    			}

    			var id = plugin.id;
    			var opts = options[id];
    			if (opts === false) {
    				return;
    			}

    			if (opts === true) {
    				opts = helpers$1.clone(core_defaults.global.plugins[id]);
    			}

    			plugins.push(plugin);
    			descriptors.push({
    				plugin: plugin,
    				options: opts || {}
    			});
    		});

    		cache.descriptors = descriptors;
    		cache.id = this._cacheId;
    		return descriptors;
    	},

    	/**
    	 * Invalidates cache for the given chart: descriptors hold a reference on plugin option,
    	 * but in some cases, this reference can be changed by the user when updating options.
    	 * https://github.com/chartjs/Chart.js/issues/5111#issuecomment-355934167
    	 * @private
    	 */
    	_invalidate: function(chart) {
    		delete chart.$plugins;
    	}
    };

    var core_scaleService = {
    	// Scale registration object. Extensions can register new scale types (such as log or DB scales) and then
    	// use the new chart options to grab the correct scale
    	constructors: {},
    	// Use a registration function so that we can move to an ES6 map when we no longer need to support
    	// old browsers

    	// Scale config defaults
    	defaults: {},
    	registerScaleType: function(type, scaleConstructor, scaleDefaults) {
    		this.constructors[type] = scaleConstructor;
    		this.defaults[type] = helpers$1.clone(scaleDefaults);
    	},
    	getScaleConstructor: function(type) {
    		return this.constructors.hasOwnProperty(type) ? this.constructors[type] : undefined;
    	},
    	getScaleDefaults: function(type) {
    		// Return the scale defaults merged with the global settings so that we always use the latest ones
    		return this.defaults.hasOwnProperty(type) ? helpers$1.merge(Object.create(null), [core_defaults.scale, this.defaults[type]]) : {};
    	},
    	updateScaleDefaults: function(type, additions) {
    		var me = this;
    		if (me.defaults.hasOwnProperty(type)) {
    			me.defaults[type] = helpers$1.extend(me.defaults[type], additions);
    		}
    	},
    	addScalesToLayout: function(chart) {
    		// Adds each scale to the chart.boxes array to be sized accordingly
    		helpers$1.each(chart.scales, function(scale) {
    			// Set ILayoutItem parameters for backwards compatibility
    			scale.fullWidth = scale.options.fullWidth;
    			scale.position = scale.options.position;
    			scale.weight = scale.options.weight;
    			core_layouts.addBox(chart, scale);
    		});
    	}
    };

    var valueOrDefault$8 = helpers$1.valueOrDefault;
    var getRtlHelper = helpers$1.rtl.getRtlAdapter;

    core_defaults._set('global', {
    	tooltips: {
    		enabled: true,
    		custom: null,
    		mode: 'nearest',
    		position: 'average',
    		intersect: true,
    		backgroundColor: 'rgba(0,0,0,0.8)',
    		titleFontStyle: 'bold',
    		titleSpacing: 2,
    		titleMarginBottom: 6,
    		titleFontColor: '#fff',
    		titleAlign: 'left',
    		bodySpacing: 2,
    		bodyFontColor: '#fff',
    		bodyAlign: 'left',
    		footerFontStyle: 'bold',
    		footerSpacing: 2,
    		footerMarginTop: 6,
    		footerFontColor: '#fff',
    		footerAlign: 'left',
    		yPadding: 6,
    		xPadding: 6,
    		caretPadding: 2,
    		caretSize: 5,
    		cornerRadius: 6,
    		multiKeyBackground: '#fff',
    		displayColors: true,
    		borderColor: 'rgba(0,0,0,0)',
    		borderWidth: 0,
    		callbacks: {
    			// Args are: (tooltipItems, data)
    			beforeTitle: helpers$1.noop,
    			title: function(tooltipItems, data) {
    				var title = '';
    				var labels = data.labels;
    				var labelCount = labels ? labels.length : 0;

    				if (tooltipItems.length > 0) {
    					var item = tooltipItems[0];
    					if (item.label) {
    						title = item.label;
    					} else if (item.xLabel) {
    						title = item.xLabel;
    					} else if (labelCount > 0 && item.index < labelCount) {
    						title = labels[item.index];
    					}
    				}

    				return title;
    			},
    			afterTitle: helpers$1.noop,

    			// Args are: (tooltipItems, data)
    			beforeBody: helpers$1.noop,

    			// Args are: (tooltipItem, data)
    			beforeLabel: helpers$1.noop,
    			label: function(tooltipItem, data) {
    				var label = data.datasets[tooltipItem.datasetIndex].label || '';

    				if (label) {
    					label += ': ';
    				}
    				if (!helpers$1.isNullOrUndef(tooltipItem.value)) {
    					label += tooltipItem.value;
    				} else {
    					label += tooltipItem.yLabel;
    				}
    				return label;
    			},
    			labelColor: function(tooltipItem, chart) {
    				var meta = chart.getDatasetMeta(tooltipItem.datasetIndex);
    				var activeElement = meta.data[tooltipItem.index];
    				var view = activeElement._view;
    				return {
    					borderColor: view.borderColor,
    					backgroundColor: view.backgroundColor
    				};
    			},
    			labelTextColor: function() {
    				return this._options.bodyFontColor;
    			},
    			afterLabel: helpers$1.noop,

    			// Args are: (tooltipItems, data)
    			afterBody: helpers$1.noop,

    			// Args are: (tooltipItems, data)
    			beforeFooter: helpers$1.noop,
    			footer: helpers$1.noop,
    			afterFooter: helpers$1.noop
    		}
    	}
    });

    var positioners = {
    	/**
    	 * Average mode places the tooltip at the average position of the elements shown
    	 * @function Chart.Tooltip.positioners.average
    	 * @param elements {ChartElement[]} the elements being displayed in the tooltip
    	 * @returns {object} tooltip position
    	 */
    	average: function(elements) {
    		if (!elements.length) {
    			return false;
    		}

    		var i, len;
    		var x = 0;
    		var y = 0;
    		var count = 0;

    		for (i = 0, len = elements.length; i < len; ++i) {
    			var el = elements[i];
    			if (el && el.hasValue()) {
    				var pos = el.tooltipPosition();
    				x += pos.x;
    				y += pos.y;
    				++count;
    			}
    		}

    		return {
    			x: x / count,
    			y: y / count
    		};
    	},

    	/**
    	 * Gets the tooltip position nearest of the item nearest to the event position
    	 * @function Chart.Tooltip.positioners.nearest
    	 * @param elements {Chart.Element[]} the tooltip elements
    	 * @param eventPosition {object} the position of the event in canvas coordinates
    	 * @returns {object} the tooltip position
    	 */
    	nearest: function(elements, eventPosition) {
    		var x = eventPosition.x;
    		var y = eventPosition.y;
    		var minDistance = Number.POSITIVE_INFINITY;
    		var i, len, nearestElement;

    		for (i = 0, len = elements.length; i < len; ++i) {
    			var el = elements[i];
    			if (el && el.hasValue()) {
    				var center = el.getCenterPoint();
    				var d = helpers$1.distanceBetweenPoints(eventPosition, center);

    				if (d < minDistance) {
    					minDistance = d;
    					nearestElement = el;
    				}
    			}
    		}

    		if (nearestElement) {
    			var tp = nearestElement.tooltipPosition();
    			x = tp.x;
    			y = tp.y;
    		}

    		return {
    			x: x,
    			y: y
    		};
    	}
    };

    // Helper to push or concat based on if the 2nd parameter is an array or not
    function pushOrConcat(base, toPush) {
    	if (toPush) {
    		if (helpers$1.isArray(toPush)) {
    			// base = base.concat(toPush);
    			Array.prototype.push.apply(base, toPush);
    		} else {
    			base.push(toPush);
    		}
    	}

    	return base;
    }

    /**
     * Returns array of strings split by newline
     * @param {string} value - The value to split by newline.
     * @returns {string[]} value if newline present - Returned from String split() method
     * @function
     */
    function splitNewlines(str) {
    	if ((typeof str === 'string' || str instanceof String) && str.indexOf('\n') > -1) {
    		return str.split('\n');
    	}
    	return str;
    }


    /**
     * Private helper to create a tooltip item model
     * @param element - the chart element (point, arc, bar) to create the tooltip item for
     * @return new tooltip item
     */
    function createTooltipItem(element) {
    	var xScale = element._xScale;
    	var yScale = element._yScale || element._scale; // handle radar || polarArea charts
    	var index = element._index;
    	var datasetIndex = element._datasetIndex;
    	var controller = element._chart.getDatasetMeta(datasetIndex).controller;
    	var indexScale = controller._getIndexScale();
    	var valueScale = controller._getValueScale();

    	return {
    		xLabel: xScale ? xScale.getLabelForIndex(index, datasetIndex) : '',
    		yLabel: yScale ? yScale.getLabelForIndex(index, datasetIndex) : '',
    		label: indexScale ? '' + indexScale.getLabelForIndex(index, datasetIndex) : '',
    		value: valueScale ? '' + valueScale.getLabelForIndex(index, datasetIndex) : '',
    		index: index,
    		datasetIndex: datasetIndex,
    		x: element._model.x,
    		y: element._model.y
    	};
    }

    /**
     * Helper to get the reset model for the tooltip
     * @param tooltipOpts {object} the tooltip options
     */
    function getBaseModel(tooltipOpts) {
    	var globalDefaults = core_defaults.global;

    	return {
    		// Positioning
    		xPadding: tooltipOpts.xPadding,
    		yPadding: tooltipOpts.yPadding,
    		xAlign: tooltipOpts.xAlign,
    		yAlign: tooltipOpts.yAlign,

    		// Drawing direction and text direction
    		rtl: tooltipOpts.rtl,
    		textDirection: tooltipOpts.textDirection,

    		// Body
    		bodyFontColor: tooltipOpts.bodyFontColor,
    		_bodyFontFamily: valueOrDefault$8(tooltipOpts.bodyFontFamily, globalDefaults.defaultFontFamily),
    		_bodyFontStyle: valueOrDefault$8(tooltipOpts.bodyFontStyle, globalDefaults.defaultFontStyle),
    		_bodyAlign: tooltipOpts.bodyAlign,
    		bodyFontSize: valueOrDefault$8(tooltipOpts.bodyFontSize, globalDefaults.defaultFontSize),
    		bodySpacing: tooltipOpts.bodySpacing,

    		// Title
    		titleFontColor: tooltipOpts.titleFontColor,
    		_titleFontFamily: valueOrDefault$8(tooltipOpts.titleFontFamily, globalDefaults.defaultFontFamily),
    		_titleFontStyle: valueOrDefault$8(tooltipOpts.titleFontStyle, globalDefaults.defaultFontStyle),
    		titleFontSize: valueOrDefault$8(tooltipOpts.titleFontSize, globalDefaults.defaultFontSize),
    		_titleAlign: tooltipOpts.titleAlign,
    		titleSpacing: tooltipOpts.titleSpacing,
    		titleMarginBottom: tooltipOpts.titleMarginBottom,

    		// Footer
    		footerFontColor: tooltipOpts.footerFontColor,
    		_footerFontFamily: valueOrDefault$8(tooltipOpts.footerFontFamily, globalDefaults.defaultFontFamily),
    		_footerFontStyle: valueOrDefault$8(tooltipOpts.footerFontStyle, globalDefaults.defaultFontStyle),
    		footerFontSize: valueOrDefault$8(tooltipOpts.footerFontSize, globalDefaults.defaultFontSize),
    		_footerAlign: tooltipOpts.footerAlign,
    		footerSpacing: tooltipOpts.footerSpacing,
    		footerMarginTop: tooltipOpts.footerMarginTop,

    		// Appearance
    		caretSize: tooltipOpts.caretSize,
    		cornerRadius: tooltipOpts.cornerRadius,
    		backgroundColor: tooltipOpts.backgroundColor,
    		opacity: 0,
    		legendColorBackground: tooltipOpts.multiKeyBackground,
    		displayColors: tooltipOpts.displayColors,
    		borderColor: tooltipOpts.borderColor,
    		borderWidth: tooltipOpts.borderWidth
    	};
    }

    /**
     * Get the size of the tooltip
     */
    function getTooltipSize(tooltip, model) {
    	var ctx = tooltip._chart.ctx;

    	var height = model.yPadding * 2; // Tooltip Padding
    	var width = 0;

    	// Count of all lines in the body
    	var body = model.body;
    	var combinedBodyLength = body.reduce(function(count, bodyItem) {
    		return count + bodyItem.before.length + bodyItem.lines.length + bodyItem.after.length;
    	}, 0);
    	combinedBodyLength += model.beforeBody.length + model.afterBody.length;

    	var titleLineCount = model.title.length;
    	var footerLineCount = model.footer.length;
    	var titleFontSize = model.titleFontSize;
    	var bodyFontSize = model.bodyFontSize;
    	var footerFontSize = model.footerFontSize;

    	height += titleLineCount * titleFontSize; // Title Lines
    	height += titleLineCount ? (titleLineCount - 1) * model.titleSpacing : 0; // Title Line Spacing
    	height += titleLineCount ? model.titleMarginBottom : 0; // Title's bottom Margin
    	height += combinedBodyLength * bodyFontSize; // Body Lines
    	height += combinedBodyLength ? (combinedBodyLength - 1) * model.bodySpacing : 0; // Body Line Spacing
    	height += footerLineCount ? model.footerMarginTop : 0; // Footer Margin
    	height += footerLineCount * (footerFontSize); // Footer Lines
    	height += footerLineCount ? (footerLineCount - 1) * model.footerSpacing : 0; // Footer Line Spacing

    	// Title width
    	var widthPadding = 0;
    	var maxLineWidth = function(line) {
    		width = Math.max(width, ctx.measureText(line).width + widthPadding);
    	};

    	ctx.font = helpers$1.fontString(titleFontSize, model._titleFontStyle, model._titleFontFamily);
    	helpers$1.each(model.title, maxLineWidth);

    	// Body width
    	ctx.font = helpers$1.fontString(bodyFontSize, model._bodyFontStyle, model._bodyFontFamily);
    	helpers$1.each(model.beforeBody.concat(model.afterBody), maxLineWidth);

    	// Body lines may include some extra width due to the color box
    	widthPadding = model.displayColors ? (bodyFontSize + 2) : 0;
    	helpers$1.each(body, function(bodyItem) {
    		helpers$1.each(bodyItem.before, maxLineWidth);
    		helpers$1.each(bodyItem.lines, maxLineWidth);
    		helpers$1.each(bodyItem.after, maxLineWidth);
    	});

    	// Reset back to 0
    	widthPadding = 0;

    	// Footer width
    	ctx.font = helpers$1.fontString(footerFontSize, model._footerFontStyle, model._footerFontFamily);
    	helpers$1.each(model.footer, maxLineWidth);

    	// Add padding
    	width += 2 * model.xPadding;

    	return {
    		width: width,
    		height: height
    	};
    }

    /**
     * Helper to get the alignment of a tooltip given the size
     */
    function determineAlignment(tooltip, size) {
    	var model = tooltip._model;
    	var chart = tooltip._chart;
    	var chartArea = tooltip._chart.chartArea;
    	var xAlign = 'center';
    	var yAlign = 'center';

    	if (model.y < size.height) {
    		yAlign = 'top';
    	} else if (model.y > (chart.height - size.height)) {
    		yAlign = 'bottom';
    	}

    	var lf, rf; // functions to determine left, right alignment
    	var olf, orf; // functions to determine if left/right alignment causes tooltip to go outside chart
    	var yf; // function to get the y alignment if the tooltip goes outside of the left or right edges
    	var midX = (chartArea.left + chartArea.right) / 2;
    	var midY = (chartArea.top + chartArea.bottom) / 2;

    	if (yAlign === 'center') {
    		lf = function(x) {
    			return x <= midX;
    		};
    		rf = function(x) {
    			return x > midX;
    		};
    	} else {
    		lf = function(x) {
    			return x <= (size.width / 2);
    		};
    		rf = function(x) {
    			return x >= (chart.width - (size.width / 2));
    		};
    	}

    	olf = function(x) {
    		return x + size.width + model.caretSize + model.caretPadding > chart.width;
    	};
    	orf = function(x) {
    		return x - size.width - model.caretSize - model.caretPadding < 0;
    	};
    	yf = function(y) {
    		return y <= midY ? 'top' : 'bottom';
    	};

    	if (lf(model.x)) {
    		xAlign = 'left';

    		// Is tooltip too wide and goes over the right side of the chart.?
    		if (olf(model.x)) {
    			xAlign = 'center';
    			yAlign = yf(model.y);
    		}
    	} else if (rf(model.x)) {
    		xAlign = 'right';

    		// Is tooltip too wide and goes outside left edge of canvas?
    		if (orf(model.x)) {
    			xAlign = 'center';
    			yAlign = yf(model.y);
    		}
    	}

    	var opts = tooltip._options;
    	return {
    		xAlign: opts.xAlign ? opts.xAlign : xAlign,
    		yAlign: opts.yAlign ? opts.yAlign : yAlign
    	};
    }

    /**
     * Helper to get the location a tooltip needs to be placed at given the initial position (via the vm) and the size and alignment
     */
    function getBackgroundPoint(vm, size, alignment, chart) {
    	// Background Position
    	var x = vm.x;
    	var y = vm.y;

    	var caretSize = vm.caretSize;
    	var caretPadding = vm.caretPadding;
    	var cornerRadius = vm.cornerRadius;
    	var xAlign = alignment.xAlign;
    	var yAlign = alignment.yAlign;
    	var paddingAndSize = caretSize + caretPadding;
    	var radiusAndPadding = cornerRadius + caretPadding;

    	if (xAlign === 'right') {
    		x -= size.width;
    	} else if (xAlign === 'center') {
    		x -= (size.width / 2);
    		if (x + size.width > chart.width) {
    			x = chart.width - size.width;
    		}
    		if (x < 0) {
    			x = 0;
    		}
    	}

    	if (yAlign === 'top') {
    		y += paddingAndSize;
    	} else if (yAlign === 'bottom') {
    		y -= size.height + paddingAndSize;
    	} else {
    		y -= (size.height / 2);
    	}

    	if (yAlign === 'center') {
    		if (xAlign === 'left') {
    			x += paddingAndSize;
    		} else if (xAlign === 'right') {
    			x -= paddingAndSize;
    		}
    	} else if (xAlign === 'left') {
    		x -= radiusAndPadding;
    	} else if (xAlign === 'right') {
    		x += radiusAndPadding;
    	}

    	return {
    		x: x,
    		y: y
    	};
    }

    function getAlignedX(vm, align) {
    	return align === 'center'
    		? vm.x + vm.width / 2
    		: align === 'right'
    			? vm.x + vm.width - vm.xPadding
    			: vm.x + vm.xPadding;
    }

    /**
     * Helper to build before and after body lines
     */
    function getBeforeAfterBodyLines(callback) {
    	return pushOrConcat([], splitNewlines(callback));
    }

    var exports$4 = core_element.extend({
    	initialize: function() {
    		this._model = getBaseModel(this._options);
    		this._lastActive = [];
    	},

    	// Get the title
    	// Args are: (tooltipItem, data)
    	getTitle: function() {
    		var me = this;
    		var opts = me._options;
    		var callbacks = opts.callbacks;

    		var beforeTitle = callbacks.beforeTitle.apply(me, arguments);
    		var title = callbacks.title.apply(me, arguments);
    		var afterTitle = callbacks.afterTitle.apply(me, arguments);

    		var lines = [];
    		lines = pushOrConcat(lines, splitNewlines(beforeTitle));
    		lines = pushOrConcat(lines, splitNewlines(title));
    		lines = pushOrConcat(lines, splitNewlines(afterTitle));

    		return lines;
    	},

    	// Args are: (tooltipItem, data)
    	getBeforeBody: function() {
    		return getBeforeAfterBodyLines(this._options.callbacks.beforeBody.apply(this, arguments));
    	},

    	// Args are: (tooltipItem, data)
    	getBody: function(tooltipItems, data) {
    		var me = this;
    		var callbacks = me._options.callbacks;
    		var bodyItems = [];

    		helpers$1.each(tooltipItems, function(tooltipItem) {
    			var bodyItem = {
    				before: [],
    				lines: [],
    				after: []
    			};
    			pushOrConcat(bodyItem.before, splitNewlines(callbacks.beforeLabel.call(me, tooltipItem, data)));
    			pushOrConcat(bodyItem.lines, callbacks.label.call(me, tooltipItem, data));
    			pushOrConcat(bodyItem.after, splitNewlines(callbacks.afterLabel.call(me, tooltipItem, data)));

    			bodyItems.push(bodyItem);
    		});

    		return bodyItems;
    	},

    	// Args are: (tooltipItem, data)
    	getAfterBody: function() {
    		return getBeforeAfterBodyLines(this._options.callbacks.afterBody.apply(this, arguments));
    	},

    	// Get the footer and beforeFooter and afterFooter lines
    	// Args are: (tooltipItem, data)
    	getFooter: function() {
    		var me = this;
    		var callbacks = me._options.callbacks;

    		var beforeFooter = callbacks.beforeFooter.apply(me, arguments);
    		var footer = callbacks.footer.apply(me, arguments);
    		var afterFooter = callbacks.afterFooter.apply(me, arguments);

    		var lines = [];
    		lines = pushOrConcat(lines, splitNewlines(beforeFooter));
    		lines = pushOrConcat(lines, splitNewlines(footer));
    		lines = pushOrConcat(lines, splitNewlines(afterFooter));

    		return lines;
    	},

    	update: function(changed) {
    		var me = this;
    		var opts = me._options;

    		// Need to regenerate the model because its faster than using extend and it is necessary due to the optimization in Chart.Element.transition
    		// that does _view = _model if ease === 1. This causes the 2nd tooltip update to set properties in both the view and model at the same time
    		// which breaks any animations.
    		var existingModel = me._model;
    		var model = me._model = getBaseModel(opts);
    		var active = me._active;

    		var data = me._data;

    		// In the case where active.length === 0 we need to keep these at existing values for good animations
    		var alignment = {
    			xAlign: existingModel.xAlign,
    			yAlign: existingModel.yAlign
    		};
    		var backgroundPoint = {
    			x: existingModel.x,
    			y: existingModel.y
    		};
    		var tooltipSize = {
    			width: existingModel.width,
    			height: existingModel.height
    		};
    		var tooltipPosition = {
    			x: existingModel.caretX,
    			y: existingModel.caretY
    		};

    		var i, len;

    		if (active.length) {
    			model.opacity = 1;

    			var labelColors = [];
    			var labelTextColors = [];
    			tooltipPosition = positioners[opts.position].call(me, active, me._eventPosition);

    			var tooltipItems = [];
    			for (i = 0, len = active.length; i < len; ++i) {
    				tooltipItems.push(createTooltipItem(active[i]));
    			}

    			// If the user provided a filter function, use it to modify the tooltip items
    			if (opts.filter) {
    				tooltipItems = tooltipItems.filter(function(a) {
    					return opts.filter(a, data);
    				});
    			}

    			// If the user provided a sorting function, use it to modify the tooltip items
    			if (opts.itemSort) {
    				tooltipItems = tooltipItems.sort(function(a, b) {
    					return opts.itemSort(a, b, data);
    				});
    			}

    			// Determine colors for boxes
    			helpers$1.each(tooltipItems, function(tooltipItem) {
    				labelColors.push(opts.callbacks.labelColor.call(me, tooltipItem, me._chart));
    				labelTextColors.push(opts.callbacks.labelTextColor.call(me, tooltipItem, me._chart));
    			});


    			// Build the Text Lines
    			model.title = me.getTitle(tooltipItems, data);
    			model.beforeBody = me.getBeforeBody(tooltipItems, data);
    			model.body = me.getBody(tooltipItems, data);
    			model.afterBody = me.getAfterBody(tooltipItems, data);
    			model.footer = me.getFooter(tooltipItems, data);

    			// Initial positioning and colors
    			model.x = tooltipPosition.x;
    			model.y = tooltipPosition.y;
    			model.caretPadding = opts.caretPadding;
    			model.labelColors = labelColors;
    			model.labelTextColors = labelTextColors;

    			// data points
    			model.dataPoints = tooltipItems;

    			// We need to determine alignment of the tooltip
    			tooltipSize = getTooltipSize(this, model);
    			alignment = determineAlignment(this, tooltipSize);
    			// Final Size and Position
    			backgroundPoint = getBackgroundPoint(model, tooltipSize, alignment, me._chart);
    		} else {
    			model.opacity = 0;
    		}

    		model.xAlign = alignment.xAlign;
    		model.yAlign = alignment.yAlign;
    		model.x = backgroundPoint.x;
    		model.y = backgroundPoint.y;
    		model.width = tooltipSize.width;
    		model.height = tooltipSize.height;

    		// Point where the caret on the tooltip points to
    		model.caretX = tooltipPosition.x;
    		model.caretY = tooltipPosition.y;

    		me._model = model;

    		if (changed && opts.custom) {
    			opts.custom.call(me, model);
    		}

    		return me;
    	},

    	drawCaret: function(tooltipPoint, size) {
    		var ctx = this._chart.ctx;
    		var vm = this._view;
    		var caretPosition = this.getCaretPosition(tooltipPoint, size, vm);

    		ctx.lineTo(caretPosition.x1, caretPosition.y1);
    		ctx.lineTo(caretPosition.x2, caretPosition.y2);
    		ctx.lineTo(caretPosition.x3, caretPosition.y3);
    	},
    	getCaretPosition: function(tooltipPoint, size, vm) {
    		var x1, x2, x3, y1, y2, y3;
    		var caretSize = vm.caretSize;
    		var cornerRadius = vm.cornerRadius;
    		var xAlign = vm.xAlign;
    		var yAlign = vm.yAlign;
    		var ptX = tooltipPoint.x;
    		var ptY = tooltipPoint.y;
    		var width = size.width;
    		var height = size.height;

    		if (yAlign === 'center') {
    			y2 = ptY + (height / 2);

    			if (xAlign === 'left') {
    				x1 = ptX;
    				x2 = x1 - caretSize;
    				x3 = x1;

    				y1 = y2 + caretSize;
    				y3 = y2 - caretSize;
    			} else {
    				x1 = ptX + width;
    				x2 = x1 + caretSize;
    				x3 = x1;

    				y1 = y2 - caretSize;
    				y3 = y2 + caretSize;
    			}
    		} else {
    			if (xAlign === 'left') {
    				x2 = ptX + cornerRadius + (caretSize);
    				x1 = x2 - caretSize;
    				x3 = x2 + caretSize;
    			} else if (xAlign === 'right') {
    				x2 = ptX + width - cornerRadius - caretSize;
    				x1 = x2 - caretSize;
    				x3 = x2 + caretSize;
    			} else {
    				x2 = vm.caretX;
    				x1 = x2 - caretSize;
    				x3 = x2 + caretSize;
    			}
    			if (yAlign === 'top') {
    				y1 = ptY;
    				y2 = y1 - caretSize;
    				y3 = y1;
    			} else {
    				y1 = ptY + height;
    				y2 = y1 + caretSize;
    				y3 = y1;
    				// invert drawing order
    				var tmp = x3;
    				x3 = x1;
    				x1 = tmp;
    			}
    		}
    		return {x1: x1, x2: x2, x3: x3, y1: y1, y2: y2, y3: y3};
    	},

    	drawTitle: function(pt, vm, ctx) {
    		var title = vm.title;
    		var length = title.length;
    		var titleFontSize, titleSpacing, i;

    		if (length) {
    			var rtlHelper = getRtlHelper(vm.rtl, vm.x, vm.width);

    			pt.x = getAlignedX(vm, vm._titleAlign);

    			ctx.textAlign = rtlHelper.textAlign(vm._titleAlign);
    			ctx.textBaseline = 'middle';

    			titleFontSize = vm.titleFontSize;
    			titleSpacing = vm.titleSpacing;

    			ctx.fillStyle = vm.titleFontColor;
    			ctx.font = helpers$1.fontString(titleFontSize, vm._titleFontStyle, vm._titleFontFamily);

    			for (i = 0; i < length; ++i) {
    				ctx.fillText(title[i], rtlHelper.x(pt.x), pt.y + titleFontSize / 2);
    				pt.y += titleFontSize + titleSpacing; // Line Height and spacing

    				if (i + 1 === length) {
    					pt.y += vm.titleMarginBottom - titleSpacing; // If Last, add margin, remove spacing
    				}
    			}
    		}
    	},

    	drawBody: function(pt, vm, ctx) {
    		var bodyFontSize = vm.bodyFontSize;
    		var bodySpacing = vm.bodySpacing;
    		var bodyAlign = vm._bodyAlign;
    		var body = vm.body;
    		var drawColorBoxes = vm.displayColors;
    		var xLinePadding = 0;
    		var colorX = drawColorBoxes ? getAlignedX(vm, 'left') : 0;

    		var rtlHelper = getRtlHelper(vm.rtl, vm.x, vm.width);

    		var fillLineOfText = function(line) {
    			ctx.fillText(line, rtlHelper.x(pt.x + xLinePadding), pt.y + bodyFontSize / 2);
    			pt.y += bodyFontSize + bodySpacing;
    		};

    		var bodyItem, textColor, labelColors, lines, i, j, ilen, jlen;
    		var bodyAlignForCalculation = rtlHelper.textAlign(bodyAlign);

    		ctx.textAlign = bodyAlign;
    		ctx.textBaseline = 'middle';
    		ctx.font = helpers$1.fontString(bodyFontSize, vm._bodyFontStyle, vm._bodyFontFamily);

    		pt.x = getAlignedX(vm, bodyAlignForCalculation);

    		// Before body lines
    		ctx.fillStyle = vm.bodyFontColor;
    		helpers$1.each(vm.beforeBody, fillLineOfText);

    		xLinePadding = drawColorBoxes && bodyAlignForCalculation !== 'right'
    			? bodyAlign === 'center' ? (bodyFontSize / 2 + 1) : (bodyFontSize + 2)
    			: 0;

    		// Draw body lines now
    		for (i = 0, ilen = body.length; i < ilen; ++i) {
    			bodyItem = body[i];
    			textColor = vm.labelTextColors[i];
    			labelColors = vm.labelColors[i];

    			ctx.fillStyle = textColor;
    			helpers$1.each(bodyItem.before, fillLineOfText);

    			lines = bodyItem.lines;
    			for (j = 0, jlen = lines.length; j < jlen; ++j) {
    				// Draw Legend-like boxes if needed
    				if (drawColorBoxes) {
    					var rtlColorX = rtlHelper.x(colorX);

    					// Fill a white rect so that colours merge nicely if the opacity is < 1
    					ctx.fillStyle = vm.legendColorBackground;
    					ctx.fillRect(rtlHelper.leftForLtr(rtlColorX, bodyFontSize), pt.y, bodyFontSize, bodyFontSize);

    					// Border
    					ctx.lineWidth = 1;
    					ctx.strokeStyle = labelColors.borderColor;
    					ctx.strokeRect(rtlHelper.leftForLtr(rtlColorX, bodyFontSize), pt.y, bodyFontSize, bodyFontSize);

    					// Inner square
    					ctx.fillStyle = labelColors.backgroundColor;
    					ctx.fillRect(rtlHelper.leftForLtr(rtlHelper.xPlus(rtlColorX, 1), bodyFontSize - 2), pt.y + 1, bodyFontSize - 2, bodyFontSize - 2);
    					ctx.fillStyle = textColor;
    				}

    				fillLineOfText(lines[j]);
    			}

    			helpers$1.each(bodyItem.after, fillLineOfText);
    		}

    		// Reset back to 0 for after body
    		xLinePadding = 0;

    		// After body lines
    		helpers$1.each(vm.afterBody, fillLineOfText);
    		pt.y -= bodySpacing; // Remove last body spacing
    	},

    	drawFooter: function(pt, vm, ctx) {
    		var footer = vm.footer;
    		var length = footer.length;
    		var footerFontSize, i;

    		if (length) {
    			var rtlHelper = getRtlHelper(vm.rtl, vm.x, vm.width);

    			pt.x = getAlignedX(vm, vm._footerAlign);
    			pt.y += vm.footerMarginTop;

    			ctx.textAlign = rtlHelper.textAlign(vm._footerAlign);
    			ctx.textBaseline = 'middle';

    			footerFontSize = vm.footerFontSize;

    			ctx.fillStyle = vm.footerFontColor;
    			ctx.font = helpers$1.fontString(footerFontSize, vm._footerFontStyle, vm._footerFontFamily);

    			for (i = 0; i < length; ++i) {
    				ctx.fillText(footer[i], rtlHelper.x(pt.x), pt.y + footerFontSize / 2);
    				pt.y += footerFontSize + vm.footerSpacing;
    			}
    		}
    	},

    	drawBackground: function(pt, vm, ctx, tooltipSize) {
    		ctx.fillStyle = vm.backgroundColor;
    		ctx.strokeStyle = vm.borderColor;
    		ctx.lineWidth = vm.borderWidth;
    		var xAlign = vm.xAlign;
    		var yAlign = vm.yAlign;
    		var x = pt.x;
    		var y = pt.y;
    		var width = tooltipSize.width;
    		var height = tooltipSize.height;
    		var radius = vm.cornerRadius;

    		ctx.beginPath();
    		ctx.moveTo(x + radius, y);
    		if (yAlign === 'top') {
    			this.drawCaret(pt, tooltipSize);
    		}
    		ctx.lineTo(x + width - radius, y);
    		ctx.quadraticCurveTo(x + width, y, x + width, y + radius);
    		if (yAlign === 'center' && xAlign === 'right') {
    			this.drawCaret(pt, tooltipSize);
    		}
    		ctx.lineTo(x + width, y + height - radius);
    		ctx.quadraticCurveTo(x + width, y + height, x + width - radius, y + height);
    		if (yAlign === 'bottom') {
    			this.drawCaret(pt, tooltipSize);
    		}
    		ctx.lineTo(x + radius, y + height);
    		ctx.quadraticCurveTo(x, y + height, x, y + height - radius);
    		if (yAlign === 'center' && xAlign === 'left') {
    			this.drawCaret(pt, tooltipSize);
    		}
    		ctx.lineTo(x, y + radius);
    		ctx.quadraticCurveTo(x, y, x + radius, y);
    		ctx.closePath();

    		ctx.fill();

    		if (vm.borderWidth > 0) {
    			ctx.stroke();
    		}
    	},

    	draw: function() {
    		var ctx = this._chart.ctx;
    		var vm = this._view;

    		if (vm.opacity === 0) {
    			return;
    		}

    		var tooltipSize = {
    			width: vm.width,
    			height: vm.height
    		};
    		var pt = {
    			x: vm.x,
    			y: vm.y
    		};

    		// IE11/Edge does not like very small opacities, so snap to 0
    		var opacity = Math.abs(vm.opacity < 1e-3) ? 0 : vm.opacity;

    		// Truthy/falsey value for empty tooltip
    		var hasTooltipContent = vm.title.length || vm.beforeBody.length || vm.body.length || vm.afterBody.length || vm.footer.length;

    		if (this._options.enabled && hasTooltipContent) {
    			ctx.save();
    			ctx.globalAlpha = opacity;

    			// Draw Background
    			this.drawBackground(pt, vm, ctx, tooltipSize);

    			// Draw Title, Body, and Footer
    			pt.y += vm.yPadding;

    			helpers$1.rtl.overrideTextDirection(ctx, vm.textDirection);

    			// Titles
    			this.drawTitle(pt, vm, ctx);

    			// Body
    			this.drawBody(pt, vm, ctx);

    			// Footer
    			this.drawFooter(pt, vm, ctx);

    			helpers$1.rtl.restoreTextDirection(ctx, vm.textDirection);

    			ctx.restore();
    		}
    	},

    	/**
    	 * Handle an event
    	 * @private
    	 * @param {IEvent} event - The event to handle
    	 * @returns {boolean} true if the tooltip changed
    	 */
    	handleEvent: function(e) {
    		var me = this;
    		var options = me._options;
    		var changed = false;

    		me._lastActive = me._lastActive || [];

    		// Find Active Elements for tooltips
    		if (e.type === 'mouseout') {
    			me._active = [];
    		} else {
    			me._active = me._chart.getElementsAtEventForMode(e, options.mode, options);
    			if (options.reverse) {
    				me._active.reverse();
    			}
    		}

    		// Remember Last Actives
    		changed = !helpers$1.arrayEquals(me._active, me._lastActive);

    		// Only handle target event on tooltip change
    		if (changed) {
    			me._lastActive = me._active;

    			if (options.enabled || options.custom) {
    				me._eventPosition = {
    					x: e.x,
    					y: e.y
    				};

    				me.update(true);
    				me.pivot();
    			}
    		}

    		return changed;
    	}
    });

    /**
     * @namespace Chart.Tooltip.positioners
     */
    var positioners_1 = positioners;

    var core_tooltip = exports$4;
    core_tooltip.positioners = positioners_1;

    var valueOrDefault$9 = helpers$1.valueOrDefault;

    core_defaults._set('global', {
    	elements: {},
    	events: [
    		'mousemove',
    		'mouseout',
    		'click',
    		'touchstart',
    		'touchmove'
    	],
    	hover: {
    		onHover: null,
    		mode: 'nearest',
    		intersect: true,
    		animationDuration: 400
    	},
    	onClick: null,
    	maintainAspectRatio: true,
    	responsive: true,
    	responsiveAnimationDuration: 0
    });

    /**
     * Recursively merge the given config objects representing the `scales` option
     * by incorporating scale defaults in `xAxes` and `yAxes` array items, then
     * returns a deep copy of the result, thus doesn't alter inputs.
     */
    function mergeScaleConfig(/* config objects ... */) {
    	return helpers$1.merge(Object.create(null), [].slice.call(arguments), {
    		merger: function(key, target, source, options) {
    			if (key === 'xAxes' || key === 'yAxes') {
    				var slen = source[key].length;
    				var i, type, scale;

    				if (!target[key]) {
    					target[key] = [];
    				}

    				for (i = 0; i < slen; ++i) {
    					scale = source[key][i];
    					type = valueOrDefault$9(scale.type, key === 'xAxes' ? 'category' : 'linear');

    					if (i >= target[key].length) {
    						target[key].push({});
    					}

    					if (!target[key][i].type || (scale.type && scale.type !== target[key][i].type)) {
    						// new/untyped scale or type changed: let's apply the new defaults
    						// then merge source scale to correctly overwrite the defaults.
    						helpers$1.merge(target[key][i], [core_scaleService.getScaleDefaults(type), scale]);
    					} else {
    						// scales type are the same
    						helpers$1.merge(target[key][i], scale);
    					}
    				}
    			} else {
    				helpers$1._merger(key, target, source, options);
    			}
    		}
    	});
    }

    /**
     * Recursively merge the given config objects as the root options by handling
     * default scale options for the `scales` and `scale` properties, then returns
     * a deep copy of the result, thus doesn't alter inputs.
     */
    function mergeConfig(/* config objects ... */) {
    	return helpers$1.merge(Object.create(null), [].slice.call(arguments), {
    		merger: function(key, target, source, options) {
    			var tval = target[key] || Object.create(null);
    			var sval = source[key];

    			if (key === 'scales') {
    				// scale config merging is complex. Add our own function here for that
    				target[key] = mergeScaleConfig(tval, sval);
    			} else if (key === 'scale') {
    				// used in polar area & radar charts since there is only one scale
    				target[key] = helpers$1.merge(tval, [core_scaleService.getScaleDefaults(sval.type), sval]);
    			} else {
    				helpers$1._merger(key, target, source, options);
    			}
    		}
    	});
    }

    function initConfig(config) {
    	config = config || Object.create(null);

    	// Do NOT use mergeConfig for the data object because this method merges arrays
    	// and so would change references to labels and datasets, preventing data updates.
    	var data = config.data = config.data || {};
    	data.datasets = data.datasets || [];
    	data.labels = data.labels || [];

    	config.options = mergeConfig(
    		core_defaults.global,
    		core_defaults[config.type],
    		config.options || {});

    	return config;
    }

    function updateConfig(chart) {
    	var newOptions = chart.options;

    	helpers$1.each(chart.scales, function(scale) {
    		core_layouts.removeBox(chart, scale);
    	});

    	newOptions = mergeConfig(
    		core_defaults.global,
    		core_defaults[chart.config.type],
    		newOptions);

    	chart.options = chart.config.options = newOptions;
    	chart.ensureScalesHaveIDs();
    	chart.buildOrUpdateScales();

    	// Tooltip
    	chart.tooltip._options = newOptions.tooltips;
    	chart.tooltip.initialize();
    }

    function nextAvailableScaleId(axesOpts, prefix, index) {
    	var id;
    	var hasId = function(obj) {
    		return obj.id === id;
    	};

    	do {
    		id = prefix + index++;
    	} while (helpers$1.findIndex(axesOpts, hasId) >= 0);

    	return id;
    }

    function positionIsHorizontal(position) {
    	return position === 'top' || position === 'bottom';
    }

    function compare2Level(l1, l2) {
    	return function(a, b) {
    		return a[l1] === b[l1]
    			? a[l2] - b[l2]
    			: a[l1] - b[l1];
    	};
    }

    var Chart = function(item, config) {
    	this.construct(item, config);
    	return this;
    };

    helpers$1.extend(Chart.prototype, /** @lends Chart */ {
    	/**
    	 * @private
    	 */
    	construct: function(item, config) {
    		var me = this;

    		config = initConfig(config);

    		var context = platform.acquireContext(item, config);
    		var canvas = context && context.canvas;
    		var height = canvas && canvas.height;
    		var width = canvas && canvas.width;

    		me.id = helpers$1.uid();
    		me.ctx = context;
    		me.canvas = canvas;
    		me.config = config;
    		me.width = width;
    		me.height = height;
    		me.aspectRatio = height ? width / height : null;
    		me.options = config.options;
    		me._bufferedRender = false;
    		me._layers = [];

    		/**
    		 * Provided for backward compatibility, Chart and Chart.Controller have been merged,
    		 * the "instance" still need to be defined since it might be called from plugins.
    		 * @prop Chart#chart
    		 * @deprecated since version 2.6.0
    		 * @todo remove at version 3
    		 * @private
    		 */
    		me.chart = me;
    		me.controller = me; // chart.chart.controller #inception

    		// Add the chart instance to the global namespace
    		Chart.instances[me.id] = me;

    		// Define alias to the config data: `chart.data === chart.config.data`
    		Object.defineProperty(me, 'data', {
    			get: function() {
    				return me.config.data;
    			},
    			set: function(value) {
    				me.config.data = value;
    			}
    		});

    		if (!context || !canvas) {
    			// The given item is not a compatible context2d element, let's return before finalizing
    			// the chart initialization but after setting basic chart / controller properties that
    			// can help to figure out that the chart is not valid (e.g chart.canvas !== null);
    			// https://github.com/chartjs/Chart.js/issues/2807
    			console.error("Failed to create chart: can't acquire context from the given item");
    			return;
    		}

    		me.initialize();
    		me.update();
    	},

    	/**
    	 * @private
    	 */
    	initialize: function() {
    		var me = this;

    		// Before init plugin notification
    		core_plugins.notify(me, 'beforeInit');

    		helpers$1.retinaScale(me, me.options.devicePixelRatio);

    		me.bindEvents();

    		if (me.options.responsive) {
    			// Initial resize before chart draws (must be silent to preserve initial animations).
    			me.resize(true);
    		}

    		me.initToolTip();

    		// After init plugin notification
    		core_plugins.notify(me, 'afterInit');

    		return me;
    	},

    	clear: function() {
    		helpers$1.canvas.clear(this);
    		return this;
    	},

    	stop: function() {
    		// Stops any current animation loop occurring
    		core_animations.cancelAnimation(this);
    		return this;
    	},

    	resize: function(silent) {
    		var me = this;
    		var options = me.options;
    		var canvas = me.canvas;
    		var aspectRatio = (options.maintainAspectRatio && me.aspectRatio) || null;

    		// the canvas render width and height will be casted to integers so make sure that
    		// the canvas display style uses the same integer values to avoid blurring effect.

    		// Set to 0 instead of canvas.size because the size defaults to 300x150 if the element is collapsed
    		var newWidth = Math.max(0, Math.floor(helpers$1.getMaximumWidth(canvas)));
    		var newHeight = Math.max(0, Math.floor(aspectRatio ? newWidth / aspectRatio : helpers$1.getMaximumHeight(canvas)));

    		if (me.width === newWidth && me.height === newHeight) {
    			return;
    		}

    		canvas.width = me.width = newWidth;
    		canvas.height = me.height = newHeight;
    		canvas.style.width = newWidth + 'px';
    		canvas.style.height = newHeight + 'px';

    		helpers$1.retinaScale(me, options.devicePixelRatio);

    		if (!silent) {
    			// Notify any plugins about the resize
    			var newSize = {width: newWidth, height: newHeight};
    			core_plugins.notify(me, 'resize', [newSize]);

    			// Notify of resize
    			if (options.onResize) {
    				options.onResize(me, newSize);
    			}

    			me.stop();
    			me.update({
    				duration: options.responsiveAnimationDuration
    			});
    		}
    	},

    	ensureScalesHaveIDs: function() {
    		var options = this.options;
    		var scalesOptions = options.scales || {};
    		var scaleOptions = options.scale;

    		helpers$1.each(scalesOptions.xAxes, function(xAxisOptions, index) {
    			if (!xAxisOptions.id) {
    				xAxisOptions.id = nextAvailableScaleId(scalesOptions.xAxes, 'x-axis-', index);
    			}
    		});

    		helpers$1.each(scalesOptions.yAxes, function(yAxisOptions, index) {
    			if (!yAxisOptions.id) {
    				yAxisOptions.id = nextAvailableScaleId(scalesOptions.yAxes, 'y-axis-', index);
    			}
    		});

    		if (scaleOptions) {
    			scaleOptions.id = scaleOptions.id || 'scale';
    		}
    	},

    	/**
    	 * Builds a map of scale ID to scale object for future lookup.
    	 */
    	buildOrUpdateScales: function() {
    		var me = this;
    		var options = me.options;
    		var scales = me.scales || {};
    		var items = [];
    		var updated = Object.keys(scales).reduce(function(obj, id) {
    			obj[id] = false;
    			return obj;
    		}, {});

    		if (options.scales) {
    			items = items.concat(
    				(options.scales.xAxes || []).map(function(xAxisOptions) {
    					return {options: xAxisOptions, dtype: 'category', dposition: 'bottom'};
    				}),
    				(options.scales.yAxes || []).map(function(yAxisOptions) {
    					return {options: yAxisOptions, dtype: 'linear', dposition: 'left'};
    				})
    			);
    		}

    		if (options.scale) {
    			items.push({
    				options: options.scale,
    				dtype: 'radialLinear',
    				isDefault: true,
    				dposition: 'chartArea'
    			});
    		}

    		helpers$1.each(items, function(item) {
    			var scaleOptions = item.options;
    			var id = scaleOptions.id;
    			var scaleType = valueOrDefault$9(scaleOptions.type, item.dtype);

    			if (positionIsHorizontal(scaleOptions.position) !== positionIsHorizontal(item.dposition)) {
    				scaleOptions.position = item.dposition;
    			}

    			updated[id] = true;
    			var scale = null;
    			if (id in scales && scales[id].type === scaleType) {
    				scale = scales[id];
    				scale.options = scaleOptions;
    				scale.ctx = me.ctx;
    				scale.chart = me;
    			} else {
    				var scaleClass = core_scaleService.getScaleConstructor(scaleType);
    				if (!scaleClass) {
    					return;
    				}
    				scale = new scaleClass({
    					id: id,
    					type: scaleType,
    					options: scaleOptions,
    					ctx: me.ctx,
    					chart: me
    				});
    				scales[scale.id] = scale;
    			}

    			scale.mergeTicksOptions();

    			// TODO(SB): I think we should be able to remove this custom case (options.scale)
    			// and consider it as a regular scale part of the "scales"" map only! This would
    			// make the logic easier and remove some useless? custom code.
    			if (item.isDefault) {
    				me.scale = scale;
    			}
    		});
    		// clear up discarded scales
    		helpers$1.each(updated, function(hasUpdated, id) {
    			if (!hasUpdated) {
    				delete scales[id];
    			}
    		});

    		me.scales = scales;

    		core_scaleService.addScalesToLayout(this);
    	},

    	buildOrUpdateControllers: function() {
    		var me = this;
    		var newControllers = [];
    		var datasets = me.data.datasets;
    		var i, ilen;

    		for (i = 0, ilen = datasets.length; i < ilen; i++) {
    			var dataset = datasets[i];
    			var meta = me.getDatasetMeta(i);
    			var type = dataset.type || me.config.type;

    			if (meta.type && meta.type !== type) {
    				me.destroyDatasetMeta(i);
    				meta = me.getDatasetMeta(i);
    			}
    			meta.type = type;
    			meta.order = dataset.order || 0;
    			meta.index = i;

    			if (meta.controller) {
    				meta.controller.updateIndex(i);
    				meta.controller.linkScales();
    			} else {
    				var ControllerClass = controllers[meta.type];
    				if (ControllerClass === undefined) {
    					throw new Error('"' + meta.type + '" is not a chart type.');
    				}

    				meta.controller = new ControllerClass(me, i);
    				newControllers.push(meta.controller);
    			}
    		}

    		return newControllers;
    	},

    	/**
    	 * Reset the elements of all datasets
    	 * @private
    	 */
    	resetElements: function() {
    		var me = this;
    		helpers$1.each(me.data.datasets, function(dataset, datasetIndex) {
    			me.getDatasetMeta(datasetIndex).controller.reset();
    		}, me);
    	},

    	/**
    	* Resets the chart back to it's state before the initial animation
    	*/
    	reset: function() {
    		this.resetElements();
    		this.tooltip.initialize();
    	},

    	update: function(config) {
    		var me = this;
    		var i, ilen;

    		if (!config || typeof config !== 'object') {
    			// backwards compatibility
    			config = {
    				duration: config,
    				lazy: arguments[1]
    			};
    		}

    		updateConfig(me);

    		// plugins options references might have change, let's invalidate the cache
    		// https://github.com/chartjs/Chart.js/issues/5111#issuecomment-355934167
    		core_plugins._invalidate(me);

    		if (core_plugins.notify(me, 'beforeUpdate') === false) {
    			return;
    		}

    		// In case the entire data object changed
    		me.tooltip._data = me.data;

    		// Make sure dataset controllers are updated and new controllers are reset
    		var newControllers = me.buildOrUpdateControllers();

    		// Make sure all dataset controllers have correct meta data counts
    		for (i = 0, ilen = me.data.datasets.length; i < ilen; i++) {
    			me.getDatasetMeta(i).controller.buildOrUpdateElements();
    		}

    		me.updateLayout();

    		// Can only reset the new controllers after the scales have been updated
    		if (me.options.animation && me.options.animation.duration) {
    			helpers$1.each(newControllers, function(controller) {
    				controller.reset();
    			});
    		}

    		me.updateDatasets();

    		// Need to reset tooltip in case it is displayed with elements that are removed
    		// after update.
    		me.tooltip.initialize();

    		// Last active contains items that were previously in the tooltip.
    		// When we reset the tooltip, we need to clear it
    		me.lastActive = [];

    		// Do this before render so that any plugins that need final scale updates can use it
    		core_plugins.notify(me, 'afterUpdate');

    		me._layers.sort(compare2Level('z', '_idx'));

    		if (me._bufferedRender) {
    			me._bufferedRequest = {
    				duration: config.duration,
    				easing: config.easing,
    				lazy: config.lazy
    			};
    		} else {
    			me.render(config);
    		}
    	},

    	/**
    	 * Updates the chart layout unless a plugin returns `false` to the `beforeLayout`
    	 * hook, in which case, plugins will not be called on `afterLayout`.
    	 * @private
    	 */
    	updateLayout: function() {
    		var me = this;

    		if (core_plugins.notify(me, 'beforeLayout') === false) {
    			return;
    		}

    		core_layouts.update(this, this.width, this.height);

    		me._layers = [];
    		helpers$1.each(me.boxes, function(box) {
    			// _configure is called twice, once in core.scale.update and once here.
    			// Here the boxes are fully updated and at their final positions.
    			if (box._configure) {
    				box._configure();
    			}
    			me._layers.push.apply(me._layers, box._layers());
    		}, me);

    		me._layers.forEach(function(item, index) {
    			item._idx = index;
    		});

    		/**
    		 * Provided for backward compatibility, use `afterLayout` instead.
    		 * @method IPlugin#afterScaleUpdate
    		 * @deprecated since version 2.5.0
    		 * @todo remove at version 3
    		 * @private
    		 */
    		core_plugins.notify(me, 'afterScaleUpdate');
    		core_plugins.notify(me, 'afterLayout');
    	},

    	/**
    	 * Updates all datasets unless a plugin returns `false` to the `beforeDatasetsUpdate`
    	 * hook, in which case, plugins will not be called on `afterDatasetsUpdate`.
    	 * @private
    	 */
    	updateDatasets: function() {
    		var me = this;

    		if (core_plugins.notify(me, 'beforeDatasetsUpdate') === false) {
    			return;
    		}

    		for (var i = 0, ilen = me.data.datasets.length; i < ilen; ++i) {
    			me.updateDataset(i);
    		}

    		core_plugins.notify(me, 'afterDatasetsUpdate');
    	},

    	/**
    	 * Updates dataset at index unless a plugin returns `false` to the `beforeDatasetUpdate`
    	 * hook, in which case, plugins will not be called on `afterDatasetUpdate`.
    	 * @private
    	 */
    	updateDataset: function(index) {
    		var me = this;
    		var meta = me.getDatasetMeta(index);
    		var args = {
    			meta: meta,
    			index: index
    		};

    		if (core_plugins.notify(me, 'beforeDatasetUpdate', [args]) === false) {
    			return;
    		}

    		meta.controller._update();

    		core_plugins.notify(me, 'afterDatasetUpdate', [args]);
    	},

    	render: function(config) {
    		var me = this;

    		if (!config || typeof config !== 'object') {
    			// backwards compatibility
    			config = {
    				duration: config,
    				lazy: arguments[1]
    			};
    		}

    		var animationOptions = me.options.animation;
    		var duration = valueOrDefault$9(config.duration, animationOptions && animationOptions.duration);
    		var lazy = config.lazy;

    		if (core_plugins.notify(me, 'beforeRender') === false) {
    			return;
    		}

    		var onComplete = function(animation) {
    			core_plugins.notify(me, 'afterRender');
    			helpers$1.callback(animationOptions && animationOptions.onComplete, [animation], me);
    		};

    		if (animationOptions && duration) {
    			var animation = new core_animation({
    				numSteps: duration / 16.66, // 60 fps
    				easing: config.easing || animationOptions.easing,

    				render: function(chart, animationObject) {
    					var easingFunction = helpers$1.easing.effects[animationObject.easing];
    					var currentStep = animationObject.currentStep;
    					var stepDecimal = currentStep / animationObject.numSteps;

    					chart.draw(easingFunction(stepDecimal), stepDecimal, currentStep);
    				},

    				onAnimationProgress: animationOptions.onProgress,
    				onAnimationComplete: onComplete
    			});

    			core_animations.addAnimation(me, animation, duration, lazy);
    		} else {
    			me.draw();

    			// See https://github.com/chartjs/Chart.js/issues/3781
    			onComplete(new core_animation({numSteps: 0, chart: me}));
    		}

    		return me;
    	},

    	draw: function(easingValue) {
    		var me = this;
    		var i, layers;

    		me.clear();

    		if (helpers$1.isNullOrUndef(easingValue)) {
    			easingValue = 1;
    		}

    		me.transition(easingValue);

    		if (me.width <= 0 || me.height <= 0) {
    			return;
    		}

    		if (core_plugins.notify(me, 'beforeDraw', [easingValue]) === false) {
    			return;
    		}

    		// Because of plugin hooks (before/afterDatasetsDraw), datasets can't
    		// currently be part of layers. Instead, we draw
    		// layers <= 0 before(default, backward compat), and the rest after
    		layers = me._layers;
    		for (i = 0; i < layers.length && layers[i].z <= 0; ++i) {
    			layers[i].draw(me.chartArea);
    		}

    		me.drawDatasets(easingValue);

    		// Rest of layers
    		for (; i < layers.length; ++i) {
    			layers[i].draw(me.chartArea);
    		}

    		me._drawTooltip(easingValue);

    		core_plugins.notify(me, 'afterDraw', [easingValue]);
    	},

    	/**
    	 * @private
    	 */
    	transition: function(easingValue) {
    		var me = this;

    		for (var i = 0, ilen = (me.data.datasets || []).length; i < ilen; ++i) {
    			if (me.isDatasetVisible(i)) {
    				me.getDatasetMeta(i).controller.transition(easingValue);
    			}
    		}

    		me.tooltip.transition(easingValue);
    	},

    	/**
    	 * @private
    	 */
    	_getSortedDatasetMetas: function(filterVisible) {
    		var me = this;
    		var datasets = me.data.datasets || [];
    		var result = [];
    		var i, ilen;

    		for (i = 0, ilen = datasets.length; i < ilen; ++i) {
    			if (!filterVisible || me.isDatasetVisible(i)) {
    				result.push(me.getDatasetMeta(i));
    			}
    		}

    		result.sort(compare2Level('order', 'index'));

    		return result;
    	},

    	/**
    	 * @private
    	 */
    	_getSortedVisibleDatasetMetas: function() {
    		return this._getSortedDatasetMetas(true);
    	},

    	/**
    	 * Draws all datasets unless a plugin returns `false` to the `beforeDatasetsDraw`
    	 * hook, in which case, plugins will not be called on `afterDatasetsDraw`.
    	 * @private
    	 */
    	drawDatasets: function(easingValue) {
    		var me = this;
    		var metasets, i;

    		if (core_plugins.notify(me, 'beforeDatasetsDraw', [easingValue]) === false) {
    			return;
    		}

    		metasets = me._getSortedVisibleDatasetMetas();
    		for (i = metasets.length - 1; i >= 0; --i) {
    			me.drawDataset(metasets[i], easingValue);
    		}

    		core_plugins.notify(me, 'afterDatasetsDraw', [easingValue]);
    	},

    	/**
    	 * Draws dataset at index unless a plugin returns `false` to the `beforeDatasetDraw`
    	 * hook, in which case, plugins will not be called on `afterDatasetDraw`.
    	 * @private
    	 */
    	drawDataset: function(meta, easingValue) {
    		var me = this;
    		var args = {
    			meta: meta,
    			index: meta.index,
    			easingValue: easingValue
    		};

    		if (core_plugins.notify(me, 'beforeDatasetDraw', [args]) === false) {
    			return;
    		}

    		meta.controller.draw(easingValue);

    		core_plugins.notify(me, 'afterDatasetDraw', [args]);
    	},

    	/**
    	 * Draws tooltip unless a plugin returns `false` to the `beforeTooltipDraw`
    	 * hook, in which case, plugins will not be called on `afterTooltipDraw`.
    	 * @private
    	 */
    	_drawTooltip: function(easingValue) {
    		var me = this;
    		var tooltip = me.tooltip;
    		var args = {
    			tooltip: tooltip,
    			easingValue: easingValue
    		};

    		if (core_plugins.notify(me, 'beforeTooltipDraw', [args]) === false) {
    			return;
    		}

    		tooltip.draw();

    		core_plugins.notify(me, 'afterTooltipDraw', [args]);
    	},

    	/**
    	 * Get the single element that was clicked on
    	 * @return An object containing the dataset index and element index of the matching element. Also contains the rectangle that was draw
    	 */
    	getElementAtEvent: function(e) {
    		return core_interaction.modes.single(this, e);
    	},

    	getElementsAtEvent: function(e) {
    		return core_interaction.modes.label(this, e, {intersect: true});
    	},

    	getElementsAtXAxis: function(e) {
    		return core_interaction.modes['x-axis'](this, e, {intersect: true});
    	},

    	getElementsAtEventForMode: function(e, mode, options) {
    		var method = core_interaction.modes[mode];
    		if (typeof method === 'function') {
    			return method(this, e, options);
    		}

    		return [];
    	},

    	getDatasetAtEvent: function(e) {
    		return core_interaction.modes.dataset(this, e, {intersect: true});
    	},

    	getDatasetMeta: function(datasetIndex) {
    		var me = this;
    		var dataset = me.data.datasets[datasetIndex];
    		if (!dataset._meta) {
    			dataset._meta = {};
    		}

    		var meta = dataset._meta[me.id];
    		if (!meta) {
    			meta = dataset._meta[me.id] = {
    				type: null,
    				data: [],
    				dataset: null,
    				controller: null,
    				hidden: null,			// See isDatasetVisible() comment
    				xAxisID: null,
    				yAxisID: null,
    				order: dataset.order || 0,
    				index: datasetIndex
    			};
    		}

    		return meta;
    	},

    	getVisibleDatasetCount: function() {
    		var count = 0;
    		for (var i = 0, ilen = this.data.datasets.length; i < ilen; ++i) {
    			if (this.isDatasetVisible(i)) {
    				count++;
    			}
    		}
    		return count;
    	},

    	isDatasetVisible: function(datasetIndex) {
    		var meta = this.getDatasetMeta(datasetIndex);

    		// meta.hidden is a per chart dataset hidden flag override with 3 states: if true or false,
    		// the dataset.hidden value is ignored, else if null, the dataset hidden state is returned.
    		return typeof meta.hidden === 'boolean' ? !meta.hidden : !this.data.datasets[datasetIndex].hidden;
    	},

    	generateLegend: function() {
    		return this.options.legendCallback(this);
    	},

    	/**
    	 * @private
    	 */
    	destroyDatasetMeta: function(datasetIndex) {
    		var id = this.id;
    		var dataset = this.data.datasets[datasetIndex];
    		var meta = dataset._meta && dataset._meta[id];

    		if (meta) {
    			meta.controller.destroy();
    			delete dataset._meta[id];
    		}
    	},

    	destroy: function() {
    		var me = this;
    		var canvas = me.canvas;
    		var i, ilen;

    		me.stop();

    		// dataset controllers need to cleanup associated data
    		for (i = 0, ilen = me.data.datasets.length; i < ilen; ++i) {
    			me.destroyDatasetMeta(i);
    		}

    		if (canvas) {
    			me.unbindEvents();
    			helpers$1.canvas.clear(me);
    			platform.releaseContext(me.ctx);
    			me.canvas = null;
    			me.ctx = null;
    		}

    		core_plugins.notify(me, 'destroy');

    		delete Chart.instances[me.id];
    	},

    	toBase64Image: function() {
    		return this.canvas.toDataURL.apply(this.canvas, arguments);
    	},

    	initToolTip: function() {
    		var me = this;
    		me.tooltip = new core_tooltip({
    			_chart: me,
    			_chartInstance: me, // deprecated, backward compatibility
    			_data: me.data,
    			_options: me.options.tooltips
    		}, me);
    	},

    	/**
    	 * @private
    	 */
    	bindEvents: function() {
    		var me = this;
    		var listeners = me._listeners = {};
    		var listener = function() {
    			me.eventHandler.apply(me, arguments);
    		};

    		helpers$1.each(me.options.events, function(type) {
    			platform.addEventListener(me, type, listener);
    			listeners[type] = listener;
    		});

    		// Elements used to detect size change should not be injected for non responsive charts.
    		// See https://github.com/chartjs/Chart.js/issues/2210
    		if (me.options.responsive) {
    			listener = function() {
    				me.resize();
    			};

    			platform.addEventListener(me, 'resize', listener);
    			listeners.resize = listener;
    		}
    	},

    	/**
    	 * @private
    	 */
    	unbindEvents: function() {
    		var me = this;
    		var listeners = me._listeners;
    		if (!listeners) {
    			return;
    		}

    		delete me._listeners;
    		helpers$1.each(listeners, function(listener, type) {
    			platform.removeEventListener(me, type, listener);
    		});
    	},

    	updateHoverStyle: function(elements, mode, enabled) {
    		var prefix = enabled ? 'set' : 'remove';
    		var element, i, ilen;

    		for (i = 0, ilen = elements.length; i < ilen; ++i) {
    			element = elements[i];
    			if (element) {
    				this.getDatasetMeta(element._datasetIndex).controller[prefix + 'HoverStyle'](element);
    			}
    		}

    		if (mode === 'dataset') {
    			this.getDatasetMeta(elements[0]._datasetIndex).controller['_' + prefix + 'DatasetHoverStyle']();
    		}
    	},

    	/**
    	 * @private
    	 */
    	eventHandler: function(e) {
    		var me = this;
    		var tooltip = me.tooltip;

    		if (core_plugins.notify(me, 'beforeEvent', [e]) === false) {
    			return;
    		}

    		// Buffer any update calls so that renders do not occur
    		me._bufferedRender = true;
    		me._bufferedRequest = null;

    		var changed = me.handleEvent(e);
    		// for smooth tooltip animations issue #4989
    		// the tooltip should be the source of change
    		// Animation check workaround:
    		// tooltip._start will be null when tooltip isn't animating
    		if (tooltip) {
    			changed = tooltip._start
    				? tooltip.handleEvent(e)
    				: changed | tooltip.handleEvent(e);
    		}

    		core_plugins.notify(me, 'afterEvent', [e]);

    		var bufferedRequest = me._bufferedRequest;
    		if (bufferedRequest) {
    			// If we have an update that was triggered, we need to do a normal render
    			me.render(bufferedRequest);
    		} else if (changed && !me.animating) {
    			// If entering, leaving, or changing elements, animate the change via pivot
    			me.stop();

    			// We only need to render at this point. Updating will cause scales to be
    			// recomputed generating flicker & using more memory than necessary.
    			me.render({
    				duration: me.options.hover.animationDuration,
    				lazy: true
    			});
    		}

    		me._bufferedRender = false;
    		me._bufferedRequest = null;

    		return me;
    	},

    	/**
    	 * Handle an event
    	 * @private
    	 * @param {IEvent} event the event to handle
    	 * @return {boolean} true if the chart needs to re-render
    	 */
    	handleEvent: function(e) {
    		var me = this;
    		var options = me.options || {};
    		var hoverOptions = options.hover;
    		var changed = false;

    		me.lastActive = me.lastActive || [];

    		// Find Active Elements for hover and tooltips
    		if (e.type === 'mouseout') {
    			me.active = [];
    		} else {
    			me.active = me.getElementsAtEventForMode(e, hoverOptions.mode, hoverOptions);
    		}

    		// Invoke onHover hook
    		// Need to call with native event here to not break backwards compatibility
    		helpers$1.callback(options.onHover || options.hover.onHover, [e.native, me.active], me);

    		if (e.type === 'mouseup' || e.type === 'click') {
    			if (options.onClick) {
    				// Use e.native here for backwards compatibility
    				options.onClick.call(me, e.native, me.active);
    			}
    		}

    		// Remove styling for last active (even if it may still be active)
    		if (me.lastActive.length) {
    			me.updateHoverStyle(me.lastActive, hoverOptions.mode, false);
    		}

    		// Built in hover styling
    		if (me.active.length && hoverOptions.mode) {
    			me.updateHoverStyle(me.active, hoverOptions.mode, true);
    		}

    		changed = !helpers$1.arrayEquals(me.active, me.lastActive);

    		// Remember Last Actives
    		me.lastActive = me.active;

    		return changed;
    	}
    });

    /**
     * NOTE(SB) We actually don't use this container anymore but we need to keep it
     * for backward compatibility. Though, it can still be useful for plugins that
     * would need to work on multiple charts?!
     */
    Chart.instances = {};

    var core_controller = Chart;

    // DEPRECATIONS

    /**
     * Provided for backward compatibility, use Chart instead.
     * @class Chart.Controller
     * @deprecated since version 2.6
     * @todo remove at version 3
     * @private
     */
    Chart.Controller = Chart;

    /**
     * Provided for backward compatibility, not available anymore.
     * @namespace Chart
     * @deprecated since version 2.8
     * @todo remove at version 3
     * @private
     */
    Chart.types = {};

    /**
     * Provided for backward compatibility, not available anymore.
     * @namespace Chart.helpers.configMerge
     * @deprecated since version 2.8.0
     * @todo remove at version 3
     * @private
     */
    helpers$1.configMerge = mergeConfig;

    /**
     * Provided for backward compatibility, not available anymore.
     * @namespace Chart.helpers.scaleMerge
     * @deprecated since version 2.8.0
     * @todo remove at version 3
     * @private
     */
    helpers$1.scaleMerge = mergeScaleConfig;

    var core_helpers = function() {

    	// -- Basic js utility methods

    	helpers$1.where = function(collection, filterCallback) {
    		if (helpers$1.isArray(collection) && Array.prototype.filter) {
    			return collection.filter(filterCallback);
    		}
    		var filtered = [];

    		helpers$1.each(collection, function(item) {
    			if (filterCallback(item)) {
    				filtered.push(item);
    			}
    		});

    		return filtered;
    	};
    	helpers$1.findIndex = Array.prototype.findIndex ?
    		function(array, callback, scope) {
    			return array.findIndex(callback, scope);
    		} :
    		function(array, callback, scope) {
    			scope = scope === undefined ? array : scope;
    			for (var i = 0, ilen = array.length; i < ilen; ++i) {
    				if (callback.call(scope, array[i], i, array)) {
    					return i;
    				}
    			}
    			return -1;
    		};
    	helpers$1.findNextWhere = function(arrayToSearch, filterCallback, startIndex) {
    		// Default to start of the array
    		if (helpers$1.isNullOrUndef(startIndex)) {
    			startIndex = -1;
    		}
    		for (var i = startIndex + 1; i < arrayToSearch.length; i++) {
    			var currentItem = arrayToSearch[i];
    			if (filterCallback(currentItem)) {
    				return currentItem;
    			}
    		}
    	};
    	helpers$1.findPreviousWhere = function(arrayToSearch, filterCallback, startIndex) {
    		// Default to end of the array
    		if (helpers$1.isNullOrUndef(startIndex)) {
    			startIndex = arrayToSearch.length;
    		}
    		for (var i = startIndex - 1; i >= 0; i--) {
    			var currentItem = arrayToSearch[i];
    			if (filterCallback(currentItem)) {
    				return currentItem;
    			}
    		}
    	};

    	// -- Math methods
    	helpers$1.isNumber = function(n) {
    		return !isNaN(parseFloat(n)) && isFinite(n);
    	};
    	helpers$1.almostEquals = function(x, y, epsilon) {
    		return Math.abs(x - y) < epsilon;
    	};
    	helpers$1.almostWhole = function(x, epsilon) {
    		var rounded = Math.round(x);
    		return ((rounded - epsilon) <= x) && ((rounded + epsilon) >= x);
    	};
    	helpers$1.max = function(array) {
    		return array.reduce(function(max, value) {
    			if (!isNaN(value)) {
    				return Math.max(max, value);
    			}
    			return max;
    		}, Number.NEGATIVE_INFINITY);
    	};
    	helpers$1.min = function(array) {
    		return array.reduce(function(min, value) {
    			if (!isNaN(value)) {
    				return Math.min(min, value);
    			}
    			return min;
    		}, Number.POSITIVE_INFINITY);
    	};
    	helpers$1.sign = Math.sign ?
    		function(x) {
    			return Math.sign(x);
    		} :
    		function(x) {
    			x = +x; // convert to a number
    			if (x === 0 || isNaN(x)) {
    				return x;
    			}
    			return x > 0 ? 1 : -1;
    		};
    	helpers$1.toRadians = function(degrees) {
    		return degrees * (Math.PI / 180);
    	};
    	helpers$1.toDegrees = function(radians) {
    		return radians * (180 / Math.PI);
    	};

    	/**
    	 * Returns the number of decimal places
    	 * i.e. the number of digits after the decimal point, of the value of this Number.
    	 * @param {number} x - A number.
    	 * @returns {number} The number of decimal places.
    	 * @private
    	 */
    	helpers$1._decimalPlaces = function(x) {
    		if (!helpers$1.isFinite(x)) {
    			return;
    		}
    		var e = 1;
    		var p = 0;
    		while (Math.round(x * e) / e !== x) {
    			e *= 10;
    			p++;
    		}
    		return p;
    	};

    	// Gets the angle from vertical upright to the point about a centre.
    	helpers$1.getAngleFromPoint = function(centrePoint, anglePoint) {
    		var distanceFromXCenter = anglePoint.x - centrePoint.x;
    		var distanceFromYCenter = anglePoint.y - centrePoint.y;
    		var radialDistanceFromCenter = Math.sqrt(distanceFromXCenter * distanceFromXCenter + distanceFromYCenter * distanceFromYCenter);

    		var angle = Math.atan2(distanceFromYCenter, distanceFromXCenter);

    		if (angle < (-0.5 * Math.PI)) {
    			angle += 2.0 * Math.PI; // make sure the returned angle is in the range of (-PI/2, 3PI/2]
    		}

    		return {
    			angle: angle,
    			distance: radialDistanceFromCenter
    		};
    	};
    	helpers$1.distanceBetweenPoints = function(pt1, pt2) {
    		return Math.sqrt(Math.pow(pt2.x - pt1.x, 2) + Math.pow(pt2.y - pt1.y, 2));
    	};

    	/**
    	 * Provided for backward compatibility, not available anymore
    	 * @function Chart.helpers.aliasPixel
    	 * @deprecated since version 2.8.0
    	 * @todo remove at version 3
    	 */
    	helpers$1.aliasPixel = function(pixelWidth) {
    		return (pixelWidth % 2 === 0) ? 0 : 0.5;
    	};

    	/**
    	 * Returns the aligned pixel value to avoid anti-aliasing blur
    	 * @param {Chart} chart - The chart instance.
    	 * @param {number} pixel - A pixel value.
    	 * @param {number} width - The width of the element.
    	 * @returns {number} The aligned pixel value.
    	 * @private
    	 */
    	helpers$1._alignPixel = function(chart, pixel, width) {
    		var devicePixelRatio = chart.currentDevicePixelRatio;
    		var halfWidth = width / 2;
    		return Math.round((pixel - halfWidth) * devicePixelRatio) / devicePixelRatio + halfWidth;
    	};

    	helpers$1.splineCurve = function(firstPoint, middlePoint, afterPoint, t) {
    		// Props to Rob Spencer at scaled innovation for his post on splining between points
    		// http://scaledinnovation.com/analytics/splines/aboutSplines.html

    		// This function must also respect "skipped" points

    		var previous = firstPoint.skip ? middlePoint : firstPoint;
    		var current = middlePoint;
    		var next = afterPoint.skip ? middlePoint : afterPoint;

    		var d01 = Math.sqrt(Math.pow(current.x - previous.x, 2) + Math.pow(current.y - previous.y, 2));
    		var d12 = Math.sqrt(Math.pow(next.x - current.x, 2) + Math.pow(next.y - current.y, 2));

    		var s01 = d01 / (d01 + d12);
    		var s12 = d12 / (d01 + d12);

    		// If all points are the same, s01 & s02 will be inf
    		s01 = isNaN(s01) ? 0 : s01;
    		s12 = isNaN(s12) ? 0 : s12;

    		var fa = t * s01; // scaling factor for triangle Ta
    		var fb = t * s12;

    		return {
    			previous: {
    				x: current.x - fa * (next.x - previous.x),
    				y: current.y - fa * (next.y - previous.y)
    			},
    			next: {
    				x: current.x + fb * (next.x - previous.x),
    				y: current.y + fb * (next.y - previous.y)
    			}
    		};
    	};
    	helpers$1.EPSILON = Number.EPSILON || 1e-14;
    	helpers$1.splineCurveMonotone = function(points) {
    		// This function calculates Bézier control points in a similar way than |splineCurve|,
    		// but preserves monotonicity of the provided data and ensures no local extremums are added
    		// between the dataset discrete points due to the interpolation.
    		// See : https://en.wikipedia.org/wiki/Monotone_cubic_interpolation

    		var pointsWithTangents = (points || []).map(function(point) {
    			return {
    				model: point._model,
    				deltaK: 0,
    				mK: 0
    			};
    		});

    		// Calculate slopes (deltaK) and initialize tangents (mK)
    		var pointsLen = pointsWithTangents.length;
    		var i, pointBefore, pointCurrent, pointAfter;
    		for (i = 0; i < pointsLen; ++i) {
    			pointCurrent = pointsWithTangents[i];
    			if (pointCurrent.model.skip) {
    				continue;
    			}

    			pointBefore = i > 0 ? pointsWithTangents[i - 1] : null;
    			pointAfter = i < pointsLen - 1 ? pointsWithTangents[i + 1] : null;
    			if (pointAfter && !pointAfter.model.skip) {
    				var slopeDeltaX = (pointAfter.model.x - pointCurrent.model.x);

    				// In the case of two points that appear at the same x pixel, slopeDeltaX is 0
    				pointCurrent.deltaK = slopeDeltaX !== 0 ? (pointAfter.model.y - pointCurrent.model.y) / slopeDeltaX : 0;
    			}

    			if (!pointBefore || pointBefore.model.skip) {
    				pointCurrent.mK = pointCurrent.deltaK;
    			} else if (!pointAfter || pointAfter.model.skip) {
    				pointCurrent.mK = pointBefore.deltaK;
    			} else if (this.sign(pointBefore.deltaK) !== this.sign(pointCurrent.deltaK)) {
    				pointCurrent.mK = 0;
    			} else {
    				pointCurrent.mK = (pointBefore.deltaK + pointCurrent.deltaK) / 2;
    			}
    		}

    		// Adjust tangents to ensure monotonic properties
    		var alphaK, betaK, tauK, squaredMagnitude;
    		for (i = 0; i < pointsLen - 1; ++i) {
    			pointCurrent = pointsWithTangents[i];
    			pointAfter = pointsWithTangents[i + 1];
    			if (pointCurrent.model.skip || pointAfter.model.skip) {
    				continue;
    			}

    			if (helpers$1.almostEquals(pointCurrent.deltaK, 0, this.EPSILON)) {
    				pointCurrent.mK = pointAfter.mK = 0;
    				continue;
    			}

    			alphaK = pointCurrent.mK / pointCurrent.deltaK;
    			betaK = pointAfter.mK / pointCurrent.deltaK;
    			squaredMagnitude = Math.pow(alphaK, 2) + Math.pow(betaK, 2);
    			if (squaredMagnitude <= 9) {
    				continue;
    			}

    			tauK = 3 / Math.sqrt(squaredMagnitude);
    			pointCurrent.mK = alphaK * tauK * pointCurrent.deltaK;
    			pointAfter.mK = betaK * tauK * pointCurrent.deltaK;
    		}

    		// Compute control points
    		var deltaX;
    		for (i = 0; i < pointsLen; ++i) {
    			pointCurrent = pointsWithTangents[i];
    			if (pointCurrent.model.skip) {
    				continue;
    			}

    			pointBefore = i > 0 ? pointsWithTangents[i - 1] : null;
    			pointAfter = i < pointsLen - 1 ? pointsWithTangents[i + 1] : null;
    			if (pointBefore && !pointBefore.model.skip) {
    				deltaX = (pointCurrent.model.x - pointBefore.model.x) / 3;
    				pointCurrent.model.controlPointPreviousX = pointCurrent.model.x - deltaX;
    				pointCurrent.model.controlPointPreviousY = pointCurrent.model.y - deltaX * pointCurrent.mK;
    			}
    			if (pointAfter && !pointAfter.model.skip) {
    				deltaX = (pointAfter.model.x - pointCurrent.model.x) / 3;
    				pointCurrent.model.controlPointNextX = pointCurrent.model.x + deltaX;
    				pointCurrent.model.controlPointNextY = pointCurrent.model.y + deltaX * pointCurrent.mK;
    			}
    		}
    	};
    	helpers$1.nextItem = function(collection, index, loop) {
    		if (loop) {
    			return index >= collection.length - 1 ? collection[0] : collection[index + 1];
    		}
    		return index >= collection.length - 1 ? collection[collection.length - 1] : collection[index + 1];
    	};
    	helpers$1.previousItem = function(collection, index, loop) {
    		if (loop) {
    			return index <= 0 ? collection[collection.length - 1] : collection[index - 1];
    		}
    		return index <= 0 ? collection[0] : collection[index - 1];
    	};
    	// Implementation of the nice number algorithm used in determining where axis labels will go
    	helpers$1.niceNum = function(range, round) {
    		var exponent = Math.floor(helpers$1.log10(range));
    		var fraction = range / Math.pow(10, exponent);
    		var niceFraction;

    		if (round) {
    			if (fraction < 1.5) {
    				niceFraction = 1;
    			} else if (fraction < 3) {
    				niceFraction = 2;
    			} else if (fraction < 7) {
    				niceFraction = 5;
    			} else {
    				niceFraction = 10;
    			}
    		} else if (fraction <= 1.0) {
    			niceFraction = 1;
    		} else if (fraction <= 2) {
    			niceFraction = 2;
    		} else if (fraction <= 5) {
    			niceFraction = 5;
    		} else {
    			niceFraction = 10;
    		}

    		return niceFraction * Math.pow(10, exponent);
    	};
    	// Request animation polyfill - https://www.paulirish.com/2011/requestanimationframe-for-smart-animating/
    	helpers$1.requestAnimFrame = (function() {
    		if (typeof window === 'undefined') {
    			return function(callback) {
    				callback();
    			};
    		}
    		return window.requestAnimationFrame ||
    			window.webkitRequestAnimationFrame ||
    			window.mozRequestAnimationFrame ||
    			window.oRequestAnimationFrame ||
    			window.msRequestAnimationFrame ||
    			function(callback) {
    				return window.setTimeout(callback, 1000 / 60);
    			};
    	}());
    	// -- DOM methods
    	helpers$1.getRelativePosition = function(evt, chart) {
    		var mouseX, mouseY;
    		var e = evt.originalEvent || evt;
    		var canvas = evt.target || evt.srcElement;
    		var boundingRect = canvas.getBoundingClientRect();

    		var touches = e.touches;
    		if (touches && touches.length > 0) {
    			mouseX = touches[0].clientX;
    			mouseY = touches[0].clientY;

    		} else {
    			mouseX = e.clientX;
    			mouseY = e.clientY;
    		}

    		// Scale mouse coordinates into canvas coordinates
    		// by following the pattern laid out by 'jerryj' in the comments of
    		// https://www.html5canvastutorials.com/advanced/html5-canvas-mouse-coordinates/
    		var paddingLeft = parseFloat(helpers$1.getStyle(canvas, 'padding-left'));
    		var paddingTop = parseFloat(helpers$1.getStyle(canvas, 'padding-top'));
    		var paddingRight = parseFloat(helpers$1.getStyle(canvas, 'padding-right'));
    		var paddingBottom = parseFloat(helpers$1.getStyle(canvas, 'padding-bottom'));
    		var width = boundingRect.right - boundingRect.left - paddingLeft - paddingRight;
    		var height = boundingRect.bottom - boundingRect.top - paddingTop - paddingBottom;

    		// We divide by the current device pixel ratio, because the canvas is scaled up by that amount in each direction. However
    		// the backend model is in unscaled coordinates. Since we are going to deal with our model coordinates, we go back here
    		mouseX = Math.round((mouseX - boundingRect.left - paddingLeft) / (width) * canvas.width / chart.currentDevicePixelRatio);
    		mouseY = Math.round((mouseY - boundingRect.top - paddingTop) / (height) * canvas.height / chart.currentDevicePixelRatio);

    		return {
    			x: mouseX,
    			y: mouseY
    		};

    	};

    	// Private helper function to convert max-width/max-height values that may be percentages into a number
    	function parseMaxStyle(styleValue, node, parentProperty) {
    		var valueInPixels;
    		if (typeof styleValue === 'string') {
    			valueInPixels = parseInt(styleValue, 10);

    			if (styleValue.indexOf('%') !== -1) {
    				// percentage * size in dimension
    				valueInPixels = valueInPixels / 100 * node.parentNode[parentProperty];
    			}
    		} else {
    			valueInPixels = styleValue;
    		}

    		return valueInPixels;
    	}

    	/**
    	 * Returns if the given value contains an effective constraint.
    	 * @private
    	 */
    	function isConstrainedValue(value) {
    		return value !== undefined && value !== null && value !== 'none';
    	}

    	/**
    	 * Returns the max width or height of the given DOM node in a cross-browser compatible fashion
    	 * @param {HTMLElement} domNode - the node to check the constraint on
    	 * @param {string} maxStyle - the style that defines the maximum for the direction we are using ('max-width' / 'max-height')
    	 * @param {string} percentageProperty - property of parent to use when calculating width as a percentage
    	 * @see {@link https://www.nathanaeljones.com/blog/2013/reading-max-width-cross-browser}
    	 */
    	function getConstraintDimension(domNode, maxStyle, percentageProperty) {
    		var view = document.defaultView;
    		var parentNode = helpers$1._getParentNode(domNode);
    		var constrainedNode = view.getComputedStyle(domNode)[maxStyle];
    		var constrainedContainer = view.getComputedStyle(parentNode)[maxStyle];
    		var hasCNode = isConstrainedValue(constrainedNode);
    		var hasCContainer = isConstrainedValue(constrainedContainer);
    		var infinity = Number.POSITIVE_INFINITY;

    		if (hasCNode || hasCContainer) {
    			return Math.min(
    				hasCNode ? parseMaxStyle(constrainedNode, domNode, percentageProperty) : infinity,
    				hasCContainer ? parseMaxStyle(constrainedContainer, parentNode, percentageProperty) : infinity);
    		}

    		return 'none';
    	}
    	// returns Number or undefined if no constraint
    	helpers$1.getConstraintWidth = function(domNode) {
    		return getConstraintDimension(domNode, 'max-width', 'clientWidth');
    	};
    	// returns Number or undefined if no constraint
    	helpers$1.getConstraintHeight = function(domNode) {
    		return getConstraintDimension(domNode, 'max-height', 'clientHeight');
    	};
    	/**
    	 * @private
     	 */
    	helpers$1._calculatePadding = function(container, padding, parentDimension) {
    		padding = helpers$1.getStyle(container, padding);

    		return padding.indexOf('%') > -1 ? parentDimension * parseInt(padding, 10) / 100 : parseInt(padding, 10);
    	};
    	/**
    	 * @private
    	 */
    	helpers$1._getParentNode = function(domNode) {
    		var parent = domNode.parentNode;
    		if (parent && parent.toString() === '[object ShadowRoot]') {
    			parent = parent.host;
    		}
    		return parent;
    	};
    	helpers$1.getMaximumWidth = function(domNode) {
    		var container = helpers$1._getParentNode(domNode);
    		if (!container) {
    			return domNode.clientWidth;
    		}

    		var clientWidth = container.clientWidth;
    		var paddingLeft = helpers$1._calculatePadding(container, 'padding-left', clientWidth);
    		var paddingRight = helpers$1._calculatePadding(container, 'padding-right', clientWidth);

    		var w = clientWidth - paddingLeft - paddingRight;
    		var cw = helpers$1.getConstraintWidth(domNode);
    		return isNaN(cw) ? w : Math.min(w, cw);
    	};
    	helpers$1.getMaximumHeight = function(domNode) {
    		var container = helpers$1._getParentNode(domNode);
    		if (!container) {
    			return domNode.clientHeight;
    		}

    		var clientHeight = container.clientHeight;
    		var paddingTop = helpers$1._calculatePadding(container, 'padding-top', clientHeight);
    		var paddingBottom = helpers$1._calculatePadding(container, 'padding-bottom', clientHeight);

    		var h = clientHeight - paddingTop - paddingBottom;
    		var ch = helpers$1.getConstraintHeight(domNode);
    		return isNaN(ch) ? h : Math.min(h, ch);
    	};
    	helpers$1.getStyle = function(el, property) {
    		return el.currentStyle ?
    			el.currentStyle[property] :
    			document.defaultView.getComputedStyle(el, null).getPropertyValue(property);
    	};
    	helpers$1.retinaScale = function(chart, forceRatio) {
    		var pixelRatio = chart.currentDevicePixelRatio = forceRatio || (typeof window !== 'undefined' && window.devicePixelRatio) || 1;
    		if (pixelRatio === 1) {
    			return;
    		}

    		var canvas = chart.canvas;
    		var height = chart.height;
    		var width = chart.width;

    		canvas.height = height * pixelRatio;
    		canvas.width = width * pixelRatio;
    		chart.ctx.scale(pixelRatio, pixelRatio);

    		// If no style has been set on the canvas, the render size is used as display size,
    		// making the chart visually bigger, so let's enforce it to the "correct" values.
    		// See https://github.com/chartjs/Chart.js/issues/3575
    		if (!canvas.style.height && !canvas.style.width) {
    			canvas.style.height = height + 'px';
    			canvas.style.width = width + 'px';
    		}
    	};
    	// -- Canvas methods
    	helpers$1.fontString = function(pixelSize, fontStyle, fontFamily) {
    		return fontStyle + ' ' + pixelSize + 'px ' + fontFamily;
    	};
    	helpers$1.longestText = function(ctx, font, arrayOfThings, cache) {
    		cache = cache || {};
    		var data = cache.data = cache.data || {};
    		var gc = cache.garbageCollect = cache.garbageCollect || [];

    		if (cache.font !== font) {
    			data = cache.data = {};
    			gc = cache.garbageCollect = [];
    			cache.font = font;
    		}

    		ctx.font = font;
    		var longest = 0;
    		var ilen = arrayOfThings.length;
    		var i, j, jlen, thing, nestedThing;
    		for (i = 0; i < ilen; i++) {
    			thing = arrayOfThings[i];

    			// Undefined strings and arrays should not be measured
    			if (thing !== undefined && thing !== null && helpers$1.isArray(thing) !== true) {
    				longest = helpers$1.measureText(ctx, data, gc, longest, thing);
    			} else if (helpers$1.isArray(thing)) {
    				// if it is an array lets measure each element
    				// to do maybe simplify this function a bit so we can do this more recursively?
    				for (j = 0, jlen = thing.length; j < jlen; j++) {
    					nestedThing = thing[j];
    					// Undefined strings and arrays should not be measured
    					if (nestedThing !== undefined && nestedThing !== null && !helpers$1.isArray(nestedThing)) {
    						longest = helpers$1.measureText(ctx, data, gc, longest, nestedThing);
    					}
    				}
    			}
    		}

    		var gcLen = gc.length / 2;
    		if (gcLen > arrayOfThings.length) {
    			for (i = 0; i < gcLen; i++) {
    				delete data[gc[i]];
    			}
    			gc.splice(0, gcLen);
    		}
    		return longest;
    	};
    	helpers$1.measureText = function(ctx, data, gc, longest, string) {
    		var textWidth = data[string];
    		if (!textWidth) {
    			textWidth = data[string] = ctx.measureText(string).width;
    			gc.push(string);
    		}
    		if (textWidth > longest) {
    			longest = textWidth;
    		}
    		return longest;
    	};

    	/**
    	 * @deprecated
    	 */
    	helpers$1.numberOfLabelLines = function(arrayOfThings) {
    		var numberOfLines = 1;
    		helpers$1.each(arrayOfThings, function(thing) {
    			if (helpers$1.isArray(thing)) {
    				if (thing.length > numberOfLines) {
    					numberOfLines = thing.length;
    				}
    			}
    		});
    		return numberOfLines;
    	};

    	helpers$1.color = !chartjsColor ?
    		function(value) {
    			console.error('Color.js not found!');
    			return value;
    		} :
    		function(value) {
    			/* global CanvasGradient */
    			if (value instanceof CanvasGradient) {
    				value = core_defaults.global.defaultColor;
    			}

    			return chartjsColor(value);
    		};

    	helpers$1.getHoverColor = function(colorValue) {
    		/* global CanvasPattern */
    		return (colorValue instanceof CanvasPattern || colorValue instanceof CanvasGradient) ?
    			colorValue :
    			helpers$1.color(colorValue).saturate(0.5).darken(0.1).rgbString();
    	};
    };

    function abstract() {
    	throw new Error(
    		'This method is not implemented: either no adapter can ' +
    		'be found or an incomplete integration was provided.'
    	);
    }

    /**
     * Date adapter (current used by the time scale)
     * @namespace Chart._adapters._date
     * @memberof Chart._adapters
     * @private
     */

    /**
     * Currently supported unit string values.
     * @typedef {('millisecond'|'second'|'minute'|'hour'|'day'|'week'|'month'|'quarter'|'year')}
     * @memberof Chart._adapters._date
     * @name Unit
     */

    /**
     * @class
     */
    function DateAdapter(options) {
    	this.options = options || {};
    }

    helpers$1.extend(DateAdapter.prototype, /** @lends DateAdapter */ {
    	/**
    	 * Returns a map of time formats for the supported formatting units defined
    	 * in Unit as well as 'datetime' representing a detailed date/time string.
    	 * @returns {{string: string}}
    	 */
    	formats: abstract,

    	/**
    	 * Parses the given `value` and return the associated timestamp.
    	 * @param {any} value - the value to parse (usually comes from the data)
    	 * @param {string} [format] - the expected data format
    	 * @returns {(number|null)}
    	 * @function
    	 */
    	parse: abstract,

    	/**
    	 * Returns the formatted date in the specified `format` for a given `timestamp`.
    	 * @param {number} timestamp - the timestamp to format
    	 * @param {string} format - the date/time token
    	 * @return {string}
    	 * @function
    	 */
    	format: abstract,

    	/**
    	 * Adds the specified `amount` of `unit` to the given `timestamp`.
    	 * @param {number} timestamp - the input timestamp
    	 * @param {number} amount - the amount to add
    	 * @param {Unit} unit - the unit as string
    	 * @return {number}
    	 * @function
    	 */
    	add: abstract,

    	/**
    	 * Returns the number of `unit` between the given timestamps.
    	 * @param {number} max - the input timestamp (reference)
    	 * @param {number} min - the timestamp to substract
    	 * @param {Unit} unit - the unit as string
    	 * @return {number}
    	 * @function
    	 */
    	diff: abstract,

    	/**
    	 * Returns start of `unit` for the given `timestamp`.
    	 * @param {number} timestamp - the input timestamp
    	 * @param {Unit} unit - the unit as string
    	 * @param {number} [weekday] - the ISO day of the week with 1 being Monday
    	 * and 7 being Sunday (only needed if param *unit* is `isoWeek`).
    	 * @function
    	 */
    	startOf: abstract,

    	/**
    	 * Returns end of `unit` for the given `timestamp`.
    	 * @param {number} timestamp - the input timestamp
    	 * @param {Unit} unit - the unit as string
    	 * @function
    	 */
    	endOf: abstract,

    	// DEPRECATIONS

    	/**
    	 * Provided for backward compatibility for scale.getValueForPixel(),
    	 * this method should be overridden only by the moment adapter.
    	 * @deprecated since version 2.8.0
    	 * @todo remove at version 3
    	 * @private
    	 */
    	_create: function(value) {
    		return value;
    	}
    });

    DateAdapter.override = function(members) {
    	helpers$1.extend(DateAdapter.prototype, members);
    };

    var _date = DateAdapter;

    var core_adapters = {
    	_date: _date
    };

    /**
     * Namespace to hold static tick generation functions
     * @namespace Chart.Ticks
     */
    var core_ticks = {
    	/**
    	 * Namespace to hold formatters for different types of ticks
    	 * @namespace Chart.Ticks.formatters
    	 */
    	formatters: {
    		/**
    		 * Formatter for value labels
    		 * @method Chart.Ticks.formatters.values
    		 * @param value the value to display
    		 * @return {string|string[]} the label to display
    		 */
    		values: function(value) {
    			return helpers$1.isArray(value) ? value : '' + value;
    		},

    		/**
    		 * Formatter for linear numeric ticks
    		 * @method Chart.Ticks.formatters.linear
    		 * @param tickValue {number} the value to be formatted
    		 * @param index {number} the position of the tickValue parameter in the ticks array
    		 * @param ticks {number[]} the list of ticks being converted
    		 * @return {string} string representation of the tickValue parameter
    		 */
    		linear: function(tickValue, index, ticks) {
    			// If we have lots of ticks, don't use the ones
    			var delta = ticks.length > 3 ? ticks[2] - ticks[1] : ticks[1] - ticks[0];

    			// If we have a number like 2.5 as the delta, figure out how many decimal places we need
    			if (Math.abs(delta) > 1) {
    				if (tickValue !== Math.floor(tickValue)) {
    					// not an integer
    					delta = tickValue - Math.floor(tickValue);
    				}
    			}

    			var logDelta = helpers$1.log10(Math.abs(delta));
    			var tickString = '';

    			if (tickValue !== 0) {
    				var maxTick = Math.max(Math.abs(ticks[0]), Math.abs(ticks[ticks.length - 1]));
    				if (maxTick < 1e-4) { // all ticks are small numbers; use scientific notation
    					var logTick = helpers$1.log10(Math.abs(tickValue));
    					var numExponential = Math.floor(logTick) - Math.floor(logDelta);
    					numExponential = Math.max(Math.min(numExponential, 20), 0);
    					tickString = tickValue.toExponential(numExponential);
    				} else {
    					var numDecimal = -1 * Math.floor(logDelta);
    					numDecimal = Math.max(Math.min(numDecimal, 20), 0); // toFixed has a max of 20 decimal places
    					tickString = tickValue.toFixed(numDecimal);
    				}
    			} else {
    				tickString = '0'; // never show decimal places for 0
    			}

    			return tickString;
    		},

    		logarithmic: function(tickValue, index, ticks) {
    			var remain = tickValue / (Math.pow(10, Math.floor(helpers$1.log10(tickValue))));

    			if (tickValue === 0) {
    				return '0';
    			} else if (remain === 1 || remain === 2 || remain === 5 || index === 0 || index === ticks.length - 1) {
    				return tickValue.toExponential();
    			}
    			return '';
    		}
    	}
    };

    var isArray = helpers$1.isArray;
    var isNullOrUndef = helpers$1.isNullOrUndef;
    var valueOrDefault$a = helpers$1.valueOrDefault;
    var valueAtIndexOrDefault = helpers$1.valueAtIndexOrDefault;

    core_defaults._set('scale', {
    	display: true,
    	position: 'left',
    	offset: false,

    	// grid line settings
    	gridLines: {
    		display: true,
    		color: 'rgba(0,0,0,0.1)',
    		lineWidth: 1,
    		drawBorder: true,
    		drawOnChartArea: true,
    		drawTicks: true,
    		tickMarkLength: 10,
    		zeroLineWidth: 1,
    		zeroLineColor: 'rgba(0,0,0,0.25)',
    		zeroLineBorderDash: [],
    		zeroLineBorderDashOffset: 0.0,
    		offsetGridLines: false,
    		borderDash: [],
    		borderDashOffset: 0.0
    	},

    	// scale label
    	scaleLabel: {
    		// display property
    		display: false,

    		// actual label
    		labelString: '',

    		// top/bottom padding
    		padding: {
    			top: 4,
    			bottom: 4
    		}
    	},

    	// label settings
    	ticks: {
    		beginAtZero: false,
    		minRotation: 0,
    		maxRotation: 50,
    		mirror: false,
    		padding: 0,
    		reverse: false,
    		display: true,
    		autoSkip: true,
    		autoSkipPadding: 0,
    		labelOffset: 0,
    		// We pass through arrays to be rendered as multiline labels, we convert Others to strings here.
    		callback: core_ticks.formatters.values,
    		minor: {},
    		major: {}
    	}
    });

    /** Returns a new array containing numItems from arr */
    function sample(arr, numItems) {
    	var result = [];
    	var increment = arr.length / numItems;
    	var i = 0;
    	var len = arr.length;

    	for (; i < len; i += increment) {
    		result.push(arr[Math.floor(i)]);
    	}
    	return result;
    }

    function getPixelForGridLine(scale, index, offsetGridLines) {
    	var length = scale.getTicks().length;
    	var validIndex = Math.min(index, length - 1);
    	var lineValue = scale.getPixelForTick(validIndex);
    	var start = scale._startPixel;
    	var end = scale._endPixel;
    	var epsilon = 1e-6; // 1e-6 is margin in pixels for accumulated error.
    	var offset;

    	if (offsetGridLines) {
    		if (length === 1) {
    			offset = Math.max(lineValue - start, end - lineValue);
    		} else if (index === 0) {
    			offset = (scale.getPixelForTick(1) - lineValue) / 2;
    		} else {
    			offset = (lineValue - scale.getPixelForTick(validIndex - 1)) / 2;
    		}
    		lineValue += validIndex < index ? offset : -offset;

    		// Return undefined if the pixel is out of the range
    		if (lineValue < start - epsilon || lineValue > end + epsilon) {
    			return;
    		}
    	}
    	return lineValue;
    }

    function garbageCollect(caches, length) {
    	helpers$1.each(caches, function(cache) {
    		var gc = cache.gc;
    		var gcLen = gc.length / 2;
    		var i;
    		if (gcLen > length) {
    			for (i = 0; i < gcLen; ++i) {
    				delete cache.data[gc[i]];
    			}
    			gc.splice(0, gcLen);
    		}
    	});
    }

    /**
     * Returns {width, height, offset} objects for the first, last, widest, highest tick
     * labels where offset indicates the anchor point offset from the top in pixels.
     */
    function computeLabelSizes(ctx, tickFonts, ticks, caches) {
    	var length = ticks.length;
    	var widths = [];
    	var heights = [];
    	var offsets = [];
    	var widestLabelSize = 0;
    	var highestLabelSize = 0;
    	var i, j, jlen, label, tickFont, fontString, cache, lineHeight, width, height, nestedLabel, widest, highest;

    	for (i = 0; i < length; ++i) {
    		label = ticks[i].label;
    		tickFont = ticks[i].major ? tickFonts.major : tickFonts.minor;
    		ctx.font = fontString = tickFont.string;
    		cache = caches[fontString] = caches[fontString] || {data: {}, gc: []};
    		lineHeight = tickFont.lineHeight;
    		width = height = 0;
    		// Undefined labels and arrays should not be measured
    		if (!isNullOrUndef(label) && !isArray(label)) {
    			width = helpers$1.measureText(ctx, cache.data, cache.gc, width, label);
    			height = lineHeight;
    		} else if (isArray(label)) {
    			// if it is an array let's measure each element
    			for (j = 0, jlen = label.length; j < jlen; ++j) {
    				nestedLabel = label[j];
    				// Undefined labels and arrays should not be measured
    				if (!isNullOrUndef(nestedLabel) && !isArray(nestedLabel)) {
    					width = helpers$1.measureText(ctx, cache.data, cache.gc, width, nestedLabel);
    					height += lineHeight;
    				}
    			}
    		}
    		widths.push(width);
    		heights.push(height);
    		offsets.push(lineHeight / 2);
    		widestLabelSize = Math.max(width, widestLabelSize);
    		highestLabelSize = Math.max(height, highestLabelSize);
    	}
    	garbageCollect(caches, length);

    	widest = widths.indexOf(widestLabelSize);
    	highest = heights.indexOf(highestLabelSize);

    	function valueAt(idx) {
    		return {
    			width: widths[idx] || 0,
    			height: heights[idx] || 0,
    			offset: offsets[idx] || 0
    		};
    	}

    	return {
    		first: valueAt(0),
    		last: valueAt(length - 1),
    		widest: valueAt(widest),
    		highest: valueAt(highest)
    	};
    }

    function getTickMarkLength(options) {
    	return options.drawTicks ? options.tickMarkLength : 0;
    }

    function getScaleLabelHeight(options) {
    	var font, padding;

    	if (!options.display) {
    		return 0;
    	}

    	font = helpers$1.options._parseFont(options);
    	padding = helpers$1.options.toPadding(options.padding);

    	return font.lineHeight + padding.height;
    }

    function parseFontOptions(options, nestedOpts) {
    	return helpers$1.extend(helpers$1.options._parseFont({
    		fontFamily: valueOrDefault$a(nestedOpts.fontFamily, options.fontFamily),
    		fontSize: valueOrDefault$a(nestedOpts.fontSize, options.fontSize),
    		fontStyle: valueOrDefault$a(nestedOpts.fontStyle, options.fontStyle),
    		lineHeight: valueOrDefault$a(nestedOpts.lineHeight, options.lineHeight)
    	}), {
    		color: helpers$1.options.resolve([nestedOpts.fontColor, options.fontColor, core_defaults.global.defaultFontColor])
    	});
    }

    function parseTickFontOptions(options) {
    	var minor = parseFontOptions(options, options.minor);
    	var major = options.major.enabled ? parseFontOptions(options, options.major) : minor;

    	return {minor: minor, major: major};
    }

    function nonSkipped(ticksToFilter) {
    	var filtered = [];
    	var item, index, len;
    	for (index = 0, len = ticksToFilter.length; index < len; ++index) {
    		item = ticksToFilter[index];
    		if (typeof item._index !== 'undefined') {
    			filtered.push(item);
    		}
    	}
    	return filtered;
    }

    function getEvenSpacing(arr) {
    	var len = arr.length;
    	var i, diff;

    	if (len < 2) {
    		return false;
    	}

    	for (diff = arr[0], i = 1; i < len; ++i) {
    		if (arr[i] - arr[i - 1] !== diff) {
    			return false;
    		}
    	}
    	return diff;
    }

    function calculateSpacing(majorIndices, ticks, axisLength, ticksLimit) {
    	var evenMajorSpacing = getEvenSpacing(majorIndices);
    	var spacing = (ticks.length - 1) / ticksLimit;
    	var factors, factor, i, ilen;

    	// If the major ticks are evenly spaced apart, place the minor ticks
    	// so that they divide the major ticks into even chunks
    	if (!evenMajorSpacing) {
    		return Math.max(spacing, 1);
    	}

    	factors = helpers$1.math._factorize(evenMajorSpacing);
    	for (i = 0, ilen = factors.length - 1; i < ilen; i++) {
    		factor = factors[i];
    		if (factor > spacing) {
    			return factor;
    		}
    	}
    	return Math.max(spacing, 1);
    }

    function getMajorIndices(ticks) {
    	var result = [];
    	var i, ilen;
    	for (i = 0, ilen = ticks.length; i < ilen; i++) {
    		if (ticks[i].major) {
    			result.push(i);
    		}
    	}
    	return result;
    }

    function skipMajors(ticks, majorIndices, spacing) {
    	var count = 0;
    	var next = majorIndices[0];
    	var i, tick;

    	spacing = Math.ceil(spacing);
    	for (i = 0; i < ticks.length; i++) {
    		tick = ticks[i];
    		if (i === next) {
    			tick._index = i;
    			count++;
    			next = majorIndices[count * spacing];
    		} else {
    			delete tick.label;
    		}
    	}
    }

    function skip(ticks, spacing, majorStart, majorEnd) {
    	var start = valueOrDefault$a(majorStart, 0);
    	var end = Math.min(valueOrDefault$a(majorEnd, ticks.length), ticks.length);
    	var count = 0;
    	var length, i, tick, next;

    	spacing = Math.ceil(spacing);
    	if (majorEnd) {
    		length = majorEnd - majorStart;
    		spacing = length / Math.floor(length / spacing);
    	}

    	next = start;

    	while (next < 0) {
    		count++;
    		next = Math.round(start + count * spacing);
    	}

    	for (i = Math.max(start, 0); i < end; i++) {
    		tick = ticks[i];
    		if (i === next) {
    			tick._index = i;
    			count++;
    			next = Math.round(start + count * spacing);
    		} else {
    			delete tick.label;
    		}
    	}
    }

    var Scale = core_element.extend({

    	zeroLineIndex: 0,

    	/**
    	 * Get the padding needed for the scale
    	 * @method getPadding
    	 * @private
    	 * @returns {Padding} the necessary padding
    	 */
    	getPadding: function() {
    		var me = this;
    		return {
    			left: me.paddingLeft || 0,
    			top: me.paddingTop || 0,
    			right: me.paddingRight || 0,
    			bottom: me.paddingBottom || 0
    		};
    	},

    	/**
    	 * Returns the scale tick objects ({label, major})
    	 * @since 2.7
    	 */
    	getTicks: function() {
    		return this._ticks;
    	},

    	/**
    	* @private
    	*/
    	_getLabels: function() {
    		var data = this.chart.data;
    		return this.options.labels || (this.isHorizontal() ? data.xLabels : data.yLabels) || data.labels || [];
    	},

    	// These methods are ordered by lifecyle. Utilities then follow.
    	// Any function defined here is inherited by all scale types.
    	// Any function can be extended by the scale type

    	/**
    	 * Provided for backward compatibility, not available anymore
    	 * @function Chart.Scale.mergeTicksOptions
    	 * @deprecated since version 2.8.0
    	 * @todo remove at version 3
    	 */
    	mergeTicksOptions: function() {
    		// noop
    	},

    	beforeUpdate: function() {
    		helpers$1.callback(this.options.beforeUpdate, [this]);
    	},

    	/**
    	 * @param {number} maxWidth - the max width in pixels
    	 * @param {number} maxHeight - the max height in pixels
    	 * @param {object} margins - the space between the edge of the other scales and edge of the chart
    	 *   This space comes from two sources:
    	 *     - padding - space that's required to show the labels at the edges of the scale
    	 *     - thickness of scales or legends in another orientation
    	 */
    	update: function(maxWidth, maxHeight, margins) {
    		var me = this;
    		var tickOpts = me.options.ticks;
    		var sampleSize = tickOpts.sampleSize;
    		var i, ilen, labels, ticks, samplingEnabled;

    		// Update Lifecycle - Probably don't want to ever extend or overwrite this function ;)
    		me.beforeUpdate();

    		// Absorb the master measurements
    		me.maxWidth = maxWidth;
    		me.maxHeight = maxHeight;
    		me.margins = helpers$1.extend({
    			left: 0,
    			right: 0,
    			top: 0,
    			bottom: 0
    		}, margins);

    		me._ticks = null;
    		me.ticks = null;
    		me._labelSizes = null;
    		me._maxLabelLines = 0;
    		me.longestLabelWidth = 0;
    		me.longestTextCache = me.longestTextCache || {};
    		me._gridLineItems = null;
    		me._labelItems = null;

    		// Dimensions
    		me.beforeSetDimensions();
    		me.setDimensions();
    		me.afterSetDimensions();

    		// Data min/max
    		me.beforeDataLimits();
    		me.determineDataLimits();
    		me.afterDataLimits();

    		// Ticks - `this.ticks` is now DEPRECATED!
    		// Internal ticks are now stored as objects in the PRIVATE `this._ticks` member
    		// and must not be accessed directly from outside this class. `this.ticks` being
    		// around for long time and not marked as private, we can't change its structure
    		// without unexpected breaking changes. If you need to access the scale ticks,
    		// use scale.getTicks() instead.

    		me.beforeBuildTicks();

    		// New implementations should return an array of objects but for BACKWARD COMPAT,
    		// we still support no return (`this.ticks` internally set by calling this method).
    		ticks = me.buildTicks() || [];

    		// Allow modification of ticks in callback.
    		ticks = me.afterBuildTicks(ticks) || ticks;

    		// Ensure ticks contains ticks in new tick format
    		if ((!ticks || !ticks.length) && me.ticks) {
    			ticks = [];
    			for (i = 0, ilen = me.ticks.length; i < ilen; ++i) {
    				ticks.push({
    					value: me.ticks[i],
    					major: false
    				});
    			}
    		}

    		me._ticks = ticks;

    		// Compute tick rotation and fit using a sampled subset of labels
    		// We generally don't need to compute the size of every single label for determining scale size
    		samplingEnabled = sampleSize < ticks.length;
    		labels = me._convertTicksToLabels(samplingEnabled ? sample(ticks, sampleSize) : ticks);

    		// _configure is called twice, once here, once from core.controller.updateLayout.
    		// Here we haven't been positioned yet, but dimensions are correct.
    		// Variables set in _configure are needed for calculateTickRotation, and
    		// it's ok that coordinates are not correct there, only dimensions matter.
    		me._configure();

    		// Tick Rotation
    		me.beforeCalculateTickRotation();
    		me.calculateTickRotation();
    		me.afterCalculateTickRotation();

    		me.beforeFit();
    		me.fit();
    		me.afterFit();

    		// Auto-skip
    		me._ticksToDraw = tickOpts.display && (tickOpts.autoSkip || tickOpts.source === 'auto') ? me._autoSkip(ticks) : ticks;

    		if (samplingEnabled) {
    			// Generate labels using all non-skipped ticks
    			labels = me._convertTicksToLabels(me._ticksToDraw);
    		}

    		me.ticks = labels;   // BACKWARD COMPATIBILITY

    		// IMPORTANT: after this point, we consider that `this.ticks` will NEVER change!

    		me.afterUpdate();

    		// TODO(v3): remove minSize as a public property and return value from all layout boxes. It is unused
    		// make maxWidth and maxHeight private
    		return me.minSize;
    	},

    	/**
    	 * @private
    	 */
    	_configure: function() {
    		var me = this;
    		var reversePixels = me.options.ticks.reverse;
    		var startPixel, endPixel;

    		if (me.isHorizontal()) {
    			startPixel = me.left;
    			endPixel = me.right;
    		} else {
    			startPixel = me.top;
    			endPixel = me.bottom;
    			// by default vertical scales are from bottom to top, so pixels are reversed
    			reversePixels = !reversePixels;
    		}
    		me._startPixel = startPixel;
    		me._endPixel = endPixel;
    		me._reversePixels = reversePixels;
    		me._length = endPixel - startPixel;
    	},

    	afterUpdate: function() {
    		helpers$1.callback(this.options.afterUpdate, [this]);
    	},

    	//

    	beforeSetDimensions: function() {
    		helpers$1.callback(this.options.beforeSetDimensions, [this]);
    	},
    	setDimensions: function() {
    		var me = this;
    		// Set the unconstrained dimension before label rotation
    		if (me.isHorizontal()) {
    			// Reset position before calculating rotation
    			me.width = me.maxWidth;
    			me.left = 0;
    			me.right = me.width;
    		} else {
    			me.height = me.maxHeight;

    			// Reset position before calculating rotation
    			me.top = 0;
    			me.bottom = me.height;
    		}

    		// Reset padding
    		me.paddingLeft = 0;
    		me.paddingTop = 0;
    		me.paddingRight = 0;
    		me.paddingBottom = 0;
    	},
    	afterSetDimensions: function() {
    		helpers$1.callback(this.options.afterSetDimensions, [this]);
    	},

    	// Data limits
    	beforeDataLimits: function() {
    		helpers$1.callback(this.options.beforeDataLimits, [this]);
    	},
    	determineDataLimits: helpers$1.noop,
    	afterDataLimits: function() {
    		helpers$1.callback(this.options.afterDataLimits, [this]);
    	},

    	//
    	beforeBuildTicks: function() {
    		helpers$1.callback(this.options.beforeBuildTicks, [this]);
    	},
    	buildTicks: helpers$1.noop,
    	afterBuildTicks: function(ticks) {
    		var me = this;
    		// ticks is empty for old axis implementations here
    		if (isArray(ticks) && ticks.length) {
    			return helpers$1.callback(me.options.afterBuildTicks, [me, ticks]);
    		}
    		// Support old implementations (that modified `this.ticks` directly in buildTicks)
    		me.ticks = helpers$1.callback(me.options.afterBuildTicks, [me, me.ticks]) || me.ticks;
    		return ticks;
    	},

    	beforeTickToLabelConversion: function() {
    		helpers$1.callback(this.options.beforeTickToLabelConversion, [this]);
    	},
    	convertTicksToLabels: function() {
    		var me = this;
    		// Convert ticks to strings
    		var tickOpts = me.options.ticks;
    		me.ticks = me.ticks.map(tickOpts.userCallback || tickOpts.callback, this);
    	},
    	afterTickToLabelConversion: function() {
    		helpers$1.callback(this.options.afterTickToLabelConversion, [this]);
    	},

    	//

    	beforeCalculateTickRotation: function() {
    		helpers$1.callback(this.options.beforeCalculateTickRotation, [this]);
    	},
    	calculateTickRotation: function() {
    		var me = this;
    		var options = me.options;
    		var tickOpts = options.ticks;
    		var numTicks = me.getTicks().length;
    		var minRotation = tickOpts.minRotation || 0;
    		var maxRotation = tickOpts.maxRotation;
    		var labelRotation = minRotation;
    		var labelSizes, maxLabelWidth, maxLabelHeight, maxWidth, tickWidth, maxHeight, maxLabelDiagonal;

    		if (!me._isVisible() || !tickOpts.display || minRotation >= maxRotation || numTicks <= 1 || !me.isHorizontal()) {
    			me.labelRotation = minRotation;
    			return;
    		}

    		labelSizes = me._getLabelSizes();
    		maxLabelWidth = labelSizes.widest.width;
    		maxLabelHeight = labelSizes.highest.height - labelSizes.highest.offset;

    		// Estimate the width of each grid based on the canvas width, the maximum
    		// label width and the number of tick intervals
    		maxWidth = Math.min(me.maxWidth, me.chart.width - maxLabelWidth);
    		tickWidth = options.offset ? me.maxWidth / numTicks : maxWidth / (numTicks - 1);

    		// Allow 3 pixels x2 padding either side for label readability
    		if (maxLabelWidth + 6 > tickWidth) {
    			tickWidth = maxWidth / (numTicks - (options.offset ? 0.5 : 1));
    			maxHeight = me.maxHeight - getTickMarkLength(options.gridLines)
    				- tickOpts.padding - getScaleLabelHeight(options.scaleLabel);
    			maxLabelDiagonal = Math.sqrt(maxLabelWidth * maxLabelWidth + maxLabelHeight * maxLabelHeight);
    			labelRotation = helpers$1.toDegrees(Math.min(
    				Math.asin(Math.min((labelSizes.highest.height + 6) / tickWidth, 1)),
    				Math.asin(Math.min(maxHeight / maxLabelDiagonal, 1)) - Math.asin(maxLabelHeight / maxLabelDiagonal)
    			));
    			labelRotation = Math.max(minRotation, Math.min(maxRotation, labelRotation));
    		}

    		me.labelRotation = labelRotation;
    	},
    	afterCalculateTickRotation: function() {
    		helpers$1.callback(this.options.afterCalculateTickRotation, [this]);
    	},

    	//

    	beforeFit: function() {
    		helpers$1.callback(this.options.beforeFit, [this]);
    	},
    	fit: function() {
    		var me = this;
    		// Reset
    		var minSize = me.minSize = {
    			width: 0,
    			height: 0
    		};

    		var chart = me.chart;
    		var opts = me.options;
    		var tickOpts = opts.ticks;
    		var scaleLabelOpts = opts.scaleLabel;
    		var gridLineOpts = opts.gridLines;
    		var display = me._isVisible();
    		var isBottom = opts.position === 'bottom';
    		var isHorizontal = me.isHorizontal();

    		// Width
    		if (isHorizontal) {
    			minSize.width = me.maxWidth;
    		} else if (display) {
    			minSize.width = getTickMarkLength(gridLineOpts) + getScaleLabelHeight(scaleLabelOpts);
    		}

    		// height
    		if (!isHorizontal) {
    			minSize.height = me.maxHeight; // fill all the height
    		} else if (display) {
    			minSize.height = getTickMarkLength(gridLineOpts) + getScaleLabelHeight(scaleLabelOpts);
    		}

    		// Don't bother fitting the ticks if we are not showing the labels
    		if (tickOpts.display && display) {
    			var tickFonts = parseTickFontOptions(tickOpts);
    			var labelSizes = me._getLabelSizes();
    			var firstLabelSize = labelSizes.first;
    			var lastLabelSize = labelSizes.last;
    			var widestLabelSize = labelSizes.widest;
    			var highestLabelSize = labelSizes.highest;
    			var lineSpace = tickFonts.minor.lineHeight * 0.4;
    			var tickPadding = tickOpts.padding;

    			if (isHorizontal) {
    				// A horizontal axis is more constrained by the height.
    				var isRotated = me.labelRotation !== 0;
    				var angleRadians = helpers$1.toRadians(me.labelRotation);
    				var cosRotation = Math.cos(angleRadians);
    				var sinRotation = Math.sin(angleRadians);

    				var labelHeight = sinRotation * widestLabelSize.width
    					+ cosRotation * (highestLabelSize.height - (isRotated ? highestLabelSize.offset : 0))
    					+ (isRotated ? 0 : lineSpace); // padding

    				minSize.height = Math.min(me.maxHeight, minSize.height + labelHeight + tickPadding);

    				var offsetLeft = me.getPixelForTick(0) - me.left;
    				var offsetRight = me.right - me.getPixelForTick(me.getTicks().length - 1);
    				var paddingLeft, paddingRight;

    				// Ensure that our ticks are always inside the canvas. When rotated, ticks are right aligned
    				// which means that the right padding is dominated by the font height
    				if (isRotated) {
    					paddingLeft = isBottom ?
    						cosRotation * firstLabelSize.width + sinRotation * firstLabelSize.offset :
    						sinRotation * (firstLabelSize.height - firstLabelSize.offset);
    					paddingRight = isBottom ?
    						sinRotation * (lastLabelSize.height - lastLabelSize.offset) :
    						cosRotation * lastLabelSize.width + sinRotation * lastLabelSize.offset;
    				} else {
    					paddingLeft = firstLabelSize.width / 2;
    					paddingRight = lastLabelSize.width / 2;
    				}

    				// Adjust padding taking into account changes in offsets
    				// and add 3 px to move away from canvas edges
    				me.paddingLeft = Math.max((paddingLeft - offsetLeft) * me.width / (me.width - offsetLeft), 0) + 3;
    				me.paddingRight = Math.max((paddingRight - offsetRight) * me.width / (me.width - offsetRight), 0) + 3;
    			} else {
    				// A vertical axis is more constrained by the width. Labels are the
    				// dominant factor here, so get that length first and account for padding
    				var labelWidth = tickOpts.mirror ? 0 :
    					// use lineSpace for consistency with horizontal axis
    					// tickPadding is not implemented for horizontal
    					widestLabelSize.width + tickPadding + lineSpace;

    				minSize.width = Math.min(me.maxWidth, minSize.width + labelWidth);

    				me.paddingTop = firstLabelSize.height / 2;
    				me.paddingBottom = lastLabelSize.height / 2;
    			}
    		}

    		me.handleMargins();

    		if (isHorizontal) {
    			me.width = me._length = chart.width - me.margins.left - me.margins.right;
    			me.height = minSize.height;
    		} else {
    			me.width = minSize.width;
    			me.height = me._length = chart.height - me.margins.top - me.margins.bottom;
    		}
    	},

    	/**
    	 * Handle margins and padding interactions
    	 * @private
    	 */
    	handleMargins: function() {
    		var me = this;
    		if (me.margins) {
    			me.margins.left = Math.max(me.paddingLeft, me.margins.left);
    			me.margins.top = Math.max(me.paddingTop, me.margins.top);
    			me.margins.right = Math.max(me.paddingRight, me.margins.right);
    			me.margins.bottom = Math.max(me.paddingBottom, me.margins.bottom);
    		}
    	},

    	afterFit: function() {
    		helpers$1.callback(this.options.afterFit, [this]);
    	},

    	// Shared Methods
    	isHorizontal: function() {
    		var pos = this.options.position;
    		return pos === 'top' || pos === 'bottom';
    	},
    	isFullWidth: function() {
    		return this.options.fullWidth;
    	},

    	// Get the correct value. NaN bad inputs, If the value type is object get the x or y based on whether we are horizontal or not
    	getRightValue: function(rawValue) {
    		// Null and undefined values first
    		if (isNullOrUndef(rawValue)) {
    			return NaN;
    		}
    		// isNaN(object) returns true, so make sure NaN is checking for a number; Discard Infinite values
    		if ((typeof rawValue === 'number' || rawValue instanceof Number) && !isFinite(rawValue)) {
    			return NaN;
    		}

    		// If it is in fact an object, dive in one more level
    		if (rawValue) {
    			if (this.isHorizontal()) {
    				if (rawValue.x !== undefined) {
    					return this.getRightValue(rawValue.x);
    				}
    			} else if (rawValue.y !== undefined) {
    				return this.getRightValue(rawValue.y);
    			}
    		}

    		// Value is good, return it
    		return rawValue;
    	},

    	_convertTicksToLabels: function(ticks) {
    		var me = this;
    		var labels, i, ilen;

    		me.ticks = ticks.map(function(tick) {
    			return tick.value;
    		});

    		me.beforeTickToLabelConversion();

    		// New implementations should return the formatted tick labels but for BACKWARD
    		// COMPAT, we still support no return (`this.ticks` internally changed by calling
    		// this method and supposed to contain only string values