# LangChain Decoded
<h4 align="center">
  <a href="https://github.com/alphasecio/langchain-decoded/blob/main/LICENSE">
    <img src="https://img.shields.io/badge/license-MIT-blue.svg" alt="Released under the MIT license." />
  </a>
  <a href="https://github.com/alphasecio/langchain-decoded">
    <img src="https://img.shields.io/github/stars/alphasecio/langchain-decoded" alt="GitHub Stars" />
  </a>
  <a href="https://github.com/alphasecio/langchain-decoded">
    <img src="https://img.shields.io/github/forks/alphasecio/langchain-decoded" alt="GitHub Forks" />
  </a>
  <a href="https://github.com/alphasecio/langchain-decoded">
    <img src="https://img.shields.io/github/watchers/alphasecio/langchain-decoded" alt="GitHub Watchers" />
  </a>
  <a href="https://twitter.com/alphasecio">
    <img src="https://img.shields.io/twitter/follow/alphasecio?label=Follow" alt="Follow on Twitter" />
  </a>
</h4>

A companion guide for the blog post series, [LangChain Decoded](https://alphasec.io/langchain-decoded-the-muggles-guide-to-langchain). 

[LangChain](https://langchain.readthedocs.io/en/latest/) is an open-source framework created to aid the development of applications leveraging the power of large language models (LLMs). It can be used for chatbots, text summarisation, data generation, code understanding, question answering, evaluation, and more. In this multi-part series, I explore various LangChain modules and use cases, and document my journey via Python notebooks. Feel free to follow along and fork the repository, or use individual notebooks on [Google Colab](https://colab.research.google.com).

## [Part 1: Models](notebooks/langchain_decoded_1_models.ipynb)
This notebook is an exploration of LangChain Models. Read [this post](https://alphasec.io/langchain-decoded-part-1-models) and follow along!

[![Open In Colab](images/colab.svg)](https://colab.research.google.com/github/alphasecio/langchain-decoded/blob/main/notebooks/langchain_decoded_1_models.ipynb)

## [Part 2: Embeddings](notebooks/langchain_decoded_2_embeddings.ipynb)
This notebook is an exploration of LangChain Embeddings. Read [this post](https://alphasec.io/langchain-decoded-part-2-embeddings) and follow along!

[![Open In Colab](images/colab.svg)](https://colab.research.google.com/github/alphasecio/langchain-decoded/blob/main/notebooks/langchain_decoded_2_embeddings.ipynb)

## [Part 3: Prompts](notebooks/langchain_decoded_3_prompts.ipynb)
This notebook is an exploration of LangChain Prompts. Read [this post](https://alphasec.io/langchain-decoded-part-3-prompts) and follow along!

[![Open In Colab](images/colab.svg)](https://colab.research.google.com/github/alphasecio/langchain-decoded/blob/main/notebooks/langchain_decoded_3_prompts.ipynb)

## [Part 4: Indexes](notebooks/langchain_decoded_4_indexes.ipynb)
This notebook is an exploration of LangChain Indexes. Read [this post](https://alphasec.io/langchain-decoded-part-4-indexes) and follow along!

[![Open In Colab](images/colab.svg)](https://colab.research.google.com/github/alphasecio/langchain-decoded/blob/main/notebooks/langchain_decoded_4_indexes.ipynb)

## [Part 5: Memory](notebooks/langchain_decoded_5_memory.ipynb)
This notebook is an exploration of LangChain Memory. Read [this post](https://alphasec.io/langchain-decoded-part-5-memory) and follow along!

[![Open In Colab](images/colab.svg)](https://colab.research.google.com/github/alphasecio/langchain-decoded/blob/main/notebooks/langchain_decoded_5_memory.ipynb)

## [Part 6: Chains](notebooks/langchain_decoded_6_chains.ipynb) (coming soon)
This notebook is an exploration of LangChain Chains. Read [this post](https://alphasec.io/langchain-decoded-part-6-chains) and follow along!

[![Open In Colab](images/colab.svg)](https://colab.research.google.com/github/alphasecio/langchain-decoded/blob/main/notebooks/langchain_decoded_6_chains.ipynb)

## [Part 7: Agents](notebooks/langchain_decoded_7_agents.ipynb) (coming soon)
This notebook is an exploration of LangChain Agents. Read [this post](https://alphasec.io/langchain-decoded-part-7-agents) and follow along!

[![Open In Colab](images/colab.svg)](https://colab.research.google.com/github/alphasecio/langchain-decoded/blob/main/notebooks/langchain_decoded_7_agents.ipynb)

## [Part 8: Callbacks](notebooks/langchain_decoded_8_callbacks.ipynb) (coming soon)
This notebook is an exploration of LangChain Callbacks. Read [this post](https://alphasec.io/langchain-decoded-part-8-callbacks) and follow along!

[![Open In Colab](images/colab.svg)](https://colab.research.google.com/github/alphasecio/langchain-decoded/blob/main/notebooks/langchain_decoded_8_callbacks.ipynb)

## [All-in-One](notebooks/langchain_decoded.ipynb)
This notebook is a consolidation of the individual notebooks above.

[![Open In Colab](images/colab.svg)](https://colab.research.google.com/github/alphasecio/langchain-decoded/blob/main/notebooks/langchain_decoded.ipynb)
