# Classification Model Zoo

## Benchmarks

| Algorithm                                           | Config                                                                                                                                                                                       | Top-1 (%) | Top-5 (%) | gpu memory (MB) | inference time (ms/img)  | Download                                                     |
|-----------------------------------------------------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------| --------- | --------- |-----------------|--------------------------| ------------------------------------------------------------ |
| resnet50(raw)                                       | [resnet50(raw)](https://github.com/alibaba/EasyCV/tree/master/configs/classification/imagenet/resnet/imagenet_resnet50_jpg.py)                                                               | 76.454    | 93.084    | 2412            | 8.59                     | [model](http://pai-vision-data-hz.oss-cn-zhangjiakou.aliyuncs.com/EasyCV/modelzoo/classification/resnet/resnet50/epoch_100.pth) |
| resnet50(tfrecord)                                  | [resnet50(tfrecord)](https://github.com/alibaba/EasyCV/tree/master/configs/classification/imagenet/resnet/imagenet_rn50_tfrecord.py)                                                         | 76.266    | 92.972    | 2412            | 8.59                     | [model](http://pai-vision-data-hz.oss-cn-zhangjiakou.aliyuncs.com/EasyCV/modelzoo/classification/resnet/resnet50/epoch_100.pth) |
| resnet101                                           | [resnet101](https://github.com/alibaba/EasyCV/tree/master/configs/classification/imagenet/resnet/imagenet_resnet101_jpg.py)                                                                  | 78.152    | 93.922    | 2484            | 16.77                    | [model](http://pai-vision-data-hz.oss-cn-zhangjiakou.aliyuncs.com/EasyCV/modelzoo/classification/resnet/resnet101/epoch_100.pth) |
| resnet152                                           | [resnet152](https://github.com/alibaba/EasyCV/tree/master/configs/classification/imagenet/resnet/imagenet_resnet152_jpg.py)                                                                  | 78.544    | 94.206    | 2544            | 24.69                    | [model](http://pai-vision-data-hz.oss-cn-zhangjiakou.aliyuncs.com/EasyCV/modelzoo/classification/resnet/resnet152/epoch_100.pth) |
| resnext50-32x4d                                     | [resnext50-32x4d](https://github.com/alibaba/EasyCV/tree/master/configs/classification/imagenet/resnext/imagenet_resnext50-32x4d_jpg.py)                                                     | 77.604    | 93.856    | 4718            | 12.88                    | [model](http://pai-vision-data-hz.oss-cn-zhangjiakou.aliyuncs.com/EasyCV/modelzoo/classification/resnext/resnet50/epoch_100.pth) |
| resnext101-32x4d                                    | [resnext101-32x4d](https://github.com/alibaba/EasyCV/tree/master/configs/classification/imagenet/resnext/imagenet_resnext101-32x4d_jpg.py)                                                   | 78.568    | 94.344    | 4792            | 26.84                    | [model](http://pai-vision-data-hz.oss-cn-zhangjiakou.aliyuncs.com/EasyCV/modelzoo/classification/resnext/resnext50-32x4d/epoch_100.pth) |
| resnext101-32x8d                                    | [resnext101-32x8d](https://github.com/alibaba/EasyCV/tree/master/configs/classification/imagenet/resnext/imagenet_resnext101-32x8d_jpg.py)                                                   | 79.468    | 94.434    | 9582            | 27.52                    | [model](http://pai-vision-data-hz.oss-cn-zhangjiakou.aliyuncs.com/EasyCV/modelzoo/classification/resnext/resnext101-32x8d/epoch_100.pth) |
| resnext152-32x4d                                    | [resnext152-32x4d](https://github.com/alibaba/EasyCV/tree/master/configs/classification/imagenet/resnext/imagenet_resnext152-32x4d_jpg.py)                                                   | 78.994    | 94.462    | 4852            | 41.08                    | [model](http://pai-vision-data-hz.oss-cn-zhangjiakou.aliyuncs.com/EasyCV/modelzoo/classification/resnext/resnext152-32x4d/epoch_100.pth) |
| hrnetw18                                            | [hrnetw18](https://github.com/alibaba/EasyCV/tree/master/configs/classification/imagenet/hrnet/imagenet_hrnetw18_jpg.py)                                                                     | 76.258    | 92.976    | 4701            | 54.55                    | [model](http://pai-vision-data-hz.oss-cn-zhangjiakou.aliyuncs.com/EasyCV/modelzoo/classification/hrnet/hrnetw18/epoch_100.pth) |
| hrnetw30                                            | [hrnetw30](https://github.com/alibaba/EasyCV/tree/master/configs/classification/imagenet/hrnet/imagenet_hrnetw30_jpg.py)                                                                     | 77.66    | 93.862    | 4766            | 54. 30                   | [model](http://pai-vision-data-hz.oss-cn-zhangjiakou.aliyuncs.com/EasyCV/modelzoo/classification/hrnet/hrnetw30/epoch_100.pth) |
| hrnetw32                                            | [hrnetw32](https://github.com/alibaba/EasyCV/tree/master/configs/classification/imagenet/hrnet/imagenet_hrnetw32_jpg.py)                                                                     | 77.994    | 93.976    | 4780            | 53.48                    | [model](http://pai-vision-data-hz.oss-cn-zhangjiakou.aliyuncs.com/EasyCV/modelzoo/classification/hrnet/hrnetw32/epoch_100.pth) |
| hrnetw40                                            | [hrnetw40](https://github.com/alibaba/EasyCV/tree/master/configs/classification/imagenet/hrnet/imagenet_hrnetw40_jpg.py)                                                                     | 78.142    | 93.956    | 4843            | 54.31                    | [model](http://pai-vision-data-hz.oss-cn-zhangjiakou.aliyuncs.com/EasyCV/modelzoo/classification/hrnet/hrnetw40/epoch_100.pth) |
| hrnetw44                                            | [hrnetw44](https://github.com/alibaba/EasyCV/tree/master/configs/classification/imagenet/hrnet/imagenet_hrnetw44_jpg.py)                                                                     | 79.266    | 94.476    | 4884            | 54.83                    | [model](http://pai-vision-data-hz.oss-cn-zhangjiakou.aliyuncs.com/EasyCV/modelzoo/classification/hrnet/hrnetw44/epoch_100.pth) |
| hrnetw48                                            | [hrnetw48](https://github.com/alibaba/EasyCV/tree/master/configs/classification/imagenet/hrnet/imagenet_hrnetw48_jpg.py)                                                                     | 79.636    | 94.802    | 4916            | 54.14                    | [model](http://pai-vision-data-hz.oss-cn-zhangjiakou.aliyuncs.com/EasyCV/modelzoo/classification/hrnet/hrnetw48/epoch_100.pth) |
| hrnetw64                                            | [hrnetw64](https://github.com/alibaba/EasyCV/tree/master/configs/classification/imagenet/hrnet/imagenet_hrnetw64_jpg.py)                                                                     | 79.884    | 95.04    | 5120            | 54.74                    | [model](http://pai-vision-data-hz.oss-cn-zhangjiakou.aliyuncs.com/EasyCV/modelzoo/classification/resnet/hrnetw64/epoch_100.pth) |
| vit-base-patch16                                    | [vit-base-patch16](https://github.com/alibaba/EasyCV/tree/master/configs/classification/imagenet/vit/imagenet_vit_base_patch16_224_jpg.py)                                                   | 76.082    | 92.026    | 346             | 8.03                     | [model](http://pai-vision-data-hz.oss-cn-zhangjiakou.aliyuncs.com/EasyCV/modelzoo/classification/vit/vit-base-patch16/epoch_300.pth) |
| swin-tiny-patch4-window7                            | [swin-tiny-patch4-window7](https://github.com/alibaba/EasyCV/tree/master/configs/classification/imagenet/swint/imagenet_swin_tiny_patch4_window7_224_jpg.py)                                 | 80.528    | 94.822    | 132             | 12.94                    | [model](http://pai-vision-data-hz.oss-cn-zhangjiakou.aliyuncs.com/EasyCV/modelzoo/classification/swint/swin-tiny-patch4-window7/epoch_300.pth) |
| deitiii-small-patch16-224                           | [deitiii-small-patch16-224](https://github.com/alibaba/EasyCV/tree/master/configs/classification/imagenet/deitiii/imagenet_deitiii_small_patch16_224_jpg.py)                                     | 81.408    | 95.388    | 90              | 7.41<br/>4.90(A100_80G)  | [model](http://pai-vision-data-hz.oss-cn-zhangjiakou.aliyuncs.com/EasyCV/modelzoo/classification/deitiii/imagenet_deitiii_small_patch16_224/deitiii_small.pth) |
| deitiii-base-patch16-192                            | [deitiii-base-patch16-192](https://github.com/alibaba/EasyCV/tree/master/configs/classification/imagenet/deitiii/imagenet_deitiii_base_patch16_192_jpg.py)                                       | 82.982    | 95.95    | 337             | 7.49<br/>5.04(A100_80G)  | [model](http://pai-vision-data-hz.oss-cn-zhangjiakou.aliyuncs.com/EasyCV/modelzoo/classification/deitiii/imagenet_deitiii_base_patch16_192/deitiii_base.pth) |
| deitiii-large-patch16-192                           | [deitiii-large-patch16-192](https://github.com/alibaba/EasyCV/tree/master/configs/classification/imagenet/deitiii/imagenet_deitiii_large_patch16_192_jpg.py)                                     | 83.902    | 96.296    | 1170            | 14.35<br/>9.91(A100_80G) | [model](http://pai-vision-data-hz.oss-cn-zhangjiakou.aliyuncs.com/EasyCV/modelzoo/classification/deitiii/imagenet_deitiii_large_patch16_192/deitiii_large.pth) |
| deit_base_patch16_224 (Hydra Attention [8 layers])  | [deit_base_patch16_224 (Hydra Attention [8 layers])](https://github.com/alibaba/EasyCV/tree/master/configs/classification/imagenet/deit/imagenet_deit_base_hydra_layer8_patch16_224_jpg.py)  | 79.444    | 94.468    | 340             | 6.78<br/>4.47(A100_80G)  | [model](http://pai-vision-data-hz.oss-cn-zhangjiakou.aliyuncs.com/EasyCV/modelzoo/classification/hydra_attention/deit_base_patch16_224%20(Hydra%20Attention%20%5B8%20layers%5D).pth) |
| deit_base_patch16_224 (Hydra Attention [12 layers]) | [deit_base_patch16_224 (Hydra Attention [12 layers])](https://github.com/alibaba/EasyCV/tree/master/configs/classification/imagenet/deit/imagenet_deit_base_hydra_layer12_patch16_224_jpg.py) | 76.67    | 92.872    | 338             | 6.65<br/>4.34(A100_80G)  | [model](http://pai-vision-data-hz.oss-cn-zhangjiakou.aliyuncs.com/EasyCV/modelzoo/classification/hydra_attention/deit_base_patch16_224%20(Hydra%20Attention%20%5B12%20layers%5D).pth) |

(ps: 通过EasyCV训练得到模型结果，推理的输入尺寸默认为224，机器默认为V100 16G，其中gpu memory记录的是gpu peak memory)

| Algorithm | Config                                           | Top-1 (%) | Top-5 (%) | gpu memory (MB) | inference time (ms/img) | Download                                                     |
| --------- | ------------------------------------------------------------ | --------- | --------- | --------- | --------- | ------------------------------------------------------------ |
| vit_base_patch16_224 | [vit_base_patch16_224](https://github.com/alibaba/EasyCV/tree/master/configs/classification/imagenet/timm/vit/vit_base_patch16_224.py) | 78.096    | 94.324   | 346    | 8.03    | [model](http://pai-vision-data-hz.oss-cn-zhangjiakou.aliyuncs.com/EasyCV/modelzoo/classification/timm/vit/B_16-i21k-300ep-lr_0.001-aug_medium1-wd_0.1-do_0.0-sd_0.0--imagenet2012-steps_20k-lr_0.01-res_224.npz) |
| vit_large_patch16_224 | [vit_large_patch16_224](https://github.com/alibaba/EasyCV/tree/master/configs/classification/imagenet/timm/vit/vit_large_patch16_224.py) | 84.404    | 97.276   | 1171    | 16.30    | [model](https://pai-vision-data-hz.oss-cn-zhangjiakou.aliyuncs.com/EasyCV/modelzoo/classification/timm/vit/L_16-i21k-300ep-lr_0.001-aug_medium1-wd_0.1-do_0.1-sd_0.1--imagenet2012-steps_20k-lr_0.01-res_224.npz) |
| deit_base_patch16_224 | [deit_base_patch16_224](https://github.com/alibaba/EasyCV/tree/master/configs/classification/imagenet/timm/deit/deit_base_patch16_224.py) | 81.756    | 95.6   | 346    | 7.98    | [model](https://pai-vision-data-hz.oss-cn-zhangjiakou.aliyuncs.com/EasyCV/modelzoo/classification/timm/deit/deit_base_patch16_224-b5f2ef4d.pth) |
| deit_base_distilled_patch16_224 | [deit_base_distilled_patch16_224](https://github.com/alibaba/EasyCV/tree/master/configs/classification/imagenet/timm/deit/deit_base_distilled_patch16_224.py) | 83.232    | 96.476   | 349    | 8.07    | [model](https://pai-vision-data-hz.oss-cn-zhangjiakou.aliyuncs.com/EasyCV/modelzoo/classification/timm/deit/deit_base_distilled_patch16_224-df68dfff.pth) |
| xcit_medium_24_p8_224 | [xcit_medium_24_p8_224](https://github.com/alibaba/EasyCV/tree/master/configs/classification/imagenet/timm/xcit/xcit_medium_24_p8_224.py) | 83.348    | 96.21   | 884    | 31.77    | [model](https://pai-vision-data-hz.oss-cn-zhangjiakou.aliyuncs.com/EasyCV/modelzoo/classification/timm/xcit/xcit_medium_24_p8_224.pth) |
| xcit_medium_24_p8_224_dist | [xcit_medium_24_p8_224_dist](https://github.com/alibaba/EasyCV/tree/master/configs/classification/imagenet/timm/xcit/xcit_medium_24_p8_224_dist.py) | 84.876    | 97.164   | 884    | 32.08    | [model](http://pai-vision-data-hz.oss-cn-zhangjiakou.aliyuncs.com/EasyCV/modelzoo/classification/timm/xcit/xcit_medium_24_p8_224_dist.pth) |
| xcit_large_24_p8_224 | [xcit_large_24_p8_224](https://github.com/alibaba/EasyCV/tree/master/configs/classification/imagenet/timm/xcit/xcit_large_24_p8_224.py) | 83.986    | 96.47   | 1962    | 37.44    | [model](https://pai-vision-data-hz.oss-cn-zhangjiakou.aliyuncs.com/EasyCV/modelzoo/classification/timm/xcit/xcit_large_24_p8_224.pth) |
| xcit_large_24_p8_224_dist | [xcit_large_24_p8_224_dist](https://github.com/alibaba/EasyCV/tree/master/configs/classification/imagenet/timm/xcit/xcit_large_24_p8_224_dist.py) | 85.022    | 97.29   | 1962    | 37.44    | [model](https://pai-vision-data-hz.oss-cn-zhangjiakou.aliyuncs.com/EasyCV/modelzoo/classification/timm/xcit/xcit_large_24_p8_224_dist.pth) |
| tnt_s_patch16_224 | [tnt_s_patch16_224](https://github.com/alibaba/EasyCV/tree/master/configs/classification/imagenet/timm/tnt/tnt_s_patch16_224.py) | 76.934    | 93.388   | 100    | 18.92    | [model](https://pai-vision-data-hz.oss-cn-zhangjiakou.aliyuncs.com/EasyCV/modelzoo/classification/timm/tnt/tnt_s_patch16_224.pth.tar) |
| convit_tiny | [convit_tiny](https://github.com/alibaba/EasyCV/tree/master/configs/classification/imagenet/timm/convit/convit_tiny.py) | 72.954    | 91.68   | 31    | 10.79    | [model](https://pai-vision-data-hz.oss-cn-zhangjiakou.aliyuncs.com/EasyCV/modelzoo/classification/timm/convit/convit_tiny.pth) |
| convit_small | [convit_small](https://github.com/alibaba/EasyCV/tree/master/configs/classification/imagenet/timm/convit/convit_small.py) | 81.342   | 95.784   | 122    | 11.23    | [model](https://pai-vision-data-hz.oss-cn-zhangjiakou.aliyuncs.com/EasyCV/modelzoo/classification/timm/convit/convit_small.pth) |
| convit_base | [convit_base](https://github.com/alibaba/EasyCV/tree/master/configs/classification/imagenet/timm/convit/convit_base.py) | 82.27    | 95.916   | 358    | 11.26    | [model](https://pai-vision-data-hz.oss-cn-zhangjiakou.aliyuncs.com/EasyCV/modelzoo/classification/timm/convit/convit_base.pth) |
| cait_xxs24_224 | [cait_xxs24_224](https://github.com/alibaba/EasyCV/tree/master/configs/classification/imagenet/timm/cait/cait_xxs24_224.py) | 78.45   | 94.154   | 50    | 22.62    | [model](https://pai-vision-data-hz.oss-cn-zhangjiakou.aliyuncs.com/EasyCV/modelzoo/classification/timm/cait/XXS24_224.pth) |
| cait_xxs36_224 | [cait_xxs36_224](https://github.com/alibaba/EasyCV/tree/master/configs/classification/imagenet/timm/cait/cait_xxs36_224.py) | 79.788   | 94.87   | 71    | 33.25    | [model](https://pai-vision-data-hz.oss-cn-zhangjiakou.aliyuncs.com/EasyCV/modelzoo/classification/timm/cait/XXS36_224.pth) |
| cait_s24_224 | [cait_s24_224](https://github.com/alibaba/EasyCV/tree/master/configs/classification/imagenet/timm/cait/cait_s24_224.py) | 83.302   | 96.568   | 190    | 23.74    | [model](http://pai-vision-data-hz.oss-cn-zhangjiakou.aliyuncs.com/EasyCV/modelzoo/classification/timm/cait/cait_s24_224.pth) |
| levit_128 | [levit_128](https://github.com/alibaba/EasyCV/tree/master/configs/classification/imagenet/timm/levit/levit_128.py) | 78.468   | 93.874   | 76    | 15.33    | [model](https://pai-vision-data-hz.oss-cn-zhangjiakou.aliyuncs.com/EasyCV/modelzoo/classification/timm/levit/LeViT-128-b88c2750.pth) |
| levit_192 | [levit_192](https://github.com/alibaba/EasyCV/tree/master/configs/classification/imagenet/timm/levit/levit_192.py) | 79.72   | 94.664   | 128    | 15.17    | [model](https://pai-vision-data-hz.oss-cn-zhangjiakou.aliyuncs.com/EasyCV/modelzoo/classification/timm/levit/LeViT-192-92712e41.pth) |
| levit_256 | [levit_256](https://github.com/alibaba/EasyCV/tree/master/configs/classification/imagenet/timm/levit/levit_256.py) | 81.432   | 95.38   | 222    | 15.27    | [model](https://pai-vision-data-hz.oss-cn-zhangjiakou.aliyuncs.com/EasyCV/modelzoo/classification/timm/levit/LeViT-256-13b5763e.pth) |
| convnext_tiny | [convnext_tiny](https://github.com/alibaba/EasyCV/tree/master/configs/classification/imagenet/timm/convnext/convnext_tiny.py) | 81.878   | 95.836   | 128    | 7.17    | [model](https://pai-vision-data-hz.oss-cn-zhangjiakou.aliyuncs.com/EasyCV/modelzoo/classification/timm/convnext/convnext_tiny_1k_224_ema.pth) |
| convnext_small | [convnext_small](https://github.com/alibaba/EasyCV/tree/master/configs/classification/imagenet/timm/convnext/convnext_small.py) | 82.836   | 96.458   | 213    | 12.89    | [model](https://pai-vision-data-hz.oss-cn-zhangjiakou.aliyuncs.com/EasyCV/modelzoo/classification/timm/convnext/convnext_small_1k_224_ema.pth) |
| convnext_base | [convnext_base](https://github.com/alibaba/EasyCV/tree/master/configs/classification/imagenet/timm/convnext/convnext_base.py) | 83.73   | 96.692   | 364    | 13.04    | [model](https://pai-vision-data-hz.oss-cn-zhangjiakou.aliyuncs.com/EasyCV/modelzoo/classification/timm/convnext/convnext_base_1k_224_ema.pth) |
| convnext_large | [convnext_large](https://github.com/alibaba/EasyCV/tree/master/configs/classification/imagenet/timm/convnext/convnext_large.py) | 84.164   | 96.844   | 781    | 13.78    | [model](https://pai-vision-data-hz.oss-cn-zhangjiakou.aliyuncs.com/EasyCV/modelzoo/classification/timm/convnext/convnext_large_1k_224_ema.pth) |
| resmlp_12_distilled_224 | [resmlp_12_distilled_224](https://github.com/alibaba/EasyCV/tree/master/configs/classification/imagenet/timm/resmlp/resmlp_12_distilled_224.py) | 77.876   | 93.532   | 66    | 4.90    | [model](https://pai-vision-data-hz.oss-cn-zhangjiakou.aliyuncs.com/EasyCV/modelzoo/classification/timm/resmlp/resmlp_12_dist.pth) |
| resmlp_24_distilled_224 | [resmlp_24_distilled_224](https://github.com/alibaba/EasyCV/tree/master/configs/classification/imagenet/timm/resmlp/resmlp_24_distilled_224.py) | 80.548   | 95.204   | 124    | 9.07    | [model](https://pai-vision-data-hz.oss-cn-zhangjiakou.aliyuncs.com/EasyCV/modelzoo/classification/timm/resmlp/resmlp_24_dist.pth) |
| resmlp_36_distilled_224 | [resmlp_36_distilled_224](https://github.com/alibaba/EasyCV/tree/master/configs/classification/imagenet/timm/resmlp/resmlp_36_distilled_224.py) | 80.944   | 95.416   | 181    | 13.56    | [model](https://pai-vision-data-hz.oss-cn-zhangjiakou.aliyuncs.com/EasyCV/modelzoo/classification/timm/resmlp/resmlp_36_dist.pth) |
| resmlp_big_24_distilled_224 | [resmlp_big_24_distilled_224](https://github.com/alibaba/EasyCV/tree/master/configs/classification/imagenet/timm/resmlp/resmlp_big_24_distilled_224.py) | 83.45   | 96.65   | 534    | 20.48    | [model](https://pai-vision-data-hz.oss-cn-zhangjiakou.aliyuncs.com/EasyCV/modelzoo/classification/timm/resmlp/resmlpB_24_dist.pth) |
| coat_tiny | [coat_tiny](https://github.com/alibaba/EasyCV/tree/master/configs/classification/imagenet/timm/coat/coat_tiny.py) | 78.112   | 93.972   | 127    | 33.09    | [model](https://pai-vision-data-hz.oss-cn-zhangjiakou.aliyuncs.com/EasyCV/modelzoo/classification/timm/coat/coat_tiny-473c2a20.pth) |
| coat_mini | [coat_mini](https://github.com/alibaba/EasyCV/tree/master/configs/classification/imagenet/timm/coat/coat_mini.py) | 80.912   | 95.378   | 247    | 33.29    | [model](https://pai-vision-data-hz.oss-cn-zhangjiakou.aliyuncs.com/EasyCV/modelzoo/classification/timm/coat/coat_mini-2c6baf49.pth) |
| convmixer_768_32 | [convmixer_768_32](https://github.com/alibaba/EasyCV/tree/master/configs/classification/imagenet/timm/convmixer/convmixer_768_32.py) | 80.08   | 94.992   | 4995    | 10.23    | [model](https://pai-vision-data-hz.oss-cn-zhangjiakou.aliyuncs.com/EasyCV/modelzoo/classification/timm/convmixer/convmixer_768_32_ks7_p7_relu.pth.tar) |
| convmixer_1024_20_ks9_p14 | [convmixer_1024_20_ks9_p14](https://github.com/alibaba/EasyCV/tree/master/configs/classification/imagenet/timm/convmixer/convmixer_1024_20_ks9_p14.py) | 81.742   | 95.578   | 2407    | 6.29    | [model](https://pai-vision-data-hz.oss-cn-zhangjiakou.aliyuncs.com/EasyCV/modelzoo/classification/timm/convmixer/convmixer_1024_20_ks9_p14.pth.tar) |
| convmixer_1536_20 | [convmixer_1536_20](https://github.com/alibaba/EasyCV/tree/master/configs/classification/imagenet/timm/convmixer/convmixer_1536_20.py) | 81.432   | 95.38   | 547    | 14.66    | [model](https://pai-vision-data-hz.oss-cn-zhangjiakou.aliyuncs.com/EasyCV/modelzoo/classification/timm/convmixer/convmixer_1536_20_ks9_p7.pth.tar) |
| gmixer_24_224 | [gmixer_24_224](https://github.com/alibaba/EasyCV/tree/master/configs/classification/imagenet/timm/gmixer/gmixer_24_224.py) | 78.088   | 93.6   | 104    | 11.65    | [model](https://pai-vision-data-hz.oss-cn-zhangjiakou.aliyuncs.com/EasyCV/modelzoo/classification/timm/gmixer/gmixer_24_224_raa-7daf7ae6.pth) |
| gmlp_s16_224 | [gmlp_s16_224](https://github.com/alibaba/EasyCV/tree/master/configs/classification/imagenet/timm/gmlp/gmlp_s16_224.py) | 77.204   | 93.358   | 81    | 11.15    | [model](http://pai-vision-data-hz.oss-cn-zhangjiakou.aliyuncs.com/EasyCV/modelzoo/classification/timm/gmlp/gmlp_s16_224.pth) |
| mixer_b16_224 | [mixer_b16_224](https://github.com/alibaba/EasyCV/tree/master/configs/classification/imagenet/timm/mlp-mixer/mixer_b16_224.py) | 72.558   | 90.068   | 241    | 5.37    | [model](https://pai-vision-data-hz.oss-cn-zhangjiakou.aliyuncs.com/EasyCV/modelzoo/classification/timm/mlp-mixer/jx_mixer_b16_224-76587d61.pth) |
| mixer_l16_224 | [mixer_l16_224](https://github.com/alibaba/EasyCV/tree/master/configs/classification/imagenet/timm/mlp-mixer/mixer_l16_224.py) | 68.34   | 86.11   | 804    | 11.74    | [model](https://pai-vision-data-hz.oss-cn-zhangjiakou.aliyuncs.com/EasyCV/modelzoo/classification/timm/mlp-mixer/jx_mixer_l16_224-92f9adc4.pth) |
| jx_nest_tiny | [jx_nest_tiny](https://github.com/alibaba/EasyCV/tree/master/configs/classification/imagenet/timm/nest/jx_nest_tiny.py) | 81.278   | 95.618   | 90    | 9.05    | [model](https://pai-vision-data-hz.oss-cn-zhangjiakou.aliyuncs.com/EasyCV/modelzoo/classification/timm/nest/jx_nest_tiny-e3428fb9.pth) |
| jx_nest_small | [jx_nest_tiny](https://github.com/alibaba/EasyCV/tree/master/configs/classification/imagenet/timm/nest/jx_nest_small.py) | 83.144   | 96.3   | 174    | 16.92    | [model](https://pai-vision-data-hz.oss-cn-zhangjiakou.aliyuncs.com/EasyCV/modelzoo/classification/timm/nest/jx_nest_small-422eaded.pth) |
| jx_nest_base | [jx_nest_base](https://github.com/alibaba/EasyCV/tree/master/configs/classification/imagenet/timm/nest/jx_nest_base.py) | 83.474   | 96.442   | 300    | 16.88    | [model](https://pai-vision-data-hz.oss-cn-zhangjiakou.aliyuncs.com/EasyCV/modelzoo/classification/timm/nest/jx_nest_base-8bc41011.pth) |
| pit_s_distilled_224 | [pit_s_distilled_224](https://github.com/alibaba/EasyCV/tree/master/configs/classification/imagenet/timm/pit/pit_s_distilled_224.py) | 83.144   | 96.3   | 109    | 7.00    | [model](https://pai-vision-data-hz.oss-cn-zhangjiakou.aliyuncs.com/EasyCV/modelzoo/classification/timm/pit/pit_s_distill_819.pth) |
| pit_b_distilled_224 | [pit_b_distilled_224](https://github.com/alibaba/EasyCV/tree/master/configs/classification/imagenet/timm/pit/pit_b_distilled_224.py) | 83.474   | 96.442   | 330    | 7.66    | [model](https://pai-vision-data-hz.oss-cn-zhangjiakou.aliyuncs.com/EasyCV/modelzoo/classification/timm/pit/pit_b_distill_840.pth) |
| twins_svt_small | [twins_svt_small](https://github.com/alibaba/EasyCV/tree/master/configs/classification/imagenet/timm/twins/twins_svt_small.py) | 81.598   | 95.55   | 657    | 14.07    | [model](https://pai-vision-data-hz.oss-cn-zhangjiakou.aliyuncs.com/EasyCV/modelzoo/classification/timm/twins/twins_svt_small-42e5f78c.pth) |
| twins_svt_base | [twins_svt_base](https://github.com/alibaba/EasyCV/tree/master/configs/classification/imagenet/timm/twins/twins_svt_base.py) | 82.882   | 96.234   | 1447    | 18.99    | [model](https://pai-vision-data-hz.oss-cn-zhangjiakou.aliyuncs.com/EasyCV/modelzoo/classification/timm/twins/twins_svt_base-c2265010.pth) |
| twins_svt_large | [twins_svt_large](https://github.com/alibaba/EasyCV/tree/master/configs/classification/imagenet/timm/twins/twins_svt_large.py) | 83.428   | 96.506   | 2567    | 19.11    | [model](https://pai-vision-data-hz.oss-cn-zhangjiakou.aliyuncs.com/EasyCV/modelzoo/classification/timm/twins/twins_svt_large-90f6aaa9.pth) |
| swin_base_patch4_window7_224 | [swin_base_patch4_window7_224](https://github.com/alibaba/EasyCV/tree/master/configs/classification/imagenet/timm/swint/swin_base_patch4_window7_224.py) | 84.714   | 97.444   | 375    | 23.47    | [model](https://pai-vision-data-hz.oss-cn-zhangjiakou.aliyuncs.com/EasyCV/modelzoo/classification/timm/swint/swin_base_patch4_window7_224_22kto1k.pth) |
| swin_large_patch4_window7_224 | [swin_large_patch4_window7_224](https://github.com/alibaba/EasyCV/tree/master/configs/classification/imagenet/timm/swint/swin_large_patch4_window7_224.py) | 85.826   | 97.816   | 788    | 23.29    | [model](https://pai-vision-data-hz.oss-cn-zhangjiakou.aliyuncs.com/EasyCV/modelzoo/classification/timm/swint/swin_large_patch4_window7_224_22kto1k.pth) |
| dynamic_swin_small_p4_w7_224 | [dynamic_swin_small_p4_w7_224](https://github.com/alibaba/EasyCV/tree/master/configs/classification/imagenet/timm/swint/dynamic_small_base_p4_w7_224.py) | 82.896   | 96.234   | 220    | 28.55    | [model](https://pai-vision-data-hz.oss-cn-zhangjiakou.aliyuncs.com/EasyCV/modelzoo/classification/timm/swint/swin_small_patch4_window7_224_statedict.pth) |
| dynamic_swin_tiny_p4_w7_224 | [dynamic_swin_tiny_p4_w7_224](https://github.com/alibaba/EasyCV/tree/master/configs/classification/imagenet/timm/swint/dynamic_swin_tiny_p4_w7_224.py) | 80.912   | 95.41   | 136    | 14.58    | [model](https://pai-vision-data-hz.oss-cn-zhangjiakou.aliyuncs.com/EasyCV/modelzoo/classification/timm/swint/swin_tiny_patch4_window7_224_statedict.pth) |
| shuffletrans_tiny_p4_w7_224 | [shuffletrans_tiny_p4_w7_224](https://github.com/alibaba/EasyCV/tree/master/configs/classification/imagenet/timm/shuffle_transformer/shuffletrans_tiny_p4_w7_224.py) | 82.176   | 96.05   | 5311    | 13.90    | [model](https://pai-vision-data-hz.oss-cn-zhangjiakou.aliyuncs.com/EasyCV/modelzoo/classification/timm/shuffle_transformer/shuffle_tiny.pth) |
| efficientformer_l1 | [efficientformer_l1](https://github.com/alibaba/EasyCV/tree/master/configs/classification/imagenet/efficientformer/efficientformer_l1.py) | 80.102   | 94.934   | 1820    | 7.5    | [model](https://pai-vision-data-hz.oss-cn-zhangjiakou.aliyuncs.com/EasyCV/modelzoo/classification/efficientformer/efficientformer_l1_1000d.pth) |
| efficientformer_l3 | [efficientformer_l3](https://github.com/alibaba/EasyCV/tree/master/configs/classification/imagenet/efficientformer/efficientformer_l3.py) | 82.272   | 96.028   | 2436    | 13.07    | [model](https://pai-vision-data-hz.oss-cn-zhangjiakou.aliyuncs.com/EasyCV/modelzoo/classification/efficientformer/efficientformer_l3_300d.pth) |
| efficientformer_l7 | [efficientformer_l7](https://github.com/alibaba/EasyCV/tree/master/configs/classification/imagenet/efficientformer/efficientformer_l7.py) | 83.076   | 96.44   | 1622    | 18.96    | [model](https://pai-vision-data-hz.oss-cn-zhangjiakou.aliyuncs.com/EasyCV/modelzoo/classification/efficientformer/efficientformer_l7_300d.pth) |
| EdgeVit_xxs_b512_224 | [EdgeVit_xxs_b512_224](https://github.com/alibaba/EasyCV/tree/master/configs/classification/imagenet/edgevit/imagenet_edgeVIT_xxs_jpg.py) | 75.18   | 92.188   | 206   | 8.67    | [model](http://pai-vision-data-hz.oss-cn-zhangjiakou.aliyuncs.com/EasyCV/modelzoo/classification/edgevit/edgexxs/ClsEvaluator_neck_top1_best.pth) |
| EdgeVit_xs_b256_224 | [EdgeVit_xs_b256_224](https://github.com/alibaba/EasyCV/tree/master/configs/classification/imagenet/edgevit/imagenet_edgeVIT_xs_jpg.py) | 77.624   | 93.47  | 551   | 8.04    | [model](http://pai-vision-data-hz.oss-cn-zhangjiakou.aliyuncs.com/EasyCV/modelzoo/classification/edgevit/edgexs/ClsEvaluator_neck_top1_best.pth) |
| EdgeVit_s_b128_224 | [EdgeVit_s_b128_224](https://github.com/alibaba/EasyCV/tree/master/configs/classification/imagenet/edgevit/imagenet_edgeVIT_s_jpg.py) | 80.3   | 95.302  | 576   | 13.49   | [model](http://pai-vision-data-hz.oss-cn-zhangjiakou.aliyuncs.com/EasyCV/modelzoo/classification/edgevit/edges/ClsEvaluator_neck_top1_best.pth) |

(ps: 通过导入官方模型得到推理结果，需要torch.__version__ >= 1.9.0，推理的输入尺寸默认为224，机器默认为V100 16G，其中gpu memory记录的是gpu peak memory)
