# CDI Guides and Tutorials - Hacking Code

This GitHub Repository belogs to [Hacking Code Site](https://blog.hackingcode.io/?utm_source=github&utm_medium=cdi-guide-tutorials) founded by [@alexandregama](https://github.com/alexandregama), that has many **Articles**, **Guides** and **Tutorials** about many frameworks and libraries like:

- [CDI](https://blog.hackingcode.io/cdi-guides-posts-news-and-tutorials/?utm_source=github&utm_medium=cdi-guide-tutorials)
- [Java 8](https://blog.hackingcode.io/java-8-tutorials-guides-ebooks-courses/?utm_source=github&utm_medium=java8-guide-tutorials)
- [JUnit](https://blog.hackingcode.io/junit-guides-tutorials-blog-posts-and-news/?utm_source=github&utm_medium=cdi-guide-tutorials)
- [Mockito](https://blog.hackingcode.io/mockito-guides-tutorials-blog-posts-and-news/?utm_source=github&utm_medium=cdi-guide-tutorials)

If you are interested in **CDI Articles**, you can learn a lot of **CDI Features** in the following links :)

- [CDI Qualifiers Tutorial](https://blog.hackingcode.io/cdi-qualifiers-dependency-injection-java-tutorial/?utm_source=github&utm_medium=cdi-guide-tutorials)
- [CDI Observers and Events Tutorial](https://blog.hackingcode.io/cdi-events-and-observers-java-tutorial/?utm_source=github&utm_medium=cdi-guide-tutorials)
- [CDI Lazy Initialization Tutorial](https://blog.hackingcode.io/cdi-lazy-initialization-java-tutorial/?utm_source=github&utm_medium=cdi-guide-tutorials)
- [CDI How to use Interceptors](https://blog.hackingcode.io/cdi-interceptors-dependency-injection-java-tutorial/?utm_source=github&utm_medium=cdi-guide-tutorials)
- [CDI Alternatives Tutorial](https://blog.hackingcode.io/cdi-alternatives-dependency-injection-java-tutorial/?utm_source=github&utm_medium=cdi-guide-tutorials)
- [CDI How to use Decorators](https://blog.hackingcode.io/cdi-decorators-dependency-injection-java-tutorial/?utm_source=github&utm_medium=cdi-guide-tutorials)

# Java 8 Guides and Tutorials

**Java 8**  changed the way that we think and code. Here you will see a **lot of articles and tutorials**
about Java 8, how to use its awesome features and how to get your life easier! Enjoy!

- [JUnit Main Page](https://blog.hackingcode.io/java-8-tutorials-guides-ebooks-courses/?utm_source=github&utm_medium=cdi-guide-tutorials)
- [GitHub Main Page](https://github.com/hacking-code/java8-guides-tutorials)

### Articles and Tutorials about Java 8

- [Java 8 - Lambda Expression](https://blog.hackingcode.io/java-8-lambda-expression-tutorial-java-guide/?utm_source=github&utm_medium=cdi-guide-tutorials)
- [Java 8 - Default Methods](https://blog.hackingcode.io/java-8-default-methods-tutorial-java-guide/?utm_source=github&utm_medium=cdi-guide-tutorials)
- [Java 8 - Functions](https://blog.hackingcode.io/java-8-functions-tutorial-java-guide/?utm_source=github&utm_medium=cdi-guide-tutorials)
- [Java 8 - Method Reference](https://blog.hackingcode.io/java-8-method-reference-tutorial-java-guide/?utm_source=github&utm_medium=cdi-guide-tutorials)
- [Java 8 - Stream Count](https://blog.hackingcode.io/java-8-stream-count-tutorial-java-guide/?utm_source=github&utm_medium=cdi-guide-tutorials)
- [Java 8 - Stream with Filter](https://blog.hackingcode.io/java-8-stream-filter-tutorial-java-guide/?utm_source=github&utm_medium=cdi-guide-tutorials)
- [Java 8 - Stream with Map](https://blog.hackingcode.io/java-8-stream-map-tutorial-java-guide/?utm_source=github&utm_medium=cdi-guide-tutorials)
- [Java 8 - Stream with Sorted](https://blog.hackingcode.io/java-8-stream-sorted-tutorial-java-guide/?utm_source=github&utm_medium=cdi-guide-tutorials)
- [Java 8 - Stream with Match](https://blog.hackingcode.io/java-8-stream-match-tutorial-java-guide/?utm_source=github&utm_medium=cdi-guide-tutorials)
- [Java 8 - Stream Reduce](https://blog.hackingcode.io/java-8-stream-reduce-tutorial-java-guide/?utm_source=github&utm_medium=cdi-guide-tutorials)
- [Java 8 - Stream Consumer](https://blog.hackingcode.io/java-8-consumers-tutorial-java-guide/?utm_source=github&utm_medium=cdi-guide-tutorials)
- [Java 8 - Predicate](https://blog.hackingcode.io/java-8-predicate-tutorial-java-guide/?utm_source=github&utm_medium=cdi-guide-tutorials)
- [Java 8 - Comparator](https://blog.hackingcode.io/java-8-comparator-tutorial-java-guide/?utm_source=github&utm_medium=cdi-guide-tutorials)
- [Java 8 - Suppliers](https://blog.hackingcode.io/java-8-suppliers-tutorial-java-guide/?utm_source=github&utm_medium=cdi-guide-tutorials)

# JUnit Guides and Tutorials

Are you interested in learn about **JUnit Framework**? Maybe you would like to see a lot of great JUnit Features in [Hacking Code Site](https://blog.hackingcode.io/?utm_source=github&utm_medium=cdi-guide-tutorials) in the following links:

- [JUnit Main Page](https://blog.hackingcode.io/junit-guides-tutorials-blog-posts-and-news/?utm_source=github&utm_medium=cdi-guide-tutorials)
- [GitHub Main Page](https://github.com/hacking-code/junit-guides-tutorials)

### Articles and Tutorials about JUnit

- [JUnit - How to Configure JUnit 4 and JUnit 5](https://blog.hackingcode.io/junit-tutorial-how-to-configuration-junit4-and-junit5/?utm_source=github&utm_medium=cdi-guide-tutorials)
- [JUnit - Mastering JUnit Assertions](https://blog.hackingcode.io/junit-tutorial-mastering-junit-assertions-java-guide/?utm_source=github&utm_medium=cdi-guide-tutorials)
- [JUnit - How to Use Hamcrest Assertions](https://blog.hackingcode.io/junit-tutorial-hamcrest-assertions-java-guide/?utm_source=github&utm_medium=cdi-guide-tutorials)
- [JUnit - How to work with Tests in Suite](https://blog.hackingcode.io/junit-tutorial-tests-in-suite-java-guide/?utm_source=github&utm_medium=cdi-guide-tutorials)
- [JUnit - How to Order your Execution Test](https://blog.hackingcode.io/junit-tutorial-test-execution-order-java-guide/?utm_source=github&utm_medium=cdi-guide-tutorials)
- [JUnit - Testing with Exceptions](https://blog.hackingcode.io/junit-tutorial-testing-exceptions-java-guide/?utm_source=github&utm_medium=cdi-guide-tutorials)

# Mockito Guides and Tutorials

**Mockito** is one of the best **Java Libraries** to work with **Unit and Integration Testing**! In the [Hacking Code Site](https://blog.hackingcode.io/?utm_source=github&utm_medium=cdi-guide-tutorials) you can follow a lot of [Mockito Articles and Tutorials](https://blog.hackingcode.io/mockito-guides-tutorials-blog-posts-and-news/?utm_source=github&utm_medium=cdi-guide-tutorials)! Have fun \o/

- [Mockito Main Page](https://blog.hackingcode.io/mockito-guides-tutorials-blog-posts-and-news/?utm_source=github&utm_medium=cdi-guide-tutorials)
- [GitHub Main Page](https://github.com/hacking-code/mockito-guide-tutorials)

### Articles and Tutorials about Mockito

- [Mockito - Mocking objects by using mock() and verify()](https://blog.hackingcode.io/mockito-tutorial-mocking-objects-java-guide/?utm_source=github&utm_medium=cdi-guide-tutorials)
- [Mockito - Basic usage of when() and thenReturn() methods](https://blog.hackingcode.io/mockito-tutorial-basic-usage-of-when-and-then-return-java-guide/?utm_source=github&utm_medium=cdi-guide-tutorials)
- [Mockito - Throwing Exceptions by using thenThrow()](https://blog.hackingcode.io/mockito-tutorial-throwing-exceptions-then-throw-java-guide/?utm_source=github&utm_medium=cdi-guide-tutorials)
- [Mockito - Stubying with Fluent Interface](https://blog.hackingcode.io/mockito-tutorial-stubbing-with-fluent-interface-java-guide/)
- [Mockito - Printing Custom Message when the Verify fails](https://blog.hackingcode.io/mockito-tutorial-printing-custom-message-when-the-verify-fails-java-guide/?utm_source=github&utm_medium=cdi-guide-tutorials)
- [Mockito BDD - Behavior Driven Development with Mockito](https://blog.hackingcode.io/mockito-tutorial-bdd-behavior-driven-development-with-mockito-java-guide/?utm_source=github&utm_medium=cdi-guide-tutorials)
- [Mockito - Ignoring Stubs](https://blog.hackingcode.io/mockito-tutorial-ignoring-stubs-java-guide/?utm_source=github&utm_medium=cdi-guide-tutorials)
- [Mockito - Reseting Mock Interactions](https://blog.hackingcode.io/mockito-tutorial-resetting-mock-interactions-java-guide/?utm_source=github&utm_medium=cdi-guide-tutorials)

# Keep Social :) 

- [Twitter](https://twitter.com/hacking_code)
- [GitHub](https://github.com/hacking-code)
- [Instagram](https://www.instagram.com/hacking_code)
- [Facebook](https://www.facebook.com/hacking.code.academy)

# About the Author - Alexandre Gama

Let's keep in touch :  )

- [Twitter](https://twitter.com/alexandregamma)
- [GitHub](https://github.com/alexandregama)
- [Linkedin](https://www.linkedin.com/in/alexandregama/)
- [Instagram](https://www.instagram.com/alexandregama/)
- [Google+](https://plus.google.com/+AlexandreGamaLima)
- [About.me](https://about.me/alexandregama)
