﻿namespace CourseLibrary.API.Services {
    public class PropertyMappingValue {
        public IEnumerable<string> DestinationProperties { get; private set; }
        public bool Revert { get; set; }

        public PropertyMappingValue(IEnumerable<string> destinationProperties, bool revert = false) {
            DestinationProperties = destinationProperties ??
                throw new ArgumentNullException(nameof(destinationProperties));
            Revert = revert;
        }
    }
}
