/*
 * Copyright 2014-2018 Aleksandr Mashchenko.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.amashchenko.struts2.pdfstream;

import java.util.Locale;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.opensymphony.xwork2.util.ValueStack;

/**
 * Default implementation of the {@link ViewRenderer} which uses
 * {@link RequestDispatcher}.
 * 
 * @author Aleksandr Mashchenko
 * 
 */
public class DefaultRenderer implements ViewRenderer {

    /** {@inheritDoc} */
    @Override
    public void render(final String location, final HttpServletRequest request,
                    final HttpServletResponse response,
                    final ServletContext servletContext, final Locale locale,
                    final ValueStack valueStack, final Object action)
                    throws Exception {
        RequestDispatcher dispatcher = request.getRequestDispatcher(location);
        dispatcher.include(request, response);
    }
}
