/*
 * Copyright 2015-2024 Alejandro Sánchez <alex@nexttypes.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.nexttypes.system;

public class KeyWords {
	
	public static final String ACCEPT = "accept";
	public static final String ACTION = "action";
	public static final String _ACTION = "_action";
	public static final String ACTION_EXECUTION_ERROR = "action_execution_error";
	public static final String ACTION_NAME_TOO_LONG = "action_name_too_long";
	public static final String ACTION_NOT_FOUND = "action_not_found";
	public static final String ACTIONS = "actions";
	public static final String ADATE = "adate";
	public static final String ADD_FILTER = "add_filter";
	public static final String ADDED_FIELDS = "added_fields";
	public static final String ADDED_INDEXES = "added_indexes";
	public static final String ALLOWED_CONTENT_TYPES = "allowed_content_types";
	public static final String ALREADY_ALTERED_TYPE = "already_altered_type";
	public static final String ALREADY_UPDATED_OBJECT = "already_updated_object";
	public static final String ALTER_TITLE = "alter_title";
	public static final String ALTERED = "altered";
	public static final String ALTERED_FIELDS = "altered_fields";
	public static final String ALTERED_INDEXES = "altered_indexes";
	public static final String ALTERED_TYPES = "altered_types";
	public static final String ANCHORS = "anchors";
	public static final String ANTIVIRUS = "antivirus";
	public static final String AREF = "aref";
	public static final String AUTH = "auth";
	public static final String AUTH_ERRORS_PER_MINUTE_EXCEEDED = "auth_errors_per_minute_exceeded";
	public static final String BACKLOG = "backlog";
	public static final String BACKUP = "backup";
	public static final String BASIC_AUTH_REALM = "basic_auth_realm";
	public static final String BASIC_AUTH_USER_AGENTS = "basic_auth_user_agents";
	public static final String BINARY_DEBUG = "binary_debug";
	public static final String BINARY_DEBUG_LIMIT = "binary_debug_limit";
	public static final String BIND_ADDRESS = "bind_address";
	public static final String CALENDAR = "calendar";
	public static final String CALENDAR_TITLE = "calendar_title";
	public static final String CANCEL = "cancel";
	public static final String CDATE = "cdate";
	public static final String CERTIFICATE_NOT_FOUND = "certificate_not_found";
	public static final String CHANNEL = "channel";
	public static final String CHARSET = "charset";
	public static final String CHECK_UNCHECK_ALL = "check_uncheck_all";
	public static final String CLEAR = "clear";
	public static final String COLOR = "color";
	public static final String COMPARISON = "comparison";
	public static final String COMPARISONS = "comparisons";
	public static final String COMPONENT = "component";
	public static final String CONTENT = "content";
	public static final String CONTENT_SECURITY_POLICY = "content_security_policy";
	public static final String CONTENT_TYPE = "content_type";
	public static final String CONTROLLER = "controller";
	public static final String CONTROL_PANEL = "control_panel";
	public static final String COUNT = "count";
	public static final String CREATE_TYPE = "create_type";
	public static final String CREATION_DATE = "creation_date";
	public static final String CURRENT_PASSWORD = "current_password";
	public static final String DATA = "data";
	public static final String DATE = "date";
	public static final String DATE_FORMAT = "date_format";
	public static final String DATETIME_FORMAT = "datetime_format";
	public static final String DATABASE = "database";
	public static final String DEBUG = "debug";
	public static final String DEFAULT = "default";
	public static final String DEFAULTS = "defaults";
	public static final String DEFAULT_LANG = "default_lang";
	public static final String DEFAULT_VIEW = "default_view";
	public static final String DELETE_REFERENCE = "delete_reference";
	public static final String DELETE_SEARCH = "delete_search";
	public static final String DESCRIPTION = "description";
	public static final String DIRECTORY = "directory";
	public static final String DISALLOWED_ATTRIBUTE = "disallowed_attribute";
	public static final String DISALLOWED_CONTENT_TYPE = "disallowed_content_type";
	public static final String DISALLOWED_TAG = "disallowed_tag";
	public static final String DROP_FILTER = "drop_filter";
	public static final String DROPPED_FIELDS = "dropped_fields";
	public static final String DROPPED_INDEXES = "dropped_indexes";
	public static final String DUPLICATE_FIELD = "duplicate_field";
	public static final String DUPLICATE_INDEX = "duplicate_index";
	public static final String EDITOR = "editor";
	public static final String ELEMENT_NOT_FOUND = "element_not_found";
	public static final String EMPTY_AXES_LIST = "empty_axes_list";
	public static final String EMPTY_CURRENT_PASSWORD = "empty_current_password";
	public static final String EMPTY_FIELD = "empty_field";
	public static final String EMPTY_FIELD_NAME = "empty_field_name";
	public static final String EMPTY_ID = "empty_id";
	public static final String EMPTY_INDEX_FIELDS_LIST = "empty_index_fields_list";
	public static final String EMPTY_INDEX_NAME = "empty_index_name";
	public static final String EMPTY_INPUT = "empty_input";
	public static final String EMPTY_NEW_NAME = "empty_new_name";
	public static final String EMPTY_OBJECTS_LIST = "empty_objects_list";
	public static final String EMPTY_PASSWORD = "empty_password";
	public static final String EMPTY_TYPE_NAME = "empty_type_name";
	public static final String EMPTY_TYPES_LIST = "empty_types_list";
	public static final String EMPTY_USER_NAME = "empty_user_name";
	public static final String END_DATE = "end_date";
	public static final String END_TIME = "end_time";
	public static final String ETAG = "etag";
	public static final String EXECUTE_ACTION_TITLE = "execute_action_title";
	public static final String EXISTING_OBJECTS_ACTION = "existing_objects_action";
	public static final String EXISTING_OBJECTS_ACTIONS = "existing_objects_actions";
	public static final String EXISTING_TYPES_ACTION = "existing_types_action";
	public static final String EXISTING_TYPES_ACTIONS = "existing_types_actions";
	public static final String EXPORT = "export";
	public static final String EXTRA_PARAMETERS = "extra_parameters";
	public static final String FALSE = "false";
	public static final String FIELD = "field";
	public static final String FIELD_HAS_NO_ELEMENTS = "field_has_no_elements";
	public static final String FIELD_HAS_NULL_VALUES = "field_has_null_values";
	public static final String FIELD_IS_PART_OF_INDEX = "field_is_part_of_index";
	public static final String FIELD_NAME_TOO_LONG = "field_name_too_long";
	public static final String FIELD_NOT_FOUND = "field_not_found";
	public static final String FIELD_RESERVED_NAME = "field_reserved_name";
	public static final String FIELDS = "fields";
	public static final String FIELDS_ALTERED = "fields_altered";
	public static final String FILE = "file";
	public static final String FILTERS = "filters";
	public static final String FOOTER = "footer";
	public static final String FORM = "form";
	public static final String FORMAT = "format";
	public static final String FULL = "full";
	public static final String FULLTEXT_SEARCH_TYPES = "fulltext_search_types";
	public static final String GROUPS = "groups";
	public static final String HELP = "help";
	public static final String HOST = "host";
	public static final String HTML_ALLOWED_TAGS = "html_allowed_tags";
	public static final String HTTPS_PORT = "https_port";
	public static final String ID = "id";
	public static final String ID_INPUT_SIZE = "id_input_size";
	public static final String ID_NAME = "id_name";
	public static final String ID_TOO_LONG = "id_too_long";
	public static final String IGNORED_OBJECTS = "ignored_objects";
	public static final String IGNORED_TYPES = "ignored_types";
	public static final String IMAGE = "image";
	public static final String IMAGE_ID = "image_id";
	public static final String IMAGE_TYPE = "image_type";
	public static final String IMPORT = "import";
	public static final String IMPORTED_OBJECTS = "imported_objects";
	public static final String IMPORTED_TYPES = "imported_types";
	public static final String INCLUDE_OBJECTS = "include_objects";
	public static final String INCREMENTAL = "incremental";
	public static final String INDEX = "index";
	public static final String INDEX_NAME_TOO_LONG = "index_name_too_long";
	public static final String INDEX_NOT_FOUND = "index_not_found";
	public static final String INDEX_TYPES = "index_types";
	public static final String INDEXES = "indexes";
	public static final String INFO = "info";
	public static final String INPUT_SIZE = "input_size";
	public static final String INSERT_TITLE = "insert_title";
	public static final String INTERVAL = "interval";
	public static final String INVALID_ACTION_NAME = "invalid_action_name";
	public static final String INVALID_BOOLEAN = "invalid_boolean";
	public static final String INVALID_CURRENT_PASSWORD = "invalid_current_password";
	public static final String INVALID_ELEMENT = "invalid_element";
	public static final String INVALID_ELEMENT_NAME = "invalid_element_name";
	public static final String INVALID_EMAIL = "invalid_email";
	public static final String INVALID_FIELD = "invalid_field";
	public static final String INVALID_FIELD_NAME = "invalid_field_name";
	public static final String INVALID_FILTER_TYPE = "invalid_filter_type";
	public static final String INVALID_HOST_NAME = "invalid_host_name";
	public static final String INVALID_ID = "invalid_id";
	public static final String INVALID_IMAGE = "invalid_image";
	public static final String INVALID_INDEX_NAME = "invalid_index_name";
	public static final String INVALID_INPUT = "invalid_input";
	public static final String INVALID_LANG = "invalid_lang";
	public static final String INVALID_NUMERIC = "invalid_numeric";
	public static final String INVALID_OBJECT_INPUT_MODE = "invalid_object_input_mode";
	public static final String INVALID_OBJECT_TYPE = "invalid_object_type";
	public static final String INVALID_OBJECTS_INPUT_MODE = "invalid_objects_input_mode";
	public static final String INVALID_PARAMETERS = "invalid_parameters";
	public static final String INVALID_PASSWORD = "invalid_password";
	public static final String INVALID_ROW_COUNT = "invalid_row_count";
	public static final String INVALID_SERIAL_FORMAT = "invalid_serial_format";
	public static final String INVALID_SESSION = "invalid_session";
	public static final String INVALID_STREAM_FORMAT = "invalid_stream_format";
	public static final String INVALID_TIMEZONE = "invalid_timezone";
	public static final String INVALID_TYPE_NAME = "invalid_type_name";
	public static final String INVALID_TYPE_OR_FIELD_NAME = "invalid_type_or_field_name";
	public static final String INVALID_URL = "invalid_url";
	public static final String INVALID_USER_OR_PASSWORD = "invalid_user_or_password";
	public static final String INVALID_VIEW_NAME = "invalid_view_name";
	public static final String ITEM = "item";
	public static final String ITEMS = "items";
	public static final String JAVASCRIPT_DISABLED_WARNING = "javascript_disabled_warning";
	public static final String LANG = "lang";
	public static final String LANGS = "langs";
	public static final String LANGUAGE = "language";
	public static final String LENGTH = "length";
	public static final String LEVEL = "level";
	public static final String LIMIT = "limit";
	public static final String LIMIT_INCREMENT = "limit_increment";
	public static final String LINK = "link";
	public static final String LIST = "list";
	public static final String LOGIN_PASSWORD = "login_password";
	public static final String LOGIN_TITLE = "login_title";
	public static final String LOGIN_USER = "login_user";
	public static final String LOGO = "logo";
	public static final String LOGO_SIZES = "logo_sizes";
	public static final String LOGO_SRCSET = "logo_srcset";
	public static final String LOGO_TEXT = "logo_text";
	public static final String LOGO_URL = "logo_url";
	public static final String LOGOUT = "logout";
	public static final String LONG_OBJECTS_COUNT = "long_objects_count";
	public static final String MAX_AUTH_ERRORS = "max_auth_errors";
	public static final String MAX_CONNECTIONS = "max_connections";
	public static final String MAX_INSERTS = "max_inserts";
	public static final String MAX_INSERTS_EXCEEDED = "max_inserts_exceeded";
	public static final String MAX_LIMIT = "max_limit";
	public static final String MAX_REQUESTS = "max_requests";
	public static final String MAX_TIME = "max_time";
	public static final String MAX = "max";
	public static final String MENU = "menu";
	public static final String MENUS = "menus";
	public static final String MESSAGE = "message";
	public static final String METHOD_NOT_ALLOWED = "method_not_allowed";
	public static final String MIN_LIMIT = "min_limit";
	public static final String MIN = "min";
	public static final String MISSING_FIELD = "missing_field";
	public static final String MISSING_REFERENCES = "missing_references";
	public static final String MODE = "mode";
	public static final String MODE_ALTERED = "mode_altered";
	public static final String MONTH = "month";
	public static final String NAME = "name";
	public static final String NAMES = "names";
	public static final String NEW_ID = "new_id";
	public static final String NEW_NAME = "new_name";
	public static final String NEW_PASSWORD = "new_password";
	public static final String NEW_PASSWORD_REPEAT = "new_password_repeat";
	public static final String NEXT = "next";
	public static final String NEXT_NODE = "next_node";
	public static final String NEXTTYPES = "nexttypes";
	public static final String NO_OBJECTS_FOUND = "no_objects_found";
	public static final String NO_TYPES_FOUND = "no_types_found";
	public static final String NODES = "nodes";
	public static final String NOT_IMPLEMENTED_METHOD = "not_implemented_method";
	public static final String NOT_NULL = "not_null";
	public static final String NOT_NULL_ALTERED = "not_null_altered";
	public static final String NULL = "null";
	public static final String OBJECT = "object";
	public static final String OBJECT_ALREADY_EXISTS = "object_already_exists";
	public static final String OBJECT_ID_SUCCESSFULLY_UPDATED = "object_id_successfully_updated";
	public static final String OBJECT_INPUT_MODE = "object_input_mode";
	public static final String OBJECT_INPUT_LIMIT = "object_input_limit";
	public static final String OBJECTS_INPUT_MODE = "objects_input_mode";
	public static final String OBJECT_NOT_FOUND = "object_not_found";
	public static final String OBJECT_SUCCESSFULLY_INSERTED = "object_successfully_inserted";
	public static final String OBJECT_SUCCESSFULLY_UPDATED = "object_successfully_updated";
	public static final String OBJECTS = "objects";
	public static final String OBJECTS_DELETE_CONFIRMATION = "objects_delete_confirmation";
	public static final String OBJECTS_INPUT_LIMIT = "objects_input_limit";
	public static final String OBJECTS_INPUT_SIZE = "objects_input_size";
	public static final String OBJECTS_INPUT_NOT_NULL = "objects_input_not_null";
	public static final String OBJECTS_SELECT = "objects_select";
	public static final String OBJECTS_SUCCESSFULLY_DELETED = "objects_successfully_deleted";
	public static final String OBJECTS_SUCCESSFULLY_IMPORTED = "objects_successfully_imported";
	public static final String OFFSET = "offset";
	public static final String OFFSET_TEXT_MODE = "offset_text_mode";
	public static final String OLD_NAME = "old_name";
	public static final String ORDER = "order";
	public static final String OTHER_TYPES = "other_types";
	public static final String OUT_OF_RANGE_VALUE = "out_of_range_value";
	public static final String PARAMETERS = "parameters";
	public static final String PARAMETERS_ALTERED = "parameters_altered";
	public static final String PASSWORD = "password";
	public static final String PASSWORD_FIELD_DEFAULT_VALUE = "password_field_default_value";
	public static final String PASSWORD_FIELD_UPDATE = "password_field_update";
	public static final String PASSWORD_SUCCESSFULLY_UPDATED = "password_successfully_updated";
	public static final String PASSWORDS_DONT_MATCH = "passwords_dont_match";
	public static final String PERMISSIONS = "permissions";
	public static final String POOL = "pool";
	public static final String PORT = "port";
	public static final String PRECISION = "precision";
	public static final String PREFIX = "prefix";
	public static final String PREVIEW = "preview";
	public static final String PREVIEW_TITLE = "preview_title";
	public static final String PREVIOUS = "previous";
	public static final String PRIMITIVE_TYPE_WITH_THE_SAME_NAME = "primitive_type_with_the_same_name";
	public static final String PUB_DATE = "pub_date";
	public static final String QRCODE = "qrcode";
	public static final String RANGE = "range";
	public static final String READ_MORE = "read_more";
	public static final String REF = "ref";
	public static final String REFERENCE = "reference";
	public static final String REFERENCED_TYPE = "referenced_type";
	public static final String REFERENCES = "references";
	public static final String REFERENCING_FIELD = "referencing_field";
	public static final String REFERENCING_TYPE = "referencing_type";
	public static final String REFERRER_POLICY = "referrer_policy";
	public static final String RENAME_TITLE = "rename_title";
	public static final String RENAMED_FIELDS = "renamed_fields";
	public static final String RENAMED_INDEXES = "renamed_indexes";
	public static final String REPEAT = "repeat";
	public static final String SCALE = "scale";
	public static final String SEARCH = "search";
	public static final String SELECT_STRING_NOT_FOUND = "select_string_not_found";
	public static final String SELECT_TITLE = "select_title";
	public static final String SESSION = "session";
	public static final String SESSION_EXPIRED = "session_expired";
	public static final String SESSION_PARAMETER_NOT_FOUND = "session_parameter_not_found";
	public static final String SETTINGS = "settings";
	public static final String SETTINGS_DIRECTORY = "settings_directory";
	public static final String SHOW_CONTROL_PANEL = "show_control_panel";
	public static final String SHOW_HEADER = "show_header";
	public static final String SHOW_ID = "show_id";
	public static final String SHOW_INSERT_FORM_BUTTON = "show_insert_form_button";
	public static final String SHOW_PREVIEW = "show_preview";
	public static final String SHOW_PROGRESS = "show_progress";
	public static final String SHOW_RANGE = "show_range";
	public static final String SHOW_TYPE = "show_type";
	public static final String SHOW_VALIDATORS = "show_validators";
	public static final String SIGNATURE = "signature";
	public static final String SIZE = "size";
	public static final String START_DATE = "start_date";
	public static final String START_TIME = "start_time";
	public static final String STATIC = "static";
	public static final String STYLE = "style";
	public static final String SUCCESSFUL_LOGIN = "successful_login";
	public static final String SUCCESSFUL_LOGOUT = "successful_logout";
	public static final String SUMMARY = "summary";
	public static final String SYSTEM_TYPES_CANT_BE_DROPPED = "system_types_cant_be_dropped";
	public static final String TASKS = "tasks";
	public static final String TEMPLATE = "template";
	public static final String TEMPLATES = "templates";
	public static final String TEXT = "text";
	public static final String THUMBNAIL = "thumbnail";
	public static final String TIME_FORMAT = "time_format";
	public static final String TITLE = "title";
	public static final String TRUE = "true";
	public static final String TYPE = "type";
	public static final String TYPE_ALREADY_EXISTS = "type_already_exists";
	public static final String TYPE_ALREADY_HAS_OBJECTS = "type_already_has_objects";
	public static final String TYPE_ALTERED = "type_altered";
	public static final String TYPE_HAS_NO_BINARY_FIELDS = "type_has_no_binary_fields";
	public static final String TYPE_NAME = "type_name";
	public static final String TYPE_NAME_TOO_LONG = "type_name_too_long";
	public static final String TYPE_NOT_ALTERED = "type_not_altered";
	public static final String TYPE_NOT_FOUND = "type_not_found";
	public static final String TYPE_OR_FIELD_NAME_TOO_LONG = "type_or_field_name_too_long";
	public static final String TYPE_RESERVED_NAME = "type_reserved_name";
	public static final String TYPE_SUCCESSFULLY_ALTERED = "type_successfully_altered";
	public static final String TYPE_SUCCESSFULLY_CREATED = "type_successfully_created";
	public static final String TYPE_SUCCESSFULLY_RENAMED = "type_successfully_renamed";
	public static final String TYPES = "types";
	public static final String TYPES_DROP_CONFIRMATION = "types_drop_confirmation";
	public static final String TYPES_SUCCESSFULLY_DROPPED = "types_successfully_dropped";
	public static final String UDATE = "udate";
	public static final String UNAUTHORIZED_ACTION = "unauthorized_action";
	public static final String UNAUTHORIZED_REFERENCE = "unauthorized_reference";
	public static final String UNEXPECTED_TAG = "unexpected_tag";
	public static final String UPDATE_ID_TITLE = "update_id_title";
	public static final String UPDATE_PASSWORD_TITLE = "update_password_title";
	public static final String UPDATE_TITLE = "update_title";
	public static final String UPDATED_OBJECTS = "updated_objects";
	public static final String UPDATING_DATE = "updating_date";
	public static final String USER = "user";
	public static final String USER_CERTIFICATE = "user_certificate";
	public static final String USER_NOT_LOGGED_IN = "user_not_logged_in";
	public static final String USERS = "users";
	public static final String VALUE = "value";
	public static final String VERSION = "version";
	public static final String VIEW = "view";
	public static final String VIEW_NOT_FOUND = "view_not_found";
	public static final String VIEWS = "views";
	public static final String VIRUS_FOUND = "virus_found";
	public static final String WEBDAV = "webdav";
	public static final String XML_ALLOWED_TAGS = "xml_allowed_tags";
	public static final String YEAR = "year";
}