<?php
date_default_timezone_set("America/New_York");
$envContent = file_get_contents('../.env');
$conf = fopen("../config/config.php", "w") or die("Unable to open config file!");

$lines = explode("\n", $envContent);
$configArray = [];

foreach ($lines as $line) {
    if (empty($line) || strpos($line, '#') === 0) {
        continue;
    }

    $parts = explode('=', $line, 2); 
    $key = trim($parts[0] ?? '');
    $value = trim(trim($parts[1] ?? '', '\'"'));
    if(empty($key)) continue;

    $keys = explode('.', $key);
    $nestedConfigReference = &$configArray;

    foreach ($keys as $nestedKey) {
        if (!isset($nestedConfigReference[$nestedKey])) {
            $nestedConfigReference[$nestedKey] = [];
        }

        $nestedConfigReference = &$nestedConfigReference[$nestedKey];
    }
    $nestedConfigReference = $value;
}

$configContent = '<?php
/**
 * This file is automatically generated at ' . 
date('Y/m/d') . ' [ ' . date("h:i:s") . (date("A") == 'AM' ? ' PM' : ' AM') . ' ] 
 *
 */'
. PHP_EOL . PHP_EOL;
$configContent .= 'return ' . var_export($configArray, true) . ';' . PHP_EOL;

fwrite($conf, $configContent);
fclose($conf);