# Markers

**Markers** can be placed and referenced at any point during a score, and in any
instrument part. e.g. `%chorus` will place a marker called "chorus" at the
current offset, and then using `@chorus` at any point will set the current
[offset](offset.md) to that of the "chorus" marker.

A marker cannot be referenced before it is placed -- for example, the following
score will result in an error:

```alda
piano:
  @someMarkerThatDoesntExistYet
  c8 d e f g2

guitar:
  r1
  %someMarkerThatDoesntExistYet
```

Instead, the placement of the marker must occur before the marker is referenced:

```alda
guitar:
  r1
  %existingMarker

piano:
  @existingMarker
  c8 d e f g2
```

## Acceptable Marker Names

Marker names follow the same rules as [instrument
names](scores-and-parts.md#acceptable-names).

