# Alda: The Docs™

This is the landing page for Alda's official documentation. If you've come here to learn more about Alda and how to use it to write amazing musical scores, READ ON!

## Useful Links

* [The official Alda website](https://alda.io)
* [Community](https://alda.io/community)
* [Contributing to Alda](../CONTRIBUTING.md)
* [CHANGELOG (release notes)](../CHANGELOG.md)
* [Dave's 2015 manifesto about text-based music composition](https://blog.djy.io/alda-a-manifesto-and-gentle-introduction)
* Writing music with Alda blog series:
  1. [Your first notes](https://blog.djy.io/writing-music-with-alda-1/)
  2. [Rhythm and meter](https://blog.djy.io/writing-music-with-alda-2/)
  3. [Flats, sharps, and key signatures](https://blog.djy.io/writing-music-with-alda-3/)
* [Alda 2 migration guide](alda-2-migration-guide.md)

## Where to Start

* [Installing Alda](https://alda.io/install)

* [Installing a good soundfont](installing-a-good-soundfont.md)

* [Editor plugins](editor-plugins.md)

* [The Alda tutorial](https://alda.io/tutorial)

* The article on [scores and parts](scores-and-parts.md) provides some good general information on what an Alda score is. After that, you may be interested in learning more about the fundamental pieces of an Alda score:
  * [notes](notes.md)
  * [rests](rests.md)
  * [chords](chords.md)
  * [voices](voices.md)
  * [markers](markers.md)
  * [offset](offset.md)
  * [attributes](attributes.md)
  * [repeats](repeats.md)
  * [variables](variables.md)
  * [cram expressions](cram-expressions.md)

* Peruse this list of [available instruments](list-of-instruments.md).

## How to Use the Docs

Alda's documentation is a (mostly) interconnected collection of [Markdown](https://daringfireball.net/projects/markdown) files that serve as the "official manual" to Alda: the definitive guide to how to do all the things you want to do in an Alda score.

In as many places as it makes sense to do so, relative links are included from one document to another. It's a lot like a [wiki](https://en.wikipedia.org/wiki/Wiki); it is versioned and maintained by the maintainers of the Alda project itself, with help from the community (that's you!). Alda's documentation is a perpetual work-in-progress, and a collaborative effort in which anyone can take part.

If you're one of those know-it-all types who likes to know everything about everything, then you may want to [browse the entire docs folder](./). Or, you can just pick an article and start reading, click whatever links catch your eye, and see where the night takes you. Whatever you wanna do, man -- I won't judge you; I'm just a landing page.

If, in the course of reading these docs, you stumble upon something that you think could be improved (even if it's just a tiny little typo), you notice that some information is incorrect or missing, or you're just plain confused about something, please feel free to [submit a Pull Request](https://github.com/alda-lang/alda/pulls) or [file an issue](https://github.com/alda-lang/alda/issues) to help us improve our documentation. Don't be shy!
