# 反复(repeat)

*此页面翻译自[Repeats](../repeats.md)*

[音符](notes_zh_cn.md) [序列](sequences_zh_cn.md)和其他类型的事件可以**反复**任意次数 只需要附加`*`和一个数字即可 您可以在事件与`*`和`*`与重复次数之间添加空格 但是这个是可选的(不添加也可以)

例如:

```alda
piano:
  # 对单个音符做反复
  c *4 c2 *2

  # 对包含音符和八度变化的序列做反复
  [c8 d e >]*3
```

## 变奏

Alda语言有一项功能 可以实现西方音乐符号中常见的["替代结尾"](http://dictionary.onmusic.org/terms/4798-second_ending_735)

*译者注: 在我学音乐的时候 这种符号通常是标记1 2 3这样的数字的线框 老师称其为1房子 2房子...*

```alda
piano:
  [ c8 d e f
    [g f e4]'1-3
    [g a b > c4.]'4
  ]*4
```

这可以对乐句做反复 并且每次反复时都可以不同 在上面的例子中 每次反复都是以`c8 d e f`开头 在第1到3次反复中 乐句以`g f e4`结尾 而在第4次时 乐句以`g a b > c4`结尾

请注意 这些更改可以在反复乐句中的任何地方发生 不一定是在结尾 所以Alda这一功能比乐谱中的"替代结尾"符号更灵活 下面的例子中的乐句具有所谓的"替代开头"和"替代中部"

```alda
piano:
  [ [c8 d e]'1,3 [e8 d c]'2,4
    f
    [g f e]'1-3 [g a b]'4
    > c <
  ]*4
```


