# 音符

*本页面翻译自[Notes](../notes.md)*

Alda的**音符**深受[MML](https://en.wikipedia.org/wiki/Music_Macro_Language#Modern_MML)的启发

## 组件

### 八度组

西方音乐理论将音高分为12个音符的重复组(十二平均律) 例如: (升序的) `c c# d d# e f f# g g# a a# b (高八度) c c# d`等等

音名(如C#)与八度的组合决定了音符的频率 八度组用数字表示 通常在1到7之间 它们对应于[科学音高记号](https://zh.wikipedia.org/wiki/%E7%A7%91%E5%AD%A6%E9%9F%B3%E9%AB%98%E8%AE%B0%E5%8F%B7)(也称国际音高记号)

例如 中央C与A440都在第4个八度组中 这也是Alda中默认的八度组

与MML一样 八度组与音符本身是分开设置的--八度组不是"附加"于音符 而是每个音符都查看当前的八度组来确定自己的音高

您可以用这两种方式设置八度组:

`o5` 将八度组设置为5 任何整数都可以跟在`o`后面

`<` 将当前八度组减少1. `>`将当前八度组增加1.

### 时值

在Alda中 音符的时值通常以标准音乐符号中的音符长度表示 与MML一样

它以数字形式表示 4是四分音符 2是二分音符 1是全音符 等等

音符后面可以添加任意数量的点`.` 它代表附点 与标准音乐符号相同--它会将音符的时值延长到其原先时值的1.5倍(也就是延长其一半的时值)

例如

```
2 = 二分音符 2拍
2. = 附点二分音符 3拍(2 * 1.5)
2.. = 复附点二分音符 3.5拍(2 * 1.5 + (2 * 0.5 * 0.5))
```

*译者注: 当一个音符有复附点时 每次附的点所延长的时值是上一个点所延长的时值的一半*

音符时值也可以用连音线语法`~`相加 例如: `4~4` = 两个四分音符加在一起 总共2拍

当音符在乐谱中按顺序解析时 Alda会跟踪当前八度组和当前默认的音符时值 每当您指定新的八度组和音符时值时 那些数据会被设为新的默认值

如果您没有指定音符的时值 则每个音符都将遵循默认的初始时值 在每个乐器部分的开头 默认的八度组为4 默认的音符时值为4(即四分音符 1拍)

#### 高级节奏

* Alda的一个特殊功能是您可以使用非标准的数字(非2的幂)作为音符的时值标记 例如 6表示在4/4拍中持续1/6小节的音符 在标准的符号中 没有"六分音符" 但是这个音符的时值通常表示为四分音符三连音中的一个音符 但在Alda中 "六分音符"不一定是三连音的一部分 这为创造更多有趣的节奏创造了可能性

* 扩展这个概念--Alda允许非整数的十进制音符时值标记

  例如 `c0.5`(或是西方古典符号中的双全音符)是`c1`(全音符)时值的两倍

  这些数字不必是2的幂 例如 `c2.4`也是有效的

* Alda还有一种指定节奏的替代方法 称为[cram表达式](cram-expressions_zh_cn.md)

* 音符时值也可以用毫秒(ms)和秒(s)表示 可以随意混搭标准音符长度:

  ```alda
  c350ms    # 持续350毫秒的C音符
  d2s       # 持续2秒的D音符
  e2s~200ms # 持续2秒+200毫秒的E音符
  f300ms~4. # 持续300毫秒+附点四分音符的F音符
  ```

### 音符格式

在Alda中 一个音符的格式为:
从a到g的一个字母 任意数量的临时变音记号(可选) 音符时值标记(可选)

降号和升号可以使音高降低/升高半音 在Alda中 降号和升号可以表示为`-`和`+` 您也可以使用多个升号或降号 甚至可以把它们组合起来 例如 `c++` = 双升号C = D

*对于非C大调的乐曲*(*译者举例*) 可能会出现这样的情况: 在每个不在C调上的音符上放置升/降号 我们更推荐您使用[调号](attributes_zh_cn.md#key-signature调号) 这可以为每个需要的音符预设必要的升/降号以匹配调性 您可以参考下文中的示例

要覆盖预设调号指定的降号/升号 您可以添加一个临时变音记号 即`+` `-`可以使音符升调或降调 还有`_`代表还原号 它会强制音符为自然音 例如`c_`是C自然音 无论您在之前的预设中改变了哪个音名的升降号

## 示例

以下是1个八度的B大调音阶 从第4组开始上升和下降

```alda
o4 b4 > c+8 d+ e f+ g+ a+ b4
a+8 g+ f+ e d+ c+ < b2.
```

这是同一个示例 在开头处预设了B大调中被升高的那些那些音名 这样就可以避免在乐谱中重复写升降号 它们会自动以您定义的升降号演奏

```alda
(key-signature "f+ c+ g+ d+ a+")
o4 b4 > c8 d e f g a b4
a8 g f e d c < b2.
```

