# 属性

*此页面翻译自[Attributes](../attributes.md)*

**属性(attribute)** 定义了[乐器](scores-and-parts_zh_cn.md)(或多个乐器)演奏[音符](notes_zh_cn.md)时的某些特质

## 设置属性值

与设置[八度组](notes_zh_cn.md#八度组)一样 设置后的属性将对该乐器所有将奏响的音符生效 直到该属性再次更改(事实上 `octave`(八度组)也是一个可以设置的属性)

不同的属性采用不同类型的值 通常 值是介于0和100的数值 但是也有例外情况

### 例子

```alda
(volume 50)
```

```alda
(quant 85)
```

```alda
(octave 'up)
```

```alda
(tempo 240)
```

```alda
(key-signature "f+ c+ g+")
```

请参阅[下文](#属性列表) 了解编写乐谱时可用的属性类型和更多信息

## 单类乐器 vs. 全局

默认情况下 属性的更改仅适用于您当前正在使用的乐器 例如 在包含四种乐器的乐谱中:

```alda
violin "violin-1":
  o4 f2   g4 a   b-2   a

violin "violin-2":
  o4 c2   e4 f   f2    f

viola:
  o3 a2 > c4 c   d2    c

cello:
  o3 f2   c4 f < b-2 > f
```

更改属性只会影响到您当前正在编辑的部分乐器

```alda
violin "violin-1":
  o4 f2   g4 a   b-2   a

violin "violin-2":
  o4 c2   e4 f   f2    f

viola:
  o3 a2 > c4 c   d2    c

cello:
  (volume 75)
  o3 f2   c4 f < b-2 > f
```

要**全局**地更改属性 (即为乐谱中每种乐器设置该属性) 请在属性名称后面添加感叹号`!`

```alda
violin "violin-1":
  (tempo! 80)
  o4 f2   g4 a   b-2   a

violin "violin-2":
  o4 c2   e4 f   f2    f

viola:
  o3 a2 > c4 c   d2    c

cello:
  o3 f2   c4 f < b-2 > f
```

在乐谱开头(编写乐器部分之前) 您也可以设置全局的属性 这些属性会在一开始就作用于所有的乐器

```alda
(tempo! 80)

violin "violin-1":
  o4 f2   g4 a   b-2   a

violin "violin-2":
  o4 c2   e4 f   f2    f

viola:
  o3 a2 > c4 c   d2    c

cello:
  o3 f2   c4 f < b-2 > f
```

## 属性列表

### `duration`(音长)

* **缩写:** (无)

* **说明:** 如果未指定 则表示音符的长度 例如 `c4`明确表示为四分音符 `c`的音符长度等于乐器的`duration`属性值

  请注意 这个属性更像是实现细节 因为每当您在音符上指定音符时值时 乐器的默认音符时值都会隐式地设置 您可能永远不会直接用到这个属性

  值得一提的是: 如果您确实需要直接设置持续时间属性 则您使用的方法应该是`set-duration` *而不是* `duration`

* **值:** 可以是:
  - 节拍数 (例如2.5 代表附点二分音符) 或
  - 毫秒数

  如果您给的值是数值 它将会被解释为节拍数

  请注意 此值与音符时值不同 例如 要将音符的时值设为四分音符 则此值应为`1` 而不是`4` 因为四分音符为1拍

  ```alda
  (set-duration 1)
  ```

  要将音长指定为音符时值(分数表示) 可以使用`set-note-length` 例如 `1`代表全音符

  ```alda
  (set-note-length 1)
  ```

  要将音符的时值指定为毫秒数 请使用`set-duration-ms`:

  ```alda
  (set-duration-ms 2000)
  ```

* **初始值:** `(note-length 4)` 即四分音符 或1拍

### `key-signature`(调号)

* **缩写:** `key-sig`

* **描述:** [一组升号或降号](https://en.wikipedia.org/wiki/Key_signature)当音名被设置了调号 且在乐谱中那个(些)音名的音符不包含临时变音记号时 调号就会默认作用于那些音符 例如 如果在调号中包含了升G(`g+`) 则乐谱中`g`音符将默认变为`g+` 除非在音符后面放置临时变音记号 即`g-`(降G音) 或`g_`(自然G音)

* **值:** 可以是:
  * 音名与临时变音记号的关联列表 例如`'(f (sharp) c (sharp) g (sharp))`
    *译者注: 这样的列表前面是有一个`'`号的 请不要漏写*
  * 字符串 如`"f+ c+ g+"`, 或
  * 列表 如 `'(a major)` 或 `'(e flat minor)`
    * 支持的音阶/调式:
      * `ionian` (`major`) 
      * `dorian`
      * `phrygian`
      * `lydian`
      * `mixolydian`
      * `aeolian` (`minor`)
      * `locrian`

* **初始值:** `'()` (空列表 不会对任何音名进行升调/降调)

### `octave`(八度组)

* **缩写:** (无)

* **描述:** 音符的八度 (请注意 Alda还有设置特定八度组的内置语法 例如`o5` 及将当前八度组向上移动一个的`>`和向下移动一个的`<`

* **Value:** 要么是代表[科学音高记号](https://en.wikipedia.org/wiki/Scientific_pitch_notation)中八度组的数字 要么是表示将当前八度组上移或下移一个的符号 `'up` 或 `'down`

* **初始值:** 4

### `panning` (声像)

* **缩写:** `pan`

* **描述:** 音符在扬声器中的空间位置 (向左/右平移多少)

* **Value:** 0-100之间的数值 最左为0 最右为100 中间为50

* **初始值:** 50

### `quantization` (量化)

* **缩写:** `quant`, `quantize`

* **描述:** 音符完整时长的百分比
  设置较低的`quantization`值意味着音符之间有更多空隙 它们听起来更像是*断奏* 而较高的量化值会使音符之间空隙更小 听起来更像是*连奏*

* **值:** 0-100之间的数值

* **初始值:** 90

### `tempo` (节奏)

* **缩写:** (无)

* **描述:** 音符的演奏速度 这个值与音符时值结合使用 以确定以毫秒为单位的演奏时间

* **值:** 表示[曲速](https://zh.wikipedia.org/wiki/%E9%80%9F%E5%BA%A6_(%E9%9F%B3%E6%A8%82))的每分钟节拍数(BPM)

* **初始值:** 120

> 默认情况下 `(tempo 100)`将把节奏设置为每分钟100拍 其中每个节拍占四分音符的长度
> Alda还提供了表示节奏的其他方式 请参阅[节奏](tempo_zh_cn.md)

### `track-volume`(音轨音量)

* **缩写:** `track-vol`

* **描述:** 乐器的总音量
  对于MIDI乐器 这对应音轨的音量 通常 您会在乐谱开头设置一次`track-volume`(不设置也可以的) 然后在后面使用`volume`更精细地控制音符之间的音量(如有疑问 可以只使用`volume`!)

* **值:** 0到100之间的数值

* **初始值:** 78.7 (这个值来源于100/127 这是MIDI的默认音轨音量 至少在JVM中是这样的)

### `transposition` (移调)

* **缩写:** `transpose`

* **描述:** 将所有音符向上/下移动指定的半音数
  此属性能使[移调乐器](https://zh.wikipedia.org/wiki/%E7%A7%BB%E8%B0%83%E4%B9%90%E5%99%A8)的编写更方便

* **值:** 一个整数(可以是正的或负的) 表示将每个音符向上或向下移动的半音数

* **初始值:** 0

### `volume` (音量/力度)

* **缩写:** `vol`

* **描述:** 音符的力度大小
  对于MIDI乐器 这对应于每个音符的*力度* 这不仅与音符的音量大小相关 还与音符的演奏强度相关 具体细节因细节而异 通常 它会影响音符开头的音调锐度

* **值:** 0到100之间的数值

* **初始值:** 54 (对应 `(mf)` 标记)

### 动态标记

* **描述:** 除了直接设置音符的音量外 您还可以指定动态标记 这些标记对应于符合MIDI标准的固定音量

* **可用的标记:**

  | 动态标记 | 匹配音量   |
  |-----------------|-------------------|
  | `(pppppp)`      | `(vol 1)`         |
  | `(ppppp)`       | `(vol 8)`         |
  | `(pppp)`        | `(vol 16)`        |
  | `(ppp)`         | `(vol 24)`        |
  | `(pp)`          | `(vol 31)`        |
  | `(p)`           | `(vol 39)`        |
  | `(mp)`          | `(vol 46)`        |
  | `(mf)`          | `(vol 54)`        |
  | `(f)`           | `(vol 62)`        |
  | `(ff)`          | `(vol 69)`        |
  | `(fff)`         | `(vol 77)`        |
  | `(ffff)`        | `(vol 85)`        |
  | `(fffff)`       | `(vol 92)`        |
  | `(ffffff)`      | `(vol 100)`       |

* **初始值:** `(mf)` (对应音量为54)

### `midi-channel` (MIDI通道)

* **缩写:** (无)

* **描述:** 默认情况下 Alda会自动为每个部分分配一个可用的MIDI通道 在极少数情况下 如果您想要控制每个部分使用哪个MIDI通道 则可以使用此属性分配特定的MIDI通道 如果需要 还可以在同一部分中多次执行此操作以切换到不同的通道

* **值:** 0到15之间的整数
  请注意 通道9是打击乐器的保留通道 如果您在非打击乐部分中包含`(midi-channel 9)` 则会引发错误

* **初始值:** _(未设置 默认情况下 MIDI通道会自动由Alda分配)_

