'use strict';
(self.webpackChunkmy_docs = self.webpackChunkmy_docs || []).push([
  [519],
  {
    6646: (e, n, i) => {
      i.r(n),
        i.d(n, {
          assets: () => h,
          contentTitle: () => s,
          default: () => j,
          frontMatter: () => d,
          metadata: () => c,
          toc: () => o,
        });
      var t = i(5893),
        l = i(1151),
        r = i(51);
      const d = {
          sidebar_position: 4,
          sidebar_label: 'SaturationSlider',
          description: 'A slider for adjusting the color saturation channel in the HSV color space.',
        },
        s = '<SaturationSlider />',
        c = {
          id: 'API/Sliders/HSB/SaturationSlider',
          title: '<SaturationSlider />',
          description: 'A slider for adjusting the color saturation channel in the HSV color space.',
          source: '@site/docs/API/Sliders/HSB/SaturationSlider.mdx',
          sourceDirName: 'API/Sliders/HSB',
          slug: '/API/Sliders/HSB/SaturationSlider',
          permalink: '/reanimated-color-picker/docs/API/Sliders/HSB/SaturationSlider',
          draft: !1,
          unlisted: !1,
          tags: [],
          version: 'current',
          sidebarPosition: 4,
          frontMatter: {
            sidebar_position: 4,
            sidebar_label: 'SaturationSlider',
            description: 'A slider for adjusting the color saturation channel in the HSV color space.',
          },
          sidebar: 'tutorialSidebar',
          previous: { title: 'BrightnessSlider', permalink: '/reanimated-color-picker/docs/API/Sliders/HSB/BrightnessSlider' },
          next: { title: 'HSL', permalink: '/reanimated-color-picker/docs/category/hsl' },
        },
        h = {},
        o = [
          {
            value: 'A slider for adjusting the color saturation channel in the HSV color space.',
            id: 'a-slider-for-adjusting-the-color-saturation-channel-in-the-hsv-color-space',
            level: 3,
          },
          { value: 'Props', id: 'props', level: 2 },
          { value: '<code>adaptSpectrum</code>', id: 'adaptspectrum', level: 3 },
        ];
      function a(e) {
        const n = {
          code: 'code',
          h1: 'h1',
          h2: 'h2',
          h3: 'h3',
          img: 'img',
          li: 'li',
          p: 'p',
          ul: 'ul',
          ...(0, l.a)(),
          ...e.components,
        };
        return (0, t.jsxs)(t.Fragment, {
          children: [
            (0, t.jsx)(n.h1, { id: 'saturationslider-', children: (0, t.jsx)(n.code, { children: '<SaturationSlider />' }) }),
            '\n',
            (0, t.jsx)(n.p, {
              children: (0, t.jsx)(n.img, { alt: 'saturation', src: i(9967).Z + '', width: '256', height: '40' }),
            }),
            '\n',
            (0, t.jsxs)(n.ul, {
              children: [
                '\n',
                (0, t.jsxs)(n.li, {
                  children: [
                    '\n',
                    (0, t.jsx)(n.h3, {
                      id: 'a-slider-for-adjusting-the-color-saturation-channel-in-the-hsv-color-space',
                      children: 'A slider for adjusting the color saturation channel in the HSV color space.',
                    }),
                    '\n',
                  ],
                }),
                '\n',
              ],
            }),
            '\n',
            (0, t.jsx)(n.h2, { id: 'props', children: 'Props' }),
            '\n',
            (0, t.jsx)(n.h3, { id: 'adaptspectrum', children: (0, t.jsx)(n.code, { children: 'adaptSpectrum' }) }),
            '\n',
            (0, t.jsxs)(n.ul, {
              children: [
                '\n',
                (0, t.jsx)(n.li, {
                  children: 'Slider background color spectrum adapts to changes in saturation and brightness.',
                }),
                '\n',
                (0, t.jsx)(n.li, { children: (0, t.jsx)(n.code, { children: 'type: boolean' }) }),
                '\n',
                (0, t.jsx)(n.li, { children: (0, t.jsx)(n.code, { children: 'default: false' }) }),
                '\n',
              ],
            }),
            '\n',
            '\n',
            '\n',
            (0, t.jsx)(r.ZP, {}),
          ],
        });
      }
      function j(e = {}) {
        const { wrapper: n } = { ...(0, l.a)(), ...e.components };
        return n ? (0, t.jsx)(n, { ...e, children: (0, t.jsx)(a, { ...e }) }) : a(e);
      }
    },
    435: (e, n, i) => {
      i.d(n, { ZP: () => d });
      var t = i(5893),
        l = i(1151);
      function r(e) {
        const n = {
          code: 'code',
          h3: 'h3',
          h4: 'h4',
          li: 'li',
          pre: 'pre',
          table: 'table',
          tbody: 'tbody',
          td: 'td',
          th: 'th',
          thead: 'thead',
          tr: 'tr',
          ul: 'ul',
          ...(0, l.a)(),
          ...e.components,
        };
        return (0, t.jsxs)(t.Fragment, {
          children: [
            (0, t.jsx)(n.h3, { id: 'renderthumb', children: (0, t.jsx)(n.code, { children: 'renderThumb' }) }),
            '\n',
            (0, t.jsxs)(n.ul, {
              children: [
                '\n',
                (0, t.jsxs)(n.li, {
                  children: [
                    'Function which receives ',
                    (0, t.jsx)(n.code, { children: 'ThumbProps' }),
                    ' and returns a custom thumb component.',
                  ],
                }),
                '\n',
                (0, t.jsxs)(n.li, { children: ['Overrides ', (0, t.jsx)(n.code, { children: 'thumbShape' })] }),
                '\n',
              ],
            }),
            '\n',
            (0, t.jsx)(n.h4, { id: 'thumbprops', children: (0, t.jsx)(n.code, { children: 'ThumbProps' }) }),
            '\n',
            (0, t.jsxs)(n.table, {
              children: [
                (0, t.jsx)(n.thead, {
                  children: (0, t.jsxs)(n.tr, {
                    children: [
                      (0, t.jsx)(n.th, { style: { textAlign: 'center' }, children: 'Prop' }),
                      (0, t.jsx)(n.th, { style: { textAlign: 'center' }, children: 'Type' }),
                      (0, t.jsx)(n.th, { style: { textAlign: 'left' }, children: 'Description' }),
                    ],
                  }),
                }),
                (0, t.jsxs)(n.tbody, {
                  children: [
                    (0, t.jsxs)(n.tr, {
                      children: [
                        (0, t.jsx)(n.td, {
                          style: { textAlign: 'center' },
                          children: (0, t.jsx)(n.code, { children: 'positionStyle' }),
                        }),
                        (0, t.jsx)(n.td, {
                          style: { textAlign: 'center' },
                          children: (0, t.jsx)(n.code, { children: 'StyleProp' }),
                        }),
                        (0, t.jsx)(n.td, {
                          style: { textAlign: 'left' },
                          children:
                            'This style determines the position of the thumb and is a crucial element that should be included.',
                        }),
                      ],
                    }),
                    (0, t.jsxs)(n.tr, {
                      children: [
                        (0, t.jsx)(n.td, { style: { textAlign: 'center' }, children: (0, t.jsx)(n.code, { children: 'width' }) }),
                        (0, t.jsx)(n.td, {
                          style: { textAlign: 'center' },
                          children: (0, t.jsx)(n.code, { children: 'number' }),
                        }),
                        (0, t.jsxs)(n.td, {
                          style: { textAlign: 'left' },
                          children: [
                            'Extracted from the ',
                            (0, t.jsx)(n.code, { children: 'thumbSize' }),
                            " prop and it's important for thumb position calculation.",
                          ],
                        }),
                      ],
                    }),
                    (0, t.jsxs)(n.tr, {
                      children: [
                        (0, t.jsx)(n.td, {
                          style: { textAlign: 'center' },
                          children: (0, t.jsx)(n.code, { children: 'height' }),
                        }),
                        (0, t.jsx)(n.td, {
                          style: { textAlign: 'center' },
                          children: (0, t.jsx)(n.code, { children: 'number' }),
                        }),
                        (0, t.jsxs)(n.td, {
                          style: { textAlign: 'left' },
                          children: [
                            'Extracted from the ',
                            (0, t.jsx)(n.code, { children: 'thumbSize' }),
                            " prop and it's important for thumb position calculation.",
                          ],
                        }),
                      ],
                    }),
                    (0, t.jsxs)(n.tr, {
                      children: [
                        (0, t.jsx)(n.td, {
                          style: { textAlign: 'center' },
                          children: (0, t.jsx)(n.code, { children: 'adaptiveColor' }),
                        }),
                        (0, t.jsx)(n.td, {
                          style: { textAlign: 'center' },
                          children: (0, t.jsx)(n.code, { children: 'SharedValue<string>' }),
                        }),
                        (0, t.jsx)(n.td, {
                          style: { textAlign: 'left' },
                          children: 'White or black based on the contrast ratio.',
                        }),
                      ],
                    }),
                    (0, t.jsxs)(n.tr, {
                      children: [
                        (0, t.jsx)(n.td, {
                          style: { textAlign: 'center' },
                          children: (0, t.jsx)(n.code, { children: 'currentColor' }),
                        }),
                        (0, t.jsx)(n.td, {
                          style: { textAlign: 'center' },
                          children: (0, t.jsx)(n.code, { children: 'SharedValue<string>' }),
                        }),
                        (0, t.jsx)(n.td, {
                          style: { textAlign: 'left' },
                          children: 'This shared value will update whenever the color changes.',
                        }),
                      ],
                    }),
                    (0, t.jsxs)(n.tr, {
                      children: [
                        (0, t.jsx)(n.td, {
                          style: { textAlign: 'center' },
                          children: (0, t.jsx)(n.code, { children: 'initialColor' }),
                        }),
                        (0, t.jsx)(n.td, {
                          style: { textAlign: 'center' },
                          children: (0, t.jsx)(n.code, { children: 'string' }),
                        }),
                        (0, t.jsxs)(n.td, {
                          style: { textAlign: 'left' },
                          children: ['The initial color value as a ', (0, t.jsx)(n.code, { children: 'string' }), '.'],
                        }),
                      ],
                    }),
                  ],
                }),
              ],
            }),
            '\n',
            (0, t.jsxs)(n.ul, { children: ['\n', (0, t.jsx)(n.li, { children: 'Example Usage:' }), '\n'] }),
            '\n',
            (0, t.jsx)(n.pre, {
              children: (0, t.jsx)(n.code, {
                className: 'language-tsx',
                children:
                  "import Animated, { useAnimatedStyle } from 'react-native-reanimated';\nimport type { RenderThumbProps } from 'reanimated-color-picker';\n\nfunction MyCustomThumb({ width, height, positionStyle, adaptiveColor, currentColor, initialColor }: RenderThumbProps) {\n  const animatedStyle = useAnimatedStyle(() => ({\n    borderColor: adaptiveColor.value,\n    backgroundColor: currentColor.value,\n  }));\n\n  return (\n    <Animated.View\n      style={[{ width, height, borderWidth: 1, borderRadius: width / 2, overflow: 'hidden' }, animatedStyle, positionStyle]}\n    >\n      <View style={{ backgroundColor: initialColor, width: '50%', height, alignSelf: 'flex-end' }} />\n    </Animated.View>\n  );\n}\n",
              }),
            }),
          ],
        });
      }
      function d(e = {}) {
        const { wrapper: n } = { ...(0, l.a)(), ...e.components };
        return n ? (0, t.jsx)(n, { ...e, children: (0, t.jsx)(r, { ...e }) }) : r(e);
      }
    },
    51: (e, n, i) => {
      i.d(n, { ZP: () => s });
      var t = i(5893),
        l = i(1151),
        r = i(435);
      function d(e) {
        const n = {
            admonition: 'admonition',
            code: 'code',
            h3: 'h3',
            img: 'img',
            li: 'li',
            mdxAdmonitionTitle: 'mdxAdmonitionTitle',
            p: 'p',
            strong: 'strong',
            ul: 'ul',
            ...(0, l.a)(),
            ...e.components,
          },
          { Shapes: d } = n;
        return (
          d ||
            (function (e, n) {
              throw new Error(
                'Expected ' +
                  (n ? 'component' : 'object') +
                  ' `' +
                  e +
                  '` to be defined: you likely forgot to import, pass, or provide it.',
              );
            })('Shapes', !0),
          (0, t.jsxs)(t.Fragment, {
            children: [
              (0, t.jsx)(n.h3, { id: 'boundedthumb', children: (0, t.jsx)(n.code, { children: 'boundedThumb' }) }),
              '\n',
              (0, t.jsx)(n.p, {
                children: (0, t.jsx)(n.img, { alt: 'boundedThumb', src: i(2737).Z + '', width: '180', height: '130' }),
              }),
              '\n',
              (0, t.jsxs)(n.ul, {
                children: [
                  '\n',
                  (0, t.jsx)(n.li, {
                    children:
                      'Determines whether the slider thumb (or handle) should be constrained to stay within the boundaries of the slider.',
                  }),
                  '\n',
                  (0, t.jsxs)(n.li, {
                    children: [
                      'When set to ',
                      (0, t.jsx)(n.code, { children: 'true' }),
                      ', the thumb will not be allowed to move beyond the edges of the slider.',
                    ],
                  }),
                  '\n',
                  (0, t.jsxs)(n.li, {
                    children: [
                      'When set to ',
                      (0, t.jsx)(n.code, { children: 'false' }),
                      ', part of it will be outside of the slider bounds.',
                    ],
                  }),
                  '\n',
                  (0, t.jsx)(n.li, { children: (0, t.jsx)(n.code, { children: 'type: boolean' }) }),
                  '\n',
                  (0, t.jsx)(n.li, { children: (0, t.jsx)(n.code, { children: 'default: false' }) }),
                  '\n',
                ],
              }),
              '\n',
              (0, t.jsx)(n.h3, { id: 'thumbsize', children: (0, t.jsx)(n.code, { children: 'thumbSize' }) }),
              '\n',
              (0, t.jsxs)(n.ul, {
                children: [
                  '\n',
                  (0, t.jsx)(n.li, { children: "The size of the slider's thumb." }),
                  '\n',
                  (0, t.jsx)(n.li, { children: (0, t.jsx)(n.code, { children: 'type: number' }) }),
                  '\n',
                  (0, t.jsx)(n.li, { children: (0, t.jsx)(n.code, { children: 'default: 35' }) }),
                  '\n',
                ],
              }),
              '\n',
              (0, t.jsx)(n.h3, { id: 'thumbcolor', children: (0, t.jsx)(n.code, { children: 'thumbColor' }) }),
              '\n',
              (0, t.jsxs)(n.ul, {
                children: [
                  '\n',
                  (0, t.jsx)(n.li, { children: "The color of the slider's thumb." }),
                  '\n',
                  (0, t.jsx)(n.li, { children: (0, t.jsx)(n.code, { children: 'type: string' }) }),
                  '\n',
                  (0, t.jsx)(n.li, { children: (0, t.jsx)(n.code, { children: 'default: interactive*' }) }),
                  '\n',
                ],
              }),
              '\n',
              (0, t.jsxs)(n.admonition, {
                type: 'info',
                children: [
                  (0, t.jsx)(n.mdxAdmonitionTitle, { children: (0, t.jsx)(n.strong, { children: '*interactive' }) }),
                  (0, t.jsxs)(n.ul, {
                    children: [
                      '\n',
                      (0, t.jsx)(n.li, {
                        children:
                          'The color of the thumb will be adjusted according to the contrast ratio, in the absence of a specific color value.',
                      }),
                      '\n',
                    ],
                  }),
                ],
              }),
              '\n',
              (0, t.jsx)(n.h3, { id: 'sliderthickness', children: (0, t.jsx)(n.code, { children: 'sliderThickness' }) }),
              '\n',
              (0, t.jsxs)(n.ul, {
                children: [
                  '\n',
                  (0, t.jsxs)(n.li, {
                    children: [
                      'The thickness is the ',
                      (0, t.jsx)(n.code, { children: 'width' }),
                      ' of the slider in ',
                      (0, t.jsx)(n.code, { children: 'vertical' }),
                      ' mode or the ',
                      (0, t.jsx)(n.code, { children: 'height' }),
                      ' in ',
                      (0, t.jsx)(n.code, { children: 'horizontal' }),
                      ' mode.',
                    ],
                  }),
                  '\n',
                  (0, t.jsx)(n.li, { children: (0, t.jsx)(n.code, { children: 'type: number' }) }),
                  '\n',
                  (0, t.jsx)(n.li, { children: (0, t.jsx)(n.code, { children: 'default: 25' }) }),
                  '\n',
                ],
              }),
              '\n',
              (0, t.jsx)(n.h3, { id: 'thumbshape', children: (0, t.jsx)(n.code, { children: 'thumbShape' }) }),
              '\n',
              (0, t.jsxs)(n.ul, {
                children: [
                  '\n',
                  (0, t.jsx)(n.li, { children: "The shape and appearance of the slider's thumb." }),
                  '\n',
                  (0, t.jsx)(n.li, { children: (0, t.jsx)(n.code, { children: 'type: string' }) }),
                  '\n',
                  (0, t.jsx)(n.li, { children: (0, t.jsx)(n.code, { children: "default: 'ring'" }) }),
                  '\n',
                  (0, t.jsxs)(n.li, { children: [(0, t.jsx)(n.code, { children: 'values:' }), (0, t.jsx)(d, {})] }),
                  '\n',
                ],
              }),
              '\n',
              (0, t.jsx)(n.h3, { id: 'thumbstyle', children: (0, t.jsx)(n.code, { children: 'thumbStyle' }) }),
              '\n',
              (0, t.jsxs)(n.ul, {
                children: [
                  '\n',
                  (0, t.jsx)(n.li, { children: "Thumb's containing View's style." }),
                  '\n',
                  (0, t.jsx)(n.li, { children: (0, t.jsx)(n.code, { children: 'type: ViewStyle' }) }),
                  '\n',
                ],
              }),
              '\n',
              (0, t.jsx)(n.h3, { id: 'thumbinnerstyle', children: (0, t.jsx)(n.code, { children: 'thumbInnerStyle' }) }),
              '\n',
              (0, t.jsxs)(n.ul, {
                children: [
                  '\n',
                  (0, t.jsx)(n.li, { children: "Thumb's inner View(s) style." }),
                  '\n',
                  (0, t.jsx)(n.li, { children: (0, t.jsx)(n.code, { children: 'type: ViewStyle' }) }),
                  '\n',
                ],
              }),
              '\n',
              (0, t.jsx)(n.h3, {
                id: 'thumbscaleanimationvalue',
                children: (0, t.jsx)(n.code, { children: 'thumbScaleAnimationValue' }),
              }),
              '\n',
              (0, t.jsxs)(n.ul, {
                children: [
                  '\n',
                  (0, t.jsx)(n.li, { children: 'Controls the scale value animation of the thumb when active.' }),
                  '\n',
                  (0, t.jsx)(n.li, { children: (0, t.jsx)(n.code, { children: 'type: number' }) }),
                  '\n',
                  (0, t.jsx)(n.li, { children: (0, t.jsx)(n.code, { children: 'default: 1.2' }) }),
                  '\n',
                ],
              }),
              '\n',
              (0, t.jsx)(n.h3, {
                id: 'thumbscaleanimationduration',
                children: (0, t.jsx)(n.code, { children: 'thumbScaleAnimationDuration' }),
              }),
              '\n',
              (0, t.jsxs)(n.ul, {
                children: [
                  '\n',
                  (0, t.jsx)(n.li, { children: 'Sets the duration of the scale animation of the thumb when active.' }),
                  '\n',
                  (0, t.jsx)(n.li, { children: (0, t.jsx)(n.code, { children: 'type: number' }) }),
                  '\n',
                  (0, t.jsx)(n.li, { children: (0, t.jsx)(n.code, { children: 'default: 100' }) }),
                  '\n',
                ],
              }),
              '\n',
              '\n',
              '\n',
              (0, t.jsx)(r.ZP, {}),
              '\n',
              (0, t.jsx)(n.h3, { id: 'reverse', children: (0, t.jsx)(n.code, { children: 'reverse' }) }),
              '\n',
              (0, t.jsxs)(n.ul, {
                children: [
                  '\n',
                  (0, t.jsx)(n.li, { children: 'Reverse the slider direction.' }),
                  '\n',
                  (0, t.jsx)(n.li, { children: (0, t.jsx)(n.code, { children: 'type: boolean' }) }),
                  '\n',
                  (0, t.jsx)(n.li, { children: (0, t.jsx)(n.code, { children: 'default: false' }) }),
                  '\n',
                ],
              }),
              '\n',
              (0, t.jsx)(n.h3, { id: 'vertical', children: (0, t.jsx)(n.code, { children: 'vertical' }) }),
              '\n',
              (0, t.jsxs)(n.ul, {
                children: [
                  '\n',
                  (0, t.jsx)(n.li, { children: 'Change the slider orientation.' }),
                  '\n',
                  (0, t.jsx)(n.li, { children: (0, t.jsx)(n.code, { children: 'type: boolean' }) }),
                  '\n',
                  (0, t.jsx)(n.li, { children: (0, t.jsx)(n.code, { children: 'default: false' }) }),
                  '\n',
                ],
              }),
              '\n',
              (0, t.jsx)(n.h3, { id: 'gestures', children: (0, t.jsx)(n.code, { children: 'gestures' }) }),
              '\n',
              (0, t.jsxs)(n.ul, {
                children: [
                  '\n',
                  (0, t.jsxs)(n.li, {
                    children: [
                      'An array of gestures or composed gestures from ',
                      (0, t.jsx)(n.code, { children: 'react-native-gesture-handler' }),
                      '.',
                    ],
                  }),
                  '\n',
                  (0, t.jsx)(n.li, { children: 'These gestures will run simultaneously with the color picker gestures.' }),
                  '\n',
                  (0, t.jsx)(n.li, { children: (0, t.jsx)(n.code, { children: 'type: Gesture[]' }) }),
                  '\n',
                  (0, t.jsx)(n.li, { children: (0, t.jsx)(n.code, { children: 'default: []' }) }),
                  '\n',
                ],
              }),
              '\n',
              (0, t.jsx)(n.h3, { id: 'style', children: (0, t.jsx)(n.code, { children: 'style' }) }),
              '\n',
              (0, t.jsxs)(n.ul, {
                children: [
                  '\n',
                  (0, t.jsx)(n.li, { children: "The style of the slider's container." }),
                  '\n',
                  (0, t.jsx)(n.li, { children: (0, t.jsx)(n.code, { children: 'type: ViewStyle' }) }),
                  '\n',
                ],
              }),
              '\n',
              (0, t.jsx)(n.admonition, {
                title: 'note',
                type: 'info',
                children: (0, t.jsxs)(n.ul, {
                  children: ['\n', (0, t.jsx)(n.li, { children: 'Certain style properties will be overridden.' }), '\n'],
                }),
              }),
            ],
          })
        );
      }
      function s(e = {}) {
        const { wrapper: n } = { ...(0, l.a)(), ...e.components };
        return n ? (0, t.jsx)(n, { ...e, children: (0, t.jsx)(d, { ...e }) }) : d(e);
      }
    },
    2737: (e, n, i) => {
      i.d(n, { Z: () => t });
      const t =
        'data:image/png;base64,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';
    },
    9967: (e, n, i) => {
      i.d(n, { Z: () => t });
      const t =
        'data:image/png;base64,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';
    },
    1151: (e, n, i) => {
      i.d(n, { Z: () => s, a: () => d });
      var t = i(7294);
      const l = {},
        r = t.createContext(l);
      function d(e) {
        const n = t.useContext(r);
        return t.useMemo(
          function () {
            return 'function' == typeof e ? e(n) : { ...n, ...e };
          },
          [n, e],
        );
      }
      function s(e) {
        let n;
        return (
          (n = e.disableParentContext
            ? 'function' == typeof e.components
              ? e.components(l)
              : e.components || l
            : d(e.components)),
          t.createElement(r.Provider, { value: n }, e.children)
        );
      }
    },
  },
]);
