/*
   GHCJS bignum library for integer-gmp package

   uses JavaScript arrays for big numbers
   some algorithms and code based on JSBN by Tom Wu

   Copyright Luite Stegeman 2016
 */








// values defined in Gen2.ClosureInfo







// thread status

/*
 * low-level heap object manipulation macros
 */
// GHCJS.Prim.JSVal







// GHCJS.Prim.JSException





// Exception dictionary for JSException


// SomeException






// GHC.Ptr.Ptr






// GHC.Integer.GMP.Internals
// Data.Maybe.Maybe




// #define HS_NOTHING h$nothing






// Data.List
// Data.Text




// Data.Text.Lazy





// black holes
// can we skip the indirection for black holes?






// resumable thunks


// general deconstruction



// retrieve  a numeric value that's possibly stored as an indirection



// generic lazy values
// generic data constructors and selectors
// unboxed tuple returns
// #define RETURN_UBX_TUP1(x) return x;

// #define GHCJSBN_TRACE_INTEGER 1


// bits per limb




// BI_FP = 52
// BI_FP - GHCJSBN_BITS

// 2*GHCJSBN_BITS - BI_FP

// 2 ^ BI_FP


// values for the Haskell Ordering enum




var h$ghcjsbn_zero_i = (h$c1(h$integerzmgmpZCGHCziIntegerziTypeziSzh_con_e, (0)));;
var h$ghcjsbn_one_i = (h$c1(h$integerzmgmpZCGHCziIntegerziTypeziSzh_con_e, (1)));;
var h$ghcjsbn_negOne_i = (h$c1(h$integerzmgmpZCGHCziIntegerziTypeziSzh_con_e, (-1)));;
var h$ghcjsbn_null_b = [-1];
var h$ghcjsbn_zero_b = [0];
var h$ghcjsbn_one_b = [1, 1];
var h$ghcjsbn_two31_b = [2, 0, 8];
var h$ghcjsbn_czero_b = [2, 268435455, 15];
var h$ghcjsbn_two31_i = (h$c1(h$integerzmgmpZCGHCziIntegerziTypeziJpzh_con_e, (h$ghcjsbn_two31_b)));;
var h$ghcjsbn_negTwo31_i = (h$c1(h$integerzmgmpZCGHCziIntegerziTypeziSzh_con_e, (-2147483648)));;

/******************************************************************************

 Types used here:
   - b BigNat:  array of limbs (each a number of GHCJSBN_BITS bits)
   - s Int:     small integer in range -2^31 .. 2^31-1
   - w Word:    small integer in range 0 .. 2^32-1,
                  values greater than 2^31-1 are stored as negative numbers
   - i Integer: Haskell Integer heap object, see invariants

 Integer invariants:
   - BigNat arrays do not have leading zeroes
   - Jp > S > Jn
   - S range: -2^31 .. 2^31-1 (-2147483648 .. 2147483647)

 ******************************************************************************/
// checks that the S,Jn,Jp constructor invariants hold
function h$ghcjsbn_assertValid_i(b, msg) {
  var sd, d, neg, i, n;
  // check global constants for unwanted mutations
  if(h$ghcjsbn_zero_b.length !== 1 || h$ghcjsbn_zero_b[0] !== 0) {
    throw new Error("zero_b mutated");
  }
  if(h$ghcjsbn_one_b.length !== 2 || h$ghcjsbn_one_b[0] !== 1 || h$ghcjsbn_one_b[1] !== 1) {
    throw new Error("one_b mutated");
  }
  if(((b).f === h$integerzmgmpZCGHCziIntegerziTypeziSzh_con_e)) {
    sd = ((b).d1);
    if(typeof sd !== 'number')
      throw new Error("invalid small integer: not a number");
    if((sd|0) !== sd)
      throw new Error("invalid small integer: not a small int");
  } else {
    if(((b).f === h$integerzmgmpZCGHCziIntegerziTypeziJpzh_con_e)) {
      neg = false;
    } else if(((b).f === h$integerzmgmpZCGHCziIntegerziTypeziJnzh_con_e)) {
      neg = true;
    } else {
      throw new Error("invalid integer: unexpected constructor");
    }
    d = ((b).d1);
    h$ghcjsbn_assertValid_b(d, "assertValid_i");
    if(d[0] < 2)
      throw new Error("invalid big integer: array too short");
    if(d[0] === 2) {
      if((d[2] >> (31-28)) === 0 ||
         (neg && d[2] === 0x20 && d[1] === 0))
        throw new Error("invalid big integer: in smallint range");
    }
    // everything ok
  }
}

// checks invariant for big number
function h$ghcjsbn_assertValid_b(d, msg) {
  var i, n;
  if(!Array.isArray(d))
    throw new Error("invalid big integer: not an array");




  if(typeof d[0] !== 'number' || d[0] > (d.length-1))
    throw new Error("invalid big integer: incorrect number of limbs");
  if(d[0] > 0 && d[d[0]] === 0)
    throw new Error("invalid big integer: leading zero");
  for(i = 1; i <= d[0]; i++) {
    n = d[i];
    if(typeof n !== 'number')
      throw new Error("invalid big integer: limb is not a number");
    if((n & 0xfffffff) !== n)
      throw new Error("invalid big integer: limb out of range");
  }
}

function h$ghcjsbn_assertValid_s(s, msg) {
  if(typeof s !== 'number')
    throw new Error("invalid int: not a number");



  if((s|0) !== s)
    throw new Error("invalid int: not in smallint range");
}

function h$ghcjsbn_assertValid_w(w, msg) {
  if(typeof w !== 'number')
    throw new Error("invalid word: not a number");



  if((w|0) !== w)
    throw new Error("invalid word: not in smallint range");
}

function h$ghcjsbn_assertValid_d(d, msg) {
  if(typeof d !== 'number')
    throw new Error("invalid double: not a number");



}
/******************************************************************************/

///////////////////////////////////////////////////////////////////////////////
// the ghcjsbn_r functions operate on the raw array data directly
///////////////////////////////////////////////////////////////////////////////



var h$ghcjsbn_smallPrimes =
 [ 2, 3, 5, 7, 11, 13, 17, 19, 23, 29, 31, 37, 41, 43, 47
 , 53, 59, 61, 67, 71, 73, 79, 83, 89, 97, 101, 103, 107, 109, 113
 , 127, 131, 137, 139, 149, 151, 157, 163, 167, 173, 179, 181, 191, 193, 197
 , 199, 211, 223, 227, 229, 233, 239, 241, 251, 257, 263, 269, 271, 277, 281
 , 283, 293, 307, 311, 313, 317, 331, 337, 347, 349, 353, 359, 367, 373, 379
 , 383, 389, 397, 401, 409, 419, 421, 431, 433, 439, 443, 449, 457, 461, 463
 , 467, 479, 487, 491, 499, 503, 509, 521, 523, 541, 547, 557, 563, 569, 571
 , 577, 587, 593, 599, 601, 607, 613, 617, 619, 631, 641, 643, 647, 653, 659
 , 661, 673, 677, 683, 691, 701, 709, 719, 727, 733, 739, 743, 751, 757, 761
 , 769, 773, 787, 797, 809, 811, 821, 823, 827, 829, 839, 853, 857, 859, 863
 , 877, 881, 883, 887, 907, 911, 919, 929, 937, 941, 947, 953, 967, 971, 977
 , 983, 991, 997
 ];

var h$ghcjsbn_smallPrimesM = null;

function h$ghcjsbn_getSmallPrimesM() {
  var a, i;
  if(h$ghcjsbn_smallPrimesM === null) {
    a = [];
    for(i = 0; i < 1008; i++) {
      a[i] = false;
    }
    for(i = h$ghcjsbn_smallPrimes.length - 1; i >= 0; i--) {
      a[h$ghcjsbn_smallPrimes[i]] = true;
    }
    h$ghcjsbn_smallPrimesM = a;
  }
  return h$ghcjsbn_smallPrimesM;
}


// Int -> Int -> Bool
// fixme: seed
function h$ghcjsbn_isPrime_s(s, rounds) {
  if(s < 2 || (s > 2 && ((s&1) === 1))) return false;
  if(s <= 1008) {
    return h$ghcjsbn_getSmallPrimesM()[s];
  }
  throw new Error("isPrime_s");
}

// BigNat -> Int -> Bool
// fixme: seed
function h$ghcjsbn_isPrime_b(b, rounds) {
  h$ghcjsbn_assertValid_b(b, "isPrime");
  throw new Error("isPrime_b");
}

// BigNat -> BigNat -> Bool
/*
function h$ghcjsbn_eq_bb(b1, b2) {
  ASSERTVALID_B(b1, "eq_bb b1");
  ASSERTVALID_B(b2, "eq_bb b2");
  var l1 = b1.length, l2 = b2.length;
  if(l1 !== l2) return false;
  while(--l1 >= 0) {
    if(b1[l1] !== b2[l1]) return false;
  }
  return true;
}
*/

// BigNat -> BigNat -> Int (Ordering: LT,EQ,GT)
function h$ghcjsbn_cmp_bb(b1, b2) {
  h$ghcjsbn_assertValid_b(b1, "cmp_bb b1");
  h$ghcjsbn_assertValid_b(b2, "cmp_bb b2");
  var l1 = b1[0], l2 = b2[0], d1, d2;
  if(l1 === l2) {
    while(--l1 >= 0) {
      d1 = b1[l1+1];
      d2 = b2[l1+1];
      if(d1 !== d2) return d1 < d2 ? 0 : 2;
    }
    return 1;
  } else {
    return l1 > l2 ? 2 : 0;
  }
}

// fixed size tmp, these should not grow
var h$ghcjsbn_tmp_2a = [0, 0, 0];
var h$ghcjsbn_tmp_2b = [0, 0, 0];

// this is variable size scratch space
var h$ghcjsbn_tmp_a = [0, 0, 0, 0, 0, 0, 0, 0];
var h$ghcjsbn_tmp_b = [0, 0, 0, 0, 0, 0, 0, 0];

// b - w :: BigNat -> Word -> BigNat

function h$ghcjsbn_sub_bw(b, w) {
  var a = h$ghcjsbn_tmp_2a;
  h$ghcjsbn_toBigNat_w(a, w);
  return h$ghcjsbn_sub_bb(b, a);
}

// b - s :: BigNat -> Int -> BigNat
// returns new BigNat, nullBigNat in case of underflow
// returns size of t
function h$ghcjsbn_sub_bs(b, s) {
  h$ghcjsbn_assertValid_b(b, "sub_bs");
  h$ghcjsbn_assertValid_s(s, "sub_bs");
  var a, ms, r;
  if(s < 0) {
    if(s === -2147483648) {
      r = h$ghcjsbn_add_bb(b, h$ghcjsbn_two31_b);
    } else {
      a = h$ghcjsn_tmp_2a;
      h$ghcjsbn_toBigNat_s(a, -s);
      r = h$ghcjsbn_add_bb(b, a);
    }
  } else {
    a = h$ghcjsn_tmp_2a;
    h$ghcjsbn_toBigNat_s(a, s);
    r = h$ghcjsbn_sub_bb(b, a);
  }
  h$ghcjsbn_assertValid_b(r, "sub_bs result");
  return r;
}

// t = b + w :: BigNat -> BigNat -> Word -> Int
// returns size of t
function h$ghcjsbn_add_bw(b, w) {
  h$ghcjsbn_assertValid_b(b, "add_bw");
  h$ghcjsbn_assertValid_w(w, "add_bw");
  var a = h$ghcjsbn_tmp_2a;
  h$ghcjsbn_toBigNat_w(a, w);
  return h$ghcjsbn_add_bb(b, a);
}

// t = b + s :: BigNat -> BigNat -> Int -> Int
// returns size of t, nullBigNat in case of underflow
function h$ghcjsbn_add_bs(b, s) {
  h$ghcjsbn_assertValid_b(b, "add_bs");
  h$ghcjsbn_assertValid_s(s, "add_bs");
  var a, ms, r;
  if(s < 0) {
    if(s === -2147483648) {
      r = h$ghcjsbn_sub_bb(b, h$ghcjsbn_two31_r);
    } else {
      ms = -s;
      a = h$ghcjsbn_tmp_2a;
      h$ghcjsbn_toBigNat_s(a, ms);
      r = h$ghcjsbn_sub(b, a);
    }
  } else {
    a = h$ghcjsbn_tmp_2a;
    h$ghcjsbn_toBigNat_s(a, s);
    r = h$ghcjsbn_add_bb(b, a);
  }
  h$ghcjsbn_assertValid_b(r, "add_bs result");
  return r;
}

// t = b1 + b2 :: BigNat -> BigNat -> BigNat -> Int
// returns size of t
function h$ghcjsbn_add_bb(b1, b2) {
  h$ghcjsbn_assertValid_b(b1, "add_bb b1");
  h$ghcjsbn_assertValid_b(b2, "add_bb b2");
  var i, c = 0, l1 = b1[0], l2 = b2[0], t = [0];
  var bl, lmin, lmax;
  if(l1 <= l2) {
    lmin = l1;
    lmax = l2;
    bl = b2;
  } else {
    lmin = l2;
    lmax = l1;
    bl = b1;
  }
  for(i=1;i<=lmin;i++) {
    c += b1[i] + b2[i];
    t[i] = c & 0xfffffff;
    c >>= 28;
  }
  for(i=lmin+1;i<=lmax;i++) {
    c += bl[i];
    t[i] = c & 0xfffffff;
    c >>= 28;
  }
  if(c !== 0) t[++lmax] = c;
  t[0] = lmax;
  h$ghcjsbn_assertValid_b(t, "add_bb result");
  return t;
}

// b1 += b2 :: BigNat -> BigNat -> Int
// returns new size of b1
function h$ghcjsbn_addTo_bb(b1, b2) {
  h$ghcjsbn_assertValid_b(b1, "addTo_bb b1");
  h$ghcjsbn_assertValid_b(b2, "addTo_bb b2");
  var i, c = 0, l1 = b1[0], l2 = b2[0];
  if(l2 > l1) {
    for(i = l1 + 1; i <= l2; i++) {
      b1[i] = 0;
    }
    l1 = l2;
  }
  for(i = 1; i <= l2; i++) {
    c += b1[i] + b2[i];
    b1[i] = c & 0xfffffff;
    c >>= 28;
  }
  // propagate carry as long as needed
  for(i = l2 + 1; c !== 0 && i <= l1; i++) {
    c += b1[i];
    b1[i] = c & 0xfffffff;
    c >>= 28;
  }
  if(c !== 0) {
    b1[l1] = c;
    b1[0] = l1+1;
  } else {
    b1[0] = l1;
  }
  h$ghcjsbn_assertValid_b(b1, "addTo_bb result");
}

// b1 - b2 :: BigNat -> BigNat -> BigNat
// returns a new BigNat, nullBigNat in case of underflow
function h$ghcjsbn_sub_bb(b1, b2) {
  h$ghcjsbn_assertValid_b(b1, "sub_bb b1");
  h$ghcjsbn_assertValid_b(b2, "sub_bb b2");
  if(h$ghcjsbn_cmp_bb(b1,b2) === 0) {
    return [];
  } else {
    var i, c = 0, l1 = b1[0], l2 = b2[0], t = [0];
    for(i = 1; i <= l2; i++) {
      c += b1[i] - b2[i];
      t[i] = c & 0xfffffff;
      c >>= 28;
    }
    for(i = l2 + 1; i <= l1; i++) {
      c += b1[i];
      t[i] = c & 0xfffffff;
      c >>= 28;
    }
    while(l1 > 0 && t[l1] === 0) l1--;
    t[0] = l1;
    h$ghcjsbn_assertValid_b(t, "sub_bb result");
    return t;
  }
}

// b1 -= b2 :: BigNat -> BigNat -> Int
// returns size of t, b1 must be >= b2
function h$ghcjsbn_subTo_bb(b1, b2) {
  h$ghcjsbn_assertValid_b(b1, "subTo_bb b1");
  h$ghcjsbn_assertValid_b(b2, "subTo_bb b2");

  if(h$ghcjsbn_cmp_bb(b1, b2) === 0) {
    throw new Error("h$ghcjsbn_subTo_bb assertion failed: b1 >= b2");
  }

  var i, c = 0, l1 = b1[0], l2 = b2[0];
  for(i = 1; i <= l2; i++) {
    c += b1[i] - b2[i];
    b1[i] = c & 0xfffffff;
    c >>= 28;
  }
  for(i = l2 + 1; c !== 0 && i <= l1; i++) {
    c += b1[i];
    b1[i] = c & 0xfffffff;
    c >>= 28;
  }
  while(l1 > 0 && b1[l1] === 0) l1--;
  b1[0] = l1;
  h$ghcjsbn_assertValid_b(b1, "subTo_bb result");
}

// t = b1 / b2, BigNat -> BigNat -> BigNat -> Int (returns size of t)
/* function h$ghcjsbn_div_bb(t, b1, b2) {

}

// t = b1 % b2, BigNat -> BigNat -> BigNat -> Int (returns size of t)
function h$ghcjsbn_mod_bb(t, b1, b2) {

}

// b % s, BigNat -> Int -> Int
function h$ghcjsbn_mod_bs(b, s) {

}
*/
// BigNat -> Integer (nonnegative, known length)
/*
function h$ghcjsbn_wrap_pl(b, l) {
  var lb;
  if(l === 0) {
    return MK_INTEGER_S(0);
  } else if(l === 1) {
    return MK_INTEGER_S(b[0]);
  } else if(l === 2 && (b[1] >> (31 - GHCJSBN_BITS)) === 0) {
    return MK_INTEGER_S((b[1] << GHCJSBN_BITS)|b[0]);
  } else {
    lb = b.length - l;
    while(lb-- > 0) b.pop();
    return MK_INTEGER_Jp(b);
  }
}
*/
// BigNat -> Integer (nonnegative)
function h$ghcjsbn_wrap_p(b) {
  var l = b[0];
  if(l === 0) {
    return (h$c1(h$integerzmgmpZCGHCziIntegerziTypeziSzh_con_e, (0)));;
  } else if(l === 1) {
    return (h$c1(h$integerzmgmpZCGHCziIntegerziTypeziSzh_con_e, (b[1])));;
  } else if(l === 2 && (b[2] >> (31 - 28)) === 0) {
    return (h$c1(h$integerzmgmpZCGHCziIntegerziTypeziSzh_con_e, ((b[2] << 28)|b[1])));;
  } else {
    return (h$c1(h$integerzmgmpZCGHCziIntegerziTypeziJpzh_con_e, (b)));;
  }
}
/*
function h$ghcjsbn_wrap_nl(b, l) {
  var lb;
  if(l === 0) {
    return MK_INTEGER_S(0);
  } else if(l === 1) {
    return MK_INTEGER_S(-b[0]);
  } else if(l === 2 &&
            ((b[1] >> (31 - GHCJSN_BITS)) === 0 ||
             (b[1] === (1 << (31 - GHCJSBN_BITS)) && b[0] === 0))) {
    return MK_INTEGER_S((-b[1]-b[0])|0);
  } else {
    lb = b.length - l;
    while(lb-- > 0) b.pop();
    return MK_INTEGER_Jn(b);
  }
}
*/
// BigNat -> Integer (nonnegative)
function h$ghcjsbn_wrap_n(b) {
  var l = b[0];
  if(l === 0) {
    return (h$c1(h$integerzmgmpZCGHCziIntegerziTypeziSzh_con_e, (0)));;
  } else if(l === 1) {
    return (h$c1(h$integerzmgmpZCGHCziIntegerziTypeziSzh_con_e, (-b[1])));;
  } else if(l === 2 &&
            ((b[2] >> (31 - GHCJSN_BITS)) === 0 ||
             (b[2] === (1 << (31 - 28)) && b[1] === 0))) {
    return (h$c1(h$integerzmgmpZCGHCziIntegerziTypeziSzh_con_e, ((-b[2]-b[1])|0)));;
  } else {
    return (h$c1(h$integerzmgmpZCGHCziIntegerziTypeziJnzh_con_e, (b)));;
  }
}

// b1 *= b2 :: BigNat -> BigNat -> IO ()
function h$ghcjsbn_mulTo_bb(b1, b2) {
  h$ghcjsbn_assertValid_b(b1, "mulTo_bb b1");
  h$ghcjsbn_assertValid_b(b2, "mulTo_bb b2");
  var t = h$ghcjsbn_mul_bb(b1, b2);
  h$ghcjsbn_copy(b1, t);
  h$ghcjsbn_assertValid_b(b1, "mulTo_bb result");
}

// b1 * b2 ::  BigNat -> BigNat -> BigNat
function h$ghcjsbn_mul_bb(b1, b2) {
  h$ghcjsbn_assertValid_b(b1, "mul_bb b1");
  h$ghcjsbn_assertValid_b(b2, "mul_bb b2");
  var l1 = b1[0], l2 = b2[0];
/*  if(l1 > 50 && l2 > 50) {
    return h$ghcjsbn_mul_karatsuba_bb(b1, b2);
  } fixme update this */
  var n = l1 + l2, i, t = [0];
  for(i = 1; i <= n; i++) t[i] = 0;
  if(l1 > l2) {
    for(i = 0; i < l2; i++) {
      t[i + l1 + 1] = h$ghcjsbn_mul_limb(0, b1, b2[i+1], t, i, 0, l1);
    }
  } else {
    for(i = 0; i < l1; i++) {
      t[i + l2 + 1] = h$ghcjsbn_mul_limb(0, b2, b1[i+1], t, i, 0, l2);
    }
  }
  for(i = l1 + l2; i > 0 && t[i] === 0; i--);
  t[0] = i;
  h$ghcjsbn_assertValid_b(t, "mul_bb result");
  return t;
}

function h$ghcjsbn_mul_bw(b, w) {
  h$ghcjsbn_assertValid_b(b, "mul_bw");
  h$ghcjsbn_assertValid_w(w, "mul_bw");
  var a = h$ghcjsbn_tmp_2a;
  h$ghcjsbn_toBigNat_w(a, w);
  var t = h$ghcjsbn_mul_bb(b, a);
  h$ghcjsbn_assertValid_b(t, "mul_bw result");
  return t;
}


// karatzuba multiplication for long numbers
function h$ghcjsbn_mul_karatsuba_bb(t, b1, b2) {
  throw new Error("not yet updated");
  var l1 = b1.length, l2 = b2.length;
  var i, b = (l1 < l2 ? l1 : l2) >> 1;
  var x0 = [b], x1 = [l1-b], y0 = [b], y1 = [l2-b];
  for(i = 1; i <= b; i++) {
    x0[i] = b1[i];
    y0[i] = b2[i];
  }
  for(i = b + 1; i <= l1; i++) x1[i - b] = b1[i];
  for(i = b + 1; i <= l2; i++) y1[i - b] = b2[i];
  var z0 = h$ghcjsbn_mul_bb(x0, y0), z1, z2 = h$ghcjsbn_mul_bb(x1, y1);

  // compute z1 = (x1 + x0)(y1 + y0) - z2 - z0
  // (reusing x0 and y0 for (x1 + x0) and (y1 + y0))
  h$ghcjsbn_addTo_bb(x0, x1);
  h$ghcjsbn_addTo_bb(y0, x1);
  z1 = h$ghcjsbn_mul_bb(x0, y0);
  h$ghcjsbn_subTo_bb(z1, z2);
  h$ghcjsbn_subTo_bb(z1, z0);
  // store shifted z2 in t
  // fixme this looks wrong
  for(i = 0; i < 2*b; i++) t[i] = 0;
  l2 = z2.length;
  for(i = 0; i < l2; i++) t[i+2*b] = z2[i];
  // compute shifted z1s = z1 * B
  var z1s = [];
  l1 = z1.length;
  for(i = 0; i < b; i++) z1s[i] = 0;
  for(i = 0; i < l1; i++) z1s[i+b] = z1[i];
  // add the results so that t = z2 * (2*B) + z1 * B + z0
  h$ghcjsbn_addTo_bb(t, z1s);
  h$ghcjsbn_addTo_bb(t, z0);
  return t;
}

// from JSBN am3
// w_j += (x*b_i) ?
/* c = carry?
   n = iterations?
 */

function h$ghcjsbn_mul_limb(i,b,x,w,j,c,n) {
  // ASSERTVALID_B(b, "mul_limb b");
  // ASSERTVALID_B(w, "mul_limb w");
  var xl = x & 0x3fff, xh = x >> 14;
  while(--n >= 0) {
    var l = b[++i] & 0x3fff;
    var h = b[i] >> 14;
    var m = xh * l + h * xl;
    l = xl *l + ((m & 0x3fff) << 14) + w[++j] + c;
    c = (l >> 28) + (m >> 14) + xh * h;
    // h$log("mul_limb: c: " + c + " l: " + l + " xh: " + xh + " h: " + h);
    w[j] = l & 0xfffffff;
  }
  return c;
}




// q = b1 / b2, r = b1 % b2 :: BigNat -> BigNat -> BigNat -> BigNat -> Int
// b2 must be > 0
// returns length of r
// d is normalized before return

/*
   algorithm:
 y = 0?
 nsh = number of leading zeroes in most significant word
 pm = positive modulus
 pt = positive divident
 y = tmp, shifted modulus
 r = shifted divident
 ys = length of y
 y0 = biggest limb of y
 yt = new estimated length of y?
 */

function h$ghcjsbn_quotRem_bb(q, r, b1, b2) {
  h$ghcjsbn_assertValid_b(b1, "quotRem_bb b1");
  h$ghcjsbn_assertValid_b(b2, "quotRem_bb b2");

  if(h$ghcjsbn_cmp_bw(b2, 0) !== 2) {
    throw new Error("h$ghcjsbn_quotRem_bb: operand not positive");
  }

  if(q === null) q = h$ghcjsbn_tmp_a;
  if(r === null) r = h$ghcjsbn_tmp_b;
  var l1 = b1[0], l2 = b2[0], nsh, y = [];
  if(l1 === 0) {
    q[0] = 0;
    r[0] = 0;
    return;
  }
  if(h$ghcjsbn_cmp_bb(b1,b2) === 0) {
    q[0] = 0;
    h$ghcjsbn_copy(r, b1);
    return;
  }
  nsh = 28 -h$ghcjsbn_nbits_s(b2[l2]);
  h$ghcjsbn_assertValid_s(nsh, "quotRem_bb nsh");
  if(nsh !== 0) {
    h$ghcjsbn_shlTo_b(y, b2, nsh);
    h$ghcjsbn_shlTo_b(r, b1, nsh);
  } else {
    h$ghcjsbn_copy(y, b2);
    h$ghcjsbn_copy(r, b1);
  }
  h$ghcjsbn_assertValid_b(y, "quotRem_bb y_0");
  h$ghcjsbn_assertValid_b(r, "quotRem_bb r_0");
  var ys = y[0], y0 = y[ys];
  var yt = y0*(1<<24)+((ys>1)?y[ys-1]>>4:0);
  var d1 = 4503599627370496/yt, d2 = (1<<24)/yt, e = 1 << 4;
  var i = r[0], j = i-ys, t = q;
  h$ghcjsbn_shlTo_limbs_b(t,y,j);
  // h$log("rt1: " + i);
  // h$log("[" + r.join(",") + "] [" + t.join(",") + "]");
  if(h$ghcjsbn_cmp_bb(r, t) !== 0) {
    r[r[0]+1] = 1;
    r[0] += 1;
    // h$log("rt1a: " + r[0]);
    h$ghcjsbn_subTo_bb(r, t);
  }
  // h$log("rt2: " + r[0]);
  // h$log("y0: " + y0 + " yt: " + yt + " d1: " + d1 + " d2: " + d2 + " e: " + e);
  h$ghcjsbn_shlTo_limbs_b(t, h$ghcjsbn_one_b, ys);
  y = h$ghcjsbn_sub_bb(t, y);
  while(y.length <= ys) y[y.length] = 0; // fixme? no looks ok
  while(--j >= 0) {
    // Estimate quotient digit
    var qd = (r[(--i)+1]===y0)?0xfffffff:Math.floor(r[i+1]*d1+(r[i]+e)*d2);
    // h$log("i: " + i + " j: " + j + " qd: " + qd + " rdi: " + r[i+1] + " ys: " + ys);
    // h$log("yd: [" + y.join(',') + "] rd: [" + r.join(',') + "]");
    var am = h$ghcjsbn_mul_limb(0, y, qd, r, j, 0, ys);
    // h$log("am: " + am);
    if((r[i+1] += am) < qd) {
    // if((r[i+1] += h$ghcjsbn_mul_limb(0, y, qd, r, j, 0, ys)) < qd) {
      h$ghcjsbn_shlTo_limbs_b(t, y, j);
      h$ghcjsbn_subTo_bb(r, t);
      // h$log("0. rdi: " + r[i+1] + " qd: " + qd);
      while(r[i+1] < --qd) {
        // h$log("1. rdi: " + r[i+1] + " qd: " + qd);
        h$ghcjsbn_subTo_bb(r, t);
      }
    }
  }
  h$ghcjsbn_assertValid_b(r, "intermediate r");
  h$ghcjsbn_shrTo_limbs_b(q, r, ys);
  r[0] = ys;
  while(r[r[0]] === 0 && r[0] > 0 && r[0]--);
  if(nsh !== 0) {
    var r0 = [];
    h$ghcjsbn_copy(r0, r);
    h$ghcjsbn_shrTo_b(r, r0, nsh);
  }
  h$ghcjsbn_assertValid_b(q, "quotRem_bb result q");
  h$ghcjsbn_assertValid_b(r, "quotRem_bb result r");
}

// b % w , q = b / w :: BigNat -> BigNat -> Word -> Word
function h$ghcjsbn_quotRem_bw(q, b, w) {
  h$ghcjsbn_assertValid_b(b, "quotRem_bw");
  h$ghcjsbn_assertValid_w(w, "quotRem_bw");
  var a = h$ghcjsbn_tmp_2a;
  h$ghcjsbn_toBigNat_w(a, w);
/*  if(w === 0) {
    a[0] = 0;
  } else if(w > 0 && w <= GHCJSBN_MASK) {
    a[0] = 1;
    a[1] = w;
  } else {
    a[0] = 2;
    a[1] = w   & GHCJSBN_MASK;
    a[2] = w >>> GHCJSBN_BITS;
  } */
  var r = [];
  h$ghcjsbn_quotRem_bb(q, r, b, a);
  return h$ghcjsbn_toWord_b(r);
}

// BigNat -> JSBN
// assumes same number of bits
function h$ghcjsbn_tmp_toJSBN(b) {
  var j = new BigInteger(), bl = b[0], i;
  for(i = 0; i < bl; i++) j.data[i] = b[i+1];
  j.s = 0;
  j.t = bl;
  return j;
/*  ASSERTVALID_B(b, "toJSBN");
  var j0 = new BigInteger();
  var j1 = new BigInteger();
  var j2 = new BigInteger();
  for(var i = b[0]; i > 0; i--) {
    h$log("i: " + b[i]);
    j2.fromString('' + b[i]);
    j0.lShiftTo(28, j1);
    j1.addTo(j2, j0);
  }
  return j0; */
}

// b = fromJSBN(j) :: BigNat -> JSBN -> Int
// returns length
function h$ghcjsbn_tmp_fromJSBN(b, j) {
  var bl = j.t, i;
  for(i = 0; i < bl; i++) {
    b[i] = j.data[i];
  }
  return bl;
}


// function h$ghcjsbn_divMod_bs(d

// t = b1 % b2 :: BigNat -> BigNat -> BigNat
function h$ghcjsbn_rem_bb(b1, b2) {
  h$ghcjsbn_assertValid_b(b1, "rem_bb b1");
  h$ghcjsbn_assertValid_b(b2, "rem_bb b2");
  var t1 = [], t2 = [];
  h$ghcjsbn_quotRem_bb(t1, t2, b1, b2);
  h$ghcjsbn_assertValid_b(t2, "rem_bb result");
  return t2;
}

// b1 % s :: BigNat -> Word -> Word
function h$ghcjsbn_rem_bw(b, w) {
  h$ghcjsbn_assertValid_b(b, "rem_bw");
  h$ghcjsbn_assertValid_w(w, "rem_bw");
  //  var t1 = [];
  var r = h$ghcjsbn_quotRem_bw([] /* t1 */, b, w);
  h$ghcjsbn_assertValid_w(r, "rem_bw result");
  return r;
//  var a = h$ghcjsbn_tmp_2a;
//  h$ghcjsbn_toBigNat_w(a, w);
//  a[1] = w   & GHCJSBN_MASK;
//  a[2] = w >>> GHCJSBN_BITS;
//  var t1 = []; // , t2 = h$ghcjsbn_tmp_2b;
//  return h$ghcjsbn_quotRem_bw(t1, /* t2 , */ b, a);
//  return t[1] | (t[2] << GHCJSBN_BITS);
}

// b1 / b2 :: BigNat -> BigNat -> BigNat
function h$ghcjsbn_quot_bb(b1, b2) {
  h$ghcjsbn_assertValid_b(b1, "quot_bb b1");
  h$ghcjsbn_assertValid_b(b2, "quot_bb b2");
  var t1 = [], t2 = [];
  h$ghcjsbn_quotRem_bb(t1, t2, b1, b2);
  h$ghcjsbn_assertValid_b(t1, "quot_bb result");
  return t1;
}
/*
// b / s :: BigNat -> Int -> BigNat
function h$ghcjsbn_div_bs(b, w) {
  ASSERTVALID_B(b, "div_bs");
  ASSERTVALID_S(s, "div_bs");
#ifdef GHCJS_ASSERT_INTEGER
  if(s <= 0) {
    throw new Error("h$ghcjsbn_div_bs: divisor must be positive");
  }
#endif
  var a = h$ghcjsbn_tmp_2a;
  a[0] = s &  GHCJSBN_MASK;
  a[1] = s >> GHCJSBN_BITS;
  return h$ghcjsbn_div_bb(t, b, a);
}
*/
// t = b % w :: BigNat -> BigNat -> Word -> Int
// returns length of t
/*
function h$ghcjsbn_div_bw(t, b, w) {
  ASSERTVALID_B(b, "div_bw");
  ASSWRTVALID_W(w, "div_bw");
  var a = h$ghcjsbn_tmp_2a;
 a[0] = w   & GHCJSBN_MASK;
 a[1] = w >>> GHCJSBN_BITS;
  return h$ghcjsbn_div_bb(t, b, a);
}
*/
// b ^ 2 :: BigNat -> BigNat
function h$ghcjsbn_sqr_b(b) {
  h$ghcjsbn_assertValid_b(b, "sqr_b");
  var l = b[0], n = 2 * l, i, c, t = [0];
  for(i = 1; i <= n; i++) t[i] = 0;
  for(i = 0; i < l - 1; i++) {
    c = h$ghcjsbn_mul_limb(i, b, b[i+1],t,2*i,0,1);
    if((t[i + l + 1] += h$ghcjsbn_mul_limb(i+1, b, 2*b[i+1], t, 2*i+1, c, l - i - 1)) >= 0x10000000) {
      t[i + l + 1] -= 0x10000000;
      t[i + l + 2] = 1;
    }
  }
  if(n > 0) t[n] += h$ghcjsbn_mul_limb(i, b, b[i+1], t, 2*i, 0, 1);
  if(t[n] === 0) n--;
  t[0] = n;
  h$ghcjsbn_assertValid_b(t, "sqr_b result");
  return t;
}

// b1 ^ b2 :: BigNat -> BigNat -> BigNat
// returns size of t
function h$ghcjsbn_pow_bb(b1, b2) {
  h$ghcjsbn_assertValid_b(b1, "pow_bb b1");
  h$ghcjsbn_assertValid_b(b2, "pow_bb b2");
  var i, sq = b1, t = [1,1];
  var bits = h$ghcjsbn_nbits_b(b2);
  for(i = 0; i < bits; i++) {
    if(h$ghcjsbn_testBit_b(b2, i)) {
      h$ghcjsbn_mulTo_bb(t, sq);
    }
    sq = h$ghcjsbn_sqr_b(sq);
  }
  return t;
}

// t = b ^ s :: BigNat -> Word -> BigNat
function h$ghcjsbn_pow_bw(b, w) {
  h$ghcjsbn_assertValid_b(b, "pow_bw");
  h$ghcjsbn_assertValid_w(w, "pow_bw");
  var i, sq = b, t = [1,1];
  while(w) {
    if(w&1) h$ghcjsbn_mulTo_bb(t, sq);
    w >>>= 1;
    if(w) {
      sq = h$ghcjsbn_sqr_b(sq);
    }
  }
  h$ghcjsbn_assertValid_b(t, "pow_bw result");
  return t;
}

// w1 ^ w2 :: Word -> Word -> BigNat
function h$ghcjsbn_pow_ww(w1, w2) {
  h$ghcjsbn_assertValid_s(w1, "pow_ww w1");
  h$ghcjsbn_assertValid_s(w2, "pow_ww w2");
  var b = h$ghcjsbn_tmp_2a;
  h$ghcjsbn_toBigNat_w(b, w1);
  var t = h$ghcjsbn_pow_bw(b, w2);
  h$ghcjsbn_assertValid_b(t, "pow_ww result");
  return t;
}

// (b ^ s1) % s2 :: BigNat -> BigNat -> BigNat -> BigNat
function h$ghcjsbn_modPow_bbb(b, s1, s2) {
  throw new Error("modPow_bbb");
}

// (b ^ s1) % s2 :: BigNat -> Int -> Int -> Int
function h$ghcjsbn_modPow_bss(b, s1, s2) {
  throw new Error("modPow_bss");
}

// (s1 ^ s2) % s3 :: Int -> Int -> Int -> Int
function h$ghcjsbn_modPow_sss(s1, s2, s3) {
  throw new Error("modPow_sss");
}



// r = gcd(b1,b2) BigNat -> BigNat -> BigNat
function h$ghcjsbn_gcd_bb(b1, b2) {
  h$ghcjsbn_assertValid_b(b1, "gcd_bb b1");
  h$ghcjsbn_assertValid_b(b2, "gcd_bb b2");
  var r;
  if(h$ghcjsbn_cmp_bb(b1, b2) === 2) {
    r = b1;
    b1 = b2;
    b2 = r;
  }
  while(b1[0] > 0) {
    r = h$ghcjsbn_rem_bb(b2, b1);
    b2 = b1;
    b1 = r;
  }
  h$ghcjsbn_assertValid_b(b2, "gcd_bb result");
  return b2;
}
// gcd(b,s) :: BigNat -> Int -> Int
function h$ghcjsbn_gcd_bs(b, s) {
  throw new Error("h$ghcjsbn_gcd_bs not implemented");
}

// gcd(s1,s2) :: Int -> Int -> Int
function h$ghcjsbn_gcd_ss(s1, s2) {
  h$ghcjsbn_assertValid_s(s1, "gcd_ss s1");
  h$ghcjsbn_assertValid_s(s2, "gcd_ss s2");
  var a, b, r;
  a = s1 < 0 ? -s1 : s1;
  b = s2 < 0 ? -s2 : s2;
  if(b < a) {
    r = a;
    a = b;
    b = r;
  }
  while(a !== 0) {
    r = b % a;
    b = a;
    a = r;
  }
  h$ghcjsbn_assertValid_s(b, "gcd_ss result");
  return b;
}

// gcd(w1,w2) :: Word -> Word -> Word
// fixme negatives are probably wrong here
function h$ghcjsbn_gcd_ww(w1, w2) {
  h$ghcjsbn_assertValid_w(w1, "gcd_ww w1");
  h$ghcjsbn_assertValid_w(w2, "gcd_ww w2");
  var a, b, r;
  a = w1 < 0 ? (w1 + 4294967296) : w1;
  b = w2 < 0 ? (w2 + 4294967296) : w2;
  if(b < a) {
    r = a;
    a = b;
    b = r;
  }
  while(a !== 0) {
    r = b % a;
    b = a;
    a = r;
  }
  b = b|0;
  h$ghcjsbn_assertValid_w(b, "gcd_ww result");
  return b;
}

function h$ghcjsbn_gcd_bw(b, w) {
  h$ghcjsbn_assertValid_b(b, "gcd_bw");
  h$ghcjsbn_assertValid_w(w, "gcd_bw");
  var q = [], r = h$ghcjsbn_quotRem_bw(q, b, w);
  h$ghcjsbn_assertValid_w(r, "gcd_bw r");
  if(r === 0) {
    return b[0] === 0 ? 0 : w;
  } else {
    return h$ghcjsbn_gcd_ww(r, w);
  }
}

// b >> s :: BigNat -> Int -> BigNat
function h$ghcjsbn_shr_b(b, s) {
  h$ghcjsbn_assertValid_b(b, "shr_b");
  h$ghcjsbn_assertValid_s(s, "shr_b");

  if(s < 0) throw new Error("h$ghcjsbn_shr_b: negative operand");

  var i, v1, v2, l = b[0], sl = (s / 28)|0, t = [0];
  l -= sl;
  if(l <= 0) {
    t[0] = 0;
  } else {
    var sb1 = s % 28, sb2 = 28 - sb1, m = (1<<sb1)-1;
    var c = b[sl + 1] >> sb1, v;
    for(i = 1; i < l; i++) {
      v = b[i + sl + 1];
      t[i] = ((v&m) << sb2)|c;
      c = v >> sb1;
    }
    if(c !== 0) {
      t[l] = c;
      t[0] = l;
    } else {
      t[0] = l - 1;
    }
  }
  h$ghcjsbn_assertValid_b(t, "shr_b result");
  return t;
}

// t = b >> s :: BigNat -> BigNat -> Int -> IO ()
function h$ghcjsbn_shrTo_b(t, b, s) {
  h$ghcjsbn_assertValid_b(b, "shrTo_b");
  h$ghcjsbn_assertValid_s(s, "shrTo_b");

  if(s < 0) throw new Error("h$ghcjsbn_shrTo_b: negative operand");

  var i, v1, v2, l = b[0], sl = (s / 28)|0;
  t[0] = 0;
  l -= sl;
  if(l <= 0) {
    t[0] = 0;
  } else {
    var sb1 = s % 28, sb2 = 28 - sb1, m = (1<<sb1)-1;
    var c = b[sl + 1] >> sb1, v;
    for(i = 1; i < l; i++) {
      v = b[i + sl + 1];
      t[i] = ((v&m) << sb2)|c;
      c = v >> sb1;
    }
    if(c !== 0) {
      t[l] = c;
      t[0] = l;
    } else {
      t[0] = l - 1;
    }
  }
  h$ghcjsbn_assertValid_b(t, "shrTo_b result");
}

function h$ghcjsbn_shr_neg_b(b, s) {
  throw new Error ("shr_neg_b not implemented");
}

// b << s :: BigNat -> Int -> BigNat
function h$ghcjsbn_shl_b(b, s) {
  h$ghcjsbn_assertValid_b(b, "shl_b");
  h$ghcjsbn_assertValid_s(s, "shl_b");

  if(s < 0) throw new Error("h$ghcjsbn_shl_b: negative operand");

  var sl = (s / 28)|0;
  var sb1 = s % 28, sb2 = 28 - sb1;
  // mask wrong
  var l = b[0];
  if(l === 0) return h$ghcjsbn_zero_b;
  var c = 0, i, v, m = (1 <<sb1) - 1, t = [0];
  for(i = 1; i <= sl; i++) {
    t[i] = 0;
  }
  for(i = 1; i <= l; i++) {
    v = b[i];
    t[i + sl] = ((v << sb1) & 0xfffffff) | c;
    c = v >> sb2;
  }
  if(c !== 0) {
    t[l+sl+1] = c;
    t[0] = l + sl + 1;
  } else {
    t[0] = l + sl;
  }
  h$ghcjsbn_assertValid_b(t, "shl_b result");
  return t;
}

// t = b << s :: BigNat -> BigNat -> Int -> IO ()
function h$ghcjsbn_shlTo_b(t, b, s) {
  h$ghcjsbn_assertValid_b(b, "shlTo_b");
  h$ghcjsbn_assertValid_s(s, "shlTo_b");

  if(s < 0) throw new Error("h$ghcjsbn_shlTo_b: negative operand");

  var sl = (s / 28)|0;
  var sb1 = s % 28, sb2 = 28 - sb1;
  // mask wrong
  var l = b[0], c = 0, i, v, m = (1 <<sb1) - 1;
  t[0] = 0;
  for(i = 1; i <= sl; i++) {
    t[i] = 0;
  }
  for(i = 1; i <= l; i++) {
    v = b[i];
    t[i + sl] = ((v << sb1) & 0xfffffff) | c;
    c = v >> sb2;
  }
  if(c !== 0) {
    t[l+sl+1] = c;
    t[0] = l + sl + 1;
  } else {
    t[0] = l + sl;
  }
  h$ghcjsbn_assertValid_b(t, "shlTo_b result");
}


// t = b >> (GHCJSBN_BITS * s) :: BigNat -> BigNat -> Int
function h$ghcjsbn_shrTo_limbs_b(t, b, s) {
  h$ghcjsbn_assertValid_b(b, "shrTo_limbs_b");
  h$ghcjsbn_assertValid_s(s, "shrTo_limbs_b");

  if(s < 0) throw new Error("h$ghcjsbn_shrTo_limbs_b: negative operand");

  var l = b[0], l1 = l - s, i;
  if(l1 < 1) {
    t[0] = 0;
  } else {
    t[0] = l1;
    for(i = 1; i <= l1; i++) t[i] = b[i+s];
  }
  h$ghcjsbn_assertValid_b(t, "shrTo_limbs_b result");
}

// t = b << (GHCJSBN_BITS * s) :: BigNat -> BigNat -> Int
function h$ghcjsbn_shlTo_limbs_b(t, b, s) {
  h$ghcjsbn_assertValid_b(b, "shlTo_limbs_b");
  h$ghcjsbn_assertValid_s(s, "shlTo_limbs_b");

  if(s < 0) throw new Error("h$ghcjsbn_shlTo_limbs_b: negative operand");

  var l = b[0], l1 = l + s, i;
  if(l === 0) {
    t[0] = 0;
  } else {
    t[0] = l1;
    for(i = 1; i <= s; i++) t[i] = 0;
    for(i = s+1; i <= l1; i++) t[i] = b[i-s];
  }
  h$ghcjsbn_assertValid_b(t, "shlTo_limbs_b result");
}

function h$ghcjsbn_nbits_b(b) {
  h$ghcjsbn_assertValid_b(b, "nbits_b");
  var l = b[0], c = 0, s, t;
  if(l === 0) {
    return 0;
  } else {
    var r = ((l-1)*28) + h$ghcjsbn_nbits_s(b[l]);
    h$ghcjsbn_assertValid_s(r, "nbits_b result");
    return r;
  }
}

function h$ghcjsbn_nbits_s(s) {
  h$ghcjsbn_assertValid_s(s, "nbits_s");
  var c = 1, t;
  if((t = s >>> 16) != 0) { s = t; c += 16; }
  if((t = s >> 8) != 0) { s = t; c += 8; }
  if((t = s >> 4) != 0) { s = t; c += 4; }
  if((t = s >> 2) != 0) { s = t; c += 2; }
  if((t = s >> 1) != 0) { s = t; c += 1; }
  h$ghcjsbn_assertValid_s(c, "nbits_s result");
  return c;
}

// BigNat -> Word -> String
function h$ghcjsbn_showBase(b, base) {
  h$ghcjsbn_assertValid_b(b, "showBase");
  h$ghcjsbn_assertValid_s(base, "showBase");
  if(h$ghcjsbn_cmp_bb(b, h$ghcjsbn_zero_b) === 1) {
    return "0";
  } else {
    return h$ghcjsbn_showBase_rec(b, base, Math.log(base), 0);
  }
}

function h$ghcjsbn_showBase_rec(b, base, logBase, pad) {
  var bits = h$ghcjsbn_nbits_b(b), r;
  // h$log("[" + b.join(",") + "] bits: " + bits);
  if(h$ghcjsbn_cmp_bb(b, h$ghcjsbn_two31_b) === 0) {
    // convert short numbers to int and show in base
    var ti = h$ghcjsbn_toInt_b(b);
    // h$log("############# got base limb: " + ti);
    r = ti === 0 ? "" : ti.toString(base);
  } else {
    // divide and conquer for long numbers
    var digits = Math.floor(bits * 0.6931471805599453 / logBase);
    var d2 = Math.round(digits/2), p, q = [], r = [];
    p = h$ghcjsbn_pow_ww(base, d2);
    h$ghcjsbn_quotRem_bb(q, r, b, p);
    r = h$ghcjsbn_showBase_rec(q, base, logBase, 0) +
        h$ghcjsbn_showBase_rec(r, base, logBase, d2);
  }
  var rl = r.length;
  if(rl < pad) {
    while(rl <= pad-8) { r = "00000000" + r; rl += 8; }
    switch(pad-rl) {
    case 1: r = "0" + r; break;
    case 2: r = "00" + r; break;
    case 3: r = "000" + r; break;
    case 4: r = "0000" + r; break;
    case 5: r = "00000" + r; break;
    case 6: r = "000000" + r; break;
    case 7: r = "0000000" + r; break;
    }
  }
  return r;
}

// BigNat -> String (decimal)
function h$ghcjsbn_show(b) {
  throw new Error("show not implemented");
  // digits =
}

// BigNat -> String
function h$ghcjsbn_showHex(b) {
  throw new Error("showHex not implemented");
}

// s = b[l - 1];

// normalize a number to length l by stripping unused leading digits
/*
function h$ghcjsbn_normalize(b, l) {
  var d = b.length - l;
  while(d--) b.pop();
}

// normalize a number by stripping leading zeroes
function h$ghcjsbn_normalize0(b) {
  var l = b.length;
  while(b[--l] === 0) b.pop();
}
*/
// t = b :: BigNat -> BigNat -> Int, returns length of t
function h$ghcjsbn_copy(t, b) {
  h$ghcjsbn_assertValid_b(b, "copy");
  var l = b[0];
  for(var i = 0; i <= l; i++) {
    t[i] = b[i];
  }
  return l;
}

// BigNat -> Int -> Bool
// test if bit n is set in b (least significant bit is 0)
function h$ghcjsbn_testBit_b(b, n) {
  h$ghcjsbn_assertValid_b(b, "testBit_b");
  h$ghcjsbn_assertValid_s(n, "testBit_b");
  var limb = (n / 28)|0;
  if(limb >= b[0]) {
    return false;
  } else {
    var d = b[limb];
    var bit = n - (28 * limb);
    return (b[limb] & (1 << bit)) !== 0;
  }
}

function h$ghcjsbn_popCount_b(b) {
  h$ghcjsbn_assertValid_b(b, "popCount_b");
  var c = 0, l = b[0];
  while(l > 0) {
    c += h$popCnt32(b[l--]);
  }
  return c;
}

// t = b1 ^ b2 :: BigNat -> BigNat -> BigNat -> Int
// returns length of t
function h$ghcjsbn_xor_bb(b1, b2) {
  h$ghcjsbn_assertValid_b(b1, "xor_bb b1");
  h$ghcjsbn_assertValid_b(b2, "xor_bb b2");
  var i, lmin, lmax, blmax, l1 = b1[0], l2 = b2[0], t = [0];
  if(l1 <= l2) {
    lmin = l1;
    lmax = l2;
    blmax = b2;
  } else {
    lmin = l2;
    lmax = l1;
    blmax = b1;
  }
  for(i = 1; i <= lmin; i++) {
    t[i] = b1[i] ^ b2[i];
  }
  for(i = lmin + 1; i <= lmax; i++) {
    t[i] = blmax[i];
  }
  while(lmax > 0 && t[lmax] === 0) lmax--;
  t[0] = lmax;
  h$ghcjsbn_assertValid_b(t, "xor_bb result");
  return t;
}

// b1 | b2 :: BigNat -> BigNat -> BigNat
function h$ghcjsbn_or_bb(b1, b2) {
  h$ghcjsbn_assertValid_b(b1, "or_bb b1");
  h$ghcjsbn_assertValid_b(b2, "or_bb b2");
  var i, lmin, lmax, blmax, l1 = b1[0], l2 = b2[0], t = [0];
  if(l1 <= l2) {
    lmin = l1;
    lmax = l2;
    blmax = b2;
  } else {
    lmin = l2;
    lmax = l1;
    blmax = b1;
  }
  for(i = 1; i <= lmin; i++) {
    t[i] = b1[i] | b2[i];
  }
  for(i = lmin + 1; i <= lmax; i++) {
    t[i] = blmax[i];
  }
  t[0] = lmax;
  h$ghcjsbn_assertValid_b(t, "or_bb result");
  return t;
}

// b1 & b2 :: BigNat -> BigNat -> BigNat
function h$ghcjsbn_and_bb(b1, b2) {
  h$ghcjsbn_assertValid_b(b1, "and_bb b1");
  h$ghcjsbn_assertValid_b(b2, "and_bb b2");
  var i, lmin, l1 = b1[0], l2 = b2[0], t = [0];
  lmin = l1 <= l2 ? l1 : l2;
  for(i = 1; i <= lmin; i++) {
    t[i] = b1[i] & b2[i];
  }
  while(lmin > 0 && t[lmin] === 0) lmin--;
  t[0] = lmin;
  h$ghcjsbn_assertValid_b(t, "and_bb result");
  return t;
}

// b1 & (~b2) :: BigNat -> BigNat -> BigNat
// fixme is this one correct?
function h$ghcjsbn_andn_bb(b1, b2) {
  h$ghcjsbn_assertValid_b(b1, "andn_bb b1");
  h$ghcjsbn_assertValid_b(b2, "andn_bb b2");
  var i, lmin, l1 = b1[0], l2 = b2[0], t = [0];
  if(l1 <= l2) {
    for(i = 0; i <= l1; i++) t[i] = b1[i] & (~b2[i]);
  } else {
    for(i = 0; i <= l2; i++) t[i] = b1[i] & (~b2[i]);
    for(i = l2+1; i <= l1; i++) t[i] = b1[i];
  }
  while(l1 > 0 && t[l1] === 0) l1--;
  t[0] = l1;
  h$ghcjsbn_assertValid_b(t, "andn_bb result");
  return t;
}

function h$ghcjsbn_toInt_b(b) {
  h$ghcjsbn_assertValid_b(b, "toInt_b");
  var bl = b[0], r;
  if(bl >= 2) {
    r = (b[2] << 28) | b[1];
  } else if(bl === 1) {
    r = b[1];
  } else {
    r = 0;
  }
  h$ghcjsbn_assertValid_s(r, "toInt_b result");
  return r;
}

function h$ghcjsbn_toWord_b(b) {
  h$ghcjsbn_assertValid_b(b, "toWord_b");
  var bl = b[0], w;
  if(bl >= 2) {
    w = (b[2] << 28) | b[1];
  } else if(bl === 1) {
    w = b[1];
  } else {
    w = 0;
  }
  h$ghcjsbn_assertValid_w(w, "toWord_b result");
  return w;
}

var h$integer_bigNatToWord64 = h$ghcjsbn_toWord64_b;
var h$integer_word64ToBigNat = h$ghcjsbn_mkBigNat_ww; // fixme?


function h$ghcjsbn_toWord64_b(b) {
  h$ghcjsbn_assertValid_b(b, "toWord64_b");
  var len = b[0], w1, w2;
  if(len < 2) {
    w2 = 0;
    w1 = (len === 1) ? b[1] : 0;
  } else {
    w1 = b[1] | (b[2] << 28);
    if(len === 2) {
      w2 = b[2] >>> 4;
    } else {
      w2 = (b[2] >>> 4) | (b[3] << 24);
    }
  }
  h$ghcjsbn_assertValid_w(w2, "toWord64_b result w2");
  h$ghcjsbn_assertValid_w(w1, "toWord64_b result w1");
  { h$ret1 = (w1); return (w2); };
}




// BigNat -> Int -> IO ()
function h$ghcjsbn_toBigNat_s(b, s) {
  h$ghcjsbn_assertValid_s(s, "toBigNat_s");

  if(s < 0) {
    throw new Error("h$ghcjsbn_toBigNat_s: negative operand");
  }

  if(s === 0) {
    b[0] = 0;
  } else if(s <= 0xfffffff) {
    b[0] = 1;
    b[1] = s;
  } else {
    b[0] = 2;
    b[1] = s & 0xfffffff;
    b[2] = s >> 0xfffffff;
  }
  h$ghcjsbn_assertValid_b(b, "toBigNat_s result");
}

// BigNat -> Word -> IO ()
function h$ghcjsbn_toBigNat_w(b, w) {
  h$ghcjsbn_assertValid_w(w, "toBigNat_w");
  if(w === 0) {
    b[0] = 0;
  } else if(w > 0 && w <= 0xfffffff) {
    b[0] = 1;
    b[1] = w;
  } else {
    b[0] = 2;
    b[1] = w & 0xfffffff;
    b[2] = w >>> 28;
  }
  h$ghcjsbn_assertValid_b(b, "toBigNat_w result");
}

function h$ghcjsbn_mkBigNat_w(w) {
  h$ghcjsbn_assertValid_w(w, "mkBigNat_w");
  var r;
  if(w === 0) r = h$ghcjsbn_zero_b;
  else if(w === 1) r = h$ghcjsbn_one_b;
  else if(w > 0 && w <= 0xfffffff) r = [1,w];
  else r = [2, w & 0xfffffff, w >>> 28];
  h$ghcjsbn_assertValid_b(r, "mkBigNat_w result");
  // ASSERTVALID_B(h$ghcjsbn_zero_b, "mkBigNat_w zero");
  return r;
}


function h$ghcjsbn_mkBigNat_ww(hw, lw) {
  h$ghcjsbn_assertValid_w(hw, "mkBigNat_ww hw");
  h$ghcjsbn_assertValid_w(lw, "mkBigNat_ww lw");
  var r;
  if(hw === 0) r = h$ghcjsbn_mkBigNat_w(lw);
  else {
    var w1 = lw & 0xfffffff;
    var w2 = (lw >>> 28) | ((hw << 4) & 0xfffffff);
    var w3 = hw >>> 24;
    if(w3 === 0) {
      r = [2, w1, w2];
    } else {
      r = [3, w1, w2, w3];
    }
  }
  h$ghcjsbn_assertValid_b(r, "mkBigNat_ww result");
  return r;
}


// fixme remove after reboot
var h$ghcjsbn_toBigNat_ww = h$ghcjsbn_mkBigNat_ww;

/* fixme re-enable after reboot
function h$ghcjsbn_toBigNat_ww(b, hw, lw) {
  ASSERTVALID_W(hw, "toBigNat_ww hw");
  ASSERTVALID_W(lw, "toBigNat_ww lw");
  if(hw === 0) h$ghcjsbn_toBigNat_w(b, lw);
  else {
    var w1 = lw & GHCJSBN_MASK;
    var w2 = (lw >>> GHCJSBN_BITS) | ((hw << 4) & GHCJSBN_MASK);
    var w3 = hw >>> 24;
    if(w3 === 0) {
      r[0] = 2;
      r[1] = w1;
      r[2] = w2;
    } else {
      r[0] = 3;
      r[1] = w1;
      r[2] = w2;
      r[3] = w3;
    }
  }
}
*/




// fixme remove later
var h$integer_mkInteger = h$ghcjsbn_mkInteger;


function h$ghcjsbn_mkInteger(nonNeg, xs) {
  // fixme write proper optimized version
  var r = [0], s = 0, t;
  while(((xs).f === h$ghczmprimZCGHCziTypesziZC_con_e)) {
    t = h$ghcjsbn_shl_b(h$ghcjsbn_mkBigNat_w(((typeof(((xs).d1)) === 'number')?(((xs).d1)):(((xs).d1)).d1)), s);
    h$ghcjsbn_addTo_bb(r, t);
    s += 31;
    xs = ((xs).d2);
  }
  if(nonNeg) {
    if(h$ghcjsbn_cmp_bb(r, h$ghcjsbn_two31_b) === 0) {
      return (h$c1(h$integerzmgmpZCGHCziIntegerziTypeziSzh_con_e, (h$ghcjsbn_toInt_b(r))));;
    } else {
      return (h$c1(h$integerzmgmpZCGHCziIntegerziTypeziJpzh_con_e, (r)));;
    }
  } else {
    var c = h$ghcjsbn_cmp_bb(r, h$ghcjsbn_two31_b);
    if(c === 2) {
      return (h$c1(h$integerzmgmpZCGHCziIntegerziTypeziJnzh_con_e, (r)));;
    } else if(c === 1) {
      return h$ghcjsbn_negTwo31_i;
    } else {
      return (h$c1(h$integerzmgmpZCGHCziIntegerziTypeziSzh_con_e, (-h$ghcjsbn_toInt_b(r))));;
    }
  }
/*  var r = h$ghcjsbn_mkBigNat_w(0), l = 0, s = 0, y, t;
  while(IS_CONS(xs)) {
    l++;
    y  = UNWRAP_NUMBER(CONS_HEAD(xs));
    r[++l] = (y << s | c) & GHCJSBN_MASK;
    c  = y >>> s;
    xs = CONS_TAIL(xs);
    s  += 3;
    l++;
    if(s > GHCJSBN_BITS) {
      s  -= GHCJSBN_BITS;
      r[++l] = c & GHCJSBN_MASK;
      c >>= GHCJSBN_BITS;
    }
  }
  if(c !== 0) r[++l] =
  while(
  if(l === 0) {
    return MK_INTEGER_S(0);
  } else if(l === 1) {

  } else if(l === 2) {

  } */
}




// BigNat -> Int -> Int
function h$ghcjsbn_indexBigNat(b, i) {
  h$ghcjsbn_assertValid_b(b, "indexBigNat");
  h$ghcjsbn_assertValid_s(i, "indexBigNat");
  var bl = b[0];
  return i >= bl ? 0 : b[i+1];
}

// BigNat -> Word -> Int (Ordering)
function h$ghcjsbn_cmp_bw(b, w) {
  h$ghcjsbn_assertValid_b(b, "cmp_bw");
  h$ghcjsbn_assertValid_w(w, "cmp_bw");
  var w1 = w & 0xfffffff, w2 = w >>> 28, bl = b[0];
  if(w2 === 0) {
    if(bl === 0) {
      return w1 > 0 ? 0 : 1;
    } else if(bl === 1) {
      var bw = b[1];
      return bw > w1 ? 2 : (bw === w1 ? 1 : 0);
    } else {
      return 2;
    }
  } else {
    if(bl < 2) {
      return 0;
    } else if(bl > 2) {
      return 2;
    } else {
      var bw1 = b[1], bw2 = b[2];
      return (bw2 > w2) ? 2
                        : (bw2 < w2 ? 0
                                    : (bw1 > w1 ? 2
                                                : (bw1 < w1 ? 0
                                                            : 1)));
    }
  }
}

/*
function h$ghcjsbn_gt_bw(b, w) {
  var r = h$ghcjsbn_gt_bw0(b,w);
  h$log("gt_bw result: " + r);
  return r;
}
*/

function h$ghcjsbn_gt_bw(b, w) {
  h$ghcjsbn_assertValid_b(b, "gt_bw");
  h$ghcjsbn_assertValid_w(w, "gt_bw");
  var bl = b[0];
  if(bl > 2) return true;
  else if(bl === 0) return false;
  else if(bl === 1) return w >= 0 && b[1] > w;
  else { // bl === 2
    var wh = w >>> 28, wl = w & 0xfffffff, b2 = b[2];
    // var r = (wh > b2 || ((wh === b2) && wl > b[1]));
    // h$log("r: " + r + " " + wh + " " + wl + " " );
    return (b2 > wh || ((wh === b2) && b[1] > wl));
  }
}

// BigNat -> BigNat -> Bool
function h$ghcjsbn_eq_bb(b1, b2) {
  h$ghcjsbn_assertValid_b(b1, "eq_bb");
  h$ghcjsbn_assertValid_b(b2, "eq_bb");
  var bl1 = b1[0], bl2 = b2[0];
  if(bl1 !== bl2) {
    return false;
  } else {
    for(var i = bl1; i >= 1; i--) {
      var bw1 = b1[i], bw2 = b2[i];
      if(bw1 !== bw2) return false;
    }
  }
  return true; // GHCJSBN_EQ;
}

// BigNat -> BigNat -> Bool
function h$ghcjsbn_neq_bb(b1, b2) {
  h$ghcjsbn_assertValid_b(b1, "neq_bb");
  h$ghcjsbn_assertValid_b(b2, "neq_bb");
  var bl1 = b1[0], bl2 = b2[0];
  if(bl1 !== bl2) {
    return true;
  } else {
    for(var i = bl1; i >= 1; i--) {
      var bw1 = b1[i], bw2 = b2[i];
      if(bw1 !== bw2) return true;
    }
  }
  return false;
}

// BigNat -> BigNat -> Bool
/*
function h$ghcjsbn_eq_bw(b, w) {
  var r = h$ghcjsbn_eq_bw0(b, w);
  return r;
}
*/
function h$ghcjsbn_eq_bw(b, w) {
  h$ghcjsbn_assertValid_b(b, "eq_bw");
  h$ghcjsbn_assertValid_w(w, "eq_bw");
  var w1 = w & 0xfffffff, w2 = w >>> 28, bl = b[0];
  if(w2 === 0) {
    if(w1 === 0) {
      return bl === 0;
    } else {
      return bl === 1 && b[1] === w;
    }
  } else {
    return bl === 2 && b[1] === w1 && b[2] === w2;
  }
}

// BigNat -> Bool
function h$ghcjsbn_isZero_b(b) {
  h$ghcjsbn_assertValid_b(b, "isZero_b");
  return b[0] === 0;
}

// BigNat -> Int
function h$ghcjsbn_isNull_b(b) {
  return b[0] === -1;
}

// 1 << n
function h$ghcjsbn_bitBigNat(n) {

  if(n < 0) {
    throw new Error("bitBigNat: argument must be positive");
  }

  if(n === 0) {
    r = h$ghcjsbn_one_b;
  } else if(n < 28) {
    r = [1, 1 << n];
  } else {
    var l = (n / 28)|0;
    var r = [l+1];
    for(var i = 1; i<= l; i++) r[i] = 0;
    r[l+1] = 1 << (n - (28 * l));
  }
  h$ghcjsbn_assertValid_b(r, "bitBigNat result");
  return r;
}


// Integer -> Int
// assumes argument is strictly positive
function h$ghcjsbn_integerLog2(i) {
  h$ghcjsbn_assertValid_i(i, "integerLog2");

/*  if(h$ghcjsbn_cmp_ii(i, h$ghcjsbn_zero_i) !== GHCJSBN_GT) {
    throw new Error("integerLog2: argument must be positive");
  } */

  if(((i).f === h$integerzmgmpZCGHCziIntegerziTypeziSzh_con_e)) {
    return h$ghcjsbn_nbits_s(((i).d1));
  } else {
    return h$ghcjsbn_nbits_b(((i).d1));
  }
}

// Integer -> Int
// returns negation of result if integer is exactly a power of two
function h$ghcjsbn_integerLog2IsPowerOf2(i) {
  h$ghcjsbn_assertValid_i(i, "integerLog2IsPowerOf2");

/*  if(h$ghcjbn_cmp_ii(i, h$ghcjsbn_zero_i) !== GHCJSBN_GT) {
    throw new Error("integerLog2IsPowerOf2: argument must be positive");
  } */

  var nb;
  if(((i).f === h$integerzmgmpZCGHCziIntegerziTypeziSzh_con_e)) {
    var sd = ((i).d1);
    h$ghcjsbn_assertValid_s(sd, "integerLog2IsPowerOf2 sd");
    nb = h$ghcjsbn_nbits_s(sd);
    return ((sd === 1 << nb) ? -nb : nb);
  } else {
    var bd = ((i).d1);
    h$ghcjsbn_assertValid_b(bd, "integerLog2IsPowerOf2 bd");
    nb = h$ghcjsbn_nbits_b(bd);
    var i, bl = (nb / 28) | 0, lb = nb - 28 * bl, l = bd[bl+1];
    if(l !== (1 << lb)) return nb;
    for(i = bl; i >= 1; i--) {
      if(bd[i] !== 0) return nb;
    }
    return -nb;
  }
}

// BigNat? -> Int
function h$ghcjsbn_isValid_b(b) {
  if(!Array.isArray(b)) return 0;
  if(b.length < 1) return 0;
  var bl = b[0], w;
  if(b.length < (bl+1)) return 0;
  for(var i = 0; i <= bl; i++) {
    w = b[i];
    if(typeof w !== 'number' || (w & 0xfffffff) !== w) return 0;
  }
  return 1;
}

// BigNat -> Integer
function h$ghcjsbn_toInteger_b(b) {
  h$ghcjsbn_assertValid_b(b, "toInteger_b");
  if(h$ghcjsbn_cmp_bb(b, h$ghcjsbn_two31_b) === 0) {
    return (h$c1(h$integerzmgmpZCGHCziIntegerziTypeziSzh_con_e, (h$ghcjsbn_toInt_b(b))));;
  } else {
    return (h$c1(h$integerzmgmpZCGHCziIntegerziTypeziJpzh_con_e, (b)));;
  }
}

// BigNat -> Integer
function h$ghcjsbn_toNegInteger_b(b) {
  h$ghcjsbn_assertValid_b(b, "toNegInteger_b");
  var c = h$ghcjsbn_cmp_bb(b, h$ghcjsbn_two31_b);
  if(c === 0) {
    return (h$c1(h$integerzmgmpZCGHCziIntegerziTypeziSzh_con_e, (-h$ghcjsbn_toInt_b(b))));;
  } else if(c === 1) {
    return h$ghcjsbn_negTwo31_i;
  } else {
    return (h$c1(h$integerzmgmpZCGHCziIntegerziTypeziJnzh_con_e, (b)));;
  }
}

// BigNat? -> Int
// (can be called with invalid bignat)
function h$ghcjsbn_sizeof_b(b) {
  if(b.length < 1) return 0;
  var bl = b[0];
  return Math.ceil((bl * 28) / 32);
}

// extract a word from a BigNat
function h$ghcjsbn_index_b(b, w) {
  throw new Error("index_b");
  h$ghcjsbn_assertValid_b(b, "index_b");
  h$ghcjsbn_assertValid_w(w, "index_b");
  var wbit = 32*w, len = b[0], limb = (wbit / 28) | 0, lb = wbit - (limb * 28);
  var r = b[limb+1] >>> lb;
/*  if() {

  } */
  h$ghcjsbn_assertValid_w(r, "index_b result");
}

// Bool -> BigNat -> Double
function h$ghcjsbn_toDouble_b(nonNeg, b) {
  throw new Error("toDouble_b");
}

function h$ghcjsbn_byteArrayToBigNat(ba, len) {
  throw new Error("h$ghcjsbn_byteArrayToBigNat not yet implemented");
}

function h$ghcjsbn_importBigNatFromAddr(a_d, a_o, len, msbf) {
  throw new Error("h$ghcjsbn_importBigNatFromAddr not yet implemented");
}

function h$ghcjsbn_importBigNatFromByteArray(ba, ofs, len, msbf) {
  throw new Error("h$ghcjsbn_importBigNatFromByteArray not yet implemented");
}


//////////////////////////////////////////////////////////////////////////////
// fixme move to primop places later

var h$integer_int64ToInteger = h$ghcjsbn_toInteger_s64;

function h$ghcjsbn_toInteger_s64(s_a, s_b) {
  h$ghcjsbn_assertValid_s(s_a, "toInteger_s64 s_a");
  h$ghcjsbn_assertValid_s(s_b, "toInteger_s64 s_b");
  if(s_a === 0) {
    if(s_b >= 0) {
      return (h$c1(h$integerzmgmpZCGHCziIntegerziTypeziSzh_con_e, (s_b)));;
    } else {
      return (h$c1(h$integerzmgmpZCGHCziIntegerziTypeziJpzh_con_e, (h$ghcjsbn_mkBigNat_w(s_b))));;
    }
  } else if(s_a === -1) {
    if(s_b < 0) {
      return (h$c1(h$integerzmgmpZCGHCziIntegerziTypeziSzh_con_e, (s_b)));;
    } else if(s_b === 0) {
      return (h$c1(h$integerzmgmpZCGHCziIntegerziTypeziJnzh_con_e, (h$ghcjsbn_mkBigNat_ww(1,0))));;
    } else {
      return (h$c1(h$integerzmgmpZCGHCziIntegerziTypeziJnzh_con_e, (h$ghcjsbn_mkBigNat_w(((~s_b)+1)|0))));;
    }
  } else if(s_a > 0) {
    return (h$c1(h$integerzmgmpZCGHCziIntegerziTypeziJpzh_con_e, (h$ghcjsbn_mkBigNat_ww(s_a, s_b))));;
  } else {
    if(s_b === 0) { // zero should be correct!
      return (h$c1(h$integerzmgmpZCGHCziIntegerziTypeziJnzh_con_e, (h$ghcjsbn_mkBigNat_ww(((~s_a)+1)|0, 0))));;
    } else {
      return (h$c1(h$integerzmgmpZCGHCziIntegerziTypeziJnzh_con_e, (h$ghcjsbn_mkBigNat_ww((~s_a)|0, ((~s_b)+1)|0))));;
    }
    /*
     if(s_b === 0) { // zero should be correct!
      return MK_INTEGER_Jn(h$ghcjsbn_mkBigNat_ww(((~s_a)+1)|0, 0));
    } else {
      return MK_INTEGER_Jn(h$ghcjsbn_mkBigNat_ww(~s_a, ((~s_b)+1)|0));
    } */
  }
}

function h$decodeDoubleInt64(d) {
  h$ghcjsbn_assertValid_d(d, "DoubleDecode_Int64");
  if(isNaN(d)) {
    // RETURN_UBX_TUP4(null, -1572864, 0, 972);
    { h$ret1 = (-1572864); h$ret2 = (0); return (972); };
  }
  h$convertDouble[0] = d;
  var i0 = h$convertInt[0], i1 = h$convertInt[1];
  var exp = (i1&2146435072)>>>20;
  var ret1, ret2 = i0, ret3;
  if(exp === 0) { // denormal or zero
    if((i1&2147483647) === 0 && ret2 === 0) {
      ret1 = 0;
      ret3 = 0;
    } else {
      h$convertDouble[0] = d*9007199254740992;
      i1 = h$convertInt[1];
      ret1 = (i1&1048575)|1048576;
      ret2 = h$convertInt[0];
      ret3 = ((i1&2146435072)>>>20)-1128;
    }
  } else {
    ret3 = exp-1075;
    ret1 = (i1&1048575)|1048576;
  }
  // negate mantissa for negative input
  if(d < 0) {
    if(ret2 === 0) {
      ret1 = ((~ret1) + 1) | 0;
      // ret2 = 0;
    } else {
      ret1 = ~ret1;
      ret2 = ((~ret2) + 1) | 0;
    }
  }
  // prim ubx tup returns don't return the first value!
  { h$ret1 = (ret1); h$ret2 = (ret2); return (ret3); };
}

// fixme remove this once rebooted
function h$primop_DoubleDecode_Int64Op(d) {
  h$ghcjsbn_assertValid_d(d, "DoubleDecode_Int64");
  if(isNaN(d)) {
    // RETURN_UBX_TUP4(null, -1572864, 0, 972);
    { h$ret1 = (-1572864); h$ret2 = (0); h$ret3 = (972); return (null); };
  }
  h$convertDouble[0] = d;
  var i0 = h$convertInt[0], i1 = h$convertInt[1];
  var exp = (i1&2146435072)>>>20;
  var ret1, ret2 = i0, ret3;
  if(exp === 0) { // denormal or zero
    if((i1&2147483647) === 0 && ret2 === 0) {
      ret1 = 0;
      ret3 = 0;
    } else {
      h$convertDouble[0] = d*9007199254740992;
      i1 = h$convertInt[1];
      ret1 = (i1&1048575)|1048576;
      ret2 = h$convertInt[0];
      ret3 = ((i1&2146435072)>>>20)-1128;
    }
  } else {
    ret3 = exp-1075;
    ret1 = (i1&1048575)|1048576;
  }
  // negate mantissa for negative input
  if(d < 0) {
    if(ret2 === 0) {
      ret1 = ((~ret1) + 1) | 0;
      // ret2 = 0;
    } else {
      ret1 = ~ret1;
      ret2 = ((~ret2) + 1) | 0;
    }
  }
  // prim ubx tup returns don't return the first value!
  { h$ret1 = (ret1); h$ret2 = (ret2); h$ret3 = (ret3); return (null); };
}

function h$ghcjsbn_encodeDouble_b(pos, b, e) {
  h$ghcjsbn_assertValid_b(b, "encodeDouble_b");
  h$ghcjsbn_assertValid_s(e, "encodeDouble_b");
  if(e >= 972) {
    return pos ? Infinity : -Infinity;
  }
  var ls = 1, bl = b[0], i, r = b[bl], mul = 1 << 28, rmul = 1/mul, s = 1;
  for(i = bl-1; i >= 1; i--) {
/*    if(e > GHCJSBN_BITS) {
      e -= GHCJSBN_BITS;
      s *= rmul;
      r  = r + s * b[i];
    } else { */
      r = r * mul + s * b[i];
//    }
  }
  // h$log("remaning exp: " + e);
  if(e > 600) {
    r = r * Math.pow(2, e-600) * Math.pow(2,600);
  } else if(e < -600) {
    r = r * Math.pow(2, e+600) * Math.pow(2,-600);
  } else {
    r = r * Math.pow(2, e);
  }
  h$ghcjsbn_assertValid_d(r, "encodeDouble_b result");
  return pos ? r : -r;
}

function h$ghcjsbn_toDouble_b(nonNeg, b) {
  return h$ghcjsbn_encodeDouble_b(nonNeg, b, 0);
}

// fixme
var h$ghcjsbn_encodeDouble_i = h$ghcjsbn_encodeDouble_s;

function h$ghcjsbn_encodeDouble_s(m, e) {
  h$ghcjsbn_assertValid_s(m, "encodeDouble_s m");
  h$ghcjsbn_assertValid_s(e, "encodeDouble_s e");
  var r = m * Math.pow(2, e);
  h$ghcjsbn_assertValid_d(r, "encodeDouble_s result");
  return r;
}






// values defined in Gen2.ClosureInfo







// thread status

/*
 * low-level heap object manipulation macros
 */
// GHCJS.Prim.JSVal







// GHCJS.Prim.JSException





// Exception dictionary for JSException


// SomeException






// GHC.Ptr.Ptr






// GHC.Integer.GMP.Internals
// Data.Maybe.Maybe




// #define HS_NOTHING h$nothing






// Data.List
// Data.Text




// Data.Text.Lazy





// black holes
// can we skip the indirection for black holes?






// resumable thunks


// general deconstruction



// retrieve  a numeric value that's possibly stored as an indirection



// generic lazy values
// generic data constructors and selectors
// unboxed tuple returns
// #define RETURN_UBX_TUP1(x) return x;

function h$createWebSocket(url, protocols) {
  return new WebSocket(url, protocols);
}

/*
   this must be called before the websocket has connected,
   typically synchronously after creating the socket
 */
function h$openWebSocket(ws, mcb, ccb, c) {
  if(ws.readyState !== 0) {
    throw new Error("h$openWebSocket: unexpected readyState, socket must be CONNECTING");
  }
  ws.lastError = null;
  ws.onopen = function() {
    if(mcb) {
      ws.onmessage = mcb;
    }
    if(ccb || mcb) {
      ws.onclose = function(ce) {
        if(ws.onmessage) {
          h$release(ws.onmessage);
          ws.onmessage = null;
        }
        if(ccb) {
          h$release(ccb);
          ccb(ce);
        }
      };
    };
    ws.onerror = function(err) {
      ws.lastError = err;
      if(ws.onmessage) {
        h$release(ws.onmessage);
        ws.onmessage = null;
      }
      ws.close();
    };
    c(null);
  };
  ws.onerror = function(err) {
    if(ccb) h$release(ccb);
    if(mcb) h$release(mcb);
    ws.onmessage = null;
    ws.close();
    c(err);
  };
}

function h$closeWebSocket(status, reason, ws) {
  ws.onerror = null;
  if(ws.onmessage) {
    h$release(ws.onmessage);
    ws.onmessage = null;
  }
  ws.close(status, reason);
}






// values defined in Gen2.ClosureInfo







// thread status

/*
 * low-level heap object manipulation macros
 */
// GHCJS.Prim.JSVal







// GHCJS.Prim.JSException





// Exception dictionary for JSException


// SomeException






// GHC.Ptr.Ptr






// GHC.Integer.GMP.Internals
// Data.Maybe.Maybe




// #define HS_NOTHING h$nothing






// Data.List
// Data.Text




// Data.Text.Lazy





// black holes
// can we skip the indirection for black holes?






// resumable thunks


// general deconstruction



// retrieve  a numeric value that's possibly stored as an indirection



// generic lazy values
// generic data constructors and selectors
// unboxed tuple returns
// #define RETURN_UBX_TUP1(x) return x;

/*
   convert an array to a Haskell list, wrapping each element in a
   JSVal constructor
 */
function h$fromArray(a) {
    var r = h$ghczmprimZCGHCziTypesziZMZN;
    for(var i=a.length-1;i>=0;i--) r = (h$c2(h$ghczmprimZCGHCziTypesziZC_con_e, ((h$c1(h$ghcjszmprimZCGHCJSziPrimziJSVal_con_e, (a[i])))), (r)));
    return a;
}

/*
   convert an array to a Haskell list. No additional wrapping of the
   elements is performed. Only use this when the elements are directly
   usable as Haskell heap objects (numbers, boolean) or when the
   array elements have already been appropriately wrapped
 */
function h$fromArrayNoWrap(a) {
    var r = h$ghczmprimZCGHCziTypesziZMZN;
    for(var i=a.length-1;i>=0;i--) r = (h$c2(h$ghczmprimZCGHCziTypesziZC_con_e, (a[i]), (r)));
    return a;
}

/*
   convert a list of JSVal to an array. the list must have been fully forced,
   not just the spine.
 */
function h$listToArray(xs) {
    var a = [], i = 0;
    while(((xs).f === h$ghczmprimZCGHCziTypesziZC_con_e)) {
 a[i++] = ((((xs).d1)).d1);
 xs = ((xs).d2);
    }
    return a;
}

function h$listToArrayWrap(xs) {
    return (h$c1(h$ghcjszmprimZCGHCJSziPrimziJSVal_con_e, (h$listToArray(xs))));
}
function h$animationFrameCancel(h) {
    if(h.handle) window.cancelAnimationFrame(h.handle);
    if(h.callback) {
        h$release(h.callback)
        h.callback = null;
    }
}

function h$animationFrameRequest(h) {
    h.handle = window.requestAnimationFrame(function(ts) {
        var cb = h.callback;
        if(cb) {
         h$release(cb);
         h.callback = null;
         cb(ts);
        }
    });
}
function h$exportValue(fp1a,fp1b,fp2a,fp2b,o) {
  var e = { fp1a: fp1a
          , fp1b: fp1b
          , fp2a: fp2a
          , fp2b: fp2b
          , released: false
          , root: o
          , _key: -1
          };
  h$retain(e);
  return e;
}

function h$derefExport(fp1a,fp1b,fp2a,fp2b,e) {
  if(!e || typeof e !== 'object') return null;
  if(e.released) return null;
  if(fp1a !== e.fp1a || fp1b !== e.fp1b ||
     fp2a !== e.fp2a || fp2b !== e.fp2b) return null;
  return e.root;
}

function h$releaseExport(e) {
  h$release(e);
  e.released = true;
  e.root = null;
}






// values defined in Gen2.ClosureInfo







// thread status

/*
 * low-level heap object manipulation macros
 */
// GHCJS.Prim.JSVal







// GHCJS.Prim.JSException





// Exception dictionary for JSException


// SomeException






// GHC.Ptr.Ptr






// GHC.Integer.GMP.Internals
// Data.Maybe.Maybe




// #define HS_NOTHING h$nothing






// Data.List
// Data.Text




// Data.Text.Lazy





// black holes
// can we skip the indirection for black holes?






// resumable thunks


// general deconstruction



// retrieve  a numeric value that's possibly stored as an indirection



// generic lazy values
// generic data constructors and selectors
// unboxed tuple returns
// #define RETURN_UBX_TUP1(x) return x;

/*
 * Support code for the Data.JSString module. This code presents a JSString
 * as a sequence of code points and hides the underlying encoding ugliness of
 * the JavaScript strings.
 *
 * Use Data.JSString.Raw for direct access to the JSThis makes the operations more expen
 */

/*
 * Some workarounds here for JS engines that do not support proper
 * code point access
 */
var h$jsstringEmpty = (h$c1(h$ghcjszmprimZCGHCJSziPrimziJSVal_con_e, ('')));

var h$jsstringHead, h$jsstringTail, h$jsstringCons,
    h$jsstringSingleton, h$jsstringSnoc, h$jsstringUncons,
    h$jsstringIndex, h$jsstringUncheckedIndex,
    h$jsstringTake, h$jsstringDrop, h$jsstringTakeEnd, h$jsstringDropEnd;

if(String.prototype.codePointAt) {
    h$jsstringSingleton = function(ch) {
                                                        ;
 return String.fromCodePoint(ch);
    }
    h$jsstringHead = function(str) {
                                                    ;
 var cp = ch.codePointAt(0);
 return (cp === undefined) ? -1 : (cp|0);
    }
    h$jsstringTail = function(str) {
                                                    ;
 var l = str.length;
 if(l===0) return null;
 var ch = str.codePointAt(0);
 if(ch === undefined) return null;
 // string length is at least two if ch comes from a surrogate pair
 return str.substr(((ch)>=0x10000)?2:1);
    }
    h$jsstringCons = function(ch, str) {
                                                                      ;
 return String.fromCodePoint(ch)+str;
    }
    h$jsstringSnoc = function(str, ch) {
                                                                 ;
 return str+String.fromCodePoint(ch);
    }
    h$jsstringUncons = function(str) {
                                                             ;
 var l = str.length;
 if(l===0) return null;
 var ch = str.codePointAt(0);
        if(ch === undefined) {
     { h$ret1 = (null); return (null); };
        }
        { h$ret1 = (str.substr(((ch)>=0x10000)?2:1)); return (ch); };
    }
    // index is the first part of the character
    h$jsstringIndex = function(i, str) {
                                                                      ;
 var ch = str.codePointAt(i);
 if(ch === undefined) return -1;
 return ch;
    }
    h$jsstringUncheckedIndex = function(i, str) {
                                                                                      ;
 return str.codePointAt(i);
    }
} else {
    h$jsstringSingleton = function(ch) {
                                                           ;
 return (((ch)>=0x10000)) ? String.fromCharCode(((((ch)-0x10000)>>>10)+0xDC00), (((ch)&0x3FF)+0xD800))
                               : String.fromCharCode(ch);
    }
    h$jsstringHead = function(str) {
                                                       ;
 var l = str.length;
 if(l===0) return -1;
 var ch = str.charCodeAt(0);
 if(((ch|1023)===0xDBFF)) {
     return (l>1) ? ((((ch)-0xD800)<<10)+(str.charCodeAt(1))-9216) : -1;
 } else {
     return ch;
 }
    }
    h$jsstringTail = function(str) {
                                                       ;
 var l = str.length;
 if(l===0) return null;
 var ch = str.charCodeAt(0);
 if(((ch|1023)===0xDBFF)) {
     return (l>1)?str.substr(2):null;
 } else return str.substr(1);
    }
    h$jsstringCons = function(ch, str) {
                                                                         ;
 return ((((ch)>=0x10000)) ? String.fromCharCode(((((ch)-0x10000)>>>10)+0xDC00), (((ch)&0x3FF)+0xD800))
                                : String.fromCharCode(ch))
                                + str;
    }
    h$jsstringSnoc = function(str, ch) {
                                                                    ;
 return str + ((((ch)>=0x10000)) ? String.fromCharCode(((((ch)-0x10000)>>>10)+0xDC00), (((ch)&0x3FF)+0xD800))
                                      : String.fromCharCode(ch));
    }
    h$jsstringUncons = function(str) {
                                                                ;
 var l = str.length;
 if(l===0) return -1;
 var ch = str.charCodeAt(0);
 if(((ch|1023)===0xDBFF)) {
   if(l > 1) {
        { h$ret1 = (str.substr(2)); return (((((ch)-0xD800)<<10)+(str.charCodeAt(1))-9216)); };
   } else {
       { h$ret1 = (null); return (-1); };
   }
 } else {
      { h$ret1 = (str.substr(1)); return (ch); };
 }
    }
    // index is the first part of the character
    h$jsstringIndex = function(i, str) {
        // TRACE_JSSTRING("(no codePointAt) index: " + i + " '" + str + "'");
 var ch = str.charCodeAt(i);
 if(ch != ch) return -1; // NaN test
 return (((ch|1023)===0xDBFF)) ? ((((ch)-0xD800)<<10)+(str.charCodeAt(i+1))-9216) : ch;
    }
    h$jsstringUncheckedIndex = function(i, str) {
                                                                                         ;
 var ch = str.charCodeAt(i);
 return (((ch|1023)===0xDBFF)) ? ((((ch)-0xD800)<<10)+(str.charCodeAt(i+1))-9216) : ch;
    }
}

function h$jsstringPack(xs) {
    var r = '', i = 0, a = [], c;
    while(((xs).f === h$ghczmprimZCGHCziTypesziZC_con_e)) {
 c = ((xs).d1);
 a[i++] = ((typeof(c) === 'number')?(c):(c).d1);
 if(i >= 60000) {
     r += String.fromCharCode.apply(null, a);
     a = [];
     i = 0;
 }
 xs = ((xs).d2);
    }
    if(i > 0) r += String.fromCharCode.apply(null, a);
                                       ;
    return r;
}

function h$jsstringPackReverse(xs) {
    var a = [], i = 0, c;
    while(((xs).f === h$ghczmprimZCGHCziTypesziZC_con_e)) {
 c = ((xs).d1);
 a[i++] = ((typeof(c) === 'number')?(c):(c).d1);
 xs = ((xs).d2);
    }
    if(i===0) return '';
    var r = h$jsstringConvertArray(a.reverse());
                                              ;
    return r;
}

function h$jsstringPackArray(arr) {
                                        ;
    return h$jsstringConvertArray(arr);
}

function h$jsstringPackArrayReverse(arr) {
                                                ;
    return h$jsstringConvertArray(arr.reverse());
}

function h$jsstringConvertArray(arr) {
    if(arr.length < 60000) {
 return String.fromCharCode.apply(null, arr);
    } else {
 var r = '';
 for(var i=0; i<arr.length; i+=60000) {
     r += String.fromCharCode.apply(null, arr.slice(i, i+60000));
 }
 return r;
    }
}

function h$jsstringInit(str) {
                                         ;
    var l = str.length;
    if(l===0) return null;
    var ch = str.charCodeAt(l-1);
    var o = ((ch|1023)===0xDFFF)?2:1;
    var r = str.substr(0, l-o);
    return r;
}

function h$jsstringLast(str) {
                                         ;
    var l = str.length;
    if(l===0) return -1;
    var ch = str.charCodeAt(l-1);
    if(((ch|1023)===0xDFFF)) {
 return (l>1) ? ((((str.charCodeAt(l-2))-0xD800)<<10)+(ch)-9216) : -1;

    } else return ch;
}

// index is the last part of the character
function h$jsstringIndexR(i, str) {
                                                     ;
    if(i < 0 || i > str.length) return -1;
    var ch = str.charCodeAt(i);
    return (((ch|1023)===0xDFFF)) ? ((((str.charCodeAt(i-1))-0xD800)<<10)+(ch)-9216) : ch;
}

function h$jsstringNextIndex(i, str) {
                                                        ;
    return i + (((str.charCodeAt(i)|1023)===0xDBFF)?2:1);
}

function h$jsstringTake(n, str) {
                                                   ;
    if(n <= 0) return '';
    var i = 0, l = str.length, ch;
    if(n >= l) return str;
    while(n--) {
 ch = str.charCodeAt(i++);
 if(((ch|1023)===0xDBFF)) i++;
 if(i >= l) return str;
    }
    return str.substr(0,i);
}

function h$jsstringDrop(n, str) {
                                                   ;
    if(n <= 0) return str;
    var i = 0, l = str.length, ch;
    if(n >= l) return '';
    while(n--) {
 ch = str.charCodeAt(i++);
 if(((ch|1023)===0xDBFF)) i++;
 if(i >= l) return str;
    }
    return str.substr(i);
}

function h$jsstringSplitAt(n, str) {
                                                    ;
  if(n <= 0) {
    { h$ret1 = (str); return (""); };
  } else if(n >= str.length) {
    { h$ret1 = (""); return (str); };
  }
  var i = 0, l = str.length, ch;
  while(n--) {
    ch = str.charCodeAt(i++);
    if(((ch|1023)===0xDBFF)) i++;
    if(i >= l) {
      { h$ret1 = (""); return (str); };
    }
  }
  { h$ret1 = (str.substr(i)); return (str.substr(0,i)); };
}

function h$jsstringTakeEnd(n, str) {
                                                      ;
    if(n <= 0) return '';
    var l = str.length, i = l-1, ch;
    if(n >= l) return str;
    while(n-- && i > 0) {
 ch = str.charCodeAt(i--);
 if(((ch|1023)===0xDFFF)) i--;
    }
    return (i<0) ? str : str.substr(i+1);
}

function h$jsstringDropEnd(n, str) {
                                                      ;
    if(n <= 0) return str;
    var l = str.length, i = l-1, ch;
    if(n >= l) return '';
    while(n-- && i > 0) {
 ch = str.charCodeAt(i--);
 if(((ch|1023)===0xDFFF)) i--;
    }
    return (i<0) ? '' : str.substr(0,i+1);
}

function h$jsstringIntercalate(x, ys) {
                                              ;
    var a = [], i = 0;
    while(((ys).f === h$ghczmprimZCGHCziTypesziZC_con_e)) {
 if(i) a[i++] = x;
 a[i++] = ((((ys).d1)).d1);
 ys = ((ys).d2);
    }
    return a.join('');
}

function h$jsstringIntersperse(ch, ys) {
                                                          ;
    var i = 0, l = ys.length, j = 0, a = [], ych;
    if(((ch)>=0x10000)) {
 var ch1 = ((((ch)-0x10000)>>>10)+0xDC00), ch2 = (((ch)&0x3FF)+0xD800);
 while(j < l) {
     if(i) {
  a[i++] = ch1;
  a[i++] = ch2;
     }
     ych = ys.charCodeAt(j++);
     a[i++] = ych;
     if(((ych|1023)===0xDBFF)) a[i++] = ys.charCodeAt(j++);
 }
    } else {
 while(j < l) {
     if(i) a[i++] = ch;
     ych = ys.charCodeAt(j++);
     a[i++] = ych;
     if(((ych|1023)===0xDBFF)) a[i++] = ys.charCodeAt(j++);
 }
    }
    return h$jsstringConvertArray(a);
}

function h$jsstringConcat(xs) {
                            ;
    var a = [], i = 0;
    while(((xs).f === h$ghczmprimZCGHCziTypesziZC_con_e)) {
 a[i++] = ((((xs).d1)).d1);
 xs = ((xs).d2);
    }
    return a.join('');
}

var h$jsstringStripPrefix, h$jsstringStripSuffix,
    h$jsstringIsPrefixOf, h$jsstringIsSuffixOf,
    h$jsstringIsInfixOf;
if(String.prototype.startsWith) {
    h$jsstringStripPrefix = function(p, x) {
                                                                    ;
 if(x.startsWith(p)) {
     return (h$c1(h$baseZCGHCziBaseziJust_con_e, ((h$c1(h$ghcjszmprimZCGHCJSziPrimziJSVal_con_e, (x.substr(p.length)))))));
 } else {
     return h$baseZCGHCziBaseziNothing;
 }
    }

    h$jsstringIsPrefixOf = function(p, x) {
                                                                   ;
 return x.startsWith(p);
    }

} else {
    h$jsstringStripPrefix = function(p, x) {
                                                                       ;
 if(x.indexOf(p) === 0) { // this has worse complexity than it should
     return (h$c1(h$baseZCGHCziBaseziJust_con_e, ((h$c1(h$ghcjszmprimZCGHCJSziPrimziJSVal_con_e, (x.substr(p.length)))))));
 } else {
   return h$baseZCGHCziBaseziNothing;
 }
    }

    h$jsstringIsPrefixOf = function(p, x) {
                                                                      ;
 return x.indexOf(p) === 0; // this has worse complexity than it should
    }
}

if(String.prototype.endsWith) {
    h$jsstringStripSuffix = function(s, x) {
                                                                  ;
 if(x.endsWith(s)) {
     return (h$c1(h$baseZCGHCziBaseziJust_con_e, ((h$c1(h$ghcjszmprimZCGHCJSziPrimziJSVal_con_e, (x.substr(0,x.length-s.length)))))));
 } else {
   return h$baseZCGHCziBaseziNothing;
 }
    }

    h$jsstringIsSuffixOf = function(s, x) {
                                                                 ;
 return x.endsWith(s);
    }
} else {
    h$jsstringStripSuffix = function(s, x) {
                                                                     ;
 var i = x.lastIndexOf(s); // this has worse complexity than it should
 var l = x.length - s.length;
 if(i !== -1 && i === l) {
     return (h$c1(h$baseZCGHCziBaseziJust_con_e, ((h$c1(h$ghcjszmprimZCGHCJSziPrimziJSVal_con_e, (x.substr(0,l)))))));
 } else {
   return h$baseZCGHCziBaseziNothing;
 }
    }

      h$jsstringIsSuffixOf = function(s, x) {
                                                                    ;
        var i = x.lastIndexOf(s); // this has worse complexity than it should
 return i !== -1 && i === x.length - s.length;
    }
}

if(String.prototype.includes) {
    h$jsstringIsInfixOf = function(i, x) {
                                                                       ;
 return x.includes(i);
    }
} else {
    h$jsstringIsInfixOf = function(i, x) {
                                                                          ;
 return x.indexOf(i) !== -1; // this has worse complexity than it should
    }
}

function h$jsstringCommonPrefixes(x, y) {
                                                             ;
    var lx = x.length, ly = y.length, i = 0, cx;
    var l = lx <= ly ? lx : ly;
    if(lx === 0 || ly === 0 || x.charCodeAt(0) !== y.charCodeAt(0)) {
      return h$baseZCGHCziBaseziNothing;
    }
    while(++i<l) {
 cx = x.charCodeAt(i);
 if(cx !== y.charCodeAt(i)) {
     if(((cx|1023)===0xDFFF)) i--;
     break;
 }
    }
  if(i===0) return h$baseZCGHCziBaseziNothing;
    return (h$c1(h$baseZCGHCziBaseziJust_con_e, ((h$c3(h$ghczmprimZCGHCziTupleziZLz2cUz2cUZR_con_e,((h$c1(h$ghcjszmprimZCGHCJSziPrimziJSVal_con_e, ((i===lx)?x:((i===ly)?y:x.substr(0,i)))))),((i===lx) ? h$jsstringEmpty : (h$c1(h$ghcjszmprimZCGHCJSziPrimziJSVal_con_e, (x.substr(i))))),((i===ly) ? h$jsstringEmpty : (h$c1(h$ghcjszmprimZCGHCJSziPrimziJSVal_con_e, (y.substr(i))))))))));



}

function h$jsstringBreakOn(b, x) {
                                                      ;
    var i = x.indexOf(b);
    if(i===-1) {
        { h$ret1 = (""); return (x); };
    }
    if(i===0) {
        { h$ret1 = (x); return (""); };
    }
    { h$ret1 = (x.substr(i)); return (x.substr(0,i)); };
}

function h$jsstringBreakOnEnd(b, x) {
                                                         ;
    var i = x.lastIndexOf(b);
  if(i===-1) {
    { h$ret1 = (x); return (""); };

    }
  i += b.length;
    { h$ret1 = (x.substr(i)); return (x.substr(0,i)); };
}

function h$jsstringBreakOnAll1(n, b, x) {
                                                                    ;
    var i = x.indexOf(b, n);
    if(i===0) {
       { h$ret1 = (""); h$ret2 = (x); return (b.length); };
    }
    if(i===-1) {
       { h$ret1 = (null); h$ret2 = (null); return (-1); };
    }
    { h$ret1 = (x.substr(0,i)); h$ret2 = (x.substr(i)); return (i+b.length); };
}

function h$jsstringBreakOnAll(pat, src) {
                                ;
    var a = [], i = 0, n = 0, r = h$ghczmprimZCGHCziTypesziZMZN, pl = pat.length;
    while(true) {
 var x = src.indexOf(pat, n);
 if(x === -1) break;
 a[i++] = (h$c2(h$ghczmprimZCGHCziTupleziZLz2cUZR_con_e,((h$c1(h$ghcjszmprimZCGHCJSziPrimziJSVal_con_e, (src.substr(0,x))))),((h$c1(h$ghcjszmprimZCGHCJSziPrimziJSVal_con_e, (src.substr(x)))))));
 n = x + pl;
    }
    while(--i >= 0) r = (h$c2(h$ghczmprimZCGHCziTypesziZC_con_e, (a[i]), (r)));
    return r;
}

function h$jsstringSplitOn1(n, p, x) {
                                                                 ;
    var i = x.indexOf(p, n);
    if(i === -1) {
        { h$ret1 = (null); return (-1); };
    }
    var r1 = (i==n) ? "" : x.substr(n, i-n);
    { h$ret1 = (r1); return (i + p.length); };
}

function h$jsstringSplitOn(p, x) {
                                                      ;
    var a = x.split(p);
    var r = h$ghczmprimZCGHCziTypesziZMZN, i = a.length;
    while(--i>=0) r = (h$c2(h$ghczmprimZCGHCziTypesziZC_con_e, ((h$c1(h$ghcjszmprimZCGHCJSziPrimziJSVal_con_e, (a[i])))), (r)));
    return r;
}

// returns -1 for end of input, start of next token otherwise
// word in h$ret1
// this function assumes that there are no whitespace characters >= 0x10000
function h$jsstringWords1(n, x) {
                                                   ;
    var m = n, s = n, l = x.length;
    if(m >= l) return -1;
    // skip leading spaces
    do {
 if(m >= l) return -1;
    } while(h$isSpace(x.charCodeAt(m++)));
    // found start of word
    s = m - 1;
    while(m < l) {
 if(h$isSpace(x.charCodeAt(m++))) {
     // found end of word
            var r1 = (m-s<=1) ? "" : x.substr(s,m-s-1);
            { h$ret1 = (r1); return (m); };
 }
    }
    // end of string
    if(s < l) {
        var r1 = s === 0 ? x : x.substr(s);
        { h$ret1 = (r1); return (m); };
    }
    { h$ret1 = (null); return (-1); };
}

function h$jsstringWords(x) {
                                        ;
    var a = null, i = 0, n, s = -1, m = 0, w, l = x.length, r = h$ghczmprimZCGHCziTypesziZMZN;
    outer:
    while(m < l) {
 // skip leading spaces
 do {
     if(m >= l) { s = m; break outer; }
 } while(h$isSpace(x.charCodeAt(m++)));
 // found start of word
 s = m - 1;
 while(m < l) {
     if(h$isSpace(x.charCodeAt(m++))) {
  // found end of word
  w = (m-s<=1) ? h$jsstringEmpty
                             : (h$c1(h$ghcjszmprimZCGHCJSziPrimziJSVal_con_e, (x.substr(s,m-s-1))));
  if(i) a[i++] = w; else { a = [w]; i = 1; }
  s = m;
  break;
     }
 }
    }
    // end of string
    if(s !== -1 && s < l) {
 w = (h$c1(h$ghcjszmprimZCGHCJSziPrimziJSVal_con_e, (s === 0 ? x : x.substr(s))));
 if(i) a[i++] = w; else { a = [w]; i = 1; }
    }
    // build resulting list
    while(--i>=0) r = (h$c2(h$ghczmprimZCGHCziTypesziZC_con_e, (a[i]), (r)));
    return r;
}

// returns -1 for end of input, start of next token otherwise
// line in h$ret1
function h$jsstringLines1(n, x) {
                                                   ;
    var m = n, l = x.length;
    if(n >= l) return -1;
    while(m < l) {
 if(x.charCodeAt(m++) === 10) {
     // found newline
     if(n > 0 && n === l-1) return -1; // it was the last character
            var r1 = (m-n<=1) ? "" : x.substr(n,m-n-1);
            { h$ret1 = (r1); return (m); };
 }
    }
    // end of string
    { h$ret1 = (x.substr(n)); return (m); };
}

function h$jsstringLines(x) {
                                        ;
    var a = null, m = 0, i = 0, l = x.length, s = 0, r = h$ghczmprimZCGHCziTypesziZMZN, w;
    if(l === 0) return h$ghczmprimZCGHCziTypesziZMZN;
    outer:
    while(true) {
 s = m;
 do {
     if(m >= l) break outer;
 } while(x.charCodeAt(m++) !== 10);
 w = (m-s<=1) ? h$jsstringEmpty : (h$c1(h$ghcjszmprimZCGHCJSziPrimziJSVal_con_e, (x.substr(s,m-s-1))));
 if(i) a[i++] = w; else { a = [w]; i = 1; }
    }
    if(s < l) {
 w = (h$c1(h$ghcjszmprimZCGHCJSziPrimziJSVal_con_e, (x.substr(s))));
 if(i) a[i++] = w; else { a = [w]; i = 1; }
    }
    while(--i>=0) r = (h$c2(h$ghczmprimZCGHCziTypesziZC_con_e, (a[i]), (r)));
    return r;
}

function h$jsstringGroup(x) {
                                        ;
    var xl = x.length;
    if(xl === 0) return h$ghczmprimZCGHCziTypesziZMZN;
    var i = xl-1, si, ch, s=xl, r=h$ghczmprimZCGHCziTypesziZMZN;
    var tch = x.charCodeAt(i--);
    if(((tch|1023)===0xDFFF)) tch = ((((x.charCodeAt(i--))-0xD800)<<10)+(tch)-9216);
    while(i >= 0) {
 si = i;
 ch = x.charCodeAt(i--);
 if(((ch|1023)===0xDFFF)) {
     ch = ((((x.charCodeAt(i--))-0xD800)<<10)+(ch)-9216);
 }
 if(ch != tch) {
     tch = ch;
     r = (h$c2(h$ghczmprimZCGHCziTypesziZC_con_e, ((h$c1(h$ghcjszmprimZCGHCJSziPrimziJSVal_con_e, (x.substr(si+1,s-si))))), (r)));
     s = si;
 }
    }
    return (h$c2(h$ghczmprimZCGHCziTypesziZC_con_e, ((h$c1(h$ghcjszmprimZCGHCJSziPrimziJSVal_con_e, (x.substr(0,s+1))))), (r)));
}

function h$jsstringChunksOf1(n, s, x) {
                                                                ;
    var m = s, c = 0, l = x.length, ch;
    if(n <= 0 || l === 0 || s >= l) return -1
    while(++m < l && ++c < n) {
 ch = x.charCodeAt(m);
 if(((ch|1023)===0xDBFF)) ++m;
    }
    var r1 = (m >= l && s === c) ? x : x.substr(s,m-s);
    { h$ret1 = (r1); return (m); };
}

function h$jsstringChunksOf(n, x) {
                                                     ;
    var l = x.length;
    if(l===0 || n <= 0) return h$ghczmprimZCGHCziTypesziZMZN;
    if(l <= n) return (h$c2(h$ghczmprimZCGHCziTypesziZC_con_e, ((h$c1(h$ghcjszmprimZCGHCJSziPrimziJSVal_con_e, (x)))), (h$ghczmprimZCGHCziTypesziZMZN)));
    var a = [], i = 0, s = 0, ch, m = 0, c, r = h$ghczmprimZCGHCziTypesziZMZN;
    while(m < l) {
 s = m;
 c = 0;
 while(m < l && ++c <= n) {
     ch = x.charCodeAt(m++);
     if(((ch|1023)===0xDBFF)) ++m;
 }
 if(c) a[i++] = x.substr(s, m-s);
    }
    while(--i>=0) r = (h$c2(h$ghczmprimZCGHCziTypesziZC_con_e, ((h$c1(h$ghcjszmprimZCGHCJSziPrimziJSVal_con_e, (a[i])))), (r)));
    return r;
}

function h$jsstringCount(pat, src) {
                                                        ;
    var i = 0, n = 0, pl = pat.length, sl = src.length;
    while(i<sl) {
 i = src.indexOf(pat, i);
 if(i===-1) break;
 n++;
 i += pl;
    }
    return n;
}

function h$jsstringReplicate(n, str) {
                                                        ;
    if(n === 0 || str == '') return '';
    if(n === 1) return str;
    var r = '';
    do {
 if(n&1) r+=str;
        str+=str;
        n >>= 1;
    } while(n > 1);
    return r+str;
}

// this does not deal with combining diacritics, Data.Text does not either
var h$jsstringReverse;
if(Array.from) {
    h$jsstringReverse = function(str) {
                                                      ;
 return Array.from(str).reverse().join('');
    }
} else {
    h$jsstringReverse = function(str) {
                                                         ;
 var l = str.length, a = [], o = 0, i = 0, c, c1, s = '';
 while(i < l) {
     c = str.charCodeAt(i);
     if(((c|1023)===0xDBFF)) {
  a[i] = str.charCodeAt(i+1);
  a[i+1] = c;
  i += 2;
     } else a[i++] = c;
     if(i-o > 60000) {
  s = String.fromCharCode.apply(null, a.reverse()) + s;
  o = -i;
  a = [];
     }
 }
 return (i===0) ? s : String.fromCharCode.apply(null,a.reverse()) + s;
    }
}

function h$jsstringUnpack(str) {
                                           ;
    var r = h$ghczmprimZCGHCziTypesziZMZN, i = str.length-1, c;
    while(i >= 0) {
 c = str.charCodeAt(i--);
 if(((c|1023)===0xDFFF)) c = ((((str.charCodeAt(i--))-0xD800)<<10)+(c)-9216)
 r = (h$c2(h$ghczmprimZCGHCziTypesziZC_con_e, (c), (r)));
    }
    return r;
}

function h$jsstringDecI64(hi,lo) {
                                              ;
    var lo0 = (lo < 0) ? lo+4294967296:lo;
    if(hi < 0) {
 if(hi === -1) return ''+(lo0-4294967296);
 lo0 = 4294967296 - lo0;
 var hi0 = -1 - hi;
 var x0 = hi0 * 967296;
 var x1 = (lo0 + x0) % 1000000;
 var x2 = hi0*4294+Math.floor((x0+lo0-x1)/1000000);
 return '-' + x2 + h$jsstringDecIPadded6(x1);
    } else {
 if(hi === 0) return ''+lo0;
 var x0 = hi * 967296;
 var x1 = (lo0 + x0) % 1000000;
 var x2 = hi*4294+Math.floor((x0+lo0-x1)/1000000);
 return '' + x2 + h$jsstringDecIPadded6(x1);
    }
}

function h$jsstringDecW64(hi,lo) {
                                              ;
    var lo0 = (lo < 0) ? lo+4294967296 : lo;
    if(hi === 0) return ''+lo0;
    var hi0 = (hi < 0) ? hi+4294967296 : hi;
    var x0 = hi0 * 967296;
    var x1 = (lo0 + x0) % 1000000;
    var x2 = hi0*4294+Math.floor((x0+lo0-x1)/1000000);
    return '' + x2 + h$jsstringDecIPadded6(x1);
}

function h$jsstringHexI64(hi,lo) {
    var lo0 = lo<0 ? lo+4294967296 : lo;
    if(hi === 0) return lo0.toString(16);
    return ((hi<0)?hi+4294967296:hi).toString(16) + h$jsstringHexIPadded8(lo0);
}

function h$jsstringHexW64(hi,lo) {
    var lo0 = lo<0 ? lo+4294967296 : lo;
    if(hi === 0) return lo0.toString(16);
    return ((hi<0)?hi+4294967296:hi).toString(16) + h$jsstringHexIPadded8(lo0);
}

// n in [0, 1000000000)
function h$jsstringDecIPadded9(n) {
                                       ;
    if(n === 0) return '000000000';
    var pad = (n>=100000000)?'':
              (n>=10000000)?'0':
              (n>=1000000)?'00':
              (n>=100000)?'000':
              (n>=10000)?'0000':
              (n>=1000)?'00000':
              (n>=100)?'000000':
              (n>=10)?'0000000':
                     '00000000';
    return pad+n;
}

// n in [0, 1000000)
function h$jsstringDecIPadded6(n) {
                                       ;
    if(n === 0) return '000000';
    var pad = (n>=100000)?'':
              (n>=10000)?'0':
              (n>=1000)?'00':
              (n>=100)?'000':
              (n>=10)?'0000':
                     '00000';
    return pad+n;
}

// n in [0, 2147483648)
function h$jsstringHexIPadded8(n) {
                                       ;
   if(n === 0) return '00000000';
   var pad = (n>=0x10000000)?'':
             (n>=0x1000000)?'0':
             (n>=0x100000)?'00':
             (n>=0x10000)?'000':
             (n>=0x1000)?'0000':
             (n>=0x100)?'00000':
             (n>=0x10)?'000000':
                      '0000000';
    return pad+n.toString(16);
}

function h$jsstringZeroes(n) {
    var r;
    switch(n&7) {
 case 0: r = ''; break;
 case 1: r = '0'; break;
 case 2: r = '00'; break;
 case 3: r = '000'; break;
 case 4: r = '0000'; break;
 case 5: r = '00000'; break;
 case 6: r = '000000'; break;
 case 7: r = '0000000';
    }
    for(var i=n>>3;i>0;i--) r = r + '00000000';
    return r;
}

function h$jsstringDoubleToFixed(decs, d) {
    if(decs >= 0) {
 if(Math.abs(d) < 1e21) {
     var r = d.toFixed(Math.min(20,decs));
     if(decs > 20) r = r + h$jsstringZeroes(decs-20);
     return r;
 } else {
     var r = d.toExponential();
     var ei = r.indexOf('e');
     var di = r.indexOf('.');
     var e = parseInt(r.substr(ei+1));
     return r.substring(0,di) + r.substring(di,ei) + h$jsstringZeroes(di-ei+e) +
                   ((decs > 0) ? ('.' + h$jsstringZeroes(decs)) : '');
 }
    }
    var r = Math.abs(d).toExponential();
    var ei = r.indexOf('e');
    var e = parseInt(r.substr(ei+1));
    var m = d < 0 ? '-' : '';
    r = r.substr(0,1) + r.substring(2,ei);
    if(e >= 0) {
 return (e > r.length) ? m + r + h$jsstringZeroes(r.length-e-1) + '.0'
                       : m + r.substr(0,e+1) + '.' + r.substr(e+1);
    } else {
 return m + '0.' + h$jsstringZeroes(-e-1) + r;
    }
}

function h$jsstringDoubleToExponent(decs, d) {
    var r;
    if(decs ===-1) {
 r = d.toExponential().replace('+','');
    } else {
 r = d.toExponential(Math.max(1, Math.min(20,decs))).replace('+','');
    }
    if(r.indexOf('.') === -1) {
 r = r.replace('e', '.0e');
    }
    if(decs > 20) r = r.replace('e', h$jsstringZeroes(decs-20)+'e');
    return r;
}

function h$jsstringDoubleGeneric(decs, d) {
    var r;
    if(decs === -1) {
 r = d.toString(10).replace('+','');
    } else {
 r = d.toPrecision(Math.max(decs+1,1)).replace('+','');
    }
    if(decs !== 0 && r.indexOf('.') === -1) {
 if(r.indexOf('e') !== -1) {
     r = r.replace('e', '.0e');
 } else {
     r = r + '.0';
 }
    }
    return r;
}

function h$jsstringAppend(x, y) {
                                                     ;
    return x+y;
}

function h$jsstringCompare(x, y) {
                                                      ;
    return (x<y)?-1:((x>y)?1:0);
}

function h$jsstringUnlines(xs) {
    var r = '';
    while(((xs).f === h$ghczmprimZCGHCziTypesziZC_con_e)) {
 r = r + ((((xs).d1)).d1) + '\n';
 xs = ((xs).d2);
    }
    return r;
}

function h$jsstringUnwords(xs) {
    if(((xs).f === h$ghczmprimZCGHCziTypesziZMZN_con_e)) return '';
    var r = ((((xs).d1)).d1);
    xs = ((xs).d2);
    while(((xs).f === h$ghczmprimZCGHCziTypesziZC_con_e)) {
 r = r + ' ' + ((((xs).d1)).d1);
 xs = ((xs).d2);
    }
    return r;
}

function h$jsstringReplace(pat, rep, src) {
                                                                        ;
    var r = src.replace(pat, rep, 'g');
    // the 'g' flag is not supported everywhere, check and fall back if necessary
    if(r.indexOf(pat) !== -1) {
 r = src.split(pat).join(rep);
    }
    return r;
}

function h$jsstringReplicateChar(n, ch) {
                                                    ;
    return h$jsstringReplicate(n, h$jsstringSingleton(ch));
}

function h$jsstringIsInteger(str) {
    return /^-?\d+$/.test(str);
}

function h$jsstringIsNatural(str) {
    return /^\d+$/.test(str);
}

function h$jsstringReadInt(str) {
    if(!/^-?\d+/.test(str)) return null;
    var x = parseInt(str, 10);
    var x0 = x|0;
    return (x===x0) ? x0 : null;
}

function h$jsstringLenientReadInt(str) {
    var x = parseInt(str, 10);
    var x0 = x|0;
    return (x===x0) ? x0 : null;
}

function h$jsstringReadWord(str) {
  if(!/^\d+/.test(str)) return null;
  var x = parseInt(str, 10);
  var x0 = x|0;
  if(x0<0) return (x===x0+2147483648) ? x0 : null;
  else return (x===x0) ? x0 : null;
}

function h$jsstringReadDouble(str) {
    return parseFloat(str, 10);
}

function h$jsstringLenientReadDouble(str) {
    return parseFloat(str, 10);
}

function h$jsstringReadInteger(str) {
                                       ;
  if(!/^(-)?\d+$/.test(str)) {
    return null;
  } else if(str.length <= 9) {
    return (h$c1(h$integerzmgmpZCGHCziIntegerziTypeziSzh_con_e, (parseInt(str, 10))));;
  } else {
    return MK_INTEGER_J(new BigInteger(str, 10));
  }
}

function h$jsstringReadInt64(str) {
  if(!/^(-)?\d+$/.test(str)) {
      { h$ret1 = (0); h$ret2 = (0); return (0); };
  }
  if(str.charCodeAt(0) === 45) { // '-'
    return h$jsstringReadValue64(str, 1, true);
  } else {
    return h$jsstringReadValue64(str, 0, false);
  }
}

function h$jsstringReadWord64(str) {
  if(!/^\d+$/.test(str)) {
    { h$ret1 = (0); h$ret2 = (0); return (0); };
  }
  return h$jsstringReadValue64(str, 0, false);
}

var h$jsstringLongs = null;

function h$jsstringReadValue64(str, start, negate) {
  var l = str.length, i = start;
  while(i < l) {
    if(str.charCodeAt(i) !== 48) break;
    i++;
  }
  if(i >= l) { h$ret1 = (0); h$ret2 = (0); return (1); }; // only zeroes
  if(h$jsstringLongs === null) {
    h$jsstringLongs = [];
    for(var t=10; t<=1000000000; t*=10) {
      h$jsstringLongs.push(goog.math.Long.fromInt(t));
    }
  }
  var li = l-i;
  if(li < 10 && !negate) {
    { h$ret1 = (0); h$ret2 = (parseInt(str.substr(i), 10)); return (1); };
  }
  var r = goog.math.Long.fromInt(parseInt(str.substr(li,9),10));
  li += 9;
  while(li < l) {
    r = r.multiply(h$jsstringLongs[Math.min(l-li-1,8)])
         .add(goog.math.Long.fromInt(parseInt(str.substr(li,9), 10)));
    li += 9;
  }
  if(negate) {
    r = r.negate();
  }
  { h$ret1 = (r.getHighBits()); h$ret2 = (r.getLowBits()); return (1); };
}

function h$jsstringExecRE(i, str, re) {
    re.lastIndex = i;
    var m = re.exec(str);
    if(m === null) return -1;
    var a = [], x, j = 1, r = h$ghczmprimZCGHCziTypesziZMZN;
    while(true) {
 x = m[j];
 if(typeof x === 'undefined') break;
 a[j-1] = x;
 j++;
    }
    j-=1;
    while(--j>=0) r = (h$c2(h$ghczmprimZCGHCziTypesziZC_con_e, ((h$c1(h$ghcjszmprimZCGHCJSziPrimziJSVal_con_e, (a[j])))), (r)));
    { h$ret1 = (m[0]); h$ret2 = (r); return (m.index); };
}

function h$jsstringReplaceRE(pat, replacement, str) {
    return str.replace(pat, replacement);
}

function h$jsstringSplitRE(limit, re, str) {
    re.lastIndex = i;
    var s = (limit < 0) ? str.split(re) : str.split(re, limit);
    var i = s.length, r = h$ghczmprimZCGHCziTypesziZMZN;
    while(--i>=0) r = (h$c2(h$ghczmprimZCGHCziTypesziZC_con_e, ((h$c1(h$ghcjszmprimZCGHCJSziPrimziJSVal_con_e, (a[i])))), (r)));
    return r;
}






// values defined in Gen2.ClosureInfo







// thread status

/*
 * low-level heap object manipulation macros
 */
// GHCJS.Prim.JSVal







// GHCJS.Prim.JSException





// Exception dictionary for JSException


// SomeException






// GHC.Ptr.Ptr






// GHC.Integer.GMP.Internals
// Data.Maybe.Maybe




// #define HS_NOTHING h$nothing






// Data.List
// Data.Text




// Data.Text.Lazy





// black holes
// can we skip the indirection for black holes?






// resumable thunks


// general deconstruction



// retrieve  a numeric value that's possibly stored as an indirection



// generic lazy values
// generic data constructors and selectors
// unboxed tuple returns
// #define RETURN_UBX_TUP1(x) return x;

/*
 * Functions that directly access JavaScript strings, ignoring character
 * widths and surrogate pairs.
 */

function h$jsstringRawChunksOf(k, x) {
    var l = x.length;
    if(l === 0) return h$ghczmprimZCGHCziTypesziZMZN;
    if(l <= k) return (h$c2(h$ghczmprimZCGHCziTypesziZC_con_e, ((h$c1(h$ghcjszmprimZCGHCJSziPrimziJSVal_con_e, (x)))), (h$ghczmprimZCGHCziTypesziZMZN)));
    var r=h$ghczmprimZCGHCziTypesziZMZN;
    for(var i=ls-k;i>=0;i-=k) r = (h$c2(h$ghczmprimZCGHCziTypesziZC_con_e, ((h$c1(h$ghcjszmprimZCGHCJSziPrimziJSVal_con_e, (x.substr(i,i+k))))), (r)));
    return r;
}

function h$jsstringRawSplitAt(k, x) {
    if(k === 0) return (h$c2(h$ghczmprimZCGHCziTupleziZLz2cUZR_con_e,(h$jsstringEmpty),((h$c1(h$ghcjszmprimZCGHCJSziPrimziJSVal_con_e, (x))))));
    if(k >= x.length) return (h$c2(h$ghczmprimZCGHCziTupleziZLz2cUZR_con_e,((h$c1(h$ghcjszmprimZCGHCJSziPrimziJSVal_con_e, (x)))),(h$jsstringEmpty)));
    return (h$c2(h$ghczmprimZCGHCziTupleziZLz2cUZR_con_e,((h$c1(h$ghcjszmprimZCGHCJSziPrimziJSVal_con_e, (x.substr(0,k))))),((h$c1(h$ghcjszmprimZCGHCJSziPrimziJSVal_con_e, (x.substr(k)))))));
}
function h$foreignListProps(o) {
    var r = HS_NIL;
    if(typeof o === 'undefined' || o === null) return null;
    throw "h$foreignListProps";
/*    for(var p in o) {

    } */
}
// conversion between JavaScript string and Data.Text







// values defined in Gen2.ClosureInfo







// thread status

/*
 * low-level heap object manipulation macros
 */
// GHCJS.Prim.JSVal







// GHCJS.Prim.JSException





// Exception dictionary for JSException


// SomeException






// GHC.Ptr.Ptr






// GHC.Integer.GMP.Internals
// Data.Maybe.Maybe




// #define HS_NOTHING h$nothing






// Data.List
// Data.Text




// Data.Text.Lazy





// black holes
// can we skip the indirection for black holes?






// resumable thunks


// general deconstruction



// retrieve  a numeric value that's possibly stored as an indirection



// generic lazy values
// generic data constructors and selectors
// unboxed tuple returns
// #define RETURN_UBX_TUP1(x) return x;


/*
  convert a Data.Text buffer with offset/length to a JavaScript string
 */
function h$textToString(arr, off, len) {
    var a = [];
    var end = off+len;
    var k = 0;
    var u1 = arr.u1;
    var s = '';
    for(var i=off;i<end;i++) {
 var cc = u1[i];
 a[k++] = cc;
 if(k === 60000) {
     s += String.fromCharCode.apply(this, a);
     k = 0;
     a = [];
 }
    }
    return s + String.fromCharCode.apply(this, a);
}

/*
   convert a JavaScript string to a Data.Text buffer, second return
   value is length
 */
function h$textFromString(s) {
    var l = s.length;
    var b = h$newByteArray(l * 2);
    var u1 = b.u1;
    for(var i=l-1;i>=0;i--) u1[i] = s.charCodeAt(i);
    { h$ret1 = (l); return (b); };
}

function h$lazyTextToString(txt) {
    var s = '';
    while(((txt).f.a === 2)) {
        var head = ((txt));
        s += h$textToString(((head).d1), ((head).d2.d1), ((head).d2.d2));
        txt = ((txt).d2.d3);
    }
    return s;
}

function h$safeTextFromString(x) {
    if(typeof x !== 'string') {
 { h$ret1 = (0); return (null); };
    }
    return h$textFromString(x);
}






// values defined in Gen2.ClosureInfo







// thread status

/*
 * low-level heap object manipulation macros
 */
// GHCJS.Prim.JSVal







// GHCJS.Prim.JSException





// Exception dictionary for JSException


// SomeException






// GHC.Ptr.Ptr






// GHC.Integer.GMP.Internals
// Data.Maybe.Maybe




// #define HS_NOTHING h$nothing






// Data.List
// Data.Text




// Data.Text.Lazy





// black holes
// can we skip the indirection for black holes?






// resumable thunks


// general deconstruction



// retrieve  a numeric value that's possibly stored as an indirection



// generic lazy values
// generic data constructors and selectors
// unboxed tuple returns
// #define RETURN_UBX_TUP1(x) return x;

function h$allProps(o) {
    var a = [], i = 0;
    for(var p in o) a[i++] = p;
    return a;
}

function h$listProps(o) {
    var r = h$ghczmprimZCGHCziTypesziZMZN;
    for(var p in o) { r = (h$c2(h$ghczmprimZCGHCziTypesziZC_con_e, ((h$c1(h$ghcjszmprimZCGHCJSziPrimziJSVal_con_e, (p)))), (r))); }
    return r;
}

function h$listAssocs(o) {
    var r = h$ghczmprimZCGHCziTypesziZMZN;
    for(var p in o) { r = (h$c2(h$ghczmprimZCGHCziTypesziZC_con_e, ((h$c2(h$ghczmprimZCGHCziTupleziZLz2cUZR_con_e,((h$c1(h$ghcjszmprimZCGHCJSziPrimziJSVal_con_e, (p)))),((h$c1(h$ghcjszmprimZCGHCJSziPrimziJSVal_con_e, (o[p]))))))), (r))); }
    return r;
}

function h$isNumber(o) {
    return typeof(o) === 'number';
}

// returns true for null, but not for functions and host objects
function h$isObject(o) {
    return typeof(o) === 'object';
}

function h$isString(o) {
    return typeof(o) === 'string';
}

function h$isSymbol(o) {
    return typeof(o) === 'symbol';
}

function h$isBoolean(o) {
    return typeof(o) === 'boolean';
}

function h$isFunction(o) {
    return typeof(o) === 'function';
}

function h$jsTypeOf(o) {
    var t = typeof(o);
    if(t === 'undefined') return 0;
    if(t === 'object') return 1;
    if(t === 'boolean') return 2;
    if(t === 'number') return 3;
    if(t === 'string') return 4;
    if(t === 'symbol') return 5;
    if(t === 'function') return 6;
    return 7; // other, host object etc
}

/*
        -- 0 - null, 1 - integer,
        -- 2 - float, 3 - bool,
        -- 4 - string, 5 - array
        -- 6 - object
*/
function h$jsonTypeOf(o) {
    if (!(o instanceof Object)) {
        if (o == null) {
            return 0;
        } else if (typeof o == 'number') {
            if (h$isInteger(o)) {
                return 1;
            } else {
                return 2;
            }
        } else if (typeof o == 'boolean') {
            return 3;
        } else {
            return 4;
        }
    } else {
        if (Object.prototype.toString.call(o) == '[object Array]') {
            // it's an array
            return 5;
        } else if (!o) {
            // null 
            return 0;
        } else {
            // it's an object
            return 6;
        }
    }

}
function h$sendXHR(xhr, d, cont) {
    xhr.addEventListener('error', function () {
 cont(2);
    });
    xhr.addEventListener('abort', function() {
 cont(1);
    });
    xhr.addEventListener('load', function() {
 cont(0);
    });
    if(d) {
 xhr.send(d);
    } else {
 xhr.send();
    }
}
(function e(t,n,r){function s(o,u){if(!n[o]){if(!t[o]){var a=typeof require=="function"&&require;if(!u&&a)return a(o,!0);if(i)return i(o,!0);var f=new Error("Cannot find module '"+o+"'");throw f.code="MODULE_NOT_FOUND",f}var l=n[o]={exports:{}};t[o][0].call(l.exports,function(e){var n=t[o][1][e];return s(n?n:e)},l,l.exports,e,t,n,r)}return n[o].exports}var i=typeof require=="function"&&require;for(var o=0;o<r.length;o++)s(r[o]);return s})({1:[function(require,module,exports){(function(global){global.h$concur={React:require("react"),ReactDOM:require("react-dom"),makeHandler:function(action,async){var f=function(ev){return h$concurEventCallback(async,action,ev)};f.hsAction=action;return f}}}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{react:183,"react-dom":31}],2:[function(require,module,exports){(function(process){"use strict";var _assign=require("object-assign");var emptyObject=require("fbjs/lib/emptyObject");var _invariant=require("fbjs/lib/invariant");if(process.env.NODE_ENV!=="production"){var warning=require("fbjs/lib/warning")}var MIXINS_KEY="mixins";function identity(fn){return fn}var ReactPropTypeLocationNames;if(process.env.NODE_ENV!=="production"){ReactPropTypeLocationNames={prop:"prop",context:"context",childContext:"child context"}}else{ReactPropTypeLocationNames={}}function factory(ReactComponent,isValidElement,ReactNoopUpdateQueue){var injectedMixins=[];var ReactClassInterface={mixins:"DEFINE_MANY",statics:"DEFINE_MANY",propTypes:"DEFINE_MANY",contextTypes:"DEFINE_MANY",childContextTypes:"DEFINE_MANY",getDefaultProps:"DEFINE_MANY_MERGED",getInitialState:"DEFINE_MANY_MERGED",getChildContext:"DEFINE_MANY_MERGED",render:"DEFINE_ONCE",componentWillMount:"DEFINE_MANY",componentDidMount:"DEFINE_MANY",componentWillReceiveProps:"DEFINE_MANY",shouldComponentUpdate:"DEFINE_ONCE",componentWillUpdate:"DEFINE_MANY",componentDidUpdate:"DEFINE_MANY",componentWillUnmount:"DEFINE_MANY",updateComponent:"OVERRIDE_BASE"};var RESERVED_SPEC_KEYS={displayName:function(Constructor,displayName){Constructor.displayName=displayName},mixins:function(Constructor,mixins){if(mixins){for(var i=0;i<mixins.length;i++){mixSpecIntoComponent(Constructor,mixins[i])}}},childContextTypes:function(Constructor,childContextTypes){if(process.env.NODE_ENV!=="production"){validateTypeDef(Constructor,childContextTypes,"childContext")}Constructor.childContextTypes=_assign({},Constructor.childContextTypes,childContextTypes)},contextTypes:function(Constructor,contextTypes){if(process.env.NODE_ENV!=="production"){validateTypeDef(Constructor,contextTypes,"context")}Constructor.contextTypes=_assign({},Constructor.contextTypes,contextTypes)},getDefaultProps:function(Constructor,getDefaultProps){if(Constructor.getDefaultProps){Constructor.getDefaultProps=createMergedResultFunction(Constructor.getDefaultProps,getDefaultProps)}else{Constructor.getDefaultProps=getDefaultProps}},propTypes:function(Constructor,propTypes){if(process.env.NODE_ENV!=="production"){validateTypeDef(Constructor,propTypes,"prop")}Constructor.propTypes=_assign({},Constructor.propTypes,propTypes)},statics:function(Constructor,statics){mixStaticSpecIntoComponent(Constructor,statics)},autobind:function(){}};function validateTypeDef(Constructor,typeDef,location){for(var propName in typeDef){if(typeDef.hasOwnProperty(propName)){if(process.env.NODE_ENV!=="production"){warning(typeof typeDef[propName]==="function","%s: %s type `%s` is invalid; it must be a function, usually from "+"React.PropTypes.",Constructor.displayName||"ReactClass",ReactPropTypeLocationNames[location],propName)}}}}function validateMethodOverride(isAlreadyDefined,name){var specPolicy=ReactClassInterface.hasOwnProperty(name)?ReactClassInterface[name]:null;if(ReactClassMixin.hasOwnProperty(name)){_invariant(specPolicy==="OVERRIDE_BASE","ReactClassInterface: You are attempting to override "+"`%s` from your class specification. Ensure that your method names "+"do not overlap with React methods.",name)}if(isAlreadyDefined){_invariant(specPolicy==="DEFINE_MANY"||specPolicy==="DEFINE_MANY_MERGED","ReactClassInterface: You are attempting to define "+"`%s` on your component more than once. This conflict may be due "+"to a mixin.",name)}}function mixSpecIntoComponent(Constructor,spec){if(!spec){if(process.env.NODE_ENV!=="production"){var typeofSpec=typeof spec;var isMixinValid=typeofSpec==="object"&&spec!==null;if(process.env.NODE_ENV!=="production"){warning(isMixinValid,"%s: You're attempting to include a mixin that is either null "+"or not an object. Check the mixins included by the component, "+"as well as any mixins they include themselves. "+"Expected object but got %s.",Constructor.displayName||"ReactClass",spec===null?null:typeofSpec)}}return}_invariant(typeof spec!=="function","ReactClass: You're attempting to "+"use a component class or function as a mixin. Instead, just use a "+"regular object.");_invariant(!isValidElement(spec),"ReactClass: You're attempting to "+"use a component as a mixin. Instead, just use a regular object.");var proto=Constructor.prototype;var autoBindPairs=proto.__reactAutoBindPairs;if(spec.hasOwnProperty(MIXINS_KEY)){RESERVED_SPEC_KEYS.mixins(Constructor,spec.mixins)}for(var name in spec){if(!spec.hasOwnProperty(name)){continue}if(name===MIXINS_KEY){continue}var property=spec[name];var isAlreadyDefined=proto.hasOwnProperty(name);validateMethodOverride(isAlreadyDefined,name);if(RESERVED_SPEC_KEYS.hasOwnProperty(name)){RESERVED_SPEC_KEYS[name](Constructor,property)}else{var isReactClassMethod=ReactClassInterface.hasOwnProperty(name);var isFunction=typeof property==="function";var shouldAutoBind=isFunction&&!isReactClassMethod&&!isAlreadyDefined&&spec.autobind!==false;if(shouldAutoBind){autoBindPairs.push(name,property);proto[name]=property}else{if(isAlreadyDefined){var specPolicy=ReactClassInterface[name];_invariant(isReactClassMethod&&(specPolicy==="DEFINE_MANY_MERGED"||specPolicy==="DEFINE_MANY"),"ReactClass: Unexpected spec policy %s for key %s "+"when mixing in component specs.",specPolicy,name);if(specPolicy==="DEFINE_MANY_MERGED"){proto[name]=createMergedResultFunction(proto[name],property)}else if(specPolicy==="DEFINE_MANY"){proto[name]=createChainedFunction(proto[name],property)}}else{proto[name]=property;if(process.env.NODE_ENV!=="production"){if(typeof property==="function"&&spec.displayName){proto[name].displayName=spec.displayName+"_"+name}}}}}}}function mixStaticSpecIntoComponent(Constructor,statics){if(!statics){return}for(var name in statics){var property=statics[name];if(!statics.hasOwnProperty(name)){continue}var isReserved=name in RESERVED_SPEC_KEYS;_invariant(!isReserved,"ReactClass: You are attempting to define a reserved "+'property, `%s`, that shouldn\'t be on the "statics" key. Define it '+"as an instance property instead; it will still be accessible on the "+"constructor.",name);var isInherited=name in Constructor;_invariant(!isInherited,"ReactClass: You are attempting to define "+"`%s` on your component more than once. This conflict may be "+"due to a mixin.",name);Constructor[name]=property}}function mergeIntoWithNoDuplicateKeys(one,two){_invariant(one&&two&&typeof one==="object"&&typeof two==="object","mergeIntoWithNoDuplicateKeys(): Cannot merge non-objects.");for(var key in two){if(two.hasOwnProperty(key)){_invariant(one[key]===undefined,"mergeIntoWithNoDuplicateKeys(): "+"Tried to merge two objects with the same key: `%s`. This conflict "+"may be due to a mixin; in particular, this may be caused by two "+"getInitialState() or getDefaultProps() methods returning objects "+"with clashing keys.",key);one[key]=two[key]}}return one}function createMergedResultFunction(one,two){return function mergedResult(){var a=one.apply(this,arguments);var b=two.apply(this,arguments);if(a==null){return b}else if(b==null){return a}var c={};mergeIntoWithNoDuplicateKeys(c,a);mergeIntoWithNoDuplicateKeys(c,b);return c}}function createChainedFunction(one,two){return function chainedFunction(){one.apply(this,arguments);two.apply(this,arguments)}}function bindAutoBindMethod(component,method){var boundMethod=method.bind(component);if(process.env.NODE_ENV!=="production"){boundMethod.__reactBoundContext=component;boundMethod.__reactBoundMethod=method;boundMethod.__reactBoundArguments=null;var componentName=component.constructor.displayName;var _bind=boundMethod.bind;boundMethod.bind=function(newThis){for(var _len=arguments.length,args=Array(_len>1?_len-1:0),_key=1;_key<_len;_key++){args[_key-1]=arguments[_key]}if(newThis!==component&&newThis!==null){if(process.env.NODE_ENV!=="production"){warning(false,"bind(): React component methods may only be bound to the "+"component instance. See %s",componentName)}}else if(!args.length){if(process.env.NODE_ENV!=="production"){warning(false,"bind(): You are binding a component method to the component. "+"React does this for you automatically in a high-performance "+"way, so you can safely remove this call. See %s",componentName)}return boundMethod}var reboundMethod=_bind.apply(boundMethod,arguments);reboundMethod.__reactBoundContext=component;reboundMethod.__reactBoundMethod=method;reboundMethod.__reactBoundArguments=args;return reboundMethod}}return boundMethod}function bindAutoBindMethods(component){var pairs=component.__reactAutoBindPairs;for(var i=0;i<pairs.length;i+=2){var autoBindKey=pairs[i];var method=pairs[i+1];component[autoBindKey]=bindAutoBindMethod(component,method)}}var IsMountedPreMixin={componentDidMount:function(){this.__isMounted=true}};var IsMountedPostMixin={componentWillUnmount:function(){this.__isMounted=false}};var ReactClassMixin={replaceState:function(newState,callback){this.updater.enqueueReplaceState(this,newState,callback)},isMounted:function(){if(process.env.NODE_ENV!=="production"){warning(this.__didWarnIsMounted,"%s: isMounted is deprecated. Instead, make sure to clean up "+"subscriptions and pending requests in componentWillUnmount to "+"prevent memory leaks.",this.constructor&&this.constructor.displayName||this.name||"Component");this.__didWarnIsMounted=true}return!!this.__isMounted}};var ReactClassComponent=function(){};_assign(ReactClassComponent.prototype,ReactComponent.prototype,ReactClassMixin);function createClass(spec){var Constructor=identity(function(props,context,updater){if(process.env.NODE_ENV!=="production"){warning(this instanceof Constructor,"Something is calling a React component directly. Use a factory or "+"JSX instead. See: https://fb.me/react-legacyfactory")}if(this.__reactAutoBindPairs.length){bindAutoBindMethods(this)}this.props=props;this.context=context;this.refs=emptyObject;this.updater=updater||ReactNoopUpdateQueue;this.state=null;var initialState=this.getInitialState?this.getInitialState():null;if(process.env.NODE_ENV!=="production"){if(initialState===undefined&&this.getInitialState._isMockFunction){initialState=null}}_invariant(typeof initialState==="object"&&!Array.isArray(initialState),"%s.getInitialState(): must return an object or null",Constructor.displayName||"ReactCompositeComponent");this.state=initialState});Constructor.prototype=new ReactClassComponent;Constructor.prototype.constructor=Constructor;Constructor.prototype.__reactAutoBindPairs=[];injectedMixins.forEach(mixSpecIntoComponent.bind(null,Constructor));mixSpecIntoComponent(Constructor,IsMountedPreMixin);mixSpecIntoComponent(Constructor,spec);mixSpecIntoComponent(Constructor,IsMountedPostMixin);if(Constructor.getDefaultProps){Constructor.defaultProps=Constructor.getDefaultProps()}if(process.env.NODE_ENV!=="production"){if(Constructor.getDefaultProps){Constructor.getDefaultProps.isReactClassApproved={}}if(Constructor.prototype.getInitialState){Constructor.prototype.getInitialState.isReactClassApproved={}}}_invariant(Constructor.prototype.render,"createClass(...): Class specification must implement a `render` method.");if(process.env.NODE_ENV!=="production"){warning(!Constructor.prototype.componentShouldUpdate,"%s has a method called "+"componentShouldUpdate(). Did you mean shouldComponentUpdate()? "+"The name is phrased as a question because the function is "+"expected to return a value.",spec.displayName||"A component");warning(!Constructor.prototype.componentWillRecieveProps,"%s has a method called "+"componentWillRecieveProps(). Did you mean componentWillReceiveProps()?",spec.displayName||"A component")}for(var methodName in ReactClassInterface){if(!Constructor.prototype[methodName]){Constructor.prototype[methodName]=null}}return Constructor}return createClass}module.exports=factory}).call(this,require("_process"))},{_process:184,"fbjs/lib/emptyObject":11,"fbjs/lib/invariant":18,"fbjs/lib/warning":25,"object-assign":26}],3:[function(require,module,exports){(function(process){"use strict";var emptyFunction=require("./emptyFunction");var EventListener={listen:function listen(target,eventType,callback){if(target.addEventListener){target.addEventListener(eventType,callback,false);return{remove:function remove(){target.removeEventListener(eventType,callback,false)}}}else if(target.attachEvent){target.attachEvent("on"+eventType,callback);return{remove:function remove(){target.detachEvent("on"+eventType,callback)}}}},capture:function capture(target,eventType,callback){if(target.addEventListener){target.addEventListener(eventType,callback,true);return{remove:function remove(){target.removeEventListener(eventType,callback,true)}}}else{if(process.env.NODE_ENV!=="production"){console.error("Attempted to listen to events during the capture phase on a "+"browser that does not support the capture phase. Your application "+"will not receive some events.")}return{remove:emptyFunction}}},registerDefault:function registerDefault(){}};module.exports=EventListener}).call(this,require("_process"))},{"./emptyFunction":10,_process:184}],4:[function(require,module,exports){"use strict";var canUseDOM=!!(typeof window!=="undefined"&&window.document&&window.document.createElement);var ExecutionEnvironment={canUseDOM:canUseDOM,canUseWorkers:typeof Worker!=="undefined",canUseEventListeners:canUseDOM&&!!(window.addEventListener||window.attachEvent),canUseViewport:canUseDOM&&!!window.screen,isInWorker:!canUseDOM};module.exports=ExecutionEnvironment},{}],5:[function(require,module,exports){"use strict";var _hyphenPattern=/-(.)/g;function camelize(string){return string.replace(_hyphenPattern,function(_,character){return character.toUpperCase()})}module.exports=camelize},{}],6:[function(require,module,exports){"use strict";var camelize=require("./camelize");var msPattern=/^-ms-/;function camelizeStyleName(string){return camelize(string.replace(msPattern,"ms-"))}module.exports=camelizeStyleName},{"./camelize":5}],7:[function(require,module,exports){"use strict";var isTextNode=require("./isTextNode");function containsNode(outerNode,innerNode){if(!outerNode||!innerNode){return false}else if(outerNode===innerNode){return true}else if(isTextNode(outerNode)){return false}else if(isTextNode(innerNode)){return containsNode(outerNode,innerNode.parentNode)}else if("contains"in outerNode){return outerNode.contains(innerNode)}else if(outerNode.compareDocumentPosition){return!!(outerNode.compareDocumentPosition(innerNode)&16)}else{return false}}module.exports=containsNode},{"./isTextNode":20}],8:[function(require,module,exports){(function(process){"use strict";var invariant=require("./invariant");function toArray(obj){var length=obj.length;!(!Array.isArray(obj)&&(typeof obj==="object"||typeof obj==="function"))?process.env.NODE_ENV!=="production"?invariant(false,"toArray: Array-like object expected"):invariant(false):void 0;!(typeof length==="number")?process.env.NODE_ENV!=="production"?invariant(false,"toArray: Object needs a length property"):invariant(false):void 0;!(length===0||length-1 in obj)?process.env.NODE_ENV!=="production"?invariant(false,"toArray: Object should have keys for indices"):invariant(false):void 0;!(typeof obj.callee!=="function")?process.env.NODE_ENV!=="production"?invariant(false,"toArray: Object can't be `arguments`. Use rest params "+"(function(...args) {}) or Array.from() instead."):invariant(false):void 0;if(obj.hasOwnProperty){try{return Array.prototype.slice.call(obj)}catch(e){}}var ret=Array(length);for(var ii=0;ii<length;ii++){ret[ii]=obj[ii]}return ret}function hasArrayNature(obj){return!!obj&&(typeof obj=="object"||typeof obj=="function")&&"length"in obj&&!("setInterval"in obj)&&typeof obj.nodeType!="number"&&(Array.isArray(obj)||"callee"in obj||"item"in obj)}function createArrayFromMixed(obj){if(!hasArrayNature(obj)){return[obj]}else if(Array.isArray(obj)){return obj.slice()}else{return toArray(obj)}}module.exports=createArrayFromMixed}).call(this,require("_process"))},{"./invariant":18,_process:184}],9:[function(require,module,exports){(function(process){"use strict";var ExecutionEnvironment=require("./ExecutionEnvironment");var createArrayFromMixed=require("./createArrayFromMixed");var getMarkupWrap=require("./getMarkupWrap");var invariant=require("./invariant");var dummyNode=ExecutionEnvironment.canUseDOM?document.createElement("div"):null;var nodeNamePattern=/^\s*<(\w+)/;function getNodeName(markup){var nodeNameMatch=markup.match(nodeNamePattern);return nodeNameMatch&&nodeNameMatch[1].toLowerCase()}function createNodesFromMarkup(markup,handleScript){var node=dummyNode;!!!dummyNode?process.env.NODE_ENV!=="production"?invariant(false,"createNodesFromMarkup dummy not initialized"):invariant(false):void 0;var nodeName=getNodeName(markup);var wrap=nodeName&&getMarkupWrap(nodeName);if(wrap){node.innerHTML=wrap[1]+markup+wrap[2];var wrapDepth=wrap[0];while(wrapDepth--){node=node.lastChild}}else{node.innerHTML=markup}var scripts=node.getElementsByTagName("script");if(scripts.length){!handleScript?process.env.NODE_ENV!=="production"?invariant(false,"createNodesFromMarkup(...): Unexpected <script> element rendered."):invariant(false):void 0;createArrayFromMixed(scripts).forEach(handleScript)}var nodes=Array.from(node.childNodes);while(node.lastChild){node.removeChild(node.lastChild)}return nodes}module.exports=createNodesFromMarkup}).call(this,require("_process"))},{"./ExecutionEnvironment":4,"./createArrayFromMixed":8,"./getMarkupWrap":14,"./invariant":18,_process:184}],10:[function(require,module,exports){"use strict";function makeEmptyFunction(arg){return function(){return arg}}var emptyFunction=function emptyFunction(){};emptyFunction.thatReturns=makeEmptyFunction;emptyFunction.thatReturnsFalse=makeEmptyFunction(false);emptyFunction.thatReturnsTrue=makeEmptyFunction(true);emptyFunction.thatReturnsNull=makeEmptyFunction(null);emptyFunction.thatReturnsThis=function(){return this};emptyFunction.thatReturnsArgument=function(arg){return arg};module.exports=emptyFunction},{}],11:[function(require,module,exports){(function(process){"use strict";var emptyObject={};if(process.env.NODE_ENV!=="production"){Object.freeze(emptyObject)}module.exports=emptyObject}).call(this,require("_process"))},{_process:184}],12:[function(require,module,exports){"use strict";function focusNode(node){try{node.focus()}catch(e){}}module.exports=focusNode},{}],13:[function(require,module,exports){"use strict";function getActiveElement(doc){doc=doc||(typeof document!=="undefined"?document:undefined);if(typeof doc==="undefined"){return null}try{return doc.activeElement||doc.body}catch(e){return doc.body}}module.exports=getActiveElement},{}],14:[function(require,module,exports){(function(process){"use strict";var ExecutionEnvironment=require("./ExecutionEnvironment");var invariant=require("./invariant");var dummyNode=ExecutionEnvironment.canUseDOM?document.createElement("div"):null;var shouldWrap={};var selectWrap=[1,'<select multiple="true">',"</select>"];var tableWrap=[1,"<table>","</table>"];var trWrap=[3,"<table><tbody><tr>","</tr></tbody></table>"];var svgWrap=[1,'<svg xmlns="http://www.w3.org/2000/svg">',"</svg>"];var markupWrap={"*":[1,"?<div>","</div>"],area:[1,"<map>","</map>"],col:[2,"<table><tbody></tbody><colgroup>","</colgroup></table>"],legend:[1,"<fieldset>","</fieldset>"],param:[1,"<object>","</object>"],tr:[2,"<table><tbody>","</tbody></table>"],optgroup:selectWrap,option:selectWrap,caption:tableWrap,colgroup:tableWrap,tbody:tableWrap,tfoot:tableWrap,thead:tableWrap,td:trWrap,th:trWrap};var svgElements=["circle","clipPath","defs","ellipse","g","image","line","linearGradient","mask","path","pattern","polygon","polyline","radialGradient","rect","stop","text","tspan"];svgElements.forEach(function(nodeName){markupWrap[nodeName]=svgWrap;shouldWrap[nodeName]=true});function getMarkupWrap(nodeName){!!!dummyNode?process.env.NODE_ENV!=="production"?invariant(false,"Markup wrapping node not initialized"):invariant(false):void 0;if(!markupWrap.hasOwnProperty(nodeName)){nodeName="*"}if(!shouldWrap.hasOwnProperty(nodeName)){if(nodeName==="*"){dummyNode.innerHTML="<link />"}else{dummyNode.innerHTML="<"+nodeName+"></"+nodeName+">"}shouldWrap[nodeName]=!dummyNode.firstChild}return shouldWrap[nodeName]?markupWrap[nodeName]:null}module.exports=getMarkupWrap}).call(this,require("_process"))},{"./ExecutionEnvironment":4,"./invariant":18,_process:184}],15:[function(require,module,exports){"use strict";function getUnboundedScrollPosition(scrollable){if(scrollable.Window&&scrollable instanceof scrollable.Window){return{x:scrollable.pageXOffset||scrollable.document.documentElement.scrollLeft,y:scrollable.pageYOffset||scrollable.document.documentElement.scrollTop}}return{x:scrollable.scrollLeft,y:scrollable.scrollTop}}module.exports=getUnboundedScrollPosition},{}],16:[function(require,module,exports){"use strict";var _uppercasePattern=/([A-Z])/g;function hyphenate(string){return string.replace(_uppercasePattern,"-$1").toLowerCase()}module.exports=hyphenate},{}],17:[function(require,module,exports){"use strict";var hyphenate=require("./hyphenate");var msPattern=/^ms-/;function hyphenateStyleName(string){return hyphenate(string).replace(msPattern,"-ms-")}module.exports=hyphenateStyleName},{"./hyphenate":16}],18:[function(require,module,exports){(function(process){"use strict";var validateFormat=function validateFormat(format){};if(process.env.NODE_ENV!=="production"){validateFormat=function validateFormat(format){if(format===undefined){throw new Error("invariant requires an error message argument")}}}function invariant(condition,format,a,b,c,d,e,f){validateFormat(format);if(!condition){var error;if(format===undefined){error=new Error("Minified exception occurred; use the non-minified dev environment "+"for the full error message and additional helpful warnings.")}else{var args=[a,b,c,d,e,f];var argIndex=0;error=new Error(format.replace(/%s/g,function(){return args[argIndex++]}));error.name="Invariant Violation"}error.framesToPop=1;throw error}}module.exports=invariant}).call(this,require("_process"))},{_process:184}],19:[function(require,module,exports){"use strict";function isNode(object){var doc=object?object.ownerDocument||object:document;var defaultView=doc.defaultView||window;return!!(object&&(typeof defaultView.Node==="function"?object instanceof defaultView.Node:typeof object==="object"&&typeof object.nodeType==="number"&&typeof object.nodeName==="string"))}module.exports=isNode},{}],20:[function(require,module,exports){"use strict";var isNode=require("./isNode");function isTextNode(object){return isNode(object)&&object.nodeType==3}module.exports=isTextNode},{"./isNode":19}],21:[function(require,module,exports){"use strict";function memoizeStringOnly(callback){var cache={};return function(string){if(!cache.hasOwnProperty(string)){cache[string]=callback.call(this,string)}return cache[string]}}module.exports=memoizeStringOnly},{}],22:[function(require,module,exports){"use strict";var ExecutionEnvironment=require("./ExecutionEnvironment");var performance;if(ExecutionEnvironment.canUseDOM){performance=window.performance||window.msPerformance||window.webkitPerformance}module.exports=performance||{}},{"./ExecutionEnvironment":4}],23:[function(require,module,exports){"use strict";var performance=require("./performance");var performanceNow;if(performance.now){performanceNow=function performanceNow(){return performance.now()}}else{performanceNow=function performanceNow(){return Date.now()}}module.exports=performanceNow},{"./performance":22}],24:[function(require,module,exports){"use strict";var hasOwnProperty=Object.prototype.hasOwnProperty;function is(x,y){if(x===y){return x!==0||y!==0||1/x===1/y}else{return x!==x&&y!==y}}function shallowEqual(objA,objB){if(is(objA,objB)){return true}if(typeof objA!=="object"||objA===null||typeof objB!=="object"||objB===null){return false}var keysA=Object.keys(objA);var keysB=Object.keys(objB);if(keysA.length!==keysB.length){return false}for(var i=0;i<keysA.length;i++){if(!hasOwnProperty.call(objB,keysA[i])||!is(objA[keysA[i]],objB[keysA[i]])){return false}}return true}module.exports=shallowEqual},{}],25:[function(require,module,exports){(function(process){"use strict";var emptyFunction=require("./emptyFunction");var warning=emptyFunction;if(process.env.NODE_ENV!=="production"){var printWarning=function printWarning(format){for(var _len=arguments.length,args=Array(_len>1?_len-1:0),_key=1;_key<_len;_key++){args[_key-1]=arguments[_key]}var argIndex=0;var message="Warning: "+format.replace(/%s/g,function(){return args[argIndex++]});if(typeof console!=="undefined"){console.error(message)}try{throw new Error(message)}catch(x){}};warning=function warning(condition,format){if(format===undefined){throw new Error("`warning(condition, format, ...args)` requires a warning "+"message argument")}if(format.indexOf("Failed Composite propType: ")===0){return}if(!condition){for(var _len2=arguments.length,args=Array(_len2>2?_len2-2:0),_key2=2;_key2<_len2;_key2++){args[_key2-2]=arguments[_key2]}printWarning.apply(undefined,[format].concat(args))}}}module.exports=warning}).call(this,require("_process"))},{"./emptyFunction":10,_process:184}],26:[function(require,module,exports){"use strict";var getOwnPropertySymbols=Object.getOwnPropertySymbols;var hasOwnProperty=Object.prototype.hasOwnProperty;var propIsEnumerable=Object.prototype.propertyIsEnumerable;function toObject(val){if(val===null||val===undefined){throw new TypeError("Object.assign cannot be called with null or undefined")}return Object(val)}function shouldUseNative(){try{if(!Object.assign){return false}var test1=new String("abc");test1[5]="de";if(Object.getOwnPropertyNames(test1)[0]==="5"){return false}var test2={};for(var i=0;i<10;i++){test2["_"+String.fromCharCode(i)]=i}var order2=Object.getOwnPropertyNames(test2).map(function(n){return test2[n]});if(order2.join("")!=="0123456789"){return false}var test3={};"abcdefghijklmnopqrst".split("").forEach(function(letter){test3[letter]=letter});if(Object.keys(Object.assign({},test3)).join("")!=="abcdefghijklmnopqrst"){return false}return true}catch(err){return false}}module.exports=shouldUseNative()?Object.assign:function(target,source){var from;var to=toObject(target);var symbols;for(var s=1;s<arguments.length;s++){from=Object(arguments[s]);for(var key in from){if(hasOwnProperty.call(from,key)){to[key]=from[key]}}if(getOwnPropertySymbols){symbols=getOwnPropertySymbols(from);for(var i=0;i<symbols.length;i++){if(propIsEnumerable.call(from,symbols[i])){to[symbols[i]]=from[symbols[i]]}}}}return to}},{}],27:[function(require,module,exports){(function(process){"use strict";if(process.env.NODE_ENV!=="production"){var invariant=require("fbjs/lib/invariant");var warning=require("fbjs/lib/warning");var ReactPropTypesSecret=require("./lib/ReactPropTypesSecret");var loggedTypeFailures={}}function checkPropTypes(typeSpecs,values,location,componentName,getStack){if(process.env.NODE_ENV!=="production"){for(var typeSpecName in typeSpecs){if(typeSpecs.hasOwnProperty(typeSpecName)){var error;try{invariant(typeof typeSpecs[typeSpecName]==="function","%s: %s type `%s` is invalid; it must be a function, usually from "+"React.PropTypes.",componentName||"React class",location,typeSpecName);error=typeSpecs[typeSpecName](values,typeSpecName,componentName,location,null,ReactPropTypesSecret)}catch(ex){error=ex}warning(!error||error instanceof Error,"%s: type specification of %s `%s` is invalid; the type checker "+"function must return `null` or an `Error` but returned a %s. "+"You may have forgotten to pass an argument to the type checker "+"creator (arrayOf, instanceOf, objectOf, oneOf, oneOfType, and "+"shape all require an argument).",componentName||"React class",location,typeSpecName,typeof error);if(error instanceof Error&&!(error.message in loggedTypeFailures)){loggedTypeFailures[error.message]=true;var stack=getStack?getStack():"";warning(false,"Failed %s type: %s%s",location,error.message,stack!=null?stack:"")}}}}}module.exports=checkPropTypes}).call(this,require("_process"))},{"./lib/ReactPropTypesSecret":30,_process:184,"fbjs/lib/invariant":18,"fbjs/lib/warning":25}],28:[function(require,module,exports){"use strict";var factory=require("./factoryWithTypeCheckers");module.exports=function(isValidElement){var throwOnDirectAccess=false;return factory(isValidElement,throwOnDirectAccess)}},{"./factoryWithTypeCheckers":29}],29:[function(require,module,exports){(function(process){"use strict";var emptyFunction=require("fbjs/lib/emptyFunction");var invariant=require("fbjs/lib/invariant");var warning=require("fbjs/lib/warning");var ReactPropTypesSecret=require("./lib/ReactPropTypesSecret");var checkPropTypes=require("./checkPropTypes");module.exports=function(isValidElement,throwOnDirectAccess){var ITERATOR_SYMBOL=typeof Symbol==="function"&&Symbol.iterator;var FAUX_ITERATOR_SYMBOL="@@iterator";function getIteratorFn(maybeIterable){var iteratorFn=maybeIterable&&(ITERATOR_SYMBOL&&maybeIterable[ITERATOR_SYMBOL]||maybeIterable[FAUX_ITERATOR_SYMBOL]);if(typeof iteratorFn==="function"){return iteratorFn}}var ANONYMOUS="<<anonymous>>";var ReactPropTypes={array:createPrimitiveTypeChecker("array"),bool:createPrimitiveTypeChecker("boolean"),func:createPrimitiveTypeChecker("function"),number:createPrimitiveTypeChecker("number"),object:createPrimitiveTypeChecker("object"),string:createPrimitiveTypeChecker("string"),symbol:createPrimitiveTypeChecker("symbol"),any:createAnyTypeChecker(),arrayOf:createArrayOfTypeChecker,element:createElementTypeChecker(),instanceOf:createInstanceTypeChecker,node:createNodeChecker(),objectOf:createObjectOfTypeChecker,oneOf:createEnumTypeChecker,oneOfType:createUnionTypeChecker,shape:createShapeTypeChecker};function is(x,y){if(x===y){return x!==0||1/x===1/y}else{return x!==x&&y!==y}}function PropTypeError(message){this.message=message;this.stack=""}PropTypeError.prototype=Error.prototype;function createChainableTypeChecker(validate){if(process.env.NODE_ENV!=="production"){var manualPropTypeCallCache={};var manualPropTypeWarningCount=0}function checkType(isRequired,props,propName,componentName,location,propFullName,secret){componentName=componentName||ANONYMOUS;propFullName=propFullName||propName;if(secret!==ReactPropTypesSecret){if(throwOnDirectAccess){invariant(false,"Calling PropTypes validators directly is not supported by the `prop-types` package. "+"Use `PropTypes.checkPropTypes()` to call them. "+"Read more at http://fb.me/use-check-prop-types")}else if(process.env.NODE_ENV!=="production"&&typeof console!=="undefined"){var cacheKey=componentName+":"+propName;if(!manualPropTypeCallCache[cacheKey]&&manualPropTypeWarningCount<3){warning(false,"You are manually calling a React.PropTypes validation "+"function for the `%s` prop on `%s`. This is deprecated "+"and will throw in the standalone `prop-types` package. "+"You may be seeing this warning due to a third-party PropTypes "+"library. See https://fb.me/react-warning-dont-call-proptypes "+"for details.",propFullName,componentName);manualPropTypeCallCache[cacheKey]=true;manualPropTypeWarningCount++}}}if(props[propName]==null){if(isRequired){if(props[propName]===null){return new PropTypeError("The "+location+" `"+propFullName+"` is marked as required "+("in `"+componentName+"`, but its value is `null`."))}return new PropTypeError("The "+location+" `"+propFullName+"` is marked as required in "+("`"+componentName+"`, but its value is `undefined`."))}return null}else{return validate(props,propName,componentName,location,propFullName)}}var chainedCheckType=checkType.bind(null,false);chainedCheckType.isRequired=checkType.bind(null,true);return chainedCheckType}function createPrimitiveTypeChecker(expectedType){function validate(props,propName,componentName,location,propFullName,secret){var propValue=props[propName];var propType=getPropType(propValue);if(propType!==expectedType){var preciseType=getPreciseType(propValue);return new PropTypeError("Invalid "+location+" `"+propFullName+"` of type "+("`"+preciseType+"` supplied to `"+componentName+"`, expected ")+("`"+expectedType+"`."))}return null}return createChainableTypeChecker(validate)}function createAnyTypeChecker(){return createChainableTypeChecker(emptyFunction.thatReturnsNull)}function createArrayOfTypeChecker(typeChecker){function validate(props,propName,componentName,location,propFullName){if(typeof typeChecker!=="function"){return new PropTypeError("Property `"+propFullName+"` of component `"+componentName+"` has invalid PropType notation inside arrayOf.")}var propValue=props[propName];if(!Array.isArray(propValue)){var propType=getPropType(propValue);return new PropTypeError("Invalid "+location+" `"+propFullName+"` of type "+("`"+propType+"` supplied to `"+componentName+"`, expected an array."))}for(var i=0;i<propValue.length;i++){var error=typeChecker(propValue,i,componentName,location,propFullName+"["+i+"]",ReactPropTypesSecret);if(error instanceof Error){return error}}return null}return createChainableTypeChecker(validate)}function createElementTypeChecker(){function validate(props,propName,componentName,location,propFullName){var propValue=props[propName];if(!isValidElement(propValue)){var propType=getPropType(propValue);return new PropTypeError("Invalid "+location+" `"+propFullName+"` of type "+("`"+propType+"` supplied to `"+componentName+"`, expected a single ReactElement."))}return null}return createChainableTypeChecker(validate)}function createInstanceTypeChecker(expectedClass){function validate(props,propName,componentName,location,propFullName){if(!(props[propName]instanceof expectedClass)){var expectedClassName=expectedClass.name||ANONYMOUS;var actualClassName=getClassName(props[propName]);return new PropTypeError("Invalid "+location+" `"+propFullName+"` of type "+("`"+actualClassName+"` supplied to `"+componentName+"`, expected ")+("instance of `"+expectedClassName+"`."))}return null}return createChainableTypeChecker(validate)}function createEnumTypeChecker(expectedValues){if(!Array.isArray(expectedValues)){process.env.NODE_ENV!=="production"?warning(false,"Invalid argument supplied to oneOf, expected an instance of array."):void 0;return emptyFunction.thatReturnsNull}function validate(props,propName,componentName,location,propFullName){var propValue=props[propName];for(var i=0;i<expectedValues.length;i++){if(is(propValue,expectedValues[i])){return null}}var valuesString=JSON.stringify(expectedValues);return new PropTypeError("Invalid "+location+" `"+propFullName+"` of value `"+propValue+"` "+("supplied to `"+componentName+"`, expected one of "+valuesString+"."))}return createChainableTypeChecker(validate)}function createObjectOfTypeChecker(typeChecker){function validate(props,propName,componentName,location,propFullName){if(typeof typeChecker!=="function"){return new PropTypeError("Property `"+propFullName+"` of component `"+componentName+"` has invalid PropType notation inside objectOf.")}var propValue=props[propName];var propType=getPropType(propValue);if(propType!=="object"){return new PropTypeError("Invalid "+location+" `"+propFullName+"` of type "+("`"+propType+"` supplied to `"+componentName+"`, expected an object."))}for(var key in propValue){if(propValue.hasOwnProperty(key)){var error=typeChecker(propValue,key,componentName,location,propFullName+"."+key,ReactPropTypesSecret);if(error instanceof Error){return error}}}return null}return createChainableTypeChecker(validate)}function createUnionTypeChecker(arrayOfTypeCheckers){if(!Array.isArray(arrayOfTypeCheckers)){process.env.NODE_ENV!=="production"?warning(false,"Invalid argument supplied to oneOfType, expected an instance of array."):void 0;return emptyFunction.thatReturnsNull}for(var i=0;i<arrayOfTypeCheckers.length;i++){var checker=arrayOfTypeCheckers[i];if(typeof checker!=="function"){warning(false,"Invalid argument supplid to oneOfType. Expected an array of check functions, but "+"received %s at index %s.",getPostfixForTypeWarning(checker),i);return emptyFunction.thatReturnsNull}}function validate(props,propName,componentName,location,propFullName){for(var i=0;i<arrayOfTypeCheckers.length;i++){var checker=arrayOfTypeCheckers[i];if(checker(props,propName,componentName,location,propFullName,ReactPropTypesSecret)==null){return null}}return new PropTypeError("Invalid "+location+" `"+propFullName+"` supplied to "+("`"+componentName+"`."))}return createChainableTypeChecker(validate)}function createNodeChecker(){function validate(props,propName,componentName,location,propFullName){if(!isNode(props[propName])){return new PropTypeError("Invalid "+location+" `"+propFullName+"` supplied to "+("`"+componentName+"`, expected a ReactNode."))}return null}return createChainableTypeChecker(validate)}function createShapeTypeChecker(shapeTypes){function validate(props,propName,componentName,location,propFullName){var propValue=props[propName];var propType=getPropType(propValue);if(propType!=="object"){return new PropTypeError("Invalid "+location+" `"+propFullName+"` of type `"+propType+"` "+("supplied to `"+componentName+"`, expected `object`."))}for(var key in shapeTypes){var checker=shapeTypes[key];if(!checker){continue}var error=checker(propValue,key,componentName,location,propFullName+"."+key,ReactPropTypesSecret);if(error){return error}}return null}return createChainableTypeChecker(validate)}function isNode(propValue){switch(typeof propValue){case"number":case"string":case"undefined":return true;case"boolean":return!propValue;case"object":if(Array.isArray(propValue)){return propValue.every(isNode)}if(propValue===null||isValidElement(propValue)){return true}var iteratorFn=getIteratorFn(propValue);if(iteratorFn){var iterator=iteratorFn.call(propValue);var step;if(iteratorFn!==propValue.entries){while(!(step=iterator.next()).done){if(!isNode(step.value)){return false}}}else{while(!(step=iterator.next()).done){var entry=step.value;if(entry){if(!isNode(entry[1])){return false}}}}}else{return false}return true;default:return false}}function isSymbol(propType,propValue){if(propType==="symbol"){return true}if(propValue["@@toStringTag"]==="Symbol"){return true}if(typeof Symbol==="function"&&propValue instanceof Symbol){return true}return false}function getPropType(propValue){var propType=typeof propValue;if(Array.isArray(propValue)){return"array"}if(propValue instanceof RegExp){return"object"}if(isSymbol(propType,propValue)){return"symbol"}return propType}function getPreciseType(propValue){if(typeof propValue==="undefined"||propValue===null){return""+propValue}var propType=getPropType(propValue);if(propType==="object"){if(propValue instanceof Date){return"date"}else if(propValue instanceof RegExp){return"regexp"}}return propType}function getPostfixForTypeWarning(value){var type=getPreciseType(value);switch(type){case"array":case"object":return"an "+type;case"boolean":case"date":case"regexp":return"a "+type;default:return type}}function getClassName(propValue){if(!propValue.constructor||!propValue.constructor.name){return ANONYMOUS}return propValue.constructor.name}ReactPropTypes.checkPropTypes=checkPropTypes;ReactPropTypes.PropTypes=ReactPropTypes;return ReactPropTypes}}).call(this,require("_process"))},{"./checkPropTypes":27,"./lib/ReactPropTypesSecret":30,_process:184,"fbjs/lib/emptyFunction":10,"fbjs/lib/invariant":18,"fbjs/lib/warning":25}],30:[function(require,module,exports){"use strict";var ReactPropTypesSecret="SECRET_DO_NOT_PASS_THIS_OR_YOU_WILL_BE_FIRED";module.exports=ReactPropTypesSecret},{}],31:[function(require,module,exports){"use strict";module.exports=require("./lib/ReactDOM")},{"./lib/ReactDOM":61}],32:[function(require,module,exports){"use strict";var ARIADOMPropertyConfig={Properties:{"aria-current":0,"aria-details":0,"aria-disabled":0,"aria-hidden":0,"aria-invalid":0,"aria-keyshortcuts":0,"aria-label":0,"aria-roledescription":0,"aria-autocomplete":0,"aria-checked":0,"aria-expanded":0,"aria-haspopup":0,"aria-level":0,"aria-modal":0,"aria-multiline":0,"aria-multiselectable":0,"aria-orientation":0,"aria-placeholder":0,"aria-pressed":0,"aria-readonly":0,"aria-required":0,"aria-selected":0,"aria-sort":0,"aria-valuemax":0,"aria-valuemin":0,"aria-valuenow":0,"aria-valuetext":0,"aria-atomic":0,"aria-busy":0,"aria-live":0,"aria-relevant":0,"aria-dropeffect":0,"aria-grabbed":0,"aria-activedescendant":0,"aria-colcount":0,"aria-colindex":0,"aria-colspan":0,"aria-controls":0,"aria-describedby":0,"aria-errormessage":0,"aria-flowto":0,"aria-labelledby":0,"aria-owns":0,"aria-posinset":0,"aria-rowcount":0,"aria-rowindex":0,"aria-rowspan":0,"aria-setsize":0},DOMAttributeNames:{},DOMPropertyNames:{}};module.exports=ARIADOMPropertyConfig},{}],33:[function(require,module,exports){"use strict";var ReactDOMComponentTree=require("./ReactDOMComponentTree");var focusNode=require("fbjs/lib/focusNode");var AutoFocusUtils={focusDOMComponent:function(){focusNode(ReactDOMComponentTree.getNodeFromInstance(this))}};module.exports=AutoFocusUtils},{"./ReactDOMComponentTree":64,"fbjs/lib/focusNode":12}],34:[function(require,module,exports){"use strict";var EventPropagators=require("./EventPropagators");var ExecutionEnvironment=require("fbjs/lib/ExecutionEnvironment");var FallbackCompositionState=require("./FallbackCompositionState");var SyntheticCompositionEvent=require("./SyntheticCompositionEvent");var SyntheticInputEvent=require("./SyntheticInputEvent");var END_KEYCODES=[9,13,27,32];var START_KEYCODE=229;var canUseCompositionEvent=ExecutionEnvironment.canUseDOM&&"CompositionEvent"in window;var documentMode=null;if(ExecutionEnvironment.canUseDOM&&"documentMode"in document){documentMode=document.documentMode}var canUseTextInputEvent=ExecutionEnvironment.canUseDOM&&"TextEvent"in window&&!documentMode&&!isPresto();var useFallbackCompositionData=ExecutionEnvironment.canUseDOM&&(!canUseCompositionEvent||documentMode&&documentMode>8&&documentMode<=11);function isPresto(){var opera=window.opera;return typeof opera==="object"&&typeof opera.version==="function"&&parseInt(opera.version(),10)<=12}var SPACEBAR_CODE=32;var SPACEBAR_CHAR=String.fromCharCode(SPACEBAR_CODE);var eventTypes={beforeInput:{phasedRegistrationNames:{bubbled:"onBeforeInput",captured:"onBeforeInputCapture"},dependencies:["topCompositionEnd","topKeyPress","topTextInput","topPaste"]},compositionEnd:{phasedRegistrationNames:{bubbled:"onCompositionEnd",captured:"onCompositionEndCapture"},dependencies:["topBlur","topCompositionEnd","topKeyDown","topKeyPress","topKeyUp","topMouseDown"]},compositionStart:{phasedRegistrationNames:{bubbled:"onCompositionStart",captured:"onCompositionStartCapture"},dependencies:["topBlur","topCompositionStart","topKeyDown","topKeyPress","topKeyUp","topMouseDown"]},compositionUpdate:{phasedRegistrationNames:{bubbled:"onCompositionUpdate",captured:"onCompositionUpdateCapture"},dependencies:["topBlur","topCompositionUpdate","topKeyDown","topKeyPress","topKeyUp","topMouseDown"]}};var hasSpaceKeypress=false;function isKeypressCommand(nativeEvent){return(nativeEvent.ctrlKey||nativeEvent.altKey||nativeEvent.metaKey)&&!(nativeEvent.ctrlKey&&nativeEvent.altKey)}function getCompositionEventType(topLevelType){switch(topLevelType){case"topCompositionStart":return eventTypes.compositionStart;case"topCompositionEnd":return eventTypes.compositionEnd;case"topCompositionUpdate":return eventTypes.compositionUpdate}}function isFallbackCompositionStart(topLevelType,nativeEvent){return topLevelType==="topKeyDown"&&nativeEvent.keyCode===START_KEYCODE}function isFallbackCompositionEnd(topLevelType,nativeEvent){switch(topLevelType){case"topKeyUp":return END_KEYCODES.indexOf(nativeEvent.keyCode)!==-1;case"topKeyDown":return nativeEvent.keyCode!==START_KEYCODE;case"topKeyPress":case"topMouseDown":case"topBlur":return true;default:return false}}function getDataFromCustomEvent(nativeEvent){var detail=nativeEvent.detail;if(typeof detail==="object"&&"data"in detail){return detail.data}return null}var currentComposition=null;function extractCompositionEvent(topLevelType,targetInst,nativeEvent,nativeEventTarget){var eventType;var fallbackData;if(canUseCompositionEvent){eventType=getCompositionEventType(topLevelType)}else if(!currentComposition){if(isFallbackCompositionStart(topLevelType,nativeEvent)){eventType=eventTypes.compositionStart}}else if(isFallbackCompositionEnd(topLevelType,nativeEvent)){eventType=eventTypes.compositionEnd}if(!eventType){return null}if(useFallbackCompositionData){if(!currentComposition&&eventType===eventTypes.compositionStart){currentComposition=FallbackCompositionState.getPooled(nativeEventTarget)}else if(eventType===eventTypes.compositionEnd){if(currentComposition){fallbackData=currentComposition.getData()}}}var event=SyntheticCompositionEvent.getPooled(eventType,targetInst,nativeEvent,nativeEventTarget);if(fallbackData){event.data=fallbackData}else{var customData=getDataFromCustomEvent(nativeEvent);if(customData!==null){event.data=customData}}EventPropagators.accumulateTwoPhaseDispatches(event);return event}function getNativeBeforeInputChars(topLevelType,nativeEvent){switch(topLevelType){case"topCompositionEnd":return getDataFromCustomEvent(nativeEvent);case"topKeyPress":var which=nativeEvent.which;if(which!==SPACEBAR_CODE){return null}hasSpaceKeypress=true;return SPACEBAR_CHAR;case"topTextInput":var chars=nativeEvent.data;if(chars===SPACEBAR_CHAR&&hasSpaceKeypress){return null}return chars;default:return null}}function getFallbackBeforeInputChars(topLevelType,nativeEvent){if(currentComposition){if(topLevelType==="topCompositionEnd"||!canUseCompositionEvent&&isFallbackCompositionEnd(topLevelType,nativeEvent)){var chars=currentComposition.getData();FallbackCompositionState.release(currentComposition);currentComposition=null;return chars}return null}switch(topLevelType){case"topPaste":return null;case"topKeyPress":if(nativeEvent.which&&!isKeypressCommand(nativeEvent)){return String.fromCharCode(nativeEvent.which)}return null;case"topCompositionEnd":return useFallbackCompositionData?null:nativeEvent.data;default:return null}}function extractBeforeInputEvent(topLevelType,targetInst,nativeEvent,nativeEventTarget){var chars;if(canUseTextInputEvent){chars=getNativeBeforeInputChars(topLevelType,nativeEvent)}else{chars=getFallbackBeforeInputChars(topLevelType,nativeEvent)}if(!chars){return null}var event=SyntheticInputEvent.getPooled(eventTypes.beforeInput,targetInst,nativeEvent,nativeEventTarget);event.data=chars;EventPropagators.accumulateTwoPhaseDispatches(event);return event}var BeforeInputEventPlugin={eventTypes:eventTypes,extractEvents:function(topLevelType,targetInst,nativeEvent,nativeEventTarget){return[extractCompositionEvent(topLevelType,targetInst,nativeEvent,nativeEventTarget),extractBeforeInputEvent(topLevelType,targetInst,nativeEvent,nativeEventTarget)]}};module.exports=BeforeInputEventPlugin},{"./EventPropagators":50,"./FallbackCompositionState":51,"./SyntheticCompositionEvent":115,"./SyntheticInputEvent":119,"fbjs/lib/ExecutionEnvironment":4}],35:[function(require,module,exports){"use strict";var isUnitlessNumber={animationIterationCount:true,borderImageOutset:true,borderImageSlice:true,borderImageWidth:true,boxFlex:true,boxFlexGroup:true,boxOrdinalGroup:true,columnCount:true,flex:true,flexGrow:true,flexPositive:true,flexShrink:true,flexNegative:true,flexOrder:true,gridRow:true,gridRowEnd:true,gridRowSpan:true,gridRowStart:true,gridColumn:true,gridColumnEnd:true,gridColumnSpan:true,gridColumnStart:true,fontWeight:true,lineClamp:true,lineHeight:true,opacity:true,order:true,orphans:true,tabSize:true,widows:true,zIndex:true,zoom:true,fillOpacity:true,floodOpacity:true,stopOpacity:true,strokeDasharray:true,strokeDashoffset:true,strokeMiterlimit:true,strokeOpacity:true,strokeWidth:true};function prefixKey(prefix,key){return prefix+key.charAt(0).toUpperCase()+key.substring(1)}var prefixes=["Webkit","ms","Moz","O"];Object.keys(isUnitlessNumber).forEach(function(prop){prefixes.forEach(function(prefix){isUnitlessNumber[prefixKey(prefix,prop)]=isUnitlessNumber[prop]})});var shorthandPropertyExpansions={background:{backgroundAttachment:true,backgroundColor:true,backgroundImage:true,backgroundPositionX:true,backgroundPositionY:true,backgroundRepeat:true},backgroundPosition:{backgroundPositionX:true,backgroundPositionY:true},border:{borderWidth:true,borderStyle:true,borderColor:true},borderBottom:{borderBottomWidth:true,borderBottomStyle:true,borderBottomColor:true},borderLeft:{borderLeftWidth:true,borderLeftStyle:true,borderLeftColor:true},borderRight:{borderRightWidth:true,borderRightStyle:true,borderRightColor:true},borderTop:{borderTopWidth:true,borderTopStyle:true,borderTopColor:true},font:{fontStyle:true,fontVariant:true,fontWeight:true,fontSize:true,lineHeight:true,fontFamily:true},outline:{outlineWidth:true,outlineStyle:true,outlineColor:true}};var CSSProperty={isUnitlessNumber:isUnitlessNumber,shorthandPropertyExpansions:shorthandPropertyExpansions};module.exports=CSSProperty},{}],36:[function(require,module,exports){(function(process){"use strict";var CSSProperty=require("./CSSProperty");var ExecutionEnvironment=require("fbjs/lib/ExecutionEnvironment");var ReactInstrumentation=require("./ReactInstrumentation");var camelizeStyleName=require("fbjs/lib/camelizeStyleName");var dangerousStyleValue=require("./dangerousStyleValue");var hyphenateStyleName=require("fbjs/lib/hyphenateStyleName");var memoizeStringOnly=require("fbjs/lib/memoizeStringOnly");var warning=require("fbjs/lib/warning");var processStyleName=memoizeStringOnly(function(styleName){return hyphenateStyleName(styleName)});var hasShorthandPropertyBug=false;var styleFloatAccessor="cssFloat";if(ExecutionEnvironment.canUseDOM){var tempStyle=document.createElement("div").style;try{tempStyle.font=""}catch(e){hasShorthandPropertyBug=true}if(document.documentElement.style.cssFloat===undefined){styleFloatAccessor="styleFloat"}}if(process.env.NODE_ENV!=="production"){var badVendoredStyleNamePattern=/^(?:webkit|moz|o)[A-Z]/;var badStyleValueWithSemicolonPattern=/;\s*$/;var warnedStyleNames={};var warnedStyleValues={};var warnedForNaNValue=false;var warnHyphenatedStyleName=function(name,owner){if(warnedStyleNames.hasOwnProperty(name)&&warnedStyleNames[name]){return}warnedStyleNames[name]=true;process.env.NODE_ENV!=="production"?warning(false,"Unsupported style property %s. Did you mean %s?%s",name,camelizeStyleName(name),checkRenderMessage(owner)):void 0};var warnBadVendoredStyleName=function(name,owner){if(warnedStyleNames.hasOwnProperty(name)&&warnedStyleNames[name]){return}warnedStyleNames[name]=true;process.env.NODE_ENV!=="production"?warning(false,"Unsupported vendor-prefixed style property %s. Did you mean %s?%s",name,name.charAt(0).toUpperCase()+name.slice(1),checkRenderMessage(owner)):void 0};var warnStyleValueWithSemicolon=function(name,value,owner){if(warnedStyleValues.hasOwnProperty(value)&&warnedStyleValues[value]){return}warnedStyleValues[value]=true;process.env.NODE_ENV!=="production"?warning(false,"Style property values shouldn't contain a semicolon.%s "+'Try "%s: %s" instead.',checkRenderMessage(owner),name,value.replace(badStyleValueWithSemicolonPattern,"")):void 0};var warnStyleValueIsNaN=function(name,value,owner){if(warnedForNaNValue){return}warnedForNaNValue=true;process.env.NODE_ENV!=="production"?warning(false,"`NaN` is an invalid value for the `%s` css style property.%s",name,checkRenderMessage(owner)):void 0};var checkRenderMessage=function(owner){if(owner){var name=owner.getName();if(name){return" Check the render method of `"+name+"`."}}return""};var warnValidStyle=function(name,value,component){var owner;if(component){owner=component._currentElement._owner}if(name.indexOf("-")>-1){warnHyphenatedStyleName(name,owner)}else if(badVendoredStyleNamePattern.test(name)){warnBadVendoredStyleName(name,owner)}else if(badStyleValueWithSemicolonPattern.test(value)){warnStyleValueWithSemicolon(name,value,owner)}if(typeof value==="number"&&isNaN(value)){warnStyleValueIsNaN(name,value,owner)}}}var CSSPropertyOperations={createMarkupForStyles:function(styles,component){var serialized="";for(var styleName in styles){if(!styles.hasOwnProperty(styleName)){continue}var isCustomProperty=styleName.indexOf("--")===0;var styleValue=styles[styleName];if(process.env.NODE_ENV!=="production"){if(!isCustomProperty){warnValidStyle(styleName,styleValue,component)}}if(styleValue!=null){serialized+=processStyleName(styleName)+":";serialized+=dangerousStyleValue(styleName,styleValue,component,isCustomProperty)+";"}}return serialized||null},setValueForStyles:function(node,styles,component){if(process.env.NODE_ENV!=="production"){ReactInstrumentation.debugTool.onHostOperation({instanceID:component._debugID,type:"update styles",payload:styles})}var style=node.style;for(var styleName in styles){if(!styles.hasOwnProperty(styleName)){continue}var isCustomProperty=styleName.indexOf("--")===0;if(process.env.NODE_ENV!=="production"){if(!isCustomProperty){warnValidStyle(styleName,styles[styleName],component)}}var styleValue=dangerousStyleValue(styleName,styles[styleName],component,isCustomProperty);if(styleName==="float"||styleName==="cssFloat"){styleName=styleFloatAccessor}if(isCustomProperty){style.setProperty(styleName,styleValue)}else if(styleValue){style[styleName]=styleValue}else{var expansion=hasShorthandPropertyBug&&CSSProperty.shorthandPropertyExpansions[styleName];if(expansion){for(var individualStyleName in expansion){style[individualStyleName]=""}}else{style[styleName]=""}}}}};module.exports=CSSPropertyOperations}).call(this,require("_process"))},{"./CSSProperty":35,"./ReactInstrumentation":93,"./dangerousStyleValue":132,_process:184,"fbjs/lib/ExecutionEnvironment":4,"fbjs/lib/camelizeStyleName":6,"fbjs/lib/hyphenateStyleName":17,"fbjs/lib/memoizeStringOnly":21,"fbjs/lib/warning":25}],37:[function(require,module,exports){(function(process){"use strict";var _prodInvariant=require("./reactProdInvariant");function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}var PooledClass=require("./PooledClass");var invariant=require("fbjs/lib/invariant");var CallbackQueue=function(){function CallbackQueue(arg){_classCallCheck(this,CallbackQueue);this._callbacks=null;this._contexts=null;this._arg=arg}CallbackQueue.prototype.enqueue=function enqueue(callback,context){this._callbacks=this._callbacks||[];this._callbacks.push(callback);this._contexts=this._contexts||[];this._contexts.push(context)};CallbackQueue.prototype.notifyAll=function notifyAll(){var callbacks=this._callbacks;var contexts=this._contexts;var arg=this._arg;if(callbacks&&contexts){!(callbacks.length===contexts.length)?process.env.NODE_ENV!=="production"?invariant(false,"Mismatched list of contexts in callback queue"):_prodInvariant("24"):void 0;this._callbacks=null;this._contexts=null;for(var i=0;i<callbacks.length;i++){callbacks[i].call(contexts[i],arg)}callbacks.length=0;contexts.length=0}};CallbackQueue.prototype.checkpoint=function checkpoint(){return this._callbacks?this._callbacks.length:0};CallbackQueue.prototype.rollback=function rollback(len){if(this._callbacks&&this._contexts){this._callbacks.length=len;this._contexts.length=len}};CallbackQueue.prototype.reset=function reset(){this._callbacks=null;this._contexts=null};CallbackQueue.prototype.destructor=function destructor(){this.reset()};return CallbackQueue}();module.exports=PooledClass.addPoolingTo(CallbackQueue)}).call(this,require("_process"))},{"./PooledClass":55,"./reactProdInvariant":151,_process:184,"fbjs/lib/invariant":18}],38:[function(require,module,exports){"use strict";var EventPluginHub=require("./EventPluginHub");var EventPropagators=require("./EventPropagators");var ExecutionEnvironment=require("fbjs/lib/ExecutionEnvironment");var ReactDOMComponentTree=require("./ReactDOMComponentTree");var ReactUpdates=require("./ReactUpdates");var SyntheticEvent=require("./SyntheticEvent");var inputValueTracking=require("./inputValueTracking");var getEventTarget=require("./getEventTarget");var isEventSupported=require("./isEventSupported");var isTextInputElement=require("./isTextInputElement");var eventTypes={change:{phasedRegistrationNames:{bubbled:"onChange",captured:"onChangeCapture"},dependencies:["topBlur","topChange","topClick","topFocus","topInput","topKeyDown","topKeyUp","topSelectionChange"]}};function createAndAccumulateChangeEvent(inst,nativeEvent,target){var event=SyntheticEvent.getPooled(eventTypes.change,inst,nativeEvent,target);event.type="change";EventPropagators.accumulateTwoPhaseDispatches(event);return event}var activeElement=null;var activeElementInst=null;function shouldUseChangeEvent(elem){var nodeName=elem.nodeName&&elem.nodeName.toLowerCase();return nodeName==="select"||nodeName==="input"&&elem.type==="file"}var doesChangeEventBubble=false;if(ExecutionEnvironment.canUseDOM){doesChangeEventBubble=isEventSupported("change")&&(!document.documentMode||document.documentMode>8)}function manualDispatchChangeEvent(nativeEvent){var event=createAndAccumulateChangeEvent(activeElementInst,nativeEvent,getEventTarget(nativeEvent));ReactUpdates.batchedUpdates(runEventInBatch,event)}function runEventInBatch(event){EventPluginHub.enqueueEvents(event);EventPluginHub.processEventQueue(false)}function startWatchingForChangeEventIE8(target,targetInst){activeElement=target;activeElementInst=targetInst;activeElement.attachEvent("onchange",manualDispatchChangeEvent)}function stopWatchingForChangeEventIE8(){if(!activeElement){return}activeElement.detachEvent("onchange",manualDispatchChangeEvent);activeElement=null;activeElementInst=null}function getInstIfValueChanged(targetInst,nativeEvent){var updated=inputValueTracking.updateValueIfChanged(targetInst);var simulated=nativeEvent.simulated===true&&ChangeEventPlugin._allowSimulatedPassThrough;if(updated||simulated){return targetInst}}function getTargetInstForChangeEvent(topLevelType,targetInst){if(topLevelType==="topChange"){return targetInst}}function handleEventsForChangeEventIE8(topLevelType,target,targetInst){if(topLevelType==="topFocus"){stopWatchingForChangeEventIE8();startWatchingForChangeEventIE8(target,targetInst)}else if(topLevelType==="topBlur"){stopWatchingForChangeEventIE8()}}var isInputEventSupported=false;if(ExecutionEnvironment.canUseDOM){isInputEventSupported=isEventSupported("input")&&(!("documentMode"in document)||document.documentMode>9)}function startWatchingForValueChange(target,targetInst){activeElement=target;activeElementInst=targetInst;activeElement.attachEvent("onpropertychange",handlePropertyChange)}function stopWatchingForValueChange(){if(!activeElement){return}activeElement.detachEvent("onpropertychange",handlePropertyChange);activeElement=null;activeElementInst=null}function handlePropertyChange(nativeEvent){if(nativeEvent.propertyName!=="value"){return}if(getInstIfValueChanged(activeElementInst,nativeEvent)){manualDispatchChangeEvent(nativeEvent)}}function handleEventsForInputEventPolyfill(topLevelType,target,targetInst){if(topLevelType==="topFocus"){stopWatchingForValueChange();startWatchingForValueChange(target,targetInst)}else if(topLevelType==="topBlur"){stopWatchingForValueChange()}}function getTargetInstForInputEventPolyfill(topLevelType,targetInst,nativeEvent){if(topLevelType==="topSelectionChange"||topLevelType==="topKeyUp"||topLevelType==="topKeyDown"){return getInstIfValueChanged(activeElementInst,nativeEvent)}}function shouldUseClickEvent(elem){var nodeName=elem.nodeName;return nodeName&&nodeName.toLowerCase()==="input"&&(elem.type==="checkbox"||elem.type==="radio")}function getTargetInstForClickEvent(topLevelType,targetInst,nativeEvent){if(topLevelType==="topClick"){return getInstIfValueChanged(targetInst,nativeEvent)}}function getTargetInstForInputOrChangeEvent(topLevelType,targetInst,nativeEvent){if(topLevelType==="topInput"||topLevelType==="topChange"){return getInstIfValueChanged(targetInst,nativeEvent)}}function handleControlledInputBlur(inst,node){if(inst==null){return}var state=inst._wrapperState||node._wrapperState;if(!state||!state.controlled||node.type!=="number"){return}var value=""+node.value;if(node.getAttribute("value")!==value){node.setAttribute("value",value)}}var ChangeEventPlugin={eventTypes:eventTypes,_allowSimulatedPassThrough:true,_isInputEventSupported:isInputEventSupported,extractEvents:function(topLevelType,targetInst,nativeEvent,nativeEventTarget){var targetNode=targetInst?ReactDOMComponentTree.getNodeFromInstance(targetInst):window;var getTargetInstFunc,handleEventFunc;if(shouldUseChangeEvent(targetNode)){if(doesChangeEventBubble){getTargetInstFunc=getTargetInstForChangeEvent}else{handleEventFunc=handleEventsForChangeEventIE8}}else if(isTextInputElement(targetNode)){if(isInputEventSupported){getTargetInstFunc=getTargetInstForInputOrChangeEvent}else{getTargetInstFunc=getTargetInstForInputEventPolyfill;handleEventFunc=handleEventsForInputEventPolyfill}}else if(shouldUseClickEvent(targetNode)){getTargetInstFunc=getTargetInstForClickEvent}if(getTargetInstFunc){var inst=getTargetInstFunc(topLevelType,targetInst,nativeEvent);if(inst){var event=createAndAccumulateChangeEvent(inst,nativeEvent,nativeEventTarget);return event}}if(handleEventFunc){handleEventFunc(topLevelType,targetNode,targetInst)}if(topLevelType==="topBlur"){handleControlledInputBlur(targetInst,targetNode)}}};module.exports=ChangeEventPlugin},{"./EventPluginHub":47,"./EventPropagators":50,"./ReactDOMComponentTree":64,"./ReactUpdates":108,"./SyntheticEvent":117,"./getEventTarget":140,"./inputValueTracking":146,"./isEventSupported":148,"./isTextInputElement":149,"fbjs/lib/ExecutionEnvironment":4}],39:[function(require,module,exports){(function(process){"use strict";var DOMLazyTree=require("./DOMLazyTree");var Danger=require("./Danger");var ReactDOMComponentTree=require("./ReactDOMComponentTree");var ReactInstrumentation=require("./ReactInstrumentation");var createMicrosoftUnsafeLocalFunction=require("./createMicrosoftUnsafeLocalFunction");var setInnerHTML=require("./setInnerHTML");var setTextContent=require("./setTextContent");function getNodeAfter(parentNode,node){if(Array.isArray(node)){node=node[1]}return node?node.nextSibling:parentNode.firstChild}var insertChildAt=createMicrosoftUnsafeLocalFunction(function(parentNode,childNode,referenceNode){parentNode.insertBefore(childNode,referenceNode)});function insertLazyTreeChildAt(parentNode,childTree,referenceNode){DOMLazyTree.insertTreeBefore(parentNode,childTree,referenceNode)}function moveChild(parentNode,childNode,referenceNode){if(Array.isArray(childNode)){moveDelimitedText(parentNode,childNode[0],childNode[1],referenceNode)}else{insertChildAt(parentNode,childNode,referenceNode)}}function removeChild(parentNode,childNode){if(Array.isArray(childNode)){var closingComment=childNode[1];childNode=childNode[0];removeDelimitedText(parentNode,childNode,closingComment);parentNode.removeChild(closingComment)}parentNode.removeChild(childNode)}function moveDelimitedText(parentNode,openingComment,closingComment,referenceNode){var node=openingComment;while(true){var nextNode=node.nextSibling;insertChildAt(parentNode,node,referenceNode);if(node===closingComment){break}node=nextNode}}function removeDelimitedText(parentNode,startNode,closingComment){while(true){var node=startNode.nextSibling;if(node===closingComment){break}else{parentNode.removeChild(node)}}}function replaceDelimitedText(openingComment,closingComment,stringText){var parentNode=openingComment.parentNode;var nodeAfterComment=openingComment.nextSibling;if(nodeAfterComment===closingComment){if(stringText){insertChildAt(parentNode,document.createTextNode(stringText),nodeAfterComment)}}else{if(stringText){setTextContent(nodeAfterComment,stringText);removeDelimitedText(parentNode,nodeAfterComment,closingComment)}else{removeDelimitedText(parentNode,openingComment,closingComment)}}if(process.env.NODE_ENV!=="production"){ReactInstrumentation.debugTool.onHostOperation({instanceID:ReactDOMComponentTree.getInstanceFromNode(openingComment)._debugID,type:"replace text",payload:stringText})}}var dangerouslyReplaceNodeWithMarkup=Danger.dangerouslyReplaceNodeWithMarkup;if(process.env.NODE_ENV!=="production"){dangerouslyReplaceNodeWithMarkup=function(oldChild,markup,prevInstance){Danger.dangerouslyReplaceNodeWithMarkup(oldChild,markup);if(prevInstance._debugID!==0){ReactInstrumentation.debugTool.onHostOperation({instanceID:prevInstance._debugID,type:"replace with",payload:markup.toString()})}else{var nextInstance=ReactDOMComponentTree.getInstanceFromNode(markup.node);if(nextInstance._debugID!==0){ReactInstrumentation.debugTool.onHostOperation({instanceID:nextInstance._debugID,type:"mount",payload:markup.toString()})}}}}var DOMChildrenOperations={dangerouslyReplaceNodeWithMarkup:dangerouslyReplaceNodeWithMarkup,replaceDelimitedText:replaceDelimitedText,processUpdates:function(parentNode,updates){if(process.env.NODE_ENV!=="production"){var parentNodeDebugID=ReactDOMComponentTree.getInstanceFromNode(parentNode)._debugID}for(var k=0;k<updates.length;k++){var update=updates[k];switch(update.type){case"INSERT_MARKUP":insertLazyTreeChildAt(parentNode,update.content,getNodeAfter(parentNode,update.afterNode));if(process.env.NODE_ENV!=="production"){ReactInstrumentation.debugTool.onHostOperation({instanceID:parentNodeDebugID,type:"insert child",payload:{toIndex:update.toIndex,content:update.content.toString()}})}break;case"MOVE_EXISTING":moveChild(parentNode,update.fromNode,getNodeAfter(parentNode,update.afterNode));if(process.env.NODE_ENV!=="production"){ReactInstrumentation.debugTool.onHostOperation({instanceID:parentNodeDebugID,type:"move child",payload:{fromIndex:update.fromIndex,toIndex:update.toIndex}})}break;case"SET_MARKUP":setInnerHTML(parentNode,update.content);if(process.env.NODE_ENV!=="production"){ReactInstrumentation.debugTool.onHostOperation({instanceID:parentNodeDebugID,type:"replace children",payload:update.content.toString()})}break;case"TEXT_CONTENT":setTextContent(parentNode,update.content);if(process.env.NODE_ENV!=="production"){ReactInstrumentation.debugTool.onHostOperation({instanceID:parentNodeDebugID,type:"replace text",payload:update.content.toString()})}break;case"REMOVE_NODE":removeChild(parentNode,update.fromNode);if(process.env.NODE_ENV!=="production"){ReactInstrumentation.debugTool.onHostOperation({instanceID:parentNodeDebugID,type:"remove child",payload:{fromIndex:update.fromIndex}})}break}}}};module.exports=DOMChildrenOperations}).call(this,require("_process"))},{"./DOMLazyTree":40,"./Danger":44,"./ReactDOMComponentTree":64,"./ReactInstrumentation":93,"./createMicrosoftUnsafeLocalFunction":131,"./setInnerHTML":153,"./setTextContent":154,_process:184}],40:[function(require,module,exports){"use strict";var DOMNamespaces=require("./DOMNamespaces");var setInnerHTML=require("./setInnerHTML");var createMicrosoftUnsafeLocalFunction=require("./createMicrosoftUnsafeLocalFunction");var setTextContent=require("./setTextContent");var ELEMENT_NODE_TYPE=1;var DOCUMENT_FRAGMENT_NODE_TYPE=11;var enableLazy=typeof document!=="undefined"&&typeof document.documentMode==="number"||typeof navigator!=="undefined"&&typeof navigator.userAgent==="string"&&/\bEdge\/\d/.test(navigator.userAgent);function insertTreeChildren(tree){if(!enableLazy){return}var node=tree.node;var children=tree.children;if(children.length){for(var i=0;i<children.length;i++){insertTreeBefore(node,children[i],null)}}else if(tree.html!=null){setInnerHTML(node,tree.html)}else if(tree.text!=null){setTextContent(node,tree.text)}}var insertTreeBefore=createMicrosoftUnsafeLocalFunction(function(parentNode,tree,referenceNode){if(tree.node.nodeType===DOCUMENT_FRAGMENT_NODE_TYPE||tree.node.nodeType===ELEMENT_NODE_TYPE&&tree.node.nodeName.toLowerCase()==="object"&&(tree.node.namespaceURI==null||tree.node.namespaceURI===DOMNamespaces.html)){insertTreeChildren(tree);parentNode.insertBefore(tree.node,referenceNode)}else{parentNode.insertBefore(tree.node,referenceNode);insertTreeChildren(tree)}});function replaceChildWithTree(oldNode,newTree){oldNode.parentNode.replaceChild(newTree.node,oldNode);insertTreeChildren(newTree)}function queueChild(parentTree,childTree){if(enableLazy){parentTree.children.push(childTree)}else{parentTree.node.appendChild(childTree.node)}}function queueHTML(tree,html){if(enableLazy){tree.html=html}else{setInnerHTML(tree.node,html)}}function queueText(tree,text){if(enableLazy){tree.text=text}else{setTextContent(tree.node,text)}}function toString(){return this.node.nodeName}function DOMLazyTree(node){return{node:node,children:[],html:null,text:null,toString:toString}}DOMLazyTree.insertTreeBefore=insertTreeBefore;DOMLazyTree.replaceChildWithTree=replaceChildWithTree;DOMLazyTree.queueChild=queueChild;DOMLazyTree.queueHTML=queueHTML;DOMLazyTree.queueText=queueText;module.exports=DOMLazyTree},{"./DOMNamespaces":41,"./createMicrosoftUnsafeLocalFunction":131,"./setInnerHTML":153,"./setTextContent":154}],41:[function(require,module,exports){"use strict";var DOMNamespaces={html:"http://www.w3.org/1999/xhtml",mathml:"http://www.w3.org/1998/Math/MathML",svg:"http://www.w3.org/2000/svg"};module.exports=DOMNamespaces},{}],42:[function(require,module,exports){(function(process){"use strict";var _prodInvariant=require("./reactProdInvariant");var invariant=require("fbjs/lib/invariant");function checkMask(value,bitmask){return(value&bitmask)===bitmask}var DOMPropertyInjection={MUST_USE_PROPERTY:1,HAS_BOOLEAN_VALUE:4,HAS_NUMERIC_VALUE:8,HAS_POSITIVE_NUMERIC_VALUE:16|8,HAS_OVERLOADED_BOOLEAN_VALUE:32,injectDOMPropertyConfig:function(domPropertyConfig){var Injection=DOMPropertyInjection;var Properties=domPropertyConfig.Properties||{};var DOMAttributeNamespaces=domPropertyConfig.DOMAttributeNamespaces||{};var DOMAttributeNames=domPropertyConfig.DOMAttributeNames||{};var DOMPropertyNames=domPropertyConfig.DOMPropertyNames||{};var DOMMutationMethods=domPropertyConfig.DOMMutationMethods||{};if(domPropertyConfig.isCustomAttribute){DOMProperty._isCustomAttributeFunctions.push(domPropertyConfig.isCustomAttribute)}for(var propName in Properties){!!DOMProperty.properties.hasOwnProperty(propName)?process.env.NODE_ENV!=="production"?invariant(false,"injectDOMPropertyConfig(...): You're trying to inject DOM property '%s' which has already been injected. You may be accidentally injecting the same DOM property config twice, or you may be injecting two configs that have conflicting property names.",propName):_prodInvariant("48",propName):void 0;var lowerCased=propName.toLowerCase();var propConfig=Properties[propName];var propertyInfo={attributeName:lowerCased,attributeNamespace:null,propertyName:propName,mutationMethod:null,mustUseProperty:checkMask(propConfig,Injection.MUST_USE_PROPERTY),hasBooleanValue:checkMask(propConfig,Injection.HAS_BOOLEAN_VALUE),hasNumericValue:checkMask(propConfig,Injection.HAS_NUMERIC_VALUE),hasPositiveNumericValue:checkMask(propConfig,Injection.HAS_POSITIVE_NUMERIC_VALUE),hasOverloadedBooleanValue:checkMask(propConfig,Injection.HAS_OVERLOADED_BOOLEAN_VALUE)};!(propertyInfo.hasBooleanValue+propertyInfo.hasNumericValue+propertyInfo.hasOverloadedBooleanValue<=1)?process.env.NODE_ENV!=="production"?invariant(false,"DOMProperty: Value can be one of boolean, overloaded boolean, or numeric value, but not a combination: %s",propName):_prodInvariant("50",propName):void 0;if(process.env.NODE_ENV!=="production"){DOMProperty.getPossibleStandardName[lowerCased]=propName}if(DOMAttributeNames.hasOwnProperty(propName)){var attributeName=DOMAttributeNames[propName];propertyInfo.attributeName=attributeName;if(process.env.NODE_ENV!=="production"){DOMProperty.getPossibleStandardName[attributeName]=propName}}if(DOMAttributeNamespaces.hasOwnProperty(propName)){propertyInfo.attributeNamespace=DOMAttributeNamespaces[propName]}if(DOMPropertyNames.hasOwnProperty(propName)){propertyInfo.propertyName=DOMPropertyNames[propName]}if(DOMMutationMethods.hasOwnProperty(propName)){propertyInfo.mutationMethod=DOMMutationMethods[propName]}DOMProperty.properties[propName]=propertyInfo}}};var ATTRIBUTE_NAME_START_CHAR=":A-Z_a-z\\u00C0-\\u00D6\\u00D8-\\u00F6\\u00F8-\\u02FF\\u0370-\\u037D\\u037F-\\u1FFF\\u200C-\\u200D\\u2070-\\u218F\\u2C00-\\u2FEF\\u3001-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFFD";var DOMProperty={ID_ATTRIBUTE_NAME:"data-reactid",ROOT_ATTRIBUTE_NAME:"data-reactroot",ATTRIBUTE_NAME_START_CHAR:ATTRIBUTE_NAME_START_CHAR,ATTRIBUTE_NAME_CHAR:ATTRIBUTE_NAME_START_CHAR+"\\-.0-9\\u00B7\\u0300-\\u036F\\u203F-\\u2040",properties:{},getPossibleStandardName:process.env.NODE_ENV!=="production"?{autofocus:"autoFocus"}:null,_isCustomAttributeFunctions:[],isCustomAttribute:function(attributeName){for(var i=0;i<DOMProperty._isCustomAttributeFunctions.length;i++){var isCustomAttributeFn=DOMProperty._isCustomAttributeFunctions[i];if(isCustomAttributeFn(attributeName)){return true}}return false},injection:DOMPropertyInjection};module.exports=DOMProperty}).call(this,require("_process"))},{"./reactProdInvariant":151,_process:184,"fbjs/lib/invariant":18}],43:[function(require,module,exports){(function(process){"use strict";var DOMProperty=require("./DOMProperty");var ReactDOMComponentTree=require("./ReactDOMComponentTree");var ReactInstrumentation=require("./ReactInstrumentation");var quoteAttributeValueForBrowser=require("./quoteAttributeValueForBrowser");var warning=require("fbjs/lib/warning");var VALID_ATTRIBUTE_NAME_REGEX=new RegExp("^["+DOMProperty.ATTRIBUTE_NAME_START_CHAR+"]["+DOMProperty.ATTRIBUTE_NAME_CHAR+"]*$");var illegalAttributeNameCache={};var validatedAttributeNameCache={};function isAttributeNameSafe(attributeName){if(validatedAttributeNameCache.hasOwnProperty(attributeName)){return true}if(illegalAttributeNameCache.hasOwnProperty(attributeName)){return false}if(VALID_ATTRIBUTE_NAME_REGEX.test(attributeName)){validatedAttributeNameCache[attributeName]=true;return true}illegalAttributeNameCache[attributeName]=true;process.env.NODE_ENV!=="production"?warning(false,"Invalid attribute name: `%s`",attributeName):void 0;return false}function shouldIgnoreValue(propertyInfo,value){return value==null||propertyInfo.hasBooleanValue&&!value||propertyInfo.hasNumericValue&&isNaN(value)||propertyInfo.hasPositiveNumericValue&&value<1||propertyInfo.hasOverloadedBooleanValue&&value===false}var DOMPropertyOperations={createMarkupForID:function(id){return DOMProperty.ID_ATTRIBUTE_NAME+"="+quoteAttributeValueForBrowser(id)},setAttributeForID:function(node,id){node.setAttribute(DOMProperty.ID_ATTRIBUTE_NAME,id)},createMarkupForRoot:function(){return DOMProperty.ROOT_ATTRIBUTE_NAME+'=""'},setAttributeForRoot:function(node){node.setAttribute(DOMProperty.ROOT_ATTRIBUTE_NAME,"")},createMarkupForProperty:function(name,value){var propertyInfo=DOMProperty.properties.hasOwnProperty(name)?DOMProperty.properties[name]:null;if(propertyInfo){if(shouldIgnoreValue(propertyInfo,value)){return""}var attributeName=propertyInfo.attributeName;if(propertyInfo.hasBooleanValue||propertyInfo.hasOverloadedBooleanValue&&value===true){return attributeName+'=""'}return attributeName+"="+quoteAttributeValueForBrowser(value)}else if(DOMProperty.isCustomAttribute(name)){if(value==null){return""}return name+"="+quoteAttributeValueForBrowser(value)}return null},createMarkupForCustomAttribute:function(name,value){if(!isAttributeNameSafe(name)||value==null){return""}return name+"="+quoteAttributeValueForBrowser(value)},setValueForProperty:function(node,name,value){var propertyInfo=DOMProperty.properties.hasOwnProperty(name)?DOMProperty.properties[name]:null;if(propertyInfo){var mutationMethod=propertyInfo.mutationMethod;if(mutationMethod){mutationMethod(node,value)}else if(shouldIgnoreValue(propertyInfo,value)){this.deleteValueForProperty(node,name);return}else if(propertyInfo.mustUseProperty){node[propertyInfo.propertyName]=value}else{var attributeName=propertyInfo.attributeName;var namespace=propertyInfo.attributeNamespace;if(namespace){node.setAttributeNS(namespace,attributeName,""+value)}else if(propertyInfo.hasBooleanValue||propertyInfo.hasOverloadedBooleanValue&&value===true){node.setAttribute(attributeName,"")}else{node.setAttribute(attributeName,""+value)}}}else if(DOMProperty.isCustomAttribute(name)){DOMPropertyOperations.setValueForAttribute(node,name,value);return}if(process.env.NODE_ENV!=="production"){var payload={};payload[name]=value;ReactInstrumentation.debugTool.onHostOperation({instanceID:ReactDOMComponentTree.getInstanceFromNode(node)._debugID,type:"update attribute",payload:payload})}},setValueForAttribute:function(node,name,value){if(!isAttributeNameSafe(name)){return}if(value==null){node.removeAttribute(name)}else{node.setAttribute(name,""+value)}if(process.env.NODE_ENV!=="production"){var payload={};payload[name]=value;ReactInstrumentation.debugTool.onHostOperation({instanceID:ReactDOMComponentTree.getInstanceFromNode(node)._debugID,type:"update attribute",payload:payload})}},deleteValueForAttribute:function(node,name){node.removeAttribute(name);if(process.env.NODE_ENV!=="production"){ReactInstrumentation.debugTool.onHostOperation({instanceID:ReactDOMComponentTree.getInstanceFromNode(node)._debugID,type:"remove attribute",payload:name})}},deleteValueForProperty:function(node,name){var propertyInfo=DOMProperty.properties.hasOwnProperty(name)?DOMProperty.properties[name]:null;if(propertyInfo){var mutationMethod=propertyInfo.mutationMethod;if(mutationMethod){mutationMethod(node,undefined)}else if(propertyInfo.mustUseProperty){var propName=propertyInfo.propertyName;if(propertyInfo.hasBooleanValue){node[propName]=false}else{node[propName]=""}}else{node.removeAttribute(propertyInfo.attributeName)}}else if(DOMProperty.isCustomAttribute(name)){node.removeAttribute(name)}if(process.env.NODE_ENV!=="production"){ReactInstrumentation.debugTool.onHostOperation({instanceID:ReactDOMComponentTree.getInstanceFromNode(node)._debugID,type:"remove attribute",payload:name})}}};module.exports=DOMPropertyOperations}).call(this,require("_process"))},{"./DOMProperty":42,"./ReactDOMComponentTree":64,"./ReactInstrumentation":93,"./quoteAttributeValueForBrowser":150,_process:184,"fbjs/lib/warning":25}],44:[function(require,module,exports){(function(process){"use strict";var _prodInvariant=require("./reactProdInvariant");var DOMLazyTree=require("./DOMLazyTree");var ExecutionEnvironment=require("fbjs/lib/ExecutionEnvironment");var createNodesFromMarkup=require("fbjs/lib/createNodesFromMarkup");var emptyFunction=require("fbjs/lib/emptyFunction");var invariant=require("fbjs/lib/invariant");var Danger={dangerouslyReplaceNodeWithMarkup:function(oldChild,markup){!ExecutionEnvironment.canUseDOM?process.env.NODE_ENV!=="production"?invariant(false,"dangerouslyReplaceNodeWithMarkup(...): Cannot render markup in a worker thread. Make sure `window` and `document` are available globally before requiring React when unit testing or use ReactDOMServer.renderToString() for server rendering."):_prodInvariant("56"):void 0;!markup?process.env.NODE_ENV!=="production"?invariant(false,"dangerouslyReplaceNodeWithMarkup(...): Missing markup."):_prodInvariant("57"):void 0;!(oldChild.nodeName!=="HTML")?process.env.NODE_ENV!=="production"?invariant(false,"dangerouslyReplaceNodeWithMarkup(...): Cannot replace markup of the <html> node. This is because browser quirks make this unreliable and/or slow. If you want to render to the root you must use server rendering. See ReactDOMServer.renderToString()."):_prodInvariant("58"):void 0;if(typeof markup==="string"){var newChild=createNodesFromMarkup(markup,emptyFunction)[0];oldChild.parentNode.replaceChild(newChild,oldChild)}else{DOMLazyTree.replaceChildWithTree(oldChild,markup)}}};module.exports=Danger}).call(this,require("_process"))},{"./DOMLazyTree":40,"./reactProdInvariant":151,_process:184,"fbjs/lib/ExecutionEnvironment":4,"fbjs/lib/createNodesFromMarkup":9,"fbjs/lib/emptyFunction":10,"fbjs/lib/invariant":18}],45:[function(require,module,exports){"use strict";var DefaultEventPluginOrder=["ResponderEventPlugin","SimpleEventPlugin","TapEventPlugin","EnterLeaveEventPlugin","ChangeEventPlugin","SelectEventPlugin","BeforeInputEventPlugin"];module.exports=DefaultEventPluginOrder},{}],46:[function(require,module,exports){"use strict";var EventPropagators=require("./EventPropagators");var ReactDOMComponentTree=require("./ReactDOMComponentTree");var SyntheticMouseEvent=require("./SyntheticMouseEvent");var eventTypes={mouseEnter:{registrationName:"onMouseEnter",dependencies:["topMouseOut","topMouseOver"]},mouseLeave:{registrationName:"onMouseLeave",dependencies:["topMouseOut","topMouseOver"]}};var EnterLeaveEventPlugin={eventTypes:eventTypes,extractEvents:function(topLevelType,targetInst,nativeEvent,nativeEventTarget){if(topLevelType==="topMouseOver"&&(nativeEvent.relatedTarget||nativeEvent.fromElement)){return null}if(topLevelType!=="topMouseOut"&&topLevelType!=="topMouseOver"){return null}var win;if(nativeEventTarget.window===nativeEventTarget){win=nativeEventTarget}else{var doc=nativeEventTarget.ownerDocument;if(doc){win=doc.defaultView||doc.parentWindow}else{win=window}}var from;var to;if(topLevelType==="topMouseOut"){from=targetInst;var related=nativeEvent.relatedTarget||nativeEvent.toElement;to=related?ReactDOMComponentTree.getClosestInstanceFromNode(related):null}else{from=null;to=targetInst}if(from===to){return null}var fromNode=from==null?win:ReactDOMComponentTree.getNodeFromInstance(from);var toNode=to==null?win:ReactDOMComponentTree.getNodeFromInstance(to);var leave=SyntheticMouseEvent.getPooled(eventTypes.mouseLeave,from,nativeEvent,nativeEventTarget);leave.type="mouseleave";leave.target=fromNode;leave.relatedTarget=toNode;var enter=SyntheticMouseEvent.getPooled(eventTypes.mouseEnter,to,nativeEvent,nativeEventTarget);enter.type="mouseenter";enter.target=toNode;enter.relatedTarget=fromNode;EventPropagators.accumulateEnterLeaveDispatches(leave,enter,from,to);return[leave,enter]}};module.exports=EnterLeaveEventPlugin},{"./EventPropagators":50,"./ReactDOMComponentTree":64,"./SyntheticMouseEvent":121}],47:[function(require,module,exports){(function(process){"use strict";var _prodInvariant=require("./reactProdInvariant");var EventPluginRegistry=require("./EventPluginRegistry");var EventPluginUtils=require("./EventPluginUtils");var ReactErrorUtils=require("./ReactErrorUtils");var accumulateInto=require("./accumulateInto");var forEachAccumulated=require("./forEachAccumulated");var invariant=require("fbjs/lib/invariant");var listenerBank={};var eventQueue=null;var executeDispatchesAndRelease=function(event,simulated){if(event){EventPluginUtils.executeDispatchesInOrder(event,simulated);if(!event.isPersistent()){event.constructor.release(event)}}};var executeDispatchesAndReleaseSimulated=function(e){return executeDispatchesAndRelease(e,true)};var executeDispatchesAndReleaseTopLevel=function(e){return executeDispatchesAndRelease(e,false)};var getDictionaryKey=function(inst){return"."+inst._rootNodeID};function isInteractive(tag){return tag==="button"||tag==="input"||tag==="select"||tag==="textarea"}function shouldPreventMouseEvent(name,type,props){switch(name){case"onClick":case"onClickCapture":case"onDoubleClick":case"onDoubleClickCapture":case"onMouseDown":case"onMouseDownCapture":case"onMouseMove":case"onMouseMoveCapture":case"onMouseUp":case"onMouseUpCapture":return!!(props.disabled&&isInteractive(type));default:return false}}var EventPluginHub={injection:{injectEventPluginOrder:EventPluginRegistry.injectEventPluginOrder,injectEventPluginsByName:EventPluginRegistry.injectEventPluginsByName},putListener:function(inst,registrationName,listener){!(typeof listener==="function")?process.env.NODE_ENV!=="production"?invariant(false,"Expected %s listener to be a function, instead got type %s",registrationName,typeof listener):_prodInvariant("94",registrationName,typeof listener):void 0;var key=getDictionaryKey(inst);var bankForRegistrationName=listenerBank[registrationName]||(listenerBank[registrationName]={});bankForRegistrationName[key]=listener;var PluginModule=EventPluginRegistry.registrationNameModules[registrationName];if(PluginModule&&PluginModule.didPutListener){PluginModule.didPutListener(inst,registrationName,listener)}},getListener:function(inst,registrationName){var bankForRegistrationName=listenerBank[registrationName];if(shouldPreventMouseEvent(registrationName,inst._currentElement.type,inst._currentElement.props)){return null}var key=getDictionaryKey(inst);return bankForRegistrationName&&bankForRegistrationName[key]},deleteListener:function(inst,registrationName){var PluginModule=EventPluginRegistry.registrationNameModules[registrationName];if(PluginModule&&PluginModule.willDeleteListener){PluginModule.willDeleteListener(inst,registrationName)}var bankForRegistrationName=listenerBank[registrationName];if(bankForRegistrationName){var key=getDictionaryKey(inst);delete bankForRegistrationName[key]}},deleteAllListeners:function(inst){var key=getDictionaryKey(inst);for(var registrationName in listenerBank){if(!listenerBank.hasOwnProperty(registrationName)){continue}if(!listenerBank[registrationName][key]){continue}var PluginModule=EventPluginRegistry.registrationNameModules[registrationName];if(PluginModule&&PluginModule.willDeleteListener){PluginModule.willDeleteListener(inst,registrationName)}delete listenerBank[registrationName][key]}},extractEvents:function(topLevelType,targetInst,nativeEvent,nativeEventTarget){var events;var plugins=EventPluginRegistry.plugins;for(var i=0;i<plugins.length;i++){var possiblePlugin=plugins[i];if(possiblePlugin){var extractedEvents=possiblePlugin.extractEvents(topLevelType,targetInst,nativeEvent,nativeEventTarget);if(extractedEvents){events=accumulateInto(events,extractedEvents)}}}return events},enqueueEvents:function(events){if(events){eventQueue=accumulateInto(eventQueue,events)}},processEventQueue:function(simulated){var processingEventQueue=eventQueue;eventQueue=null;if(simulated){forEachAccumulated(processingEventQueue,executeDispatchesAndReleaseSimulated)}else{forEachAccumulated(processingEventQueue,executeDispatchesAndReleaseTopLevel)}!!eventQueue?process.env.NODE_ENV!=="production"?invariant(false,"processEventQueue(): Additional events were enqueued while processing an event queue. Support for this has not yet been implemented."):_prodInvariant("95"):void 0;ReactErrorUtils.rethrowCaughtError()},__purge:function(){listenerBank={}},__getListenerBank:function(){return listenerBank}};module.exports=EventPluginHub}).call(this,require("_process"))},{"./EventPluginRegistry":48,"./EventPluginUtils":49,"./ReactErrorUtils":84,"./accumulateInto":128,"./forEachAccumulated":136,"./reactProdInvariant":151,_process:184,"fbjs/lib/invariant":18}],48:[function(require,module,exports){(function(process){"use strict";var _prodInvariant=require("./reactProdInvariant");var invariant=require("fbjs/lib/invariant");var eventPluginOrder=null;var namesToPlugins={};function recomputePluginOrdering(){if(!eventPluginOrder){return}for(var pluginName in namesToPlugins){var pluginModule=namesToPlugins[pluginName];var pluginIndex=eventPluginOrder.indexOf(pluginName);!(pluginIndex>-1)?process.env.NODE_ENV!=="production"?invariant(false,"EventPluginRegistry: Cannot inject event plugins that do not exist in the plugin ordering, `%s`.",pluginName):_prodInvariant("96",pluginName):void 0;if(EventPluginRegistry.plugins[pluginIndex]){continue}!pluginModule.extractEvents?process.env.NODE_ENV!=="production"?invariant(false,"EventPluginRegistry: Event plugins must implement an `extractEvents` method, but `%s` does not.",pluginName):_prodInvariant("97",pluginName):void 0;EventPluginRegistry.plugins[pluginIndex]=pluginModule;var publishedEvents=pluginModule.eventTypes;for(var eventName in publishedEvents){!publishEventForPlugin(publishedEvents[eventName],pluginModule,eventName)?process.env.NODE_ENV!=="production"?invariant(false,"EventPluginRegistry: Failed to publish event `%s` for plugin `%s`.",eventName,pluginName):_prodInvariant("98",eventName,pluginName):void 0}}}function publishEventForPlugin(dispatchConfig,pluginModule,eventName){!!EventPluginRegistry.eventNameDispatchConfigs.hasOwnProperty(eventName)?process.env.NODE_ENV!=="production"?invariant(false,"EventPluginHub: More than one plugin attempted to publish the same event name, `%s`.",eventName):_prodInvariant("99",eventName):void 0;EventPluginRegistry.eventNameDispatchConfigs[eventName]=dispatchConfig;var phasedRegistrationNames=dispatchConfig.phasedRegistrationNames;if(phasedRegistrationNames){for(var phaseName in phasedRegistrationNames){if(phasedRegistrationNames.hasOwnProperty(phaseName)){var phasedRegistrationName=phasedRegistrationNames[phaseName];publishRegistrationName(phasedRegistrationName,pluginModule,eventName)}}return true}else if(dispatchConfig.registrationName){publishRegistrationName(dispatchConfig.registrationName,pluginModule,eventName);return true}return false}function publishRegistrationName(registrationName,pluginModule,eventName){!!EventPluginRegistry.registrationNameModules[registrationName]?process.env.NODE_ENV!=="production"?invariant(false,"EventPluginHub: More than one plugin attempted to publish the same registration name, `%s`.",registrationName):_prodInvariant("100",registrationName):void 0;EventPluginRegistry.registrationNameModules[registrationName]=pluginModule;EventPluginRegistry.registrationNameDependencies[registrationName]=pluginModule.eventTypes[eventName].dependencies;if(process.env.NODE_ENV!=="production"){var lowerCasedName=registrationName.toLowerCase();EventPluginRegistry.possibleRegistrationNames[lowerCasedName]=registrationName;if(registrationName==="onDoubleClick"){EventPluginRegistry.possibleRegistrationNames.ondblclick=registrationName}}}var EventPluginRegistry={plugins:[],eventNameDispatchConfigs:{},registrationNameModules:{},registrationNameDependencies:{},possibleRegistrationNames:process.env.NODE_ENV!=="production"?{}:null,injectEventPluginOrder:function(injectedEventPluginOrder){!!eventPluginOrder?process.env.NODE_ENV!=="production"?invariant(false,"EventPluginRegistry: Cannot inject event plugin ordering more than once. You are likely trying to load more than one copy of React."):_prodInvariant("101"):void 0;eventPluginOrder=Array.prototype.slice.call(injectedEventPluginOrder);recomputePluginOrdering()},injectEventPluginsByName:function(injectedNamesToPlugins){var isOrderingDirty=false;for(var pluginName in injectedNamesToPlugins){if(!injectedNamesToPlugins.hasOwnProperty(pluginName)){continue}var pluginModule=injectedNamesToPlugins[pluginName];if(!namesToPlugins.hasOwnProperty(pluginName)||namesToPlugins[pluginName]!==pluginModule){!!namesToPlugins[pluginName]?process.env.NODE_ENV!=="production"?invariant(false,"EventPluginRegistry: Cannot inject two different event plugins using the same name, `%s`.",pluginName):_prodInvariant("102",pluginName):void 0;namesToPlugins[pluginName]=pluginModule;isOrderingDirty=true}}if(isOrderingDirty){recomputePluginOrdering()}},getPluginModuleForEvent:function(event){var dispatchConfig=event.dispatchConfig;if(dispatchConfig.registrationName){return EventPluginRegistry.registrationNameModules[dispatchConfig.registrationName]||null}if(dispatchConfig.phasedRegistrationNames!==undefined){var phasedRegistrationNames=dispatchConfig.phasedRegistrationNames;for(var phase in phasedRegistrationNames){if(!phasedRegistrationNames.hasOwnProperty(phase)){continue}var pluginModule=EventPluginRegistry.registrationNameModules[phasedRegistrationNames[phase]];if(pluginModule){return pluginModule}}}return null},_resetEventPlugins:function(){eventPluginOrder=null;for(var pluginName in namesToPlugins){if(namesToPlugins.hasOwnProperty(pluginName)){delete namesToPlugins[pluginName]}}EventPluginRegistry.plugins.length=0;var eventNameDispatchConfigs=EventPluginRegistry.eventNameDispatchConfigs;for(var eventName in eventNameDispatchConfigs){if(eventNameDispatchConfigs.hasOwnProperty(eventName)){delete eventNameDispatchConfigs[eventName]}}var registrationNameModules=EventPluginRegistry.registrationNameModules;for(var registrationName in registrationNameModules){if(registrationNameModules.hasOwnProperty(registrationName)){delete registrationNameModules[registrationName]}}if(process.env.NODE_ENV!=="production"){var possibleRegistrationNames=EventPluginRegistry.possibleRegistrationNames;for(var lowerCasedName in possibleRegistrationNames){if(possibleRegistrationNames.hasOwnProperty(lowerCasedName)){delete possibleRegistrationNames[lowerCasedName]}}}}};module.exports=EventPluginRegistry}).call(this,require("_process"))},{"./reactProdInvariant":151,_process:184,"fbjs/lib/invariant":18}],49:[function(require,module,exports){(function(process){"use strict";var _prodInvariant=require("./reactProdInvariant");var ReactErrorUtils=require("./ReactErrorUtils");var invariant=require("fbjs/lib/invariant");var warning=require("fbjs/lib/warning");var ComponentTree;var TreeTraversal;var injection={injectComponentTree:function(Injected){ComponentTree=Injected;if(process.env.NODE_ENV!=="production"){process.env.NODE_ENV!=="production"?warning(Injected&&Injected.getNodeFromInstance&&Injected.getInstanceFromNode,"EventPluginUtils.injection.injectComponentTree(...): Injected "+"module is missing getNodeFromInstance or getInstanceFromNode."):void 0}},injectTreeTraversal:function(Injected){TreeTraversal=Injected;if(process.env.NODE_ENV!=="production"){process.env.NODE_ENV!=="production"?warning(Injected&&Injected.isAncestor&&Injected.getLowestCommonAncestor,"EventPluginUtils.injection.injectTreeTraversal(...): Injected "+"module is missing isAncestor or getLowestCommonAncestor."):void 0}}};function isEndish(topLevelType){return topLevelType==="topMouseUp"||topLevelType==="topTouchEnd"||topLevelType==="topTouchCancel"}function isMoveish(topLevelType){return topLevelType==="topMouseMove"||topLevelType==="topTouchMove"}function isStartish(topLevelType){return topLevelType==="topMouseDown"||topLevelType==="topTouchStart"}var validateEventDispatches;if(process.env.NODE_ENV!=="production"){validateEventDispatches=function(event){var dispatchListeners=event._dispatchListeners;var dispatchInstances=event._dispatchInstances;var listenersIsArr=Array.isArray(dispatchListeners);var listenersLen=listenersIsArr?dispatchListeners.length:dispatchListeners?1:0;var instancesIsArr=Array.isArray(dispatchInstances);var instancesLen=instancesIsArr?dispatchInstances.length:dispatchInstances?1:0;process.env.NODE_ENV!=="production"?warning(instancesIsArr===listenersIsArr&&instancesLen===listenersLen,"EventPluginUtils: Invalid `event`."):void 0}}function executeDispatch(event,simulated,listener,inst){var type=event.type||"unknown-event";event.currentTarget=EventPluginUtils.getNodeFromInstance(inst);if(simulated){ReactErrorUtils.invokeGuardedCallbackWithCatch(type,listener,event)}else{ReactErrorUtils.invokeGuardedCallback(type,listener,event)}event.currentTarget=null}function executeDispatchesInOrder(event,simulated){var dispatchListeners=event._dispatchListeners;var dispatchInstances=event._dispatchInstances;if(process.env.NODE_ENV!=="production"){validateEventDispatches(event)}if(Array.isArray(dispatchListeners)){for(var i=0;i<dispatchListeners.length;i++){if(event.isPropagationStopped()){break}executeDispatch(event,simulated,dispatchListeners[i],dispatchInstances[i])}}else if(dispatchListeners){executeDispatch(event,simulated,dispatchListeners,dispatchInstances)}event._dispatchListeners=null;event._dispatchInstances=null}function executeDispatchesInOrderStopAtTrueImpl(event){var dispatchListeners=event._dispatchListeners;var dispatchInstances=event._dispatchInstances;if(process.env.NODE_ENV!=="production"){validateEventDispatches(event)}if(Array.isArray(dispatchListeners)){for(var i=0;i<dispatchListeners.length;i++){if(event.isPropagationStopped()){break}if(dispatchListeners[i](event,dispatchInstances[i])){return dispatchInstances[i]}}}else if(dispatchListeners){if(dispatchListeners(event,dispatchInstances)){return dispatchInstances}}return null}function executeDispatchesInOrderStopAtTrue(event){var ret=executeDispatchesInOrderStopAtTrueImpl(event);event._dispatchInstances=null;event._dispatchListeners=null;return ret}function executeDirectDispatch(event){if(process.env.NODE_ENV!=="production"){validateEventDispatches(event)}var dispatchListener=event._dispatchListeners;var dispatchInstance=event._dispatchInstances;!!Array.isArray(dispatchListener)?process.env.NODE_ENV!=="production"?invariant(false,"executeDirectDispatch(...): Invalid `event`."):_prodInvariant("103"):void 0;event.currentTarget=dispatchListener?EventPluginUtils.getNodeFromInstance(dispatchInstance):null;var res=dispatchListener?dispatchListener(event):null;event.currentTarget=null;event._dispatchListeners=null;event._dispatchInstances=null;return res}function hasDispatches(event){return!!event._dispatchListeners}var EventPluginUtils={isEndish:isEndish,isMoveish:isMoveish,isStartish:isStartish,executeDirectDispatch:executeDirectDispatch,executeDispatchesInOrder:executeDispatchesInOrder,executeDispatchesInOrderStopAtTrue:executeDispatchesInOrderStopAtTrue,hasDispatches:hasDispatches,getInstanceFromNode:function(node){return ComponentTree.getInstanceFromNode(node)},getNodeFromInstance:function(node){return ComponentTree.getNodeFromInstance(node)},isAncestor:function(a,b){return TreeTraversal.isAncestor(a,b)},getLowestCommonAncestor:function(a,b){return TreeTraversal.getLowestCommonAncestor(a,b)},getParentInstance:function(inst){return TreeTraversal.getParentInstance(inst)},traverseTwoPhase:function(target,fn,arg){return TreeTraversal.traverseTwoPhase(target,fn,arg)},traverseEnterLeave:function(from,to,fn,argFrom,argTo){return TreeTraversal.traverseEnterLeave(from,to,fn,argFrom,argTo)},injection:injection};module.exports=EventPluginUtils}).call(this,require("_process"))},{"./ReactErrorUtils":84,"./reactProdInvariant":151,_process:184,"fbjs/lib/invariant":18,"fbjs/lib/warning":25}],50:[function(require,module,exports){(function(process){"use strict";var EventPluginHub=require("./EventPluginHub");var EventPluginUtils=require("./EventPluginUtils");var accumulateInto=require("./accumulateInto");var forEachAccumulated=require("./forEachAccumulated");var warning=require("fbjs/lib/warning");var getListener=EventPluginHub.getListener;function listenerAtPhase(inst,event,propagationPhase){var registrationName=event.dispatchConfig.phasedRegistrationNames[propagationPhase];return getListener(inst,registrationName)}function accumulateDirectionalDispatches(inst,phase,event){if(process.env.NODE_ENV!=="production"){process.env.NODE_ENV!=="production"?warning(inst,"Dispatching inst must not be null"):void 0}var listener=listenerAtPhase(inst,event,phase);if(listener){event._dispatchListeners=accumulateInto(event._dispatchListeners,listener);event._dispatchInstances=accumulateInto(event._dispatchInstances,inst)}}function accumulateTwoPhaseDispatchesSingle(event){if(event&&event.dispatchConfig.phasedRegistrationNames){EventPluginUtils.traverseTwoPhase(event._targetInst,accumulateDirectionalDispatches,event)}}function accumulateTwoPhaseDispatchesSingleSkipTarget(event){if(event&&event.dispatchConfig.phasedRegistrationNames){var targetInst=event._targetInst;var parentInst=targetInst?EventPluginUtils.getParentInstance(targetInst):null;EventPluginUtils.traverseTwoPhase(parentInst,accumulateDirectionalDispatches,event)}}function accumulateDispatches(inst,ignoredDirection,event){if(event&&event.dispatchConfig.registrationName){var registrationName=event.dispatchConfig.registrationName;var listener=getListener(inst,registrationName);if(listener){event._dispatchListeners=accumulateInto(event._dispatchListeners,listener);event._dispatchInstances=accumulateInto(event._dispatchInstances,inst)}}}function accumulateDirectDispatchesSingle(event){if(event&&event.dispatchConfig.registrationName){accumulateDispatches(event._targetInst,null,event)}}function accumulateTwoPhaseDispatches(events){forEachAccumulated(events,accumulateTwoPhaseDispatchesSingle)}function accumulateTwoPhaseDispatchesSkipTarget(events){forEachAccumulated(events,accumulateTwoPhaseDispatchesSingleSkipTarget)}function accumulateEnterLeaveDispatches(leave,enter,from,to){EventPluginUtils.traverseEnterLeave(from,to,accumulateDispatches,leave,enter)}function accumulateDirectDispatches(events){forEachAccumulated(events,accumulateDirectDispatchesSingle)}var EventPropagators={accumulateTwoPhaseDispatches:accumulateTwoPhaseDispatches,accumulateTwoPhaseDispatchesSkipTarget:accumulateTwoPhaseDispatchesSkipTarget,accumulateDirectDispatches:accumulateDirectDispatches,accumulateEnterLeaveDispatches:accumulateEnterLeaveDispatches};module.exports=EventPropagators}).call(this,require("_process"))},{"./EventPluginHub":47,"./EventPluginUtils":49,"./accumulateInto":128,"./forEachAccumulated":136,_process:184,"fbjs/lib/warning":25}],51:[function(require,module,exports){"use strict";var _assign=require("object-assign");var PooledClass=require("./PooledClass");var getTextContentAccessor=require("./getTextContentAccessor");function FallbackCompositionState(root){this._root=root;this._startText=this.getText();this._fallbackText=null}_assign(FallbackCompositionState.prototype,{destructor:function(){this._root=null;this._startText=null;this._fallbackText=null},getText:function(){if("value"in this._root){return this._root.value}return this._root[getTextContentAccessor()]},getData:function(){if(this._fallbackText){return this._fallbackText}var start;var startValue=this._startText;var startLength=startValue.length;var end;var endValue=this.getText();var endLength=endValue.length;for(start=0;start<startLength;start++){if(startValue[start]!==endValue[start]){break}}var minEnd=startLength-start;for(end=1;end<=minEnd;end++){if(startValue[startLength-end]!==endValue[endLength-end]){break}}var sliceTail=end>1?1-end:undefined;this._fallbackText=endValue.slice(start,sliceTail);return this._fallbackText}});PooledClass.addPoolingTo(FallbackCompositionState);module.exports=FallbackCompositionState},{"./PooledClass":55,"./getTextContentAccessor":144,"object-assign":26}],52:[function(require,module,exports){"use strict";var DOMProperty=require("./DOMProperty");var MUST_USE_PROPERTY=DOMProperty.injection.MUST_USE_PROPERTY;var HAS_BOOLEAN_VALUE=DOMProperty.injection.HAS_BOOLEAN_VALUE;var HAS_NUMERIC_VALUE=DOMProperty.injection.HAS_NUMERIC_VALUE;var HAS_POSITIVE_NUMERIC_VALUE=DOMProperty.injection.HAS_POSITIVE_NUMERIC_VALUE;var HAS_OVERLOADED_BOOLEAN_VALUE=DOMProperty.injection.HAS_OVERLOADED_BOOLEAN_VALUE;var HTMLDOMPropertyConfig={isCustomAttribute:RegExp.prototype.test.bind(new RegExp("^(data|aria)-["+DOMProperty.ATTRIBUTE_NAME_CHAR+"]*$")),Properties:{accept:0,acceptCharset:0,accessKey:0,action:0,allowFullScreen:HAS_BOOLEAN_VALUE,allowTransparency:0,alt:0,as:0,async:HAS_BOOLEAN_VALUE,autoComplete:0,autoPlay:HAS_BOOLEAN_VALUE,capture:HAS_BOOLEAN_VALUE,cellPadding:0,cellSpacing:0,charSet:0,challenge:0,checked:MUST_USE_PROPERTY|HAS_BOOLEAN_VALUE,cite:0,classID:0,className:0,cols:HAS_POSITIVE_NUMERIC_VALUE,colSpan:0,content:0,contentEditable:0,contextMenu:0,controls:HAS_BOOLEAN_VALUE,coords:0,crossOrigin:0,data:0,dateTime:0,default:HAS_BOOLEAN_VALUE,defer:HAS_BOOLEAN_VALUE,dir:0,disabled:HAS_BOOLEAN_VALUE,download:HAS_OVERLOADED_BOOLEAN_VALUE,draggable:0,encType:0,form:0,formAction:0,formEncType:0,formMethod:0,formNoValidate:HAS_BOOLEAN_VALUE,formTarget:0,frameBorder:0,headers:0,height:0,hidden:HAS_BOOLEAN_VALUE,high:0,href:0,hrefLang:0,htmlFor:0,httpEquiv:0,icon:0,id:0,inputMode:0,integrity:0,is:0,keyParams:0,keyType:0,kind:0,label:0,lang:0,list:0,loop:HAS_BOOLEAN_VALUE,low:0,manifest:0,marginHeight:0,marginWidth:0,max:0,maxLength:0,media:0,mediaGroup:0,method:0,min:0,minLength:0,multiple:MUST_USE_PROPERTY|HAS_BOOLEAN_VALUE,muted:MUST_USE_PROPERTY|HAS_BOOLEAN_VALUE,name:0,nonce:0,noValidate:HAS_BOOLEAN_VALUE,open:HAS_BOOLEAN_VALUE,optimum:0,pattern:0,placeholder:0,playsInline:HAS_BOOLEAN_VALUE,poster:0,preload:0,profile:0,radioGroup:0,readOnly:HAS_BOOLEAN_VALUE,referrerPolicy:0,rel:0,required:HAS_BOOLEAN_VALUE,reversed:HAS_BOOLEAN_VALUE,role:0,rows:HAS_POSITIVE_NUMERIC_VALUE,rowSpan:HAS_NUMERIC_VALUE,sandbox:0,scope:0,scoped:HAS_BOOLEAN_VALUE,scrolling:0,seamless:HAS_BOOLEAN_VALUE,selected:MUST_USE_PROPERTY|HAS_BOOLEAN_VALUE,shape:0,size:HAS_POSITIVE_NUMERIC_VALUE,sizes:0,span:HAS_POSITIVE_NUMERIC_VALUE,spellCheck:0,src:0,srcDoc:0,srcLang:0,srcSet:0,start:HAS_NUMERIC_VALUE,step:0,style:0,summary:0,tabIndex:0,target:0,title:0,type:0,useMap:0,value:0,width:0,wmode:0,wrap:0,about:0,datatype:0,inlist:0,prefix:0,property:0,resource:0,typeof:0,vocab:0,autoCapitalize:0,autoCorrect:0,autoSave:0,color:0,itemProp:0,itemScope:HAS_BOOLEAN_VALUE,itemType:0,itemID:0,itemRef:0,results:0,security:0,unselectable:0},DOMAttributeNames:{acceptCharset:"accept-charset",className:"class",htmlFor:"for",httpEquiv:"http-equiv"},DOMPropertyNames:{},DOMMutationMethods:{value:function(node,value){if(value==null){return node.removeAttribute("value")}if(node.type!=="number"||node.hasAttribute("value")===false){node.setAttribute("value",""+value)}else if(node.validity&&!node.validity.badInput&&node.ownerDocument.activeElement!==node){node.setAttribute("value",""+value)}}}};module.exports=HTMLDOMPropertyConfig},{"./DOMProperty":42}],53:[function(require,module,exports){"use strict";function escape(key){var escapeRegex=/[=:]/g;var escaperLookup={"=":"=0",":":"=2"};var escapedString=(""+key).replace(escapeRegex,function(match){return escaperLookup[match]});return"$"+escapedString}function unescape(key){var unescapeRegex=/(=0|=2)/g;var unescaperLookup={"=0":"=","=2":":"};var keySubstring=key[0]==="."&&key[1]==="$"?key.substring(2):key.substring(1);return(""+keySubstring).replace(unescapeRegex,function(match){return unescaperLookup[match]})}var KeyEscapeUtils={escape:escape,unescape:unescape};module.exports=KeyEscapeUtils},{}],54:[function(require,module,exports){(function(process){"use strict";var _prodInvariant=require("./reactProdInvariant");var ReactPropTypesSecret=require("./ReactPropTypesSecret");var propTypesFactory=require("prop-types/factory");var React=require("react/lib/React");var PropTypes=propTypesFactory(React.isValidElement);var invariant=require("fbjs/lib/invariant");var warning=require("fbjs/lib/warning");var hasReadOnlyValue={button:true,checkbox:true,image:true,hidden:true,radio:true,reset:true,submit:true};function _assertSingleLink(inputProps){!(inputProps.checkedLink==null||inputProps.valueLink==null)?process.env.NODE_ENV!=="production"?invariant(false,"Cannot provide a checkedLink and a valueLink. If you want to use checkedLink, you probably don't want to use valueLink and vice versa."):_prodInvariant("87"):void 0}function _assertValueLink(inputProps){_assertSingleLink(inputProps);!(inputProps.value==null&&inputProps.onChange==null)?process.env.NODE_ENV!=="production"?invariant(false,"Cannot provide a valueLink and a value or onChange event. If you want to use value or onChange, you probably don't want to use valueLink."):_prodInvariant("88"):void 0}function _assertCheckedLink(inputProps){_assertSingleLink(inputProps);!(inputProps.checked==null&&inputProps.onChange==null)?process.env.NODE_ENV!=="production"?invariant(false,"Cannot provide a checkedLink and a checked property or onChange event. If you want to use checked or onChange, you probably don't want to use checkedLink"):_prodInvariant("89"):void 0}var propTypes={value:function(props,propName,componentName){if(!props[propName]||hasReadOnlyValue[props.type]||props.onChange||props.readOnly||props.disabled){return null}return new Error("You provided a `value` prop to a form field without an "+"`onChange` handler. This will render a read-only field. If "+"the field should be mutable use `defaultValue`. Otherwise, "+"set either `onChange` or `readOnly`.")},checked:function(props,propName,componentName){if(!props[propName]||props.onChange||props.readOnly||props.disabled){return null}return new Error("You provided a `checked` prop to a form field without an "+"`onChange` handler. This will render a read-only field. If "+"the field should be mutable use `defaultChecked`. Otherwise, "+"set either `onChange` or `readOnly`.")},onChange:PropTypes.func};var loggedTypeFailures={};function getDeclarationErrorAddendum(owner){if(owner){var name=owner.getName();if(name){return" Check the render method of `"+name+"`."}}return""}var LinkedValueUtils={checkPropTypes:function(tagName,props,owner){for(var propName in propTypes){if(propTypes.hasOwnProperty(propName)){var error=propTypes[propName](props,propName,tagName,"prop",null,ReactPropTypesSecret)}if(error instanceof Error&&!(error.message in loggedTypeFailures)){loggedTypeFailures[error.message]=true;var addendum=getDeclarationErrorAddendum(owner);process.env.NODE_ENV!=="production"?warning(false,"Failed form propType: %s%s",error.message,addendum):void 0}}},getValue:function(inputProps){if(inputProps.valueLink){_assertValueLink(inputProps);return inputProps.valueLink.value}return inputProps.value},getChecked:function(inputProps){if(inputProps.checkedLink){_assertCheckedLink(inputProps);return inputProps.checkedLink.value}return inputProps.checked},executeOnChange:function(inputProps,event){if(inputProps.valueLink){_assertValueLink(inputProps);return inputProps.valueLink.requestChange(event.target.value)}else if(inputProps.checkedLink){_assertCheckedLink(inputProps);return inputProps.checkedLink.requestChange(event.target.checked)}else if(inputProps.onChange){return inputProps.onChange.call(undefined,event)}}};module.exports=LinkedValueUtils}).call(this,require("_process"))},{"./ReactPropTypesSecret":101,"./reactProdInvariant":151,_process:184,"fbjs/lib/invariant":18,"fbjs/lib/warning":25,"prop-types/factory":28,"react/lib/React":160}],55:[function(require,module,exports){(function(process){"use strict";var _prodInvariant=require("./reactProdInvariant");var invariant=require("fbjs/lib/invariant");var oneArgumentPooler=function(copyFieldsFrom){var Klass=this;if(Klass.instancePool.length){var instance=Klass.instancePool.pop();Klass.call(instance,copyFieldsFrom);return instance}else{return new Klass(copyFieldsFrom)}};var twoArgumentPooler=function(a1,a2){var Klass=this;if(Klass.instancePool.length){var instance=Klass.instancePool.pop();Klass.call(instance,a1,a2);return instance}else{return new Klass(a1,a2)}};var threeArgumentPooler=function(a1,a2,a3){var Klass=this;if(Klass.instancePool.length){var instance=Klass.instancePool.pop();Klass.call(instance,a1,a2,a3);return instance}else{return new Klass(a1,a2,a3)}};var fourArgumentPooler=function(a1,a2,a3,a4){var Klass=this;if(Klass.instancePool.length){var instance=Klass.instancePool.pop();Klass.call(instance,a1,a2,a3,a4);return instance}else{return new Klass(a1,a2,a3,a4)}};var standardReleaser=function(instance){var Klass=this;!(instance instanceof Klass)?process.env.NODE_ENV!=="production"?invariant(false,"Trying to release an instance into a pool of a different type."):_prodInvariant("25"):void 0;instance.destructor();if(Klass.instancePool.length<Klass.poolSize){Klass.instancePool.push(instance)}};var DEFAULT_POOL_SIZE=10;var DEFAULT_POOLER=oneArgumentPooler;var addPoolingTo=function(CopyConstructor,pooler){var NewKlass=CopyConstructor;NewKlass.instancePool=[];NewKlass.getPooled=pooler||DEFAULT_POOLER;if(!NewKlass.poolSize){NewKlass.poolSize=DEFAULT_POOL_SIZE}NewKlass.release=standardReleaser;return NewKlass};var PooledClass={addPoolingTo:addPoolingTo,oneArgumentPooler:oneArgumentPooler,twoArgumentPooler:twoArgumentPooler,threeArgumentPooler:threeArgumentPooler,fourArgumentPooler:fourArgumentPooler};module.exports=PooledClass}).call(this,require("_process"))},{"./reactProdInvariant":151,_process:184,"fbjs/lib/invariant":18}],56:[function(require,module,exports){"use strict";var _assign=require("object-assign");var EventPluginRegistry=require("./EventPluginRegistry");var ReactEventEmitterMixin=require("./ReactEventEmitterMixin");var ViewportMetrics=require("./ViewportMetrics");var getVendorPrefixedEventName=require("./getVendorPrefixedEventName");var isEventSupported=require("./isEventSupported");var hasEventPageXY;var alreadyListeningTo={};var isMonitoringScrollValue=false;var reactTopListenersCounter=0;var topEventMapping={topAbort:"abort",topAnimationEnd:getVendorPrefixedEventName("animationend")||"animationend",topAnimationIteration:getVendorPrefixedEventName("animationiteration")||"animationiteration",topAnimationStart:getVendorPrefixedEventName("animationstart")||"animationstart",topBlur:"blur",topCanPlay:"canplay",topCanPlayThrough:"canplaythrough",topChange:"change",topClick:"click",topCompositionEnd:"compositionend",topCompositionStart:"compositionstart",topCompositionUpdate:"compositionupdate",topContextMenu:"contextmenu",topCopy:"copy",topCut:"cut",topDoubleClick:"dblclick",topDrag:"drag",topDragEnd:"dragend",topDragEnter:"dragenter",topDragExit:"dragexit",topDragLeave:"dragleave",topDragOver:"dragover",topDragStart:"dragstart",topDrop:"drop",topDurationChange:"durationchange",topEmptied:"emptied",topEncrypted:"encrypted",topEnded:"ended",topError:"error",topFocus:"focus",topInput:"input",topKeyDown:"keydown",topKeyPress:"keypress",topKeyUp:"keyup",topLoadedData:"loadeddata",topLoadedMetadata:"loadedmetadata",topLoadStart:"loadstart",topMouseDown:"mousedown",topMouseMove:"mousemove",topMouseOut:"mouseout",topMouseOver:"mouseover",topMouseUp:"mouseup",topPaste:"paste",topPause:"pause",topPlay:"play",topPlaying:"playing",topProgress:"progress",topRateChange:"ratechange",topScroll:"scroll",topSeeked:"seeked",topSeeking:"seeking",topSelectionChange:"selectionchange",topStalled:"stalled",topSuspend:"suspend",topTextInput:"textInput",topTimeUpdate:"timeupdate",topTouchCancel:"touchcancel",topTouchEnd:"touchend",topTouchMove:"touchmove",topTouchStart:"touchstart",topTransitionEnd:getVendorPrefixedEventName("transitionend")||"transitionend",topVolumeChange:"volumechange",topWaiting:"waiting",topWheel:"wheel"};var topListenersIDKey="_reactListenersID"+String(Math.random()).slice(2);function getListeningForDocument(mountAt){if(!Object.prototype.hasOwnProperty.call(mountAt,topListenersIDKey)){mountAt[topListenersIDKey]=reactTopListenersCounter++;alreadyListeningTo[mountAt[topListenersIDKey]]={}}return alreadyListeningTo[mountAt[topListenersIDKey]]}var ReactBrowserEventEmitter=_assign({},ReactEventEmitterMixin,{ReactEventListener:null,injection:{injectReactEventListener:function(ReactEventListener){ReactEventListener.setHandleTopLevel(ReactBrowserEventEmitter.handleTopLevel);ReactBrowserEventEmitter.ReactEventListener=ReactEventListener}},setEnabled:function(enabled){if(ReactBrowserEventEmitter.ReactEventListener){ReactBrowserEventEmitter.ReactEventListener.setEnabled(enabled)}},isEnabled:function(){return!!(ReactBrowserEventEmitter.ReactEventListener&&ReactBrowserEventEmitter.ReactEventListener.isEnabled())},listenTo:function(registrationName,contentDocumentHandle){var mountAt=contentDocumentHandle;var isListening=getListeningForDocument(mountAt);var dependencies=EventPluginRegistry.registrationNameDependencies[registrationName];for(var i=0;i<dependencies.length;i++){var dependency=dependencies[i];if(!(isListening.hasOwnProperty(dependency)&&isListening[dependency])){if(dependency==="topWheel"){if(isEventSupported("wheel")){ReactBrowserEventEmitter.ReactEventListener.trapBubbledEvent("topWheel","wheel",mountAt)}else if(isEventSupported("mousewheel")){ReactBrowserEventEmitter.ReactEventListener.trapBubbledEvent("topWheel","mousewheel",mountAt)}else{ReactBrowserEventEmitter.ReactEventListener.trapBubbledEvent("topWheel","DOMMouseScroll",mountAt)}}else if(dependency==="topScroll"){if(isEventSupported("scroll",true)){ReactBrowserEventEmitter.ReactEventListener.trapCapturedEvent("topScroll","scroll",mountAt)}else{ReactBrowserEventEmitter.ReactEventListener.trapBubbledEvent("topScroll","scroll",ReactBrowserEventEmitter.ReactEventListener.WINDOW_HANDLE)}}else if(dependency==="topFocus"||dependency==="topBlur"){if(isEventSupported("focus",true)){ReactBrowserEventEmitter.ReactEventListener.trapCapturedEvent("topFocus","focus",mountAt);ReactBrowserEventEmitter.ReactEventListener.trapCapturedEvent("topBlur","blur",mountAt)}else if(isEventSupported("focusin")){ReactBrowserEventEmitter.ReactEventListener.trapBubbledEvent("topFocus","focusin",mountAt);ReactBrowserEventEmitter.ReactEventListener.trapBubbledEvent("topBlur","focusout",mountAt)}isListening.topBlur=true;isListening.topFocus=true}else if(topEventMapping.hasOwnProperty(dependency)){ReactBrowserEventEmitter.ReactEventListener.trapBubbledEvent(dependency,topEventMapping[dependency],mountAt)}isListening[dependency]=true}}},trapBubbledEvent:function(topLevelType,handlerBaseName,handle){return ReactBrowserEventEmitter.ReactEventListener.trapBubbledEvent(topLevelType,handlerBaseName,handle)},trapCapturedEvent:function(topLevelType,handlerBaseName,handle){return ReactBrowserEventEmitter.ReactEventListener.trapCapturedEvent(topLevelType,handlerBaseName,handle)},supportsEventPageXY:function(){if(!document.createEvent){return false}var ev=document.createEvent("MouseEvent");return ev!=null&&"pageX"in ev},ensureScrollValueMonitoring:function(){if(hasEventPageXY===undefined){hasEventPageXY=ReactBrowserEventEmitter.supportsEventPageXY()}if(!hasEventPageXY&&!isMonitoringScrollValue){var refresh=ViewportMetrics.refreshScrollValues;ReactBrowserEventEmitter.ReactEventListener.monitorScrollValue(refresh);isMonitoringScrollValue=true}}});module.exports=ReactBrowserEventEmitter},{"./EventPluginRegistry":48,"./ReactEventEmitterMixin":85,"./ViewportMetrics":127,"./getVendorPrefixedEventName":145,"./isEventSupported":148,"object-assign":26}],57:[function(require,module,exports){(function(process){"use strict";var ReactReconciler=require("./ReactReconciler");var instantiateReactComponent=require("./instantiateReactComponent");var KeyEscapeUtils=require("./KeyEscapeUtils");var shouldUpdateReactComponent=require("./shouldUpdateReactComponent");var traverseAllChildren=require("./traverseAllChildren");var warning=require("fbjs/lib/warning");var ReactComponentTreeHook;if(typeof process!=="undefined"&&process.env&&process.env.NODE_ENV==="test"){ReactComponentTreeHook=require("react/lib/ReactComponentTreeHook")}function instantiateChild(childInstances,child,name,selfDebugID){var keyUnique=childInstances[name]===undefined;if(process.env.NODE_ENV!=="production"){if(!ReactComponentTreeHook){ReactComponentTreeHook=require("react/lib/ReactComponentTreeHook")}if(!keyUnique){process.env.NODE_ENV!=="production"?warning(false,"flattenChildren(...): Encountered two children with the same key, "+"`%s`. Child keys must be unique; when two children share a key, only "+"the first child will be used.%s",KeyEscapeUtils.unescape(name),ReactComponentTreeHook.getStackAddendumByID(selfDebugID)):void 0}}if(child!=null&&keyUnique){childInstances[name]=instantiateReactComponent(child,true)}}var ReactChildReconciler={instantiateChildren:function(nestedChildNodes,transaction,context,selfDebugID){if(nestedChildNodes==null){return null}var childInstances={};if(process.env.NODE_ENV!=="production"){traverseAllChildren(nestedChildNodes,function(childInsts,child,name){return instantiateChild(childInsts,child,name,selfDebugID)},childInstances)}else{traverseAllChildren(nestedChildNodes,instantiateChild,childInstances)}return childInstances},updateChildren:function(prevChildren,nextChildren,mountImages,removedNodes,transaction,hostParent,hostContainerInfo,context,selfDebugID){if(!nextChildren&&!prevChildren){return}var name;var prevChild;for(name in nextChildren){if(!nextChildren.hasOwnProperty(name)){continue}prevChild=prevChildren&&prevChildren[name];var prevElement=prevChild&&prevChild._currentElement;var nextElement=nextChildren[name];if(prevChild!=null&&shouldUpdateReactComponent(prevElement,nextElement)){ReactReconciler.receiveComponent(prevChild,nextElement,transaction,context);nextChildren[name]=prevChild}else{if(prevChild){removedNodes[name]=ReactReconciler.getHostNode(prevChild);ReactReconciler.unmountComponent(prevChild,false)}var nextChildInstance=instantiateReactComponent(nextElement,true);nextChildren[name]=nextChildInstance;var nextChildMountImage=ReactReconciler.mountComponent(nextChildInstance,transaction,hostParent,hostContainerInfo,context,selfDebugID);mountImages.push(nextChildMountImage)}}for(name in prevChildren){if(prevChildren.hasOwnProperty(name)&&!(nextChildren&&nextChildren.hasOwnProperty(name))){prevChild=prevChildren[name];removedNodes[name]=ReactReconciler.getHostNode(prevChild);ReactReconciler.unmountComponent(prevChild,false)}}},unmountChildren:function(renderedChildren,safely){for(var name in renderedChildren){if(renderedChildren.hasOwnProperty(name)){var renderedChild=renderedChildren[name];ReactReconciler.unmountComponent(renderedChild,safely)}}}};module.exports=ReactChildReconciler}).call(this,require("_process"))},{"./KeyEscapeUtils":53,"./ReactReconciler":103,"./instantiateReactComponent":147,"./shouldUpdateReactComponent":155,"./traverseAllChildren":156,_process:184,"fbjs/lib/warning":25,"react/lib/ReactComponentTreeHook":163}],58:[function(require,module,exports){"use strict";var DOMChildrenOperations=require("./DOMChildrenOperations");var ReactDOMIDOperations=require("./ReactDOMIDOperations");var ReactComponentBrowserEnvironment={processChildrenUpdates:ReactDOMIDOperations.dangerouslyProcessChildrenUpdates,replaceNodeWithMarkup:DOMChildrenOperations.dangerouslyReplaceNodeWithMarkup};module.exports=ReactComponentBrowserEnvironment},{"./DOMChildrenOperations":39,"./ReactDOMIDOperations":68}],59:[function(require,module,exports){(function(process){"use strict";var _prodInvariant=require("./reactProdInvariant");var invariant=require("fbjs/lib/invariant");var injected=false;var ReactComponentEnvironment={replaceNodeWithMarkup:null,processChildrenUpdates:null,injection:{injectEnvironment:function(environment){!!injected?process.env.NODE_ENV!=="production"?invariant(false,"ReactCompositeComponent: injectEnvironment() can only be called once."):_prodInvariant("104"):void 0;ReactComponentEnvironment.replaceNodeWithMarkup=environment.replaceNodeWithMarkup;ReactComponentEnvironment.processChildrenUpdates=environment.processChildrenUpdates;injected=true}}};module.exports=ReactComponentEnvironment}).call(this,require("_process"))},{"./reactProdInvariant":151,_process:184,"fbjs/lib/invariant":18}],60:[function(require,module,exports){(function(process){"use strict";var _prodInvariant=require("./reactProdInvariant"),_assign=require("object-assign");var React=require("react/lib/React");var ReactComponentEnvironment=require("./ReactComponentEnvironment");var ReactCurrentOwner=require("react/lib/ReactCurrentOwner");var ReactErrorUtils=require("./ReactErrorUtils");var ReactInstanceMap=require("./ReactInstanceMap");var ReactInstrumentation=require("./ReactInstrumentation");var ReactNodeTypes=require("./ReactNodeTypes");var ReactReconciler=require("./ReactReconciler");if(process.env.NODE_ENV!=="production"){var checkReactTypeSpec=require("./checkReactTypeSpec")}var emptyObject=require("fbjs/lib/emptyObject");var invariant=require("fbjs/lib/invariant");var shallowEqual=require("fbjs/lib/shallowEqual");var shouldUpdateReactComponent=require("./shouldUpdateReactComponent");var warning=require("fbjs/lib/warning");var CompositeTypes={ImpureClass:0,PureClass:1,StatelessFunctional:2};function StatelessComponent(Component){}StatelessComponent.prototype.render=function(){var Component=ReactInstanceMap.get(this)._currentElement.type;var element=Component(this.props,this.context,this.updater);warnIfInvalidElement(Component,element);return element};function warnIfInvalidElement(Component,element){if(process.env.NODE_ENV!=="production"){process.env.NODE_ENV!=="production"?warning(element===null||element===false||React.isValidElement(element),"%s(...): A valid React element (or null) must be returned. You may have "+"returned undefined, an array or some other invalid object.",Component.displayName||Component.name||"Component"):void 0;process.env.NODE_ENV!=="production"?warning(!Component.childContextTypes,"%s(...): childContextTypes cannot be defined on a functional component.",Component.displayName||Component.name||"Component"):void 0}}function shouldConstruct(Component){return!!(Component.prototype&&Component.prototype.isReactComponent)}function isPureComponent(Component){return!!(Component.prototype&&Component.prototype.isPureReactComponent)}function measureLifeCyclePerf(fn,debugID,timerType){if(debugID===0){return fn()}ReactInstrumentation.debugTool.onBeginLifeCycleTimer(debugID,timerType);try{return fn()}finally{ReactInstrumentation.debugTool.onEndLifeCycleTimer(debugID,timerType)}}var nextMountID=1;var ReactCompositeComponent={construct:function(element){this._currentElement=element;this._rootNodeID=0;this._compositeType=null;this._instance=null;this._hostParent=null;this._hostContainerInfo=null;this._updateBatchNumber=null;this._pendingElement=null;this._pendingStateQueue=null;this._pendingReplaceState=false;this._pendingForceUpdate=false;this._renderedNodeType=null;this._renderedComponent=null;this._context=null;this._mountOrder=0;this._topLevelWrapper=null;this._pendingCallbacks=null;this._calledComponentWillUnmount=false;if(process.env.NODE_ENV!=="production"){this._warnedAboutRefsInRender=false}},mountComponent:function(transaction,hostParent,hostContainerInfo,context){var _this=this;this._context=context;this._mountOrder=nextMountID++;this._hostParent=hostParent;this._hostContainerInfo=hostContainerInfo;var publicProps=this._currentElement.props;var publicContext=this._processContext(context);var Component=this._currentElement.type;var updateQueue=transaction.getUpdateQueue();var doConstruct=shouldConstruct(Component);var inst=this._constructComponent(doConstruct,publicProps,publicContext,updateQueue);var renderedElement;if(!doConstruct&&(inst==null||inst.render==null)){renderedElement=inst;warnIfInvalidElement(Component,renderedElement);!(inst===null||inst===false||React.isValidElement(inst))?process.env.NODE_ENV!=="production"?invariant(false,"%s(...): A valid React element (or null) must be returned. You may have returned undefined, an array or some other invalid object.",Component.displayName||Component.name||"Component"):_prodInvariant("105",Component.displayName||Component.name||"Component"):void 0;inst=new StatelessComponent(Component);this._compositeType=CompositeTypes.StatelessFunctional}else{if(isPureComponent(Component)){this._compositeType=CompositeTypes.PureClass}else{this._compositeType=CompositeTypes.ImpureClass}}if(process.env.NODE_ENV!=="production"){if(inst.render==null){process.env.NODE_ENV!=="production"?warning(false,"%s(...): No `render` method found on the returned component "+"instance: you may have forgotten to define `render`.",Component.displayName||Component.name||"Component"):void 0}var propsMutated=inst.props!==publicProps;var componentName=Component.displayName||Component.name||"Component";process.env.NODE_ENV!=="production"?warning(inst.props===undefined||!propsMutated,"%s(...): When calling super() in `%s`, make sure to pass "+"up the same props that your component's constructor was passed.",componentName,componentName):void 0}inst.props=publicProps;inst.context=publicContext;inst.refs=emptyObject;inst.updater=updateQueue;this._instance=inst;ReactInstanceMap.set(inst,this);if(process.env.NODE_ENV!=="production"){process.env.NODE_ENV!=="production"?warning(!inst.getInitialState||inst.getInitialState.isReactClassApproved||inst.state,"getInitialState was defined on %s, a plain JavaScript class. "+"This is only supported for classes created using React.createClass. "+"Did you mean to define a state property instead?",this.getName()||"a component"):void 0;process.env.NODE_ENV!=="production"?warning(!inst.getDefaultProps||inst.getDefaultProps.isReactClassApproved,"getDefaultProps was defined on %s, a plain JavaScript class. "+"This is only supported for classes created using React.createClass. "+"Use a static property to define defaultProps instead.",this.getName()||"a component"):void 0;process.env.NODE_ENV!=="production"?warning(!inst.propTypes,"propTypes was defined as an instance property on %s. Use a static "+"property to define propTypes instead.",this.getName()||"a component"):void 0;process.env.NODE_ENV!=="production"?warning(!inst.contextTypes,"contextTypes was defined as an instance property on %s. Use a "+"static property to define contextTypes instead.",this.getName()||"a component"):void 0;process.env.NODE_ENV!=="production"?warning(typeof inst.componentShouldUpdate!=="function","%s has a method called "+"componentShouldUpdate(). Did you mean shouldComponentUpdate()? "+"The name is phrased as a question because the function is "+"expected to return a value.",this.getName()||"A component"):void 0;process.env.NODE_ENV!=="production"?warning(typeof inst.componentDidUnmount!=="function","%s has a method called "+"componentDidUnmount(). But there is no such lifecycle method. "+"Did you mean componentWillUnmount()?",this.getName()||"A component"):void 0;process.env.NODE_ENV!=="production"?warning(typeof inst.componentWillRecieveProps!=="function","%s has a method called "+"componentWillRecieveProps(). Did you mean componentWillReceiveProps()?",this.getName()||"A component"):void 0}var initialState=inst.state;if(initialState===undefined){inst.state=initialState=null}!(typeof initialState==="object"&&!Array.isArray(initialState))?process.env.NODE_ENV!=="production"?invariant(false,"%s.state: must be set to an object or null",this.getName()||"ReactCompositeComponent"):_prodInvariant("106",this.getName()||"ReactCompositeComponent"):void 0;this._pendingStateQueue=null;this._pendingReplaceState=false;this._pendingForceUpdate=false;var markup;if(inst.unstable_handleError){markup=this.performInitialMountWithErrorHandling(renderedElement,hostParent,hostContainerInfo,transaction,context)}else{markup=this.performInitialMount(renderedElement,hostParent,hostContainerInfo,transaction,context)}if(inst.componentDidMount){if(process.env.NODE_ENV!=="production"){transaction.getReactMountReady().enqueue(function(){measureLifeCyclePerf(function(){return inst.componentDidMount()},_this._debugID,"componentDidMount")})}else{transaction.getReactMountReady().enqueue(inst.componentDidMount,inst)}}return markup},_constructComponent:function(doConstruct,publicProps,publicContext,updateQueue){if(process.env.NODE_ENV!=="production"){ReactCurrentOwner.current=this;try{return this._constructComponentWithoutOwner(doConstruct,publicProps,publicContext,updateQueue)}finally{ReactCurrentOwner.current=null}}else{return this._constructComponentWithoutOwner(doConstruct,publicProps,publicContext,updateQueue)}},_constructComponentWithoutOwner:function(doConstruct,publicProps,publicContext,updateQueue){var Component=this._currentElement.type;if(doConstruct){if(process.env.NODE_ENV!=="production"){return measureLifeCyclePerf(function(){return new Component(publicProps,publicContext,updateQueue)},this._debugID,"ctor")}else{return new Component(publicProps,publicContext,updateQueue)}}if(process.env.NODE_ENV!=="production"){return measureLifeCyclePerf(function(){return Component(publicProps,publicContext,updateQueue)},this._debugID,"render")}else{return Component(publicProps,publicContext,updateQueue)}},performInitialMountWithErrorHandling:function(renderedElement,hostParent,hostContainerInfo,transaction,context){var markup;var checkpoint=transaction.checkpoint();try{markup=this.performInitialMount(renderedElement,hostParent,hostContainerInfo,transaction,context)}catch(e){transaction.rollback(checkpoint);this._instance.unstable_handleError(e);if(this._pendingStateQueue){this._instance.state=this._processPendingState(this._instance.props,this._instance.context)}checkpoint=transaction.checkpoint();this._renderedComponent.unmountComponent(true);transaction.rollback(checkpoint);markup=this.performInitialMount(renderedElement,hostParent,hostContainerInfo,transaction,context)}return markup},performInitialMount:function(renderedElement,hostParent,hostContainerInfo,transaction,context){var inst=this._instance;var debugID=0;if(process.env.NODE_ENV!=="production"){debugID=this._debugID}if(inst.componentWillMount){if(process.env.NODE_ENV!=="production"){measureLifeCyclePerf(function(){return inst.componentWillMount()},debugID,"componentWillMount")}else{inst.componentWillMount()}if(this._pendingStateQueue){inst.state=this._processPendingState(inst.props,inst.context)}}if(renderedElement===undefined){renderedElement=this._renderValidatedComponent()}var nodeType=ReactNodeTypes.getType(renderedElement);this._renderedNodeType=nodeType;var child=this._instantiateReactComponent(renderedElement,nodeType!==ReactNodeTypes.EMPTY);this._renderedComponent=child;var markup=ReactReconciler.mountComponent(child,transaction,hostParent,hostContainerInfo,this._processChildContext(context),debugID);if(process.env.NODE_ENV!=="production"){if(debugID!==0){var childDebugIDs=child._debugID!==0?[child._debugID]:[];ReactInstrumentation.debugTool.onSetChildren(debugID,childDebugIDs)}}return markup},getHostNode:function(){return ReactReconciler.getHostNode(this._renderedComponent)},unmountComponent:function(safely){if(!this._renderedComponent){return}var inst=this._instance;if(inst.componentWillUnmount&&!inst._calledComponentWillUnmount){inst._calledComponentWillUnmount=true;if(safely){var name=this.getName()+".componentWillUnmount()";ReactErrorUtils.invokeGuardedCallback(name,inst.componentWillUnmount.bind(inst))}else{if(process.env.NODE_ENV!=="production"){measureLifeCyclePerf(function(){return inst.componentWillUnmount()},this._debugID,"componentWillUnmount")}else{inst.componentWillUnmount()}}}if(this._renderedComponent){ReactReconciler.unmountComponent(this._renderedComponent,safely);this._renderedNodeType=null;this._renderedComponent=null;this._instance=null}this._pendingStateQueue=null;this._pendingReplaceState=false;this._pendingForceUpdate=false;this._pendingCallbacks=null;this._pendingElement=null;this._context=null;this._rootNodeID=0;this._topLevelWrapper=null;ReactInstanceMap.remove(inst)},_maskContext:function(context){var Component=this._currentElement.type;var contextTypes=Component.contextTypes;if(!contextTypes){return emptyObject}var maskedContext={};for(var contextName in contextTypes){maskedContext[contextName]=context[contextName]}return maskedContext},_processContext:function(context){var maskedContext=this._maskContext(context);if(process.env.NODE_ENV!=="production"){var Component=this._currentElement.type;if(Component.contextTypes){this._checkContextTypes(Component.contextTypes,maskedContext,"context")}}return maskedContext},_processChildContext:function(currentContext){var Component=this._currentElement.type;var inst=this._instance;var childContext;if(inst.getChildContext){if(process.env.NODE_ENV!=="production"){ReactInstrumentation.debugTool.onBeginProcessingChildContext();try{childContext=inst.getChildContext()}finally{ReactInstrumentation.debugTool.onEndProcessingChildContext()}}else{childContext=inst.getChildContext()}}if(childContext){!(typeof Component.childContextTypes==="object")?process.env.NODE_ENV!=="production"?invariant(false,"%s.getChildContext(): childContextTypes must be defined in order to use getChildContext().",this.getName()||"ReactCompositeComponent"):_prodInvariant("107",this.getName()||"ReactCompositeComponent"):void 0;if(process.env.NODE_ENV!=="production"){this._checkContextTypes(Component.childContextTypes,childContext,"child context")}for(var name in childContext){!(name in Component.childContextTypes)?process.env.NODE_ENV!=="production"?invariant(false,'%s.getChildContext(): key "%s" is not defined in childContextTypes.',this.getName()||"ReactCompositeComponent",name):_prodInvariant("108",this.getName()||"ReactCompositeComponent",name):void 0}return _assign({},currentContext,childContext)}return currentContext},_checkContextTypes:function(typeSpecs,values,location){if(process.env.NODE_ENV!=="production"){checkReactTypeSpec(typeSpecs,values,location,this.getName(),null,this._debugID)}},receiveComponent:function(nextElement,transaction,nextContext){var prevElement=this._currentElement;var prevContext=this._context;this._pendingElement=null;this.updateComponent(transaction,prevElement,nextElement,prevContext,nextContext)},performUpdateIfNecessary:function(transaction){if(this._pendingElement!=null){ReactReconciler.receiveComponent(this,this._pendingElement,transaction,this._context)}else if(this._pendingStateQueue!==null||this._pendingForceUpdate){this.updateComponent(transaction,this._currentElement,this._currentElement,this._context,this._context)}else{this._updateBatchNumber=null}},updateComponent:function(transaction,prevParentElement,nextParentElement,prevUnmaskedContext,nextUnmaskedContext){var inst=this._instance;!(inst!=null)?process.env.NODE_ENV!=="production"?invariant(false,"Attempted to update component `%s` that has already been unmounted (or failed to mount).",this.getName()||"ReactCompositeComponent"):_prodInvariant("136",this.getName()||"ReactCompositeComponent"):void 0;var willReceive=false;var nextContext;if(this._context===nextUnmaskedContext){nextContext=inst.context}else{nextContext=this._processContext(nextUnmaskedContext);willReceive=true}var prevProps=prevParentElement.props;var nextProps=nextParentElement.props;if(prevParentElement!==nextParentElement){willReceive=true}if(willReceive&&inst.componentWillReceiveProps){if(process.env.NODE_ENV!=="production"){measureLifeCyclePerf(function(){return inst.componentWillReceiveProps(nextProps,nextContext)},this._debugID,"componentWillReceiveProps")}else{inst.componentWillReceiveProps(nextProps,nextContext)}}var nextState=this._processPendingState(nextProps,nextContext);var shouldUpdate=true;if(!this._pendingForceUpdate){if(inst.shouldComponentUpdate){if(process.env.NODE_ENV!=="production"){shouldUpdate=measureLifeCyclePerf(function(){return inst.shouldComponentUpdate(nextProps,nextState,nextContext)},this._debugID,"shouldComponentUpdate")}else{shouldUpdate=inst.shouldComponentUpdate(nextProps,nextState,nextContext)}}else{if(this._compositeType===CompositeTypes.PureClass){shouldUpdate=!shallowEqual(prevProps,nextProps)||!shallowEqual(inst.state,nextState)}}}if(process.env.NODE_ENV!=="production"){process.env.NODE_ENV!=="production"?warning(shouldUpdate!==undefined,"%s.shouldComponentUpdate(): Returned undefined instead of a "+"boolean value. Make sure to return true or false.",this.getName()||"ReactCompositeComponent"):void 0}this._updateBatchNumber=null;if(shouldUpdate){this._pendingForceUpdate=false;this._performComponentUpdate(nextParentElement,nextProps,nextState,nextContext,transaction,nextUnmaskedContext)}else{this._currentElement=nextParentElement;this._context=nextUnmaskedContext;inst.props=nextProps;inst.state=nextState;inst.context=nextContext}},_processPendingState:function(props,context){var inst=this._instance;var queue=this._pendingStateQueue;var replace=this._pendingReplaceState;this._pendingReplaceState=false;this._pendingStateQueue=null;if(!queue){return inst.state}if(replace&&queue.length===1){return queue[0]}var nextState=_assign({},replace?queue[0]:inst.state);for(var i=replace?1:0;i<queue.length;i++){var partial=queue[i];_assign(nextState,typeof partial==="function"?partial.call(inst,nextState,props,context):partial)}return nextState},_performComponentUpdate:function(nextElement,nextProps,nextState,nextContext,transaction,unmaskedContext){var _this2=this;var inst=this._instance;var hasComponentDidUpdate=Boolean(inst.componentDidUpdate);var prevProps;var prevState;var prevContext;if(hasComponentDidUpdate){prevProps=inst.props;prevState=inst.state;prevContext=inst.context}if(inst.componentWillUpdate){if(process.env.NODE_ENV!=="production"){measureLifeCyclePerf(function(){return inst.componentWillUpdate(nextProps,nextState,nextContext)},this._debugID,"componentWillUpdate")}else{inst.componentWillUpdate(nextProps,nextState,nextContext)}}this._currentElement=nextElement;this._context=unmaskedContext;inst.props=nextProps;inst.state=nextState;inst.context=nextContext;this._updateRenderedComponent(transaction,unmaskedContext);if(hasComponentDidUpdate){if(process.env.NODE_ENV!=="production"){transaction.getReactMountReady().enqueue(function(){measureLifeCyclePerf(inst.componentDidUpdate.bind(inst,prevProps,prevState,prevContext),_this2._debugID,"componentDidUpdate")})}else{transaction.getReactMountReady().enqueue(inst.componentDidUpdate.bind(inst,prevProps,prevState,prevContext),inst)}}},_updateRenderedComponent:function(transaction,context){var prevComponentInstance=this._renderedComponent;var prevRenderedElement=prevComponentInstance._currentElement;var nextRenderedElement=this._renderValidatedComponent();var debugID=0;if(process.env.NODE_ENV!=="production"){debugID=this._debugID}if(shouldUpdateReactComponent(prevRenderedElement,nextRenderedElement)){ReactReconciler.receiveComponent(prevComponentInstance,nextRenderedElement,transaction,this._processChildContext(context))}else{var oldHostNode=ReactReconciler.getHostNode(prevComponentInstance);ReactReconciler.unmountComponent(prevComponentInstance,false);var nodeType=ReactNodeTypes.getType(nextRenderedElement);this._renderedNodeType=nodeType;var child=this._instantiateReactComponent(nextRenderedElement,nodeType!==ReactNodeTypes.EMPTY);this._renderedComponent=child;var nextMarkup=ReactReconciler.mountComponent(child,transaction,this._hostParent,this._hostContainerInfo,this._processChildContext(context),debugID);if(process.env.NODE_ENV!=="production"){if(debugID!==0){var childDebugIDs=child._debugID!==0?[child._debugID]:[];ReactInstrumentation.debugTool.onSetChildren(debugID,childDebugIDs)}}this._replaceNodeWithMarkup(oldHostNode,nextMarkup,prevComponentInstance)}},_replaceNodeWithMarkup:function(oldHostNode,nextMarkup,prevInstance){ReactComponentEnvironment.replaceNodeWithMarkup(oldHostNode,nextMarkup,prevInstance)},_renderValidatedComponentWithoutOwnerOrContext:function(){var inst=this._instance;var renderedElement;if(process.env.NODE_ENV!=="production"){renderedElement=measureLifeCyclePerf(function(){return inst.render()},this._debugID,"render")}else{renderedElement=inst.render()}if(process.env.NODE_ENV!=="production"){if(renderedElement===undefined&&inst.render._isMockFunction){renderedElement=null}}return renderedElement},_renderValidatedComponent:function(){var renderedElement;if(process.env.NODE_ENV!=="production"||this._compositeType!==CompositeTypes.StatelessFunctional){ReactCurrentOwner.current=this;try{renderedElement=this._renderValidatedComponentWithoutOwnerOrContext()}finally{ReactCurrentOwner.current=null}}else{renderedElement=this._renderValidatedComponentWithoutOwnerOrContext()}!(renderedElement===null||renderedElement===false||React.isValidElement(renderedElement))?process.env.NODE_ENV!=="production"?invariant(false,"%s.render(): A valid React element (or null) must be returned. You may have returned undefined, an array or some other invalid object.",this.getName()||"ReactCompositeComponent"):_prodInvariant("109",this.getName()||"ReactCompositeComponent"):void 0;return renderedElement},attachRef:function(ref,component){var inst=this.getPublicInstance();!(inst!=null)?process.env.NODE_ENV!=="production"?invariant(false,"Stateless function components cannot have refs."):_prodInvariant("110"):void 0;var publicComponentInstance=component.getPublicInstance();if(process.env.NODE_ENV!=="production"){var componentName=component&&component.getName?component.getName():"a component";process.env.NODE_ENV!=="production"?warning(publicComponentInstance!=null||component._compositeType!==CompositeTypes.StatelessFunctional,"Stateless function components cannot be given refs "+'(See ref "%s" in %s created by %s). '+"Attempts to access this ref will fail.",ref,componentName,this.getName()):void 0}var refs=inst.refs===emptyObject?inst.refs={}:inst.refs;refs[ref]=publicComponentInstance},detachRef:function(ref){var refs=this.getPublicInstance().refs;delete refs[ref]},getName:function(){var type=this._currentElement.type;var constructor=this._instance&&this._instance.constructor;return type.displayName||constructor&&constructor.displayName||type.name||constructor&&constructor.name||null},getPublicInstance:function(){var inst=this._instance;if(this._compositeType===CompositeTypes.StatelessFunctional){return null}return inst},_instantiateReactComponent:null};module.exports=ReactCompositeComponent}).call(this,require("_process"))},{"./ReactComponentEnvironment":59,"./ReactErrorUtils":84,"./ReactInstanceMap":92,"./ReactInstrumentation":93,"./ReactNodeTypes":98,"./ReactReconciler":103,"./checkReactTypeSpec":130,"./reactProdInvariant":151,"./shouldUpdateReactComponent":155,_process:184,"fbjs/lib/emptyObject":11,"fbjs/lib/invariant":18,"fbjs/lib/shallowEqual":24,"fbjs/lib/warning":25,"object-assign":26,"react/lib/React":160,"react/lib/ReactCurrentOwner":164}],61:[function(require,module,exports){(function(process){"use strict";var ReactDOMComponentTree=require("./ReactDOMComponentTree");var ReactDefaultInjection=require("./ReactDefaultInjection");var ReactMount=require("./ReactMount");var ReactReconciler=require("./ReactReconciler");var ReactUpdates=require("./ReactUpdates");var ReactVersion=require("./ReactVersion");var findDOMNode=require("./findDOMNode");var getHostComponentFromComposite=require("./getHostComponentFromComposite");var renderSubtreeIntoContainer=require("./renderSubtreeIntoContainer");var warning=require("fbjs/lib/warning");ReactDefaultInjection.inject();var ReactDOM={findDOMNode:findDOMNode,render:ReactMount.render,unmountComponentAtNode:ReactMount.unmountComponentAtNode,version:ReactVersion,unstable_batchedUpdates:ReactUpdates.batchedUpdates,unstable_renderSubtreeIntoContainer:renderSubtreeIntoContainer};if(typeof __REACT_DEVTOOLS_GLOBAL_HOOK__!=="undefined"&&typeof __REACT_DEVTOOLS_GLOBAL_HOOK__.inject==="function"){__REACT_DEVTOOLS_GLOBAL_HOOK__.inject({ComponentTree:{getClosestInstanceFromNode:ReactDOMComponentTree.getClosestInstanceFromNode,getNodeFromInstance:function(inst){if(inst._renderedComponent){inst=getHostComponentFromComposite(inst)}if(inst){return ReactDOMComponentTree.getNodeFromInstance(inst)}else{return null}}},Mount:ReactMount,Reconciler:ReactReconciler})}if(process.env.NODE_ENV!=="production"){var ExecutionEnvironment=require("fbjs/lib/ExecutionEnvironment");if(ExecutionEnvironment.canUseDOM&&window.top===window.self){if(typeof __REACT_DEVTOOLS_GLOBAL_HOOK__==="undefined"){if(navigator.userAgent.indexOf("Chrome")>-1&&navigator.userAgent.indexOf("Edge")===-1||navigator.userAgent.indexOf("Firefox")>-1){var showFileUrlMessage=window.location.protocol.indexOf("http")===-1&&navigator.userAgent.indexOf("Firefox")===-1;console.debug("Download the React DevTools "+(showFileUrlMessage?"and use an HTTP server (instead of a file: URL) ":"")+"for a better development experience: "+"https://fb.me/react-devtools")}}var testFunc=function testFn(){};process.env.NODE_ENV!=="production"?warning((testFunc.name||testFunc.toString()).indexOf("testFn")!==-1,"It looks like you're using a minified copy of the development build "+"of React. When deploying React apps to production, make sure to use "+"the production build which skips development warnings and is faster. "+"See https://fb.me/react-minification for more details."):void 0;var ieCompatibilityMode=document.documentMode&&document.documentMode<8;process.env.NODE_ENV!=="production"?warning(!ieCompatibilityMode,"Internet Explorer is running in compatibility mode; please add the "+"following tag to your HTML to prevent this from happening: "+'<meta http-equiv="X-UA-Compatible" content="IE=edge" />'):void 0;var expectedFeatures=[Array.isArray,Array.prototype.every,Array.prototype.forEach,Array.prototype.indexOf,Array.prototype.map,Date.now,Function.prototype.bind,Object.keys,String.prototype.trim];for(var i=0;i<expectedFeatures.length;i++){if(!expectedFeatures[i]){process.env.NODE_ENV!=="production"?warning(false,"One or more ES5 shims expected by React are not available: "+"https://fb.me/react-warning-polyfills"):void 0;break}}}}if(process.env.NODE_ENV!=="production"){var ReactInstrumentation=require("./ReactInstrumentation");var ReactDOMUnknownPropertyHook=require("./ReactDOMUnknownPropertyHook");var ReactDOMNullInputValuePropHook=require("./ReactDOMNullInputValuePropHook");var ReactDOMInvalidARIAHook=require("./ReactDOMInvalidARIAHook");ReactInstrumentation.debugTool.addHook(ReactDOMUnknownPropertyHook);ReactInstrumentation.debugTool.addHook(ReactDOMNullInputValuePropHook);ReactInstrumentation.debugTool.addHook(ReactDOMInvalidARIAHook)}module.exports=ReactDOM}).call(this,require("_process"))},{"./ReactDOMComponentTree":64,"./ReactDOMInvalidARIAHook":70,"./ReactDOMNullInputValuePropHook":71,"./ReactDOMUnknownPropertyHook":78,"./ReactDefaultInjection":81,"./ReactInstrumentation":93,"./ReactMount":96,"./ReactReconciler":103,"./ReactUpdates":108,"./ReactVersion":109,"./findDOMNode":134,"./getHostComponentFromComposite":141,"./renderSubtreeIntoContainer":152,_process:184,"fbjs/lib/ExecutionEnvironment":4,"fbjs/lib/warning":25}],62:[function(require,module,exports){(function(process){"use strict";var _prodInvariant=require("./reactProdInvariant"),_assign=require("object-assign");var AutoFocusUtils=require("./AutoFocusUtils");var CSSPropertyOperations=require("./CSSPropertyOperations");var DOMLazyTree=require("./DOMLazyTree");var DOMNamespaces=require("./DOMNamespaces");var DOMProperty=require("./DOMProperty");var DOMPropertyOperations=require("./DOMPropertyOperations");var EventPluginHub=require("./EventPluginHub");var EventPluginRegistry=require("./EventPluginRegistry");var ReactBrowserEventEmitter=require("./ReactBrowserEventEmitter");var ReactDOMComponentFlags=require("./ReactDOMComponentFlags");var ReactDOMComponentTree=require("./ReactDOMComponentTree");var ReactDOMInput=require("./ReactDOMInput");var ReactDOMOption=require("./ReactDOMOption");var ReactDOMSelect=require("./ReactDOMSelect");var ReactDOMTextarea=require("./ReactDOMTextarea");var ReactInstrumentation=require("./ReactInstrumentation");var ReactMultiChild=require("./ReactMultiChild");var ReactServerRenderingTransaction=require("./ReactServerRenderingTransaction");var emptyFunction=require("fbjs/lib/emptyFunction");var escapeTextContentForBrowser=require("./escapeTextContentForBrowser");var invariant=require("fbjs/lib/invariant");var isEventSupported=require("./isEventSupported");var shallowEqual=require("fbjs/lib/shallowEqual");var inputValueTracking=require("./inputValueTracking");var validateDOMNesting=require("./validateDOMNesting");var warning=require("fbjs/lib/warning");var Flags=ReactDOMComponentFlags;var deleteListener=EventPluginHub.deleteListener;var getNode=ReactDOMComponentTree.getNodeFromInstance;var listenTo=ReactBrowserEventEmitter.listenTo;var registrationNameModules=EventPluginRegistry.registrationNameModules;var CONTENT_TYPES={string:true,number:true};var STYLE="style";var HTML="__html";var RESERVED_PROPS={children:null,dangerouslySetInnerHTML:null,suppressContentEditableWarning:null};var DOC_FRAGMENT_TYPE=11;function getDeclarationErrorAddendum(internalInstance){if(internalInstance){var owner=internalInstance._currentElement._owner||null;if(owner){var name=owner.getName();if(name){return" This DOM node was rendered by `"+name+"`."}}}return""}function friendlyStringify(obj){if(typeof obj==="object"){if(Array.isArray(obj)){return"["+obj.map(friendlyStringify).join(", ")+"]"}else{var pairs=[];for(var key in obj){if(Object.prototype.hasOwnProperty.call(obj,key)){var keyEscaped=/^[a-z$_][\w$_]*$/i.test(key)?key:JSON.stringify(key);pairs.push(keyEscaped+": "+friendlyStringify(obj[key]))}}return"{"+pairs.join(", ")+"}"}}else if(typeof obj==="string"){return JSON.stringify(obj)}else if(typeof obj==="function"){return"[function object]"}return String(obj)}var styleMutationWarning={};function checkAndWarnForMutatedStyle(style1,style2,component){if(style1==null||style2==null){return}if(shallowEqual(style1,style2)){return}var componentName=component._tag;var owner=component._currentElement._owner;var ownerName;if(owner){ownerName=owner.getName()}var hash=ownerName+"|"+componentName;if(styleMutationWarning.hasOwnProperty(hash)){return}styleMutationWarning[hash]=true;process.env.NODE_ENV!=="production"?warning(false,"`%s` was passed a style object that has previously been mutated. "+"Mutating `style` is deprecated. Consider cloning it beforehand. Check "+"the `render` %s. Previous style: %s. Mutated style: %s.",componentName,owner?"of `"+ownerName+"`":"using <"+componentName+">",friendlyStringify(style1),friendlyStringify(style2)):void 0}function assertValidProps(component,props){if(!props){return}if(voidElementTags[component._tag]){!(props.children==null&&props.dangerouslySetInnerHTML==null)?process.env.NODE_ENV!=="production"?invariant(false,"%s is a void element tag and must neither have `children` nor use `dangerouslySetInnerHTML`.%s",component._tag,component._currentElement._owner?" Check the render method of "+component._currentElement._owner.getName()+".":""):_prodInvariant("137",component._tag,component._currentElement._owner?" Check the render method of "+component._currentElement._owner.getName()+".":""):void 0}if(props.dangerouslySetInnerHTML!=null){!(props.children==null)?process.env.NODE_ENV!=="production"?invariant(false,"Can only set one of `children` or `props.dangerouslySetInnerHTML`."):_prodInvariant("60"):void 0;!(typeof props.dangerouslySetInnerHTML==="object"&&HTML in props.dangerouslySetInnerHTML)?process.env.NODE_ENV!=="production"?invariant(false,"`props.dangerouslySetInnerHTML` must be in the form `{__html: ...}`. Please visit https://fb.me/react-invariant-dangerously-set-inner-html for more information."):_prodInvariant("61"):void 0}if(process.env.NODE_ENV!=="production"){process.env.NODE_ENV!=="production"?warning(props.innerHTML==null,"Directly setting property `innerHTML` is not permitted. "+"For more information, lookup documentation on `dangerouslySetInnerHTML`."):void 0;process.env.NODE_ENV!=="production"?warning(props.suppressContentEditableWarning||!props.contentEditable||props.children==null,"A component is `contentEditable` and contains `children` managed by "+"React. It is now your responsibility to guarantee that none of "+"those nodes are unexpectedly modified or duplicated. This is "+"probably not intentional."):void 0;process.env.NODE_ENV!=="production"?warning(props.onFocusIn==null&&props.onFocusOut==null,"React uses onFocus and onBlur instead of onFocusIn and onFocusOut. "+"All React events are normalized to bubble, so onFocusIn and onFocusOut "+"are not needed/supported by React."):void 0}!(props.style==null||typeof props.style==="object")?process.env.NODE_ENV!=="production"?invariant(false,"The `style` prop expects a mapping from style properties to values, not a string. For example, style={{marginRight: spacing + 'em'}} when using JSX.%s",getDeclarationErrorAddendum(component)):_prodInvariant("62",getDeclarationErrorAddendum(component)):void 0}function enqueuePutListener(inst,registrationName,listener,transaction){if(transaction instanceof ReactServerRenderingTransaction){return}if(process.env.NODE_ENV!=="production"){process.env.NODE_ENV!=="production"?warning(registrationName!=="onScroll"||isEventSupported("scroll",true),"This browser doesn't support the `onScroll` event"):void 0}var containerInfo=inst._hostContainerInfo;var isDocumentFragment=containerInfo._node&&containerInfo._node.nodeType===DOC_FRAGMENT_TYPE;var doc=isDocumentFragment?containerInfo._node:containerInfo._ownerDocument;listenTo(registrationName,doc);transaction.getReactMountReady().enqueue(putListener,{inst:inst,registrationName:registrationName,listener:listener})}function putListener(){var listenerToPut=this;EventPluginHub.putListener(listenerToPut.inst,listenerToPut.registrationName,listenerToPut.listener)}function inputPostMount(){var inst=this;ReactDOMInput.postMountWrapper(inst)}function textareaPostMount(){var inst=this;ReactDOMTextarea.postMountWrapper(inst)}function optionPostMount(){var inst=this;ReactDOMOption.postMountWrapper(inst)}var setAndValidateContentChildDev=emptyFunction;if(process.env.NODE_ENV!=="production"){setAndValidateContentChildDev=function(content){var hasExistingContent=this._contentDebugID!=null;var debugID=this._debugID;var contentDebugID=-debugID;if(content==null){if(hasExistingContent){ReactInstrumentation.debugTool.onUnmountComponent(this._contentDebugID)}this._contentDebugID=null;return}validateDOMNesting(null,String(content),this,this._ancestorInfo);this._contentDebugID=contentDebugID;if(hasExistingContent){ReactInstrumentation.debugTool.onBeforeUpdateComponent(contentDebugID,content);ReactInstrumentation.debugTool.onUpdateComponent(contentDebugID)}else{ReactInstrumentation.debugTool.onBeforeMountComponent(contentDebugID,content,debugID);ReactInstrumentation.debugTool.onMountComponent(contentDebugID);ReactInstrumentation.debugTool.onSetChildren(debugID,[contentDebugID])}}}var mediaEvents={topAbort:"abort",topCanPlay:"canplay",topCanPlayThrough:"canplaythrough",topDurationChange:"durationchange",topEmptied:"emptied",topEncrypted:"encrypted",topEnded:"ended",topError:"error",topLoadedData:"loadeddata",topLoadedMetadata:"loadedmetadata",topLoadStart:"loadstart",topPause:"pause",topPlay:"play",topPlaying:"playing",topProgress:"progress",topRateChange:"ratechange",topSeeked:"seeked",topSeeking:"seeking",topStalled:"stalled",topSuspend:"suspend",topTimeUpdate:"timeupdate",topVolumeChange:"volumechange",topWaiting:"waiting"};function trackInputValue(){inputValueTracking.track(this)}function trapBubbledEventsLocal(){var inst=this;!inst._rootNodeID?process.env.NODE_ENV!=="production"?invariant(false,"Must be mounted to trap events"):_prodInvariant("63"):void 0;var node=getNode(inst);!node?process.env.NODE_ENV!=="production"?invariant(false,"trapBubbledEvent(...): Requires node to be rendered."):_prodInvariant("64"):void 0;switch(inst._tag){case"iframe":case"object":inst._wrapperState.listeners=[ReactBrowserEventEmitter.trapBubbledEvent("topLoad","load",node)];break;case"video":case"audio":inst._wrapperState.listeners=[];for(var event in mediaEvents){if(mediaEvents.hasOwnProperty(event)){inst._wrapperState.listeners.push(ReactBrowserEventEmitter.trapBubbledEvent(event,mediaEvents[event],node))}}break;case"source":inst._wrapperState.listeners=[ReactBrowserEventEmitter.trapBubbledEvent("topError","error",node)];break;case"img":inst._wrapperState.listeners=[ReactBrowserEventEmitter.trapBubbledEvent("topError","error",node),ReactBrowserEventEmitter.trapBubbledEvent("topLoad","load",node)];break;case"form":inst._wrapperState.listeners=[ReactBrowserEventEmitter.trapBubbledEvent("topReset","reset",node),ReactBrowserEventEmitter.trapBubbledEvent("topSubmit","submit",node)];break;case"input":case"select":case"textarea":inst._wrapperState.listeners=[ReactBrowserEventEmitter.trapBubbledEvent("topInvalid","invalid",node)];break}}function postUpdateSelectWrapper(){ReactDOMSelect.postUpdateWrapper(this)}var omittedCloseTags={area:true,base:true,br:true,col:true,embed:true,hr:true,img:true,input:true,keygen:true,link:true,meta:true,param:true,source:true,track:true,wbr:true};var newlineEatingTags={listing:true,pre:true,textarea:true};var voidElementTags=_assign({menuitem:true},omittedCloseTags);var VALID_TAG_REGEX=/^[a-zA-Z][a-zA-Z:_\.\-\d]*$/;var validatedTagCache={};var hasOwnProperty={}.hasOwnProperty;function validateDangerousTag(tag){if(!hasOwnProperty.call(validatedTagCache,tag)){!VALID_TAG_REGEX.test(tag)?process.env.NODE_ENV!=="production"?invariant(false,"Invalid tag: %s",tag):_prodInvariant("65",tag):void 0;validatedTagCache[tag]=true}}function isCustomComponent(tagName,props){return tagName.indexOf("-")>=0||props.is!=null}var globalIdCounter=1;function ReactDOMComponent(element){var tag=element.type;validateDangerousTag(tag);this._currentElement=element;this._tag=tag.toLowerCase();this._namespaceURI=null;this._renderedChildren=null;this._previousStyle=null;this._previousStyleCopy=null;this._hostNode=null;this._hostParent=null;this._rootNodeID=0;this._domID=0;this._hostContainerInfo=null;this._wrapperState=null;this._topLevelWrapper=null;this._flags=0;if(process.env.NODE_ENV!=="production"){this._ancestorInfo=null;setAndValidateContentChildDev.call(this,null)}}ReactDOMComponent.displayName="ReactDOMComponent";ReactDOMComponent.Mixin={mountComponent:function(transaction,hostParent,hostContainerInfo,context){this._rootNodeID=globalIdCounter++;this._domID=hostContainerInfo._idCounter++;this._hostParent=hostParent;this._hostContainerInfo=hostContainerInfo;var props=this._currentElement.props;switch(this._tag){case"audio":case"form":case"iframe":case"img":case"link":case"object":case"source":case"video":this._wrapperState={listeners:null};transaction.getReactMountReady().enqueue(trapBubbledEventsLocal,this);break;case"input":ReactDOMInput.mountWrapper(this,props,hostParent);props=ReactDOMInput.getHostProps(this,props);transaction.getReactMountReady().enqueue(trackInputValue,this);transaction.getReactMountReady().enqueue(trapBubbledEventsLocal,this);break;case"option":ReactDOMOption.mountWrapper(this,props,hostParent);props=ReactDOMOption.getHostProps(this,props);break;case"select":ReactDOMSelect.mountWrapper(this,props,hostParent);props=ReactDOMSelect.getHostProps(this,props);transaction.getReactMountReady().enqueue(trapBubbledEventsLocal,this);break;case"textarea":ReactDOMTextarea.mountWrapper(this,props,hostParent);props=ReactDOMTextarea.getHostProps(this,props);transaction.getReactMountReady().enqueue(trackInputValue,this);transaction.getReactMountReady().enqueue(trapBubbledEventsLocal,this);break}assertValidProps(this,props);var namespaceURI;var parentTag;if(hostParent!=null){namespaceURI=hostParent._namespaceURI;parentTag=hostParent._tag}else if(hostContainerInfo._tag){namespaceURI=hostContainerInfo._namespaceURI;parentTag=hostContainerInfo._tag}if(namespaceURI==null||namespaceURI===DOMNamespaces.svg&&parentTag==="foreignobject"){namespaceURI=DOMNamespaces.html}if(namespaceURI===DOMNamespaces.html){if(this._tag==="svg"){namespaceURI=DOMNamespaces.svg}else if(this._tag==="math"){namespaceURI=DOMNamespaces.mathml}}this._namespaceURI=namespaceURI;if(process.env.NODE_ENV!=="production"){var parentInfo;if(hostParent!=null){parentInfo=hostParent._ancestorInfo}else if(hostContainerInfo._tag){parentInfo=hostContainerInfo._ancestorInfo}if(parentInfo){validateDOMNesting(this._tag,null,this,parentInfo)}this._ancestorInfo=validateDOMNesting.updatedAncestorInfo(parentInfo,this._tag,this)}var mountImage;if(transaction.useCreateElement){var ownerDocument=hostContainerInfo._ownerDocument;var el;if(namespaceURI===DOMNamespaces.html){if(this._tag==="script"){var div=ownerDocument.createElement("div");var type=this._currentElement.type;div.innerHTML="<"+type+"></"+type+">";el=div.removeChild(div.firstChild)}else if(props.is){el=ownerDocument.createElement(this._currentElement.type,props.is)}else{el=ownerDocument.createElement(this._currentElement.type)}}else{el=ownerDocument.createElementNS(namespaceURI,this._currentElement.type)}ReactDOMComponentTree.precacheNode(this,el);this._flags|=Flags.hasCachedChildNodes;if(!this._hostParent){DOMPropertyOperations.setAttributeForRoot(el)}this._updateDOMProperties(null,props,transaction);var lazyTree=DOMLazyTree(el);this._createInitialChildren(transaction,props,context,lazyTree);mountImage=lazyTree}else{var tagOpen=this._createOpenTagMarkupAndPutListeners(transaction,props);var tagContent=this._createContentMarkup(transaction,props,context);if(!tagContent&&omittedCloseTags[this._tag]){mountImage=tagOpen+"/>"}else{mountImage=tagOpen+">"+tagContent+"</"+this._currentElement.type+">"}}switch(this._tag){case"input":transaction.getReactMountReady().enqueue(inputPostMount,this);if(props.autoFocus){transaction.getReactMountReady().enqueue(AutoFocusUtils.focusDOMComponent,this)}break;case"textarea":transaction.getReactMountReady().enqueue(textareaPostMount,this);if(props.autoFocus){transaction.getReactMountReady().enqueue(AutoFocusUtils.focusDOMComponent,this)}break;case"select":if(props.autoFocus){transaction.getReactMountReady().enqueue(AutoFocusUtils.focusDOMComponent,this)}break;case"button":if(props.autoFocus){transaction.getReactMountReady().enqueue(AutoFocusUtils.focusDOMComponent,this)}break;case"option":transaction.getReactMountReady().enqueue(optionPostMount,this);break}return mountImage},_createOpenTagMarkupAndPutListeners:function(transaction,props){var ret="<"+this._currentElement.type;for(var propKey in props){if(!props.hasOwnProperty(propKey)){continue}var propValue=props[propKey];if(propValue==null){continue}if(registrationNameModules.hasOwnProperty(propKey)){if(propValue){enqueuePutListener(this,propKey,propValue,transaction)}}else{if(propKey===STYLE){if(propValue){if(process.env.NODE_ENV!=="production"){this._previousStyle=propValue}propValue=this._previousStyleCopy=_assign({},props.style)}propValue=CSSPropertyOperations.createMarkupForStyles(propValue,this)}var markup=null;if(this._tag!=null&&isCustomComponent(this._tag,props)){if(!RESERVED_PROPS.hasOwnProperty(propKey)){markup=DOMPropertyOperations.createMarkupForCustomAttribute(propKey,propValue)}}else{markup=DOMPropertyOperations.createMarkupForProperty(propKey,propValue)}if(markup){ret+=" "+markup}}}if(transaction.renderToStaticMarkup){return ret}if(!this._hostParent){ret+=" "+DOMPropertyOperations.createMarkupForRoot()}ret+=" "+DOMPropertyOperations.createMarkupForID(this._domID);return ret},_createContentMarkup:function(transaction,props,context){var ret="";var innerHTML=props.dangerouslySetInnerHTML;if(innerHTML!=null){if(innerHTML.__html!=null){ret=innerHTML.__html}}else{var contentToUse=CONTENT_TYPES[typeof props.children]?props.children:null;var childrenToUse=contentToUse!=null?null:props.children;if(contentToUse!=null){ret=escapeTextContentForBrowser(contentToUse);if(process.env.NODE_ENV!=="production"){setAndValidateContentChildDev.call(this,contentToUse)}}else if(childrenToUse!=null){var mountImages=this.mountChildren(childrenToUse,transaction,context);ret=mountImages.join("")}}if(newlineEatingTags[this._tag]&&ret.charAt(0)==="\n"){return"\n"+ret}else{return ret}},_createInitialChildren:function(transaction,props,context,lazyTree){var innerHTML=props.dangerouslySetInnerHTML;if(innerHTML!=null){if(innerHTML.__html!=null){DOMLazyTree.queueHTML(lazyTree,innerHTML.__html)}}else{var contentToUse=CONTENT_TYPES[typeof props.children]?props.children:null;var childrenToUse=contentToUse!=null?null:props.children;if(contentToUse!=null){if(contentToUse!==""){if(process.env.NODE_ENV!=="production"){setAndValidateContentChildDev.call(this,contentToUse)}DOMLazyTree.queueText(lazyTree,contentToUse)}}else if(childrenToUse!=null){var mountImages=this.mountChildren(childrenToUse,transaction,context);for(var i=0;i<mountImages.length;i++){DOMLazyTree.queueChild(lazyTree,mountImages[i])}}}},receiveComponent:function(nextElement,transaction,context){var prevElement=this._currentElement;this._currentElement=nextElement;this.updateComponent(transaction,prevElement,nextElement,context)},updateComponent:function(transaction,prevElement,nextElement,context){var lastProps=prevElement.props;var nextProps=this._currentElement.props;switch(this._tag){case"input":lastProps=ReactDOMInput.getHostProps(this,lastProps);nextProps=ReactDOMInput.getHostProps(this,nextProps);break;case"option":lastProps=ReactDOMOption.getHostProps(this,lastProps);nextProps=ReactDOMOption.getHostProps(this,nextProps);break;case"select":lastProps=ReactDOMSelect.getHostProps(this,lastProps);nextProps=ReactDOMSelect.getHostProps(this,nextProps);break;case"textarea":lastProps=ReactDOMTextarea.getHostProps(this,lastProps);nextProps=ReactDOMTextarea.getHostProps(this,nextProps);break}assertValidProps(this,nextProps);this._updateDOMProperties(lastProps,nextProps,transaction);this._updateDOMChildren(lastProps,nextProps,transaction,context);switch(this._tag){case"input":ReactDOMInput.updateWrapper(this);break;case"textarea":ReactDOMTextarea.updateWrapper(this);break;case"select":transaction.getReactMountReady().enqueue(postUpdateSelectWrapper,this);break}},_updateDOMProperties:function(lastProps,nextProps,transaction){var propKey;var styleName;var styleUpdates;for(propKey in lastProps){if(nextProps.hasOwnProperty(propKey)||!lastProps.hasOwnProperty(propKey)||lastProps[propKey]==null){continue}if(propKey===STYLE){var lastStyle=this._previousStyleCopy;for(styleName in lastStyle){if(lastStyle.hasOwnProperty(styleName)){styleUpdates=styleUpdates||{};styleUpdates[styleName]=""}}this._previousStyleCopy=null}else if(registrationNameModules.hasOwnProperty(propKey)){if(lastProps[propKey]){deleteListener(this,propKey)}}else if(isCustomComponent(this._tag,lastProps)){if(!RESERVED_PROPS.hasOwnProperty(propKey)){DOMPropertyOperations.deleteValueForAttribute(getNode(this),propKey)}}else if(DOMProperty.properties[propKey]||DOMProperty.isCustomAttribute(propKey)){DOMPropertyOperations.deleteValueForProperty(getNode(this),propKey)}}for(propKey in nextProps){var nextProp=nextProps[propKey];var lastProp=propKey===STYLE?this._previousStyleCopy:lastProps!=null?lastProps[propKey]:undefined;if(!nextProps.hasOwnProperty(propKey)||nextProp===lastProp||nextProp==null&&lastProp==null){continue}if(propKey===STYLE){if(nextProp){if(process.env.NODE_ENV!=="production"){checkAndWarnForMutatedStyle(this._previousStyleCopy,this._previousStyle,this);this._previousStyle=nextProp}nextProp=this._previousStyleCopy=_assign({},nextProp)}else{this._previousStyleCopy=null}if(lastProp){for(styleName in lastProp){if(lastProp.hasOwnProperty(styleName)&&(!nextProp||!nextProp.hasOwnProperty(styleName))){styleUpdates=styleUpdates||{};styleUpdates[styleName]=""}}for(styleName in nextProp){if(nextProp.hasOwnProperty(styleName)&&lastProp[styleName]!==nextProp[styleName]){styleUpdates=styleUpdates||{};styleUpdates[styleName]=nextProp[styleName]}}}else{styleUpdates=nextProp}}else if(registrationNameModules.hasOwnProperty(propKey)){if(nextProp){enqueuePutListener(this,propKey,nextProp,transaction)}else if(lastProp){deleteListener(this,propKey)}}else if(isCustomComponent(this._tag,nextProps)){if(!RESERVED_PROPS.hasOwnProperty(propKey)){DOMPropertyOperations.setValueForAttribute(getNode(this),propKey,nextProp)}}else if(DOMProperty.properties[propKey]||DOMProperty.isCustomAttribute(propKey)){var node=getNode(this);if(nextProp!=null){DOMPropertyOperations.setValueForProperty(node,propKey,nextProp)}else{DOMPropertyOperations.deleteValueForProperty(node,propKey)}}}if(styleUpdates){CSSPropertyOperations.setValueForStyles(getNode(this),styleUpdates,this)}},_updateDOMChildren:function(lastProps,nextProps,transaction,context){var lastContent=CONTENT_TYPES[typeof lastProps.children]?lastProps.children:null;var nextContent=CONTENT_TYPES[typeof nextProps.children]?nextProps.children:null;var lastHtml=lastProps.dangerouslySetInnerHTML&&lastProps.dangerouslySetInnerHTML.__html;var nextHtml=nextProps.dangerouslySetInnerHTML&&nextProps.dangerouslySetInnerHTML.__html;var lastChildren=lastContent!=null?null:lastProps.children;var nextChildren=nextContent!=null?null:nextProps.children;var lastHasContentOrHtml=lastContent!=null||lastHtml!=null;var nextHasContentOrHtml=nextContent!=null||nextHtml!=null;if(lastChildren!=null&&nextChildren==null){this.updateChildren(null,transaction,context)}else if(lastHasContentOrHtml&&!nextHasContentOrHtml){this.updateTextContent("");if(process.env.NODE_ENV!=="production"){ReactInstrumentation.debugTool.onSetChildren(this._debugID,[])}}if(nextContent!=null){if(lastContent!==nextContent){this.updateTextContent(""+nextContent);if(process.env.NODE_ENV!=="production"){setAndValidateContentChildDev.call(this,nextContent)}}}else if(nextHtml!=null){if(lastHtml!==nextHtml){this.updateMarkup(""+nextHtml)}if(process.env.NODE_ENV!=="production"){ReactInstrumentation.debugTool.onSetChildren(this._debugID,[])}}else if(nextChildren!=null){if(process.env.NODE_ENV!=="production"){setAndValidateContentChildDev.call(this,null)}this.updateChildren(nextChildren,transaction,context)}},getHostNode:function(){return getNode(this)},unmountComponent:function(safely){switch(this._tag){case"audio":case"form":case"iframe":case"img":case"link":case"object":case"source":case"video":var listeners=this._wrapperState.listeners;if(listeners){for(var i=0;i<listeners.length;i++){listeners[i].remove()}}break;case"input":case"textarea":inputValueTracking.stopTracking(this);break;case"html":case"head":case"body":!false?process.env.NODE_ENV!=="production"?invariant(false,"<%s> tried to unmount. Because of cross-browser quirks it is impossible to unmount some top-level components (eg <html>, <head>, and <body>) reliably and efficiently. To fix this, have a single top-level component that never unmounts render these elements.",this._tag):_prodInvariant("66",this._tag):void 0;break}this.unmountChildren(safely);ReactDOMComponentTree.uncacheNode(this);EventPluginHub.deleteAllListeners(this);this._rootNodeID=0;this._domID=0;this._wrapperState=null;if(process.env.NODE_ENV!=="production"){setAndValidateContentChildDev.call(this,null)}},getPublicInstance:function(){return getNode(this)}};_assign(ReactDOMComponent.prototype,ReactDOMComponent.Mixin,ReactMultiChild.Mixin);module.exports=ReactDOMComponent}).call(this,require("_process"))},{"./AutoFocusUtils":33,"./CSSPropertyOperations":36,"./DOMLazyTree":40,"./DOMNamespaces":41,"./DOMProperty":42,"./DOMPropertyOperations":43,"./EventPluginHub":47,"./EventPluginRegistry":48,"./ReactBrowserEventEmitter":56,"./ReactDOMComponentFlags":63,"./ReactDOMComponentTree":64,"./ReactDOMInput":69,"./ReactDOMOption":72,"./ReactDOMSelect":73,"./ReactDOMTextarea":76,"./ReactInstrumentation":93,"./ReactMultiChild":97,"./ReactServerRenderingTransaction":105,"./escapeTextContentForBrowser":133,"./inputValueTracking":146,"./isEventSupported":148,"./reactProdInvariant":151,"./validateDOMNesting":157,_process:184,"fbjs/lib/emptyFunction":10,"fbjs/lib/invariant":18,"fbjs/lib/shallowEqual":24,"fbjs/lib/warning":25,"object-assign":26}],63:[function(require,module,exports){"use strict";var ReactDOMComponentFlags={hasCachedChildNodes:1<<0};module.exports=ReactDOMComponentFlags},{}],64:[function(require,module,exports){(function(process){"use strict";var _prodInvariant=require("./reactProdInvariant");var DOMProperty=require("./DOMProperty");var ReactDOMComponentFlags=require("./ReactDOMComponentFlags");var invariant=require("fbjs/lib/invariant");var ATTR_NAME=DOMProperty.ID_ATTRIBUTE_NAME;var Flags=ReactDOMComponentFlags;var internalInstanceKey="__reactInternalInstance$"+Math.random().toString(36).slice(2);function shouldPrecacheNode(node,nodeID){return node.nodeType===1&&node.getAttribute(ATTR_NAME)===String(nodeID)||node.nodeType===8&&node.nodeValue===" react-text: "+nodeID+" "||node.nodeType===8&&node.nodeValue===" react-empty: "+nodeID+" "}function getRenderedHostOrTextFromComponent(component){var rendered;while(rendered=component._renderedComponent){component=rendered}return component}function precacheNode(inst,node){var hostInst=getRenderedHostOrTextFromComponent(inst);hostInst._hostNode=node;node[internalInstanceKey]=hostInst}function uncacheNode(inst){var node=inst._hostNode;if(node){delete node[internalInstanceKey];inst._hostNode=null}}function precacheChildNodes(inst,node){if(inst._flags&Flags.hasCachedChildNodes){return}var children=inst._renderedChildren;var childNode=node.firstChild;outer:for(var name in children){if(!children.hasOwnProperty(name)){continue}var childInst=children[name];var childID=getRenderedHostOrTextFromComponent(childInst)._domID;if(childID===0){continue}for(;childNode!==null;childNode=childNode.nextSibling){if(shouldPrecacheNode(childNode,childID)){precacheNode(childInst,childNode);continue outer}}!false?process.env.NODE_ENV!=="production"?invariant(false,"Unable to find element with ID %s.",childID):_prodInvariant("32",childID):void 0}inst._flags|=Flags.hasCachedChildNodes}function getClosestInstanceFromNode(node){if(node[internalInstanceKey]){return node[internalInstanceKey]}var parents=[];while(!node[internalInstanceKey]){parents.push(node);if(node.parentNode){node=node.parentNode}else{return null}}var closest;var inst;for(;node&&(inst=node[internalInstanceKey]);node=parents.pop()){closest=inst;if(parents.length){precacheChildNodes(inst,node)}}return closest}function getInstanceFromNode(node){var inst=getClosestInstanceFromNode(node);if(inst!=null&&inst._hostNode===node){return inst}else{return null}}function getNodeFromInstance(inst){!(inst._hostNode!==undefined)?process.env.NODE_ENV!=="production"?invariant(false,"getNodeFromInstance: Invalid argument."):_prodInvariant("33"):void 0;if(inst._hostNode){return inst._hostNode}var parents=[];while(!inst._hostNode){parents.push(inst);!inst._hostParent?process.env.NODE_ENV!=="production"?invariant(false,"React DOM tree root should always have a node reference."):_prodInvariant("34"):void 0;inst=inst._hostParent}for(;parents.length;inst=parents.pop()){precacheChildNodes(inst,inst._hostNode)}return inst._hostNode}var ReactDOMComponentTree={getClosestInstanceFromNode:getClosestInstanceFromNode,getInstanceFromNode:getInstanceFromNode,getNodeFromInstance:getNodeFromInstance,precacheChildNodes:precacheChildNodes,precacheNode:precacheNode,uncacheNode:uncacheNode};module.exports=ReactDOMComponentTree}).call(this,require("_process"))},{"./DOMProperty":42,"./ReactDOMComponentFlags":63,"./reactProdInvariant":151,_process:184,"fbjs/lib/invariant":18}],65:[function(require,module,exports){(function(process){"use strict";var validateDOMNesting=require("./validateDOMNesting");var DOC_NODE_TYPE=9;function ReactDOMContainerInfo(topLevelWrapper,node){var info={_topLevelWrapper:topLevelWrapper,_idCounter:1,_ownerDocument:node?node.nodeType===DOC_NODE_TYPE?node:node.ownerDocument:null,_node:node,_tag:node?node.nodeName.toLowerCase():null,_namespaceURI:node?node.namespaceURI:null};if(process.env.NODE_ENV!=="production"){info._ancestorInfo=node?validateDOMNesting.updatedAncestorInfo(null,info._tag,null):null}return info}module.exports=ReactDOMContainerInfo}).call(this,require("_process"))},{"./validateDOMNesting":157,_process:184}],66:[function(require,module,exports){"use strict";var _assign=require("object-assign");var DOMLazyTree=require("./DOMLazyTree");var ReactDOMComponentTree=require("./ReactDOMComponentTree");var ReactDOMEmptyComponent=function(instantiate){this._currentElement=null;this._hostNode=null;this._hostParent=null;this._hostContainerInfo=null;this._domID=0};_assign(ReactDOMEmptyComponent.prototype,{mountComponent:function(transaction,hostParent,hostContainerInfo,context){var domID=hostContainerInfo._idCounter++;this._domID=domID;this._hostParent=hostParent;this._hostContainerInfo=hostContainerInfo;var nodeValue=" react-empty: "+this._domID+" ";if(transaction.useCreateElement){var ownerDocument=hostContainerInfo._ownerDocument;var node=ownerDocument.createComment(nodeValue);ReactDOMComponentTree.precacheNode(this,node);return DOMLazyTree(node)}else{if(transaction.renderToStaticMarkup){return""}return"\x3c!--"+nodeValue+"--\x3e"}},receiveComponent:function(){},getHostNode:function(){return ReactDOMComponentTree.getNodeFromInstance(this)},unmountComponent:function(){ReactDOMComponentTree.uncacheNode(this)}});module.exports=ReactDOMEmptyComponent},{"./DOMLazyTree":40,"./ReactDOMComponentTree":64,"object-assign":26}],67:[function(require,module,exports){"use strict";var ReactDOMFeatureFlags={useCreateElement:true,useFiber:false};module.exports=ReactDOMFeatureFlags},{}],68:[function(require,module,exports){"use strict";var DOMChildrenOperations=require("./DOMChildrenOperations");var ReactDOMComponentTree=require("./ReactDOMComponentTree");var ReactDOMIDOperations={dangerouslyProcessChildrenUpdates:function(parentInst,updates){var node=ReactDOMComponentTree.getNodeFromInstance(parentInst);DOMChildrenOperations.processUpdates(node,updates)}};module.exports=ReactDOMIDOperations},{"./DOMChildrenOperations":39,"./ReactDOMComponentTree":64}],69:[function(require,module,exports){(function(process){"use strict";var _prodInvariant=require("./reactProdInvariant"),_assign=require("object-assign");var DOMPropertyOperations=require("./DOMPropertyOperations");var LinkedValueUtils=require("./LinkedValueUtils");var ReactDOMComponentTree=require("./ReactDOMComponentTree");var ReactUpdates=require("./ReactUpdates");var invariant=require("fbjs/lib/invariant");var warning=require("fbjs/lib/warning");var didWarnValueLink=false;var didWarnCheckedLink=false;var didWarnValueDefaultValue=false;var didWarnCheckedDefaultChecked=false;var didWarnControlledToUncontrolled=false;var didWarnUncontrolledToControlled=false;function forceUpdateIfMounted(){if(this._rootNodeID){ReactDOMInput.updateWrapper(this)}}function isControlled(props){var usesChecked=props.type==="checkbox"||props.type==="radio";return usesChecked?props.checked!=null:props.value!=null}var ReactDOMInput={getHostProps:function(inst,props){var value=LinkedValueUtils.getValue(props);var checked=LinkedValueUtils.getChecked(props);var hostProps=_assign({type:undefined,step:undefined,min:undefined,max:undefined},props,{defaultChecked:undefined,defaultValue:undefined,value:value!=null?value:inst._wrapperState.initialValue,checked:checked!=null?checked:inst._wrapperState.initialChecked,onChange:inst._wrapperState.onChange});return hostProps},mountWrapper:function(inst,props){if(process.env.NODE_ENV!=="production"){LinkedValueUtils.checkPropTypes("input",props,inst._currentElement._owner);var owner=inst._currentElement._owner;if(props.valueLink!==undefined&&!didWarnValueLink){process.env.NODE_ENV!=="production"?warning(false,"`valueLink` prop on `input` is deprecated; set `value` and `onChange` instead."):void 0;didWarnValueLink=true}if(props.checkedLink!==undefined&&!didWarnCheckedLink){process.env.NODE_ENV!=="production"?warning(false,"`checkedLink` prop on `input` is deprecated; set `value` and `onChange` instead."):void 0;didWarnCheckedLink=true}if(props.checked!==undefined&&props.defaultChecked!==undefined&&!didWarnCheckedDefaultChecked){process.env.NODE_ENV!=="production"?warning(false,"%s contains an input of type %s with both checked and defaultChecked props. "+"Input elements must be either controlled or uncontrolled "+"(specify either the checked prop, or the defaultChecked prop, but not "+"both). Decide between using a controlled or uncontrolled input "+"element and remove one of these props. More info: "+"https://fb.me/react-controlled-components",owner&&owner.getName()||"A component",props.type):void 0;didWarnCheckedDefaultChecked=true}if(props.value!==undefined&&props.defaultValue!==undefined&&!didWarnValueDefaultValue){process.env.NODE_ENV!=="production"?warning(false,"%s contains an input of type %s with both value and defaultValue props. "+"Input elements must be either controlled or uncontrolled "+"(specify either the value prop, or the defaultValue prop, but not "+"both). Decide between using a controlled or uncontrolled input "+"element and remove one of these props. More info: "+"https://fb.me/react-controlled-components",owner&&owner.getName()||"A component",props.type):void 0;didWarnValueDefaultValue=true}}var defaultValue=props.defaultValue;inst._wrapperState={initialChecked:props.checked!=null?props.checked:props.defaultChecked,initialValue:props.value!=null?props.value:defaultValue,listeners:null,onChange:_handleChange.bind(inst),controlled:isControlled(props)}},updateWrapper:function(inst){var props=inst._currentElement.props;if(process.env.NODE_ENV!=="production"){var controlled=isControlled(props);var owner=inst._currentElement._owner;if(!inst._wrapperState.controlled&&controlled&&!didWarnUncontrolledToControlled){process.env.NODE_ENV!=="production"?warning(false,"%s is changing an uncontrolled input of type %s to be controlled. "+"Input elements should not switch from uncontrolled to controlled (or vice versa). "+"Decide between using a controlled or uncontrolled input "+"element for the lifetime of the component. More info: https://fb.me/react-controlled-components",owner&&owner.getName()||"A component",props.type):void 0;didWarnUncontrolledToControlled=true}if(inst._wrapperState.controlled&&!controlled&&!didWarnControlledToUncontrolled){process.env.NODE_ENV!=="production"?warning(false,"%s is changing a controlled input of type %s to be uncontrolled. "+"Input elements should not switch from controlled to uncontrolled (or vice versa). "+"Decide between using a controlled or uncontrolled input "+"element for the lifetime of the component. More info: https://fb.me/react-controlled-components",owner&&owner.getName()||"A component",props.type):void 0;didWarnControlledToUncontrolled=true}}var checked=props.checked;if(checked!=null){DOMPropertyOperations.setValueForProperty(ReactDOMComponentTree.getNodeFromInstance(inst),"checked",checked||false)}var node=ReactDOMComponentTree.getNodeFromInstance(inst);var value=LinkedValueUtils.getValue(props);if(value!=null){if(value===0&&node.value===""){node.value="0"}else if(props.type==="number"){var valueAsNumber=parseFloat(node.value,10)||0;if(value!=valueAsNumber||value==valueAsNumber&&node.value!=value){node.value=""+value}}else if(node.value!==""+value){node.value=""+value}}else{if(props.value==null&&props.defaultValue!=null){if(node.defaultValue!==""+props.defaultValue){node.defaultValue=""+props.defaultValue}}if(props.checked==null&&props.defaultChecked!=null){node.defaultChecked=!!props.defaultChecked}}},postMountWrapper:function(inst){var props=inst._currentElement.props;var node=ReactDOMComponentTree.getNodeFromInstance(inst);switch(props.type){case"submit":case"reset":break;case"color":case"date":case"datetime":case"datetime-local":case"month":case"time":case"week":node.value="";node.value=node.defaultValue;break;default:node.value=node.value;break}var name=node.name;if(name!==""){node.name=""}node.defaultChecked=!node.defaultChecked;node.defaultChecked=!node.defaultChecked;if(name!==""){node.name=name}}};function _handleChange(event){var props=this._currentElement.props;var returnValue=LinkedValueUtils.executeOnChange(props,event);ReactUpdates.asap(forceUpdateIfMounted,this);var name=props.name;if(props.type==="radio"&&name!=null){var rootNode=ReactDOMComponentTree.getNodeFromInstance(this);var queryRoot=rootNode;while(queryRoot.parentNode){queryRoot=queryRoot.parentNode}var group=queryRoot.querySelectorAll("input[name="+JSON.stringify(""+name)+'][type="radio"]');for(var i=0;i<group.length;i++){var otherNode=group[i];if(otherNode===rootNode||otherNode.form!==rootNode.form){continue}var otherInstance=ReactDOMComponentTree.getInstanceFromNode(otherNode);!otherInstance?process.env.NODE_ENV!=="production"?invariant(false,"ReactDOMInput: Mixing React and non-React radio inputs with the same `name` is not supported."):_prodInvariant("90"):void 0;ReactUpdates.asap(forceUpdateIfMounted,otherInstance)}}return returnValue}module.exports=ReactDOMInput}).call(this,require("_process"))},{"./DOMPropertyOperations":43,"./LinkedValueUtils":54,"./ReactDOMComponentTree":64,"./ReactUpdates":108,"./reactProdInvariant":151,_process:184,"fbjs/lib/invariant":18,"fbjs/lib/warning":25,"object-assign":26}],70:[function(require,module,exports){(function(process){"use strict";var DOMProperty=require("./DOMProperty");var ReactComponentTreeHook=require("react/lib/ReactComponentTreeHook");var warning=require("fbjs/lib/warning");var warnedProperties={};var rARIA=new RegExp("^(aria)-["+DOMProperty.ATTRIBUTE_NAME_CHAR+"]*$");function validateProperty(tagName,name,debugID){if(warnedProperties.hasOwnProperty(name)&&warnedProperties[name]){return true}if(rARIA.test(name)){var lowerCasedName=name.toLowerCase();var standardName=DOMProperty.getPossibleStandardName.hasOwnProperty(lowerCasedName)?DOMProperty.getPossibleStandardName[lowerCasedName]:null;if(standardName==null){warnedProperties[name]=true;return false}if(name!==standardName){process.env.NODE_ENV!=="production"?warning(false,"Unknown ARIA attribute %s. Did you mean %s?%s",name,standardName,ReactComponentTreeHook.getStackAddendumByID(debugID)):void 0;warnedProperties[name]=true;return true}}return true}function warnInvalidARIAProps(debugID,element){var invalidProps=[];for(var key in element.props){var isValid=validateProperty(element.type,key,debugID);if(!isValid){invalidProps.push(key)}}var unknownPropString=invalidProps.map(function(prop){return"`"+prop+"`"}).join(", ");if(invalidProps.length===1){process.env.NODE_ENV!=="production"?warning(false,"Invalid aria prop %s on <%s> tag. "+"For details, see https://fb.me/invalid-aria-prop%s",unknownPropString,element.type,ReactComponentTreeHook.getStackAddendumByID(debugID)):void 0}else if(invalidProps.length>1){process.env.NODE_ENV!=="production"?warning(false,"Invalid aria props %s on <%s> tag. "+"For details, see https://fb.me/invalid-aria-prop%s",unknownPropString,element.type,ReactComponentTreeHook.getStackAddendumByID(debugID)):void 0}}function handleElement(debugID,element){if(element==null||typeof element.type!=="string"){return}if(element.type.indexOf("-")>=0||element.props.is){return}warnInvalidARIAProps(debugID,element)}var ReactDOMInvalidARIAHook={onBeforeMountComponent:function(debugID,element){if(process.env.NODE_ENV!=="production"){handleElement(debugID,element)}},onBeforeUpdateComponent:function(debugID,element){if(process.env.NODE_ENV!=="production"){handleElement(debugID,element)}}};module.exports=ReactDOMInvalidARIAHook}).call(this,require("_process"))},{"./DOMProperty":42,_process:184,"fbjs/lib/warning":25,"react/lib/ReactComponentTreeHook":163}],71:[function(require,module,exports){(function(process){"use strict";var ReactComponentTreeHook=require("react/lib/ReactComponentTreeHook");var warning=require("fbjs/lib/warning");var didWarnValueNull=false;function handleElement(debugID,element){if(element==null){return}if(element.type!=="input"&&element.type!=="textarea"&&element.type!=="select"){return}if(element.props!=null&&element.props.value===null&&!didWarnValueNull){process.env.NODE_ENV!=="production"?warning(false,"`value` prop on `%s` should not be null. "+"Consider using the empty string to clear the component or `undefined` "+"for uncontrolled components.%s",element.type,ReactComponentTreeHook.getStackAddendumByID(debugID)):void 0;didWarnValueNull=true}}var ReactDOMNullInputValuePropHook={onBeforeMountComponent:function(debugID,element){handleElement(debugID,element)},onBeforeUpdateComponent:function(debugID,element){handleElement(debugID,element)}};module.exports=ReactDOMNullInputValuePropHook}).call(this,require("_process"))},{_process:184,"fbjs/lib/warning":25,"react/lib/ReactComponentTreeHook":163}],72:[function(require,module,exports){(function(process){"use strict";var _assign=require("object-assign");var React=require("react/lib/React");var ReactDOMComponentTree=require("./ReactDOMComponentTree");var ReactDOMSelect=require("./ReactDOMSelect");var warning=require("fbjs/lib/warning");var didWarnInvalidOptionChildren=false;function flattenChildren(children){var content="";React.Children.forEach(children,function(child){if(child==null){return}if(typeof child==="string"||typeof child==="number"){content+=child}else if(!didWarnInvalidOptionChildren){didWarnInvalidOptionChildren=true;process.env.NODE_ENV!=="production"?warning(false,"Only strings and numbers are supported as <option> children."):void 0}});return content}var ReactDOMOption={mountWrapper:function(inst,props,hostParent){if(process.env.NODE_ENV!=="production"){process.env.NODE_ENV!=="production"?warning(props.selected==null,"Use the `defaultValue` or `value` props on <select> instead of "+"setting `selected` on <option>."):void 0}var selectValue=null;if(hostParent!=null){var selectParent=hostParent;if(selectParent._tag==="optgroup"){selectParent=selectParent._hostParent}if(selectParent!=null&&selectParent._tag==="select"){selectValue=ReactDOMSelect.getSelectValueContext(selectParent)}}var selected=null;if(selectValue!=null){var value;if(props.value!=null){value=props.value+""}else{value=flattenChildren(props.children)}selected=false;if(Array.isArray(selectValue)){for(var i=0;i<selectValue.length;i++){if(""+selectValue[i]===value){selected=true;break}}}else{selected=""+selectValue===value}}inst._wrapperState={selected:selected}},postMountWrapper:function(inst){var props=inst._currentElement.props;if(props.value!=null){var node=ReactDOMComponentTree.getNodeFromInstance(inst);node.setAttribute("value",props.value)}},getHostProps:function(inst,props){var hostProps=_assign({selected:undefined,children:undefined},props);if(inst._wrapperState.selected!=null){hostProps.selected=inst._wrapperState.selected}var content=flattenChildren(props.children);if(content){hostProps.children=content}return hostProps}};module.exports=ReactDOMOption}).call(this,require("_process"))},{"./ReactDOMComponentTree":64,"./ReactDOMSelect":73,_process:184,"fbjs/lib/warning":25,"object-assign":26,"react/lib/React":160}],73:[function(require,module,exports){(function(process){"use strict";var _assign=require("object-assign");var LinkedValueUtils=require("./LinkedValueUtils");var ReactDOMComponentTree=require("./ReactDOMComponentTree");var ReactUpdates=require("./ReactUpdates");var warning=require("fbjs/lib/warning");var didWarnValueLink=false;var didWarnValueDefaultValue=false;function updateOptionsIfPendingUpdateAndMounted(){if(this._rootNodeID&&this._wrapperState.pendingUpdate){this._wrapperState.pendingUpdate=false;var props=this._currentElement.props;var value=LinkedValueUtils.getValue(props);if(value!=null){updateOptions(this,Boolean(props.multiple),value)}}}function getDeclarationErrorAddendum(owner){if(owner){var name=owner.getName();if(name){return" Check the render method of `"+name+"`."}}return""}var valuePropNames=["value","defaultValue"];function checkSelectPropTypes(inst,props){var owner=inst._currentElement._owner;LinkedValueUtils.checkPropTypes("select",props,owner);if(props.valueLink!==undefined&&!didWarnValueLink){process.env.NODE_ENV!=="production"?warning(false,"`valueLink` prop on `select` is deprecated; set `value` and `onChange` instead."):void 0;didWarnValueLink=true}for(var i=0;i<valuePropNames.length;i++){var propName=valuePropNames[i];if(props[propName]==null){continue}var isArray=Array.isArray(props[propName]);if(props.multiple&&!isArray){process.env.NODE_ENV!=="production"?warning(false,"The `%s` prop supplied to <select> must be an array if "+"`multiple` is true.%s",propName,getDeclarationErrorAddendum(owner)):void 0}else if(!props.multiple&&isArray){process.env.NODE_ENV!=="production"?warning(false,"The `%s` prop supplied to <select> must be a scalar "+"value if `multiple` is false.%s",propName,getDeclarationErrorAddendum(owner)):void 0}}}function updateOptions(inst,multiple,propValue){var selectedValue,i;var options=ReactDOMComponentTree.getNodeFromInstance(inst).options;if(multiple){selectedValue={};for(i=0;i<propValue.length;i++){selectedValue[""+propValue[i]]=true}for(i=0;i<options.length;i++){var selected=selectedValue.hasOwnProperty(options[i].value);if(options[i].selected!==selected){options[i].selected=selected}}}else{selectedValue=""+propValue;for(i=0;i<options.length;i++){if(options[i].value===selectedValue){options[i].selected=true;return}}if(options.length){options[0].selected=true}}}var ReactDOMSelect={getHostProps:function(inst,props){return _assign({},props,{onChange:inst._wrapperState.onChange,value:undefined})},mountWrapper:function(inst,props){if(process.env.NODE_ENV!=="production"){checkSelectPropTypes(inst,props)}var value=LinkedValueUtils.getValue(props);inst._wrapperState={pendingUpdate:false,initialValue:value!=null?value:props.defaultValue,listeners:null,onChange:_handleChange.bind(inst),wasMultiple:Boolean(props.multiple)};if(props.value!==undefined&&props.defaultValue!==undefined&&!didWarnValueDefaultValue){process.env.NODE_ENV!=="production"?warning(false,"Select elements must be either controlled or uncontrolled "+"(specify either the value prop, or the defaultValue prop, but not "+"both). Decide between using a controlled or uncontrolled select "+"element and remove one of these props. More info: "+"https://fb.me/react-controlled-components"):void 0;didWarnValueDefaultValue=true}},getSelectValueContext:function(inst){return inst._wrapperState.initialValue},postUpdateWrapper:function(inst){var props=inst._currentElement.props;inst._wrapperState.initialValue=undefined;var wasMultiple=inst._wrapperState.wasMultiple;inst._wrapperState.wasMultiple=Boolean(props.multiple);var value=LinkedValueUtils.getValue(props);if(value!=null){inst._wrapperState.pendingUpdate=false;updateOptions(inst,Boolean(props.multiple),value)}else if(wasMultiple!==Boolean(props.multiple)){if(props.defaultValue!=null){updateOptions(inst,Boolean(props.multiple),props.defaultValue)}else{updateOptions(inst,Boolean(props.multiple),props.multiple?[]:"")}}}};function _handleChange(event){var props=this._currentElement.props;var returnValue=LinkedValueUtils.executeOnChange(props,event);if(this._rootNodeID){this._wrapperState.pendingUpdate=true}ReactUpdates.asap(updateOptionsIfPendingUpdateAndMounted,this);return returnValue}module.exports=ReactDOMSelect}).call(this,require("_process"))},{"./LinkedValueUtils":54,"./ReactDOMComponentTree":64,"./ReactUpdates":108,_process:184,"fbjs/lib/warning":25,"object-assign":26}],74:[function(require,module,exports){"use strict";var ExecutionEnvironment=require("fbjs/lib/ExecutionEnvironment");var getNodeForCharacterOffset=require("./getNodeForCharacterOffset");var getTextContentAccessor=require("./getTextContentAccessor");function isCollapsed(anchorNode,anchorOffset,focusNode,focusOffset){return anchorNode===focusNode&&anchorOffset===focusOffset}function getIEOffsets(node){var selection=document.selection;var selectedRange=selection.createRange();var selectedLength=selectedRange.text.length;var fromStart=selectedRange.duplicate();fromStart.moveToElementText(node);fromStart.setEndPoint("EndToStart",selectedRange);var startOffset=fromStart.text.length;var endOffset=startOffset+selectedLength;return{start:startOffset,end:endOffset}}function getModernOffsets(node){var selection=window.getSelection&&window.getSelection();if(!selection||selection.rangeCount===0){return null}var anchorNode=selection.anchorNode;var anchorOffset=selection.anchorOffset;var focusNode=selection.focusNode;var focusOffset=selection.focusOffset;var currentRange=selection.getRangeAt(0);try{currentRange.startContainer.nodeType;currentRange.endContainer.nodeType}catch(e){return null}var isSelectionCollapsed=isCollapsed(selection.anchorNode,selection.anchorOffset,selection.focusNode,selection.focusOffset);var rangeLength=isSelectionCollapsed?0:currentRange.toString().length;var tempRange=currentRange.cloneRange();tempRange.selectNodeContents(node);tempRange.setEnd(currentRange.startContainer,currentRange.startOffset);var isTempRangeCollapsed=isCollapsed(tempRange.startContainer,tempRange.startOffset,tempRange.endContainer,tempRange.endOffset);var start=isTempRangeCollapsed?0:tempRange.toString().length;var end=start+rangeLength;var detectionRange=document.createRange();detectionRange.setStart(anchorNode,anchorOffset);detectionRange.setEnd(focusNode,focusOffset);var isBackward=detectionRange.collapsed;return{start:isBackward?end:start,end:isBackward?start:end}}function setIEOffsets(node,offsets){var range=document.selection.createRange().duplicate();var start,end;if(offsets.end===undefined){start=offsets.start;end=start}else if(offsets.start>offsets.end){start=offsets.end;end=offsets.start}else{start=offsets.start;end=offsets.end}range.moveToElementText(node);range.moveStart("character",start);range.setEndPoint("EndToStart",range);range.moveEnd("character",end-start);range.select()}function setModernOffsets(node,offsets){if(!window.getSelection){return}var selection=window.getSelection();var length=node[getTextContentAccessor()].length;var start=Math.min(offsets.start,length);var end=offsets.end===undefined?start:Math.min(offsets.end,length);if(!selection.extend&&start>end){var temp=end;end=start;start=temp}var startMarker=getNodeForCharacterOffset(node,start);var endMarker=getNodeForCharacterOffset(node,end);if(startMarker&&endMarker){var range=document.createRange();range.setStart(startMarker.node,startMarker.offset);selection.removeAllRanges();if(start>end){selection.addRange(range);selection.extend(endMarker.node,endMarker.offset)}else{range.setEnd(endMarker.node,endMarker.offset);selection.addRange(range)}}}var useIEOffsets=ExecutionEnvironment.canUseDOM&&"selection"in document&&!("getSelection"in window);var ReactDOMSelection={getOffsets:useIEOffsets?getIEOffsets:getModernOffsets,setOffsets:useIEOffsets?setIEOffsets:setModernOffsets};module.exports=ReactDOMSelection},{"./getNodeForCharacterOffset":143,"./getTextContentAccessor":144,"fbjs/lib/ExecutionEnvironment":4}],75:[function(require,module,exports){(function(process){"use strict";var _prodInvariant=require("./reactProdInvariant"),_assign=require("object-assign");var DOMChildrenOperations=require("./DOMChildrenOperations");var DOMLazyTree=require("./DOMLazyTree");var ReactDOMComponentTree=require("./ReactDOMComponentTree");var escapeTextContentForBrowser=require("./escapeTextContentForBrowser");var invariant=require("fbjs/lib/invariant");var validateDOMNesting=require("./validateDOMNesting");var ReactDOMTextComponent=function(text){this._currentElement=text;this._stringText=""+text;this._hostNode=null;this._hostParent=null;this._domID=0;this._mountIndex=0;this._closingComment=null;this._commentNodes=null};_assign(ReactDOMTextComponent.prototype,{mountComponent:function(transaction,hostParent,hostContainerInfo,context){if(process.env.NODE_ENV!=="production"){var parentInfo;if(hostParent!=null){parentInfo=hostParent._ancestorInfo}else if(hostContainerInfo!=null){parentInfo=hostContainerInfo._ancestorInfo}if(parentInfo){validateDOMNesting(null,this._stringText,this,parentInfo)}}var domID=hostContainerInfo._idCounter++;var openingValue=" react-text: "+domID+" ";var closingValue=" /react-text ";this._domID=domID;this._hostParent=hostParent;if(transaction.useCreateElement){var ownerDocument=hostContainerInfo._ownerDocument;var openingComment=ownerDocument.createComment(openingValue);var closingComment=ownerDocument.createComment(closingValue);var lazyTree=DOMLazyTree(ownerDocument.createDocumentFragment());DOMLazyTree.queueChild(lazyTree,DOMLazyTree(openingComment));if(this._stringText){DOMLazyTree.queueChild(lazyTree,DOMLazyTree(ownerDocument.createTextNode(this._stringText)))}DOMLazyTree.queueChild(lazyTree,DOMLazyTree(closingComment));ReactDOMComponentTree.precacheNode(this,openingComment);this._closingComment=closingComment;return lazyTree}else{var escapedText=escapeTextContentForBrowser(this._stringText);if(transaction.renderToStaticMarkup){return escapedText}return"\x3c!--"+openingValue+"--\x3e"+escapedText+"\x3c!--"+closingValue+"--\x3e"}},receiveComponent:function(nextText,transaction){if(nextText!==this._currentElement){this._currentElement=nextText;var nextStringText=""+nextText;if(nextStringText!==this._stringText){this._stringText=nextStringText;var commentNodes=this.getHostNode();DOMChildrenOperations.replaceDelimitedText(commentNodes[0],commentNodes[1],nextStringText)}}},getHostNode:function(){var hostNode=this._commentNodes;if(hostNode){return hostNode}if(!this._closingComment){var openingComment=ReactDOMComponentTree.getNodeFromInstance(this);var node=openingComment.nextSibling;while(true){!(node!=null)?process.env.NODE_ENV!=="production"?invariant(false,"Missing closing comment for text component %s",this._domID):_prodInvariant("67",this._domID):void 0;if(node.nodeType===8&&node.nodeValue===" /react-text "){this._closingComment=node;break}node=node.nextSibling}}hostNode=[this._hostNode,this._closingComment];this._commentNodes=hostNode;return hostNode},unmountComponent:function(){this._closingComment=null;this._commentNodes=null;ReactDOMComponentTree.uncacheNode(this)}});module.exports=ReactDOMTextComponent}).call(this,require("_process"))},{"./DOMChildrenOperations":39,"./DOMLazyTree":40,"./ReactDOMComponentTree":64,"./escapeTextContentForBrowser":133,"./reactProdInvariant":151,"./validateDOMNesting":157,_process:184,"fbjs/lib/invariant":18,"object-assign":26}],76:[function(require,module,exports){(function(process){"use strict";var _prodInvariant=require("./reactProdInvariant"),_assign=require("object-assign");var LinkedValueUtils=require("./LinkedValueUtils");var ReactDOMComponentTree=require("./ReactDOMComponentTree");var ReactUpdates=require("./ReactUpdates");var invariant=require("fbjs/lib/invariant");var warning=require("fbjs/lib/warning");var didWarnValueLink=false;var didWarnValDefaultVal=false;function forceUpdateIfMounted(){if(this._rootNodeID){ReactDOMTextarea.updateWrapper(this)}}var ReactDOMTextarea={getHostProps:function(inst,props){!(props.dangerouslySetInnerHTML==null)?process.env.NODE_ENV!=="production"?invariant(false,"`dangerouslySetInnerHTML` does not make sense on <textarea>."):_prodInvariant("91"):void 0;var hostProps=_assign({},props,{value:undefined,defaultValue:undefined,children:""+inst._wrapperState.initialValue,onChange:inst._wrapperState.onChange});return hostProps},mountWrapper:function(inst,props){if(process.env.NODE_ENV!=="production"){LinkedValueUtils.checkPropTypes("textarea",props,inst._currentElement._owner);if(props.valueLink!==undefined&&!didWarnValueLink){process.env.NODE_ENV!=="production"?warning(false,"`valueLink` prop on `textarea` is deprecated; set `value` and `onChange` instead."):void 0;didWarnValueLink=true}if(props.value!==undefined&&props.defaultValue!==undefined&&!didWarnValDefaultVal){process.env.NODE_ENV!=="production"?warning(false,"Textarea elements must be either controlled or uncontrolled "+"(specify either the value prop, or the defaultValue prop, but not "+"both). Decide between using a controlled or uncontrolled textarea "+"and remove one of these props. More info: "+"https://fb.me/react-controlled-components"):void 0;didWarnValDefaultVal=true}}var value=LinkedValueUtils.getValue(props);var initialValue=value;if(value==null){var defaultValue=props.defaultValue;var children=props.children;if(children!=null){if(process.env.NODE_ENV!=="production"){process.env.NODE_ENV!=="production"?warning(false,"Use the `defaultValue` or `value` props instead of setting "+"children on <textarea>."):void 0}!(defaultValue==null)?process.env.NODE_ENV!=="production"?invariant(false,"If you supply `defaultValue` on a <textarea>, do not pass children."):_prodInvariant("92"):void 0;if(Array.isArray(children)){!(children.length<=1)?process.env.NODE_ENV!=="production"?invariant(false,"<textarea> can only have at most one child."):_prodInvariant("93"):void 0;children=children[0]}defaultValue=""+children}if(defaultValue==null){defaultValue=""}initialValue=defaultValue}inst._wrapperState={initialValue:""+initialValue,listeners:null,onChange:_handleChange.bind(inst)}},updateWrapper:function(inst){var props=inst._currentElement.props;var node=ReactDOMComponentTree.getNodeFromInstance(inst);var value=LinkedValueUtils.getValue(props);if(value!=null){var newValue=""+value;if(newValue!==node.value){node.value=newValue}if(props.defaultValue==null){node.defaultValue=newValue}}if(props.defaultValue!=null){node.defaultValue=props.defaultValue}},postMountWrapper:function(inst){var node=ReactDOMComponentTree.getNodeFromInstance(inst);var textContent=node.textContent;if(textContent===inst._wrapperState.initialValue){node.value=textContent}}};function _handleChange(event){var props=this._currentElement.props;var returnValue=LinkedValueUtils.executeOnChange(props,event);ReactUpdates.asap(forceUpdateIfMounted,this);return returnValue}module.exports=ReactDOMTextarea}).call(this,require("_process"))},{"./LinkedValueUtils":54,"./ReactDOMComponentTree":64,"./ReactUpdates":108,"./reactProdInvariant":151,_process:184,"fbjs/lib/invariant":18,"fbjs/lib/warning":25,"object-assign":26}],77:[function(require,module,exports){(function(process){"use strict";var _prodInvariant=require("./reactProdInvariant");var invariant=require("fbjs/lib/invariant");function getLowestCommonAncestor(instA,instB){!("_hostNode"in instA)?process.env.NODE_ENV!=="production"?invariant(false,"getNodeFromInstance: Invalid argument."):_prodInvariant("33"):void 0;!("_hostNode"in instB)?process.env.NODE_ENV!=="production"?invariant(false,"getNodeFromInstance: Invalid argument."):_prodInvariant("33"):void 0;var depthA=0;for(var tempA=instA;tempA;tempA=tempA._hostParent){depthA++}var depthB=0;for(var tempB=instB;tempB;tempB=tempB._hostParent){depthB++}while(depthA-depthB>0){instA=instA._hostParent;depthA--}while(depthB-depthA>0){instB=instB._hostParent;depthB--}var depth=depthA;while(depth--){if(instA===instB){return instA}instA=instA._hostParent;instB=instB._hostParent}return null}function isAncestor(instA,instB){!("_hostNode"in instA)?process.env.NODE_ENV!=="production"?invariant(false,"isAncestor: Invalid argument."):_prodInvariant("35"):void 0;!("_hostNode"in instB)?process.env.NODE_ENV!=="production"?invariant(false,"isAncestor: Invalid argument."):_prodInvariant("35"):void 0;while(instB){if(instB===instA){return true}instB=instB._hostParent}return false}function getParentInstance(inst){!("_hostNode"in inst)?process.env.NODE_ENV!=="production"?invariant(false,"getParentInstance: Invalid argument."):_prodInvariant("36"):void 0;return inst._hostParent}function traverseTwoPhase(inst,fn,arg){var path=[];while(inst){path.push(inst);inst=inst._hostParent}var i;for(i=path.length;i-- >0;){fn(path[i],"captured",arg)}for(i=0;i<path.length;i++){fn(path[i],"bubbled",arg)}}function traverseEnterLeave(from,to,fn,argFrom,argTo){var common=from&&to?getLowestCommonAncestor(from,to):null;var pathFrom=[];while(from&&from!==common){pathFrom.push(from);from=from._hostParent}var pathTo=[];while(to&&to!==common){pathTo.push(to);to=to._hostParent}var i;for(i=0;i<pathFrom.length;i++){fn(pathFrom[i],"bubbled",argFrom)}for(i=pathTo.length;i-- >0;){fn(pathTo[i],"captured",argTo)}}module.exports={isAncestor:isAncestor,getLowestCommonAncestor:getLowestCommonAncestor,getParentInstance:getParentInstance,traverseTwoPhase:traverseTwoPhase,traverseEnterLeave:traverseEnterLeave}}).call(this,require("_process"))},{"./reactProdInvariant":151,_process:184,"fbjs/lib/invariant":18}],78:[function(require,module,exports){(function(process){"use strict";var DOMProperty=require("./DOMProperty");var EventPluginRegistry=require("./EventPluginRegistry");var ReactComponentTreeHook=require("react/lib/ReactComponentTreeHook");var warning=require("fbjs/lib/warning");if(process.env.NODE_ENV!=="production"){var reactProps={children:true,dangerouslySetInnerHTML:true,key:true,ref:true,autoFocus:true,defaultValue:true,valueLink:true,defaultChecked:true,checkedLink:true,innerHTML:true,suppressContentEditableWarning:true,onFocusIn:true,onFocusOut:true};var warnedProperties={};var validateProperty=function(tagName,name,debugID){if(DOMProperty.properties.hasOwnProperty(name)||DOMProperty.isCustomAttribute(name)){return true}if(reactProps.hasOwnProperty(name)&&reactProps[name]||warnedProperties.hasOwnProperty(name)&&warnedProperties[name]){return true}if(EventPluginRegistry.registrationNameModules.hasOwnProperty(name)){return true}warnedProperties[name]=true;var lowerCasedName=name.toLowerCase();var standardName=DOMProperty.isCustomAttribute(lowerCasedName)?lowerCasedName:DOMProperty.getPossibleStandardName.hasOwnProperty(lowerCasedName)?DOMProperty.getPossibleStandardName[lowerCasedName]:null;var registrationName=EventPluginRegistry.possibleRegistrationNames.hasOwnProperty(lowerCasedName)?EventPluginRegistry.possibleRegistrationNames[lowerCasedName]:null;if(standardName!=null){process.env.NODE_ENV!=="production"?warning(false,"Unknown DOM property %s. Did you mean %s?%s",name,standardName,ReactComponentTreeHook.getStackAddendumByID(debugID)):void 0;return true}else if(registrationName!=null){process.env.NODE_ENV!=="production"?warning(false,"Unknown event handler property %s. Did you mean `%s`?%s",name,registrationName,ReactComponentTreeHook.getStackAddendumByID(debugID)):void 0;return true}else{return false}}}var warnUnknownProperties=function(debugID,element){var unknownProps=[];for(var key in element.props){var isValid=validateProperty(element.type,key,debugID);if(!isValid){unknownProps.push(key)}}var unknownPropString=unknownProps.map(function(prop){return"`"+prop+"`"}).join(", ");if(unknownProps.length===1){process.env.NODE_ENV!=="production"?warning(false,"Unknown prop %s on <%s> tag. Remove this prop from the element. "+"For details, see https://fb.me/react-unknown-prop%s",unknownPropString,element.type,ReactComponentTreeHook.getStackAddendumByID(debugID)):void 0}else if(unknownProps.length>1){process.env.NODE_ENV!=="production"?warning(false,"Unknown props %s on <%s> tag. Remove these props from the element. "+"For details, see https://fb.me/react-unknown-prop%s",unknownPropString,element.type,ReactComponentTreeHook.getStackAddendumByID(debugID)):void 0}};function handleElement(debugID,element){if(element==null||typeof element.type!=="string"){return}if(element.type.indexOf("-")>=0||element.props.is){return}warnUnknownProperties(debugID,element)}var ReactDOMUnknownPropertyHook={onBeforeMountComponent:function(debugID,element){handleElement(debugID,element)},onBeforeUpdateComponent:function(debugID,element){handleElement(debugID,element)}};module.exports=ReactDOMUnknownPropertyHook}).call(this,require("_process"))},{"./DOMProperty":42,"./EventPluginRegistry":48,_process:184,"fbjs/lib/warning":25,"react/lib/ReactComponentTreeHook":163}],79:[function(require,module,exports){(function(process){"use strict";var ReactInvalidSetStateWarningHook=require("./ReactInvalidSetStateWarningHook");var ReactHostOperationHistoryHook=require("./ReactHostOperationHistoryHook");var ReactComponentTreeHook=require("react/lib/ReactComponentTreeHook");var ExecutionEnvironment=require("fbjs/lib/ExecutionEnvironment");var performanceNow=require("fbjs/lib/performanceNow");var warning=require("fbjs/lib/warning");var hooks=[];var didHookThrowForEvent={};function callHook(event,fn,context,arg1,arg2,arg3,arg4,arg5){try{fn.call(context,arg1,arg2,arg3,arg4,arg5)}catch(e){process.env.NODE_ENV!=="production"?warning(didHookThrowForEvent[event],"Exception thrown by hook while handling %s: %s",event,e+"\n"+e.stack):void 0;didHookThrowForEvent[event]=true}}function emitEvent(event,arg1,arg2,arg3,arg4,arg5){for(var i=0;i<hooks.length;i++){var hook=hooks[i];var fn=hook[event];if(fn){callHook(event,fn,hook,arg1,arg2,arg3,arg4,arg5)}}}var isProfiling=false;var flushHistory=[];var lifeCycleTimerStack=[];var currentFlushNesting=0;var currentFlushMeasurements=[];var currentFlushStartTime=0;var currentTimerDebugID=null;var currentTimerStartTime=0;var currentTimerNestedFlushDuration=0;var currentTimerType=null;var lifeCycleTimerHasWarned=false;function clearHistory(){ReactComponentTreeHook.purgeUnmountedComponents();ReactHostOperationHistoryHook.clearHistory()}function getTreeSnapshot(registeredIDs){return registeredIDs.reduce(function(tree,id){var ownerID=ReactComponentTreeHook.getOwnerID(id);var parentID=ReactComponentTreeHook.getParentID(id);tree[id]={displayName:ReactComponentTreeHook.getDisplayName(id),text:ReactComponentTreeHook.getText(id),updateCount:ReactComponentTreeHook.getUpdateCount(id),childIDs:ReactComponentTreeHook.getChildIDs(id),ownerID:ownerID||parentID&&ReactComponentTreeHook.getOwnerID(parentID)||0,parentID:parentID};return tree},{})}function resetMeasurements(){var previousStartTime=currentFlushStartTime;var previousMeasurements=currentFlushMeasurements;var previousOperations=ReactHostOperationHistoryHook.getHistory();if(currentFlushNesting===0){currentFlushStartTime=0;currentFlushMeasurements=[];clearHistory();return}if(previousMeasurements.length||previousOperations.length){var registeredIDs=ReactComponentTreeHook.getRegisteredIDs();flushHistory.push({duration:performanceNow()-previousStartTime,measurements:previousMeasurements||[],operations:previousOperations||[],treeSnapshot:getTreeSnapshot(registeredIDs)})}clearHistory();currentFlushStartTime=performanceNow();currentFlushMeasurements=[]}function checkDebugID(debugID){var allowRoot=arguments.length>1&&arguments[1]!==undefined?arguments[1]:false;if(allowRoot&&debugID===0){return}if(!debugID){process.env.NODE_ENV!=="production"?warning(false,"ReactDebugTool: debugID may not be empty."):void 0}}function beginLifeCycleTimer(debugID,timerType){if(currentFlushNesting===0){return}if(currentTimerType&&!lifeCycleTimerHasWarned){process.env.NODE_ENV!=="production"?warning(false,"There is an internal error in the React performance measurement code. "+"Did not expect %s timer to start while %s timer is still in "+"progress for %s instance.",timerType,currentTimerType||"no",debugID===currentTimerDebugID?"the same":"another"):void 0;lifeCycleTimerHasWarned=true}currentTimerStartTime=performanceNow();currentTimerNestedFlushDuration=0;currentTimerDebugID=debugID;currentTimerType=timerType}function endLifeCycleTimer(debugID,timerType){if(currentFlushNesting===0){return}if(currentTimerType!==timerType&&!lifeCycleTimerHasWarned){process.env.NODE_ENV!=="production"?warning(false,"There is an internal error in the React performance measurement code. "+"We did not expect %s timer to stop while %s timer is still in "+"progress for %s instance. Please report this as a bug in React.",timerType,currentTimerType||"no",debugID===currentTimerDebugID?"the same":"another"):void 0;lifeCycleTimerHasWarned=true}if(isProfiling){currentFlushMeasurements.push({timerType:timerType,instanceID:debugID,duration:performanceNow()-currentTimerStartTime-currentTimerNestedFlushDuration})}currentTimerStartTime=0;currentTimerNestedFlushDuration=0;currentTimerDebugID=null;currentTimerType=null}function pauseCurrentLifeCycleTimer(){var currentTimer={startTime:currentTimerStartTime,nestedFlushStartTime:performanceNow(),debugID:currentTimerDebugID,timerType:currentTimerType};lifeCycleTimerStack.push(currentTimer);currentTimerStartTime=0;currentTimerNestedFlushDuration=0;currentTimerDebugID=null;currentTimerType=null}function resumeCurrentLifeCycleTimer(){var _lifeCycleTimerStack$=lifeCycleTimerStack.pop(),startTime=_lifeCycleTimerStack$.startTime,nestedFlushStartTime=_lifeCycleTimerStack$.nestedFlushStartTime,debugID=_lifeCycleTimerStack$.debugID,timerType=_lifeCycleTimerStack$.timerType;var nestedFlushDuration=performanceNow()-nestedFlushStartTime;currentTimerStartTime=startTime;currentTimerNestedFlushDuration+=nestedFlushDuration;currentTimerDebugID=debugID;currentTimerType=timerType}var lastMarkTimeStamp=0;var canUsePerformanceMeasure=typeof performance!=="undefined"&&typeof performance.mark==="function"&&typeof performance.clearMarks==="function"&&typeof performance.measure==="function"&&typeof performance.clearMeasures==="function";function shouldMark(debugID){if(!isProfiling||!canUsePerformanceMeasure){return false}var element=ReactComponentTreeHook.getElement(debugID);if(element==null||typeof element!=="object"){return false}var isHostElement=typeof element.type==="string";if(isHostElement){return false}return true}function markBegin(debugID,markType){if(!shouldMark(debugID)){return}var markName=debugID+"::"+markType;lastMarkTimeStamp=performanceNow();performance.mark(markName)}function markEnd(debugID,markType){if(!shouldMark(debugID)){return}var markName=debugID+"::"+markType;var displayName=ReactComponentTreeHook.getDisplayName(debugID)||"Unknown";var timeStamp=performanceNow();if(timeStamp-lastMarkTimeStamp>.1){var measurementName=displayName+" ["+markType+"]";performance.measure(measurementName,markName)}performance.clearMarks(markName);if(measurementName){performance.clearMeasures(measurementName)}}var ReactDebugTool={addHook:function(hook){hooks.push(hook)},removeHook:function(hook){for(var i=0;i<hooks.length;i++){if(hooks[i]===hook){hooks.splice(i,1);i--}}},isProfiling:function(){return isProfiling},beginProfiling:function(){if(isProfiling){return}isProfiling=true;flushHistory.length=0;resetMeasurements();ReactDebugTool.addHook(ReactHostOperationHistoryHook)},endProfiling:function(){if(!isProfiling){return}isProfiling=false;resetMeasurements();ReactDebugTool.removeHook(ReactHostOperationHistoryHook)},getFlushHistory:function(){return flushHistory},onBeginFlush:function(){currentFlushNesting++;resetMeasurements();pauseCurrentLifeCycleTimer();emitEvent("onBeginFlush")},onEndFlush:function(){resetMeasurements();currentFlushNesting--;resumeCurrentLifeCycleTimer();emitEvent("onEndFlush")},onBeginLifeCycleTimer:function(debugID,timerType){checkDebugID(debugID);emitEvent("onBeginLifeCycleTimer",debugID,timerType);markBegin(debugID,timerType);beginLifeCycleTimer(debugID,timerType)},onEndLifeCycleTimer:function(debugID,timerType){checkDebugID(debugID);endLifeCycleTimer(debugID,timerType);markEnd(debugID,timerType);emitEvent("onEndLifeCycleTimer",debugID,timerType)},onBeginProcessingChildContext:function(){emitEvent("onBeginProcessingChildContext")},onEndProcessingChildContext:function(){emitEvent("onEndProcessingChildContext")},onHostOperation:function(operation){checkDebugID(operation.instanceID);emitEvent("onHostOperation",operation)},onSetState:function(){emitEvent("onSetState")},onSetChildren:function(debugID,childDebugIDs){checkDebugID(debugID);childDebugIDs.forEach(checkDebugID);emitEvent("onSetChildren",debugID,childDebugIDs)},onBeforeMountComponent:function(debugID,element,parentDebugID){checkDebugID(debugID);checkDebugID(parentDebugID,true);emitEvent("onBeforeMountComponent",debugID,element,parentDebugID);markBegin(debugID,"mount")},onMountComponent:function(debugID){checkDebugID(debugID);markEnd(debugID,"mount");emitEvent("onMountComponent",debugID)},onBeforeUpdateComponent:function(debugID,element){checkDebugID(debugID);emitEvent("onBeforeUpdateComponent",debugID,element);markBegin(debugID,"update")},onUpdateComponent:function(debugID){checkDebugID(debugID);markEnd(debugID,"update");emitEvent("onUpdateComponent",debugID)},onBeforeUnmountComponent:function(debugID){checkDebugID(debugID);emitEvent("onBeforeUnmountComponent",debugID);markBegin(debugID,"unmount")},onUnmountComponent:function(debugID){checkDebugID(debugID);markEnd(debugID,"unmount");emitEvent("onUnmountComponent",debugID)},onTestEvent:function(){emitEvent("onTestEvent")}};ReactDebugTool.addDevtool=ReactDebugTool.addHook;ReactDebugTool.removeDevtool=ReactDebugTool.removeHook;ReactDebugTool.addHook(ReactInvalidSetStateWarningHook);ReactDebugTool.addHook(ReactComponentTreeHook);var url=ExecutionEnvironment.canUseDOM&&window.location.href||"";if(/[?&]react_perf\b/.test(url)){ReactDebugTool.beginProfiling()}module.exports=ReactDebugTool}).call(this,require("_process"))},{"./ReactHostOperationHistoryHook":89,"./ReactInvalidSetStateWarningHook":94,_process:184,"fbjs/lib/ExecutionEnvironment":4,"fbjs/lib/performanceNow":23,"fbjs/lib/warning":25,"react/lib/ReactComponentTreeHook":163}],80:[function(require,module,exports){"use strict";var _assign=require("object-assign");var ReactUpdates=require("./ReactUpdates");var Transaction=require("./Transaction");var emptyFunction=require("fbjs/lib/emptyFunction");var RESET_BATCHED_UPDATES={initialize:emptyFunction,close:function(){ReactDefaultBatchingStrategy.isBatchingUpdates=false}};var FLUSH_BATCHED_UPDATES={initialize:emptyFunction,close:ReactUpdates.flushBatchedUpdates.bind(ReactUpdates)};var TRANSACTION_WRAPPERS=[FLUSH_BATCHED_UPDATES,RESET_BATCHED_UPDATES];function ReactDefaultBatchingStrategyTransaction(){this.reinitializeTransaction()}_assign(ReactDefaultBatchingStrategyTransaction.prototype,Transaction,{getTransactionWrappers:function(){return TRANSACTION_WRAPPERS}});var transaction=new ReactDefaultBatchingStrategyTransaction;var ReactDefaultBatchingStrategy={isBatchingUpdates:false,batchedUpdates:function(callback,a,b,c,d,e){var alreadyBatchingUpdates=ReactDefaultBatchingStrategy.isBatchingUpdates;ReactDefaultBatchingStrategy.isBatchingUpdates=true;if(alreadyBatchingUpdates){return callback(a,b,c,d,e)}else{return transaction.perform(callback,null,a,b,c,d,e)}}};module.exports=ReactDefaultBatchingStrategy},{"./ReactUpdates":108,"./Transaction":126,"fbjs/lib/emptyFunction":10,"object-assign":26}],81:[function(require,module,exports){"use strict";var ARIADOMPropertyConfig=require("./ARIADOMPropertyConfig");var BeforeInputEventPlugin=require("./BeforeInputEventPlugin");var ChangeEventPlugin=require("./ChangeEventPlugin");var DefaultEventPluginOrder=require("./DefaultEventPluginOrder");var EnterLeaveEventPlugin=require("./EnterLeaveEventPlugin");var HTMLDOMPropertyConfig=require("./HTMLDOMPropertyConfig");var ReactComponentBrowserEnvironment=require("./ReactComponentBrowserEnvironment");var ReactDOMComponent=require("./ReactDOMComponent");var ReactDOMComponentTree=require("./ReactDOMComponentTree");var ReactDOMEmptyComponent=require("./ReactDOMEmptyComponent");var ReactDOMTreeTraversal=require("./ReactDOMTreeTraversal");var ReactDOMTextComponent=require("./ReactDOMTextComponent");var ReactDefaultBatchingStrategy=require("./ReactDefaultBatchingStrategy");var ReactEventListener=require("./ReactEventListener");var ReactInjection=require("./ReactInjection");var ReactReconcileTransaction=require("./ReactReconcileTransaction");var SVGDOMPropertyConfig=require("./SVGDOMPropertyConfig");var SelectEventPlugin=require("./SelectEventPlugin");var SimpleEventPlugin=require("./SimpleEventPlugin");var alreadyInjected=false;function inject(){if(alreadyInjected){return}alreadyInjected=true;ReactInjection.EventEmitter.injectReactEventListener(ReactEventListener);ReactInjection.EventPluginHub.injectEventPluginOrder(DefaultEventPluginOrder);ReactInjection.EventPluginUtils.injectComponentTree(ReactDOMComponentTree);ReactInjection.EventPluginUtils.injectTreeTraversal(ReactDOMTreeTraversal);ReactInjection.EventPluginHub.injectEventPluginsByName({SimpleEventPlugin:SimpleEventPlugin,EnterLeaveEventPlugin:EnterLeaveEventPlugin,ChangeEventPlugin:ChangeEventPlugin,SelectEventPlugin:SelectEventPlugin,BeforeInputEventPlugin:BeforeInputEventPlugin});ReactInjection.HostComponent.injectGenericComponentClass(ReactDOMComponent);ReactInjection.HostComponent.injectTextComponentClass(ReactDOMTextComponent);ReactInjection.DOMProperty.injectDOMPropertyConfig(ARIADOMPropertyConfig);ReactInjection.DOMProperty.injectDOMPropertyConfig(HTMLDOMPropertyConfig);ReactInjection.DOMProperty.injectDOMPropertyConfig(SVGDOMPropertyConfig);ReactInjection.EmptyComponent.injectEmptyComponentFactory(function(instantiate){return new ReactDOMEmptyComponent(instantiate)});ReactInjection.Updates.injectReconcileTransaction(ReactReconcileTransaction);ReactInjection.Updates.injectBatchingStrategy(ReactDefaultBatchingStrategy);ReactInjection.Component.injectEnvironment(ReactComponentBrowserEnvironment)}module.exports={inject:inject}},{"./ARIADOMPropertyConfig":32,"./BeforeInputEventPlugin":34,"./ChangeEventPlugin":38,"./DefaultEventPluginOrder":45,"./EnterLeaveEventPlugin":46,"./HTMLDOMPropertyConfig":52,"./ReactComponentBrowserEnvironment":58,"./ReactDOMComponent":62,"./ReactDOMComponentTree":64,"./ReactDOMEmptyComponent":66,"./ReactDOMTextComponent":75,"./ReactDOMTreeTraversal":77,"./ReactDefaultBatchingStrategy":80,"./ReactEventListener":86,"./ReactInjection":90,"./ReactReconcileTransaction":102,"./SVGDOMPropertyConfig":110,"./SelectEventPlugin":111,"./SimpleEventPlugin":112}],82:[function(require,module,exports){"use strict";var REACT_ELEMENT_TYPE=typeof Symbol==="function"&&Symbol["for"]&&Symbol["for"]("react.element")||60103;module.exports=REACT_ELEMENT_TYPE},{}],83:[function(require,module,exports){"use strict";var emptyComponentFactory;var ReactEmptyComponentInjection={injectEmptyComponentFactory:function(factory){emptyComponentFactory=factory}};var ReactEmptyComponent={create:function(instantiate){return emptyComponentFactory(instantiate)}};ReactEmptyComponent.injection=ReactEmptyComponentInjection;module.exports=ReactEmptyComponent},{}],84:[function(require,module,exports){(function(process){"use strict";var caughtError=null;function invokeGuardedCallback(name,func,a){try{func(a)}catch(x){if(caughtError===null){caughtError=x}}}var ReactErrorUtils={invokeGuardedCallback:invokeGuardedCallback,invokeGuardedCallbackWithCatch:invokeGuardedCallback,rethrowCaughtError:function(){if(caughtError){var error=caughtError;caughtError=null;throw error}}};if(process.env.NODE_ENV!=="production"){if(typeof window!=="undefined"&&typeof window.dispatchEvent==="function"&&typeof document!=="undefined"&&typeof document.createEvent==="function"){var fakeNode=document.createElement("react");ReactErrorUtils.invokeGuardedCallback=function(name,func,a){var boundFunc=func.bind(null,a);var evtType="react-"+name;fakeNode.addEventListener(evtType,boundFunc,false);var evt=document.createEvent("Event");evt.initEvent(evtType,false,false);fakeNode.dispatchEvent(evt);fakeNode.removeEventListener(evtType,boundFunc,false)}}}module.exports=ReactErrorUtils}).call(this,require("_process"))},{_process:184}],85:[function(require,module,exports){"use strict";var EventPluginHub=require("./EventPluginHub");function runEventQueueInBatch(events){EventPluginHub.enqueueEvents(events);EventPluginHub.processEventQueue(false)}var ReactEventEmitterMixin={handleTopLevel:function(topLevelType,targetInst,nativeEvent,nativeEventTarget){var events=EventPluginHub.extractEvents(topLevelType,targetInst,nativeEvent,nativeEventTarget);runEventQueueInBatch(events)}};module.exports=ReactEventEmitterMixin},{"./EventPluginHub":47}],86:[function(require,module,exports){"use strict";var _assign=require("object-assign");var EventListener=require("fbjs/lib/EventListener");var ExecutionEnvironment=require("fbjs/lib/ExecutionEnvironment");var PooledClass=require("./PooledClass");var ReactDOMComponentTree=require("./ReactDOMComponentTree");var ReactUpdates=require("./ReactUpdates");var getEventTarget=require("./getEventTarget");var getUnboundedScrollPosition=require("fbjs/lib/getUnboundedScrollPosition");function findParent(inst){while(inst._hostParent){inst=inst._hostParent}var rootNode=ReactDOMComponentTree.getNodeFromInstance(inst);var container=rootNode.parentNode;return ReactDOMComponentTree.getClosestInstanceFromNode(container)}function TopLevelCallbackBookKeeping(topLevelType,nativeEvent){this.topLevelType=topLevelType;this.nativeEvent=nativeEvent;this.ancestors=[]}_assign(TopLevelCallbackBookKeeping.prototype,{destructor:function(){this.topLevelType=null;this.nativeEvent=null;this.ancestors.length=0}});PooledClass.addPoolingTo(TopLevelCallbackBookKeeping,PooledClass.twoArgumentPooler);function handleTopLevelImpl(bookKeeping){var nativeEventTarget=getEventTarget(bookKeeping.nativeEvent);var targetInst=ReactDOMComponentTree.getClosestInstanceFromNode(nativeEventTarget);var ancestor=targetInst;do{bookKeeping.ancestors.push(ancestor);ancestor=ancestor&&findParent(ancestor)}while(ancestor);for(var i=0;i<bookKeeping.ancestors.length;i++){targetInst=bookKeeping.ancestors[i];ReactEventListener._handleTopLevel(bookKeeping.topLevelType,targetInst,bookKeeping.nativeEvent,getEventTarget(bookKeeping.nativeEvent))}}function scrollValueMonitor(cb){var scrollPosition=getUnboundedScrollPosition(window);cb(scrollPosition)}var ReactEventListener={_enabled:true,_handleTopLevel:null,WINDOW_HANDLE:ExecutionEnvironment.canUseDOM?window:null,setHandleTopLevel:function(handleTopLevel){ReactEventListener._handleTopLevel=handleTopLevel},setEnabled:function(enabled){ReactEventListener._enabled=!!enabled},isEnabled:function(){return ReactEventListener._enabled},trapBubbledEvent:function(topLevelType,handlerBaseName,element){if(!element){return null}return EventListener.listen(element,handlerBaseName,ReactEventListener.dispatchEvent.bind(null,topLevelType))},trapCapturedEvent:function(topLevelType,handlerBaseName,element){if(!element){return null}return EventListener.capture(element,handlerBaseName,ReactEventListener.dispatchEvent.bind(null,topLevelType))},monitorScrollValue:function(refresh){var callback=scrollValueMonitor.bind(null,refresh);EventListener.listen(window,"scroll",callback)},dispatchEvent:function(topLevelType,nativeEvent){if(!ReactEventListener._enabled){return}var bookKeeping=TopLevelCallbackBookKeeping.getPooled(topLevelType,nativeEvent);try{ReactUpdates.batchedUpdates(handleTopLevelImpl,bookKeeping)}finally{TopLevelCallbackBookKeeping.release(bookKeeping)}}};module.exports=ReactEventListener},{"./PooledClass":55,"./ReactDOMComponentTree":64,"./ReactUpdates":108,"./getEventTarget":140,"fbjs/lib/EventListener":3,"fbjs/lib/ExecutionEnvironment":4,"fbjs/lib/getUnboundedScrollPosition":15,"object-assign":26}],87:[function(require,module,exports){"use strict";var ReactFeatureFlags={logTopLevelRenders:false};module.exports=ReactFeatureFlags},{}],88:[function(require,module,exports){(function(process){"use strict";var _prodInvariant=require("./reactProdInvariant");var invariant=require("fbjs/lib/invariant");var genericComponentClass=null;var textComponentClass=null;var ReactHostComponentInjection={injectGenericComponentClass:function(componentClass){genericComponentClass=componentClass},injectTextComponentClass:function(componentClass){textComponentClass=componentClass}};function createInternalComponent(element){!genericComponentClass?process.env.NODE_ENV!=="production"?invariant(false,"There is no registered component for the tag %s",element.type):_prodInvariant("111",element.type):void 0;return new genericComponentClass(element)}function createInstanceForText(text){return new textComponentClass(text)}function isTextComponent(component){return component instanceof textComponentClass}var ReactHostComponent={createInternalComponent:createInternalComponent,createInstanceForText:createInstanceForText,isTextComponent:isTextComponent,injection:ReactHostComponentInjection};module.exports=ReactHostComponent}).call(this,require("_process"))},{"./reactProdInvariant":151,_process:184,"fbjs/lib/invariant":18}],89:[function(require,module,exports){"use strict";var history=[];var ReactHostOperationHistoryHook={onHostOperation:function(operation){history.push(operation)},clearHistory:function(){if(ReactHostOperationHistoryHook._preventClearing){return}history=[]},getHistory:function(){return history}};module.exports=ReactHostOperationHistoryHook},{}],90:[function(require,module,exports){"use strict";var DOMProperty=require("./DOMProperty");var EventPluginHub=require("./EventPluginHub");var EventPluginUtils=require("./EventPluginUtils");var ReactComponentEnvironment=require("./ReactComponentEnvironment");var ReactEmptyComponent=require("./ReactEmptyComponent");var ReactBrowserEventEmitter=require("./ReactBrowserEventEmitter");var ReactHostComponent=require("./ReactHostComponent");var ReactUpdates=require("./ReactUpdates");var ReactInjection={Component:ReactComponentEnvironment.injection,DOMProperty:DOMProperty.injection,EmptyComponent:ReactEmptyComponent.injection,EventPluginHub:EventPluginHub.injection,EventPluginUtils:EventPluginUtils.injection,EventEmitter:ReactBrowserEventEmitter.injection,HostComponent:ReactHostComponent.injection,Updates:ReactUpdates.injection};module.exports=ReactInjection},{"./DOMProperty":42,"./EventPluginHub":47,"./EventPluginUtils":49,"./ReactBrowserEventEmitter":56,"./ReactComponentEnvironment":59,"./ReactEmptyComponent":83,"./ReactHostComponent":88,"./ReactUpdates":108}],91:[function(require,module,exports){"use strict";var ReactDOMSelection=require("./ReactDOMSelection");var containsNode=require("fbjs/lib/containsNode");var focusNode=require("fbjs/lib/focusNode");var getActiveElement=require("fbjs/lib/getActiveElement");function isInDocument(node){return containsNode(document.documentElement,node)}var ReactInputSelection={hasSelectionCapabilities:function(elem){var nodeName=elem&&elem.nodeName&&elem.nodeName.toLowerCase();return nodeName&&(nodeName==="input"&&elem.type==="text"||nodeName==="textarea"||elem.contentEditable==="true")},getSelectionInformation:function(){var focusedElem=getActiveElement();return{focusedElem:focusedElem,selectionRange:ReactInputSelection.hasSelectionCapabilities(focusedElem)?ReactInputSelection.getSelection(focusedElem):null}},restoreSelection:function(priorSelectionInformation){var curFocusedElem=getActiveElement();var priorFocusedElem=priorSelectionInformation.focusedElem;var priorSelectionRange=priorSelectionInformation.selectionRange;if(curFocusedElem!==priorFocusedElem&&isInDocument(priorFocusedElem)){if(ReactInputSelection.hasSelectionCapabilities(priorFocusedElem)){ReactInputSelection.setSelection(priorFocusedElem,priorSelectionRange)}focusNode(priorFocusedElem)}},getSelection:function(input){var selection;if("selectionStart"in input){selection={start:input.selectionStart,end:input.selectionEnd}}else if(document.selection&&input.nodeName&&input.nodeName.toLowerCase()==="input"){var range=document.selection.createRange();if(range.parentElement()===input){selection={start:-range.moveStart("character",-input.value.length),end:-range.moveEnd("character",-input.value.length)}}}else{selection=ReactDOMSelection.getOffsets(input)}return selection||{start:0,end:0}},setSelection:function(input,offsets){var start=offsets.start;var end=offsets.end;if(end===undefined){end=start}if("selectionStart"in input){input.selectionStart=start;input.selectionEnd=Math.min(end,input.value.length)}else if(document.selection&&input.nodeName&&input.nodeName.toLowerCase()==="input"){var range=input.createTextRange();range.collapse(true);range.moveStart("character",start);range.moveEnd("character",end-start);range.select()}else{ReactDOMSelection.setOffsets(input,offsets)}}};module.exports=ReactInputSelection},{"./ReactDOMSelection":74,"fbjs/lib/containsNode":7,"fbjs/lib/focusNode":12,"fbjs/lib/getActiveElement":13}],92:[function(require,module,exports){"use strict";var ReactInstanceMap={remove:function(key){key._reactInternalInstance=undefined},get:function(key){return key._reactInternalInstance},has:function(key){return key._reactInternalInstance!==undefined},set:function(key,value){key._reactInternalInstance=value}};module.exports=ReactInstanceMap},{}],93:[function(require,module,exports){(function(process){"use strict";var debugTool=null;if(process.env.NODE_ENV!=="production"){var ReactDebugTool=require("./ReactDebugTool");debugTool=ReactDebugTool}module.exports={debugTool:debugTool}}).call(this,require("_process"))},{"./ReactDebugTool":79,_process:184}],94:[function(require,module,exports){(function(process){"use strict";var warning=require("fbjs/lib/warning");if(process.env.NODE_ENV!=="production"){var processingChildContext=false;var warnInvalidSetState=function(){process.env.NODE_ENV!=="production"?warning(!processingChildContext,"setState(...): Cannot call setState() inside getChildContext()"):void 0}}var ReactInvalidSetStateWarningHook={onBeginProcessingChildContext:function(){processingChildContext=true},onEndProcessingChildContext:function(){processingChildContext=false},onSetState:function(){warnInvalidSetState()}};module.exports=ReactInvalidSetStateWarningHook}).call(this,require("_process"))},{_process:184,"fbjs/lib/warning":25}],95:[function(require,module,exports){"use strict";var adler32=require("./adler32");var TAG_END=/\/?>/;var COMMENT_START=/^<\!\-\-/;var ReactMarkupChecksum={CHECKSUM_ATTR_NAME:"data-react-checksum",addChecksumToMarkup:function(markup){var checksum=adler32(markup);if(COMMENT_START.test(markup)){return markup}else{return markup.replace(TAG_END," "+ReactMarkupChecksum.CHECKSUM_ATTR_NAME+'="'+checksum+'"$&')}},canReuseMarkup:function(markup,element){var existingChecksum=element.getAttribute(ReactMarkupChecksum.CHECKSUM_ATTR_NAME);existingChecksum=existingChecksum&&parseInt(existingChecksum,10);var markupChecksum=adler32(markup);return markupChecksum===existingChecksum}};module.exports=ReactMarkupChecksum},{"./adler32":129}],96:[function(require,module,exports){(function(process){"use strict";var _prodInvariant=require("./reactProdInvariant");var DOMLazyTree=require("./DOMLazyTree");var DOMProperty=require("./DOMProperty");var React=require("react/lib/React");var ReactBrowserEventEmitter=require("./ReactBrowserEventEmitter");var ReactCurrentOwner=require("react/lib/ReactCurrentOwner");var ReactDOMComponentTree=require("./ReactDOMComponentTree");var ReactDOMContainerInfo=require("./ReactDOMContainerInfo");var ReactDOMFeatureFlags=require("./ReactDOMFeatureFlags");var ReactFeatureFlags=require("./ReactFeatureFlags");var ReactInstanceMap=require("./ReactInstanceMap");var ReactInstrumentation=require("./ReactInstrumentation");var ReactMarkupChecksum=require("./ReactMarkupChecksum");var ReactReconciler=require("./ReactReconciler");var ReactUpdateQueue=require("./ReactUpdateQueue");var ReactUpdates=require("./ReactUpdates");var emptyObject=require("fbjs/lib/emptyObject");var instantiateReactComponent=require("./instantiateReactComponent");var invariant=require("fbjs/lib/invariant");var setInnerHTML=require("./setInnerHTML");var shouldUpdateReactComponent=require("./shouldUpdateReactComponent");var warning=require("fbjs/lib/warning");var ATTR_NAME=DOMProperty.ID_ATTRIBUTE_NAME;var ROOT_ATTR_NAME=DOMProperty.ROOT_ATTRIBUTE_NAME;var ELEMENT_NODE_TYPE=1;var DOC_NODE_TYPE=9;var DOCUMENT_FRAGMENT_NODE_TYPE=11;var instancesByReactRootID={};function firstDifferenceIndex(string1,string2){var minLen=Math.min(string1.length,string2.length);for(var i=0;i<minLen;i++){if(string1.charAt(i)!==string2.charAt(i)){return i}}return string1.length===string2.length?-1:minLen}function getReactRootElementInContainer(container){if(!container){return null}if(container.nodeType===DOC_NODE_TYPE){return container.documentElement}else{return container.firstChild}}function internalGetID(node){return node.getAttribute&&node.getAttribute(ATTR_NAME)||""}function mountComponentIntoNode(wrapperInstance,container,transaction,shouldReuseMarkup,context){var markerName;if(ReactFeatureFlags.logTopLevelRenders){var wrappedElement=wrapperInstance._currentElement.props.child;var type=wrappedElement.type;markerName="React mount: "+(typeof type==="string"?type:type.displayName||type.name);console.time(markerName)}var markup=ReactReconciler.mountComponent(wrapperInstance,transaction,null,ReactDOMContainerInfo(wrapperInstance,container),context,0);if(markerName){console.timeEnd(markerName)}wrapperInstance._renderedComponent._topLevelWrapper=wrapperInstance;ReactMount._mountImageIntoNode(markup,container,wrapperInstance,shouldReuseMarkup,transaction)}function batchedMountComponentIntoNode(componentInstance,container,shouldReuseMarkup,context){var transaction=ReactUpdates.ReactReconcileTransaction.getPooled(!shouldReuseMarkup&&ReactDOMFeatureFlags.useCreateElement);transaction.perform(mountComponentIntoNode,null,componentInstance,container,transaction,shouldReuseMarkup,context);ReactUpdates.ReactReconcileTransaction.release(transaction)}function unmountComponentFromNode(instance,container,safely){if(process.env.NODE_ENV!=="production"){ReactInstrumentation.debugTool.onBeginFlush()}ReactReconciler.unmountComponent(instance,safely);if(process.env.NODE_ENV!=="production"){ReactInstrumentation.debugTool.onEndFlush()}if(container.nodeType===DOC_NODE_TYPE){container=container.documentElement}while(container.lastChild){container.removeChild(container.lastChild)}}function hasNonRootReactChild(container){var rootEl=getReactRootElementInContainer(container);if(rootEl){var inst=ReactDOMComponentTree.getInstanceFromNode(rootEl);return!!(inst&&inst._hostParent)}}function nodeIsRenderedByOtherInstance(container){var rootEl=getReactRootElementInContainer(container);return!!(rootEl&&isReactNode(rootEl)&&!ReactDOMComponentTree.getInstanceFromNode(rootEl))}function isValidContainer(node){return!!(node&&(node.nodeType===ELEMENT_NODE_TYPE||node.nodeType===DOC_NODE_TYPE||node.nodeType===DOCUMENT_FRAGMENT_NODE_TYPE))}function isReactNode(node){return isValidContainer(node)&&(node.hasAttribute(ROOT_ATTR_NAME)||node.hasAttribute(ATTR_NAME))}function getHostRootInstanceInContainer(container){var rootEl=getReactRootElementInContainer(container);var prevHostInstance=rootEl&&ReactDOMComponentTree.getInstanceFromNode(rootEl);return prevHostInstance&&!prevHostInstance._hostParent?prevHostInstance:null}function getTopLevelWrapperInContainer(container){var root=getHostRootInstanceInContainer(container);return root?root._hostContainerInfo._topLevelWrapper:null}var topLevelRootCounter=1;var TopLevelWrapper=function(){this.rootID=topLevelRootCounter++};TopLevelWrapper.prototype.isReactComponent={};if(process.env.NODE_ENV!=="production"){TopLevelWrapper.displayName="TopLevelWrapper"}TopLevelWrapper.prototype.render=function(){return this.props.child};TopLevelWrapper.isReactTopLevelWrapper=true;var ReactMount={TopLevelWrapper:TopLevelWrapper,_instancesByReactRootID:instancesByReactRootID,scrollMonitor:function(container,renderCallback){renderCallback()},_updateRootComponent:function(prevComponent,nextElement,nextContext,container,callback){ReactMount.scrollMonitor(container,function(){ReactUpdateQueue.enqueueElementInternal(prevComponent,nextElement,nextContext);if(callback){ReactUpdateQueue.enqueueCallbackInternal(prevComponent,callback)}});return prevComponent},_renderNewRootComponent:function(nextElement,container,shouldReuseMarkup,context){process.env.NODE_ENV!=="production"?warning(ReactCurrentOwner.current==null,"_renderNewRootComponent(): Render methods should be a pure function "+"of props and state; triggering nested component updates from "+"render is not allowed. If necessary, trigger nested updates in "+"componentDidUpdate. Check the render method of %s.",ReactCurrentOwner.current&&ReactCurrentOwner.current.getName()||"ReactCompositeComponent"):void 0;!isValidContainer(container)?process.env.NODE_ENV!=="production"?invariant(false,"_registerComponent(...): Target container is not a DOM element."):_prodInvariant("37"):void 0;ReactBrowserEventEmitter.ensureScrollValueMonitoring();var componentInstance=instantiateReactComponent(nextElement,false);ReactUpdates.batchedUpdates(batchedMountComponentIntoNode,componentInstance,container,shouldReuseMarkup,context);var wrapperID=componentInstance._instance.rootID;instancesByReactRootID[wrapperID]=componentInstance;return componentInstance},renderSubtreeIntoContainer:function(parentComponent,nextElement,container,callback){!(parentComponent!=null&&ReactInstanceMap.has(parentComponent))?process.env.NODE_ENV!=="production"?invariant(false,"parentComponent must be a valid React Component"):_prodInvariant("38"):void 0;return ReactMount._renderSubtreeIntoContainer(parentComponent,nextElement,container,callback)},_renderSubtreeIntoContainer:function(parentComponent,nextElement,container,callback){ReactUpdateQueue.validateCallback(callback,"ReactDOM.render");!React.isValidElement(nextElement)?process.env.NODE_ENV!=="production"?invariant(false,"ReactDOM.render(): Invalid component element.%s",typeof nextElement==="string"?" Instead of passing a string like 'div', pass "+"React.createElement('div') or <div />.":typeof nextElement==="function"?" Instead of passing a class like Foo, pass "+"React.createElement(Foo) or <Foo />.":nextElement!=null&&nextElement.props!==undefined?" This may be caused by unintentionally loading two independent "+"copies of React.":""):_prodInvariant("39",typeof nextElement==="string"?" Instead of passing a string like 'div', pass "+"React.createElement('div') or <div />.":typeof nextElement==="function"?" Instead of passing a class like Foo, pass "+"React.createElement(Foo) or <Foo />.":nextElement!=null&&nextElement.props!==undefined?" This may be caused by unintentionally loading two independent "+"copies of React.":""):void 0;process.env.NODE_ENV!=="production"?warning(!container||!container.tagName||container.tagName.toUpperCase()!=="BODY","render(): Rendering components directly into document.body is "+"discouraged, since its children are often manipulated by third-party "+"scripts and browser extensions. This may lead to subtle "+"reconciliation issues. Try rendering into a container element created "+"for your app."):void 0;var nextWrappedElement=React.createElement(TopLevelWrapper,{child:nextElement});var nextContext;if(parentComponent){var parentInst=ReactInstanceMap.get(parentComponent);nextContext=parentInst._processChildContext(parentInst._context)}else{nextContext=emptyObject}var prevComponent=getTopLevelWrapperInContainer(container);if(prevComponent){var prevWrappedElement=prevComponent._currentElement;var prevElement=prevWrappedElement.props.child;if(shouldUpdateReactComponent(prevElement,nextElement)){var publicInst=prevComponent._renderedComponent.getPublicInstance();var updatedCallback=callback&&function(){callback.call(publicInst)};ReactMount._updateRootComponent(prevComponent,nextWrappedElement,nextContext,container,updatedCallback);return publicInst}else{ReactMount.unmountComponentAtNode(container)}}var reactRootElement=getReactRootElementInContainer(container);var containerHasReactMarkup=reactRootElement&&!!internalGetID(reactRootElement);var containerHasNonRootReactChild=hasNonRootReactChild(container);if(process.env.NODE_ENV!=="production"){process.env.NODE_ENV!=="production"?warning(!containerHasNonRootReactChild,"render(...): Replacing React-rendered children with a new root "+"component. If you intended to update the children of this node, "+"you should instead have the existing children update their state "+"and render the new components instead of calling ReactDOM.render."):void 0;if(!containerHasReactMarkup||reactRootElement.nextSibling){var rootElementSibling=reactRootElement;while(rootElementSibling){if(internalGetID(rootElementSibling)){process.env.NODE_ENV!=="production"?warning(false,"render(): Target node has markup rendered by React, but there "+"are unrelated nodes as well. This is most commonly caused by "+"white-space inserted around server-rendered markup."):void 0;break}rootElementSibling=rootElementSibling.nextSibling}}}var shouldReuseMarkup=containerHasReactMarkup&&!prevComponent&&!containerHasNonRootReactChild;var component=ReactMount._renderNewRootComponent(nextWrappedElement,container,shouldReuseMarkup,nextContext)._renderedComponent.getPublicInstance();if(callback){callback.call(component)}return component},render:function(nextElement,container,callback){return ReactMount._renderSubtreeIntoContainer(null,nextElement,container,callback)},unmountComponentAtNode:function(container){process.env.NODE_ENV!=="production"?warning(ReactCurrentOwner.current==null,"unmountComponentAtNode(): Render methods should be a pure function "+"of props and state; triggering nested component updates from render "+"is not allowed. If necessary, trigger nested updates in "+"componentDidUpdate. Check the render method of %s.",ReactCurrentOwner.current&&ReactCurrentOwner.current.getName()||"ReactCompositeComponent"):void 0;!isValidContainer(container)?process.env.NODE_ENV!=="production"?invariant(false,"unmountComponentAtNode(...): Target container is not a DOM element."):_prodInvariant("40"):void 0;if(process.env.NODE_ENV!=="production"){process.env.NODE_ENV!=="production"?warning(!nodeIsRenderedByOtherInstance(container),"unmountComponentAtNode(): The node you're attempting to unmount "+"was rendered by another copy of React."):void 0}var prevComponent=getTopLevelWrapperInContainer(container);if(!prevComponent){var containerHasNonRootReactChild=hasNonRootReactChild(container);var isContainerReactRoot=container.nodeType===1&&container.hasAttribute(ROOT_ATTR_NAME);if(process.env.NODE_ENV!=="production"){process.env.NODE_ENV!=="production"?warning(!containerHasNonRootReactChild,"unmountComponentAtNode(): The node you're attempting to unmount "+"was rendered by React and is not a top-level container. %s",isContainerReactRoot?"You may have accidentally passed in a React root node instead "+"of its container.":"Instead, have the parent component update its state and "+"rerender in order to remove this component."):void 0}return false}delete instancesByReactRootID[prevComponent._instance.rootID];ReactUpdates.batchedUpdates(unmountComponentFromNode,prevComponent,container,false);return true},_mountImageIntoNode:function(markup,container,instance,shouldReuseMarkup,transaction){!isValidContainer(container)?process.env.NODE_ENV!=="production"?invariant(false,"mountComponentIntoNode(...): Target container is not valid."):_prodInvariant("41"):void 0;if(shouldReuseMarkup){var rootElement=getReactRootElementInContainer(container);if(ReactMarkupChecksum.canReuseMarkup(markup,rootElement)){ReactDOMComponentTree.precacheNode(instance,rootElement);return}else{var checksum=rootElement.getAttribute(ReactMarkupChecksum.CHECKSUM_ATTR_NAME);rootElement.removeAttribute(ReactMarkupChecksum.CHECKSUM_ATTR_NAME);var rootMarkup=rootElement.outerHTML;rootElement.setAttribute(ReactMarkupChecksum.CHECKSUM_ATTR_NAME,checksum);var normalizedMarkup=markup;if(process.env.NODE_ENV!=="production"){var normalizer;if(container.nodeType===ELEMENT_NODE_TYPE){normalizer=document.createElement("div");normalizer.innerHTML=markup;normalizedMarkup=normalizer.innerHTML}else{normalizer=document.createElement("iframe");document.body.appendChild(normalizer);normalizer.contentDocument.write(markup);normalizedMarkup=normalizer.contentDocument.documentElement.outerHTML;document.body.removeChild(normalizer)}}var diffIndex=firstDifferenceIndex(normalizedMarkup,rootMarkup);var difference=" (client) "+normalizedMarkup.substring(diffIndex-20,diffIndex+20)+"\n (server) "+rootMarkup.substring(diffIndex-20,diffIndex+20);!(container.nodeType!==DOC_NODE_TYPE)?process.env.NODE_ENV!=="production"?invariant(false,"You're trying to render a component to the document using server rendering but the checksum was invalid. This usually means you rendered a different component type or props on the client from the one on the server, or your render() methods are impure. React cannot handle this case due to cross-browser quirks by rendering at the document root. You should look for environment dependent code in your components and ensure the props are the same client and server side:\n%s",difference):_prodInvariant("42",difference):void 0;if(process.env.NODE_ENV!=="production"){process.env.NODE_ENV!=="production"?warning(false,"React attempted to reuse markup in a container but the "+"checksum was invalid. This generally means that you are "+"using server rendering and the markup generated on the "+"server was not what the client was expecting. React injected "+"new markup to compensate which works but you have lost many "+"of the benefits of server rendering. Instead, figure out "+"why the markup being generated is different on the client "+"or server:\n%s",difference):void 0}}}!(container.nodeType!==DOC_NODE_TYPE)?process.env.NODE_ENV!=="production"?invariant(false,"You're trying to render a component to the document but you didn't use server rendering. We can't do this without using server rendering due to cross-browser quirks. See ReactDOMServer.renderToString() for server rendering."):_prodInvariant("43"):void 0;if(transaction.useCreateElement){while(container.lastChild){container.removeChild(container.lastChild)}DOMLazyTree.insertTreeBefore(container,markup,null)}else{setInnerHTML(container,markup);ReactDOMComponentTree.precacheNode(instance,container.firstChild)}if(process.env.NODE_ENV!=="production"){var hostNode=ReactDOMComponentTree.getInstanceFromNode(container.firstChild);if(hostNode._debugID!==0){ReactInstrumentation.debugTool.onHostOperation({instanceID:hostNode._debugID,type:"mount",payload:markup.toString()})}}}};module.exports=ReactMount}).call(this,require("_process"))},{"./DOMLazyTree":40,"./DOMProperty":42,"./ReactBrowserEventEmitter":56,"./ReactDOMComponentTree":64,"./ReactDOMContainerInfo":65,"./ReactDOMFeatureFlags":67,"./ReactFeatureFlags":87,"./ReactInstanceMap":92,"./ReactInstrumentation":93,"./ReactMarkupChecksum":95,"./ReactReconciler":103,"./ReactUpdateQueue":107,"./ReactUpdates":108,"./instantiateReactComponent":147,"./reactProdInvariant":151,"./setInnerHTML":153,"./shouldUpdateReactComponent":155,_process:184,"fbjs/lib/emptyObject":11,"fbjs/lib/invariant":18,"fbjs/lib/warning":25,"react/lib/React":160,"react/lib/ReactCurrentOwner":164}],97:[function(require,module,exports){(function(process){"use strict";var _prodInvariant=require("./reactProdInvariant");var ReactComponentEnvironment=require("./ReactComponentEnvironment");var ReactInstanceMap=require("./ReactInstanceMap");var ReactInstrumentation=require("./ReactInstrumentation");var ReactCurrentOwner=require("react/lib/ReactCurrentOwner");var ReactReconciler=require("./ReactReconciler");var ReactChildReconciler=require("./ReactChildReconciler");var emptyFunction=require("fbjs/lib/emptyFunction");var flattenChildren=require("./flattenChildren");var invariant=require("fbjs/lib/invariant");function makeInsertMarkup(markup,afterNode,toIndex){return{type:"INSERT_MARKUP",content:markup,fromIndex:null,fromNode:null,toIndex:toIndex,afterNode:afterNode}}function makeMove(child,afterNode,toIndex){return{type:"MOVE_EXISTING",content:null,fromIndex:child._mountIndex,fromNode:ReactReconciler.getHostNode(child),toIndex:toIndex,afterNode:afterNode}}function makeRemove(child,node){return{type:"REMOVE_NODE",content:null,fromIndex:child._mountIndex,fromNode:node,toIndex:null,afterNode:null}}function makeSetMarkup(markup){return{type:"SET_MARKUP",content:markup,fromIndex:null,fromNode:null,toIndex:null,afterNode:null}}function makeTextContent(textContent){return{type:"TEXT_CONTENT",content:textContent,fromIndex:null,fromNode:null,toIndex:null,afterNode:null}}function enqueue(queue,update){if(update){queue=queue||[];queue.push(update)}return queue}function processQueue(inst,updateQueue){ReactComponentEnvironment.processChildrenUpdates(inst,updateQueue)}var setChildrenForInstrumentation=emptyFunction;if(process.env.NODE_ENV!=="production"){var getDebugID=function(inst){if(!inst._debugID){var internal;if(internal=ReactInstanceMap.get(inst)){inst=internal}}return inst._debugID};setChildrenForInstrumentation=function(children){var debugID=getDebugID(this);if(debugID!==0){ReactInstrumentation.debugTool.onSetChildren(debugID,children?Object.keys(children).map(function(key){return children[key]._debugID}):[])}}}var ReactMultiChild={Mixin:{_reconcilerInstantiateChildren:function(nestedChildren,transaction,context){if(process.env.NODE_ENV!=="production"){var selfDebugID=getDebugID(this);if(this._currentElement){try{ReactCurrentOwner.current=this._currentElement._owner;return ReactChildReconciler.instantiateChildren(nestedChildren,transaction,context,selfDebugID)}finally{ReactCurrentOwner.current=null}}}return ReactChildReconciler.instantiateChildren(nestedChildren,transaction,context)},_reconcilerUpdateChildren:function(prevChildren,nextNestedChildrenElements,mountImages,removedNodes,transaction,context){var nextChildren;var selfDebugID=0;if(process.env.NODE_ENV!=="production"){selfDebugID=getDebugID(this);if(this._currentElement){try{ReactCurrentOwner.current=this._currentElement._owner;nextChildren=flattenChildren(nextNestedChildrenElements,selfDebugID)}finally{ReactCurrentOwner.current=null}ReactChildReconciler.updateChildren(prevChildren,nextChildren,mountImages,removedNodes,transaction,this,this._hostContainerInfo,context,selfDebugID);return nextChildren}}nextChildren=flattenChildren(nextNestedChildrenElements,selfDebugID);ReactChildReconciler.updateChildren(prevChildren,nextChildren,mountImages,removedNodes,transaction,this,this._hostContainerInfo,context,selfDebugID);return nextChildren},mountChildren:function(nestedChildren,transaction,context){var children=this._reconcilerInstantiateChildren(nestedChildren,transaction,context);this._renderedChildren=children;var mountImages=[];var index=0;for(var name in children){if(children.hasOwnProperty(name)){var child=children[name];var selfDebugID=0;if(process.env.NODE_ENV!=="production"){selfDebugID=getDebugID(this)}var mountImage=ReactReconciler.mountComponent(child,transaction,this,this._hostContainerInfo,context,selfDebugID);child._mountIndex=index++;mountImages.push(mountImage)}}if(process.env.NODE_ENV!=="production"){setChildrenForInstrumentation.call(this,children)}return mountImages},updateTextContent:function(nextContent){var prevChildren=this._renderedChildren;ReactChildReconciler.unmountChildren(prevChildren,false);for(var name in prevChildren){if(prevChildren.hasOwnProperty(name)){!false?process.env.NODE_ENV!=="production"?invariant(false,"updateTextContent called on non-empty component."):_prodInvariant("118"):void 0}}var updates=[makeTextContent(nextContent)];processQueue(this,updates)},updateMarkup:function(nextMarkup){var prevChildren=this._renderedChildren;ReactChildReconciler.unmountChildren(prevChildren,false);for(var name in prevChildren){if(prevChildren.hasOwnProperty(name)){!false?process.env.NODE_ENV!=="production"?invariant(false,"updateTextContent called on non-empty component."):_prodInvariant("118"):void 0}}var updates=[makeSetMarkup(nextMarkup)];processQueue(this,updates)},updateChildren:function(nextNestedChildrenElements,transaction,context){this._updateChildren(nextNestedChildrenElements,transaction,context)},_updateChildren:function(nextNestedChildrenElements,transaction,context){var prevChildren=this._renderedChildren;var removedNodes={};var mountImages=[];var nextChildren=this._reconcilerUpdateChildren(prevChildren,nextNestedChildrenElements,mountImages,removedNodes,transaction,context);if(!nextChildren&&!prevChildren){return}var updates=null;var name;var nextIndex=0;var lastIndex=0;var nextMountIndex=0;var lastPlacedNode=null;for(name in nextChildren){if(!nextChildren.hasOwnProperty(name)){continue}var prevChild=prevChildren&&prevChildren[name];var nextChild=nextChildren[name];if(prevChild===nextChild){updates=enqueue(updates,this.moveChild(prevChild,lastPlacedNode,nextIndex,lastIndex));lastIndex=Math.max(prevChild._mountIndex,lastIndex);prevChild._mountIndex=nextIndex}else{if(prevChild){lastIndex=Math.max(prevChild._mountIndex,lastIndex)}updates=enqueue(updates,this._mountChildAtIndex(nextChild,mountImages[nextMountIndex],lastPlacedNode,nextIndex,transaction,context));nextMountIndex++}nextIndex++;lastPlacedNode=ReactReconciler.getHostNode(nextChild)}for(name in removedNodes){if(removedNodes.hasOwnProperty(name)){updates=enqueue(updates,this._unmountChild(prevChildren[name],removedNodes[name]))}}if(updates){processQueue(this,updates)}this._renderedChildren=nextChildren;if(process.env.NODE_ENV!=="production"){setChildrenForInstrumentation.call(this,nextChildren)}},unmountChildren:function(safely){var renderedChildren=this._renderedChildren;ReactChildReconciler.unmountChildren(renderedChildren,safely);this._renderedChildren=null},moveChild:function(child,afterNode,toIndex,lastIndex){if(child._mountIndex<lastIndex){return makeMove(child,afterNode,toIndex)}},createChild:function(child,afterNode,mountImage){return makeInsertMarkup(mountImage,afterNode,child._mountIndex)},removeChild:function(child,node){return makeRemove(child,node)},_mountChildAtIndex:function(child,mountImage,afterNode,index,transaction,context){child._mountIndex=index;return this.createChild(child,afterNode,mountImage)},_unmountChild:function(child,node){var update=this.removeChild(child,node);child._mountIndex=null;return update}}};module.exports=ReactMultiChild}).call(this,require("_process"))},{"./ReactChildReconciler":57,"./ReactComponentEnvironment":59,"./ReactInstanceMap":92,"./ReactInstrumentation":93,"./ReactReconciler":103,"./flattenChildren":135,"./reactProdInvariant":151,_process:184,"fbjs/lib/emptyFunction":10,"fbjs/lib/invariant":18,"react/lib/ReactCurrentOwner":164}],98:[function(require,module,exports){(function(process){"use strict";var _prodInvariant=require("./reactProdInvariant");var React=require("react/lib/React");var invariant=require("fbjs/lib/invariant");var ReactNodeTypes={HOST:0,COMPOSITE:1,EMPTY:2,getType:function(node){if(node===null||node===false){return ReactNodeTypes.EMPTY}else if(React.isValidElement(node)){if(typeof node.type==="function"){return ReactNodeTypes.COMPOSITE}else{return ReactNodeTypes.HOST}}!false?process.env.NODE_ENV!=="production"?invariant(false,"Unexpected node: %s",node):_prodInvariant("26",node):void 0}};module.exports=ReactNodeTypes}).call(this,require("_process"))},{"./reactProdInvariant":151,_process:184,"fbjs/lib/invariant":18,"react/lib/React":160}],99:[function(require,module,exports){(function(process){"use strict";var _prodInvariant=require("./reactProdInvariant");var invariant=require("fbjs/lib/invariant");function isValidOwner(object){return!!(object&&typeof object.attachRef==="function"&&typeof object.detachRef==="function")}var ReactOwner={addComponentAsRefTo:function(component,ref,owner){!isValidOwner(owner)?process.env.NODE_ENV!=="production"?invariant(false,"addComponentAsRefTo(...): Only a ReactOwner can have refs. You might be adding a ref to a component that was not created inside a component's `render` method, or you have multiple copies of React loaded (details: https://fb.me/react-refs-must-have-owner)."):_prodInvariant("119"):void 0;owner.attachRef(ref,component)},removeComponentAsRefFrom:function(component,ref,owner){!isValidOwner(owner)?process.env.NODE_ENV!=="production"?invariant(false,"removeComponentAsRefFrom(...): Only a ReactOwner can have refs. You might be removing a ref to a component that was not created inside a component's `render` method, or you have multiple copies of React loaded (details: https://fb.me/react-refs-must-have-owner)."):_prodInvariant("120"):void 0;var ownerPublicInstance=owner.getPublicInstance();if(ownerPublicInstance&&ownerPublicInstance.refs[ref]===component.getPublicInstance()){owner.detachRef(ref)}}};module.exports=ReactOwner}).call(this,require("_process"))},{"./reactProdInvariant":151,_process:184,"fbjs/lib/invariant":18}],100:[function(require,module,exports){(function(process){"use strict";var ReactPropTypeLocationNames={};if(process.env.NODE_ENV!=="production"){ReactPropTypeLocationNames={prop:"prop",context:"context",childContext:"child context"}}module.exports=ReactPropTypeLocationNames}).call(this,require("_process"))},{_process:184}],101:[function(require,module,exports){"use strict";var ReactPropTypesSecret="SECRET_DO_NOT_PASS_THIS_OR_YOU_WILL_BE_FIRED";module.exports=ReactPropTypesSecret},{}],102:[function(require,module,exports){(function(process){"use strict";var _assign=require("object-assign");var CallbackQueue=require("./CallbackQueue");var PooledClass=require("./PooledClass");var ReactBrowserEventEmitter=require("./ReactBrowserEventEmitter");var ReactInputSelection=require("./ReactInputSelection");var ReactInstrumentation=require("./ReactInstrumentation");var Transaction=require("./Transaction");var ReactUpdateQueue=require("./ReactUpdateQueue");var SELECTION_RESTORATION={initialize:ReactInputSelection.getSelectionInformation,close:ReactInputSelection.restoreSelection};var EVENT_SUPPRESSION={initialize:function(){var currentlyEnabled=ReactBrowserEventEmitter.isEnabled();ReactBrowserEventEmitter.setEnabled(false);return currentlyEnabled},close:function(previouslyEnabled){ReactBrowserEventEmitter.setEnabled(previouslyEnabled)}};var ON_DOM_READY_QUEUEING={initialize:function(){this.reactMountReady.reset()},close:function(){this.reactMountReady.notifyAll()}};var TRANSACTION_WRAPPERS=[SELECTION_RESTORATION,EVENT_SUPPRESSION,ON_DOM_READY_QUEUEING];if(process.env.NODE_ENV!=="production"){TRANSACTION_WRAPPERS.push({initialize:ReactInstrumentation.debugTool.onBeginFlush,close:ReactInstrumentation.debugTool.onEndFlush})}function ReactReconcileTransaction(useCreateElement){this.reinitializeTransaction();this.renderToStaticMarkup=false;this.reactMountReady=CallbackQueue.getPooled(null);this.useCreateElement=useCreateElement}var Mixin={getTransactionWrappers:function(){return TRANSACTION_WRAPPERS},getReactMountReady:function(){return this.reactMountReady},getUpdateQueue:function(){return ReactUpdateQueue},checkpoint:function(){return this.reactMountReady.checkpoint()},rollback:function(checkpoint){this.reactMountReady.rollback(checkpoint)},destructor:function(){CallbackQueue.release(this.reactMountReady);this.reactMountReady=null}};_assign(ReactReconcileTransaction.prototype,Transaction,Mixin);PooledClass.addPoolingTo(ReactReconcileTransaction);module.exports=ReactReconcileTransaction}).call(this,require("_process"))},{"./CallbackQueue":37,"./PooledClass":55,"./ReactBrowserEventEmitter":56,"./ReactInputSelection":91,"./ReactInstrumentation":93,"./ReactUpdateQueue":107,"./Transaction":126,_process:184,"object-assign":26}],103:[function(require,module,exports){(function(process){"use strict";var ReactRef=require("./ReactRef");var ReactInstrumentation=require("./ReactInstrumentation");var warning=require("fbjs/lib/warning");function attachRefs(){ReactRef.attachRefs(this,this._currentElement)}var ReactReconciler={mountComponent:function(internalInstance,transaction,hostParent,hostContainerInfo,context,parentDebugID){if(process.env.NODE_ENV!=="production"){if(internalInstance._debugID!==0){ReactInstrumentation.debugTool.onBeforeMountComponent(internalInstance._debugID,internalInstance._currentElement,parentDebugID)}}var markup=internalInstance.mountComponent(transaction,hostParent,hostContainerInfo,context,parentDebugID);if(internalInstance._currentElement&&internalInstance._currentElement.ref!=null){transaction.getReactMountReady().enqueue(attachRefs,internalInstance)}if(process.env.NODE_ENV!=="production"){if(internalInstance._debugID!==0){ReactInstrumentation.debugTool.onMountComponent(internalInstance._debugID)}}return markup},getHostNode:function(internalInstance){return internalInstance.getHostNode()},unmountComponent:function(internalInstance,safely){if(process.env.NODE_ENV!=="production"){if(internalInstance._debugID!==0){ReactInstrumentation.debugTool.onBeforeUnmountComponent(internalInstance._debugID)}}ReactRef.detachRefs(internalInstance,internalInstance._currentElement);internalInstance.unmountComponent(safely);if(process.env.NODE_ENV!=="production"){if(internalInstance._debugID!==0){ReactInstrumentation.debugTool.onUnmountComponent(internalInstance._debugID)}}},receiveComponent:function(internalInstance,nextElement,transaction,context){var prevElement=internalInstance._currentElement;if(nextElement===prevElement&&context===internalInstance._context){return}if(process.env.NODE_ENV!=="production"){if(internalInstance._debugID!==0){ReactInstrumentation.debugTool.onBeforeUpdateComponent(internalInstance._debugID,nextElement)}}var refsChanged=ReactRef.shouldUpdateRefs(prevElement,nextElement);if(refsChanged){ReactRef.detachRefs(internalInstance,prevElement)}internalInstance.receiveComponent(nextElement,transaction,context);if(refsChanged&&internalInstance._currentElement&&internalInstance._currentElement.ref!=null){transaction.getReactMountReady().enqueue(attachRefs,internalInstance)}if(process.env.NODE_ENV!=="production"){if(internalInstance._debugID!==0){ReactInstrumentation.debugTool.onUpdateComponent(internalInstance._debugID)}}},performUpdateIfNecessary:function(internalInstance,transaction,updateBatchNumber){if(internalInstance._updateBatchNumber!==updateBatchNumber){process.env.NODE_ENV!=="production"?warning(internalInstance._updateBatchNumber==null||internalInstance._updateBatchNumber===updateBatchNumber+1,"performUpdateIfNecessary: Unexpected batch number (current %s, "+"pending %s)",updateBatchNumber,internalInstance._updateBatchNumber):void 0;return}if(process.env.NODE_ENV!=="production"){if(internalInstance._debugID!==0){ReactInstrumentation.debugTool.onBeforeUpdateComponent(internalInstance._debugID,internalInstance._currentElement)}}internalInstance.performUpdateIfNecessary(transaction);if(process.env.NODE_ENV!=="production"){if(internalInstance._debugID!==0){ReactInstrumentation.debugTool.onUpdateComponent(internalInstance._debugID)}}}};module.exports=ReactReconciler}).call(this,require("_process"))},{"./ReactInstrumentation":93,"./ReactRef":104,_process:184,"fbjs/lib/warning":25}],104:[function(require,module,exports){"use strict";var ReactOwner=require("./ReactOwner");var ReactRef={};function attachRef(ref,component,owner){if(typeof ref==="function"){ref(component.getPublicInstance())}else{ReactOwner.addComponentAsRefTo(component,ref,owner)}}function detachRef(ref,component,owner){if(typeof ref==="function"){ref(null)}else{ReactOwner.removeComponentAsRefFrom(component,ref,owner)}}ReactRef.attachRefs=function(instance,element){if(element===null||typeof element!=="object"){return}var ref=element.ref;if(ref!=null){attachRef(ref,instance,element._owner)}};ReactRef.shouldUpdateRefs=function(prevElement,nextElement){var prevRef=null;var prevOwner=null;if(prevElement!==null&&typeof prevElement==="object"){prevRef=prevElement.ref;prevOwner=prevElement._owner}var nextRef=null;var nextOwner=null;if(nextElement!==null&&typeof nextElement==="object"){nextRef=nextElement.ref;nextOwner=nextElement._owner}return prevRef!==nextRef||typeof nextRef==="string"&&nextOwner!==prevOwner};ReactRef.detachRefs=function(instance,element){if(element===null||typeof element!=="object"){return}var ref=element.ref;if(ref!=null){detachRef(ref,instance,element._owner)}};module.exports=ReactRef},{"./ReactOwner":99}],105:[function(require,module,exports){(function(process){"use strict";var _assign=require("object-assign");var PooledClass=require("./PooledClass");var Transaction=require("./Transaction");var ReactInstrumentation=require("./ReactInstrumentation");var ReactServerUpdateQueue=require("./ReactServerUpdateQueue");var TRANSACTION_WRAPPERS=[];if(process.env.NODE_ENV!=="production"){TRANSACTION_WRAPPERS.push({initialize:ReactInstrumentation.debugTool.onBeginFlush,close:ReactInstrumentation.debugTool.onEndFlush})}var noopCallbackQueue={enqueue:function(){}};function ReactServerRenderingTransaction(renderToStaticMarkup){this.reinitializeTransaction();this.renderToStaticMarkup=renderToStaticMarkup;this.useCreateElement=false;this.updateQueue=new ReactServerUpdateQueue(this)}var Mixin={getTransactionWrappers:function(){return TRANSACTION_WRAPPERS},getReactMountReady:function(){return noopCallbackQueue},getUpdateQueue:function(){return this.updateQueue},destructor:function(){},checkpoint:function(){},rollback:function(){}};_assign(ReactServerRenderingTransaction.prototype,Transaction,Mixin);PooledClass.addPoolingTo(ReactServerRenderingTransaction);module.exports=ReactServerRenderingTransaction}).call(this,require("_process"))},{"./PooledClass":55,"./ReactInstrumentation":93,"./ReactServerUpdateQueue":106,"./Transaction":126,_process:184,"object-assign":26}],106:[function(require,module,exports){(function(process){"use strict";function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}var ReactUpdateQueue=require("./ReactUpdateQueue");var warning=require("fbjs/lib/warning");function warnNoop(publicInstance,callerName){if(process.env.NODE_ENV!=="production"){var constructor=publicInstance.constructor;process.env.NODE_ENV!=="production"?warning(false,"%s(...): Can only update a mounting component. "+"This usually means you called %s() outside componentWillMount() on the server. "+"This is a no-op. Please check the code for the %s component.",callerName,callerName,constructor&&(constructor.displayName||constructor.name)||"ReactClass"):void 0}}var ReactServerUpdateQueue=function(){function ReactServerUpdateQueue(transaction){_classCallCheck(this,ReactServerUpdateQueue);this.transaction=transaction}ReactServerUpdateQueue.prototype.isMounted=function isMounted(publicInstance){return false};ReactServerUpdateQueue.prototype.enqueueCallback=function enqueueCallback(publicInstance,callback,callerName){if(this.transaction.isInTransaction()){ReactUpdateQueue.enqueueCallback(publicInstance,callback,callerName)}};ReactServerUpdateQueue.prototype.enqueueForceUpdate=function enqueueForceUpdate(publicInstance){if(this.transaction.isInTransaction()){ReactUpdateQueue.enqueueForceUpdate(publicInstance)}else{warnNoop(publicInstance,"forceUpdate")}};ReactServerUpdateQueue.prototype.enqueueReplaceState=function enqueueReplaceState(publicInstance,completeState){if(this.transaction.isInTransaction()){ReactUpdateQueue.enqueueReplaceState(publicInstance,completeState)}else{warnNoop(publicInstance,"replaceState")}};ReactServerUpdateQueue.prototype.enqueueSetState=function enqueueSetState(publicInstance,partialState){if(this.transaction.isInTransaction()){ReactUpdateQueue.enqueueSetState(publicInstance,partialState)}else{warnNoop(publicInstance,"setState")}};return ReactServerUpdateQueue}();module.exports=ReactServerUpdateQueue}).call(this,require("_process"))},{"./ReactUpdateQueue":107,_process:184,"fbjs/lib/warning":25}],107:[function(require,module,exports){(function(process){"use strict";var _prodInvariant=require("./reactProdInvariant");var ReactCurrentOwner=require("react/lib/ReactCurrentOwner");var ReactInstanceMap=require("./ReactInstanceMap");var ReactInstrumentation=require("./ReactInstrumentation");var ReactUpdates=require("./ReactUpdates");var invariant=require("fbjs/lib/invariant");var warning=require("fbjs/lib/warning");function enqueueUpdate(internalInstance){ReactUpdates.enqueueUpdate(internalInstance)}function formatUnexpectedArgument(arg){var type=typeof arg;if(type!=="object"){return type}var displayName=arg.constructor&&arg.constructor.name||type;var keys=Object.keys(arg);if(keys.length>0&&keys.length<20){return displayName+" (keys: "+keys.join(", ")+")"}return displayName}function getInternalInstanceReadyForUpdate(publicInstance,callerName){var internalInstance=ReactInstanceMap.get(publicInstance);if(!internalInstance){if(process.env.NODE_ENV!=="production"){var ctor=publicInstance.constructor;process.env.NODE_ENV!=="production"?warning(!callerName,"%s(...): Can only update a mounted or mounting component. "+"This usually means you called %s() on an unmounted component. "+"This is a no-op. Please check the code for the %s component.",callerName,callerName,ctor&&(ctor.displayName||ctor.name)||"ReactClass"):void 0}return null}if(process.env.NODE_ENV!=="production"){process.env.NODE_ENV!=="production"?warning(ReactCurrentOwner.current==null,"%s(...): Cannot update during an existing state transition (such as "+"within `render` or another component's constructor). Render methods "+"should be a pure function of props and state; constructor "+"side-effects are an anti-pattern, but can be moved to "+"`componentWillMount`.",callerName):void 0}return internalInstance}var ReactUpdateQueue={isMounted:function(publicInstance){if(process.env.NODE_ENV!=="production"){var owner=ReactCurrentOwner.current;if(owner!==null){process.env.NODE_ENV!=="production"?warning(owner._warnedAboutRefsInRender,"%s is accessing isMounted inside its render() function. "+"render() should be a pure function of props and state. It should "+"never access something that requires stale data from the previous "+"render, such as refs. Move this logic to componentDidMount and "+"componentDidUpdate instead.",owner.getName()||"A component"):void 0;owner._warnedAboutRefsInRender=true}}var internalInstance=ReactInstanceMap.get(publicInstance);if(internalInstance){return!!internalInstance._renderedComponent}else{return false}},enqueueCallback:function(publicInstance,callback,callerName){ReactUpdateQueue.validateCallback(callback,callerName);var internalInstance=getInternalInstanceReadyForUpdate(publicInstance);if(!internalInstance){return null}if(internalInstance._pendingCallbacks){internalInstance._pendingCallbacks.push(callback)}else{internalInstance._pendingCallbacks=[callback]}enqueueUpdate(internalInstance)},enqueueCallbackInternal:function(internalInstance,callback){if(internalInstance._pendingCallbacks){internalInstance._pendingCallbacks.push(callback)}else{internalInstance._pendingCallbacks=[callback]}enqueueUpdate(internalInstance)},enqueueForceUpdate:function(publicInstance){var internalInstance=getInternalInstanceReadyForUpdate(publicInstance,"forceUpdate");if(!internalInstance){return}internalInstance._pendingForceUpdate=true;enqueueUpdate(internalInstance)},enqueueReplaceState:function(publicInstance,completeState,callback){var internalInstance=getInternalInstanceReadyForUpdate(publicInstance,"replaceState");if(!internalInstance){return}internalInstance._pendingStateQueue=[completeState];internalInstance._pendingReplaceState=true;if(callback!==undefined&&callback!==null){ReactUpdateQueue.validateCallback(callback,"replaceState");if(internalInstance._pendingCallbacks){internalInstance._pendingCallbacks.push(callback)}else{internalInstance._pendingCallbacks=[callback]}}enqueueUpdate(internalInstance)},enqueueSetState:function(publicInstance,partialState){if(process.env.NODE_ENV!=="production"){ReactInstrumentation.debugTool.onSetState();process.env.NODE_ENV!=="production"?warning(partialState!=null,"setState(...): You passed an undefined or null state object; "+"instead, use forceUpdate()."):void 0}var internalInstance=getInternalInstanceReadyForUpdate(publicInstance,"setState");if(!internalInstance){return}var queue=internalInstance._pendingStateQueue||(internalInstance._pendingStateQueue=[]);queue.push(partialState);enqueueUpdate(internalInstance)},enqueueElementInternal:function(internalInstance,nextElement,nextContext){internalInstance._pendingElement=nextElement;internalInstance._context=nextContext;enqueueUpdate(internalInstance)},validateCallback:function(callback,callerName){!(!callback||typeof callback==="function")?process.env.NODE_ENV!=="production"?invariant(false,"%s(...): Expected the last optional `callback` argument to be a function. Instead received: %s.",callerName,formatUnexpectedArgument(callback)):_prodInvariant("122",callerName,formatUnexpectedArgument(callback)):void 0}};module.exports=ReactUpdateQueue}).call(this,require("_process"))},{"./ReactInstanceMap":92,"./ReactInstrumentation":93,"./ReactUpdates":108,"./reactProdInvariant":151,_process:184,"fbjs/lib/invariant":18,"fbjs/lib/warning":25,"react/lib/ReactCurrentOwner":164}],108:[function(require,module,exports){(function(process){"use strict";var _prodInvariant=require("./reactProdInvariant"),_assign=require("object-assign");var CallbackQueue=require("./CallbackQueue");var PooledClass=require("./PooledClass");var ReactFeatureFlags=require("./ReactFeatureFlags");var ReactReconciler=require("./ReactReconciler");var Transaction=require("./Transaction");var invariant=require("fbjs/lib/invariant");var dirtyComponents=[];var updateBatchNumber=0;var asapCallbackQueue=CallbackQueue.getPooled();var asapEnqueued=false;var batchingStrategy=null;function ensureInjected(){!(ReactUpdates.ReactReconcileTransaction&&batchingStrategy)?process.env.NODE_ENV!=="production"?invariant(false,"ReactUpdates: must inject a reconcile transaction class and batching strategy"):_prodInvariant("123"):void 0}var NESTED_UPDATES={initialize:function(){this.dirtyComponentsLength=dirtyComponents.length},close:function(){if(this.dirtyComponentsLength!==dirtyComponents.length){dirtyComponents.splice(0,this.dirtyComponentsLength);flushBatchedUpdates()}else{dirtyComponents.length=0}}};var UPDATE_QUEUEING={initialize:function(){this.callbackQueue.reset()},close:function(){this.callbackQueue.notifyAll()}};var TRANSACTION_WRAPPERS=[NESTED_UPDATES,UPDATE_QUEUEING];function ReactUpdatesFlushTransaction(){this.reinitializeTransaction();this.dirtyComponentsLength=null;this.callbackQueue=CallbackQueue.getPooled();this.reconcileTransaction=ReactUpdates.ReactReconcileTransaction.getPooled(true)}_assign(ReactUpdatesFlushTransaction.prototype,Transaction,{getTransactionWrappers:function(){return TRANSACTION_WRAPPERS},destructor:function(){this.dirtyComponentsLength=null;CallbackQueue.release(this.callbackQueue);this.callbackQueue=null;ReactUpdates.ReactReconcileTransaction.release(this.reconcileTransaction);this.reconcileTransaction=null},perform:function(method,scope,a){return Transaction.perform.call(this,this.reconcileTransaction.perform,this.reconcileTransaction,method,scope,a)}});PooledClass.addPoolingTo(ReactUpdatesFlushTransaction);function batchedUpdates(callback,a,b,c,d,e){ensureInjected();return batchingStrategy.batchedUpdates(callback,a,b,c,d,e)}function mountOrderComparator(c1,c2){return c1._mountOrder-c2._mountOrder}function runBatchedUpdates(transaction){var len=transaction.dirtyComponentsLength;!(len===dirtyComponents.length)?process.env.NODE_ENV!=="production"?invariant(false,"Expected flush transaction's stored dirty-components length (%s) to match dirty-components array length (%s).",len,dirtyComponents.length):_prodInvariant("124",len,dirtyComponents.length):void 0;dirtyComponents.sort(mountOrderComparator);updateBatchNumber++;for(var i=0;i<len;i++){var component=dirtyComponents[i];var callbacks=component._pendingCallbacks;component._pendingCallbacks=null;var markerName;if(ReactFeatureFlags.logTopLevelRenders){var namedComponent=component;if(component._currentElement.type.isReactTopLevelWrapper){namedComponent=component._renderedComponent}markerName="React update: "+namedComponent.getName();console.time(markerName)}ReactReconciler.performUpdateIfNecessary(component,transaction.reconcileTransaction,updateBatchNumber);if(markerName){console.timeEnd(markerName)}if(callbacks){for(var j=0;j<callbacks.length;j++){transaction.callbackQueue.enqueue(callbacks[j],component.getPublicInstance())}}}}var flushBatchedUpdates=function(){while(dirtyComponents.length||asapEnqueued){if(dirtyComponents.length){var transaction=ReactUpdatesFlushTransaction.getPooled();transaction.perform(runBatchedUpdates,null,transaction);ReactUpdatesFlushTransaction.release(transaction)}if(asapEnqueued){asapEnqueued=false;var queue=asapCallbackQueue;asapCallbackQueue=CallbackQueue.getPooled();queue.notifyAll();CallbackQueue.release(queue)}}};function enqueueUpdate(component){ensureInjected();if(!batchingStrategy.isBatchingUpdates){batchingStrategy.batchedUpdates(enqueueUpdate,component);return}dirtyComponents.push(component);if(component._updateBatchNumber==null){component._updateBatchNumber=updateBatchNumber+1}}function asap(callback,context){!batchingStrategy.isBatchingUpdates?process.env.NODE_ENV!=="production"?invariant(false,"ReactUpdates.asap: Can't enqueue an asap callback in a context whereupdates are not being batched."):_prodInvariant("125"):void 0;asapCallbackQueue.enqueue(callback,context);asapEnqueued=true}var ReactUpdatesInjection={injectReconcileTransaction:function(ReconcileTransaction){!ReconcileTransaction?process.env.NODE_ENV!=="production"?invariant(false,"ReactUpdates: must provide a reconcile transaction class"):_prodInvariant("126"):void 0;ReactUpdates.ReactReconcileTransaction=ReconcileTransaction},injectBatchingStrategy:function(_batchingStrategy){!_batchingStrategy?process.env.NODE_ENV!=="production"?invariant(false,"ReactUpdates: must provide a batching strategy"):_prodInvariant("127"):void 0;!(typeof _batchingStrategy.batchedUpdates==="function")?process.env.NODE_ENV!=="production"?invariant(false,"ReactUpdates: must provide a batchedUpdates() function"):_prodInvariant("128"):void 0;!(typeof _batchingStrategy.isBatchingUpdates==="boolean")?process.env.NODE_ENV!=="production"?invariant(false,"ReactUpdates: must provide an isBatchingUpdates boolean attribute"):_prodInvariant("129"):void 0;batchingStrategy=_batchingStrategy}};var ReactUpdates={ReactReconcileTransaction:null,batchedUpdates:batchedUpdates,enqueueUpdate:enqueueUpdate,flushBatchedUpdates:flushBatchedUpdates,injection:ReactUpdatesInjection,asap:asap};module.exports=ReactUpdates}).call(this,require("_process"))},{"./CallbackQueue":37,"./PooledClass":55,"./ReactFeatureFlags":87,"./ReactReconciler":103,"./Transaction":126,"./reactProdInvariant":151,_process:184,"fbjs/lib/invariant":18,"object-assign":26}],109:[function(require,module,exports){"use strict";module.exports="15.6.1"},{}],110:[function(require,module,exports){"use strict";var NS={xlink:"http://www.w3.org/1999/xlink",xml:"http://www.w3.org/XML/1998/namespace"};var ATTRS={accentHeight:"accent-height",accumulate:0,additive:0,alignmentBaseline:"alignment-baseline",allowReorder:"allowReorder",alphabetic:0,amplitude:0,arabicForm:"arabic-form",ascent:0,attributeName:"attributeName",attributeType:"attributeType",autoReverse:"autoReverse",azimuth:0,baseFrequency:"baseFrequency",baseProfile:"baseProfile",baselineShift:"baseline-shift",bbox:0,begin:0,bias:0,by:0,calcMode:"calcMode",capHeight:"cap-height",clip:0,clipPath:"clip-path",clipRule:"clip-rule",clipPathUnits:"clipPathUnits",colorInterpolation:"color-interpolation",colorInterpolationFilters:"color-interpolation-filters",colorProfile:"color-profile",colorRendering:"color-rendering",contentScriptType:"contentScriptType",contentStyleType:"contentStyleType",cursor:0,cx:0,cy:0,d:0,decelerate:0,descent:0,diffuseConstant:"diffuseConstant",direction:0,display:0,divisor:0,dominantBaseline:"dominant-baseline",dur:0,dx:0,dy:0,edgeMode:"edgeMode",elevation:0,enableBackground:"enable-background",end:0,exponent:0,externalResourcesRequired:"externalResourcesRequired",fill:0,fillOpacity:"fill-opacity",fillRule:"fill-rule",filter:0,filterRes:"filterRes",filterUnits:"filterUnits",floodColor:"flood-color",floodOpacity:"flood-opacity",focusable:0,fontFamily:"font-family",fontSize:"font-size",fontSizeAdjust:"font-size-adjust",fontStretch:"font-stretch",fontStyle:"font-style",fontVariant:"font-variant",fontWeight:"font-weight",format:0,from:0,fx:0,fy:0,g1:0,g2:0,glyphName:"glyph-name",glyphOrientationHorizontal:"glyph-orientation-horizontal",glyphOrientationVertical:"glyph-orientation-vertical",glyphRef:"glyphRef",gradientTransform:"gradientTransform",gradientUnits:"gradientUnits",hanging:0,horizAdvX:"horiz-adv-x",horizOriginX:"horiz-origin-x",ideographic:0,imageRendering:"image-rendering",in:0,in2:0,intercept:0,k:0,k1:0,k2:0,k3:0,k4:0,kernelMatrix:"kernelMatrix",kernelUnitLength:"kernelUnitLength",kerning:0,keyPoints:"keyPoints",keySplines:"keySplines",keyTimes:"keyTimes",lengthAdjust:"lengthAdjust",letterSpacing:"letter-spacing",lightingColor:"lighting-color",limitingConeAngle:"limitingConeAngle",local:0,markerEnd:"marker-end",markerMid:"marker-mid",markerStart:"marker-start",markerHeight:"markerHeight",markerUnits:"markerUnits",markerWidth:"markerWidth",mask:0,maskContentUnits:"maskContentUnits",maskUnits:"maskUnits",mathematical:0,mode:0,numOctaves:"numOctaves",offset:0,opacity:0,operator:0,order:0,orient:0,orientation:0,origin:0,overflow:0,overlinePosition:"overline-position",overlineThickness:"overline-thickness",paintOrder:"paint-order",panose1:"panose-1",pathLength:"pathLength",patternContentUnits:"patternContentUnits",patternTransform:"patternTransform",patternUnits:"patternUnits",pointerEvents:"pointer-events",points:0,pointsAtX:"pointsAtX",pointsAtY:"pointsAtY",pointsAtZ:"pointsAtZ",preserveAlpha:"preserveAlpha",preserveAspectRatio:"preserveAspectRatio",primitiveUnits:"primitiveUnits",r:0,radius:0,refX:"refX",refY:"refY",renderingIntent:"rendering-intent",repeatCount:"repeatCount",repeatDur:"repeatDur",requiredExtensions:"requiredExtensions",requiredFeatures:"requiredFeatures",restart:0,result:0,rotate:0,rx:0,ry:0,scale:0,seed:0,shapeRendering:"shape-rendering",slope:0,spacing:0,specularConstant:"specularConstant",specularExponent:"specularExponent",speed:0,spreadMethod:"spreadMethod",startOffset:"startOffset",stdDeviation:"stdDeviation",stemh:0,stemv:0,stitchTiles:"stitchTiles",stopColor:"stop-color",stopOpacity:"stop-opacity",strikethroughPosition:"strikethrough-position",strikethroughThickness:"strikethrough-thickness",string:0,stroke:0,strokeDasharray:"stroke-dasharray",strokeDashoffset:"stroke-dashoffset",strokeLinecap:"stroke-linecap",strokeLinejoin:"stroke-linejoin",strokeMiterlimit:"stroke-miterlimit",strokeOpacity:"stroke-opacity",strokeWidth:"stroke-width",surfaceScale:"surfaceScale",systemLanguage:"systemLanguage",tableValues:"tableValues",targetX:"targetX",targetY:"targetY",textAnchor:"text-anchor",textDecoration:"text-decoration",textRendering:"text-rendering",textLength:"textLength",to:0,transform:0,u1:0,u2:0,underlinePosition:"underline-position",underlineThickness:"underline-thickness",unicode:0,unicodeBidi:"unicode-bidi",unicodeRange:"unicode-range",unitsPerEm:"units-per-em",vAlphabetic:"v-alphabetic",vHanging:"v-hanging",vIdeographic:"v-ideographic",vMathematical:"v-mathematical",values:0,vectorEffect:"vector-effect",version:0,vertAdvY:"vert-adv-y",vertOriginX:"vert-origin-x",vertOriginY:"vert-origin-y",viewBox:"viewBox",viewTarget:"viewTarget",visibility:0,widths:0,wordSpacing:"word-spacing",writingMode:"writing-mode",x:0,xHeight:"x-height",x1:0,x2:0,xChannelSelector:"xChannelSelector",xlinkActuate:"xlink:actuate",xlinkArcrole:"xlink:arcrole",xlinkHref:"xlink:href",xlinkRole:"xlink:role",xlinkShow:"xlink:show",xlinkTitle:"xlink:title",xlinkType:"xlink:type",xmlBase:"xml:base",xmlns:0,xmlnsXlink:"xmlns:xlink",xmlLang:"xml:lang",xmlSpace:"xml:space",y:0,y1:0,y2:0,yChannelSelector:"yChannelSelector",z:0,zoomAndPan:"zoomAndPan"};var SVGDOMPropertyConfig={Properties:{},DOMAttributeNamespaces:{xlinkActuate:NS.xlink,xlinkArcrole:NS.xlink,xlinkHref:NS.xlink,xlinkRole:NS.xlink,xlinkShow:NS.xlink,xlinkTitle:NS.xlink,xlinkType:NS.xlink,xmlBase:NS.xml,xmlLang:NS.xml,xmlSpace:NS.xml},DOMAttributeNames:{}};Object.keys(ATTRS).forEach(function(key){SVGDOMPropertyConfig.Properties[key]=0;if(ATTRS[key]){SVGDOMPropertyConfig.DOMAttributeNames[key]=ATTRS[key]}});module.exports=SVGDOMPropertyConfig},{}],111:[function(require,module,exports){"use strict";var EventPropagators=require("./EventPropagators");var ExecutionEnvironment=require("fbjs/lib/ExecutionEnvironment");var ReactDOMComponentTree=require("./ReactDOMComponentTree");var ReactInputSelection=require("./ReactInputSelection");var SyntheticEvent=require("./SyntheticEvent");var getActiveElement=require("fbjs/lib/getActiveElement");var isTextInputElement=require("./isTextInputElement");var shallowEqual=require("fbjs/lib/shallowEqual");var skipSelectionChangeEvent=ExecutionEnvironment.canUseDOM&&"documentMode"in document&&document.documentMode<=11;var eventTypes={select:{phasedRegistrationNames:{bubbled:"onSelect",captured:"onSelectCapture"},dependencies:["topBlur","topContextMenu","topFocus","topKeyDown","topKeyUp","topMouseDown","topMouseUp","topSelectionChange"]}};var activeElement=null;var activeElementInst=null;var lastSelection=null;var mouseDown=false;var hasListener=false;function getSelection(node){if("selectionStart"in node&&ReactInputSelection.hasSelectionCapabilities(node)){return{start:node.selectionStart,end:node.selectionEnd}}else if(window.getSelection){var selection=window.getSelection();return{anchorNode:selection.anchorNode,anchorOffset:selection.anchorOffset,focusNode:selection.focusNode,focusOffset:selection.focusOffset}}else if(document.selection){var range=document.selection.createRange();return{parentElement:range.parentElement(),text:range.text,top:range.boundingTop,left:range.boundingLeft}}}function constructSelectEvent(nativeEvent,nativeEventTarget){if(mouseDown||activeElement==null||activeElement!==getActiveElement()){return null}var currentSelection=getSelection(activeElement);if(!lastSelection||!shallowEqual(lastSelection,currentSelection)){lastSelection=currentSelection;var syntheticEvent=SyntheticEvent.getPooled(eventTypes.select,activeElementInst,nativeEvent,nativeEventTarget);syntheticEvent.type="select";syntheticEvent.target=activeElement;EventPropagators.accumulateTwoPhaseDispatches(syntheticEvent);return syntheticEvent}return null}var SelectEventPlugin={eventTypes:eventTypes,extractEvents:function(topLevelType,targetInst,nativeEvent,nativeEventTarget){if(!hasListener){return null}var targetNode=targetInst?ReactDOMComponentTree.getNodeFromInstance(targetInst):window;switch(topLevelType){case"topFocus":if(isTextInputElement(targetNode)||targetNode.contentEditable==="true"){activeElement=targetNode;activeElementInst=targetInst;lastSelection=null}break;case"topBlur":activeElement=null;activeElementInst=null;lastSelection=null;break;case"topMouseDown":mouseDown=true;break;case"topContextMenu":case"topMouseUp":mouseDown=false;return constructSelectEvent(nativeEvent,nativeEventTarget);case"topSelectionChange":if(skipSelectionChangeEvent){break}case"topKeyDown":case"topKeyUp":return constructSelectEvent(nativeEvent,nativeEventTarget)}return null},didPutListener:function(inst,registrationName,listener){if(registrationName==="onSelect"){hasListener=true}}};module.exports=SelectEventPlugin},{"./EventPropagators":50,"./ReactDOMComponentTree":64,"./ReactInputSelection":91,"./SyntheticEvent":117,"./isTextInputElement":149,"fbjs/lib/ExecutionEnvironment":4,"fbjs/lib/getActiveElement":13,"fbjs/lib/shallowEqual":24}],112:[function(require,module,exports){(function(process){"use strict";var _prodInvariant=require("./reactProdInvariant");var EventListener=require("fbjs/lib/EventListener");var EventPropagators=require("./EventPropagators");var ReactDOMComponentTree=require("./ReactDOMComponentTree");var SyntheticAnimationEvent=require("./SyntheticAnimationEvent");var SyntheticClipboardEvent=require("./SyntheticClipboardEvent");var SyntheticEvent=require("./SyntheticEvent");var SyntheticFocusEvent=require("./SyntheticFocusEvent");var SyntheticKeyboardEvent=require("./SyntheticKeyboardEvent");var SyntheticMouseEvent=require("./SyntheticMouseEvent");var SyntheticDragEvent=require("./SyntheticDragEvent");var SyntheticTouchEvent=require("./SyntheticTouchEvent");var SyntheticTransitionEvent=require("./SyntheticTransitionEvent");var SyntheticUIEvent=require("./SyntheticUIEvent");var SyntheticWheelEvent=require("./SyntheticWheelEvent");var emptyFunction=require("fbjs/lib/emptyFunction");var getEventCharCode=require("./getEventCharCode");var invariant=require("fbjs/lib/invariant");var eventTypes={};var topLevelEventsToDispatchConfig={};["abort","animationEnd","animationIteration","animationStart","blur","canPlay","canPlayThrough","click","contextMenu","copy","cut","doubleClick","drag","dragEnd","dragEnter","dragExit","dragLeave","dragOver","dragStart","drop","durationChange","emptied","encrypted","ended","error","focus","input","invalid","keyDown","keyPress","keyUp","load","loadedData","loadedMetadata","loadStart","mouseDown","mouseMove","mouseOut","mouseOver","mouseUp","paste","pause","play","playing","progress","rateChange","reset","scroll","seeked","seeking","stalled","submit","suspend","timeUpdate","touchCancel","touchEnd","touchMove","touchStart","transitionEnd","volumeChange","waiting","wheel"].forEach(function(event){var capitalizedEvent=event[0].toUpperCase()+event.slice(1);var onEvent="on"+capitalizedEvent;var topEvent="top"+capitalizedEvent;var type={phasedRegistrationNames:{bubbled:onEvent,captured:onEvent+"Capture"},dependencies:[topEvent]};eventTypes[event]=type;topLevelEventsToDispatchConfig[topEvent]=type});var onClickListeners={};function getDictionaryKey(inst){return"."+inst._rootNodeID}function isInteractive(tag){return tag==="button"||tag==="input"||tag==="select"||tag==="textarea"}var SimpleEventPlugin={eventTypes:eventTypes,extractEvents:function(topLevelType,targetInst,nativeEvent,nativeEventTarget){var dispatchConfig=topLevelEventsToDispatchConfig[topLevelType];if(!dispatchConfig){return null}var EventConstructor;switch(topLevelType){case"topAbort":case"topCanPlay":case"topCanPlayThrough":case"topDurationChange":case"topEmptied":case"topEncrypted":case"topEnded":case"topError":case"topInput":case"topInvalid":case"topLoad":case"topLoadedData":case"topLoadedMetadata":case"topLoadStart":case"topPause":case"topPlay":case"topPlaying":case"topProgress":case"topRateChange":case"topReset":case"topSeeked":case"topSeeking":case"topStalled":case"topSubmit":case"topSuspend":case"topTimeUpdate":case"topVolumeChange":case"topWaiting":EventConstructor=SyntheticEvent;break;case"topKeyPress":if(getEventCharCode(nativeEvent)===0){return null}case"topKeyDown":case"topKeyUp":EventConstructor=SyntheticKeyboardEvent;break;case"topBlur":case"topFocus":EventConstructor=SyntheticFocusEvent;break;case"topClick":if(nativeEvent.button===2){return null}case"topDoubleClick":case"topMouseDown":case"topMouseMove":case"topMouseUp":case"topMouseOut":case"topMouseOver":case"topContextMenu":EventConstructor=SyntheticMouseEvent;break;case"topDrag":case"topDragEnd":case"topDragEnter":case"topDragExit":case"topDragLeave":case"topDragOver":case"topDragStart":case"topDrop":EventConstructor=SyntheticDragEvent;break;case"topTouchCancel":case"topTouchEnd":case"topTouchMove":case"topTouchStart":EventConstructor=SyntheticTouchEvent;break;case"topAnimationEnd":case"topAnimationIteration":case"topAnimationStart":EventConstructor=SyntheticAnimationEvent;break;case"topTransitionEnd":EventConstructor=SyntheticTransitionEvent;break;case"topScroll":EventConstructor=SyntheticUIEvent;break;case"topWheel":EventConstructor=SyntheticWheelEvent;break;case"topCopy":case"topCut":case"topPaste":EventConstructor=SyntheticClipboardEvent;break}!EventConstructor?process.env.NODE_ENV!=="production"?invariant(false,"SimpleEventPlugin: Unhandled event type, `%s`.",topLevelType):_prodInvariant("86",topLevelType):void 0;var event=EventConstructor.getPooled(dispatchConfig,targetInst,nativeEvent,nativeEventTarget);EventPropagators.accumulateTwoPhaseDispatches(event);return event},didPutListener:function(inst,registrationName,listener){if(registrationName==="onClick"&&!isInteractive(inst._tag)){var key=getDictionaryKey(inst);var node=ReactDOMComponentTree.getNodeFromInstance(inst);if(!onClickListeners[key]){onClickListeners[key]=EventListener.listen(node,"click",emptyFunction)}}},willDeleteListener:function(inst,registrationName){if(registrationName==="onClick"&&!isInteractive(inst._tag)){var key=getDictionaryKey(inst);onClickListeners[key].remove();delete onClickListeners[key]}}};module.exports=SimpleEventPlugin}).call(this,require("_process"))},{"./EventPropagators":50,"./ReactDOMComponentTree":64,"./SyntheticAnimationEvent":113,"./SyntheticClipboardEvent":114,"./SyntheticDragEvent":116,"./SyntheticEvent":117,"./SyntheticFocusEvent":118,"./SyntheticKeyboardEvent":120,"./SyntheticMouseEvent":121,"./SyntheticTouchEvent":122,"./SyntheticTransitionEvent":123,"./SyntheticUIEvent":124,"./SyntheticWheelEvent":125,"./getEventCharCode":137,"./reactProdInvariant":151,_process:184,"fbjs/lib/EventListener":3,"fbjs/lib/emptyFunction":10,"fbjs/lib/invariant":18}],113:[function(require,module,exports){"use strict";var SyntheticEvent=require("./SyntheticEvent");var AnimationEventInterface={animationName:null,elapsedTime:null,pseudoElement:null};function SyntheticAnimationEvent(dispatchConfig,dispatchMarker,nativeEvent,nativeEventTarget){return SyntheticEvent.call(this,dispatchConfig,dispatchMarker,nativeEvent,nativeEventTarget)}SyntheticEvent.augmentClass(SyntheticAnimationEvent,AnimationEventInterface);module.exports=SyntheticAnimationEvent},{"./SyntheticEvent":117}],114:[function(require,module,exports){"use strict";var SyntheticEvent=require("./SyntheticEvent");var ClipboardEventInterface={clipboardData:function(event){return"clipboardData"in event?event.clipboardData:window.clipboardData}};function SyntheticClipboardEvent(dispatchConfig,dispatchMarker,nativeEvent,nativeEventTarget){return SyntheticEvent.call(this,dispatchConfig,dispatchMarker,nativeEvent,nativeEventTarget)}SyntheticEvent.augmentClass(SyntheticClipboardEvent,ClipboardEventInterface);module.exports=SyntheticClipboardEvent},{"./SyntheticEvent":117}],115:[function(require,module,exports){"use strict";var SyntheticEvent=require("./SyntheticEvent");var CompositionEventInterface={data:null};function SyntheticCompositionEvent(dispatchConfig,dispatchMarker,nativeEvent,nativeEventTarget){return SyntheticEvent.call(this,dispatchConfig,dispatchMarker,nativeEvent,nativeEventTarget)}SyntheticEvent.augmentClass(SyntheticCompositionEvent,CompositionEventInterface);module.exports=SyntheticCompositionEvent},{"./SyntheticEvent":117}],116:[function(require,module,exports){"use strict";var SyntheticMouseEvent=require("./SyntheticMouseEvent");var DragEventInterface={dataTransfer:null};function SyntheticDragEvent(dispatchConfig,dispatchMarker,nativeEvent,nativeEventTarget){return SyntheticMouseEvent.call(this,dispatchConfig,dispatchMarker,nativeEvent,nativeEventTarget)}SyntheticMouseEvent.augmentClass(SyntheticDragEvent,DragEventInterface);module.exports=SyntheticDragEvent},{"./SyntheticMouseEvent":121}],117:[function(require,module,exports){(function(process){"use strict";var _assign=require("object-assign");var PooledClass=require("./PooledClass");var emptyFunction=require("fbjs/lib/emptyFunction");var warning=require("fbjs/lib/warning");var didWarnForAddedNewProperty=false;var isProxySupported=typeof Proxy==="function";var shouldBeReleasedProperties=["dispatchConfig","_targetInst","nativeEvent","isDefaultPrevented","isPropagationStopped","_dispatchListeners","_dispatchInstances"];var EventInterface={type:null,target:null,currentTarget:emptyFunction.thatReturnsNull,eventPhase:null,bubbles:null,cancelable:null,timeStamp:function(event){return event.timeStamp||Date.now()},defaultPrevented:null,isTrusted:null};function SyntheticEvent(dispatchConfig,targetInst,nativeEvent,nativeEventTarget){if(process.env.NODE_ENV!=="production"){delete this.nativeEvent;delete this.preventDefault;delete this.stopPropagation}this.dispatchConfig=dispatchConfig;this._targetInst=targetInst;this.nativeEvent=nativeEvent;var Interface=this.constructor.Interface;for(var propName in Interface){if(!Interface.hasOwnProperty(propName)){continue}if(process.env.NODE_ENV!=="production"){delete this[propName]}var normalize=Interface[propName];if(normalize){this[propName]=normalize(nativeEvent)}else{if(propName==="target"){this.target=nativeEventTarget}else{this[propName]=nativeEvent[propName]}}}var defaultPrevented=nativeEvent.defaultPrevented!=null?nativeEvent.defaultPrevented:nativeEvent.returnValue===false;if(defaultPrevented){this.isDefaultPrevented=emptyFunction.thatReturnsTrue}else{this.isDefaultPrevented=emptyFunction.thatReturnsFalse}this.isPropagationStopped=emptyFunction.thatReturnsFalse;return this}_assign(SyntheticEvent.prototype,{preventDefault:function(){this.defaultPrevented=true;var event=this.nativeEvent;if(!event){return}if(event.preventDefault){event.preventDefault()}else if(typeof event.returnValue!=="unknown"){event.returnValue=false}this.isDefaultPrevented=emptyFunction.thatReturnsTrue},stopPropagation:function(){var event=this.nativeEvent;if(!event){return}if(event.stopPropagation){event.stopPropagation()}else if(typeof event.cancelBubble!=="unknown"){event.cancelBubble=true}this.isPropagationStopped=emptyFunction.thatReturnsTrue},persist:function(){this.isPersistent=emptyFunction.thatReturnsTrue},isPersistent:emptyFunction.thatReturnsFalse,destructor:function(){var Interface=this.constructor.Interface;for(var propName in Interface){if(process.env.NODE_ENV!=="production"){Object.defineProperty(this,propName,getPooledWarningPropertyDefinition(propName,Interface[propName]))}else{this[propName]=null}}for(var i=0;i<shouldBeReleasedProperties.length;i++){this[shouldBeReleasedProperties[i]]=null}if(process.env.NODE_ENV!=="production"){Object.defineProperty(this,"nativeEvent",getPooledWarningPropertyDefinition("nativeEvent",null));Object.defineProperty(this,"preventDefault",getPooledWarningPropertyDefinition("preventDefault",emptyFunction));Object.defineProperty(this,"stopPropagation",getPooledWarningPropertyDefinition("stopPropagation",emptyFunction))}}});SyntheticEvent.Interface=EventInterface;if(process.env.NODE_ENV!=="production"){if(isProxySupported){SyntheticEvent=new Proxy(SyntheticEvent,{construct:function(target,args){return this.apply(target,Object.create(target.prototype),args)},apply:function(constructor,that,args){return new Proxy(constructor.apply(that,args),{set:function(target,prop,value){if(prop!=="isPersistent"&&!target.constructor.Interface.hasOwnProperty(prop)&&shouldBeReleasedProperties.indexOf(prop)===-1){process.env.NODE_ENV!=="production"?warning(didWarnForAddedNewProperty||target.isPersistent(),"This synthetic event is reused for performance reasons. If you're "+"seeing this, you're adding a new property in the synthetic event object. "+"The property is never released. See "+"https://fb.me/react-event-pooling for more information."):void 0;didWarnForAddedNewProperty=true}target[prop]=value;return true}})}})}}SyntheticEvent.augmentClass=function(Class,Interface){var Super=this;var E=function(){};E.prototype=Super.prototype;var prototype=new E;_assign(prototype,Class.prototype);Class.prototype=prototype;Class.prototype.constructor=Class;Class.Interface=_assign({},Super.Interface,Interface);Class.augmentClass=Super.augmentClass;PooledClass.addPoolingTo(Class,PooledClass.fourArgumentPooler)};PooledClass.addPoolingTo(SyntheticEvent,PooledClass.fourArgumentPooler);module.exports=SyntheticEvent;function getPooledWarningPropertyDefinition(propName,getVal){var isFunction=typeof getVal==="function";return{configurable:true,set:set,get:get};function set(val){var action=isFunction?"setting the method":"setting the property";warn(action,"This is effectively a no-op");return val}function get(){var action=isFunction?"accessing the method":"accessing the property";var result=isFunction?"This is a no-op function":"This is set to null";warn(action,result);return getVal}function warn(action,result){var warningCondition=false;process.env.NODE_ENV!=="production"?warning(warningCondition,"This synthetic event is reused for performance reasons. If you're seeing this, "+"you're %s `%s` on a released/nullified synthetic event. %s. "+"If you must keep the original synthetic event around, use event.persist(). "+"See https://fb.me/react-event-pooling for more information.",action,propName,result):void 0}}}).call(this,require("_process"))},{"./PooledClass":55,_process:184,"fbjs/lib/emptyFunction":10,"fbjs/lib/warning":25,"object-assign":26}],118:[function(require,module,exports){"use strict";var SyntheticUIEvent=require("./SyntheticUIEvent");var FocusEventInterface={relatedTarget:null};function SyntheticFocusEvent(dispatchConfig,dispatchMarker,nativeEvent,nativeEventTarget){return SyntheticUIEvent.call(this,dispatchConfig,dispatchMarker,nativeEvent,nativeEventTarget)}SyntheticUIEvent.augmentClass(SyntheticFocusEvent,FocusEventInterface);module.exports=SyntheticFocusEvent},{"./SyntheticUIEvent":124}],119:[function(require,module,exports){"use strict";var SyntheticEvent=require("./SyntheticEvent");var InputEventInterface={data:null};function SyntheticInputEvent(dispatchConfig,dispatchMarker,nativeEvent,nativeEventTarget){return SyntheticEvent.call(this,dispatchConfig,dispatchMarker,nativeEvent,nativeEventTarget)}SyntheticEvent.augmentClass(SyntheticInputEvent,InputEventInterface);module.exports=SyntheticInputEvent},{"./SyntheticEvent":117}],120:[function(require,module,exports){"use strict";var SyntheticUIEvent=require("./SyntheticUIEvent");var getEventCharCode=require("./getEventCharCode");var getEventKey=require("./getEventKey");var getEventModifierState=require("./getEventModifierState");var KeyboardEventInterface={key:getEventKey,location:null,ctrlKey:null,shiftKey:null,altKey:null,metaKey:null,repeat:null,locale:null,getModifierState:getEventModifierState,charCode:function(event){if(event.type==="keypress"){return getEventCharCode(event)}return 0},keyCode:function(event){if(event.type==="keydown"||event.type==="keyup"){return event.keyCode}return 0},which:function(event){if(event.type==="keypress"){return getEventCharCode(event)}if(event.type==="keydown"||event.type==="keyup"){return event.keyCode}return 0}};function SyntheticKeyboardEvent(dispatchConfig,dispatchMarker,nativeEvent,nativeEventTarget){return SyntheticUIEvent.call(this,dispatchConfig,dispatchMarker,nativeEvent,nativeEventTarget)}SyntheticUIEvent.augmentClass(SyntheticKeyboardEvent,KeyboardEventInterface);module.exports=SyntheticKeyboardEvent},{"./SyntheticUIEvent":124,"./getEventCharCode":137,"./getEventKey":138,"./getEventModifierState":139}],121:[function(require,module,exports){"use strict";var SyntheticUIEvent=require("./SyntheticUIEvent");var ViewportMetrics=require("./ViewportMetrics");var getEventModifierState=require("./getEventModifierState");var MouseEventInterface={screenX:null,screenY:null,clientX:null,clientY:null,ctrlKey:null,shiftKey:null,altKey:null,metaKey:null,getModifierState:getEventModifierState,button:function(event){var button=event.button;if("which"in event){return button}return button===2?2:button===4?1:0},buttons:null,relatedTarget:function(event){return event.relatedTarget||(event.fromElement===event.srcElement?event.toElement:event.fromElement)},pageX:function(event){return"pageX"in event?event.pageX:event.clientX+ViewportMetrics.currentScrollLeft},pageY:function(event){return"pageY"in event?event.pageY:event.clientY+ViewportMetrics.currentScrollTop}};function SyntheticMouseEvent(dispatchConfig,dispatchMarker,nativeEvent,nativeEventTarget){return SyntheticUIEvent.call(this,dispatchConfig,dispatchMarker,nativeEvent,nativeEventTarget)}SyntheticUIEvent.augmentClass(SyntheticMouseEvent,MouseEventInterface);module.exports=SyntheticMouseEvent},{"./SyntheticUIEvent":124,"./ViewportMetrics":127,"./getEventModifierState":139}],122:[function(require,module,exports){"use strict";var SyntheticUIEvent=require("./SyntheticUIEvent");var getEventModifierState=require("./getEventModifierState");var TouchEventInterface={touches:null,targetTouches:null,changedTouches:null,altKey:null,metaKey:null,ctrlKey:null,shiftKey:null,getModifierState:getEventModifierState};function SyntheticTouchEvent(dispatchConfig,dispatchMarker,nativeEvent,nativeEventTarget){return SyntheticUIEvent.call(this,dispatchConfig,dispatchMarker,nativeEvent,nativeEventTarget)}SyntheticUIEvent.augmentClass(SyntheticTouchEvent,TouchEventInterface);module.exports=SyntheticTouchEvent},{"./SyntheticUIEvent":124,"./getEventModifierState":139}],123:[function(require,module,exports){"use strict";var SyntheticEvent=require("./SyntheticEvent");var TransitionEventInterface={propertyName:null,elapsedTime:null,pseudoElement:null};function SyntheticTransitionEvent(dispatchConfig,dispatchMarker,nativeEvent,nativeEventTarget){return SyntheticEvent.call(this,dispatchConfig,dispatchMarker,nativeEvent,nativeEventTarget)}SyntheticEvent.augmentClass(SyntheticTransitionEvent,TransitionEventInterface);module.exports=SyntheticTransitionEvent},{"./SyntheticEvent":117}],124:[function(require,module,exports){"use strict";var SyntheticEvent=require("./SyntheticEvent");var getEventTarget=require("./getEventTarget");var UIEventInterface={view:function(event){if(event.view){return event.view}var target=getEventTarget(event);if(target.window===target){return target}var doc=target.ownerDocument;if(doc){return doc.defaultView||doc.parentWindow}else{return window}},detail:function(event){return event.detail||0}};function SyntheticUIEvent(dispatchConfig,dispatchMarker,nativeEvent,nativeEventTarget){return SyntheticEvent.call(this,dispatchConfig,dispatchMarker,nativeEvent,nativeEventTarget)}SyntheticEvent.augmentClass(SyntheticUIEvent,UIEventInterface);module.exports=SyntheticUIEvent},{"./SyntheticEvent":117,"./getEventTarget":140}],125:[function(require,module,exports){"use strict";var SyntheticMouseEvent=require("./SyntheticMouseEvent");var WheelEventInterface={deltaX:function(event){return"deltaX"in event?event.deltaX:"wheelDeltaX"in event?-event.wheelDeltaX:0},deltaY:function(event){return"deltaY"in event?event.deltaY:"wheelDeltaY"in event?-event.wheelDeltaY:"wheelDelta"in event?-event.wheelDelta:0},deltaZ:null,deltaMode:null};function SyntheticWheelEvent(dispatchConfig,dispatchMarker,nativeEvent,nativeEventTarget){return SyntheticMouseEvent.call(this,dispatchConfig,dispatchMarker,nativeEvent,nativeEventTarget)}SyntheticMouseEvent.augmentClass(SyntheticWheelEvent,WheelEventInterface);module.exports=SyntheticWheelEvent},{"./SyntheticMouseEvent":121}],126:[function(require,module,exports){(function(process){"use strict";var _prodInvariant=require("./reactProdInvariant");var invariant=require("fbjs/lib/invariant");var OBSERVED_ERROR={};var TransactionImpl={reinitializeTransaction:function(){this.transactionWrappers=this.getTransactionWrappers();if(this.wrapperInitData){this.wrapperInitData.length=0}else{this.wrapperInitData=[]}this._isInTransaction=false},_isInTransaction:false,getTransactionWrappers:null,isInTransaction:function(){return!!this._isInTransaction},perform:function(method,scope,a,b,c,d,e,f){!!this.isInTransaction()?process.env.NODE_ENV!=="production"?invariant(false,"Transaction.perform(...): Cannot initialize a transaction when there is already an outstanding transaction."):_prodInvariant("27"):void 0;var errorThrown;var ret;try{this._isInTransaction=true;errorThrown=true;this.initializeAll(0);ret=method.call(scope,a,b,c,d,e,f);errorThrown=false}finally{try{if(errorThrown){try{this.closeAll(0)}catch(err){}}else{this.closeAll(0)}}finally{this._isInTransaction=false}}return ret},initializeAll:function(startIndex){var transactionWrappers=this.transactionWrappers;for(var i=startIndex;i<transactionWrappers.length;i++){var wrapper=transactionWrappers[i];try{this.wrapperInitData[i]=OBSERVED_ERROR;this.wrapperInitData[i]=wrapper.initialize?wrapper.initialize.call(this):null}finally{if(this.wrapperInitData[i]===OBSERVED_ERROR){try{this.initializeAll(i+1)}catch(err){}}}}},closeAll:function(startIndex){!this.isInTransaction()?process.env.NODE_ENV!=="production"?invariant(false,"Transaction.closeAll(): Cannot close transaction when none are open."):_prodInvariant("28"):void 0;var transactionWrappers=this.transactionWrappers;for(var i=startIndex;i<transactionWrappers.length;i++){var wrapper=transactionWrappers[i];var initData=this.wrapperInitData[i];var errorThrown;try{errorThrown=true;if(initData!==OBSERVED_ERROR&&wrapper.close){wrapper.close.call(this,initData)}errorThrown=false}finally{if(errorThrown){try{this.closeAll(i+1)}catch(e){}}}}this.wrapperInitData.length=0}};module.exports=TransactionImpl}).call(this,require("_process"))},{"./reactProdInvariant":151,_process:184,"fbjs/lib/invariant":18}],127:[function(require,module,exports){"use strict";var ViewportMetrics={currentScrollLeft:0,currentScrollTop:0,refreshScrollValues:function(scrollPosition){ViewportMetrics.currentScrollLeft=scrollPosition.x;ViewportMetrics.currentScrollTop=scrollPosition.y}};module.exports=ViewportMetrics},{}],128:[function(require,module,exports){(function(process){"use strict";var _prodInvariant=require("./reactProdInvariant");var invariant=require("fbjs/lib/invariant");function accumulateInto(current,next){!(next!=null)?process.env.NODE_ENV!=="production"?invariant(false,"accumulateInto(...): Accumulated items must not be null or undefined."):_prodInvariant("30"):void 0;if(current==null){return next}if(Array.isArray(current)){if(Array.isArray(next)){current.push.apply(current,next);return current}current.push(next);return current}if(Array.isArray(next)){return[current].concat(next)}return[current,next]}module.exports=accumulateInto}).call(this,require("_process"))},{"./reactProdInvariant":151,_process:184,"fbjs/lib/invariant":18}],129:[function(require,module,exports){"use strict";var MOD=65521;function adler32(data){var a=1;var b=0;var i=0;var l=data.length;var m=l&~3;while(i<m){var n=Math.min(i+4096,m);for(;i<n;i+=4){b+=(a+=data.charCodeAt(i))+(a+=data.charCodeAt(i+1))+(a+=data.charCodeAt(i+2))+(a+=data.charCodeAt(i+3))}a%=MOD;b%=MOD}for(;i<l;i++){b+=a+=data.charCodeAt(i)}a%=MOD;b%=MOD;return a|b<<16}module.exports=adler32},{}],130:[function(require,module,exports){(function(process){"use strict";var _prodInvariant=require("./reactProdInvariant");var ReactPropTypeLocationNames=require("./ReactPropTypeLocationNames");var ReactPropTypesSecret=require("./ReactPropTypesSecret");var invariant=require("fbjs/lib/invariant");var warning=require("fbjs/lib/warning");var ReactComponentTreeHook;if(typeof process!=="undefined"&&process.env&&process.env.NODE_ENV==="test"){ReactComponentTreeHook=require("react/lib/ReactComponentTreeHook")}var loggedTypeFailures={};function checkReactTypeSpec(typeSpecs,values,location,componentName,element,debugID){for(var typeSpecName in typeSpecs){if(typeSpecs.hasOwnProperty(typeSpecName)){var error;try{!(typeof typeSpecs[typeSpecName]==="function")?process.env.NODE_ENV!=="production"?invariant(false,"%s: %s type `%s` is invalid; it must be a function, usually from React.PropTypes.",componentName||"React class",ReactPropTypeLocationNames[location],typeSpecName):_prodInvariant("84",componentName||"React class",ReactPropTypeLocationNames[location],typeSpecName):void 0;error=typeSpecs[typeSpecName](values,typeSpecName,componentName,location,null,ReactPropTypesSecret)}catch(ex){error=ex}process.env.NODE_ENV!=="production"?warning(!error||error instanceof Error,"%s: type specification of %s `%s` is invalid; the type checker "+"function must return `null` or an `Error` but returned a %s. "+"You may have forgotten to pass an argument to the type checker "+"creator (arrayOf, instanceOf, objectOf, oneOf, oneOfType, and "+"shape all require an argument).",componentName||"React class",ReactPropTypeLocationNames[location],typeSpecName,typeof error):void 0;if(error instanceof Error&&!(error.message in loggedTypeFailures)){loggedTypeFailures[error.message]=true;var componentStackInfo="";if(process.env.NODE_ENV!=="production"){if(!ReactComponentTreeHook){ReactComponentTreeHook=require("react/lib/ReactComponentTreeHook")}if(debugID!==null){componentStackInfo=ReactComponentTreeHook.getStackAddendumByID(debugID)}else if(element!==null){componentStackInfo=ReactComponentTreeHook.getCurrentStackAddendum(element)}}process.env.NODE_ENV!=="production"?warning(false,"Failed %s type: %s%s",location,error.message,componentStackInfo):void 0}}}}module.exports=checkReactTypeSpec}).call(this,require("_process"))},{"./ReactPropTypeLocationNames":100,"./ReactPropTypesSecret":101,"./reactProdInvariant":151,_process:184,"fbjs/lib/invariant":18,"fbjs/lib/warning":25,"react/lib/ReactComponentTreeHook":163}],131:[function(require,module,exports){"use strict";var createMicrosoftUnsafeLocalFunction=function(func){if(typeof MSApp!=="undefined"&&MSApp.execUnsafeLocalFunction){return function(arg0,arg1,arg2,arg3){MSApp.execUnsafeLocalFunction(function(){return func(arg0,arg1,arg2,arg3)})}}else{return func}};module.exports=createMicrosoftUnsafeLocalFunction},{}],132:[function(require,module,exports){(function(process){"use strict";var CSSProperty=require("./CSSProperty");var warning=require("fbjs/lib/warning");var isUnitlessNumber=CSSProperty.isUnitlessNumber;var styleWarnings={};function dangerousStyleValue(name,value,component,isCustomProperty){var isEmpty=value==null||typeof value==="boolean"||value==="";if(isEmpty){return""}var isNonNumeric=isNaN(value);if(isCustomProperty||isNonNumeric||value===0||isUnitlessNumber.hasOwnProperty(name)&&isUnitlessNumber[name]){return""+value}if(typeof value==="string"){if(process.env.NODE_ENV!=="production"){if(component&&value!=="0"){var owner=component._currentElement._owner;var ownerName=owner?owner.getName():null;if(ownerName&&!styleWarnings[ownerName]){styleWarnings[ownerName]={}}var warned=false;if(ownerName){var warnings=styleWarnings[ownerName];warned=warnings[name];if(!warned){warnings[name]=true}}if(!warned){process.env.NODE_ENV!=="production"?warning(false,"a `%s` tag (owner: `%s`) was passed a numeric string value "+"for CSS property `%s` (value: `%s`) which will be treated "+"as a unitless number in a future version of React.",component._currentElement.type,ownerName||"unknown",name,value):void 0}}}value=value.trim()}return value+"px"}module.exports=dangerousStyleValue}).call(this,require("_process"))},{"./CSSProperty":35,_process:184,"fbjs/lib/warning":25}],133:[function(require,module,exports){"use strict";var matchHtmlRegExp=/["'&<>]/;function escapeHtml(string){var str=""+string;var match=matchHtmlRegExp.exec(str);if(!match){return str}var escape;var html="";var index=0;var lastIndex=0;for(index=match.index;index<str.length;index++){switch(str.charCodeAt(index)){case 34:escape="&quot;";break;case 38:escape="&amp;";break;case 39:escape="&#x27;";break;case 60:escape="&lt;";break;case 62:escape="&gt;";break;default:continue}if(lastIndex!==index){html+=str.substring(lastIndex,index)}lastIndex=index+1;html+=escape}return lastIndex!==index?html+str.substring(lastIndex,index):html}function escapeTextContentForBrowser(text){if(typeof text==="boolean"||typeof text==="number"){return""+text}return escapeHtml(text)}module.exports=escapeTextContentForBrowser},{}],134:[function(require,module,exports){(function(process){"use strict";var _prodInvariant=require("./reactProdInvariant");var ReactCurrentOwner=require("react/lib/ReactCurrentOwner");var ReactDOMComponentTree=require("./ReactDOMComponentTree");var ReactInstanceMap=require("./ReactInstanceMap");var getHostComponentFromComposite=require("./getHostComponentFromComposite");var invariant=require("fbjs/lib/invariant");var warning=require("fbjs/lib/warning");function findDOMNode(componentOrElement){if(process.env.NODE_ENV!=="production"){var owner=ReactCurrentOwner.current;if(owner!==null){process.env.NODE_ENV!=="production"?warning(owner._warnedAboutRefsInRender,"%s is accessing findDOMNode inside its render(). "+"render() should be a pure function of props and state. It should "+"never access something that requires stale data from the previous "+"render, such as refs. Move this logic to componentDidMount and "+"componentDidUpdate instead.",owner.getName()||"A component"):void 0;owner._warnedAboutRefsInRender=true}}if(componentOrElement==null){return null}if(componentOrElement.nodeType===1){return componentOrElement}var inst=ReactInstanceMap.get(componentOrElement);if(inst){inst=getHostComponentFromComposite(inst);return inst?ReactDOMComponentTree.getNodeFromInstance(inst):null}if(typeof componentOrElement.render==="function"){!false?process.env.NODE_ENV!=="production"?invariant(false,"findDOMNode was called on an unmounted component."):_prodInvariant("44"):void 0}else{!false?process.env.NODE_ENV!=="production"?invariant(false,"Element appears to be neither ReactComponent nor DOMNode (keys: %s)",Object.keys(componentOrElement)):_prodInvariant("45",Object.keys(componentOrElement)):void 0}}module.exports=findDOMNode}).call(this,require("_process"))},{"./ReactDOMComponentTree":64,"./ReactInstanceMap":92,"./getHostComponentFromComposite":141,"./reactProdInvariant":151,_process:184,"fbjs/lib/invariant":18,"fbjs/lib/warning":25,"react/lib/ReactCurrentOwner":164}],135:[function(require,module,exports){(function(process){"use strict";var KeyEscapeUtils=require("./KeyEscapeUtils");var traverseAllChildren=require("./traverseAllChildren");var warning=require("fbjs/lib/warning");var ReactComponentTreeHook;if(typeof process!=="undefined"&&process.env&&process.env.NODE_ENV==="test"){ReactComponentTreeHook=require("react/lib/ReactComponentTreeHook")}function flattenSingleChildIntoContext(traverseContext,child,name,selfDebugID){if(traverseContext&&typeof traverseContext==="object"){var result=traverseContext;var keyUnique=result[name]===undefined;if(process.env.NODE_ENV!=="production"){if(!ReactComponentTreeHook){ReactComponentTreeHook=require("react/lib/ReactComponentTreeHook")}if(!keyUnique){process.env.NODE_ENV!=="production"?warning(false,"flattenChildren(...): Encountered two children with the same key, "+"`%s`. Child keys must be unique; when two children share a key, only "+"the first child will be used.%s",KeyEscapeUtils.unescape(name),ReactComponentTreeHook.getStackAddendumByID(selfDebugID)):void 0}}if(keyUnique&&child!=null){result[name]=child}}}function flattenChildren(children,selfDebugID){if(children==null){return children}var result={};if(process.env.NODE_ENV!=="production"){traverseAllChildren(children,function(traverseContext,child,name){return flattenSingleChildIntoContext(traverseContext,child,name,selfDebugID)},result)}else{traverseAllChildren(children,flattenSingleChildIntoContext,result)}return result}module.exports=flattenChildren}).call(this,require("_process"))},{"./KeyEscapeUtils":53,"./traverseAllChildren":156,_process:184,"fbjs/lib/warning":25,"react/lib/ReactComponentTreeHook":163}],136:[function(require,module,exports){"use strict";function forEachAccumulated(arr,cb,scope){if(Array.isArray(arr)){arr.forEach(cb,scope)}else if(arr){cb.call(scope,arr)}}module.exports=forEachAccumulated},{}],137:[function(require,module,exports){"use strict";function getEventCharCode(nativeEvent){var charCode;var keyCode=nativeEvent.keyCode;if("charCode"in nativeEvent){charCode=nativeEvent.charCode;if(charCode===0&&keyCode===13){charCode=13}}else{charCode=keyCode}if(charCode>=32||charCode===13){return charCode}return 0}module.exports=getEventCharCode},{}],138:[function(require,module,exports){"use strict";var getEventCharCode=require("./getEventCharCode");var normalizeKey={Esc:"Escape",Spacebar:" ",Left:"ArrowLeft",Up:"ArrowUp",Right:"ArrowRight",Down:"ArrowDown",Del:"Delete",Win:"OS",Menu:"ContextMenu",Apps:"ContextMenu",Scroll:"ScrollLock",MozPrintableKey:"Unidentified"};var translateToKey={8:"Backspace",9:"Tab",12:"Clear",13:"Enter",16:"Shift",17:"Control",18:"Alt",19:"Pause",20:"CapsLock",27:"Escape",32:" ",33:"PageUp",34:"PageDown",35:"End",36:"Home",37:"ArrowLeft",38:"ArrowUp",39:"ArrowRight",40:"ArrowDown",45:"Insert",46:"Delete",112:"F1",113:"F2",114:"F3",115:"F4",116:"F5",117:"F6",118:"F7",119:"F8",120:"F9",121:"F10",122:"F11",123:"F12",144:"NumLock",145:"ScrollLock",224:"Meta"};function getEventKey(nativeEvent){if(nativeEvent.key){var key=normalizeKey[nativeEvent.key]||nativeEvent.key;if(key!=="Unidentified"){return key}}if(nativeEvent.type==="keypress"){var charCode=getEventCharCode(nativeEvent);return charCode===13?"Enter":String.fromCharCode(charCode)}if(nativeEvent.type==="keydown"||nativeEvent.type==="keyup"){return translateToKey[nativeEvent.keyCode]||"Unidentified"}return""}module.exports=getEventKey},{"./getEventCharCode":137}],139:[function(require,module,exports){"use strict";var modifierKeyToProp={Alt:"altKey",Control:"ctrlKey",Meta:"metaKey",Shift:"shiftKey"};function modifierStateGetter(keyArg){var syntheticEvent=this;var nativeEvent=syntheticEvent.nativeEvent;if(nativeEvent.getModifierState){return nativeEvent.getModifierState(keyArg)}var keyProp=modifierKeyToProp[keyArg];return keyProp?!!nativeEvent[keyProp]:false}function getEventModifierState(nativeEvent){return modifierStateGetter}module.exports=getEventModifierState},{}],140:[function(require,module,exports){"use strict";function getEventTarget(nativeEvent){var target=nativeEvent.target||nativeEvent.srcElement||window;if(target.correspondingUseElement){target=target.correspondingUseElement}return target.nodeType===3?target.parentNode:target}module.exports=getEventTarget},{}],141:[function(require,module,exports){"use strict";var ReactNodeTypes=require("./ReactNodeTypes");function getHostComponentFromComposite(inst){var type;while((type=inst._renderedNodeType)===ReactNodeTypes.COMPOSITE){inst=inst._renderedComponent}if(type===ReactNodeTypes.HOST){return inst._renderedComponent}else if(type===ReactNodeTypes.EMPTY){return null}}module.exports=getHostComponentFromComposite},{"./ReactNodeTypes":98}],142:[function(require,module,exports){"use strict";var ITERATOR_SYMBOL=typeof Symbol==="function"&&Symbol.iterator;var FAUX_ITERATOR_SYMBOL="@@iterator";function getIteratorFn(maybeIterable){var iteratorFn=maybeIterable&&(ITERATOR_SYMBOL&&maybeIterable[ITERATOR_SYMBOL]||maybeIterable[FAUX_ITERATOR_SYMBOL]);if(typeof iteratorFn==="function"){return iteratorFn}}module.exports=getIteratorFn},{}],143:[function(require,module,exports){"use strict";function getLeafNode(node){while(node&&node.firstChild){node=node.firstChild}return node}function getSiblingNode(node){while(node){if(node.nextSibling){return node.nextSibling}node=node.parentNode}}function getNodeForCharacterOffset(root,offset){var node=getLeafNode(root);var nodeStart=0;var nodeEnd=0;while(node){if(node.nodeType===3){nodeEnd=nodeStart+node.textContent.length;if(nodeStart<=offset&&nodeEnd>=offset){return{node:node,offset:offset-nodeStart}}nodeStart=nodeEnd}node=getLeafNode(getSiblingNode(node))}}module.exports=getNodeForCharacterOffset},{}],144:[function(require,module,exports){"use strict";var ExecutionEnvironment=require("fbjs/lib/ExecutionEnvironment");var contentKey=null;function getTextContentAccessor(){if(!contentKey&&ExecutionEnvironment.canUseDOM){contentKey="textContent"in document.documentElement?"textContent":"innerText"}return contentKey}module.exports=getTextContentAccessor},{"fbjs/lib/ExecutionEnvironment":4}],145:[function(require,module,exports){"use strict";var ExecutionEnvironment=require("fbjs/lib/ExecutionEnvironment");function makePrefixMap(styleProp,eventName){var prefixes={};prefixes[styleProp.toLowerCase()]=eventName.toLowerCase();prefixes["Webkit"+styleProp]="webkit"+eventName;prefixes["Moz"+styleProp]="moz"+eventName;prefixes["ms"+styleProp]="MS"+eventName;prefixes["O"+styleProp]="o"+eventName.toLowerCase();return prefixes}var vendorPrefixes={animationend:makePrefixMap("Animation","AnimationEnd"),animationiteration:makePrefixMap("Animation","AnimationIteration"),animationstart:makePrefixMap("Animation","AnimationStart"),transitionend:makePrefixMap("Transition","TransitionEnd")};var prefixedEventNames={};var style={};if(ExecutionEnvironment.canUseDOM){style=document.createElement("div").style;if(!("AnimationEvent"in window)){delete vendorPrefixes.animationend.animation;delete vendorPrefixes.animationiteration.animation;delete vendorPrefixes.animationstart.animation}if(!("TransitionEvent"in window)){delete vendorPrefixes.transitionend.transition}}function getVendorPrefixedEventName(eventName){if(prefixedEventNames[eventName]){return prefixedEventNames[eventName]}else if(!vendorPrefixes[eventName]){return eventName}var prefixMap=vendorPrefixes[eventName];for(var styleProp in prefixMap){if(prefixMap.hasOwnProperty(styleProp)&&styleProp in style){return prefixedEventNames[eventName]=prefixMap[styleProp]}}return""}module.exports=getVendorPrefixedEventName},{"fbjs/lib/ExecutionEnvironment":4}],146:[function(require,module,exports){"use strict";var ReactDOMComponentTree=require("./ReactDOMComponentTree");function isCheckable(elem){var type=elem.type;var nodeName=elem.nodeName;return nodeName&&nodeName.toLowerCase()==="input"&&(type==="checkbox"||type==="radio")}function getTracker(inst){return inst._wrapperState.valueTracker}function attachTracker(inst,tracker){inst._wrapperState.valueTracker=tracker}function detachTracker(inst){delete inst._wrapperState.valueTracker}function getValueFromNode(node){var value;if(node){value=isCheckable(node)?""+node.checked:node.value}return value}var inputValueTracking={_getTrackerFromNode:function(node){return getTracker(ReactDOMComponentTree.getInstanceFromNode(node))},track:function(inst){if(getTracker(inst)){return}var node=ReactDOMComponentTree.getNodeFromInstance(inst);var valueField=isCheckable(node)?"checked":"value";var descriptor=Object.getOwnPropertyDescriptor(node.constructor.prototype,valueField);var currentValue=""+node[valueField];if(node.hasOwnProperty(valueField)||typeof descriptor.get!=="function"||typeof descriptor.set!=="function"){return}Object.defineProperty(node,valueField,{enumerable:descriptor.enumerable,configurable:true,get:function(){return descriptor.get.call(this)},set:function(value){currentValue=""+value;descriptor.set.call(this,value)}});attachTracker(inst,{getValue:function(){return currentValue},setValue:function(value){currentValue=""+value},stopTracking:function(){detachTracker(inst);delete node[valueField]}})},updateValueIfChanged:function(inst){if(!inst){return false}var tracker=getTracker(inst);if(!tracker){inputValueTracking.track(inst);return true}var lastValue=tracker.getValue();var nextValue=getValueFromNode(ReactDOMComponentTree.getNodeFromInstance(inst));if(nextValue!==lastValue){tracker.setValue(nextValue);return true}return false},stopTracking:function(inst){var tracker=getTracker(inst);if(tracker){tracker.stopTracking()}}};module.exports=inputValueTracking},{"./ReactDOMComponentTree":64}],147:[function(require,module,exports){(function(process){"use strict";var _prodInvariant=require("./reactProdInvariant"),_assign=require("object-assign");var ReactCompositeComponent=require("./ReactCompositeComponent");var ReactEmptyComponent=require("./ReactEmptyComponent");var ReactHostComponent=require("./ReactHostComponent");var getNextDebugID=require("react/lib/getNextDebugID");var invariant=require("fbjs/lib/invariant");var warning=require("fbjs/lib/warning");var ReactCompositeComponentWrapper=function(element){this.construct(element)};function getDeclarationErrorAddendum(owner){if(owner){var name=owner.getName();if(name){return" Check the render method of `"+name+"`."}}return""}function isInternalComponentType(type){return typeof type==="function"&&typeof type.prototype!=="undefined"&&typeof type.prototype.mountComponent==="function"&&typeof type.prototype.receiveComponent==="function"}function instantiateReactComponent(node,shouldHaveDebugID){var instance;if(node===null||node===false){instance=ReactEmptyComponent.create(instantiateReactComponent)}else if(typeof node==="object"){var element=node;var type=element.type;if(typeof type!=="function"&&typeof type!=="string"){var info="";if(process.env.NODE_ENV!=="production"){if(type===undefined||typeof type==="object"&&type!==null&&Object.keys(type).length===0){info+=" You likely forgot to export your component from the file "+"it's defined in."}}info+=getDeclarationErrorAddendum(element._owner);!false?process.env.NODE_ENV!=="production"?invariant(false,"Element type is invalid: expected a string (for built-in components) or a class/function (for composite components) but got: %s.%s",type==null?type:typeof type,info):_prodInvariant("130",type==null?type:typeof type,info):void 0}if(typeof element.type==="string"){instance=ReactHostComponent.createInternalComponent(element)}else if(isInternalComponentType(element.type)){instance=new element.type(element);if(!instance.getHostNode){instance.getHostNode=instance.getNativeNode}}else{instance=new ReactCompositeComponentWrapper(element)}}else if(typeof node==="string"||typeof node==="number"){instance=ReactHostComponent.createInstanceForText(node)}else{!false?process.env.NODE_ENV!=="production"?invariant(false,"Encountered invalid React node of type %s",typeof node):_prodInvariant("131",typeof node):void 0}if(process.env.NODE_ENV!=="production"){process.env.NODE_ENV!=="production"?warning(typeof instance.mountComponent==="function"&&typeof instance.receiveComponent==="function"&&typeof instance.getHostNode==="function"&&typeof instance.unmountComponent==="function","Only React Components can be mounted."):void 0}instance._mountIndex=0;instance._mountImage=null;if(process.env.NODE_ENV!=="production"){instance._debugID=shouldHaveDebugID?getNextDebugID():0}if(process.env.NODE_ENV!=="production"){if(Object.preventExtensions){Object.preventExtensions(instance)}}return instance}_assign(ReactCompositeComponentWrapper.prototype,ReactCompositeComponent,{_instantiateReactComponent:instantiateReactComponent});module.exports=instantiateReactComponent}).call(this,require("_process"))},{"./ReactCompositeComponent":60,"./ReactEmptyComponent":83,"./ReactHostComponent":88,"./reactProdInvariant":151,_process:184,"fbjs/lib/invariant":18,"fbjs/lib/warning":25,"object-assign":26,"react/lib/getNextDebugID":178}],148:[function(require,module,exports){"use strict";var ExecutionEnvironment=require("fbjs/lib/ExecutionEnvironment");var useHasFeature;if(ExecutionEnvironment.canUseDOM){useHasFeature=document.implementation&&document.implementation.hasFeature&&document.implementation.hasFeature("","")!==true}function isEventSupported(eventNameSuffix,capture){if(!ExecutionEnvironment.canUseDOM||capture&&!("addEventListener"in document)){return false}var eventName="on"+eventNameSuffix;var isSupported=eventName in document;if(!isSupported){var element=document.createElement("div");element.setAttribute(eventName,"return;");isSupported=typeof element[eventName]==="function"}if(!isSupported&&useHasFeature&&eventNameSuffix==="wheel"){isSupported=document.implementation.hasFeature("Events.wheel","3.0")}return isSupported}module.exports=isEventSupported},{"fbjs/lib/ExecutionEnvironment":4}],149:[function(require,module,exports){"use strict";var supportedInputTypes={color:true,date:true,datetime:true,"datetime-local":true,email:true,month:true,number:true,password:true,range:true,search:true,tel:true,text:true,time:true,url:true,week:true};function isTextInputElement(elem){var nodeName=elem&&elem.nodeName&&elem.nodeName.toLowerCase();if(nodeName==="input"){return!!supportedInputTypes[elem.type]}if(nodeName==="textarea"){return true}return false}module.exports=isTextInputElement},{}],150:[function(require,module,exports){"use strict";var escapeTextContentForBrowser=require("./escapeTextContentForBrowser");function quoteAttributeValueForBrowser(value){return'"'+escapeTextContentForBrowser(value)+'"'}module.exports=quoteAttributeValueForBrowser},{"./escapeTextContentForBrowser":133}],151:[function(require,module,exports){"use strict";function reactProdInvariant(code){var argCount=arguments.length-1;var message="Minified React error #"+code+"; visit "+"http://facebook.github.io/react/docs/error-decoder.html?invariant="+code;for(var argIdx=0;argIdx<argCount;argIdx++){message+="&args[]="+encodeURIComponent(arguments[argIdx+1])}message+=" for the full message or use the non-minified dev environment"+" for full errors and additional helpful warnings.";var error=new Error(message);error.name="Invariant Violation";error.framesToPop=1;throw error}module.exports=reactProdInvariant},{}],152:[function(require,module,exports){"use strict";var ReactMount=require("./ReactMount");module.exports=ReactMount.renderSubtreeIntoContainer},{"./ReactMount":96}],153:[function(require,module,exports){"use strict";var ExecutionEnvironment=require("fbjs/lib/ExecutionEnvironment");var DOMNamespaces=require("./DOMNamespaces");var WHITESPACE_TEST=/^[ \r\n\t\f]/;var NONVISIBLE_TEST=/<(!--|link|noscript|meta|script|style)[ \r\n\t\f\/>]/;var createMicrosoftUnsafeLocalFunction=require("./createMicrosoftUnsafeLocalFunction");var reusableSVGContainer;var setInnerHTML=createMicrosoftUnsafeLocalFunction(function(node,html){if(node.namespaceURI===DOMNamespaces.svg&&!("innerHTML"in node)){reusableSVGContainer=reusableSVGContainer||document.createElement("div");reusableSVGContainer.innerHTML="<svg>"+html+"</svg>";var svgNode=reusableSVGContainer.firstChild;while(svgNode.firstChild){node.appendChild(svgNode.firstChild)}}else{node.innerHTML=html}});if(ExecutionEnvironment.canUseDOM){var testElement=document.createElement("div");testElement.innerHTML=" ";if(testElement.innerHTML===""){setInnerHTML=function(node,html){if(node.parentNode){node.parentNode.replaceChild(node,node)}if(WHITESPACE_TEST.test(html)||html[0]==="<"&&NONVISIBLE_TEST.test(html)){node.innerHTML=String.fromCharCode(65279)+html;var textNode=node.firstChild;if(textNode.data.length===1){node.removeChild(textNode)}else{textNode.deleteData(0,1)}}else{node.innerHTML=html}}}testElement=null}module.exports=setInnerHTML},{"./DOMNamespaces":41,"./createMicrosoftUnsafeLocalFunction":131,"fbjs/lib/ExecutionEnvironment":4}],154:[function(require,module,exports){"use strict";var ExecutionEnvironment=require("fbjs/lib/ExecutionEnvironment");var escapeTextContentForBrowser=require("./escapeTextContentForBrowser");var setInnerHTML=require("./setInnerHTML");var setTextContent=function(node,text){if(text){var firstChild=node.firstChild;if(firstChild&&firstChild===node.lastChild&&firstChild.nodeType===3){firstChild.nodeValue=text;return}}node.textContent=text};if(ExecutionEnvironment.canUseDOM){if(!("textContent"in document.documentElement)){setTextContent=function(node,text){if(node.nodeType===3){node.nodeValue=text;return}setInnerHTML(node,escapeTextContentForBrowser(text))}}}module.exports=setTextContent},{"./escapeTextContentForBrowser":133,"./setInnerHTML":153,"fbjs/lib/ExecutionEnvironment":4}],155:[function(require,module,exports){"use strict";function shouldUpdateReactComponent(prevElement,nextElement){var prevEmpty=prevElement===null||prevElement===false;var nextEmpty=nextElement===null||nextElement===false;if(prevEmpty||nextEmpty){return prevEmpty===nextEmpty}var prevType=typeof prevElement;var nextType=typeof nextElement;if(prevType==="string"||prevType==="number"){return nextType==="string"||nextType==="number"}else{return nextType==="object"&&prevElement.type===nextElement.type&&prevElement.key===nextElement.key}}module.exports=shouldUpdateReactComponent},{}],156:[function(require,module,exports){(function(process){"use strict";var _prodInvariant=require("./reactProdInvariant");var ReactCurrentOwner=require("react/lib/ReactCurrentOwner");var REACT_ELEMENT_TYPE=require("./ReactElementSymbol");var getIteratorFn=require("./getIteratorFn");var invariant=require("fbjs/lib/invariant");var KeyEscapeUtils=require("./KeyEscapeUtils");var warning=require("fbjs/lib/warning");var SEPARATOR=".";var SUBSEPARATOR=":";var didWarnAboutMaps=false;function getComponentKey(component,index){if(component&&typeof component==="object"&&component.key!=null){return KeyEscapeUtils.escape(component.key)}return index.toString(36)}function traverseAllChildrenImpl(children,nameSoFar,callback,traverseContext){var type=typeof children;if(type==="undefined"||type==="boolean"){children=null}if(children===null||type==="string"||type==="number"||type==="object"&&children.$$typeof===REACT_ELEMENT_TYPE){callback(traverseContext,children,nameSoFar===""?SEPARATOR+getComponentKey(children,0):nameSoFar);return 1}var child;var nextName;var subtreeCount=0;var nextNamePrefix=nameSoFar===""?SEPARATOR:nameSoFar+SUBSEPARATOR;if(Array.isArray(children)){for(var i=0;i<children.length;i++){child=children[i];nextName=nextNamePrefix+getComponentKey(child,i);subtreeCount+=traverseAllChildrenImpl(child,nextName,callback,traverseContext)}}else{var iteratorFn=getIteratorFn(children);if(iteratorFn){var iterator=iteratorFn.call(children);var step;if(iteratorFn!==children.entries){var ii=0;while(!(step=iterator.next()).done){child=step.value;nextName=nextNamePrefix+getComponentKey(child,ii++);subtreeCount+=traverseAllChildrenImpl(child,nextName,callback,traverseContext)}}else{if(process.env.NODE_ENV!=="production"){var mapsAsChildrenAddendum="";if(ReactCurrentOwner.current){var mapsAsChildrenOwnerName=ReactCurrentOwner.current.getName();if(mapsAsChildrenOwnerName){mapsAsChildrenAddendum=" Check the render method of `"+mapsAsChildrenOwnerName+"`."}}process.env.NODE_ENV!=="production"?warning(didWarnAboutMaps,"Using Maps as children is not yet fully supported. It is an "+"experimental feature that might be removed. Convert it to a "+"sequence / iterable of keyed ReactElements instead.%s",mapsAsChildrenAddendum):void 0;didWarnAboutMaps=true}while(!(step=iterator.next()).done){var entry=step.value;if(entry){child=entry[1];nextName=nextNamePrefix+KeyEscapeUtils.escape(entry[0])+SUBSEPARATOR+getComponentKey(child,0);subtreeCount+=traverseAllChildrenImpl(child,nextName,callback,traverseContext)}}}}else if(type==="object"){var addendum="";if(process.env.NODE_ENV!=="production"){addendum=" If you meant to render a collection of children, use an array "+"instead or wrap the object using createFragment(object) from the "+"React add-ons.";if(children._isReactElement){addendum=" It looks like you're using an element created by a different "+"version of React. Make sure to use only one copy of React."}if(ReactCurrentOwner.current){var name=ReactCurrentOwner.current.getName();if(name){addendum+=" Check the render method of `"+name+"`."}}}var childrenString=String(children);!false?process.env.NODE_ENV!=="production"?invariant(false,"Objects are not valid as a React child (found: %s).%s",childrenString==="[object Object]"?"object with keys {"+Object.keys(children).join(", ")+"}":childrenString,addendum):_prodInvariant("31",childrenString==="[object Object]"?"object with keys {"+Object.keys(children).join(", ")+"}":childrenString,addendum):void 0}}return subtreeCount}function traverseAllChildren(children,callback,traverseContext){if(children==null){return 0}return traverseAllChildrenImpl(children,"",callback,traverseContext)}module.exports=traverseAllChildren}).call(this,require("_process"))},{"./KeyEscapeUtils":53,"./ReactElementSymbol":82,"./getIteratorFn":142,"./reactProdInvariant":151,_process:184,"fbjs/lib/invariant":18,"fbjs/lib/warning":25,"react/lib/ReactCurrentOwner":164}],157:[function(require,module,exports){(function(process){"use strict";var _assign=require("object-assign");var emptyFunction=require("fbjs/lib/emptyFunction");var warning=require("fbjs/lib/warning");var validateDOMNesting=emptyFunction;if(process.env.NODE_ENV!=="production"){var specialTags=["address","applet","area","article","aside","base","basefont","bgsound","blockquote","body","br","button","caption","center","col","colgroup","dd","details","dir","div","dl","dt","embed","fieldset","figcaption","figure","footer","form","frame","frameset","h1","h2","h3","h4","h5","h6","head","header","hgroup","hr","html","iframe","img","input","isindex","li","link","listing","main","marquee","menu","menuitem","meta","nav","noembed","noframes","noscript","object","ol","p","param","plaintext","pre","script","section","select","source","style","summary","table","tbody","td","template","textarea","tfoot","th","thead","title","tr","track","ul","wbr","xmp"];var inScopeTags=["applet","caption","html","table","td","th","marquee","object","template","foreignObject","desc","title"];var buttonScopeTags=inScopeTags.concat(["button"]);var impliedEndTags=["dd","dt","li","option","optgroup","p","rp","rt"];var emptyAncestorInfo={current:null,formTag:null,aTagInScope:null,buttonTagInScope:null,nobrTagInScope:null,pTagInButtonScope:null,listItemTagAutoclosing:null,dlItemTagAutoclosing:null};var updatedAncestorInfo=function(oldInfo,tag,instance){var ancestorInfo=_assign({},oldInfo||emptyAncestorInfo);var info={tag:tag,instance:instance};if(inScopeTags.indexOf(tag)!==-1){ancestorInfo.aTagInScope=null;ancestorInfo.buttonTagInScope=null;ancestorInfo.nobrTagInScope=null}if(buttonScopeTags.indexOf(tag)!==-1){ancestorInfo.pTagInButtonScope=null}if(specialTags.indexOf(tag)!==-1&&tag!=="address"&&tag!=="div"&&tag!=="p"){ancestorInfo.listItemTagAutoclosing=null;ancestorInfo.dlItemTagAutoclosing=null}ancestorInfo.current=info;if(tag==="form"){ancestorInfo.formTag=info}if(tag==="a"){ancestorInfo.aTagInScope=info}if(tag==="button"){ancestorInfo.buttonTagInScope=info}if(tag==="nobr"){ancestorInfo.nobrTagInScope=info}if(tag==="p"){ancestorInfo.pTagInButtonScope=info}if(tag==="li"){ancestorInfo.listItemTagAutoclosing=info}if(tag==="dd"||tag==="dt"){ancestorInfo.dlItemTagAutoclosing=info}return ancestorInfo};var isTagValidWithParent=function(tag,parentTag){switch(parentTag){case"select":return tag==="option"||tag==="optgroup"||tag==="#text";case"optgroup":return tag==="option"||tag==="#text";case"option":return tag==="#text";case"tr":return tag==="th"||tag==="td"||tag==="style"||tag==="script"||tag==="template";case"tbody":case"thead":case"tfoot":return tag==="tr"||tag==="style"||tag==="script"||tag==="template";case"colgroup":return tag==="col"||tag==="template";case"table":return tag==="caption"||tag==="colgroup"||tag==="tbody"||tag==="tfoot"||tag==="thead"||tag==="style"||tag==="script"||tag==="template";case"head":return tag==="base"||tag==="basefont"||tag==="bgsound"||tag==="link"||tag==="meta"||tag==="title"||tag==="noscript"||tag==="noframes"||tag==="style"||tag==="script"||tag==="template";case"html":return tag==="head"||tag==="body";case"#document":return tag==="html"}switch(tag){case"h1":case"h2":case"h3":case"h4":case"h5":case"h6":return parentTag!=="h1"&&parentTag!=="h2"&&parentTag!=="h3"&&parentTag!=="h4"&&parentTag!=="h5"&&parentTag!=="h6";case"rp":case"rt":return impliedEndTags.indexOf(parentTag)===-1;case"body":case"caption":case"col":case"colgroup":case"frame":case"head":case"html":case"tbody":case"td":case"tfoot":case"th":case"thead":case"tr":return parentTag==null}return true};var findInvalidAncestorForTag=function(tag,ancestorInfo){switch(tag){case"address":case"article":case"aside":case"blockquote":case"center":case"details":case"dialog":case"dir":case"div":case"dl":case"fieldset":case"figcaption":case"figure":case"footer":case"header":case"hgroup":case"main":case"menu":case"nav":case"ol":case"p":case"section":case"summary":case"ul":case"pre":case"listing":case"table":case"hr":case"xmp":case"h1":case"h2":case"h3":case"h4":case"h5":case"h6":return ancestorInfo.pTagInButtonScope;case"form":return ancestorInfo.formTag||ancestorInfo.pTagInButtonScope;case"li":return ancestorInfo.listItemTagAutoclosing;case"dd":case"dt":return ancestorInfo.dlItemTagAutoclosing;case"button":return ancestorInfo.buttonTagInScope;case"a":return ancestorInfo.aTagInScope;case"nobr":return ancestorInfo.nobrTagInScope}return null};var findOwnerStack=function(instance){if(!instance){return[]}var stack=[];do{stack.push(instance)}while(instance=instance._currentElement._owner);stack.reverse();return stack};var didWarn={};validateDOMNesting=function(childTag,childText,childInstance,ancestorInfo){ancestorInfo=ancestorInfo||emptyAncestorInfo;var parentInfo=ancestorInfo.current;var parentTag=parentInfo&&parentInfo.tag;if(childText!=null){process.env.NODE_ENV!=="production"?warning(childTag==null,"validateDOMNesting: when childText is passed, childTag should be null"):void 0;childTag="#text"}var invalidParent=isTagValidWithParent(childTag,parentTag)?null:parentInfo;var invalidAncestor=invalidParent?null:findInvalidAncestorForTag(childTag,ancestorInfo);var problematic=invalidParent||invalidAncestor;if(problematic){var ancestorTag=problematic.tag;var ancestorInstance=problematic.instance;var childOwner=childInstance&&childInstance._currentElement._owner;var ancestorOwner=ancestorInstance&&ancestorInstance._currentElement._owner;var childOwners=findOwnerStack(childOwner);var ancestorOwners=findOwnerStack(ancestorOwner);var minStackLen=Math.min(childOwners.length,ancestorOwners.length);var i;var deepestCommon=-1;for(i=0;i<minStackLen;i++){if(childOwners[i]===ancestorOwners[i]){deepestCommon=i}else{break}}var UNKNOWN="(unknown)";var childOwnerNames=childOwners.slice(deepestCommon+1).map(function(inst){return inst.getName()||UNKNOWN});var ancestorOwnerNames=ancestorOwners.slice(deepestCommon+1).map(function(inst){return inst.getName()||UNKNOWN});var ownerInfo=[].concat(deepestCommon!==-1?childOwners[deepestCommon].getName()||UNKNOWN:[],ancestorOwnerNames,ancestorTag,invalidAncestor?["..."]:[],childOwnerNames,childTag).join(" > ");var warnKey=!!invalidParent+"|"+childTag+"|"+ancestorTag+"|"+ownerInfo;if(didWarn[warnKey]){return}didWarn[warnKey]=true;var tagDisplayName=childTag;var whitespaceInfo="";if(childTag==="#text"){if(/\S/.test(childText)){tagDisplayName="Text nodes"}else{tagDisplayName="Whitespace text nodes";whitespaceInfo=" Make sure you don't have any extra whitespace between tags on "+"each line of your source code."}}else{tagDisplayName="<"+childTag+">"}if(invalidParent){var info="";if(ancestorTag==="table"&&childTag==="tr"){info+=" Add a <tbody> to your code to match the DOM tree generated by "+"the browser."}process.env.NODE_ENV!=="production"?warning(false,"validateDOMNesting(...): %s cannot appear as a child of <%s>.%s "+"See %s.%s",tagDisplayName,ancestorTag,whitespaceInfo,ownerInfo,info):void 0}else{process.env.NODE_ENV!=="production"?warning(false,"validateDOMNesting(...): %s cannot appear as a descendant of "+"<%s>. See %s.",tagDisplayName,ancestorTag,ownerInfo):void 0}}};validateDOMNesting.updatedAncestorInfo=updatedAncestorInfo;validateDOMNesting.isTagValidInContext=function(tag,ancestorInfo){ancestorInfo=ancestorInfo||emptyAncestorInfo;var parentInfo=ancestorInfo.current;var parentTag=parentInfo&&parentInfo.tag;return isTagValidWithParent(tag,parentTag)&&!findInvalidAncestorForTag(tag,ancestorInfo)}}module.exports=validateDOMNesting}).call(this,require("_process"))},{_process:184,"fbjs/lib/emptyFunction":10,"fbjs/lib/warning":25,"object-assign":26}],158:[function(require,module,exports){arguments[4][53][0].apply(exports,arguments)},{dup:53}],159:[function(require,module,exports){arguments[4][55][0].apply(exports,arguments)},{"./reactProdInvariant":181,_process:184,dup:55,"fbjs/lib/invariant":18}],160:[function(require,module,exports){(function(process){"use strict";var _assign=require("object-assign");var ReactBaseClasses=require("./ReactBaseClasses");var ReactChildren=require("./ReactChildren");var ReactDOMFactories=require("./ReactDOMFactories");var ReactElement=require("./ReactElement");var ReactPropTypes=require("./ReactPropTypes");var ReactVersion=require("./ReactVersion");var createReactClass=require("./createClass");var onlyChild=require("./onlyChild");var createElement=ReactElement.createElement;var createFactory=ReactElement.createFactory;var cloneElement=ReactElement.cloneElement;if(process.env.NODE_ENV!=="production"){var lowPriorityWarning=require("./lowPriorityWarning");var canDefineProperty=require("./canDefineProperty");var ReactElementValidator=require("./ReactElementValidator");var didWarnPropTypesDeprecated=false;createElement=ReactElementValidator.createElement;createFactory=ReactElementValidator.createFactory;cloneElement=ReactElementValidator.cloneElement}var __spread=_assign;var createMixin=function(mixin){return mixin};if(process.env.NODE_ENV!=="production"){var warnedForSpread=false;var warnedForCreateMixin=false;__spread=function(){lowPriorityWarning(warnedForSpread,"React.__spread is deprecated and should not be used. Use "+"Object.assign directly or another helper function with similar "+"semantics. You may be seeing this warning due to your compiler. "+"See https://fb.me/react-spread-deprecation for more details.");warnedForSpread=true;return _assign.apply(null,arguments)};createMixin=function(mixin){lowPriorityWarning(warnedForCreateMixin,"React.createMixin is deprecated and should not be used. "+"In React v16.0, it will be removed. "+"You can use this mixin directly instead. "+"See https://fb.me/createmixin-was-never-implemented for more info.");warnedForCreateMixin=true;return mixin}}var React={Children:{map:ReactChildren.map,forEach:ReactChildren.forEach,count:ReactChildren.count,toArray:ReactChildren.toArray,only:onlyChild},Component:ReactBaseClasses.Component,PureComponent:ReactBaseClasses.PureComponent,createElement:createElement,cloneElement:cloneElement,isValidElement:ReactElement.isValidElement,PropTypes:ReactPropTypes,createClass:createReactClass,createFactory:createFactory,createMixin:createMixin,DOM:ReactDOMFactories,version:ReactVersion,__spread:__spread};if(process.env.NODE_ENV!=="production"){var warnedForCreateClass=false;if(canDefineProperty){Object.defineProperty(React,"PropTypes",{get:function(){lowPriorityWarning(didWarnPropTypesDeprecated,"Accessing PropTypes via the main React package is deprecated,"+" and will be removed in  React v16.0."+" Use the latest available v15.* prop-types package from npm instead."+" For info on usage, compatibility, migration and more, see "+"https://fb.me/prop-types-docs");didWarnPropTypesDeprecated=true;return ReactPropTypes}});Object.defineProperty(React,"createClass",{get:function(){lowPriorityWarning(warnedForCreateClass,"Accessing createClass via the main React package is deprecated,"+" and will be removed in React v16.0."+" Use a plain JavaScript class instead. If you're not yet "+"ready to migrate, create-react-class v15.* is available "+"on npm as a temporary, drop-in replacement. "+"For more info see https://fb.me/react-create-class");warnedForCreateClass=true;return createReactClass}})}React.DOM={};var warnedForFactories=false;Object.keys(ReactDOMFactories).forEach(function(factory){React.DOM[factory]=function(){if(!warnedForFactories){lowPriorityWarning(false,"Accessing factories like React.DOM.%s has been deprecated "+"and will be removed in v16.0+. Use the "+"react-dom-factories package instead. "+" Version 1.0 provides a drop-in replacement."+" For more info, see https://fb.me/react-dom-factories",factory);warnedForFactories=true}return ReactDOMFactories[factory].apply(ReactDOMFactories,arguments)}})}module.exports=React}).call(this,require("_process"))},{"./ReactBaseClasses":161,"./ReactChildren":162,"./ReactDOMFactories":165,"./ReactElement":166,"./ReactElementValidator":168,"./ReactPropTypes":171,"./ReactVersion":173,"./canDefineProperty":174,"./createClass":176,"./lowPriorityWarning":179,"./onlyChild":180,_process:184,"object-assign":26}],161:[function(require,module,exports){(function(process){"use strict";var _prodInvariant=require("./reactProdInvariant"),_assign=require("object-assign");var ReactNoopUpdateQueue=require("./ReactNoopUpdateQueue");var canDefineProperty=require("./canDefineProperty");var emptyObject=require("fbjs/lib/emptyObject");var invariant=require("fbjs/lib/invariant");var lowPriorityWarning=require("./lowPriorityWarning");function ReactComponent(props,context,updater){this.props=props;this.context=context;this.refs=emptyObject;this.updater=updater||ReactNoopUpdateQueue}ReactComponent.prototype.isReactComponent={};ReactComponent.prototype.setState=function(partialState,callback){!(typeof partialState==="object"||typeof partialState==="function"||partialState==null)?process.env.NODE_ENV!=="production"?invariant(false,"setState(...): takes an object of state variables to update or a function which returns an object of state variables."):_prodInvariant("85"):void 0;this.updater.enqueueSetState(this,partialState);if(callback){this.updater.enqueueCallback(this,callback,"setState")}};ReactComponent.prototype.forceUpdate=function(callback){this.updater.enqueueForceUpdate(this);if(callback){this.updater.enqueueCallback(this,callback,"forceUpdate")}};if(process.env.NODE_ENV!=="production"){var deprecatedAPIs={isMounted:["isMounted","Instead, make sure to clean up subscriptions and pending requests in "+"componentWillUnmount to prevent memory leaks."],replaceState:["replaceState","Refactor your code to use setState instead (see "+"https://github.com/facebook/react/issues/3236)."]};var defineDeprecationWarning=function(methodName,info){if(canDefineProperty){Object.defineProperty(ReactComponent.prototype,methodName,{get:function(){lowPriorityWarning(false,"%s(...) is deprecated in plain JavaScript React classes. %s",info[0],info[1]);return undefined}})}};for(var fnName in deprecatedAPIs){if(deprecatedAPIs.hasOwnProperty(fnName)){defineDeprecationWarning(fnName,deprecatedAPIs[fnName])}}}function ReactPureComponent(props,context,updater){this.props=props;this.context=context;this.refs=emptyObject;this.updater=updater||ReactNoopUpdateQueue}function ComponentDummy(){}ComponentDummy.prototype=ReactComponent.prototype;ReactPureComponent.prototype=new ComponentDummy;ReactPureComponent.prototype.constructor=ReactPureComponent;_assign(ReactPureComponent.prototype,ReactComponent.prototype);ReactPureComponent.prototype.isPureReactComponent=true;module.exports={Component:ReactComponent,PureComponent:ReactPureComponent}}).call(this,require("_process"))},{"./ReactNoopUpdateQueue":169,"./canDefineProperty":174,"./lowPriorityWarning":179,"./reactProdInvariant":181,_process:184,"fbjs/lib/emptyObject":11,"fbjs/lib/invariant":18,"object-assign":26}],162:[function(require,module,exports){"use strict";var PooledClass=require("./PooledClass");var ReactElement=require("./ReactElement");var emptyFunction=require("fbjs/lib/emptyFunction");var traverseAllChildren=require("./traverseAllChildren");var twoArgumentPooler=PooledClass.twoArgumentPooler;var fourArgumentPooler=PooledClass.fourArgumentPooler;var userProvidedKeyEscapeRegex=/\/+/g;function escapeUserProvidedKey(text){return(""+text).replace(userProvidedKeyEscapeRegex,"$&/")}function ForEachBookKeeping(forEachFunction,forEachContext){this.func=forEachFunction;this.context=forEachContext;this.count=0}ForEachBookKeeping.prototype.destructor=function(){this.func=null;this.context=null;this.count=0};PooledClass.addPoolingTo(ForEachBookKeeping,twoArgumentPooler);function forEachSingleChild(bookKeeping,child,name){var func=bookKeeping.func,context=bookKeeping.context;func.call(context,child,bookKeeping.count++)}function forEachChildren(children,forEachFunc,forEachContext){if(children==null){return children}var traverseContext=ForEachBookKeeping.getPooled(forEachFunc,forEachContext);traverseAllChildren(children,forEachSingleChild,traverseContext);ForEachBookKeeping.release(traverseContext)}function MapBookKeeping(mapResult,keyPrefix,mapFunction,mapContext){this.result=mapResult;this.keyPrefix=keyPrefix;this.func=mapFunction;this.context=mapContext;this.count=0}MapBookKeeping.prototype.destructor=function(){this.result=null;this.keyPrefix=null;this.func=null;this.context=null;this.count=0};PooledClass.addPoolingTo(MapBookKeeping,fourArgumentPooler);function mapSingleChildIntoContext(bookKeeping,child,childKey){var result=bookKeeping.result,keyPrefix=bookKeeping.keyPrefix,func=bookKeeping.func,context=bookKeeping.context;var mappedChild=func.call(context,child,bookKeeping.count++);if(Array.isArray(mappedChild)){mapIntoWithKeyPrefixInternal(mappedChild,result,childKey,emptyFunction.thatReturnsArgument)}else if(mappedChild!=null){if(ReactElement.isValidElement(mappedChild)){mappedChild=ReactElement.cloneAndReplaceKey(mappedChild,keyPrefix+(mappedChild.key&&(!child||child.key!==mappedChild.key)?escapeUserProvidedKey(mappedChild.key)+"/":"")+childKey)}result.push(mappedChild)}}function mapIntoWithKeyPrefixInternal(children,array,prefix,func,context){var escapedPrefix="";if(prefix!=null){escapedPrefix=escapeUserProvidedKey(prefix)+"/"}var traverseContext=MapBookKeeping.getPooled(array,escapedPrefix,func,context);traverseAllChildren(children,mapSingleChildIntoContext,traverseContext);MapBookKeeping.release(traverseContext)}function mapChildren(children,func,context){if(children==null){return children}var result=[];mapIntoWithKeyPrefixInternal(children,result,null,func,context);return result}function forEachSingleChildDummy(traverseContext,child,name){return null}function countChildren(children,context){return traverseAllChildren(children,forEachSingleChildDummy,null)}function toArray(children){var result=[];mapIntoWithKeyPrefixInternal(children,result,null,emptyFunction.thatReturnsArgument);return result}var ReactChildren={forEach:forEachChildren,map:mapChildren,mapIntoWithKeyPrefixInternal:mapIntoWithKeyPrefixInternal,count:countChildren,toArray:toArray};module.exports=ReactChildren},{"./PooledClass":159,"./ReactElement":166,"./traverseAllChildren":182,"fbjs/lib/emptyFunction":10}],163:[function(require,module,exports){(function(process){"use strict";var _prodInvariant=require("./reactProdInvariant");var ReactCurrentOwner=require("./ReactCurrentOwner");var invariant=require("fbjs/lib/invariant");var warning=require("fbjs/lib/warning");function isNative(fn){var funcToString=Function.prototype.toString;var hasOwnProperty=Object.prototype.hasOwnProperty;var reIsNative=RegExp("^"+funcToString.call(hasOwnProperty).replace(/[\\^$.*+?()[\]{}|]/g,"\\$&").replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g,"$1.*?")+"$");try{var source=funcToString.call(fn);return reIsNative.test(source)}catch(err){return false}}var canUseCollections=typeof Array.from==="function"&&typeof Map==="function"&&isNative(Map)&&Map.prototype!=null&&typeof Map.prototype.keys==="function"&&isNative(Map.prototype.keys)&&typeof Set==="function"&&isNative(Set)&&Set.prototype!=null&&typeof Set.prototype.keys==="function"&&isNative(Set.prototype.keys);var setItem;var getItem;var removeItem;var getItemIDs;var addRoot;var removeRoot;var getRootIDs;if(canUseCollections){var itemMap=new Map;var rootIDSet=new Set;setItem=function(id,item){itemMap.set(id,item)};getItem=function(id){return itemMap.get(id)};removeItem=function(id){itemMap["delete"](id)};getItemIDs=function(){return Array.from(itemMap.keys())};addRoot=function(id){rootIDSet.add(id)};removeRoot=function(id){rootIDSet["delete"](id)};getRootIDs=function(){return Array.from(rootIDSet.keys())}}else{var itemByKey={};var rootByKey={};var getKeyFromID=function(id){return"."+id};var getIDFromKey=function(key){return parseInt(key.substr(1),10)};setItem=function(id,item){var key=getKeyFromID(id);itemByKey[key]=item};getItem=function(id){var key=getKeyFromID(id);return itemByKey[key]};removeItem=function(id){var key=getKeyFromID(id);delete itemByKey[key]};getItemIDs=function(){return Object.keys(itemByKey).map(getIDFromKey)};addRoot=function(id){var key=getKeyFromID(id);rootByKey[key]=true};removeRoot=function(id){var key=getKeyFromID(id);delete rootByKey[key]};getRootIDs=function(){return Object.keys(rootByKey).map(getIDFromKey)}}var unmountedIDs=[];function purgeDeep(id){var item=getItem(id);if(item){var childIDs=item.childIDs;removeItem(id);childIDs.forEach(purgeDeep)}}function describeComponentFrame(name,source,ownerName){return"\n    in "+(name||"Unknown")+(source?" (at "+source.fileName.replace(/^.*[\\\/]/,"")+":"+source.lineNumber+")":ownerName?" (created by "+ownerName+")":"")}function getDisplayName(element){if(element==null){return"#empty"}else if(typeof element==="string"||typeof element==="number"){return"#text"}else if(typeof element.type==="string"){return element.type}else{return element.type.displayName||element.type.name||"Unknown"}}function describeID(id){var name=ReactComponentTreeHook.getDisplayName(id);var element=ReactComponentTreeHook.getElement(id);var ownerID=ReactComponentTreeHook.getOwnerID(id);var ownerName;if(ownerID){ownerName=ReactComponentTreeHook.getDisplayName(ownerID)}process.env.NODE_ENV!=="production"?warning(element,"ReactComponentTreeHook: Missing React element for debugID %s when "+"building stack",id):void 0;return describeComponentFrame(name,element&&element._source,ownerName)}var ReactComponentTreeHook={onSetChildren:function(id,nextChildIDs){var item=getItem(id);!item?process.env.NODE_ENV!=="production"?invariant(false,"Item must have been set"):_prodInvariant("144"):void 0;item.childIDs=nextChildIDs;for(var i=0;i<nextChildIDs.length;i++){var nextChildID=nextChildIDs[i];var nextChild=getItem(nextChildID);!nextChild?process.env.NODE_ENV!=="production"?invariant(false,"Expected hook events to fire for the child before its parent includes it in onSetChildren()."):_prodInvariant("140"):void 0;!(nextChild.childIDs!=null||typeof nextChild.element!=="object"||nextChild.element==null)?process.env.NODE_ENV!=="production"?invariant(false,"Expected onSetChildren() to fire for a container child before its parent includes it in onSetChildren()."):_prodInvariant("141"):void 0;!nextChild.isMounted?process.env.NODE_ENV!=="production"?invariant(false,"Expected onMountComponent() to fire for the child before its parent includes it in onSetChildren()."):_prodInvariant("71"):void 0;if(nextChild.parentID==null){nextChild.parentID=id}!(nextChild.parentID===id)?process.env.NODE_ENV!=="production"?invariant(false,"Expected onBeforeMountComponent() parent and onSetChildren() to be consistent (%s has parents %s and %s).",nextChildID,nextChild.parentID,id):_prodInvariant("142",nextChildID,nextChild.parentID,id):void 0}},onBeforeMountComponent:function(id,element,parentID){var item={element:element,parentID:parentID,text:null,childIDs:[],isMounted:false,updateCount:0};setItem(id,item)},onBeforeUpdateComponent:function(id,element){var item=getItem(id);if(!item||!item.isMounted){return}item.element=element},onMountComponent:function(id){var item=getItem(id);!item?process.env.NODE_ENV!=="production"?invariant(false,"Item must have been set"):_prodInvariant("144"):void 0;item.isMounted=true;var isRoot=item.parentID===0;if(isRoot){addRoot(id)}},onUpdateComponent:function(id){var item=getItem(id);if(!item||!item.isMounted){return}item.updateCount++},onUnmountComponent:function(id){var item=getItem(id);if(item){item.isMounted=false;var isRoot=item.parentID===0;if(isRoot){removeRoot(id)}}unmountedIDs.push(id)},purgeUnmountedComponents:function(){if(ReactComponentTreeHook._preventPurging){return}for(var i=0;i<unmountedIDs.length;i++){var id=unmountedIDs[i];purgeDeep(id)}unmountedIDs.length=0},isMounted:function(id){var item=getItem(id);return item?item.isMounted:false},getCurrentStackAddendum:function(topElement){var info="";if(topElement){var name=getDisplayName(topElement);var owner=topElement._owner;info+=describeComponentFrame(name,topElement._source,owner&&owner.getName())}var currentOwner=ReactCurrentOwner.current;var id=currentOwner&&currentOwner._debugID;info+=ReactComponentTreeHook.getStackAddendumByID(id);return info},getStackAddendumByID:function(id){var info="";while(id){info+=describeID(id);id=ReactComponentTreeHook.getParentID(id)}return info},getChildIDs:function(id){var item=getItem(id);return item?item.childIDs:[]},getDisplayName:function(id){var element=ReactComponentTreeHook.getElement(id);if(!element){return null}return getDisplayName(element)},getElement:function(id){var item=getItem(id);return item?item.element:null},getOwnerID:function(id){var element=ReactComponentTreeHook.getElement(id);if(!element||!element._owner){return null}return element._owner._debugID},getParentID:function(id){var item=getItem(id);return item?item.parentID:null},getSource:function(id){var item=getItem(id);var element=item?item.element:null;var source=element!=null?element._source:null;return source},getText:function(id){var element=ReactComponentTreeHook.getElement(id);if(typeof element==="string"){return element}else if(typeof element==="number"){return""+element}else{return null}},getUpdateCount:function(id){var item=getItem(id);return item?item.updateCount:0},getRootIDs:getRootIDs,getRegisteredIDs:getItemIDs,pushNonStandardWarningStack:function(isCreatingElement,currentSource){if(typeof console.reactStack!=="function"){return}var stack=[];var currentOwner=ReactCurrentOwner.current;var id=currentOwner&&currentOwner._debugID;try{if(isCreatingElement){stack.push({name:id?ReactComponentTreeHook.getDisplayName(id):null,fileName:currentSource?currentSource.fileName:null,lineNumber:currentSource?currentSource.lineNumber:null})}while(id){var element=ReactComponentTreeHook.getElement(id);var parentID=ReactComponentTreeHook.getParentID(id);var ownerID=ReactComponentTreeHook.getOwnerID(id);var ownerName=ownerID?ReactComponentTreeHook.getDisplayName(ownerID):null;var source=element&&element._source;stack.push({name:ownerName,fileName:source?source.fileName:null,lineNumber:source?source.lineNumber:null});id=parentID}}catch(err){}console.reactStack(stack)},popNonStandardWarningStack:function(){if(typeof console.reactStackEnd!=="function"){return}console.reactStackEnd()}};module.exports=ReactComponentTreeHook}).call(this,require("_process"))},{"./ReactCurrentOwner":164,"./reactProdInvariant":181,_process:184,"fbjs/lib/invariant":18,"fbjs/lib/warning":25}],164:[function(require,module,exports){"use strict";var ReactCurrentOwner={current:null};module.exports=ReactCurrentOwner},{}],165:[function(require,module,exports){(function(process){"use strict";var ReactElement=require("./ReactElement");var createDOMFactory=ReactElement.createFactory;if(process.env.NODE_ENV!=="production"){var ReactElementValidator=require("./ReactElementValidator");createDOMFactory=ReactElementValidator.createFactory}var ReactDOMFactories={a:createDOMFactory("a"),abbr:createDOMFactory("abbr"),address:createDOMFactory("address"),area:createDOMFactory("area"),article:createDOMFactory("article"),aside:createDOMFactory("aside"),audio:createDOMFactory("audio"),b:createDOMFactory("b"),base:createDOMFactory("base"),bdi:createDOMFactory("bdi"),bdo:createDOMFactory("bdo"),big:createDOMFactory("big"),blockquote:createDOMFactory("blockquote"),body:createDOMFactory("body"),br:createDOMFactory("br"),button:createDOMFactory("button"),canvas:createDOMFactory("canvas"),caption:createDOMFactory("caption"),cite:createDOMFactory("cite"),code:createDOMFactory("code"),col:createDOMFactory("col"),colgroup:createDOMFactory("colgroup"),data:createDOMFactory("data"),datalist:createDOMFactory("datalist"),dd:createDOMFactory("dd"),del:createDOMFactory("del"),details:createDOMFactory("details"),dfn:createDOMFactory("dfn"),dialog:createDOMFactory("dialog"),div:createDOMFactory("div"),dl:createDOMFactory("dl"),dt:createDOMFactory("dt"),em:createDOMFactory("em"),embed:createDOMFactory("embed"),fieldset:createDOMFactory("fieldset"),figcaption:createDOMFactory("figcaption"),figure:createDOMFactory("figure"),footer:createDOMFactory("footer"),form:createDOMFactory("form"),h1:createDOMFactory("h1"),h2:createDOMFactory("h2"),h3:createDOMFactory("h3"),h4:createDOMFactory("h4"),h5:createDOMFactory("h5"),h6:createDOMFactory("h6"),head:createDOMFactory("head"),header:createDOMFactory("header"),hgroup:createDOMFactory("hgroup"),hr:createDOMFactory("hr"),html:createDOMFactory("html"),i:createDOMFactory("i"),iframe:createDOMFactory("iframe"),img:createDOMFactory("img"),input:createDOMFactory("input"),ins:createDOMFactory("ins"),kbd:createDOMFactory("kbd"),keygen:createDOMFactory("keygen"),label:createDOMFactory("label"),legend:createDOMFactory("legend"),li:createDOMFactory("li"),link:createDOMFactory("link"),main:createDOMFactory("main"),map:createDOMFactory("map"),mark:createDOMFactory("mark"),menu:createDOMFactory("menu"),menuitem:createDOMFactory("menuitem"),meta:createDOMFactory("meta"),meter:createDOMFactory("meter"),nav:createDOMFactory("nav"),noscript:createDOMFactory("noscript"),object:createDOMFactory("object"),ol:createDOMFactory("ol"),optgroup:createDOMFactory("optgroup"),option:createDOMFactory("option"),output:createDOMFactory("output"),p:createDOMFactory("p"),param:createDOMFactory("param"),picture:createDOMFactory("picture"),pre:createDOMFactory("pre"),progress:createDOMFactory("progress"),q:createDOMFactory("q"),rp:createDOMFactory("rp"),rt:createDOMFactory("rt"),ruby:createDOMFactory("ruby"),s:createDOMFactory("s"),samp:createDOMFactory("samp"),script:createDOMFactory("script"),section:createDOMFactory("section"),select:createDOMFactory("select"),small:createDOMFactory("small"),source:createDOMFactory("source"),span:createDOMFactory("span"),strong:createDOMFactory("strong"),style:createDOMFactory("style"),sub:createDOMFactory("sub"),summary:createDOMFactory("summary"),sup:createDOMFactory("sup"),table:createDOMFactory("table"),tbody:createDOMFactory("tbody"),td:createDOMFactory("td"),textarea:createDOMFactory("textarea"),tfoot:createDOMFactory("tfoot"),th:createDOMFactory("th"),thead:createDOMFactory("thead"),time:createDOMFactory("time"),title:createDOMFactory("title"),tr:createDOMFactory("tr"),track:createDOMFactory("track"),u:createDOMFactory("u"),ul:createDOMFactory("ul"),var:createDOMFactory("var"),video:createDOMFactory("video"),wbr:createDOMFactory("wbr"),circle:createDOMFactory("circle"),clipPath:createDOMFactory("clipPath"),defs:createDOMFactory("defs"),ellipse:createDOMFactory("ellipse"),g:createDOMFactory("g"),image:createDOMFactory("image"),line:createDOMFactory("line"),linearGradient:createDOMFactory("linearGradient"),mask:createDOMFactory("mask"),path:createDOMFactory("path"),pattern:createDOMFactory("pattern"),polygon:createDOMFactory("polygon"),polyline:createDOMFactory("polyline"),radialGradient:createDOMFactory("radialGradient"),rect:createDOMFactory("rect"),stop:createDOMFactory("stop"),svg:createDOMFactory("svg"),text:createDOMFactory("text"),tspan:createDOMFactory("tspan")};module.exports=ReactDOMFactories}).call(this,require("_process"))},{"./ReactElement":166,"./ReactElementValidator":168,_process:184}],166:[function(require,module,exports){(function(process){"use strict";var _assign=require("object-assign");var ReactCurrentOwner=require("./ReactCurrentOwner");var warning=require("fbjs/lib/warning");var canDefineProperty=require("./canDefineProperty");var hasOwnProperty=Object.prototype.hasOwnProperty;var REACT_ELEMENT_TYPE=require("./ReactElementSymbol");var RESERVED_PROPS={key:true,ref:true,__self:true,__source:true};var specialPropKeyWarningShown,specialPropRefWarningShown;function hasValidRef(config){if(process.env.NODE_ENV!=="production"){if(hasOwnProperty.call(config,"ref")){var getter=Object.getOwnPropertyDescriptor(config,"ref").get;if(getter&&getter.isReactWarning){return false}}}return config.ref!==undefined}function hasValidKey(config){if(process.env.NODE_ENV!=="production"){if(hasOwnProperty.call(config,"key")){var getter=Object.getOwnPropertyDescriptor(config,"key").get;if(getter&&getter.isReactWarning){return false}}}return config.key!==undefined}function defineKeyPropWarningGetter(props,displayName){var warnAboutAccessingKey=function(){if(!specialPropKeyWarningShown){specialPropKeyWarningShown=true;process.env.NODE_ENV!=="production"?warning(false,"%s: `key` is not a prop. Trying to access it will result "+"in `undefined` being returned. If you need to access the same "+"value within the child component, you should pass it as a different "+"prop. (https://fb.me/react-special-props)",displayName):void 0}};warnAboutAccessingKey.isReactWarning=true;Object.defineProperty(props,"key",{get:warnAboutAccessingKey,configurable:true})}function defineRefPropWarningGetter(props,displayName){var warnAboutAccessingRef=function(){if(!specialPropRefWarningShown){specialPropRefWarningShown=true;process.env.NODE_ENV!=="production"?warning(false,"%s: `ref` is not a prop. Trying to access it will result "+"in `undefined` being returned. If you need to access the same "+"value within the child component, you should pass it as a different "+"prop. (https://fb.me/react-special-props)",displayName):void 0}};warnAboutAccessingRef.isReactWarning=true;Object.defineProperty(props,"ref",{get:warnAboutAccessingRef,configurable:true})}var ReactElement=function(type,key,ref,self,source,owner,props){var element={$$typeof:REACT_ELEMENT_TYPE,type:type,key:key,ref:ref,props:props,_owner:owner};if(process.env.NODE_ENV!=="production"){element._store={};if(canDefineProperty){Object.defineProperty(element._store,"validated",{configurable:false,enumerable:false,writable:true,value:false});Object.defineProperty(element,"_self",{configurable:false,enumerable:false,writable:false,value:self});Object.defineProperty(element,"_source",{configurable:false,enumerable:false,writable:false,value:source})}else{element._store.validated=false;element._self=self;element._source=source}if(Object.freeze){Object.freeze(element.props);Object.freeze(element)}}return element};ReactElement.createElement=function(type,config,children){var propName;var props={};var key=null;var ref=null;var self=null;var source=null;if(config!=null){if(hasValidRef(config)){ref=config.ref}if(hasValidKey(config)){key=""+config.key}self=config.__self===undefined?null:config.__self;source=config.__source===undefined?null:config.__source;for(propName in config){if(hasOwnProperty.call(config,propName)&&!RESERVED_PROPS.hasOwnProperty(propName)){props[propName]=config[propName]}}}var childrenLength=arguments.length-2;if(childrenLength===1){props.children=children}else if(childrenLength>1){var childArray=Array(childrenLength);for(var i=0;i<childrenLength;i++){childArray[i]=arguments[i+2]}if(process.env.NODE_ENV!=="production"){if(Object.freeze){Object.freeze(childArray)}}props.children=childArray}if(type&&type.defaultProps){var defaultProps=type.defaultProps;for(propName in defaultProps){if(props[propName]===undefined){props[propName]=defaultProps[propName]}}}if(process.env.NODE_ENV!=="production"){if(key||ref){if(typeof props.$$typeof==="undefined"||props.$$typeof!==REACT_ELEMENT_TYPE){var displayName=typeof type==="function"?type.displayName||type.name||"Unknown":type;if(key){defineKeyPropWarningGetter(props,displayName)}if(ref){defineRefPropWarningGetter(props,displayName)}}}}return ReactElement(type,key,ref,self,source,ReactCurrentOwner.current,props)};ReactElement.createFactory=function(type){var factory=ReactElement.createElement.bind(null,type);factory.type=type;return factory};ReactElement.cloneAndReplaceKey=function(oldElement,newKey){var newElement=ReactElement(oldElement.type,newKey,oldElement.ref,oldElement._self,oldElement._source,oldElement._owner,oldElement.props);return newElement};ReactElement.cloneElement=function(element,config,children){var propName;var props=_assign({},element.props);var key=element.key;var ref=element.ref;var self=element._self;var source=element._source;var owner=element._owner;if(config!=null){if(hasValidRef(config)){ref=config.ref;owner=ReactCurrentOwner.current}if(hasValidKey(config)){key=""+config.key}var defaultProps;if(element.type&&element.type.defaultProps){defaultProps=element.type.defaultProps}for(propName in config){if(hasOwnProperty.call(config,propName)&&!RESERVED_PROPS.hasOwnProperty(propName)){if(config[propName]===undefined&&defaultProps!==undefined){props[propName]=defaultProps[propName]}else{props[propName]=config[propName]}}}}var childrenLength=arguments.length-2;if(childrenLength===1){props.children=children}else if(childrenLength>1){var childArray=Array(childrenLength);for(var i=0;i<childrenLength;i++){childArray[i]=arguments[i+2]}props.children=childArray}return ReactElement(element.type,key,ref,self,source,owner,props)};ReactElement.isValidElement=function(object){return typeof object==="object"&&object!==null&&object.$$typeof===REACT_ELEMENT_TYPE};module.exports=ReactElement}).call(this,require("_process"))},{"./ReactCurrentOwner":164,"./ReactElementSymbol":167,"./canDefineProperty":174,_process:184,"fbjs/lib/warning":25,"object-assign":26}],167:[function(require,module,exports){arguments[4][82][0].apply(exports,arguments)},{dup:82}],168:[function(require,module,exports){(function(process){"use strict";var ReactCurrentOwner=require("./ReactCurrentOwner");var ReactComponentTreeHook=require("./ReactComponentTreeHook");var ReactElement=require("./ReactElement");var checkReactTypeSpec=require("./checkReactTypeSpec");var canDefineProperty=require("./canDefineProperty");var getIteratorFn=require("./getIteratorFn");var warning=require("fbjs/lib/warning");var lowPriorityWarning=require("./lowPriorityWarning");function getDeclarationErrorAddendum(){if(ReactCurrentOwner.current){var name=ReactCurrentOwner.current.getName();if(name){return" Check the render method of `"+name+"`."}}return""}function getSourceInfoErrorAddendum(elementProps){if(elementProps!==null&&elementProps!==undefined&&elementProps.__source!==undefined){var source=elementProps.__source;var fileName=source.fileName.replace(/^.*[\\\/]/,"");var lineNumber=source.lineNumber;return" Check your code at "+fileName+":"+lineNumber+"."}return""}var ownerHasKeyUseWarning={};function getCurrentComponentErrorInfo(parentType){var info=getDeclarationErrorAddendum();if(!info){var parentName=typeof parentType==="string"?parentType:parentType.displayName||parentType.name;if(parentName){info=" Check the top-level render call using <"+parentName+">."}}return info}function validateExplicitKey(element,parentType){if(!element._store||element._store.validated||element.key!=null){return}element._store.validated=true;var memoizer=ownerHasKeyUseWarning.uniqueKey||(ownerHasKeyUseWarning.uniqueKey={});var currentComponentErrorInfo=getCurrentComponentErrorInfo(parentType);if(memoizer[currentComponentErrorInfo]){return}memoizer[currentComponentErrorInfo]=true;var childOwner="";if(element&&element._owner&&element._owner!==ReactCurrentOwner.current){childOwner=" It was passed a child from "+element._owner.getName()+"."}process.env.NODE_ENV!=="production"?warning(false,'Each child in an array or iterator should have a unique "key" prop.'+"%s%s See https://fb.me/react-warning-keys for more information.%s",currentComponentErrorInfo,childOwner,ReactComponentTreeHook.getCurrentStackAddendum(element)):void 0}function validateChildKeys(node,parentType){if(typeof node!=="object"){return}if(Array.isArray(node)){for(var i=0;i<node.length;i++){var child=node[i];if(ReactElement.isValidElement(child)){validateExplicitKey(child,parentType)}}}else if(ReactElement.isValidElement(node)){if(node._store){node._store.validated=true}}else if(node){var iteratorFn=getIteratorFn(node);if(iteratorFn){if(iteratorFn!==node.entries){var iterator=iteratorFn.call(node);var step;while(!(step=iterator.next()).done){if(ReactElement.isValidElement(step.value)){validateExplicitKey(step.value,parentType)}}}}}}function validatePropTypes(element){var componentClass=element.type;if(typeof componentClass!=="function"){return}var name=componentClass.displayName||componentClass.name;if(componentClass.propTypes){checkReactTypeSpec(componentClass.propTypes,element.props,"prop",name,element,null)}if(typeof componentClass.getDefaultProps==="function"){process.env.NODE_ENV!=="production"?warning(componentClass.getDefaultProps.isReactClassApproved,"getDefaultProps is only used on classic React.createClass "+"definitions. Use a static property named `defaultProps` instead."):void 0}}var ReactElementValidator={createElement:function(type,props,children){var validType=typeof type==="string"||typeof type==="function";if(!validType){if(typeof type!=="function"&&typeof type!=="string"){var info="";if(type===undefined||typeof type==="object"&&type!==null&&Object.keys(type).length===0){info+=" You likely forgot to export your component from the file "+"it's defined in."}var sourceInfo=getSourceInfoErrorAddendum(props);if(sourceInfo){info+=sourceInfo}else{info+=getDeclarationErrorAddendum()}info+=ReactComponentTreeHook.getCurrentStackAddendum();var currentSource=props!==null&&props!==undefined&&props.__source!==undefined?props.__source:null;ReactComponentTreeHook.pushNonStandardWarningStack(true,currentSource);process.env.NODE_ENV!=="production"?warning(false,"React.createElement: type is invalid -- expected a string (for "+"built-in components) or a class/function (for composite "+"components) but got: %s.%s",type==null?type:typeof type,info):void 0;ReactComponentTreeHook.popNonStandardWarningStack()}}var element=ReactElement.createElement.apply(this,arguments);if(element==null){return element}if(validType){for(var i=2;i<arguments.length;i++){validateChildKeys(arguments[i],type)}}validatePropTypes(element);return element},createFactory:function(type){var validatedFactory=ReactElementValidator.createElement.bind(null,type);validatedFactory.type=type;if(process.env.NODE_ENV!=="production"){if(canDefineProperty){Object.defineProperty(validatedFactory,"type",{enumerable:false,get:function(){lowPriorityWarning(false,"Factory.type is deprecated. Access the class directly "+"before passing it to createFactory.");Object.defineProperty(this,"type",{value:type});return type}})}}return validatedFactory},cloneElement:function(element,props,children){var newElement=ReactElement.cloneElement.apply(this,arguments);for(var i=2;i<arguments.length;i++){validateChildKeys(arguments[i],newElement.type)}validatePropTypes(newElement);return newElement}};module.exports=ReactElementValidator}).call(this,require("_process"))},{"./ReactComponentTreeHook":163,"./ReactCurrentOwner":164,"./ReactElement":166,"./canDefineProperty":174,"./checkReactTypeSpec":175,"./getIteratorFn":177,"./lowPriorityWarning":179,_process:184,"fbjs/lib/warning":25}],169:[function(require,module,exports){(function(process){"use strict";var warning=require("fbjs/lib/warning");function warnNoop(publicInstance,callerName){if(process.env.NODE_ENV!=="production"){var constructor=publicInstance.constructor;process.env.NODE_ENV!=="production"?warning(false,"%s(...): Can only update a mounted or mounting component. "+"This usually means you called %s() on an unmounted component. "+"This is a no-op. Please check the code for the %s component.",callerName,callerName,constructor&&(constructor.displayName||constructor.name)||"ReactClass"):void 0}}var ReactNoopUpdateQueue={isMounted:function(publicInstance){return false},enqueueCallback:function(publicInstance,callback){},enqueueForceUpdate:function(publicInstance){warnNoop(publicInstance,"forceUpdate")},enqueueReplaceState:function(publicInstance,completeState){warnNoop(publicInstance,"replaceState")},enqueueSetState:function(publicInstance,partialState){warnNoop(publicInstance,"setState")}};module.exports=ReactNoopUpdateQueue}).call(this,require("_process"))},{_process:184,"fbjs/lib/warning":25}],170:[function(require,module,exports){arguments[4][100][0].apply(exports,arguments)},{_process:184,dup:100}],171:[function(require,module,exports){"use strict";var _require=require("./ReactElement"),isValidElement=_require.isValidElement;var factory=require("prop-types/factory");module.exports=factory(isValidElement)},{"./ReactElement":166,"prop-types/factory":28}],172:[function(require,module,exports){arguments[4][101][0].apply(exports,arguments)},{dup:101}],173:[function(require,module,exports){arguments[4][109][0].apply(exports,arguments)},{dup:109}],174:[function(require,module,exports){(function(process){"use strict";var canDefineProperty=false;if(process.env.NODE_ENV!=="production"){try{Object.defineProperty({},"x",{get:function(){}});canDefineProperty=true}catch(x){}}module.exports=canDefineProperty}).call(this,require("_process"))},{_process:184}],175:[function(require,module,exports){(function(process){"use strict";var _prodInvariant=require("./reactProdInvariant");var ReactPropTypeLocationNames=require("./ReactPropTypeLocationNames");var ReactPropTypesSecret=require("./ReactPropTypesSecret");var invariant=require("fbjs/lib/invariant");var warning=require("fbjs/lib/warning");var ReactComponentTreeHook;if(typeof process!=="undefined"&&process.env&&process.env.NODE_ENV==="test"){ReactComponentTreeHook=require("./ReactComponentTreeHook")}var loggedTypeFailures={};function checkReactTypeSpec(typeSpecs,values,location,componentName,element,debugID){for(var typeSpecName in typeSpecs){if(typeSpecs.hasOwnProperty(typeSpecName)){var error;try{!(typeof typeSpecs[typeSpecName]==="function")?process.env.NODE_ENV!=="production"?invariant(false,"%s: %s type `%s` is invalid; it must be a function, usually from React.PropTypes.",componentName||"React class",ReactPropTypeLocationNames[location],typeSpecName):_prodInvariant("84",componentName||"React class",ReactPropTypeLocationNames[location],typeSpecName):void 0;error=typeSpecs[typeSpecName](values,typeSpecName,componentName,location,null,ReactPropTypesSecret)}catch(ex){error=ex}process.env.NODE_ENV!=="production"?warning(!error||error instanceof Error,"%s: type specification of %s `%s` is invalid; the type checker "+"function must return `null` or an `Error` but returned a %s. "+"You may have forgotten to pass an argument to the type checker "+"creator (arrayOf, instanceOf, objectOf, oneOf, oneOfType, and "+"shape all require an argument).",componentName||"React class",ReactPropTypeLocationNames[location],typeSpecName,typeof error):void 0;if(error instanceof Error&&!(error.message in loggedTypeFailures)){loggedTypeFailures[error.message]=true;var componentStackInfo="";if(process.env.NODE_ENV!=="production"){if(!ReactComponentTreeHook){ReactComponentTreeHook=require("./ReactComponentTreeHook")}if(debugID!==null){componentStackInfo=ReactComponentTreeHook.getStackAddendumByID(debugID)}else if(element!==null){componentStackInfo=ReactComponentTreeHook.getCurrentStackAddendum(element)}}process.env.NODE_ENV!=="production"?warning(false,"Failed %s type: %s%s",location,error.message,componentStackInfo):void 0}}}}module.exports=checkReactTypeSpec}).call(this,require("_process"))},{"./ReactComponentTreeHook":163,"./ReactPropTypeLocationNames":170,"./ReactPropTypesSecret":172,"./reactProdInvariant":181,_process:184,"fbjs/lib/invariant":18,"fbjs/lib/warning":25}],176:[function(require,module,exports){"use strict";var _require=require("./ReactBaseClasses"),Component=_require.Component;var _require2=require("./ReactElement"),isValidElement=_require2.isValidElement;var ReactNoopUpdateQueue=require("./ReactNoopUpdateQueue");var factory=require("create-react-class/factory");module.exports=factory(Component,isValidElement,ReactNoopUpdateQueue)},{"./ReactBaseClasses":161,"./ReactElement":166,"./ReactNoopUpdateQueue":169,"create-react-class/factory":2}],177:[function(require,module,exports){arguments[4][142][0].apply(exports,arguments)},{dup:142}],178:[function(require,module,exports){"use strict";var nextDebugID=1;function getNextDebugID(){return nextDebugID++}module.exports=getNextDebugID},{}],179:[function(require,module,exports){(function(process){"use strict";var lowPriorityWarning=function(){};if(process.env.NODE_ENV!=="production"){var printWarning=function(format){for(var _len=arguments.length,args=Array(_len>1?_len-1:0),_key=1;_key<_len;_key++){args[_key-1]=arguments[_key]}var argIndex=0;var message="Warning: "+format.replace(/%s/g,function(){return args[argIndex++]});if(typeof console!=="undefined"){console.warn(message)}try{throw new Error(message)}catch(x){}};lowPriorityWarning=function(condition,format){if(format===undefined){throw new Error("`warning(condition, format, ...args)` requires a warning "+"message argument")}if(!condition){for(var _len2=arguments.length,args=Array(_len2>2?_len2-2:0),_key2=2;_key2<_len2;_key2++){args[_key2-2]=arguments[_key2]}printWarning.apply(undefined,[format].concat(args))}}}module.exports=lowPriorityWarning}).call(this,require("_process"))},{_process:184}],180:[function(require,module,exports){(function(process){"use strict";var _prodInvariant=require("./reactProdInvariant");var ReactElement=require("./ReactElement");var invariant=require("fbjs/lib/invariant");function onlyChild(children){!ReactElement.isValidElement(children)?process.env.NODE_ENV!=="production"?invariant(false,"React.Children.only expected to receive a single React element child."):_prodInvariant("143"):void 0;return children}module.exports=onlyChild}).call(this,require("_process"))},{"./ReactElement":166,"./reactProdInvariant":181,_process:184,"fbjs/lib/invariant":18}],181:[function(require,module,exports){arguments[4][151][0].apply(exports,arguments)},{dup:151}],182:[function(require,module,exports){(function(process){"use strict";var _prodInvariant=require("./reactProdInvariant");var ReactCurrentOwner=require("./ReactCurrentOwner");var REACT_ELEMENT_TYPE=require("./ReactElementSymbol");var getIteratorFn=require("./getIteratorFn");var invariant=require("fbjs/lib/invariant");var KeyEscapeUtils=require("./KeyEscapeUtils");var warning=require("fbjs/lib/warning");var SEPARATOR=".";var SUBSEPARATOR=":";var didWarnAboutMaps=false;function getComponentKey(component,index){if(component&&typeof component==="object"&&component.key!=null){return KeyEscapeUtils.escape(component.key)}return index.toString(36)}function traverseAllChildrenImpl(children,nameSoFar,callback,traverseContext){var type=typeof children;if(type==="undefined"||type==="boolean"){children=null}if(children===null||type==="string"||type==="number"||type==="object"&&children.$$typeof===REACT_ELEMENT_TYPE){callback(traverseContext,children,nameSoFar===""?SEPARATOR+getComponentKey(children,0):nameSoFar);return 1}var child;var nextName;var subtreeCount=0;var nextNamePrefix=nameSoFar===""?SEPARATOR:nameSoFar+SUBSEPARATOR;if(Array.isArray(children)){for(var i=0;i<children.length;i++){child=children[i];nextName=nextNamePrefix+getComponentKey(child,i);subtreeCount+=traverseAllChildrenImpl(child,nextName,callback,traverseContext)}}else{var iteratorFn=getIteratorFn(children);if(iteratorFn){var iterator=iteratorFn.call(children);var step;if(iteratorFn!==children.entries){var ii=0;while(!(step=iterator.next()).done){child=step.value;nextName=nextNamePrefix+getComponentKey(child,ii++);subtreeCount+=traverseAllChildrenImpl(child,nextName,callback,traverseContext)}}else{if(process.env.NODE_ENV!=="production"){var mapsAsChildrenAddendum="";if(ReactCurrentOwner.current){var mapsAsChildrenOwnerName=ReactCurrentOwner.current.getName();if(mapsAsChildrenOwnerName){mapsAsChildrenAddendum=" Check the render method of `"+mapsAsChildrenOwnerName+"`."}}process.env.NODE_ENV!=="production"?warning(didWarnAboutMaps,"Using Maps as children is not yet fully supported. It is an "+"experimental feature that might be removed. Convert it to a "+"sequence / iterable of keyed ReactElements instead.%s",mapsAsChildrenAddendum):void 0;didWarnAboutMaps=true}while(!(step=iterator.next()).done){var entry=step.value;if(entry){child=entry[1];nextName=nextNamePrefix+KeyEscapeUtils.escape(entry[0])+SUBSEPARATOR+getComponentKey(child,0);subtreeCount+=traverseAllChildrenImpl(child,nextName,callback,traverseContext)}}}}else if(type==="object"){var addendum="";if(process.env.NODE_ENV!=="production"){addendum=" If you meant to render a collection of children, use an array "+"instead or wrap the object using createFragment(object) from the "+"React add-ons.";if(children._isReactElement){addendum=" It looks like you're using an element created by a different "+"version of React. Make sure to use only one copy of React."}if(ReactCurrentOwner.current){var name=ReactCurrentOwner.current.getName();if(name){addendum+=" Check the render method of `"+name+"`."}}}var childrenString=String(children);!false?process.env.NODE_ENV!=="production"?invariant(false,"Objects are not valid as a React child (found: %s).%s",childrenString==="[object Object]"?"object with keys {"+Object.keys(children).join(", ")+"}":childrenString,addendum):_prodInvariant("31",childrenString==="[object Object]"?"object with keys {"+Object.keys(children).join(", ")+"}":childrenString,addendum):void 0}}return subtreeCount}function traverseAllChildren(children,callback,traverseContext){if(children==null){return 0}return traverseAllChildrenImpl(children,"",callback,traverseContext)}module.exports=traverseAllChildren}).call(this,require("_process"))},{"./KeyEscapeUtils":158,"./ReactCurrentOwner":164,"./ReactElementSymbol":167,"./getIteratorFn":177,"./reactProdInvariant":181,_process:184,"fbjs/lib/invariant":18,"fbjs/lib/warning":25}],183:[function(require,module,exports){"use strict";module.exports=require("./lib/React")},{"./lib/React":160}],184:[function(require,module,exports){var process=module.exports={};var cachedSetTimeout;var cachedClearTimeout;function defaultSetTimout(){throw new Error("setTimeout has not been defined")}function defaultClearTimeout(){throw new Error("clearTimeout has not been defined")}(function(){try{if(typeof setTimeout==="function"){cachedSetTimeout=setTimeout}else{cachedSetTimeout=defaultSetTimout}}catch(e){cachedSetTimeout=defaultSetTimout}try{if(typeof clearTimeout==="function"){cachedClearTimeout=clearTimeout}else{cachedClearTimeout=defaultClearTimeout}}catch(e){cachedClearTimeout=defaultClearTimeout}})();function runTimeout(fun){if(cachedSetTimeout===setTimeout){return setTimeout(fun,0)}if((cachedSetTimeout===defaultSetTimout||!cachedSetTimeout)&&setTimeout){cachedSetTimeout=setTimeout;return setTimeout(fun,0)}try{return cachedSetTimeout(fun,0)}catch(e){try{return cachedSetTimeout.call(null,fun,0)}catch(e){return cachedSetTimeout.call(this,fun,0)}}}function runClearTimeout(marker){if(cachedClearTimeout===clearTimeout){return clearTimeout(marker)}if((cachedClearTimeout===defaultClearTimeout||!cachedClearTimeout)&&clearTimeout){cachedClearTimeout=clearTimeout;return clearTimeout(marker)}try{return cachedClearTimeout(marker)}catch(e){try{return cachedClearTimeout.call(null,marker)}catch(e){return cachedClearTimeout.call(this,marker)}}}var queue=[];var draining=false;var currentQueue;var queueIndex=-1;function cleanUpNextTick(){if(!draining||!currentQueue){return}draining=false;if(currentQueue.length){queue=currentQueue.concat(queue)}else{queueIndex=-1}if(queue.length){drainQueue()}}function drainQueue(){if(draining){return}var timeout=runTimeout(cleanUpNextTick);draining=true;var len=queue.length;while(len){currentQueue=queue;queue=[];while(++queueIndex<len){if(currentQueue){currentQueue[queueIndex].run()}}queueIndex=-1;len=queue.length}currentQueue=null;draining=false;runClearTimeout(timeout)}process.nextTick=function(fun){var args=new Array(arguments.length-1);if(arguments.length>1){for(var i=1;i<arguments.length;i++){args[i-1]=arguments[i]}}queue.push(new Item(fun,args));if(queue.length===1&&!draining){runTimeout(drainQueue)}};function Item(fun,array){this.fun=fun;this.array=array}Item.prototype.run=function(){this.fun.apply(null,this.array)};process.title="browser";process.browser=true;process.env={};process.argv=[];process.version="";process.versions={};function noop(){}process.on=noop;process.addListener=noop;process.once=noop;process.off=noop;process.removeListener=noop;process.removeAllListeners=noop;process.emit=noop;process.prependListener=noop;process.prependOnceListener=noop;process.listeners=function(name){return[]};process.binding=function(name){throw new Error("process.binding is not supported")};process.cwd=function(){return"/"};process.chdir=function(dir){throw new Error("process.chdir is not supported")};process.umask=function(){return 0}},{}]},{},[1]);






// values defined in Gen2.ClosureInfo







// thread status

/*
 * low-level heap object manipulation macros
 */
// GHCJS.Prim.JSVal







// GHCJS.Prim.JSException





// Exception dictionary for JSException


// SomeException






// GHC.Ptr.Ptr






// GHC.Integer.GMP.Internals
// Data.Maybe.Maybe




// #define HS_NOTHING h$nothing






// Data.List
// Data.Text




// Data.Text.Lazy





// black holes
// can we skip the indirection for black holes?






// resumable thunks


// general deconstruction



// retrieve  a numeric value that's possibly stored as an indirection



// generic lazy values
// generic data constructors and selectors
// unboxed tuple returns
// #define RETURN_UBX_TUP1(x) return x;

function h$concurEventCallback(async, action, ev) {
    var a = (h$c2(h$ap1_e,(action),((h$c1(h$ghcjszmprimZCGHCJSziPrimziJSVal_con_e, (ev))))));
    if(async) {
        h$run(a);
    } else {
        h$runSync(a, true);
    }
}
function h$hsprimitive_memcpy(dst_d, dst_o, doff, src_d, src_o, soff, len) {
  return h$primitive_memmove(dst_d, dst_o, doff, src_d, src_o, len);
}

function h$hsprimitive_memmove(dst_d, dst_o, doff, src_d, src_o, soff, len) {
  if(len === 0) return;
  var du8 = dst_d.u8, su8 = src_d.u8;
  for(var i=len-1;i>=0;i--) {
    du8[dst_o+i] = su8[src_o+i];
  }
}
function h$hsprimitive_memsetba_Word8 (p_d, off, n, x) { if(n > 0) { if(p_d.u8.fill) p_d.u8.fill(x, off, off + n); else for(var i=off; i<off+n; i++) p_d.u8[i] = x; } }
function h$hsprimitive_memsetba_Word16 (p_d, off, n, x) { if(n > 0) { if(p_d.u1.fill) p_d.u1.fill(x, off, off + n); else for(var i=off; i<off+n; i++) p_d.u1[i] = x; } }
function h$hsprimitive_memsetba_Word32 (p_d, off, n, x) { if(n > 0) { if(p_d.i3.fill) p_d.i3.fill(x, off, off + n); else for(var i=off; i<off+n; i++) p_d.i3[i] = x; } }
function h$hsprimitive_memsetba_Word (p_d, off, n, x) { if(n > 0) { if(p_d.i3.fill) p_d.i3.fill(x, off, off + n); else for(var i=off; i<off+n; i++) p_d.i3[i] = x; } }
function h$hsprimitive_memsetba_Float (p_d, off, n, x) { if(n > 0) { if(p_d.f3.fill) p_d.f3.fill(x, off, off + n); else for(var i=off; i<off+n; i++) p_d.f3[i] = x; } }
function h$hsprimitive_memsetba_Double (p_d, off, n, x) { if(n > 0) { if(p_d.f6.fill) p_d.f6.fill(x, off, off + n); else for(var i=off; i<off+n; i++) p_d.f6[i] = x; } }
function h$hsprimitive_memsetba_Char (p_d, off, n, x) { if(n > 0) { if(p_d.i3.fill) p_d.i3.fill(x, off, off + n); else for(var i=off; i<off+n; i++) p_d.i3[i] = x; } }

function h$hsprimitive_memset_Word8 (p_d, p_o, off, n, x) { var start = (p_o >> 0) + off; if(n > 0) { if(p_d.u8.fill) p_d.u8.fill(x, start, start + n); else for(var i=start; i<start+n; i++) p_d.u8[i] = x; } }
function h$hsprimitive_memset_Word16 (p_d, p_o, off, n, x) { var start = (p_o >> 1) + off; if(n > 0) { if(p_d.u1.fill) p_d.u1.fill(x, start, start + n); else for(var i=start; i<start+n; i++) p_d.u1[i] = x; } }
function h$hsprimitive_memset_Word32 (p_d, p_o, off, n, x) { var start = (p_o >> 2) + off; if(n > 0) { if(p_d.i3.fill) p_d.i3.fill(x, start, start + n); else for(var i=start; i<start+n; i++) p_d.i3[i] = x; } }
function h$hsprimitive_memset_Word (p_d, p_o, off, n, x) { var start = (p_o >> 2) + off; if(n > 0) { if(p_d.i3.fill) p_d.i3.fill(x, start, start + n); else for(var i=start; i<start+n; i++) p_d.i3[i] = x; } }
function h$hsprimitive_memset_Float (p_d, p_o, off, n, x) { var start = (p_o >> 2) + off; if(n > 0) { if(p_d.f3.fill) p_d.f3.fill(x, start, start + n); else for(var i=start; i<start+n; i++) p_d.f3[i] = x; } }
function h$hsprimitive_memset_Double (p_d, p_o, off, n, x) { var start = (p_o >> 3) + off; if(n > 0) { if(p_d.f6.fill) p_d.f6.fill(x, start, start + n); else for(var i=start; i<start+n; i++) p_d.f6[i] = x; } }
function h$hsprimitive_memset_Char (p_d, p_o, off, n, x) { var start = (p_o >> 2) + off; if(n > 0) { if(p_d.i3.fill) p_d.i3.fill(x, start, start + n); else for(var i=start; i<start+n; i++) p_d.i3[i] = x; } }

function h$hsprimitive_memsetba_Word64(p_d, off, n, x_1, x_2) {
  h$hsprimitive_memset_Word64(p_d, 0, off, n, x_1, x_2);
}

function h$hsprimitive_memset_Word64(p_d, p_o, off, n, x_1, x_2) {
  var start = (p_o >> 3) + off;
  if(n > 0) {
    var pi3 = p_d.i3;
    for(var i = 0; i < n; i++) {
      var o = (start + i) << 1;
      pi3[o] = x_1;
      pi3[o+1] = x_2;
    }
  }
}

function h$hsprimitive_memset_Ptr(p_d, p_o, off, n, x_1, x_2) {
  if(n > 0) {
    if(!p_d.arr) p_d.arr = [];
    var a = p_d.arr;
    for(var i = 0; i < n; i++) {
      a[p_o + ((off + i) << 2)] = [x_1, x_2];
    }
  }
}
// Copyright 2011 The Closure Library Authors. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS-IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/**
 * @fileoverview Abstract cryptographic hash interface.
 *
 * See goog.crypt.Sha1 and goog.crypt.Md5 for sample implementations.
 *
 */

goog.provide('goog.crypt.Hash');



/**
 * Create a cryptographic hash instance.
 *
 * @constructor
 * @struct
 */
goog.crypt.Hash = function() {
  /**
   * The block size for the hasher.
   * @type {number}
   */
  this.blockSize = -1;
};


/**
 * Resets the internal accumulator.
 */
goog.crypt.Hash.prototype.reset = goog.abstractMethod;


/**
 * Adds a byte array (array with values in [0-255] range) or a string (might
 * only contain 8-bit, i.e., Latin1 characters) to the internal accumulator.
 *
 * Many hash functions operate on blocks of data and implement optimizations
 * when a full chunk of data is readily available. Hence it is often preferable
 * to provide large chunks of data (a kilobyte or more) than to repeatedly
 * call the update method with few tens of bytes. If this is not possible, or
 * not feasible, it might be good to provide data in multiplies of hash block
 * size (often 64 bytes). Please see the implementation and performance tests
 * of your favourite hash.
 *
 * @param {Array<number>|Uint8Array|string} bytes Data used for the update.
 * @param {number=} opt_length Number of bytes to use.
 */
goog.crypt.Hash.prototype.update = goog.abstractMethod;


/**
 * @return {!Array<number>} The finalized hash computed
 *     from the internal accumulator.
 */
goog.crypt.Hash.prototype.digest = goog.abstractMethod;
// Copyright 2011 The Closure Library Authors. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS-IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/**
 * @fileoverview MD5 cryptographic hash.
 * Implementation of http://tools.ietf.org/html/rfc1321 with common
 * optimizations and tweaks (see http://en.wikipedia.org/wiki/MD5).
 *
 * Usage:
 *   var md5 = new goog.crypt.Md5();
 *   md5.update(bytes);
 *   var hash = md5.digest();
 *
 * Performance:
 *   Chrome 23              ~680 Mbit/s
 *   Chrome 13 (in a VM)    ~250 Mbit/s
 *   Firefox 6.0 (in a VM)  ~100 Mbit/s
 *   IE9 (in a VM)           ~27 Mbit/s
 *   Firefox 3.6             ~15 Mbit/s
 *   IE8 (in a VM)           ~13 Mbit/s
 *
 */

goog.provide('goog.crypt.Md5');

goog.require('goog.crypt.Hash');



/**
 * MD5 cryptographic hash constructor.
 * @constructor
 * @extends {goog.crypt.Hash}
 * @final
 * @struct
 */
goog.crypt.Md5 = function() {
  goog.crypt.Md5.base(this, 'constructor');

  this.blockSize = 512 / 8;

  /**
   * Holds the current values of accumulated A-D variables (MD buffer).
   * @type {!Array<number>}
   * @private
   */
  this.chain_ = new Array(4);

  /**
   * A buffer holding the data until the whole block can be processed.
   * @type {!Array<number>}
   * @private
   */
  this.block_ = new Array(this.blockSize);

  /**
   * The length of yet-unprocessed data as collected in the block.
   * @type {number}
   * @private
   */
  this.blockLength_ = 0;

  /**
   * The total length of the message so far.
   * @type {number}
   * @private
   */
  this.totalLength_ = 0;

  this.reset();
};
goog.inherits(goog.crypt.Md5, goog.crypt.Hash);


/**
 * Integer rotation constants used by the abbreviated implementation.
 * They are hardcoded in the unrolled implementation, so it is left
 * here commented out.
 * @type {Array<number>}
 * @private
 *
goog.crypt.Md5.S_ = [
  7, 12, 17, 22, 7, 12, 17, 22, 7, 12, 17, 22, 7, 12, 17, 22,
  5, 9, 14, 20, 5, 9, 14, 20, 5, 9, 14, 20, 5, 9, 14, 20,
  4, 11, 16, 23, 4, 11, 16, 23, 4, 11, 16, 23, 4, 11, 16, 23,
  6, 10, 15, 21, 6, 10, 15, 21, 6, 10, 15, 21, 6, 10, 15, 21
];
 */

/**
 * Sine function constants used by the abbreviated implementation.
 * They are hardcoded in the unrolled implementation, so it is left
 * here commented out.
 * @type {Array<number>}
 * @private
 *
goog.crypt.Md5.T_ = [
  0xd76aa478, 0xe8c7b756, 0x242070db, 0xc1bdceee,
  0xf57c0faf, 0x4787c62a, 0xa8304613, 0xfd469501,
  0x698098d8, 0x8b44f7af, 0xffff5bb1, 0x895cd7be,
  0x6b901122, 0xfd987193, 0xa679438e, 0x49b40821,
  0xf61e2562, 0xc040b340, 0x265e5a51, 0xe9b6c7aa,
  0xd62f105d, 0x02441453, 0xd8a1e681, 0xe7d3fbc8,
  0x21e1cde6, 0xc33707d6, 0xf4d50d87, 0x455a14ed,
  0xa9e3e905, 0xfcefa3f8, 0x676f02d9, 0x8d2a4c8a,
  0xfffa3942, 0x8771f681, 0x6d9d6122, 0xfde5380c,
  0xa4beea44, 0x4bdecfa9, 0xf6bb4b60, 0xbebfbc70,
  0x289b7ec6, 0xeaa127fa, 0xd4ef3085, 0x04881d05,
  0xd9d4d039, 0xe6db99e5, 0x1fa27cf8, 0xc4ac5665,
  0xf4292244, 0x432aff97, 0xab9423a7, 0xfc93a039,
  0x655b59c3, 0x8f0ccc92, 0xffeff47d, 0x85845dd1,
  0x6fa87e4f, 0xfe2ce6e0, 0xa3014314, 0x4e0811a1,
  0xf7537e82, 0xbd3af235, 0x2ad7d2bb, 0xeb86d391
];
 */


/** @override */
goog.crypt.Md5.prototype.reset = function() {
  this.chain_[0] = 0x67452301;
  this.chain_[1] = 0xefcdab89;
  this.chain_[2] = 0x98badcfe;
  this.chain_[3] = 0x10325476;

  this.blockLength_ = 0;
  this.totalLength_ = 0;
};


/**
 * Internal compress helper function. It takes a block of data (64 bytes)
 * and updates the accumulator.
 * @param {Array<number>|Uint8Array|string} buf The block to compress.
 * @param {number=} opt_offset Offset of the block in the buffer.
 * @private
 */
goog.crypt.Md5.prototype.compress_ = function(buf, opt_offset) {
  if (!opt_offset) {
    opt_offset = 0;
  }

  // We allocate the array every time, but it's cheap in practice.
  var X = new Array(16);

  // Get 16 little endian words. It is not worth unrolling this for Chrome 11.
  if (goog.isString(buf)) {
    for (var i = 0; i < 16; ++i) {
      X[i] = (buf.charCodeAt(opt_offset++)) |
             (buf.charCodeAt(opt_offset++) << 8) |
             (buf.charCodeAt(opt_offset++) << 16) |
             (buf.charCodeAt(opt_offset++) << 24);
    }
  } else {
    for (var i = 0; i < 16; ++i) {
      X[i] = (buf[opt_offset++]) |
             (buf[opt_offset++] << 8) |
             (buf[opt_offset++] << 16) |
             (buf[opt_offset++] << 24);
    }
  }

  var A = this.chain_[0];
  var B = this.chain_[1];
  var C = this.chain_[2];
  var D = this.chain_[3];
  var sum = 0;

  /*
   * This is an abbreviated implementation, it is left here commented out for
   * reference purposes. See below for an unrolled version in use.
   *
  var f, n, tmp;
  for (var i = 0; i < 64; ++i) {

    if (i < 16) {
      f = (D ^ (B & (C ^ D)));
      n = i;
    } else if (i < 32) {
      f = (C ^ (D & (B ^ C)));
      n = (5 * i + 1) % 16;
    } else if (i < 48) {
      f = (B ^ C ^ D);
      n = (3 * i + 5) % 16;
    } else {
      f = (C ^ (B | (~D)));
      n = (7 * i) % 16;
    }

    tmp = D;
    D = C;
    C = B;
    sum = (A + f + goog.crypt.Md5.T_[i] + X[n]) & 0xffffffff;
    B += ((sum << goog.crypt.Md5.S_[i]) & 0xffffffff) |
         (sum >>> (32 - goog.crypt.Md5.S_[i]));
    A = tmp;
  }
   */

  /*
   * This is an unrolled MD5 implementation, which gives ~30% speedup compared
   * to the abbreviated implementation above, as measured on Chrome 11. It is
   * important to keep 32-bit croppings to minimum and inline the integer
   * rotation.
   */
  sum = (A + (D ^ (B & (C ^ D))) + X[0] + 0xd76aa478) & 0xffffffff;
  A = B + (((sum << 7) & 0xffffffff) | (sum >>> 25));
  sum = (D + (C ^ (A & (B ^ C))) + X[1] + 0xe8c7b756) & 0xffffffff;
  D = A + (((sum << 12) & 0xffffffff) | (sum >>> 20));
  sum = (C + (B ^ (D & (A ^ B))) + X[2] + 0x242070db) & 0xffffffff;
  C = D + (((sum << 17) & 0xffffffff) | (sum >>> 15));
  sum = (B + (A ^ (C & (D ^ A))) + X[3] + 0xc1bdceee) & 0xffffffff;
  B = C + (((sum << 22) & 0xffffffff) | (sum >>> 10));
  sum = (A + (D ^ (B & (C ^ D))) + X[4] + 0xf57c0faf) & 0xffffffff;
  A = B + (((sum << 7) & 0xffffffff) | (sum >>> 25));
  sum = (D + (C ^ (A & (B ^ C))) + X[5] + 0x4787c62a) & 0xffffffff;
  D = A + (((sum << 12) & 0xffffffff) | (sum >>> 20));
  sum = (C + (B ^ (D & (A ^ B))) + X[6] + 0xa8304613) & 0xffffffff;
  C = D + (((sum << 17) & 0xffffffff) | (sum >>> 15));
  sum = (B + (A ^ (C & (D ^ A))) + X[7] + 0xfd469501) & 0xffffffff;
  B = C + (((sum << 22) & 0xffffffff) | (sum >>> 10));
  sum = (A + (D ^ (B & (C ^ D))) + X[8] + 0x698098d8) & 0xffffffff;
  A = B + (((sum << 7) & 0xffffffff) | (sum >>> 25));
  sum = (D + (C ^ (A & (B ^ C))) + X[9] + 0x8b44f7af) & 0xffffffff;
  D = A + (((sum << 12) & 0xffffffff) | (sum >>> 20));
  sum = (C + (B ^ (D & (A ^ B))) + X[10] + 0xffff5bb1) & 0xffffffff;
  C = D + (((sum << 17) & 0xffffffff) | (sum >>> 15));
  sum = (B + (A ^ (C & (D ^ A))) + X[11] + 0x895cd7be) & 0xffffffff;
  B = C + (((sum << 22) & 0xffffffff) | (sum >>> 10));
  sum = (A + (D ^ (B & (C ^ D))) + X[12] + 0x6b901122) & 0xffffffff;
  A = B + (((sum << 7) & 0xffffffff) | (sum >>> 25));
  sum = (D + (C ^ (A & (B ^ C))) + X[13] + 0xfd987193) & 0xffffffff;
  D = A + (((sum << 12) & 0xffffffff) | (sum >>> 20));
  sum = (C + (B ^ (D & (A ^ B))) + X[14] + 0xa679438e) & 0xffffffff;
  C = D + (((sum << 17) & 0xffffffff) | (sum >>> 15));
  sum = (B + (A ^ (C & (D ^ A))) + X[15] + 0x49b40821) & 0xffffffff;
  B = C + (((sum << 22) & 0xffffffff) | (sum >>> 10));
  sum = (A + (C ^ (D & (B ^ C))) + X[1] + 0xf61e2562) & 0xffffffff;
  A = B + (((sum << 5) & 0xffffffff) | (sum >>> 27));
  sum = (D + (B ^ (C & (A ^ B))) + X[6] + 0xc040b340) & 0xffffffff;
  D = A + (((sum << 9) & 0xffffffff) | (sum >>> 23));
  sum = (C + (A ^ (B & (D ^ A))) + X[11] + 0x265e5a51) & 0xffffffff;
  C = D + (((sum << 14) & 0xffffffff) | (sum >>> 18));
  sum = (B + (D ^ (A & (C ^ D))) + X[0] + 0xe9b6c7aa) & 0xffffffff;
  B = C + (((sum << 20) & 0xffffffff) | (sum >>> 12));
  sum = (A + (C ^ (D & (B ^ C))) + X[5] + 0xd62f105d) & 0xffffffff;
  A = B + (((sum << 5) & 0xffffffff) | (sum >>> 27));
  sum = (D + (B ^ (C & (A ^ B))) + X[10] + 0x02441453) & 0xffffffff;
  D = A + (((sum << 9) & 0xffffffff) | (sum >>> 23));
  sum = (C + (A ^ (B & (D ^ A))) + X[15] + 0xd8a1e681) & 0xffffffff;
  C = D + (((sum << 14) & 0xffffffff) | (sum >>> 18));
  sum = (B + (D ^ (A & (C ^ D))) + X[4] + 0xe7d3fbc8) & 0xffffffff;
  B = C + (((sum << 20) & 0xffffffff) | (sum >>> 12));
  sum = (A + (C ^ (D & (B ^ C))) + X[9] + 0x21e1cde6) & 0xffffffff;
  A = B + (((sum << 5) & 0xffffffff) | (sum >>> 27));
  sum = (D + (B ^ (C & (A ^ B))) + X[14] + 0xc33707d6) & 0xffffffff;
  D = A + (((sum << 9) & 0xffffffff) | (sum >>> 23));
  sum = (C + (A ^ (B & (D ^ A))) + X[3] + 0xf4d50d87) & 0xffffffff;
  C = D + (((sum << 14) & 0xffffffff) | (sum >>> 18));
  sum = (B + (D ^ (A & (C ^ D))) + X[8] + 0x455a14ed) & 0xffffffff;
  B = C + (((sum << 20) & 0xffffffff) | (sum >>> 12));
  sum = (A + (C ^ (D & (B ^ C))) + X[13] + 0xa9e3e905) & 0xffffffff;
  A = B + (((sum << 5) & 0xffffffff) | (sum >>> 27));
  sum = (D + (B ^ (C & (A ^ B))) + X[2] + 0xfcefa3f8) & 0xffffffff;
  D = A + (((sum << 9) & 0xffffffff) | (sum >>> 23));
  sum = (C + (A ^ (B & (D ^ A))) + X[7] + 0x676f02d9) & 0xffffffff;
  C = D + (((sum << 14) & 0xffffffff) | (sum >>> 18));
  sum = (B + (D ^ (A & (C ^ D))) + X[12] + 0x8d2a4c8a) & 0xffffffff;
  B = C + (((sum << 20) & 0xffffffff) | (sum >>> 12));
  sum = (A + (B ^ C ^ D) + X[5] + 0xfffa3942) & 0xffffffff;
  A = B + (((sum << 4) & 0xffffffff) | (sum >>> 28));
  sum = (D + (A ^ B ^ C) + X[8] + 0x8771f681) & 0xffffffff;
  D = A + (((sum << 11) & 0xffffffff) | (sum >>> 21));
  sum = (C + (D ^ A ^ B) + X[11] + 0x6d9d6122) & 0xffffffff;
  C = D + (((sum << 16) & 0xffffffff) | (sum >>> 16));
  sum = (B + (C ^ D ^ A) + X[14] + 0xfde5380c) & 0xffffffff;
  B = C + (((sum << 23) & 0xffffffff) | (sum >>> 9));
  sum = (A + (B ^ C ^ D) + X[1] + 0xa4beea44) & 0xffffffff;
  A = B + (((sum << 4) & 0xffffffff) | (sum >>> 28));
  sum = (D + (A ^ B ^ C) + X[4] + 0x4bdecfa9) & 0xffffffff;
  D = A + (((sum << 11) & 0xffffffff) | (sum >>> 21));
  sum = (C + (D ^ A ^ B) + X[7] + 0xf6bb4b60) & 0xffffffff;
  C = D + (((sum << 16) & 0xffffffff) | (sum >>> 16));
  sum = (B + (C ^ D ^ A) + X[10] + 0xbebfbc70) & 0xffffffff;
  B = C + (((sum << 23) & 0xffffffff) | (sum >>> 9));
  sum = (A + (B ^ C ^ D) + X[13] + 0x289b7ec6) & 0xffffffff;
  A = B + (((sum << 4) & 0xffffffff) | (sum >>> 28));
  sum = (D + (A ^ B ^ C) + X[0] + 0xeaa127fa) & 0xffffffff;
  D = A + (((sum << 11) & 0xffffffff) | (sum >>> 21));
  sum = (C + (D ^ A ^ B) + X[3] + 0xd4ef3085) & 0xffffffff;
  C = D + (((sum << 16) & 0xffffffff) | (sum >>> 16));
  sum = (B + (C ^ D ^ A) + X[6] + 0x04881d05) & 0xffffffff;
  B = C + (((sum << 23) & 0xffffffff) | (sum >>> 9));
  sum = (A + (B ^ C ^ D) + X[9] + 0xd9d4d039) & 0xffffffff;
  A = B + (((sum << 4) & 0xffffffff) | (sum >>> 28));
  sum = (D + (A ^ B ^ C) + X[12] + 0xe6db99e5) & 0xffffffff;
  D = A + (((sum << 11) & 0xffffffff) | (sum >>> 21));
  sum = (C + (D ^ A ^ B) + X[15] + 0x1fa27cf8) & 0xffffffff;
  C = D + (((sum << 16) & 0xffffffff) | (sum >>> 16));
  sum = (B + (C ^ D ^ A) + X[2] + 0xc4ac5665) & 0xffffffff;
  B = C + (((sum << 23) & 0xffffffff) | (sum >>> 9));
  sum = (A + (C ^ (B | (~D))) + X[0] + 0xf4292244) & 0xffffffff;
  A = B + (((sum << 6) & 0xffffffff) | (sum >>> 26));
  sum = (D + (B ^ (A | (~C))) + X[7] + 0x432aff97) & 0xffffffff;
  D = A + (((sum << 10) & 0xffffffff) | (sum >>> 22));
  sum = (C + (A ^ (D | (~B))) + X[14] + 0xab9423a7) & 0xffffffff;
  C = D + (((sum << 15) & 0xffffffff) | (sum >>> 17));
  sum = (B + (D ^ (C | (~A))) + X[5] + 0xfc93a039) & 0xffffffff;
  B = C + (((sum << 21) & 0xffffffff) | (sum >>> 11));
  sum = (A + (C ^ (B | (~D))) + X[12] + 0x655b59c3) & 0xffffffff;
  A = B + (((sum << 6) & 0xffffffff) | (sum >>> 26));
  sum = (D + (B ^ (A | (~C))) + X[3] + 0x8f0ccc92) & 0xffffffff;
  D = A + (((sum << 10) & 0xffffffff) | (sum >>> 22));
  sum = (C + (A ^ (D | (~B))) + X[10] + 0xffeff47d) & 0xffffffff;
  C = D + (((sum << 15) & 0xffffffff) | (sum >>> 17));
  sum = (B + (D ^ (C | (~A))) + X[1] + 0x85845dd1) & 0xffffffff;
  B = C + (((sum << 21) & 0xffffffff) | (sum >>> 11));
  sum = (A + (C ^ (B | (~D))) + X[8] + 0x6fa87e4f) & 0xffffffff;
  A = B + (((sum << 6) & 0xffffffff) | (sum >>> 26));
  sum = (D + (B ^ (A | (~C))) + X[15] + 0xfe2ce6e0) & 0xffffffff;
  D = A + (((sum << 10) & 0xffffffff) | (sum >>> 22));
  sum = (C + (A ^ (D | (~B))) + X[6] + 0xa3014314) & 0xffffffff;
  C = D + (((sum << 15) & 0xffffffff) | (sum >>> 17));
  sum = (B + (D ^ (C | (~A))) + X[13] + 0x4e0811a1) & 0xffffffff;
  B = C + (((sum << 21) & 0xffffffff) | (sum >>> 11));
  sum = (A + (C ^ (B | (~D))) + X[4] + 0xf7537e82) & 0xffffffff;
  A = B + (((sum << 6) & 0xffffffff) | (sum >>> 26));
  sum = (D + (B ^ (A | (~C))) + X[11] + 0xbd3af235) & 0xffffffff;
  D = A + (((sum << 10) & 0xffffffff) | (sum >>> 22));
  sum = (C + (A ^ (D | (~B))) + X[2] + 0x2ad7d2bb) & 0xffffffff;
  C = D + (((sum << 15) & 0xffffffff) | (sum >>> 17));
  sum = (B + (D ^ (C | (~A))) + X[9] + 0xeb86d391) & 0xffffffff;
  B = C + (((sum << 21) & 0xffffffff) | (sum >>> 11));

  this.chain_[0] = (this.chain_[0] + A) & 0xffffffff;
  this.chain_[1] = (this.chain_[1] + B) & 0xffffffff;
  this.chain_[2] = (this.chain_[2] + C) & 0xffffffff;
  this.chain_[3] = (this.chain_[3] + D) & 0xffffffff;
};


/** @override */
goog.crypt.Md5.prototype.update = function(bytes, opt_length) {
  if (!goog.isDef(opt_length)) {
    opt_length = bytes.length;
  }
  var lengthMinusBlock = opt_length - this.blockSize;

  // Copy some object properties to local variables in order to save on access
  // time from inside the loop (~10% speedup was observed on Chrome 11).
  var block = this.block_;
  var blockLength = this.blockLength_;
  var i = 0;

  // The outer while loop should execute at most twice.
  while (i < opt_length) {
    // When we have no data in the block to top up, we can directly process the
    // input buffer (assuming it contains sufficient data). This gives ~30%
    // speedup on Chrome 14 and ~70% speedup on Firefox 6.0, but requires that
    // the data is provided in large chunks (or in multiples of 64 bytes).
    if (blockLength == 0) {
      while (i <= lengthMinusBlock) {
        this.compress_(bytes, i);
        i += this.blockSize;
      }
    }

    if (goog.isString(bytes)) {
      while (i < opt_length) {
        block[blockLength++] = bytes.charCodeAt(i++);
        if (blockLength == this.blockSize) {
          this.compress_(block);
          blockLength = 0;
          // Jump to the outer loop so we use the full-block optimization.
          break;
        }
      }
    } else {
      while (i < opt_length) {
        block[blockLength++] = bytes[i++];
        if (blockLength == this.blockSize) {
          this.compress_(block);
          blockLength = 0;
          // Jump to the outer loop so we use the full-block optimization.
          break;
        }
      }
    }
  }

  this.blockLength_ = blockLength;
  this.totalLength_ += opt_length;
};


/** @override */
goog.crypt.Md5.prototype.digest = function() {
  // This must accommodate at least 1 padding byte (0x80), 8 bytes of
  // total bitlength, and must end at a 64-byte boundary.
  var pad = new Array((this.blockLength_ < 56 ?
                       this.blockSize :
                       this.blockSize * 2) - this.blockLength_);

  // Add padding: 0x80 0x00*
  pad[0] = 0x80;
  for (var i = 1; i < pad.length - 8; ++i) {
    pad[i] = 0;
  }
  // Add the total number of bits, little endian 64-bit integer.
  var totalBits = this.totalLength_ * 8;
  for (var i = pad.length - 8; i < pad.length; ++i) {
    pad[i] = totalBits & 0xff;
    totalBits /= 0x100; // Don't use bit-shifting here!
  }
  this.update(pad);

  var digest = new Array(16);
  var n = 0;
  for (var i = 0; i < 4; ++i) {
    for (var j = 0; j < 32; j += 8) {
      digest[n++] = (this.chain_[i] >>> j) & 0xff;
    }
  }
  return digest;
};




/* include/HsBaseConfig.h.  Generated from HsBaseConfig.h.in by configure.  */
/* include/HsBaseConfig.h.in.  Generated from configure.ac by autoheader.  */

/* The value of E2BIG. */


/* The value of EACCES. */


/* The value of EADDRINUSE. */


/* The value of EADDRNOTAVAIL. */


/* The value of EADV. */


/* The value of EAFNOSUPPORT. */


/* The value of EAGAIN. */


/* The value of EALREADY. */


/* The value of EBADF. */


/* The value of EBADMSG. */


/* The value of EBADRPC. */


/* The value of EBUSY. */


/* The value of ECHILD. */


/* The value of ECOMM. */


/* The value of ECONNABORTED. */


/* The value of ECONNREFUSED. */


/* The value of ECONNRESET. */


/* The value of EDEADLK. */


/* The value of EDESTADDRREQ. */


/* The value of EDIRTY. */


/* The value of EDOM. */


/* The value of EDQUOT. */


/* The value of EEXIST. */


/* The value of EFAULT. */


/* The value of EFBIG. */


/* The value of EFTYPE. */


/* The value of EHOSTDOWN. */


/* The value of EHOSTUNREACH. */


/* The value of EIDRM. */


/* The value of EILSEQ. */


/* The value of EINPROGRESS. */


/* The value of EINTR. */


/* The value of EINVAL. */


/* The value of EIO. */


/* The value of EISCONN. */


/* The value of EISDIR. */


/* The value of ELOOP. */


/* The value of EMFILE. */


/* The value of EMLINK. */


/* The value of EMSGSIZE. */


/* The value of EMULTIHOP. */


/* The value of ENAMETOOLONG. */


/* The value of ENETDOWN. */


/* The value of ENETRESET. */


/* The value of ENETUNREACH. */


/* The value of ENFILE. */


/* The value of ENOBUFS. */


/* The value of ENOCIGAR. */


/* The value of ENODATA. */


/* The value of ENODEV. */


/* The value of ENOENT. */


/* The value of ENOEXEC. */


/* The value of ENOLCK. */


/* The value of ENOLINK. */


/* The value of ENOMEM. */


/* The value of ENOMSG. */


/* The value of ENONET. */


/* The value of ENOPROTOOPT. */


/* The value of ENOSPC. */


/* The value of ENOSR. */


/* The value of ENOSTR. */


/* The value of ENOSYS. */


/* The value of ENOTBLK. */


/* The value of ENOTCONN. */


/* The value of ENOTDIR. */


/* The value of ENOTEMPTY. */


/* The value of ENOTSOCK. */


/* The value of ENOTSUP. */


/* The value of ENOTTY. */


/* The value of ENXIO. */


/* The value of EOPNOTSUPP. */


/* The value of EPERM. */


/* The value of EPFNOSUPPORT. */


/* The value of EPIPE. */


/* The value of EPROCLIM. */


/* The value of EPROCUNAVAIL. */


/* The value of EPROGMISMATCH. */


/* The value of EPROGUNAVAIL. */


/* The value of EPROTO. */


/* The value of EPROTONOSUPPORT. */


/* The value of EPROTOTYPE. */


/* The value of ERANGE. */


/* The value of EREMCHG. */


/* The value of EREMOTE. */


/* The value of EROFS. */


/* The value of ERPCMISMATCH. */


/* The value of ERREMOTE. */


/* The value of ESHUTDOWN. */


/* The value of ESOCKTNOSUPPORT. */


/* The value of ESPIPE. */


/* The value of ESRCH. */


/* The value of ESRMNT. */


/* The value of ESTALE. */


/* The value of ETIME. */


/* The value of ETIMEDOUT. */


/* The value of ETOOMANYREFS. */


/* The value of ETXTBSY. */


/* The value of EUSERS. */


/* The value of EWOULDBLOCK. */


/* The value of EXDEV. */


/* The value of O_BINARY. */


/* The value of SIGINT. */


/* Define to 1 if you have the `clock_gettime' function. */
/* #undef HAVE_CLOCK_GETTIME */

/* Define to 1 if you have the <ctype.h> header file. */


/* Define if you have epoll support. */
/* #undef HAVE_EPOLL */

/* Define to 1 if you have the `epoll_ctl' function. */
/* #undef HAVE_EPOLL_CTL */

/* Define to 1 if you have the <errno.h> header file. */


/* Define to 1 if you have the `eventfd' function. */
/* #undef HAVE_EVENTFD */

/* Define to 1 if you have the <fcntl.h> header file. */


/* Define to 1 if you have the `ftruncate' function. */


/* Define to 1 if you have the `getclock' function. */
/* #undef HAVE_GETCLOCK */

/* Define to 1 if you have the `getrusage' function. */


/* Define to 1 if you have the <inttypes.h> header file. */


/* Define to 1 if you have the `iswspace' function. */


/* Define to 1 if you have the `kevent' function. */


/* Define to 1 if you have the `kevent64' function. */


/* Define if you have kqueue support. */


/* Define to 1 if you have the <langinfo.h> header file. */


/* Define to 1 if you have libcharset. */


/* Define to 1 if you have the `rt' library (-lrt). */
/* #undef HAVE_LIBRT */

/* Define to 1 if you have the <limits.h> header file. */


/* Define to 1 if the system has the type `long long'. */


/* Define to 1 if you have the `lstat' function. */


/* Define to 1 if you have the <memory.h> header file. */


/* Define if you have poll support. */


/* Define to 1 if you have the <poll.h> header file. */


/* Define to 1 if you have the <signal.h> header file. */


/* Define to 1 if you have the <stdint.h> header file. */


/* Define to 1 if you have the <stdlib.h> header file. */


/* Define to 1 if you have the <strings.h> header file. */


/* Define to 1 if you have the <string.h> header file. */


/* Define to 1 if you have the <sys/epoll.h> header file. */
/* #undef HAVE_SYS_EPOLL_H */

/* Define to 1 if you have the <sys/eventfd.h> header file. */
/* #undef HAVE_SYS_EVENTFD_H */

/* Define to 1 if you have the <sys/event.h> header file. */


/* Define to 1 if you have the <sys/resource.h> header file. */


/* Define to 1 if you have the <sys/select.h> header file. */


/* Define to 1 if you have the <sys/stat.h> header file. */


/* Define to 1 if you have the <sys/syscall.h> header file. */


/* Define to 1 if you have the <sys/timeb.h> header file. */


/* Define to 1 if you have the <sys/timers.h> header file. */
/* #undef HAVE_SYS_TIMERS_H */

/* Define to 1 if you have the <sys/times.h> header file. */


/* Define to 1 if you have the <sys/time.h> header file. */


/* Define to 1 if you have the <sys/types.h> header file. */


/* Define to 1 if you have the <sys/utsname.h> header file. */


/* Define to 1 if you have the <sys/wait.h> header file. */


/* Define to 1 if you have the <termios.h> header file. */


/* Define to 1 if you have the `times' function. */


/* Define to 1 if you have the <time.h> header file. */


/* Define to 1 if you have the <unistd.h> header file. */


/* Define to 1 if you have the <utime.h> header file. */


/* Define to 1 if you have the <wctype.h> header file. */


/* Define to 1 if you have the <windows.h> header file. */
/* #undef HAVE_WINDOWS_H */

/* Define to 1 if you have the <winsock.h> header file. */
/* #undef HAVE_WINSOCK_H */

/* Define to 1 if you have the `_chsize' function. */
/* #undef HAVE__CHSIZE */

/* Define to Haskell type for cc_t */


/* Define to Haskell type for char */


/* Define to Haskell type for clock_t */


/* Define to Haskell type for dev_t */


/* Define to Haskell type for double */


/* Define to Haskell type for float */


/* Define to Haskell type for gid_t */


/* Define to Haskell type for ino_t */


/* Define to Haskell type for int */


/* Define to Haskell type for intmax_t */


/* Define to Haskell type for intptr_t */


/* Define to Haskell type for long */


/* Define to Haskell type for long long */


/* Define to Haskell type for mode_t */


/* Define to Haskell type for nlink_t */


/* Define to Haskell type for off_t */


/* Define to Haskell type for pid_t */


/* Define to Haskell type for ptrdiff_t */


/* Define to Haskell type for rlim_t */


/* Define to Haskell type for short */


/* Define to Haskell type for signed char */


/* Define to Haskell type for sig_atomic_t */


/* Define to Haskell type for size_t */


/* Define to Haskell type for speed_t */


/* Define to Haskell type for ssize_t */


/* Define to Haskell type for suseconds_t */


/* Define to Haskell type for tcflag_t */


/* Define to Haskell type for time_t */


/* Define to Haskell type for uid_t */


/* Define to Haskell type for uintmax_t */


/* Define to Haskell type for uintptr_t */


/* Define to Haskell type for unsigned char */


/* Define to Haskell type for unsigned int */


/* Define to Haskell type for unsigned long */


/* Define to Haskell type for unsigned long long */


/* Define to Haskell type for unsigned short */


/* Define to Haskell type for useconds_t */


/* Define to Haskell type for wchar_t */


/* Define to the address where bug reports for this package should be sent. */


/* Define to the full name of this package. */


/* Define to the full name and version of this package. */


/* Define to the one symbol short name of this package. */


/* Define to the home page for this package. */


/* Define to the version of this package. */


/* The size of `kev.filter', as computed by sizeof. */


/* The size of `kev.flags', as computed by sizeof. */


/* The size of `struct MD5Context', as computed by sizeof. */


/* Define to 1 if you have the ANSI C header files. */


/* Number of bits in a file offset, on hosts where this is settable. */
/* #undef _FILE_OFFSET_BITS */

/* Define for large files, on AIX-style hosts. */
/* #undef _LARGE_FILES */






// values defined in Gen2.ClosureInfo







// thread status

/*
 * low-level heap object manipulation macros
 */
// GHCJS.Prim.JSVal







// GHCJS.Prim.JSException





// Exception dictionary for JSException


// SomeException






// GHC.Ptr.Ptr






// GHC.Integer.GMP.Internals
// Data.Maybe.Maybe




// #define HS_NOTHING h$nothing






// Data.List
// Data.Text




// Data.Text.Lazy





// black holes
// can we skip the indirection for black holes?






// resumable thunks


// general deconstruction



// retrieve  a numeric value that's possibly stored as an indirection



// generic lazy values
// generic data constructors and selectors
// unboxed tuple returns
// #define RETURN_UBX_TUP1(x) return x;

// #define GHCJS_TRACE_IO 1
function h$base_access(file, file_off, mode, c) {
                           ;

    if(h$isNode) {
        h$fs.stat(fd, function(err, fs) {
            if(err) {
                h$handleErrnoC(err, -1, 0, c);
            } else {
                c(mode & fs.mode); // fixme is this ok?
            }
        });
    } else

        h$unsupported(-1, c);
}

function h$base_chmod(file, file_off, mode, c) {
                          ;

    if(h$isNode) {
        h$fs.chmod(h$decodeUtf8z(file, file_off), mode, function(err) {
            h$handleErrnoC(err, -1, 0, c);
        });
    } else

        h$unsupported(-1, c);
}

function h$base_close(fd, c) {
                          ;
    var fdo = h$base_fds[fd];
    if(fdo && fdo.close) {
        fdo.close(fd, fdo, c);
    } else {
        h$errno = 22;
        c(-1);
    }
}

function h$base_dup(fd, something, c) {
    throw "h$base_dup";
}

function h$base_dup2(fd, c) {
    throw "h$base_dup2";
}

function h$base_fstat(fd, stat, stat_off, c) {
                         ;

    if(h$isNode) {
        h$fs.fstat(fd, function(err, fs) {
            if(err) {
                h$handlErrnoC(err, -1, 0, c);
            } else {
                h$base_fillStat(fs, stat, stat_off);
                c(0);
            }
        });
    } else

        h$unsupported(-1, c);
}

function h$base_isatty(fd) {
                                 ;

    if(h$isNode) {
        if(fd === 0) return process.stdin.isTTY?1:0;
        if(fd === 1) return process.stdout.isTTY?1:0;
        if(fd === 2) return process.stderr.isTTY?1:0;
    }

    if(fd === 1 || fd === 2) return 1;
    return 0;
}

function h$base_lseek(fd, pos_1, pos_2, whence, c) {
                          ;

    if(h$isNode) {
        var p = goog.math.Long.fromBits(pos_2, pos_1), p1;
        var o = h$base_fds[fd];
        if(!o) {
            h$errno = CONST_BADF;
            c(-1,-1);
        } else {
            switch(whence) {
            case 0: /* SET */
                o.pos = p.toNumber();
                c(p.getHighBits(), p.getLowBits());
                break;
            case 1: /* CUR */
                o.pos += p.toNumber();
                p1 = goog.math.Long.fromNumber(o.pos);
                c(p1.getHighBits(), p1.getLowBits());
                break;
            case 2: /* END */
                h$fs.fstat(fd, function(err, fs) {
                    if(err) {
                        h$setErrno(err);
                        c(-1,-1);
                    } else {
                        o.pos = fs.size + p.toNumber();
                        p1 = goog.math.Long.fromNumber(o.pos);
                        c(p1.getHighBits(), p1.getLowBits());
                    }
                });
                break;
            default:
                h$errno = 22;
                c(-1,-1);
            }
        }
    } else {

        h$unsupported();
        c(-1, -1);

    }

}

function h$base_lstat(file, file_off, stat, stat_off, c) {
                          ;

    if(h$isNode) {
        h$fs.lstat(h$decodeUtf8z(file, file_off), function(err, fs) {
            if(err) {
                h$handleErrnoC(err, -1, 0, c);
            } else {
                h$base_fillStat(fs, stat, stat_off);
                c(0);
            }
        });
    } else

        h$unsupported(-1, c);
}
function h$base_open(file, file_off, how, mode, c) {

    if(h$isNode) {
        var flags, off;
        var fp = h$decodeUtf8z(file, file_off);
        var acc = how & h$base_o_accmode;
        // passing a number lets node.js use it directly as the flags (undocumented)
        if(acc === h$base_o_rdonly) {
            flags = h$processConstants['fs']['O_RDONLY'];
        } else if(acc === h$base_o_wronly) {
            flags = h$processConstants['fs']['O_WRONLY'];
        } else { // r+w
            flags = h$processConstants['fs']['O_RDWR'];
        }
        off = (how & h$base_o_append) ? -1 : 0;
        flags = flags | ((how & h$base_o_trunc) ? h$processConstants['fs']['O_TRUNC'] : 0)
                      | ((how & h$base_o_creat) ? h$processConstants['fs']['O_CREAT'] : 0)
                      | ((how & h$base_o_excl) ? h$processConstants['fs']['O_EXCL'] : 0)
                      | ((how & h$base_o_append) ? h$processConstants['fs']['O_APPEND'] : 0);
        h$fs.open(fp, flags, mode, function(err, fd) {
            if(err) {
                h$handleErrnoC(err, -1, 0, c);
            } else {
                var f = function(p) {
                    h$base_fds[fd] = { read: h$base_readFile
                                       , write: h$base_writeFile
                                       , close: h$base_closeFile
                                       , pos: p
                                     };
                    c(fd);
                }
                if(off === -1) {
                    h$fs.stat(fp, function(err, fs) {
                        if(err) h$handleErrnoC(err, -1, 0, c); else f(fs.size);
                    });
                } else {
                    f(0);
                }
            }
        });
    } else

        h$unsupported(-1, c);
}
function h$base_read(fd, buf, buf_off, n, c) {
                                ;
    var fdo = h$base_fds[fd];
    if(fdo && fdo.read) {
        fdo.read(fd, fdo, buf, buf_off, n, c);
    } else {
        h$errno = 22;
        c(-1);
    }
}
function h$base_stat(file, file_off, stat, stat_off, c) {
                         ;

    if(h$isNode) {
        h$fs.stat(h$decodeUtf8z(file, file_off), function(err, fs) {
            if(err) {
                h$handlErrnoC(err, -1, 0, c);
            } else {
                h$base_fillStat(fs, stat, stat_off);
                c(0);
            }
        });
    } else

        h$unsupported(-1, c);
}
function h$base_umask(mode) {
                                   ;

    if(h$isNode) return process.umask(mode);

    return 0;
}

function h$base_write(fd, buf, buf_off, n, c) {
                                 ;
    var fdo = h$base_fds[fd];
    if(fdo && fdo.write) {
        fdo.write(fd, fdo, buf, buf_off, n, c);
    } else {
        h$errno = 22;
        c(-1);
    }
}

function h$base_ftruncate(fd, pos_1, pos_2, c) {
                              ;

    if(h$isNode) {
        h$fs.ftruncate(fd, goog.math.Long.fromBits(pos_2, pos_1).toNumber(), function(err) {
            h$handleErrnoC(err, -1, 0, c);
        });
    } else

        h$unsupported(-1, c);
}
function h$base_unlink(file, file_off, c) {
                           ;

    if(h$isNode) {
        h$fs.unlink(h$decodeUtf8z(file, file_off), function(err) {
            h$handleErrnoC(err, -1, 0, c);
        });
    } else

        h$unsupported(-1, c);
}
function h$base_getpid() {
                           ;

    if(h$isNode) return process.pid;

    return 0;
}
function h$base_link(file1, file1_off, file2, file2_off, c) {
                         ;

    if(h$isNode) {
        h$fs.link(h$decodeUtf8z(file1, file1_off), h$decodeUtf8z(file2, file2_off), function(err) {
            h$handleErrnoC(err, -1, 0, c);
        });
    } else

        h$unsupported(-1, c);
}
function h$base_mkfifo(file, file_off, mode, c) {
    throw "h$base_mkfifo";
}
function h$base_sigemptyset(sigset, sigset_off) {
    return 0;
    // throw "h$base_sigemptyset";
}
function h$base_sigaddset(sigset, sigset_off, sig) {
    return 0;
    // throw "h$base_sigaddset";
}
function h$base_sigprocmask(sig, sigset1, sigset1_off, sigset2, sigset2_off) {
    return 0;
    // throw "h$base_sigprocmask";
}
function h$base_tcgetattr(attr, termios, termios_off) {
    return 0;
}
function h$base_tcsetattr(attr, val, termios, termios_off) {
    return 0;
}
function h$base_utime(file, file_off, timbuf, timbuf_off, c) {
                          ;

    if(h$isNode) {
        h$fs.fstat(h$decodeUtf8z(file, file_off), function(err, fs) {
            if(err) {
                h$handleErrnoC(err, 0, -1, c); // fixme
            } else {
                var atime = goog.math.Long.fromNumber(fs.atime.getTime());
                var mtime = goog.math.Long.fromNumber(fs.mtime.getTime());
                var ctime = goog.math.Long.fromNumber(fs.ctime.getTime());
                timbuf.i3[0] = atime.getHighBits();
                timbuf.i3[1] = atime.getLowBits();
                timbuf.i3[2] = mtime.getHighBits();
                timbuf.i3[3] = mtime.getLowBits();
                timbuf.i3[4] = ctime.getHighBits();
                timbuf.i3[5] = ctime.getLowBits();
                c(0);
            }
        });
    } else

        h$unsupported(-1, c);
}
function h$base_waitpid(pid, stat, stat_off, options, c) {
    throw "h$base_waitpid";
}
/** @const */ var h$base_o_rdonly = 0x00000;
/** @const */ var h$base_o_wronly = 0x00001;
/** @const */ var h$base_o_rdwr = 0x00002;
/** @const */ var h$base_o_accmode = 0x00003;
/** @const */ var h$base_o_append = 0x00008;
/** @const */ var h$base_o_creat = 0x00200;
/** @const */ var h$base_o_trunc = 0x00400;
/** @const */ var h$base_o_excl = 0x00800;
/** @const */ var h$base_o_noctty = 0x20000;
/** @const */ var h$base_o_nonblock = 0x00004;
/** @const */ var h$base_o_binary = 0x00000;

function h$base_c_s_isreg(mode) {
    return 1;
}
function h$base_c_s_ischr(mode) {
    return 0;
}
function h$base_c_s_isblk(mode) {
    return 0;
}
function h$base_c_s_isdir(mode) {
    return 0; // fixme
}
function h$base_c_s_isfifo(mode) {
    return 0;
}


function h$base_fillStat(fs, b, off) {
    if(off%4) throw "h$base_fillStat: not aligned";
    var o = off>>2;
    b.i3[o+0] = fs.mode;
    var s = goog.math.Long.fromNumber(fs.size);
    b.i3[o+1] = s.getHighBits();
    b.i3[o+2] = s.getLowBits();
    b.i3[o+3] = 0; // fixme
    b.i3[o+4] = 0; // fixme
    b.i3[o+5] = fs.dev;
    var i = goog.math.Long.fromNumber(fs.ino);
    b.i3[o+6] = i.getHighBits();
    b.i3[o+7] = i.getLowBits();
    b.i3[o+8] = fs.uid;
    b.i3[o+9] = fs.gid;
}


// [mode,size1,size2,mtime1,mtime2,dev,ino1,ino2,uid,gid] all 32 bit
/** @const */ var h$base_sizeof_stat = 40;

function h$base_st_mtime(stat, stat_off) {
    { h$ret1 = (stat.i3[(stat_off>>2)+4]); return (stat.i3[(stat_off>>2)+3]); };
}

function h$base_st_size(stat, stat_off) {
    { h$ret1 = (stat.i3[(stat_off>>2)+2]); return (stat.i3[(stat_off>>2)+1]); };
}

function h$base_st_mode(stat, stat_off) {
    return stat.i3[stat_off>>2];
}

function h$base_st_dev(stat, stat_off) {
    return stat.i3[(stat_off>>2)+5];
}

function h$base_st_ino(stat, stat_off) {
    { h$ret1 = (stat.i3[(stat_off>>2)+7]); return (stat.i3[(stat_off>>2)+6]); };
}

/** @const */ var h$base_echo = 1;
/** @const */ var h$base_tcsanow = 2;
/** @const */ var h$base_icanon = 4;
/** @const */ var h$base_vmin = 8;
/** @const */ var h$base_vtime = 16;
/** @const */ var h$base_sigttou = 0;
/** @const */ var h$base_sig_block = 0;
/** @const */ var h$base_sig_setmask = 0;
/** @const */ var h$base_f_getfl = 0;
/** @const */ var h$base_f_setfl = 0;
/** @const */ var h$base_f_setfd = 0;
/** @const */ var h$base_fd_cloexec = 0;
/** @const */ var h$base_sizeof_termios = 4;
/** @const */ var h$base_sizeof_sigset_t = 4;

function h$base_lflag(termios, termios_off) {
    return 0;
}

function h$base_poke_lflag(termios, termios_off, flag) {
    return 0;
}

function h$base_ptr_c_cc(termios, termios_off) {
    { h$ret1 = (0); return (h$newByteArray(8)); };
}

/** @const */ var h$base_default_buffer_size = 32768;

function h$base_c_s_issock(mode) {
    return 0; // fixme
}

/** @const */ var h$base_SEEK_SET = 0;
/** @const */ var h$base_SEEK_CUR = 1;
/** @const */ var h$base_SEEK_END = 2;

function h$base_set_saved_termios(a, b, c) {
    { h$ret1 = (0); return (null); };
}

function h$base_get_saved_termios(r) {
    { h$ret1 = (0); return (null); };
}

// fixme
function h$lockFile(fd, dev, ino, for_writing) {
                              ;
    return 0;
}
function h$unlockFile(fd) {
                                ;
    return 0;
}



// engine-dependent setup
var h$base_readStdin , h$base_writeStderr, h$base_writeStdout;
var h$base_closeStdin = null, h$base_closeStderr = null, h$base_closeStdout = null;
var h$base_readFile, h$base_writeFile, h$base_closeFile;

var h$base_stdin_waiting = new h$Queue();
var h$base_stdin_chunk = { buf: null
                           , pos: 0
                           , processing: false
                           };
var h$base_stdin_eof = false;
var h$base_process_stdin = function() {
    var c = h$base_stdin_chunk;
    var q = h$base_stdin_waiting;
    if(!q.length() || c.processing) return;
    c.processing = true;
    if(!c.buf) { c.pos = 0; c.buf = process.stdin.read(); }
    while(c.buf && q.length()) {
        var x = q.dequeue();
        var n = Math.min(c.buf.length - c.pos, x.n);
        for(var i=0;i<n;i++) {
            x.buf.u8[i+x.off] = c.buf[c.pos+i];
        }
        c.pos += n;
        x.c(n);
        if(c.pos >= c.buf.length) c.buf = null;
        if(!c.buf && q.length()) { c.pos = 0; c.buf = process.stdin.read(); }
    }
    while(h$base_stdin_eof && q.length()) q.dequeue().c(0);
    c.processing = false;
}

if(h$isNode) {
    h$base_closeFile = function(fd, fdo, c) {
        h$fs.close(fd, function(err) {
            delete h$base_fds[fd];
            h$handleErrnoC(err, -1, 0, c);
        });
    }

    h$base_readFile = function(fd, fdo, buf, buf_offset, n, c) {
        var pos = typeof fdo.pos === 'number' ? fdo.pos : null;
                                                                                 ;
        h$fs.read(fd, new Buffer(n), 0, n, pos, function(err, bytesRead, nbuf) {
            if(err) {
                h$setErrno(err);
                c(-1);
            } else {
                for(var i=bytesRead-1;i>=0;i--) buf.u8[buf_offset+i] = nbuf[i];
                if(typeof fdo.pos === 'number') fdo.pos += bytesRead;
                c(bytesRead);
            }
        });
    }

    h$base_readStdin = function(fd, fdo, buf, buf_offset, n, c) {
                              ;
        h$base_stdin_waiting.enqueue({buf: buf, off: buf_offset, n: n, c: c});
        h$base_process_stdin();
    }

    h$base_closeStdin = function(fd, fdo, c) {
                               ;
        // process.stdin.close(); fixme
        c(0);
    }

    h$base_writeFile = function(fd, fdo, buf, buf_offset, n, c) {
        var pos = typeof fdo.pos === 'number' ? fdo.pos : null;
                                                                                  ;
        var nbuf = new Buffer(n);
        for(var i=0;i<n;i++) nbuf[i] = buf.u8[i+buf_offset];
        if(typeof fdo.pos === 'number') fdo.pos += n;
        h$fs.write(fd, nbuf, 0, n, pos, function(err, bytesWritten) {
                                           ;
            if(err) {
                h$setErrno(err);
                if(typeof fdo.pos === 'number') fdo.pos -= n;
                if(h$errno === 35)
                    setTimeout(function() { h$base_writeFile(fd, fdo, buf, buf_offset, n, c); }, 20);
                else c(-1);
            } else {
                if(typeof fdo.pos === 'number') fdo.pos += bytesWritten - n;
                c(bytesWritten);
            }
        });
    }

    h$base_writeStdout = function(fd, fdo, buf, buf_offset, n, c) {
                                ;
        h$base_writeFile(1, fdo, buf, buf_offset, n, c);
    }

    h$base_closeStdout = function(fd, fdo, c) {
                                ;
 // not actually closed, fixme?
        c(0);
    }

    h$base_writeStderr = function(fd, fdo, buf, buf_offset, n, c) {
                                ;
        h$base_writeFile(2, fdo, buf, buf_offset, n, c);
    }

    h$base_closeStderr = function(fd, fdo, c) {
                                ;
 // not actually closed, fixme?
        c(0);
    }

    process.stdin.on('readable', h$base_process_stdin);
    process.stdin.on('end', function() { h$base_stdin_eof = true; h$base_process_stdin(); });

} else if (h$isJsShell) {
    h$base_readStdin = function(fd, fdo, buf, buf_offset, n, c) {
        c(0);
    }
    h$base_writeStdout = function(fd, fdo, buf, buf_offset, n, c) {
        putstr(h$decodeUtf8(buf, n, buf_offset));
        c(n);
    }
    h$base_writeStderr = function(fd, fdo, buf, buf_offset, n, c) {
        printErr(h$decodeUtf8(buf, n, buf_offset));
        c(n);
    }
} else if(h$isJsCore) {
    h$base_readStdin = function(fd, fdo, buf, buf_offset, n, c) {
 c(0);
    }
    var h$base_stdoutLeftover = { f: print, val: null };
    var h$base_stderrLeftover = { f: debug, val: null };
    var h$base_writeWithLeftover = function(buf, n, buf_offset, c, lo) {
 var lines = h$decodeUtf8(buf, n, buf_offset).split(/\r?\n/);
 if(lines.length === 1) {
     if(lines[0].length) {
  if(lo.val !== null) lo.val += lines[0];
  else lo.val = lines[0];
     }
 } else {
            lo.f(((lo.val !== null) ? lo.val : '') + lines[0]);
     for(var i=1;i<lines.length-1;i++) lo.f(lines[i]);
     if(lines[lines.length-1].length) lo.val = lines[lines.length-1];
     else lo.val = null;
 }
 c(n);
    }
    h$base_writeStdout = function(fd, fdo, buf, buf_offset, n, c) {
 h$base_writeWithLeftover(buf, n, buf_offset, c, h$base_stdoutLeftover);
    }
    h$base_writeStderr = function(fd, fdo, buf, buf_offset, n, c) {
 // writing to stderr not supported, write to stdout
 h$base_writeWithLeftover(buf, n, buf_offset, c, h$base_stderrLeftover);
    }
} else { // browser / fallback

    h$base_readStdin = function(fd, fdo, buf, buf_offset, n, c) {
        c(0);
    }
    h$base_writeStdout = function(fd, fdo, buf, buf_offset, n, c) {
        console.log(h$decodeUtf8(buf, n, buf_offset));
        c(n);
    }
    h$base_writeStderr = function(fd, fdo, buf, buf_offset, n, c) {
        console.log(h$decodeUtf8(buf, n, buf_offset));
        c(n);
    }

}


var h$base_stdin_fd = { read: h$base_readStdin, close: h$base_closeStdin };
var h$base_stdout_fd = { write: h$base_writeStdout, close: h$base_closeStdout };
var h$base_stderr_fd = { write: h$base_writeStderr, close: h$base_closeStderr };

var h$base_fdN = -1; // negative file descriptors are 'virtual'
var h$base_fds = [h$base_stdin_fd, h$base_stdout_fd, h$base_stderr_fd];

function h$shutdownHaskellAndExit(code, fast) {






    h$exitProcess(code);
}

// RAND_MAX = 32767
function h$rand() {
  return (32768 * Math.random()) & 32767;
}
function h$get_current_timezone_seconds(t, pdst_v, pdst_o, pname_v, pname_o) {
    var d = new Date(t * 1000);
    var now = new Date();
    var jan = new Date(now.getFullYear(),0,1);
    var jul = new Date(now.getFullYear(),6,1);
    var stdOff = Math.max(jan.getTimezoneOffset(), jul.getTimezoneOffset());
    var isDst = d.getTimezoneOffset() < stdOff;
    var tzo = d.getTimezoneOffset();
    pdst_v.dv.setInt32(pdst_o, isDst ? 1 : 0, true);
    if(!pname_v.arr) pname_v.arr = [];
    var offstr = tzo < 0 ? ('+' + (tzo/-60)) : ('' + (tzo/-60));
    pname_v.arr[pname_o] = [h$encodeUtf8("UTC" + offstr), 0];
    return (-60*tzo)|0;
}

function h$clock_gettime(when, p_d, p_o) {
/*  h$log("clock_gettime");
  h$log(when);
  h$log(p_d);
  h$log(p_o); */

  var o = p_o >> 2,
      t = Date.now ? Date.now() : new Date().getTime(),
      tf = Math.floor(t / 1000),
      tn = 1000000 * (t - (1000 * tf));
  p_d.i3[o] = tf|0;
  p_d.i3[o+1] = tn|0;
  return 0;
}






// values defined in Gen2.ClosureInfo







// thread status

/*
 * low-level heap object manipulation macros
 */
// GHCJS.Prim.JSVal







// GHCJS.Prim.JSException





// Exception dictionary for JSException


// SomeException






// GHC.Ptr.Ptr






// GHC.Integer.GMP.Internals
// Data.Maybe.Maybe




// #define HS_NOTHING h$nothing






// Data.List
// Data.Text




// Data.Text.Lazy





// black holes
// can we skip the indirection for black holes?






// resumable thunks


// general deconstruction



// retrieve  a numeric value that's possibly stored as an indirection



// generic lazy values
// generic data constructors and selectors
// unboxed tuple returns
// #define RETURN_UBX_TUP1(x) return x;

function h$_hs_text_memcpy(dst_v,dst_o2,src_v,src_o2,n) {
  return h$memcpy(dst_v,2*dst_o2,src_v,2*src_o2,2*n);
}

function h$_hs_text_memcmp(a_v,a_o2,b_v,b_o2,n) {
  return h$memcmp(a_v,2*a_o2,b_v,2*b_o2,2*n);
}

// decoder below adapted from cbits/cbits.c in the text package




var h$_text_utf8d =
   [
  /*
   * The first part of the table maps bytes to character classes that
   * to reduce the size of the transition table and create bitmasks.
   */
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1, 9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,
   7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7, 7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,
   8,8,2,2,2,2,2,2,2,2,2,2,2,2,2,2, 2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
  10,3,3,3,3,3,3,3,3,3,3,3,3,4,3,3, 11,6,6,6,5,8,8,8,8,8,8,8,8,8,8,8,

  /*
   * The second part is a transition table that maps a combination of
   * a state of the automaton and a character class to a state.
   */
   0,12,24,36,60,96,84,12,12,12,48,72, 12,12,12,12,12,12,12,12,12,12,12,12,
  12, 0,12,12,12,12,12, 0,12, 0,12,12, 12,24,12,12,12,12,12,24,12,24,12,12,
  12,12,12,12,12,12,12,24,12,12,12,12, 12,24,12,12,12,12,12,12,12,24,12,12,
  12,12,12,12,12,12,12,36,12,36,12,12, 12,36,12,12,12,12,12,36,12,36,12,12,
  12,36,12,12,12,12,12,12,12,12,12,12];

/*
 * A best-effort decoder. Runs until it hits either end of input or
 * the start of an invalid byte sequence.
 *
 * At exit, updates *destoff with the next offset to write to, and
 * returns the next source offset to read from.
 */

function h$_hs_text_decode_utf8_internal ( dest_v
                                         , destoff_v, destoff_o
                                         , src_v, src_o
                                         , src_end_v, src_end_o
                                         , s
                                         ) {
  if(src_v === null || src_end_v === null) {
    { h$ret1 = (src_end_o); return (null); };
  }
  var dsto = destoff_v.dv.getUint32(destoff_o,true) << 1;
  var srco = src_o;
  var state = s.state;
  var codepoint = s.codepoint;
  var ddv = dest_v.dv;
  var sdv = src_v.dv;

  function decode(b) {
    var type = h$_text_utf8d[b];
    codepoint = (state !== 0) ?
      (b & 0x3f) | (codepoint << 6) :
      (0xff >>> type) & b;
    state = h$_text_utf8d[256 + state + type];
    return state;
  }

  while (srco < src_end_o) {
    if(decode(sdv.getUint8(srco++)) !== 0) {
      if(state !== 12) {
        continue;
      } else {
        break;
      }
    }
    if (codepoint <= 0xffff) {
      ddv.setUint16(dsto,codepoint,true);
      dsto += 2;
    } else {
      ddv.setUint16(dsto,(0xD7C0 + (codepoint >>> 10)),true);
      ddv.setUint16(dsto+2,(0xDC00 + (codepoint & 0x3FF)),true);
      dsto += 4;
    }
    s.last = srco;
  }

  s.state = state;
  s.codepoint = codepoint;
  destoff_v.dv.setUint32(destoff_o,dsto>>1,true);
  { h$ret1 = (srco); return (src_v); };
}

function h$_hs_text_decode_utf8_state( dest_v
                                     , destoff_v, destoff_o
                                     , src_v, src_o
                                     , srcend_v, srcend_o
                                     , codepoint0_v, codepoint0_o
                                     , state0_v, state0_o
                                     ) {
  var s = { state: state0_v.dv.getUint32(state0_o, true)
          , codepoint: codepoint0_v.dv.getUint32(codepoint0_o, true)
          , last: src_o
          };
  var ret, ret1;
  { (ret) = (h$_hs_text_decode_utf8_internal ( dest_v , destoff_v, destoff_o , src_v.arr[src_o][0], src_v.arr[src_o][1] , srcend_v, srcend_o , s )); (ret1) = h$ret1; };







  src_v.arr[src_o][1] = s.last;
  state0_v.dv.setUint32(state0_o, s.state, true);
  codepoint0_v.dv.setUint32(codepoint0_o, s.codepoint, true);
  if(s.state === 12) ret1--;
  { h$ret1 = (ret1); return (ret); };
}

function h$_hs_text_decode_utf8( dest_v
                               , destoff_v, destoff_o
                               , src_v, src_o
                               , srcend_v, srcend_o
                               ) {
  /* Back up if we have an incomplete or invalid encoding */
  var s = { state: 0
          , codepoint: 0
          , last: src_o
          };
  var ret, ret1;
  { (ret) = (h$_hs_text_decode_utf8_internal ( dest_v , destoff_v, destoff_o , src_v, src_o , srcend_v, srcend_o , s )); (ret1) = h$ret1; };







  if (s.state !== 0) ret1--;
  { h$ret1 = (ret1); return (ret); };
}


/*
 * The ISO 8859-1 (aka latin-1) code points correspond exactly to the first 256 unicode
 * code-points, therefore we can trivially convert from a latin-1 encoded bytestring to
 * an UTF16 array
 */
function h$_hs_text_decode_latin1(dest_d, src_d, src_o, srcend_d, srcend_o) {
  var p = src_o;
  var d = 0;
  var su8 = src_d.u8;
  var su3 = src_d.u3;
  var du1 = dest_d.u1;

  // consume unaligned prefix
  while(p != srcend_o && p & 3) {
    du1[d++] = su8[p++];
  }

  // iterate over 32-bit aligned loads
  if(su3) {
    while (p < srcend_o - 3) {
      var w = su3[p>>2];
      du1[d++] = w & 0xff;
      du1[d++] = (w >>> 8) & 0xff;
      du1[d++] = (w >>> 16) & 0xff;
      du1[d++] = (w >>> 32) & 0xff;
      p += 4;
    }
  }

  // handle unaligned suffix
  while (p != srcend_o)
    du1[d++] = su8[p++];
}

function h$_hs_text_encode_utf8(destp_v, destp_o, src_v, srcoff, srclen) {
  var dest_v = destp_v.arr[destp_o][0];
  var dest_o = destp_v.arr[destp_o][1];
  var src = srcoff;
  var dest = dest_o;
  var srcend = src + srclen;
  var srcu1 = src_v.u1;
  if(!srcu1) throw "h$_hs_text_encode_utf8: invalid alignment for source";
  var srcu3 = src_v.u3;
  var destu8 = dest_v.u8;
  while(src < srcend) {
    // run of (aligned) ascii characters
    while(srcu3 && !(src & 1) && srcend - src >= 2) {
      var w = srcu3[src>>1];
      if(w & 0xFF80FF80) break;
      destu8[dest++] = w & 0xFFFF;
      destu8[dest++] = w >>> 16;
      src += 2;
    }
    while(src < srcend) {
      var w = srcu1[src++];
      if(w <= 0x7F) {
        destu8[dest++] = w;
        break; // go back to a stream of ASCII
      } else if(w <= 0x7FF) {
        destu8[dest++] = (w >> 6) | 0xC0;
        destu8[dest++] = (w & 0x3f) | 0x80;
      } else if(w < 0xD800 || w > 0xDBFF) {
        destu8[dest++] = (w >>> 12) | 0xE0;
        destu8[dest++] = ((w >> 6) & 0x3F) | 0x80;
        destu8[dest++] = (w & 0x3F) | 0x80;
      } else {
        var c = ((w - 0xD800) << 10) + (srcu1[src++] - 0xDC00) + 0x10000;
        destu8[dest++] = (c >>> 18) | 0xF0;
        destu8[dest++] = ((c >> 12) & 0x3F) | 0x80;
        destu8[dest++] = ((c >> 6) & 0x3F) | 0x80;
        destu8[dest++] = (c & 0x3F) | 0x80;
      }
    }
  }
  destp_v.arr[destp_o][1] = dest;
}
/* FNV-1 hash
 *
 * The FNV-1 hash description: http://isthe.com/chongo/tech/comp/fnv/
 * The FNV-1 hash is public domain: http://isthe.com/chongo/tech/comp/fnv/#public_domain
 */
function h$hashable_fnv_hash_offset(str_a, o, len, hash) {
  return h$hashable_fnv_hash(str_a, o, len, hash);
}

function h$hashable_fnv_hash(str_d, str_o, len, hash) {
  if(len > 0) {
    var d = str_d.u8;
    for(var i=0;i<len;i++) {
      hash = h$mulInt32(hash, 16777619) ^ d[str_o+i];
    }
  }
  return hash;
}


// int hashable_getRandomBytes(unsigned char *dest, int nbytes)
function h$hashable_getRandomBytes(dest_d, dest_o, len) {
  if(len > 0) {
    var d = dest_d.u8;
    for(var i=0;i<len;i++) {
      d[dest_o+i] = Math.floor(Math.random() * 256);
    }
  }
  return len;
}






// values defined in Gen2.ClosureInfo







// thread status

/*
 * low-level heap object manipulation macros
 */
// GHCJS.Prim.JSVal







// GHCJS.Prim.JSException





// Exception dictionary for JSException


// SomeException






// GHC.Ptr.Ptr






// GHC.Integer.GMP.Internals
// Data.Maybe.Maybe




// #define HS_NOTHING h$nothing






// Data.List
// Data.Text




// Data.Text.Lazy





// black holes
// can we skip the indirection for black holes?






// resumable thunks


// general deconstruction



// retrieve  a numeric value that's possibly stored as an indirection



// generic lazy values
// generic data constructors and selectors
// unboxed tuple returns
// #define RETURN_UBX_TUP1(x) return x;

// JS Objects stuff

function h$isFloat (n) {
  return n===+n && n!==(n|0);
}

function h$isInteger (n) {
  return n===+n && n===(n|0);
}

/*
        -- 0 - null, 1 - integer,
        -- 2 - float, 3 - bool,
        -- 4 - string, 5 - array
        -- 6 - object
*/
function h$typeOf(o) {
    if (!(o instanceof Object)) {
        if (o == null) {
            return 0;
        } else if (typeof o == 'number') {
            if (h$isInteger(o)) {
                return 1;
            } else {
                return 2;
            }
        } else if (typeof o == 'boolean') {
            return 3;
        } else {
            return 4;
        }
    } else {
        if (Object.prototype.toString.call(o) == '[object Array]') {
            // it's an array
            return 5;
        } else if (!o) {
            // null 
            return 0;
        } else {
            // it's an object
            return 6;
        }
    }
}

function h$listProps(o) {
    if (!(o instanceof Object)) {
        return [];
    }
    var l = [], i = 0;
    for (var prop in o) {
        l[i++] = prop;
    }
    return l;
}

function h$flattenObj(o) {
    var l = [], i = 0;
    for (var prop in o) {
        l[i++] = [prop, o[prop]];
    }
    return l;
}

/*

  build an object from key/value pairs:
    var obj = h$buildObject(key1, val1, key2, val2, ...);

  note: magic name:
    invocations of this function are replaced by object literals wherever
    possible

 */
function h$buildObject() {
    var r = {}, l = arguments.length;
    for(var i = 0; i < l; i += 2) {
        var k = arguments[i], v = arguments[i+1];
        r[k] = v;
    }
    return r;
}

// same as above, but from a list: [k1,v1,k2,v2,...]
function h$buildObjectFromList(xs) {
    var r = {}, k, v, t;
    while(((xs).f === h$ghczmprimZCGHCziTypesziZC_con_e)) {
        xs = ((xs).d2);
        t = ((xs).d2);
        if(((t).f === h$ghczmprimZCGHCziTypesziZC_con_e)) {
            k = ((xs).d1);
            v = ((t).d1);
            xs = ((t).d2);
            r[k] = v;
        } else {
            return r;
        }
    }
    return r;
}

// same as above, but from a list of tuples [(k1,v1),(k2,v2),...]
function h$buildObjectFromTupList(xs) {
    var r = {};
    while(((xs).f === h$ghczmprimZCGHCziTypesziZC_con_e)) {
 var h = ((xs).d1);
 xs = ((xs).d2);
 r[((((h).d1)).d1)] = ((((h).d2)).d1);
    }
    return r;
}






// values defined in Gen2.ClosureInfo







// thread status

/*
 * low-level heap object manipulation macros
 */
// GHCJS.Prim.JSVal







// GHCJS.Prim.JSException





// Exception dictionary for JSException


// SomeException






// GHC.Ptr.Ptr






// GHC.Integer.GMP.Internals
// Data.Maybe.Maybe




// #define HS_NOTHING h$nothing






// Data.List
// Data.Text




// Data.Text.Lazy





// black holes
// can we skip the indirection for black holes?






// resumable thunks


// general deconstruction



// retrieve  a numeric value that's possibly stored as an indirection



// generic lazy values
// generic data constructors and selectors
// unboxed tuple returns
// #define RETURN_UBX_TUP1(x) return x;

// translated from bytestring cbits/fpstring.c

function h$fps_reverse(a_v, a_o, b_v, b_o, n) {
    if(n > 0) {
        var au8 = a_v.u8, bu8 = b_v.u8;
        for(var i=0;i<n;i++) {
            au8[a_o+n-i-1] = bu8[b_o+i];
        }
    }
}

function h$fps_intersperse(a_v,a_o,b_v,b_o,n,c) {
    if(n > 0) {
        var au8 = a_v.u8, bu8 = b_v.u8, dst_o = a_o;
        for(var i=0;i<n-1;i++) {
            au8[dst_o] = bu8[b_o+i];
            au8[dst_o+1] = c;
            dst_o += 2;
        }
        au8[dst_o] = bu8[b_o+n-1];
    }
}

function h$fps_maximum(a_v,a_o,n) {
    if(n > 0) {
        var au8 = a_v.u8, max = au8[a_o];
        for(var i=1;i<n;i++) {
            var c = au8[a_o+i];
            if(c > max) { max = c; }
        }
        return max;
    }
    return 0;
}

function h$fps_minimum(a_v,a_o,n) {
    if(n > 0) {
        var au8 = a_v.u8, min = a_v.u8[a_o];
        for(var i=1;i<n;i++) {
            var c = au8[a_o+i];
            if(c < min) { min = c; }
        }
        return min;
    }
    return 255;
}

function h$fps_count(a_v,a_o,n,c) {
    if(n > 0) {
        var au8 = a_v.u8, count = 0;
        for(var i=0;i<n;i++) {
            if(au8[a_o+i] === c) { count++; }
        }
        return count|0;
    }
    return 0;
}

function h$fps_memcpy_offsets(dst_d, dst_o, dst_off
                              , src_d, src_o, src_off, n) {
    return memcpy(dst_d, dst_o + dst_off, src_d, src_o + src_off, n);
}

// translated from bytestring cbits/itoa.c

var h$_hs_bytestring_digits = [48,49,50,51,52,53,54,55,56,57,97,98,99,100,101,102]; // 0123456789abcdef
var h$_hs_bytestring_l10 = goog.math.Long.fromBits(10, 0);

// signed integers
function h$_hs_bytestring_int_dec(x, buf_d, buf_o) {
    var c, ptr = buf_o, next_free, x_tmp;
    var bu8 = buf_d.u8;
    // we cannot negate directly as  0 - (minBound :: Int) = minBound
    if(x < 0) {
        bu8[ptr++] = 45; // '-'
        buf_o++;
        x_tmp = x;
        x = (x / 10) | 0;
        bu8[ptr++] = h$_hs_bytestring_digits[x * 10 - x_tmp];
        if(x === 0) {
            { h$ret1 = (ptr); return (buf_d); };
        } else {
            x = -x;
        }
    }

    // encode positive number as little-endian decimal
    do {
        x_tmp = x;
        x = (x / 10) | 0;
        bu8[ptr++] = h$_hs_bytestring_digits[x_tmp - x * 10];
    } while (x);

    next_free = ptr--;
    while(buf_o < ptr) {
        c = bu8[ptr];
        bu8[ptr--] = bu8[buf_o];
        bu8[buf_o++] = c;
    }
    { h$ret1 = (next_free); return (buf_d); };
}

// signed long long ints (64 bit integers)
function h$_hs_bytestring_long_long_int_dec(x_a, x_b, buf_d, buf_o) {
    var l10 = h$_hs_bytestring_l10;
    var x = goog.math.Long.fromBits(x_b, x_a);
    var c, ptr = buf_o, next_free;
    var bu8 = buf_d.u8;

    // we cannot negate directly as  0 - (minBound :: Int) = minBound
    if(x.isNegative()) {
        bu8[ptr++] = 45; // '-';
        buf_o++;
        x_tmp = x;
        x = x.div(l10);
        bu8[ptr++] = h$_hs_bytestring_digits[x.multiply(l10).subtract(x_tmp).getLowBits()];
        if(x.isZero()) {
            { h$ret1 = (ptr); return (buf_d); };
        } else {
            x = x.negate();
        }
    }

    // encode positive number as little-endian decimal
    do {
        x_tmp = x;
        x = x.div(l10);
        bu8[ptr++] = h$_hs_bytestring_digits[x_tmp.subtract(x.multiply(l10))];
    } while (!x.isZero());

    // reverse written digits
    next_free = ptr--;
    while(buf_o < ptr) {
        c = bu8[ptr];
        bu8[ptr--] = bu8[buf_o];
        bu8[buf_o++] = c;
    }
    { h$ret1 = (next_free); return (buf_d); };
}

// unsigned integers
function h$_hs_bytestring_uint_dec(x, buf_d, buf_o) {
    var c, ptr = buf_o, next_free;
    var bu8 = buf_d.u8;
    var x_tmp;

    if(x < 0) x += 4294967296;

    do {
        x_tmp = x;
        x = (x / 10) | 0;
        bu8[ptr++] = h$_hs_bytestring_digits[x_tmp - x * 10];
    } while(x);
    next_free = ptr--;
    while(buf_o < ptr) {
        c = bu8[ptr];
        bu8[ptr--] = bu8[buf_o];
        bu8[buf_o++] = c;
    }
    { h$ret1 = (next_free); return (buf_d); };
}

function h$_hs_bytestring_long_long_uint_dec(x_a, x_b, buf_d, buf_o) {
    var c, ptr = buf_o, next_free;
    var bu8 = buf_d.u8;
    var x = h$ghcjsbn_mkBigNat_ww(x_a, x_b), q = [], r = [];

    // encode positive number as little-endian decimal
    do {
        h$ghcjsbn_quotRem_bw(q, r, x, 10);
        x = q;
        bu8[ptr++] = h$_hs_bytestring_digits[h$ghcjsbn_toInt_b(r)];
    } while(!h$ghcjsbn_isZero_b(x));

    // reverse written digits;
    next_free = ptr--;
    while(buf_o < ptr) {
        c = bu8[ptr];
        bu8[ptr--] = bu8[buf_o];
        bu8[buf_o++] = c;
    }
    { h$ret1 = (next_free); return (buf_d); };
}

// Padded, decimal, positive integers for the decimal output of bignums
///////////////////////////////////////////////////////////////////////

// Padded (9 digits), decimal, positive int:
// We will use it with numbers that fit in 31 bits; i.e., numbers smaller than
// 10^9, as "31 * log 2 / log 10 = 9.33"

function h$_hs_bytestring_int_dec_padded9(x, buf_d, buf_o) {
    var max_width_int32_dec = 9;
    var ptr = buf_o + max_width_int32_dec;
    var bu8 = buf_d.u8;
    var x_tmp;

    // encode positive number as little-endian decimal
    do {
        x_tmp = x;
        x = (x / 10) | 0;
        bu8[--ptr] = h$_hs_bytestring_digits[x_tmp - x * 10];
    } while(x);

    // pad beginning
    while (buf_o < ptr) { bu8[--ptr] = 48; }
}

// Padded (19 digits), decimal, positive long long int:
// We will use it with numbers that fit in 63 bits; i.e., numbers smaller than
// 10^18, as "63 * log 2 / log 10 = 18.96"
function h$_hs_bytestring_long_long_int_dec_padded18(x_a, x_b, buf_d, buf_o) {
    var l10 = h$_hs_bytestring_l10;
    var max_width_int64_dec = 18;
    var ptr = buf_o + max_width_int64_dec;
    var bu8 = buf_d.u8;
    var x = goog.math.Long.fromBits(x_b, x_a);

    // encode positive number as little-endian decimal
    do {
        x_tmp = x;
        x = x.div(l10);
        bu8[--ptr] = h$_hs_bytestring_digits[x_tmp.subtract(x.multiply(l10))];
    } while (!x.isZero());

    // pad beginning
    while (buf_o < ptr) { bu8[--ptr] = 48; }
}

///////////////////////
// Hexadecimal encoding
///////////////////////

// unsigned ints (32 bit words)
function h$_hs_bytestring_uint_hex(x, buf_d, buf_o) {
    var c, ptr = buf_o, next_free;
    var bu8 = buf_d.u8;
    // write hex representation in reverse order
    do {
        bu8[ptr++] = h$_hs_bytestring_digits[x & 0xf];
        x >>>= 4;
    } while(x);

    // invert written digits
    next_free = ptr--;
    while(buf_o < ptr) {
        c = bu8[ptr];
        bu8[ptr--] = bu8[buf_o];
        bu8[buf_o++] = c;
    }
    { h$ret1 = (next_free); return (buf_d); };
}

// unsigned long ints (64 bit words)
function h$_hs_bytestring_long_long_uint_hex(x_a, x_b, buf_d, buf_o) {
    // write hex representation in reverse order
    var c, ptr = buf_o, next_free;
    var bu8 = buf_d.u8;
    if(x_a === 0 && x_b === 0) {
        bu8[ptr++] = 48; // '0'
    } else {
        while(x_b !== 0) {
            bu8[ptr++] = h$_hs_bytestring_digits[x_b & 0xf];
            x_b >>>= 4;
        }
        while(x_a !== 0) {
            bu8[ptr++] = h$_hs_bytestring_digits[x_a & 0xf];
            x_a >>>= 4;
        }
    }

    // invert written digits
    next_free = ptr--;
    while(buf_o < ptr) {
        c = bu8[ptr];
        bu8[ptr--] = bu8[buf_o];
        bu8[buf_o++] = c;
    }
    { h$ret1 = (next_free); return (buf_d); };
}
var h$ffi =
/******/ (function(modules) { // webpackBootstrap
/******/ // The module cache
/******/ var installedModules = {};
/******/
/******/ // The require function
/******/ function __webpack_require__(moduleId) {
/******/
/******/ // Check if module is in cache
/******/ if(installedModules[moduleId]) {
/******/ return installedModules[moduleId].exports;
/******/ }
/******/ // Create a new module (and put it into the cache)
/******/ var module = installedModules[moduleId] = {
/******/ i: moduleId,
/******/ l: false,
/******/ exports: {}
/******/ };
/******/
/******/ // Execute the module function
/******/ modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ // Flag the module as loaded
/******/ module.l = true;
/******/
/******/ // Return the exports of the module
/******/ return module.exports;
/******/ }
/******/
/******/
/******/ // expose the modules object (__webpack_modules__)
/******/ __webpack_require__.m = modules;
/******/
/******/ // expose the module cache
/******/ __webpack_require__.c = installedModules;
/******/
/******/ // define getter function for harmony exports
/******/ __webpack_require__.d = function(exports, name, getter) {
/******/ if(!__webpack_require__.o(exports, name)) {
/******/ Object.defineProperty(exports, name, {
/******/ configurable: false,
/******/ enumerable: true,
/******/ get: getter
/******/ });
/******/ }
/******/ };
/******/
/******/ // getDefaultExport function for compatibility with non-harmony modules
/******/ __webpack_require__.n = function(module) {
/******/ var getter = module && module.__esModule ?
/******/ function getDefault() { return module['default']; } :
/******/ function getModuleExports() { return module; };
/******/ __webpack_require__.d(getter, 'a', getter);
/******/ return getter;
/******/ };
/******/
/******/ // Object.prototype.hasOwnProperty.call
/******/ __webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ // __webpack_public_path__
/******/ __webpack_require__.p = "";
/******/
/******/ // Load entry module and return exports
/******/ return __webpack_require__(__webpack_require__.s = 153);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ (function(module, exports) {

module.exports = h$concur.React;

/***/ }),
/* 1 */
/***/ (function(module, exports) {

// shim for using process in browser
var process = module.exports = {};

// cached from whatever global is present so that test runners that stub it
// don't break things.  But we need to wrap it in a try catch in case it is
// wrapped in strict mode code which doesn't define any globals.  It's inside a
// function because try/catches deoptimize in certain engines.

var cachedSetTimeout;
var cachedClearTimeout;

function defaultSetTimout() {
    throw new Error('setTimeout has not been defined');
}
function defaultClearTimeout () {
    throw new Error('clearTimeout has not been defined');
}
(function () {
    try {
        if (typeof setTimeout === 'function') {
            cachedSetTimeout = setTimeout;
        } else {
            cachedSetTimeout = defaultSetTimout;
        }
    } catch (e) {
        cachedSetTimeout = defaultSetTimout;
    }
    try {
        if (typeof clearTimeout === 'function') {
            cachedClearTimeout = clearTimeout;
        } else {
            cachedClearTimeout = defaultClearTimeout;
        }
    } catch (e) {
        cachedClearTimeout = defaultClearTimeout;
    }
} ())
function runTimeout(fun) {
    if (cachedSetTimeout === setTimeout) {
        //normal enviroments in sane situations
        return setTimeout(fun, 0);
    }
    // if setTimeout wasn't available but was latter defined
    if ((cachedSetTimeout === defaultSetTimout || !cachedSetTimeout) && setTimeout) {
        cachedSetTimeout = setTimeout;
        return setTimeout(fun, 0);
    }
    try {
        // when when somebody has screwed with setTimeout but no I.E. maddness
        return cachedSetTimeout(fun, 0);
    } catch(e){
        try {
            // When we are in I.E. but the script has been evaled so I.E. doesn't trust the global object when called normally
            return cachedSetTimeout.call(null, fun, 0);
        } catch(e){
            // same as above but when it's a version of I.E. that must have the global object for 'this', hopfully our context correct otherwise it will throw a global error
            return cachedSetTimeout.call(this, fun, 0);
        }
    }


}
function runClearTimeout(marker) {
    if (cachedClearTimeout === clearTimeout) {
        //normal enviroments in sane situations
        return clearTimeout(marker);
    }
    // if clearTimeout wasn't available but was latter defined
    if ((cachedClearTimeout === defaultClearTimeout || !cachedClearTimeout) && clearTimeout) {
        cachedClearTimeout = clearTimeout;
        return clearTimeout(marker);
    }
    try {
        // when when somebody has screwed with setTimeout but no I.E. maddness
        return cachedClearTimeout(marker);
    } catch (e){
        try {
            // When we are in I.E. but the script has been evaled so I.E. doesn't  trust the global object when called normally
            return cachedClearTimeout.call(null, marker);
        } catch (e){
            // same as above but when it's a version of I.E. that must have the global object for 'this', hopfully our context correct otherwise it will throw a global error.
            // Some versions of I.E. have different rules for clearTimeout vs setTimeout
            return cachedClearTimeout.call(this, marker);
        }
    }



}
var queue = [];
var draining = false;
var currentQueue;
var queueIndex = -1;

function cleanUpNextTick() {
    if (!draining || !currentQueue) {
        return;
    }
    draining = false;
    if (currentQueue.length) {
        queue = currentQueue.concat(queue);
    } else {
        queueIndex = -1;
    }
    if (queue.length) {
        drainQueue();
    }
}

function drainQueue() {
    if (draining) {
        return;
    }
    var timeout = runTimeout(cleanUpNextTick);
    draining = true;

    var len = queue.length;
    while(len) {
        currentQueue = queue;
        queue = [];
        while (++queueIndex < len) {
            if (currentQueue) {
                currentQueue[queueIndex].run();
            }
        }
        queueIndex = -1;
        len = queue.length;
    }
    currentQueue = null;
    draining = false;
    runClearTimeout(timeout);
}

process.nextTick = function (fun) {
    var args = new Array(arguments.length - 1);
    if (arguments.length > 1) {
        for (var i = 1; i < arguments.length; i++) {
            args[i - 1] = arguments[i];
        }
    }
    queue.push(new Item(fun, args));
    if (queue.length === 1 && !draining) {
        runTimeout(drainQueue);
    }
};

// v8 likes predictible objects
function Item(fun, array) {
    this.fun = fun;
    this.array = array;
}
Item.prototype.run = function () {
    this.fun.apply(null, this.array);
};
process.title = 'browser';
process.browser = true;
process.env = {};
process.argv = [];
process.version = ''; // empty string to avoid regexp issues
process.versions = {};

function noop() {}

process.on = noop;
process.addListener = noop;
process.once = noop;
process.off = noop;
process.removeListener = noop;
process.removeAllListeners = noop;
process.emit = noop;
process.prependListener = noop;
process.prependOnceListener = noop;

process.listeners = function (name) { return [] }

process.binding = function (name) {
    throw new Error('process.binding is not supported');
};

process.cwd = function () { return '/' };
process.chdir = function (dir) {
    throw new Error('process.chdir is not supported');
};
process.umask = function() { return 0; };


/***/ }),
/* 2 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


exports.__esModule = true;

exports.default = function (instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
};

/***/ }),
/* 3 */
/***/ (function(module, exports, __webpack_require__) {

/* WEBPACK VAR INJECTION */(function(process) {/**
 * Copyright 2013-present, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 */

if (process.env.NODE_ENV !== 'production') {
  var REACT_ELEMENT_TYPE = (typeof Symbol === 'function' &&
    Symbol.for &&
    Symbol.for('react.element')) ||
    0xeac7;

  var isValidElement = function(object) {
    return typeof object === 'object' &&
      object !== null &&
      object.$$typeof === REACT_ELEMENT_TYPE;
  };

  // By explicitly using `prop-types` you are opting into new development behavior.
  // http://fb.me/prop-types-in-prod
  var throwOnDirectAccess = true;
  module.exports = __webpack_require__(155)(isValidElement, throwOnDirectAccess);
} else {
  // By explicitly using `prop-types` you are opting into new production behavior.
  // http://fb.me/prop-types-in-prod
  module.exports = __webpack_require__(157)();
}

/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(1)))

/***/ }),
/* 4 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


exports.__esModule = true;

var _defineProperty = __webpack_require__(162);

var _defineProperty2 = _interopRequireDefault(_defineProperty);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports.default = function () {
  function defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];
      descriptor.enumerable = descriptor.enumerable || false;
      descriptor.configurable = true;
      if ("value" in descriptor) descriptor.writable = true;
      (0, _defineProperty2.default)(target, descriptor.key, descriptor);
    }
  }

  return function (Constructor, protoProps, staticProps) {
    if (protoProps) defineProperties(Constructor.prototype, protoProps);
    if (staticProps) defineProperties(Constructor, staticProps);
    return Constructor;
  };
}();

/***/ }),
/* 5 */
/***/ (function(module, exports, __webpack_require__) {

module.exports = { "default": __webpack_require__(159), __esModule: true };

/***/ }),
/* 6 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


exports.__esModule = true;

var _typeof2 = __webpack_require__(91);

var _typeof3 = _interopRequireDefault(_typeof2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports.default = function (self, call) {
  if (!self) {
    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  }

  return call && ((typeof call === "undefined" ? "undefined" : (0, _typeof3.default)(call)) === "object" || typeof call === "function") ? call : self;
};

/***/ }),
/* 7 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


exports.__esModule = true;

var _setPrototypeOf = __webpack_require__(187);

var _setPrototypeOf2 = _interopRequireDefault(_setPrototypeOf);

var _create = __webpack_require__(191);

var _create2 = _interopRequireDefault(_create);

var _typeof2 = __webpack_require__(91);

var _typeof3 = _interopRequireDefault(_typeof2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports.default = function (subClass, superClass) {
  if (typeof superClass !== "function" && superClass !== null) {
    throw new TypeError("Super expression must either be null or a function, not " + (typeof superClass === "undefined" ? "undefined" : (0, _typeof3.default)(superClass)));
  }

  subClass.prototype = (0, _create2.default)(superClass && superClass.prototype, {
    constructor: {
      value: subClass,
      enumerable: false,
      writable: true,
      configurable: true
    }
  });
  if (superClass) _setPrototypeOf2.default ? (0, _setPrototypeOf2.default)(subClass, superClass) : subClass.__proto__ = superClass;
};

/***/ }),
/* 8 */
/***/ (function(module, exports) {

var core = module.exports = { version: '2.5.1' };
if (typeof __e == 'number') __e = core; // eslint-disable-line no-undef


/***/ }),
/* 9 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function(process) {/**
 * Copyright 2013-2015, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 */



/**
 * Use invariant() to assert state which your program assumes to be true.
 *
 * Provide sprintf-style format (only %s is supported) and arguments
 * to provide information about what broke and what you were
 * expecting.
 *
 * The invariant message will be stripped in production, but the invariant
 * will remain to ensure logic does not differ in production.
 */

var invariant = function(condition, format, a, b, c, d, e, f) {
  if (process.env.NODE_ENV !== 'production') {
    if (format === undefined) {
      throw new Error('invariant requires an error message argument');
    }
  }

  if (!condition) {
    var error;
    if (format === undefined) {
      error = new Error(
        'Minified exception occurred; use the non-minified dev environment ' +
        'for the full error message and additional helpful warnings.'
      );
    } else {
      var args = [a, b, c, d, e, f];
      var argIndex = 0;
      error = new Error(
        format.replace(/%s/g, function() { return args[argIndex++]; })
      );
      error.name = 'Invariant Violation';
    }

    error.framesToPop = 1; // we don't care about invariant's own frame
    throw error;
  }
};

module.exports = invariant;

/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(1)))

/***/ }),
/* 10 */
/***/ (function(module, exports, __webpack_require__) {

var store = __webpack_require__(55)('wks');
var uid = __webpack_require__(34);
var Symbol = __webpack_require__(11).Symbol;
var USE_SYMBOL = typeof Symbol == 'function';

var $exports = module.exports = function (name) {
  return store[name] || (store[name] =
    USE_SYMBOL && Symbol[name] || (USE_SYMBOL ? Symbol : uid)('Symbol.' + name));
};

$exports.store = store;


/***/ }),
/* 11 */
/***/ (function(module, exports) {

// https://github.com/zloirock/core-js/issues/86#issuecomment-115759028
var global = module.exports = typeof window != 'undefined' && window.Math == Math
  ? window : typeof self != 'undefined' && self.Math == Math ? self
  // eslint-disable-next-line no-new-func
  : Function('return this')();
if (typeof __g == 'number') __g = global; // eslint-disable-line no-undef


/***/ }),
/* 12 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


exports.__esModule = true;

var _assign = __webpack_require__(198);

var _assign2 = _interopRequireDefault(_assign);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports.default = _assign2.default || function (target) {
  for (var i = 1; i < arguments.length; i++) {
    var source = arguments[i];

    for (var key in source) {
      if (Object.prototype.hasOwnProperty.call(source, key)) {
        target[key] = source[key];
      }
    }
  }

  return target;
};

/***/ }),
/* 13 */
/***/ (function(module, exports) {

var hasOwnProperty = {}.hasOwnProperty;
module.exports = function (it, key) {
  return hasOwnProperty.call(it, key);
};


/***/ }),
/* 14 */
/***/ (function(module, exports, __webpack_require__) {

var global = __webpack_require__(11);
var core = __webpack_require__(8);
var ctx = __webpack_require__(88);
var hide = __webpack_require__(20);
var PROTOTYPE = 'prototype';

var $export = function (type, name, source) {
  var IS_FORCED = type & $export.F;
  var IS_GLOBAL = type & $export.G;
  var IS_STATIC = type & $export.S;
  var IS_PROTO = type & $export.P;
  var IS_BIND = type & $export.B;
  var IS_WRAP = type & $export.W;
  var exports = IS_GLOBAL ? core : core[name] || (core[name] = {});
  var expProto = exports[PROTOTYPE];
  var target = IS_GLOBAL ? global : IS_STATIC ? global[name] : (global[name] || {})[PROTOTYPE];
  var key, own, out;
  if (IS_GLOBAL) source = name;
  for (key in source) {
    // contains in native
    own = !IS_FORCED && target && target[key] !== undefined;
    if (own && key in exports) continue;
    // export native or passed
    out = own ? target[key] : source[key];
    // prevent global pollution for namespaces
    exports[key] = IS_GLOBAL && typeof target[key] != 'function' ? source[key]
    // bind timers to global for call from export context
    : IS_BIND && own ? ctx(out, global)
    // wrap global constructors for prevent change them in library
    : IS_WRAP && target[key] == out ? (function (C) {
      var F = function (a, b, c) {
        if (this instanceof C) {
          switch (arguments.length) {
            case 0: return new C();
            case 1: return new C(a);
            case 2: return new C(a, b);
          } return new C(a, b, c);
        } return C.apply(this, arguments);
      };
      F[PROTOTYPE] = C[PROTOTYPE];
      return F;
    // make static versions for prototype methods
    })(out) : IS_PROTO && typeof out == 'function' ? ctx(Function.call, out) : out;
    // export proto methods to core.%CONSTRUCTOR%.methods.%NAME%
    if (IS_PROTO) {
      (exports.virtual || (exports.virtual = {}))[key] = out;
      // export proto methods to core.%CONSTRUCTOR%.prototype.%NAME%
      if (type & $export.R && expProto && !expProto[key]) hide(expProto, key, out);
    }
  }
};
// type bitmap
$export.F = 1; // forced
$export.G = 2; // global
$export.S = 4; // static
$export.P = 8; // proto
$export.B = 16; // bind
$export.W = 32; // wrap
$export.U = 64; // safe
$export.R = 128; // real proto method for `library`
module.exports = $export;


/***/ }),
/* 15 */
/***/ (function(module, exports, __webpack_require__) {

var anObject = __webpack_require__(21);
var IE8_DOM_DEFINE = __webpack_require__(89);
var toPrimitive = __webpack_require__(57);
var dP = Object.defineProperty;

exports.f = __webpack_require__(16) ? Object.defineProperty : function defineProperty(O, P, Attributes) {
  anObject(O);
  P = toPrimitive(P, true);
  anObject(Attributes);
  if (IE8_DOM_DEFINE) try {
    return dP(O, P, Attributes);
  } catch (e) { /* empty */ }
  if ('get' in Attributes || 'set' in Attributes) throw TypeError('Accessors not supported!');
  if ('value' in Attributes) O[P] = Attributes.value;
  return O;
};


/***/ }),
/* 16 */
/***/ (function(module, exports, __webpack_require__) {

// Thank's IE8 for his funny defineProperty
module.exports = !__webpack_require__(22)(function () {
  return Object.defineProperty({}, 'a', { get: function () { return 7; } }).a != 7;
});


/***/ }),
/* 17 */
/***/ (function(module, exports, __webpack_require__) {

// to indexed object, toObject with fallback for non-array-like ES3 strings
var IObject = __webpack_require__(95);
var defined = __webpack_require__(53);
module.exports = function (it) {
  return IObject(defined(it));
};


/***/ }),
/* 18 */
/***/ (function(module, exports, __webpack_require__) {

var baseGetTag = __webpack_require__(40),
    getPrototype = __webpack_require__(251),
    isObjectLike = __webpack_require__(31);

/** `Object#toString` result references. */
var objectTag = '[object Object]';

/** Used for built-in method references. */
var funcProto = Function.prototype,
    objectProto = Object.prototype;

/** Used to resolve the decompiled source of functions. */
var funcToString = funcProto.toString;

/** Used to check objects for own properties. */
var hasOwnProperty = objectProto.hasOwnProperty;

/** Used to infer the `Object` constructor. */
var objectCtorString = funcToString.call(Object);

/**
 * Checks if `value` is a plain object, that is, an object created by the
 * `Object` constructor or one with a `[[Prototype]]` of `null`.
 *
 * @static
 * @memberOf _
 * @since 0.8.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a plain object, else `false`.
 * @example
 *
 * function Foo() {
 *   this.a = 1;
 * }
 *
 * _.isPlainObject(new Foo);
 * // => false
 *
 * _.isPlainObject([1, 2, 3]);
 * // => false
 *
 * _.isPlainObject({ 'x': 0, 'y': 0 });
 * // => true
 *
 * _.isPlainObject(Object.create(null));
 * // => true
 */
function isPlainObject(value) {
  if (!isObjectLike(value) || baseGetTag(value) != objectTag) {
    return false;
  }
  var proto = getPrototype(value);
  if (proto === null) {
    return true;
  }
  var Ctor = hasOwnProperty.call(proto, 'constructor') && proto.constructor;
  return typeof Ctor == 'function' && Ctor instanceof Ctor &&
    funcToString.call(Ctor) == objectCtorString;
}

module.exports = isPlainObject;


/***/ }),
/* 19 */
/***/ (function(module, exports) {

/**
 * Checks if `value` is classified as an `Array` object.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is an array, else `false`.
 * @example
 *
 * _.isArray([1, 2, 3]);
 * // => true
 *
 * _.isArray(document.body.children);
 * // => false
 *
 * _.isArray('abc');
 * // => false
 *
 * _.isArray(_.noop);
 * // => false
 */
var isArray = Array.isArray;

module.exports = isArray;


/***/ }),
/* 20 */
/***/ (function(module, exports, __webpack_require__) {

var dP = __webpack_require__(15);
var createDesc = __webpack_require__(35);
module.exports = __webpack_require__(16) ? function (object, key, value) {
  return dP.f(object, key, createDesc(1, value));
} : function (object, key, value) {
  object[key] = value;
  return object;
};


/***/ }),
/* 21 */
/***/ (function(module, exports, __webpack_require__) {

var isObject = __webpack_require__(27);
module.exports = function (it) {
  if (!isObject(it)) throw TypeError(it + ' is not an object!');
  return it;
};


/***/ }),
/* 22 */
/***/ (function(module, exports) {

module.exports = function (exec) {
  try {
    return !!exec();
  } catch (e) {
    return true;
  }
};


/***/ }),
/* 23 */
/***/ (function(module, exports) {

module.exports = h$concur.ReactDOM;

/***/ }),
/* 24 */
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/*!
  Copyright (c) 2016 Jed Watson.
  Licensed under the MIT License (MIT), see
  http://jedwatson.github.io/classnames
*/
/* global define */

(function () {
 'use strict';

 var hasOwn = {}.hasOwnProperty;

 function classNames () {
  var classes = [];

  for (var i = 0; i < arguments.length; i++) {
   var arg = arguments[i];
   if (!arg) continue;

   var argType = typeof arg;

   if (argType === 'string' || argType === 'number') {
    classes.push(arg);
   } else if (Array.isArray(arg)) {
    classes.push(classNames.apply(null, arg));
   } else if (argType === 'object') {
    for (var key in arg) {
     if (hasOwn.call(arg, key) && arg[key]) {
      classes.push(key);
     }
    }
   }
  }

  return classes.join(' ');
 }

 if (typeof module !== 'undefined' && module.exports) {
  module.exports = classNames;
 } else if (true) {
  // register as 'classnames', consistent with npm package name
  !(__WEBPACK_AMD_DEFINE_ARRAY__ = [], __WEBPACK_AMD_DEFINE_RESULT__ = function () {
   return classNames;
  }.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
    __WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
 } else {
  window.classNames = classNames;
 }
}());


/***/ }),
/* 25 */
/***/ (function(module, exports) {

var g;

// This works in non-strict mode
g = (function() {
 return this;
})();

try {
 // This works if eval is allowed (see CSP)
 g = g || Function("return this")() || (1,eval)("this");
} catch(e) {
 // This works if the window reference is available
 if(typeof window === "object")
  g = window;
}

// g can still be undefined, but nothing to do about it...
// We return undefined, instead of nothing here, so it's
// easier to handle this case. if(!global) { ...}

module.exports = g;


/***/ }),
/* 26 */
/***/ (function(module, exports, __webpack_require__) {

var identity = __webpack_require__(134),
    overRest = __webpack_require__(288),
    setToString = __webpack_require__(289);

/**
 * The base implementation of `_.rest` which doesn't validate or coerce arguments.
 *
 * @private
 * @param {Function} func The function to apply a rest parameter to.
 * @param {number} [start=func.length-1] The start position of the rest parameter.
 * @returns {Function} Returns the new function.
 */
function baseRest(func, start) {
  return setToString(overRest(func, start, identity), func + '');
}

module.exports = baseRest;


/***/ }),
/* 27 */
/***/ (function(module, exports) {

module.exports = function (it) {
  return typeof it === 'object' ? it !== null : typeof it === 'function';
};


/***/ }),
/* 28 */
/***/ (function(module, exports) {

module.exports = {};


/***/ }),
/* 29 */
/***/ (function(module, exports, __webpack_require__) {

// 19.1.2.14 / 15.2.3.14 Object.keys(O)
var $keys = __webpack_require__(94);
var enumBugKeys = __webpack_require__(63);

module.exports = Object.keys || function keys(O) {
  return $keys(O, enumBugKeys);
};


/***/ }),
/* 30 */
/***/ (function(module, exports, __webpack_require__) {

var freeGlobal = __webpack_require__(127);

/** Detect free variable `self`. */
var freeSelf = typeof self == 'object' && self && self.Object === Object && self;

/** Used as a reference to the global object. */
var root = freeGlobal || freeSelf || Function('return this')();

module.exports = root;


/***/ }),
/* 31 */
/***/ (function(module, exports) {

/**
 * Checks if `value` is object-like. A value is object-like if it's not `null`
 * and has a `typeof` result of "object".
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is object-like, else `false`.
 * @example
 *
 * _.isObjectLike({});
 * // => true
 *
 * _.isObjectLike([1, 2, 3]);
 * // => true
 *
 * _.isObjectLike(_.noop);
 * // => false
 *
 * _.isObjectLike(null);
 * // => false
 */
function isObjectLike(value) {
  return value != null && typeof value == 'object';
}

module.exports = isObjectLike;


/***/ }),
/* 32 */
/***/ (function(module, exports) {

/**
 * Checks if `value` is the
 * [language type](http://www.ecma-international.org/ecma-262/7.0/#sec-ecmascript-language-types)
 * of `Object`. (e.g. arrays, functions, objects, regexes, `new Number(0)`, and `new String('')`)
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is an object, else `false`.
 * @example
 *
 * _.isObject({});
 * // => true
 *
 * _.isObject([1, 2, 3]);
 * // => true
 *
 * _.isObject(_.noop);
 * // => true
 *
 * _.isObject(null);
 * // => false
 */
function isObject(value) {
  var type = typeof value;
  return value != null && (type == 'object' || type == 'function');
}

module.exports = isObject;


/***/ }),
/* 33 */
/***/ (function(module, exports, __webpack_require__) {

// 7.1.13 ToObject(argument)
var defined = __webpack_require__(53);
module.exports = function (it) {
  return Object(defined(it));
};


/***/ }),
/* 34 */
/***/ (function(module, exports) {

var id = 0;
var px = Math.random();
module.exports = function (key) {
  return 'Symbol('.concat(key === undefined ? '' : key, ')_', (++id + px).toString(36));
};


/***/ }),
/* 35 */
/***/ (function(module, exports) {

module.exports = function (bitmap, value) {
  return {
    enumerable: !(bitmap & 1),
    configurable: !(bitmap & 2),
    writable: !(bitmap & 4),
    value: value
  };
};


/***/ }),
/* 36 */
/***/ (function(module, exports) {

exports.f = {}.propertyIsEnumerable;


/***/ }),
/* 37 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


exports.__esModule = true;

exports.default = function (obj, keys) {
  var target = {};

  for (var i in obj) {
    if (keys.indexOf(i) >= 0) continue;
    if (!Object.prototype.hasOwnProperty.call(obj, i)) continue;
    target[i] = obj[i];
  }

  return target;
};

/***/ }),
/* 38 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__Grid__ = __webpack_require__(104);
/* harmony reexport (binding) */ __webpack_require__.d(__webpack_exports__, "c", function() { return __WEBPACK_IMPORTED_MODULE_0__Grid__["a"]; });
/* harmony reexport (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return __WEBPACK_IMPORTED_MODULE_0__Grid__["a"]; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__accessibilityOverscanIndicesGetter__ = __webpack_require__(215);
/* harmony reexport (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return __WEBPACK_IMPORTED_MODULE_1__accessibilityOverscanIndicesGetter__["a"]; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__defaultCellRangeRenderer__ = __webpack_require__(106);
/* harmony reexport (binding) */ __webpack_require__.d(__webpack_exports__, "d", function() { return __WEBPACK_IMPORTED_MODULE_2__defaultCellRangeRenderer__["a"]; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__defaultOverscanIndicesGetter__ = __webpack_require__(105);
/* harmony reexport (binding) */ __webpack_require__.d(__webpack_exports__, "e", function() { return __WEBPACK_IMPORTED_MODULE_3__defaultOverscanIndicesGetter__["c"]; });
/***/ }),
/* 39 */
/***/ (function(module, exports) {

module.exports = function(module) {
 if(!module.webpackPolyfill) {
  module.deprecate = function() {};
  module.paths = [];
  // module.parent = undefined by default
  if(!module.children) module.children = [];
  Object.defineProperty(module, "loaded", {
   enumerable: true,
   get: function() {
    return module.l;
   }
  });
  Object.defineProperty(module, "id", {
   enumerable: true,
   get: function() {
    return module.i;
   }
  });
  module.webpackPolyfill = 1;
 }
 return module;
};


/***/ }),
/* 40 */
/***/ (function(module, exports, __webpack_require__) {

var Symbol = __webpack_require__(72),
    getRawTag = __webpack_require__(249),
    objectToString = __webpack_require__(250);

/** `Object#toString` result references. */
var nullTag = '[object Null]',
    undefinedTag = '[object Undefined]';

/** Built-in value references. */
var symToStringTag = Symbol ? Symbol.toStringTag : undefined;

/**
 * The base implementation of `getTag` without fallbacks for buggy environments.
 *
 * @private
 * @param {*} value The value to query.
 * @returns {string} Returns the `toStringTag`.
 */
function baseGetTag(value) {
  if (value == null) {
    return value === undefined ? undefinedTag : nullTag;
  }
  return (symToStringTag && symToStringTag in Object(value))
    ? getRawTag(value)
    : objectToString(value);
}

module.exports = baseGetTag;


/***/ }),
/* 41 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.END_DRAG = exports.DROP = exports.HOVER = exports.PUBLISH_DRAG_SOURCE = exports.BEGIN_DRAG = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

exports.beginDrag = beginDrag;
exports.publishDragSource = publishDragSource;
exports.hover = hover;
exports.drop = drop;
exports.endDrag = endDrag;

var _invariant = __webpack_require__(9);

var _invariant2 = _interopRequireDefault(_invariant);

var _isArray = __webpack_require__(19);

var _isArray2 = _interopRequireDefault(_isArray);

var _isObject = __webpack_require__(32);

var _isObject2 = _interopRequireDefault(_isObject);

var _matchesType = __webpack_require__(129);

var _matchesType2 = _interopRequireDefault(_matchesType);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var BEGIN_DRAG = exports.BEGIN_DRAG = 'dnd-core/BEGIN_DRAG';
var PUBLISH_DRAG_SOURCE = exports.PUBLISH_DRAG_SOURCE = 'dnd-core/PUBLISH_DRAG_SOURCE';
var HOVER = exports.HOVER = 'dnd-core/HOVER';
var DROP = exports.DROP = 'dnd-core/DROP';
var END_DRAG = exports.END_DRAG = 'dnd-core/END_DRAG';

function beginDrag(sourceIds) {
  var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : { publishSource: true, clientOffset: null };
  var publishSource = options.publishSource,
      clientOffset = options.clientOffset,
      getSourceClientOffset = options.getSourceClientOffset;

  (0, _invariant2.default)((0, _isArray2.default)(sourceIds), 'Expected sourceIds to be an array.');

  var monitor = this.getMonitor();
  var registry = this.getRegistry();
  (0, _invariant2.default)(!monitor.isDragging(), 'Cannot call beginDrag while dragging.');

  for (var i = 0; i < sourceIds.length; i++) {
    (0, _invariant2.default)(registry.getSource(sourceIds[i]), 'Expected sourceIds to be registered.');
  }

  var sourceId = null;
  for (var _i = sourceIds.length - 1; _i >= 0; _i--) {
    if (monitor.canDragSource(sourceIds[_i])) {
      sourceId = sourceIds[_i];
      break;
    }
  }
  if (sourceId === null) {
    return;
  }

  var sourceClientOffset = null;
  if (clientOffset) {
    (0, _invariant2.default)(typeof getSourceClientOffset === 'function', 'When clientOffset is provided, getSourceClientOffset must be a function.');
    sourceClientOffset = getSourceClientOffset(sourceId);
  }

  var source = registry.getSource(sourceId);
  var item = source.beginDrag(monitor, sourceId);
  (0, _invariant2.default)((0, _isObject2.default)(item), 'Item must be an object.');

  registry.pinSource(sourceId);

  var itemType = registry.getSourceType(sourceId);
  return {
    type: BEGIN_DRAG,
    itemType: itemType,
    item: item,
    sourceId: sourceId,
    clientOffset: clientOffset,
    sourceClientOffset: sourceClientOffset,
    isSourcePublic: publishSource
  };
}

function publishDragSource() {
  var monitor = this.getMonitor();
  if (!monitor.isDragging()) {
    return;
  }

  return { type: PUBLISH_DRAG_SOURCE };
}

function hover(targetIdsArg) {
  var _ref = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
      _ref$clientOffset = _ref.clientOffset,
      clientOffset = _ref$clientOffset === undefined ? null : _ref$clientOffset;

  (0, _invariant2.default)((0, _isArray2.default)(targetIdsArg), 'Expected targetIds to be an array.');
  var targetIds = targetIdsArg.slice(0);

  var monitor = this.getMonitor();
  var registry = this.getRegistry();
  (0, _invariant2.default)(monitor.isDragging(), 'Cannot call hover while not dragging.');
  (0, _invariant2.default)(!monitor.didDrop(), 'Cannot call hover after drop.');

  // First check invariants.
  for (var i = 0; i < targetIds.length; i++) {
    var targetId = targetIds[i];
    (0, _invariant2.default)(targetIds.lastIndexOf(targetId) === i, 'Expected targetIds to be unique in the passed array.');

    var target = registry.getTarget(targetId);
    (0, _invariant2.default)(target, 'Expected targetIds to be registered.');
  }

  var draggedItemType = monitor.getItemType();

  // Remove those targetIds that don't match the targetType.  This
  // fixes shallow isOver which would only be non-shallow because of
  // non-matching targets.
  for (var _i2 = targetIds.length - 1; _i2 >= 0; _i2--) {
    var _targetId = targetIds[_i2];
    var targetType = registry.getTargetType(_targetId);
    if (!(0, _matchesType2.default)(targetType, draggedItemType)) {
      targetIds.splice(_i2, 1);
    }
  }

  // Finally call hover on all matching targets.
  for (var _i3 = 0; _i3 < targetIds.length; _i3++) {
    var _targetId2 = targetIds[_i3];
    var _target = registry.getTarget(_targetId2);
    _target.hover(monitor, _targetId2);
  }

  return {
    type: HOVER,
    targetIds: targetIds,
    clientOffset: clientOffset
  };
}

function drop() {
  var _this = this;

  var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

  var monitor = this.getMonitor();
  var registry = this.getRegistry();
  (0, _invariant2.default)(monitor.isDragging(), 'Cannot call drop while not dragging.');
  (0, _invariant2.default)(!monitor.didDrop(), 'Cannot call drop twice during one drag operation.');

  var targetIds = monitor.getTargetIds().filter(monitor.canDropOnTarget, monitor);

  targetIds.reverse();
  targetIds.forEach(function (targetId, index) {
    var target = registry.getTarget(targetId);

    var dropResult = target.drop(monitor, targetId);
    (0, _invariant2.default)(typeof dropResult === 'undefined' || (0, _isObject2.default)(dropResult), 'Drop result must either be an object or undefined.');
    if (typeof dropResult === 'undefined') {
      dropResult = index === 0 ? {} : monitor.getDropResult();
    }

    _this.store.dispatch({
      type: DROP,
      dropResult: _extends({}, options, dropResult)
    });
  });
}

function endDrag() {
  var monitor = this.getMonitor();
  var registry = this.getRegistry();
  (0, _invariant2.default)(monitor.isDragging(), 'Cannot call endDrag while not dragging.');

  var sourceId = monitor.getSourceId();
  var source = registry.getSource(sourceId, true);
  source.endDrag(monitor, sourceId);

  registry.unpinSource();

  return { type: END_DRAG };
}

/***/ }),
/* 42 */
/***/ (function(module, exports, __webpack_require__) {

var getNative = __webpack_require__(43);

/* Built-in method references that are verified to be native. */
var nativeCreate = getNative(Object, 'create');

module.exports = nativeCreate;


/***/ }),
/* 43 */
/***/ (function(module, exports, __webpack_require__) {

var baseIsNative = __webpack_require__(261),
    getValue = __webpack_require__(265);

/**
 * Gets the native function at `key` of `object`.
 *
 * @private
 * @param {Object} object The object to query.
 * @param {string} key The key of the method to get.
 * @returns {*} Returns the function if it's native, else `undefined`.
 */
function getNative(object, key) {
  var value = getValue(object, key);
  return baseIsNative(value) ? value : undefined;
}

module.exports = getNative;


/***/ }),
/* 44 */
/***/ (function(module, exports, __webpack_require__) {

var eq = __webpack_require__(45);

/**
 * Gets the index at which the `key` is found in `array` of key-value pairs.
 *
 * @private
 * @param {Array} array The array to inspect.
 * @param {*} key The key to search for.
 * @returns {number} Returns the index of the matched value, else `-1`.
 */
function assocIndexOf(array, key) {
  var length = array.length;
  while (length--) {
    if (eq(array[length][0], key)) {
      return length;
    }
  }
  return -1;
}

module.exports = assocIndexOf;


/***/ }),
/* 45 */
/***/ (function(module, exports) {

/**
 * Performs a
 * [`SameValueZero`](http://ecma-international.org/ecma-262/7.0/#sec-samevaluezero)
 * comparison between two values to determine if they are equivalent.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to compare.
 * @param {*} other The other value to compare.
 * @returns {boolean} Returns `true` if the values are equivalent, else `false`.
 * @example
 *
 * var object = { 'a': 1 };
 * var other = { 'a': 1 };
 *
 * _.eq(object, object);
 * // => true
 *
 * _.eq(object, other);
 * // => false
 *
 * _.eq('a', 'a');
 * // => true
 *
 * _.eq('a', Object('a'));
 * // => false
 *
 * _.eq(NaN, NaN);
 * // => true
 */
function eq(value, other) {
  return value === other || (value !== value && other !== other);
}

module.exports = eq;


/***/ }),
/* 46 */
/***/ (function(module, exports, __webpack_require__) {

var isKeyable = __webpack_require__(278);

/**
 * Gets the data for `map`.
 *
 * @private
 * @param {Object} map The map to query.
 * @param {string} key The reference key.
 * @returns {*} Returns the map data.
 */
function getMapData(map, key) {
  var data = map.__data__;
  return isKeyable(key)
    ? data[typeof key == 'string' ? 'string' : 'hash']
    : data.map;
}

module.exports = getMapData;


/***/ }),
/* 47 */
/***/ (function(module, exports, __webpack_require__) {

var isArrayLike = __webpack_require__(79),
    isObjectLike = __webpack_require__(31);

/**
 * This method is like `_.isArrayLike` except that it also checks if `value`
 * is an object.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is an array-like object,
 *  else `false`.
 * @example
 *
 * _.isArrayLikeObject([1, 2, 3]);
 * // => true
 *
 * _.isArrayLikeObject(document.body.children);
 * // => true
 *
 * _.isArrayLikeObject('abc');
 * // => false
 *
 * _.isArrayLikeObject(_.noop);
 * // => false
 */
function isArrayLikeObject(value) {
  return isObjectLike(value) && isArrayLike(value);
}

module.exports = isArrayLikeObject;


/***/ }),
/* 48 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.addSource = addSource;
exports.addTarget = addTarget;
exports.removeSource = removeSource;
exports.removeTarget = removeTarget;
var ADD_SOURCE = exports.ADD_SOURCE = 'dnd-core/ADD_SOURCE';
var ADD_TARGET = exports.ADD_TARGET = 'dnd-core/ADD_TARGET';
var REMOVE_SOURCE = exports.REMOVE_SOURCE = 'dnd-core/REMOVE_SOURCE';
var REMOVE_TARGET = exports.REMOVE_TARGET = 'dnd-core/REMOVE_TARGET';

function addSource(sourceId) {
  return {
    type: ADD_SOURCE,
    sourceId: sourceId
  };
}

function addTarget(targetId) {
  return {
    type: ADD_TARGET,
    targetId: targetId
  };
}

function removeSource(sourceId) {
  return {
    type: REMOVE_SOURCE,
    sourceId: sourceId
  };
}

function removeTarget(targetId) {
  return {
    type: REMOVE_TARGET,
    targetId: targetId
  };
}

/***/ }),
/* 49 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function(process) {

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = checkDecoratorArguments;
function checkDecoratorArguments(functionName, signature) {
  if (process.env.NODE_ENV !== 'production') {
    for (var i = 0; i < (arguments.length <= 2 ? 0 : arguments.length - 2); i += 1) {
      var arg = arguments.length <= i + 2 ? undefined : arguments[i + 2];
      if (arg && arg.prototype && arg.prototype.render) {
        console.error( // eslint-disable-line no-console
        'You seem to be applying the arguments in the wrong order. ' + ('It should be ' + functionName + '(' + signature + ')(Component), not the other way around. ') + 'Read more: http://react-dnd.github.io/react-dnd/docs-troubleshooting.html#you-seem-to-be-applying-the-arguments-in-the-wrong-order');
        return;
      }
    }
  }
}
/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(1)))

/***/ }),
/* 50 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


/**
 * Copyright (c) 2013-present, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 *
 * 
 */

function makeEmptyFunction(arg) {
  return function () {
    return arg;
  };
}

/**
 * This function accepts and discards inputs; it has no side effects. This is
 * primarily useful idiomatically for overridable function endpoints which
 * always need to be callable, since JS lacks a null-call idiom ala Cocoa.
 */
var emptyFunction = function emptyFunction() {};

emptyFunction.thatReturns = makeEmptyFunction;
emptyFunction.thatReturnsFalse = makeEmptyFunction(false);
emptyFunction.thatReturnsTrue = makeEmptyFunction(true);
emptyFunction.thatReturnsNull = makeEmptyFunction(null);
emptyFunction.thatReturnsThis = function () {
  return this;
};
emptyFunction.thatReturnsArgument = function (arg) {
  return arg;
};

module.exports = emptyFunction;

/***/ }),
/* 51 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function(process) {/**
 * Copyright (c) 2013-present, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 *
 */



/**
 * Use invariant() to assert state which your program assumes to be true.
 *
 * Provide sprintf-style format (only %s is supported) and arguments
 * to provide information about what broke and what you were
 * expecting.
 *
 * The invariant message will be stripped in production, but the invariant
 * will remain to ensure logic does not differ in production.
 */

var validateFormat = function validateFormat(format) {};

if (process.env.NODE_ENV !== 'production') {
  validateFormat = function validateFormat(format) {
    if (format === undefined) {
      throw new Error('invariant requires an error message argument');
    }
  };
}

function invariant(condition, format, a, b, c, d, e, f) {
  validateFormat(format);

  if (!condition) {
    var error;
    if (format === undefined) {
      error = new Error('Minified exception occurred; use the non-minified dev environment ' + 'for the full error message and additional helpful warnings.');
    } else {
      var args = [a, b, c, d, e, f];
      var argIndex = 0;
      error = new Error(format.replace(/%s/g, function () {
        return args[argIndex++];
      }));
      error.name = 'Invariant Violation';
    }

    error.framesToPop = 1; // we don't care about invariant's own frame
    throw error;
  }
}

module.exports = invariant;
/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(1)))

/***/ }),
/* 52 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/**
 * Copyright 2013-present, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 */



var ReactPropTypesSecret = 'SECRET_DO_NOT_PASS_THIS_OR_YOU_WILL_BE_FIRED';

module.exports = ReactPropTypesSecret;


/***/ }),
/* 53 */
/***/ (function(module, exports) {

// 7.2.1 RequireObjectCoercible(argument)
module.exports = function (it) {
  if (it == undefined) throw TypeError("Can't call method on  " + it);
  return it;
};


/***/ }),
/* 54 */
/***/ (function(module, exports, __webpack_require__) {

var shared = __webpack_require__(55)('keys');
var uid = __webpack_require__(34);
module.exports = function (key) {
  return shared[key] || (shared[key] = uid(key));
};


/***/ }),
/* 55 */
/***/ (function(module, exports, __webpack_require__) {

var global = __webpack_require__(11);
var SHARED = '__core-js_shared__';
var store = global[SHARED] || (global[SHARED] = {});
module.exports = function (key) {
  return store[key] || (store[key] = {});
};


/***/ }),
/* 56 */
/***/ (function(module, exports, __webpack_require__) {

// most Object methods by ES6 should accept primitives
var $export = __webpack_require__(14);
var core = __webpack_require__(8);
var fails = __webpack_require__(22);
module.exports = function (KEY, exec) {
  var fn = (core.Object || {})[KEY] || Object[KEY];
  var exp = {};
  exp[KEY] = exec(fn);
  $export($export.S + $export.F * fails(function () { fn(1); }), 'Object', exp);
};


/***/ }),
/* 57 */
/***/ (function(module, exports, __webpack_require__) {

// 7.1.1 ToPrimitive(input [, PreferredType])
var isObject = __webpack_require__(27);
// instead of the ES6 spec version, we didn't implement @@toPrimitive case
// and the second argument - flag - preferred type is a string
module.exports = function (it, S) {
  if (!isObject(it)) return it;
  var fn, val;
  if (S && typeof (fn = it.toString) == 'function' && !isObject(val = fn.call(it))) return val;
  if (typeof (fn = it.valueOf) == 'function' && !isObject(val = fn.call(it))) return val;
  if (!S && typeof (fn = it.toString) == 'function' && !isObject(val = fn.call(it))) return val;
  throw TypeError("Can't convert object to primitive value");
};


/***/ }),
/* 58 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var $at = __webpack_require__(167)(true);

// 21.1.3.27 String.prototype[@@iterator]()
__webpack_require__(92)(String, 'String', function (iterated) {
  this._t = String(iterated); // target
  this._i = 0; // next index
// 21.1.5.2.1 %StringIteratorPrototype%.next()
}, function () {
  var O = this._t;
  var index = this._i;
  var point;
  if (index >= O.length) return { value: undefined, done: true };
  point = $at(O, index);
  this._i += point.length;
  return { value: point, done: false };
});


/***/ }),
/* 59 */
/***/ (function(module, exports) {

// 7.1.4 ToInteger
var ceil = Math.ceil;
var floor = Math.floor;
module.exports = function (it) {
  return isNaN(it = +it) ? 0 : (it > 0 ? floor : ceil)(it);
};


/***/ }),
/* 60 */
/***/ (function(module, exports) {

module.exports = true;


/***/ }),
/* 61 */
/***/ (function(module, exports, __webpack_require__) {

// 19.1.2.2 / 15.2.3.5 Object.create(O [, Properties])
var anObject = __webpack_require__(21);
var dPs = __webpack_require__(169);
var enumBugKeys = __webpack_require__(63);
var IE_PROTO = __webpack_require__(54)('IE_PROTO');
var Empty = function () { /* empty */ };
var PROTOTYPE = 'prototype';

// Create object with fake `null` prototype: use iframe Object with cleared prototype
var createDict = function () {
  // Thrash, waste and sodomy: IE GC bug
  var iframe = __webpack_require__(90)('iframe');
  var i = enumBugKeys.length;
  var lt = '<';
  var gt = '>';
  var iframeDocument;
  iframe.style.display = 'none';
  __webpack_require__(173).appendChild(iframe);
  iframe.src = 'javascript:'; // eslint-disable-line no-script-url
  // createDict = iframe.contentWindow.Object;
  // html.removeChild(iframe);
  iframeDocument = iframe.contentWindow.document;
  iframeDocument.open();
  iframeDocument.write(lt + 'script' + gt + 'document.F=Object' + lt + '/script' + gt);
  iframeDocument.close();
  createDict = iframeDocument.F;
  while (i--) delete createDict[PROTOTYPE][enumBugKeys[i]];
  return createDict();
};

module.exports = Object.create || function create(O, Properties) {
  var result;
  if (O !== null) {
    Empty[PROTOTYPE] = anObject(O);
    result = new Empty();
    Empty[PROTOTYPE] = null;
    // add "__proto__" for Object.getPrototypeOf polyfill
    result[IE_PROTO] = O;
  } else result = createDict();
  return Properties === undefined ? result : dPs(result, Properties);
};


/***/ }),
/* 62 */
/***/ (function(module, exports) {

var toString = {}.toString;

module.exports = function (it) {
  return toString.call(it).slice(8, -1);
};


/***/ }),
/* 63 */
/***/ (function(module, exports) {

// IE 8- don't enum bug keys
module.exports = (
  'constructor,hasOwnProperty,isPrototypeOf,propertyIsEnumerable,toLocaleString,toString,valueOf'
).split(',');


/***/ }),
/* 64 */
/***/ (function(module, exports, __webpack_require__) {

var def = __webpack_require__(15).f;
var has = __webpack_require__(13);
var TAG = __webpack_require__(10)('toStringTag');

module.exports = function (it, tag, stat) {
  if (it && !has(it = stat ? it : it.prototype, TAG)) def(it, TAG, { configurable: true, value: tag });
};


/***/ }),
/* 65 */
/***/ (function(module, exports, __webpack_require__) {

__webpack_require__(174);
var global = __webpack_require__(11);
var hide = __webpack_require__(20);
var Iterators = __webpack_require__(28);
var TO_STRING_TAG = __webpack_require__(10)('toStringTag');

var DOMIterables = ('CSSRuleList,CSSStyleDeclaration,CSSValueList,ClientRectList,DOMRectList,DOMStringList,' +
  'DOMTokenList,DataTransferItemList,FileList,HTMLAllCollection,HTMLCollection,HTMLFormElement,HTMLSelectElement,' +
  'MediaList,MimeTypeArray,NamedNodeMap,NodeList,PaintRequestList,Plugin,PluginArray,SVGLengthList,SVGNumberList,' +
  'SVGPathSegList,SVGPointList,SVGStringList,SVGTransformList,SourceBufferList,StyleSheetList,TextTrackCueList,' +
  'TextTrackList,TouchList').split(',');

for (var i = 0; i < DOMIterables.length; i++) {
  var NAME = DOMIterables[i];
  var Collection = global[NAME];
  var proto = Collection && Collection.prototype;
  if (proto && !proto[TO_STRING_TAG]) hide(proto, TO_STRING_TAG, NAME);
  Iterators[NAME] = Iterators.Array;
}


/***/ }),
/* 66 */
/***/ (function(module, exports, __webpack_require__) {

exports.f = __webpack_require__(10);


/***/ }),
/* 67 */
/***/ (function(module, exports, __webpack_require__) {

var global = __webpack_require__(11);
var core = __webpack_require__(8);
var LIBRARY = __webpack_require__(60);
var wksExt = __webpack_require__(66);
var defineProperty = __webpack_require__(15).f;
module.exports = function (name) {
  var $Symbol = core.Symbol || (core.Symbol = LIBRARY ? {} : global.Symbol || {});
  if (name.charAt(0) != '_' && !(name in $Symbol)) defineProperty($Symbol, name, { value: wksExt.f(name) });
};


/***/ }),
/* 68 */
/***/ (function(module, exports) {

exports.f = Object.getOwnPropertySymbols;


/***/ }),
/* 69 */
/***/ (function(module, exports, __webpack_require__) {

var pIE = __webpack_require__(36);
var createDesc = __webpack_require__(35);
var toIObject = __webpack_require__(17);
var toPrimitive = __webpack_require__(57);
var has = __webpack_require__(13);
var IE8_DOM_DEFINE = __webpack_require__(89);
var gOPD = Object.getOwnPropertyDescriptor;

exports.f = __webpack_require__(16) ? gOPD : function getOwnPropertyDescriptor(O, P) {
  O = toIObject(O);
  P = toPrimitive(P, true);
  if (IE8_DOM_DEFINE) try {
    return gOPD(O, P);
  } catch (e) { /* empty */ }
  if (has(O, P)) return createDesc(!pIE.f.call(O, P), O[P]);
};


/***/ }),
/* 70 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (immutable) */ __webpack_exports__["a"] = createCallbackMemoizer;
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_core_js_object_keys__ = __webpack_require__(101);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_core_js_object_keys___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_babel_runtime_core_js_object_keys__);

/**
 * Helper utility that updates the specified callback whenever any of the specified indices have changed.
 */
function createCallbackMemoizer() {
  var requireAllKeys = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : true;

  var cachedIndices = {};

  return function (_ref) {
    var callback = _ref.callback,
        indices = _ref.indices;

    var keys = __WEBPACK_IMPORTED_MODULE_0_babel_runtime_core_js_object_keys___default()(indices);
    var allInitialized = !requireAllKeys || keys.every(function (key) {
      var value = indices[key];
      return Array.isArray(value) ? value.length > 0 : value >= 0;
    });
    var indexChanged = keys.length !== __WEBPACK_IMPORTED_MODULE_0_babel_runtime_core_js_object_keys___default()(cachedIndices).length || keys.some(function (key) {
      var cachedValue = cachedIndices[key];
      var value = indices[key];

      return Array.isArray(value) ? cachedValue.join(',') !== value.join(',') : cachedValue !== value;
    });

    cachedIndices = indices;

    if (allInitialized && indexChanged) {
      callback(indices);
    }
  };
}

/***/ }),
/* 71 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
var SortDirection = {
  /**
   * Sort items in ascending order.
   * This means arranging from the lowest value to the highest (e.g. a-z, 0-9).
   */
  ASC: 'ASC',

  /**
   * Sort items in descending order.
   * This means arranging from the highest value to the lowest (e.g. z-a, 9-0).
   */
  DESC: 'DESC'
};

/* harmony default export */ __webpack_exports__["a"] = (SortDirection);

/***/ }),
/* 72 */
/***/ (function(module, exports, __webpack_require__) {

var root = __webpack_require__(30);

/** Built-in value references. */
var Symbol = root.Symbol;

module.exports = Symbol;


/***/ }),
/* 73 */
/***/ (function(module, exports, __webpack_require__) {

var MapCache = __webpack_require__(132),
    setCacheAdd = __webpack_require__(282),
    setCacheHas = __webpack_require__(283);

/**
 *
 * Creates an array cache object to store unique values.
 *
 * @private
 * @constructor
 * @param {Array} [values] The values to cache.
 */
function SetCache(values) {
  var index = -1,
      length = values == null ? 0 : values.length;

  this.__data__ = new MapCache;
  while (++index < length) {
    this.add(values[index]);
  }
}

// Add methods to `SetCache`.
SetCache.prototype.add = SetCache.prototype.push = setCacheAdd;
SetCache.prototype.has = setCacheHas;

module.exports = SetCache;


/***/ }),
/* 74 */
/***/ (function(module, exports, __webpack_require__) {

var baseIndexOf = __webpack_require__(284);

/**
 * A specialized version of `_.includes` for arrays without support for
 * specifying an index to search from.
 *
 * @private
 * @param {Array} [array] The array to inspect.
 * @param {*} target The value to search for.
 * @returns {boolean} Returns `true` if `target` is found, else `false`.
 */
function arrayIncludes(array, value) {
  var length = array == null ? 0 : array.length;
  return !!length && baseIndexOf(array, value, 0) > -1;
}

module.exports = arrayIncludes;


/***/ }),
/* 75 */
/***/ (function(module, exports) {

/**
 * This function is like `arrayIncludes` except that it accepts a comparator.
 *
 * @private
 * @param {Array} [array] The array to inspect.
 * @param {*} target The value to search for.
 * @param {Function} comparator The comparator invoked per element.
 * @returns {boolean} Returns `true` if `target` is found, else `false`.
 */
function arrayIncludesWith(array, value, comparator) {
  var index = -1,
      length = array == null ? 0 : array.length;

  while (++index < length) {
    if (comparator(value, array[index])) {
      return true;
    }
  }
  return false;
}

module.exports = arrayIncludesWith;


/***/ }),
/* 76 */
/***/ (function(module, exports) {

/**
 * A specialized version of `_.map` for arrays without support for iteratee
 * shorthands.
 *
 * @private
 * @param {Array} [array] The array to iterate over.
 * @param {Function} iteratee The function invoked per iteration.
 * @returns {Array} Returns the new mapped array.
 */
function arrayMap(array, iteratee) {
  var index = -1,
      length = array == null ? 0 : array.length,
      result = Array(length);

  while (++index < length) {
    result[index] = iteratee(array[index], index, array);
  }
  return result;
}

module.exports = arrayMap;


/***/ }),
/* 77 */
/***/ (function(module, exports) {

/**
 * The base implementation of `_.unary` without support for storing metadata.
 *
 * @private
 * @param {Function} func The function to cap arguments for.
 * @returns {Function} Returns the new capped function.
 */
function baseUnary(func) {
  return function(value) {
    return func(value);
  };
}

module.exports = baseUnary;


/***/ }),
/* 78 */
/***/ (function(module, exports) {

/**
 * Checks if a `cache` value for `key` exists.
 *
 * @private
 * @param {Object} cache The cache to query.
 * @param {string} key The key of the entry to check.
 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
 */
function cacheHas(cache, key) {
  return cache.has(key);
}

module.exports = cacheHas;


/***/ }),
/* 79 */
/***/ (function(module, exports, __webpack_require__) {

var isFunction = __webpack_require__(133),
    isLength = __webpack_require__(137);

/**
 * Checks if `value` is array-like. A value is considered array-like if it's
 * not a function and has a `value.length` that's an integer greater than or
 * equal to `0` and less than or equal to `Number.MAX_SAFE_INTEGER`.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is array-like, else `false`.
 * @example
 *
 * _.isArrayLike([1, 2, 3]);
 * // => true
 *
 * _.isArrayLike(document.body.children);
 * // => true
 *
 * _.isArrayLike('abc');
 * // => true
 *
 * _.isArrayLike(_.noop);
 * // => false
 */
function isArrayLike(value) {
  return value != null && isLength(value.length) && !isFunction(value);
}

module.exports = isArrayLike;


/***/ }),
/* 80 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/**
 * Copyright 2015, Yahoo! Inc.
 * Copyrights licensed under the New BSD License. See the accompanying LICENSE file for terms.
 */


var REACT_STATICS = {
    childContextTypes: true,
    contextTypes: true,
    defaultProps: true,
    displayName: true,
    getDefaultProps: true,
    mixins: true,
    propTypes: true,
    type: true
};

var KNOWN_STATICS = {
  name: true,
  length: true,
  prototype: true,
  caller: true,
  callee: true,
  arguments: true,
  arity: true
};

var defineProperty = Object.defineProperty;
var getOwnPropertyNames = Object.getOwnPropertyNames;
var getOwnPropertySymbols = Object.getOwnPropertySymbols;
var getOwnPropertyDescriptor = Object.getOwnPropertyDescriptor;
var getPrototypeOf = Object.getPrototypeOf;
var objectPrototype = getPrototypeOf && getPrototypeOf(Object);

module.exports = function hoistNonReactStatics(targetComponent, sourceComponent, blacklist) {
    if (typeof sourceComponent !== 'string') { // don't hoist over string (html) components

        if (objectPrototype) {
            var inheritedComponent = getPrototypeOf(sourceComponent);
            if (inheritedComponent && inheritedComponent !== objectPrototype) {
                hoistNonReactStatics(targetComponent, inheritedComponent, blacklist);
            }
        }

        var keys = getOwnPropertyNames(sourceComponent);

        if (getOwnPropertySymbols) {
            keys = keys.concat(getOwnPropertySymbols(sourceComponent));
        }

        for (var i = 0; i < keys.length; ++i) {
            var key = keys[i];
            if (!REACT_STATICS[key] && !KNOWN_STATICS[key] && (!blacklist || !blacklist[key])) {
                var descriptor = getOwnPropertyDescriptor(sourceComponent, key);
                try { // Avoid failures from read-only properties
                    defineProperty(targetComponent, key, descriptor);
                } catch (e) {}
            }
        }

        return targetComponent;
    }

    return targetComponent;
};


/***/ }),
/* 81 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = shallowEqual;
function shallowEqual(objA, objB) {
  if (objA === objB) {
    return true;
  }

  var keysA = Object.keys(objA);
  var keysB = Object.keys(objB);

  if (keysA.length !== keysB.length) {
    return false;
  }

  // Test for A's keys different from B.
  var hasOwn = Object.prototype.hasOwnProperty;
  for (var i = 0; i < keysA.length; i += 1) {
    if (!hasOwn.call(objB, keysA[i]) || objA[keysA[i]] !== objB[keysA[i]]) {
      return false;
    }

    var valA = objA[keysA[i]];
    var valB = objB[keysA[i]];

    if (valA !== valB) {
      return false;
    }
  }

  return true;
}

/***/ }),
/* 82 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


exports.__esModule = true;
exports['default'] = isDisposable;

function isDisposable(obj) {
  return Boolean(obj && typeof obj.dispose === 'function');
}

module.exports = exports['default'];

/***/ }),
/* 83 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
var FILE = exports.FILE = '__NATIVE_FILE__';
var URL = exports.URL = '__NATIVE_URL__';
var TEXT = exports.TEXT = '__NATIVE_TEXT__';

/***/ }),
/* 84 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function(process) {/**
 * Copyright 2014-2015, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 *
 */



var emptyFunction = __webpack_require__(50);

/**
 * Similar to invariant but only logs a warning if the condition is not met.
 * This can be used to log issues in development environments in critical
 * paths. Removing the logging code for production environments will keep the
 * same logic and follow the same code paths.
 */

var warning = emptyFunction;

if (process.env.NODE_ENV !== 'production') {
  var printWarning = function printWarning(format) {
    for (var _len = arguments.length, args = Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
      args[_key - 1] = arguments[_key];
    }

    var argIndex = 0;
    var message = 'Warning: ' + format.replace(/%s/g, function () {
      return args[argIndex++];
    });
    if (typeof console !== 'undefined') {
      console.error(message);
    }
    try {
      // --- Welcome to debugging React ---
      // This error was thrown as a convenience so that you can use this stack
      // to find the callsite that caused this warning to fire.
      throw new Error(message);
    } catch (x) {}
  };

  warning = function warning(condition, format) {
    if (format === undefined) {
      throw new Error('`warning(condition, format, ...args)` requires a warning ' + 'message argument');
    }

    if (format.indexOf('Failed Composite propType: ') === 0) {
      return; // Ignore CompositeComponent proptype check.
    }

    if (!condition) {
      for (var _len2 = arguments.length, args = Array(_len2 > 2 ? _len2 - 2 : 0), _key2 = 2; _key2 < _len2; _key2++) {
        args[_key2 - 2] = arguments[_key2];
      }

      printWarning.apply(undefined, [format].concat(args));
    }
  };
}

module.exports = warning;
/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(1)))

/***/ }),
/* 85 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
Object.defineProperty(__webpack_exports__, "__esModule", { value: true });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__ArrowKeyStepper__ = __webpack_require__(158);
/* harmony reexport (binding) */ __webpack_require__.d(__webpack_exports__, "ArrowKeyStepper", function() { return __WEBPACK_IMPORTED_MODULE_0__ArrowKeyStepper__["a"]; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__AutoSizer__ = __webpack_require__(194);
/* harmony reexport (binding) */ __webpack_require__.d(__webpack_exports__, "AutoSizer", function() { return __WEBPACK_IMPORTED_MODULE_1__AutoSizer__["a"]; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__CellMeasurer__ = __webpack_require__(98);
/* harmony reexport (binding) */ __webpack_require__.d(__webpack_exports__, "CellMeasurer", function() { return __WEBPACK_IMPORTED_MODULE_2__CellMeasurer__["a"]; });
/* harmony reexport (binding) */ __webpack_require__.d(__webpack_exports__, "CellMeasurerCache", function() { return __WEBPACK_IMPORTED_MODULE_2__CellMeasurer__["b"]; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__Collection__ = __webpack_require__(197);
/* harmony reexport (binding) */ __webpack_require__.d(__webpack_exports__, "Collection", function() { return __WEBPACK_IMPORTED_MODULE_3__Collection__["a"]; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4__ColumnSizer__ = __webpack_require__(210);
/* harmony reexport (binding) */ __webpack_require__.d(__webpack_exports__, "ColumnSizer", function() { return __WEBPACK_IMPORTED_MODULE_4__ColumnSizer__["a"]; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5__Grid__ = __webpack_require__(38);
/* harmony reexport (binding) */ __webpack_require__.d(__webpack_exports__, "accessibilityOverscanIndicesGetter", function() { return __WEBPACK_IMPORTED_MODULE_5__Grid__["b"]; });
/* harmony reexport (binding) */ __webpack_require__.d(__webpack_exports__, "defaultCellRangeRenderer", function() { return __WEBPACK_IMPORTED_MODULE_5__Grid__["d"]; });
/* harmony reexport (binding) */ __webpack_require__.d(__webpack_exports__, "defaultOverscanIndicesGetter", function() { return __WEBPACK_IMPORTED_MODULE_5__Grid__["e"]; });
/* harmony reexport (binding) */ __webpack_require__.d(__webpack_exports__, "Grid", function() { return __WEBPACK_IMPORTED_MODULE_5__Grid__["a"]; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6__InfiniteLoader__ = __webpack_require__(216);
/* harmony reexport (binding) */ __webpack_require__.d(__webpack_exports__, "InfiniteLoader", function() { return __WEBPACK_IMPORTED_MODULE_6__InfiniteLoader__["a"]; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7__List__ = __webpack_require__(217);
/* harmony reexport (binding) */ __webpack_require__.d(__webpack_exports__, "List", function() { return __WEBPACK_IMPORTED_MODULE_7__List__["a"]; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_8__Masonry__ = __webpack_require__(221);
/* harmony reexport (binding) */ __webpack_require__.d(__webpack_exports__, "createMasonryCellPositioner", function() { return __WEBPACK_IMPORTED_MODULE_8__Masonry__["b"]; });
/* harmony reexport (binding) */ __webpack_require__.d(__webpack_exports__, "Masonry", function() { return __WEBPACK_IMPORTED_MODULE_8__Masonry__["a"]; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_9__MultiGrid__ = __webpack_require__(234);
/* harmony reexport (binding) */ __webpack_require__.d(__webpack_exports__, "MultiGrid", function() { return __WEBPACK_IMPORTED_MODULE_9__MultiGrid__["a"]; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_10__ScrollSync__ = __webpack_require__(236);
/* harmony reexport (binding) */ __webpack_require__.d(__webpack_exports__, "ScrollSync", function() { return __WEBPACK_IMPORTED_MODULE_10__ScrollSync__["a"]; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_11__Table__ = __webpack_require__(237);
/* harmony reexport (binding) */ __webpack_require__.d(__webpack_exports__, "defaultTableCellDataGetter", function() { return __WEBPACK_IMPORTED_MODULE_11__Table__["e"]; });
/* harmony reexport (binding) */ __webpack_require__.d(__webpack_exports__, "defaultTableCellRenderer", function() { return __WEBPACK_IMPORTED_MODULE_11__Table__["f"]; });
/* harmony reexport (binding) */ __webpack_require__.d(__webpack_exports__, "defaultTableHeaderRenderer", function() { return __WEBPACK_IMPORTED_MODULE_11__Table__["g"]; });
/* harmony reexport (binding) */ __webpack_require__.d(__webpack_exports__, "defaultTableHeaderRowRenderer", function() { return __WEBPACK_IMPORTED_MODULE_11__Table__["h"]; });
/* harmony reexport (binding) */ __webpack_require__.d(__webpack_exports__, "defaultTableRowRenderer", function() { return __WEBPACK_IMPORTED_MODULE_11__Table__["i"]; });
/* harmony reexport (binding) */ __webpack_require__.d(__webpack_exports__, "Table", function() { return __WEBPACK_IMPORTED_MODULE_11__Table__["d"]; });
/* harmony reexport (binding) */ __webpack_require__.d(__webpack_exports__, "Column", function() { return __WEBPACK_IMPORTED_MODULE_11__Table__["a"]; });
/* harmony reexport (binding) */ __webpack_require__.d(__webpack_exports__, "SortDirection", function() { return __WEBPACK_IMPORTED_MODULE_11__Table__["b"]; });
/* harmony reexport (binding) */ __webpack_require__.d(__webpack_exports__, "SortIndicator", function() { return __WEBPACK_IMPORTED_MODULE_11__Table__["c"]; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_12__WindowScroller__ = __webpack_require__(238);
/* harmony reexport (binding) */ __webpack_require__.d(__webpack_exports__, "WindowScroller", function() { return __WEBPACK_IMPORTED_MODULE_12__WindowScroller__["a"]; });
/***/ }),
/* 86 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function(process) {/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_core_js_object_get_prototype_of__ = __webpack_require__(5);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_core_js_object_get_prototype_of___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_babel_runtime_core_js_object_get_prototype_of__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_classCallCheck__ = __webpack_require__(2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_classCallCheck___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_classCallCheck__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_createClass__ = __webpack_require__(4);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_createClass___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_createClass__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_babel_runtime_helpers_possibleConstructorReturn__ = __webpack_require__(6);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_babel_runtime_helpers_possibleConstructorReturn___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_3_babel_runtime_helpers_possibleConstructorReturn__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_babel_runtime_helpers_inherits__ = __webpack_require__(7);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_babel_runtime_helpers_inherits___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_4_babel_runtime_helpers_inherits__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5_prop_types__ = __webpack_require__(3);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5_prop_types___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_5_prop_types__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6_react__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_6_react__);
/**
 * This HOC decorates a virtualized component and responds to arrow-key events by scrolling one row or column at a time.
 */

var ArrowKeyStepper = function (_PureComponent) {
  __WEBPACK_IMPORTED_MODULE_4_babel_runtime_helpers_inherits___default()(ArrowKeyStepper, _PureComponent);

  function ArrowKeyStepper(props, context) {
    __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_classCallCheck___default()(this, ArrowKeyStepper);

    var _this = __WEBPACK_IMPORTED_MODULE_3_babel_runtime_helpers_possibleConstructorReturn___default()(this, (ArrowKeyStepper.__proto__ || __WEBPACK_IMPORTED_MODULE_0_babel_runtime_core_js_object_get_prototype_of___default()(ArrowKeyStepper)).call(this, props, context));

    _this.state = {
      scrollToColumn: props.scrollToColumn,
      scrollToRow: props.scrollToRow
    };

    _this._columnStartIndex = 0;
    _this._columnStopIndex = 0;
    _this._rowStartIndex = 0;
    _this._rowStopIndex = 0;

    _this._onKeyDown = _this._onKeyDown.bind(_this);
    _this._onSectionRendered = _this._onSectionRendered.bind(_this);
    return _this;
  }

  __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_createClass___default()(ArrowKeyStepper, [{
    key: 'componentWillReceiveProps',
    value: function componentWillReceiveProps(nextProps) {
      if (this.props.isControlled) {
        return;
      }

      var scrollToColumn = nextProps.scrollToColumn,
          scrollToRow = nextProps.scrollToRow;
      var _props = this.props,
          prevScrollToColumn = _props.scrollToColumn,
          prevScrollToRow = _props.scrollToRow;


      if (prevScrollToColumn !== scrollToColumn && prevScrollToRow !== scrollToRow) {
        this.setState({
          scrollToColumn: scrollToColumn,
          scrollToRow: scrollToRow
        });
      } else if (prevScrollToColumn !== scrollToColumn) {
        this.setState({ scrollToColumn: scrollToColumn });
      } else if (prevScrollToRow !== scrollToRow) {
        this.setState({ scrollToRow: scrollToRow });
      }
    }
  }, {
    key: 'setScrollIndexes',
    value: function setScrollIndexes(_ref) {
      var scrollToColumn = _ref.scrollToColumn,
          scrollToRow = _ref.scrollToRow;

      this.setState({
        scrollToRow: scrollToRow,
        scrollToColumn: scrollToColumn
      });
    }
  }, {
    key: 'render',
    value: function render() {
      var _props2 = this.props,
          className = _props2.className,
          children = _props2.children;

      var _getScrollState2 = this._getScrollState(),
          scrollToColumn = _getScrollState2.scrollToColumn,
          scrollToRow = _getScrollState2.scrollToRow;

      return __WEBPACK_IMPORTED_MODULE_6_react___default.a.createElement(
        'div',
        {
          className: className,
          onKeyDown: this._onKeyDown
        },
        children({
          onSectionRendered: this._onSectionRendered,
          scrollToColumn: scrollToColumn,
          scrollToRow: scrollToRow
        })
      );
    }
  }, {
    key: '_onKeyDown',
    value: function _onKeyDown(event) {
      var _props3 = this.props,
          columnCount = _props3.columnCount,
          disabled = _props3.disabled,
          mode = _props3.mode,
          rowCount = _props3.rowCount;


      if (disabled) {
        return;
      }

      var _getScrollState3 = this._getScrollState(),
          scrollToColumnPrevious = _getScrollState3.scrollToColumn,
          scrollToRowPrevious = _getScrollState3.scrollToRow;

      var _getScrollState4 = this._getScrollState(),
          scrollToColumn = _getScrollState4.scrollToColumn,
          scrollToRow = _getScrollState4.scrollToRow;

      // The above cases all prevent default event event behavior.
      // This is to keep the grid from scrolling after the snap-to update.


      switch (event.key) {
        case 'ArrowDown':
          scrollToRow = mode === 'cells' ? Math.min(scrollToRow + 1, rowCount - 1) : Math.min(this._rowStopIndex + 1, rowCount - 1);
          break;
        case 'ArrowLeft':
          scrollToColumn = mode === 'cells' ? Math.max(scrollToColumn - 1, 0) : Math.max(this._columnStartIndex - 1, 0);
          break;
        case 'ArrowRight':
          scrollToColumn = mode === 'cells' ? Math.min(scrollToColumn + 1, columnCount - 1) : Math.min(this._columnStopIndex + 1, columnCount - 1);
          break;
        case 'ArrowUp':
          scrollToRow = mode === 'cells' ? Math.max(scrollToRow - 1, 0) : Math.max(this._rowStartIndex - 1, 0);
          break;
      }

      if (scrollToColumn !== scrollToColumnPrevious || scrollToRow !== scrollToRowPrevious) {
        event.preventDefault();

        this._updateScrollState({ scrollToColumn: scrollToColumn, scrollToRow: scrollToRow });
      }
    }
  }, {
    key: '_onSectionRendered',
    value: function _onSectionRendered(_ref2) {
      var columnStartIndex = _ref2.columnStartIndex,
          columnStopIndex = _ref2.columnStopIndex,
          rowStartIndex = _ref2.rowStartIndex,
          rowStopIndex = _ref2.rowStopIndex;

      this._columnStartIndex = columnStartIndex;
      this._columnStopIndex = columnStopIndex;
      this._rowStartIndex = rowStartIndex;
      this._rowStopIndex = rowStopIndex;
    }
  }, {
    key: '_getScrollState',
    value: function _getScrollState() {
      return this.props.isControlled ? this.props : this.state;
    }
  }, {
    key: '_updateScrollState',
    value: function _updateScrollState(_ref3) {
      var scrollToColumn = _ref3.scrollToColumn,
          scrollToRow = _ref3.scrollToRow;
      var _props4 = this.props,
          isControlled = _props4.isControlled,
          onScrollToChange = _props4.onScrollToChange;


      if (typeof onScrollToChange === 'function') {
        onScrollToChange({ scrollToColumn: scrollToColumn, scrollToRow: scrollToRow });
      }

      if (!isControlled) {
        this.setState({ scrollToColumn: scrollToColumn, scrollToRow: scrollToRow });
      }
    }
  }]);

  return ArrowKeyStepper;
}(__WEBPACK_IMPORTED_MODULE_6_react__["PureComponent"]);

ArrowKeyStepper.defaultProps = {
  disabled: false,
  isControlled: false,
  mode: 'edges',
  scrollToColumn: 0,
  scrollToRow: 0
};
/* harmony default export */ __webpack_exports__["a"] = (ArrowKeyStepper);
process.env.NODE_ENV !== "production" ? ArrowKeyStepper.propTypes = {
  children: __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.func.isRequired,
  className: __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.string,
  columnCount: __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.number.isRequired,
  disabled: __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.bool.isRequired,
  isControlled: __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.bool.isRequired,
  mode: __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.oneOf(['cells', 'edges']),
  onScrollToChange: __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.func,
  rowCount: __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.number.isRequired,
  scrollToColumn: __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.number.isRequired,
  scrollToRow: __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.number.isRequired
} : void 0;
/* WEBPACK VAR INJECTION */}.call(__webpack_exports__, __webpack_require__(1)))

/***/ }),
/* 87 */
/***/ (function(module, exports, __webpack_require__) {

// 19.1.2.9 / 15.2.3.2 Object.getPrototypeOf(O)
var has = __webpack_require__(13);
var toObject = __webpack_require__(33);
var IE_PROTO = __webpack_require__(54)('IE_PROTO');
var ObjectProto = Object.prototype;

module.exports = Object.getPrototypeOf || function (O) {
  O = toObject(O);
  if (has(O, IE_PROTO)) return O[IE_PROTO];
  if (typeof O.constructor == 'function' && O instanceof O.constructor) {
    return O.constructor.prototype;
  } return O instanceof Object ? ObjectProto : null;
};


/***/ }),
/* 88 */
/***/ (function(module, exports, __webpack_require__) {

// optional / simple context binding
var aFunction = __webpack_require__(161);
module.exports = function (fn, that, length) {
  aFunction(fn);
  if (that === undefined) return fn;
  switch (length) {
    case 1: return function (a) {
      return fn.call(that, a);
    };
    case 2: return function (a, b) {
      return fn.call(that, a, b);
    };
    case 3: return function (a, b, c) {
      return fn.call(that, a, b, c);
    };
  }
  return function (/* ...args */) {
    return fn.apply(that, arguments);
  };
};


/***/ }),
/* 89 */
/***/ (function(module, exports, __webpack_require__) {

module.exports = !__webpack_require__(16) && !__webpack_require__(22)(function () {
  return Object.defineProperty(__webpack_require__(90)('div'), 'a', { get: function () { return 7; } }).a != 7;
});


/***/ }),
/* 90 */
/***/ (function(module, exports, __webpack_require__) {

var isObject = __webpack_require__(27);
var document = __webpack_require__(11).document;
// typeof document.createElement is 'object' in old IE
var is = isObject(document) && isObject(document.createElement);
module.exports = function (it) {
  return is ? document.createElement(it) : {};
};


/***/ }),
/* 91 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


exports.__esModule = true;

var _iterator = __webpack_require__(165);

var _iterator2 = _interopRequireDefault(_iterator);

var _symbol = __webpack_require__(177);

var _symbol2 = _interopRequireDefault(_symbol);

var _typeof = typeof _symbol2.default === "function" && typeof _iterator2.default === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof _symbol2.default === "function" && obj.constructor === _symbol2.default && obj !== _symbol2.default.prototype ? "symbol" : typeof obj; };

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports.default = typeof _symbol2.default === "function" && _typeof(_iterator2.default) === "symbol" ? function (obj) {
  return typeof obj === "undefined" ? "undefined" : _typeof(obj);
} : function (obj) {
  return obj && typeof _symbol2.default === "function" && obj.constructor === _symbol2.default && obj !== _symbol2.default.prototype ? "symbol" : typeof obj === "undefined" ? "undefined" : _typeof(obj);
};

/***/ }),
/* 92 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var LIBRARY = __webpack_require__(60);
var $export = __webpack_require__(14);
var redefine = __webpack_require__(93);
var hide = __webpack_require__(20);
var has = __webpack_require__(13);
var Iterators = __webpack_require__(28);
var $iterCreate = __webpack_require__(168);
var setToStringTag = __webpack_require__(64);
var getPrototypeOf = __webpack_require__(87);
var ITERATOR = __webpack_require__(10)('iterator');
var BUGGY = !([].keys && 'next' in [].keys()); // Safari has buggy iterators w/o `next`
var FF_ITERATOR = '@@iterator';
var KEYS = 'keys';
var VALUES = 'values';

var returnThis = function () { return this; };

module.exports = function (Base, NAME, Constructor, next, DEFAULT, IS_SET, FORCED) {
  $iterCreate(Constructor, NAME, next);
  var getMethod = function (kind) {
    if (!BUGGY && kind in proto) return proto[kind];
    switch (kind) {
      case KEYS: return function keys() { return new Constructor(this, kind); };
      case VALUES: return function values() { return new Constructor(this, kind); };
    } return function entries() { return new Constructor(this, kind); };
  };
  var TAG = NAME + ' Iterator';
  var DEF_VALUES = DEFAULT == VALUES;
  var VALUES_BUG = false;
  var proto = Base.prototype;
  var $native = proto[ITERATOR] || proto[FF_ITERATOR] || DEFAULT && proto[DEFAULT];
  var $default = $native || getMethod(DEFAULT);
  var $entries = DEFAULT ? !DEF_VALUES ? $default : getMethod('entries') : undefined;
  var $anyNative = NAME == 'Array' ? proto.entries || $native : $native;
  var methods, key, IteratorPrototype;
  // Fix native
  if ($anyNative) {
    IteratorPrototype = getPrototypeOf($anyNative.call(new Base()));
    if (IteratorPrototype !== Object.prototype && IteratorPrototype.next) {
      // Set @@toStringTag to native iterators
      setToStringTag(IteratorPrototype, TAG, true);
      // fix for some old engines
      if (!LIBRARY && !has(IteratorPrototype, ITERATOR)) hide(IteratorPrototype, ITERATOR, returnThis);
    }
  }
  // fix Array#{values, @@iterator}.name in V8 / FF
  if (DEF_VALUES && $native && $native.name !== VALUES) {
    VALUES_BUG = true;
    $default = function values() { return $native.call(this); };
  }
  // Define iterator
  if ((!LIBRARY || FORCED) && (BUGGY || VALUES_BUG || !proto[ITERATOR])) {
    hide(proto, ITERATOR, $default);
  }
  // Plug for library
  Iterators[NAME] = $default;
  Iterators[TAG] = returnThis;
  if (DEFAULT) {
    methods = {
      values: DEF_VALUES ? $default : getMethod(VALUES),
      keys: IS_SET ? $default : getMethod(KEYS),
      entries: $entries
    };
    if (FORCED) for (key in methods) {
      if (!(key in proto)) redefine(proto, key, methods[key]);
    } else $export($export.P + $export.F * (BUGGY || VALUES_BUG), NAME, methods);
  }
  return methods;
};


/***/ }),
/* 93 */
/***/ (function(module, exports, __webpack_require__) {

module.exports = __webpack_require__(20);


/***/ }),
/* 94 */
/***/ (function(module, exports, __webpack_require__) {

var has = __webpack_require__(13);
var toIObject = __webpack_require__(17);
var arrayIndexOf = __webpack_require__(170)(false);
var IE_PROTO = __webpack_require__(54)('IE_PROTO');

module.exports = function (object, names) {
  var O = toIObject(object);
  var i = 0;
  var result = [];
  var key;
  for (key in O) if (key != IE_PROTO) has(O, key) && result.push(key);
  // Don't enum bug & hidden keys
  while (names.length > i) if (has(O, key = names[i++])) {
    ~arrayIndexOf(result, key) || result.push(key);
  }
  return result;
};


/***/ }),
/* 95 */
/***/ (function(module, exports, __webpack_require__) {

// fallback for non-array-like ES3 and non-enumerable old V8 strings
var cof = __webpack_require__(62);
// eslint-disable-next-line no-prototype-builtins
module.exports = Object('z').propertyIsEnumerable(0) ? Object : function (it) {
  return cof(it) == 'String' ? it.split('') : Object(it);
};


/***/ }),
/* 96 */
/***/ (function(module, exports, __webpack_require__) {

// 19.1.2.7 / 15.2.3.4 Object.getOwnPropertyNames(O)
var $keys = __webpack_require__(94);
var hiddenKeys = __webpack_require__(63).concat('length', 'prototype');

exports.f = Object.getOwnPropertyNames || function getOwnPropertyNames(O) {
  return $keys(O, hiddenKeys);
};


/***/ }),
/* 97 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function(process) {/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_core_js_object_get_prototype_of__ = __webpack_require__(5);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_core_js_object_get_prototype_of___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_babel_runtime_core_js_object_get_prototype_of__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_classCallCheck__ = __webpack_require__(2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_classCallCheck___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_classCallCheck__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_createClass__ = __webpack_require__(4);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_createClass___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_createClass__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_babel_runtime_helpers_possibleConstructorReturn__ = __webpack_require__(6);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_babel_runtime_helpers_possibleConstructorReturn___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_3_babel_runtime_helpers_possibleConstructorReturn__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_babel_runtime_helpers_inherits__ = __webpack_require__(7);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_babel_runtime_helpers_inherits___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_4_babel_runtime_helpers_inherits__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5_prop_types__ = __webpack_require__(3);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5_prop_types___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_5_prop_types__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6_react__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_6_react__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7__vendor_detectElementResize__ = __webpack_require__(195);
/**
 * Decorator component that automatically adjusts the width and height of a single child.
 * Child component should not be declared as a child but should rather be specified by a `ChildComponent` property.
 * All other properties will be passed through to the child component.
 */

var AutoSizer = function (_PureComponent) {
  __WEBPACK_IMPORTED_MODULE_4_babel_runtime_helpers_inherits___default()(AutoSizer, _PureComponent);

  function AutoSizer(props) {
    __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_classCallCheck___default()(this, AutoSizer);

    var _this = __WEBPACK_IMPORTED_MODULE_3_babel_runtime_helpers_possibleConstructorReturn___default()(this, (AutoSizer.__proto__ || __WEBPACK_IMPORTED_MODULE_0_babel_runtime_core_js_object_get_prototype_of___default()(AutoSizer)).call(this, props));

    _this.state = {
      height: 0,
      width: 0
    };

    _this._onResize = _this._onResize.bind(_this);
    _this._setRef = _this._setRef.bind(_this);
    return _this;
  }

  __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_createClass___default()(AutoSizer, [{
    key: 'componentDidMount',
    value: function componentDidMount() {
      var nonce = this.props.nonce;

      // Delay access of parentNode until mount.
      // This handles edge-cases where the component has already been unmounted before its ref has been set,
      // As well as libraries like react-lite which have a slightly different lifecycle.

      this._parentNode = this._autoSizer.parentNode;

      // Defer requiring resize handler in order to support server-side rendering.
      // See issue #41
      this._detectElementResize = Object(__WEBPACK_IMPORTED_MODULE_7__vendor_detectElementResize__["a" /* default */])(nonce);
      this._detectElementResize.addResizeListener(this._parentNode, this._onResize);

      this._onResize();
    }
  }, {
    key: 'componentWillUnmount',
    value: function componentWillUnmount() {
      if (this._detectElementResize) {
        this._detectElementResize.removeResizeListener(this._parentNode, this._onResize);
      }
    }
  }, {
    key: 'render',
    value: function render() {
      var _props = this.props,
          children = _props.children,
          disableHeight = _props.disableHeight,
          disableWidth = _props.disableWidth;
      var _state = this.state,
          height = _state.height,
          width = _state.width;

      // Outer div should not force width/height since that may prevent containers from shrinking.
      // Inner component should overflow and use calculated width/height.
      // See issue #68 for more information.

      var outerStyle = { overflow: 'visible' };

      if (!disableHeight) {
        outerStyle.height = 0;
      }

      if (!disableWidth) {
        outerStyle.width = 0;
      }

      /**
       * TODO: Avoid rendering children before the initial measurements have been collected.
       * At best this would just be wasting cycles.
       * Add this check into version 10 though as it could break too many ref callbacks in version 9.
      if (
        height !== 0 &&
        width !== 0
      ) {
        child = children({ height, width })
      }
      */

      return __WEBPACK_IMPORTED_MODULE_6_react___default.a.createElement(
        'div',
        {
          ref: this._setRef,
          style: outerStyle
        },
        children({ height: height, width: width })
      );
    }
  }, {
    key: '_onResize',
    value: function _onResize() {
      var _props2 = this.props,
          disableHeight = _props2.disableHeight,
          disableWidth = _props2.disableWidth,
          onResize = _props2.onResize;

      // Guard against AutoSizer component being removed from the DOM immediately after being added.
      // This can result in invalid style values which can result in NaN values if we don't handle them.
      // See issue #150 for more context.

      var height = this._parentNode.offsetHeight || 0;
      var width = this._parentNode.offsetWidth || 0;

      var style = window.getComputedStyle(this._parentNode) || {};
      var paddingLeft = parseInt(style.paddingLeft, 10) || 0;
      var paddingRight = parseInt(style.paddingRight, 10) || 0;
      var paddingTop = parseInt(style.paddingTop, 10) || 0;
      var paddingBottom = parseInt(style.paddingBottom, 10) || 0;

      var newHeight = height - paddingTop - paddingBottom;
      var newWidth = width - paddingLeft - paddingRight;

      if (!disableHeight && this.state.height !== newHeight || !disableWidth && this.state.width !== newWidth) {
        this.setState({
          height: height - paddingTop - paddingBottom,
          width: width - paddingLeft - paddingRight
        });

        onResize({ height: height, width: width });
      }
    }
  }, {
    key: '_setRef',
    value: function _setRef(autoSizer) {
      this._autoSizer = autoSizer;
    }
  }]);

  return AutoSizer;
}(__WEBPACK_IMPORTED_MODULE_6_react__["PureComponent"]);

AutoSizer.defaultProps = {
  onResize: function onResize() {}
};
/* harmony default export */ __webpack_exports__["a"] = (AutoSizer);
process.env.NODE_ENV !== "production" ? AutoSizer.propTypes = {
  /**
  * Function responsible for rendering children.
  * This function should implement the following signature:
  * ({ height, width }) => PropTypes.element
  */
  children: __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.func.isRequired,

  /** Disable dynamic :height property */
  disableHeight: __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.bool,

  /** Disable dynamic :width property */
  disableWidth: __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.bool,

  /** Nonce of the inlined stylesheet for Content Security Policy */
  nonce: __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.string,

  /** Callback to be invoked on-resize: ({ height, width }) */
  onResize: __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.func.isRequired
} : void 0;
/* WEBPACK VAR INJECTION */}.call(__webpack_exports__, __webpack_require__(1)))

/***/ }),
/* 98 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__CellMeasurer__ = __webpack_require__(99);
/* unused harmony reexport default */
/* harmony reexport (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return __WEBPACK_IMPORTED_MODULE_0__CellMeasurer__["a"]; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__CellMeasurerCache__ = __webpack_require__(196);
/* harmony reexport (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return __WEBPACK_IMPORTED_MODULE_1__CellMeasurerCache__["a"]; });







/***/ }),
/* 99 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function(process) {/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_core_js_object_get_prototype_of__ = __webpack_require__(5);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_core_js_object_get_prototype_of___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_babel_runtime_core_js_object_get_prototype_of__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_classCallCheck__ = __webpack_require__(2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_classCallCheck___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_classCallCheck__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_createClass__ = __webpack_require__(4);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_createClass___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_createClass__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_babel_runtime_helpers_possibleConstructorReturn__ = __webpack_require__(6);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_babel_runtime_helpers_possibleConstructorReturn___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_3_babel_runtime_helpers_possibleConstructorReturn__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_babel_runtime_helpers_inherits__ = __webpack_require__(7);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_babel_runtime_helpers_inherits___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_4_babel_runtime_helpers_inherits__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5_react__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_5_react__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6_react_dom__ = __webpack_require__(23);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6_react_dom___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_6_react_dom__);
/**
 * Wraps a cell and measures its rendered content.
 * Measurements are stored in a per-cell cache.
 * Cached-content is not be re-measured.
 */
var CellMeasurer = function (_PureComponent) {
  __WEBPACK_IMPORTED_MODULE_4_babel_runtime_helpers_inherits___default()(CellMeasurer, _PureComponent);

  function CellMeasurer(props, context) {
    __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_classCallCheck___default()(this, CellMeasurer);

    var _this = __WEBPACK_IMPORTED_MODULE_3_babel_runtime_helpers_possibleConstructorReturn___default()(this, (CellMeasurer.__proto__ || __WEBPACK_IMPORTED_MODULE_0_babel_runtime_core_js_object_get_prototype_of___default()(CellMeasurer)).call(this, props, context));

    _this._measure = _this._measure.bind(_this);
    return _this;
  }

  __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_createClass___default()(CellMeasurer, [{
    key: 'componentDidMount',
    value: function componentDidMount() {
      this._maybeMeasureCell();
    }
  }, {
    key: 'componentDidUpdate',
    value: function componentDidUpdate(prevProps, prevState) {
      this._maybeMeasureCell();
    }
  }, {
    key: 'render',
    value: function render() {
      var children = this.props.children;


      return typeof children === 'function' ? children({ measure: this._measure }) : children;
    }
  }, {
    key: '_getCellMeasurements',
    value: function _getCellMeasurements() {
      var cache = this.props.cache;


      var node = Object(__WEBPACK_IMPORTED_MODULE_6_react_dom__["findDOMNode"])(this);

      // TODO Check for a bad combination of fixedWidth and missing numeric width or vice versa with height

      var styleWidth = node.style.width;
      var styleHeight = node.style.height;

      // If we are re-measuring a cell that has already been measured,
      // It will have a hard-coded width/height from the previous measurement.
      // The fact that we are measuring indicates this measurement is probably stale,
      // So explicitly clear it out (eg set to "auto") so we can recalculate.
      // See issue #593 for more info.
      // Even if we are measuring initially- if we're inside of a MultiGrid component,
      // Explicitly clear width/height before measuring to avoid being tainted by another Grid.
      // eg top/left Grid renders before bottom/right Grid
      // Since the CellMeasurerCache is shared between them this taints derived cell size values.
      if (!cache.hasFixedWidth()) {
        node.style.width = 'auto';
      }
      if (!cache.hasFixedHeight()) {
        node.style.height = 'auto';
      }

      var height = Math.ceil(node.offsetHeight);
      var width = Math.ceil(node.offsetWidth);

      // Reset after measuring to avoid breaking styles; see #660
      if (styleWidth) {
        node.style.width = styleWidth;
      }
      if (styleHeight) {
        node.style.height = styleHeight;
      }

      return { height: height, styleHeight: styleHeight, styleWidth: styleWidth, width: width };
    }
  }, {
    key: '_maybeMeasureCell',
    value: function _maybeMeasureCell() {
      var _props = this.props,
          cache = _props.cache,
          _props$columnIndex = _props.columnIndex,
          columnIndex = _props$columnIndex === undefined ? 0 : _props$columnIndex,
          parent = _props.parent,
          _props$rowIndex = _props.rowIndex,
          rowIndex = _props$rowIndex === undefined ? this.props.index : _props$rowIndex;


      if (!cache.has(rowIndex, columnIndex)) {
        var _getCellMeasurements2 = this._getCellMeasurements(),
            height = _getCellMeasurements2.height,
            width = _getCellMeasurements2.width;

        cache.set(rowIndex, columnIndex, width, height);

        // If size has changed, let Grid know to re-render.
        if (parent && typeof parent.invalidateCellSizeAfterRender === 'function') {
          parent.invalidateCellSizeAfterRender({
            columnIndex: columnIndex,
            rowIndex: rowIndex
          });
        }
      }
    }
  }, {
    key: '_measure',
    value: function _measure() {
      var _props2 = this.props,
          cache = _props2.cache,
          _props2$columnIndex = _props2.columnIndex,
          columnIndex = _props2$columnIndex === undefined ? 0 : _props2$columnIndex,
          parent = _props2.parent,
          _props2$rowIndex = _props2.rowIndex,
          rowIndex = _props2$rowIndex === undefined ? this.props.index : _props2$rowIndex;

      var _getCellMeasurements3 = this._getCellMeasurements(),
          height = _getCellMeasurements3.height,
          width = _getCellMeasurements3.width;

      if (height !== cache.getHeight(rowIndex, columnIndex) || width !== cache.getWidth(rowIndex, columnIndex)) {
        cache.set(rowIndex, columnIndex, width, height);

        if (parent && typeof parent.recomputeGridSize === 'function') {
          parent.recomputeGridSize({
            columnIndex: columnIndex,
            rowIndex: rowIndex
          });
        }
      }
    }
  }]);

  return CellMeasurer;
}(__WEBPACK_IMPORTED_MODULE_5_react__["PureComponent"]);

// Used for DEV mode warning check


/* harmony default export */ __webpack_exports__["a"] = (CellMeasurer);
if (process.env.NODE_ENV !== 'production') {
  CellMeasurer.__internalCellMeasurerFlag = true;
}
/* WEBPACK VAR INJECTION */}.call(__webpack_exports__, __webpack_require__(1)))

/***/ }),
/* 100 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function(process) {/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_extends__ = __webpack_require__(12);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_extends___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_extends__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_objectWithoutProperties__ = __webpack_require__(37);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_objectWithoutProperties___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_objectWithoutProperties__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_babel_runtime_core_js_object_get_prototype_of__ = __webpack_require__(5);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_babel_runtime_core_js_object_get_prototype_of___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2_babel_runtime_core_js_object_get_prototype_of__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_babel_runtime_helpers_classCallCheck__ = __webpack_require__(2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_babel_runtime_helpers_classCallCheck___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_3_babel_runtime_helpers_classCallCheck__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_babel_runtime_helpers_createClass__ = __webpack_require__(4);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_babel_runtime_helpers_createClass___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_4_babel_runtime_helpers_createClass__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5_babel_runtime_helpers_possibleConstructorReturn__ = __webpack_require__(6);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5_babel_runtime_helpers_possibleConstructorReturn___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_5_babel_runtime_helpers_possibleConstructorReturn__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6_babel_runtime_helpers_inherits__ = __webpack_require__(7);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6_babel_runtime_helpers_inherits___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_6_babel_runtime_helpers_inherits__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7_prop_types__ = __webpack_require__(3);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7_prop_types___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_7_prop_types__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_8_react__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_8_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_8_react__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_9__CollectionView__ = __webpack_require__(202);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_10__utils_calculateSizeAndPositionData__ = __webpack_require__(206);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_11__utils_getUpdatedOffsetForIndex__ = __webpack_require__(209);
/**
 * Renders scattered or non-linear data.
 * Unlike Grid, which renders checkerboard data, Collection can render arbitrarily positioned- even overlapping- data.
 */
var Collection = function (_PureComponent) {
  __WEBPACK_IMPORTED_MODULE_6_babel_runtime_helpers_inherits___default()(Collection, _PureComponent);

  function Collection(props, context) {
    __WEBPACK_IMPORTED_MODULE_3_babel_runtime_helpers_classCallCheck___default()(this, Collection);

    var _this = __WEBPACK_IMPORTED_MODULE_5_babel_runtime_helpers_possibleConstructorReturn___default()(this, (Collection.__proto__ || __WEBPACK_IMPORTED_MODULE_2_babel_runtime_core_js_object_get_prototype_of___default()(Collection)).call(this, props, context));

    _this._cellMetadata = [];
    _this._lastRenderedCellIndices = [];

    // Cell cache during scroll (for perforamnce)
    _this._cellCache = [];

    _this._isScrollingChange = _this._isScrollingChange.bind(_this);
    _this._setCollectionViewRef = _this._setCollectionViewRef.bind(_this);
    return _this;
  }

  __WEBPACK_IMPORTED_MODULE_4_babel_runtime_helpers_createClass___default()(Collection, [{
    key: 'forceUpdate',
    value: function forceUpdate() {
      if (this._collectionView !== undefined) {
        this._collectionView.forceUpdate();
      }
    }

    /** See Collection#recomputeCellSizesAndPositions */

  }, {
    key: 'recomputeCellSizesAndPositions',
    value: function recomputeCellSizesAndPositions() {
      this._cellCache = [];
      this._collectionView.recomputeCellSizesAndPositions();
    }

    /** React lifecycle methods */

  }, {
    key: 'render',
    value: function render() {
      var props = __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_objectWithoutProperties___default()(this.props, []);

      return __WEBPACK_IMPORTED_MODULE_8_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_9__CollectionView__["a" /* default */], __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_extends___default()({
        cellLayoutManager: this,
        isScrollingChange: this._isScrollingChange,
        ref: this._setCollectionViewRef
      }, props));
    }

    /** CellLayoutManager interface */

  }, {
    key: 'calculateSizeAndPositionData',
    value: function calculateSizeAndPositionData() {
      var _props = this.props,
          cellCount = _props.cellCount,
          cellSizeAndPositionGetter = _props.cellSizeAndPositionGetter,
          sectionSize = _props.sectionSize;


      var data = Object(__WEBPACK_IMPORTED_MODULE_10__utils_calculateSizeAndPositionData__["a" /* default */])({
        cellCount: cellCount,
        cellSizeAndPositionGetter: cellSizeAndPositionGetter,
        sectionSize: sectionSize
      });

      this._cellMetadata = data.cellMetadata;
      this._sectionManager = data.sectionManager;
      this._height = data.height;
      this._width = data.width;
    }

    /**
     * Returns the most recently rendered set of cell indices.
     */

  }, {
    key: 'getLastRenderedIndices',
    value: function getLastRenderedIndices() {
      return this._lastRenderedCellIndices;
    }

    /**
     * Calculates the minimum amount of change from the current scroll position to ensure the specified cell is (fully) visible.
     */

  }, {
    key: 'getScrollPositionForCell',
    value: function getScrollPositionForCell(_ref) {
      var align = _ref.align,
          cellIndex = _ref.cellIndex,
          height = _ref.height,
          scrollLeft = _ref.scrollLeft,
          scrollTop = _ref.scrollTop,
          width = _ref.width;
      var cellCount = this.props.cellCount;


      if (cellIndex >= 0 && cellIndex < cellCount) {
        var cellMetadata = this._cellMetadata[cellIndex];

        scrollLeft = Object(__WEBPACK_IMPORTED_MODULE_11__utils_getUpdatedOffsetForIndex__["a" /* default */])({
          align: align,
          cellOffset: cellMetadata.x,
          cellSize: cellMetadata.width,
          containerSize: width,
          currentOffset: scrollLeft,
          targetIndex: cellIndex
        });

        scrollTop = Object(__WEBPACK_IMPORTED_MODULE_11__utils_getUpdatedOffsetForIndex__["a" /* default */])({
          align: align,
          cellOffset: cellMetadata.y,
          cellSize: cellMetadata.height,
          containerSize: height,
          currentOffset: scrollTop,
          targetIndex: cellIndex
        });
      }

      return {
        scrollLeft: scrollLeft,
        scrollTop: scrollTop
      };
    }
  }, {
    key: 'getTotalSize',
    value: function getTotalSize() {
      return {
        height: this._height,
        width: this._width
      };
    }
  }, {
    key: 'cellRenderers',
    value: function cellRenderers(_ref2) {
      var _this2 = this;

      var height = _ref2.height,
          isScrolling = _ref2.isScrolling,
          width = _ref2.width,
          x = _ref2.x,
          y = _ref2.y;
      var _props2 = this.props,
          cellGroupRenderer = _props2.cellGroupRenderer,
          cellRenderer = _props2.cellRenderer;

      // Store for later calls to getLastRenderedIndices()

      this._lastRenderedCellIndices = this._sectionManager.getCellIndices({
        height: height,
        width: width,
        x: x,
        y: y
      });

      return cellGroupRenderer({
        cellCache: this._cellCache,
        cellRenderer: cellRenderer,
        cellSizeAndPositionGetter: function cellSizeAndPositionGetter(_ref3) {
          var index = _ref3.index;
          return _this2._sectionManager.getCellMetadata({ index: index });
        },
        indices: this._lastRenderedCellIndices,
        isScrolling: isScrolling
      });
    }
  }, {
    key: '_isScrollingChange',
    value: function _isScrollingChange(isScrolling) {
      if (!isScrolling) {
        this._cellCache = [];
      }
    }
  }, {
    key: '_setCollectionViewRef',
    value: function _setCollectionViewRef(ref) {
      this._collectionView = ref;
    }
  }]);

  return Collection;
}(__WEBPACK_IMPORTED_MODULE_8_react__["PureComponent"]);

Collection.defaultProps = {
  'aria-label': 'grid',
  cellGroupRenderer: defaultCellGroupRenderer
};
/* harmony default export */ __webpack_exports__["a"] = (Collection);
process.env.NODE_ENV !== "production" ? Collection.propTypes = {
  'aria-label': __WEBPACK_IMPORTED_MODULE_7_prop_types___default.a.string,

  /**
   * Number of cells in Collection.
   */
  cellCount: __WEBPACK_IMPORTED_MODULE_7_prop_types___default.a.number.isRequired,

  /**
   * Responsible for rendering a group of cells given their indices.
   * Should implement the following interface: ({
   *   cellSizeAndPositionGetter:Function,
   *   indices: Array<number>,
   *   cellRenderer: Function
   * }): Array<PropTypes.node>
   */
  cellGroupRenderer: __WEBPACK_IMPORTED_MODULE_7_prop_types___default.a.func.isRequired,

  /**
   * Responsible for rendering a cell given an row and column index.
   * Should implement the following interface: ({ index: number, key: string, style: object }): PropTypes.element
   */
  cellRenderer: __WEBPACK_IMPORTED_MODULE_7_prop_types___default.a.func.isRequired,

  /**
   * Callback responsible for returning size and offset/position information for a given cell (index).
   * ({ index: number }): { height: number, width: number, x: number, y: number }
   */
  cellSizeAndPositionGetter: __WEBPACK_IMPORTED_MODULE_7_prop_types___default.a.func.isRequired,

  /**
   * Optionally override the size of the sections a Collection's cells are split into.
   */
  sectionSize: __WEBPACK_IMPORTED_MODULE_7_prop_types___default.a.number
} : void 0;


function defaultCellGroupRenderer(_ref4) {
  var cellCache = _ref4.cellCache,
      cellRenderer = _ref4.cellRenderer,
      cellSizeAndPositionGetter = _ref4.cellSizeAndPositionGetter,
      indices = _ref4.indices,
      isScrolling = _ref4.isScrolling;

  return indices.map(function (index) {
    var cellMetadata = cellSizeAndPositionGetter({ index: index });

    var cellRendererProps = {
      index: index,
      isScrolling: isScrolling,
      key: index,
      style: {
        height: cellMetadata.height,
        left: cellMetadata.x,
        position: 'absolute',
        top: cellMetadata.y,
        width: cellMetadata.width
      }
    };

    // Avoid re-creating cells while scrolling.
    // This can lead to the same cell being created many times and can cause performance issues for "heavy" cells.
    // If a scroll is in progress- cache and reuse cells.
    // This cache will be thrown away once scrolling complets.
    if (isScrolling) {
      if (!(index in cellCache)) {
        cellCache[index] = cellRenderer(cellRendererProps);
      }

      return cellCache[index];
    } else {
      return cellRenderer(cellRendererProps);
    }
  }).filter(function (renderedCell) {
    return !!renderedCell;
  });
}
/* WEBPACK VAR INJECTION */}.call(__webpack_exports__, __webpack_require__(1)))

/***/ }),
/* 101 */
/***/ (function(module, exports, __webpack_require__) {

module.exports = { "default": __webpack_require__(203), __esModule: true };

/***/ }),
/* 102 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

exports.default = function (recalc) {
  if (!size || recalc) {
    if (_inDOM2.default) {
      var scrollDiv = document.createElement('div');

      scrollDiv.style.position = 'absolute';
      scrollDiv.style.top = '-9999px';
      scrollDiv.style.width = '50px';
      scrollDiv.style.height = '50px';
      scrollDiv.style.overflow = 'scroll';

      document.body.appendChild(scrollDiv);
      size = scrollDiv.offsetWidth - scrollDiv.clientWidth;
      document.body.removeChild(scrollDiv);
    }
  }

  return size;
};

var _inDOM = __webpack_require__(205);

var _inDOM2 = _interopRequireDefault(_inDOM);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var size = void 0;

module.exports = exports['default'];

/***/ }),
/* 103 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function(process) {/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_core_js_object_get_prototype_of__ = __webpack_require__(5);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_core_js_object_get_prototype_of___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_babel_runtime_core_js_object_get_prototype_of__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_classCallCheck__ = __webpack_require__(2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_classCallCheck___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_classCallCheck__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_createClass__ = __webpack_require__(4);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_createClass___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_createClass__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_babel_runtime_helpers_possibleConstructorReturn__ = __webpack_require__(6);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_babel_runtime_helpers_possibleConstructorReturn___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_3_babel_runtime_helpers_possibleConstructorReturn__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_babel_runtime_helpers_inherits__ = __webpack_require__(7);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_babel_runtime_helpers_inherits___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_4_babel_runtime_helpers_inherits__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5_prop_types__ = __webpack_require__(3);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5_prop_types___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_5_prop_types__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6_react__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_6_react__);
/**
 * High-order component that auto-calculates column-widths for `Grid` cells.
 */

var ColumnSizer = function (_PureComponent) {
  __WEBPACK_IMPORTED_MODULE_4_babel_runtime_helpers_inherits___default()(ColumnSizer, _PureComponent);

  function ColumnSizer(props, context) {
    __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_classCallCheck___default()(this, ColumnSizer);

    var _this = __WEBPACK_IMPORTED_MODULE_3_babel_runtime_helpers_possibleConstructorReturn___default()(this, (ColumnSizer.__proto__ || __WEBPACK_IMPORTED_MODULE_0_babel_runtime_core_js_object_get_prototype_of___default()(ColumnSizer)).call(this, props, context));

    _this._registerChild = _this._registerChild.bind(_this);
    return _this;
  }

  __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_createClass___default()(ColumnSizer, [{
    key: 'componentDidUpdate',
    value: function componentDidUpdate(prevProps, prevState) {
      var _props = this.props,
          columnMaxWidth = _props.columnMaxWidth,
          columnMinWidth = _props.columnMinWidth,
          columnCount = _props.columnCount,
          width = _props.width;


      if (columnMaxWidth !== prevProps.columnMaxWidth || columnMinWidth !== prevProps.columnMinWidth || columnCount !== prevProps.columnCount || width !== prevProps.width) {
        if (this._registeredChild) {
          this._registeredChild.recomputeGridSize();
        }
      }
    }
  }, {
    key: 'render',
    value: function render() {
      var _props2 = this.props,
          children = _props2.children,
          columnMaxWidth = _props2.columnMaxWidth,
          columnMinWidth = _props2.columnMinWidth,
          columnCount = _props2.columnCount,
          width = _props2.width;


      var safeColumnMinWidth = columnMinWidth || 1;

      var safeColumnMaxWidth = columnMaxWidth ? Math.min(columnMaxWidth, width) : width;

      var columnWidth = width / columnCount;
      columnWidth = Math.max(safeColumnMinWidth, columnWidth);
      columnWidth = Math.min(safeColumnMaxWidth, columnWidth);
      columnWidth = Math.floor(columnWidth);

      var adjustedWidth = Math.min(width, columnWidth * columnCount);

      return children({
        adjustedWidth: adjustedWidth,
        columnWidth: columnWidth,
        getColumnWidth: function getColumnWidth() {
          return columnWidth;
        },
        registerChild: this._registerChild
      });
    }
  }, {
    key: '_registerChild',
    value: function _registerChild(child) {
      if (child && typeof child.recomputeGridSize !== 'function') {
        throw Error('Unexpected child type registered; only Grid/MultiGrid children are supported.');
      }

      this._registeredChild = child;

      if (this._registeredChild) {
        this._registeredChild.recomputeGridSize();
      }
    }
  }]);

  return ColumnSizer;
}(__WEBPACK_IMPORTED_MODULE_6_react__["PureComponent"]);

/* harmony default export */ __webpack_exports__["a"] = (ColumnSizer);
process.env.NODE_ENV !== "production" ? ColumnSizer.propTypes = {
  /**
   * Function responsible for rendering a virtualized Grid.
   * This function should implement the following signature:
   * ({ adjustedWidth, getColumnWidth, registerChild }) => PropTypes.element
   *
   * The specified :getColumnWidth function should be passed to the Grid's :columnWidth property.
   * The :registerChild should be passed to the Grid's :ref property.
   * The :adjustedWidth property is optional; it reflects the lesser of the overall width or the width of all columns.
   */
  children: __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.func.isRequired,

  /** Optional maximum allowed column width */
  columnMaxWidth: __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.number,

  /** Optional minimum allowed column width */
  columnMinWidth: __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.number,

  /** Number of columns in Grid or Table child */
  columnCount: __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.number.isRequired,

  /** Width of Grid or Table child */
  width: __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.number.isRequired
} : void 0;
/* WEBPACK VAR INJECTION */}.call(__webpack_exports__, __webpack_require__(1)))

/***/ }),
/* 104 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function(process) {/* unused harmony export DEFAULT_SCROLLING_RESET_TIME_INTERVAL */
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_extends__ = __webpack_require__(12);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_extends___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_extends__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_babel_runtime_core_js_object_get_prototype_of__ = __webpack_require__(5);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_babel_runtime_core_js_object_get_prototype_of___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_babel_runtime_core_js_object_get_prototype_of__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_classCallCheck__ = __webpack_require__(2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_classCallCheck___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_classCallCheck__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_babel_runtime_helpers_createClass__ = __webpack_require__(4);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_babel_runtime_helpers_createClass___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_3_babel_runtime_helpers_createClass__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_babel_runtime_helpers_possibleConstructorReturn__ = __webpack_require__(6);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_babel_runtime_helpers_possibleConstructorReturn___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_4_babel_runtime_helpers_possibleConstructorReturn__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5_babel_runtime_helpers_inherits__ = __webpack_require__(7);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5_babel_runtime_helpers_inherits___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_5_babel_runtime_helpers_inherits__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6_react__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_6_react__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7_prop_types__ = __webpack_require__(3);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7_prop_types___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_7_prop_types__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_8_classnames__ = __webpack_require__(24);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_8_classnames___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_8_classnames__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_9__utils_calculateSizeAndPositionDataAndUpdateScrollOffset__ = __webpack_require__(211);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_10__utils_ScalingCellSizeAndPositionManager__ = __webpack_require__(212);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_11__utils_createCallbackMemoizer__ = __webpack_require__(70);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_12__defaultOverscanIndicesGetter__ = __webpack_require__(105);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_13__utils_updateScrollIndexHelper__ = __webpack_require__(214);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_14__defaultCellRangeRenderer__ = __webpack_require__(106);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_15_dom_helpers_util_scrollbarSize__ = __webpack_require__(102);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_15_dom_helpers_util_scrollbarSize___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_15_dom_helpers_util_scrollbarSize__);
/**
 * Specifies the number of milliseconds during which to disable pointer events while a scroll is in progress.
 * This improves performance and makes scrolling smoother.
 */
var DEFAULT_SCROLLING_RESET_TIME_INTERVAL = 150;

/**
 * Controls whether the Grid updates the DOM element's scrollLeft/scrollTop based on the current state or just observes it.
 * This prevents Grid from interrupting mouse-wheel animations (see issue #2).
 */
var SCROLL_POSITION_CHANGE_REASONS = {
  OBSERVED: 'observed',
  REQUESTED: 'requested'
};

/**
 * Renders tabular data with virtualization along the vertical and horizontal axes.
 * Row heights and column widths must be known ahead of time and specified as properties.
 */

var Grid = function (_PureComponent) {
  __WEBPACK_IMPORTED_MODULE_5_babel_runtime_helpers_inherits___default()(Grid, _PureComponent);

  function Grid(props, context) {
    __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_classCallCheck___default()(this, Grid);

    var _this = __WEBPACK_IMPORTED_MODULE_4_babel_runtime_helpers_possibleConstructorReturn___default()(this, (Grid.__proto__ || __WEBPACK_IMPORTED_MODULE_1_babel_runtime_core_js_object_get_prototype_of___default()(Grid)).call(this, props, context));

    _this.state = {
      isScrolling: false,
      scrollDirectionHorizontal: __WEBPACK_IMPORTED_MODULE_12__defaultOverscanIndicesGetter__["b" /* SCROLL_DIRECTION_FORWARD */],
      scrollDirectionVertical: __WEBPACK_IMPORTED_MODULE_12__defaultOverscanIndicesGetter__["b" /* SCROLL_DIRECTION_FORWARD */],
      scrollLeft: 0,
      scrollTop: 0
    };

    // Invokes onSectionRendered callback only when start/stop row or column indices change
    _this._onGridRenderedMemoizer = Object(__WEBPACK_IMPORTED_MODULE_11__utils_createCallbackMemoizer__["a" /* default */])();
    _this._onScrollMemoizer = Object(__WEBPACK_IMPORTED_MODULE_11__utils_createCallbackMemoizer__["a" /* default */])(false);

    // Bind functions to instance so they don't lose context when passed around
    _this._debounceScrollEndedCallback = _this._debounceScrollEndedCallback.bind(_this);
    _this._invokeOnGridRenderedHelper = _this._invokeOnGridRenderedHelper.bind(_this);
    _this._onScroll = _this._onScroll.bind(_this);
    _this._setScrollingContainerRef = _this._setScrollingContainerRef.bind(_this);

    _this._columnWidthGetter = _this._wrapSizeGetter(props.columnWidth);
    _this._rowHeightGetter = _this._wrapSizeGetter(props.rowHeight);

    _this._deferredInvalidateColumnIndex = null;
    _this._deferredInvalidateRowIndex = null;
    _this._recomputeScrollLeftFlag = false;
    _this._recomputeScrollTopFlag = false;

    _this._horizontalScrollBarSize = 0;
    _this._verticalScrollBarSize = 0;
    _this._scrollbarPresenceChanged = false;

    var deferredMeasurementCache = props.deferredMeasurementCache;
    var deferredMode = typeof deferredMeasurementCache !== 'undefined';

    _this._columnSizeAndPositionManager = new __WEBPACK_IMPORTED_MODULE_10__utils_ScalingCellSizeAndPositionManager__["a" /* default */]({
      batchAllCells: deferredMode && !deferredMeasurementCache.hasFixedHeight(),
      cellCount: props.columnCount,
      cellSizeGetter: function cellSizeGetter(params) {
        return _this._columnWidthGetter(params);
      },
      estimatedCellSize: _this._getEstimatedColumnSize(props)
    });
    _this._rowSizeAndPositionManager = new __WEBPACK_IMPORTED_MODULE_10__utils_ScalingCellSizeAndPositionManager__["a" /* default */]({
      batchAllCells: deferredMode && !deferredMeasurementCache.hasFixedWidth(),
      cellCount: props.rowCount,
      cellSizeGetter: function cellSizeGetter(params) {
        return _this._rowHeightGetter(params);
      },
      estimatedCellSize: _this._getEstimatedRowSize(props)
    });

    // See defaultCellRangeRenderer() for more information on the usage of these caches
    _this._cellCache = {};
    _this._styleCache = {};
    return _this;
  }

  /**
   * Gets offsets for a given cell and alignment.
   */


  __WEBPACK_IMPORTED_MODULE_3_babel_runtime_helpers_createClass___default()(Grid, [{
    key: 'getOffsetForCell',
    value: function getOffsetForCell() {
      var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
          _ref$alignment = _ref.alignment,
          alignment = _ref$alignment === undefined ? this.props.scrollToAlignment : _ref$alignment,
          _ref$columnIndex = _ref.columnIndex,
          columnIndex = _ref$columnIndex === undefined ? this.props.scrollToColumn : _ref$columnIndex,
          _ref$rowIndex = _ref.rowIndex,
          rowIndex = _ref$rowIndex === undefined ? this.props.scrollToRow : _ref$rowIndex;

      var offsetProps = __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_extends___default()({}, this.props, {
        scrollToAlignment: alignment,
        scrollToColumn: columnIndex,
        scrollToRow: rowIndex
      });

      return {
        scrollLeft: this._getCalculatedScrollLeft(offsetProps),
        scrollTop: this._getCalculatedScrollTop(offsetProps)
      };
    }

    /**
     * This method handles a scroll event originating from an external scroll control.
     * It's an advanced method and should probably not be used unless you're implementing a custom scroll-bar solution.
     */

  }, {
    key: 'handleScrollEvent',
    value: function handleScrollEvent(_ref2) {
      var _ref2$scrollLeft = _ref2.scrollLeft,
          scrollLeftParam = _ref2$scrollLeft === undefined ? 0 : _ref2$scrollLeft,
          _ref2$scrollTop = _ref2.scrollTop,
          scrollTopParam = _ref2$scrollTop === undefined ? 0 : _ref2$scrollTop;

      // On iOS, we can arrive at negative offsets by swiping past the start.
      // To prevent flicker here, we make playing in the negative offset zone cause nothing to happen.
      if (scrollTopParam < 0) {
        return;
      }

      // Prevent pointer events from interrupting a smooth scroll
      this._debounceScrollEnded();

      var _props = this.props,
          autoHeight = _props.autoHeight,
          autoWidth = _props.autoWidth,
          height = _props.height,
          width = _props.width;

      // When this component is shrunk drastically, React dispatches a series of back-to-back scroll events,
      // Gradually converging on a scrollTop that is within the bounds of the new, smaller height.
      // This causes a series of rapid renders that is slow for long lists.
      // We can avoid that by doing some simple bounds checking to ensure that scroll offsets never exceed their bounds.

      var scrollbarSize = this._scrollbarSize;
      var totalRowsHeight = this._rowSizeAndPositionManager.getTotalSize();
      var totalColumnsWidth = this._columnSizeAndPositionManager.getTotalSize();
      var scrollLeft = Math.min(Math.max(0, totalColumnsWidth - width + scrollbarSize), scrollLeftParam);
      var scrollTop = Math.min(Math.max(0, totalRowsHeight - height + scrollbarSize), scrollTopParam);

      // Certain devices (like Apple touchpad) rapid-fire duplicate events.
      // Don't force a re-render if this is the case.
      // The mouse may move faster then the animation frame does.
      // Use requestAnimationFrame to avoid over-updating.
      if (this.state.scrollLeft !== scrollLeft || this.state.scrollTop !== scrollTop) {
        // Track scrolling direction so we can more efficiently overscan rows to reduce empty space around the edges while scrolling.
        // Don't change direction for an axis unless scroll offset has changed.
        var scrollDirectionHorizontal = scrollLeft !== this.state.scrollLeft ? scrollLeft > this.state.scrollLeft ? __WEBPACK_IMPORTED_MODULE_12__defaultOverscanIndicesGetter__["b" /* SCROLL_DIRECTION_FORWARD */] : __WEBPACK_IMPORTED_MODULE_12__defaultOverscanIndicesGetter__["a" /* SCROLL_DIRECTION_BACKWARD */] : this.state.scrollDirectionHorizontal;
        var scrollDirectionVertical = scrollTop !== this.state.scrollTop ? scrollTop > this.state.scrollTop ? __WEBPACK_IMPORTED_MODULE_12__defaultOverscanIndicesGetter__["b" /* SCROLL_DIRECTION_FORWARD */] : __WEBPACK_IMPORTED_MODULE_12__defaultOverscanIndicesGetter__["a" /* SCROLL_DIRECTION_BACKWARD */] : this.state.scrollDirectionVertical;

        var newState = {
          isScrolling: true,
          scrollDirectionHorizontal: scrollDirectionHorizontal,
          scrollDirectionVertical: scrollDirectionVertical,
          scrollPositionChangeReason: SCROLL_POSITION_CHANGE_REASONS.OBSERVED
        };

        if (!autoHeight) {
          newState.scrollTop = scrollTop;
        }

        if (!autoWidth) {
          newState.scrollLeft = scrollLeft;
        }

        this.setState(newState);
      }

      this._invokeOnScrollMemoizer({ scrollLeft: scrollLeft, scrollTop: scrollTop, totalColumnsWidth: totalColumnsWidth, totalRowsHeight: totalRowsHeight });
    }

    /**
     * Invalidate Grid size and recompute visible cells.
     * This is a deferred wrapper for recomputeGridSize().
     * It sets a flag to be evaluated on cDM/cDU to avoid unnecessary renders.
     * This method is intended for advanced use-cases like CellMeasurer.
     */
    // @TODO (bvaughn) Add automated test coverage for this.

  }, {
    key: 'invalidateCellSizeAfterRender',
    value: function invalidateCellSizeAfterRender(_ref3) {
      var columnIndex = _ref3.columnIndex,
          rowIndex = _ref3.rowIndex;

      this._deferredInvalidateColumnIndex = typeof this._deferredInvalidateColumnIndex === 'number' ? Math.min(this._deferredInvalidateColumnIndex, columnIndex) : columnIndex;
      this._deferredInvalidateRowIndex = typeof this._deferredInvalidateRowIndex === 'number' ? Math.min(this._deferredInvalidateRowIndex, rowIndex) : rowIndex;
    }

    /**
     * Pre-measure all columns and rows in a Grid.
     * Typically cells are only measured as needed and estimated sizes are used for cells that have not yet been measured.
     * This method ensures that the next call to getTotalSize() returns an exact size (as opposed to just an estimated one).
     */

  }, {
    key: 'measureAllCells',
    value: function measureAllCells() {
      var _props2 = this.props,
          columnCount = _props2.columnCount,
          rowCount = _props2.rowCount;


      this._columnSizeAndPositionManager.getSizeAndPositionOfCell(columnCount - 1);
      this._rowSizeAndPositionManager.getSizeAndPositionOfCell(rowCount - 1);
    }

    /**
     * Forced recompute of row heights and column widths.
     * This function should be called if dynamic column or row sizes have changed but nothing else has.
     * Since Grid only receives :columnCount and :rowCount it has no way of detecting when the underlying data changes.
     */

  }, {
    key: 'recomputeGridSize',
    value: function recomputeGridSize() {
      var _ref4 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
          _ref4$columnIndex = _ref4.columnIndex,
          columnIndex = _ref4$columnIndex === undefined ? 0 : _ref4$columnIndex,
          _ref4$rowIndex = _ref4.rowIndex,
          rowIndex = _ref4$rowIndex === undefined ? 0 : _ref4$rowIndex;

      var _props3 = this.props,
          scrollToColumn = _props3.scrollToColumn,
          scrollToRow = _props3.scrollToRow;


      this._columnSizeAndPositionManager.resetCell(columnIndex);
      this._rowSizeAndPositionManager.resetCell(rowIndex);

      // Cell sizes may be determined by a function property.
      // In this case the cDU handler can't know if they changed.
      // Store this flag to let the next cDU pass know it needs to recompute the scroll offset.
      this._recomputeScrollLeftFlag = scrollToColumn >= 0 && columnIndex <= scrollToColumn;
      this._recomputeScrollTopFlag = scrollToRow >= 0 && rowIndex <= scrollToRow;

      // Clear cell cache in case we are scrolling;
      // Invalid row heights likely mean invalid cached content as well.
      this._cellCache = {};
      this._styleCache = {};

      this.forceUpdate();
    }

    /**
     * Ensure column and row are visible.
     */

  }, {
    key: 'scrollToCell',
    value: function scrollToCell(_ref5) {
      var columnIndex = _ref5.columnIndex,
          rowIndex = _ref5.rowIndex;
      var columnCount = this.props.columnCount;


      var props = this.props;

      // Don't adjust scroll offset for single-column grids (eg List, Table).
      // This can cause a funky scroll offset because of the vertical scrollbar width.
      if (columnCount > 1) {
        this._updateScrollLeftForScrollToColumn(__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_extends___default()({}, props, {
          scrollToColumn: columnIndex
        }));
      }

      this._updateScrollTopForScrollToRow(__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_extends___default()({}, props, {
        scrollToRow: rowIndex
      }));
    }

    /**
     * Scroll to the specified offset(s).
     * Useful for animating position changes.
     */

  }, {
    key: 'scrollToPosition',
    value: function scrollToPosition() {
      var _ref6 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
          scrollLeft = _ref6.scrollLeft,
          scrollTop = _ref6.scrollTop;

      this._setScrollPosition({ scrollLeft: scrollLeft, scrollTop: scrollTop });
    }
  }, {
    key: 'componentDidMount',
    value: function componentDidMount() {
      var _props4 = this.props,
          getScrollbarSize = _props4.getScrollbarSize,
          height = _props4.height,
          scrollLeft = _props4.scrollLeft,
          scrollToColumn = _props4.scrollToColumn,
          scrollTop = _props4.scrollTop,
          scrollToRow = _props4.scrollToRow,
          width = _props4.width;

      // If cell sizes have been invalidated (eg we are using CellMeasurer) then reset cached positions.
      // We must do this at the start of the method as we may calculate and update scroll position below.

      this._handleInvalidatedGridSize();

      // If this component was first rendered server-side, scrollbar size will be undefined.
      // In that event we need to remeasure.
      if (!this._scrollbarSizeMeasured) {
        this._scrollbarSize = getScrollbarSize();
        this._scrollbarSizeMeasured = true;
        this.setState({});
      }

      if (scrollLeft >= 0 || scrollTop >= 0) {
        this._setScrollPosition({ scrollLeft: scrollLeft, scrollTop: scrollTop });
      }

      // Don't update scroll offset if the size is 0; we don't render any cells in this case.
      // Setting a state may cause us to later thing we've updated the offce when we haven't.
      var sizeIsBiggerThanZero = height > 0 && width > 0;
      if (scrollToColumn >= 0 && sizeIsBiggerThanZero) {
        this._updateScrollLeftForScrollToColumn();
      }
      if (scrollToRow >= 0 && sizeIsBiggerThanZero) {
        this._updateScrollTopForScrollToRow();
      }

      // Update onRowsRendered callback
      this._invokeOnGridRenderedHelper();

      // Initialize onScroll callback
      this._invokeOnScrollMemoizer({
        scrollLeft: scrollLeft || 0,
        scrollTop: scrollTop || 0,
        totalColumnsWidth: this._columnSizeAndPositionManager.getTotalSize(),
        totalRowsHeight: this._rowSizeAndPositionManager.getTotalSize()
      });

      this._maybeCallOnScrollbarPresenceChange();
    }

    /**
     * @private
     * This method updates scrollLeft/scrollTop in state for the following conditions:
     * 1) New scroll-to-cell props have been set
     */

  }, {
    key: 'componentDidUpdate',
    value: function componentDidUpdate(prevProps, prevState) {
      var _this2 = this;

      var _props5 = this.props,
          autoHeight = _props5.autoHeight,
          autoWidth = _props5.autoWidth,
          columnCount = _props5.columnCount,
          height = _props5.height,
          rowCount = _props5.rowCount,
          scrollToAlignment = _props5.scrollToAlignment,
          scrollToColumn = _props5.scrollToColumn,
          scrollToRow = _props5.scrollToRow,
          width = _props5.width;
      var _state = this.state,
          scrollLeft = _state.scrollLeft,
          scrollPositionChangeReason = _state.scrollPositionChangeReason,
          scrollTop = _state.scrollTop;

      // If cell sizes have been invalidated (eg we are using CellMeasurer) then reset cached positions.
      // We must do this at the start of the method as we may calculate and update scroll position below.

      this._handleInvalidatedGridSize();

      // Handle edge case where column or row count has only just increased over 0.
      // In this case we may have to restore a previously-specified scroll offset.
      // For more info see bvaughn/react-virtualized/issues/218
      var columnOrRowCountJustIncreasedFromZero = columnCount > 0 && prevProps.columnCount === 0 || rowCount > 0 && prevProps.rowCount === 0;

      // Make sure requested changes to :scrollLeft or :scrollTop get applied.
      // Assigning to scrollLeft/scrollTop tells the browser to interrupt any running scroll animations,
      // And to discard any pending async changes to the scroll position that may have happened in the meantime (e.g. on a separate scrolling thread).
      // So we only set these when we require an adjustment of the scroll position.
      // See issue #2 for more information.
      if (scrollPositionChangeReason === SCROLL_POSITION_CHANGE_REASONS.REQUESTED) {
        // @TRICKY :autoHeight and :autoWidth properties instructs Grid to leave :scrollTop and :scrollLeft management to an external HOC (eg WindowScroller).
        // In this case we should avoid checking scrollingContainer.scrollTop and scrollingContainer.scrollLeft since it forces layout/flow.
        if (!autoWidth && scrollLeft >= 0 && (scrollLeft !== prevState.scrollLeft && scrollLeft !== this._scrollingContainer.scrollLeft || columnOrRowCountJustIncreasedFromZero)) {
          this._scrollingContainer.scrollLeft = scrollLeft;
        }
        if (!autoHeight && scrollTop >= 0 && (scrollTop !== prevState.scrollTop && scrollTop !== this._scrollingContainer.scrollTop || columnOrRowCountJustIncreasedFromZero)) {
          this._scrollingContainer.scrollTop = scrollTop;
        }
      }

      // Special case where the previous size was 0:
      // In this case we don't show any windowed cells at all.
      // So we should always recalculate offset afterwards.
      var sizeJustIncreasedFromZero = (prevProps.width === 0 || prevProps.height === 0) && height > 0 && width > 0;

      // Update scroll offsets if the current :scrollToColumn or :scrollToRow values requires it
      // @TODO Do we also need this check or can the one in componentWillUpdate() suffice?
      if (this._recomputeScrollLeftFlag) {
        this._recomputeScrollLeftFlag = false;
        this._updateScrollLeftForScrollToColumn(this.props);
      } else {
        Object(__WEBPACK_IMPORTED_MODULE_13__utils_updateScrollIndexHelper__["a" /* default */])({
          cellSizeAndPositionManager: this._columnSizeAndPositionManager,
          previousCellsCount: prevProps.columnCount,
          previousCellSize: prevProps.columnWidth,
          previousScrollToAlignment: prevProps.scrollToAlignment,
          previousScrollToIndex: prevProps.scrollToColumn,
          previousSize: prevProps.width,
          scrollOffset: scrollLeft,
          scrollToAlignment: scrollToAlignment,
          scrollToIndex: scrollToColumn,
          size: width,
          sizeJustIncreasedFromZero: sizeJustIncreasedFromZero,
          updateScrollIndexCallback: function updateScrollIndexCallback(scrollToColumn) {
            return _this2._updateScrollLeftForScrollToColumn(_this2.props);
          }
        });
      }

      if (this._recomputeScrollTopFlag) {
        this._recomputeScrollTopFlag = false;
        this._updateScrollTopForScrollToRow(this.props);
      } else {
        Object(__WEBPACK_IMPORTED_MODULE_13__utils_updateScrollIndexHelper__["a" /* default */])({
          cellSizeAndPositionManager: this._rowSizeAndPositionManager,
          previousCellsCount: prevProps.rowCount,
          previousCellSize: prevProps.rowHeight,
          previousScrollToAlignment: prevProps.scrollToAlignment,
          previousScrollToIndex: prevProps.scrollToRow,
          previousSize: prevProps.height,
          scrollOffset: scrollTop,
          scrollToAlignment: scrollToAlignment,
          scrollToIndex: scrollToRow,
          size: height,
          sizeJustIncreasedFromZero: sizeJustIncreasedFromZero,
          updateScrollIndexCallback: function updateScrollIndexCallback(scrollToRow) {
            return _this2._updateScrollTopForScrollToRow(_this2.props);
          }
        });
      }

      // Update onRowsRendered callback if start/stop indices have changed
      this._invokeOnGridRenderedHelper();

      // Changes to :scrollLeft or :scrollTop should also notify :onScroll listeners
      if (scrollLeft !== prevState.scrollLeft || scrollTop !== prevState.scrollTop) {
        var totalRowsHeight = this._rowSizeAndPositionManager.getTotalSize();
        var totalColumnsWidth = this._columnSizeAndPositionManager.getTotalSize();

        this._invokeOnScrollMemoizer({ scrollLeft: scrollLeft, scrollTop: scrollTop, totalColumnsWidth: totalColumnsWidth, totalRowsHeight: totalRowsHeight });
      }

      this._maybeCallOnScrollbarPresenceChange();
    }
  }, {
    key: 'componentWillMount',
    value: function componentWillMount() {
      var getScrollbarSize = this.props.getScrollbarSize;

      // If this component is being rendered server-side, getScrollbarSize() will return undefined.
      // We handle this case in componentDidMount()

      this._scrollbarSize = getScrollbarSize();
      if (this._scrollbarSize === undefined) {
        this._scrollbarSizeMeasured = false;
        this._scrollbarSize = 0;
      } else {
        this._scrollbarSizeMeasured = true;
      }

      this._calculateChildrenToRender();
    }
  }, {
    key: 'componentWillUnmount',
    value: function componentWillUnmount() {
      if (this._disablePointerEventsTimeoutId) {
        clearTimeout(this._disablePointerEventsTimeoutId);
      }
    }

    /**
     * @private
     * This method updates scrollLeft/scrollTop in state for the following conditions:
     * 1) Empty content (0 rows or columns)
     * 2) New scroll props overriding the current state
     * 3) Cells-count or cells-size has changed, making previous scroll offsets invalid
     */

  }, {
    key: 'componentWillReceiveProps',
    value: function componentWillReceiveProps(nextProps) {
      var _this3 = this;

      var _state2 = this.state,
          scrollLeft = _state2.scrollLeft,
          scrollTop = _state2.scrollTop;


      if (nextProps.columnCount === 0 && scrollLeft !== 0 || nextProps.rowCount === 0 && scrollTop !== 0) {
        this._setScrollPosition({
          scrollLeft: 0,
          scrollTop: 0
        });
      } else if (nextProps.scrollLeft !== this.props.scrollLeft || nextProps.scrollTop !== this.props.scrollTop) {
        var newState = {};

        if (nextProps.scrollLeft != null) {
          newState.scrollLeft = nextProps.scrollLeft;
        }
        if (nextProps.scrollTop != null) {
          newState.scrollTop = nextProps.scrollTop;
        }

        this._setScrollPosition(newState);
      }

      if (nextProps.columnWidth !== this.props.columnWidth || nextProps.rowHeight !== this.props.rowHeight) {
        this._styleCache = {};
      }

      this._columnWidthGetter = this._wrapSizeGetter(nextProps.columnWidth);
      this._rowHeightGetter = this._wrapSizeGetter(nextProps.rowHeight);

      this._columnSizeAndPositionManager.configure({
        cellCount: nextProps.columnCount,
        estimatedCellSize: this._getEstimatedColumnSize(nextProps)
      });
      this._rowSizeAndPositionManager.configure({
        cellCount: nextProps.rowCount,
        estimatedCellSize: this._getEstimatedRowSize(nextProps)
      });

      var _props6 = this.props,
          columnCount = _props6.columnCount,
          rowCount = _props6.rowCount;

      // Special case when either cols or rows were 0
      // This would prevent any cells from rendering
      // So we need to reset row scroll if cols changed from 0 (and vice versa)

      if (columnCount === 0 || rowCount === 0) {
        columnCount = 0;
        rowCount = 0;
      }

      // If scrolling is controlled outside this component, clear cache when scrolling stops
      if (nextProps.autoHeight && nextProps.isScrolling === false && this.props.isScrolling === true) {
        this._resetStyleCache();
      }

      // Update scroll offsets if the size or number of cells have changed, invalidating the previous value
      Object(__WEBPACK_IMPORTED_MODULE_9__utils_calculateSizeAndPositionDataAndUpdateScrollOffset__["a" /* default */])({
        cellCount: columnCount,
        cellSize: this.props.columnWidth,
        computeMetadataCallback: function computeMetadataCallback() {
          return _this3._columnSizeAndPositionManager.resetCell(0);
        },
        computeMetadataCallbackProps: nextProps,
        nextCellsCount: nextProps.columnCount,
        nextCellSize: nextProps.columnWidth,
        nextScrollToIndex: nextProps.scrollToColumn,
        scrollToIndex: this.props.scrollToColumn,
        updateScrollOffsetForScrollToIndex: function updateScrollOffsetForScrollToIndex() {
          return _this3._updateScrollLeftForScrollToColumn(nextProps, _this3.state);
        }
      });
      Object(__WEBPACK_IMPORTED_MODULE_9__utils_calculateSizeAndPositionDataAndUpdateScrollOffset__["a" /* default */])({
        cellCount: rowCount,
        cellSize: this.props.rowHeight,
        computeMetadataCallback: function computeMetadataCallback() {
          return _this3._rowSizeAndPositionManager.resetCell(0);
        },
        computeMetadataCallbackProps: nextProps,
        nextCellsCount: nextProps.rowCount,
        nextCellSize: nextProps.rowHeight,
        nextScrollToIndex: nextProps.scrollToRow,
        scrollToIndex: this.props.scrollToRow,
        updateScrollOffsetForScrollToIndex: function updateScrollOffsetForScrollToIndex() {
          return _this3._updateScrollTopForScrollToRow(nextProps, _this3.state);
        }
      });
    }
  }, {
    key: 'componentWillUpdate',
    value: function componentWillUpdate(nextProps, nextState) {
      this._calculateChildrenToRender(nextProps, nextState);
    }
  }, {
    key: 'render',
    value: function render() {
      var _props7 = this.props,
          autoContainerWidth = _props7.autoContainerWidth,
          autoHeight = _props7.autoHeight,
          autoWidth = _props7.autoWidth,
          className = _props7.className,
          containerStyle = _props7.containerStyle,
          height = _props7.height,
          id = _props7.id,
          noContentRenderer = _props7.noContentRenderer,
          role = _props7.role,
          style = _props7.style,
          tabIndex = _props7.tabIndex,
          width = _props7.width;


      var isScrolling = this._isScrolling();

      var gridStyle = {
        boxSizing: 'border-box',
        direction: 'ltr',
        height: autoHeight ? 'auto' : height,
        position: 'relative',
        width: autoWidth ? 'auto' : width,
        WebkitOverflowScrolling: 'touch',
        willChange: 'transform'
      };

      var totalColumnsWidth = this._columnSizeAndPositionManager.getTotalSize();
      var totalRowsHeight = this._rowSizeAndPositionManager.getTotalSize();

      // Force browser to hide scrollbars when we know they aren't necessary.
      // Otherwise once scrollbars appear they may not disappear again.
      // For more info see issue #116
      var verticalScrollBarSize = totalRowsHeight > height ? this._scrollbarSize : 0;
      var horizontalScrollBarSize = totalColumnsWidth > width ? this._scrollbarSize : 0;

      if (horizontalScrollBarSize !== this._horizontalScrollBarSize || verticalScrollBarSize !== this._verticalScrollBarSize) {
        this._horizontalScrollBarSize = horizontalScrollBarSize;
        this._verticalScrollBarSize = verticalScrollBarSize;
        this._scrollbarPresenceChanged = true;
      }

      // Also explicitly init styles to 'auto' if scrollbars are required.
      // This works around an obscure edge case where external CSS styles have not yet been loaded,
      // But an initial scroll index of offset is set as an external prop.
      // Without this style, Grid would render the correct range of cells but would NOT update its internal offset.
      // This was originally reported via clauderic/react-infinite-calendar/issues/23
      gridStyle.overflowX = totalColumnsWidth + verticalScrollBarSize <= width ? 'hidden' : 'auto';
      gridStyle.overflowY = totalRowsHeight + horizontalScrollBarSize <= height ? 'hidden' : 'auto';

      var childrenToDisplay = this._childrenToDisplay;

      var showNoContentRenderer = childrenToDisplay.length === 0 && height > 0 && width > 0;

      return __WEBPACK_IMPORTED_MODULE_6_react___default.a.createElement(
        'div',
        {
          ref: this._setScrollingContainerRef,
          'aria-label': this.props['aria-label'],
          className: __WEBPACK_IMPORTED_MODULE_8_classnames___default()('ReactVirtualized__Grid', className),
          id: id,
          onScroll: this._onScroll,
          role: role,
          style: __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_extends___default()({}, gridStyle, style),
          tabIndex: tabIndex
        },
        childrenToDisplay.length > 0 && __WEBPACK_IMPORTED_MODULE_6_react___default.a.createElement(
          'div',
          {
            className: 'ReactVirtualized__Grid__innerScrollContainer',
            style: __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_extends___default()({
              width: autoContainerWidth ? 'auto' : totalColumnsWidth,
              height: totalRowsHeight,
              maxWidth: totalColumnsWidth,
              maxHeight: totalRowsHeight,
              overflow: 'hidden',
              pointerEvents: isScrolling ? 'none' : '',
              position: 'relative'
            }, containerStyle)
          },
          childrenToDisplay
        ),
        showNoContentRenderer && noContentRenderer()
      );
    }

    /* ---------------------------- Helper methods ---------------------------- */

  }, {
    key: '_calculateChildrenToRender',
    value: function _calculateChildrenToRender() {
      var props = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : this.props;
      var state = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : this.state;
      var cellRenderer = props.cellRenderer,
          cellRangeRenderer = props.cellRangeRenderer,
          columnCount = props.columnCount,
          deferredMeasurementCache = props.deferredMeasurementCache,
          height = props.height,
          overscanColumnCount = props.overscanColumnCount,
          overscanIndicesGetter = props.overscanIndicesGetter,
          overscanRowCount = props.overscanRowCount,
          rowCount = props.rowCount,
          width = props.width;
      var scrollDirectionHorizontal = state.scrollDirectionHorizontal,
          scrollDirectionVertical = state.scrollDirectionVertical,
          scrollLeft = state.scrollLeft,
          scrollTop = state.scrollTop;


      var isScrolling = this._isScrolling(props, state);

      this._childrenToDisplay = [];

      // Render only enough columns and rows to cover the visible area of the grid.
      if (height > 0 && width > 0) {
        var visibleColumnIndices = this._columnSizeAndPositionManager.getVisibleCellRange({
          containerSize: width,
          offset: scrollLeft
        });
        var visibleRowIndices = this._rowSizeAndPositionManager.getVisibleCellRange({
          containerSize: height,
          offset: scrollTop
        });

        var horizontalOffsetAdjustment = this._columnSizeAndPositionManager.getOffsetAdjustment({
          containerSize: width,
          offset: scrollLeft
        });
        var verticalOffsetAdjustment = this._rowSizeAndPositionManager.getOffsetAdjustment({
          containerSize: height,
          offset: scrollTop
        });

        // Store for _invokeOnGridRenderedHelper()
        this._renderedColumnStartIndex = visibleColumnIndices.start;
        this._renderedColumnStopIndex = visibleColumnIndices.stop;
        this._renderedRowStartIndex = visibleRowIndices.start;
        this._renderedRowStopIndex = visibleRowIndices.stop;

        var overscanColumnIndices = overscanIndicesGetter({
          direction: 'horizontal',
          cellCount: columnCount,
          overscanCellsCount: overscanColumnCount,
          scrollDirection: scrollDirectionHorizontal,
          startIndex: this._renderedColumnStartIndex,
          stopIndex: this._renderedColumnStopIndex
        });

        var overscanRowIndices = overscanIndicesGetter({
          direction: 'vertical',
          cellCount: rowCount,
          overscanCellsCount: overscanRowCount,
          scrollDirection: scrollDirectionVertical,
          startIndex: this._renderedRowStartIndex,
          stopIndex: this._renderedRowStopIndex
        });

        // Store for _invokeOnGridRenderedHelper()
        this._columnStartIndex = overscanColumnIndices.overscanStartIndex;
        this._columnStopIndex = overscanColumnIndices.overscanStopIndex;
        this._rowStartIndex = overscanRowIndices.overscanStartIndex;
        this._rowStopIndex = overscanRowIndices.overscanStopIndex;

        this._childrenToDisplay = cellRangeRenderer({
          cellCache: this._cellCache,
          cellRenderer: cellRenderer,
          columnSizeAndPositionManager: this._columnSizeAndPositionManager,
          columnStartIndex: this._columnStartIndex,
          columnStopIndex: this._columnStopIndex,
          deferredMeasurementCache: deferredMeasurementCache,
          horizontalOffsetAdjustment: horizontalOffsetAdjustment,
          isScrolling: isScrolling,
          parent: this,
          rowSizeAndPositionManager: this._rowSizeAndPositionManager,
          rowStartIndex: this._rowStartIndex,
          rowStopIndex: this._rowStopIndex,
          scrollLeft: scrollLeft,
          scrollTop: scrollTop,
          styleCache: this._styleCache,
          verticalOffsetAdjustment: verticalOffsetAdjustment,
          visibleColumnIndices: visibleColumnIndices,
          visibleRowIndices: visibleRowIndices
        });
      }
    }

    /**
     * Sets an :isScrolling flag for a small window of time.
     * This flag is used to disable pointer events on the scrollable portion of the Grid.
     * This prevents jerky/stuttery mouse-wheel scrolling.
     */

  }, {
    key: '_debounceScrollEnded',
    value: function _debounceScrollEnded() {
      var scrollingResetTimeInterval = this.props.scrollingResetTimeInterval;


      if (this._disablePointerEventsTimeoutId) {
        clearTimeout(this._disablePointerEventsTimeoutId);
      }

      this._disablePointerEventsTimeoutId = setTimeout(this._debounceScrollEndedCallback, scrollingResetTimeInterval);
    }
  }, {
    key: '_debounceScrollEndedCallback',
    value: function _debounceScrollEndedCallback() {
      this._disablePointerEventsTimeoutId = null;
      this._resetStyleCache();
    }
  }, {
    key: '_getEstimatedColumnSize',
    value: function _getEstimatedColumnSize(props) {
      return typeof props.columnWidth === 'number' ? props.columnWidth : props.estimatedColumnSize;
    }
  }, {
    key: '_getEstimatedRowSize',
    value: function _getEstimatedRowSize(props) {
      return typeof props.rowHeight === 'number' ? props.rowHeight : props.estimatedRowSize;
    }

    /**
     * Check for batched CellMeasurer size invalidations.
     * This will occur the first time one or more previously unmeasured cells are rendered.
     */

  }, {
    key: '_handleInvalidatedGridSize',
    value: function _handleInvalidatedGridSize() {
      if (typeof this._deferredInvalidateColumnIndex === 'number') {
        var columnIndex = this._deferredInvalidateColumnIndex;
        var rowIndex = this._deferredInvalidateRowIndex;

        this._deferredInvalidateColumnIndex = null;
        this._deferredInvalidateRowIndex = null;

        this.recomputeGridSize({ columnIndex: columnIndex, rowIndex: rowIndex });
      }
    }
  }, {
    key: '_invokeOnGridRenderedHelper',
    value: function _invokeOnGridRenderedHelper() {
      var onSectionRendered = this.props.onSectionRendered;


      this._onGridRenderedMemoizer({
        callback: onSectionRendered,
        indices: {
          columnOverscanStartIndex: this._columnStartIndex,
          columnOverscanStopIndex: this._columnStopIndex,
          columnStartIndex: this._renderedColumnStartIndex,
          columnStopIndex: this._renderedColumnStopIndex,
          rowOverscanStartIndex: this._rowStartIndex,
          rowOverscanStopIndex: this._rowStopIndex,
          rowStartIndex: this._renderedRowStartIndex,
          rowStopIndex: this._renderedRowStopIndex
        }
      });
    }
  }, {
    key: '_invokeOnScrollMemoizer',
    value: function _invokeOnScrollMemoizer(_ref7) {
      var _this4 = this;

      var scrollLeft = _ref7.scrollLeft,
          scrollTop = _ref7.scrollTop,
          totalColumnsWidth = _ref7.totalColumnsWidth,
          totalRowsHeight = _ref7.totalRowsHeight;

      this._onScrollMemoizer({
        callback: function callback(_ref8) {
          var scrollLeft = _ref8.scrollLeft,
              scrollTop = _ref8.scrollTop;
          var _props8 = _this4.props,
              height = _props8.height,
              onScroll = _props8.onScroll,
              width = _props8.width;


          onScroll({
            clientHeight: height,
            clientWidth: width,
            scrollHeight: totalRowsHeight,
            scrollLeft: scrollLeft,
            scrollTop: scrollTop,
            scrollWidth: totalColumnsWidth
          });
        },
        indices: {
          scrollLeft: scrollLeft,
          scrollTop: scrollTop
        }
      });
    }
  }, {
    key: '_isScrolling',
    value: function _isScrolling() {
      var props = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : this.props;
      var state = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : this.state;

      // If isScrolling is defined in props, use it to override the value in state
      // This is a performance optimization for WindowScroller + Grid
      return Object.hasOwnProperty.call(props, 'isScrolling') ? props.isScrolling : state.isScrolling;
    }
  }, {
    key: '_maybeCallOnScrollbarPresenceChange',
    value: function _maybeCallOnScrollbarPresenceChange() {
      if (this._scrollbarPresenceChanged) {
        var onScrollbarPresenceChange = this.props.onScrollbarPresenceChange;


        this._scrollbarPresenceChanged = false;

        onScrollbarPresenceChange({
          horizontal: this._horizontalScrollBarSize > 0,
          size: this._scrollbarSize,
          vertical: this._verticalScrollBarSize > 0
        });
      }
    }
  }, {
    key: '_setScrollingContainerRef',
    value: function _setScrollingContainerRef(ref) {
      this._scrollingContainer = ref;
    }
  }, {
    key: '_setScrollPosition',
    value: function _setScrollPosition(_ref9) {
      var scrollLeft = _ref9.scrollLeft,
          scrollTop = _ref9.scrollTop;

      var newState = {
        scrollPositionChangeReason: SCROLL_POSITION_CHANGE_REASONS.REQUESTED
      };

      if (scrollLeft >= 0) {
        newState.scrollDirectionHorizontal = scrollLeft > this.state.scrollLeft ? __WEBPACK_IMPORTED_MODULE_12__defaultOverscanIndicesGetter__["b" /* SCROLL_DIRECTION_FORWARD */] : __WEBPACK_IMPORTED_MODULE_12__defaultOverscanIndicesGetter__["a" /* SCROLL_DIRECTION_BACKWARD */];
        newState.scrollLeft = scrollLeft;
      }

      if (scrollTop >= 0) {
        newState.scrollDirectionVertical = scrollTop > this.state.scrollTop ? __WEBPACK_IMPORTED_MODULE_12__defaultOverscanIndicesGetter__["b" /* SCROLL_DIRECTION_FORWARD */] : __WEBPACK_IMPORTED_MODULE_12__defaultOverscanIndicesGetter__["a" /* SCROLL_DIRECTION_BACKWARD */];
        newState.scrollTop = scrollTop;
      }

      if (scrollLeft >= 0 && scrollLeft !== this.state.scrollLeft || scrollTop >= 0 && scrollTop !== this.state.scrollTop) {
        this.setState(newState);
      }
    }
  }, {
    key: '_wrapPropertyGetter',
    value: function _wrapPropertyGetter(value) {
      return typeof value === 'function' ? value : function () {
        return value;
      };
    }
  }, {
    key: '_wrapSizeGetter',
    value: function _wrapSizeGetter(size) {
      return this._wrapPropertyGetter(size);
    }
  }, {
    key: '_getCalculatedScrollLeft',
    value: function _getCalculatedScrollLeft() {
      var props = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : this.props;
      var state = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : this.state;
      var columnCount = props.columnCount,
          height = props.height,
          scrollToAlignment = props.scrollToAlignment,
          scrollToColumn = props.scrollToColumn,
          width = props.width;
      var scrollLeft = state.scrollLeft;


      if (scrollToColumn >= 0 && columnCount > 0) {
        var targetIndex = Math.max(0, Math.min(columnCount - 1, scrollToColumn));
        var totalRowsHeight = this._rowSizeAndPositionManager.getTotalSize();
        var scrollBarSize = totalRowsHeight > height ? this._scrollbarSize : 0;

        return this._columnSizeAndPositionManager.getUpdatedOffsetForIndex({
          align: scrollToAlignment,
          containerSize: width - scrollBarSize,
          currentOffset: scrollLeft,
          targetIndex: targetIndex
        });
      }
    }
  }, {
    key: '_updateScrollLeftForScrollToColumn',
    value: function _updateScrollLeftForScrollToColumn() {
      var props = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : this.props;
      var state = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : this.state;
      var scrollLeft = state.scrollLeft;

      var calculatedScrollLeft = this._getCalculatedScrollLeft(props, state);

      if (calculatedScrollLeft >= 0 && scrollLeft !== calculatedScrollLeft) {
        this._setScrollPosition({
          scrollLeft: calculatedScrollLeft
        });
      }
    }
  }, {
    key: '_getCalculatedScrollTop',
    value: function _getCalculatedScrollTop() {
      var props = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : this.props;
      var state = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : this.state;
      var height = props.height,
          rowCount = props.rowCount,
          scrollToAlignment = props.scrollToAlignment,
          scrollToRow = props.scrollToRow,
          width = props.width;
      var scrollTop = state.scrollTop;


      if (scrollToRow >= 0 && rowCount > 0) {
        var targetIndex = Math.max(0, Math.min(rowCount - 1, scrollToRow));
        var totalColumnsWidth = this._columnSizeAndPositionManager.getTotalSize();
        var scrollBarSize = totalColumnsWidth > width ? this._scrollbarSize : 0;

        return this._rowSizeAndPositionManager.getUpdatedOffsetForIndex({
          align: scrollToAlignment,
          containerSize: height - scrollBarSize,
          currentOffset: scrollTop,
          targetIndex: targetIndex
        });
      }
    }
  }, {
    key: '_resetStyleCache',
    value: function _resetStyleCache() {
      var styleCache = this._styleCache;

      // Reset cell and style caches once scrolling stops.
      // This makes Grid simpler to use (since cells commonly change).
      // And it keeps the caches from growing too large.
      // Performance is most sensitive when a user is scrolling.
      this._cellCache = {};
      this._styleCache = {};

      // Copy over the visible cell styles so avoid unnecessary re-render.
      for (var rowIndex = this._rowStartIndex; rowIndex <= this._rowStopIndex; rowIndex++) {
        for (var columnIndex = this._columnStartIndex; columnIndex <= this._columnStopIndex; columnIndex++) {
          var key = rowIndex + '-' + columnIndex;
          this._styleCache[key] = styleCache[key];
        }
      }

      this.setState({
        isScrolling: false
      });
    }
  }, {
    key: '_updateScrollTopForScrollToRow',
    value: function _updateScrollTopForScrollToRow() {
      var props = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : this.props;
      var state = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : this.state;
      var scrollTop = state.scrollTop;

      var calculatedScrollTop = this._getCalculatedScrollTop(props, state);

      if (calculatedScrollTop >= 0 && scrollTop !== calculatedScrollTop) {
        this._setScrollPosition({
          scrollTop: calculatedScrollTop
        });
      }
    }
  }, {
    key: '_onScroll',
    value: function _onScroll(event) {
      // In certain edge-cases React dispatches an onScroll event with an invalid target.scrollLeft / target.scrollTop.
      // This invalid event can be detected by comparing event.target to this component's scrollable DOM element.
      // See issue #404 for more information.
      if (event.target !== this._scrollingContainer) {
        return;
      }

      this.handleScrollEvent(event.target);
    }
  }]);

  return Grid;
}(__WEBPACK_IMPORTED_MODULE_6_react__["PureComponent"]);

Grid.defaultProps = {
  'aria-label': 'grid',
  cellRangeRenderer: __WEBPACK_IMPORTED_MODULE_14__defaultCellRangeRenderer__["a" /* default */],
  estimatedColumnSize: 100,
  estimatedRowSize: 30,
  getScrollbarSize: __WEBPACK_IMPORTED_MODULE_15_dom_helpers_util_scrollbarSize___default.a,
  noContentRenderer: function noContentRenderer() {
    return null;
  },
  onScroll: function onScroll() {
    return null;
  },
  onScrollbarPresenceChange: function onScrollbarPresenceChange() {
    return null;
  },
  onSectionRendered: function onSectionRendered() {
    return null;
  },
  overscanColumnCount: 0,
  overscanIndicesGetter: __WEBPACK_IMPORTED_MODULE_12__defaultOverscanIndicesGetter__["c" /* default */],
  overscanRowCount: 10,
  role: 'grid',
  scrollingResetTimeInterval: DEFAULT_SCROLLING_RESET_TIME_INTERVAL,
  scrollToAlignment: 'auto',
  scrollToColumn: -1,
  scrollToRow: -1,
  style: {},
  tabIndex: 0
};
/* harmony default export */ __webpack_exports__["a"] = (Grid);
process.env.NODE_ENV !== "production" ? Grid.propTypes = {
  'aria-label': __WEBPACK_IMPORTED_MODULE_7_prop_types___default.a.string,

  /**
   * Set the width of the inner scrollable container to 'auto'.
   * This is useful for single-column Grids to ensure that the column doesn't extend below a vertical scrollbar.
   */
  autoContainerWidth: __WEBPACK_IMPORTED_MODULE_7_prop_types___default.a.bool,

  /**
   * Removes fixed height from the scrollingContainer so that the total height of rows can stretch the window.
   * Intended for use with WindowScroller
   */
  autoHeight: __WEBPACK_IMPORTED_MODULE_7_prop_types___default.a.bool,

  /**
   * Removes fixed width from the scrollingContainer so that the total width of rows can stretch the window.
   * Intended for use with WindowScroller
   */
  autoWidth: __WEBPACK_IMPORTED_MODULE_7_prop_types___default.a.bool,

  /**
   * Responsible for rendering a cell given an row and column index.
   * Should implement the following interface: ({ columnIndex: number, rowIndex: number }): PropTypes.node
   */
  cellRenderer: __WEBPACK_IMPORTED_MODULE_7_prop_types___default.a.func.isRequired,

  /**
   * Responsible for rendering a group of cells given their index ranges.
   * Should implement the following interface: ({
   *   cellCache: Map,
   *   cellRenderer: Function,
   *   columnSizeAndPositionManager: CellSizeAndPositionManager,
   *   columnStartIndex: number,
   *   columnStopIndex: number,
   *   isScrolling: boolean,
   *   rowSizeAndPositionManager: CellSizeAndPositionManager,
   *   rowStartIndex: number,
   *   rowStopIndex: number,
   *   scrollLeft: number,
   *   scrollTop: number
   * }): Array<PropTypes.node>
   */
  cellRangeRenderer: __WEBPACK_IMPORTED_MODULE_7_prop_types___default.a.func.isRequired,

  /**
   * Optional custom CSS class name to attach to root Grid element.
   */
  className: __WEBPACK_IMPORTED_MODULE_7_prop_types___default.a.string,

  /**
   * Number of columns in grid.
   */
  columnCount: __WEBPACK_IMPORTED_MODULE_7_prop_types___default.a.number.isRequired,

  /**
   * Either a fixed column width (number) or a function that returns the width of a column given its index.
   * Should implement the following interface: (index: number): number
   */
  columnWidth: __WEBPACK_IMPORTED_MODULE_7_prop_types___default.a.oneOfType([__WEBPACK_IMPORTED_MODULE_7_prop_types___default.a.number, __WEBPACK_IMPORTED_MODULE_7_prop_types___default.a.func]).isRequired,

  /** Optional inline style applied to inner cell-container */
  containerStyle: __WEBPACK_IMPORTED_MODULE_7_prop_types___default.a.object,

  /**
   * If CellMeasurer is used to measure this Grid's children, this should be a pointer to its CellMeasurerCache.
   * A shared CellMeasurerCache reference enables Grid and CellMeasurer to share measurement data.
   */
  deferredMeasurementCache: __WEBPACK_IMPORTED_MODULE_7_prop_types___default.a.object,

  /**
   * Used to estimate the total width of a Grid before all of its columns have actually been measured.
   * The estimated total width is adjusted as columns are rendered.
   */
  estimatedColumnSize: __WEBPACK_IMPORTED_MODULE_7_prop_types___default.a.number.isRequired,

  /**
   * Used to estimate the total height of a Grid before all of its rows have actually been measured.
   * The estimated total height is adjusted as rows are rendered.
   */
  estimatedRowSize: __WEBPACK_IMPORTED_MODULE_7_prop_types___default.a.number.isRequired,

  /**
   * Exposed for testing purposes only.
   */
  getScrollbarSize: __WEBPACK_IMPORTED_MODULE_7_prop_types___default.a.func.isRequired,

  /**
   * Height of Grid; this property determines the number of visible (vs virtualized) rows.
   */
  height: __WEBPACK_IMPORTED_MODULE_7_prop_types___default.a.number.isRequired,

  /**
   * Optional custom id to attach to root Grid element.
   */
  id: __WEBPACK_IMPORTED_MODULE_7_prop_types___default.a.string,

  /**
   * Override internal is-scrolling state tracking.
   * This property is primarily intended for use with the WindowScroller component.
   */
  isScrolling: __WEBPACK_IMPORTED_MODULE_7_prop_types___default.a.bool,

  /**
   * Optional renderer to be used in place of rows when either :rowCount or :columnCount is 0.
   */
  noContentRenderer: __WEBPACK_IMPORTED_MODULE_7_prop_types___default.a.func.isRequired,

  /**
   * Callback invoked whenever the scroll offset changes within the inner scrollable region.
   * This callback can be used to sync scrolling between lists, tables, or grids.
   * ({ clientHeight, clientWidth, scrollHeight, scrollLeft, scrollTop, scrollWidth }): void
   */
  onScroll: __WEBPACK_IMPORTED_MODULE_7_prop_types___default.a.func.isRequired,

  /**
   * Called whenever a horizontal or vertical scrollbar is added or removed.
   * This prop is not intended for end-user use;
   * It is used by MultiGrid to support fixed-row/fixed-column scroll syncing.
   */
  onScrollbarPresenceChange: __WEBPACK_IMPORTED_MODULE_7_prop_types___default.a.func.isRequired,

  /**
   * Callback invoked with information about the section of the Grid that was just rendered.
   * ({ columnStartIndex, columnStopIndex, rowStartIndex, rowStopIndex }): void
   */
  onSectionRendered: __WEBPACK_IMPORTED_MODULE_7_prop_types___default.a.func.isRequired,

  /**
   * Number of columns to render before/after the visible section of the grid.
   * These columns can help for smoother scrolling on touch devices or browsers that send scroll events infrequently.
   */
  overscanColumnCount: __WEBPACK_IMPORTED_MODULE_7_prop_types___default.a.number.isRequired,

  /**
   * Calculates the number of cells to overscan before and after a specified range.
   * This function ensures that overscanning doesn't exceed the available cells.
   * Should implement the following interface: ({
   *   cellCount: number,
   *   overscanCellsCount: number,
   *   scrollDirection: number,
   *   startIndex: number,
   *   stopIndex: number
   * }): {overscanStartIndex: number, overscanStopIndex: number}
   */
  overscanIndicesGetter: __WEBPACK_IMPORTED_MODULE_7_prop_types___default.a.func.isRequired,

  /**
   * Number of rows to render above/below the visible section of the grid.
   * These rows can help for smoother scrolling on touch devices or browsers that send scroll events infrequently.
   */
  overscanRowCount: __WEBPACK_IMPORTED_MODULE_7_prop_types___default.a.number.isRequired,

  /**
   * ARIA role for the grid element.
   */
  role: __WEBPACK_IMPORTED_MODULE_7_prop_types___default.a.string,

  /**
   * Either a fixed row height (number) or a function that returns the height of a row given its index.
   * Should implement the following interface: ({ index: number }): number
   */
  rowHeight: __WEBPACK_IMPORTED_MODULE_7_prop_types___default.a.oneOfType([__WEBPACK_IMPORTED_MODULE_7_prop_types___default.a.number, __WEBPACK_IMPORTED_MODULE_7_prop_types___default.a.func]).isRequired,

  /**
   * Number of rows in grid.
   */
  rowCount: __WEBPACK_IMPORTED_MODULE_7_prop_types___default.a.number.isRequired,

  /** Wait this amount of time after the last scroll event before resetting Grid `pointer-events`. */
  scrollingResetTimeInterval: __WEBPACK_IMPORTED_MODULE_7_prop_types___default.a.number,

  /** Horizontal offset. */
  scrollLeft: __WEBPACK_IMPORTED_MODULE_7_prop_types___default.a.number,

  /**
   * Controls scroll-to-cell behavior of the Grid.
   * The default ("auto") scrolls the least amount possible to ensure that the specified cell is fully visible.
   * Use "start" to align cells to the top/left of the Grid and "end" to align bottom/right.
   */
  scrollToAlignment: __WEBPACK_IMPORTED_MODULE_7_prop_types___default.a.oneOf(['auto', 'end', 'start', 'center']).isRequired,

  /**
   * Column index to ensure visible (by forcefully scrolling if necessary)
   */
  scrollToColumn: __WEBPACK_IMPORTED_MODULE_7_prop_types___default.a.number.isRequired,

  /** Vertical offset. */
  scrollTop: __WEBPACK_IMPORTED_MODULE_7_prop_types___default.a.number,

  /**
   * Row index to ensure visible (by forcefully scrolling if necessary)
   */
  scrollToRow: __WEBPACK_IMPORTED_MODULE_7_prop_types___default.a.number.isRequired,

  /** Optional inline style */
  style: __WEBPACK_IMPORTED_MODULE_7_prop_types___default.a.object,

  /** Tab index for focus */
  tabIndex: __WEBPACK_IMPORTED_MODULE_7_prop_types___default.a.number,

  /**
   * Width of Grid; this property determines the number of visible (vs virtualized) columns.
   */
  width: __WEBPACK_IMPORTED_MODULE_7_prop_types___default.a.number.isRequired
} : void 0;
/* WEBPACK VAR INJECTION */}.call(__webpack_exports__, __webpack_require__(1)))

/***/ }),
/* 105 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return SCROLL_DIRECTION_BACKWARD; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return SCROLL_DIRECTION_FORWARD; });
/* unused harmony export SCROLL_DIRECTION_HORIZONTAL */
/* unused harmony export SCROLL_DIRECTION_VERTICAL */
/* harmony export (immutable) */ __webpack_exports__["c"] = defaultOverscanIndicesGetter;
var SCROLL_DIRECTION_BACKWARD = -1;
var SCROLL_DIRECTION_FORWARD = 1;

var SCROLL_DIRECTION_HORIZONTAL = 'horizontal';
var SCROLL_DIRECTION_VERTICAL = 'vertical';
/**
 * Calculates the number of cells to overscan before and after a specified range.
 * This function ensures that overscanning doesn't exceed the available cells.
 *
 * @param direction One of SCROLL_DIRECTION_HORIZONTAL or SCROLL_DIRECTION_VERTICAL
 * @param cellCount Number of rows or columns in the current axis
 * @param scrollDirection One of SCROLL_DIRECTION_BACKWARD or SCROLL_DIRECTION_FORWARD
 * @param overscanCellsCount Maximum number of cells to over-render in either direction
 * @param startIndex Begin of range of visible cells
 * @param stopIndex End of range of visible cells
 */
function defaultOverscanIndicesGetter(_ref) {
  var direction = _ref.direction,
      cellCount = _ref.cellCount,
      overscanCellsCount = _ref.overscanCellsCount,
      scrollDirection = _ref.scrollDirection,
      startIndex = _ref.startIndex,
      stopIndex = _ref.stopIndex;

  var overscanStartIndex = void 0;
  var overscanStopIndex = void 0;

  switch (scrollDirection) {
    case SCROLL_DIRECTION_FORWARD:
      overscanStartIndex = startIndex;
      overscanStopIndex = stopIndex + overscanCellsCount;
      break;
    case SCROLL_DIRECTION_BACKWARD:
      overscanStartIndex = startIndex - overscanCellsCount;
      overscanStopIndex = stopIndex;
      break;
  }

  return {
    overscanStartIndex: Math.max(0, overscanStartIndex),
    overscanStopIndex: Math.min(cellCount - 1, overscanStopIndex)
  };
}

/***/ }),
/* 106 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function(process) {/* harmony export (immutable) */ __webpack_exports__["a"] = defaultCellRangeRenderer;

/**
 * Default implementation of cellRangeRenderer used by Grid.
 * This renderer supports cell-caching while the user is scrolling.
 */
function defaultCellRangeRenderer(_ref) {
  var cellCache = _ref.cellCache,
      cellRenderer = _ref.cellRenderer,
      columnSizeAndPositionManager = _ref.columnSizeAndPositionManager,
      columnStartIndex = _ref.columnStartIndex,
      columnStopIndex = _ref.columnStopIndex,
      deferredMeasurementCache = _ref.deferredMeasurementCache,
      horizontalOffsetAdjustment = _ref.horizontalOffsetAdjustment,
      isScrolling = _ref.isScrolling,
      parent = _ref.parent,
      rowSizeAndPositionManager = _ref.rowSizeAndPositionManager,
      rowStartIndex = _ref.rowStartIndex,
      rowStopIndex = _ref.rowStopIndex,
      scrollLeft = _ref.scrollLeft,
      scrollTop = _ref.scrollTop,
      styleCache = _ref.styleCache,
      verticalOffsetAdjustment = _ref.verticalOffsetAdjustment,
      visibleColumnIndices = _ref.visibleColumnIndices,
      visibleRowIndices = _ref.visibleRowIndices;

  var deferredMode = typeof deferredMeasurementCache !== 'undefined';

  var renderedCells = [];

  // Browsers have native size limits for elements (eg Chrome 33M pixels, IE 1.5M pixes).
  // User cannot scroll beyond these size limitations.
  // In order to work around this, ScalingCellSizeAndPositionManager compresses offsets.
  // We should never cache styles for compressed offsets though as this can lead to bugs.
  // See issue #576 for more.
  var areOffsetsAdjusted = columnSizeAndPositionManager.areOffsetsAdjusted() || rowSizeAndPositionManager.areOffsetsAdjusted();

  var canCacheStyle = !isScrolling && !areOffsetsAdjusted;

  for (var rowIndex = rowStartIndex; rowIndex <= rowStopIndex; rowIndex++) {
    var rowDatum = rowSizeAndPositionManager.getSizeAndPositionOfCell(rowIndex);

    for (var columnIndex = columnStartIndex; columnIndex <= columnStopIndex; columnIndex++) {
      var columnDatum = columnSizeAndPositionManager.getSizeAndPositionOfCell(columnIndex);
      var isVisible = columnIndex >= visibleColumnIndices.start && columnIndex <= visibleColumnIndices.stop && rowIndex >= visibleRowIndices.start && rowIndex <= visibleRowIndices.stop;
      var key = rowIndex + '-' + columnIndex;
      var style = void 0;

      // Cache style objects so shallow-compare doesn't re-render unnecessarily.
      if (canCacheStyle && styleCache[key]) {
        style = styleCache[key];
      } else {
        // In deferred mode, cells will be initially rendered before we know their size.
        // Don't interfere with CellMeasurer's measurements by setting an invalid size.
        if (deferredMode && !deferredMeasurementCache.has(rowIndex, columnIndex)) {
          // Position not-yet-measured cells at top/left 0,0,
          // And give them width/height of 'auto' so they can grow larger than the parent Grid if necessary.
          // Positioning them further to the right/bottom influences their measured size.
          style = {
            height: 'auto',
            left: 0,
            position: 'absolute',
            top: 0,
            width: 'auto'
          };
        } else {
          style = {
            height: rowDatum.size,
            left: columnDatum.offset + horizontalOffsetAdjustment,
            position: 'absolute',
            top: rowDatum.offset + verticalOffsetAdjustment,
            width: columnDatum.size
          };

          styleCache[key] = style;
        }
      }

      var cellRendererParams = {
        columnIndex: columnIndex,
        isScrolling: isScrolling,
        isVisible: isVisible,
        key: key,
        parent: parent,
        rowIndex: rowIndex,
        style: style
      };

      var renderedCell = void 0;

      // Avoid re-creating cells while scrolling.
      // This can lead to the same cell being created many times and can cause performance issues for "heavy" cells.
      // If a scroll is in progress- cache and reuse cells.
      // This cache will be thrown away once scrolling completes.
      // However if we are scaling scroll positions and sizes, we should also avoid caching.
      // This is because the offset changes slightly as scroll position changes and caching leads to stale values.
      // For more info refer to issue #395
      if (isScrolling && !horizontalOffsetAdjustment && !verticalOffsetAdjustment) {
        if (!cellCache[key]) {
          cellCache[key] = cellRenderer(cellRendererParams);
        }

        renderedCell = cellCache[key];

        // If the user is no longer scrolling, don't cache cells.
        // This makes dynamic cell content difficult for users and would also lead to a heavier memory footprint.
      } else {
        renderedCell = cellRenderer(cellRendererParams);
      }

      if (renderedCell == null || renderedCell === false) {
        continue;
      }

      if (process.env.NODE_ENV !== 'production') {
        warnAboutMissingStyle(parent, renderedCell);
      }

      renderedCells.push(renderedCell);
    }
  }

  return renderedCells;
}

function warnAboutMissingStyle(parent, renderedCell) {
  if (process.env.NODE_ENV !== 'production') {
    if (renderedCell) {
      // If the direct child is a CellMeasurer, then we should check its child
      // See issue #611
      if (renderedCell.type && renderedCell.type.__internalCellMeasurerFlag) {
        renderedCell = renderedCell.props.children;
      }

      if (renderedCell && renderedCell.props && renderedCell.props.style === undefined && parent.__warnedAboutMissingStyle !== true) {
        parent.__warnedAboutMissingStyle = true;

        console.warn('Rendered cell should include style property for positioning.');
      }
    }
  }
}
/* WEBPACK VAR INJECTION */}.call(__webpack_exports__, __webpack_require__(1)))

/***/ }),
/* 107 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function(process) {/* unused harmony export isRangeVisible */
/* unused harmony export scanForUnloadedRanges */
/* unused harmony export forceUpdateReactVirtualizedComponent */
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_core_js_object_get_prototype_of__ = __webpack_require__(5);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_core_js_object_get_prototype_of___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_babel_runtime_core_js_object_get_prototype_of__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_classCallCheck__ = __webpack_require__(2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_classCallCheck___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_classCallCheck__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_createClass__ = __webpack_require__(4);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_createClass___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_createClass__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_babel_runtime_helpers_possibleConstructorReturn__ = __webpack_require__(6);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_babel_runtime_helpers_possibleConstructorReturn___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_3_babel_runtime_helpers_possibleConstructorReturn__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_babel_runtime_helpers_inherits__ = __webpack_require__(7);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_babel_runtime_helpers_inherits___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_4_babel_runtime_helpers_inherits__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5_react__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_5_react__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6_prop_types__ = __webpack_require__(3);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6_prop_types___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_6_prop_types__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7__utils_createCallbackMemoizer__ = __webpack_require__(70);
/**
 * Higher-order component that manages lazy-loading for "infinite" data.
 * This component decorates a virtual component and just-in-time prefetches rows as a user scrolls.
 * It is intended as a convenience component; fork it if you'd like finer-grained control over data-loading.
 */

var InfiniteLoader = function (_PureComponent) {
  __WEBPACK_IMPORTED_MODULE_4_babel_runtime_helpers_inherits___default()(InfiniteLoader, _PureComponent);

  function InfiniteLoader(props, context) {
    __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_classCallCheck___default()(this, InfiniteLoader);

    var _this = __WEBPACK_IMPORTED_MODULE_3_babel_runtime_helpers_possibleConstructorReturn___default()(this, (InfiniteLoader.__proto__ || __WEBPACK_IMPORTED_MODULE_0_babel_runtime_core_js_object_get_prototype_of___default()(InfiniteLoader)).call(this, props, context));

    _this._loadMoreRowsMemoizer = Object(__WEBPACK_IMPORTED_MODULE_7__utils_createCallbackMemoizer__["a" /* default */])();

    _this._onRowsRendered = _this._onRowsRendered.bind(_this);
    _this._registerChild = _this._registerChild.bind(_this);
    return _this;
  }

  __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_createClass___default()(InfiniteLoader, [{
    key: 'resetLoadMoreRowsCache',
    value: function resetLoadMoreRowsCache(autoReload) {
      this._loadMoreRowsMemoizer = Object(__WEBPACK_IMPORTED_MODULE_7__utils_createCallbackMemoizer__["a" /* default */])();

      if (autoReload) {
        this._doStuff(this._lastRenderedStartIndex, this._lastRenderedStopIndex);
      }
    }
  }, {
    key: 'render',
    value: function render() {
      var children = this.props.children;


      return children({
        onRowsRendered: this._onRowsRendered,
        registerChild: this._registerChild
      });
    }
  }, {
    key: '_loadUnloadedRanges',
    value: function _loadUnloadedRanges(unloadedRanges) {
      var _this2 = this;

      var loadMoreRows = this.props.loadMoreRows;


      unloadedRanges.forEach(function (unloadedRange) {
        var promise = loadMoreRows(unloadedRange);
        if (promise) {
          promise.then(function () {
            // Refresh the visible rows if any of them have just been loaded.
            // Otherwise they will remain in their unloaded visual state.
            if (isRangeVisible({
              lastRenderedStartIndex: _this2._lastRenderedStartIndex,
              lastRenderedStopIndex: _this2._lastRenderedStopIndex,
              startIndex: unloadedRange.startIndex,
              stopIndex: unloadedRange.stopIndex
            })) {
              if (_this2._registeredChild) {
                forceUpdateReactVirtualizedComponent(_this2._registeredChild, _this2._lastRenderedStartIndex);
              }
            }
          });
        }
      });
    }
  }, {
    key: '_onRowsRendered',
    value: function _onRowsRendered(_ref) {
      var startIndex = _ref.startIndex,
          stopIndex = _ref.stopIndex;

      this._lastRenderedStartIndex = startIndex;
      this._lastRenderedStopIndex = stopIndex;

      this._doStuff(startIndex, stopIndex);
    }
  }, {
    key: '_doStuff',
    value: function _doStuff(startIndex, stopIndex) {
      var _this3 = this;

      var _props = this.props,
          isRowLoaded = _props.isRowLoaded,
          minimumBatchSize = _props.minimumBatchSize,
          rowCount = _props.rowCount,
          threshold = _props.threshold;


      var unloadedRanges = scanForUnloadedRanges({
        isRowLoaded: isRowLoaded,
        minimumBatchSize: minimumBatchSize,
        rowCount: rowCount,
        startIndex: Math.max(0, startIndex - threshold),
        stopIndex: Math.min(rowCount - 1, stopIndex + threshold)
      });

      // For memoize comparison
      var squashedUnloadedRanges = unloadedRanges.reduce(function (reduced, unloadedRange) {
        return reduced.concat([unloadedRange.startIndex, unloadedRange.stopIndex]);
      }, []);

      this._loadMoreRowsMemoizer({
        callback: function callback() {
          _this3._loadUnloadedRanges(unloadedRanges);
        },
        indices: { squashedUnloadedRanges: squashedUnloadedRanges }
      });
    }
  }, {
    key: '_registerChild',
    value: function _registerChild(registeredChild) {
      this._registeredChild = registeredChild;
    }
  }]);

  return InfiniteLoader;
}(__WEBPACK_IMPORTED_MODULE_5_react__["PureComponent"]);

/**
 * Determines if the specified start/stop range is visible based on the most recently rendered range.
 */


InfiniteLoader.defaultProps = {
  minimumBatchSize: 10,
  rowCount: 0,
  threshold: 15
};
/* harmony default export */ __webpack_exports__["a"] = (InfiniteLoader);
process.env.NODE_ENV !== "production" ? InfiniteLoader.propTypes = {
  /**
   * Function responsible for rendering a virtualized component.
   * This function should implement the following signature:
   * ({ onRowsRendered, registerChild }) => PropTypes.element
   *
   * The specified :onRowsRendered function should be passed through to the child's :onRowsRendered property.
   * The :registerChild callback should be set as the virtualized component's :ref.
   */
  children: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.func.isRequired,

  /**
   * Function responsible for tracking the loaded state of each row.
   * It should implement the following signature: ({ index: number }): boolean
   */
  isRowLoaded: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.func.isRequired,

  /**
   * Callback to be invoked when more rows must be loaded.
   * It should implement the following signature: ({ startIndex, stopIndex }): Promise
   * The returned Promise should be resolved once row data has finished loading.
   * It will be used to determine when to refresh the list with the newly-loaded data.
   * This callback may be called multiple times in reaction to a single scroll event.
   */
  loadMoreRows: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.func.isRequired,

  /**
   * Minimum number of rows to be loaded at a time.
   * This property can be used to batch requests to reduce HTTP requests.
   */
  minimumBatchSize: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.number.isRequired,

  /**
   * Number of rows in list; can be arbitrary high number if actual number is unknown.
   */
  rowCount: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.number.isRequired,

  /**
   * Threshold at which to pre-fetch data.
   * A threshold X means that data will start loading when a user scrolls within X rows.
   * This value defaults to 15.
   */
  threshold: __WEBPACK_IMPORTED_MODULE_6_prop_types___default.a.number.isRequired
} : void 0;
function isRangeVisible(_ref2) {
  var lastRenderedStartIndex = _ref2.lastRenderedStartIndex,
      lastRenderedStopIndex = _ref2.lastRenderedStopIndex,
      startIndex = _ref2.startIndex,
      stopIndex = _ref2.stopIndex;

  return !(startIndex > lastRenderedStopIndex || stopIndex < lastRenderedStartIndex);
}

/**
 * Returns all of the ranges within a larger range that contain unloaded rows.
 */
function scanForUnloadedRanges(_ref3) {
  var isRowLoaded = _ref3.isRowLoaded,
      minimumBatchSize = _ref3.minimumBatchSize,
      rowCount = _ref3.rowCount,
      startIndex = _ref3.startIndex,
      stopIndex = _ref3.stopIndex;

  var unloadedRanges = [];

  var rangeStartIndex = null;
  var rangeStopIndex = null;

  for (var index = startIndex; index <= stopIndex; index++) {
    var loaded = isRowLoaded({ index: index });

    if (!loaded) {
      rangeStopIndex = index;
      if (rangeStartIndex === null) {
        rangeStartIndex = index;
      }
    } else if (rangeStopIndex !== null) {
      unloadedRanges.push({
        startIndex: rangeStartIndex,
        stopIndex: rangeStopIndex
      });

      rangeStartIndex = rangeStopIndex = null;
    }
  }

  // If :rangeStopIndex is not null it means we haven't ran out of unloaded rows.
  // Scan forward to try filling our :minimumBatchSize.
  if (rangeStopIndex !== null) {
    var potentialStopIndex = Math.min(Math.max(rangeStopIndex, rangeStartIndex + minimumBatchSize - 1), rowCount - 1);

    for (var _index = rangeStopIndex + 1; _index <= potentialStopIndex; _index++) {
      if (!isRowLoaded({ index: _index })) {
        rangeStopIndex = _index;
      } else {
        break;
      }
    }

    unloadedRanges.push({
      startIndex: rangeStartIndex,
      stopIndex: rangeStopIndex
    });
  }

  // Check to see if our first range ended prematurely.
  // In this case we should scan backwards to try filling our :minimumBatchSize.
  if (unloadedRanges.length) {
    var firstUnloadedRange = unloadedRanges[0];

    while (firstUnloadedRange.stopIndex - firstUnloadedRange.startIndex + 1 < minimumBatchSize && firstUnloadedRange.startIndex > 0) {
      var _index2 = firstUnloadedRange.startIndex - 1;

      if (!isRowLoaded({ index: _index2 })) {
        firstUnloadedRange.startIndex = _index2;
      } else {
        break;
      }
    }
  }

  return unloadedRanges;
}

/**
 * Since RV components use shallowCompare we need to force a render (even though props haven't changed).
 * However InfiniteLoader may wrap a Grid or it may wrap a Table or List.
 * In the first case the built-in React forceUpdate() method is sufficient to force a re-render,
 * But in the latter cases we need to use the RV-specific forceUpdateGrid() method.
 * Else the inner Grid will not be re-rendered and visuals may be stale.
 *
 * Additionally, while a Grid is scrolling the cells can be cached,
 * So it's important to invalidate that cache by recalculating sizes
 * before forcing a rerender.
 */
function forceUpdateReactVirtualizedComponent(component) {
  var currentIndex = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;

  var recomputeSize = typeof component.recomputeGridSize === 'function' ? component.recomputeGridSize : component.recomputeRowHeights;

  if (recomputeSize) {
    recomputeSize.call(component, currentIndex);
  } else {
    component.forceUpdate();
  }
}
/* WEBPACK VAR INJECTION */}.call(__webpack_exports__, __webpack_require__(1)))

/***/ }),
/* 108 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function(process) {/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_core_js_object_get_own_property_descriptor__ = __webpack_require__(218);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_core_js_object_get_own_property_descriptor___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_babel_runtime_core_js_object_get_own_property_descriptor__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_objectWithoutProperties__ = __webpack_require__(37);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_objectWithoutProperties___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_objectWithoutProperties__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_extends__ = __webpack_require__(12);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_extends___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_extends__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_babel_runtime_core_js_object_get_prototype_of__ = __webpack_require__(5);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_babel_runtime_core_js_object_get_prototype_of___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_3_babel_runtime_core_js_object_get_prototype_of__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_babel_runtime_helpers_classCallCheck__ = __webpack_require__(2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_babel_runtime_helpers_classCallCheck___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_4_babel_runtime_helpers_classCallCheck__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5_babel_runtime_helpers_createClass__ = __webpack_require__(4);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5_babel_runtime_helpers_createClass___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_5_babel_runtime_helpers_createClass__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6_babel_runtime_helpers_possibleConstructorReturn__ = __webpack_require__(6);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6_babel_runtime_helpers_possibleConstructorReturn___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_6_babel_runtime_helpers_possibleConstructorReturn__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7_babel_runtime_helpers_inherits__ = __webpack_require__(7);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7_babel_runtime_helpers_inherits___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_7_babel_runtime_helpers_inherits__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_8__Grid__ = __webpack_require__(38);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_9_prop_types__ = __webpack_require__(3);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_9_prop_types___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_9_prop_types__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_10_react__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_10_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_10_react__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_11_classnames__ = __webpack_require__(24);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_11_classnames___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_11_classnames__);
/**
 * It is inefficient to create and manage a large list of DOM elements within a scrolling container
 * if only a few of those elements are visible. The primary purpose of this component is to improve
 * performance by only rendering the DOM nodes that a user is able to see based on their current
 * scroll position.
 *
 * This component renders a virtualized list of elements with either fixed or dynamic heights.
 */

var List = function (_PureComponent) {
  __WEBPACK_IMPORTED_MODULE_7_babel_runtime_helpers_inherits___default()(List, _PureComponent);

  function List(props, context) {
    __WEBPACK_IMPORTED_MODULE_4_babel_runtime_helpers_classCallCheck___default()(this, List);

    var _this = __WEBPACK_IMPORTED_MODULE_6_babel_runtime_helpers_possibleConstructorReturn___default()(this, (List.__proto__ || __WEBPACK_IMPORTED_MODULE_3_babel_runtime_core_js_object_get_prototype_of___default()(List)).call(this, props, context));

    _this._cellRenderer = _this._cellRenderer.bind(_this);
    _this._onScroll = _this._onScroll.bind(_this);
    _this._onSectionRendered = _this._onSectionRendered.bind(_this);
    _this._setRef = _this._setRef.bind(_this);
    return _this;
  }

  __WEBPACK_IMPORTED_MODULE_5_babel_runtime_helpers_createClass___default()(List, [{
    key: 'forceUpdateGrid',
    value: function forceUpdateGrid() {
      this.Grid.forceUpdate();
    }

    /** See Grid#getOffsetForCell */

  }, {
    key: 'getOffsetForRow',
    value: function getOffsetForRow(_ref) {
      var alignment = _ref.alignment,
          index = _ref.index;

      var _Grid$getOffsetForCel = this.Grid.getOffsetForCell({
        alignment: alignment,
        rowIndex: index
      }),
          scrollTop = _Grid$getOffsetForCel.scrollTop;

      return scrollTop;
    }

    /** See Grid#measureAllCells */

  }, {
    key: 'measureAllRows',
    value: function measureAllRows() {
      this.Grid.measureAllCells();
    }

    /** See Grid#recomputeGridSize */

  }, {
    key: 'recomputeRowHeights',
    value: function recomputeRowHeights() {
      var index = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 0;

      this.Grid.recomputeGridSize({
        rowIndex: index
      });
    }

    /** See Grid#scrollToPosition */

  }, {
    key: 'scrollToPosition',
    value: function scrollToPosition() {
      var scrollTop = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 0;

      this.Grid.scrollToPosition({ scrollTop: scrollTop });
    }

    /** See Grid#scrollToCell */

  }, {
    key: 'scrollToRow',
    value: function scrollToRow() {
      var index = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 0;

      this.Grid.scrollToCell({
        columnIndex: 0,
        rowIndex: index
      });
    }
  }, {
    key: 'render',
    value: function render() {
      var _props = this.props,
          className = _props.className,
          noRowsRenderer = _props.noRowsRenderer,
          scrollToIndex = _props.scrollToIndex,
          width = _props.width;


      var classNames = __WEBPACK_IMPORTED_MODULE_11_classnames___default()('ReactVirtualized__List', className);

      return __WEBPACK_IMPORTED_MODULE_10_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_8__Grid__["c" /* default */], __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_extends___default()({}, this.props, {
        autoContainerWidth: true,
        cellRenderer: this._cellRenderer,
        className: classNames,
        columnWidth: width,
        columnCount: 1,
        noContentRenderer: noRowsRenderer,
        onScroll: this._onScroll,
        onSectionRendered: this._onSectionRendered,
        ref: this._setRef,
        scrollToRow: scrollToIndex
      }));
    }
  }, {
    key: '_cellRenderer',
    value: function _cellRenderer(_ref2) {
      var rowIndex = _ref2.rowIndex,
          style = _ref2.style,
          rest = __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_objectWithoutProperties___default()(_ref2, ['rowIndex', 'style']);

      var rowRenderer = this.props.rowRenderer;

      // TRICKY The style object is sometimes cached by Grid.
      // This prevents new style objects from bypassing shallowCompare().
      // However as of React 16, style props are auto-frozen (at least in dev mode)
      // Check to make sure we can still modify the style before proceeding.
      // https://github.com/facebook/react/commit/977357765b44af8ff0cfea327866861073095c12#commitcomment-20648713

      var _Object$getOwnPropert = __WEBPACK_IMPORTED_MODULE_0_babel_runtime_core_js_object_get_own_property_descriptor___default()(style, 'width'),
          writable = _Object$getOwnPropert.writable;

      if (writable) {
        // By default, List cells should be 100% width.
        // This prevents them from flowing under a scrollbar (if present).
        style.width = '100%';
      }

      return rowRenderer(__WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_extends___default()({
        index: rowIndex,
        style: style
      }, rest));
    }
  }, {
    key: '_setRef',
    value: function _setRef(ref) {
      this.Grid = ref;
    }
  }, {
    key: '_onScroll',
    value: function _onScroll(_ref3) {
      var clientHeight = _ref3.clientHeight,
          scrollHeight = _ref3.scrollHeight,
          scrollTop = _ref3.scrollTop;
      var onScroll = this.props.onScroll;


      onScroll({ clientHeight: clientHeight, scrollHeight: scrollHeight, scrollTop: scrollTop });
    }
  }, {
    key: '_onSectionRendered',
    value: function _onSectionRendered(_ref4) {
      var rowOverscanStartIndex = _ref4.rowOverscanStartIndex,
          rowOverscanStopIndex = _ref4.rowOverscanStopIndex,
          rowStartIndex = _ref4.rowStartIndex,
          rowStopIndex = _ref4.rowStopIndex;
      var onRowsRendered = this.props.onRowsRendered;


      onRowsRendered({
        overscanStartIndex: rowOverscanStartIndex,
        overscanStopIndex: rowOverscanStopIndex,
        startIndex: rowStartIndex,
        stopIndex: rowStopIndex
      });
    }
  }]);

  return List;
}(__WEBPACK_IMPORTED_MODULE_10_react__["PureComponent"]);

List.defaultProps = {
  estimatedRowSize: 30,
  noRowsRenderer: function noRowsRenderer() {
    return null;
  },
  onRowsRendered: function onRowsRendered() {
    return null;
  },
  onScroll: function onScroll() {
    return null;
  },
  overscanIndicesGetter: __WEBPACK_IMPORTED_MODULE_8__Grid__["b" /* accessibilityOverscanIndicesGetter */],
  overscanRowCount: 10,
  scrollToAlignment: 'auto',
  scrollToIndex: -1,
  style: {}
};
/* harmony default export */ __webpack_exports__["a"] = (List);
process.env.NODE_ENV !== "production" ? List.propTypes = {
  'aria-label': __WEBPACK_IMPORTED_MODULE_9_prop_types___default.a.string,

  /**
   * Removes fixed height from the scrollingContainer so that the total height
   * of rows can stretch the window. Intended for use with WindowScroller
   */
  autoHeight: __WEBPACK_IMPORTED_MODULE_9_prop_types___default.a.bool,

  /** Optional CSS class name */
  className: __WEBPACK_IMPORTED_MODULE_9_prop_types___default.a.string,

  /**
   * Used to estimate the total height of a List before all of its rows have actually been measured.
   * The estimated total height is adjusted as rows are rendered.
   */
  estimatedRowSize: __WEBPACK_IMPORTED_MODULE_9_prop_types___default.a.number.isRequired,

  /** Height constraint for list (determines how many actual rows are rendered) */
  height: __WEBPACK_IMPORTED_MODULE_9_prop_types___default.a.number.isRequired,

  /** Optional renderer to be used in place of rows when rowCount is 0 */
  noRowsRenderer: __WEBPACK_IMPORTED_MODULE_9_prop_types___default.a.func.isRequired,

  /**
   * Callback invoked with information about the slice of rows that were just rendered.
   * ({ startIndex, stopIndex }): void
   */
  onRowsRendered: __WEBPACK_IMPORTED_MODULE_9_prop_types___default.a.func.isRequired,

  /**
   * Callback invoked whenever the scroll offset changes within the inner scrollable region.
   * This callback can be used to sync scrolling between lists, tables, or grids.
   * ({ clientHeight, scrollHeight, scrollTop }): void
   */
  onScroll: __WEBPACK_IMPORTED_MODULE_9_prop_types___default.a.func.isRequired,

  /** See Grid#overscanIndicesGetter */
  overscanIndicesGetter: __WEBPACK_IMPORTED_MODULE_9_prop_types___default.a.func.isRequired,

  /**
   * Number of rows to render above/below the visible bounds of the list.
   * These rows can help for smoother scrolling on touch devices.
   */
  overscanRowCount: __WEBPACK_IMPORTED_MODULE_9_prop_types___default.a.number.isRequired,

  /**
   * Either a fixed row height (number) or a function that returns the height of a row given its index.
   * ({ index: number }): number
   */
  rowHeight: __WEBPACK_IMPORTED_MODULE_9_prop_types___default.a.oneOfType([__WEBPACK_IMPORTED_MODULE_9_prop_types___default.a.number, __WEBPACK_IMPORTED_MODULE_9_prop_types___default.a.func]).isRequired,

  /** Responsible for rendering a row given an index; ({ index: number }): node */
  rowRenderer: __WEBPACK_IMPORTED_MODULE_9_prop_types___default.a.func.isRequired,

  /** Number of rows in list. */
  rowCount: __WEBPACK_IMPORTED_MODULE_9_prop_types___default.a.number.isRequired,

  /** See Grid#scrollToAlignment */
  scrollToAlignment: __WEBPACK_IMPORTED_MODULE_9_prop_types___default.a.oneOf(['auto', 'end', 'start', 'center']).isRequired,

  /** Row index to ensure visible (by forcefully scrolling if necessary) */
  scrollToIndex: __WEBPACK_IMPORTED_MODULE_9_prop_types___default.a.number.isRequired,

  /** Vertical offset. */
  scrollTop: __WEBPACK_IMPORTED_MODULE_9_prop_types___default.a.number,

  /** Optional inline style */
  style: __WEBPACK_IMPORTED_MODULE_9_prop_types___default.a.object,

  /** Tab index for focus */
  tabIndex: __WEBPACK_IMPORTED_MODULE_9_prop_types___default.a.number,

  /** Width of list */
  width: __WEBPACK_IMPORTED_MODULE_9_prop_types___default.a.number.isRequired
} : void 0;
/* WEBPACK VAR INJECTION */}.call(__webpack_exports__, __webpack_require__(1)))

/***/ }),
/* 109 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* unused harmony export DEFAULT_SCROLLING_RESET_TIME_INTERVAL */
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_extends__ = __webpack_require__(12);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_extends___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_extends__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_babel_runtime_core_js_object_get_prototype_of__ = __webpack_require__(5);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_babel_runtime_core_js_object_get_prototype_of___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_babel_runtime_core_js_object_get_prototype_of__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_classCallCheck__ = __webpack_require__(2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_classCallCheck___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_classCallCheck__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_babel_runtime_helpers_createClass__ = __webpack_require__(4);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_babel_runtime_helpers_createClass___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_3_babel_runtime_helpers_createClass__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_babel_runtime_helpers_possibleConstructorReturn__ = __webpack_require__(6);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_babel_runtime_helpers_possibleConstructorReturn___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_4_babel_runtime_helpers_possibleConstructorReturn__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5_babel_runtime_helpers_inherits__ = __webpack_require__(7);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5_babel_runtime_helpers_inherits___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_5_babel_runtime_helpers_inherits__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6_react__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_6_react__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7_classnames__ = __webpack_require__(24);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7_classnames___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_7_classnames__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_8__PositionCache__ = __webpack_require__(222);
var emptyObject = {};

/**
 * Specifies the number of miliseconds during which to disable pointer events while a scroll is in progress.
 * This improves performance and makes scrolling smoother.
 */
var DEFAULT_SCROLLING_RESET_TIME_INTERVAL = 150;

/**
 * This component efficiently displays arbitrarily positioned cells using windowing techniques.
 * Cell position is determined by an injected `cellPositioner` property.
 * Windowing is vertical; this component does not support horizontal scrolling.
 *
 * Rendering occurs in two phases:
 * 1) First pass uses estimated cell sizes (provided by the cache) to determine how many cells to measure in a batch.
 *    Batch size is chosen using a fast, naive layout algorithm that stacks images in order until the viewport has been filled.
 *    After measurement is complete (componentDidMount or componentDidUpdate) this component evaluates positioned cells
 *    in order to determine if another measurement pass is required (eg if actual cell sizes were less than estimated sizes).
 *    All measurements are permanently cached (keyed by `keyMapper`) for performance purposes.
 * 2) Second pass uses the external `cellPositioner` to layout cells.
 *    At this time the positioner has access to cached size measurements for all cells.
 *    The positions it returns are cached by Masonry for fast access later.
 *    Phase one is repeated if the user scrolls beyond the current layout's bounds.
 *    If the layout is invalidated due to eg a resize, cached positions can be cleared using `recomputeCellPositions()`.
 *
 * Animation constraints:
 *   Simple animations are supported (eg translate/slide into place on initial reveal).
 *   More complex animations are not (eg flying from one position to another on resize).
 *
 * Layout constraints:
 *   This component supports multi-column layout.
 *   The height of each item may vary.
 *   The width of each item must not exceed the width of the column it is "in".
 *   The left position of all items within a column must align.
 *   (Items may not span multiple columns.)
 */

var Masonry = function (_PureComponent) {
  __WEBPACK_IMPORTED_MODULE_5_babel_runtime_helpers_inherits___default()(Masonry, _PureComponent);

  function Masonry(props, context) {
    __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_classCallCheck___default()(this, Masonry);

    var _this = __WEBPACK_IMPORTED_MODULE_4_babel_runtime_helpers_possibleConstructorReturn___default()(this, (Masonry.__proto__ || __WEBPACK_IMPORTED_MODULE_1_babel_runtime_core_js_object_get_prototype_of___default()(Masonry)).call(this, props, context));

    _this._invalidateOnUpdateStartIndex = null;
    _this._invalidateOnUpdateStopIndex = null;
    _this._positionCache = new __WEBPACK_IMPORTED_MODULE_8__PositionCache__["a" /* default */]();
    _this._startIndex = null;
    _this._startIndexMemoized = null;
    _this._stopIndex = null;
    _this._stopIndexMemoized = null;


    _this.state = {
      isScrolling: false,
      scrollTop: 0
    };

    _this._debounceResetIsScrollingCallback = _this._debounceResetIsScrollingCallback.bind(_this);
    _this._setScrollingContainerRef = _this._setScrollingContainerRef.bind(_this);
    _this._onScroll = _this._onScroll.bind(_this);
    return _this;
  }

  __WEBPACK_IMPORTED_MODULE_3_babel_runtime_helpers_createClass___default()(Masonry, [{
    key: 'clearCellPositions',
    value: function clearCellPositions() {
      this._positionCache = new __WEBPACK_IMPORTED_MODULE_8__PositionCache__["a" /* default */]();
      this.forceUpdate();
    }

    // HACK This method signature was intended for Grid

  }, {
    key: 'invalidateCellSizeAfterRender',
    value: function invalidateCellSizeAfterRender(_ref) {
      var index = _ref.rowIndex;

      if (this._invalidateOnUpdateStartIndex === null) {
        this._invalidateOnUpdateStartIndex = index;
        this._invalidateOnUpdateStopIndex = index;
      } else {
        this._invalidateOnUpdateStartIndex = Math.min(this._invalidateOnUpdateStartIndex, index);
        this._invalidateOnUpdateStopIndex = Math.max(this._invalidateOnUpdateStopIndex, index);
      }
    }
  }, {
    key: 'recomputeCellPositions',
    value: function recomputeCellPositions() {
      var stopIndex = this._positionCache.count - 1;

      this._positionCache = new __WEBPACK_IMPORTED_MODULE_8__PositionCache__["a" /* default */]();
      this._populatePositionCache(0, stopIndex);

      this.forceUpdate();
    }
  }, {
    key: 'componentDidMount',
    value: function componentDidMount() {
      this._checkInvalidateOnUpdate();
      this._invokeOnScrollCallback();
      this._invokeOnCellsRenderedCallback();
    }
  }, {
    key: 'componentDidUpdate',
    value: function componentDidUpdate(prevProps, prevState) {
      this._checkInvalidateOnUpdate();
      this._invokeOnScrollCallback();
      this._invokeOnCellsRenderedCallback();
    }
  }, {
    key: 'componentWillUnmount',
    value: function componentWillUnmount() {
      if (this._debounceResetIsScrollingId) {
        clearTimeout(this._debounceResetIsScrollingId);
      }
    }
  }, {
    key: 'componentWillReceiveProps',
    value: function componentWillReceiveProps(nextProps) {
      var scrollTop = this.props.scrollTop;


      if (scrollTop !== nextProps.scrollTop) {
        this._debounceResetIsScrolling();

        this.setState({
          isScrolling: true,
          scrollTop: nextProps.scrollTop
        });
      }
    }
  }, {
    key: 'render',
    value: function render() {
      var _this2 = this;

      var _props = this.props,
          autoHeight = _props.autoHeight,
          cellCount = _props.cellCount,
          cellMeasurerCache = _props.cellMeasurerCache,
          cellRenderer = _props.cellRenderer,
          className = _props.className,
          height = _props.height,
          id = _props.id,
          keyMapper = _props.keyMapper,
          overscanByPixels = _props.overscanByPixels,
          role = _props.role,
          style = _props.style,
          tabIndex = _props.tabIndex,
          width = _props.width;
      var _state = this.state,
          isScrolling = _state.isScrolling,
          scrollTop = _state.scrollTop;


      var children = [];

      var estimateTotalHeight = this._getEstimatedTotalHeight();

      var shortestColumnSize = this._positionCache.shortestColumnSize;
      var measuredCellCount = this._positionCache.count;

      // We need to measure more cells before layout
      if (shortestColumnSize < scrollTop + height + overscanByPixels && measuredCellCount < cellCount) {
        var batchSize = Math.min(cellCount - measuredCellCount, Math.ceil((scrollTop + height + overscanByPixels - shortestColumnSize) / cellMeasurerCache.defaultHeight * width / cellMeasurerCache.defaultWidth));

        for (var _index = measuredCellCount; _index < measuredCellCount + batchSize; _index++) {
          children.push(cellRenderer({
            index: _index,
            isScrolling: isScrolling,
            key: keyMapper(_index),
            parent: this,
            style: {
              width: cellMeasurerCache.getWidth(_index)
            }
          }));
        }
      } else {
        (function () {
          var stopIndex = void 0;
          var startIndex = void 0;

          _this2._positionCache.range(scrollTop - overscanByPixels, height + overscanByPixels, function (index, left, top) {
            if (typeof startIndex === 'undefined') {
              startIndex = index;
              stopIndex = index;
            } else {
              startIndex = Math.min(startIndex, index);
              stopIndex = Math.max(stopIndex, index);
            }

            children.push(cellRenderer({
              index: index,
              isScrolling: isScrolling,
              key: keyMapper(index),
              parent: _this2,
              style: {
                height: cellMeasurerCache.getHeight(index),
                left: left,
                position: 'absolute',
                top: top,
                width: cellMeasurerCache.getWidth(index)
              }
            }));

            _this2._startIndex = startIndex;
            _this2._stopIndex = stopIndex;
          });
        })();
      }

      return __WEBPACK_IMPORTED_MODULE_6_react___default.a.createElement(
        'div',
        {
          ref: this._setScrollingContainerRef,
          'aria-label': this.props['aria-label'],
          className: __WEBPACK_IMPORTED_MODULE_7_classnames___default()('ReactVirtualized__Masonry', className),
          id: id,
          onScroll: this._onScroll,
          role: role,
          style: __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_extends___default()({
            boxSizing: 'border-box',
            direction: 'ltr',
            height: autoHeight ? 'auto' : height,
            overflowX: 'hidden',
            overflowY: estimateTotalHeight < height ? 'hidden' : 'auto',
            position: 'relative',
            width: width,
            WebkitOverflowScrolling: 'touch',
            willChange: 'transform'
          }, style),
          tabIndex: tabIndex
        },
        __WEBPACK_IMPORTED_MODULE_6_react___default.a.createElement(
          'div',
          {
            className: 'ReactVirtualized__Masonry__innerScrollContainer',
            style: {
              width: '100%',
              height: estimateTotalHeight,
              maxWidth: '100%',
              maxHeight: estimateTotalHeight,
              overflow: 'hidden',
              pointerEvents: isScrolling ? 'none' : '',
              position: 'relative'
            }
          },
          children
        )
      );
    }
  }, {
    key: '_checkInvalidateOnUpdate',
    value: function _checkInvalidateOnUpdate() {
      if (typeof this._invalidateOnUpdateStartIndex === 'number') {
        var _startIndex = this._invalidateOnUpdateStartIndex;
        var _stopIndex = this._invalidateOnUpdateStopIndex;

        this._invalidateOnUpdateStartIndex = null;
        this._invalidateOnUpdateStopIndex = null;

        // Query external layout logic for position of newly-measured cells
        this._populatePositionCache(_startIndex, _stopIndex);

        this.forceUpdate();
      }
    }
  }, {
    key: '_debounceResetIsScrolling',
    value: function _debounceResetIsScrolling() {
      var scrollingResetTimeInterval = this.props.scrollingResetTimeInterval;


      if (this._debounceResetIsScrollingId) {
        clearTimeout(this._debounceResetIsScrollingId);
      }

      this._debounceResetIsScrollingId = setTimeout(this._debounceResetIsScrollingCallback, scrollingResetTimeInterval);
    }
  }, {
    key: '_debounceResetIsScrollingCallback',
    value: function _debounceResetIsScrollingCallback() {
      this.setState({
        isScrolling: false
      });
    }
  }, {
    key: '_getEstimatedTotalHeight',
    value: function _getEstimatedTotalHeight() {
      var _props2 = this.props,
          cellCount = _props2.cellCount,
          cellMeasurerCache = _props2.cellMeasurerCache,
          width = _props2.width;


      var estimatedColumnCount = Math.floor(width / cellMeasurerCache.defaultWidth);

      return this._positionCache.estimateTotalHeight(cellCount, estimatedColumnCount, cellMeasurerCache.defaultHeight);
    }
  }, {
    key: '_invokeOnScrollCallback',
    value: function _invokeOnScrollCallback() {
      var _props3 = this.props,
          height = _props3.height,
          onScroll = _props3.onScroll;
      var scrollTop = this.state.scrollTop;


      if (this._onScrollMemoized !== scrollTop) {
        onScroll({
          clientHeight: height,
          scrollHeight: this._getEstimatedTotalHeight(),
          scrollTop: scrollTop
        });

        this._onScrollMemoized = scrollTop;
      }
    }
  }, {
    key: '_invokeOnCellsRenderedCallback',
    value: function _invokeOnCellsRenderedCallback() {
      if (this._startIndexMemoized !== this._startIndex || this._stopIndexMemoized !== this._stopIndex) {
        var _onCellsRendered = this.props.onCellsRendered;


        _onCellsRendered({
          startIndex: this._startIndex,
          stopIndex: this._stopIndex
        });

        this._startIndexMemoized = this._startIndex;
        this._stopIndexMemoized = this._stopIndex;
      }
    }
  }, {
    key: '_populatePositionCache',
    value: function _populatePositionCache(startIndex, stopIndex) {
      var _props4 = this.props,
          cellMeasurerCache = _props4.cellMeasurerCache,
          cellPositioner = _props4.cellPositioner;


      for (var _index2 = startIndex; _index2 <= stopIndex; _index2++) {
        var _cellPositioner = cellPositioner(_index2),
            _left = _cellPositioner.left,
            _top = _cellPositioner.top;

        this._positionCache.setPosition(_index2, _left, _top, cellMeasurerCache.getHeight(_index2));
      }
    }
  }, {
    key: '_setScrollingContainerRef',
    value: function _setScrollingContainerRef(ref) {
      this._scrollingContainer = ref;
    }
  }, {
    key: '_onScroll',
    value: function _onScroll(event) {
      var height = this.props.height;


      var eventScrollTop = event.target.scrollTop;

      // When this component is shrunk drastically, React dispatches a series of back-to-back scroll events,
      // Gradually converging on a scrollTop that is within the bounds of the new, smaller height.
      // This causes a series of rapid renders that is slow for long lists.
      // We can avoid that by doing some simple bounds checking to ensure that scroll offsets never exceed their bounds.
      var scrollTop = Math.min(Math.max(0, this._getEstimatedTotalHeight() - height), eventScrollTop);

      // On iOS, we can arrive at negative offsets by swiping past the start or end.
      // Avoid re-rendering in this case as it can cause problems; see #532 for more.
      if (eventScrollTop !== scrollTop) {
        return;
      }

      // Prevent pointer events from interrupting a smooth scroll
      this._debounceResetIsScrolling();

      // Certain devices (like Apple touchpad) rapid-fire duplicate events.
      // Don't force a re-render if this is the case.
      // The mouse may move faster then the animation frame does.
      // Use requestAnimationFrame to avoid over-updating.
      if (this.state.scrollTop !== scrollTop) {
        this.setState({
          isScrolling: true,
          scrollTop: scrollTop
        });
      }
    }
  }]);

  return Masonry;
}(__WEBPACK_IMPORTED_MODULE_6_react__["PureComponent"]);

Masonry.defaultProps = {
  autoHeight: false,
  keyMapper: identity,
  onCellsRendered: noop,
  onScroll: noop,
  overscanByPixels: 20,
  role: 'grid',
  scrollingResetTimeInterval: DEFAULT_SCROLLING_RESET_TIME_INTERVAL,
  style: emptyObject,
  tabIndex: 0
};
/* harmony default export */ __webpack_exports__["a"] = (Masonry);


function identity(value) {
  return value;
}

function noop() {}

/***/ }),
/* 110 */
/***/ (function(module, exports, __webpack_require__) {

// getting tag from 19.1.3.6 Object.prototype.toString()
var cof = __webpack_require__(62);
var TAG = __webpack_require__(10)('toStringTag');
// ES3 wrong here
var ARG = cof(function () { return arguments; }()) == 'Arguments';

// fallback for IE11 Script Access Denied error
var tryGet = function (it, key) {
  try {
    return it[key];
  } catch (e) { /* empty */ }
};

module.exports = function (it) {
  var O, T, B;
  return it === undefined ? 'Undefined' : it === null ? 'Null'
    // @@toStringTag case
    : typeof (T = tryGet(O = Object(it), TAG)) == 'string' ? T
    // builtinTag case
    : ARG ? cof(O)
    // ES3 arguments fallback
    : (B = cof(O)) == 'Object' && typeof O.callee == 'function' ? 'Arguments' : B;
};


/***/ }),
/* 111 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function(process) {/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_extends__ = __webpack_require__(12);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_extends___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_extends__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_objectWithoutProperties__ = __webpack_require__(37);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_objectWithoutProperties___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_objectWithoutProperties__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_babel_runtime_core_js_object_get_prototype_of__ = __webpack_require__(5);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_babel_runtime_core_js_object_get_prototype_of___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2_babel_runtime_core_js_object_get_prototype_of__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_babel_runtime_helpers_classCallCheck__ = __webpack_require__(2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_babel_runtime_helpers_classCallCheck___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_3_babel_runtime_helpers_classCallCheck__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_babel_runtime_helpers_createClass__ = __webpack_require__(4);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_babel_runtime_helpers_createClass___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_4_babel_runtime_helpers_createClass__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5_babel_runtime_helpers_possibleConstructorReturn__ = __webpack_require__(6);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5_babel_runtime_helpers_possibleConstructorReturn___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_5_babel_runtime_helpers_possibleConstructorReturn__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6_babel_runtime_helpers_inherits__ = __webpack_require__(7);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6_babel_runtime_helpers_inherits___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_6_babel_runtime_helpers_inherits__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7_prop_types__ = __webpack_require__(3);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7_prop_types___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_7_prop_types__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_8_react__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_8_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_8_react__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_9__CellMeasurerCacheDecorator__ = __webpack_require__(235);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_10__Grid__ = __webpack_require__(38);
var SCROLLBAR_SIZE_BUFFER = 20;

/**
 * Renders 1, 2, or 4 Grids depending on configuration.
 * A main (body) Grid will always be rendered.
 * Optionally, 1-2 Grids for sticky header rows will also be rendered.
 * If no sticky columns, only 1 sticky header Grid will be rendered.
 * If sticky columns, 2 sticky header Grids will be rendered.
 */

var MultiGrid = function (_PureComponent) {
  __WEBPACK_IMPORTED_MODULE_6_babel_runtime_helpers_inherits___default()(MultiGrid, _PureComponent);

  function MultiGrid(props, context) {
    __WEBPACK_IMPORTED_MODULE_3_babel_runtime_helpers_classCallCheck___default()(this, MultiGrid);

    var _this = __WEBPACK_IMPORTED_MODULE_5_babel_runtime_helpers_possibleConstructorReturn___default()(this, (MultiGrid.__proto__ || __WEBPACK_IMPORTED_MODULE_2_babel_runtime_core_js_object_get_prototype_of___default()(MultiGrid)).call(this, props, context));

    _this.state = {
      scrollLeft: 0,
      scrollTop: 0,
      scrollbarSize: 0,
      showHorizontalScrollbar: false,
      showVerticalScrollbar: false
    };

    _this._deferredInvalidateColumnIndex = null;
    _this._deferredInvalidateRowIndex = null;

    _this._bottomLeftGridRef = _this._bottomLeftGridRef.bind(_this);
    _this._bottomRightGridRef = _this._bottomRightGridRef.bind(_this);
    _this._cellRendererBottomLeftGrid = _this._cellRendererBottomLeftGrid.bind(_this);
    _this._cellRendererBottomRightGrid = _this._cellRendererBottomRightGrid.bind(_this);
    _this._cellRendererTopRightGrid = _this._cellRendererTopRightGrid.bind(_this);
    _this._columnWidthRightGrid = _this._columnWidthRightGrid.bind(_this);
    _this._onScroll = _this._onScroll.bind(_this);
    _this._onScrollbarPresenceChange = _this._onScrollbarPresenceChange.bind(_this);
    _this._onScrollLeft = _this._onScrollLeft.bind(_this);
    _this._onScrollTop = _this._onScrollTop.bind(_this);
    _this._rowHeightBottomGrid = _this._rowHeightBottomGrid.bind(_this);
    _this._topLeftGridRef = _this._topLeftGridRef.bind(_this);
    _this._topRightGridRef = _this._topRightGridRef.bind(_this);
    return _this;
  }

  __WEBPACK_IMPORTED_MODULE_4_babel_runtime_helpers_createClass___default()(MultiGrid, [{
    key: 'forceUpdateGrids',
    value: function forceUpdateGrids() {
      this._bottomLeftGrid && this._bottomLeftGrid.forceUpdate();
      this._bottomRightGrid && this._bottomRightGrid.forceUpdate();
      this._topLeftGrid && this._topLeftGrid.forceUpdate();
      this._topRightGrid && this._topRightGrid.forceUpdate();
    }

    /** See Grid#invalidateCellSizeAfterRender */

  }, {
    key: 'invalidateCellSizeAfterRender',
    value: function invalidateCellSizeAfterRender() {
      var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
          _ref$columnIndex = _ref.columnIndex,
          columnIndex = _ref$columnIndex === undefined ? 0 : _ref$columnIndex,
          _ref$rowIndex = _ref.rowIndex,
          rowIndex = _ref$rowIndex === undefined ? 0 : _ref$rowIndex;

      this._deferredInvalidateColumnIndex = typeof this._deferredInvalidateColumnIndex === 'number' ? Math.min(this._deferredInvalidateColumnIndex, columnIndex) : columnIndex;
      this._deferredInvalidateRowIndex = typeof this._deferredInvalidateRowIndex === 'number' ? Math.min(this._deferredInvalidateRowIndex, rowIndex) : rowIndex;
    }

    /** See Grid#measureAllCells */

  }, {
    key: 'measureAllCells',
    value: function measureAllCells() {
      this._bottomLeftGrid && this._bottomLeftGrid.measureAllCells();
      this._bottomRightGrid && this._bottomRightGrid.measureAllCells();
      this._topLeftGrid && this._topLeftGrid.measureAllCells();
      this._topRightGrid && this._topRightGrid.measureAllCells();
    }

    /** See Grid#recomputeGridSize */

  }, {
    key: 'recomputeGridSize',
    value: function recomputeGridSize() {
      var _ref2 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
          _ref2$columnIndex = _ref2.columnIndex,
          columnIndex = _ref2$columnIndex === undefined ? 0 : _ref2$columnIndex,
          _ref2$rowIndex = _ref2.rowIndex,
          rowIndex = _ref2$rowIndex === undefined ? 0 : _ref2$rowIndex;

      var _props = this.props,
          fixedColumnCount = _props.fixedColumnCount,
          fixedRowCount = _props.fixedRowCount;


      var adjustedColumnIndex = Math.max(0, columnIndex - fixedColumnCount);
      var adjustedRowIndex = Math.max(0, rowIndex - fixedRowCount);

      this._bottomLeftGrid && this._bottomLeftGrid.recomputeGridSize({
        columnIndex: columnIndex,
        rowIndex: adjustedRowIndex
      });
      this._bottomRightGrid && this._bottomRightGrid.recomputeGridSize({
        columnIndex: adjustedColumnIndex,
        rowIndex: adjustedRowIndex
      });
      this._topLeftGrid && this._topLeftGrid.recomputeGridSize({
        columnIndex: columnIndex,
        rowIndex: rowIndex
      });
      this._topRightGrid && this._topRightGrid.recomputeGridSize({
        columnIndex: adjustedColumnIndex,
        rowIndex: rowIndex
      });

      this._leftGridWidth = null;
      this._topGridHeight = null;
      this._maybeCalculateCachedStyles(null, this.props, null, this.state);
    }
  }, {
    key: 'componentDidMount',
    value: function componentDidMount() {
      var _props2 = this.props,
          scrollLeft = _props2.scrollLeft,
          scrollTop = _props2.scrollTop;


      if (scrollLeft > 0 || scrollTop > 0) {
        var newState = {};

        if (scrollLeft > 0) {
          newState.scrollLeft = scrollLeft;
        }

        if (scrollTop > 0) {
          newState.scrollTop = scrollTop;
        }

        this.setState(newState);
      }
      this._handleInvalidatedGridSize();
    }
  }, {
    key: 'componentDidUpdate',
    value: function componentDidUpdate(prevProps, prevState) {
      this._handleInvalidatedGridSize();
    }
  }, {
    key: 'componentWillMount',
    value: function componentWillMount() {
      var _props3 = this.props,
          deferredMeasurementCache = _props3.deferredMeasurementCache,
          fixedColumnCount = _props3.fixedColumnCount,
          fixedRowCount = _props3.fixedRowCount;


      this._maybeCalculateCachedStyles(null, this.props, null, this.state);

      if (deferredMeasurementCache) {
        this._deferredMeasurementCacheBottomLeftGrid = fixedRowCount > 0 ? new __WEBPACK_IMPORTED_MODULE_9__CellMeasurerCacheDecorator__["a" /* default */]({
          cellMeasurerCache: deferredMeasurementCache,
          columnIndexOffset: 0,
          rowIndexOffset: fixedRowCount
        }) : deferredMeasurementCache;

        this._deferredMeasurementCacheBottomRightGrid = fixedColumnCount > 0 || fixedRowCount > 0 ? new __WEBPACK_IMPORTED_MODULE_9__CellMeasurerCacheDecorator__["a" /* default */]({
          cellMeasurerCache: deferredMeasurementCache,
          columnIndexOffset: fixedColumnCount,
          rowIndexOffset: fixedRowCount
        }) : deferredMeasurementCache;

        this._deferredMeasurementCacheTopRightGrid = fixedColumnCount > 0 ? new __WEBPACK_IMPORTED_MODULE_9__CellMeasurerCacheDecorator__["a" /* default */]({
          cellMeasurerCache: deferredMeasurementCache,
          columnIndexOffset: fixedColumnCount,
          rowIndexOffset: 0
        }) : deferredMeasurementCache;
      }
    }
  }, {
    key: 'componentWillReceiveProps',
    value: function componentWillReceiveProps(nextProps, nextState) {
      var _props4 = this.props,
          columnWidth = _props4.columnWidth,
          fixedColumnCount = _props4.fixedColumnCount,
          fixedRowCount = _props4.fixedRowCount,
          rowHeight = _props4.rowHeight;


      if (columnWidth !== nextProps.columnWidth || fixedColumnCount !== nextProps.fixedColumnCount) {
        this._leftGridWidth = null;
      }

      if (fixedRowCount !== nextProps.fixedRowCount || rowHeight !== nextProps.rowHeight) {
        this._topGridHeight = null;
      }

      if (nextProps.scrollLeft !== this.props.scrollLeft || nextProps.scrollTop !== this.props.scrollTop) {
        var newState = {};

        if (nextProps.scrollLeft != null && nextProps.scrollLeft >= 0) {
          newState.scrollLeft = nextProps.scrollLeft;
        }

        if (nextProps.scrollTop != null && nextProps.scrollTop >= 0) {
          newState.scrollTop = nextProps.scrollTop;
        }

        this.setState(newState);
      }

      this._maybeCalculateCachedStyles(this.props, nextProps, this.state, nextState);
    }
  }, {
    key: 'render',
    value: function render() {
      var _props5 = this.props,
          onScroll = _props5.onScroll,
          onSectionRendered = _props5.onSectionRendered,
          scrollLeftProp = _props5.scrollLeft,
          scrollToColumn = _props5.scrollToColumn,
          scrollTopProp = _props5.scrollTop,
          scrollToRow = _props5.scrollToRow,
          rest = __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_objectWithoutProperties___default()(_props5, ['onScroll', 'onSectionRendered', 'scrollLeft', 'scrollToColumn', 'scrollTop', 'scrollToRow']);

      // Don't render any of our Grids if there are no cells.
      // This mirrors what Grid does,
      // And prevents us from recording inaccurage measurements when used with CellMeasurer.


      if (this.props.width === 0 || this.props.height === 0) {
        return null;
      }

      // scrollTop and scrollLeft props are explicitly filtered out and ignored

      var _state = this.state,
          scrollLeft = _state.scrollLeft,
          scrollTop = _state.scrollTop;


      return __WEBPACK_IMPORTED_MODULE_8_react___default.a.createElement(
        'div',
        { style: this._containerOuterStyle },
        __WEBPACK_IMPORTED_MODULE_8_react___default.a.createElement(
          'div',
          { style: this._containerTopStyle },
          this._renderTopLeftGrid(rest),
          this._renderTopRightGrid(__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_extends___default()({}, rest, {
            onScroll: onScroll,
            scrollLeft: scrollLeft
          }))
        ),
        __WEBPACK_IMPORTED_MODULE_8_react___default.a.createElement(
          'div',
          { style: this._containerBottomStyle },
          this._renderBottomLeftGrid(__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_extends___default()({}, rest, {
            onScroll: onScroll,
            scrollTop: scrollTop
          })),
          this._renderBottomRightGrid(__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_extends___default()({}, rest, {
            onScroll: onScroll,
            onSectionRendered: onSectionRendered,
            scrollLeft: scrollLeft,
            scrollToColumn: scrollToColumn,
            scrollToRow: scrollToRow,
            scrollTop: scrollTop
          }))
        )
      );
    }
  }, {
    key: '_bottomLeftGridRef',
    value: function _bottomLeftGridRef(ref) {
      this._bottomLeftGrid = ref;
    }
  }, {
    key: '_bottomRightGridRef',
    value: function _bottomRightGridRef(ref) {
      this._bottomRightGrid = ref;
    }
  }, {
    key: '_cellRendererBottomLeftGrid',
    value: function _cellRendererBottomLeftGrid(_ref3) {
      var rowIndex = _ref3.rowIndex,
          rest = __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_objectWithoutProperties___default()(_ref3, ['rowIndex']);

      var _props6 = this.props,
          cellRenderer = _props6.cellRenderer,
          fixedRowCount = _props6.fixedRowCount,
          rowCount = _props6.rowCount;


      if (rowIndex === rowCount - fixedRowCount) {
        return __WEBPACK_IMPORTED_MODULE_8_react___default.a.createElement('div', {
          key: rest.key,
          style: __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_extends___default()({}, rest.style, {
            height: SCROLLBAR_SIZE_BUFFER
          })
        });
      } else {
        return cellRenderer(__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_extends___default()({}, rest, {
          parent: this,
          rowIndex: rowIndex + fixedRowCount
        }));
      }
    }
  }, {
    key: '_cellRendererBottomRightGrid',
    value: function _cellRendererBottomRightGrid(_ref4) {
      var columnIndex = _ref4.columnIndex,
          rowIndex = _ref4.rowIndex,
          rest = __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_objectWithoutProperties___default()(_ref4, ['columnIndex', 'rowIndex']);

      var _props7 = this.props,
          cellRenderer = _props7.cellRenderer,
          fixedColumnCount = _props7.fixedColumnCount,
          fixedRowCount = _props7.fixedRowCount;


      return cellRenderer(__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_extends___default()({}, rest, {
        columnIndex: columnIndex + fixedColumnCount,
        parent: this,
        rowIndex: rowIndex + fixedRowCount
      }));
    }
  }, {
    key: '_cellRendererTopRightGrid',
    value: function _cellRendererTopRightGrid(_ref5) {
      var columnIndex = _ref5.columnIndex,
          rest = __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_objectWithoutProperties___default()(_ref5, ['columnIndex']);

      var _props8 = this.props,
          cellRenderer = _props8.cellRenderer,
          columnCount = _props8.columnCount,
          fixedColumnCount = _props8.fixedColumnCount;


      if (columnIndex === columnCount - fixedColumnCount) {
        return __WEBPACK_IMPORTED_MODULE_8_react___default.a.createElement('div', {
          key: rest.key,
          style: __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_extends___default()({}, rest.style, {
            width: SCROLLBAR_SIZE_BUFFER
          })
        });
      } else {
        return cellRenderer(__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_extends___default()({}, rest, {
          columnIndex: columnIndex + fixedColumnCount,
          parent: this
        }));
      }
    }
  }, {
    key: '_columnWidthRightGrid',
    value: function _columnWidthRightGrid(_ref6) {
      var index = _ref6.index;
      var _props9 = this.props,
          columnCount = _props9.columnCount,
          fixedColumnCount = _props9.fixedColumnCount,
          columnWidth = _props9.columnWidth;
      var _state2 = this.state,
          scrollbarSize = _state2.scrollbarSize,
          showHorizontalScrollbar = _state2.showHorizontalScrollbar;

      // An extra cell is added to the count
      // This gives the smaller Grid extra room for offset,
      // In case the main (bottom right) Grid has a scrollbar
      // If no scrollbar, the extra space is overflow:hidden anyway

      if (showHorizontalScrollbar && index === columnCount - fixedColumnCount) {
        return scrollbarSize;
      }

      return typeof columnWidth === 'function' ? columnWidth({ index: index + fixedColumnCount }) : columnWidth;
    }
  }, {
    key: '_getBottomGridHeight',
    value: function _getBottomGridHeight(props) {
      var height = props.height;


      var topGridHeight = this._getTopGridHeight(props);

      return height - topGridHeight;
    }
  }, {
    key: '_getLeftGridWidth',
    value: function _getLeftGridWidth(props) {
      var fixedColumnCount = props.fixedColumnCount,
          columnWidth = props.columnWidth;


      if (this._leftGridWidth == null) {
        if (typeof columnWidth === 'function') {
          var leftGridWidth = 0;

          for (var index = 0; index < fixedColumnCount; index++) {
            leftGridWidth += columnWidth({ index: index });
          }

          this._leftGridWidth = leftGridWidth;
        } else {
          this._leftGridWidth = columnWidth * fixedColumnCount;
        }
      }

      return this._leftGridWidth;
    }
  }, {
    key: '_getRightGridWidth',
    value: function _getRightGridWidth(props) {
      var width = props.width;


      var leftGridWidth = this._getLeftGridWidth(props);

      return width - leftGridWidth;
    }
  }, {
    key: '_getTopGridHeight',
    value: function _getTopGridHeight(props) {
      var fixedRowCount = props.fixedRowCount,
          rowHeight = props.rowHeight;


      if (this._topGridHeight == null) {
        if (typeof rowHeight === 'function') {
          var topGridHeight = 0;

          for (var index = 0; index < fixedRowCount; index++) {
            topGridHeight += rowHeight({ index: index });
          }

          this._topGridHeight = topGridHeight;
        } else {
          this._topGridHeight = rowHeight * fixedRowCount;
        }
      }

      return this._topGridHeight;
    }
  }, {
    key: '_handleInvalidatedGridSize',
    value: function _handleInvalidatedGridSize() {
      if (typeof this._deferredInvalidateColumnIndex === 'number') {
        var columnIndex = this._deferredInvalidateColumnIndex;
        var rowIndex = this._deferredInvalidateRowIndex;

        this._deferredInvalidateColumnIndex = null;
        this._deferredInvalidateRowIndex = null;

        this.recomputeGridSize({
          columnIndex: columnIndex,
          rowIndex: rowIndex
        });
        this.forceUpdate();
      }
    }

    /**
     * Avoid recreating inline styles each render; this bypasses Grid's shallowCompare.
     * This method recalculates styles only when specific props change.
     */

  }, {
    key: '_maybeCalculateCachedStyles',
    value: function _maybeCalculateCachedStyles(prevProps, props, prevState, state) {
      var columnWidth = props.columnWidth,
          enableFixedColumnScroll = props.enableFixedColumnScroll,
          enableFixedRowScroll = props.enableFixedRowScroll,
          height = props.height,
          fixedColumnCount = props.fixedColumnCount,
          fixedRowCount = props.fixedRowCount,
          rowHeight = props.rowHeight,
          style = props.style,
          styleBottomLeftGrid = props.styleBottomLeftGrid,
          styleBottomRightGrid = props.styleBottomRightGrid,
          styleTopLeftGrid = props.styleTopLeftGrid,
          styleTopRightGrid = props.styleTopRightGrid,
          width = props.width;


      var firstRender = !prevProps;
      var sizeChange = firstRender || height !== prevProps.height || width !== prevProps.width;
      var leftSizeChange = firstRender || columnWidth !== prevProps.columnWidth || fixedColumnCount !== prevProps.fixedColumnCount;
      var topSizeChange = firstRender || fixedRowCount !== prevProps.fixedRowCount || rowHeight !== prevProps.rowHeight;

      if (firstRender || sizeChange || style !== prevProps.style) {
        this._containerOuterStyle = __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_extends___default()({
          height: height,
          overflow: 'visible', // Let :focus outline show through
          width: width
        }, style);
      }

      if (firstRender || sizeChange || topSizeChange) {
        this._containerTopStyle = {
          height: this._getTopGridHeight(props),
          position: 'relative',
          width: width
        };

        this._containerBottomStyle = {
          height: height - this._getTopGridHeight(props),
          overflow: 'visible', // Let :focus outline show through
          position: 'relative',
          width: width
        };
      }

      if (firstRender || styleBottomLeftGrid !== prevProps.styleBottomLeftGrid) {
        this._bottomLeftGridStyle = __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_extends___default()({
          left: 0,
          overflowX: 'hidden',
          overflowY: enableFixedColumnScroll ? 'auto' : 'hidden',
          position: 'absolute'
        }, styleBottomLeftGrid);
      }

      if (firstRender || leftSizeChange || styleBottomRightGrid !== prevProps.styleBottomRightGrid) {
        this._bottomRightGridStyle = __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_extends___default()({
          left: this._getLeftGridWidth(props),
          position: 'absolute'
        }, styleBottomRightGrid);
      }

      if (firstRender || styleTopLeftGrid !== prevProps.styleTopLeftGrid) {
        this._topLeftGridStyle = __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_extends___default()({
          left: 0,
          overflowX: 'hidden',
          overflowY: 'hidden',
          position: 'absolute',
          top: 0
        }, styleTopLeftGrid);
      }

      if (firstRender || leftSizeChange || styleTopRightGrid !== prevProps.styleTopRightGrid) {
        this._topRightGridStyle = __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_extends___default()({
          left: this._getLeftGridWidth(props),
          overflowX: enableFixedRowScroll ? 'auto' : 'hidden',
          overflowY: 'hidden',
          position: 'absolute',
          top: 0
        }, styleTopRightGrid);
      }
    }
  }, {
    key: '_onScroll',
    value: function _onScroll(scrollInfo) {
      var scrollLeft = scrollInfo.scrollLeft,
          scrollTop = scrollInfo.scrollTop;

      this.setState({
        scrollLeft: scrollLeft,
        scrollTop: scrollTop
      });
      var onScroll = this.props.onScroll;
      if (onScroll) {
        onScroll(scrollInfo);
      }
    }
  }, {
    key: '_onScrollbarPresenceChange',
    value: function _onScrollbarPresenceChange(_ref7) {
      var horizontal = _ref7.horizontal,
          size = _ref7.size,
          vertical = _ref7.vertical;
      var _state3 = this.state,
          showHorizontalScrollbar = _state3.showHorizontalScrollbar,
          showVerticalScrollbar = _state3.showVerticalScrollbar;


      if (horizontal !== showHorizontalScrollbar || vertical !== showVerticalScrollbar) {
        this.setState({
          scrollbarSize: size,
          showHorizontalScrollbar: horizontal,
          showVerticalScrollbar: vertical
        });
      }
    }
  }, {
    key: '_onScrollLeft',
    value: function _onScrollLeft(scrollInfo) {
      var scrollLeft = scrollInfo.scrollLeft;

      this._onScroll({
        scrollLeft: scrollLeft,
        scrollTop: this.state.scrollTop
      });
    }
  }, {
    key: '_onScrollTop',
    value: function _onScrollTop(scrollInfo) {
      var scrollTop = scrollInfo.scrollTop;

      this._onScroll({
        scrollTop: scrollTop,
        scrollLeft: this.state.scrollLeft
      });
    }
  }, {
    key: '_renderBottomLeftGrid',
    value: function _renderBottomLeftGrid(props) {
      var enableFixedColumnScroll = props.enableFixedColumnScroll,
          fixedColumnCount = props.fixedColumnCount,
          fixedRowCount = props.fixedRowCount,
          rowCount = props.rowCount,
          scrollTop = props.scrollTop;
      var showVerticalScrollbar = this.state.showVerticalScrollbar;


      if (!fixedColumnCount) {
        return null;
      }

      var additionalRowCount = showVerticalScrollbar ? 1 : 0;

      return __WEBPACK_IMPORTED_MODULE_8_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_10__Grid__["c" /* default */], __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_extends___default()({}, props, {
        cellRenderer: this._cellRendererBottomLeftGrid,
        columnCount: fixedColumnCount,
        deferredMeasurementCache: this._deferredMeasurementCacheBottomLeftGrid,
        height: this._getBottomGridHeight(props),
        onScroll: enableFixedColumnScroll ? this._onScrollTop : undefined,
        ref: this._bottomLeftGridRef,
        rowCount: Math.max(0, rowCount - fixedRowCount) + additionalRowCount,
        rowHeight: this._rowHeightBottomGrid,
        scrollTop: scrollTop,
        style: this._bottomLeftGridStyle,
        tabIndex: null,
        width: this._getLeftGridWidth(props)
      }));
    }
  }, {
    key: '_renderBottomRightGrid',
    value: function _renderBottomRightGrid(props) {
      var columnCount = props.columnCount,
          fixedColumnCount = props.fixedColumnCount,
          fixedRowCount = props.fixedRowCount,
          rowCount = props.rowCount,
          scrollToColumn = props.scrollToColumn,
          scrollToRow = props.scrollToRow;


      return __WEBPACK_IMPORTED_MODULE_8_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_10__Grid__["c" /* default */], __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_extends___default()({}, props, {
        cellRenderer: this._cellRendererBottomRightGrid,
        columnCount: Math.max(0, columnCount - fixedColumnCount),
        columnWidth: this._columnWidthRightGrid,
        deferredMeasurementCache: this._deferredMeasurementCacheBottomRightGrid,
        height: this._getBottomGridHeight(props),
        onScroll: this._onScroll,
        onScrollbarPresenceChange: this._onScrollbarPresenceChange,
        ref: this._bottomRightGridRef,
        rowCount: Math.max(0, rowCount - fixedRowCount),
        rowHeight: this._rowHeightBottomGrid,
        scrollToColumn: scrollToColumn - fixedColumnCount,
        scrollToRow: scrollToRow - fixedRowCount,
        style: this._bottomRightGridStyle,
        width: this._getRightGridWidth(props)
      }));
    }
  }, {
    key: '_renderTopLeftGrid',
    value: function _renderTopLeftGrid(props) {
      var fixedColumnCount = props.fixedColumnCount,
          fixedRowCount = props.fixedRowCount;


      if (!fixedColumnCount || !fixedRowCount) {
        return null;
      }

      return __WEBPACK_IMPORTED_MODULE_8_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_10__Grid__["c" /* default */], __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_extends___default()({}, props, {
        columnCount: fixedColumnCount,
        height: this._getTopGridHeight(props),
        ref: this._topLeftGridRef,
        rowCount: fixedRowCount,
        style: this._topLeftGridStyle,
        tabIndex: null,
        width: this._getLeftGridWidth(props)
      }));
    }
  }, {
    key: '_renderTopRightGrid',
    value: function _renderTopRightGrid(props) {
      var columnCount = props.columnCount,
          enableFixedRowScroll = props.enableFixedRowScroll,
          fixedColumnCount = props.fixedColumnCount,
          fixedRowCount = props.fixedRowCount,
          scrollLeft = props.scrollLeft;
      var showHorizontalScrollbar = this.state.showHorizontalScrollbar;


      if (!fixedRowCount) {
        return null;
      }

      var additionalColumnCount = showHorizontalScrollbar ? 1 : 0;

      return __WEBPACK_IMPORTED_MODULE_8_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_10__Grid__["c" /* default */], __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_extends___default()({}, props, {
        cellRenderer: this._cellRendererTopRightGrid,
        columnCount: Math.max(0, columnCount - fixedColumnCount) + additionalColumnCount,
        columnWidth: this._columnWidthRightGrid,
        deferredMeasurementCache: this._deferredMeasurementCacheTopRightGrid,
        height: this._getTopGridHeight(props),
        onScroll: enableFixedRowScroll ? this._onScrollLeft : undefined,
        ref: this._topRightGridRef,
        rowCount: fixedRowCount,
        scrollLeft: scrollLeft,
        style: this._topRightGridStyle,
        tabIndex: null,
        width: this._getRightGridWidth(props)
      }));
    }
  }, {
    key: '_rowHeightBottomGrid',
    value: function _rowHeightBottomGrid(_ref8) {
      var index = _ref8.index;
      var _props10 = this.props,
          fixedRowCount = _props10.fixedRowCount,
          rowCount = _props10.rowCount,
          rowHeight = _props10.rowHeight;
      var _state4 = this.state,
          scrollbarSize = _state4.scrollbarSize,
          showVerticalScrollbar = _state4.showVerticalScrollbar;

      // An extra cell is added to the count
      // This gives the smaller Grid extra room for offset,
      // In case the main (bottom right) Grid has a scrollbar
      // If no scrollbar, the extra space is overflow:hidden anyway

      if (showVerticalScrollbar && index === rowCount - fixedRowCount) {
        return scrollbarSize;
      }

      return typeof rowHeight === 'function' ? rowHeight({ index: index + fixedRowCount }) : rowHeight;
    }
  }, {
    key: '_topLeftGridRef',
    value: function _topLeftGridRef(ref) {
      this._topLeftGrid = ref;
    }
  }, {
    key: '_topRightGridRef',
    value: function _topRightGridRef(ref) {
      this._topRightGrid = ref;
    }
  }]);

  return MultiGrid;
}(__WEBPACK_IMPORTED_MODULE_8_react__["PureComponent"]);

MultiGrid.defaultProps = {
  enableFixedColumnScroll: false,
  enableFixedRowScroll: false,
  fixedColumnCount: 0,
  fixedRowCount: 0,
  style: {},
  styleBottomLeftGrid: {},
  styleBottomRightGrid: {},
  styleTopLeftGrid: {},
  styleTopRightGrid: {}
};
/* harmony default export */ __webpack_exports__["a"] = (MultiGrid);
process.env.NODE_ENV !== "production" ? MultiGrid.propTypes = {
  enableFixedColumnScroll: __WEBPACK_IMPORTED_MODULE_7_prop_types___default.a.bool.isRequired,
  enableFixedRowScroll: __WEBPACK_IMPORTED_MODULE_7_prop_types___default.a.bool.isRequired,
  fixedColumnCount: __WEBPACK_IMPORTED_MODULE_7_prop_types___default.a.number.isRequired,
  fixedRowCount: __WEBPACK_IMPORTED_MODULE_7_prop_types___default.a.number.isRequired,
  style: __WEBPACK_IMPORTED_MODULE_7_prop_types___default.a.object.isRequired,
  styleBottomLeftGrid: __WEBPACK_IMPORTED_MODULE_7_prop_types___default.a.object.isRequired,
  styleBottomRightGrid: __WEBPACK_IMPORTED_MODULE_7_prop_types___default.a.object.isRequired,
  styleTopLeftGrid: __WEBPACK_IMPORTED_MODULE_7_prop_types___default.a.object.isRequired,
  styleTopRightGrid: __WEBPACK_IMPORTED_MODULE_7_prop_types___default.a.object.isRequired
} : void 0;
/* WEBPACK VAR INJECTION */}.call(__webpack_exports__, __webpack_require__(1)))

/***/ }),
/* 112 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function(process) {/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_core_js_object_get_prototype_of__ = __webpack_require__(5);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_core_js_object_get_prototype_of___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_babel_runtime_core_js_object_get_prototype_of__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_classCallCheck__ = __webpack_require__(2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_classCallCheck___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_classCallCheck__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_createClass__ = __webpack_require__(4);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_createClass___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_createClass__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_babel_runtime_helpers_possibleConstructorReturn__ = __webpack_require__(6);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_babel_runtime_helpers_possibleConstructorReturn___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_3_babel_runtime_helpers_possibleConstructorReturn__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_babel_runtime_helpers_inherits__ = __webpack_require__(7);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_babel_runtime_helpers_inherits___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_4_babel_runtime_helpers_inherits__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5_prop_types__ = __webpack_require__(3);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5_prop_types___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_5_prop_types__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6_react__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_6_react__);
/**
 * HOC that simplifies the process of synchronizing scrolling between two or more virtualized components.
 */

var ScrollSync = function (_PureComponent) {
  __WEBPACK_IMPORTED_MODULE_4_babel_runtime_helpers_inherits___default()(ScrollSync, _PureComponent);

  function ScrollSync(props, context) {
    __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_classCallCheck___default()(this, ScrollSync);

    var _this = __WEBPACK_IMPORTED_MODULE_3_babel_runtime_helpers_possibleConstructorReturn___default()(this, (ScrollSync.__proto__ || __WEBPACK_IMPORTED_MODULE_0_babel_runtime_core_js_object_get_prototype_of___default()(ScrollSync)).call(this, props, context));

    _this.state = {
      clientHeight: 0,
      clientWidth: 0,
      scrollHeight: 0,
      scrollLeft: 0,
      scrollTop: 0,
      scrollWidth: 0
    };

    _this._onScroll = _this._onScroll.bind(_this);
    return _this;
  }

  __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_createClass___default()(ScrollSync, [{
    key: 'render',
    value: function render() {
      var children = this.props.children;
      var _state = this.state,
          clientHeight = _state.clientHeight,
          clientWidth = _state.clientWidth,
          scrollHeight = _state.scrollHeight,
          scrollLeft = _state.scrollLeft,
          scrollTop = _state.scrollTop,
          scrollWidth = _state.scrollWidth;


      return children({
        clientHeight: clientHeight,
        clientWidth: clientWidth,
        onScroll: this._onScroll,
        scrollHeight: scrollHeight,
        scrollLeft: scrollLeft,
        scrollTop: scrollTop,
        scrollWidth: scrollWidth
      });
    }
  }, {
    key: '_onScroll',
    value: function _onScroll(_ref) {
      var clientHeight = _ref.clientHeight,
          clientWidth = _ref.clientWidth,
          scrollHeight = _ref.scrollHeight,
          scrollLeft = _ref.scrollLeft,
          scrollTop = _ref.scrollTop,
          scrollWidth = _ref.scrollWidth;

      this.setState({ clientHeight: clientHeight, clientWidth: clientWidth, scrollHeight: scrollHeight, scrollLeft: scrollLeft, scrollTop: scrollTop, scrollWidth: scrollWidth });
    }
  }]);

  return ScrollSync;
}(__WEBPACK_IMPORTED_MODULE_6_react__["PureComponent"]);

/* harmony default export */ __webpack_exports__["a"] = (ScrollSync);
process.env.NODE_ENV !== "production" ? ScrollSync.propTypes = {
  /**
   * Function responsible for rendering 2 or more virtualized components.
   * This function should implement the following signature:
   * ({ onScroll, scrollLeft, scrollTop }) => PropTypes.element
   */
  children: __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.func.isRequired
} : void 0;
/* WEBPACK VAR INJECTION */}.call(__webpack_exports__, __webpack_require__(1)))

/***/ }),
/* 113 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function(process) {/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_extends__ = __webpack_require__(12);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_extends___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_extends__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_babel_runtime_core_js_object_get_prototype_of__ = __webpack_require__(5);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_babel_runtime_core_js_object_get_prototype_of___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_babel_runtime_core_js_object_get_prototype_of__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_classCallCheck__ = __webpack_require__(2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_classCallCheck___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_classCallCheck__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_babel_runtime_helpers_createClass__ = __webpack_require__(4);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_babel_runtime_helpers_createClass___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_3_babel_runtime_helpers_createClass__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_babel_runtime_helpers_possibleConstructorReturn__ = __webpack_require__(6);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_babel_runtime_helpers_possibleConstructorReturn___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_4_babel_runtime_helpers_possibleConstructorReturn__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5_babel_runtime_helpers_inherits__ = __webpack_require__(7);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5_babel_runtime_helpers_inherits___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_5_babel_runtime_helpers_inherits__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6_classnames__ = __webpack_require__(24);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6_classnames___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_6_classnames__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7__Column__ = __webpack_require__(114);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_8_prop_types__ = __webpack_require__(3);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_8_prop_types___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_8_prop_types__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_9_react__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_9_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_9_react__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_10_react_dom__ = __webpack_require__(23);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_10_react_dom___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_10_react_dom__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_11__Grid__ = __webpack_require__(38);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_12__defaultRowRenderer__ = __webpack_require__(119);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_13__defaultHeaderRowRenderer__ = __webpack_require__(120);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_14__SortDirection__ = __webpack_require__(71);
/**
 * Table component with fixed headers and virtualized rows for improved performance with large data sets.
 * This component expects explicit width, height, and padding parameters.
 */

var Table = function (_PureComponent) {
  __WEBPACK_IMPORTED_MODULE_5_babel_runtime_helpers_inherits___default()(Table, _PureComponent);

  function Table(props) {
    __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_classCallCheck___default()(this, Table);

    var _this = __WEBPACK_IMPORTED_MODULE_4_babel_runtime_helpers_possibleConstructorReturn___default()(this, (Table.__proto__ || __WEBPACK_IMPORTED_MODULE_1_babel_runtime_core_js_object_get_prototype_of___default()(Table)).call(this, props));

    _this.state = {
      scrollbarWidth: 0
    };

    _this._createColumn = _this._createColumn.bind(_this);
    _this._createRow = _this._createRow.bind(_this);
    _this._onScroll = _this._onScroll.bind(_this);
    _this._onSectionRendered = _this._onSectionRendered.bind(_this);
    _this._setRef = _this._setRef.bind(_this);
    return _this;
  }

  __WEBPACK_IMPORTED_MODULE_3_babel_runtime_helpers_createClass___default()(Table, [{
    key: 'forceUpdateGrid',
    value: function forceUpdateGrid() {
      this.Grid.forceUpdate();
    }

    /** See Grid#getOffsetForCell */

  }, {
    key: 'getOffsetForRow',
    value: function getOffsetForRow(_ref) {
      var alignment = _ref.alignment,
          index = _ref.index;

      var _Grid$getOffsetForCel = this.Grid.getOffsetForCell({
        alignment: alignment,
        rowIndex: index
      }),
          scrollTop = _Grid$getOffsetForCel.scrollTop;

      return scrollTop;
    }

    /** See Grid#measureAllCells */

  }, {
    key: 'measureAllRows',
    value: function measureAllRows() {
      this.Grid.measureAllCells();
    }

    /** See Grid#recomputeGridSize */

  }, {
    key: 'recomputeRowHeights',
    value: function recomputeRowHeights() {
      var index = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 0;

      this.Grid.recomputeGridSize({
        rowIndex: index
      });
    }

    /** See Grid#scrollToPosition */

  }, {
    key: 'scrollToPosition',
    value: function scrollToPosition() {
      var scrollTop = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 0;

      this.Grid.scrollToPosition({ scrollTop: scrollTop });
    }

    /** See Grid#scrollToCell */

  }, {
    key: 'scrollToRow',
    value: function scrollToRow() {
      var index = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 0;

      this.Grid.scrollToCell({
        columnIndex: 0,
        rowIndex: index
      });
    }
  }, {
    key: 'componentDidMount',
    value: function componentDidMount() {
      this._setScrollbarWidth();
    }
  }, {
    key: 'componentDidUpdate',
    value: function componentDidUpdate() {
      this._setScrollbarWidth();
    }
  }, {
    key: 'render',
    value: function render() {
      var _this2 = this;

      var _props = this.props,
          children = _props.children,
          className = _props.className,
          disableHeader = _props.disableHeader,
          gridClassName = _props.gridClassName,
          gridStyle = _props.gridStyle,
          headerHeight = _props.headerHeight,
          headerRowRenderer = _props.headerRowRenderer,
          height = _props.height,
          id = _props.id,
          noRowsRenderer = _props.noRowsRenderer,
          rowClassName = _props.rowClassName,
          rowStyle = _props.rowStyle,
          scrollToIndex = _props.scrollToIndex,
          style = _props.style,
          width = _props.width;
      var scrollbarWidth = this.state.scrollbarWidth;


      var availableRowsHeight = disableHeader ? height : height - headerHeight;

      var rowClass = typeof rowClassName === 'function' ? rowClassName({ index: -1 }) : rowClassName;
      var rowStyleObject = typeof rowStyle === 'function' ? rowStyle({ index: -1 }) : rowStyle;

      // Precompute and cache column styles before rendering rows and columns to speed things up
      this._cachedColumnStyles = [];
      __WEBPACK_IMPORTED_MODULE_9_react___default.a.Children.toArray(children).forEach(function (column, index) {
        var flexStyles = _this2._getFlexStyleForColumn(column, column.props.style);

        _this2._cachedColumnStyles[index] = __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_extends___default()({}, flexStyles, {
          overflow: 'hidden'
        });
      });

      // Note that we specify :rowCount, :scrollbarWidth, :sortBy, and :sortDirection as properties on Grid even though these have nothing to do with Grid.
      // This is done because Grid is a pure component and won't update unless its properties or state has changed.
      // Any property that should trigger a re-render of Grid then is specified here to avoid a stale display.
      return __WEBPACK_IMPORTED_MODULE_9_react___default.a.createElement(
        'div',
        {
          className: __WEBPACK_IMPORTED_MODULE_6_classnames___default()('ReactVirtualized__Table', className),
          id: id,
          role: 'grid',
          style: style
        },
        !disableHeader && headerRowRenderer({
          className: __WEBPACK_IMPORTED_MODULE_6_classnames___default()('ReactVirtualized__Table__headerRow', rowClass),
          columns: this._getHeaderColumns(),
          style: __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_extends___default()({}, rowStyleObject, {
            height: headerHeight,
            overflow: 'hidden',
            paddingRight: scrollbarWidth,
            width: width
          })
        }),
        __WEBPACK_IMPORTED_MODULE_9_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_11__Grid__["c" /* default */], __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_extends___default()({}, this.props, {
          autoContainerWidth: true,
          className: __WEBPACK_IMPORTED_MODULE_6_classnames___default()('ReactVirtualized__Table__Grid', gridClassName),
          cellRenderer: this._createRow,
          columnWidth: width,
          columnCount: 1,
          height: availableRowsHeight,
          id: undefined,
          noContentRenderer: noRowsRenderer,
          onScroll: this._onScroll,
          onSectionRendered: this._onSectionRendered,
          ref: this._setRef,
          role: 'rowgroup',
          scrollbarWidth: scrollbarWidth,
          scrollToRow: scrollToIndex,
          style: __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_extends___default()({}, gridStyle, {
            overflowX: 'hidden'
          })
        }))
      );
    }
  }, {
    key: '_createColumn',
    value: function _createColumn(_ref2) {
      var column = _ref2.column,
          columnIndex = _ref2.columnIndex,
          isScrolling = _ref2.isScrolling,
          parent = _ref2.parent,
          rowData = _ref2.rowData,
          rowIndex = _ref2.rowIndex;
      var _column$props = column.props,
          cellDataGetter = _column$props.cellDataGetter,
          cellRenderer = _column$props.cellRenderer,
          className = _column$props.className,
          columnData = _column$props.columnData,
          dataKey = _column$props.dataKey,
          id = _column$props.id;


      var cellData = cellDataGetter({ columnData: columnData, dataKey: dataKey, rowData: rowData });
      var renderedCell = cellRenderer({ cellData: cellData, columnData: columnData, columnIndex: columnIndex, dataKey: dataKey, isScrolling: isScrolling, parent: parent, rowData: rowData, rowIndex: rowIndex });

      var style = this._cachedColumnStyles[columnIndex];

      var title = typeof renderedCell === 'string' ? renderedCell : null;

      var a11yProps = {
        role: 'gridcell'
      };

      if (id) {
        a11yProps['aria-describedby'] = id;
      }

      return __WEBPACK_IMPORTED_MODULE_9_react___default.a.createElement(
        'div',
        __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_extends___default()({}, a11yProps, {
          key: 'Row' + rowIndex + '-Col' + columnIndex,
          className: __WEBPACK_IMPORTED_MODULE_6_classnames___default()('ReactVirtualized__Table__rowColumn', className),
          style: style,
          title: title
        }),
        renderedCell
      );
    }
  }, {
    key: '_createHeader',
    value: function _createHeader(_ref3) {
      var column = _ref3.column,
          index = _ref3.index;
      var _props2 = this.props,
          headerClassName = _props2.headerClassName,
          headerStyle = _props2.headerStyle,
          onHeaderClick = _props2.onHeaderClick,
          sort = _props2.sort,
          sortBy = _props2.sortBy,
          sortDirection = _props2.sortDirection;
      var _column$props2 = column.props,
          dataKey = _column$props2.dataKey,
          disableSort = _column$props2.disableSort,
          headerRenderer = _column$props2.headerRenderer,
          id = _column$props2.id,
          label = _column$props2.label,
          columnData = _column$props2.columnData;

      var sortEnabled = !disableSort && sort;

      var classNames = __WEBPACK_IMPORTED_MODULE_6_classnames___default()('ReactVirtualized__Table__headerColumn', headerClassName, column.props.headerClassName, {
        'ReactVirtualized__Table__sortableHeaderColumn': sortEnabled
      });
      var style = this._getFlexStyleForColumn(column, headerStyle);

      var renderedHeader = headerRenderer({
        columnData: columnData,
        dataKey: dataKey,
        disableSort: disableSort,
        label: label,
        sortBy: sortBy,
        sortDirection: sortDirection
      });

      var a11yProps = {
        role: 'columnheader'
      };

      if (sortEnabled || onHeaderClick) {
        (function () {
          // If this is a sortable header, clicking it should update the table data's sorting.
          var newSortDirection = sortBy !== dataKey || sortDirection === __WEBPACK_IMPORTED_MODULE_14__SortDirection__["a" /* default */].DESC ? __WEBPACK_IMPORTED_MODULE_14__SortDirection__["a" /* default */].ASC : __WEBPACK_IMPORTED_MODULE_14__SortDirection__["a" /* default */].DESC;

          var onClick = function onClick(event) {
            sortEnabled && sort({
              sortBy: dataKey,
              sortDirection: newSortDirection
            });
            onHeaderClick && onHeaderClick({ columnData: columnData, dataKey: dataKey, event: event });
          };

          var onKeyDown = function onKeyDown(event) {
            if (event.key === 'Enter' || event.key === ' ') {
              onClick(event);
            }
          };

          a11yProps['aria-label'] = column.props['aria-label'] || label || dataKey;
          a11yProps.tabIndex = 0;
          a11yProps.onClick = onClick;
          a11yProps.onKeyDown = onKeyDown;
        })();
      }

      if (sortBy === dataKey) {
        a11yProps['aria-sort'] = sortDirection === __WEBPACK_IMPORTED_MODULE_14__SortDirection__["a" /* default */].ASC ? 'ascending' : 'descending';
      }

      if (id) {
        a11yProps.id = id;
      }

      return __WEBPACK_IMPORTED_MODULE_9_react___default.a.createElement(
        'div',
        __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_extends___default()({}, a11yProps, {
          key: 'Header-Col' + index,
          className: classNames,
          style: style
        }),
        renderedHeader
      );
    }
  }, {
    key: '_createRow',
    value: function _createRow(_ref4) {
      var _this3 = this;

      var index = _ref4.rowIndex,
          isScrolling = _ref4.isScrolling,
          key = _ref4.key,
          parent = _ref4.parent,
          style = _ref4.style;
      var _props3 = this.props,
          children = _props3.children,
          onRowClick = _props3.onRowClick,
          onRowDoubleClick = _props3.onRowDoubleClick,
          onRowMouseOver = _props3.onRowMouseOver,
          onRowMouseOut = _props3.onRowMouseOut,
          rowClassName = _props3.rowClassName,
          rowGetter = _props3.rowGetter,
          rowRenderer = _props3.rowRenderer,
          rowStyle = _props3.rowStyle;
      var scrollbarWidth = this.state.scrollbarWidth;


      var rowClass = typeof rowClassName === 'function' ? rowClassName({ index: index }) : rowClassName;
      var rowStyleObject = typeof rowStyle === 'function' ? rowStyle({ index: index }) : rowStyle;
      var rowData = rowGetter({ index: index });

      var columns = __WEBPACK_IMPORTED_MODULE_9_react___default.a.Children.toArray(children).map(function (column, columnIndex) {
        return _this3._createColumn({
          column: column,
          columnIndex: columnIndex,
          isScrolling: isScrolling,
          parent: parent,
          rowData: rowData,
          rowIndex: index,
          scrollbarWidth: scrollbarWidth
        });
      });

      var className = __WEBPACK_IMPORTED_MODULE_6_classnames___default()('ReactVirtualized__Table__row', rowClass);
      var flattenedStyle = __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_extends___default()({}, style, rowStyleObject, {
        height: this._getRowHeight(index),
        overflow: 'hidden',
        paddingRight: scrollbarWidth
      });

      return rowRenderer({
        className: className,
        columns: columns,
        index: index,
        isScrolling: isScrolling,
        key: key,
        onRowClick: onRowClick,
        onRowDoubleClick: onRowDoubleClick,
        onRowMouseOver: onRowMouseOver,
        onRowMouseOut: onRowMouseOut,
        rowData: rowData,
        style: flattenedStyle
      });
    }

    /**
     * Determines the flex-shrink, flex-grow, and width values for a cell (header or column).
     */

  }, {
    key: '_getFlexStyleForColumn',
    value: function _getFlexStyleForColumn(column) {
      var customStyle = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      var flexValue = column.props.flexGrow + ' ' + column.props.flexShrink + ' ' + column.props.width + 'px';

      var style = __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_extends___default()({}, customStyle, {
        flex: flexValue,
        msFlex: flexValue,
        WebkitFlex: flexValue
      });

      if (column.props.maxWidth) {
        style.maxWidth = column.props.maxWidth;
      }

      if (column.props.minWidth) {
        style.minWidth = column.props.minWidth;
      }

      return style;
    }
  }, {
    key: '_getHeaderColumns',
    value: function _getHeaderColumns() {
      var _this4 = this;

      var _props4 = this.props,
          children = _props4.children,
          disableHeader = _props4.disableHeader;

      var items = disableHeader ? [] : __WEBPACK_IMPORTED_MODULE_9_react___default.a.Children.toArray(children);

      return items.map(function (column, index) {
        return _this4._createHeader({ column: column, index: index });
      });
    }
  }, {
    key: '_getRowHeight',
    value: function _getRowHeight(rowIndex) {
      var rowHeight = this.props.rowHeight;


      return typeof rowHeight === 'function' ? rowHeight({ index: rowIndex }) : rowHeight;
    }
  }, {
    key: '_onScroll',
    value: function _onScroll(_ref5) {
      var clientHeight = _ref5.clientHeight,
          scrollHeight = _ref5.scrollHeight,
          scrollTop = _ref5.scrollTop;
      var onScroll = this.props.onScroll;


      onScroll({ clientHeight: clientHeight, scrollHeight: scrollHeight, scrollTop: scrollTop });
    }
  }, {
    key: '_onSectionRendered',
    value: function _onSectionRendered(_ref6) {
      var rowOverscanStartIndex = _ref6.rowOverscanStartIndex,
          rowOverscanStopIndex = _ref6.rowOverscanStopIndex,
          rowStartIndex = _ref6.rowStartIndex,
          rowStopIndex = _ref6.rowStopIndex;
      var onRowsRendered = this.props.onRowsRendered;


      onRowsRendered({
        overscanStartIndex: rowOverscanStartIndex,
        overscanStopIndex: rowOverscanStopIndex,
        startIndex: rowStartIndex,
        stopIndex: rowStopIndex
      });
    }
  }, {
    key: '_setRef',
    value: function _setRef(ref) {
      this.Grid = ref;
    }
  }, {
    key: '_setScrollbarWidth',
    value: function _setScrollbarWidth() {
      var Grid = Object(__WEBPACK_IMPORTED_MODULE_10_react_dom__["findDOMNode"])(this.Grid);
      var clientWidth = Grid.clientWidth || 0;
      var offsetWidth = Grid.offsetWidth || 0;
      var scrollbarWidth = offsetWidth - clientWidth;

      this.setState({ scrollbarWidth: scrollbarWidth });
    }
  }]);

  return Table;
}(__WEBPACK_IMPORTED_MODULE_9_react__["PureComponent"]);

Table.defaultProps = {
  disableHeader: false,
  estimatedRowSize: 30,
  headerHeight: 0,
  headerStyle: {},
  noRowsRenderer: function noRowsRenderer() {
    return null;
  },
  onRowsRendered: function onRowsRendered() {
    return null;
  },
  onScroll: function onScroll() {
    return null;
  },
  overscanIndicesGetter: __WEBPACK_IMPORTED_MODULE_11__Grid__["b" /* accessibilityOverscanIndicesGetter */],
  overscanRowCount: 10,
  rowRenderer: __WEBPACK_IMPORTED_MODULE_12__defaultRowRenderer__["a" /* default */],
  headerRowRenderer: __WEBPACK_IMPORTED_MODULE_13__defaultHeaderRowRenderer__["a" /* default */],
  rowStyle: {},
  scrollToAlignment: 'auto',
  scrollToIndex: -1,
  style: {}
};
/* harmony default export */ __webpack_exports__["a"] = (Table);
process.env.NODE_ENV !== "production" ? Table.propTypes = {
  'aria-label': __WEBPACK_IMPORTED_MODULE_8_prop_types___default.a.string,

  /**
   * Removes fixed height from the scrollingContainer so that the total height
   * of rows can stretch the window. Intended for use with WindowScroller
   */
  autoHeight: __WEBPACK_IMPORTED_MODULE_8_prop_types___default.a.bool,

  /** One or more Columns describing the data displayed in this row */
  children: function children(props, propName, componentName) {
    var children = __WEBPACK_IMPORTED_MODULE_9_react___default.a.Children.toArray(props.children);
    for (var i = 0; i < children.length; i++) {
      if (children[i].type !== __WEBPACK_IMPORTED_MODULE_7__Column__["a" /* default */]) {
        return new Error('Table only accepts children of type Column');
      }
    }
  },

  /** Optional CSS class name */
  className: __WEBPACK_IMPORTED_MODULE_8_prop_types___default.a.string,

  /** Disable rendering the header at all */
  disableHeader: __WEBPACK_IMPORTED_MODULE_8_prop_types___default.a.bool,

  /**
   * Used to estimate the total height of a Table before all of its rows have actually been measured.
   * The estimated total height is adjusted as rows are rendered.
   */
  estimatedRowSize: __WEBPACK_IMPORTED_MODULE_8_prop_types___default.a.number.isRequired,

  /** Optional custom CSS class name to attach to inner Grid element. */
  gridClassName: __WEBPACK_IMPORTED_MODULE_8_prop_types___default.a.string,

  /** Optional inline style to attach to inner Grid element. */
  gridStyle: __WEBPACK_IMPORTED_MODULE_8_prop_types___default.a.object,

  /** Optional CSS class to apply to all column headers */
  headerClassName: __WEBPACK_IMPORTED_MODULE_8_prop_types___default.a.string,

  /** Fixed height of header row */
  headerHeight: __WEBPACK_IMPORTED_MODULE_8_prop_types___default.a.number.isRequired,

  /**
   * Responsible for rendering a table row given an array of columns:
   * Should implement the following interface: ({
   *   className: string,
   *   columns: any[],
   *   style: any
   * }): PropTypes.node
   */
  headerRowRenderer: __WEBPACK_IMPORTED_MODULE_8_prop_types___default.a.func,

  /** Optional custom inline style to attach to table header columns. */
  headerStyle: __WEBPACK_IMPORTED_MODULE_8_prop_types___default.a.object,

  /** Fixed/available height for out DOM element */
  height: __WEBPACK_IMPORTED_MODULE_8_prop_types___default.a.number.isRequired,

  /** Optional id */
  id: __WEBPACK_IMPORTED_MODULE_8_prop_types___default.a.string,

  /** Optional renderer to be used in place of table body rows when rowCount is 0 */
  noRowsRenderer: __WEBPACK_IMPORTED_MODULE_8_prop_types___default.a.func,

  /**
  * Optional callback when a column's header is clicked.
  * ({ columnData: any, dataKey: string }): void
  */
  onHeaderClick: __WEBPACK_IMPORTED_MODULE_8_prop_types___default.a.func,

  /**
   * Callback invoked when a user clicks on a table row.
   * ({ index: number }): void
   */
  onRowClick: __WEBPACK_IMPORTED_MODULE_8_prop_types___default.a.func,

  /**
   * Callback invoked when a user double-clicks on a table row.
   * ({ index: number }): void
   */
  onRowDoubleClick: __WEBPACK_IMPORTED_MODULE_8_prop_types___default.a.func,

  /**
   * Callback invoked when the mouse leaves a table row.
   * ({ index: number }): void
   */
  onRowMouseOut: __WEBPACK_IMPORTED_MODULE_8_prop_types___default.a.func,

  /**
   * Callback invoked when a user moves the mouse over a table row.
   * ({ index: number }): void
   */
  onRowMouseOver: __WEBPACK_IMPORTED_MODULE_8_prop_types___default.a.func,

  /**
   * Callback invoked with information about the slice of rows that were just rendered.
   * ({ startIndex, stopIndex }): void
   */
  onRowsRendered: __WEBPACK_IMPORTED_MODULE_8_prop_types___default.a.func,

  /**
   * Callback invoked whenever the scroll offset changes within the inner scrollable region.
   * This callback can be used to sync scrolling between lists, tables, or grids.
   * ({ clientHeight, scrollHeight, scrollTop }): void
   */
  onScroll: __WEBPACK_IMPORTED_MODULE_8_prop_types___default.a.func.isRequired,

  /** See Grid#overscanIndicesGetter */
  overscanIndicesGetter: __WEBPACK_IMPORTED_MODULE_8_prop_types___default.a.func.isRequired,

  /**
   * Number of rows to render above/below the visible bounds of the list.
   * These rows can help for smoother scrolling on touch devices.
   */
  overscanRowCount: __WEBPACK_IMPORTED_MODULE_8_prop_types___default.a.number.isRequired,

  /**
   * Optional CSS class to apply to all table rows (including the header row).
   * This property can be a CSS class name (string) or a function that returns a class name.
   * If a function is provided its signature should be: ({ index: number }): string
   */
  rowClassName: __WEBPACK_IMPORTED_MODULE_8_prop_types___default.a.oneOfType([__WEBPACK_IMPORTED_MODULE_8_prop_types___default.a.string, __WEBPACK_IMPORTED_MODULE_8_prop_types___default.a.func]),

  /**
   * Callback responsible for returning a data row given an index.
   * ({ index: number }): any
   */
  rowGetter: __WEBPACK_IMPORTED_MODULE_8_prop_types___default.a.func.isRequired,

  /**
   * Either a fixed row height (number) or a function that returns the height of a row given its index.
   * ({ index: number }): number
   */
  rowHeight: __WEBPACK_IMPORTED_MODULE_8_prop_types___default.a.oneOfType([__WEBPACK_IMPORTED_MODULE_8_prop_types___default.a.number, __WEBPACK_IMPORTED_MODULE_8_prop_types___default.a.func]).isRequired,

  /** Number of rows in table. */
  rowCount: __WEBPACK_IMPORTED_MODULE_8_prop_types___default.a.number.isRequired,

  /**
   * Responsible for rendering a table row given an array of columns:
   * Should implement the following interface: ({
   *   className: string,
   *   columns: Array,
   *   index: number,
   *   isScrolling: boolean,
   *   onRowClick: ?Function,
   *   onRowDoubleClick: ?Function,
   *   onRowMouseOver: ?Function,
   *   onRowMouseOut: ?Function,
   *   rowData: any,
   *   style: any
   * }): PropTypes.node
   */
  rowRenderer: __WEBPACK_IMPORTED_MODULE_8_prop_types___default.a.func,

  /** Optional custom inline style to attach to table rows. */
  rowStyle: __WEBPACK_IMPORTED_MODULE_8_prop_types___default.a.oneOfType([__WEBPACK_IMPORTED_MODULE_8_prop_types___default.a.object, __WEBPACK_IMPORTED_MODULE_8_prop_types___default.a.func]).isRequired,

  /** See Grid#scrollToAlignment */
  scrollToAlignment: __WEBPACK_IMPORTED_MODULE_8_prop_types___default.a.oneOf(['auto', 'end', 'start', 'center']).isRequired,

  /** Row index to ensure visible (by forcefully scrolling if necessary) */
  scrollToIndex: __WEBPACK_IMPORTED_MODULE_8_prop_types___default.a.number.isRequired,

  /** Vertical offset. */
  scrollTop: __WEBPACK_IMPORTED_MODULE_8_prop_types___default.a.number,

  /**
   * Sort function to be called if a sortable header is clicked.
   * ({ sortBy: string, sortDirection: SortDirection }): void
   */
  sort: __WEBPACK_IMPORTED_MODULE_8_prop_types___default.a.func,

  /** Table data is currently sorted by this :dataKey (if it is sorted at all) */
  sortBy: __WEBPACK_IMPORTED_MODULE_8_prop_types___default.a.string,

  /** Table data is currently sorted in this direction (if it is sorted at all) */
  sortDirection: __WEBPACK_IMPORTED_MODULE_8_prop_types___default.a.oneOf([__WEBPACK_IMPORTED_MODULE_14__SortDirection__["a" /* default */].ASC, __WEBPACK_IMPORTED_MODULE_14__SortDirection__["a" /* default */].DESC]),

  /** Optional inline style */
  style: __WEBPACK_IMPORTED_MODULE_8_prop_types___default.a.object,

  /** Tab index for focus */
  tabIndex: __WEBPACK_IMPORTED_MODULE_8_prop_types___default.a.number,

  /** Width of list */
  width: __WEBPACK_IMPORTED_MODULE_8_prop_types___default.a.number.isRequired
} : void 0;
/* WEBPACK VAR INJECTION */}.call(__webpack_exports__, __webpack_require__(1)))

/***/ }),
/* 114 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function(process) {/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_core_js_object_get_prototype_of__ = __webpack_require__(5);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_core_js_object_get_prototype_of___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_babel_runtime_core_js_object_get_prototype_of__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_classCallCheck__ = __webpack_require__(2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_classCallCheck___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_classCallCheck__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_possibleConstructorReturn__ = __webpack_require__(6);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_possibleConstructorReturn___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_possibleConstructorReturn__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_babel_runtime_helpers_inherits__ = __webpack_require__(7);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_babel_runtime_helpers_inherits___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_3_babel_runtime_helpers_inherits__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_prop_types__ = __webpack_require__(3);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_prop_types___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_4_prop_types__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5_react__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_5_react__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6__defaultHeaderRenderer__ = __webpack_require__(115);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7__defaultCellRenderer__ = __webpack_require__(117);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_8__defaultCellDataGetter__ = __webpack_require__(118);
/**
 * Describes the header and cell contents of a table column.
 */

var Column = function (_Component) {
  __WEBPACK_IMPORTED_MODULE_3_babel_runtime_helpers_inherits___default()(Column, _Component);

  function Column() {
    __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_classCallCheck___default()(this, Column);

    return __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_possibleConstructorReturn___default()(this, (Column.__proto__ || __WEBPACK_IMPORTED_MODULE_0_babel_runtime_core_js_object_get_prototype_of___default()(Column)).apply(this, arguments));
  }

  return Column;
}(__WEBPACK_IMPORTED_MODULE_5_react__["Component"]);

Column.defaultProps = {
  cellDataGetter: __WEBPACK_IMPORTED_MODULE_8__defaultCellDataGetter__["a" /* default */],
  cellRenderer: __WEBPACK_IMPORTED_MODULE_7__defaultCellRenderer__["a" /* default */],
  flexGrow: 0,
  flexShrink: 1,
  headerRenderer: __WEBPACK_IMPORTED_MODULE_6__defaultHeaderRenderer__["a" /* default */],
  style: {}
};
/* harmony default export */ __webpack_exports__["a"] = (Column);
process.env.NODE_ENV !== "production" ? Column.propTypes = {
  /** Optional aria-label value to set on the column header */
  'aria-label': __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.string,

  /**
   * Callback responsible for returning a cell's data, given its :dataKey
   * ({ columnData: any, dataKey: string, rowData: any }): any
   */
  cellDataGetter: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.func,

  /**
   * Callback responsible for rendering a cell's contents.
   * ({ cellData: any, columnData: any, dataKey: string, rowData: any, rowIndex: number }): node
   */
  cellRenderer: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.func,

  /** Optional CSS class to apply to cell */
  className: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.string,

  /** Optional additional data passed to this column's :cellDataGetter */
  columnData: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.object,

  /** Uniquely identifies the row-data attribute correspnding to this cell */
  dataKey: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.any.isRequired,

  /** If sort is enabled for the table at large, disable it for this column */
  disableSort: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.bool,

  /** Flex grow style; defaults to 0 */
  flexGrow: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.number,

  /** Flex shrink style; defaults to 1 */
  flexShrink: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.number,

  /** Optional CSS class to apply to this column's header */
  headerClassName: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.string,

  /**
   * Optional callback responsible for rendering a column header contents.
   * ({ columnData: object, dataKey: string, disableSort: boolean, label: node, sortBy: string, sortDirection: string }): PropTypes.node
   */
  headerRenderer: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.func.isRequired,

  /** Optional id to set on the column header */
  id: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.string,

  /** Header label for this column */
  label: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.node,

  /** Maximum width of column; this property will only be used if :flexGrow is > 0. */
  maxWidth: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.number,

  /** Minimum width of column. */
  minWidth: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.number,

  /** Optional inline style to apply to cell */
  style: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.object,

  /** Flex basis (width) for this column; This value can grow or shrink based on :flexGrow and :flexShrink properties. */
  width: __WEBPACK_IMPORTED_MODULE_4_prop_types___default.a.number.isRequired
} : void 0;
/* WEBPACK VAR INJECTION */}.call(__webpack_exports__, __webpack_require__(1)))

/***/ }),
/* 115 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (immutable) */ __webpack_exports__["a"] = defaultHeaderRenderer;
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_react__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__SortIndicator__ = __webpack_require__(116);




/**
 * Default table header renderer.
 */
function defaultHeaderRenderer(_ref) {
  var columnData = _ref.columnData,
      dataKey = _ref.dataKey,
      disableSort = _ref.disableSort,
      label = _ref.label,
      sortBy = _ref.sortBy,
      sortDirection = _ref.sortDirection;

  var showSortIndicator = sortBy === dataKey;
  var children = [__WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
    'span',
    {
      className: 'ReactVirtualized__Table__headerTruncatedText',
      key: 'label',
      title: label
    },
    label
  )];

  if (showSortIndicator) {
    children.push(__WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_1__SortIndicator__["a" /* default */], {
      key: 'SortIndicator',
      sortDirection: sortDirection
    }));
  }

  return children;
}

/***/ }),
/* 116 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function(process) {/* harmony export (immutable) */ __webpack_exports__["a"] = SortIndicator;
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_classnames__ = __webpack_require__(24);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_classnames___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_classnames__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_prop_types__ = __webpack_require__(3);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_prop_types___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_prop_types__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_react__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2_react__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__SortDirection__ = __webpack_require__(71);





/**
 * Displayed beside a header to indicate that a Table is currently sorted by this column.
 */
function SortIndicator(_ref) {
  var sortDirection = _ref.sortDirection;

  var classNames = __WEBPACK_IMPORTED_MODULE_0_classnames___default()('ReactVirtualized__Table__sortableHeaderIcon', {
    'ReactVirtualized__Table__sortableHeaderIcon--ASC': sortDirection === __WEBPACK_IMPORTED_MODULE_3__SortDirection__["a" /* default */].ASC,
    'ReactVirtualized__Table__sortableHeaderIcon--DESC': sortDirection === __WEBPACK_IMPORTED_MODULE_3__SortDirection__["a" /* default */].DESC
  });

  return __WEBPACK_IMPORTED_MODULE_2_react___default.a.createElement(
    'svg',
    {
      className: classNames,
      width: 18,
      height: 18,
      viewBox: '0 0 24 24'
    },
    sortDirection === __WEBPACK_IMPORTED_MODULE_3__SortDirection__["a" /* default */].ASC ? __WEBPACK_IMPORTED_MODULE_2_react___default.a.createElement('path', { d: 'M7 14l5-5 5 5z' }) : __WEBPACK_IMPORTED_MODULE_2_react___default.a.createElement('path', { d: 'M7 10l5 5 5-5z' }),
    __WEBPACK_IMPORTED_MODULE_2_react___default.a.createElement('path', { d: 'M0 0h24v24H0z', fill: 'none' })
  );
}

process.env.NODE_ENV !== "production" ? SortIndicator.propTypes = {
  sortDirection: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.oneOf([__WEBPACK_IMPORTED_MODULE_3__SortDirection__["a" /* default */].ASC, __WEBPACK_IMPORTED_MODULE_3__SortDirection__["a" /* default */].DESC])
} : void 0;
/* WEBPACK VAR INJECTION */}.call(__webpack_exports__, __webpack_require__(1)))

/***/ }),
/* 117 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (immutable) */ __webpack_exports__["a"] = defaultCellRenderer;


/**
 * Default cell renderer that displays an attribute as a simple string
 * You should override the column's cellRenderer if your data is some other type of object.
 */
function defaultCellRenderer(_ref) {
  var cellData = _ref.cellData,
      columnData = _ref.columnData,
      columnIndex = _ref.columnIndex,
      dataKey = _ref.dataKey,
      isScrolling = _ref.isScrolling,
      rowData = _ref.rowData,
      rowIndex = _ref.rowIndex;

  if (cellData == null) {
    return '';
  } else {
    return String(cellData);
  }
}

/***/ }),
/* 118 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (immutable) */ __webpack_exports__["a"] = defaultCellDataGetter;


/**
 * Default accessor for returning a cell value for a given attribute.
 * This function expects to operate on either a vanilla Object or an Immutable Map.
 * You should override the column's cellDataGetter if your data is some other type of object.
 */
function defaultCellDataGetter(_ref) {
  var columnData = _ref.columnData,
      dataKey = _ref.dataKey,
      rowData = _ref.rowData;

  if (typeof rowData.get === 'function') {
    return rowData.get(dataKey);
  } else {
    return rowData[dataKey];
  }
}

/***/ }),
/* 119 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (immutable) */ __webpack_exports__["a"] = defaultRowRenderer;
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_extends__ = __webpack_require__(12);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_extends___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_extends__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_react__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_react__);




/**
 * Default row renderer for Table.
 */
function defaultRowRenderer(_ref) {
  var className = _ref.className,
      columns = _ref.columns,
      index = _ref.index,
      isScrolling = _ref.isScrolling,
      key = _ref.key,
      onRowClick = _ref.onRowClick,
      onRowDoubleClick = _ref.onRowDoubleClick,
      onRowMouseOver = _ref.onRowMouseOver,
      onRowMouseOut = _ref.onRowMouseOut,
      rowData = _ref.rowData,
      style = _ref.style;

  var a11yProps = {};

  if (onRowClick || onRowDoubleClick || onRowMouseOver || onRowMouseOut) {
    a11yProps['aria-label'] = 'row';
    a11yProps.tabIndex = 0;

    if (onRowClick) {
      a11yProps.onClick = function (event) {
        return onRowClick({ event: event, index: index, rowData: rowData });
      };
    }
    if (onRowDoubleClick) {
      a11yProps.onDoubleClick = function (event) {
        return onRowDoubleClick({ event: event, index: index, rowData: rowData });
      };
    }
    if (onRowMouseOut) {
      a11yProps.onMouseOut = function (event) {
        return onRowMouseOut({ event: event, index: index, rowData: rowData });
      };
    }
    if (onRowMouseOver) {
      a11yProps.onMouseOver = function (event) {
        return onRowMouseOver({ event: event, index: index, rowData: rowData });
      };
    }
  }

  return __WEBPACK_IMPORTED_MODULE_1_react___default.a.createElement(
    'div',
    __WEBPACK_IMPORTED_MODULE_0_babel_runtime_helpers_extends___default()({}, a11yProps, {
      className: className,
      key: key,
      role: 'row',
      style: style
    }),
    columns
  );
}

/***/ }),
/* 120 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (immutable) */ __webpack_exports__["a"] = defaultHeaderRowRenderer;
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_react__);



function defaultHeaderRowRenderer(_ref) {
  var className = _ref.className,
      columns = _ref.columns,
      style = _ref.style;

  return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
    'div',
    {
      className: className,
      role: 'row',
      style: style
    },
    columns
  );
}

/***/ }),
/* 121 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function(process) {/* unused harmony export IS_SCROLLING_TIMEOUT */
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_core_js_object_get_prototype_of__ = __webpack_require__(5);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_babel_runtime_core_js_object_get_prototype_of___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_babel_runtime_core_js_object_get_prototype_of__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_classCallCheck__ = __webpack_require__(2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_classCallCheck___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_classCallCheck__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_createClass__ = __webpack_require__(4);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_createClass___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_createClass__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_babel_runtime_helpers_possibleConstructorReturn__ = __webpack_require__(6);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_babel_runtime_helpers_possibleConstructorReturn___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_3_babel_runtime_helpers_possibleConstructorReturn__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_babel_runtime_helpers_inherits__ = __webpack_require__(7);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_babel_runtime_helpers_inherits___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_4_babel_runtime_helpers_inherits__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5_prop_types__ = __webpack_require__(3);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5_prop_types___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_5_prop_types__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6_react__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_6_react__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7_react_dom__ = __webpack_require__(23);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7_react_dom___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_7_react_dom__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_8__utils_onScroll__ = __webpack_require__(122);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_9__utils_dimensions__ = __webpack_require__(239);
/**
 * Specifies the number of miliseconds during which to disable pointer events while a scroll is in progress.
 * This improves performance and makes scrolling smoother.
 */
var IS_SCROLLING_TIMEOUT = 150;

var WindowScroller = function (_PureComponent) {
  __WEBPACK_IMPORTED_MODULE_4_babel_runtime_helpers_inherits___default()(WindowScroller, _PureComponent);

  function WindowScroller(props) {
    __WEBPACK_IMPORTED_MODULE_1_babel_runtime_helpers_classCallCheck___default()(this, WindowScroller);

    // Handle server-side rendering case
    var _this = __WEBPACK_IMPORTED_MODULE_3_babel_runtime_helpers_possibleConstructorReturn___default()(this, (WindowScroller.__proto__ || __WEBPACK_IMPORTED_MODULE_0_babel_runtime_core_js_object_get_prototype_of___default()(WindowScroller)).call(this, props));

    var _ref = typeof window !== 'undefined' ? Object(__WEBPACK_IMPORTED_MODULE_9__utils_dimensions__["a" /* getDimensions */])(props.scrollElement || window) : { width: 0, height: 0 },
        width = _ref.width,
        height = _ref.height;

    _this.state = {
      height: height,
      width: width,
      isScrolling: false,
      scrollLeft: 0,
      scrollTop: 0
    };

    _this._onResize = _this._onResize.bind(_this);
    _this._onChildScroll = _this._onChildScroll.bind(_this);
    _this.__handleWindowScrollEvent = _this.__handleWindowScrollEvent.bind(_this);
    _this.__resetIsScrolling = _this.__resetIsScrolling.bind(_this);
    return _this;
  }

  // Can’t use defaultProps for scrollElement without breaking server-side rendering


  __WEBPACK_IMPORTED_MODULE_2_babel_runtime_helpers_createClass___default()(WindowScroller, [{
    key: 'updatePosition',
    value: function updatePosition(scrollElement) {
      var onResize = this.props.onResize;
      var _state = this.state,
          height = _state.height,
          width = _state.width;


      scrollElement = scrollElement || this.props.scrollElement || window;
      var offset = Object(__WEBPACK_IMPORTED_MODULE_9__utils_dimensions__["b" /* getPositionOffset */])(__WEBPACK_IMPORTED_MODULE_7_react_dom___default.a.findDOMNode(this), scrollElement);
      this._positionFromTop = offset.top;
      this._positionFromLeft = offset.left;

      var dimensions = Object(__WEBPACK_IMPORTED_MODULE_9__utils_dimensions__["a" /* getDimensions */])(scrollElement);
      if (height !== dimensions.height || width !== dimensions.width) {
        this.setState({
          height: dimensions.height,
          width: dimensions.width
        });
        onResize({
          height: dimensions.height,
          width: dimensions.width
        });
      }
    }
  }, {
    key: 'componentDidMount',
    value: function componentDidMount() {
      var scrollElement = this.props.scrollElement || window;

      this.updatePosition(scrollElement);

      Object(__WEBPACK_IMPORTED_MODULE_8__utils_onScroll__["a" /* registerScrollListener */])(this, scrollElement);

      window.addEventListener('resize', this._onResize, false);

      this._isMounted = true;
    }
  }, {
    key: 'componentWillReceiveProps',
    value: function componentWillReceiveProps(nextProps) {
      var scrollElement = this.props.scrollElement || window;
      var nextScrollElement = nextProps.scrollElement || window;

      if (scrollElement !== nextScrollElement) {
        this.updatePosition(nextScrollElement);

        Object(__WEBPACK_IMPORTED_MODULE_8__utils_onScroll__["b" /* unregisterScrollListener */])(this, scrollElement);
        Object(__WEBPACK_IMPORTED_MODULE_8__utils_onScroll__["a" /* registerScrollListener */])(this, nextScrollElement);
      }
    }
  }, {
    key: 'componentWillUnmount',
    value: function componentWillUnmount() {
      Object(__WEBPACK_IMPORTED_MODULE_8__utils_onScroll__["b" /* unregisterScrollListener */])(this, this.props.scrollElement || window);
      window.removeEventListener('resize', this._onResize, false);

      this._isMounted = false;
    }
  }, {
    key: 'render',
    value: function render() {
      var children = this.props.children;
      var _state2 = this.state,
          isScrolling = _state2.isScrolling,
          scrollTop = _state2.scrollTop,
          scrollLeft = _state2.scrollLeft,
          height = _state2.height,
          width = _state2.width;


      return children({
        onChildScroll: this._onChildScroll,
        height: height,
        isScrolling: isScrolling,
        scrollLeft: scrollLeft,
        scrollTop: scrollTop,
        width: width
      });
    }
  }, {
    key: '_onChildScroll',
    value: function _onChildScroll(_ref2) {
      var scrollTop = _ref2.scrollTop;

      if (this.state.scrollTop === scrollTop) return;

      var scrollElement = this.scrollElement;

      if (typeof scrollElement.scrollTo === 'function') {
        scrollElement.scrollTo(0, scrollTop + this._positionFromTop);
      } else {
        scrollElement.scrollTop = scrollTop + this._positionFromTop;
      }
    }
  }, {
    key: '_onResize',
    value: function _onResize(event) {
      this.updatePosition();
    }

    // Referenced by utils/onScroll

  }, {
    key: '__handleWindowScrollEvent',
    value: function __handleWindowScrollEvent(event) {
      if (!this._isMounted) return;

      var onScroll = this.props.onScroll;


      var scrollElement = this.props.scrollElement || window;
      var scrollOffset = Object(__WEBPACK_IMPORTED_MODULE_9__utils_dimensions__["c" /* getScrollOffset */])(scrollElement);
      var scrollLeft = Math.max(0, scrollOffset.left - this._positionFromLeft);
      var scrollTop = Math.max(0, scrollOffset.top - this._positionFromTop);

      this.setState({
        isScrolling: true,
        scrollLeft: scrollLeft,
        scrollTop: scrollTop
      });

      onScroll({
        scrollLeft: scrollLeft,
        scrollTop: scrollTop
      });
    }

    // Referenced by utils/onScroll

  }, {
    key: '__resetIsScrolling',
    value: function __resetIsScrolling() {
      this.setState({
        isScrolling: false
      });
    }
  }, {
    key: 'scrollElement',
    get: function get() {
      return this.props.scrollElement || window;
    }
  }]);

  return WindowScroller;
}(__WEBPACK_IMPORTED_MODULE_6_react__["PureComponent"]);

WindowScroller.defaultProps = {
  onResize: function onResize() {},
  onScroll: function onScroll() {},
  scrollingResetTimeInterval: IS_SCROLLING_TIMEOUT
};
/* harmony default export */ __webpack_exports__["a"] = (WindowScroller);
process.env.NODE_ENV !== "production" ? WindowScroller.propTypes = {
  /**
   * Function responsible for rendering children.
   * This function should implement the following signature:
   * ({ height, isScrolling, scrollLeft, scrollTop, width }) => PropTypes.element
   */
  children: __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.func.isRequired,

  /** Callback to be invoked on-resize: ({ height, width }) */
  onResize: __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.func.isRequired,

  /** Callback to be invoked on-scroll: ({ scrollLeft, scrollTop }) */
  onScroll: __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.func.isRequired,

  /** Element to attach scroll event listeners. Defaults to window. */
  scrollElement: __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.any,

  /**
   * Wait this amount of time after the last scroll event before resetting child `pointer-events`.
   */
  scrollingResetTimeInterval: __WEBPACK_IMPORTED_MODULE_5_prop_types___default.a.number.isRequired
} : void 0;
/* WEBPACK VAR INJECTION */}.call(__webpack_exports__, __webpack_require__(1)))

/***/ }),
/* 122 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (immutable) */ __webpack_exports__["a"] = registerScrollListener;
/* harmony export (immutable) */ __webpack_exports__["b"] = unregisterScrollListener;
var mountedInstances = [];
var originalBodyPointerEvents = null;
var disablePointerEventsTimeoutId = null;

function enablePointerEventsIfDisabled() {
  if (disablePointerEventsTimeoutId) {
    disablePointerEventsTimeoutId = null;

    document.body.style.pointerEvents = originalBodyPointerEvents;

    originalBodyPointerEvents = null;
  }
}

function enablePointerEventsAfterDelayCallback() {
  enablePointerEventsIfDisabled();
  mountedInstances.forEach(function (instance) {
    return instance.__resetIsScrolling();
  });
}

function enablePointerEventsAfterDelay() {
  if (disablePointerEventsTimeoutId) {
    clearTimeout(disablePointerEventsTimeoutId);
  }

  var maximumTimeout = 0;
  mountedInstances.forEach(function (instance) {
    maximumTimeout = Math.max(maximumTimeout, instance.props.scrollingResetTimeInterval);
  });

  disablePointerEventsTimeoutId = setTimeout(enablePointerEventsAfterDelayCallback, maximumTimeout);
}

function onScrollWindow(event) {
  if (event.currentTarget === window && originalBodyPointerEvents == null) {
    originalBodyPointerEvents = document.body.style.pointerEvents;

    document.body.style.pointerEvents = 'none';
  }
  enablePointerEventsAfterDelay();
  mountedInstances.forEach(function (instance) {
    if (instance.scrollElement === event.currentTarget) {
      instance.__handleWindowScrollEvent(event);
    }
  });
}

function registerScrollListener(component, element) {
  if (!mountedInstances.some(function (instance) {
    return instance.scrollElement === element;
  })) {
    element.addEventListener('scroll', onScrollWindow);
  }
  mountedInstances.push(component);
}

function unregisterScrollListener(component, element) {
  mountedInstances = mountedInstances.filter(function (instance) {
    return instance !== component;
  });
  if (!mountedInstances.length) {
    element.removeEventListener('scroll', onScrollWindow);
    if (disablePointerEventsTimeoutId) {
      clearTimeout(disablePointerEventsTimeoutId);
      enablePointerEventsIfDisabled();
    }
  }
}

/***/ }),
/* 123 */
/***/ (function(module, exports, __webpack_require__) {

/* WEBPACK VAR INJECTION */(function(global, module) {/**
 * Lodash (Custom Build) <https://lodash.com/>
 * Build: `lodash modularize exports="npm" -o ./`
 * Copyright JS Foundation and other contributors <https://js.foundation/>
 * Released under MIT license <https://lodash.com/license>
 * Based on Underscore.js 1.8.3 <http://underscorejs.org/LICENSE>
 * Copyright Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
 */

/** Used as the size to enable large array optimizations. */
var LARGE_ARRAY_SIZE = 200;

/** Used to stand-in for `undefined` hash values. */
var HASH_UNDEFINED = '__lodash_hash_undefined__';

/** Used to compose bitmasks for value comparisons. */
var COMPARE_PARTIAL_FLAG = 1,
    COMPARE_UNORDERED_FLAG = 2;

/** Used as references for various `Number` constants. */
var MAX_SAFE_INTEGER = 9007199254740991;

/** `Object#toString` result references. */
var argsTag = '[object Arguments]',
    arrayTag = '[object Array]',
    asyncTag = '[object AsyncFunction]',
    boolTag = '[object Boolean]',
    dateTag = '[object Date]',
    errorTag = '[object Error]',
    funcTag = '[object Function]',
    genTag = '[object GeneratorFunction]',
    mapTag = '[object Map]',
    numberTag = '[object Number]',
    nullTag = '[object Null]',
    objectTag = '[object Object]',
    promiseTag = '[object Promise]',
    proxyTag = '[object Proxy]',
    regexpTag = '[object RegExp]',
    setTag = '[object Set]',
    stringTag = '[object String]',
    symbolTag = '[object Symbol]',
    undefinedTag = '[object Undefined]',
    weakMapTag = '[object WeakMap]';

var arrayBufferTag = '[object ArrayBuffer]',
    dataViewTag = '[object DataView]',
    float32Tag = '[object Float32Array]',
    float64Tag = '[object Float64Array]',
    int8Tag = '[object Int8Array]',
    int16Tag = '[object Int16Array]',
    int32Tag = '[object Int32Array]',
    uint8Tag = '[object Uint8Array]',
    uint8ClampedTag = '[object Uint8ClampedArray]',
    uint16Tag = '[object Uint16Array]',
    uint32Tag = '[object Uint32Array]';

/**
 * Used to match `RegExp`
 * [syntax characters](http://ecma-international.org/ecma-262/7.0/#sec-patterns).
 */
var reRegExpChar = /[\\^$.*+?()[\]{}|]/g;

/** Used to detect host constructors (Safari). */
var reIsHostCtor = /^\[object .+?Constructor\]$/;

/** Used to detect unsigned integer values. */
var reIsUint = /^(?:0|[1-9]\d*)$/;

/** Used to identify `toStringTag` values of typed arrays. */
var typedArrayTags = {};
typedArrayTags[float32Tag] = typedArrayTags[float64Tag] =
typedArrayTags[int8Tag] = typedArrayTags[int16Tag] =
typedArrayTags[int32Tag] = typedArrayTags[uint8Tag] =
typedArrayTags[uint8ClampedTag] = typedArrayTags[uint16Tag] =
typedArrayTags[uint32Tag] = true;
typedArrayTags[argsTag] = typedArrayTags[arrayTag] =
typedArrayTags[arrayBufferTag] = typedArrayTags[boolTag] =
typedArrayTags[dataViewTag] = typedArrayTags[dateTag] =
typedArrayTags[errorTag] = typedArrayTags[funcTag] =
typedArrayTags[mapTag] = typedArrayTags[numberTag] =
typedArrayTags[objectTag] = typedArrayTags[regexpTag] =
typedArrayTags[setTag] = typedArrayTags[stringTag] =
typedArrayTags[weakMapTag] = false;

/** Detect free variable `global` from Node.js. */
var freeGlobal = typeof global == 'object' && global && global.Object === Object && global;

/** Detect free variable `self`. */
var freeSelf = typeof self == 'object' && self && self.Object === Object && self;

/** Used as a reference to the global object. */
var root = freeGlobal || freeSelf || Function('return this')();

/** Detect free variable `exports`. */
var freeExports = typeof exports == 'object' && exports && !exports.nodeType && exports;

/** Detect free variable `module`. */
var freeModule = freeExports && typeof module == 'object' && module && !module.nodeType && module;

/** Detect the popular CommonJS extension `module.exports`. */
var moduleExports = freeModule && freeModule.exports === freeExports;

/** Detect free variable `process` from Node.js. */
var freeProcess = moduleExports && freeGlobal.process;

/** Used to access faster Node.js helpers. */
var nodeUtil = (function() {
  try {
    return freeProcess && freeProcess.binding && freeProcess.binding('util');
  } catch (e) {}
}());

/* Node.js helper references. */
var nodeIsTypedArray = nodeUtil && nodeUtil.isTypedArray;

/**
 * A specialized version of `_.filter` for arrays without support for
 * iteratee shorthands.
 *
 * @private
 * @param {Array} [array] The array to iterate over.
 * @param {Function} predicate The function invoked per iteration.
 * @returns {Array} Returns the new filtered array.
 */
function arrayFilter(array, predicate) {
  var index = -1,
      length = array == null ? 0 : array.length,
      resIndex = 0,
      result = [];

  while (++index < length) {
    var value = array[index];
    if (predicate(value, index, array)) {
      result[resIndex++] = value;
    }
  }
  return result;
}

/**
 * Appends the elements of `values` to `array`.
 *
 * @private
 * @param {Array} array The array to modify.
 * @param {Array} values The values to append.
 * @returns {Array} Returns `array`.
 */
function arrayPush(array, values) {
  var index = -1,
      length = values.length,
      offset = array.length;

  while (++index < length) {
    array[offset + index] = values[index];
  }
  return array;
}

/**
 * A specialized version of `_.some` for arrays without support for iteratee
 * shorthands.
 *
 * @private
 * @param {Array} [array] The array to iterate over.
 * @param {Function} predicate The function invoked per iteration.
 * @returns {boolean} Returns `true` if any element passes the predicate check,
 *  else `false`.
 */
function arraySome(array, predicate) {
  var index = -1,
      length = array == null ? 0 : array.length;

  while (++index < length) {
    if (predicate(array[index], index, array)) {
      return true;
    }
  }
  return false;
}

/**
 * The base implementation of `_.times` without support for iteratee shorthands
 * or max array length checks.
 *
 * @private
 * @param {number} n The number of times to invoke `iteratee`.
 * @param {Function} iteratee The function invoked per iteration.
 * @returns {Array} Returns the array of results.
 */
function baseTimes(n, iteratee) {
  var index = -1,
      result = Array(n);

  while (++index < n) {
    result[index] = iteratee(index);
  }
  return result;
}

/**
 * The base implementation of `_.unary` without support for storing metadata.
 *
 * @private
 * @param {Function} func The function to cap arguments for.
 * @returns {Function} Returns the new capped function.
 */
function baseUnary(func) {
  return function(value) {
    return func(value);
  };
}

/**
 * Checks if a `cache` value for `key` exists.
 *
 * @private
 * @param {Object} cache The cache to query.
 * @param {string} key The key of the entry to check.
 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
 */
function cacheHas(cache, key) {
  return cache.has(key);
}

/**
 * Gets the value at `key` of `object`.
 *
 * @private
 * @param {Object} [object] The object to query.
 * @param {string} key The key of the property to get.
 * @returns {*} Returns the property value.
 */
function getValue(object, key) {
  return object == null ? undefined : object[key];
}

/**
 * Converts `map` to its key-value pairs.
 *
 * @private
 * @param {Object} map The map to convert.
 * @returns {Array} Returns the key-value pairs.
 */
function mapToArray(map) {
  var index = -1,
      result = Array(map.size);

  map.forEach(function(value, key) {
    result[++index] = [key, value];
  });
  return result;
}

/**
 * Creates a unary function that invokes `func` with its argument transformed.
 *
 * @private
 * @param {Function} func The function to wrap.
 * @param {Function} transform The argument transform.
 * @returns {Function} Returns the new function.
 */
function overArg(func, transform) {
  return function(arg) {
    return func(transform(arg));
  };
}

/**
 * Converts `set` to an array of its values.
 *
 * @private
 * @param {Object} set The set to convert.
 * @returns {Array} Returns the values.
 */
function setToArray(set) {
  var index = -1,
      result = Array(set.size);

  set.forEach(function(value) {
    result[++index] = value;
  });
  return result;
}

/** Used for built-in method references. */
var arrayProto = Array.prototype,
    funcProto = Function.prototype,
    objectProto = Object.prototype;

/** Used to detect overreaching core-js shims. */
var coreJsData = root['__core-js_shared__'];

/** Used to resolve the decompiled source of functions. */
var funcToString = funcProto.toString;

/** Used to check objects for own properties. */
var hasOwnProperty = objectProto.hasOwnProperty;

/** Used to detect methods masquerading as native. */
var maskSrcKey = (function() {
  var uid = /[^.]+$/.exec(coreJsData && coreJsData.keys && coreJsData.keys.IE_PROTO || '');
  return uid ? ('Symbol(src)_1.' + uid) : '';
}());

/**
 * Used to resolve the
 * [`toStringTag`](http://ecma-international.org/ecma-262/7.0/#sec-object.prototype.tostring)
 * of values.
 */
var nativeObjectToString = objectProto.toString;

/** Used to detect if a method is native. */
var reIsNative = RegExp('^' +
  funcToString.call(hasOwnProperty).replace(reRegExpChar, '\\$&')
  .replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g, '$1.*?') + '$'
);

/** Built-in value references. */
var Buffer = moduleExports ? root.Buffer : undefined,
    Symbol = root.Symbol,
    Uint8Array = root.Uint8Array,
    propertyIsEnumerable = objectProto.propertyIsEnumerable,
    splice = arrayProto.splice,
    symToStringTag = Symbol ? Symbol.toStringTag : undefined;

/* Built-in method references for those with the same name as other `lodash` methods. */
var nativeGetSymbols = Object.getOwnPropertySymbols,
    nativeIsBuffer = Buffer ? Buffer.isBuffer : undefined,
    nativeKeys = overArg(Object.keys, Object);

/* Built-in method references that are verified to be native. */
var DataView = getNative(root, 'DataView'),
    Map = getNative(root, 'Map'),
    Promise = getNative(root, 'Promise'),
    Set = getNative(root, 'Set'),
    WeakMap = getNative(root, 'WeakMap'),
    nativeCreate = getNative(Object, 'create');

/** Used to detect maps, sets, and weakmaps. */
var dataViewCtorString = toSource(DataView),
    mapCtorString = toSource(Map),
    promiseCtorString = toSource(Promise),
    setCtorString = toSource(Set),
    weakMapCtorString = toSource(WeakMap);

/** Used to convert symbols to primitives and strings. */
var symbolProto = Symbol ? Symbol.prototype : undefined,
    symbolValueOf = symbolProto ? symbolProto.valueOf : undefined;

/**
 * Creates a hash object.
 *
 * @private
 * @constructor
 * @param {Array} [entries] The key-value pairs to cache.
 */
function Hash(entries) {
  var index = -1,
      length = entries == null ? 0 : entries.length;

  this.clear();
  while (++index < length) {
    var entry = entries[index];
    this.set(entry[0], entry[1]);
  }
}

/**
 * Removes all key-value entries from the hash.
 *
 * @private
 * @name clear
 * @memberOf Hash
 */
function hashClear() {
  this.__data__ = nativeCreate ? nativeCreate(null) : {};
  this.size = 0;
}

/**
 * Removes `key` and its value from the hash.
 *
 * @private
 * @name delete
 * @memberOf Hash
 * @param {Object} hash The hash to modify.
 * @param {string} key The key of the value to remove.
 * @returns {boolean} Returns `true` if the entry was removed, else `false`.
 */
function hashDelete(key) {
  var result = this.has(key) && delete this.__data__[key];
  this.size -= result ? 1 : 0;
  return result;
}

/**
 * Gets the hash value for `key`.
 *
 * @private
 * @name get
 * @memberOf Hash
 * @param {string} key The key of the value to get.
 * @returns {*} Returns the entry value.
 */
function hashGet(key) {
  var data = this.__data__;
  if (nativeCreate) {
    var result = data[key];
    return result === HASH_UNDEFINED ? undefined : result;
  }
  return hasOwnProperty.call(data, key) ? data[key] : undefined;
}

/**
 * Checks if a hash value for `key` exists.
 *
 * @private
 * @name has
 * @memberOf Hash
 * @param {string} key The key of the entry to check.
 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
 */
function hashHas(key) {
  var data = this.__data__;
  return nativeCreate ? (data[key] !== undefined) : hasOwnProperty.call(data, key);
}

/**
 * Sets the hash `key` to `value`.
 *
 * @private
 * @name set
 * @memberOf Hash
 * @param {string} key The key of the value to set.
 * @param {*} value The value to set.
 * @returns {Object} Returns the hash instance.
 */
function hashSet(key, value) {
  var data = this.__data__;
  this.size += this.has(key) ? 0 : 1;
  data[key] = (nativeCreate && value === undefined) ? HASH_UNDEFINED : value;
  return this;
}

// Add methods to `Hash`.
Hash.prototype.clear = hashClear;
Hash.prototype['delete'] = hashDelete;
Hash.prototype.get = hashGet;
Hash.prototype.has = hashHas;
Hash.prototype.set = hashSet;

/**
 * Creates an list cache object.
 *
 * @private
 * @constructor
 * @param {Array} [entries] The key-value pairs to cache.
 */
function ListCache(entries) {
  var index = -1,
      length = entries == null ? 0 : entries.length;

  this.clear();
  while (++index < length) {
    var entry = entries[index];
    this.set(entry[0], entry[1]);
  }
}

/**
 * Removes all key-value entries from the list cache.
 *
 * @private
 * @name clear
 * @memberOf ListCache
 */
function listCacheClear() {
  this.__data__ = [];
  this.size = 0;
}

/**
 * Removes `key` and its value from the list cache.
 *
 * @private
 * @name delete
 * @memberOf ListCache
 * @param {string} key The key of the value to remove.
 * @returns {boolean} Returns `true` if the entry was removed, else `false`.
 */
function listCacheDelete(key) {
  var data = this.__data__,
      index = assocIndexOf(data, key);

  if (index < 0) {
    return false;
  }
  var lastIndex = data.length - 1;
  if (index == lastIndex) {
    data.pop();
  } else {
    splice.call(data, index, 1);
  }
  --this.size;
  return true;
}

/**
 * Gets the list cache value for `key`.
 *
 * @private
 * @name get
 * @memberOf ListCache
 * @param {string} key The key of the value to get.
 * @returns {*} Returns the entry value.
 */
function listCacheGet(key) {
  var data = this.__data__,
      index = assocIndexOf(data, key);

  return index < 0 ? undefined : data[index][1];
}

/**
 * Checks if a list cache value for `key` exists.
 *
 * @private
 * @name has
 * @memberOf ListCache
 * @param {string} key The key of the entry to check.
 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
 */
function listCacheHas(key) {
  return assocIndexOf(this.__data__, key) > -1;
}

/**
 * Sets the list cache `key` to `value`.
 *
 * @private
 * @name set
 * @memberOf ListCache
 * @param {string} key The key of the value to set.
 * @param {*} value The value to set.
 * @returns {Object} Returns the list cache instance.
 */
function listCacheSet(key, value) {
  var data = this.__data__,
      index = assocIndexOf(data, key);

  if (index < 0) {
    ++this.size;
    data.push([key, value]);
  } else {
    data[index][1] = value;
  }
  return this;
}

// Add methods to `ListCache`.
ListCache.prototype.clear = listCacheClear;
ListCache.prototype['delete'] = listCacheDelete;
ListCache.prototype.get = listCacheGet;
ListCache.prototype.has = listCacheHas;
ListCache.prototype.set = listCacheSet;

/**
 * Creates a map cache object to store key-value pairs.
 *
 * @private
 * @constructor
 * @param {Array} [entries] The key-value pairs to cache.
 */
function MapCache(entries) {
  var index = -1,
      length = entries == null ? 0 : entries.length;

  this.clear();
  while (++index < length) {
    var entry = entries[index];
    this.set(entry[0], entry[1]);
  }
}

/**
 * Removes all key-value entries from the map.
 *
 * @private
 * @name clear
 * @memberOf MapCache
 */
function mapCacheClear() {
  this.size = 0;
  this.__data__ = {
    'hash': new Hash,
    'map': new (Map || ListCache),
    'string': new Hash
  };
}

/**
 * Removes `key` and its value from the map.
 *
 * @private
 * @name delete
 * @memberOf MapCache
 * @param {string} key The key of the value to remove.
 * @returns {boolean} Returns `true` if the entry was removed, else `false`.
 */
function mapCacheDelete(key) {
  var result = getMapData(this, key)['delete'](key);
  this.size -= result ? 1 : 0;
  return result;
}

/**
 * Gets the map value for `key`.
 *
 * @private
 * @name get
 * @memberOf MapCache
 * @param {string} key The key of the value to get.
 * @returns {*} Returns the entry value.
 */
function mapCacheGet(key) {
  return getMapData(this, key).get(key);
}

/**
 * Checks if a map value for `key` exists.
 *
 * @private
 * @name has
 * @memberOf MapCache
 * @param {string} key The key of the entry to check.
 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
 */
function mapCacheHas(key) {
  return getMapData(this, key).has(key);
}

/**
 * Sets the map `key` to `value`.
 *
 * @private
 * @name set
 * @memberOf MapCache
 * @param {string} key The key of the value to set.
 * @param {*} value The value to set.
 * @returns {Object} Returns the map cache instance.
 */
function mapCacheSet(key, value) {
  var data = getMapData(this, key),
      size = data.size;

  data.set(key, value);
  this.size += data.size == size ? 0 : 1;
  return this;
}

// Add methods to `MapCache`.
MapCache.prototype.clear = mapCacheClear;
MapCache.prototype['delete'] = mapCacheDelete;
MapCache.prototype.get = mapCacheGet;
MapCache.prototype.has = mapCacheHas;
MapCache.prototype.set = mapCacheSet;

/**
 *
 * Creates an array cache object to store unique values.
 *
 * @private
 * @constructor
 * @param {Array} [values] The values to cache.
 */
function SetCache(values) {
  var index = -1,
      length = values == null ? 0 : values.length;

  this.__data__ = new MapCache;
  while (++index < length) {
    this.add(values[index]);
  }
}

/**
 * Adds `value` to the array cache.
 *
 * @private
 * @name add
 * @memberOf SetCache
 * @alias push
 * @param {*} value The value to cache.
 * @returns {Object} Returns the cache instance.
 */
function setCacheAdd(value) {
  this.__data__.set(value, HASH_UNDEFINED);
  return this;
}

/**
 * Checks if `value` is in the array cache.
 *
 * @private
 * @name has
 * @memberOf SetCache
 * @param {*} value The value to search for.
 * @returns {number} Returns `true` if `value` is found, else `false`.
 */
function setCacheHas(value) {
  return this.__data__.has(value);
}

// Add methods to `SetCache`.
SetCache.prototype.add = SetCache.prototype.push = setCacheAdd;
SetCache.prototype.has = setCacheHas;

/**
 * Creates a stack cache object to store key-value pairs.
 *
 * @private
 * @constructor
 * @param {Array} [entries] The key-value pairs to cache.
 */
function Stack(entries) {
  var data = this.__data__ = new ListCache(entries);
  this.size = data.size;
}

/**
 * Removes all key-value entries from the stack.
 *
 * @private
 * @name clear
 * @memberOf Stack
 */
function stackClear() {
  this.__data__ = new ListCache;
  this.size = 0;
}

/**
 * Removes `key` and its value from the stack.
 *
 * @private
 * @name delete
 * @memberOf Stack
 * @param {string} key The key of the value to remove.
 * @returns {boolean} Returns `true` if the entry was removed, else `false`.
 */
function stackDelete(key) {
  var data = this.__data__,
      result = data['delete'](key);

  this.size = data.size;
  return result;
}

/**
 * Gets the stack value for `key`.
 *
 * @private
 * @name get
 * @memberOf Stack
 * @param {string} key The key of the value to get.
 * @returns {*} Returns the entry value.
 */
function stackGet(key) {
  return this.__data__.get(key);
}

/**
 * Checks if a stack value for `key` exists.
 *
 * @private
 * @name has
 * @memberOf Stack
 * @param {string} key The key of the entry to check.
 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
 */
function stackHas(key) {
  return this.__data__.has(key);
}

/**
 * Sets the stack `key` to `value`.
 *
 * @private
 * @name set
 * @memberOf Stack
 * @param {string} key The key of the value to set.
 * @param {*} value The value to set.
 * @returns {Object} Returns the stack cache instance.
 */
function stackSet(key, value) {
  var data = this.__data__;
  if (data instanceof ListCache) {
    var pairs = data.__data__;
    if (!Map || (pairs.length < LARGE_ARRAY_SIZE - 1)) {
      pairs.push([key, value]);
      this.size = ++data.size;
      return this;
    }
    data = this.__data__ = new MapCache(pairs);
  }
  data.set(key, value);
  this.size = data.size;
  return this;
}

// Add methods to `Stack`.
Stack.prototype.clear = stackClear;
Stack.prototype['delete'] = stackDelete;
Stack.prototype.get = stackGet;
Stack.prototype.has = stackHas;
Stack.prototype.set = stackSet;

/**
 * Creates an array of the enumerable property names of the array-like `value`.
 *
 * @private
 * @param {*} value The value to query.
 * @param {boolean} inherited Specify returning inherited property names.
 * @returns {Array} Returns the array of property names.
 */
function arrayLikeKeys(value, inherited) {
  var isArr = isArray(value),
      isArg = !isArr && isArguments(value),
      isBuff = !isArr && !isArg && isBuffer(value),
      isType = !isArr && !isArg && !isBuff && isTypedArray(value),
      skipIndexes = isArr || isArg || isBuff || isType,
      result = skipIndexes ? baseTimes(value.length, String) : [],
      length = result.length;

  for (var key in value) {
    if ((inherited || hasOwnProperty.call(value, key)) &&
        !(skipIndexes && (
           // Safari 9 has enumerable `arguments.length` in strict mode.
           key == 'length' ||
           // Node.js 0.10 has enumerable non-index properties on buffers.
           (isBuff && (key == 'offset' || key == 'parent')) ||
           // PhantomJS 2 has enumerable non-index properties on typed arrays.
           (isType && (key == 'buffer' || key == 'byteLength' || key == 'byteOffset')) ||
           // Skip index properties.
           isIndex(key, length)
        ))) {
      result.push(key);
    }
  }
  return result;
}

/**
 * Gets the index at which the `key` is found in `array` of key-value pairs.
 *
 * @private
 * @param {Array} array The array to inspect.
 * @param {*} key The key to search for.
 * @returns {number} Returns the index of the matched value, else `-1`.
 */
function assocIndexOf(array, key) {
  var length = array.length;
  while (length--) {
    if (eq(array[length][0], key)) {
      return length;
    }
  }
  return -1;
}

/**
 * The base implementation of `getAllKeys` and `getAllKeysIn` which uses
 * `keysFunc` and `symbolsFunc` to get the enumerable property names and
 * symbols of `object`.
 *
 * @private
 * @param {Object} object The object to query.
 * @param {Function} keysFunc The function to get the keys of `object`.
 * @param {Function} symbolsFunc The function to get the symbols of `object`.
 * @returns {Array} Returns the array of property names and symbols.
 */
function baseGetAllKeys(object, keysFunc, symbolsFunc) {
  var result = keysFunc(object);
  return isArray(object) ? result : arrayPush(result, symbolsFunc(object));
}

/**
 * The base implementation of `getTag` without fallbacks for buggy environments.
 *
 * @private
 * @param {*} value The value to query.
 * @returns {string} Returns the `toStringTag`.
 */
function baseGetTag(value) {
  if (value == null) {
    return value === undefined ? undefinedTag : nullTag;
  }
  return (symToStringTag && symToStringTag in Object(value))
    ? getRawTag(value)
    : objectToString(value);
}

/**
 * The base implementation of `_.isArguments`.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is an `arguments` object,
 */
function baseIsArguments(value) {
  return isObjectLike(value) && baseGetTag(value) == argsTag;
}

/**
 * The base implementation of `_.isEqual` which supports partial comparisons
 * and tracks traversed objects.
 *
 * @private
 * @param {*} value The value to compare.
 * @param {*} other The other value to compare.
 * @param {boolean} bitmask The bitmask flags.
 *  1 - Unordered comparison
 *  2 - Partial comparison
 * @param {Function} [customizer] The function to customize comparisons.
 * @param {Object} [stack] Tracks traversed `value` and `other` objects.
 * @returns {boolean} Returns `true` if the values are equivalent, else `false`.
 */
function baseIsEqual(value, other, bitmask, customizer, stack) {
  if (value === other) {
    return true;
  }
  if (value == null || other == null || (!isObjectLike(value) && !isObjectLike(other))) {
    return value !== value && other !== other;
  }
  return baseIsEqualDeep(value, other, bitmask, customizer, baseIsEqual, stack);
}

/**
 * A specialized version of `baseIsEqual` for arrays and objects which performs
 * deep comparisons and tracks traversed objects enabling objects with circular
 * references to be compared.
 *
 * @private
 * @param {Object} object The object to compare.
 * @param {Object} other The other object to compare.
 * @param {number} bitmask The bitmask flags. See `baseIsEqual` for more details.
 * @param {Function} customizer The function to customize comparisons.
 * @param {Function} equalFunc The function to determine equivalents of values.
 * @param {Object} [stack] Tracks traversed `object` and `other` objects.
 * @returns {boolean} Returns `true` if the objects are equivalent, else `false`.
 */
function baseIsEqualDeep(object, other, bitmask, customizer, equalFunc, stack) {
  var objIsArr = isArray(object),
      othIsArr = isArray(other),
      objTag = objIsArr ? arrayTag : getTag(object),
      othTag = othIsArr ? arrayTag : getTag(other);

  objTag = objTag == argsTag ? objectTag : objTag;
  othTag = othTag == argsTag ? objectTag : othTag;

  var objIsObj = objTag == objectTag,
      othIsObj = othTag == objectTag,
      isSameTag = objTag == othTag;

  if (isSameTag && isBuffer(object)) {
    if (!isBuffer(other)) {
      return false;
    }
    objIsArr = true;
    objIsObj = false;
  }
  if (isSameTag && !objIsObj) {
    stack || (stack = new Stack);
    return (objIsArr || isTypedArray(object))
      ? equalArrays(object, other, bitmask, customizer, equalFunc, stack)
      : equalByTag(object, other, objTag, bitmask, customizer, equalFunc, stack);
  }
  if (!(bitmask & COMPARE_PARTIAL_FLAG)) {
    var objIsWrapped = objIsObj && hasOwnProperty.call(object, '__wrapped__'),
        othIsWrapped = othIsObj && hasOwnProperty.call(other, '__wrapped__');

    if (objIsWrapped || othIsWrapped) {
      var objUnwrapped = objIsWrapped ? object.value() : object,
          othUnwrapped = othIsWrapped ? other.value() : other;

      stack || (stack = new Stack);
      return equalFunc(objUnwrapped, othUnwrapped, bitmask, customizer, stack);
    }
  }
  if (!isSameTag) {
    return false;
  }
  stack || (stack = new Stack);
  return equalObjects(object, other, bitmask, customizer, equalFunc, stack);
}

/**
 * The base implementation of `_.isNative` without bad shim checks.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a native function,
 *  else `false`.
 */
function baseIsNative(value) {
  if (!isObject(value) || isMasked(value)) {
    return false;
  }
  var pattern = isFunction(value) ? reIsNative : reIsHostCtor;
  return pattern.test(toSource(value));
}

/**
 * The base implementation of `_.isTypedArray` without Node.js optimizations.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a typed array, else `false`.
 */
function baseIsTypedArray(value) {
  return isObjectLike(value) &&
    isLength(value.length) && !!typedArrayTags[baseGetTag(value)];
}

/**
 * The base implementation of `_.keys` which doesn't treat sparse arrays as dense.
 *
 * @private
 * @param {Object} object The object to query.
 * @returns {Array} Returns the array of property names.
 */
function baseKeys(object) {
  if (!isPrototype(object)) {
    return nativeKeys(object);
  }
  var result = [];
  for (var key in Object(object)) {
    if (hasOwnProperty.call(object, key) && key != 'constructor') {
      result.push(key);
    }
  }
  return result;
}

/**
 * A specialized version of `baseIsEqualDeep` for arrays with support for
 * partial deep comparisons.
 *
 * @private
 * @param {Array} array The array to compare.
 * @param {Array} other The other array to compare.
 * @param {number} bitmask The bitmask flags. See `baseIsEqual` for more details.
 * @param {Function} customizer The function to customize comparisons.
 * @param {Function} equalFunc The function to determine equivalents of values.
 * @param {Object} stack Tracks traversed `array` and `other` objects.
 * @returns {boolean} Returns `true` if the arrays are equivalent, else `false`.
 */
function equalArrays(array, other, bitmask, customizer, equalFunc, stack) {
  var isPartial = bitmask & COMPARE_PARTIAL_FLAG,
      arrLength = array.length,
      othLength = other.length;

  if (arrLength != othLength && !(isPartial && othLength > arrLength)) {
    return false;
  }
  // Assume cyclic values are equal.
  var stacked = stack.get(array);
  if (stacked && stack.get(other)) {
    return stacked == other;
  }
  var index = -1,
      result = true,
      seen = (bitmask & COMPARE_UNORDERED_FLAG) ? new SetCache : undefined;

  stack.set(array, other);
  stack.set(other, array);

  // Ignore non-index properties.
  while (++index < arrLength) {
    var arrValue = array[index],
        othValue = other[index];

    if (customizer) {
      var compared = isPartial
        ? customizer(othValue, arrValue, index, other, array, stack)
        : customizer(arrValue, othValue, index, array, other, stack);
    }
    if (compared !== undefined) {
      if (compared) {
        continue;
      }
      result = false;
      break;
    }
    // Recursively compare arrays (susceptible to call stack limits).
    if (seen) {
      if (!arraySome(other, function(othValue, othIndex) {
            if (!cacheHas(seen, othIndex) &&
                (arrValue === othValue || equalFunc(arrValue, othValue, bitmask, customizer, stack))) {
              return seen.push(othIndex);
            }
          })) {
        result = false;
        break;
      }
    } else if (!(
          arrValue === othValue ||
            equalFunc(arrValue, othValue, bitmask, customizer, stack)
        )) {
      result = false;
      break;
    }
  }
  stack['delete'](array);
  stack['delete'](other);
  return result;
}

/**
 * A specialized version of `baseIsEqualDeep` for comparing objects of
 * the same `toStringTag`.
 *
 * **Note:** This function only supports comparing values with tags of
 * `Boolean`, `Date`, `Error`, `Number`, `RegExp`, or `String`.
 *
 * @private
 * @param {Object} object The object to compare.
 * @param {Object} other The other object to compare.
 * @param {string} tag The `toStringTag` of the objects to compare.
 * @param {number} bitmask The bitmask flags. See `baseIsEqual` for more details.
 * @param {Function} customizer The function to customize comparisons.
 * @param {Function} equalFunc The function to determine equivalents of values.
 * @param {Object} stack Tracks traversed `object` and `other` objects.
 * @returns {boolean} Returns `true` if the objects are equivalent, else `false`.
 */
function equalByTag(object, other, tag, bitmask, customizer, equalFunc, stack) {
  switch (tag) {
    case dataViewTag:
      if ((object.byteLength != other.byteLength) ||
          (object.byteOffset != other.byteOffset)) {
        return false;
      }
      object = object.buffer;
      other = other.buffer;

    case arrayBufferTag:
      if ((object.byteLength != other.byteLength) ||
          !equalFunc(new Uint8Array(object), new Uint8Array(other))) {
        return false;
      }
      return true;

    case boolTag:
    case dateTag:
    case numberTag:
      // Coerce booleans to `1` or `0` and dates to milliseconds.
      // Invalid dates are coerced to `NaN`.
      return eq(+object, +other);

    case errorTag:
      return object.name == other.name && object.message == other.message;

    case regexpTag:
    case stringTag:
      // Coerce regexes to strings and treat strings, primitives and objects,
      // as equal. See http://www.ecma-international.org/ecma-262/7.0/#sec-regexp.prototype.tostring
      // for more details.
      return object == (other + '');

    case mapTag:
      var convert = mapToArray;

    case setTag:
      var isPartial = bitmask & COMPARE_PARTIAL_FLAG;
      convert || (convert = setToArray);

      if (object.size != other.size && !isPartial) {
        return false;
      }
      // Assume cyclic values are equal.
      var stacked = stack.get(object);
      if (stacked) {
        return stacked == other;
      }
      bitmask |= COMPARE_UNORDERED_FLAG;

      // Recursively compare objects (susceptible to call stack limits).
      stack.set(object, other);
      var result = equalArrays(convert(object), convert(other), bitmask, customizer, equalFunc, stack);
      stack['delete'](object);
      return result;

    case symbolTag:
      if (symbolValueOf) {
        return symbolValueOf.call(object) == symbolValueOf.call(other);
      }
  }
  return false;
}

/**
 * A specialized version of `baseIsEqualDeep` for objects with support for
 * partial deep comparisons.
 *
 * @private
 * @param {Object} object The object to compare.
 * @param {Object} other The other object to compare.
 * @param {number} bitmask The bitmask flags. See `baseIsEqual` for more details.
 * @param {Function} customizer The function to customize comparisons.
 * @param {Function} equalFunc The function to determine equivalents of values.
 * @param {Object} stack Tracks traversed `object` and `other` objects.
 * @returns {boolean} Returns `true` if the objects are equivalent, else `false`.
 */
function equalObjects(object, other, bitmask, customizer, equalFunc, stack) {
  var isPartial = bitmask & COMPARE_PARTIAL_FLAG,
      objProps = getAllKeys(object),
      objLength = objProps.length,
      othProps = getAllKeys(other),
      othLength = othProps.length;

  if (objLength != othLength && !isPartial) {
    return false;
  }
  var index = objLength;
  while (index--) {
    var key = objProps[index];
    if (!(isPartial ? key in other : hasOwnProperty.call(other, key))) {
      return false;
    }
  }
  // Assume cyclic values are equal.
  var stacked = stack.get(object);
  if (stacked && stack.get(other)) {
    return stacked == other;
  }
  var result = true;
  stack.set(object, other);
  stack.set(other, object);

  var skipCtor = isPartial;
  while (++index < objLength) {
    key = objProps[index];
    var objValue = object[key],
        othValue = other[key];

    if (customizer) {
      var compared = isPartial
        ? customizer(othValue, objValue, key, other, object, stack)
        : customizer(objValue, othValue, key, object, other, stack);
    }
    // Recursively compare objects (susceptible to call stack limits).
    if (!(compared === undefined
          ? (objValue === othValue || equalFunc(objValue, othValue, bitmask, customizer, stack))
          : compared
        )) {
      result = false;
      break;
    }
    skipCtor || (skipCtor = key == 'constructor');
  }
  if (result && !skipCtor) {
    var objCtor = object.constructor,
        othCtor = other.constructor;

    // Non `Object` object instances with different constructors are not equal.
    if (objCtor != othCtor &&
        ('constructor' in object && 'constructor' in other) &&
        !(typeof objCtor == 'function' && objCtor instanceof objCtor &&
          typeof othCtor == 'function' && othCtor instanceof othCtor)) {
      result = false;
    }
  }
  stack['delete'](object);
  stack['delete'](other);
  return result;
}

/**
 * Creates an array of own enumerable property names and symbols of `object`.
 *
 * @private
 * @param {Object} object The object to query.
 * @returns {Array} Returns the array of property names and symbols.
 */
function getAllKeys(object) {
  return baseGetAllKeys(object, keys, getSymbols);
}

/**
 * Gets the data for `map`.
 *
 * @private
 * @param {Object} map The map to query.
 * @param {string} key The reference key.
 * @returns {*} Returns the map data.
 */
function getMapData(map, key) {
  var data = map.__data__;
  return isKeyable(key)
    ? data[typeof key == 'string' ? 'string' : 'hash']
    : data.map;
}

/**
 * Gets the native function at `key` of `object`.
 *
 * @private
 * @param {Object} object The object to query.
 * @param {string} key The key of the method to get.
 * @returns {*} Returns the function if it's native, else `undefined`.
 */
function getNative(object, key) {
  var value = getValue(object, key);
  return baseIsNative(value) ? value : undefined;
}

/**
 * A specialized version of `baseGetTag` which ignores `Symbol.toStringTag` values.
 *
 * @private
 * @param {*} value The value to query.
 * @returns {string} Returns the raw `toStringTag`.
 */
function getRawTag(value) {
  var isOwn = hasOwnProperty.call(value, symToStringTag),
      tag = value[symToStringTag];

  try {
    value[symToStringTag] = undefined;
    var unmasked = true;
  } catch (e) {}

  var result = nativeObjectToString.call(value);
  if (unmasked) {
    if (isOwn) {
      value[symToStringTag] = tag;
    } else {
      delete value[symToStringTag];
    }
  }
  return result;
}

/**
 * Creates an array of the own enumerable symbols of `object`.
 *
 * @private
 * @param {Object} object The object to query.
 * @returns {Array} Returns the array of symbols.
 */
var getSymbols = !nativeGetSymbols ? stubArray : function(object) {
  if (object == null) {
    return [];
  }
  object = Object(object);
  return arrayFilter(nativeGetSymbols(object), function(symbol) {
    return propertyIsEnumerable.call(object, symbol);
  });
};

/**
 * Gets the `toStringTag` of `value`.
 *
 * @private
 * @param {*} value The value to query.
 * @returns {string} Returns the `toStringTag`.
 */
var getTag = baseGetTag;

// Fallback for data views, maps, sets, and weak maps in IE 11 and promises in Node.js < 6.
if ((DataView && getTag(new DataView(new ArrayBuffer(1))) != dataViewTag) ||
    (Map && getTag(new Map) != mapTag) ||
    (Promise && getTag(Promise.resolve()) != promiseTag) ||
    (Set && getTag(new Set) != setTag) ||
    (WeakMap && getTag(new WeakMap) != weakMapTag)) {
  getTag = function(value) {
    var result = baseGetTag(value),
        Ctor = result == objectTag ? value.constructor : undefined,
        ctorString = Ctor ? toSource(Ctor) : '';

    if (ctorString) {
      switch (ctorString) {
        case dataViewCtorString: return dataViewTag;
        case mapCtorString: return mapTag;
        case promiseCtorString: return promiseTag;
        case setCtorString: return setTag;
        case weakMapCtorString: return weakMapTag;
      }
    }
    return result;
  };
}

/**
 * Checks if `value` is a valid array-like index.
 *
 * @private
 * @param {*} value The value to check.
 * @param {number} [length=MAX_SAFE_INTEGER] The upper bounds of a valid index.
 * @returns {boolean} Returns `true` if `value` is a valid index, else `false`.
 */
function isIndex(value, length) {
  length = length == null ? MAX_SAFE_INTEGER : length;
  return !!length &&
    (typeof value == 'number' || reIsUint.test(value)) &&
    (value > -1 && value % 1 == 0 && value < length);
}

/**
 * Checks if `value` is suitable for use as unique object key.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is suitable, else `false`.
 */
function isKeyable(value) {
  var type = typeof value;
  return (type == 'string' || type == 'number' || type == 'symbol' || type == 'boolean')
    ? (value !== '__proto__')
    : (value === null);
}

/**
 * Checks if `func` has its source masked.
 *
 * @private
 * @param {Function} func The function to check.
 * @returns {boolean} Returns `true` if `func` is masked, else `false`.
 */
function isMasked(func) {
  return !!maskSrcKey && (maskSrcKey in func);
}

/**
 * Checks if `value` is likely a prototype object.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a prototype, else `false`.
 */
function isPrototype(value) {
  var Ctor = value && value.constructor,
      proto = (typeof Ctor == 'function' && Ctor.prototype) || objectProto;

  return value === proto;
}

/**
 * Converts `value` to a string using `Object.prototype.toString`.
 *
 * @private
 * @param {*} value The value to convert.
 * @returns {string} Returns the converted string.
 */
function objectToString(value) {
  return nativeObjectToString.call(value);
}

/**
 * Converts `func` to its source code.
 *
 * @private
 * @param {Function} func The function to convert.
 * @returns {string} Returns the source code.
 */
function toSource(func) {
  if (func != null) {
    try {
      return funcToString.call(func);
    } catch (e) {}
    try {
      return (func + '');
    } catch (e) {}
  }
  return '';
}

/**
 * Performs a
 * [`SameValueZero`](http://ecma-international.org/ecma-262/7.0/#sec-samevaluezero)
 * comparison between two values to determine if they are equivalent.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to compare.
 * @param {*} other The other value to compare.
 * @returns {boolean} Returns `true` if the values are equivalent, else `false`.
 * @example
 *
 * var object = { 'a': 1 };
 * var other = { 'a': 1 };
 *
 * _.eq(object, object);
 * // => true
 *
 * _.eq(object, other);
 * // => false
 *
 * _.eq('a', 'a');
 * // => true
 *
 * _.eq('a', Object('a'));
 * // => false
 *
 * _.eq(NaN, NaN);
 * // => true
 */
function eq(value, other) {
  return value === other || (value !== value && other !== other);
}

/**
 * Checks if `value` is likely an `arguments` object.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is an `arguments` object,
 *  else `false`.
 * @example
 *
 * _.isArguments(function() { return arguments; }());
 * // => true
 *
 * _.isArguments([1, 2, 3]);
 * // => false
 */
var isArguments = baseIsArguments(function() { return arguments; }()) ? baseIsArguments : function(value) {
  return isObjectLike(value) && hasOwnProperty.call(value, 'callee') &&
    !propertyIsEnumerable.call(value, 'callee');
};

/**
 * Checks if `value` is classified as an `Array` object.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is an array, else `false`.
 * @example
 *
 * _.isArray([1, 2, 3]);
 * // => true
 *
 * _.isArray(document.body.children);
 * // => false
 *
 * _.isArray('abc');
 * // => false
 *
 * _.isArray(_.noop);
 * // => false
 */
var isArray = Array.isArray;

/**
 * Checks if `value` is array-like. A value is considered array-like if it's
 * not a function and has a `value.length` that's an integer greater than or
 * equal to `0` and less than or equal to `Number.MAX_SAFE_INTEGER`.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is array-like, else `false`.
 * @example
 *
 * _.isArrayLike([1, 2, 3]);
 * // => true
 *
 * _.isArrayLike(document.body.children);
 * // => true
 *
 * _.isArrayLike('abc');
 * // => true
 *
 * _.isArrayLike(_.noop);
 * // => false
 */
function isArrayLike(value) {
  return value != null && isLength(value.length) && !isFunction(value);
}

/**
 * Checks if `value` is a buffer.
 *
 * @static
 * @memberOf _
 * @since 4.3.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a buffer, else `false`.
 * @example
 *
 * _.isBuffer(new Buffer(2));
 * // => true
 *
 * _.isBuffer(new Uint8Array(2));
 * // => false
 */
var isBuffer = nativeIsBuffer || stubFalse;

/**
 * Performs a deep comparison between two values to determine if they are
 * equivalent.
 *
 * **Note:** This method supports comparing arrays, array buffers, booleans,
 * date objects, error objects, maps, numbers, `Object` objects, regexes,
 * sets, strings, symbols, and typed arrays. `Object` objects are compared
 * by their own, not inherited, enumerable properties. Functions and DOM
 * nodes are compared by strict equality, i.e. `===`.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to compare.
 * @param {*} other The other value to compare.
 * @returns {boolean} Returns `true` if the values are equivalent, else `false`.
 * @example
 *
 * var object = { 'a': 1 };
 * var other = { 'a': 1 };
 *
 * _.isEqual(object, other);
 * // => true
 *
 * object === other;
 * // => false
 */
function isEqual(value, other) {
  return baseIsEqual(value, other);
}

/**
 * Checks if `value` is classified as a `Function` object.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a function, else `false`.
 * @example
 *
 * _.isFunction(_);
 * // => true
 *
 * _.isFunction(/abc/);
 * // => false
 */
function isFunction(value) {
  if (!isObject(value)) {
    return false;
  }
  // The use of `Object#toString` avoids issues with the `typeof` operator
  // in Safari 9 which returns 'object' for typed arrays and other constructors.
  var tag = baseGetTag(value);
  return tag == funcTag || tag == genTag || tag == asyncTag || tag == proxyTag;
}

/**
 * Checks if `value` is a valid array-like length.
 *
 * **Note:** This method is loosely based on
 * [`ToLength`](http://ecma-international.org/ecma-262/7.0/#sec-tolength).
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a valid length, else `false`.
 * @example
 *
 * _.isLength(3);
 * // => true
 *
 * _.isLength(Number.MIN_VALUE);
 * // => false
 *
 * _.isLength(Infinity);
 * // => false
 *
 * _.isLength('3');
 * // => false
 */
function isLength(value) {
  return typeof value == 'number' &&
    value > -1 && value % 1 == 0 && value <= MAX_SAFE_INTEGER;
}

/**
 * Checks if `value` is the
 * [language type](http://www.ecma-international.org/ecma-262/7.0/#sec-ecmascript-language-types)
 * of `Object`. (e.g. arrays, functions, objects, regexes, `new Number(0)`, and `new String('')`)
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is an object, else `false`.
 * @example
 *
 * _.isObject({});
 * // => true
 *
 * _.isObject([1, 2, 3]);
 * // => true
 *
 * _.isObject(_.noop);
 * // => true
 *
 * _.isObject(null);
 * // => false
 */
function isObject(value) {
  var type = typeof value;
  return value != null && (type == 'object' || type == 'function');
}

/**
 * Checks if `value` is object-like. A value is object-like if it's not `null`
 * and has a `typeof` result of "object".
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is object-like, else `false`.
 * @example
 *
 * _.isObjectLike({});
 * // => true
 *
 * _.isObjectLike([1, 2, 3]);
 * // => true
 *
 * _.isObjectLike(_.noop);
 * // => false
 *
 * _.isObjectLike(null);
 * // => false
 */
function isObjectLike(value) {
  return value != null && typeof value == 'object';
}

/**
 * Checks if `value` is classified as a typed array.
 *
 * @static
 * @memberOf _
 * @since 3.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a typed array, else `false`.
 * @example
 *
 * _.isTypedArray(new Uint8Array);
 * // => true
 *
 * _.isTypedArray([]);
 * // => false
 */
var isTypedArray = nodeIsTypedArray ? baseUnary(nodeIsTypedArray) : baseIsTypedArray;

/**
 * Creates an array of the own enumerable property names of `object`.
 *
 * **Note:** Non-object values are coerced to objects. See the
 * [ES spec](http://ecma-international.org/ecma-262/7.0/#sec-object.keys)
 * for more details.
 *
 * @static
 * @since 0.1.0
 * @memberOf _
 * @category Object
 * @param {Object} object The object to query.
 * @returns {Array} Returns the array of property names.
 * @example
 *
 * function Foo() {
 *   this.a = 1;
 *   this.b = 2;
 * }
 *
 * Foo.prototype.c = 3;
 *
 * _.keys(new Foo);
 * // => ['a', 'b'] (iteration order is not guaranteed)
 *
 * _.keys('hi');
 * // => ['0', '1']
 */
function keys(object) {
  return isArrayLike(object) ? arrayLikeKeys(object) : baseKeys(object);
}

/**
 * This method returns a new empty array.
 *
 * @static
 * @memberOf _
 * @since 4.13.0
 * @category Util
 * @returns {Array} Returns the new empty array.
 * @example
 *
 * var arrays = _.times(2, _.stubArray);
 *
 * console.log(arrays);
 * // => [[], []]
 *
 * console.log(arrays[0] === arrays[1]);
 * // => false
 */
function stubArray() {
  return [];
}

/**
 * This method returns `false`.
 *
 * @static
 * @memberOf _
 * @since 4.13.0
 * @category Util
 * @returns {boolean} Returns `false`.
 * @example
 *
 * _.times(2, _.stubFalse);
 * // => [false, false]
 */
function stubFalse() {
  return false;
}

module.exports = isEqual;

/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(25), __webpack_require__(39)(module)))

/***/ }),
/* 124 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.defaultVerticalStrength = exports.defaultHorizontalStrength = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

exports.createHorizontalStrength = createHorizontalStrength;
exports.createVerticalStrength = createVerticalStrength;
exports.default = createScrollingComponent;

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(3);

var _propTypes2 = _interopRequireDefault(_propTypes);

var _reactDom = __webpack_require__(23);

var _lodash = __webpack_require__(240);

var _lodash2 = _interopRequireDefault(_lodash);

var _raf = __webpack_require__(241);

var _raf2 = _interopRequireDefault(_raf);

var _reactDisplayName = __webpack_require__(243);

var _reactDisplayName2 = _interopRequireDefault(_reactDisplayName);

var _hoistNonReactStatics = __webpack_require__(244);

var _hoistNonReactStatics2 = _interopRequireDefault(_hoistNonReactStatics);

var _util = __webpack_require__(245);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var DEFAULT_BUFFER = 150;

function createHorizontalStrength(_buffer) {
  return function defaultHorizontalStrength(_ref, point) {
    var x = _ref.x;
    var w = _ref.w;
    var y = _ref.y;
    var h = _ref.h;

    var buffer = Math.min(w / 2, _buffer);
    var inRange = point.x >= x && point.x <= x + w;
    var inBox = inRange && point.y >= y && point.y <= y + h;

    if (inBox) {
      if (point.x < x + buffer) {
        return (point.x - x - buffer) / buffer;
      } else if (point.x > x + w - buffer) {
        return -(x + w - point.x - buffer) / buffer;
      }
    }

    return 0;
  };
}

function createVerticalStrength(_buffer) {
  return function defaultVerticalStrength(_ref2, point) {
    var y = _ref2.y;
    var h = _ref2.h;
    var x = _ref2.x;
    var w = _ref2.w;

    var buffer = Math.min(h / 2, _buffer);
    var inRange = point.y >= y && point.y <= y + h;
    var inBox = inRange && point.x >= x && point.x <= x + w;

    if (inBox) {
      if (point.y < y + buffer) {
        return (point.y - y - buffer) / buffer;
      } else if (point.y > y + h - buffer) {
        return -(y + h - point.y - buffer) / buffer;
      }
    }

    return 0;
  };
}

var defaultHorizontalStrength = exports.defaultHorizontalStrength = createHorizontalStrength(DEFAULT_BUFFER);

var defaultVerticalStrength = exports.defaultVerticalStrength = createVerticalStrength(DEFAULT_BUFFER);

function createScrollingComponent(WrappedComponent) {
  var ScrollingComponent = function (_Component) {
    _inherits(ScrollingComponent, _Component);

    function ScrollingComponent(props, ctx) {
      _classCallCheck(this, ScrollingComponent);

      var _this = _possibleConstructorReturn(this, (ScrollingComponent.__proto__ || Object.getPrototypeOf(ScrollingComponent)).call(this, props, ctx));

      _this.handleEvent = function (evt) {
        if (_this.dragging && !_this.attached) {
          _this.attach();
          _this.updateScrolling(evt);
        }
      };

      _this.updateScrolling = (0, _lodash2.default)(function (evt) {
        var _this$container$getBo = _this.container.getBoundingClientRect();

        var x = _this$container$getBo.left;
        var y = _this$container$getBo.top;
        var w = _this$container$getBo.width;
        var h = _this$container$getBo.height;

        var box = { x: x, y: y, w: w, h: h };
        var coords = (0, _util.getCoords)(evt);

        // calculate strength
        _this.scaleX = _this.props.horizontalStrength(box, coords);
        _this.scaleY = _this.props.verticalStrength(box, coords);

        // start scrolling if we need to
        if (!_this.frame && (_this.scaleX || _this.scaleY)) {
          _this.startScrolling();
        }
      }, 100, { trailing: false });


      _this.scaleX = 0;
      _this.scaleY = 0;
      _this.frame = null;

      _this.attached = false;
      _this.dragging = false;
      return _this;
    }

    _createClass(ScrollingComponent, [{
      key: 'componentDidMount',
      value: function componentDidMount() {
        var _this2 = this;

        this.container = (0, _reactDom.findDOMNode)(this.wrappedInstance);
        this.container.addEventListener('dragover', this.handleEvent);
        // touchmove events don't seem to work across siblings, so we unfortunately
        // have to attach the listeners to the body
        window.document.body.addEventListener('touchmove', this.handleEvent);

        this.clearMonitorSubscription = this.context.dragDropManager.getMonitor().subscribeToStateChange(function () {
          return _this2.handleMonitorChange();
        });
      }
    }, {
      key: 'componentWillUnmount',
      value: function componentWillUnmount() {
        this.container.removeEventListener('dragover', this.handleEvent);
        window.document.body.removeEventListener('touchmove', this.handleEvent);
        this.clearMonitorSubscription();
        this.stopScrolling();
      }
    }, {
      key: 'handleMonitorChange',
      value: function handleMonitorChange() {
        var isDragging = this.context.dragDropManager.getMonitor().isDragging();

        if (!this.dragging && isDragging) {
          this.dragging = true;
        } else if (this.dragging && !isDragging) {
          this.dragging = false;
          this.stopScrolling();
        }
      }
    }, {
      key: 'attach',
      value: function attach() {
        this.attached = true;
        window.document.body.addEventListener('dragover', this.updateScrolling);
        window.document.body.addEventListener('touchmove', this.updateScrolling);
      }
    }, {
      key: 'detach',
      value: function detach() {
        this.attached = false;
        window.document.body.removeEventListener('dragover', this.updateScrolling);
        window.document.body.removeEventListener('touchmove', this.updateScrolling);
      }

      // Update scaleX and scaleY every 100ms or so
      // and start scrolling if necessary

    }, {
      key: 'startScrolling',
      value: function startScrolling() {
        var _this3 = this;

        var i = 0;
        var tick = function tick() {
          var scaleX = _this3.scaleX;
          var scaleY = _this3.scaleY;
          var container = _this3.container;
          var _props = _this3.props;
          var strengthMultiplier = _props.strengthMultiplier;
          var onScrollChange = _props.onScrollChange;

          // stop scrolling if there's nothing to do

          if (strengthMultiplier === 0 || scaleX + scaleY === 0) {
            _this3.stopScrolling();
            return;
          }

          // there's a bug in safari where it seems like we can't get
          // mousemove events from a container that also emits a scroll
          // event that same frame. So we double the strengthMultiplier and only adjust
          // the scroll position at 30fps
          if (i++ % 2) {
            var scrollLeft = container.scrollLeft;
            var scrollTop = container.scrollTop;
            var scrollWidth = container.scrollWidth;
            var scrollHeight = container.scrollHeight;
            var clientWidth = container.clientWidth;
            var clientHeight = container.clientHeight;


            var newLeft = scaleX ? container.scrollLeft = (0, _util.intBetween)(0, scrollWidth - clientWidth, scrollLeft + scaleX * strengthMultiplier) : scrollLeft;

            var newTop = scaleY ? container.scrollTop = (0, _util.intBetween)(0, scrollHeight - clientHeight, scrollTop + scaleY * strengthMultiplier) : scrollTop;

            onScrollChange(newLeft, newTop);
          }
          _this3.frame = (0, _raf2.default)(tick);
        };

        tick();
      }
    }, {
      key: 'stopScrolling',
      value: function stopScrolling() {
        this.detach();
        this.scaleX = 0;
        this.scaleY = 0;

        if (this.frame) {
          _raf2.default.cancel(this.frame);
          this.frame = null;
        }
      }
    }, {
      key: 'render',
      value: function render() {
        var _this4 = this;

        var _props2 = this.props;
        var strengthMultiplier = _props2.strengthMultiplier;
        var verticalStrength = _props2.verticalStrength;
        var horizontalStrength = _props2.horizontalStrength;
        var onScrollChange = _props2.onScrollChange;

        var props = _objectWithoutProperties(_props2, ['strengthMultiplier', 'verticalStrength', 'horizontalStrength', 'onScrollChange']);

        return _react2.default.createElement(WrappedComponent, _extends({
          ref: function ref(_ref3) {
            _this4.wrappedInstance = _ref3;
          }
        }, props));
      }
    }]);

    return ScrollingComponent;
  }(_react.Component);

  ScrollingComponent.displayName = 'Scrolling(' + (0, _reactDisplayName2.default)(WrappedComponent) + ')';
  ScrollingComponent.propTypes = {
    onScrollChange: _propTypes2.default.func,
    verticalStrength: _propTypes2.default.func,
    horizontalStrength: _propTypes2.default.func,
    strengthMultiplier: _propTypes2.default.number
  };
  ScrollingComponent.defaultProps = {
    onScrollChange: _util.noop,
    verticalStrength: defaultVerticalStrength,
    horizontalStrength: defaultHorizontalStrength,
    strengthMultiplier: 30
  };
  ScrollingComponent.contextTypes = {
    dragDropManager: _propTypes2.default.object
  };


  return (0, _hoistNonReactStatics2.default)(ScrollingComponent, WrappedComponent);
}

/***/ }),
/* 125 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _DragDropContext = __webpack_require__(126);

Object.defineProperty(exports, 'DragDropContext', {
  enumerable: true,
  get: function get() {
    return _interopRequireDefault(_DragDropContext).default;
  }
});

var _DragDropContextProvider = __webpack_require__(314);

Object.defineProperty(exports, 'DragDropContextProvider', {
  enumerable: true,
  get: function get() {
    return _interopRequireDefault(_DragDropContextProvider).default;
  }
});

var _DragLayer = __webpack_require__(315);

Object.defineProperty(exports, 'DragLayer', {
  enumerable: true,
  get: function get() {
    return _interopRequireDefault(_DragLayer).default;
  }
});

var _DragSource = __webpack_require__(316);

Object.defineProperty(exports, 'DragSource', {
  enumerable: true,
  get: function get() {
    return _interopRequireDefault(_DragSource).default;
  }
});

var _DropTarget = __webpack_require__(326);

Object.defineProperty(exports, 'DropTarget', {
  enumerable: true,
  get: function get() {
    return _interopRequireDefault(_DropTarget).default;
  }
});

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/***/ }),
/* 126 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.unpackBackendForEs5Users = exports.createChildContext = exports.CHILD_CONTEXT_TYPES = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

exports.default = DragDropContext;

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(3);

var _propTypes2 = _interopRequireDefault(_propTypes);

var _dndCore = __webpack_require__(246);

var _invariant = __webpack_require__(9);

var _invariant2 = _interopRequireDefault(_invariant);

var _hoistNonReactStatics = __webpack_require__(80);

var _hoistNonReactStatics2 = _interopRequireDefault(_hoistNonReactStatics);

var _checkDecoratorArguments = __webpack_require__(49);

var _checkDecoratorArguments2 = _interopRequireDefault(_checkDecoratorArguments);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var CHILD_CONTEXT_TYPES = exports.CHILD_CONTEXT_TYPES = {
  dragDropManager: _propTypes2.default.object.isRequired
};

var createChildContext = exports.createChildContext = function createChildContext(backend, context) {
  return {
    dragDropManager: new _dndCore.DragDropManager(backend, context)
  };
};

var unpackBackendForEs5Users = exports.unpackBackendForEs5Users = function unpackBackendForEs5Users(backendOrModule) {
  // Auto-detect ES6 default export for people still using ES5
  var backend = backendOrModule;
  if ((typeof backend === 'undefined' ? 'undefined' : _typeof(backend)) === 'object' && typeof backend.default === 'function') {
    backend = backend.default;
  }
  (0, _invariant2.default)(typeof backend === 'function', 'Expected the backend to be a function or an ES6 module exporting a default function. ' + 'Read more: http://react-dnd.github.io/react-dnd/docs-drag-drop-context.html');
  return backend;
};

function DragDropContext(backendOrModule) {
  _checkDecoratorArguments2.default.apply(undefined, ['DragDropContext', 'backend'].concat(Array.prototype.slice.call(arguments))); // eslint-disable-line prefer-rest-params

  var backend = unpackBackendForEs5Users(backendOrModule);
  var childContext = createChildContext(backend);

  return function decorateContext(DecoratedComponent) {
    var _class, _temp;

    var displayName = DecoratedComponent.displayName || DecoratedComponent.name || 'Component';

    var DragDropContextContainer = (_temp = _class = function (_Component) {
      _inherits(DragDropContextContainer, _Component);

      function DragDropContextContainer() {
        _classCallCheck(this, DragDropContextContainer);

        return _possibleConstructorReturn(this, (DragDropContextContainer.__proto__ || Object.getPrototypeOf(DragDropContextContainer)).apply(this, arguments));
      }

      _createClass(DragDropContextContainer, [{
        key: 'getDecoratedComponentInstance',
        value: function getDecoratedComponentInstance() {
          (0, _invariant2.default)(this.child, 'In order to access an instance of the decorated component it can ' + 'not be a stateless component.');
          return this.child;
        }
      }, {
        key: 'getManager',
        value: function getManager() {
          return childContext.dragDropManager;
        }
      }, {
        key: 'getChildContext',
        value: function getChildContext() {
          return childContext;
        }
      }, {
        key: 'render',
        value: function render() {
          var _this2 = this;

          return _react2.default.createElement(DecoratedComponent, _extends({}, this.props, {
            ref: function ref(child) {
              _this2.child = child;
            }
          }));
        }
      }]);

      return DragDropContextContainer;
    }(_react.Component), _class.DecoratedComponent = DecoratedComponent, _class.displayName = 'DragDropContext(' + displayName + ')', _class.childContextTypes = CHILD_CONTEXT_TYPES, _temp);


    return (0, _hoistNonReactStatics2.default)(DragDropContextContainer, DecoratedComponent);
  };
}

/***/ }),
/* 127 */
/***/ (function(module, exports, __webpack_require__) {

/* WEBPACK VAR INJECTION */(function(global) {/** Detect free variable `global` from Node.js. */
var freeGlobal = typeof global == 'object' && global && global.Object === Object && global;

module.exports = freeGlobal;

/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(25)))

/***/ }),
/* 128 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

exports.default = dragOffset;
exports.getSourceClientOffset = getSourceClientOffset;
exports.getDifferenceFromInitialOffset = getDifferenceFromInitialOffset;

var _dragDrop = __webpack_require__(41);

var initialState = {
  initialSourceClientOffset: null,
  initialClientOffset: null,
  clientOffset: null
};

function areOffsetsEqual(offsetA, offsetB) {
  if (offsetA === offsetB) {
    return true;
  }
  return offsetA && offsetB && offsetA.x === offsetB.x && offsetA.y === offsetB.y;
}

function dragOffset() {
  var state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : initialState;
  var action = arguments[1];

  switch (action.type) {
    case _dragDrop.BEGIN_DRAG:
      return {
        initialSourceClientOffset: action.sourceClientOffset,
        initialClientOffset: action.clientOffset,
        clientOffset: action.clientOffset
      };
    case _dragDrop.HOVER:
      if (areOffsetsEqual(state.clientOffset, action.clientOffset)) {
        return state;
      }
      return _extends({}, state, {
        clientOffset: action.clientOffset
      });
    case _dragDrop.END_DRAG:
    case _dragDrop.DROP:
      return initialState;
    default:
      return state;
  }
}

function getSourceClientOffset(state) {
  var clientOffset = state.clientOffset,
      initialClientOffset = state.initialClientOffset,
      initialSourceClientOffset = state.initialSourceClientOffset;

  if (!clientOffset || !initialClientOffset || !initialSourceClientOffset) {
    return null;
  }
  return {
    x: clientOffset.x + initialSourceClientOffset.x - initialClientOffset.x,
    y: clientOffset.y + initialSourceClientOffset.y - initialClientOffset.y
  };
}

function getDifferenceFromInitialOffset(state) {
  var clientOffset = state.clientOffset,
      initialClientOffset = state.initialClientOffset;

  if (!clientOffset || !initialClientOffset) {
    return null;
  }
  return {
    x: clientOffset.x - initialClientOffset.x,
    y: clientOffset.y - initialClientOffset.y
  };
}

/***/ }),
/* 129 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = matchesType;

var _isArray = __webpack_require__(19);

var _isArray2 = _interopRequireDefault(_isArray);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function matchesType(targetType, draggedItemType) {
  if ((0, _isArray2.default)(targetType)) {
    return targetType.some(function (t) {
      return t === draggedItemType;
    });
  } else {
    return targetType === draggedItemType;
  }
}

/***/ }),
/* 130 */
/***/ (function(module, exports, __webpack_require__) {

var baseDifference = __webpack_require__(131),
    baseRest = __webpack_require__(26),
    isArrayLikeObject = __webpack_require__(47);

/**
 * Creates an array excluding all given values using
 * [`SameValueZero`](http://ecma-international.org/ecma-262/7.0/#sec-samevaluezero)
 * for equality comparisons.
 *
 * **Note:** Unlike `_.pull`, this method returns a new array.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Array
 * @param {Array} array The array to inspect.
 * @param {...*} [values] The values to exclude.
 * @returns {Array} Returns the new array of filtered values.
 * @see _.difference, _.xor
 * @example
 *
 * _.without([2, 1, 2, 3], 1, 2);
 * // => [3]
 */
var without = baseRest(function(array, values) {
  return isArrayLikeObject(array)
    ? baseDifference(array, values)
    : [];
});

module.exports = without;


/***/ }),
/* 131 */
/***/ (function(module, exports, __webpack_require__) {

var SetCache = __webpack_require__(73),
    arrayIncludes = __webpack_require__(74),
    arrayIncludesWith = __webpack_require__(75),
    arrayMap = __webpack_require__(76),
    baseUnary = __webpack_require__(77),
    cacheHas = __webpack_require__(78);

/** Used as the size to enable large array optimizations. */
var LARGE_ARRAY_SIZE = 200;

/**
 * The base implementation of methods like `_.difference` without support
 * for excluding multiple arrays or iteratee shorthands.
 *
 * @private
 * @param {Array} array The array to inspect.
 * @param {Array} values The values to exclude.
 * @param {Function} [iteratee] The iteratee invoked per element.
 * @param {Function} [comparator] The comparator invoked per element.
 * @returns {Array} Returns the new array of filtered values.
 */
function baseDifference(array, values, iteratee, comparator) {
  var index = -1,
      includes = arrayIncludes,
      isCommon = true,
      length = array.length,
      result = [],
      valuesLength = values.length;

  if (!length) {
    return result;
  }
  if (iteratee) {
    values = arrayMap(values, baseUnary(iteratee));
  }
  if (comparator) {
    includes = arrayIncludesWith;
    isCommon = false;
  }
  else if (values.length >= LARGE_ARRAY_SIZE) {
    includes = cacheHas;
    isCommon = false;
    values = new SetCache(values);
  }
  outer:
  while (++index < length) {
    var value = array[index],
        computed = iteratee == null ? value : iteratee(value);

    value = (comparator || value !== 0) ? value : 0;
    if (isCommon && computed === computed) {
      var valuesIndex = valuesLength;
      while (valuesIndex--) {
        if (values[valuesIndex] === computed) {
          continue outer;
        }
      }
      result.push(value);
    }
    else if (!includes(values, computed, comparator)) {
      result.push(value);
    }
  }
  return result;
}

module.exports = baseDifference;


/***/ }),
/* 132 */
/***/ (function(module, exports, __webpack_require__) {

var mapCacheClear = __webpack_require__(258),
    mapCacheDelete = __webpack_require__(277),
    mapCacheGet = __webpack_require__(279),
    mapCacheHas = __webpack_require__(280),
    mapCacheSet = __webpack_require__(281);

/**
 * Creates a map cache object to store key-value pairs.
 *
 * @private
 * @constructor
 * @param {Array} [entries] The key-value pairs to cache.
 */
function MapCache(entries) {
  var index = -1,
      length = entries == null ? 0 : entries.length;

  this.clear();
  while (++index < length) {
    var entry = entries[index];
    this.set(entry[0], entry[1]);
  }
}

// Add methods to `MapCache`.
MapCache.prototype.clear = mapCacheClear;
MapCache.prototype['delete'] = mapCacheDelete;
MapCache.prototype.get = mapCacheGet;
MapCache.prototype.has = mapCacheHas;
MapCache.prototype.set = mapCacheSet;

module.exports = MapCache;


/***/ }),
/* 133 */
/***/ (function(module, exports, __webpack_require__) {

var baseGetTag = __webpack_require__(40),
    isObject = __webpack_require__(32);

/** `Object#toString` result references. */
var asyncTag = '[object AsyncFunction]',
    funcTag = '[object Function]',
    genTag = '[object GeneratorFunction]',
    proxyTag = '[object Proxy]';

/**
 * Checks if `value` is classified as a `Function` object.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a function, else `false`.
 * @example
 *
 * _.isFunction(_);
 * // => true
 *
 * _.isFunction(/abc/);
 * // => false
 */
function isFunction(value) {
  if (!isObject(value)) {
    return false;
  }
  // The use of `Object#toString` avoids issues with the `typeof` operator
  // in Safari 9 which returns 'object' for typed arrays and other constructors.
  var tag = baseGetTag(value);
  return tag == funcTag || tag == genTag || tag == asyncTag || tag == proxyTag;
}

module.exports = isFunction;


/***/ }),
/* 134 */
/***/ (function(module, exports) {

/**
 * This method returns the first argument it receives.
 *
 * @static
 * @since 0.1.0
 * @memberOf _
 * @category Util
 * @param {*} value Any value.
 * @returns {*} Returns `value`.
 * @example
 *
 * var object = { 'a': 1 };
 *
 * console.log(_.identity(object) === object);
 * // => true
 */
function identity(value) {
  return value;
}

module.exports = identity;


/***/ }),
/* 135 */
/***/ (function(module, exports) {

/**
 * A faster alternative to `Function#apply`, this function invokes `func`
 * with the `this` binding of `thisArg` and the arguments of `args`.
 *
 * @private
 * @param {Function} func The function to invoke.
 * @param {*} thisArg The `this` binding of `func`.
 * @param {Array} args The arguments to invoke `func` with.
 * @returns {*} Returns the result of `func`.
 */
function apply(func, thisArg, args) {
  switch (args.length) {
    case 0: return func.call(thisArg);
    case 1: return func.call(thisArg, args[0]);
    case 2: return func.call(thisArg, args[0], args[1]);
    case 3: return func.call(thisArg, args[0], args[1], args[2]);
  }
  return func.apply(thisArg, args);
}

module.exports = apply;


/***/ }),
/* 136 */
/***/ (function(module, exports, __webpack_require__) {

var getNative = __webpack_require__(43);

var defineProperty = (function() {
  try {
    var func = getNative(Object, 'defineProperty');
    func({}, '', {});
    return func;
  } catch (e) {}
}());

module.exports = defineProperty;


/***/ }),
/* 137 */
/***/ (function(module, exports) {

/** Used as references for various `Number` constants. */
var MAX_SAFE_INTEGER = 9007199254740991;

/**
 * Checks if `value` is a valid array-like length.
 *
 * **Note:** This method is loosely based on
 * [`ToLength`](http://ecma-international.org/ecma-262/7.0/#sec-tolength).
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a valid length, else `false`.
 * @example
 *
 * _.isLength(3);
 * // => true
 *
 * _.isLength(Number.MIN_VALUE);
 * // => false
 *
 * _.isLength(Infinity);
 * // => false
 *
 * _.isLength('3');
 * // => false
 */
function isLength(value) {
  return typeof value == 'number' &&
    value > -1 && value % 1 == 0 && value <= MAX_SAFE_INTEGER;
}

module.exports = isLength;


/***/ }),
/* 138 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = dirtyHandlerIds;
exports.areDirty = areDirty;

var _xor = __webpack_require__(294);

var _xor2 = _interopRequireDefault(_xor);

var _intersection = __webpack_require__(302);

var _intersection2 = _interopRequireDefault(_intersection);

var _dragDrop = __webpack_require__(41);

var _registry = __webpack_require__(48);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var NONE = [];
var ALL = [];

function dirtyHandlerIds() {
  var state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : NONE;
  var action = arguments[1];
  var dragOperation = arguments[2];

  switch (action.type) {
    case _dragDrop.HOVER:
      break;
    case _registry.ADD_SOURCE:
    case _registry.ADD_TARGET:
    case _registry.REMOVE_TARGET:
    case _registry.REMOVE_SOURCE:
      return NONE;
    case _dragDrop.BEGIN_DRAG:
    case _dragDrop.PUBLISH_DRAG_SOURCE:
    case _dragDrop.END_DRAG:
    case _dragDrop.DROP:
    default:
      return ALL;
  }

  var targetIds = action.targetIds;
  var prevTargetIds = dragOperation.targetIds;

  var result = (0, _xor2.default)(targetIds, prevTargetIds);

  var didChange = false;
  if (result.length === 0) {
    for (var i = 0; i < targetIds.length; i++) {
      if (targetIds[i] !== prevTargetIds[i]) {
        didChange = true;
        break;
      }
    }
  } else {
    didChange = true;
  }

  if (!didChange) {
    return NONE;
  }

  var prevInnermostTargetId = prevTargetIds[prevTargetIds.length - 1];
  var innermostTargetId = targetIds[targetIds.length - 1];

  if (prevInnermostTargetId !== innermostTargetId) {
    if (prevInnermostTargetId) {
      result.push(prevInnermostTargetId);
    }
    if (innermostTargetId) {
      result.push(innermostTargetId);
    }
  }

  return result;
}

function areDirty(state, handlerIds) {
  if (state === NONE) {
    return false;
  }

  if (state === ALL || typeof handlerIds === 'undefined') {
    return true;
  }

  return (0, _intersection2.default)(handlerIds, state).length > 0;
}

/***/ }),
/* 139 */
/***/ (function(module, exports, __webpack_require__) {

var arrayPush = __webpack_require__(297),
    isFlattenable = __webpack_require__(298);

/**
 * The base implementation of `_.flatten` with support for restricting flattening.
 *
 * @private
 * @param {Array} array The array to flatten.
 * @param {number} depth The maximum recursion depth.
 * @param {boolean} [predicate=isFlattenable] The function invoked per iteration.
 * @param {boolean} [isStrict] Restrict to values that pass `predicate` checks.
 * @param {Array} [result=[]] The initial result value.
 * @returns {Array} Returns the new flattened array.
 */
function baseFlatten(array, depth, predicate, isStrict, result) {
  var index = -1,
      length = array.length;

  predicate || (predicate = isFlattenable);
  result || (result = []);

  while (++index < length) {
    var value = array[index];
    if (depth > 0 && predicate(value)) {
      if (depth > 1) {
        // Recursively flatten arrays (susceptible to call stack limits).
        baseFlatten(value, depth - 1, predicate, isStrict, result);
      } else {
        arrayPush(result, value);
      }
    } else if (!isStrict) {
      result[result.length] = value;
    }
  }
  return result;
}

module.exports = baseFlatten;


/***/ }),
/* 140 */
/***/ (function(module, exports, __webpack_require__) {

var baseIsArguments = __webpack_require__(299),
    isObjectLike = __webpack_require__(31);

/** Used for built-in method references. */
var objectProto = Object.prototype;

/** Used to check objects for own properties. */
var hasOwnProperty = objectProto.hasOwnProperty;

/** Built-in value references. */
var propertyIsEnumerable = objectProto.propertyIsEnumerable;

/**
 * Checks if `value` is likely an `arguments` object.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is an `arguments` object,
 *  else `false`.
 * @example
 *
 * _.isArguments(function() { return arguments; }());
 * // => true
 *
 * _.isArguments([1, 2, 3]);
 * // => false
 */
var isArguments = baseIsArguments(function() { return arguments; }()) ? baseIsArguments : function(value) {
  return isObjectLike(value) && hasOwnProperty.call(value, 'callee') &&
    !propertyIsEnumerable.call(value, 'callee');
};

module.exports = isArguments;


/***/ }),
/* 141 */
/***/ (function(module, exports, __webpack_require__) {

var SetCache = __webpack_require__(73),
    arrayIncludes = __webpack_require__(74),
    arrayIncludesWith = __webpack_require__(75),
    cacheHas = __webpack_require__(78),
    createSet = __webpack_require__(300),
    setToArray = __webpack_require__(143);

/** Used as the size to enable large array optimizations. */
var LARGE_ARRAY_SIZE = 200;

/**
 * The base implementation of `_.uniqBy` without support for iteratee shorthands.
 *
 * @private
 * @param {Array} array The array to inspect.
 * @param {Function} [iteratee] The iteratee invoked per element.
 * @param {Function} [comparator] The comparator invoked per element.
 * @returns {Array} Returns the new duplicate free array.
 */
function baseUniq(array, iteratee, comparator) {
  var index = -1,
      includes = arrayIncludes,
      length = array.length,
      isCommon = true,
      result = [],
      seen = result;

  if (comparator) {
    isCommon = false;
    includes = arrayIncludesWith;
  }
  else if (length >= LARGE_ARRAY_SIZE) {
    var set = iteratee ? null : createSet(array);
    if (set) {
      return setToArray(set);
    }
    isCommon = false;
    includes = cacheHas;
    seen = new SetCache;
  }
  else {
    seen = iteratee ? [] : result;
  }
  outer:
  while (++index < length) {
    var value = array[index],
        computed = iteratee ? iteratee(value) : value;

    value = (comparator || value !== 0) ? value : 0;
    if (isCommon && computed === computed) {
      var seenIndex = seen.length;
      while (seenIndex--) {
        if (seen[seenIndex] === computed) {
          continue outer;
        }
      }
      if (iteratee) {
        seen.push(computed);
      }
      result.push(value);
    }
    else if (!includes(seen, computed, comparator)) {
      if (seen !== result) {
        seen.push(computed);
      }
      result.push(value);
    }
  }
  return result;
}

module.exports = baseUniq;


/***/ }),
/* 142 */
/***/ (function(module, exports) {

/**
 * This method returns `undefined`.
 *
 * @static
 * @memberOf _
 * @since 2.3.0
 * @category Util
 * @example
 *
 * _.times(2, _.noop);
 * // => [undefined, undefined]
 */
function noop() {
  // No operation performed.
}

module.exports = noop;


/***/ }),
/* 143 */
/***/ (function(module, exports) {

/**
 * Converts `set` to an array of its values.
 *
 * @private
 * @param {Object} set The set to convert.
 * @returns {Array} Returns the values.
 */
function setToArray(set) {
  var index = -1,
      result = Array(set.size);

  set.forEach(function(value) {
    result[++index] = value;
  });
  return result;
}

module.exports = setToArray;


/***/ }),
/* 144 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

exports.default = shallowEqualScalar;
function shallowEqualScalar(objA, objB) {
  if (objA === objB) {
    return true;
  }

  if ((typeof objA === 'undefined' ? 'undefined' : _typeof(objA)) !== 'object' || objA === null || (typeof objB === 'undefined' ? 'undefined' : _typeof(objB)) !== 'object' || objB === null) {
    return false;
  }

  var keysA = Object.keys(objA);
  var keysB = Object.keys(objB);

  if (keysA.length !== keysB.length) {
    return false;
  }

  // Test for A's keys different from B.
  var hasOwn = Object.prototype.hasOwnProperty;
  for (var i = 0; i < keysA.length; i += 1) {
    if (!hasOwn.call(objB, keysA[i])) {
      return false;
    }

    var valA = objA[keysA[i]];
    var valB = objB[keysA[i]];

    if (valA !== valB || (typeof valA === 'undefined' ? 'undefined' : _typeof(valA)) === 'object' || (typeof valB === 'undefined' ? 'undefined' : _typeof(valB)) === 'object') {
      return false;
    }
  }

  return true;
}

/***/ }),
/* 145 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function(process) {

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

exports.default = decorateHandler;

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(3);

var _propTypes2 = _interopRequireDefault(_propTypes);

var _disposables = __webpack_require__(317);

var _isPlainObject = __webpack_require__(18);

var _isPlainObject2 = _interopRequireDefault(_isPlainObject);

var _invariant = __webpack_require__(9);

var _invariant2 = _interopRequireDefault(_invariant);

var _hoistNonReactStatics = __webpack_require__(80);

var _hoistNonReactStatics2 = _interopRequireDefault(_hoistNonReactStatics);

var _shallowEqual = __webpack_require__(81);

var _shallowEqual2 = _interopRequireDefault(_shallowEqual);

var _shallowEqualScalar = __webpack_require__(144);

var _shallowEqualScalar2 = _interopRequireDefault(_shallowEqualScalar);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

function decorateHandler(_ref) {
  var _class, _temp;

  var DecoratedComponent = _ref.DecoratedComponent,
      createHandler = _ref.createHandler,
      createMonitor = _ref.createMonitor,
      createConnector = _ref.createConnector,
      registerHandler = _ref.registerHandler,
      containerDisplayName = _ref.containerDisplayName,
      getType = _ref.getType,
      collect = _ref.collect,
      options = _ref.options;
  var _options$arePropsEqua = options.arePropsEqual,
      arePropsEqual = _options$arePropsEqua === undefined ? _shallowEqualScalar2.default : _options$arePropsEqua;

  var displayName = DecoratedComponent.displayName || DecoratedComponent.name || 'Component';

  var DragDropContainer = (_temp = _class = function (_Component) {
    _inherits(DragDropContainer, _Component);

    _createClass(DragDropContainer, [{
      key: 'getHandlerId',
      value: function getHandlerId() {
        return this.handlerId;
      }
    }, {
      key: 'getDecoratedComponentInstance',
      value: function getDecoratedComponentInstance() {
        return this.decoratedComponentInstance;
      }
    }, {
      key: 'shouldComponentUpdate',
      value: function shouldComponentUpdate(nextProps, nextState) {
        return !arePropsEqual(nextProps, this.props) || !(0, _shallowEqual2.default)(nextState, this.state);
      }
    }]);

    function DragDropContainer(props, context) {
      _classCallCheck(this, DragDropContainer);

      var _this = _possibleConstructorReturn(this, (DragDropContainer.__proto__ || Object.getPrototypeOf(DragDropContainer)).call(this, props, context));

      _this.handleChange = _this.handleChange.bind(_this);
      _this.handleChildRef = _this.handleChildRef.bind(_this);

      (0, _invariant2.default)(_typeof(_this.context.dragDropManager) === 'object', 'Could not find the drag and drop manager in the context of %s. ' + 'Make sure to wrap the top-level component of your app with DragDropContext. ' + 'Read more: http://react-dnd.github.io/react-dnd/docs-troubleshooting.html#could-not-find-the-drag-and-drop-manager-in-the-context', displayName, displayName);

      _this.manager = _this.context.dragDropManager;
      _this.handlerMonitor = createMonitor(_this.manager);
      _this.handlerConnector = createConnector(_this.manager.getBackend());
      _this.handler = createHandler(_this.handlerMonitor);

      _this.disposable = new _disposables.SerialDisposable();
      _this.receiveProps(props);
      _this.state = _this.getCurrentState();
      _this.