import React from 'react'

import styled from 'styled-components'

import {
  background,
  BackgroundProps,
  color,
  ColorProps,
  space,
  position,
  PositionProps,
  SpaceProps,
  layout,
  LayoutProps,
  fontSize,
  FontSizeProps,
  fontWeight,
  FontWeightProps,
  border,
  BorderProps,
  boxShadow,
  BoxShadowProps,
  flexbox,
  FlexboxProps
} from 'styled-system'

export type Props = BorderProps &
  BoxShadowProps &
  BackgroundProps &
  ColorProps &
  FlexboxProps &
  FontSizeProps &
  FontWeightProps &
  LayoutProps &
  PositionProps &
  SpaceProps & {
    background?: string
    children?: any
    className?: string
    color?: string
    onClick?: () => void
  }

export const BoxStyled = styled.div`
  ${background}
  ${border}
  ${boxShadow}
  ${color}
  ${flexbox}
  ${fontSize}
  ${fontWeight}
  ${layout}
  ${position}
  ${space}
`
export const Box = React.forwardRef<HTMLDivElement, Props>(
  ({ ...props }, ref) => {
    return <BoxStyled data-testid='box' ref={ref} {...props} />
  }
)
