# Bash Shell Script Database Management System (DBMS)

![Forks](https://img.shields.io/github/forks/ahmedabougabal/DatabaseManagementSystem_ITI?style=social)
![Stars](https://img.shields.io/github/stars/ahmedabougabal/DatabaseManagementSystem_ITI?style=social)
![Watchers](https://img.shields.io/github/watchers/ahmedabougabal/DatabaseManagementSystem_ITI?style=social)
![Issues](https://img.shields.io/github/issues/ahmedabougabal/DatabaseManagementSystem_ITI)
![Pull Requests](https://img.shields.io/github/issues-pr/ahmedabougabal/DatabaseManagementSystem_ITI)
![License](https://img.shields.io/github/license/ahmedabougabal/DatabaseManagementSystem_ITI)

## Overview

Welcome to the **Bash Shell Script Database Management System (DBMS)**! This project aims to create a lightweight, file-based DBMS using Bash scripts. Users can perform various database operations through a command-line interface.

## Features

- 📁 **Create Database**
- 📜 **List Databases**
- 🔗 **Connect to Database**
- 🗑️ **Drop Database**
- 📋 **Create Table**
- 📄 **List Tables**
- 🗑️ **Drop Table**
- ➕ **Insert into Table**
- 🔍 **Select From Table**
- ❌ **Delete From Table**
- 📝 **Update Table**

## Table of Contents

- [Installation](#installation)
- [Usage](#usage)
- [Commands](#commands)
  - [Database Commands](#database-commands)
  - [Table Commands](#table-commands)
- [Contributing](#contributing)

## Installation

Clone the repository to your local machine:

```sh
git clone https://github.com/ahmedabougabal/DatabaseManagementSystem_ITI.git
cd DatabaseManagementSystem_ITI
```

Make the script executable:

```sh
chmod +x dbms.sh
```

## Usage

Run the main script to start the DBMS:

```sh
./dbms.sh
```

Follow the prompts to interact with the DBMS.

## Commands

### Database Commands

- **Create Database**: Create a new database directory.
- **List Databases**: List all available databases.
- **Connect to Database**: Connect to a specific database.
- **Drop Database**: Delete a specific database.

### Table Commands

Once connected to a database, the following commands are available:

- **Create Table**: Define a new table and its columns.
- **List Tables**: List all tables within the connected database.
- **Drop Table**: Delete a specific table.
- **Insert into Table**: Add a new row to a table.
- **Select From Table**: Display rows from a table.
- **Delete From Table**: Remove specific rows from a table.
- **Update Table**: Modify existing rows in a table.

## Contributing

We welcome contributions to enhance the DBMS. Please follow these steps:

1. Fork the repository.
2. Create a new branch for your feature or bugfix.
3. Commit your changes with a descriptive message.
4. Push your changes to your fork.
5. Create a pull request to the main repository.

<hr />
