const units = [{"name":"1-Introduction","chapters":[{"name":"chapter-1","result":"","files":{"main.cpp":"\nint main() {}\n"},"readme":"<p><strong>Welcome to Learnyoucpp!</strong> Along this journey you&#39;ll learn to write c++ programming language and understand its applications and best practices. We assume you&#39;re already familiar with some programming in general and want to learn or get upto date with recent changes in C++. A lot has changed since the advent of <em>Modern C++</em> but the essentials of language are still preserved. Let&#39;s see what creator of C++ has to say on it -</p>\n<blockquote>\n<p>C++11 feels like a new language. I write code differently now than I did in C++98. The C++11 code is shorter, simpler, and usually more efficient than what I used to write.</p>\n</blockquote>\n<blockquote>\n<p><em>- Bjarne Stroustrup</em></p>\n</blockquote>\n<p>This course is divided into several units which are again divided into several chapters. Each chapter tries to focus on a specific feature of this language and provides challenges that you can complete in order to get familiar with those features and understand more about this language. The aim for this unit is to get you familiar with the language without diving deep into the details. We&#39;ll start with the most minimal program in C++ -</p>\n<h2 id=\"main\">Main</h2>\n<p>The program on the right defines a function called <em>main</em> which takes no arguments and does nothing. Every C++ program must contain exactly one global <em>main</em> function which gets executed right when you run your executable. The braces <code>{</code> &amp; <code>}</code> mark the beginning and end of <em>main</em> function and keyword <code>int</code> specifies the return type of your function. We&#39;ll read more about functions in later units.</p>\n<h3 id=\"todo\">TODO</h3>\n<ul>\n<li>Execute the program by pressing compile button on bottom right of your screen!</li>\n</ul>\n<p><strong>PS</strong>: you can resize everything on this website so try playing out with layout and adjust accordingly :)</p>\n"},{"name":"chapter-2","result":"","files":{"main.cpp":"\n\nint main()\n{\n    /*\n      Hello World\n      This is a multiline comment\n      You should be able to convert this into\n      4 single line comments\n    */\n}\n"},"readme":"<p>Comments are essential feature of a programming language and are used to annotate source code so that its easily readable by other programmers working on same code as yours. C++ offers two types of comments which are pretty common with other programming languages as well -</p>\n<ul>\n<li>Single line comments</li>\n<li>Multi line comments</li>\n</ul>\n<p>Single line comments start with 2 slashes <code>//</code> and extend till the end of line. Anything you write after them is not visible to the compiler till a new line is encountered. Multi-line comments, as the name says, extend to multiple lines and start with <code>/*</code> and end with <code>*/</code>. They are often used to describe documentation of functions,classes,... and other constructs of languages.</p>\n<h3 id=\"todo\">TODO</h3>\n<ul>\n<li>For this chapter you just need to convert the multiline comments to separate single line ones.</li>\n</ul>\n"},{"name":"chapter-3","result":"Hello World!\n","files":{"helper.hpp":"#include <iostream>\n\ntemplate <typename... Args>\nvoid log(Args... args)\n{\n    ((std::cout << args << ' '), ...) << '\\n';\n}\n","main.cpp":"#include \"helper.hpp\"\n\nint main()\n{\n    // replace with log() function\n}\n"},"readme":"<p>You should&#39;ve noticed -</p>\n<pre><code class=\"lang-cpp\">#include &quot;helper.hpp&quot;\n</code></pre>\n<p>in your code by now. <code>#include</code> includes other source file into current source file at the line immediately after the directive. What this means is the content of included file(<code>helper.hpp</code> here) are copied into the current file so that you can use them in your code.</p>\n<p>There are two syntax associated with <code>#include</code> -</p>\n<ul>\n<li><code>#include &lt;file&gt;</code></li>\n<li><code>#include &quot;file&quot;</code></li>\n</ul>\n<p>The first one is generally used when including standard defined header files while the second one is used to include other header files inside our code. In our case we&#39;re using <code>header.hpp</code> file(you can look at its content by opening associated tab) to include a helper function called <code>log()</code>. It takes any number of arguments and prints them to your screen. Don&#39;t worry about its implementation which you can safely ignore for now.</p>\n<h3 id=\"todo\">TODO</h3>\n<p>Since we&#39;ve already introduced <code>log()</code> let&#39;s use it! Print a string to your output panel on the bottom of your screen by writing it between <code>log(</code> ... <code>)</code>. Another thing you might&#39;ve noticed is like several other programming languages, statements in c++ end with a <code>;</code> always, so don&#39;t forget to terminate each statement with one!</p>\n<ul>\n<li>To use <code>log()</code> function, replace that comment with -</li>\n</ul>\n<pre><code class=\"lang-cpp\">log(&quot;Hello World!&quot;);\n</code></pre>\n<p>and execute your program.</p>\n"},{"name":"chapter-4","result":"42\n","files":{"helper.hpp":"#include <iostream>\n\ntemplate <typename... Args>\nvoid log(Args... args)\n{\n    ((std::cout << args << ' '), ...) << '\\n';\n}\n","main.cpp":"#include \"helper.hpp\"\n\nint main()\n{\n    // declare integer a here\n    // print a here\n}\n"},"readme":"<p>There&#39;s one other thing we need to cover before we move over to functions - <strong>Data Types</strong>. C++ is a statically typed language and what that means is, it defines set of possible values and operations associated with our data which can be checked at compile time. For example, if we write -</p>\n<pre><code class=\"lang-cpp\">int a{20};\n</code></pre>\n<p>we&#39;ve just declared a variable <code>a</code> of <em>type</em> integer. Now <code>a</code> being an integer, you can perform additon/subtraction or compare it with other integers. There are several other types in C++ but we&#39;ll divide them into following two categories -</p>\n<ul>\n<li><strong>Fundamental</strong> types eg. int, float, bool...</li>\n<li><strong>Compound</strong> types eg. pointer, array, class...</li>\n</ul>\n<p>In this unit we will only cover Fundamental types and leave Compound types for later.</p>\n<h3 id=\"todo\">TODO</h3>\n<p>For this lesson, we&#39;ll introduce Fundamental integer types. Integer types differ with floating types as they&#39;re unable to store decimal digits. So something like <code>int a{4.5}</code> will fail to compile but <code>int a{4}</code> will do fine. There are two categories of integer types -</p>\n<ul>\n<li><strong>Signed</strong> integers - able to store negative as well as positive numbers</li>\n<li><strong>Unsigned</strong> integers - can only store positive numbers</li>\n</ul>\n<p>You can make an integer type signed/unsigned by appending these keywords ahead of its declaration. By default, not specifying anything is assumed to be signed, for example -</p>\n<pre><code class=\"lang-cpp\">int a{-4};  // signed int\nunsigned int b{4}; // unsigned int\nunsigned int c{-4}; // this won&#39;t compile\n</code></pre>\n<p>Sometimes <code>int</code> data type is not enough to store all required integer values so C++ also provides <code>long int</code> and <code>long long int</code> at your disposal. The only difference is they&#39;re able to represent much higher range of integers. The usual rules of signedness and unsignedness apply here as well.</p>\n<ul>\n<li>To pass this test, declare an integer <code>a</code> with value <code>42</code> and print to screen.</li>\n</ul>\n<p>Hint - You can use <code>log()</code> function to print your integer like this - <code>log(a);</code></p>\n"},{"name":"chapter-5","result":"Sum of number 3 and 5 is: 8\nDifference of number 8 and 2 is: 6\n","files":{"helper.hpp":"#include <iostream>\n\ntemplate <typename... Args>\nvoid log(Args... args)\n{\n    ((std::cout << args << ' '), ...) << '\\n';\n}\n","main.cpp":"#include \"helper.hpp\"\n\nint sum(int a, int b) { return a + b; }\n\n// Add diff function here\n\nint main()\n{\n    int resultSum = sum(3, 5);\n    log(\"Sum of number 3 and 5 is:\", resultSum);\n\n    // Call function diff and store result in resultDiff variable\n\n    log(\"Difference of number 8 and 2 is:\", resultDiff);\n\n    return 0;\n}\n"},"readme":"<p>Now we&#39;ve enough material to cover for an introduction to functions in C++. They&#39;re declared like -</p>\n<pre><code class=\"lang-cpp\">returnType name(T1 arg1, T2 arg2, T3 arg3...) {\n    // body of function\n    return statement;\n}\n</code></pre>\n<p>where</p>\n<ul>\n<li>returnType is placeholder for the type of value it returns</li>\n<li>name is obviously the name of your function</li>\n<li>arg1, arg2, ... represents the parameters taken by this function along with their types T1, T2, ...</li>\n<li><code>{}</code> marks the body of the function</li>\n<li>a return statement that returns a value from the function</li>\n</ul>\n<p>As an example we&#39;ve already created a function named <code>sum()</code> that takes two integer types and returns an integer as result. To call a function we write -</p>\n<pre><code class=\"lang-cpp\">returnType result = name(/* Pass parameters here */);\n</code></pre>\n<p>replacing name with actual function name and parameters with what you want to pass. If this function returns anything, we write another variable on left side of calling it. A function can also choose to return nothing and you don&#39;t need a return statement in that case, as we&#39;ll see in upcoming units.</p>\n<p>Did you notice that we skipped a <code>return</code> statement in <code>int main(){}</code> even though return type is mentioned as <code>int</code>, until now? That is because you can skip it in <code>main()</code> and it is implied to be <code>return 0;</code> by default. The int value returned by main(), if any, is received by the system which chooses to use it for own purposes. A nonzero value from main() indicates failure.</p>\n<h3 id=\"todo\">TODO</h3>\n<p>We&#39;ve already created a <code>sum()</code> function that takes two integers and returns the addition of both which is then stored in <code>resultSum</code> variable. This variable is then printed on the screen along with a message. To pass this lesson, you need to -</p>\n<ul>\n<li>Declare a function named <code>diff()</code> below <code>sum()</code>, that takes two integers and returns the difference of them</li>\n<li>Call the <code>diff()</code> function by passing <code>8</code> and <code>2</code> to it</li>\n<li>Store the result of call in <code>resultDiff</code> variable</li>\n</ul>\n<p>The value of <code>resultDiff</code> will be printed on the console.</p>\n"}]}];