#include "Launcher/Code/RS/RS.hpp"

using namespace aff3ct;
using namespace aff3ct::launcher;

template<class L, typename B, typename R, typename Q>
RS<L, B, R, Q>::RS(const int argc, const char** argv, std::ostream& stream)
  : L(argc, argv, stream)
  , params_cdc(new factory::Codec_RS("cdc"))
{
    this->params.set_cdc(params_cdc);
}

template<class L, typename B, typename R, typename Q>
void
RS<L, B, R, Q>::get_description_args()
{
    params_cdc->get_description(this->args);

    auto penc = params_cdc->enc->get_prefix();
    auto pdec = params_cdc->dec->get_prefix();

    this->args.erase({ penc + "-fra", "F" });
    this->args.erase({ penc + "-seed", "S" });

    L::get_description_args();
}

template<class L, typename B, typename R, typename Q>
void
RS<L, B, R, Q>::store_args()
{
    params_cdc->store(this->arg_vals);

    L::store_args();
}

// ==================================================================================== explicit template instantiation
#include "Launcher/Simulation/BFER_std.hpp"
#include "Tools/types.h"
#ifdef AFF3CT_MULTI_PREC
template class aff3ct::launcher::RS<aff3ct::launcher::BFER_std<B_8, R_8, Q_8>, B_8, R_8, Q_8>;
template class aff3ct::launcher::RS<aff3ct::launcher::BFER_std<B_16, R_16, Q_16>, B_16, R_16, Q_16>;
template class aff3ct::launcher::RS<aff3ct::launcher::BFER_std<B_32, R_32, Q_32>, B_32, R_32, Q_32>;
template class aff3ct::launcher::RS<aff3ct::launcher::BFER_std<B_64, R_64, Q_64>, B_64, R_64, Q_64>;
#else
template class aff3ct::launcher::RS<aff3ct::launcher::BFER_std<B, R, Q>, B, R, Q>;
#endif
// ==================================================================================== explicit template instantiation
