/*!
 * \file
 * \brief Class factory::Encoder_RA.
 */
#ifndef FACTORY_ENCODER_RA_HPP
#define FACTORY_ENCODER_RA_HPP

#include <cli.hpp>
#include <map>
#include <string>
#include <vector>

#include "Factory/Module/Encoder/Encoder.hpp"
#include "Factory/Module/Interleaver/Interleaver.hpp"
#include "Module/Encoder/RA/Encoder_RA.hpp"
#include "Module/Interleaver/Interleaver.hpp"
#include "Tools/Factory/Header.hpp"
#include "Tools/auto_cloned_unique_ptr.hpp"

namespace aff3ct
{
namespace factory
{
extern const std::string Encoder_RA_name;
extern const std::string Encoder_RA_prefix;
class Encoder_RA : public Encoder
{
  public:
    // ----------------------------------------------------------------------------------------------------- PARAMETERS
    // depending parameters
    tools::auto_cloned_unique_ptr<Interleaver> itl;

    // -------------------------------------------------------------------------------------------------------- METHODS
    explicit Encoder_RA(const std::string& p = Encoder_RA_prefix);
    virtual ~Encoder_RA() = default;
    Encoder_RA* clone() const;

    virtual std::vector<std::string> get_names() const;
    virtual std::vector<std::string> get_short_names() const;
    virtual std::vector<std::string> get_prefixes() const;

    // parameters construction
    void get_description(cli::Argument_map_info& args) const;
    void store(const cli::Argument_map_value& vals);
    void get_headers(std::map<std::string, tools::header_list>& headers, const bool full = true) const;

    // builder
    template<typename B = int>
    module::Encoder_RA<B>* build(const module::Interleaver<B>& itl) const;
};
}
}

#endif /* FACTORY_ENCODER_RA_HPP */
