import Head from "next/head";
import { useState } from "react";
import * as Space from "react-spaces";

export default function Home() {
	const [lsize, setLSize] = useState("10%"); // To check for the hover effect
	return (
		<>
			<Space.SSR />
			<Head>
				<title>Create Next App</title>
				<meta name="description" content="Generated by create next app" />
				<meta name="viewport" content="width=device-width, initial-scale=1" />
				<link rel="icon" href="/favicon.ico" />
			</Head>
			<Space.ViewPort>
				<Space.LeftResizable
					size={lsize}
					onMouseEnter={() => setLSize("25%")}
					onMouseLeave={() => setLSize("10%")}
					centerContent={Space.CenterType.HorizontalVertical}
					style={{ backgroundColor: "white", transition: "all 0.3s ease-in-out" }}>
					<span style={{ color: "black" }}>Hello world</span>
				</Space.LeftResizable>
				<Space.RightResizable size="25%" centerContent={Space.CenterType.HorizontalVertical} style={{ backgroundColor: "white" }}>
					<span style={{ color: "black" }}>Hello world</span>
				</Space.RightResizable>
				<Space.Fill>
					<Space.TopResizable size="25%" centerContent={Space.CenterType.HorizontalVertical} style={{ backgroundColor: "white" }}>
						<span style={{ color: "black" }}>Hello world</span>
					</Space.TopResizable>
					<Space.BottomResizable size="25%" centerContent={Space.CenterType.HorizontalVertical} style={{ backgroundColor: "white" }}>
						<span style={{ color: "black" }}>Hello world</span>
					</Space.BottomResizable>
					<Space.Fill centerContent={Space.CenterType.HorizontalVertical}>Hello world</Space.Fill>
				</Space.Fill>
			</Space.ViewPort>
		</>
	);
}
