/*
 * Copyright (c) 2015. Rick Hightower, Geoff Chandler
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *  		http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * QBit - The Microservice lib for Java : JSON, WebSocket, REST. Be The Web!
 */

package io.advantageous.qbit.http.request;


import io.advantageous.qbit.util.MultiMap;
import org.slf4j.LoggerFactory;

import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;

/**
 * Represents a response callback which receives an HTTP response.
 * <p>
 * created by rhightower on 10/21/14.
 *
 * @author rhightower
 *         can be text or binary
 */
public interface HttpResponseReceiver<T> {

    default boolean isText() {
        return true;
    }

    void response(int code, String contentType, T body);


    default void response(int code, String contentType, T body, MultiMap<String, String> headers) {
        response(code, contentType, body);
    }


    default Consumer<Exception> errorHandler() {
        return exception -> LoggerFactory.getLogger(HttpTextResponse.class)
                .error(exception.getMessage(), exception);
    }


    default void respondOK(String json) {
        respond(200, json);
    }

    default void error(String json) {
        respond(500, json);
    }


    default void errorWithCode(String json, int code) {
        respond(code, json);
    }

    default void timeout() {
        respond(408, "\"Timeout\"");
    }


    default void timeoutWithMessage(String json) {
        respond(408, "\"Timeout\"");
    }


    default void respond(int code, String json) {
        if (!isText()) {
            response(code, "application/json", (T) json.getBytes(StandardCharsets.UTF_8));
        } else {
            response(code, "application/json", (T) json);

        }
    }

    default void notFound() {
        respond(404, "\"not found\"");
    }
}
