/*
 * Copyright (c) 2015. Rick Hightower, Geoff Chandler
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *  		http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * QBit - The Microservice lib for Java : JSON, WebSocket, REST. Be The Web!
 */

package io.advantageous.qbit.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Defines a request parameter used to map service method parameters to HTTP request params.
 *
 * @author Rick Hightower
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(value = {ElementType.PARAMETER})
public @interface RequestParam {

    /**
     * Name of the request param.
     *
     * @return value
     */
    String value();

    boolean required() default false;


    /**
     * Default value.
     * The default value is set to AnnotationConstants.NOT_SET which is used
     * to indicate a default value was not set.
     *
     * @return default value
     */
    String defaultValue() default AnnotationConstants.NOT_SET;


    /**
     * Used to document endpoint
     *
     * @return description
     */
    String description() default "no description";


}
