# Code of Conduct

## Introduction

We, the contributors and maintainers of the CompanionLLama project, are committed to providing a welcoming and inclusive environment for everyone, regardless of their background or identity. We want to foster a community where all individuals feel respected, valued, and safe to express their ideas and opinions.

This Code of Conduct outlines our expectations for all those who participate in our community, as well as the consequences for unacceptable behavior. We ask that you read and adhere to this code in all interactions within the CompanionLLama project, including discussions, contributions, and collaborations.

## Our Standards

To create a positive and respectful environment, we have established the following standards for behavior:

### 1. Inclusivity

We welcome contributions from people of all backgrounds and experiences. Discrimination or exclusion based on race, gender, sexual orientation, disability, age, religion, nationality, or any other personal characteristics is not tolerated.

### 2. Respect

We value diverse perspectives and opinions. Disagreements are natural, but we expect all interactions to be conducted with respect and civility. Treat others as you would like to be treated.

### 3. Open Communication

We encourage open and constructive communication. Express your ideas, feedback, and concerns in a clear and respectful manner. Avoid offensive language, personal attacks, and harassment.

### 4. Collaboration

Collaboration is essential to our success. We work together to achieve common goals. Be supportive, helpful, and considerate of others' contributions. Offer assistance when needed and ask for help when necessary.

### 5. Safety

We prioritize the safety and well-being of all community members. Harassment, threats, and any form of unwelcome behavior are unacceptable.

## Unacceptable Behavior

The following behaviors are considered unacceptable and will not be tolerated within the CompanionLLama community:

- Harassment, intimidation, or discrimination in any form.
- Offensive, hurtful, or derogatory comments or jokes.
- Personal attacks or insults, whether in public or private communication.
- Any form of unwelcome advances, including sexual advances.
- Trolling, spamming, or disruptive behavior.
- Doxing (publicly sharing private or personal information about others without their consent).
- Violation of privacy or boundaries.
- Encouraging or glorifying violence or harm to others.

## Reporting and Enforcement

If you believe someone is violating this Code of Conduct, please report it to the project maintainers by contacting us through one of the following channels:

- [GitHub Issues](https://github.com/adithya-s-k/CompanionLLama/issues): Report incidents, violations, or concerns.
- [Email](mailto:adithyaskolavi@cognitivelab.tech): Send an email to the project maintainers.

All reports will be kept confidential. We will promptly review and investigate the issue, and take appropriate action.

Violations of this Code of Conduct may result in temporary or permanent removal from the CompanionLLama community. We reserve the right to enforce consequences based on the severity and nature of the violation, including warnings, temporary suspensions, or permanent bans.

## Acknowledgment

This Code of Conduct is adapted from the [Contributor Covenant](https://www.contributor-covenant.org/), version 2.1, available at [https://www.contributor-covenant.org/version/2/1/code_of_conduct.html](https://www.contributor-covenant.org/version/2/1/code_of_conduct.html).

## Questions and Clarifications

If you have questions or need clarification about this Code of Conduct, please reach out to the project maintainers at [adithyaskolavi@cognitivelab.tech](mailto:adithyaskolavi@cognitivelab.tech).
