# 📜🖼️ Font Gallery

Font Gallery app showcases how different Font Families with their different variations (Style, Weight and Size) look. You could switch between light and dark modes and also compare different font families.

There's a handy search feature to easily search for your favorite fonts and the text to compare the font's could also be changed to a custom user set text.

The Fonts are sourced from Google Fonts and even the Font Author information is displayed.

Please star⭐ the repo if you like what you see😊.

## 💻 Installation and Usage

### [Click here to visit the website version](https://adeeteya.github.io/FontGallery/#/)

### Android

[<img alt='Get it on Google Play' src="https://play.google.com/intl/en_us/badges/static/images/badges/en_badge_web_generic.png" width="250">](https://play.google.com/store/apps/details?id=com.adeeteya.font_gallery&pcampaignid=pcampaignidMKT-Other-global-all-co-prtnr-py-PartBadge-Mar2515-1)

(or)

[![Download apk](https://img.shields.io/badge/Download-apk-green)](https://github.com/adeeteya/FontGallery/releases/download/1.2.1/FontGallery-Android.apk)

### Windows
[![Download exe](https://img.shields.io/badge/Download-exe-blue)](https://github.com/adeeteya/FontGallery/releases/download/1.2.1/FontGallery-Windows.exe)

## ✨ Features

- [x] Display Different Fonts
- [x] Search for Fonts using their name
- [x] Dark/Light Theme Modes
- [x] Input Text to preview how it would look with the selected Font
- [x] Change Font Size
- [x] Display all the Font Weights
- [x] Option to Display a different Font style
- [x] Display Font Author Information
- [x] Compare Fonts
- [ ] Change Font Colors
- [ ] Generate an Image for the font
- [ ] Multi-Language Support

## 📸 Screenshots
<img alt="Light Mode Image" src="screenshots/app_screenshot_1.jpg" height="587px" width="256px"/> <img alt="Dark Mode Image" src="screenshots/app_screenshot_2.jpg" height="587px" width="256px"/> <img alt="Search Screen Image" src="screenshots/app_screenshot_3.jpg" height="587px" width="256px"/> <img alt="Input Text Image" src="screenshots/app_screenshot_4.jpg" height="587px" width="256px"/> <img alt="Input Text Image" src="screenshots/app_screenshot_5.jpg" height="587px" width="256px"/> <img alt="Input Text Image" src="screenshots/app_screenshot_6.jpg" height="587px" width="256px"/>

## 🔌 Plugins

| Name                                                                  | Usage                               |
|-----------------------------------------------------------------------|-------------------------------------|
| [**shared_preferences**](https://pub.dev/packages/shared_preferences) | To store theme mode preference      |
| [**flutter_lints**](https://pub.dev/packages/flutter_lints)           | For linting                         |
| [**lottie**](https://pub.dev/packages/lottie)                         | For Theme Switch Animation          |
| [**google_fonts**](https://pub.dev/packages/google_fonts)             | For downloading the different fonts |
| [**flutter_riverpod**](https://pub.dev/packages/flutter_riverpod)     | For managing the state              |

## 🤓 Author

**[Aditya R](https://github.com/adeeteya)**

## 🔖 LICENSE
Copyright (c) 2023 **[Aditya R](https://github.com/adeeteya)**
[MIT LICENSE](https://github.com/adeeteya/FontGallery/blob/master/LICENSE)

## 🙏 Attributions
<a href="https://www.flaticon.com/free-icons/font-size" title="font size icons">Font size icons created by Freepik - Flaticon</a>