/*
 * This file is part of Adblock Plus <https://adblockplus.org/>,
 * Copyright (C) 2006-present eyeo GmbH
 *
 * Adblock Plus is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * Adblock Plus is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Adblock Plus.  If not, see <http://www.gnu.org/licenses/>.
 */

export const ANNOYANCE_SUBSCRIPTION_TYPE = "annoyances";
export const COOKIES_PREMIUM_SUBSCRIPTION_TYPE = "cookies-premium";

/**
 * Premium subscription types
 */
export const premiumTypes = new Set([
  ANNOYANCE_SUBSCRIPTION_TYPE,
  COOKIES_PREMIUM_SUBSCRIPTION_TYPE
]);

export type PremiumSubscriptionType =
  | typeof ANNOYANCE_SUBSCRIPTION_TYPE
  | typeof COOKIES_PREMIUM_SUBSCRIPTION_TYPE;
