/*
 * This file is part of Adblock Plus <https://adblockplus.org/>,
 * Copyright (C) 2006-present eyeo GmbH
 *
 * Adblock Plus is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * Adblock Plus is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Adblock Plus.  If not, see <http://www.gnu.org/licenses/>.
 */

export default {
  extends: "base",
  webpack: {
    alias: {
      "./info$": "./info.firefox.ts"
    },
    bundles: [
      {
        dest: "background.js",
        src: ["mocks/js/background.mjs"],
        overwrite: true
      },
      {
        dest: "polyfill.js",
        src: ["mocks/js/polyfills/ui/index.entry.mjs"],
        overwrite: true
      },
      {
        dest: "polyfill-background.js",
        src: ["mocks/js/polyfills/background/index.entry.mjs"],
        overwrite: true
      },
      // Specific to Firefox Mobile
      {
        dest: "mobile-options.js",
        src: ["js/pages/mobile-options.mjs"]
      }
    ]
  },
  mapping: {
    copy: [
      {
        dest: "locale",
        src: ["locale/**"]
      },
      {
        dest: "mocks",
        src: ["mocks/background.html"]
      },
      {
        dest: "mocks/data",
        src: ["mocks/data/**"]
      },
      // Specific to Firefox Mobile
      {
        dest: "skin",
        src: [
          "skin/icons/mobile/**"
        ]
      },
      {
        dest: "",
        src: ["src/mobile-options/ui/mobile-options.html"]
      }
    ],
    rename: []
  }
};
