// Automatically generated by Interoptopus.

#pragma warning disable 0105
using System;
using System.Collections;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using EdgeVectorIndex;
#pragma warning restore 0105

namespace EdgeVectorIndex
{
    internal static partial class Interop
    {
        public const string NativeLib = "libedge_vector_index";

        static Interop()
        {
        }


        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "create")]
        public static extern IntPtr create();

        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "add_to_index")]
        public static extern void add_to_index(IntPtr handle, Data data);

        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "find_closest_match")]
        public static extern int find_closest_match(IntPtr handle, Slicef32 vector);

        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "free_resources")]
        public static extern void free_resources(IntPtr handle);

        [DllImport(NativeLib, CallingConvention = CallingConvention.Cdecl, EntryPoint = "cosine_similarity")]
        public static extern float cosine_similarity(Slicef32 input, Slicef32 output);

    }

    [Serializable]
    [StructLayout(LayoutKind.Sequential)]
    internal partial struct Data
    {
        public Slicef32 data;
        public int id;
    }

    ///A pointer to an array of data someone else owns which may not be modified.
    [Serializable]
    [StructLayout(LayoutKind.Sequential)]
    internal partial struct Slicef32
    {
        ///Pointer to start of immutable data.
        IntPtr data;
        ///Number of elements.
        ulong len;
    }

    internal partial struct Slicef32 : IEnumerable<float>
    {
        public Slicef32(GCHandle handle, ulong count)
        {
            this.data = handle.AddrOfPinnedObject();
            this.len = count;
        }
        public Slicef32(IntPtr handle, ulong count)
        {
            this.data = handle;
            this.len = count;
        }
        public float this[int i]
        {
            get
            {
                if (i >= Count) throw new IndexOutOfRangeException();
                var size = Marshal.SizeOf(typeof(float));
                var ptr = new IntPtr(data.ToInt64() + i * size);
                return Marshal.PtrToStructure<float>(ptr);
            }
        }
        public float[] Copied
        {
            get
            {
                var rval = new float[len];
                for (var i = 0; i < (int) len; i++) {
                    rval[i] = this[i];
                }
                return rval;
            }
        }
        public int Count => (int) len;
        public IEnumerator<float> GetEnumerator()
        {
            for (var i = 0; i < (int)len; ++i)
            {
                yield return this[i];
            }
        }
        IEnumerator IEnumerable.GetEnumerator()
        {
            return this.GetEnumerator();
        }
    }




    public class InteropException<T> : Exception
    {
        public T Error { get; private set; }

        public InteropException(T error): base($"Something went wrong: {error}")
        {
            Error = error;
        }
    }

}
