// ==UserScript==
// @name                ChatGPT Auto-Talk 📣
// @name:af             ChatGPT Auto-Praat 📣
// @name:am             ChatGPT በራስሰር እንጋቢ 📣
// @name:ar             ChatGPT التحدث التلقائي 📣
// @name:az             ChatGPT Avtomatik-Danışıq 📣
// @name:be             ChatGPT Аўта-Размова 📣
// @name:bem            ChatGPT Kusogolo Kwati 📣
// @name:bg             ChatGPT Авто-Разговор 📣
// @name:bn             ChatGPT অটো-টক 📣
// @name:bo             ChatGPT རང་འཛུལ་སྐད་ཆེན་པོ 📣
// @name:bs             ChatGPT Auto-Razgovor 📣
// @name:ca             ChatGPT Auto-Parla 📣
// @name:ceb            ChatGPT Auto-Panulti 📣
// @name:ckb            ChatGPT ئەوەی-خۆکار 📣
// @name:cs             ChatGPT Automatický-Rozhovor 📣
// @name:cy             ChatGPT Sgwrsio-Awtomatig 📣
// @name:da             ChatGPT Auto-Tale 📣
// @name:de             ChatGPT Auto-Sprechen 📣
// @name:dv             ChatGPT އޮޓޯ-ކޮމިއުނިކޭޝަން 📣
// @name:dz             ChatGPT རང་འཛུལ་སྐད་ཆེན་པོ 📣
// @name:el             ChatGPT Αυτόματη-Ομιλία 📣
// @name:eo             ChatGPT Aŭtomata-Parolo 📣
// @name:es             ChatGPT Auto-Hablar 📣
// @name:et             ChatGPT Automaatne-Jutt 📣
// @name:eu             ChatGPT Auto-Hizketa 📣
// @name:fa             ChatGPT گفتگوی خودکار 📣
// @name:fi             ChatGPT Auto-Puhe 📣
// @name:fo             ChatGPT Sjálvvirkandi-Prát 📣
// @name:fr             ChatGPT Auto-Parler 📣
// @name:fr-CA          ChatGPT Auto-Parler 📣
// @name:gd             ChatGPT Fèin-Labhairt 📣
// @name:gl             ChatGPT Auto-Falar 📣
// @name:gu             ChatGPT ઓટો-બોલો 📣
// @name:haw            ChatGPT Kūʻokoʻa-ʻŌlelo 📣
// @name:he             ChatGPT דיבור-אוטומטי 📣
// @name:hi             ChatGPT ऑटो-टॉक 📣
// @name:hr             ChatGPT Auto-Razgovor 📣
// @name:ht             ChatGPT Auto-Pale 📣
// @name:hu             ChatGPT Auto-Beszélgetés 📣
// @name:hy             ChatGPT Ինքնաբերաբար-Խոսք 📣
// @name:id             ChatGPT Bicara-Otomatis 📣
// @name:is             ChatGPT Sjálfvirk-Tal 📣
// @name:it             ChatGPT Auto-Parlare 📣
// @name:ja             ChatGPT オートトーク 📣
// @name:jv             ChatGPT Auto-Omah 📣
// @name:ka             ChatGPT ავტო-ლაპარაკი 📣
// @name:kab            ChatGPT Awto-Talqeq 📣
// @name:kk             ChatGPT Авто-Сөйлеу 📣
// @name:km             ChatGPT ការប្រាស្រ័យអគ្គិសនី 📣
// @name:kn             ChatGPT ಸ್ವಯಂಚಾಲಿತ-ಮಾತು 📣
// @name:ko             ChatGPT 자동-토크 📣
// @name:ku             ChatGPT Axê-Raxt 📣
// @name:ky             ChatGPT Авто-Сүйлөшүү 📣
// @name:la             ChatGPT Auto-Loquens 📣
// @name:lb             ChatGPT Auto-Schwätzen 📣
// @name:lo             ChatGPT ການເວົ້າອັດຕະໂນມັດ 📣
// @name:lt             ChatGPT Auto-Kalba 📣
// @name:lv             ChatGPT Auto-Saruna 📣
// @name:mg             ChatGPT Auto-Kabary 📣
// @name:mi             ChatGPT Aunoa-Kōrero 📣
// @name:mk             ChatGPT Авто-Разговор 📣
// @name:ml             ChatGPT ഓട്ടോ-സംസാരം 📣
// @name:mn             ChatGPT Автомат-Яриа 📣
// @name:ms             ChatGPT Auto-Bercakap 📣
// @name:mt             ChatGPT Auto-Kellem 📣
// @name:my             ChatGPT အလိုအလျောက်-စကားပြော 📣
// @name:ne             ChatGPT स्वचालित-वार्ता 📣
// @name:nl             ChatGPT Auto-Praten 📣
// @name:no             ChatGPT Auto-Snakke 📣
// @name:ny             ChatGPT Auto-Kulankhula 📣
// @name:pa             ChatGPT ਆਟੋ-ਗੱਲਬਾਤ 📣
// @name:pap            ChatGPT Auto-Papia 📣
// @name:pl             ChatGPT Auto-Rozmowa 📣
// @name:ps             ChatGPT خودکاره-خبري کول 📣
// @name:pt             ChatGPT Auto-Falar 📣
// @name:pt-BR          ChatGPT Auto-Falar 📣
// @name:rn             ChatGPT Auto-Kuvuga 📣
// @name:ro             ChatGPT Auto-Vorbire 📣
// @name:ru             ChatGPT Авто-Разговор 📣
// @name:rw             ChatGPT Ibyoguhindura 📣
// @name:sg             ChatGPT Auto-Yângâ 📣
// @name:si             ChatGPT ස්වයංක්‍රීය-කතා 📣
// @name:sk             ChatGPT Automatický-Rozhovor 📣
// @name:sl             ChatGPT Avtomatski-Pogovor 📣
// @name:sm             ChatGPT Fetalai-Otometi 📣
// @name:sn             ChatGPT Auto-Taurirana 📣
// @name:so             ChatGPT Hadal-otomaatig ah 📣
// @name:sr             ChatGPT Ауто-Разговор 📣
// @name:sv             ChatGPT Auto-Prata 📣
// @name:sw             ChatGPT Maongezi-Otomatiki 📣
// @name:ta             ChatGPT தானாகவே-பேச்சு 📣
// @name:te             ChatGPT ఆటో-మాట 📣
// @name:tg             ChatGPT Авто-Гап 📣
// @name:th             ChatGPT การสนทนาอัตโนมัติ 📣
// @name:ti             ChatGPT እስካምልክቲ-ቃል ኣቐሪቡ 📣
// @name:tk             ChatGPT Auto-Dialog 📣
// @name:tn             ChatGPT Auto-Matla 📣
// @name:to             ChatGPT Fakamatala-Otometi 📣
// @name:tpi            ChatGPT Autometik-Tok 📣
// @name:tr             ChatGPT Otomatik-Konuşma 📣
// @name:uk             ChatGPT Авто-Розмова 📣
// @name:ur             ChatGPT خودکار-بات 📣
// @name:uz             ChatGPT Avto-Suhbat 📣
// @name:vi             ChatGPT Tự-Động-Nói 📣
// @name:xh             ChatGPT IyaZenzekelayo-Thetha 📣
// @name:yi             ChatGPT אַוטאָ-רעדן 📣
// @name:zh             ChatGPT 自动谈话 📣
// @name:zh-CN          ChatGPT 自动谈话 📣
// @name:zh-HK          ChatGPT 自動談話 📣
// @name:zh-SG          ChatGPT 自动谈话 📣
// @name:zh-TW          ChatGPT 自動談話 📣
// @name:zu             ChatGPT Ukuzenzakalela-Ukhuluma 📣
// @description         Automatically play ChatGPT responses
// @description:af      Speel ChatGPT-antwoorde outomaties af
// @description:am      ምርመራ ChatGPT ምላሾችን በራስ-ሰር
// @description:ar      تشغيل ردود ChatGPT تلقائيًا
// @description:az      ChatGPT cavablarını avtomatik olaraq oynat
// @description:be      Аўтаматычнае прайграванне адказаў ChatGPT
// @description:bem     Panga zolingana pa ChatGPT mwankhama
// @description:bg      Автоматично възпроизвеждане на отговори от ChatGPT
// @description:bn      ChatGPT প্রতিক্রিয়া স্বয়ংক্রিয়ভাবে প্লে করুন
// @description:bo      ChatGPT ལྟེ་བཤོལ་རང་འཛུལ་སྐད་སྒྲོན་འགྲོ
// @description:bs      Automatski reproducirajte odgovore ChatGPT-a
// @description:ca      Reproduir automàticament les respostes de ChatGPT
// @description:ceb     Awomatikong pagdula sa mga tubag sa ChatGPT
// @description:ckb     بەرزکردنی وەڵامەکانی ChatGPT بە شێوەی خۆکار
// @description:cs      Automatické přehrávání odpovědí ChatGPT
// @description:cy      Chwarae atebion ChatGPT yn awtomatig
// @description:da      Afspil ChatGPT-svar automatisk
// @description:de      ChatGPT-Antworten automatisch abspielen
// @description:dv      ChatGPT ޖެހިދާން އޮޓޯއެވެއްވިދާނެއް ކުރޭ
// @description:dz      ChatGPT བརྒྱུད་གཏོང་རང་འཛུལ་སྐད་སྒྲོན་འགྲོ
// @description:el      Αυτόματη αναπαραγωγή απαντήσεων ChatGPT
// @description:eo      Aŭtomate ludi ChatGPT-respondojn
// @description:es      Reproducir automáticamente respuestas de ChatGPT
// @description:et      ChatGPT vastuste automaatne esitamine
// @description:eu      ChatGPT erantzunak automatikoki erreproduzitu
// @description:fa      پخش خودکار پاسخهای ChatGPT
// @description:fi      Toista ChatGPT-vastaukset automaattisesti
// @description:fo      Spæl ChatGPT svar sjálvvirkandi
// @description:fr      Lire automatiquement les réponses de ChatGPT
// @description:fr-CA   Lire automatiquement les réponses de ChatGPT
// @description:gd      Cluich gu fèin-ghluasadach freagairtean ChatGPT
// @description:gl      Reproducir automaticamente as respostas de ChatGPT
// @description:gu      ChatGPT પ્રતિક્રિયાઓ આપોઆપ વગાડો
// @description:haw     Hoʻopaʻapaʻa i nā pane ChatGPT ma ka automate
// @description:he      השמע תגובות ChatGPT באופן אוטומטי
// @description:hi      ChatGPT प्रतिक्रियाओं को स्वचालित रूप से चलाएं
// @description:hr      Automatski reproducirajte odgovore ChatGPT-a
// @description:ht      Jwe repons ChatGPT otomatikman
// @description:hu      ChatGPT-válaszok automatikus lejátszása
// @description:hy      Ավտոմատ նվագարկել ChatGPT-ի պատասխանները
// @description:id      Mainkan respons ChatGPT secara otomatis
// @description:is      Spilaðu sjálfkrafa svör ChatGPT
// @description:it      Riprodurre automaticamente le risposte di ChatGPT
// @description:ja      ChatGPT の回答を自動的に再生する
// @description:jv      Puter balasan ChatGPT kanthi otomatis
// @description:ka      ავტომატურად ითამაშეთ ChatGPT პასუხები
// @description:kab     Melk ikdimen n d-yitran n ChatGPT
// @description:kk      ChatGPT жауаптарын автоматты түрде ойнату
// @description:km      លេងការឆ្លើយតបរបស់ ChatGPT ដោយស្វ័យប្រវត្តិ
// @description:kn      ChatGPT ಪ್ರತಿಕ್ರಿಯೆಗಳನ್ನು ಸ್ವಯಂಚಾಲಿತವಾಗಿ ಪ್ಲೇ ಮಾಡಿ
// @description:ko      ChatGPT 응답 자동 재생
// @description:ku      Serdana erebeyîyan bi xweka yên ChatGPT bixwe
// @description:ky      ChatGPT жоопторун автоматтык түрдө ойнотуу
// @description:la      Lude responsiones ChatGPT automatice
// @description:lb      ChatGPT-Äntwerten automatesch ofspillen
// @description:lo      ຄວາມສົມພາດ ChatGPT ໃນຕົວເອງ
// @description:lt      Automatiškai leisti ChatGPT atsakymus
// @description:lv      Automātiski atskaņot ChatGPT atbildes
// @description:mg      Alefaso ho azy ny valintenin'i ChatGPT
// @description:mi      Purei aunoa i ngā whakautu a ChatGPT
// @description:mk      Автоматски пуштај одговори на ChatGPT
// @description:ml      ChatGPT പ്രതികരണങ്ങൾ സ്വയമേവ പ്ലേ ചെയ്യുക
// @description:mn      ChatGPT хариултыг автоматаар тоглуулах
// @description:ms      Mainkan tindak balas ChatGPT secara automatik
// @description:mt      Awtomatikament iddoqq ir-risposti ta' ChatGPT
// @description:my      ChatGPT ၏တုံ့ပြန်ချက်များကို အလိုအလျောက် ဖွင့်ပါ
// @description:ne      ChatGPT प्रतिक्रियाहरू स्वचालित रूपमा प्ले गर्नुहोस्
// @description:nl      Speel ChatGPT-antwoorden automatisch af
// @description:no      Spill ChatGPT-svar automatisk
// @description:ny      Sewera mayankho a ChatGPT zokha
// @description:pa      ChatGPT ਦੇ ਜਵਾਬ ਆਟੋਮੈਟਿਕ ਚਲਾਓ
// @description:pap     Hunga respuesta di ChatGPT otomátikamente
// @description:pl      Automatyczne odtwarzanie odpowiedzi ChatGPT
// @description:ps      د ChatGPT ځوابونه په اوتومات ډول لوبې کړئ
// @description:pt      Reproduzir automaticamente respostas do ChatGPT
// @description:pt-BR   Reproduzir automaticamente respostas do ChatGPT
// @description:rn      Gukina ivyishura vya ChatGPT ku buryo bwikora
// @description:ro      Redați automat răspunsurile ChatGPT
// @description:ru      Автоматическое воспроизведение ответов ChatGPT
// @description:rw      Gukina ibisubizo bya ChatGPT ku buryo bwikora
// @description:sg      Gbangba ko ye tere ChatGPT makumba mbene
// @description:si      ChatGPT ප්‍රතිචාර ස්වයංක්‍රීයව ප්ලේ කරන්න
// @description:sk      Automatické prehrávanie odpovedí ChatGPT
// @description:sl      Samodejno predvajaj odgovore ChatGPT
// @description:sm      Taʻa otometi tali a le ChatGPT
// @description:sn      Tumira otomatiki mhinduro dzeChatGPT
// @description:so      Si toos ah u ciyaar jawaabaha ChatGPT
// @description:sr      Аутоматски пуштајте одговоре ChatGPT-а
// @description:sv      Spela upp ChatGPT-svar automatiskt
// @description:sw      Chezesha majibu ya ChatGPT kiotomatiki
// @description:ta      ChatGPT பதில்களை தானாகவே இயக்கவும்
// @description:te      ChatGPT ప్రతిస్పందనలను ఆటోమేటిక్ గా ప్లే చేయండి
// @description:tg      Ба таври худкор ҷавобҳои ChatGPT-ро навозед
// @description:th      เล่นการตอบสนอง ChatGPT โดยอัตโนมัติ
// @description:ti      እቶም ምላእ ብኣውቶማቲክ ንእሽቶ ChatGPT እቶም እዩ ክንዕዘምብ እዩ
// @description:tk      ChatGPT jogaplaryny awtomatiki oýnamak
// @description:tn      Dira karabo tsa ChatGPT ka boitsamaisi
// @description:to      Tataki ke tali ʻo e ChatGPT ‘i he ngaahi fakamatala faka‘otometiki
// @description:tpi     Pleiim ol toktok blong ChatGPT olsem otomat
// @description:tr      ChatGPT yanıtlarını otomatik olarak oynat
// @description:uk      Автоматично відтворювати відповіді ChatGPT
// @description:ur      خودکار طور پر ChatGPT جوابات چلائیں
// @description:uz      ChatGPT javoblarini avtomatik ijro etish
// @description:vi      Tự động phát các phản hồi của ChatGPT
// @description:xh      Dlala iimpendulo zeChatGPT ngokuzenzekelayo
// @description:yi      שפּיל אויטאָמאַטיש ChatGPT ענטפֿערס
// @description:zh      自动播放 ChatGPT 的回复
// @description:zh-CN   自动播放 ChatGPT 的回复
// @description:zh-HK   自動播放 ChatGPT 的回覆
// @description:zh-SG   自动播放 ChatGPT 的回复
// @description:zh-TW   自動播放 ChatGPT 的回覆
// @description:zu      Dlala izimpendulo ze-ChatGPT ngokuzenzakalela
// @author              Adam Lui
// @namespace           https://github.com/adamlui
// @version             2025.1.4
// @license             MIT
// @icon                https://assets.chatgptautotalk.com/images/icons/openai/black/icon48.png?v=9f1ed3c
// @icon64              https://assets.chatgptautotalk.com/images/icons/openai/black/icon64.png?v=9f1ed3c
// @match               *://chatgpt.com/*
// @match               *://chat.openai.com/*
// @connect             cdn.jsdelivr.net
// @connect             update.greasyfork.org
// @require             https://cdn.jsdelivr.net/npm/@kudoai/chatgpt.js@3.5.0/dist/chatgpt.min.js#sha256-+C0x4BOFQc38aZB3pvUC2THu+ZSvuCxRphGdtRLjCDg=
// @resource brsCSS     https://assets.aiwebextensions.com/styles/rising-stars/dist/black.min.css?v=3289404#sha256-CTj6Ndngq+TsPlNpQ6Ej39PQKSDpmxyKUFohhc91ruQ=
// @resource wrsCSS     https://assets.aiwebextensions.com/styles/rising-stars/dist/white.min.css?v=3289404#sha256-tOOIvIe6O5/x2A5E7s9kP4+zw0d4EEDfRgXQLq2KwLs=
// @grant               GM_setValue
// @grant               GM_getValue
// @grant               GM_registerMenuCommand
// @grant               GM_unregisterMenuCommand
// @grant               GM_getResourceText
// @grant               GM_xmlhttpRequest
// @grant               GM.xmlHttpRequest
// @noframes
// @downloadURL         https://update.greasyfork.org/scripts/500940/autoclear-chatgpt-history.user.js
// @updateURL           https://update.greasyfork.org/scripts/500940/autoclear-chatgpt-history.meta.js
// @homepageURL         https://www.chatgptautotalk.com
// @supportURL          https://support.chatgptautotalk.com
// @contributionURL     https://github.com/sponsors/adamlui
// ==/UserScript==

// NOTE: This script relies on the powerful chatgpt.js library @ https://chatgpt.js.org
//  © 2023–2025 KudoAI & contributors under the MIT license.

(async () => {

    // Init ENV context
    const env = {
        browser: {
            language: chatgpt.getUserLanguage(), isMobile: chatgpt.browser.isMobile(), isFF: chatgpt.browser.isFirefox()
        },
        scriptManager: {
            name: (() => { try { return GM_info.scriptHandler } catch (err) { return 'unknown' }})(),
            version: (() => { try { return GM_info.version } catch (err) { return 'unknown' }})()
        },
        ui: { scheme: getScheme() }
    }
    env.browser.isPortrait = env.browser.isMobile && (window.innerWidth < window.innerHeight)
    env.scriptManager.supportsTooltips = env.scriptManager.name == 'Tampermonkey'
                                      && parseInt(env.scriptManager.version.split('.')[0]) >= 5
    const xhr = typeof GM != 'undefined' && GM.xmlHttpRequest || GM_xmlhttpRequest

    // Init APP data
    const app = {
        name: 'ChatGPT Auto-Talk', version: GM_info.script.version, symbol: '📣', cssPrefix: 'chatgpt-auto-talk',
        configKeyPrefix: 'chatGPTautoTalk', chatgptJSver: /chatgpt\.js@([\d.]+)/.exec(GM_info.scriptMetaStr)[1],
        author: { name: 'Adam Lui', url: 'https://github.com/adamlui' },
        urls: {
            chatgptJS: 'https://chatgpt.js.org',
            contributors: 'https://docs.chatgptautotalk.com/#-contributors',
            donate: {
                cashApp: 'https://cash.app/$adamlui',
                gitHub: 'https://github.com/sponsors/adamlui',
                payPal: 'https://paypal.me/adamlui'
            },
            gitHub: 'https://github.com/adamlui/chatgpt-auto-talk',
            greasyFork: 'https://greasyfork.org/en/scripts/500940-chatgpt-auto-talk',
            relatedExtensions: 'https://github.com/adamlui/ai-web-extensions',
            review: {
                greasyFork: 'https://greasyfork.org/en/scripts/500940-chatgpt-auto-talk/feedback#post-discussion'
            },
            support: 'https://support.chatgptautotalk.com'
        },
        latestAssetCommitHash: '19ff069' // for cached messages.json + navicon in toggles.sidebar.insert()
    }
    app.urls.assetHost = app.urls.gitHub.replace('github.com', 'cdn.jsdelivr.net/gh') + `@${app.latestAssetCommitHash}`
    app.urls.update = app.urls.greasyFork.replace('https://', 'https://update.')
        .replace(/(\d+)-?([a-z-]*)$/i, (_, id, name) => `${id}/${ name || 'script' }.meta.js`)
    app.msgs = {
        appName: app.name,
        appAuthor: app.author.name,
        appDesc: 'Automatically play ChatGPT responses',
        menuLabel_toggleVis: 'Toggle Visibility',
        menuLabel_about: 'About',
        menuLabel_donate: 'Please send a donation',
        about_author: 'Author',
        about_and: '&',
        about_contributors: 'contributors',
        about_version: 'Version',
        about_poweredBy: 'Powered by',
        about_openSourceCode: 'Open source code',
        mode_autoTalk: 'Auto-Talk',
        helptip_toggleVis: 'Show Auto-Talk toggle in sidebar',
        alert_updateAvail: 'Update available',
        alert_newerVer: 'An update to',
        alert_isAvail: 'is available',
        alert_upToDate: 'Up-to-date',
        alert_showYourSupport: 'Show your support',
        alert_isOSS: 'is open-source software built & maintained for free through 100% volunteer efforts',
        alert_despiteAffliction: 'Despite being severely afflicted by',
        alert_longCOVID: 'long COVID',
        alert_since2020: 'since 2020',
        alert_byDonatingResults: 'by donating, you help me to continue improving, fixing bugs, adding new features, and making the software even better',
        alert_yourContrib: 'Your contribution',
        alert_noMatterSize: 'no matter the size',
        alert_directlySupports: 'directly supports my unpaid efforts to ensure this project remains free and open for all to use',
        alert_tyForSupport: 'Thank you for your support',
        alert_isUpToDate: 'is up-to-date',
        btnLabel_moreAIextensions: 'More AI Extensions',
        btnLabel_rateUs: 'Rate Us',
        btnLabel_getSupport: 'Get Support',
        btnLabel_checkForUpdates: 'Check for Updates',
        btnLabel_update: 'Update',
        btnLabel_dismiss: 'Dismiss',
        link_viewChanges: 'View changes',
        state_enabled: 'enabled',
        state_disabled: 'disabled',
        state_on: 'on',
        state_off: 'off'
    }

    // LOCALIZE app.msgs for non-English users
    if (!env.browser.language.startsWith('en')) {
        const localizedMsgs = await new Promise(resolve => {
            const msgHostDir = app.urls.assetHost + '/greasemonkey/_locales/',
                  msgLocaleDir = ( env.browser.language ? env.browser.language.replace('-', '_') : 'en' ) + '/'
            let msgHref = msgHostDir + msgLocaleDir + 'messages.json', msgXHRtries = 0
            function fetchMsgs() { xhr({ method: 'GET', url: msgHref, onload: handleMsgs })}
            function handleMsgs(resp) {
                try { // to return localized messages.json
                    const msgs = JSON.parse(resp.responseText), flatMsgs = {}
                    for (const key in msgs)  // remove need to ref nested keys
                        if (typeof msgs[key] == 'object' && 'message' in msgs[key])
                            flatMsgs[key] = msgs[key].message
                    resolve(flatMsgs)
                } catch (err) { // if bad response
                    msgXHRtries++ ; if (msgXHRtries == 3) return resolve({}) // try original/region-stripped/EN only
                    msgHref = env.browser.language.includes('-') && msgXHRtries == 1 ? // if regional lang on 1st try...
                        msgHref.replace(/([^_]+_[^_]+)_[^/]*(\/.*)/, '$1$2') // ...strip region before retrying
                            : ( msgHostDir + 'en/messages.json' ) // else use default English messages
                    fetchMsgs()
                }
            }
            fetchMsgs()
        })
        Object.assign(app.msgs, localizedMsgs)
    }

    // Init SETTINGS
    const config = {}
    const settings = {

        controls: { // displays top-to-bottom in toolbar menu
            autoTalkDisabled: { type: 'toggle', label: app.msgs.mode_autoTalk },
            toggleHidden: { type: 'toggle', label: app.msgs.menuLabel_toggleVis, helptip: app.msgs.helptip_toggleVis }
        },

        load(...keys) { keys.flat().forEach(key => config[key] = GM_getValue(app.configKeyPrefix + '_' + key, false)) },

        save(key, val) { GM_setValue(app.configKeyPrefix + '_' + key, val) ; config[key] = val }
    }
    settings.load('autoTalkDisabled', 'toggleHidden')

    // Define MENU functions

    const menu = {
        ids: [], state: {
            symbols: ['❌', '✔️'], separator: env.scriptManager.name == 'Tampermonkey' ? ' — ' : ': ',
            words: [app.msgs.state_off.toUpperCase(), app.msgs.state_on.toUpperCase()]
        },

        register() {

            // Add toggles
            Object.keys(settings.controls).forEach(key => {
                const settingIsEnabled = config[key] ^ /disabled|hidden/i.test(key)
                const menuLabel = `${ settings.controls[key].symbol || menu.state.symbols[+settingIsEnabled] } `
                                + settings.controls[key].label
                                + menu.state.separator + menu.state.words[+settingIsEnabled]
                menu.ids.push(GM_registerMenuCommand(menuLabel, () => {
                    settings.save(key, !config[key]) ; syncConfigToUI({ updatedKey: key })
                    notify(`${settings.controls[key].label}: ${
                        menu.state.words[+(config[key] ^ /disabled|hidden/i.test(key))]}`)
                }, env.scriptManager.supportsTooltips ? { title: settings.controls[key].helptip || ' ' } : undefined))
            });

            // Add About/Donate entries
            ['about', 'donate'].forEach(entryType => menu.ids.push(GM_registerMenuCommand(
                `${ entryType == 'about' ? '💡' : '💖' }`
                    + ` ${app.msgs[`menuLabel_${entryType}`]} ${ entryType == 'about' ? app.msgs.appName : '' }`,
                () => modals.open(entryType), env.scriptManager.supportsTooltips ? { title: ' ' } : undefined
            )))
        },

        refresh() {
            if (typeof GM_unregisterMenuCommand == 'undefined') return
            for (const id of menu.ids) { GM_unregisterMenuCommand(id) } menu.register()
        }
    }

    function updateCheck() {
        xhr({
            method: 'GET', url: app.urls.update + '?t=' + Date.now(),
            headers: { 'Cache-Control': 'no-cache' },
            onload: resp => {

                // Compare versions, alert if update found
                app.latestVer = /@version +(.*)/.exec(resp.responseText)[1]
                for (let i = 0 ; i < 4 ; i++) { // loop thru subver's
                    const currentSubVer = parseInt(app.version.split('.')[i], 10) || 0,
                          latestSubVer = parseInt(app.latestVer.split('.')[i], 10) || 0
                    if (currentSubVer > latestSubVer) break // out of comparison since not outdated
                    else if (latestSubVer > currentSubVer) // if outdated
                        return modals.open('update', 'available')
                }

                // Alert to no update found, nav back to About
                modals.open('update', 'unavailable')
        }})
    }

    // Define FEEDBACK functions

    function notify(msg, pos = '', notifDuration = '', shadow = '') {

        // Strip state word to append colored one later
        const foundState = menu.state.words.find(word => msg.includes(word))
        if (foundState) msg = msg.replace(foundState, '')

        // Show notification
        chatgpt.notify(`${app.symbol} ${msg}`, pos, notifDuration, shadow || env.ui.scheme == 'dark' ? '' : 'shadow')
        const notif = document.querySelector('.chatgpt-notif:last-child')

        // Append styled state word
        if (foundState) {
            const styledStateSpan = document.createElement('span')
            styledStateSpan.style.cssText = `color: ${
                foundState == menu.state.words[0] ? '#ef4848 ; text-shadow: rgba(255,169,225,0.44) 2px 1px 5px'
                                                  : '#5cef48 ; text-shadow: rgba(255,250,169,0.38) 2px 1px 5px' }`
            styledStateSpan.append(foundState) ; notif.append(styledStateSpan)
        }
    }

    // Define MODAL functions

    const modals = {
        stack: [], // of types of undismissed modals
        class: `${app.cssPrefix}-modal`,

        alert(title = '', msg = '', btns = '', checkbox = '', width = '') { // generic one from chatgpt.alert()
            const alertID = chatgpt.alert(title, msg, btns, checkbox, width),
                  alert = document.getElementById(alertID).firstChild
            this.init(alert) // add classes + starry bg
            return alert
        },

        open(modalType, modalSubType) {
            const modal = modalSubType ? this[modalType][modalSubType]() : this[modalType]() // show modal
            this.stack.unshift(modalSubType ? `${modalType}_${modalSubType}` : modalType) // add to stack
            this.init(modal) // add classes + starry bg
            this.observeRemoval(modal, modalType, modalSubType) // to maintain stack for proper nav
        },

        init(modal) {
            if (!this.styles) this.stylize() // to init/append stylesheet
            modal.classList.add('no-user-select', this.class) ; modal.parentNode.classList.add(`${this.class}-bg`)
            fillStarryBG(modal) // add starry bg
        },

        stylize() {
            if (!this.styles) {
                this.styles = document.createElement('style') ; this.styles.id = `${this.class}-styles`
                document.head.append(this.styles)
            }
            this.styles.innerText = (
                `.no-user-select {
                    user-select: none ; -webkit-user-select: none ; -moz-user-select: none ; -ms-user-select: none }`
              + `.${this.class} {` // modals
                  + 'font-family: -apple-system, system-ui, BlinkMacSystemFont, Segoe UI, Roboto,'
                      + 'Oxygen-Sans, Ubuntu, Cantarell, Helvetica Neue, sans-serif ;'
                  + 'padding: 20px 25px 24px 25px !important ; font-size: 20px ;'
                  + `color: ${ env.ui.scheme == 'dark' ? 'white' : 'black' } !important ;`
                  + `background-image: linear-gradient(180deg, ${
                       env.ui.scheme == 'dark' ? '#99a8a6 -200px, black 200px' : '#b6ebff -296px, white 171px' }) }`
              + `.${this.class} [class*=modal-close-btn] {`
                  + 'position: absolute !important ; float: right ; top: 14px !important ; right: 16px !important ;'
                  + 'cursor: pointer ; width: 33px ; height: 33px ; border-radius: 20px }'
              + `.${this.class} [class*=modal-close-btn] svg { height: 10px }`
              + `.${this.class} [class*=modal-close-btn] path {`
                  + `${ env.ui.scheme == 'dark' ? 'stroke: white ; fill: white' : 'stroke: #9f9f9f ; fill: #9f9f9f' }}`
              + ( env.ui.scheme == 'dark' ?  // invert dark mode hover paths
                    `.${this.class} [class*=modal-close-btn]:hover path { stroke: black ; fill: black }` : '' )
              + `.${this.class} [class*=modal-close-btn]:hover { background-color: #f2f2f2 }` // hover underlay
              + `.${this.class} [class*=modal-close-btn] svg { margin: 11.5px }` // center SVG for hover underlay
              + `.${this.class} a { color: #${ env.ui.scheme == 'dark' ? '00cfff' : '1e9ebb' } !important }`
              + `.${this.class} h2 { font-weight: bold }`
              + `.${this.class} button {`
                  + '--btn-transition: transform 0.1s ease-in-out, box-shadow 0.1s ease-in-out ;'
                  + 'font-size: 14px ; text-transform: uppercase ;' // shrink/uppercase labels
                  + 'border-radius: 0 !important ;' // square borders
                  + 'transition: var(--btn-transition) ;' // smoothen hover fx
                      + '-webkit-transition: var(--btn-transition) ; -moz-transition: var(--btn-transition) ;'
                      + '-o-transition: var(--btn-transition) ; -ms-transition: var(--btn-transition) ;'
                  + 'cursor: pointer !important ;' // add finger cursor
                  + `border: 1px solid ${ env.ui.scheme == 'dark' ? 'white' : 'black' } !important ;`
                  + 'padding: 8px !important ; min-width: 102px }' // resize
              + `.${this.class} button:hover {` // add zoom, re-scheme
                  + 'transform: scale(1.055) ; color: black !important ;'
                  + `background-color: #${ env.ui.scheme == 'dark' ? '00cfff' : '9cdaff' } !important }`
              + ( !env.browser.isMobile ? `.${this.class} .modal-buttons { margin-left: -13px !important }` : '' )
              + `.about-em { color: ${ env.ui.scheme == 'dark' ? 'white' : 'green' } !important }`
            )
        },

        observeRemoval(modal, modalType, modalSubType) { // to maintain stack for proper nav
            const modalBG = modal.parentNode
            new MutationObserver(([mutation], obs) => {
                mutation.removedNodes.forEach(removedNode => { if (removedNode == modalBG) {
                    if (modals.stack[0].includes(modalSubType || modalType)) { // new modal not launched so nav back
                        modals.stack.shift() // remove this modal type from stack 1st
                        const prevModalType = modals.stack[0]
                        if (prevModalType) { // open it
                            modals.stack.shift() // remove type from stack since re-added on open
                            modals.open(prevModalType)
                        }
                    }
                    obs.disconnect()
                }})
            }).observe(modalBG.parentNode, { childList: true, subtree: true })
        },

        about() {

            // Show modal
            const aboutModal = modals.alert(
                `${app.symbol} ${app.msgs.appName}`, // title
                `🧠 ${app.msgs.about_author}: ` // msg
                    + `<a href="${app.author.url}">${app.msgs.appAuthor}</a> ${app.msgs.about_and}`
                        + ` <a href="${app.urls.contributors}">${app.msgs.about_contributors}</a>\n`
                + `🏷️ ${app.msgs.about_version}: <span class="about-em">${app.version}</span>\n`
                + `📜 ${app.msgs.about_openSourceCode}: `
                    + `<a href="${app.urls.gitHub}" target="_blank" rel="nopener">`
                        + app.urls.gitHub + '</a>\n'
                + `⚡ ${app.msgs.about_poweredBy}: `
                    + `<a href="${app.urls.chatgptJS}" target="_blank" rel="noopener">chatgpt.js</a>`
                        + ` v${app.chatgptJSver}`,
                [ // buttons
                    function checkForUpdates() { updateCheck() },
                    function getSupport(){},
                    function rateUs() {},
                    function moreAIextensions(){}
                ], '', 691 // set width
            )

            // Format text
            aboutModal.querySelector('h2').style.cssText = (
                'text-align: center ; font-size: 51px ; line-height: 46px ; padding: 15px 0' )
            aboutModal.querySelector('p').style.cssText = (
                'text-align: center ; overflow-wrap: anywhere ;'
              + `margin: ${ env.browser.isPortrait ? '6px 0 -16px' : '3px 0 29px' }` )

            // Hack buttons
            aboutModal.querySelectorAll('button').forEach(btn => {
                btn.style.cssText = 'height: 58px ; min-width: 136px ; text-align: center'

                // Replace link buttons w/ clones that don't dismiss modal
                if (/support|rate|extensions/i.test(btn.textContent)) {
                    const btnClone = btn.cloneNode(true)
                    btn.parentNode.replaceChild(btnClone, btn) ; btn = btnClone
                    btn.onclick = () => modals.safeWinOpen(
                        btn.textContent.includes(app.msgs.btnLabel_getSupport) ? app.urls.support
                      : btn.textContent.includes(app.msgs.btnLabel_rateUs) ? app.urls.review.greasyFork
                      : app.urls.relatedExtensions
                    )
                }

                // Prepend emoji + localize labels
                if (/updates/i.test(btn.textContent))
                    btn.textContent = `🚀 ${app.msgs.btnLabel_checkForUpdates}`
                else if (/support/i.test(btn.textContent))
                    btn.textContent = `🧠 ${app.msgs.btnLabel_getSupport}`
                else if (/rate/i.test(btn.textContent))
                    btn.textContent = `⭐ ${app.msgs.btnLabel_rateUs}`
                else if (/extensions/i.test(btn.textContent))
                    btn.textContent = `🤖 ${app.msgs.btnLabel_moreAIextensions}`

                // Hide Dismiss button
                else btn.style.display = 'none' // hide Dismiss button
            })

            return aboutModal
        },

        donate() {

            // Show modal
            const donateModal = modals.alert(
                `💖 ${app.msgs.alert_showYourSupport}`, // title
                    `<p>${app.msgs.appName} ${app.msgs.alert_isOSS}.</p>`
                    + `<p>${app.msgs.alert_despiteAffliction} `
                        + '<a target="_blank" rel="noopener" href="https://en.wikipedia.org/wiki/Long_COVID">'
                            + `${app.msgs.alert_longCOVID}</a> `
                        + `${app.msgs.alert_since2020}, ${app.msgs.alert_byDonatingResults}.</p>`
                    + `<p>${app.msgs.alert_yourContrib}, <b>${app.msgs.alert_noMatterSize}</b>, `
                        + `${app.msgs.alert_directlySupports}.</p>`
                    + `<p>${app.msgs.alert_tyForSupport}!</p>`
                    + '<img src="https://cdn.jsdelivr.net/gh/adamlui/adamlui/images/siggie/'
                        + `${ env.ui.scheme == 'dark' ? 'white' : 'black' }.png" `
                        + 'style="height: 54px ; margin: 5px 0 -2px 5px"></img>'
                    + `<p>—<b><a target="_blank" rel="noopener" href="${app.author.url}">`
                        + `${app.msgs.appAuthor}</a></b>, ${app.msgs.about_author.toLowerCase()}</p>`,
                [ // buttons
                    function paypal(){},
                    function githubSponsors(){},
                    function cashApp(){},
                    function rateUs() { modals.safeWinOpen(app.urls.review.greasyFork) }
                ], '', 478 // set width
            )

            // Format text
            donateModal.querySelectorAll('p').forEach(p => // v-pad text, shrink line height
                p.style.cssText = 'padding: 8px 0 ; line-height: 20px')

            // Hack buttons
            const btns = donateModal.querySelectorAll('button')
            btns.forEach((btn, idx) => {

                // Replace link buttons w/ clones that don't dismiss modal
                if (!/dismiss|rate/i.test(btn.textContent)) {
                    const btnClone = btn.cloneNode(true)
                    btn.parentNode.replaceChild(btnClone, btn) ; btn = btnClone
                    btn.onclick = () => modals.safeWinOpen(
                        btn.textContent == 'Cash App' ? app.urls.donate.cashApp
                      : btn.textContent == 'Github Sponsors' ? app.urls.donate.gitHub
                      : btn.textContent == 'Paypal' ? app.urls.donate.payPal
                      : app.urls.review.greasyFork
                    )
                }

                // Format buttons
                if (idx == 0) btn.style.display = 'none' // hide Dismiss button
                else {
                    btn.style.cssText = 'padding: 8px 6px !important ; margin-top: -14px ;'
                                      + ' width: 107px ; line-height: 14px'
                    if (idx == btns.length -1) // de-emphasize right-most button
                        btn.classList.remove('primary-modal-btn')
                    else if (/rate/i.test(btn.textContent)) // localize 'Rate Us' label
                        btn.textContent = app.msgs.btnLabel_rateUs
                }
            })

            return donateModal
        },

        update: {
            width: 377,

            available() {

                // Show modal
                const updateAvailModal = modals.alert(`🚀 ${app.msgs.alert_updateAvail}!`, // title
                    `${app.msgs.alert_newerVer} ${app.msgs.appName} ` // msg
                        + `(v${app.latestVer}) ${app.msgs.alert_isAvail}!  `
                        + '<a target="_blank" rel="noopener" style="font-size: 0.7rem" href="'
                            + app.urls.update.replace(/.+\/([^/]+)meta\.js/,
                                `${app.urls.gitHub}/commits/main/greasemonkey/$1user.js`)
                        + `">${app.msgs.link_viewChanges}</a>`,
                    function update() { // button
                        modals.safeWinOpen(app.urls.update.replace('meta.js', 'user.js') + '?t=' + Date.now())
                    }, '', modals.update.width
                )

                // Localize button labels if needed
                if (!env.browser.language.startsWith('en')) {
                    const updateBtns = updateAvailModal.querySelectorAll('button')
                    updateBtns[1].textContent = app.msgs.btnLabel_update
                    updateBtns[0].textContent = app.msgs.btnLabel_dismiss
                }

                return updateAvailModal
            },

            unavailable() {
                return modals.alert(`${app.msgs.alert_upToDate}!`, // title
                    `${app.msgs.appName} (v${app.version}) ${app.msgs.alert_isUpToDate}!`, // msg
                    '', '', modals.update.width
                )
            }
        },

        safeWinOpen(url) { open(url, '_blank', 'noopener') } // to prevent backdoor vulnerabilities
    }

    // Define UI functions

    function syncConfigToUI() {
        toggles.sidebar.updateState() // based on config.autoTalkDisabled + config.toggleHidden
        menu.refresh() // prefixes/suffixes
    }

    function getScheme() {
        return document.documentElement.className
            || (window.matchMedia?.('(prefers-color-scheme: dark)')?.matches ? 'dark' : 'light')
    }

    function createStyle(content) {
        const style = document.createElement('style')
        if (content) style.innerText = content
        return style
    }

    function fillStarryBG(targetNode) { // requires https://assets.aiwebextensions.com/styles/rising-stars/css/<black|white>.min.css
        if (targetNode.querySelector('[id*=stars]')) return
        const starsDivsContainer = document.createElement('div')
        starsDivsContainer.style.cssText = 'position: absolute ; top: 0 ; left: 0 ;' // hug targetNode's top-left corner
          + 'height: 100% ; width: 100% ; border-radius: 15px ; overflow: clip ;' // bound innards exactly by targetNode
          + 'z-index: -1'; // allow interactive elems to be clicked
        ['sm', 'med', 'lg'].forEach(starSize => {
            const starsDiv = document.createElement('div')
            starsDiv.id = `${ env.ui.scheme == 'dark' ? 'white' : 'black' }-stars-${starSize}`
            starsDivsContainer.append(starsDiv)
        })
        targetNode.prepend(starsDivsContainer)
    }

    const toggles = {

        sidebar: {
            class: `${app.cssPrefix}-sidebar-toggle`,

            create() {

                // Init toggle elems
                this.div = document.createElement('div') ; this.div.className = this.class
                this.navicon = document.createElement('img')
                this.toggleLabel = document.createElement('label')
                this.toggleInput = document.createElement('input')
                this.switchSpan = document.createElement('span')
                this.knobSpan = document.createElement('span')

                // Assemble elems into parent div
                this.switchSpan.append(this.knobSpan)
                this.div.append(this.navicon, this.toggleInput, this.switchSpan, this.toggleLabel)

                // Stylize elems
                this.stylize() // create/append stylesheet
                if (env.ui.firstLink) { // borrow/assign classes from sidebar elems
                    const firstIcon = env.ui.firstLink.querySelector('div:first-child'),
                          firstLabel = env.ui.firstLink.querySelector('div:nth-child(2)')
                    this.div.classList.add(
                        ...env.ui.firstLink.classList, ...(firstLabel?.classList || []))
                    this.div.querySelector('img')?.classList.add(...(firstIcon?.classList || []))
                }

                // Update color/state
                this.updateAesthetic() ; this.updateState() // to opposite init state for animation on 1st load

                // Add hover/click listeners
                this.div.onmouseover = this.div.onmouseout = event => // trigger OpenAI hover overlay
                    this.div.style.setProperty('--item-background-color',
                        `var(--sidebar-surface-${event.type == 'mouseover' ? 'secondary' : 'primary'})`)
                this.div.onclick = () => {
                    settings.save('autoTalkDisabled', this.toggleInput.checked)
                    syncConfigToUI({ updatedKey: 'autoTalkDisabled' })
                    notify(`${app.msgs.mode_autoTalk}: ${menu.state.words[+!config.autoTalkDisabled]}`)
                }
            },

            stylize() {
                this.styles = document.createElement('style') ; this.styles.id = `${this.class}-styles`
                this.styles.innerText = (
                    ':root {' // vars
                      + '--switch-enabled-bg-color: #ad68ff ; --switch-disabled-bg-color: #ccc ;'
                      + '--switch-enabled-box-shadow: 2px 1px 9px #d8a9ff ;'
                      + '--switch-enabled-hover-box-shadow: 0 1px 10px #9b5ad1 ;'
                      + '--knob-box-shadow: rgba(0,0,0,0.3) 0 1px 2px 0 ;'
                      + '--knob-box-shadow-dark: rgba(0,0,0,0.3) 0 1px 2px 0, rgba(0,0,0,0.15) 0 3px 6px 2px }'

                    // Element styles
                  + `.${this.class} {` // parent div
                      + 'max-height: 37px ; margin: 2px 0 ; user-select: none ; cursor: pointer ;'
                      + 'flex-grow: unset }' // overcome OpenAI .grow
                  + `.${this.class} > img {` // navicon
                      + 'width: 1.25rem ; height: 1.25rem ; margin-left: 2px ; margin-right: 4px }'
                  + `.${this.class} > input { display: none }` // hide checkbox
                  + `.${this.class} > span {` // switch span
                      + 'position: relative ; width: 30px ; height: 15px ; border-radius: 28px ;'
                      + `background-color: var(--switch-${ // init opposite final color
                            config.autoclear ? 'disabled' : 'enabled' }-bg-color) ;`
                      + `bottom: ${ env.ui.firstLink ? 0 : -0.15 }em ;`
                      + `left: ${ env.browser.isMobile ? 169 : env.ui.firstLink ? 154 : 160 }px ;`
                      + 'transition: 0.4s ; -webkit-transition: 0.4s ; -moz-transition: 0.4s ;'
                          + '-o-transition: 0.4s ; -ms-transition: 0.4s }'
                  + `.${this.class} > span.enabled {` // switch on
                      + 'background-color: var(--switch-enabled-bg-color) ;'
                      + 'box-shadow: var(--switch-enabled-box-shadow) }'
                  + `.${this.class}:hover > span.enabled {` // switch on when hover on parent div
                      + 'box-shadow: var(--switch-enabled-hover-box-shadow) ;'
                      + 'transition: none ; -webkit-transition: none ; -moz-transition: none ;'
                          + '-o-transition: none ; -ms-transition: none }'
                  + `.${this.class} > span.disabled {` // switch off
                      + 'background-color: var(--switch-disabled-bg-color) ; box-shadow: none }'
                  + `.${this.class} > span > span {` // knob span
                      + 'position: absolute ; width: 12px ; height: 12px ; content: "" ; border-radius: 28px ;'
                      + 'background-color: white ; left: 3px ; bottom: 1.25px ;'
                      + 'box-shadow: var(--knob-box-shadow) ;' // make 3D
                      + `transform: translateX(${ !config.autoTalkDisabled ? 0 : 13 }px) ;` // init opposite final pos
                      + 'transition: 0.4s ; -webkit-transition: 0.4s ; -moz-transition: 0.4s ;'
                          + '-o-transition: 0.4s ; -ms-transition: 0.4s }'
                  + `.${this.class} > label {` // toggle label
                      + 'cursor: pointer ; overflow: hidden ; text-overflow: ellipsis ;'
                      + `width: ${ env.browser.isMobile ? 201 : 148 }px ;`
                      + `margin-left: -${ env.ui.firstLink ? 41 : 23 }px ;` // left-shift to navicon
                      + `${ env.ui.firstLink ? '' : 'font-size: 0.875rem ; font-weight: 600' }}`

                    // Dark scheme mods
                  + `.${this.class}.dark > span.enabled {` // switch on
                      + 'background-color: var(--switch-enabled-bg-color) ;'
                      + 'box-shadow: var(--switch-enabled-hover-box-shadow) }' // use hover style instead
                  + `.${this.class}.dark:hover > span.enabled {` // switch on when hover on parent div
                      + 'box-shadow: var(--switch-enabled-box-shadow) }' // use regular style instead
                  + `.${this.class}.dark > span > span {` // knob span
                      + 'box-shadow: var(--knob-box-shadow-dark) }' // make 3D-er
                )
                document.head.append(this.styles)
            },

            insert() {
                if (this.status?.startsWith('insert') || document.querySelector(`.${this.class}`)) return
                const sidebar = document.querySelectorAll('nav')[env.browser.isMobile ? 1 : 0] ; if (!sidebar) return
                this.status = 'inserting' ; if (!this.div) this.create()
                sidebar.insertBefore(this.div, sidebar.children[1]) ; this.status = 'inserted'
            },

            updateAesthetic() { // to match UI scheme
                const isDarkScheme = env.ui.scheme == 'dark'
                this.div.classList.add(isDarkScheme ? 'dark' : 'light')
                this.div.classList.remove(isDarkScheme ? 'light' : 'dark')
                this.navicon.src = `${app.urls.assetHost }/assets/images/icons/speaker/${
                    env.ui.scheme == 'dark' ? 'white' : 'black' }-icon.svg`
            },

            updateState() {
                if (!this.div) return // since toggle never created = sidebar missing
                this.div.style.display = config.toggleHidden ? 'none' : 'flex'
                this.toggleInput.checked = !config.autoTalkDisabled
                this.toggleLabel.innerText = `${app.msgs.mode_autoTalk} `
                    + app.msgs[`state_${ this.toggleInput.checked ? 'enabled' : 'disabled' }`]
                setTimeout(() => {
                    this.switchSpan.className = this.toggleInput.checked ? 'enabled' : 'disabled'
                    this.knobSpan.style.transform = `translateX(${ this.toggleInput.checked ? 13 : 0 }px)`
                }, 1) // min delay to trigger 1st transition fx
            }
        }
    }

    // Run MAIN routine

    menu.register() // create browser toolbar menu

    // Init BROWSER/UI props
    await Promise.race([chatgpt.isLoaded(), new Promise(resolve => setTimeout(resolve, 5000))]) // initial UI loaded
    await chatgpt.sidebar.isLoaded()
    env.ui.firstLink = chatgpt.getNewChatLink();

    // Add STARS styles
    ['brs', 'wrs'].forEach(cssType => document.head.append(createStyle(GM_getResourceText(`${cssType}CSS`))))

    toggles.sidebar.insert()

    // Observe <main> for need to AUTO-PLAY response
    await Promise.race([chatgpt.isLoaded(), new Promise(resolve => setTimeout(resolve, 1000))])
    const autoPlayObserver = new MutationObserver(mutations => {
        if (config.autoTalkDisabled || document.querySelector('[data-testid*=login]')) return
        for (const mutation of mutations) { if (mutation.type == 'childList')
            mutation.addedNodes.forEach(node => { if (node?.tagName == 'DIV') {
                const playIcon = node.querySelector('path[d^="M11 4.9099C11"]')
                if (playIcon && !document.querySelector('div[class*=bg-black]:not([id$=-btn])')) // not in Temp Chat
                    setTimeout(() => { if (!chatgpt.getStopGeneratingButton()) playIcon.closest('button').click() }, 50)
    }})}})
    autoPlayObserver.observe(document.querySelector('main'), { childList: true, subtree: true })

    // Monitor NODE CHANGES to maintain sidebar toggle visibility
    new MutationObserver(() => {
        if (!config.toggleHidden && !document.querySelector(`.${toggles.sidebar.class}`)
            && toggles.sidebar.status != 'inserting') {
                toggles.sidebar.status = 'missing' ; toggles.sidebar.insert() }
    }).observe(document.body, { attributes: true, subtree: true })

    // Monitor SCHEME PREF changes to update sidebar toggle + modal colors
    new MutationObserver(handleSchemePrefChange).observe( // for site scheme pref changes
        document.documentElement, { attributes: true, attributeFilter: ['class'] })
    window.matchMedia('(prefers-color-scheme: dark)').addEventListener( // for browser/system scheme pref changes
        'change', () => requestAnimationFrame(handleSchemePrefChange))
    function handleSchemePrefChange() {
        const displayedScheme = getScheme()
        if (env.ui.scheme != displayedScheme) {
            env.ui.scheme = displayedScheme ; toggles.sidebar.updateAesthetic() ; modals.stylize() }
    }

    // Disable distracting SIDEBAR CLICK-ZOOM effect
    if (!document.documentElement.hasAttribute('sidebar-click-zoom-observed')) {
        new MutationObserver(mutations => mutations.forEach(({ target }) => {
            if (target.closest('[class*=sidebar]') // include sidebar elems
                && !target.closest('[class*=sidebar-toggle]') // exclude our toggles.sidebar's elems
                && target.style.transform != 'none' // click-zoom occurred
            ) target.style.transform = 'none'
        })).observe(document.body, { attributes: true, subtree: true, attributeFilter: ['style'] })
        document.documentElement.setAttribute('sidebar-click-zoom-observed', true)
    }

})()
