#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include <sys/socket.h>
#include <netinet/ip.h>
#include <arpa/inet.h>
#include "header.h"

unsigned short in_cksum(unsigned short *buf, int length)
{
    unsigned short *w = buf;
    int nleft = length;
    int sum = 0;
    unsigned short temp = 0;

    // The algorithm uses a 32 bit accumulator (sum), adds
    // sequential 16 bit words to it, and at the end, folds back all
    // the carry bits from the top 16 bits into the lower 16 bits.

    while (nleft > 1)
    {
        sum += *w++;
        nleft -= 2;
    }

    // treat the odd byte at the end, if any
    if (nleft == 1)
    {
        *(u_char *)(&temp) = *(u_char *)w;
        sum += temp;
    }

    // add back carry outs from top 16 bits to low 16 bits
    sum = (sum >> 16) + (sum & 0xffff); // add high 16 to low 16
    sum += (sum >> 16);					// add carry
    return (unsigned short)(~sum);
}

// TCP checksum is calculated on the pseudo header, which includes
// the TCP header and data, plus some part of the IP header.
// Therefore, we need to construct the pseudo header first.

unsigned short calculate_tcp_checksum(struct ipheader *ip)
{
    struct tcpheader *tcp = (struct tcpheader *)((u_char *)ip + sizeof(struct ipheader));

    int tcp_len = ntohs(ip->iph_len) - sizeof(struct ipheader);

    // pseudo tcp header for the checksum computation
    struct pseudo_tcp p_tcp;
    memset(&p_tcp, 0x0, sizeof(struct pseudo_tcp));

    p_tcp.saddr = ip->iph_sourceip.s_addr;
    p_tcp.daddr = ip->iph_destip.s_addr;
    p_tcp.mbz = 0;
    p_tcp.ptcl = IPPROTO_TCP;
    p_tcp.tcpl = htons(tcp_len);
    memcpy(&p_tcp.tcp, tcp, tcp_len);

    return (unsigned short)in_cksum((unsigned short *)&p_tcp, tcp_len + 12);
}
