# Generated by Django 2.2.6 on 2019-11-24 05:58

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Course',
            fields=[
                ('course_code', models.CharField(max_length=50, primary_key=True, serialize=False)),
                ('course_name', models.CharField(max_length=50)),
                ('faculty', models.CharField(max_length=50)),
            ],
        ),
        migrations.CreateModel(
            name='Hostel',
            fields=[
                ('hostel_name', models.CharField(max_length=5, primary_key=True, serialize=False)),
                ('warden', models.CharField(max_length=50)),
                ('gender', models.CharField(choices=[('M', 'Male'), ('F', 'Female')], default=None, max_length=1)),
            ],
        ),
        migrations.CreateModel(
            name='Mess',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('mess_type', models.CharField(max_length=50)),
                ('contractor', models.CharField(max_length=50)),
                ('daily_fees', models.IntegerField()),
            ],
        ),
        migrations.CreateModel(
            name='Room',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('room_num', models.IntegerField()),
                ('room_alloted', models.BooleanField(default=False)),
                ('hostel', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='hostel_app.Hostel')),
            ],
            options={
                'ordering': ['hostel', 'room_num'],
                'unique_together': {('hostel', 'room_num')},
            },
        ),
        migrations.CreateModel(
            name='Student',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('student_name', models.CharField(max_length=50)),
                ('gender', models.CharField(choices=[('M', 'Male'), ('F', 'Female')], default=None, max_length=1)),
                ('course', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='hostel_app.Course')),
                ('room', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='hostel_app.Room')),
                ('user', models.OneToOneField(max_length=9, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.AddField(
            model_name='hostel',
            name='mess',
            field=models.OneToOneField(null=True, on_delete=django.db.models.deletion.SET_NULL, to='hostel_app.Mess'),
        ),
    ]
