const Glyph = ({ icon }) => {
  switch (icon) {
    case 'chevron-down':
      return (
        <g>
          <path d="M16.293 9.293L12 13.586 7.707 9.293 6.293 10.707 12 16.414 17.707 10.707z" />
        </g>
      );
    case 'code':
      return (
        <g>
          <path d="M7.375 16.781l1.25-1.562L4.601 12l4.024-3.219-1.25-1.562-5 4C2.138 11.409 2 11.696 2 12s.138.591.375.781L7.375 16.781zM16.625 7.219l-1.25 1.562L19.399 12l-4.024 3.219 1.25 1.562 5-4C21.862 12.591 22 12.304 22 12s-.138-.591-.375-.781L16.625 7.219z" />
          <path
            transform="rotate(102.527 12 12)"
            d="M2.78 11H21.219V13.001H2.78z"
          />
        </g>
      );
    case 'cog':
      return (
        <g>
          <path d="M12,16c2.206,0,4-1.794,4-4s-1.794-4-4-4s-4,1.794-4,4S9.794,16,12,16z M12,10c1.084,0,2,0.916,2,2s-0.916,2-2,2 s-2-0.916-2-2S10.916,10,12,10z" />
          <path d="M2.845,16.136l1,1.73c0.531,0.917,1.809,1.261,2.73,0.73l0.529-0.306C7.686,18.747,8.325,19.122,9,19.402V20 c0,1.103,0.897,2,2,2h2c1.103,0,2-0.897,2-2v-0.598c0.675-0.28,1.314-0.655,1.896-1.111l0.529,0.306 c0.923,0.53,2.198,0.188,2.731-0.731l0.999-1.729c0.552-0.955,0.224-2.181-0.731-2.732l-0.505-0.292C19.973,12.742,20,12.371,20,12 s-0.027-0.743-0.081-1.111l0.505-0.292c0.955-0.552,1.283-1.777,0.731-2.732l-0.999-1.729c-0.531-0.92-1.808-1.265-2.731-0.732 l-0.529,0.306C16.314,5.253,15.675,4.878,15,4.598V4c0-1.103-0.897-2-2-2h-2C9.897,2,9,2.897,9,4v0.598 c-0.675,0.28-1.314,0.655-1.896,1.111L6.575,5.403c-0.924-0.531-2.2-0.187-2.731,0.732L2.845,7.864 c-0.552,0.955-0.224,2.181,0.731,2.732l0.505,0.292C4.027,11.257,4,11.629,4,12s0.027,0.742,0.081,1.111l-0.505,0.292 C2.621,13.955,2.293,15.181,2.845,16.136z M6.171,13.378C6.058,12.925,6,12.461,6,12c0-0.462,0.058-0.926,0.17-1.378 c0.108-0.433-0.083-0.885-0.47-1.108L4.577,8.864l0.998-1.729L6.72,7.797c0.384,0.221,0.867,0.165,1.188-0.142 c0.683-0.647,1.507-1.131,2.384-1.399C10.713,6.128,11,5.739,11,5.3V4h2v1.3c0,0.439,0.287,0.828,0.708,0.956 c0.877,0.269,1.701,0.752,2.384,1.399c0.321,0.307,0.806,0.362,1.188,0.142l1.144-0.661l1,1.729L18.3,9.514 c-0.387,0.224-0.578,0.676-0.47,1.108C17.942,11.074,18,11.538,18,12c0,0.461-0.058,0.925-0.171,1.378 c-0.107,0.433,0.084,0.885,0.471,1.108l1.123,0.649l-0.998,1.729l-1.145-0.661c-0.383-0.221-0.867-0.166-1.188,0.142 c-0.683,0.647-1.507,1.131-2.384,1.399C13.287,17.872,13,18.261,13,18.7l0.002,1.3H11v-1.3c0-0.439-0.287-0.828-0.708-0.956 c-0.877-0.269-1.701-0.752-2.384-1.399c-0.19-0.182-0.438-0.275-0.688-0.275c-0.172,0-0.344,0.044-0.5,0.134l-1.144,0.662l-1-1.729 L5.7,14.486C6.087,14.263,6.278,13.811,6.171,13.378z" />
        </g>
      );
    case 'font':
      return (
        <g>
          <path d="M11.307,4l-6,16h2.137l1.875-5h6.363l1.875,5h2.137l-6-16H11.307z M10.068,13L12.5,6.515L14.932,13H10.068z" />
        </g>
      );
    case 'github':
      return (
        <g>
          <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M12.026,2c-5.509,0-9.974,4.465-9.974,9.974c0,4.406,2.857,8.145,6.821,9.465	c0.499,0.09,0.679-0.217,0.679-0.481c0-0.237-0.008-0.865-0.011-1.696c-2.775,0.602-3.361-1.338-3.361-1.338	c-0.452-1.152-1.107-1.459-1.107-1.459c-0.905-0.619,0.069-0.605,0.069-0.605c1.002,0.07,1.527,1.028,1.527,1.028	c0.89,1.524,2.336,1.084,2.902,0.829c0.091-0.645,0.351-1.085,0.635-1.334c-2.214-0.251-4.542-1.107-4.542-4.93	c0-1.087,0.389-1.979,1.024-2.675c-0.101-0.253-0.446-1.268,0.099-2.64c0,0,0.837-0.269,2.742,1.021	c0.798-0.221,1.649-0.332,2.496-0.336c0.849,0.004,1.701,0.115,2.496,0.336c1.906-1.291,2.742-1.021,2.742-1.021	c0.545,1.372,0.203,2.387,0.099,2.64c0.64,0.696,1.024,1.587,1.024,2.675c0,3.833-2.33,4.675-4.552,4.922	c0.355,0.308,0.675,0.916,0.675,1.846c0,1.334-0.012,2.41-0.012,2.737c0,0.267,0.178,0.577,0.687,0.479	C19.146,20.115,22,16.379,22,11.974C22,6.465,17.535,2,12.026,2z"
          />
        </g>
      );
    case 'globe':
      return (
        <g>
          <path d="M12,2C6.486,2,2,6.486,2,12s4.486,10,10,10s10-4.486,10-10S17.514,2,12,2z M19.931,11h-2.764 c-0.116-2.165-0.73-4.3-1.792-6.243C17.813,5.898,19.582,8.228,19.931,11z M12.53,4.027c1.035,1.364,2.427,3.78,2.627,6.973H9.03 c0.139-2.596,0.994-5.028,2.451-6.974C11.653,4.016,11.825,4,12,4C12.179,4,12.354,4.016,12.53,4.027z M8.688,4.727 C7.704,6.618,7.136,8.762,7.03,11H4.069C4.421,8.204,6.217,5.857,8.688,4.727z M4.069,13h2.974c0.136,2.379,0.665,4.478,1.556,6.23 C6.174,18.084,4.416,15.762,4.069,13z M11.45,19.973C10.049,18.275,9.222,15.896,9.041,13h6.113 c-0.208,2.773-1.117,5.196-2.603,6.972C12.369,19.984,12.187,20,12,20C11.814,20,11.633,19.984,11.45,19.973z M15.461,19.201 c0.955-1.794,1.538-3.901,1.691-6.201h2.778C19.587,15.739,17.854,18.047,15.461,19.201z" />
        </g>
      );
    case 'palette':
      return (
        <g>
          <path d="M13.4,2.096c-3.358-0.458-6.729,0.804-8.937,3.331C2.565,7.603,1.702,10.509,2.096,13.4 c0.53,3.894,3.458,7.207,7.285,8.246C10.245,21.881,11.126,22,11.999,22l0.142-0.001c1.032-0.016,1.973-0.549,2.516-1.426 c0.541-0.876,0.599-1.953,0.153-2.879l-0.199-0.416c-0.418-0.868-0.121-1.57,0.094-1.912c0.539-0.858,1.627-1.21,2.576-0.755 l0.412,0.197c0.412,0.198,0.85,0.299,1.301,0.299c1.633,0,2.981-1.331,3.006-2.967c0.014-0.92-0.105-1.849-0.353-2.76 C20.607,5.554,17.294,2.626,13.4,2.096z M18.558,13.005l-0.412-0.197c-1.828-0.878-4.07-0.198-5.135,1.494 c-0.738,1.176-0.813,2.576-0.204,3.842l0.199,0.416c0.151,0.314,0.133,0.664-0.051,0.961c-0.185,0.299-0.492,0.474-0.844,0.479 L11.999,20c-0.696,0-1.401-0.096-2.095-0.283c-3.063-0.831-5.403-3.479-5.826-6.586C3.757,10.776,4.43,8.508,5.971,6.742 C7.491,5,9.689,4,12,4c0.374,0,0.754,0.026,1.131,0.078c3.107,0.423,5.755,2.764,6.586,5.826c0.198,0.73,0.293,1.474,0.282,2.207 C19.987,12.918,19.154,13.294,18.558,13.005z" />
          <circle cx="7.5" cy="14.5" r="1.5" />
          <circle cx="7.5" cy="10.5" r="1.5" />
          <circle cx="10.5" cy="7.5" r="1.5" />
          <circle cx="14.5" cy="7.5" r="1.5" />
        </g>
      );
    case 'sad':
      return (
        <g>
          <path d="M12,2C6.486,2,2,6.486,2,12s4.486,10,10,10s10-4.486,10-10S17.514,2,12,2z M12,20c-4.411,0-8-3.589-8-8s3.589-8,8-8 s8,3.589,8,8S16.411,20,12,20z" />
          <circle cx="8.5" cy="10.5" r="1.5" />
          <circle cx="15.493" cy="10.493" r="1.493" />
          <path d="M12,14c-3,0-4,3-4,3h8C16,17,15,14,12,14z" />
        </g>
      );
    case 'twitter':
      return (
        <g>
          <path d="M19.633 7.99701C19.646 8.17201 19.646 8.34601 19.646 8.52001C19.646 13.845 15.593 19.981 8.186 19.981C5.904 19.981 3.784 19.32 2 18.172C2.324 18.209 2.636 18.222 2.973 18.222C4.856 18.222 6.589 17.586 7.974 16.501C6.203 16.464 4.719 15.304 4.207 13.708C4.456 13.745 4.706 13.77 4.968 13.77C5.329 13.77 5.692 13.72 6.029 13.633C4.182 13.259 2.799 11.638 2.799 9.68001V9.63001C3.336 9.92901 3.959 10.116 4.619 10.141C3.534 9.41901 2.823 8.18401 2.823 6.78701C2.823 6.03901 3.022 5.35301 3.371 4.75501C5.354 7.19801 8.335 8.79501 11.677 8.97001C11.615 8.67001 11.577 8.35901 11.577 8.04701C11.577 5.82701 13.373 4.01901 15.605 4.01901C16.765 4.01901 17.812 4.50501 18.548 5.29101C19.458 5.11601 20.33 4.77901 21.104 4.31801C20.805 5.25301 20.168 6.03901 19.333 6.53801C20.144 6.45001 20.93 6.22601 21.652 5.91401C21.104 6.71201 20.419 7.42301 19.633 7.99701Z" />
        </g>
      );
    default:
      return null;
  }
};

export function Icon({ icon, ...props }) {
  return (
    <svg fill="currentColor" viewBox="0 0 24 24" {...props}>
      <Glyph icon={icon} />
    </svg>
  );
}
