<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;

class Category extends Model
{
    use HasFactory;

    protected $fillable = [
        "title",
        "slug",
        "content"
    ];

    public function posts(): BelongsToMany
    {
        return $this->belongsToMany(Post::class, PostCategory::class);
    }
}
