const char *header_vert_src =

"//#define DIRECTIONALS\n"
"//#define POINTLIGHTS\n"
"//#define SPOTLIGHTS\n"

"#define ATTRIB_POS	0\n"
"#define ATTRIB_NORMAL	1\n"
"#define ATTRIB_COLOR	2\n"
"#define ATTRIB_WEIGHTS	3\n"
"#define ATTRIB_INDICES	4\n"
"#define ATTRIB_TEXCOORDS0	5\n"
"#define ATTRIB_TEXCOORDS1	6\n"


"VSIN(ATTRIB_NORMAL)	vec3 in_normal;\n"
"VSIN(ATTRIB_COLOR)	vec4 in_color;\n"
"VSIN(ATTRIB_WEIGHTS)	vec4 in_weights;\n"
"VSIN(ATTRIB_INDICES)	vec4 in_indices;\n"
"VSIN(ATTRIB_TEXCOORDS0)	vec2 in_tex0;\n"
"VSIN(ATTRIB_TEXCOORDS1)	vec2 in_tex1;\n"


"#ifdef USE_UBOS\n"
"layout(std140) uniform State\n"
"{\n"
"	vec2 u_alphaRef;\n"
"	vec4  u_fogData;\n"
"	vec4  u_fogColor;\n"
"};\n"
"#else\n"
"uniform vec4 u_alphaRef;\n"
"uniform vec4  u_fogData;\n"
"uniform vec4  u_fogColor;\n"
"#endif\n"

"#define u_fogStart (u_fogData.x)\n"
"#define u_fogEnd (u_fogData.y)\n"
"#define u_fogRange (u_fogData.z)\n"
"#define u_fogDisable (u_fogData.w)\n"

"#ifdef USE_UBOS\n"
"layout(std140) uniform Scene\n"
"{\n"
"	mat4 u_proj;\n"
"	mat4 u_view;\n"
"};\n"
"#else\n"
"uniform mat4 u_proj;\n"
"uniform mat4 u_view;\n"
"#endif\n"

"#define MAX_LIGHTS 8\n"

"#ifdef USE_UBOS\n"
"layout(std140) uniform Object\n"
"{\n"
"	mat4  u_world;\n"
"	vec4  u_ambLight;\n"
"	vec4 u_lightParams[MAX_LIGHTS];	// type, radius, minusCosAngle, hardSpot\n"
"	vec4 u_lightPosition[MAX_LIGHTS];\n"
"	vec4 u_lightDirection[MAX_LIGHTS];\n"
"	vec4 u_lightColor[MAX_LIGHTS];\n"
"};\n"
"#else\n"
"uniform mat4 u_world;\n"
"uniform vec4 u_ambLight;\n"
"uniform vec4 u_lightParams[MAX_LIGHTS];	// type, radius, minusCosAngle, hardSpot\n"
"uniform vec4 u_lightPosition[MAX_LIGHTS];\n"
"uniform vec4 u_lightDirection[MAX_LIGHTS];\n"
"uniform vec4 u_lightColor[MAX_LIGHTS];\n"
"#endif\n"

"uniform vec4 u_matColor;\n"
"uniform vec4 u_surfProps;	// amb, spec, diff, extra\n"

"#define surfAmbient (u_surfProps.x)\n"
"#define surfSpecular (u_surfProps.y)\n"
"#define surfDiffuse (u_surfProps.z)\n"

"vec3 DoDynamicLight(vec3 V, vec3 N)\n"
"{\n"
"	vec3 color = vec3(0.0, 0.0, 0.0);\n"
"	for(int i = 0; i < MAX_LIGHTS; i++){\n"
"		if(u_lightParams[i].x == 0.0)\n"
"			break;\n"
"#ifdef DIRECTIONALS\n"
"		if(u_lightParams[i].x == 1.0){\n"
"			// direct\n"
"			float l = max(0.0, dot(N, -u_lightDirection[i].xyz));\n"
"			color += l*u_lightColor[i].rgb;\n"
"		}else\n"
"#endif\n"
"#ifdef POINTLIGHTS\n"
"		if(u_lightParams[i].x == 2.0){\n"
"			// point\n"
"			vec3 dir = V - u_lightPosition[i].xyz;\n"
"			float dist = length(dir);\n"
"			float atten = max(0.0, (1.0 - dist/u_lightParams[i].y));\n"
"			float l = max(0.0, dot(N, -normalize(dir)));\n"
"			color += l*u_lightColor[i].rgb*atten;\n"
"		}else\n"
"#endif\n"
"#ifdef SPOTLIGHTS\n"
"		if(u_lightParams[i].x == 3.0){\n"
"			// spot\n"
"			vec3 dir = V - u_lightPosition[i].xyz;\n"
"			float dist = length(dir);\n"
"			float atten = max(0.0, (1.0 - dist/u_lightParams[i].y));\n"
"			dir /= dist;\n"
"			float l = max(0.0, dot(N, -dir));\n"
"			float pcos = dot(dir, u_lightDirection[i].xyz);	// cos to point\n"
"			float ccos = -u_lightParams[i].z;\n"
"			float falloff = (pcos-ccos)/(1.0-ccos);\n"
"			if(falloff < 0.0)	// outside of cone\n"
"				l = 0.0;\n"
"			l *= max(falloff, u_lightParams[i].w);\n"
"			return l*u_lightColor[i].rgb*atten;\n"
"		}else\n"
"#endif\n"
"			;\n"
"	}\n"
"	return color;\n"
"}\n"

"float DoFog(float w)\n"
"{\n"
"	return clamp((w - u_fogEnd)*u_fogRange, u_fogDisable, 1.0);\n"
"}\n"
;
