/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.stress;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.poi.extractor.ExtractorFactory;
import org.apache.poi.ooxml.POIXMLDocument;
import org.apache.poi.sl.extractor.SlideShowExtractor;
import org.apache.poi.sl.usermodel.SlideShow;
import org.apache.poi.stress.POIXMLDocumentHandler;
import org.apache.poi.stress.SlideShowHandler;
import org.apache.poi.xslf.usermodel.XMLSlideShow;
import org.apache.poi.xslf.usermodel.XSLFSlideShow;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class XSLFFileHandler
extends SlideShowHandler {
    XSLFFileHandler() {
    }

    @Override
    public void handleFile(InputStream stream, String path) throws Exception {
        XMLSlideShow slide = new XMLSlideShow(stream);
        XSLFSlideShow slideInner = new XSLFSlideShow(slide.getPackage());
        Assertions.assertNotNull((Object)slideInner.getPresentation());
        Assertions.assertNotNull((Object)slideInner.getSlideMasterReferences());
        Assertions.assertNotNull((Object)slideInner.getSlideReferences());
        new POIXMLDocumentHandler().handlePOIXMLDocument((POIXMLDocument)slide);
        this.handleSlideShow((SlideShow<?, ?>)slide);
        slideInner.close();
        slide.close();
    }

    @Override
    public void handleExtracting(File file) throws Exception {
        super.handleExtracting(file);
        try (SlideShowExtractor extractor = (SlideShowExtractor)ExtractorFactory.createExtractor((File)file);){
            Assertions.assertNotNull((Object)extractor);
            extractor.setSlidesByDefault(true);
            extractor.setNotesByDefault(true);
            extractor.setMasterByDefault(true);
            Assertions.assertNotNull((Object)extractor.getText());
            extractor.setSlidesByDefault(false);
            extractor.setNotesByDefault(false);
            extractor.setMasterByDefault(false);
            Assertions.assertEquals((Object)"", (Object)extractor.getText(), (String)"With all options disabled we should not get text");
        }
    }

    @Override
    @Test
    void test() throws Exception {
        File file = new File("test-data/slideshow/ca.ubc.cs.people_~emhill_presentations_HowWeRefactor.pptx");
        try (FileInputStream stream = new FileInputStream(file);){
            this.handleFile(stream, file.getPath());
        }
        this.handleExtracting(file);
    }
}

