/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.stress;

import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.ooxml.POIXMLDocument;
import org.apache.poi.poifs.filesystem.FileMagic;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.junit.jupiter.api.Assertions;

public final class POIXMLDocumentHandler {
    protected void handlePOIXMLDocument(POIXMLDocument doc) throws Exception {
        Assertions.assertNotNull((Object)doc.getAllEmbeddedParts());
        Assertions.assertNotNull((Object)doc.getPackage());
        Assertions.assertNotNull((Object)doc.getPackagePart());
        Assertions.assertNotNull((Object)doc.getProperties());
        Assertions.assertNotNull((Object)doc.getRelations());
    }

    protected static boolean isEncrypted(InputStream stream) throws IOException {
        if (FileMagic.valueOf((InputStream)stream) == FileMagic.OLE2) {
            try (POIFSFileSystem poifs = new POIFSFileSystem(stream);){
                if (poifs.getRoot().hasEntry("EncryptedPackage")) {
                    boolean bl = true;
                    return bl;
                }
            }
            throw new IOException("Wrong file format or file extension for OO XML file");
        }
        return false;
    }
}

