/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.stress;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.poi.POIDocument;
import org.apache.poi.hpsf.extractor.HPSFPropertiesExtractor;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.stress.AbstractFileHandler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class POIFSFileHandler
extends AbstractFileHandler {
    POIFSFileHandler() {
    }

    @Override
    public void handleFile(InputStream stream, String path) throws Exception {
        try (POIFSFileSystem fs = new POIFSFileSystem(stream);){
            this.handlePOIFSFileSystem(fs);
            this.handleHPSFProperties(fs);
        }
    }

    private void handleHPSFProperties(POIFSFileSystem fs) throws IOException {
        try (HPSFPropertiesExtractor ext = new HPSFPropertiesExtractor(fs);){
            ext.getDocSummaryInformation();
            ext.getSummaryInformation();
            Assertions.assertNotNull((Object)ext.getDocumentSummaryInformationText());
            Assertions.assertNotNull((Object)ext.getSummaryInformationText());
            Assertions.assertNotNull((Object)ext.getText());
        }
    }

    private void handlePOIFSFileSystem(POIFSFileSystem fs) {
        Assertions.assertNotNull((Object)fs);
        Assertions.assertNotNull((Object)fs.getRoot());
    }

    protected void handlePOIDocument(POIDocument doc) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        doc.write((OutputStream)out);
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        POIFSFileSystem fs = new POIFSFileSystem((InputStream)in);
        this.handlePOIFSFileSystem(fs);
        fs.close();
    }

    @Test
    void test() throws Exception {
        File file = new File("test-data/poifs/Notes.ole2");
        try (FileInputStream stream = new FileInputStream(file);){
            this.handleFile(stream, file.getPath());
        }
    }
}

