/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.stress;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.PushbackInputStream;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.stress.AbstractFileHandler;
import org.apache.poi.stress.POIXMLDocumentHandler;
import org.apache.poi.xwpf.usermodel.XWPFRelation;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class OPCFileHandler
extends AbstractFileHandler {
    OPCFileHandler() {
    }

    @Override
    public void handleFile(InputStream stream, String path) throws Exception {
        if (POIXMLDocumentHandler.isEncrypted(stream)) {
            return;
        }
        OPCPackage p = OPCPackage.open((InputStream)stream);
        for (PackagePart part : p.getParts()) {
            if (part.getPartName().toString().equals("/docProps/core.xml")) {
                Assertions.assertEquals((Object)"application/vnd.openxmlformats-package.core-properties+xml", (Object)part.getContentType());
            }
            if (part.getPartName().toString().equals("/word/document.xml")) {
                Assertions.assertTrue((XWPFRelation.DOCUMENT.getContentType().equals(part.getContentType()) || XWPFRelation.MACRO_DOCUMENT.getContentType().equals(part.getContentType()) || XWPFRelation.TEMPLATE.getContentType().equals(part.getContentType()) ? 1 : 0) != 0, (String)("Expected one of " + XWPFRelation.MACRO_DOCUMENT + ", " + XWPFRelation.DOCUMENT + ", " + XWPFRelation.TEMPLATE + ", but had " + part.getContentType()));
            }
            if (!part.getPartName().toString().equals("/word/theme/theme1.xml")) continue;
            Assertions.assertEquals((Object)XWPFRelation.THEME.getContentType(), (Object)part.getContentType());
        }
    }

    @Override
    public void handleExtracting(File file) {
    }

    @Test
    void test() throws Exception {
        File file = new File("test-data/diagram/test.vsdx");
        try (PushbackInputStream stream = new PushbackInputStream(new FileInputStream(file), 100000);){
            this.handleFile(stream, file.getPath());
        }
        this.handleExtracting(file);
    }
}

