/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.stress;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import org.apache.poi.hssf.HSSFTestDataSamples;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class HSSFRecordsStresser {
    HSSFRecordsStresser() {
    }

    public static void handleWorkbook(HSSFWorkbook wb) {
        List records = wb.getWorkbook().getRecords();
        for (Record record : records) {
            try {
                Record newRecord = record.copy();
                Assertions.assertEquals(record.getClass(), newRecord.getClass(), (String)("Expecting the same class back from clone(), but had Record of type " + record.getClass() + " and got back a " + newRecord.getClass() + " from clone()"));
                byte[] origBytes = record.serialize();
                byte[] newBytes = newRecord.serialize();
                Assertions.assertArrayEquals((byte[])origBytes, (byte[])newBytes, (String)("Record of type " + record.getClass() + " should return the same byte array via the clone() method, but did return a different array"));
            }
            catch (RuntimeException e) {
                Assertions.assertTrue((boolean)e.getMessage().contains("needs to define a clone method"));
            }
        }
    }

    @Test
    void test() throws Exception {
        try (FileInputStream stream = new FileInputStream(HSSFTestDataSamples.getSampleFile((String)"15556.xls"));){
            HSSFWorkbook wb = new HSSFWorkbook((InputStream)stream);
            HSSFRecordsStresser.handleWorkbook(wb);
            wb.close();
        }
    }
}

