/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.stress;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.poi.POIDocument;
import org.apache.poi.hslf.record.Record;
import org.apache.poi.hslf.usermodel.HSLFSlideShow;
import org.apache.poi.hslf.usermodel.HSLFSlideShowImpl;
import org.apache.poi.sl.usermodel.SlideShow;
import org.apache.poi.stress.SlideShowHandler;
import org.apache.poi.util.SystemOutLogger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class HSLFFileHandler
extends SlideShowHandler {
    HSLFFileHandler() {
    }

    @Override
    public void handleFile(InputStream stream, String path) throws Exception {
        HSLFSlideShowImpl slide = new HSLFSlideShowImpl(stream);
        Assertions.assertNotNull((Object)slide.getCurrentUserAtom());
        Assertions.assertNotNull((Object)slide.getEmbeddedObjects());
        Assertions.assertNotNull((Object)slide.getUnderlyingBytes());
        Assertions.assertNotNull((Object)slide.getPictureData());
        Record[] records = slide.getRecords();
        Assertions.assertNotNull((Object)records);
        for (Record record : records) {
            Assertions.assertNotNull((Object)record, (String)"Found a record which was null");
            Assertions.assertTrue((record.getRecordType() >= 0L ? 1 : 0) != 0);
        }
        this.handlePOIDocument((POIDocument)slide);
        HSLFSlideShow ss = new HSLFSlideShow(slide);
        this.handleSlideShow((SlideShow<?, ?>)ss);
    }

    @Test
    void testOne() throws Exception {
        this.testOneFile(new File("test-data/slideshow/54880_chinese.ppt"));
    }

    @Override
    @Test
    void test() throws Exception {
        File[] files = new File("test-data/slideshow/").listFiles((dir, name) -> name.endsWith(".ppt"));
        Assertions.assertNotNull((Object)files);
        System.out.println("Testing " + files.length + " files");
        SystemOutLogger logger = new SystemOutLogger();
        for (File file : files) {
            try {
                this.testOneFile(file);
            }
            catch (Throwable e) {
                logger.log(5, new Object[]{"Failed to handle file ", file, e});
            }
        }
    }

    private void testOneFile(File file) throws Exception {
        System.out.println(file);
        try (FileInputStream stream = new FileInputStream(file);){
            this.handleFile(stream, file.getPath());
        }
        this.handleExtracting(file);
    }

    public static void main(String[] args) throws Exception {
        System.setProperty("org.apache.poi.util.POILogger", "org.apache.poi.util.SystemOutLogger");
        try (FileInputStream stream = new FileInputStream(args[0]);){
            new HSLFFileHandler().handleFile(stream, args[0]);
        }
    }
}

