/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.stress;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.hdgf.HDGFDiagram;
import org.apache.poi.hdgf.extractor.VisioTextExtractor;
import org.apache.poi.hdgf.streams.Stream;
import org.apache.poi.hdgf.streams.TrailerStream;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.stress.POIFSFileHandler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class HDGFFileHandler
extends POIFSFileHandler {
    HDGFFileHandler() {
    }

    @Override
    public void handleFile(InputStream stream, String path) throws IOException {
        POIFSFileSystem poifs = new POIFSFileSystem(stream);
        HDGFDiagram diagram = new HDGFDiagram(poifs);
        Stream[] topLevelStreams = diagram.getTopLevelStreams();
        Assertions.assertNotNull((Object)topLevelStreams);
        for (Stream str : topLevelStreams) {
            Assertions.assertTrue((str.getPointer().getLength() >= 0 ? 1 : 0) != 0);
        }
        TrailerStream trailerStream = diagram.getTrailerStream();
        Assertions.assertNotNull((Object)trailerStream);
        Assertions.assertTrue((trailerStream.getPointer().getLength() >= 0 ? 1 : 0) != 0);
        diagram.close();
        poifs.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Test
    void test() throws Exception {
        File file = new File("test-data/diagram/44501.vsd");
        try (FileInputStream stream = new FileInputStream(file);){
            this.handleFile(stream, file.getPath());
        }
        this.handleExtracting(file);
        stream = new FileInputStream(file);
        try (VisioTextExtractor extractor = new VisioTextExtractor((InputStream)stream);){
            Assertions.assertNotNull((Object)extractor.getText());
        }
        finally {
            ((InputStream)stream).close();
        }
    }
}

