/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.stress;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.zip.ZipException;
import org.apache.poi.EncryptedDocumentException;
import org.apache.poi.OldFileFormatException;
import org.apache.poi.poifs.filesystem.OfficeXmlFileException;
import org.apache.poi.stress.FileHandler;
import org.apache.poi.stress.HSLFFileHandler;
import org.apache.poi.stress.HSSFFileHandler;
import org.apache.poi.stress.HWPFFileHandler;
import org.apache.poi.stress.TestAllFiles;
import org.apache.poi.stress.XSLFFileHandler;
import org.apache.poi.stress.XSSFFileHandler;
import org.apache.poi.stress.XWPFFileHandler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;

public class BaseIntegrationTest {
    private final File rootDir;
    private final String file;
    private FileHandler handler;

    public BaseIntegrationTest(File rootDir, String file, FileHandler handler) {
        this.rootDir = rootDir;
        this.file = file;
        this.handler = handler;
    }

    void test() throws Exception {
        Assertions.assertNotNull((Object)this.handler, (String)("Unknown file extension for file: " + this.file + ": " + TestAllFiles.getExtension(this.file)));
        this.testOneFile(new File(this.rootDir, this.file));
    }

    protected void testOneFile(File inputFile) throws Exception {
        try {
            this.handleFile(inputFile);
        }
        catch (OfficeXmlFileException e) {
            this.handleWrongOLE2XMLExtension(inputFile, (Exception)((Object)e));
        }
        catch (OldFileFormatException e) {
            Assumptions.assumeFalse((boolean)true, (String)("File " + this.file + " excluded because it is an unsupported old format"));
        }
        catch (EncryptedDocumentException e) {
            Assumptions.assumeFalse((boolean)true, (String)("File " + this.file + " excluded because it is password-encrypted"));
        }
        catch (ZipException e) {
            if (e.getMessage().equals("unexpected EOF") || e.getMessage().equals("Truncated ZIP file")) {
                Assumptions.assumeFalse((boolean)true, (String)("File " + this.file + " excluded because the Zip file is incomplete"));
            }
            throw e;
        }
        catch (IOException e) {
            String message = e.getMessage();
            if (message != null && message.contains("Truncated ZIP file")) {
                Assumptions.assumeFalse((boolean)true, (String)("File " + this.file + " excluded because the Zip file is incomplete"));
            }
            if (message != null && message.contains("rong file format or file extension for OO XML file")) {
                this.handleWrongOLE2XMLExtension(inputFile, e);
                return;
            }
            throw e;
        }
        catch (IllegalArgumentException e) {
            String message = e.getMessage();
            if (message != null && (message.equals("The document is really a RTF file") || message.equals("The document is really a PDF file") || message.equals("The document is really a HTML file"))) {
                Assumptions.assumeFalse((boolean)true, (String)("File " + this.file + " excluded because it is actually a PDF/RTF/HTML file"));
            }
            if (message != null && message.equals("The document is really a OOXML file")) {
                this.handleWrongOLE2XMLExtension(inputFile, e);
                return;
            }
            throw e;
        }
        try {
            this.handler.handleExtracting(inputFile);
        }
        catch (EncryptedDocumentException e) {
            Assumptions.assumeFalse((boolean)true, (String)("File " + this.file + " excluded because it is password-encrypted"));
        }
    }

    void handleWrongOLE2XMLExtension(File inputFile, Exception e) throws Exception {
        String message = e.getMessage();
        Assumptions.assumeFalse((message != null && (message.equals("The document is really a RTF file") || message.equals("The document is really a PDF file") || message.equals("The document is really a HTML file")) ? 1 : 0) != 0, (String)("File " + this.file + " excluded because it is actually a PDF/RTF/HTML file"));
        if (message != null && message.equals("The document is really a XLS file")) {
            this.handler = TestAllFiles.HANDLERS.get(".xls");
        } else if (message != null && message.equals("The document is really a PPT file")) {
            this.handler = TestAllFiles.HANDLERS.get(".ppt");
        } else if (message != null && message.equals("The document is really a DOC file")) {
            this.handler = TestAllFiles.HANDLERS.get(".doc");
        } else if (message != null && message.equals("The document is really a VSD file")) {
            this.handler = TestAllFiles.HANDLERS.get(".vsd");
        } else if (this.handler instanceof HWPFFileHandler) {
            this.handler = TestAllFiles.HANDLERS.get(".docx");
        } else if (this.handler instanceof HSSFFileHandler) {
            this.handler = TestAllFiles.HANDLERS.get(".xlsx");
        } else if (this.handler instanceof HSLFFileHandler) {
            this.handler = TestAllFiles.HANDLERS.get(".pptx");
        } else if (this.handler instanceof XWPFFileHandler) {
            this.handler = TestAllFiles.HANDLERS.get(".doc");
        } else if (this.handler instanceof XSSFFileHandler) {
            this.handler = TestAllFiles.HANDLERS.get(".xls");
        } else if (this.handler instanceof XSLFFileHandler) {
            this.handler = TestAllFiles.HANDLERS.get(".ppt");
        } else {
            throw e;
        }
        this.handleFile(inputFile);
    }

    private void handleFile(File inputFile) throws Exception {
        try (BufferedInputStream newStream = new BufferedInputStream(new FileInputStream(inputFile), 65536);){
            this.handler.handleFile(newStream, inputFile.getAbsolutePath());
        }
    }
}

