function formatTime(date) {
  var year = date.getFullYear()
  var month = date.getMonth() + 1
  var day = date.getDate()

  var hour = date.getHours()
  var minute = date.getMinutes()
  var second = date.getSeconds()


  return [year, month, day].map(formatNumber).join('/') + ' ' + [hour, minute, second].map(formatNumber).join(':')
}

function formatNumber(n) {
  n = n.toString()
  return n[1] ? n : '0' + n
}

var APIHelper = {};
APIHelper.post = function (action, param, callback) {
  var apiUrl = "https://lite001.z01.com/API/wei001/wxapp.ashx?r=" + (new Date()).getTime()+"&action=" + action;
  wx.request({
    url: apiUrl,
    data: param,
    header: {
      'content-type': 'application/x-www-form-urlencoded'
    },
    method: "POST",
    dataType: "json",
    success: function (data) { callback(data); },
    fail: function () { console.log("api 3001"); }
  })
}
//从返回的结果中取出result值,失败则为空并控制台输出报错信息
APIHelper.getResult = function (wxret) {
  var result = { result: "" };
  try {
    if (!wxret) { console.log("api 4001:data is null"); }
    else if (wxret.statusCode != 200) { console.log("api 4002:" + wxret.errMsg); }
    else //微信网络接口返回正常
    {
      var retMod = wxret.data;
      if (!retMod) { console.log("api 5001:return is null"); }
      else if (typeof (retMod) == "string") { console.log("api 5002:" + retMod); }
      else if (retMod.retcode != 1) { console.log("api 5003:" + retMod.retmsg) }
      else {
        if (retMod.result.indexOf("{") == 0 || retMod.result.indexOf("[") == 0) {
          retMod.result = JSON.parse(retMod.result);
        }
        result = retMod;
      }
    }
  } catch (ex) { console.log("api 5004:" + ex.message); }
  return result;
}
//-----------------------------------APIHelper End;
var Convert = {};
Convert.ToInt = function (str, def) {
  if (!def) { def = 0; }
  var r = parseInt(str);
  if ((r + "") == "NaN") { r = def; }
  return r;
}
//num=小数位
Convert.ToDouble = function (str, num, def) {
  if (!def) { def = 0; }
  if (!num) { num = 2; }
  var r = parseFloat(str);
  if ((r + "") == "NaN") { r = def; }
  return parseFloat(r.toFixed(num));
}
//-----------------------------------Convert End;


module.exports = {
  formatTime: formatTime,
  APIHelper: APIHelper,
  Convert: Convert
}
