// pages/product/index.js
var WxParse = require('../../wxParse/wxParse.js');
var bll = require("../../utils/bll");
Page({
  data: {
    product: null,
    index_index_scroll_tmpl: {
      items: [],
      indicatorDots: true,
      vertical: false,
      autoplay: true,
      interval: 3000,
      duration: 1200
    },
  },

  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function (options) {
    var that = this;
    bll.product.get(options.id, function (product) {
      WxParse.wxParse('Procontent', 'html', product.Procontent, that, 5);
      that.setData({ "product": product });
    });
  },
  //只有定义了此事件处理函数，右上角菜单才会显示 “转发” 按钮
  onShareAppMessage: function (options) {
    var that = this;
    return {
      title: that.data.product.Proname,
      path: "/pages/product/index?id=" + that.data.product.ID,
      imageUrl: that.data.product.Clearimg,
      success: function (xhr) { console.log("share success"); }
    }
  },
  cartAdd: function () {
    var cfg = { proid: this.data.product.ID, pronum: 1, op: "+" };
    utils.APIHelper.cartAdd(cfg, function () {
      wx.switchTab({
        url: '/pages/cart/index',
      })
    });
  },//cartAdd end;
  checkOut: function () {
    var that = this;
    bll.payment.checkOut({ money: that.data.product.LinPrice }, function () { });
  }
})