//index.js
//获取应用实例
const app = getApp()
Page({
  data: {
    latitude: 28.682914,
    longitude: 115.944199,
    markers: [{
      iconPath: "/images/if_paul.png",
      id: 0,
      latitude: 28.682914,
      longitude: 115.944199,
      width: 50,
      height: 50,
      callout: {
        content: "南昌市 青山湖区 江大南路 华成嘉园A701",
        color: "#2e6da4", 
        borderRadius:"5px",
        display:"ALWAYS"
      }
    }],
  },
  //事件处理函数
  bindViewTap: function () {
  },
  onReady: function (e) {
    // 使用 wx.createMapContext 获取 map 上下文
    this.mapCtx = wx.createMapContext('map')
  },
  onLoad: function () {

  },
  getCenterLocation: function () {
    this.mapCtx.getCenterLocation({
      success: function (res) {
        console.log(res.longitude)
        console.log(res.latitude)
      }
    })
  },
  moveToLocation: function () {
    this.mapCtx.moveToLocation()
  },
  translateMarker: function () {
    this.mapCtx.translateMarker({
      markerId: 0,
      autoRotate: true,
      duration: 1000,
      destination: {
        latitude: 115.94383,
        longitude: 28.688435,
      },
      //
      animationEnd() {
        console.log('animation end')
      }
    })
  },
  includePoints: function () {
    this.mapCtx.includePoints({
      padding: [10],
      points: [{
        latitude: 23.10229,
        longitude: 113.3345211,
      }, {
        latitude: 23.00229,
        longitude: 113.3345211,
      }]
    })
  }
})
