/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.io.ByteStreams;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

@Beta
@GwtIncompatible
public final class LittleEndianDataInputStream
extends FilterInputStream
implements DataInput {
    public LittleEndianDataInputStream(InputStream in2) {
        super(Preconditions.checkNotNull(in2));
    }

    @Override
    @CanIgnoreReturnValue
    public String readLine() {
        throw new UnsupportedOperationException("readLine is not supported");
    }

    @Override
    public void readFully(byte[] b11) throws IOException {
        ByteStreams.readFully(this, b11);
    }

    @Override
    public void readFully(byte[] b11, int off, int len) throws IOException {
        ByteStreams.readFully(this, b11, off, len);
    }

    @Override
    public int skipBytes(int n11) throws IOException {
        return (int)this.in.skip(n11);
    }

    @Override
    @CanIgnoreReturnValue
    public int readUnsignedByte() throws IOException {
        int b12 = this.in.read();
        if (0 > b12) {
            throw new EOFException();
        }
        return b12;
    }

    @Override
    @CanIgnoreReturnValue
    public int readUnsignedShort() throws IOException {
        byte b12 = this.readAndCheckByte();
        byte b22 = this.readAndCheckByte();
        return Ints.fromBytes((byte)0, (byte)0, b22, b12);
    }

    @Override
    @CanIgnoreReturnValue
    public int readInt() throws IOException {
        byte b12 = this.readAndCheckByte();
        byte b22 = this.readAndCheckByte();
        byte b32 = this.readAndCheckByte();
        byte b42 = this.readAndCheckByte();
        return Ints.fromBytes(b42, b32, b22, b12);
    }

    @Override
    @CanIgnoreReturnValue
    public long readLong() throws IOException {
        byte b12 = this.readAndCheckByte();
        byte b22 = this.readAndCheckByte();
        byte b32 = this.readAndCheckByte();
        byte b42 = this.readAndCheckByte();
        byte b52 = this.readAndCheckByte();
        byte b62 = this.readAndCheckByte();
        byte b72 = this.readAndCheckByte();
        byte b82 = this.readAndCheckByte();
        return Longs.fromBytes(b82, b72, b62, b52, b42, b32, b22, b12);
    }

    @Override
    @CanIgnoreReturnValue
    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    @CanIgnoreReturnValue
    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    @CanIgnoreReturnValue
    public String readUTF() throws IOException {
        return new DataInputStream(this.in).readUTF();
    }

    @Override
    @CanIgnoreReturnValue
    public short readShort() throws IOException {
        return (short)this.readUnsignedShort();
    }

    @Override
    @CanIgnoreReturnValue
    public char readChar() throws IOException {
        return (char)this.readUnsignedShort();
    }

    @Override
    @CanIgnoreReturnValue
    public byte readByte() throws IOException {
        return (byte)this.readUnsignedByte();
    }

    @Override
    @CanIgnoreReturnValue
    public boolean readBoolean() throws IOException {
        return this.readUnsignedByte() != 0;
    }

    private byte readAndCheckByte() throws IOException, EOFException {
        int b12 = this.in.read();
        if (-1 == b12) {
            throw new EOFException();
        }
        return (byte)b12;
    }
}

